/*
 *      Web server handler routines for Routing stuffs
 *
 */


/*-- System inlcude files --*/
#include <string.h>
#include <sys/ioctl.h>
#include <sys/time.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <sys/socket.h>
#include <linux/if.h>
#include <net/route.h>

/*-- Local inlcude files --*/
#include "../webs.h"
#include "webform.h"
#include "mib.h"
#include "utility.h"
#include "../../port.h"
#include "utf8_string.h"
#ifdef CONFIG_CU_BASEON_CMCC
#include "fmdefs.h"
#endif

#include "subr_net.h"

///////////////////////////////////////////////////////////////////
void formRoute(request * wp, char *path, char *query)
{
	char	*str, *submitUrl;
	char tmpBuf[100];
	//struct rtentry rt;
	struct in_addr *addr;
	MIB_CE_IP_ROUTE_T entry;
	int xflag, isnet;
	int skfd;
	int intVal;
	//char ifname[16];
#ifndef NO_ACTION
	int pid;
#endif

	memset( &entry, 0, sizeof(MIB_CE_IP_ROUTE_T));

#ifdef DEFAULT_GATEWAY_V2
	// Jenny, Default Gateway setting
	str = boaGetVar(wp, "dgwSet", "");
	if (str[0]) {
		unsigned int dgw;

		str = boaGetVar(wp, "droute", "");
		dgw = (unsigned int)atoi(str);
		if (!mib_set(MIB_ADSL_WAN_DGW_ITF, (void *)&dgw)) {
			strcpy(tmpBuf, "Set Default Gateway error!");
			goto setErr_route;
		}
		goto setOk_route;
	}
#endif

	// Delete
#ifdef CONFIG_CMCC_ENTERPRISE
	str = boaGetVar(wp, "delV4Routename", "");
#else
	str = boaGetVar(wp, "delRoute", "");
#endif
	if (str[0]) {
		unsigned int i;
		unsigned int idx;
		MIB_CE_IP_ROUTE_T Entry;
		unsigned int totalEntry = mib_chain_total(MIB_IP_ROUTE_TBL); /* get chain record size */
		str = boaGetVar(wp, "select", "");

		if (str[0]) {
			for (i=0; i<totalEntry; i++) {
				idx = totalEntry-i-1;
				snprintf(tmpBuf, 4, "s%d", idx);

				if ( !gstrcmp(str, tmpBuf) ) {
					//struct sockaddr_in *s_in;
					/* get the specified chain record */
					if (!mib_chain_get(MIB_IP_ROUTE_TBL, idx, (void *)&Entry)) {
						strcpy(tmpBuf, errGetEntry);
						goto setErr_route;
					}

					//This API will update mib entry, so it has to be called before delete mib entry.
					if(route_cfg_modify(&Entry, 1, idx)) {
						printf("%s %d Delete static route error!\n", __func__, __LINE__);
					}
					
					// delete from chain record
					if(mib_chain_delete(MIB_IP_ROUTE_TBL, idx) != 1) {
						strcpy(tmpBuf, "删除失败!"); //Delete chain record error!
						goto setErr_route;
					}

					syslog(LOG_INFO, "StaticRoute: Delete Entry");

					goto setOk_route;
				}
			} // end of for
		}
		else {
			strcpy(tmpBuf, "没有选择删除的项目!"); //There is no item selected to delete!
			goto setErr_route;
		}

		goto setOk_route;
	}

	// parse input
	str = boaGetVar(wp, "destNet", "");
	if (!inet_aton(str, (struct in_addr *)&entry.destID)) {
		snprintf(tmpBuf, 100, "错误: 无法解析目的 %s", str); //Error: can't resolve dest
		goto setErr_route;
	}

	str = boaGetVar(wp, "subMask", "");
	if (str[0]) {
		if (!isValidNetmask(str, 1)) {
			snprintf(tmpBuf, 100, "错误: 不合法的子网遮罩 %s", str); //Error: Invalid subnet mask
			goto setErr_route;
		}
		if (!inet_aton(str, (struct in_addr *)&entry.netMask)) {
			snprintf(tmpBuf, 100, "错误: 无法解析遮罩 %s", str); //Error: can't resolve mask 
			goto setErr_route;
		}
	}

#if defined(CONFIG_CMCC) || defined(CONFIG_CU)
	entry.FWMetric = 0;

	entry.ifIndex = DUMMY_IFINDEX;
	str = boaGetVar(wp, "intfEnable", "0");
	entry.intfEnable = 0;
	if(atoi(str)==1){
		entry.intfEnable = 1;
		str = boaGetVar(wp, "interface", "");
		if ( str ) {
			if (!string_to_dec(str, &intVal)) {
				snprintf(tmpBuf, 100, "错误: ifname 错误 %s", str); //Error: ifname error
				goto setErr_route;
			}
			entry.ifIndex = intVal;
		}
	}

#if defined(CONFIG_CMCC) || defined(CONFIG_CU)
	str = boaGetVar(wp, "nextHopEnable", "0");
	entry.nextHopEnable = 0;
	if(atoi(str)==1){
		entry.nextHopEnable = 1;
#endif
		str = boaGetVar(wp, "nextHop", "");
		if (!str && (entry.ifIndex == DUMMY_IFINDEX)) {
			snprintf(tmpBuf, 100, "错误: 无法解析下一跳点 %s", str); //Error: can't resolve next tHop
			goto setErr_route;
		} else if (str[0]) {
			if (!inet_aton(str, (struct in_addr *)&entry.nextHop)) {
				snprintf(tmpBuf, 100, "错误: 无法解析下一跳点 %s", str); //Error: can't resolve next tHop
				goto setErr_route;
			}
		}
#if defined(CONFIG_CMCC) || defined(CONFIG_CU)
	}
#endif
	
	entry.Enable = 1;
#else
	str = boaGetVar(wp, "metric", "");
	if ( str[0] ) {
		if (!string_to_dec(str, &intVal)) {
			snprintf(tmpBuf, 100, "错误: Metric"); //Error: Metric
			goto setErr_route;
		}

		if ((intVal < 0) || (intVal > 16)) {
			snprintf(tmpBuf, 100, "错误: Metric 需在 0 to 16"); //Error: Metric must be 0 to 16
			goto setErr_route;
		}
		entry.FWMetric = intVal;
	}
	
	entry.ifIndex = DUMMY_IFINDEX;
	str = boaGetVar(wp, "interface", "");
	if ( str ) {
		if (!string_to_dec(str, &intVal)) {
			snprintf(tmpBuf, 100, "错误: ifname 错误 %s", str); //Error: ifname error
			goto setErr_route;
		}
		entry.ifIndex = intVal;
	}

	str = boaGetVar(wp, "nextHop", "");
	if (!str && (entry.ifIndex == DUMMY_IFINDEX)) {
		snprintf(tmpBuf, 100, "错误: 无法解析下一跳点 %s", str); //Error: can't resolve next tHop
		goto setErr_route;
	} else if (str[0]) {
		if (!inet_aton(str, (struct in_addr *)&entry.nextHop)) {
			snprintf(tmpBuf, 100, "错误: 无法解析下一跳点 %s", str); //Error: can't resolve next tHop
			goto setErr_route;
		}
	}

	str = boaGetVar(wp, "enable", "");
	if ( str && str[0] ) {
		entry.Enable = 1;
	}
#endif

#ifdef SUPPORT_SET_WANTYPE_FOR_STATIC_ROUTE	
	int ifindex = -1;
	str = boaGetVar(wp, "wanTypeEnable", "0");
	entry.itfTypeEnable = 0;
	entry.intfEnable = 0;
	strcpy(entry.itfType, "");
	if(atoi(str)==1){
		str = boaGetVar(wp, "itfType", "");
		{
			if ( str ) {
				entry.itfTypeEnable = 1;
				entry.intfEnable = 0;
				strcpy(entry.itfType, str);
			}
		}
	}
#endif

	// Update
	str = boaGetVar(wp, "updateRoute", "");
	if (str && str[0]) {
		char *select, strBuf[8];
		int i, idx;
		MIB_CE_IP_ROUTE_T tmp;
		unsigned int totalEntry = mib_chain_total(MIB_IP_ROUTE_TBL); /* get chain record size */

		select = boaGetVar(wp, "select", "");
		if (!select )
			goto setOk_route;

		for (i=0; i<totalEntry; i++) {
			idx = totalEntry-i-1;
			snprintf(strBuf, 4, "s%d", idx);

			if (!gstrcmp(select, strBuf)) {
				if (mib_chain_get(MIB_IP_ROUTE_TBL, idx, (void *)&tmp)) {
					
					if(route_cfg_modify(&tmp, 1, idx)) { // delete original route
						printf("%s %d Delete static route error!\n", __func__, __LINE__);
					}
					entry.InstanceNum = tmp.InstanceNum; /*keep old instancenum, jiunming*/
				}

				if (!checkRoute(entry, idx)) {	// Jenny
					if(route_cfg_modify(&tmp, 0, idx)) {
						printf("%s %d Add static route error!\n", __func__, __LINE__);
					}
					strcpy(tmpBuf, Tinvalid_rule);
					goto setErr_route;
				}

				if(route_cfg_modify(&entry, 0, idx)) { // add new route
					printf("%s %d Add static route error!\n", __func__, __LINE__);
				}
				mib_chain_update(MIB_IP_ROUTE_TBL, &entry, idx);

				syslog(LOG_INFO, "StaticRoute: Update Entry");

				goto setOk_route;
			}
		} // end of for

		goto setOk_route;
	}

	// Add
#ifdef CONFIG_CMCC_ENTERPRISE
	str = boaGetVar(wp, "addV4Routename", "");
#else
	str = boaGetVar(wp, "addRoute", "");
#endif
	if (str && str[0]) {
		int totalEntry = 0;
		if (!checkRoute(entry, -1)) {	// Jenny
			strcpy(tmpBuf, Tinvalid_rule);
			goto setErr_route;
		}
		printf("add route\n");

		/* get chain record size */
		totalEntry = mib_chain_total(MIB_IP_ROUTE_TBL); 

		if(route_cfg_modify(&entry, 0, totalEntry-1)) {
			printf("%s %d Add static route error!\n", __func__, __LINE__);
		}
		else{
	                intVal = mib_chain_add(MIB_IP_ROUTE_TBL, (unsigned char*)&entry);
        	        if (intVal == 0) {
                	        strcpy(tmpBuf, Tadd_chain_error);
                        	goto setErr_route;
                	}
                	else if (intVal == -1) {
                        	strcpy(tmpBuf, strTableFull);
                        	goto setErr_route;
               		}
		}

		syslog(LOG_INFO, "StaticRoute: Add Entry");
	}

setOk_route:
// Magician: Commit immediately
#ifdef COMMIT_IMMEDIATELY
	Commit();
#endif

#ifndef NO_ACTION
	pid = fork();
	if (pid)
		waitpid(pid, NULL, 0);
	else if (pid == 0) {
		snprintf(tmpBuf, 100, "%s/%s", _CONFIG_SCRIPT_PATH, _CONFIG_SCRIPT_PROG);
#ifdef HOME_GATEWAY
		execl( tmpBuf, _CONFIG_SCRIPT_PROG, "gw", "bridge", NULL);
#else
		execl( tmpBuf, _CONFIG_SCRIPT_PROG, "ap", "bridge", NULL);
#endif
		exit(1);
	}
#endif

	submitUrl = boaGetVar(wp, "submit-url", "");
	if (submitUrl[0])
		boaRedirect(wp, submitUrl);
	else
		boaDone(wp, 200);
  	return;

setErr_route:
	ERR_MSG(tmpBuf);
}
int GetDefaultGateway(int eid, request * wp, int argc, char **argv)
{
#ifdef DEFAULT_GATEWAY_V2
	unsigned int dgw;
	mib_get_s(MIB_ADSL_WAN_DGW_ITF, (void *)&dgw, sizeof(dgw));
	//boaWrite(wp, "<script>\n"
	//				"	document.route.droute.value = %u;\n"
	//				"</script>", dgw);
#ifdef AUTO_PPPOE_ROUTE
	if (dgw == DGW_AUTO)
		boaWrite(wp, "	document.forms[0].droute[0].checked = true;\n");
	else
#endif
		boaWrite(wp, "	document.forms[0].droute[1].checked = true;\n");
#endif
	return 0;
}

#ifdef CONFIG_IPV6
void formIPv6Route(request * wp, char *path, char *query)
{
	char	*str, *submitUrl;
	char tmpBuf[100];
	//struct rtentry rt;
	struct in_addr *addr;
	MIB_CE_IPV6_ROUTE_T entry;
	int xflag, isnet, ret;
	int skfd;
	int intVal;
	unsigned int totalEntry;
	//char ifname[16];
#ifndef NO_ACTION
	int pid;
#endif
	if (wp->method == M_GET)
	{
		strcpy(tmpBuf, "Reject the GET request!\n");
		goto setErr_route;
	}

	memset( &entry, 0, sizeof(MIB_CE_IPV6_ROUTE_T));

	// Delete
#ifdef CONFIG_CMCC_ENTERPRISE
	str = boaGetVar(wp, "delV6RouteName", "");
#else
	str = boaGetVar(wp, "delV6Route", "");
#endif
	if (str[0]) {
		unsigned int i;
		unsigned int idx;
		MIB_CE_IPV6_ROUTE_T Entry;
		unsigned int totalEntry = mib_chain_total(MIB_IPV6_ROUTE_TBL); /* get chain record size */
		str = boaGetVar(wp, "select", "");

		if (str[0]) {
			for (i=0; i<totalEntry; i++) {
				idx = totalEntry-i-1;
				snprintf(tmpBuf, 4, "s%d", idx);

				if ( !gstrcmp(str, tmpBuf) ) {
					//struct sockaddr_in *s_in;
					/* get the specified chain record */
					if (!mib_chain_get(MIB_IPV6_ROUTE_TBL, idx, (void *)&Entry)) {
						strcpy(tmpBuf, errGetEntry);
						goto setErr_route;
					}

					if(route_v6_cfg_modify(&Entry, 1)) {
						printf("%s %d Delete v6 static route error!\n", __func__, __LINE__);
					}

					// delete from chain record
					if(mib_chain_delete(MIB_IPV6_ROUTE_TBL, idx) != 1) {
						strcpy(tmpBuf, "删除失败!");
						goto setErr_route;
					}

					syslog(LOG_INFO, "StaticV6Route: Delete Entry");

					goto setOk_route;
				}
			} // end of for
		}
		else {
			strcpy(tmpBuf, "没有选择删除的项目!");
			goto setErr_route;
		}

		goto setOk_route;
	}

	// parse input
	str = boaGetVar(wp, "destNet", "");
	if (str[0]){
		//strcpy(entry.Dstination,str);
		entry.Dstination[sizeof(entry.Dstination)-1]='\0';
		strncpy(entry.Dstination, str, sizeof(entry.Dstination)-1);
	}

	str = boaGetVar(wp, "metric", "");
	if ( str[0] ) {
		if (!string_to_dec(str, &intVal)) {
			snprintf(tmpBuf, 100, "错误: Metric ");
			goto setErr_route;
		}

		if ((intVal < 0) || (intVal > 16)) {
			snprintf(tmpBuf, 100, "错误: Metric 需在 0 to 16");
			goto setErr_route;
		}
		entry.FWMetric = intVal;
	}

	entry.DstIfIndex = DUMMY_IFINDEX;

#if defined(CONFIG_CMCC) || defined(CONFIG_CU)
	str = boaGetVar(wp, "intfEnable", "0");
	entry.intfEnable = atoi(str);
	printf("intfEnable is %d\n", entry.intfEnable);

	if(entry.intfEnable)
#endif
	{
		str = boaGetVar(wp, "interface", "");
		if ( str ) {
			if (!string_to_dec(str, &intVal)) {
				snprintf(tmpBuf, 100, "错误: ifname 错误 %s", str); //Error: ifname error
				goto setErr_route;
			}
			entry.DstIfIndex = intVal;
		}
	}

#if defined(CONFIG_CMCC) || defined(CONFIG_CU)
	str = boaGetVar(wp, "nextHopEnable", "0");
	entry.nextHopEnable = atoi(str);
	printf("nextHopEnable is %d\n", entry.nextHopEnable);
#endif

	str = boaGetVar(wp, "nextHop", "");
	//nextHop = ntohl(inet_addr(str));	// Jenny, for checking duplicated destination address
	if (!str && (entry.DstIfIndex == DUMMY_IFINDEX)) {
		snprintf(tmpBuf, 100, "错误: 无法解析下一跳点 %s", str);
		goto setErr_route;
	} else if (str[0]) {
		struct in6_addr tmp;
		//strcpy(entry.NextHop, str);
		entry.NextHop[sizeof(entry.NextHop)-1]='\0';
		strncpy(entry.NextHop, str, sizeof(entry.NextHop)-1);
		if (!inet_pton(AF_INET6, str, (struct in6_addr *)&tmp)) {
			snprintf(tmpBuf, 100, "错误: 无法解析下一跳点 %s", str);
			goto setErr_route;
		}
	}

	str = boaGetVar(wp, "enable", "");
	if ( str && str[0] ) {
		entry.Enable = 1;
	}

	str = boaGetVar(wp, "prefixLen", "");
	if ( str && str[0] ) {
		strcat(entry.Dstination, "/");
		//strcat(entry.Dstination, str);
		strncat(entry.Dstination, str, sizeof(entry.Dstination)-strlen(entry.Dstination)-1);
	}

	// Update
	str = boaGetVar(wp, "updateV6Route", "");
	if (str && str[0]) {
		//char *select, tmpBuf[8];
		char *select, strBuf[8];
		int i, idx;
		MIB_CE_IPV6_ROUTE_T tmp;
		totalEntry = mib_chain_total(MIB_IPV6_ROUTE_TBL); /* get chain record size */

		select = boaGetVar(wp, "select", "");
		if (!select )
			goto setOk_route;

		for (i=0; i<totalEntry; i++) {
			idx = totalEntry-i-1;
			snprintf(strBuf, 4, "s%d", idx);

			if (!gstrcmp(select, strBuf)) {
				//check if duplicate
				if (!checkIPv6Route(&entry)) {	// Jenny
					strcpy(tmpBuf, "这个路由已存在于MIB!");
					goto setErr_route;
				}
				else{
					if (mib_chain_get(MIB_IPV6_ROUTE_TBL, idx, (void *)&tmp)) {
						//Del old route
						if(route_v6_cfg_modify(&tmp, 1)) {
							printf("%s %d Delete ipv6 static route error!\n", __func__, __LINE__);
						}
						entry.InstanceNum = tmp.InstanceNum; /*keep old instancenum, jiunming*/
					}

					if(route_v6_cfg_modify(&entry, 0)) { // add new route
						printf("%s %d update static route error!\n", __func__, __LINE__);
					}

					mib_chain_update(MIB_IPV6_ROUTE_TBL, &entry, idx);

					syslog(LOG_INFO, "StaticV6Route: Update Entry");

					goto setOk_route;
				}
			}
		} // end of for

		goto setOk_route;
	}

	// Add
#ifdef CONFIG_CMCC_ENTERPRISE
	str = boaGetVar(wp, "addV6RouteName", "");
#else
	str = boaGetVar(wp, "addV6Route", "");
#endif
	if (str && str[0]) {
		intVal = checkIPv6Route(&entry);
		if (intVal == 0) {
			strcpy(tmpBuf, "这个路由已存在于MIB!");
			goto setErr_route;
		}

		intVal = mib_chain_add(MIB_IPV6_ROUTE_TBL, (unsigned char*)&entry);
		if (intVal == 0) {
			//strcpy(tmpBuf, Tadd_chain_error);
			snprintf(tmpBuf, sizeof(tmpBuf), "%s", Tadd_chain_error);
			goto setErr_route;
		}
		else if (intVal == -1) {
			//strcpy(tmpBuf, strTableFull);
			snprintf(tmpBuf, sizeof(tmpBuf), "%s", strTableFull);
			goto setErr_route;
		}
		
		totalEntry = mib_chain_total(MIB_IPV6_ROUTE_TBL); 
		if(route_v6_cfg_modify(&entry, 0)==-1){
			printf("%s %d Add ipv6 static route error!\n", __func__, __LINE__);
			strcpy(tmpBuf, "错误: 无法新增路由");
			mib_chain_delete(MIB_IPV6_ROUTE_TBL, totalEntry-1);
			goto setErr_route;
		}

		syslog(LOG_INFO, "StaticV6Route: Add Entry");
	}

setOk_route:
// Magician: Commit immediately
#ifdef COMMIT_IMMEDIATELY
	Commit();
#endif

#ifndef NO_ACTION
	pid = fork();
	if (pid)
		waitpid(pid, NULL, 0);
	else if (pid == 0) {
		snprintf(tmpBuf, 100, "%s/%s", _CONFIG_SCRIPT_PATH, _CONFIG_SCRIPT_PROG);
#ifdef HOME_GATEWAY
		execl( tmpBuf, _CONFIG_SCRIPT_PROG, "gw", "bridge", NULL);
#else
		execl( tmpBuf, _CONFIG_SCRIPT_PROG, "ap", "bridge", NULL);
#endif
		exit(1);
	}
#endif

	submitUrl = boaGetVar(wp, "submit-url", "");
	if (submitUrl[0])
		boaRedirect(wp, submitUrl);
	else
		boaDone(wp, 200);
  	return;

setErr_route:
	ERR_MSG(tmpBuf);
}
#endif

#ifdef CONFIG_USER_QUAGGA_RIPNGD
void formRipng(request * wp, char *path, char *query)
{
	char *str, *submitUrl, *strVal;
	char tmpBuf[100];
	unsigned int ripng_if;
	unsigned char ripngEnable;
	unsigned int entryNum, i;
	MIB_CE_RIPNG_T Entry,delEntry;
	int actionValue = 0;
	char actionifname[IFNAMSIZ];
#ifndef NO_ACTION
	int pid;
#endif

//start: delete the ip6tables rules about ripng
	entryNum = mib_chain_total(MIB_RIPNG_TBL);
	for (i=0; i<entryNum; i++) 
	{
		mib_chain_get(MIB_RIPNG_TBL, i, (void *)&Entry);
		if( Entry.ifIndexV6== DUMMY_IFINDEX) 
		{
			strncpy(actionifname, "br0", strlen("br0"));
			actionifname[strlen("br0")] = '\0';
		} else {
			ifGetName(Entry.ifIndexV6, actionifname, sizeof(actionifname));
		}
		va_cmd(IP6TABLES, 10, 1, "-D", "INPUT", "-i",actionifname, "-p","udp", "--dport", "521", "-j", "ACCEPT");
	}
//end
	
	// RIPNG Add
#ifdef CONFIG_CMCC_ENTERPRISE
	str = boaGetVar(wp, "ripngAddName", "");
#else
	str = boaGetVar(wp, "ripngAdd", "");
#endif
	if (str[0]) 
	{
		int intVal;
		str = boaGetVar(wp, "ripng_if", "");
		ripng_if = (unsigned int)atoi(str);

		// Check RIPNG table
		entryNum = mib_chain_total(MIB_RIPNG_TBL);
		for (i=0; i<entryNum; i++) 
		{
			mib_chain_get(MIB_RIPNG_TBL, i, (void *)&Entry);
			if (Entry.ifIndexV6 == ripng_if) 
			{
				strcpy(tmpBuf, "Entry already exists!");
				goto setErr_ripng;
			}
		}

		memset(&Entry, '\0', sizeof(MIB_CE_RIPNG_T));
		Entry.ifIndexV6 = ripng_if;
		str = boaGetVar(wp, "ripngmode", "");
		if ( str[0]=='5' ) 
		{
			Entry.receiveModeV6 = 5;	 // ripng
			Entry.sendModeV6 = 5;	
		} else {
			strcpy(tmpBuf, "设定RIPNG接收模式失败!"); //Set RIPNG receive and send mode error!
			goto setErr_ripng;
		}
		
		intVal = mib_chain_add(MIB_RIPNG_TBL, (unsigned char*)&Entry); //update ripng_table
		
		if (intVal == 0) 
		{
			strcpy(tmpBuf, "错误: 加入MIB_RIPNG_TBL chain record失败"); 
			goto setErr_ripng;
		}
		else if (intVal == -1) 
		{
			strcpy(tmpBuf, strTableFull);
			goto setErr_ripng;
		}
		goto setRefresh_ripng;
	}

	/* Delete selected */
	str = boaGetVar(wp, "ripngDel", "");
	if (str[0]) 
	{
		unsigned int i;
		unsigned int idx;
		unsigned int deleted = 0;
		unsigned int totalEntry = mib_chain_total(MIB_RIPNG_TBL); /* get chain record size */

		idx = str[0] - '0';
		if(idx < 0 || idx > totalEntry)
		{
			strcpy(tmpBuf, "没有选择删除的项目!"); //There is no item selected to delete!
			goto setErr_ripng;
		}

		if(mib_chain_delete(MIB_RIPNG_TBL, idx) != 1) 
		{
			strcpy(tmpBuf, "错误: 删除MIB_RIPNG_TBL chain record失败!"); //Delete MIB_RIPNG_TBL chain record error!
			goto setErr_ripng;
		}
		goto setRefresh_ripng;
	}
	// RIPNG setting
	str = boaGetVar(wp, "ripngSet", "");
	if (str[0]) 
	{
		unsigned char ripngVal;

		str = boaGetVar(wp, "ripng_on", "");
		if (str[0] == '1')
			ripngVal = 1;
		else
			ripngVal = 0; // default "off"
		if (!mib_set(MIB_RIPNG_ENABLE, (void *)&ripngVal)) 
		{
			strcpy(tmpBuf, "Set RIPNG error!");
			goto setErr_ripng;
		}
	}

setOk_ripng:
	startRipng();

// Magician: Commit immediately
#ifdef COMMIT_IMMEDIATELY
	Commit();
#endif

#ifndef NO_ACTION
	pid = fork();
	if (pid)
		waitpid(pid, NULL, 0);
	else if (pid == 0) {
		snprintf(tmpBuf, 100, "%s/%s", _CONFIG_SCRIPT_PATH, _CONFIG_SCRIPT_PROG);
#ifdef HOME_GATEWAY
		execl( tmpBuf, _CONFIG_SCRIPT_PROG, "gw", "bridge", NULL);
#else
		execl( tmpBuf, _CONFIG_SCRIPT_PROG, "ap", "bridge", NULL);
#endif
		exit(1);
	}
#endif

	//start: add the ip6tables rules about ripng. Don't add any rules for ripng, if ripng is disable
	mib_get(MIB_RIPNG_ENABLE, (void *)&ripngEnable);
	if(ripngEnable == 1)
	{
		entryNum = mib_chain_total(MIB_RIPNG_TBL);
		for (i=0; i<entryNum; i++) 
		{
			mib_chain_get(MIB_RIPNG_TBL, i, (void *)&Entry);
			if( Entry.ifIndexV6== DUMMY_IFINDEX) 
			{
				strncpy(actionifname, "br0", strlen("br0"));
				actionifname[strlen("br0")] = '\0';
			} else {
				ifGetName(Entry.ifIndexV6, actionifname, sizeof(actionifname));
			}
			va_cmd(IP6TABLES, 10, 1, "-I", "INPUT", "-i",actionifname, "-p","udp", "--dport", "521", "-j", "ACCEPT");
		}
	}
	//end
	
	submitUrl = boaGetVar(wp, "submit-url", "");
	//OK_MSG(submitUrl);
	if (submitUrl[0])
		boaRedirect(wp, submitUrl);
	else
		boaDone(wp, 200);
	return;

setRefresh_ripng:
	startRipng();

// Magician: Commit immediately
#ifdef COMMIT_IMMEDIATELY
	Commit();
#endif

//start: add the ip6tables rules about ripng. Don't add any rules for ripng, if ripng is disable
	mib_get(MIB_RIPNG_ENABLE, (void *)&ripngEnable);
	if(ripngEnable == 1)
	{
		entryNum = mib_chain_total(MIB_RIPNG_TBL);
		for (i=0; i<entryNum; i++) 
		{
			mib_chain_get(MIB_RIPNG_TBL, i, (void *)&Entry);
			if( Entry.ifIndexV6== DUMMY_IFINDEX) 
			{
				strncpy(actionifname, "br0", strlen("br0"));
				actionifname[strlen("br0")] = '\0';
			} else {
				ifGetName(Entry.ifIndexV6, actionifname, sizeof(actionifname));
			}
			va_cmd(IP6TABLES, 10, 1, "-I", "INPUT", "-i",actionifname, "-p","udp", "--dport", "521", "-j", "ACCEPT");
		}
	}
//end

	submitUrl = boaGetVar(wp, "submit-url", "");
	if (submitUrl[0])
		boaRedirect(wp, submitUrl);
	else
		boaDone(wp, 200);
	return;
	
setErr_ripng:
	ERR_MSG(tmpBuf);

}

#endif


#if defined(CONFIG_USER_ROUTED_ROUTED) && !defined(CONFIG_USER_ZEBRA_OSPFD_OSPFD)
void formRip(request * wp, char *path, char *query)
{
	char	*str, *submitUrl, *strVal;
	char tmpBuf[100];
	unsigned int rip_if;
	unsigned int entryNum, i;
	MIB_CE_RIP_T Entry;
#ifndef NO_ACTION
	int pid;
#endif

	// RIP Add
#ifdef CONFIG_CMCC_ENTERPRISE
	str = boaGetVar(wp, "ripAddName", "");
#else
	str = boaGetVar(wp, "ripAdd", "");
#endif
	if (str[0]) {
		int intVal;
		str = boaGetVar(wp, "rip_if", "");
		rip_if = (unsigned int)atoi(str);

		// Check RIP table
		entryNum = mib_chain_total(MIB_RIP_TBL);
		for (i=0; i<entryNum; i++) {
			mib_chain_get(MIB_RIP_TBL, i, (void *)&Entry);
			if (Entry.ifIndex == rip_if) {
				strcpy(tmpBuf, "Entry already exists!");
				goto setErr_rip;
			}
		}

		memset(&Entry, '\0', sizeof(MIB_CE_RIP_T));
		Entry.enable = 1;
		Entry.ifIndex = rip_if;
		str = boaGetVar(wp, "receive_mode", "");
		if ( str[0]=='0' ) {
			Entry.receiveMode = RIP_NONE;    // None
		} else if ( str[0]=='1') {
			Entry.receiveMode = RIP_V1;      // RIPV1
		} else if ( str[0]=='2') {
			Entry.receiveMode = RIP_V2;      // RIPV2
		} else if ( str[0]=='3') {
			Entry.receiveMode = RIP_V1_V2;   // RIPV1 and RIPV2
		} else {
			strcpy(tmpBuf, "设定RIP接收模式失败!"); //Set RIP receive mode error!
			goto setErr_rip;
		}

		str = boaGetVar(wp, "send_mode", "");
		if ( str[0]=='0' ) {
			Entry.sendMode = RIP_NONE;    		// None
		} else if ( str[0]=='1') {
			Entry.sendMode = RIP_V1;      		// RIPV1
		} else if ( str[0]=='2') {
			Entry.sendMode = RIP_V2;      		// RIPV2
		}
#ifdef CONFIG_CMCC_ENTERPRISE
		else if ( str[0]=='3') 
#else
		else if ( str[0]=='4')
#endif
		{
			Entry.sendMode = RIP_V1_COMPAT;      	// RIPV1COMPAT
		} else {
			strcpy(tmpBuf, "设定RIP传送模式失败!"); //Set RIP send mode error!
			goto setErr_rip;
		}

#ifdef	CONFIG_CMCC_ENTERPRISE
		str = boaGetVar(wp, "auth_type", "");
		Entry.authType = atoi(str);

		if (Entry.authType >= 2)
		{
			str = boaGetVar(wp, "key", "");
			snprintf(Entry.key, 32, "%s", str);
		}
#endif

		intVal = mib_chain_add(MIB_RIP_TBL, (unsigned char*)&Entry);
		if (intVal == 0) {
			//boaWrite(wp, "%s", "Error: Add MIB_RIP_TBL chain record.");
			//return;
			strcpy(tmpBuf, "错误: 加入MIB_RIP_TBL chain record失败"); //Error: Add MIB_RIP_TBL chain record.
			goto setErr_rip;
		}
		else if (intVal == -1) {
			//strcpy(tmpBuf, strTableFull);
			snprintf(tmpBuf, sizeof(tmpBuf), "%s", strTableFull);
			goto setErr_rip;
		}
		goto setRefresh_rip;
	}

	// Delete all
	str = boaGetVar(wp, "ripDelAll", "");
	if (str[0]) {
		mib_chain_clear(MIB_RIP_TBL); /* clear chain record */
		goto setRefresh_rip;
	}

	/* Delete selected */
	str = boaGetVar(wp, "ripDel", "");
	if (str[0]) {
		unsigned int i;
		unsigned int idx;
		unsigned int deleted = 0;
		unsigned int totalEntry = mib_chain_total(MIB_RIP_TBL); /* get chain record size */
#ifdef	CONFIG_CMCC_ENTERPRISE
				idx = str[0] - '0';
				if(idx < 0 || idx > totalEntry){
					strcpy(tmpBuf, "没有选择删除的项目!"); //There is no item selected to delete!
					goto setErr_rip;
				}
				if(mib_chain_delete(MIB_RIP_TBL, idx) != 1) {
					strcpy(tmpBuf, "错误: 删除MIB_RIP_TBL chain record失败!"); //Delete MIB_RIP_TBL chain record error!
					goto setErr_rip;
				}
#else
		
				for (i=0; i<totalEntry; i++) {
		
					idx = totalEntry-i-1;
					snprintf(tmpBuf, 20, "select%d", idx);
					strVal = boaGetVar(wp, tmpBuf, "");
		
					if ( !gstrcmp(strVal, "ON") ) {
						deleted ++;
						if(mib_chain_delete(MIB_RIP_TBL, idx) != 1) {
							strcpy(tmpBuf, "错误: 删除MIB_RIP_TBL chain record失败!"); //Delete MIB_RIP_TBL chain record error!
							goto setErr_rip;
						}
					}
				}
				if (deleted <= 0) {
					strcpy(tmpBuf, "没有选择删除的项目!"); //There is no item selected to delete!
					goto setErr_rip;
				}
#endif
		goto setRefresh_rip;
	}
	// RIP setting
	str = boaGetVar(wp, "ripSet", "");
	if (str[0]) {
		unsigned char ripVal;

		str = boaGetVar(wp, "rip_on", "");
		if (str[0] == '1')
			ripVal = 1;
		else
			ripVal = 0;	// default "off"
		if (!mib_set(MIB_RIP_ENABLE, (void *)&ripVal)) {
			strcpy(tmpBuf, "Set RIP error!");
			goto setErr_rip;
		}

		// Commented by Mason Yu
		/*
		str = boaGetVar(wp, "rip_ver", "");
		if (str[0] == '0')
			ripVal = 0;
		else
			ripVal = 1;	// default "v2"
		if (!mib_set(MIB_RIP_VERSION, (void *)&ripVal)) {
			strcpy(tmpBuf, "Set RIP error!");
			goto setErr_rip;
		}
		*/
	}

setOk_rip:
	startRip();

// Magician: Commit immediately
#ifdef COMMIT_IMMEDIATELY
	Commit();
#endif

#ifndef NO_ACTION
	pid = fork();
	if (pid)
		waitpid(pid, NULL, 0);
	else if (pid == 0) {
		snprintf(tmpBuf, 100, "%s/%s", _CONFIG_SCRIPT_PATH, _CONFIG_SCRIPT_PROG);
#ifdef HOME_GATEWAY
		execl( tmpBuf, _CONFIG_SCRIPT_PROG, "gw", "bridge", NULL);
#else
		execl( tmpBuf, _CONFIG_SCRIPT_PROG, "ap", "bridge", NULL);
#endif
		exit(1);
	}
#endif

	submitUrl = boaGetVar(wp, "submit-url", "");
	//OK_MSG(submitUrl);
	if (submitUrl[0])
		boaRedirect(wp, submitUrl);
	else
		boaDone(wp, 200);
	return;

setRefresh_rip:
	startRip();

// Magician: Commit immediately
#ifdef COMMIT_IMMEDIATELY
	Commit();
#endif

	submitUrl = boaGetVar(wp, "submit-url", "");
	if (submitUrl[0])
		boaRedirect(wp, submitUrl);
	else
		boaDone(wp, 200);
	return;

setErr_rip:
	ERR_MSG(tmpBuf);
}
#else
#ifdef CONFIG_USER_ZEBRA_OSPFD_OSPFD
void formRip(request * wp, char *path, char *query)
{
	char	*str, *submitUrl;
	char *strVal;
	char tmpBuf[100];
	unsigned char igpEnable;
#ifndef NO_ACTION
	int pid;
#endif

	//check if it is RIP
	strVal = boaGetVar(wp, "igp", "");
	if (strVal[0] == '0') {//RIP
		// RIP Add
		str = boaGetVar(wp, "ripAdd", "");
		if (str[0]) {
			unsigned int rip_if;
			unsigned int i;
			MIB_CE_RIP_T Entry;
			int intVal;

			memset(&Entry, '\0', sizeof(MIB_CE_RIP_T));

			Entry.enable = 1;
			str = boaGetVar(wp, "rip_if", "");
			rip_if = (unsigned char)atoi(str);
			Entry.ifIndex = rip_if;

			str = boaGetVar(wp, "receive_mode", "");
			if ( str[0]=='0' ) {
				Entry.receiveMode = RIP_NONE;    // None
			} else if ( str[0]=='1') {
				Entry.receiveMode = RIP_V1;      // RIPV1
			} else if ( str[0]=='2') {
				Entry.receiveMode = RIP_V2;      // RIPV2
			} else if ( str[0]=='3') {
				Entry.receiveMode = RIP_V1_V2;   // RIPV1 and RIPV2
			} else {
				strcpy(tmpBuf, "设定RIP接收模式失败!"); //Set RIP receive mode error!
				goto setErr_rip;
			}

			str = boaGetVar(wp, "send_mode", "");
			if ( str[0]=='0' ) {
				Entry.sendMode = RIP_NONE;    		// None
			} else if ( str[0]=='1') {
				Entry.sendMode = RIP_V1;      		// RIPV1
			} else if ( str[0]=='2') {
				Entry.sendMode = RIP_V2;      		// RIPV2
			} else if ( str[0]=='4') {
				Entry.sendMode = RIP_V1_COMPAT;      	// RIPV1COMPAT
			} else {
				strcpy(tmpBuf, "设定RIP传送模式失败!"); //Set RIP send mode error!
				goto setErr_rip;
			}

			intVal = mib_chain_add(MIB_RIP_TBL, (unsigned char*)&Entry);
			if (intVal == 0) {
				//boaWrite(wp, "%s", "Error: Add MIB_RIP_TBL chain record.");
				//return;
				strcpy(tmpBuf, "错误: 加入MIB_RIP_TBL chain record失败"); //Error: Add MIB_RIP_TBL chain record.
				goto setErr_rip;
			}
			else if (intVal == -1) {
				strcpy(tmpBuf, strTableFull);
				goto setErr_rip;
			}
			goto setRefresh_rip;
		}

		// Delete all
		str = boaGetVar(wp, "ripDelAll", "");
		if (str[0]) {
			mib_chain_clear(MIB_RIP_TBL); /* clear chain record */
			goto setRefresh_rip;
		}

		/* Delete selected */
		str = boaGetVar(wp, "ripDel", "");
		if (str[0]) {
			unsigned int i;
			unsigned int idx;
			unsigned int deleted = 0;
			unsigned int totalEntry = mib_chain_total(MIB_RIP_TBL); /* get chain record size */

			for (i=0; i<totalEntry; i++) {

				idx = totalEntry-i-1;
				snprintf(tmpBuf, 20, "select%d", idx);
				strVal = boaGetVar(wp, tmpBuf, "");

				if ( !gstrcmp(strVal, "ON") ) {
					deleted ++;
					if(mib_chain_delete(MIB_RIP_TBL, idx) != 1) {
						strcpy(tmpBuf, "错误: 删除MIB_RIP_TBL chain record失败!"); //Delete MIB_RIP_TBL chain record error!
						goto setErr_rip;
					}
				}
			}
			if (deleted <= 0) {
				strcpy(tmpBuf, "没有选择删除的项目!"); //There is no item selected to delete!
				goto setErr_rip;
			}

			goto setRefresh_rip;
		}
#if 0
		// Delete
		str = boaGetVar(wp, "ripDel", "");
		if (str[0]) {
			unsigned int i;
			unsigned int idx;
			MIB_CE_RIP_T Entry;
			unsigned int totalEntry = mib_chain_total(MIB_RIP_TBL); /* get chain record size */

			str = boaGetVar(wp, "select", "");

			if (str[0]) {
				for (i=0; i<totalEntry; i++) {
					idx = totalEntry-i-1;
					snprintf(tmpBuf, 4, "s%d", idx);

					if ( !gstrcmp(str, tmpBuf) ) {

						// delete from chain record
						if(mib_chain_delete(MIB_RIP_TBL, idx) != 1) {
							strcpy(tmpBuf, "Delete MIB_RIP_TBL chain record error!");
							goto setErr_rip;
						}
					}
				} // end of for
			}
			goto setRefresh_rip;
		}
#endif

		// RIP setting
		str = boaGetVar(wp, "ripSet", "");
		if (str[0]) {
			unsigned char ripVal;

			str = boaGetVar(wp, "rip_on", "");
			if (str[0] == '1')
				ripVal = 1;
			else
				ripVal = 0;	// default "off"
			if (!mib_set(MIB_RIP_ENABLE, (void *)&ripVal)) {
				strcpy(tmpBuf, "Set RIP error!");
				goto setErr_rip;
			}

			// Commented by Mason Yu
			/*
			str = boaGetVar(wp, "rip_ver", "");
			if (str[0] == '0')
				ripVal = 0;
			else
				ripVal = 1;	// default "v2"
			if (!mib_set(MIB_RIP_VERSION, (void *)&ripVal)) {
				strcpy(tmpBuf, "Set RIP error!");
				goto setErr_rip;
			}
			*/
		}

		mib_get_s(MIB_RIP_ENABLE, (void *)&igpEnable, sizeof(igpEnable));
		if (igpEnable == 1) {//if rip enabled, close ospf; else dont change any state.
			igpEnable = 0;
			mib_set(MIB_OSPF_ENABLE, (void *)&igpEnable);
		}
	}
	else if (strVal[0] == '1') {
		//ospf add
		str = boaGetVar(wp, "ripAdd", "");
		if (str[0]) {
			MIB_CE_OSPF_T Entry;
			int intVal;

			str = boaGetVar(wp, "ip", "");
			if (str[0]) {
				if ( !inet_aton(str, (struct in_addr *)&Entry.ipAddr) ) {
					strcpy(tmpBuf, Tinvalid_if_ip);
					goto setErr_rip;
				}
			}
			str = boaGetVar(wp, "mask", "");
			if (str[0]) {
				if (!isValidNetmask(str, 1)) {
					strcpy(tmpBuf, Tinvalid_if_mask);
					goto setErr_rip;
				}
				if ( !inet_aton(str, (struct in_addr *)&Entry.netMask) ) {
					strcpy(tmpBuf, Tinvalid_if_mask);
					goto setErr_rip;
				}
			}
			intVal = mib_chain_add(MIB_OSPF_TBL, (unsigned char*)&Entry);
			if (intVal == 0) {
				//boaWrite(wp, "%s", "Error: Add MIB_OSPF_TBL chain record.");
				//return;
				strcpy(tmpBuf, "错误: 加入 MIB_OSPF_TBL chain record失败"); //Error: Add MIB_OSPF_TBL chain record.
				goto setErr_rip;
			}
			else if (intVal == -1) {
				strcpy(tmpBuf, strTableFull);
				goto setErr_rip;
			}
			goto setRefresh_rip;
		}

		// Delete
		str = boaGetVar(wp, "ripDel", "");
		if (str[0]) {
			unsigned int i;
			unsigned int idx;
			MIB_CE_OSPF_T Entry;
			unsigned int totalEntry = mib_chain_total(MIB_OSPF_TBL); /* get chain record size */

			str = boaGetVar(wp, "select", "");

			if (str[0]) {
				for (i=0; i<totalEntry; i++) {
					idx = totalEntry-i-1;
					snprintf(tmpBuf, 4, "s%d", idx);

					if ( !gstrcmp(str, tmpBuf) ) {

						// delete from chain record
						if(mib_chain_delete(MIB_OSPF_TBL, idx) != 1) {
							strcpy(tmpBuf, "错误: 删除 MIB_OSPF_TBL chain record失败!"); //Delete MIB_OSPF_TBL chain record error!
							goto setErr_rip;
						}
					}
				} // end of for
			}
			goto setRefresh_rip;
		}

		// OSPF setting
		str = boaGetVar(wp, "ripSet", "");
		if (str[0]) {
			unsigned char ripVal;

			str = boaGetVar(wp, "rip_on", "");
			if (str[0] == '1')
				ripVal = 1;
			else
				ripVal = 0;	// default "off"
			if (!mib_set(MIB_OSPF_ENABLE, (void *)&ripVal)) {
				strcpy(tmpBuf, "Set OSPF error!");
				goto setErr_rip;
			}
		}

		mib_get_s(MIB_OSPF_ENABLE, (void *)&igpEnable, sizeof(igpEnable));
#ifdef CONFIG_USER_ROUTED_ROUTED
		if (igpEnable == 1) {//if ospf enabled, close rip; else dont change any state.
			igpEnable = 0;
			mib_set(MIB_RIP_ENABLE, (void *)&igpEnable);
		}
#endif
	}

setRefresh_rip:
#ifdef CONFIG_USER_ROUTED_ROUTED
	startRip();
#endif
	startOspf();

	submitUrl = boaGetVar(wp, "submit-url", "");
	if (submitUrl[0])
		boaRedirect(wp, submitUrl);
	else
		boaDone(wp, 200);
	return;

setErr_rip:
	ERR_MSG(tmpBuf);
}
#endif // of CONFIG_USER_ZEBRA_OSPFD_OSPFD
#endif

#ifdef CONFIG_USER_QUAGGA_RIPNGD
// List all the ripng interface at web page.
// return: number of ripng interface listed.
int showRipngIf(int eid, request * wp, int argc, char **argv)
{
	int nBytesSent=0;
	unsigned int entryNum, i;
	MIB_CE_RIPNG_T Entry;
	char ifname[IFNAMSIZ], receive_mode[16], send_mode[16];
	unsigned char ripngEnable = 2;

	entryNum = mib_chain_total(MIB_RIPNG_TBL);
	nBytesSent += boaWrite(wp, "<tr><font size=1>"
	"<td align=center width=\"20%%\">%s</td>"
	"<td align=center width=\"20%%\">%s</td>"
	"<td align=center width=\"20%%\">%s</td>\n"
	"<td align=center width=\"20%%\">%s</td></font></tr>\n",
	multilang(LANG_INTERFACES), multilang(LANG_VERSION), multilang(LANG_OPERATION_STR), multilang(LANG_ENABLE_DNS));


	for (i=0; i<entryNum; i++) 
	{

		if (!mib_chain_get(MIB_RIPNG_TBL, i, (void *)&Entry))
		{
  			boaError(wp, 400, "Get MIB_RIPNG_TBL chain record 错误!\n");
			return -1;
		}

		if( Entry.ifIndexV6== DUMMY_IFINDEX) 
		{
			strncpy(ifname, "br0", strlen("br0"));
			ifname[strlen("br0")] = '\0';
		} else {
			ifGetName(Entry.ifIndexV6, ifname, sizeof(ifname));
		}
		
		if(Entry.receiveModeV6!= Entry.sendModeV6)
		{
			Entry.sendModeV6= Entry.receiveModeV6;
			mib_chain_update(MIB_RIPNG_TBL, (void *)&Entry, i);
#ifdef COMMIT_IMMEDIATELY
			Commit();
#endif
		}
		if ( Entry.receiveModeV6 == 5 ) 
		{
			strncpy(receive_mode, "RIPng", strlen("RIPng"));
			receive_mode[strlen("RIPng")] = '\0';
		} else {
			boaError(wp, 400, "Get RIPNG Receive Mode 错误!\n");
			return -1;
		}
		if ( Entry.sendModeV6 == 5 ) 
		{
			strncpy(send_mode, "RIPng", strlen("RIPng"));
			send_mode[strlen("RIPng")] = '\0';
		} 
		else 
		{
			boaError(wp, 400, "Get RIPNG Send Mode 错误!\n");
			return -1;
		}
		
		if ( !mib_get( MIB_RIPNG_ENABLE, (void *)&ripngEnable) )
		{
			printf("[%s %d]ripngEnable is error\n", __func__, __LINE__);
			return -1;
		}
		nBytesSent += boaWrite(wp, "<tr>"
		"<td align=center width=\"20%%\"><font size=\"2\"><b>%s</b></font></td>"
		"<td align=center width=\"20%%\"><font size=\"2\"><b>%s</b></font></td>"
		"<td align=center width=\"20%%\"><input type=\"button\" name=\"select%d\" value=\"删除\" onClick=\"ripng_del_click(%d);\"></td>\n"
		"<td align=center width=\"20%%\"><input type=\"checkbox\" name=\"enable\" %s></td>\n"
		"</tr>\n",
		ifname, receive_mode, i, i, (ripngEnable==1)?"checked":"");
	}
	return 0;
}
#endif


#ifdef CONFIG_USER_ROUTED_ROUTED
// List all the rip interface at web page.
// return: number of rip interface listed.
int showRipIf(int eid, request * wp, int argc, char **argv)
{
	int nBytesSent=0;
	unsigned int entryNum, i;
	MIB_CE_RIP_T Entry;
	char ifname[IFNAMSIZ], receive_mode[5], send_mode[16];
#ifdef CONFIG_CMCC_ENTERPRISE
	unsigned char ripEnable;
	char authType[10], keyStr[32];
#endif

	entryNum = mib_chain_total(MIB_RIP_TBL);
#ifdef CONFIG_CMCC_ENTERPRISE
	nBytesSent += boaWrite(wp, "<tr><font size=1>"
		"<td align=center width=\"20%%\">%s</td>"
		"<td align=center width=\"20%%\">%s</td>"
		"<td align=center width=\"20%%\">%s</td>\n"
		"<td align=center width=\"20%%\">%s</td>"
		"<td align=center width=\"20%%\">%s</td></font></tr>\n",
		multilang(LANG_INTERFACE),multilang(LANG_VERSION),multilang(LANG_OPERATION_STR),
		multilang(LANG_VERIFICATION_METHOD_STR),multilang(LANG_ENABLE));
#else
	nBytesSent += boaWrite(wp, "<tr><font size=1>"
		"<td align=center width=\"5%%\" bgcolor=\"#808080\">%s</td>\n"
		"<td align=center width=\"20%%\" bgcolor=\"#808080\">%s</td>"
		"<td align=center width=\"20%%\" bgcolor=\"#808080\">%s%s</td>"
		"<td align=center width=\"20%%\" bgcolor=\"#808080\">%s%s</td></font></tr>\n", 
		UTF8_STR_DELETE, UTF8_STR_INTERFACE, UTF8_STR_RECEIVE, UTF8_STR_VERSION, UTF8_STR_TRANSMIT, UTF8_STR_VERSION);
#endif

	for (i=0; i<entryNum; i++) {

		if (!mib_chain_get(MIB_RIP_TBL, i, (void *)&Entry))
		{
  			boaError(wp, 400, "Get MIB_RIP_TBL chain record 错误!\n");
			return -1;
		}

		if( Entry.ifIndex == DUMMY_IFINDEX) {
			strncpy(ifname, "br0", strlen("br0"));
			ifname[strlen("br0")] = '\0';
		} else {
			ifGetName(Entry.ifIndex, ifname, sizeof(ifname));
		}

#ifdef CONFIG_CMCC_ENTERPRISE//unify mode anyway
		mib_get(MIB_RIP_ENABLE, (void *)&ripEnable);
		if(Entry.receiveMode != Entry.sendMode)
		{
			Entry.sendMode = Entry.receiveMode;
			mib_chain_update(MIB_RIP_TBL, (void *)&Entry, i);
#ifdef COMMIT_IMMEDIATELY
			Commit();
#endif
		}
#endif

		if ( Entry.receiveMode == RIP_NONE ) {
			strncpy(receive_mode, "None", strlen("None"));
			receive_mode[strlen("None")] = '\0';
		} else if ( Entry.receiveMode == RIP_V1 ) {
			strncpy(receive_mode, "RIP1", strlen("RIP1"));
			receive_mode[strlen("RIP1")] = '\0';
		} else if ( Entry.receiveMode == RIP_V2 ) {
			strncpy(receive_mode, "RIP2", strlen("RIP2"));
			receive_mode[strlen("RIP2")] = '\0';
		} else if ( Entry.receiveMode == RIP_V1_V2 ) {
			strncpy(receive_mode, "Both", strlen("Both"));
			receive_mode[strlen("Both")] = '\0';
		} else {
			boaError(wp, 400, "Get RIP Receive Mode 错误!\n");
			return -1;
		}

		if ( Entry.sendMode == RIP_NONE ) {
			strncpy(send_mode, "None", strlen("None"));
			send_mode[strlen("None")] = '\0';
		} else if ( Entry.sendMode == RIP_V1 ) {
			strncpy(send_mode, "RIP1", strlen("RIP1"));
			send_mode[strlen("RIP1")] = '\0';
		} else if ( Entry.sendMode == RIP_V2 ) {
			strncpy(send_mode, "RIP2", strlen("RIP2"));
			send_mode[strlen("RIP2")] = '\0';
		}
#ifdef CONFIG_CMCC_ENTERPRISE
		else if ( Entry.sendMode == RIP_V1_V2 ) 
#else
		else if ( Entry.sendMode == RIP_V1_COMPAT ) 
#endif 
		{
			strncpy(send_mode, "RIP1COMPAT", strlen("RIP1COMPAT"));
			send_mode[strlen("RIP1COMPAT")] = '\0';
		} else {
			boaError(wp, 400, "Get RIP Send Mode 错误!\n");
			return -1;
		}
#ifdef CONFIG_CMCC_ENTERPRISE
		if (Entry.authType == 2)
		{
			snprintf(authType, 10, "TEXT");
			snprintf(keyStr, 32, "%s", Entry.key);
		}
		else if (Entry.authType == 3)
		{
			snprintf(authType, 10, "MD5");
			snprintf(keyStr, 32, "%s", Entry.key);
		}
		else
		{
			snprintf(authType, 10, "NONE");
			memset(keyStr, 0, 32);
		}
		nBytesSent += boaWrite(wp, "<tr>"
		"<td align=center width=\"20%%\"><font size=\"2\"><b>%s</b></font></td>"
		"<td align=center width=\"20%%\"><font size=\"2\"><b>%s</b></font></td>"
		"<td align=center width=\"20%%\"><input type=\"button\" name=\"select%d\" value=\"删除\" onClick=\"rip_del_click(%d);\"></td>\n"
		"<td align=center width=\"20%%\"><font size=\"2\"><b>%s</b></font></td>"
		"<td align=center width=\"20%%\"><input type=\"checkbox\" name=\"enable\" %s></td>\n"
		"</tr>\n",
		ifname, receive_mode, i, i, authType, (ripEnable==1)?"checked":"");
#else
		nBytesSent += boaWrite(wp, "<tr>"
//		"<td align=center width=\"5%%\" bgcolor=\"#C0C0C0\"><input type=\"radio\" name=\"select\""
//		" value=\"s%d\""
//		"></td>\n"
		"<td align=center width=\"5%%\" bgcolor=\"#C0C0C0\"><input type=\"checkbox\" name=\"select%d\" value=\"ON\"></td>\n"
		"<td align=center width=\"20%%\" bgcolor=\"#C0C0C0\"><font size=\"2\"><b>%s</b></font></td>"
		"<td align=center width=\"20%%\" bgcolor=\"#C0C0C0\"><font size=\"2\"><b>%s</b></font></td>"
		"<td align=center width=\"20%%\" bgcolor=\"#C0C0C0\"><font size=\"2\"><b>%s</b></font></td>"
		"</tr>\n",
		i,
		ifname, receive_mode, send_mode);
#endif
	}
	return 0;
}

int ifRipNum()
{
	int ifnum=0;

	unsigned int entryNum, i;
	MIB_CE_ATM_VC_T Entry;
	char  buffer[3];


	// check LAN
	if (mib_get_s(MIB_ADSL_LAN_RIP, (void *)buffer, sizeof(buffer)) != 0) {
		if (buffer[0] == 1) {
			ifnum++;
		}
	}

	// check WAN
	entryNum = mib_chain_total(MIB_ATM_VC_TBL);
	for (i=0; i<entryNum; i++) {

		if (!mib_chain_get(MIB_ATM_VC_TBL, i, (void *)&Entry))
		{
			return -1;
		}

		if (Entry.enable == 0)
			continue;

		if (Entry.cmode != CHANNEL_MODE_BRIDGE && Entry.rip)
		{
			ifnum++;
		}
	}

	return ifnum;
}
#endif	// of CONFIG_USER_ROUTED_ROUTED

int showStaticRoute(int eid, request * wp, int argc, char **argv)
{
	int nBytesSent=0;

	unsigned int entryNum, i;
	MIB_CE_IP_ROUTE_T Entry;
	unsigned long int d,g,m;
	struct in_addr dest;
	struct in_addr gw;
	struct in_addr mask;
	char sdest[16], sgw[16];
	char interface_name[MAX_WAN_NAME_LEN];
	MIB_CE_ATM_VC_T vcEntry;
	int j;
	int mibTotal = mib_chain_total(MIB_ATM_VC_TBL);
#ifdef CONFIG_CMCC_ENTERPRISE
	int prefix_len=0;
#endif

	entryNum = mib_chain_total(MIB_IP_ROUTE_TBL);
#if defined(CONFIG_CMCC_ENTERPRISE)
	nBytesSent += boaWrite(wp, "<tr>"
	"<td align=center width=\"15%%\">%s</td>\n"
	"<td align=center width=\"30%%\">%s/%s</td>\n"
	"<td align=center width=\"15%%\">%s</td>\n"
	"<td align=center width=\"15%%\">%s</td>\n"
	"<td align=center width=\"15%%\">%s</td>\n"
	"<td align=center width=\"10%%\">%s</td>\n"
	"</tr>\n",
	multilang(LANG_IP_VERSION), multilang(LANG_DESRT_IP_STR), multilang(LANG_VOIP_PREFIX_LENGTH), multilang(LANG_GATEWAY),
	multilang(LANG_INTERFACES), multilang(LANG_HOP_COUNT_STR), multilang(LANG_DELETE));
#elif defined(CONFIG_CMCC) || defined(CONFIG_CU)
	nBytesSent += boaWrite(wp, "<tr>"
	"<td align=center width=\"8%%\">目的地址</td>\n"
	"<td align=center width=\"8%%\">网关</td>\n"
	"<td align=center width=\"8%%\">子网掩码</td>\n"
	"<td align=center width=\"8%%\">接口</td>\n"
#ifdef SUPPORT_SET_WANTYPE_FOR_STATIC_ROUTE	
	"<td align=center width=\"8%%\">接口类型</td>\n"
#endif	
	"<td align=center width=\"5%%\">删除</td>\n"
	"</tr>\n");
#else
	nBytesSent += boaWrite(wp, "<tr><font size=1>"
	"<td align=center width=\"5%%\" bgcolor=\"#808080\">选择</td>\n"
	"<td align=center width=\"5%%\" bgcolor=\"#808080\">状态</td>\n"
	"<td align=center width=\"8%%\" bgcolor=\"#808080\">目的</td>\n"
	"<td align=center width=\"8%%\" bgcolor=\"#808080\">子网掩码</td>\n"
	"<td align=center width=\"8%%\" bgcolor=\"#808080\">网关</td>\n"
	"<td align=center width=\"8%%\" bgcolor=\"#808080\">Metric</td>\n"
	"<td align=center width=\"8%%\" bgcolor=\"#808080\">接口</td>\n"
	"</font></tr>\n");
#endif

	for (i=0; i<entryNum; i++) {

		char destNet[16], subMask[16], nextHop[16];

		if (!mib_chain_get(MIB_IP_ROUTE_TBL, i, (void *)&Entry))
		{
  			boaError(wp, 400, "Get chain record error!\n");
			return -1;
		}

		dest.s_addr = *(unsigned long *)Entry.destID;
		gw.s_addr   = *(unsigned long *)Entry.nextHop;
		mask.s_addr = *(unsigned long *)Entry.netMask;
		// inet_ntoa is not reentrant, we have to
		// copy the static memory before reuse it
		strcpy(sdest, inet_ntoa(dest));

#if defined(CONFIG_CMCC) || defined(CONFIG_CU)
		if(Entry.nextHopEnable==1){
			strcpy(sgw, inet_ntoa(gw));
		}
		else{
			strcpy(sgw, "N/A");
		}
#else
		strcpy(sgw, inet_ntoa(gw));
#endif
		memset(interface_name, 0, sizeof(interface_name));
		strcpy( interface_name, "---" );
		if ( Entry.ifIndex != DUMMY_IFINDEX )
		{
			if(getWanEntrybyindex(&vcEntry, Entry.ifIndex) == 0){
				if(getWanName(&vcEntry, interface_name) == 0){
					strcpy( interface_name, "---" );
				}
			}			
		}
		
#if defined(CONFIG_CMCC) || defined(CONFIG_CU)
#ifdef SUPPORT_SET_WANTYPE_FOR_STATIC_ROUTE
		char str_ipaddr[20] = {0};
		char str_netmask[20] = {0};
		char str_gateway[20] = {0};

		if(Entry.itfTypeEnable && strlen(Entry.itfType))
		{
			getIPaddrInfo(&vcEntry, str_ipaddr, str_netmask, str_gateway);
			strcpy(sgw, str_gateway);
		}
#endif	
#endif

		strcpy(destNet, inet_ntoa(*((struct in_addr *)Entry.destID)) );
#if defined(CONFIG_CMCC) || defined(CONFIG_CU)
		if(Entry.nextHopEnable==1){
			strcpy(nextHop, inet_ntoa(*((struct in_addr *)Entry.nextHop)) );
		}
		else{
			strcpy(nextHop, "N/A");
		}
#else
		strcpy(nextHop, inet_ntoa(*((struct in_addr *)Entry.nextHop)) );
#endif
		strcpy(subMask, inet_ntoa(*((struct in_addr *)Entry.netMask)) );

#ifdef CONFIG_CMCC_ENTERPRISE
		prefix_len = netmask_to_cidr(subMask);
#endif
		nBytesSent += boaWrite(wp, "<tr>"
#ifdef CONFIG_CMCC_ENTERPRISE
		"<td align=center width=\"15%%\">IPV4</td>\n"
		"<td align=center width=\"35%%\">%s/%d</td>\n"
		"<td align=center width=\"15%%\">%s</td>\n"
		"<td align=center width=\"15%%\">%s</td>\n"
		"<td align=center width=\"15%%\">%d</td>\n"
		"<td align=center width=\"5%%\"><input type=\"radio\" name=\"select\""
		" value=\"s%d\" "
		"onClick=\"postGW(%d,  '%s','%s','%s',%d,%d,'select%d' )\""
		
		"></td>\n"
		"</tr>\n",
		sdest, prefix_len, sgw, interface_name, Entry.FWMetric,
		i, Entry.Enable, destNet, subMask, nextHop, Entry.FWMetric, Entry.ifIndex, i);
#elif defined(CONFIG_CMCC) || defined(CONFIG_CU)
		"<td align=center width=\"8%%\"> %s</td>\n"
		"<td align=center width=\"8%%\"> %s</td>\n"
		"<td align=center width=\"8%%\"> %s</td>"
		"<td align=center width=\"8%%\"> %s</td>"	
#ifdef SUPPORT_SET_WANTYPE_FOR_STATIC_ROUTE	
		"<td align=center width=\"8%%\"> %s</td>"
#endif	
		"<td align=center width=\"5%%\"><input type=\"radio\" name=\"select\""
		" value=\"s%d\" "
		"onClick=\"postGW(%d,  '%s','%s','%s',%d,%d,'select%d' )\""

		"></td>\n"
		"</tr>\n",
		sdest, sgw, inet_ntoa(mask), interface_name,
#ifdef SUPPORT_SET_WANTYPE_FOR_STATIC_ROUTE
		Entry.itfType,
#endif
		i, Entry.Enable, destNet, subMask, nextHop, Entry.FWMetric, Entry.ifIndex, i);
#else
		"<td align=center width=\"5%%\" bgcolor=\"#C0C0C0\"><input type=\"radio\" name=\"select\""
		" value=\"s%d\" "
		"onClick=\"postGW(%d,  '%s','%s','%s',%d,%d,'select%d' )\""

		"></td>\n"
		"<td align=center width=\"8%%\" bgcolor=\"#C0C0C0\"><font size=\"2\"><b>%s</b></font></td>\n"
		"<td align=center width=\"8%%\" bgcolor=\"#C0C0C0\"><font size=\"2\"><b>%s</b></font></td>\n"
		"<td align=center width=\"8%%\" bgcolor=\"#C0C0C0\"><font size=\"2\"><b>%s</b></font></td>\n"
		"<td align=center width=\"8%%\" bgcolor=\"#C0C0C0\"><font size=\"2\"><b>%s</b></font></td>"
		"<td align=center width=\"8%%\" bgcolor=\"#C0C0C0\"><font size=\"2\"><b>%d</b></font></td>"
		"<td align=center width=\"8%%\" bgcolor=\"#C0C0C0\"><font size=\"2\"><b>%s</b></font></td>"
		"</tr>\n",
		i,
		Entry.Enable, destNet, subMask, nextHop, Entry.FWMetric, Entry.ifIndex, i,
		Entry.Enable ? "启用" : "禁用", sdest, inet_ntoa(mask), sgw, Entry.FWMetric, interface_name);
#endif
	}

	return 0;
}

#ifdef CONFIG_CU_BASEON_CMCC
int showIPForwardList(int eid, request * wp, int argc, char **argv)
{
	int nBytesSent=0;
	int i, mibTotal;
	char wanName[MAX_WAN_NAME_LEN]={0};
	MIB_CE_ATM_VC_T vcEntry;
	mibTotal = mib_chain_total(MIB_ATM_VC_TBL);

	nBytesSent += boaWrite(wp, "<tr>"
	"<td align=center width=\"8%%\">连接名称</td>\n"
	"<td align=center width=\"8%%\">目的IP</td>\n"
	"</tr>\n");

	for (i=0; i<mibTotal; i++) 
	{
		if (!mib_chain_get(MIB_ATM_VC_TBL, i, (void *)&vcEntry))
		{
  			boaError(wp, 400, "Get chain record error!\n");
			return 0;
		}

		if((vcEntry.IPForwardModeEnabled == 0) || (strlen(vcEntry.IPForwardList) == 0))
			continue;

		getWanName(&vcEntry, wanName);

		nBytesSent += boaWrite(wp, "<tr>"
		"<td align=center width=\"8%%\"> %s</td>\n"
		"<td align=center width=\"8%%\"> %s</td>\n"
		"</tr>\n",
		wanName, vcEntry.IPForwardList);
	}

	return 0;
}

int rteIPForwardList(int eid, request * wp, int argc, char ** argv)
{
	int i, mibTotal;
	char wanName[MAX_WAN_NAME_LEN]={0};
	MIB_CE_ATM_VC_T entry;
#if 0
	unsigned char ipForwardEnable = 0;
	
	mib_get_s(CWMP_CT_IP_FORWARD_MODE_ENABLED, (void *)&ipForwardEnable, sizeof(ipForwardEnable));
	_PUT_BOOL(ipForwardEnable);

	if(ipForwardEnable)
#endif
	{
		mibTotal = mib_chain_total(MIB_ATM_VC_TBL);
		for (i=0; i<mibTotal; i++) 
		{
			if (!mib_chain_get(MIB_ATM_VC_TBL, i, (void *)&entry))
			{
  				boaError(wp, 400, "Get chain record error!\n");
				return 0;
			}
	
			if((entry.IPForwardModeEnabled == 0) || (strlen(entry.IPForwardList) == 0))
				continue;
	
			getWanName(&entry, wanName);

			boaWrite(wp, "push(new it_nr(\"%d\"" _PTI _PTS _PTS "));\n",
				i, _PME(ifIndex), "ifname", wanName, _PME(IPForwardList));
		}
	}
	return 0;
}
void formIPForward(request *wp, char *path, char *query)
{
	MIB_CE_ATM_VC_T *pEntry, entry;
	char *strVal;
	char *stemp = "";
	int index = 0;
	int lineno = __LINE__;
	unsigned char ipForwardEnable = 0;
	char IPForwardList[IPFORWARD_SIZE];
	unsigned int ipForwardWan;
	_BC_USE;

	FETCH_INVALID_OPT(stemp, "action", _NEED);

	pEntry = &entry;
#if 0
	if(strcmp(stemp, "sw") == 0)	//switch
	{
		_GET_BOOL(ipForwardEnable, _NEED);
		printf("ipForwardEnable = %d", ipForwardEnable);

		mib_set(CWMP_CT_IP_FORWARD_MODE_ENABLED, (void *)&ipForwardEnable);
#ifdef _PRMT_X_CU_EXTEND_
		handle_WANIPForwardMode_all();
#else
		handle_IPForwardMode(-1);	
#endif
	}
	else 
#endif
	if(strcmp(stemp, "rm") == 0)	//remove
	{
		_BC_INIT("bcdata");
		while(_BC_NEXT())
		{
			//memset(vc_entity, 0, sizeof(struct MIB_CE_ATM_VC_T));
			memset(&entry, 0, sizeof(MIB_CE_ATM_VC_T));
			_BC_ENTRY_INT(ifIndex, _OPT);
			_BC_ENTRY_STR(IPForwardList, _OPT);

			ipForwardWan = pEntry->ifIndex;
			int mibtotal,i,num=0,totalnum=0;
			mibtotal = mib_chain_total(MIB_ATM_VC_TBL);
			for(i=0;i<mibtotal;i++)
			{
				if(!mib_chain_get(MIB_ATM_VC_TBL, i, (void *)pEntry))
					continue;
				if(pEntry->ifIndex == ipForwardWan)
					break;
			}
			if(i==mibtotal)
				goto check_err;

			memset(IPForwardList, 0, IPFORWARD_SIZE);
			strncpy(pEntry->IPForwardList, IPForwardList, sizeof(pEntry->IPForwardList));
			pEntry->IPForwardModeEnabled = 0;
			mib_chain_update(MIB_ATM_VC_TBL, (unsigned char*)pEntry, i);
#ifdef _PRMT_X_CU_EXTEND_
			handle_WANIPForwardMode(i);
#else
			handle_IPForwardMode(i);		
#endif
		}
	}
	else if(strcmp(stemp, "ad") == 0)	//add
	{
		strVal = boaGetVar(wp, "ifIndex", "");
		if (strVal[0]) {
			ipForwardWan = (unsigned int)atoi(strVal);
		}
		else{
			ipForwardWan = DUMMY_IFINDEX;
			goto check_err;
		}
		printf("%s %d, ipForwardWan=%d\n", __FUNCTION__, __LINE__, ipForwardWan);
		
		int mibtotal,i,num=0,totalnum=0;
		mibtotal = mib_chain_total(MIB_ATM_VC_TBL);
		for(i=0;i<mibtotal;i++)
		{
			if(!mib_chain_get(MIB_ATM_VC_TBL, i, (void *)pEntry))
				continue;
			if(pEntry->ifIndex == ipForwardWan)
				break;
		}
		if(i==mibtotal)
			goto check_err;

		memset(IPForwardList, 0, IPFORWARD_SIZE);
		_GET_STR(IPForwardList, _NEED);
		strncpy(pEntry->IPForwardList, IPForwardList, sizeof(pEntry->IPForwardList));
		pEntry->IPForwardModeEnabled = 1;
		mib_chain_update(MIB_ATM_VC_TBL, (unsigned char*)pEntry, i);
#ifdef _PRMT_X_CU_EXTEND_
		handle_WANIPForwardMode(i);
#else
		handle_IPForwardMode(i);
#endif
	}
	else {lineno = __LINE__; goto check_err;}

	mib_update(CURRENT_SETTING, CONFIG_MIB_ALL);
	_COND_REDIRECT;
check_err:
	_BC_FREE();
	return;
}
#endif

#if defined(CONFIG_CMCC) || defined(CONFIG_CU) || defined(CONFIG_E8B)
#ifdef CONFIG_IPV6
int showIPv6StaticRoute(int eid, request * wp, int argc, char **argv)
{
	int nBytesSent=0;

	unsigned int entryNum, i;
	MIB_CE_IPV6_ROUTE_T Entry;
	unsigned long int d,g,m;
	char sdest[40], sgw[40];
	char interface_name[MAX_WAN_NAME_LEN];
	MIB_CE_ATM_VC_T vcEntry;
	int j;
	int mibTotal = mib_chain_total(MIB_ATM_VC_TBL);
	int len=0;
	char addr[MAX_V6_IP_LEN] ={0};

	entryNum = mib_chain_total(MIB_IPV6_ROUTE_TBL);

#ifdef CONFIG_CMCC_ENTERPRISE
	nBytesSent += boaWrite(wp, "<tr>"
	"<td align=center width=\"15%%\">%s</td>\n"
	"<td align=center width=\"30%%\">%s/%s</td>\n"
	"<td align=center width=\"15%%\">%s</td>\n"
	"<td align=center width=\"15%%\">%s</td>\n"
	"<td align=center width=\"15%%\">%s</td>\n"
	"<td align=center width=\"10%%\">%s</td>\n"
	"</tr>\n",
	multilang(LANG_IP_VERSION), multilang(LANG_DESRT_IP_STR), multilang(LANG_VOIP_PREFIX_LENGTH), multilang(LANG_GATEWAY), 
	multilang(LANG_INTERFACES), multilang(LANG_DESRT_IP_STR), multilang(LANG_DELETE));
#elif defined(CONFIG_CMCC) || defined(CONFIG_CU)
	nBytesSent += boaWrite(wp, "<tr>"
	"<td align=center>目的地址</td>\n"
	"<td align=center>网关</td>\n"
	"<td align=center>接口</td>\n"
	"<td align=center>使能</td>\n"
	"<td align=center>删除</td>\n"
	"</tr>\n");
#else
	nBytesSent += boaWrite(wp, "<tr><font size=1>"
	"<td align=center bgcolor=\"#c8c8c8\">选择</td>\n"
	"<td align=center bgcolor=\"#c8c8c8\">状态</td>\n"
	"<td align=center bgcolor=\"#c8c8c8\">目的</td>\n"
	"<td align=center bgcolor=\"#c8c8c8\">前缀长度</td>\n"
	"<td align=center bgcolor=\"#c8c8c8\">网关</td>\n"
	"<td align=center bgcolor=\"#c8c8c8\">Metric</td>\n"
	"<td align=center bgcolor=\"#c8c8c8\">接口</td>\n"
	"</font></tr>\n");
#endif

	for (i=0; i<entryNum; i++) {
		char destNet[48], nextHop[48];

		if (!mib_chain_get(MIB_IPV6_ROUTE_TBL, i, (void *)&Entry))
		{
  			boaError(wp, 400, "Get chain record error!\n");
			return -1;
		}

		memset(interface_name, 0, sizeof(interface_name));
		strcpy( interface_name, "---");
		if ( Entry.DstIfIndex != DUMMY_IFINDEX )
		{
			if(getWanEntrybyindex(&vcEntry, Entry.DstIfIndex) == 0){
				if(getWanName(&vcEntry, interface_name) == 0){
					strcpy( interface_name, "---");
				}
			}
		}

		sscanf(Entry.Dstination, "%[^/]/%d", addr, &len);
        strcpy(destNet, addr);
#if defined(CONFIG_CMCC) || defined(CONFIG_CU)
		if(Entry.nextHopEnable==1){
			strcpy(nextHop, Entry.NextHop);
		}
		else{
			strcpy(nextHop, "");
		}
#else
		strcpy(nextHop, Entry.NextHop);
#endif

		nBytesSent += boaWrite(wp, "<tr>"
#ifdef CONFIG_CMCC_ENTERPRISE
		"<td align=center width=\"15%%\">IPV6</td>\n"
		"<td align=center width=\"35%%\">%s/%d</td>\n"
		"<td align=center width=\"15%%\">%s</td>\n"
		"<td align=center width=\"15%%\">%s</td>\n"
		"<td align=center width=\"15%%\">%d</td>\n"
		"<td align=center width=\"5%%\"><input type=\"radio\" name=\"select\""
		" value=\"s%d\" "
		"onClick=\"postGWv6(%d,  '%s',%d,'%s',%d,'select%d' )\""
		"></td>\n"		
		"</tr>\n",
		destNet, len, nextHop, interface_name, Entry.FWMetric,
		i, Entry.Enable, destNet, len, nextHop, Entry.DstIfIndex, i);
#elif defined(CONFIG_CMCC) || defined(CONFIG_CU)
		"<td align=center width=\"8%%\">%s</td>\n"
		"<td align=center width=\"8%%\">%s</td>\n"
		"<td align=center width=\"8%%\">%s</td>"
		"<td align=center width=\"8%%\">%s</td>"
		"<td align=center width=\"5%%\"><input type=\"radio\" name=\"select\""
		" value=\"s%d\" "
		"onClick=\"postGWv6(%d,  '%s',%d,'%s',%d,'select%d' )\""
		"></td>\n"		
		"</tr>\n",
		destNet, nextHop, interface_name, Entry.Enable ? "使能" : "禁用", 
		i, Entry.Enable, destNet, len, nextHop, Entry.DstIfIndex, i);
#else
		"<td align=center width=\"5%%\" bgcolor=\"#c8c8c8\"><input type=\"radio\" name=\"select\""
		" value=\"s%d\" "
		"onClick=\"postGW(%d, '%s',%d,'%s',%d, %d, 'select%d' )\""
		
		"></td>\n"
		"<td align=center width=\"8%%\" bgcolor=\"#f4f4f4\"><font size=\"2\"><b>%s</b></font></td>\n"
		"<td align=center width=\"8%%\" bgcolor=\"#f4f4f4\"><font size=\"2\"><b>%s</b></font></td>\n"
		"<td align=center width=\"8%%\" bgcolor=\"#f4f4f4\"><font size=\"2\"><b>%d</b></font></td>"
		"<td align=center width=\"8%%\" bgcolor=\"#f4f4f4\"><font size=\"2\"><b>%s</b></font></td>"
		"<td align=center width=\"8%%\" bgcolor=\"#f4f4f4\"><font size=\"2\"><b>%d</b></font></td>"
		"<td align=center width=\"8%%\" bgcolor=\"#f4f4f4\"><font size=\"2\"><b>%s</b></font></td>"
		"</tr>\n",
		i,
		Entry.Enable, destNet, len, nextHop, Entry.FWMetric, Entry.DstIfIndex, i,
		Entry.Enable ? "启用" : "禁用", destNet, len,  nextHop, Entry.FWMetric, interface_name);
#endif
	}
	return 0;
}

void v6AddrTransform(char *src, char *dst)
{
	unsigned char buf[sizeof(struct in6_addr)];
	int s;

    if(!src || !dst)
		return;

    s = inet_pton(AF_INET6, src, buf);
    if (s <= 0) {
        if (s == 0)
            fprintf(stderr, "Not in presentation format");
        else
            perror("inet_pton");
        return;
    }

    if (inet_ntop(AF_INET6, buf, dst, INET6_ADDRSTRLEN) == NULL)
        perror("inet_ntop");
}

int routeIPv6List(int eid, request * wp, int argc, char **argv)
{
	char buff[1024], iface[10], flags[10];
	char addr6[INET6_ADDRSTRLEN], naddr6[INET6_ADDRSTRLEN];
	struct sockaddr_in6 saddr6, snaddr6;
	int num, iflags, metric, refcnt, use, prefix_len, slen;
	char addr6p[8][5], saddr6p[8][5], naddr6p[8][5];
	int nBytesSent=0;
	char dstr[INET6_ADDRSTRLEN],nextHopStr[INET6_ADDRSTRLEN],tmp[INET6_ADDRSTRLEN];

	FILE *fp=NULL;

	if (!(fp=fopen("/proc/net/ipv6_route", "r"))) {
		printf("Error: cannot open /proc/net/ipv6_route - continuing...\n");
		boaWrite(wp, "%s", "Error: cannot open /proc/net/ipv6_route !!");
		return -1;
	}

	/*
	 * Display like route -A inet6 form
	 * Destination                                 Next Hop                                Flags Metric Ref    Use Iface
	 * 2001:db8:101:100::/64                       ::                                      U     256    10       0 nas0_0
	 */
#ifndef CONFIG_GENERAL_WEB
	nBytesSent += boaWrite(wp, "<tr><font size=1>"
			"<td align=center width=\"32%%\" bgcolor=\"#808080\">%s</td>\n"
			"<td align=center width=\"32%%\" bgcolor=\"#808080\">%s</td>\n"
			"<td align=center width=\"32%%\" bgcolor=\"#808080\">%s</td>\n"
			"<td align=center width=\"32%%\" bgcolor=\"#808080\">%s</td>\n"
			"<td align=center width=\"32%%\" bgcolor=\"#808080\">%s</td>\n"
			"<td align=center width=\"32%%\" bgcolor=\"#808080\">%s</td>\n"
			"<td align=center width=\"32%%\" bgcolor=\"#808080\">%s</td></font></tr>\n",
#else
	nBytesSent += boaWrite(wp, "<tr>"
			"<th align=center width=\"32%%\">%s</th>\n"
			"<th align=center width=\"32%%\">%s</th>\n"
			"<th align=center width=\"32%%\">%s</th>\n"
			"<th align=center width=\"32%%\">%s</th>\n"
			"<th align=center width=\"32%%\">%s</th>\n"
			"<th align=center width=\"32%%\">%s</th>\n"
			"<th align=center width=\"32%%\">%s</th></tr>\n",
#endif
			multilang(LANG_DESTINATION),  multilang(LANG_NEXT_HOP), multilang(LANG_FLAGS),
			multilang(LANG_METRIC), multilang(LANG_REF), multilang(LANG_USE), multilang(LANG_INTERFACE));

	while (fgets(buff, sizeof(buff), fp)) {
		num = sscanf(buff, "%4s%4s%4s%4s%4s%4s%4s%4s %02x %4s%4s%4s%4s%4s%4s%4s%4s %02x %4s%4s%4s%4s%4s%4s%4s%4s %08x %08x %08x %08x %s\n",
				addr6p[0], addr6p[1], addr6p[2], addr6p[3],
				addr6p[4], addr6p[5], addr6p[6], addr6p[7],
				&prefix_len,
				saddr6p[0], saddr6p[1], saddr6p[2], saddr6p[3],
				saddr6p[4], saddr6p[5], saddr6p[6], saddr6p[7],
				&slen,
				naddr6p[0], naddr6p[1], naddr6p[2], naddr6p[3],
				naddr6p[4], naddr6p[5], naddr6p[6], naddr6p[7],
				&metric, &use, &refcnt, &iflags, iface);

		if (!(iflags & RTF_UP))
			continue;

		/* Fetch and resolve the target address. */
		snprintf(addr6, sizeof(addr6), "%s:%s:%s:%s:%s:%s:%s:%s",
				addr6p[0], addr6p[1], addr6p[2], addr6p[3],
				addr6p[4], addr6p[5], addr6p[6], addr6p[7]);

		/* Fetch and resolve the nexthop address. */
		snprintf(naddr6, sizeof(naddr6), "%s:%s:%s:%s:%s:%s:%s:%s",
				naddr6p[0], naddr6p[1], naddr6p[2], naddr6p[3],
				naddr6p[4], naddr6p[5], naddr6p[6], naddr6p[7]);

		v6AddrTransform(addr6, tmp);
		sprintf(dstr,"%s/%d",tmp,prefix_len);
		v6AddrTransform(naddr6, nextHopStr);

		/* Decode the flags. */
		strcpy(flags, "U");
		if (iflags & RTF_GATEWAY)
			strcat(flags, "G");
		if (iflags & RTF_HOST)
			strcat(flags, "H");
		if (iflags & RTF_DEFAULT)
			strcat(flags, "D");
		if (iflags & RTF_ADDRCONF)
			strcat(flags, "A");
		if (iflags & RTF_CACHE)
			strcat(flags, "C");

		nBytesSent += boaWrite(wp, "<tr>"
#ifndef CONFIG_GENERAL_WEB
				"<td align=center width=\"8%%\" bgcolor=\"#C0C0C0\"><font size=\"2\"><b>%s</b></font></td>\n"
				"<td align=center width=\"8%%\" bgcolor=\"#C0C0C0\"><font size=\"2\"><b>%s</b></font></td>\n"
				"<td align=center width=\"8%%\" bgcolor=\"#C0C0C0\"><font size=\"2\"><b>%s</b></font></td>\n"
				"<td align=center width=\"8%%\" bgcolor=\"#C0C0C0\"><font size=\"2\"><b>%d</b></font></td>\n"
				"<td align=center width=\"8%%\" bgcolor=\"#C0C0C0\"><font size=\"2\"><b>%d</b></font></td>\n"
				"<td align=center width=\"8%%\" bgcolor=\"#C0C0C0\"><font size=\"2\"><b>%d</b></font></td>\n"
				"<td align=center width=\"8%%\" bgcolor=\"#C0C0C0\"><font size=\"2\"><b>%s</b></font></td></tr>\n",
#else
				"<td align=center width=\"8%%\">%s</td>\n"
				"<td align=center width=\"8%%\">%s</td>\n"
				"<td align=center width=\"8%%\">%s</td>\n"
				"<td align=center width=\"8%%\">%d</td>\n"
				"<td align=center width=\"8%%\">%d</td>\n"
				"<td align=center width=\"8%%\">%d</td>\n"
				"<td align=center width=\"8%%\">%s</td></tr>\n",
#endif
				dstr,  nextHopStr, flags, metric, use, refcnt , iface);
	}

	fclose(fp);
	return 0;
}
#endif

#endif


#ifndef RTF_UP
/* Keep this in sync with /usr/src/linux/include/linux/route.h */
#define RTF_UP          0x0001	/* route usable                 */
#define RTF_GATEWAY     0x0002	/* destination is a gateway     */
#define RTF_HOST        0x0004	/* host entry (net otherwise)   */
#define RTF_REINSTATE   0x0008	/* reinstate route after tmout  */
#define RTF_DYNAMIC     0x0010	/* created dyn. (by redirect)   */
#define RTF_MODIFIED    0x0020	/* modified dyn. (by redirect)  */
#define RTF_MTU         0x0040	/* specific MTU for this route  */
#ifndef RTF_MSS
#define RTF_MSS         RTF_MTU	/* Compatibility :-(            */
#endif
#define RTF_WINDOW      0x0080	/* per route window clamping    */
#define RTF_IRTT        0x0100	/* Initial round trip time      */
#define RTF_REJECT      0x0200	/* Reject route                 */
#endif

int routeList(int eid, request * wp, int argc, char **argv)
{
	int nBytesSent=0;
	char buff[256];
	int flgs, metric;
	unsigned long int d,g,m;
	struct in_addr dest;
	struct in_addr gw;
	struct in_addr mask;
	char sdest[16], sgw[16], iface[30];
	FILE *fp;

	if (!(fp=fopen("/proc/net/route", "r"))) {
		//fclose(fp);
		printf("Error: cannot open /proc/net/route - continuing...\n");
		boaWrite(wp, "%s", "Error: cannot open /proc/net/route !!");
		return -1;
	}
	nBytesSent += boaWrite(wp, "<tr><font size=1>"
	"<td align=center width=\"8%%\" bgcolor=\"#808080\">目的</td>\n"
	"<td align=center width=\"8%%\" bgcolor=\"#808080\">子网掩码</td>\n"
	"<td align=center width=\"8%%\" bgcolor=\"#808080\">网关</td>\n"
	"<td align=center width=\"8%%\" bgcolor=\"#808080\">Metric</td>\n"
	"<td align=center width=\"8%%\" bgcolor=\"#808080\">接口</td></font></tr>\n");
	fgets(buff, sizeof(buff), fp);

	while( fgets(buff, sizeof(buff), fp) != NULL ) {
		if(sscanf(buff, "%s%lx%lx%X%*d%*d%d%lx",
		   iface, &d, &g, &flgs, &metric, &m)!=6) {
			printf("Unsuported kernel route format\n");
			boaWrite(wp, "%s", "Error: Unsuported kernel route format !!");
			fclose(fp);
			return -1;
		}

		if(flgs & RTF_UP) {
			dest.s_addr = d;
			gw.s_addr   = g;
			mask.s_addr = m;
			// inet_ntoa is not reentrant, we have to
			// copy the static memory before reuse it
			//strcpy(sdest, inet_ntoa(dest));
			sdest[sizeof(sdest)-1]='\0';
			strncpy(sdest, inet_ntoa(dest), sizeof(sdest)-1);
			//strcpy(sgw,  (gw.s_addr==0   ? "*" : inet_ntoa(gw)));
			sgw[sizeof(sgw)-1]='\0';
			strncpy(sgw, (gw.s_addr==0   ? "*" : inet_ntoa(gw)), sizeof(sgw)-1);

			nBytesSent += boaWrite(wp, "<tr>"
			"<td align=center width=\"8%%\" bgcolor=\"#C0C0C0\"><font size=\"2\"><b>%s</b></font></td>\n"
			"<td align=center width=\"8%%\" bgcolor=\"#C0C0C0\"><font size=\"2\"><b>%s</b></font></td>\n"
			"<td align=center width=\"8%%\" bgcolor=\"#C0C0C0\"><font size=\"2\"><b>%s</b></font></td>\n"
			"<td align=center width=\"8%%\" bgcolor=\"#C0C0C0\"><font size=\"2\"><b>%d</b></font></td>\n"
			"<td align=center width=\"8%%\" bgcolor=\"#C0C0C0\"><font size=\"2\"><b>%s</b></font></td></tr>\n",
			sdest, inet_ntoa(mask), sgw, metric, iface);
		}
	}

	fclose(fp);
	return 0;
}

/////////////////////////////////////////////////////////////////////////////
void formRefleshRouteTbl(request * wp, char *path, char *query)
{
	char *submitUrl;

	submitUrl = boaGetVar(wp, "submit-url", "");
	if (submitUrl[0])
		boaRedirect(wp, submitUrl);
}

//ql_xu
#ifdef CONFIG_USER_ZEBRA_OSPFD_OSPFD
int showOspfIf(int eid, request * wp, int argc, char **argv)
{
	int nBytesSent=0;
	unsigned int entryNum, i, j;
	MIB_CE_OSPF_T Entry;
	char net[20]={0};
	char net_tmp[20]={0};

	unsigned int uMask;
	unsigned int uIp;

	entryNum = mib_chain_total(MIB_OSPF_TBL);
	nBytesSent = boaWrite(wp, "<tr><font size=1>"
		"<td align=center width=\"5%%\" bgcolor=\"#808080\">选择</td>\n"
		"<td align=center width=\"20%%\" bgcolor=\"#808080\">OSPF广播网络</td></font></tr>\n");

	for (i=0; i<entryNum; i++) {

		if (!mib_chain_get(MIB_OSPF_TBL, i, (void *)&Entry))
		{
  			boaError(wp, 400, "Get MIB_OSPF_TBL chain record error!\n");
			return;
		}

		uIp = *(unsigned int *)Entry.ipAddr;
		uMask = *(unsigned int *)Entry.netMask;
		uIp = uIp & uMask;
		sprintf(net, "%s", inet_ntoa(*((struct in_addr *)&uIp)));
		for (j=0; j<32; j++)
			if ((uMask>>j) & 0x01)
				break;
		uMask = 32 - j;
		snprintf(net_tmp, 20, "%s/%d", net, uMask);

		nBytesSent += boaWrite(wp, "<tr>\n"
			"<td align=center width=\"5%%\" bgcolor=\"#C0C0C0\"><input type=\"radio\" name=\"select\""
			" value=\"s%d\"></td>\n"
			"<td align=center width=\"20%%\" bgcolor=\"#C0C0C0\"><font size=\"2\"><b>%s</b></font></td>\n"
			"</tr>\n",
			i, net_tmp);
	}
	return 0;
}
#endif
