#include <rtk/utility.h>

#include "webs.h"
#include "webform.h"
#include "../defs.h"
#include "multilang.h"

void formSamba(request * wp, char *path, char *query)
{
	char *str, *submitUrl;
	unsigned char samba_enable;

	str = boaGetVar(wp, "sambaCap", "");
	if (str[0]) {
		samba_enable = str[0] - '0';
		if (!mib_set(MIB_SAMBA_ENABLE, &samba_enable)) {
			goto formSamba_err;
		}
	}

#ifdef CONFIG_USER_NMBD
	str = boaGetVar(wp, "netBIOSName", "");
	if (str[0]) {
		if (!mib_set(MIB_SAMBA_NETBIOS_NAME, str)) {
			goto formSamba_err;
		}
	}
#endif

	str = boaGetVar(wp, "serverString", "");
	if (str[0]) {
		if (!mib_set(MIB_SAMBA_SERVER_STRING, str)) {
			goto formSamba_err;
		}
	}

formSamba_end:
#ifdef APPLY_CHANGE
	stopSamba();
	startSamba();
#endif

#ifdef COMMIT_IMMEDIATELY
	Commit();
#endif

	submitUrl = boaGetVar(wp, "submit-url", "");
	OK_MSG(submitUrl);

	return;

formSamba_err:
	ERR_MSG("Set MIB error...");
}

void formSambaAccount(request * wp, char *path, char *query)
{
#ifdef CONFIG_MULTI_SMBD_ACCOUNT
	char	*str, *submitUrl;
	char tmpBuf[100];
	//struct rtentry rt;
	MIB_CE_SMB_ACCOUNT_T entry;
	int xflag, isnet, ret;
	int skfd;
	int intVal;
	unsigned int totalEntry;

	memset( &entry, 0, sizeof(MIB_CE_SMB_ACCOUNT_T));

	// Delete
	str = boaGetVar(wp, "delSamba", "");
	if (str[0]) {
		unsigned int i;
		unsigned int idx;
		MIB_CE_SMB_ACCOUNT_T Entry;
		unsigned int totalEntry = mib_chain_total(MIB_SMBD_ACCOUNT_TBL); /* get chain record size */
		str = boaGetVar(wp, "select", "");

		if (str[0]) {
			for (i=0; i<totalEntry; i++) {
				idx = totalEntry-i-1;

				if ( idx == atoi(str) ) {
					/* get the specified chain record */
					if (!mib_chain_get(MIB_SMBD_ACCOUNT_TBL, idx, (void *)&Entry)) {
						strcpy(tmpBuf, errGetEntry);
						goto setErr_samba;
					}

					rtk_app_del_smbd_account(Entry.username);

					syslog(LOG_INFO, "formSambaAccount: Delete Entry");

					goto setOk_samba;
				}
			} // end of for
		}
		else {
			strcpy(tmpBuf, "没有选择删除的项目!");
			goto setErr_samba;
		}

		goto setOk_samba;
	}

	// parse input
	str = boaGetVar(wp, "username", "");
	if (str[0]){
	    strcpy(entry.username,str);
		printf("username:%s\n", entry.username);
	}

	str = boaGetVar(wp, "password", "");
	if (str[0]){
	    strcpy(entry.password,str);
		printf("password:%s\n", entry.password);
	}

	str = boaGetVar(wp, "saveDir", "");
	if (str[0]){
	    sprintf(entry.path,"/mnt/%s",str);
		printf("path:%s\n", entry.path);
	}
	else{
		sprintf(entry.path,"/mnt");
		printf("path:%s\n", entry.path);
	}

	str = boaGetVar(wp, "writeable", "");
	if ( str && str[0] ) {
		entry.writable=atoi(str);
	}

	// Add
	str = boaGetVar(wp, "addSamba", "");
	if (str && str[0]) {
		intVal = add_smbd_account(entry.username, entry.password, entry.path, entry.writable);
		if (intVal == -1) {
			strcpy(tmpBuf, "这个用户已存在于MIB!");
			goto setErr_samba;
		}

		if (intVal == 0) {
			strcpy(tmpBuf, Tadd_chain_error);
			goto setErr_samba;
		}

		syslog(LOG_INFO, "Samba Account: Add Entry");
	}

setOk_samba:
// Magician: Commit immediately
#ifdef COMMIT_IMMEDIATELY
	Commit();
#endif

	submitUrl = boaGetVar(wp, "submit-url", "");
	if (submitUrl[0])
		boaRedirect(wp, submitUrl);
	else
		boaDone(wp, 200);
  	return;

setErr_samba:
	ERR_MSG(tmpBuf);
#endif
}

int showSambaAccount(int eid, request * wp, int argc, char **argv)
{
#ifdef CONFIG_MULTI_SMBD_ACCOUNT
	int nBytesSent=0;

	unsigned int entryNum, i;
	MIB_CE_SMB_ACCOUNT_T Entry;

	entryNum = mib_chain_total(MIB_SMBD_ACCOUNT_TBL);

	nBytesSent += boaWrite(wp, "<tr>"
	"<td align=center width=\"8%%\">用户名</td>\n"
	"<td align=center width=\"8%%\">密码</td>\n"
	"<td align=center width=\"8%%\">目录</td>\n"
	"<td align=center width=\"8%%\">目录权限</td>\n"
	"<td align=center width=\"5%%\">删除</td>\n"
	"</tr>\n");


	for (i=0; i<entryNum; i++) {

		char sWritable[16];

		if (!mib_chain_get(MIB_SMBD_ACCOUNT_TBL, i, (void *)&Entry))
		{
  			boaError(wp, 400, "Get chain record error!\n");
			return -1;
		}
		memset(sWritable, 0, sizeof(sWritable));
		sprintf(sWritable, "%s", Entry.writable==1 ? "可读写":"可读");

		nBytesSent += boaWrite(wp, "<tr>"

		"<td align=center width=\"8%%\"> %s</td>\n"
		"<td align=center width=\"8%%\"> %s</td>\n"
		"<td align=center width=\"8%%\"> %s</td>"
		"<td align=center width=\"8%%\"> %s</td>"	
		"<td align=center width=\"5%%\"><input type=\"radio\" name=\"select\""
		" value=\"%d\" "
		"onClick=\"postSamba('%s','%s','%s',%d,'select%d' )\""
		"></td>\n"
		"</tr>\n",
		strValToASP(Entry.username), strValToASP(Entry.password), strValToASP(Entry.path), sWritable,
		i, strValToASP(Entry.username), strValToASP(Entry.password), strValToASP(Entry.path), Entry.writable, i);

	}
#endif

	return 0;
}

