/*
 *      Web server handler routines for SEC
 *      Authors:
 *
 */

/*-- System inlcude files --*/
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <ctype.h>
#include <sys/wait.h>
#include <semaphore.h>
#ifdef EMBED
#include <linux/config.h>
#else
#include "../../../uClibc/include/linux/autoconf.h"
#endif

/* for ioctl */
#include <sys/ioctl.h>
#include <sys/socket.h>
#include <linux/if.h>

#include "../webs.h"
#include "fmdefs.h"
#include "mib.h"
#include "utility.h"
#include "debug.h"
#include "../defs.h"

/*****************************
** 安全级
*/
int initPageFirewall(int eid, request *wp, int argc, char **argv)
{
	//防火墙等级:
	unsigned char 	filterLevel = 0;	// 0- 低;  1- 中;  2- 高
	int				lineno = __LINE__;

	_TRACE_CALL;

	if (!mib_get_s(MIB_FW_GRADE, (void *)&filterLevel, sizeof(filterLevel))) {
		printf("get fw grade fail\n");
	}

	_PUT_INT(filterLevel);

check_err:
	_TRACE_LEAVEL;
	return 0;
}

void formFirewall(request * wp, char *path, char *query)
{
	//防火墙等级:
	unsigned char 	filterLevel;	//0- 低;  1- 中;  2- 高
	char*			stemp = "";
	int				lineno = __LINE__;

	_TRACE_CALL;
#ifdef CONFIG_CMCC_ENTERPRISE
	 unsigned char FirewallEn;
	_GET_BOOL(FirewallEn, _NEED);
	if (!mib_set(MIB_FW_ENABLE, (void *)&FirewallEn)) {
		printf("set firewall enable fail\n");
		goto check_err;
	}
#endif

	_GET_INT(filterLevel, _NEED);
	if(filterLevel > FW_HIGH)	// out of range
	{
		lineno = __LINE__; goto check_err;
	}

	if (!mib_set(MIB_FW_GRADE, (void *)&filterLevel)) {
		printf("set firewall grade fail\n");
		goto check_err;
	}
#ifdef NEW_ENTERPRISE_FIREWALLLEVEL
	unsigned int dos_enable=0;
	unsigned char psdEnble = 0;
	if(filterLevel == FW_HIGH)
	{
		dos_enable = DOS_ENABLE;
		psdEnble = 1;
	}
	else if ( filterLevel == FW_MIDDLE )
	{
		dos_enable = 0;
		psdEnble = 1;
	}
	else
	{
		dos_enable = 0;
		psdEnble = 0;
	}

	if (!mib_set(MIB_DOS_ENABLED, (void *)&dos_enable)) {
		printf("set DOS failed!\n");
		goto check_err;
	}

	if (!mib_set(MIB_PSD_ENABLE, (void *)&psdEnble)) {
		printf("set Port Scan failed!\n");
		goto check_err;
	}
#else
#ifdef DOS_SUPPORT
	unsigned int dosEnble, lastStatus;

	if (!mib_get_s(MIB_DOS_ENABLED, (void *)&dosEnble, sizeof(dosEnble))) {
		printf("get DOS fail\n");
	}
	lastStatus = dosEnble;

	if ( dosEnble & DOS_ENABLE )
		dosEnble = DOS_ENABLE;
	else
		dosEnble = 0;

	if(filterLevel == FW_HIGH)
	{
		dosEnble |= CMCC_FIREWARE_LEVEL_HIGH;
		dosEnble |= CMCC_FIREWARE_LEVEL_MIDDLE;
		dosEnble |= CMCC_FIREWARE_LEVEL_LOW;
	}
	else if ( filterLevel == FW_MIDDLE )
	{
		dosEnble |= CMCC_FIREWARE_LEVEL_MIDDLE;
		dosEnble |= CMCC_FIREWARE_LEVEL_LOW;
	}
	else
	{
		dosEnble |= CMCC_FIREWARE_LEVEL_LOW;
	}
	if (!mib_set(MIB_DOS_ENABLED, (void *)&dosEnble)) {
		printf("set DOS failed!\n");
		goto check_err;
	}	
	if(filterLevel == FW_HIGH)
		syslog(LOG_CRIT, "Firewall, change level: High" );	
	else if(filterLevel == FW_MIDDLE)
		syslog(LOG_CRIT, "Firewall, change level: Middle" );
	else
		syslog(LOG_CRIT, "Firewall, change level: Low" );
#endif
	//write to flash
	mib_update(CURRENT_SETTING, CONFIG_MIB_ALL);

	//take effect
#ifdef CONFIG_CMCC_ENTERPRISE
	changeFwGrade(FirewallEn, filterLevel);
#else
	changeFwGrade(1, filterLevel);
#endif
	//DOS take effect
	if (lastStatus != dosEnble) {		
		setup_dos_protection(); 
	}
#endif //DOS_SUPPORT

	_COND_REDIRECT;
check_err:
	_TRACE_LEAVEL;
	return;
}

/*****************************
** 攻击保护设置
*/
int initPageDos(int eid, request *wp, int argc, char **argv)
{
	//使能:
	unsigned int		dosEnble;	// 1- 使能;  0- 禁用
	int				lineno = __LINE__;

	_TRACE_CALL;

	if (!mib_get_s(MIB_DOS_ENABLED, (void *)&dosEnble, sizeof(dosEnble))) {
		printf("get DOS fail\n");
	}

	dosEnble = (dosEnble&DOS_ENABLE) ? 1:0;

	_PUT_BOOL(dosEnble);

check_err:
	_TRACE_LEAVEL;
	return 0;
}

void formDos(request * wp, char *path, char *query)
{
	//使能:
	unsigned int		dosEnble, portScanEnble;	//1- 使能;  0- 禁用
	char*			stemp = "";
	unsigned int lastStatus;
	unsigned char psdEnble = 0;
	int				lineno = __LINE__;
#ifdef CONFIG_CMCC_ENTERPRISE
	unsigned int ArpCheatEn = 0,ArpfloodingEn = 0;
#endif

	_TRACE_CALL;

	_GET_BOOL(dosEnble, _NEED);
	_GET_BOOL(portScanEnble, _NEED);

#ifdef DOS_SUPPORT
	if (!mib_get_s(MIB_DOS_ENABLED, (void *)&lastStatus, sizeof(lastStatus)))
		printf("get DOS failed!\n");

	lastStatus = lastStatus & (0xFFFFFE);
	dosEnble |= lastStatus;

	if((dosEnble & DOS_ENABLE) && (lastStatus == 0))
		dosEnble = DOS_ENABLE_ALL;
	
	if (!mib_set(MIB_DOS_ENABLED, (void *)&dosEnble)) {
		printf("set DOS failed!\n");
		goto check_err;
	}
	
	syslog(LOG_CRIT, "DoS is %s.", dosEnble & 0x1 ? "enabled": "disabled");

	//write to flash
	mib_update(CURRENT_SETTING, CONFIG_MIB_ALL);

	//take effect
	setup_dos_protection();
#endif //DOS_SUPPORT
#ifdef CONFIG_NETFILTER_XT_MATCH_PSD
	   if (!mib_get_s(MIB_PSD_ENABLE, (void *)&psdEnble, sizeof(psdEnble)))
			   printf("get Port Scan enable failed!\n");

	   if ( portScanEnble != psdEnble)
	   {
		   psdEnble=portScanEnble;
		   if (!mib_set(MIB_PSD_ENABLE, (void *)&psdEnble)) {
			   printf("set Port Scan enable failed!\n");
			   goto check_err;
		   }
		   syslog(LOG_CRIT, "Port Scan enable is %s.", portScanEnble & 0x1 ? "enabled": "disabled");
		   //write to flash
		   mib_update(CURRENT_SETTING, CONFIG_MIB_ALL);
		   //take effect
		   setup_psd();
	   }
#endif
#ifdef CONFIG_CMCC_ENTERPRISE
	_GET_BOOL(psdEnble, _NEED);
	if (!mib_set(MIB_PSD_ENABLE, (void *)&psdEnble)) {
		printf("set Port Scan failed!\n");
		goto check_err;
	}
	setup_psd();
	_GET_BOOL(ArpCheatEn, _NEED);
	if (!mib_set(MIB_ARP_CHEAT_ENABLED, (void *)&ArpCheatEn)) {
		printf("set ArpCheatEn failed!\n");
		goto check_err;
	}
	_GET_BOOL(ArpfloodingEn, _NEED);
	if (!mib_set(MIB_ARP_FLOODING_ENABLED, (void *)&ArpfloodingEn)) {
		printf("set ArpfloodingEn failed!\n");
		goto check_err;
	}
#endif

	_COND_REDIRECT;
check_err:
	_TRACE_LEAVEL;
	return;
}

void formIpv6SessionFw(request * wp, char *path, char *query)
{
	unsigned char ipv6SessionFwEnble;
	char* stemp = "";
	unsigned int lastStatus;
	int lineno = __LINE__;

	_TRACE_CALL;

	_GET_BOOL(ipv6SessionFwEnble, _NEED);
	
	if (!mib_set(MIB_V6_SESSION_FW_ENABLE, (void *)&ipv6SessionFwEnble)) {
		printf("set IPv6 session Firewall failed!\n");
		goto check_err;
	}
	syslog(LOG_CRIT, "IPv6 session Firewall is %s.", ipv6SessionFwEnble & 0x1 ? "enabled": "disabled");

	//write to flash
	mib_update(CURRENT_SETTING, CONFIG_MIB_ALL);

	//take effect
	restart_IPV6Filter();

	_COND_REDIRECT;
check_err:
	_TRACE_LEAVEL;
	return;
}

int brgMacFilterList(int eid, request *wp, int argc, char **argv)
{
	unsigned char 		macFilterEnble = 1;
	unsigned char 		macFilterMode = 0;
	//struct brgmac_entry	entry = {1, 0, 0, 1, 0,"00-11-22-33-44-55", "11-11-22-33-44-55" };
	char ifname[1024] = "INTERNET_R_0_0_32";
	int cnt = 2;
	int index = 0;
	int lineno = __LINE__;
	int i;
	char entry_lost;

	_TRACE_CALL;

	/************Place your code here, do what you want to do! ************/
	cnt=mib_chain_total(MIB_MAC_FILTER_EBTABLES_TBL);
	mib_get_s(MIB_MAC_FILTER_EBTABLES_ENABLE, &macFilterEnble, sizeof(macFilterEnble));
	mib_get_s(MIB_MAC_FILTER_EBTABLES_MODE, &macFilterMode, sizeof(macFilterMode));
	/************Place your code here, do what you want to do! ************/

	_PUT_BOOL(macFilterEnble);
	_PUT_BOOL(macFilterMode);
	for(index = cnt - 1; index >= 0; index--)
	{
		memset(ifname, 0, sizeof(ifname));
		entry_lost = 0;

		/************Place your code here, do what you want to do! ************/
		struct brgmac_entry entry;
		mib_chain_get(MIB_MAC_FILTER_EBTABLES_TBL, index, &entry);

		for(i=0;i<entry.portNum;i++)
		{
			char name[MAX_WAN_NAME_LEN]={0};
			MIB_CE_ATM_VC_T pvc_entry;
			{
				if(getWanEntrybyindex(&pvc_entry, entry.ifIndex[i]|0xff00) == -1)
				{
					printf("%s:%d: This entry is not found, deleting...\n", __FILE__, __LINE__);
					mib_chain_delete(MIB_MAC_FILTER_EBTABLES_TBL, index);
					entry_lost = 1;
					break;
				}

				if(getWanName(&pvc_entry, name) != 1)
					printf("%s:%d: Get Wan name failed!\n", __FILE__, __LINE__);

				strcat(ifname,name);
				if(i!=entry.portNum-1)
					strcat(ifname,"/");
			}
		}

		if(entry_lost)
			continue;

		changeMacFormat(entry.dmac,':','-');
		changeMacFormat(entry.smac,':','-');
		/************Place your code here, do what you want to do! ************/

		boaWrite(wp, "push(new it_nr(\"%d\"" _PTS _PTS _PTI _PTI _PTI _PTI _PTS "));\n",
			index, _PME(dmac), _PME(smac), _PME(protoType), _PME(direction),
			_PME(allPort), _PME(portNum), "ifname",ifname);
	}

check_err:
	_TRACE_LEAVEL;
	return 0;
}

void formBrgMacFilter(request * wp, char *path, char *query)
{
	unsigned char macFilterEnble = 0;
	unsigned char macFilterMode = 0;
	MIB_CE_BRGMAC_T entry;
	MIB_CE_BRGMAC_T curEntry;
	char ifname[1024];
	char *stemp = "";
	char *send = NULL;
	char * stoken = NULL;
	int index = 0;
	int lineno = __LINE__;
	int entrynum, i;
	_BC_USE;
	memset(&entry,0,sizeof(struct brgmac_entry));
	FETCH_INVALID_OPT(stemp, "action", _NEED);
	if(strcmp(stemp, "sw") == 0)	//switch
	{
		_GET_BOOL(macFilterEnble, _NEED);
		/************Place your code here, do what you want to do! ************/
		printf("macFilterEnble=%d\n",macFilterEnble);
		mib_set(MIB_MAC_FILTER_EBTABLES_ENABLE,&macFilterEnble);
		//macFilterMode=0;//default is black list
		//mib_set(MIB_MAC_FILTER_EBTABLES_MODE,&macFilterMode);
		/************Place your code here, do what you want to do! ************/
	}else if(strcmp(stemp,"modesw")==0){
		_GET_BOOL(macFilterMode, _NEED);
		mib_chain_clear(MIB_MAC_FILTER_EBTABLES_TBL);
		mib_set(MIB_MAC_FILTER_EBTABLES_MODE,&macFilterMode);
	}
	else if(strcmp(stemp, "rm") == 0)	//remove
	{
		_BC_INIT("bcdata");
		while(_BC_NEXT())
		{
			memset(ifname, 0, sizeof(ifname));

			_BC_ENTRY_STR(dmac, _OPT);
			_BC_ENTRY_STR(smac, _OPT);
			_BC_ENTRY_INT(protoType, _OPT);
			_BC_ENTRY_INT(direction, _OPT);
			_BC_ENTRY_INT(allPort, _OPT);
			_BC_ENTRY_INT(portNum, _OPT);

			/************Place your code here, do what you want to do! ************/
			/*remove*/
			char *itf;
			itf=(char *)bc_gets(bc, "ifname");
			if(itf)
				strncpy(ifname, itf, sizeof(ifname));
			stoken = &ifname[0];
			if (stoken) send = strchr(stoken, '/');
			index = 0;
			while(stoken && index < entry.portNum)
			{
				if(send)*send = '\0';

				//ppifs[index] = stoken;
				entry.ifIndex[index]=getifIndexByWanName(stoken);
				printf("entry[%d]=%d\n",index,entry.ifIndex[index]);
				if(send == NULL)break;
				stoken = send + 1;
				send = strchr(stoken, '/');
				index++;
			}
			/************Place your code here, do what you want to do! ************/
			int t=0;
			char *bugentry=(char*)&entry;
			changeMacFormat(entry.smac,'-',':');
			changeMacFormat(entry.dmac,'-',':');
			MIB_CHAIN_DELETE(MIB_MAC_FILTER_EBTABLES_TBL, struct brgmac_entry, entry)
		}
	}
	else if(strcmp(stemp, "ad") == 0)	//add
	{
		memset(ifname, 0, sizeof(ifname));
		if(mib_chain_total(MIB_MAC_FILTER_EBTABLES_TBL)>=MAC_FILTER_BRIDGE_RULES)
		{
			ERR_MSG("对不起,规则数已达最大限制!");
			goto check_err;
		}
		_ENTRY_STR(dmac, _OPT);
		_ENTRY_STR(smac, _OPT);
		_ENTRY_INT(protoType, _OPT);
		if(entry.protoType > 7) {lineno = __LINE__; goto check_err;}
		_ENTRY_INT(direction, _OPT);
		if(entry.direction > 2) {lineno = __LINE__; goto check_err;}
		_ENTRY_INT(allPort, _OPT);
		if(entry.allPort > 1) {lineno = __LINE__; goto check_err;}
		if(!entry.allPort)
		{
			_ENTRY_INT(portNum, _NEED);
			FETCH_INVALID_OPT(stemp, "ifname", _OPT);
			strncpy(ifname, stemp, sizeof(ifname));
			ifname[sizeof(ifname)-1] = '\0';
			//if(ppifs) {free(ppifs); ppifs = NULL;}
			//ppifs = (char**)malloc((entry.portNum + 1) * sizeof(char*));
			stoken = &ifname[0];
			if (stoken) send = strchr(stoken, ';');
			index = 0;
			while(stoken && index < entry.portNum)
			{
				if(send)*send = '\0';

				//ppifs[index] = stoken;
				entry.ifIndex[index]=atoi(stoken);
				printf("ifIndex[%d]=%d\n", index, entry.ifIndex[index]);
				if(send == NULL) break;
				stoken = send + 1;
				send = strchr(stoken, ';');
				index++;
			}
		}

		/************Place your code here, do what you want to do! ************/
		//fix the mac format form xx-xx-xx-xx-xx-xx to xx:xx:xx:xx:xx
		changeMacFormat(entry.smac,'-',':');
		changeMacFormat(entry.dmac,'-',':');

		entrynum = mib_chain_total(MIB_MAC_FILTER_EBTABLES_TBL);
		for( i = 0; i < entrynum; i++ )
		{
			if(!mib_chain_get(MIB_MAC_FILTER_EBTABLES_TBL, i, (void *)&curEntry))
				continue;

			if(!strcmp(entry.smac, curEntry.smac) && !strcmp(entry.dmac, curEntry.dmac) && entry.protoType == curEntry.protoType &&
				entry.direction == curEntry.direction && !memcmp(entry.ifIndex, curEntry.ifIndex, 8*sizeof(int)))
				goto Dup_ERR;
		}

		mib_chain_add(MIB_MAC_FILTER_EBTABLES_TBL, &entry);
		/************Place your code here, do what you want to do! ************/
	}
	else {lineno = __LINE__; goto check_err;}

	restart_IPFilter_DMZ_MACFilter();

	mib_update(CURRENT_SETTING, CONFIG_MIB_ALL);
	_COND_REDIRECT;
check_err:
	_BC_FREE();
	_TRACE_LEAVEL;
	return;
Dup_ERR:
	_BC_FREE();
	_TRACE_LEAVEL;
	ERR_MSG("This rule already existed!");
	return;
}

int initPageMacFilter(int eid, request * wp, int argc, char ** argv)
{
	char *name;
   	if (boaArgs(argc, argv, "%s", &name) < 1) {
   		boaError(wp, 400, "Insufficient args\n");
   		return -1;
   	}
	if ( !strcmp(name, "table_cell") ) {
#ifdef MAC_FILTER_BLOCKTIMES_SUPPORT
		boaWrite(wp, "cell = row.insertCell(j++);"
		"cell.innerHTML = rules[i].enable?\"enable\":\"disable\";");
#endif
	}
	else if ( !strcmp(name, "table_title") ) {
#ifdef MAC_FILTER_BLOCKTIMES_SUPPORT
		boaWrite(wp,  "<td width=\"100px\">使能</td>");
#endif
	}
	else if ( !strcmp(name, "edit_items") ) {
#ifdef MAC_FILTER_BLOCKTIMES_SUPPORT
		boaWrite(wp, "form.enable.value = rules[index].enable?\"on\":\"off\";");
#endif
	}
	else if ( !strcmp(name, "add_items") ) {
#ifdef MAC_FILTER_BLOCKTIMES_SUPPORT
		boaWrite(wp, "<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\">\n"
				"<tr>"
					"<td width=\"100\">使能&nbsp</td>\n"
					"<td><input type=\"radio\" name=\"enable\" value=\"on\" checked >&nbsp;&nbsp;enable</td>\n"
					"<td><input type=\"radio\" name=\"enable\" value=\"off\" >&nbsp;&nbsp;disable</td>\n"
				"</tr>"
			"</table>");
#endif
	}
	return 0;
}


/*****************************
** 路由MAC过滤
*/
#if defined(CONFIG_CMCC) || defined(CONFIG_CU_BASEON_CMCC)
int rteMacFilterList(int eid, request * wp, int argc, char ** argv)
{
	unsigned char macFilterEnble = 0; // 0-off, 1-on
	unsigned char macFilterMode = 0; // 0-black list, 1-white list
	unsigned char macCap = 0; // bit 1: macFilterEnble, bit 2: macFilterMode
	struct routemac_entry   entry = {"00-11-22-33-44-55", "INTERNET_R_0_0_32"};
	int cnt = 2;
	int index = 0;
	int lineno = __LINE__;
	int Num=0, Modeflag = 0;
#ifdef SUPPORT_TIME_SCHEDULE
	MIB_CE_TIME_SCHEDULE_T schdEntry;
#endif

	_TRACE_CALL;
	mib_get_s(MIB_MAC_FILTER_SRC_ENABLE, &macCap, sizeof(macCap));
	switch(macCap)
	{
		case 2:
			macFilterMode = 1; 
		case 1:
			macFilterEnble = 1; 
			break;
	}
	_PUT_BOOL(macFilterEnble);
	_PUT_INT(macFilterMode);
#ifdef CONFIG_CMCC_ENTERPRISE
	_PUT_INT(Modeflag);
	Num = cnt;
	_PUT_INT(Num);
#endif
	cnt = mib_chain_total(MIB_MAC_FILTER_ROUTER_TBL);
	for (index = 0; index < cnt; index++)
	{
		memset(&entry, 0, sizeof(struct routemac_entry));
		mib_chain_get(MIB_MAC_FILTER_ROUTER_TBL, index, &entry);
		//changeMacFormat(entry.mac,':','-');
#ifdef SUPPORT_TIME_SCHEDULE
		if(entry.schedIndex >= 1)
		{
			if (!mib_chain_get(MIB_TIME_SCHEDULE_TBL, entry.schedIndex-1, (void *)&schdEntry))
				continue;

			boaWrite(wp, "push(new it_nr(\"%d\"" _PTS_XSS _PTS_XSS _PTI _PTS_XSS _PTI"));\n", 
			index, _PME_XSS(name), _PME_XSS(mac), _PME(mode), "Schedule", schdEntry.name,  "ScheduleIdex", entry.schedIndex);
		}
		else
		{
			boaWrite(wp, "push(new it_nr(\"%d\"" _PTS_XSS _PTS_XSS _PTI _PTS_XSS  _PTI"));\n",
			index, _PME_XSS(name), _PME_XSS(mac), _PME(mode), "Schedule", multilang(LANG_SCHEDULE_EFFECTIVE), "ScheduleIdex", entry.schedIndex);
		}
#else
		boaWrite(wp, "push(new it_nr(\"%d\"" _PTS_XSS _PTS_XSS _PTI "));\n", index, _PME_XSS(name), _PME_XSS(mac), _PME(mode));
#endif
	}
	_TRACE_LEAVEL;
	return 0;
}
#else
int rteMacFilterList(int eid, request * wp, int argc, char ** argv)
{
	unsigned char macFilterEnble;
	struct routemac_entry	entry = {"00-11-22-33-44-55", "INTERNET_R_0_0_32"};
	int cnt = 2;
	int index = 0;
	int lineno = __LINE__;
#ifdef MAC_FILTER_SRC_WHITELIST
	unsigned char macFilterMode = 0;
	unsigned char whitelistenable = 0;
	mib_get_s(PROVINCE_MAC_FILTER_SRC_WHITELIST, &whitelistenable, sizeof(whitelistenable));
#endif

	_TRACE_CALL;

	mib_get_s(MIB_MAC_FILTER_SRC_ENABLE, &macFilterEnble, sizeof(macFilterEnble));
#ifdef MAC_FILTER_SRC_WHITELIST
	if(whitelistenable){
		if(macFilterEnble==3){//when black and white both set, only blacklist enable
			macFilterEnble = 1;
			macFilterMode = 0;
		}
		else if(macFilterEnble==2){
			macFilterEnble = 1;
			macFilterMode = 1;
	}
		if(macFilterEnble)
	_PUT_INT(macFilterMode);
	}
#endif
	_PUT_BOOL(macFilterEnble);

	if(macFilterEnble){
		/************Place your code here, do what you want to do! ************/
		cnt=mib_chain_total(MIB_MAC_FILTER_ROUTER_TBL);
		/************Place your code here, do what you want to do! ************/

		for(index = 0; index < cnt; index++)
		{
			/************Place your code here, do what you want to do! ************/
			memset(&entry,0,sizeof(struct routemac_entry));
			mib_chain_get(MIB_MAC_FILTER_ROUTER_TBL,index,&entry);
#ifdef CONFIG_E8B
#ifdef CONFIG_YUEME
			rtk_mac_filter_get_drop_pkt_count(entry.mac);
#endif
#endif
			/************Place your code here, do what you want to do! ************/
			changeMacFormat(entry.mac,':','-');
#ifdef MAC_FILTER_SRC_WHITELIST
			if(whitelistenable)
			{
				if(entry.mode == macFilterMode)
#ifdef MAC_FILTER_BLOCKTIMES_SUPPORT
					boaWrite(wp, "push(new it_nr(\"%d\"" _PTS _PTS _PTI  _PTI _PTI"));\n",
						index, _PME(devname), _PME(mac), _PME(enable), _PME(mode), _PME(instnum));
#else
					boaWrite(wp, "push(new it_nr(\"%d\"" _PTS _PTS _PTI"));\n",
						index, _PME(devname), _PME(mac), _PME(mode));
#endif
			}				
			else
				if(entry.mode == 1)//do not show white list entry
					continue;
				else
#endif
#ifdef MAC_FILTER_BLOCKTIMES_SUPPORT
						boaWrite(wp, "push(new it_nr(\"%d\"" _PTS_XSS _PTS_XSS _PTI _PTI"));\n",
										index, _PME_XSS(devname), _PME_XSS(mac), _PME(enable), _PME(instnum));
#else
						boaWrite(wp, "push(new it_nr(\"%d\"" _PTS _PTS "));\n",
							index, _PME(devname), _PME(mac));
#endif
		}
	}
	_TRACE_LEAVEL;
	return 0;
}
#endif

#if defined(CONFIG_CMCC) || defined(CONFIG_CU_BASEON_CMCC)
void formRteMacFilter(request *wp, char *path, char *query)
{
	struct routemac_entry	entry;
	char *stemp = "";
	int index = 0;
	int lineno = __LINE__;
	unsigned char 		macFilterEnble = 0;
	int cnt = 0;
	unsigned char macFilterMode = 0; // 0-black list, 1-white list
	unsigned char macCap = 0; // 0-off, 1-black list, 2-white list
	
	_BC_USE;

	_TRACE_CALL;
	if (wp->method == M_GET)
	{
		goto check_err;
	}
	FETCH_INVALID_OPT(stemp, "action", _NEED);

	if(strcmp(stemp, "sw") == 0)	//switch
	{
		_GET_BOOL(macFilterEnble, _NEED);
		_GET_BOOL(macFilterMode, _NEED);
		printf("macFilterEnble = %d, macFilterMode = %d\n", macFilterEnble, macFilterMode);

		if (macFilterEnble) {
			macFilterEnble += macFilterMode;
		}

		macCap = macFilterEnble;
		printf("macCap = %d\n", macCap);
		mib_set(MIB_MAC_FILTER_SRC_ENABLE, &macCap);

		if(macCap==1)
		{
			if(macFilterMode==0)
				syslog(LOG_CRIT, "MAC Filter, open mac filter. (blacklist)");
			else if(macFilterMode==1)
				syslog(LOG_CRIT, "MAC Filter, open mac filter. (whitelist)");
		}
		else if(macCap==0)
			syslog(LOG_CRIT, "MAC Filter, close mac filter.");


		
		cnt = mib_chain_total(MIB_MAC_FILTER_ROUTER_TBL);
		for (index = 0; index < cnt; index++)
		{
			memset(&entry, 0, sizeof(struct routemac_entry));
			mib_chain_get(MIB_MAC_FILTER_ROUTER_TBL, index, &entry);

			entry.mode = macFilterMode;
			mib_chain_update(MIB_MAC_FILTER_ROUTER_TBL, (void *)&entry, index);
		}	
	}
	else if(strcmp(stemp, "rm") == 0)	//remove
	{
#ifdef CONFIG_CMCC
		unsigned int MAX_DEL_NUM=30, INPUTSTR_MAX_LENGTH=512, MAX_NAME_LENGTH=32, i=0, commaNum=0;
		unsigned char name[INPUTSTR_MAX_LENGTH], SubName[MAX_DEL_NUM][MAX_NAME_LENGTH], 
			      mac[INPUTSTR_MAX_LENGTH], SubMac[MAX_DEL_NUM][MAX_NAME_LENGTH],
			      mode[INPUTSTR_MAX_LENGTH], SubMode[MAX_DEL_NUM][MAX_NAME_LENGTH];
		
		memset((void *)SubName, 0, sizeof(unsigned char)*MAX_DEL_NUM*MAX_NAME_LENGTH);
		memset((void *)SubMac, 0, sizeof(unsigned char)*MAX_DEL_NUM*MAX_NAME_LENGTH);
		memset((void *)SubMode, 0, sizeof(unsigned char)*MAX_DEL_NUM*MAX_NAME_LENGTH);
		strcpy(name, boaGetVar(wp, "sel_name", ""));
		strcpy(mac, boaGetVar(wp, "sel_mac", ""));
		strcpy(mode, boaGetVar(wp, "sel_mode", ""));
		rtk_web_get_commanum_substr(&commaNum, name, SubName);
		rtk_web_get_commanum_substr(&commaNum, mac, SubMac);
		rtk_web_get_commanum_substr(&commaNum, mode, SubMode);
		if (mac[0] && mode[0])
		{
			for(i=0; i<commaNum+1; i++)
			{
				memset(&entry, 0, sizeof(struct routemac_entry));
				//strcpy(entry.name, SubName[i]);
				entry.name[sizeof(entry.name)-1]='\0';
				strncpy(entry.name, SubName[i], sizeof(entry.name)-1);
				//strcpy(entry.mac, SubMac[i]);
				entry.mac[sizeof(entry.mac)-1]='\0';
				strncpy(entry.mac, SubMac[i], sizeof(entry.mac)-1);
				changeMacFormat(entry.mac,'-',':');
				entry.mode=atoi(SubMode[i]);
				
				/*remove*/
				if(entry.mode==0)
					syslog(LOG_CRIT, "MAC Filter, delete blacklist - name=%s MAC=%s", entry.name, entry.mac);
				else if(entry.mode==1)
					syslog(LOG_CRIT, "MAC Filter, delete whitelist - name=%s MAC=%s", entry.name, entry.mac);

				MIB_CHAIN_DELETE_CHT(MIB_MAC_FILTER_ROUTER_TBL, struct routemac_entry, entry);
			}
		}
		else 
			return;
#else
		_BC_INIT("bcdata");
		while(_BC_NEXT())
		{
			memset(&entry, 0, sizeof(struct routemac_entry));
			_BC_ENTRY_STR(name, _OPT);
			_BC_ENTRY_STR(mac, _OPT);
			_BC_ENTRY_INT(mode, _OPT);
			changeMacFormat(entry.mac,'-',':');
			/************Place your code here, do what you want to do! ************/
			/*remove*/
			if(entry.mode==0)
				syslog(LOG_CRIT, "MAC Filter, delete blacklist - name=%s MAC=%s", entry.name, entry.mac);
			else if(entry.mode==1)
				syslog(LOG_CRIT, "MAC Filter, delete whitelist - name=%s MAC=%s", entry.name, entry.mac);
			MIB_CHAIN_DELETE(MIB_MAC_FILTER_ROUTER_TBL,struct routemac_entry,entry);
			/************Place your code here, do what you want to do! ************/
		}
#endif
	}
	else if(strcmp(stemp, "ad") == 0)	//add
	{
		if(mib_chain_total(MIB_MAC_FILTER_ROUTER_TBL)>=MAC_FILTER_ROUTER_RULES)
		{
			ERR_MSG("对不起,规则数已达最大限制!");
			goto check_err;
		}
		memset(&entry, 0, sizeof(struct routemac_entry));
		//_ENTRY_STR(devname, _NEED);
		_ENTRY_STR(mac, _NEED);
		_ENTRY_STR(name, _NEED);
		
		// Check XSS attack
		if(!isValidMacString(entry.mac)){
			printf("%s:%d String %s contains invalid words!\n",__FUNCTION__,__LINE__,entry.mac);
			ERR_MSG("invalid string!");
			goto check_err;
		}
		
		mib_get_s(MIB_MAC_FILTER_SRC_ENABLE, &macCap, sizeof(macCap));
		if(macCap > 0)
			entry.mode = macCap -1;
		//_ENTRY_BOOL(mode, _NEED);
		//AUG_PRT("add new mode=%d mac=%s\n",entry.mode,entry.mac);
		if(entry.name[0]!='\0')
			AUG_PRT("add new mode=%d name=%s mac=%s\n", entry.mode,entry.name,entry.mac);
		else
			AUG_PRT("add new mode=%d name= mac=%s\n", entry.mode, entry.mac);
		changeMacFormat(entry.mac, '-', ':');
		mib_chain_add(MIB_MAC_FILTER_ROUTER_TBL,&entry);
		if(entry.mode==0)
			syslog(LOG_CRIT, "MAC Filter, add blacklist - name=%s mac=%s", entry.name, entry.mac);
		else if(entry.mode==1)
			syslog(LOG_CRIT, "MAC Filter, add whitelist - name=%s mac=%s", entry.name, entry.mac);
	}
	else {lineno = __LINE__; goto check_err;}

	restart_IPFilter_DMZ_MACFilter();

	mib_update(CURRENT_SETTING, CONFIG_MIB_ALL);
	_COND_REDIRECT;
check_err:
	_BC_FREE();
	_TRACE_LEAVEL;
	return;
}
#else
void formRteMacFilter(request *wp, char *path, char *query)
{
	struct routemac_entry	entry, Entry;
	char *stemp = "";
	int index = 0;
	int i = 0,totalNum = 0;
	int lineno = __LINE__;
	unsigned char 		macFilterEnble = 0;
#ifdef MAC_FILTER_SRC_WHITELIST
	int cnt = 0;
	unsigned char macFilterMode = 0; // 0-black list, 1-white list
	unsigned char whitelistenable = 0;
	unsigned char enable = 0;
	char *devname;
	unsigned int blocktimes = 0;
	unsigned char instnum[MAC_FILTER_ROUTER_RULES+1] = {0};
	int entryTotal = 0;
	mib_get_s(PROVINCE_MAC_FILTER_SRC_WHITELIST, &whitelistenable, sizeof(whitelistenable));
#endif
	_BC_USE;

	_TRACE_CALL;
	if (wp->method == M_GET)
	{
		goto check_err;
	}
	FETCH_INVALID_OPT(stemp, "action", _NEED);

	if(strcmp(stemp, "sw") == 0)	//switch
	{
		_GET_BOOL(macFilterEnble, _NEED);
		mib_set(MIB_MAC_FILTER_SRC_ENABLE,&macFilterEnble);
	}
#ifdef MAC_FILTER_SRC_WHITELIST
	else if(strcmp(stemp, "mode") == 0) //change mode
	{
		if(!whitelistenable)
			{lineno = __LINE__; goto check_err;}
		_GET_BOOL(macFilterEnble, _NEED);
		_GET_BOOL(macFilterMode, _NEED);
		printf("macFilterEnble = %d, macFilterMode = %d\n", macFilterEnble, macFilterMode);
		if (macFilterEnble) {
			macFilterEnble += macFilterMode;
		mib_set(MIB_MAC_FILTER_SRC_ENABLE,&macFilterEnble);
			if(macFilterMode==0)
				syslog(LOG_CRIT, "MAC Filter, open mac filter. (blacklist)");
			else if(macFilterMode==1)
				syslog(LOG_CRIT, "MAC Filter, open mac filter. (whitelist)");
		}
		else if(macFilterEnble==0)
			syslog(LOG_CRIT, "MAC Filter, close mac filter.");
#if 0			
		cnt = mib_chain_total(MIB_MAC_FILTER_ROUTER_TBL);
		for (index = 0; index < cnt; index++)
		{
			memset(&entry, 0, sizeof(struct routemac_entry));
			mib_chain_get(MIB_MAC_FILTER_ROUTER_TBL, index, &entry);

			entry.mode = macFilterMode;
			mib_chain_update(MIB_MAC_FILTER_ROUTER_TBL, (void *)&entry, index);
		}	
#endif
	}
#endif
	else if(strcmp(stemp, "rm") == 0)	//remove
	{
		_BC_INIT("bcdata");
		while(_BC_NEXT())
		{
			memset(&entry, 0, sizeof(struct routemac_entry));

			_BC_ENTRY_STR(devname, _OPT);
			_BC_ENTRY_STR(mac, _OPT);
			_GET_BOOL(macFilterMode, _OPT);
			entry.mode = macFilterMode;
			changeMacFormat(entry.mac,'-',':');
			/************Place your code here, do what you want to do! ************/
			/*remove*/
#ifdef MAC_FILTER_BLOCKTIMES_SUPPORT
			_BC_ENTRY_INT(enable, _OPT);
			_BC_ENTRY_INT(instnum, _OPT);
#endif
			totalNum = mib_chain_total(MIB_MAC_FILTER_ROUTER_TBL);
			for(i = 0;i < totalNum;i++)
			{
				mib_chain_get(MIB_MAC_FILTER_ROUTER_TBL, i, (void *)&Entry);
				if(!strncmp(Entry.mac,entry.mac,sizeof(Entry.mac)) && !strncmp(Entry.devname,entry.devname,sizeof(Entry.devname)))
				{
					mib_chain_delete(MIB_MAC_FILTER_ROUTER_TBL, i);
					break;
				}
			}
			
			//MIB_CHAIN_DELETE(MIB_MAC_FILTER_ROUTER_TBL,struct routemac_entry,entry);
			/************Place your code here, do what you want to do! ************/
		}
	}
	else if(strcmp(stemp, "up") == 0)	//update
	{
		int i;
		entryTotal = mib_chain_total(MIB_MAC_FILTER_ROUTER_TBL);
		memset(&entry, 0, sizeof(struct routemac_entry));

		_ENTRY_STR(devname, _NEED);
		_ENTRY_STR(mac, _NEED);
		changeMacFormat(entry.mac,'-',':');
		
		// Check XSS attack
		if(!isValidMacString(entry.mac)){
			printf("%s:%d String %s contains invalid words!\n",__FUNCTION__,__LINE__,entry.mac);
			ERR_MSG("invalid string!");
			goto check_err;
		}
#ifdef MAC_FILTER_SRC_WHITELIST
		_GET_BOOL(macFilterMode, _NEED);
		entry.mode = macFilterMode;		
#ifdef MAC_FILTER_BLOCKTIMES_SUPPORT
		_GET_BOOL(enable, _NEED);
		entry.enable = enable;
#endif
		index = atoi(boaGetVar(wp,"index",""));
		for(i = 0;i < entryTotal;i++)//find index
		{
			mib_chain_get(MIB_MAC_FILTER_ROUTER_TBL, i, (void *)&Entry);
			if(Entry.mode == macFilterMode)
			{
				if(index==0)
				{
					index  = i;
					break;
				}
				index--;
			}
		}
#ifdef MAC_FILTER_BLOCKTIMES_SUPPORT
		mib_chain_get(MIB_MAC_FILTER_ROUTER_TBL, index, (void *)&Entry);
		entry.instnum = Entry.instnum;
#endif
#endif
		entry.access_level = Entry.access_level;
		mib_chain_update(MIB_MAC_FILTER_ROUTER_TBL, (void *)&entry, index);
	}
	else if(strcmp(stemp, "ad") == 0)	//add
	{
		entryTotal = mib_chain_total(MIB_MAC_FILTER_ROUTER_TBL);
		if(entryTotal >= MAC_FILTER_ROUTER_RULES)
		{
			ERR_MSG("对不起,规则数已达最大限制!");
			goto check_err;
		}
		memset(&entry, 0, sizeof(struct routemac_entry));

		_ENTRY_STR(devname, _NEED);
		_ENTRY_STR(mac, _NEED);
		changeMacFormat(entry.mac,'-',':');
		/************Place your code here, do what you want to do! ************/
		// Check XSS attack
		if(!isValidMacString(entry.mac)){
			printf("%s:%d String %s contains invalid words\n",__FUNCTION__,__LINE__,entry.mac);
			ERR_MSG("invalid string!");
			goto check_err;
		}
		
#ifdef MAC_FILTER_SRC_WHITELIST
		_GET_BOOL(macFilterMode, _NEED);
		entry.mode = macFilterMode;
#ifdef MAC_FILTER_BLOCKTIMES_SUPPORT
		_GET_BOOL(enable, _NEED);
		entry.enable = enable;
		for(index = 0;index < entryTotal;index++)
		{
			mib_chain_get(MIB_MAC_FILTER_ROUTER_TBL, index, (void *)&Entry);
			instnum[Entry.instnum] = 1;
		}
		for(index = 1; index <= MAC_FILTER_ROUTER_RULES; index++)
		{
			if(instnum[index] == 0)
			{
				entry.instnum = index;
				break;
			}
		}
#endif		
#endif	
		entry.access_level = 0;
		mib_chain_add(MIB_MAC_FILTER_ROUTER_TBL,&entry);
		/************Place your code here, do what you want to do! ************/
	}
	else {lineno = __LINE__; goto check_err;}

	restart_IPFilter_DMZ_MACFilter();

	mib_update(CURRENT_SETTING, CONFIG_MIB_ALL);
	_COND_REDIRECT;
check_err:
	_BC_FREE();
	_TRACE_LEAVEL;
	return;
}
#endif

#ifdef CONFIG_CMCC_ENTERPRISE
#include "cJSON.h"
#ifdef SUPPORT_TIME_SCHEDULE
void formSchedule(request * wp, char *path, char *query)
{
	char *str, *submitUrl;
	char *name, *mod;
	char tmpBuf[100];
	char vChar;
	unsigned int totalEntry;
	MIB_CE_TIME_SCHEDULE_T Entry;
	MIB_CE_TIME_SCHEDULE_T pEntry;
	char *sch_time, *tmp;
	unsigned int *addTime, *pTime;
	int j;
	int i, selected=-1;
	int intVal, modIndex;

	int fd = -1;
	fd = creat(SCHEDULE_NOW_FILE, 0777);
	if(fd >= 0) close(fd);

	str = boaGetVar(wp, "addschedule", "");
	if(str[0]){
		//submit to add schedule
		mod = boaGetVar(wp, "sched_mod", "");
		if(!mod[0]){
			strcpy(tmpBuf, "Get ERROR!");
			goto setErr_Schedule;
		}

		modIndex = mod[0]-'0';
		
		name = boaGetVar(wp, "name_sched", "");
		if(!name[0]){
			strcpy(tmpBuf, "Get Name ERROR!");
			goto setErr_Schedule;
		}

		sch_time = boaGetVar(wp, "sch_time", "");
		if(!sch_time[0]){
			printf("[%s %d]sch_time does not exist!!\n", __func__, __LINE__);
			strcpy(tmpBuf, "Get schedule ERROR!");
			goto setErr_Schedule;
		}

		memset(&Entry, 0x00, sizeof(Entry));
		strcpy(Entry.name, name);
	
		i = 0;
		int s_time = atoi(sch_time);
		do {
			((unsigned int *)&Entry.sch_time)[i++] = (s_time & (1 << (i-1)))?1:0;
			printf("[%s %d]Entry.sch_time[%d]=%d\n", __func__, __LINE__, i, ((unsigned int *)&Entry.sch_time)[i-1]);
		}while(i<7);
#ifdef CONFIG_CMCC_ENTERPRISE
		char *sch_min = boaGetVar(wp, "startHour", "");
		if(!sch_min[0]){
			strcpy(tmpBuf, "Get startHour ERROR!");
			goto setErr_Schedule;
		}
		Entry.sch_min[0] = atoi(sch_min);
		sch_min = boaGetVar(wp, "startMin", "");
		if(!sch_min[0]){
			strcpy(tmpBuf, "Get startMin ERROR!");
			goto setErr_Schedule;
		}
		Entry.sch_min[1] = atoi(sch_min);
		sch_min = boaGetVar(wp, "endHour", "");
		if(!sch_min[0]){
			strcpy(tmpBuf, "Get endHour ERROR!");
			goto setErr_Schedule;
		}
		Entry.sch_min[2] = atoi(sch_min);
		sch_min = boaGetVar(wp, "endMin", "");
		if(!sch_min[0]){
			strcpy(tmpBuf, "Get endMin ERROR!");
			goto setErr_Schedule;
		}
		Entry.sch_min[3] = atoi(sch_min);
#endif
		totalEntry = mib_chain_total(MIB_TIME_SCHEDULE_TBL); /* get chain record size */
		
		if(modIndex != 0)
		{
			//modify, not add
			for (i=0; i<totalEntry; i++)
			{
				if (!mib_chain_get(MIB_TIME_SCHEDULE_TBL, i, (void *)&pEntry))
				{
					strcpy(tmpBuf, strGetChainerror);
					goto setErr_Schedule;
				}
				if((strcmp(Entry.name, pEntry.name)==0) && (i != modIndex-1))
				{
					strcpy(tmpBuf, "Schedule Name aleady exist!!");
					goto setErr_Schedule;
				}

				addTime = (unsigned int *)Entry.sch_time;
				pTime = (unsigned int *)pEntry.sch_time;
				printf("[%s %d]addTime=%d %d %d %d %d %d %d\n", __func__, __LINE__, addTime[0], addTime[1], addTime[2], addTime[3], addTime[4], addTime[5], addTime[6]);
				printf("[%s %d]pTime=%d %d %d %d %d %d %d\n", __func__, __LINE__, pTime[0], pTime[1], pTime[2], pTime[3], pTime[4], pTime[5], pTime[6]);
				if((i != modIndex-1)
					&& strncmp(Entry.sch_time, pEntry.sch_time, sizeof(Entry.sch_time)) == 0
#ifdef CONFIG_CMCC_ENTERPRISE
					&& strncmp(Entry.sch_min, pEntry.sch_min, sizeof(pEntry.sch_min)) == 0
#endif
				)
				{
					strcpy(tmpBuf, "Schedule Rule aleady exist!!");
					goto setErr_Schedule;
				}

			}
			if(!mib_chain_update( MIB_TIME_SCHEDULE_TBL, (void*)&Entry, modIndex-1))
			{
				strcpy(tmpBuf, "update error!!");
				goto setErr_Schedule;
			}
			else
			{
				//update ok!
				goto setOk;
			}
		}
		

		//duplicate check
		for (i=0; i<totalEntry; i++) {
			if (!mib_chain_get(MIB_TIME_SCHEDULE_TBL, i, (void *)&pEntry))
			{
				strcpy(tmpBuf, strGetChainerror);
				goto setErr_Schedule;
			}
			if((strcmp(Entry.name, pEntry.name)==0))
			{
				strcpy(tmpBuf, "Schedule Name aleady exist!!");
				goto setErr_Schedule;
			}

			addTime = (unsigned int *)Entry.sch_time;
			pTime = (unsigned int *)pEntry.sch_time;
			printf("[%s %d]addTime=%d %d %d %d %d %d %d\n", __func__, __LINE__, addTime[0], addTime[1], addTime[2], addTime[3], addTime[4], addTime[5], addTime[6]);
			printf("[%s %d]pTime=%d %d %d %d %d %d %d\n", __func__, __LINE__, pTime[0], pTime[1], pTime[2], pTime[3], pTime[4], pTime[5], pTime[6]);
			if(strncmp(Entry.sch_time, pEntry.sch_time, sizeof(Entry.sch_time)) == 0
#ifdef CONFIG_CMCC_ENTERPRISE
				&& strncmp(Entry.sch_min, pEntry.sch_min, sizeof(pEntry.sch_min)) == 0
#endif
				)
			{
				strcpy(tmpBuf, "Schedule Rule aleady exist!!");
				goto setErr_Schedule;
			}

		}

		intVal = mib_chain_add(MIB_TIME_SCHEDULE_TBL, (void *)&Entry);
		if (intVal == 0) {
			strcpy(tmpBuf, strAddChainerror);
			goto setErr_Schedule;
		}
		else if (intVal == -1) {
			strcpy(tmpBuf, strTableFull);
			goto setErr_Schedule;
		}

	}

setOk:

// Magician: Commit immediately
#ifdef COMMIT_IMMEDIATELY
	Commit();
#endif

	if(modIndex != 0)
	{
		restart_urlblocking();
		restart_IPFilter_DMZ_MACFilter();
	}
#ifdef SUPPORT_TIME_SCHEDULE
	updateScheduleCrondFile("/var/spool/cron/crontabs", 0);
	firewall_schedule();
#endif
	submitUrl = boaGetVar(wp, "submit-url", "");
	printf("redirectUrl:%s\n", submitUrl);

	if (submitUrl[0])
		boaRedirect(wp, submitUrl);
	else
		boaDone(wp, 200);
 	return;

setErr_Schedule:
setErr_dns:
	printf("tmpBuf = %s\n",tmpBuf);
	ERR_MSG(tmpBuf);
}

void formSchedList(request * wp, char *path, char *query)
{
	char *strVal, *submitUrl;
	unsigned int totalEntry;
	MIB_CE_URL_FQDN_T urlEntry;
	MIB_CE_ROUTEMAC_T macEntry;
    MIB_CE_IP_PORT_FILTER_T ipEntry;
	int i, selected=-1;
	int intVal;
	int action, index;
	int mac_index=-1, url_index=-1;

	printf("Enter formSchedList\n");

	strVal = boaGetVar(wp, "action", "");
	if (strVal[0]) {
		action = strVal[0]-'0';
		strVal = boaGetVar(wp, "idx", "");
		index = strVal[0]-'0';

		printf("action:%d index:%d\n", action, index);
		if (action == 0) 
		{ 	// delete schedule may effect mac-filter & url-filter
			mib_chain_delete(MIB_TIME_SCHEDULE_TBL, index);

#ifdef URL_BLOCKING_SUPPORT
			totalEntry = mib_chain_total(MIB_URL_FQDN_TBL);
			for (i=totalEntry-1 ; i>=0; i--)
			{
				if (mib_chain_get(MIB_URL_FQDN_TBL, i, (void *)&urlEntry))
				{
					if(urlEntry.schedIndex == index+1)
						mib_chain_delete(MIB_URL_FQDN_TBL, i);
					else if(urlEntry.schedIndex > index+1)
					{
						urlEntry.schedIndex--;
						mib_chain_update(MIB_URL_FQDN_TBL, (void *)&urlEntry, i);
					}
				}
			}
#endif

			totalEntry = mib_chain_total(MIB_MAC_FILTER_ROUTER_TBL);
			for (i=totalEntry-1 ; i>=0; i--)
			{
				if (mib_chain_get(MIB_MAC_FILTER_ROUTER_TBL, i, (void *)&macEntry))
				{
					if(macEntry.schedIndex == index+1)
						mib_chain_delete(MIB_MAC_FILTER_ROUTER_TBL, i);
					else if(macEntry.schedIndex > index+1)
					{
						macEntry.schedIndex--;
						mib_chain_update(MIB_MAC_FILTER_ROUTER_TBL, (void *)&macEntry, i);
					}
				}
			}

            totalEntry = mib_chain_total(MIB_IP_PORT_FILTER_TBL);
            for (i=totalEntry-1 ; i>=0; i--)
			{
				if (mib_chain_get(MIB_IP_PORT_FILTER_TBL, i, (void *)&ipEntry))
				{
					if(ipEntry.schedIndex == index+1)
						mib_chain_delete(MIB_IP_PORT_FILTER_TBL, i);
					else if(ipEntry.schedIndex > index+1)
					{
						ipEntry.schedIndex--;
						mib_chain_update(MIB_IP_PORT_FILTER_TBL, (void *)&ipEntry, i);
					}
				}
			}
		}
	}

#ifdef COMMIT_IMMEDIATELY
	Commit();
#endif

	if (action == 0) 
	{
		restart_urlblocking();
		restart_IPFilter_DMZ_MACFilter();
	}
	submitUrl = boaGetVar(wp, "redirect-url", "");   // hidden page
	printf("redirectUrl:%s\n", submitUrl);
	if (submitUrl[0])
		boaRedirect(wp, submitUrl);
	else
		boaDone(wp, 200);
  	return;
	
}

int schedTableList(int eid, request * wp, int argc, char **argv)
{
	char *str, *submitUrl;
	char *name;
	char vChar;
	unsigned int totalEntry;
	MIB_CE_TIME_SCHEDULE_T Entry;
	MIB_CE_TIME_SCHEDULE_T pEntry;
	char *sch_time;
	int i, j;
	int intVal;
	int ret = 0;

	totalEntry = mib_chain_total(MIB_TIME_SCHEDULE_TBL); /* get chain record size */

	//printf("[%s %d]totalEntry:%d\n", __func__, __LINE__, totalEntry);
	for (i=0; i<totalEntry; i++) {
		if (mib_chain_get(MIB_TIME_SCHEDULE_TBL, i, (void *)&pEntry))
		{
			char tmp[256] = {0};
			
			strcpy(tmp, multilang(LANG_PERIOD));
			strcat(tmp, ": ");
			if(((unsigned int *)&pEntry.sch_time)[0])
			{
				strcat(tmp, multilang(LANG_SUN));
				strcat(tmp, "\t");
			}
			if(((unsigned int *)&pEntry.sch_time)[1])
			{
				strcat(tmp, multilang(LANG_MON));
				strcat(tmp, "\t");
			}
			if(((unsigned int *)&pEntry.sch_time)[2])
			{
				strcat(tmp, multilang(LANG_TUE));
				strcat(tmp, "\t");
			}
			if(((unsigned int *)&pEntry.sch_time)[3])
			{
				strcat(tmp, multilang(LANG_WED));
				strcat(tmp, "\t");
			}
			if(((unsigned int *)&pEntry.sch_time)[4])
			{
				strcat(tmp, multilang(LANG_THU));
				strcat(tmp, "\t");
			}
			if(((unsigned int *)&pEntry.sch_time)[5])
			{
				strcat(tmp, multilang(LANG_FRI));
				strcat(tmp, "\t");
			}
			if(((unsigned int *)&pEntry.sch_time)[6])
			{
				strcat(tmp, multilang(LANG_SAT));
				strcat(tmp, "\t");
			}

#ifdef CONFIG_CMCC_ENTERPRISE
			char tmp2[64] = {0};
			strcat(tmp, multilang(LANG_TIME));
			sprintf(tmp2, ": %02d:%02d - %02d:%02d",pEntry.sch_min[0],pEntry.sch_min[1],pEntry.sch_min[2],pEntry.sch_min[3]);
			strcat(tmp, tmp2);
#endif
			ret += boaWrite(wp, "<tr align=\"center\"><td>%s</td><td>%s</td><td>"
			"<a href=\"#\" onClick=\"editShedClick(%d)\">"
			"%s</a></td>"
			"<td><a href=\"#\" onClick=\"delClick(%d)\">"
			"%s</a></td></tr>\n", pEntry.name,tmp, i, multilang(LANG_MODIFY), i, multilang(LANG_DELETE));
		}
		
	}
	return ret;
}

int schedList_select(int eid, request * wp, int argc, char ** argv)
{
	char *str, *submitUrl;
	char *name, *starttime, *endtime, *weekday;
	char weekdays[10];
	char vChar;
	unsigned int totalEntry;
	MIB_CE_TIME_SCHEDULE_T pEntry;
	int i, j;
	int intVal;
	int ret = 0;

	ret += boaWrite(wp,"\t<option value=0 selected=\"selected\">%s</option>\n", multilang(LANG_SCHEDULE_EFFECTIVE));

	totalEntry = mib_chain_total(MIB_TIME_SCHEDULE_TBL); /* get chain record size */
	//printf("[%s %d]totalEntry:%d\n", __func__, __LINE__, totalEntry);
	for (i=0; i<totalEntry; i++) {
		if (mib_chain_get(MIB_TIME_SCHEDULE_TBL, i, (void *)&pEntry))
		{
			// printf("[%s %d]name:%s, week:%s, time%s - %s\n", __func__, __LINE__, pEntry.name, pEntry.weekdays, pEntry.timestart, pEntry.timestop);
			ret += boaWrite(wp,"\t<option value=%d>%s</option>\n", i+1, pEntry.name);
		}
	}
	// ret += boaWrite(wp,"\t<option value=%d>Never</option>\n", totalEntry+1);

	return ret;
}
#endif

void mac_filter_Form(request *wp, char *path, char *query)
{
	struct routemac_entry   entry;
	char *stemp = "";
	int index = 0;
	int lineno = __LINE__;
	unsigned char           macfltenable = 0;
	int cnt = 0, i;
	unsigned char macfltmode = 0; // 0-black list, 1-white list
	unsigned char macCap = 0; // 0-off, 1-black list, 2-white list
	cJSON* macfltlist_json=NULL;
	cJSON* macfltentry_json=NULL;
	cJSON* mac_json=NULL;
	cJSON* mode_json=NULL;
#ifdef SUPPORT_TIME_SCHEDULE
	cJSON* schedule_json=NULL;
	int fd = -1;

	fd = creat(SCHEDULE_NOW_FILE, 0777);
	if(fd >= 0) close(fd);
#endif
	_BC_USE;

	_TRACE_CALL;
	//FETCH_INVALID_OPT(stemp, "macfltenable", _NEED);
	_GET_BOOL(macfltenable, _OPT);
	if(macfltenable)        //macfilter on
	{
		_GET_INT(macfltmode, _NEED);
		printf("macfltmode=%d\n",macfltmode);
		macCap = macfltenable + macfltmode;
		mib_set(MIB_MAC_FILTER_SRC_ENABLE,&macCap);
		FETCH_INVALID_OPT(stemp, "macfltlist", _OPT);

		cnt = mib_chain_total(MIB_MAC_FILTER_ROUTER_TBL);
		for(i = cnt-1;i>=0;i--){//flush table first
			mib_chain_delete(MIB_MAC_FILTER_ROUTER_TBL,i);
		}
		macfltlist_json = cJSON_Parse(stemp);
		if(!macfltlist_json) {lineno = __LINE__; goto check_empty;}

		cnt = cJSON_GetArraySize(macfltlist_json);
		printf(" input json array size %d\n",cnt);

		for(i = 0;i<cnt;i++){
			memset(&entry, 0, sizeof(entry));
			macfltentry_json = cJSON_GetArrayItem(macfltlist_json,i);
			if(!macfltentry_json) continue;
			printf("\t%d entry:%s",i, cJSON_PrintUnformatted(macfltentry_json));
			mac_json = cJSON_GetObjectItem(macfltentry_json,"mac");
			if(mac_json)
				strncpy(entry.mac, mac_json->valuestring, sizeof(entry.mac));
			else
				continue;
			mode_json = cJSON_GetObjectItem(macfltentry_json,"mode");
			printf("\t\t mode_json->valueint:%d",mode_json->valueint);
			if(mode_json)
				entry.mode = mode_json->valueint;
			else
				entry.mode = macfltmode;
#ifdef SUPPORT_TIME_SCHEDULE
			schedule_json = cJSON_GetObjectItem(macfltentry_json,"ScheduleIdex");
			printf("\t\t schedule_json->valueint:%d",schedule_json->valueint);
			if(schedule_json->valueint >=32 || schedule_json->valueint < 0)
			{
				printf("%s: schedList error!\n",__func__);
				goto check_err;
			}
			if(schedule_json)
				entry.schedIndex = schedule_json->valueint;
			else
				entry.schedIndex = 0;
#endif
		//printf("add mac filter entry %s mode %d\n",entry.mac, entry.mode);
			mib_chain_add(MIB_MAC_FILTER_ROUTER_TBL,&entry);
		}
	}
	else    //macfilter off
	{
	//printf("macfltenable=%d\n",macfltenable);
		mib_set(MIB_MAC_FILTER_SRC_ENABLE,&macfltenable);
	}
check_empty:
	restart_IPFilter_DMZ_MACFilter();

	mib_update(CURRENT_SETTING, CONFIG_MIB_ALL);
	_COND_REDIRECT;
check_err:
	_BC_FREE();
	if(macfltlist_json) cJSON_Delete(macfltlist_json);
	_TRACE_LEAVEL;
	return;
}

void ip_filter_Form(request * wp, char *path, char *query)
{
	unsigned char ipfltenable = 0;
	unsigned char out_ipfltenable = 0;
	unsigned char ipfltmode = 0;	//default whitelist
	unsigned char out_ipfltmode = 0;//default whitelist
	cJSON* ipfltlist_json=NULL;
	cJSON* ipfltentry_json=NULL;
	cJSON* tmp_json=NULL;
#ifdef SUPPORT_TIME_SCHEDULE
	cJSON* schedule_json=NULL;
	int fd = -1;

	fd = creat(SCHEDULE_NOW_FILE, 0777);
	if(fd >= 0) close(fd);
#endif
	unsigned long tmp_ip, tmp_ip2;
	MIB_CE_IP_PORT_FILTER_T entry;

	char *stemp = "";
	int lineno = __LINE__;
	int cnt = 0, i;
	_TRACE_CALL;
	_BC_USE;

	_GET_BOOL(ipfltenable, _NEED);
	_GET_BOOL(out_ipfltenable, _NEED);
	_GET_INT(ipfltmode, _NEED);
	_GET_INT(out_ipfltmode, _NEED);

	mib_set(MIB_IPFILTER_IN_ENABLE, (void*)&ipfltenable);
	mib_set(MIB_IPFILTER_OUT_ENABLE, (void*)&out_ipfltenable);
	mib_set(MIB_IPF_IN_ACTION, (void*)&ipfltmode);
	mib_set(MIB_IPF_OUT_ACTION, (void*)&out_ipfltmode);

	cnt = mib_chain_total(MIB_IP_PORT_FILTER_TBL);
	for(i = cnt-1;i>=0;i--){//flush table first
		mib_chain_delete(MIB_IP_PORT_FILTER_TBL,i);
	}
//ipfltlist in
	FETCH_INVALID_OPT(stemp, "ipfltlist_in", _OPT);
	ipfltlist_json = cJSON_Parse(stemp);
	if(!ipfltlist_json)
		{lineno = __LINE__; goto check_err;}
	cnt = cJSON_GetArraySize(ipfltlist_json);
	printf("input json array size %d\n",cnt);
	for(i = 0;i<cnt;i++){
		memset(&entry, 0, sizeof(entry));
		ipfltentry_json = cJSON_GetArrayItem(ipfltlist_json,i);
		if(!ipfltentry_json) continue;
		printf("\t%d entry:%s\n",i, cJSON_PrintUnformatted(ipfltentry_json));
//[{"name":"1","select":false,"filterName":"in","protoType":4,"sipStart":"7.7.7.7","sipEnd":"7.7.7.70","smask":"0.0.0.0","dipStart":"2.2.2.2","dipEnd":"2.2.2.20","dmask":"0.0.0.0","sportStart":0,"sportEnd":0,"dportStart":0,"dportEnd":0,"allport":0,"portnum":0,"ifname":"INTERNET_R_0_0_32;INTERNET_R_0_8_35","enable":1,"IpProtocolType":1,"sip6Start":"::","sip6End":"::","dip6Start":"::","dip6End":"::","sip6PrefixLen":0,"dip6PrefixLen":0,"WanPath":"nas0_0","mode":"1"},{"name":"0","select":false,"filterName":"aa","protoType":3,"sipStart":"1.1.1.1","sipEnd":"1.1.1.10","smask":"0.0.0.0","dipStart":"2.2.2.2","dipEnd":"2.2.2.20","dmask":"0.0.0.0","sportStart":20,"sportEnd":22,"dportStart":0,"dportEnd":0,"enable":1,"IpProtocolType":1,"sip6Start":"::","sip6End":"::","dip6Start":"::","dip6End":"::","sip6PrefixLen":0,"dip6PrefixLen":0,"mode":"0"}]
		tmp_json = cJSON_GetObjectItem(ipfltentry_json,"sipStart");
		if(tmp_json){
			tmp_ip = strlen(tmp_json->valuestring)?inet_addr(tmp_json->valuestring):0;
			if(tmp_ip){
				memcpy(entry.srcIp, &tmp_ip, 4);
				tmp_json = cJSON_GetObjectItem(ipfltentry_json,"sipEnd");
				if(tmp_json){
					tmp_ip2 = strlen(tmp_json->valuestring)?inet_addr(tmp_json->valuestring):0;
					if(tmp_ip2){
						memcpy(entry.srcIp2, &tmp_ip2, 4);
					}
					else
						memcpy(entry.srcIp2, &tmp_ip, 4);
				}else
					memcpy(entry.srcIp2, &tmp_ip, 4);
			}
		}
		printf("\t\tentry.srcIp=0x%02x%02x%02x%02x\n",entry.srcIp[0],entry.srcIp[1],entry.srcIp[2],entry.srcIp[3]);
		printf("\t\tentry.srcIp2=0x%02x%02x%02x%02x\n",entry.srcIp2[0],entry.srcIp2[1],entry.srcIp2[2],entry.srcIp2[3]);
		tmp_json = cJSON_GetObjectItem(ipfltentry_json,"dipStart");
		if(tmp_json){
			tmp_ip = strlen(tmp_json->valuestring)?inet_addr(tmp_json->valuestring):0;
			if(tmp_ip){
				memcpy(entry.dstIp, &tmp_ip, 4);
				tmp_json = cJSON_GetObjectItem(ipfltentry_json,"dipEnd");
				if(tmp_json){
					tmp_ip2 = strlen(tmp_json->valuestring)?inet_addr(tmp_json->valuestring):0;
					if(tmp_ip2)
						memcpy(entry.dstIp2, &tmp_ip2, 4);
					else 
						memcpy(entry.dstIp2, &tmp_ip, 4);
				}else
					memcpy(entry.dstIp2, &tmp_ip, 4);
			}
		}
		printf("\t\tentry.dstIp=0x%02x%02x%02x%02x\n",entry.dstIp[0],entry.dstIp[1],entry.dstIp[2],entry.dstIp[3]);
		printf("\t\tentry.dstIp2=0x%02x%02x%02x%02x\n",entry.dstIp2[0],entry.dstIp2[1],entry.dstIp2[2],entry.dstIp2[3]);
		tmp_json = cJSON_GetObjectItem(ipfltentry_json,"sportStart");
		if(tmp_json)
			entry.srcPortFrom = tmp_json->valueint;
			//entry.srcPortFrom = strlen(tmp_json->valuestring)?atoi(tmp_json->valuestring):0;
		printf("\t\tentry.srcPortFrom=%d\n",entry.srcPortFrom);
		tmp_json = cJSON_GetObjectItem(ipfltentry_json,"sportEnd");
		if(tmp_json)
			entry.srcPortTo = tmp_json->valueint;
			//entry.srcPortTo = strlen(tmp_json->valuestring)?atoi(tmp_json->valuestring):0;
		printf("\t\tentry.srcPortTo=%d\n",entry.srcPortTo);
		tmp_json = cJSON_GetObjectItem(ipfltentry_json,"dportStart");
		if(tmp_json)
			entry.dstPortFrom = tmp_json->valueint;
			//entry.dstPortFrom = strlen(tmp_json->valuestring)?atoi(tmp_json->valuestring):0;
		printf("\t\tentry.dstPortFrom=%d\n",entry.dstPortFrom);
		tmp_json = cJSON_GetObjectItem(ipfltentry_json,"dportEnd");
		if(tmp_json)
			entry.dstPortTo = tmp_json->valueint;
			//entry.dstPortTo = strlen(tmp_json->valuestring)?atoi(tmp_json->valuestring):0;
		printf("\t\tentry.dstPortTo=%d\n",entry.dstPortTo);
		if(entry.srcPortTo == 0)
			entry.srcPortTo = entry.srcPortFrom;
		if(entry.dstPortTo == 0)
			entry.dstPortTo = entry.dstPortFrom;

		entry.action = 1-ipfltmode;
		entry.dir= DIR_IN;

		printf("\t\tentry.action=%d(0 - Deny, 1 - Allow)\n",entry.action);
		printf("\t\tentry.dir=%d(0 - out, 1 - in)\n",entry.dir);
		entry.IpProtocol = IPVER_IPV4;
		tmp_json = cJSON_GetObjectItem(ipfltentry_json,"protoType");
		if(tmp_json->type != cJSON_Number)
			fprintf(stderr, "error!!!empty protoType, regard as all protocols\n");
		switch(tmp_json->valueint)
		{
			case 0:
				entry.protoType=PROTO_NONE;
				break;
			case 1:
				entry.protoType=PROTO_TCP;
				break;
			case 2:
				entry.protoType=PROTO_UDP;
				break;
			case 3:
				entry.protoType=PROTO_UDPTCP;
				break;
			case 4:
				entry.protoType=PROTO_ICMP;
				break;
		}
#ifdef SUPPORT_TIME_SCHEDULE
		tmp_json = cJSON_GetObjectItem(ipfltentry_json,"ScheduleIdex");
		if(tmp_json->valueint >=32 || tmp_json->valueint < 0)
		{
			printf("%s: schedList error!\n",__func__);
			goto check_err;
		}
		if(tmp_json)
			entry.schedIndex = tmp_json->valueint;
		else 
			entry.schedIndex = 0;
#endif	
		entry.enable = 1;
		mib_chain_add(MIB_IP_PORT_FILTER_TBL,&entry);
	}
//ipfltlist out
	FETCH_INVALID_OPT(stemp, "ipfltlist_out", _OPT);
	ipfltlist_json = cJSON_Parse(stemp);
	if(!ipfltlist_json) 
		{lineno = __LINE__; goto check_err;}
	cnt = cJSON_GetArraySize(ipfltlist_json);
	for(i = 0;i<cnt;i++){
		memset(&entry, 0, sizeof(entry));
		ipfltentry_json = cJSON_GetArrayItem(ipfltlist_json,i);
		if(!ipfltentry_json) continue;
		printf("\t%d entry:%s\n",i, cJSON_PrintUnformatted(ipfltentry_json));
//[{"name":"1","select":false,"filterName":"in","protoType":4,"sipStart":"7.7.7.7","sipEnd":"7.7.7.70","smask":"0.0.0.0","dipStart":"2.2.2.2","dipEnd":"2.2.2.20","dmask":"0.0.0.0","sportStart":0,"sportEnd":0,"dportStart":0,"dportEnd":0,"allport":0,"portnum":0,"ifname":"INTERNET_R_0_0_32;INTERNET_R_0_8_35","enable":1,"IpProtocolType":1,"sip6Start":"::","sip6End":"::","dip6Start":"::","dip6End":"::","sip6PrefixLen":0,"dip6PrefixLen":0,"WanPath":"nas0_0","mode":"1"},{"name":"0","select":false,"filterName":"aa","protoType":3,"sipStart":"1.1.1.1","sipEnd":"1.1.1.10","smask":"0.0.0.0","dipStart":"2.2.2.2","dipEnd":"2.2.2.20","dmask":"0.0.0.0","sportStart":20,"sportEnd":22,"dportStart":0,"dportEnd":0,"enable":1,"IpProtocolType":1,"sip6Start":"::","sip6End":"::","dip6Start":"::","dip6End":"::","sip6PrefixLen":0,"dip6PrefixLen":0,"mode":"0"}]
		tmp_json = cJSON_GetObjectItem(ipfltentry_json,"sipStart");
		if(tmp_json){
			tmp_ip = strlen(tmp_json->valuestring)?inet_addr(tmp_json->valuestring):0;
			if(tmp_ip){
				memcpy(entry.srcIp, &tmp_ip, 4);
				tmp_json = cJSON_GetObjectItem(ipfltentry_json,"sipEnd");
				if(tmp_json){
					tmp_ip2 = strlen(tmp_json->valuestring)?inet_addr(tmp_json->valuestring):0;
					if(tmp_ip2){
						memcpy(entry.srcIp2, &tmp_ip2, 4);
					}
					else
						memcpy(entry.srcIp2, &tmp_ip, 4);
				}else
					memcpy(entry.srcIp2, &tmp_ip, 4);
			}
		}
		printf("\t\tentry.srcIp=0x%02x%02x%02x%02x\n",entry.srcIp[0],entry.srcIp[1],entry.srcIp[2],entry.srcIp[3]);
		printf("\t\tentry.srcIp2=0x%02x%02x%02x%02x\n",entry.srcIp2[0],entry.srcIp2[1],entry.srcIp2[2],entry.srcIp2[3]);
		tmp_json = cJSON_GetObjectItem(ipfltentry_json,"dipStart");
		if(tmp_json){
			tmp_ip = strlen(tmp_json->valuestring)?inet_addr(tmp_json->valuestring):0;
			if(tmp_ip){
				memcpy(entry.dstIp, &tmp_ip, 4);
				tmp_json = cJSON_GetObjectItem(ipfltentry_json,"dipEnd");
				if(tmp_json){
					tmp_ip2 = strlen(tmp_json->valuestring)?inet_addr(tmp_json->valuestring):0;
					if(tmp_ip2)
						memcpy(entry.dstIp2, &tmp_ip2, 4);
					else 
						memcpy(entry.dstIp2, &tmp_ip, 4);
				}else
					memcpy(entry.dstIp2, &tmp_ip, 4);
			}
		}
		printf("\t\tentry.dstIp=0x%02x%02x%02x%02x\n",entry.dstIp[0],entry.dstIp[1],entry.dstIp[2],entry.dstIp[3]);
		printf("\t\tentry.dstIp2=0x%02x%02x%02x%02x\n",entry.dstIp2[0],entry.dstIp2[1],entry.dstIp2[2],entry.dstIp2[3]);
		tmp_json = cJSON_GetObjectItem(ipfltentry_json,"sportStart");
		if(tmp_json)
			entry.srcPortFrom = tmp_json->valueint;
			//entry.srcPortFrom = strlen(tmp_json->valuestring)?atoi(tmp_json->valuestring):0;
		printf("\t\tentry.srcPortFrom=%d\n",entry.srcPortFrom);
		tmp_json = cJSON_GetObjectItem(ipfltentry_json,"sportEnd");
		if(tmp_json)
			entry.srcPortTo = tmp_json->valueint;
			//entry.srcPortTo = strlen(tmp_json->valuestring)?atoi(tmp_json->valuestring):0;
		printf("\t\tentry.srcPortTo=%d\n",entry.srcPortTo);
		tmp_json = cJSON_GetObjectItem(ipfltentry_json,"dportStart");
		if(tmp_json)
			entry.dstPortFrom = tmp_json->valueint;
			//entry.dstPortFrom = strlen(tmp_json->valuestring)?atoi(tmp_json->valuestring):0;
		printf("\t\tentry.dstPortFrom=%d\n",entry.dstPortFrom);
		tmp_json = cJSON_GetObjectItem(ipfltentry_json,"dportEnd");
		if(tmp_json)
			entry.dstPortTo = tmp_json->valueint;
			//entry.dstPortTo = strlen(tmp_json->valuestring)?atoi(tmp_json->valuestring):0;
		printf("\t\tentry.dstPortTo=%d\n",entry.dstPortTo);
		if(entry.srcPortTo == 0)
			entry.srcPortTo = entry.srcPortFrom;
		if(entry.dstPortTo == 0)
			entry.dstPortTo = entry.dstPortFrom;

		entry.action = 1-out_ipfltmode;
		entry.dir= DIR_OUT;

		printf("\t\tentry.action=%d(0 - Deny, 1 - Allow)\n",entry.action);
		printf("\t\tentry.dir=%d(0 - out, 1 - in)\n",entry.dir);
		entry.IpProtocol = IPVER_IPV4;
		tmp_json = cJSON_GetObjectItem(ipfltentry_json,"protoType");
		if(tmp_json->type != cJSON_Number) 
			fprintf(stderr, "error!!!empty protoType, regard as all protocols\n");
		switch(tmp_json->valueint)
		{
			case 0:
				entry.protoType=PROTO_NONE;
				break;
			case 1:
				entry.protoType=PROTO_TCP;
				break;
			case 2:
				entry.protoType=PROTO_UDP;
				break;
			case 3:
				entry.protoType=PROTO_UDPTCP;
				break;
			case 4:
				entry.protoType=PROTO_ICMP;
				break;
		}
#ifdef SUPPORT_TIME_SCHEDULE
		tmp_json = cJSON_GetObjectItem(ipfltentry_json,"ScheduleIdex");
		if(tmp_json->valueint >=32 || tmp_json->valueint < 0)
		{
			printf("%s: schedList error!\n",__func__);
			goto check_err;
		}
		if(tmp_json)
			entry.schedIndex = tmp_json->valueint;
		else 
			entry.schedIndex = 0;
		printf("\t\tentry.schedIndex=%d\n",entry.schedIndex);
#endif	
		entry.enable = 1;
		mib_chain_add(MIB_IP_PORT_FILTER_TBL,&entry);
	}
#ifdef COMMIT_IMMEDIATELY
	Commit();
#endif
	//take effect immediate
	restart_IPFilter_DMZ_MACFilter();

	mib_update(CURRENT_SETTING, CONFIG_MIB_ALL);
	_COND_REDIRECT;
check_err:
	_BC_FREE();
	if(ipfltlist_json) cJSON_Delete(ipfltlist_json);
	_TRACE_LEAVEL;
	return;

}

int init_ip_filter_In (int eid, request * wp, int argc, char ** argv)
{
	struct ipfilter_blacklist_entry	entry = {0};
	char sipStart[16];
	char sipEnd[16];
	char smask[16];
	char dipStart[16];
	char dipEnd[16];
	char dmask[16];
	int cnt = 2;
	int index = 0;
	int lineno = __LINE__;
	unsigned char ipfilterInEnable = 0;
	unsigned char ipfilterInAction = 0;
	char scheduleName[16]={0};

	snprintf(scheduleName, sizeof(scheduleName), "%s", multilang(LANG_SCHEDULE_EFFECTIVE));


#ifdef CONFIG_IPV6
	unsigned char 	sip6StartStr[48], dip6StartStr[48], sip6EndStr[48], dip6EndStr[48];
#endif
#ifdef SUPPORT_TIME_SCHEDULE
	MIB_CE_TIME_SCHEDULE_T schdEntry;
#endif

	_TRACE_CALL;
	mib_get(MIB_IPFILTER_IN_ENABLE, (void*)&ipfilterInEnable);
	mib_get(MIB_IPF_IN_ACTION, (void*)&ipfilterInAction);

	_PUT_BOOL(ipfilterInEnable);
	_PUT_INT(ipfilterInAction);

	/************Place your code here, do what you want to do! ************/
	MIB_CE_IP_PORT_FILTER_T Mib_Entry;
	cnt = mib_chain_total(MIB_IP_PORT_FILTER_TBL);
	/************Place your code here, do what you want to do! ************/

	for(index = 0; index < cnt; index++)
	{
		/************Place your code here, do what you want to do! ************/
		memset(&entry, 0, sizeof(entry));
		if (!mib_chain_get(MIB_IP_PORT_FILTER_TBL, index, (void *)&Mib_Entry))
		{
 			boaError(wp, 400, "Get chain record error!\n");
			return -1;
		}
		if (Mib_Entry.dir == DIR_OUT) 
		{
			continue;
		}
		memcpy(entry.filterName, Mib_Entry.name, sizeof(entry.filterName));
#if defined(CONFIG_CMCC) || defined(CONFIG_CU)
		memcpy(entry.WanPath, Mib_Entry.WanPath, sizeof(entry.WanPath));
#endif

		switch(Mib_Entry.protoType)
		{
			case PROTO_NONE:
				entry.protoType=0;
				break;
			case PROTO_TCP:
				entry.protoType=1;
				break;
			case PROTO_UDP:
				entry.protoType=2;
				break;
			case PROTO_UDPTCP:
				entry.protoType=3;
				break;
			case PROTO_ICMP:
				entry.protoType=4;
				break;
		}
		memcpy(&entry.sipStart, Mib_Entry.srcIp, 4);
		memcpy(&entry.sipEnd, Mib_Entry.srcIp2, 4);
		entry.smask=0xFFFFFFFF;
		if(Mib_Entry.smaskbit !=0)
			entry.smask =entry.smask<<(32-Mib_Entry.smaskbit);
		else
			entry.smask=0;
		memcpy(&entry.dipStart, Mib_Entry.dstIp, 4);
		memcpy(&entry.dipEnd, Mib_Entry.dstIp2, 4);
		entry.dmask=0xFFFFFFFF;
		if(Mib_Entry.dmaskbit !=0)
			entry.dmask =(entry.dmask<<(32-Mib_Entry.dmaskbit));
		else
			entry.dmask=0;
		entry.sportStart=Mib_Entry.srcPortFrom;
		entry.sportEnd=Mib_Entry.srcPortTo;
		entry.dportStart=Mib_Entry.dstPortFrom;
		entry.dportEnd=Mib_Entry.dstPortTo;
		entry.enable = Mib_Entry.enable;

#ifdef CONFIG_IPV6
		inet_ntop(PF_INET6, (struct in6_addr *)Mib_Entry.sip6Start, sip6StartStr, sizeof(sip6StartStr));
		inet_ntop(PF_INET6, (struct in6_addr *)Mib_Entry.sip6End, sip6EndStr, sizeof(sip6EndStr));
		inet_ntop(PF_INET6, (struct in6_addr *)Mib_Entry.dip6Start, dip6StartStr, sizeof(dip6StartStr));
		inet_ntop(PF_INET6, (struct in6_addr *)Mib_Entry.dip6End, dip6EndStr, sizeof(dip6EndStr));
#endif
#ifdef SUPPORT_TIME_SCHEDULE
		if(Mib_Entry.schedIndex)
			mib_chain_get(MIB_TIME_SCHEDULE_TBL, Mib_Entry.schedIndex-1, (void *)&schdEntry);
#endif
		/************Place your code here, do what you want to do! ************/

		boaWrite (wp, "push(new it_nr(\"%d\"" _PTS _PTI _PTS _PTS _PTS _PTS _PTS _PTS _PTI _PTI _PTI _PTI _PTI
#ifdef CONFIG_IPV6
		", \nnew it(\"IpProtocolType\",%d),\n"  	//ipv4 or ipv6
		"new it(\"sip6Start\",  \"%s\"),\n" 	//source ip6Start
		"new it(\"sip6End\",  \"%s\"),\n" 		//source ip6End
		"new it(\"dip6Start\",  \"%s\"),\n" 	//dst ip6Start
		"new it(\"dip6End\",  \"%s\"),\n" 		//dst ip6End
		"new it(\"sip6PrefixLen\",%d),\n"  	 	//source ip6 Prefix Len
		"new it(\"dip6PrefixLen\",%d)"  		//dst ip6 Prefix Len
#endif
#if defined(CONFIG_CMCC) || defined(CONFIG_CU)
		", \nnew it(\"WanPath\",  \"%s\")\n"		//WanPath
#endif
#ifdef SUPPORT_TIME_SCHEDULE
		", \nnew it(\"Schedule\",  \"%s\")\n"		//Schedule rule name
		", \nnew it(\"ScheduleIdex\",  %d)\n"		//Schedule rule index
#endif
		"));\n",
		index, _PME(filterName), _PME(protoType),
		_PMEIP(sipStart), _PMEIP(sipEnd), _PMEIP(smask), _PMEIP(dipStart), _PMEIP(dipEnd), _PMEIP(dmask),
		_PME(sportStart), _PME(sportEnd), _PME(dportStart), _PME(dportEnd), _PME(enable)
#ifdef CONFIG_IPV6
		, Mib_Entry.IpProtocol, sip6StartStr, sip6EndStr, dip6StartStr, dip6EndStr, Mib_Entry.sip6PrefixLen, Mib_Entry.dip6PrefixLen
#endif
#if defined(CONFIG_CMCC) || defined(CONFIG_CU)
		,entry.WanPath
#endif
#ifdef SUPPORT_TIME_SCHEDULE
		,(Mib_Entry.schedIndex)?schdEntry.name:scheduleName	//Schedule rule name
		,Mib_Entry.schedIndex								//Schedule rule index
#endif
		);
	}

check_err:
	_TRACE_LEAVEL;
	return 0;
}

int init_ip_filter_Out (int eid, request * wp, int argc, char ** argv)
{
	struct ipfilter_blacklist_entry	entry = {0};
	char sipStart[16];
	char sipEnd[16];
	char smask[16];
	char dipStart[16];
	char dipEnd[16];
	char dmask[16];
	int cnt = 2;
	int index = 0;
	int lineno = __LINE__;
#ifdef CONFIG_IPV6
	unsigned char 	sip6StartStr[48]={0}, dip6StartStr[48]={0}, sip6EndStr[48]={0}, dip6EndStr[48]={0};
#endif
#ifdef SUPPORT_TIME_SCHEDULE
	MIB_CE_TIME_SCHEDULE_T schdEntry;
#endif
	unsigned char ipfilterOutEnable = 0;
	unsigned char ipfilterOutAction = 0;
	char scheduleName[16]={0};

	snprintf(scheduleName, sizeof(scheduleName), "%s", multilang(LANG_SCHEDULE_EFFECTIVE));
	_TRACE_CALL;

	mib_get(MIB_IPFILTER_OUT_ENABLE, (void*)&ipfilterOutEnable);
	mib_get(MIB_IPF_OUT_ACTION, (void*)&ipfilterOutAction);

	_PUT_BOOL(ipfilterOutEnable);
	_PUT_INT(ipfilterOutAction);


	/************Place your code here, do what you want to do! ************/
	MIB_CE_IP_PORT_FILTER_T Mib_Entry;
	cnt = mib_chain_total(MIB_IP_PORT_FILTER_TBL);
	/************Place your code here, do what you want to do! ************/

	for(index = 0; index < cnt; index++)
	{
		/************Place your code here, do what you want to do! ************/
		memset(&entry, 0, sizeof(entry));
		if (!mib_chain_get(MIB_IP_PORT_FILTER_TBL, index, (void *)&Mib_Entry))
		{
			boaError(wp, 400, "Get chain record error!\n");
			return -1;
		}
		if (Mib_Entry.dir == DIR_IN)
		{
			continue;
		}
		memcpy(entry.filterName, Mib_Entry.name, sizeof(entry.filterName));
#if defined(CONFIG_CMCC) || defined(CONFIG_CU)
		memcpy(entry.WanPath, Mib_Entry.WanPath, sizeof(entry.WanPath));
#endif

		switch(Mib_Entry.protoType)
		{
			case PROTO_NONE:
				entry.protoType=0;
				break;
			case PROTO_TCP:
				entry.protoType=1;
				break;
			case PROTO_UDP:
				entry.protoType=2;
				break;
			case PROTO_UDPTCP:
				entry.protoType=3;
				break;
			case PROTO_ICMP:
				entry.protoType=4;
				break;
		}
		memcpy(&entry.sipStart, Mib_Entry.srcIp, 4);
		memcpy(&entry.sipEnd, Mib_Entry.srcIp2, 4);
		entry.smask=0xFFFFFFFF;
		if(Mib_Entry.smaskbit !=0)
			entry.smask =entry.smask<<(32-Mib_Entry.smaskbit);
		else
			entry.smask=0;
		memcpy(&entry.dipStart, Mib_Entry.dstIp, 4);
		memcpy(&entry.dipEnd, Mib_Entry.dstIp2, 4);
		entry.dmask=0xFFFFFFFF;
		if(Mib_Entry.dmaskbit !=0)
			entry.dmask =(entry.dmask<<(32-Mib_Entry.dmaskbit));
		else
			entry.dmask=0;
		entry.sportStart=Mib_Entry.srcPortFrom;
		entry.sportEnd=Mib_Entry.srcPortTo;
		entry.dportStart=Mib_Entry.dstPortFrom;
		entry.dportEnd=Mib_Entry.dstPortTo;
		entry.enable = Mib_Entry.enable;

#ifdef CONFIG_IPV6
		inet_ntop(PF_INET6, (struct in6_addr *)Mib_Entry.sip6Start, sip6StartStr, sizeof(sip6StartStr));
		inet_ntop(PF_INET6, (struct in6_addr *)Mib_Entry.sip6End, sip6EndStr, sizeof(sip6EndStr));
		inet_ntop(PF_INET6, (struct in6_addr *)Mib_Entry.dip6Start, dip6StartStr, sizeof(dip6StartStr));
		inet_ntop(PF_INET6, (struct in6_addr *)Mib_Entry.dip6End, dip6EndStr, sizeof(dip6EndStr));
#endif
#ifdef SUPPORT_TIME_SCHEDULE
		if(Mib_Entry.schedIndex)
			mib_chain_get(MIB_TIME_SCHEDULE_TBL, Mib_Entry.schedIndex-1, (void *)&schdEntry);
#endif
		/************Place your code here, do what you want to do! ************/

		boaWrite (wp, "push(new it_nr(\"%d\"" _PTS _PTI _PTS _PTS _PTS _PTS _PTS _PTS _PTI _PTI _PTI _PTI _PTI
#ifdef CONFIG_IPV6
		", \nnew it(\"IpProtocolType\",%d),\n"  	//ipv4 or ipv6
		"new it(\"sip6Start\",  \"%s\"),\n" 	//source ip6Start
		"new it(\"sip6End\",  \"%s\"),\n" 		//source ip6End
		"new it(\"dip6Start\",  \"%s\"),\n" 	//dst ip6Start
		"new it(\"dip6End\",  \"%s\"),\n" 		//dst ip6End
		"new it(\"sip6PrefixLen\",%d),\n"  	 	//source ip6 Prefix Len
		"new it(\"dip6PrefixLen\",%d)"  		//dst ip6 Prefix Len
#endif
#if defined(CONFIG_CMCC) || defined(CONFIG_CU)
		", \nnew it(\"WanPath\",  \"%s\")\n"		//WanPath
#endif
#ifdef SUPPORT_TIME_SCHEDULE
		", \nnew it(\"Schedule\",  \"%s\")\n"		//Schedule rule name
		", \nnew it(\"ScheduleIdex\",  %d)\n"		//Schedule rule index
#endif
		"));\n",
		index, _PME(filterName), _PME(protoType),
		_PMEIP(sipStart), _PMEIP(sipEnd), _PMEIP(smask), _PMEIP(dipStart), _PMEIP(dipEnd), _PMEIP(dmask),
		_PME(sportStart), _PME(sportEnd), _PME(dportStart), _PME(dportEnd), _PME(enable)
#ifdef CONFIG_IPV6
		, Mib_Entry.IpProtocol, sip6StartStr, sip6EndStr, dip6StartStr, dip6EndStr, Mib_Entry.sip6PrefixLen, Mib_Entry.dip6PrefixLen
#endif
#if defined(CONFIG_CMCC) || defined(CONFIG_CU)
		,entry.WanPath
#endif
#ifdef SUPPORT_TIME_SCHEDULE
		,(Mib_Entry.schedIndex)? schdEntry.name:scheduleName	//Schedule rule name
		,Mib_Entry.schedIndex								//Schedule rule index
#endif
		);
	}

check_err:
	_TRACE_LEAVEL;
	return 0;
}

#define NEW_ENTERPRISE_FIREWALLLEVEL 1
int initFirewallCfg(int eid, request *wp, int argc, char **argv)
{
	unsigned char	filterLevel = 0;
	unsigned char FirewallEn = 0;
	unsigned int dosEnble =0;
	unsigned char psdEnble = 0;
	unsigned int ArpCheatEn = 0,ArpfloodingEn = 0;

	int 			lineno = __LINE__;

	_TRACE_CALL;
	if (!mib_get(MIB_FW_ENABLE, (void *)&FirewallEn)) {
		printf("get fw grade fail\n");
	}
	boaWrite(wp, "FirewallCfg.FirewallEn = %d;\n", FirewallEn);
	if (!mib_get(MIB_FW_GRADE, (void *)&filterLevel)) {
		printf("get fw grade fail\n");
	}
	boaWrite(wp, "FirewallCfg.security_level = %d;\n", filterLevel);

	if (!mib_get(MIB_DOS_ENABLED, (void *)&dosEnble))
		printf("get DOS failed!\n");
	if( dosEnble & DOS_ENABLE)
		boaWrite(wp, "FirewallCfg.dosEnble = 1;\n");
	else
		boaWrite(wp, "FirewallCfg.dosEnble = 0;\n");

	if(!mib_get(MIB_PSD_ENABLE, (void *)&psdEnble))
		printf("get PSD fail!\n");
	boaWrite(wp, "FirewallCfg.psdEnble = %d;\n", psdEnble);
	if (!mib_get(MIB_ARP_CHEAT_ENABLED, (void *)&ArpCheatEn)) {
		printf("get ArpCheatEn failed!\n");
		goto check_err;
	}
	boaWrite(wp, "FirewallCfg.ArpCheatEn = %d;\n", ArpCheatEn);

	if (!mib_get(MIB_ARP_FLOODING_ENABLED, (void *)&ArpfloodingEn)) {
		printf("get ArpfloodingEn failed!\n");
		goto check_err;
	}
	boaWrite(wp, "FirewallCfg.ArpfloodingEn = %d;\n", ArpfloodingEn);

check_err:
	_TRACE_LEAVEL;
	return 0;
}

#endif


/*****************************
** 端口过滤
*/
int ipPortFilterConfig(int eid, request * wp, int argc, char ** argv)
{
	//IP地址过滤启用:
	unsigned char ipfilterEnable = 0;	//1- 启用;  0- 禁用
	int lineno = __LINE__;

	_TRACE_CALL;

	/************Place your code here, do what you want to do! ************/
	mib_get_s(MIB_IPFILTER_ON_OFF, (void*)&ipfilterEnable, sizeof(ipfilterEnable));
	/************Place your code here, do what you want to do! ************/

	_PUT_BOOL(ipfilterEnable);

check_err:
	_TRACE_LEAVEL;
	return 0;
}

#if defined(CONFIG_CMCC) || defined(CONFIG_CU)
int findIPFilterEntrybyNameDirection(char *name, int dir, MIB_CE_IP_PORT_FILTER_T *pEntry, int *pIndex);
int getTotalIPFilterNumOneDirection(int dir);
int parseIpFilterInfo2Entry(struct ipfilter_blacklist_entry *entry, MIB_CE_IP_PORT_FILTER_T *filterEntry, int direction);

int ipPortFilterDirConfig(int eid, request * wp, int argc, char ** argv)
{

	unsigned char ipfilterInEnable = 0;
	unsigned char ipfilterOutEnable = 0;
	unsigned char ipfilterInAction = 0;
	unsigned char ipfilterOutAction = 0;

	int lineno = __LINE__;

	_TRACE_CALL;

	/************Place your code here, do what you want to do! ************/
	mib_get_s(MIB_IPFILTER_IN_ENABLE, (void*)&ipfilterInEnable, sizeof(ipfilterInEnable));
	mib_get_s(MIB_IPFILTER_OUT_ENABLE, (void*)&ipfilterOutEnable, sizeof(ipfilterOutEnable));
	mib_get_s(MIB_IPF_IN_ACTION, (void*)&ipfilterInAction, sizeof(ipfilterInAction));
	mib_get_s(MIB_IPF_OUT_ACTION, (void*)&ipfilterOutAction, sizeof(ipfilterOutAction));

	/************Place your code here, do what you want to do! ************/

	_PUT_BOOL(ipfilterInEnable);
	_PUT_BOOL(ipfilterOutEnable);	
	_PUT_BOOL(ipfilterInAction);
	_PUT_BOOL(ipfilterOutAction);	

check_err:
	_TRACE_LEAVEL;
	return 0;
}
void formPortFilterIn(request * wp, char *path, char *query)
{
	unsigned char ipfilterInEnable = 0;		
	unsigned char ipFilterInMode = 0;
	unsigned char ipfilterInEnable_ori = 0;
	unsigned char ipfilterInMode_ori = 0;

	char *stemp = "";
	int lineno = __LINE__;
	unsigned char original_state = 0;
	_TRACE_CALL;
	mib_get_s(MIB_IPFILTER_IN_ENABLE, (void*)&ipfilterInEnable_ori, sizeof(ipfilterInEnable_ori));
	mib_get_s(MIB_IPF_IN_ACTION, (void*)&ipfilterInMode_ori, sizeof(ipfilterInMode_ori));
	printf("ipfilterInEnable_ori = %d ipfilterInMode_ori=%d\n", ipfilterInEnable_ori,ipfilterInMode_ori);

	//_GET_BOOL(ipfilterEnable, _NEED);
	FETCH_INVALID_OPT(stemp, "action", _NEED);
	/************Place your code here, do what you want to do! ************/
	if(strstr(stemp, "sw"))	//switch
	{
		_GET_BOOL(ipfilterInEnable, _NEED);
		if(ipfilterInEnable)
			ipfilterInEnable=1;
		else
			ipfilterInEnable=0;
		_GET_BOOL(ipFilterInMode, _NEED);
		if(ipFilterInMode)
			ipFilterInMode=1;
		else
			ipFilterInMode=0;
		//_GET_BOOL(ipfilterOutEnable, _NEED);
		printf("ipfilterInEnable = %d, ipFilterInMode=%d\n", ipfilterInEnable,ipFilterInMode);
		if((ipfilterInEnable^ipfilterInEnable_ori) || (ipFilterInMode^ipfilterInMode_ori)){
#if defined(CONFIG_CMCC) || defined(CONFIG_CU_BASEON_CMCC)
			syslog(LOG_CRIT, "Port Filter, DIR IN %s %s", ipfilterInEnable? "Enable":"Disable", ipfilterInEnable? (ipFilterInMode==0? ", Default Deny": ", Default Allow"):"");
#endif
			mib_set(MIB_IPFILTER_IN_ENABLE, &ipfilterInEnable);
			mib_set(MIB_IPF_IN_ACTION, &ipFilterInMode);
			restart_IPFilter_DMZ_MACFilter();
			mib_update(CURRENT_SETTING, CONFIG_MIB_ALL);
		}
	}	
#if 0
	mib_get_s(MIB_IPFILTER_ON_OFF, (void*)&original_state, sizeof(original_state));
	if(ipfilterEnable)
		ipfilterEnable=1;
	//printf("new=%d, old=%d, new^old=%d\n",ipfilterEnable, original_state, (ipfilterEnable^original_state));
	if(ipfilterEnable^original_state)
	{//mib set only if ipfitler switch changed...
		//printf("###%d###\n", ipfilterEnable);
		mib_set(MIB_IPFILTER_ON_OFF, (void*)&ipfilterEnable);
		//take effect immediate...
		//setupFirewall();
		restart_IPFilter_DMZ_MACFilter();
		//Write to flash, take effect forever
		mib_update(CURRENT_SETTING, CONFIG_MIB_ALL);
	}
#endif	
	/************Place your code here, do what you want to do! ************/

	_COND_REDIRECT;
check_err:
	_TRACE_LEAVEL;
	return;
}

void formPortFilterOut(request * wp, char *path, char *query)
{
	unsigned char ipfilterOutEnable = 0;		
	unsigned char ipFilterOutMode = 0;
	unsigned char ipfilterOutEnable_ori = 0;
	unsigned char ipfilterOutMode_ori = 0;

	char *stemp = "";
	int lineno = __LINE__;
	unsigned char original_state = 0;
	_TRACE_CALL;
	mib_get_s(MIB_IPFILTER_OUT_ENABLE, (void*)&ipfilterOutEnable_ori, sizeof(ipfilterOutEnable_ori));
	mib_get_s(MIB_IPF_OUT_ACTION, (void*)&ipfilterOutMode_ori, sizeof(ipfilterOutMode_ori));
	printf("ipfilterOutEnable_ori = %d ipfilterOutMode_ori=%d\n", ipfilterOutEnable_ori,ipfilterOutMode_ori);

	//_GET_BOOL(ipfilterEnable, _NEED);
	FETCH_INVALID_OPT(stemp, "action", _NEED);
	/************Place your code here, do what you want to do! ************/
	if(strstr(stemp, "sw"))	//switch
	{
		//_GET_BOOL(ipfilterInEnable, _NEED);
		_GET_BOOL(ipfilterOutEnable, _NEED);
		if(ipfilterOutEnable)
			ipfilterOutEnable=1;
		else
			ipfilterOutEnable=0;
		_GET_BOOL(ipFilterOutMode, _NEED);
		if(ipFilterOutMode)
			ipFilterOutMode=1;
		else
			ipFilterOutMode=0;
		printf("ipfilterOutEnable = %d ipFilterOutMode=%d\n", ipfilterOutEnable,ipFilterOutMode);
		//mib_set(MIB_IPFILTER_IN_ENABLE, &ipfilterInEnable);
		if((ipfilterOutEnable^ipfilterOutEnable_ori) || (ipFilterOutMode^ipfilterOutMode_ori)){
#if defined(CONFIG_CMCC) || defined(CONFIG_CU_BASEON_CMCC)
			syslog(LOG_CRIT, "Port Filter, DIR OUT %s %s", ipfilterOutEnable? "Enable":"Disable", ipfilterOutEnable? (ipFilterOutMode==0? ", Default Deny": ", Default Allow"):"");
#endif
			mib_set(MIB_IPFILTER_OUT_ENABLE, &ipfilterOutEnable);
			mib_set(MIB_IPF_OUT_ACTION, &ipFilterOutMode);
			restart_IPFilter_DMZ_MACFilter();
			mib_update(CURRENT_SETTING, CONFIG_MIB_ALL);
		}
	}	
#if 0
	mib_get_s(MIB_IPFILTER_ON_OFF, (void*)&original_state, sizeof(original_state));
	if(ipfilterEnable)
		ipfilterEnable=1;
	//printf("new=%d, old=%d, new^old=%d\n",ipfilterEnable, original_state, (ipfilterEnable^original_state));
	if(ipfilterEnable^original_state)
	{//mib set only if ipfitler switch changed...
		//printf("###%d###\n", ipfilterEnable);
		mib_set(MIB_IPFILTER_ON_OFF, (void*)&ipfilterEnable);
		//take effect immediate...
		//setupFirewall();
		restart_IPFilter_DMZ_MACFilter();
		//Write to flash, take effect forever
		mib_update(CURRENT_SETTING, CONFIG_MIB_ALL);
	}
#endif	
	/************Place your code here, do what you want to do! ************/

	_COND_REDIRECT;
check_err:
	_TRACE_LEAVEL;
	return;
}

int ipPortFilterBlacklistIn (int eid, request * wp, int argc, char ** argv)
{
	struct ipfilter_blacklist_entry	entry;
	char sipStart[16];
	char sipEnd[16];
	char smask[16];
	char dipStart[16];
	char dipEnd[16];
	char dmask[16];
	int cnt = 2;
	int index = 0;
	int lineno = __LINE__;
#ifdef CONFIG_IPV6
	unsigned char 	sip6StartStr[48], dip6StartStr[48], sip6EndStr[48], dip6EndStr[48];
#endif

	_TRACE_CALL;

	/************Place your code here, do what you want to do! ************/
	MIB_CE_IP_PORT_FILTER_T Mib_Entry;
	cnt = mib_chain_total(MIB_IP_PORT_FILTER_TBL);
	/************Place your code here, do what you want to do! ************/

	for(index = 0; index < cnt; index++)
	{
		/************Place your code here, do what you want to do! ************/
		memset(&entry, 0, sizeof(entry));
		if (!mib_chain_get(MIB_IP_PORT_FILTER_TBL, index, (void *)&Mib_Entry))
		{
 			boaError(wp, 400, "Get chain record error!\n");
			return -1;
		}
		if (Mib_Entry.dir == DIR_OUT) //incoming rules, which belong to white list...
		{
			continue;
		}
		memcpy(entry.filterName, Mib_Entry.name, sizeof(entry.filterName));
#if defined(CONFIG_CMCC) || defined(CONFIG_CU)
		memcpy(entry.WanPath, Mib_Entry.WanPath, sizeof(entry.WanPath));
#endif

		switch(Mib_Entry.protoType)
		{
			case PROTO_NONE:
				entry.protoType=0;
				break;
			case PROTO_UDPTCP:
				entry.protoType=1;
				break;
			case PROTO_TCP:
				entry.protoType=2;
				break;
			case PROTO_UDP:
				entry.protoType=3;
				break;
			case PROTO_ICMP:
				entry.protoType=4;
				break;
		}
		memcpy(&entry.sipStart, Mib_Entry.srcIp, 4);
		memcpy(&entry.sipEnd, Mib_Entry.srcIp2, 4);
		entry.smask=0xFFFFFFFF;
		if(Mib_Entry.smaskbit !=0)
			entry.smask =entry.smask<<(32-Mib_Entry.smaskbit);
		else
			entry.smask=0;
		memcpy(&entry.dipStart, Mib_Entry.dstIp, 4);
		memcpy(&entry.dipEnd, Mib_Entry.dstIp2, 4);
		entry.dmask=0xFFFFFFFF;
		if(Mib_Entry.dmaskbit !=0)
			entry.dmask =(entry.dmask<<(32-Mib_Entry.dmaskbit));
		else
			entry.dmask=0;
		entry.sportStart=Mib_Entry.srcPortFrom;
		entry.sportEnd=Mib_Entry.srcPortTo;
		entry.dportStart=Mib_Entry.dstPortFrom;
		entry.dportEnd=Mib_Entry.dstPortTo;
		entry.enable = Mib_Entry.enable;

#ifdef CONFIG_IPV6
		inet_ntop(PF_INET6, (struct in6_addr *)Mib_Entry.sip6Start, sip6StartStr, sizeof(sip6StartStr));
		inet_ntop(PF_INET6, (struct in6_addr *)Mib_Entry.sip6End, sip6EndStr, sizeof(sip6EndStr));
		inet_ntop(PF_INET6, (struct in6_addr *)Mib_Entry.dip6Start, dip6StartStr, sizeof(dip6StartStr));
		inet_ntop(PF_INET6, (struct in6_addr *)Mib_Entry.dip6End, dip6EndStr, sizeof(dip6EndStr));
#endif
		/************Place your code here, do what you want to do! ************/

		boaWrite (wp, "push(new it_nr(\"%d\"" _PTS_XSS _PTI _PTS _PTS _PTS _PTS _PTS _PTS _PTI _PTI _PTI _PTI _PTI
#ifdef CONFIG_IPV6
		", \nnew it(\"IpProtocolType\",%d),\n"  	//ipv4 or ipv6
		"new it(\"sip6Start\",  \"%s\"),\n" 	//source ip6Start
		"new it(\"sip6End\",  \"%s\"),\n" 		//source ip6End
		"new it(\"dip6Start\",  \"%s\"),\n" 	//dst ip6Start
		"new it(\"dip6End\",  \"%s\"),\n" 		//dst ip6End
		"new it(\"sip6PrefixLen\",%d),\n"  	 	//source ip6 Prefix Len
		"new it(\"dip6PrefixLen\",%d)"  		//dst ip6 Prefix Len
#endif
#if defined(CONFIG_CMCC) || defined(CONFIG_CU)
		", \nnew it(\"WanPath\",  \"%s\")\n"		//WanPath
#endif

		"));\n",
		index, _PME_XSS(filterName), _PME(protoType),
		_PMEIP(sipStart), _PMEIP(sipEnd), _PMEIP(smask), _PMEIP(dipStart), _PMEIP(dipEnd), _PMEIP(dmask),
		_PME(sportStart), _PME(sportEnd), _PME(dportStart), _PME(dportEnd), _PME(enable)
#ifdef CONFIG_IPV6
		, Mib_Entry.IpProtocol, sip6StartStr, sip6EndStr, dip6StartStr, dip6EndStr, Mib_Entry.sip6PrefixLen, Mib_Entry.dip6PrefixLen
#endif
#if defined(CONFIG_CMCC) || defined(CONFIG_CU)
		,entry.WanPath
#endif
		);
	}

check_err:
	_TRACE_LEAVEL;
	return 0;
}

int ipPortFilterBlacklistOut (int eid, request * wp, int argc, char ** argv)
{
	struct ipfilter_blacklist_entry	entry;
	char sipStart[16];
	char sipEnd[16];
	char smask[16];
	char dipStart[16];
	char dipEnd[16];
	char dmask[16];
	int cnt = 2;
	int index = 0;
	int lineno = __LINE__;
#ifdef CONFIG_IPV6
	unsigned char 	sip6StartStr[48], dip6StartStr[48], sip6EndStr[48], dip6EndStr[48];
#endif

	_TRACE_CALL;

	/************Place your code here, do what you want to do! ************/
	MIB_CE_IP_PORT_FILTER_T Mib_Entry;
	cnt = mib_chain_total(MIB_IP_PORT_FILTER_TBL);
	/************Place your code here, do what you want to do! ************/

	for(index = 0; index < cnt; index++)
	{
		/************Place your code here, do what you want to do! ************/
		memset(&entry, 0, sizeof(entry));
		if (!mib_chain_get(MIB_IP_PORT_FILTER_TBL, index, (void *)&Mib_Entry))
		{
 			boaError(wp, 400, "Get chain record error!\n");
			return -1;
		}
		if (Mib_Entry.dir == DIR_IN) //incoming rules, which belong to white list...
		{
			continue;
		}
		memcpy(entry.filterName, Mib_Entry.name, sizeof(entry.filterName));
		switch(Mib_Entry.protoType)
		{
			case PROTO_NONE:
				entry.protoType=0;
				break;
			case PROTO_UDPTCP:
				entry.protoType=1;
				break;
			case PROTO_TCP:
				entry.protoType=2;
				break;
			case PROTO_UDP:
				entry.protoType=3;
				break;
			case PROTO_ICMP:
				entry.protoType=4;
				break;
		}
		memcpy(&entry.sipStart, Mib_Entry.srcIp, 4);
		memcpy(&entry.sipEnd, Mib_Entry.srcIp2, 4);
		entry.smask=0xFFFFFFFF;
		if(Mib_Entry.smaskbit !=0)
			entry.smask =entry.smask<<(32-Mib_Entry.smaskbit);
		else
			entry.smask=0;
		memcpy(&entry.dipStart, Mib_Entry.dstIp, 4);
		memcpy(&entry.dipEnd, Mib_Entry.dstIp2, 4);
		entry.dmask=0xFFFFFFFF;
		if(Mib_Entry.dmaskbit !=0)
			entry.dmask =(entry.dmask<<(32-Mib_Entry.dmaskbit));
		else
			entry.dmask=0;
		entry.sportStart=Mib_Entry.srcPortFrom;
		entry.sportEnd=Mib_Entry.srcPortTo;
		entry.dportStart=Mib_Entry.dstPortFrom;
		entry.dportEnd=Mib_Entry.dstPortTo;
		entry.enable = Mib_Entry.enable;
#ifdef CONFIG_IPV6
		inet_ntop(PF_INET6, (struct in6_addr *)Mib_Entry.sip6Start, sip6StartStr, sizeof(sip6StartStr));
		inet_ntop(PF_INET6, (struct in6_addr *)Mib_Entry.sip6End, sip6EndStr, sizeof(sip6EndStr));
		inet_ntop(PF_INET6, (struct in6_addr *)Mib_Entry.dip6Start, dip6StartStr, sizeof(dip6StartStr));
		inet_ntop(PF_INET6, (struct in6_addr *)Mib_Entry.dip6End, dip6EndStr, sizeof(dip6EndStr));
#endif
		/************Place your code here, do what you want to do! ************/

		boaWrite (wp, "push(new it_nr(\"%d\"" _PTS_XSS _PTI _PTS _PTS _PTS _PTS _PTS _PTS _PTI _PTI _PTI _PTI _PTI
#ifdef CONFIG_IPV6
		", \nnew it(\"IpProtocolType\",%d),\n"  	//ipv4 or ipv6
		"new it(\"sip6Start\",  \"%s\"),\n" 	//source ip6Start
		"new it(\"sip6End\",  \"%s\"),\n" 		//source ip6End
		"new it(\"dip6Start\",  \"%s\"),\n" 	//dst ip6Start
		"new it(\"dip6End\",  \"%s\"),\n" 		//dst ip6End
		"new it(\"sip6PrefixLen\",%d),\n"  	 	//source ip6 Prefix Len
		"new it(\"dip6PrefixLen\",%d)\n"  		//dst ip6 Prefix Len
#endif
		"));\n",
		index, _PME_XSS(filterName), _PME(protoType),
		_PMEIP(sipStart), _PMEIP(sipEnd), _PMEIP(smask), _PMEIP(dipStart), _PMEIP(dipEnd), _PMEIP(dmask),
		_PME(sportStart), _PME(sportEnd), _PME(dportStart), _PME(dportEnd),  _PME(enable)
#ifdef CONFIG_IPV6
		, Mib_Entry.IpProtocol, sip6StartStr, sip6EndStr, dip6StartStr, dip6EndStr, Mib_Entry.sip6PrefixLen, Mib_Entry.dip6PrefixLen
#endif
		);
	}

check_err:
	_TRACE_LEAVEL;
	return 0;
}

int ipPortFilterWhitelistIn (int eid, request * wp, int argc, char ** argv)
{
	struct ipfilter_whitelist_entry	entry;
	char sipStart[16];
	char sipEnd[16];
	char smask[16];
	char dipStart[16];
	char dipEnd[16];
	char dmask[16];
	char ifname[1024] = "INTERNET_R_0_0_32;INTERNET_R_0_8_35";
	int cnt = 2;
	int index = 0;
	int lineno = __LINE__;
#ifdef CONFIG_IPV6
	unsigned char 	sip6StartStr[48], dip6StartStr[48], sip6EndStr[48], dip6EndStr[48];
#endif

	_TRACE_CALL;

	/************Place your code here, do what you want to do! ************/
	MIB_CE_IP_PORT_FILTER_T Mib_Entry;
	cnt = mib_chain_total(MIB_IP_PORT_FILTER_TBL);
	/************Place your code here, do what you want to do! ************/

	for(index = 0; index < cnt; index++)
	{
		/************Place your code here, do what you want to do! ************/
		memset(&entry, 0, sizeof(entry));
		if (!mib_chain_get(MIB_IP_PORT_FILTER_TBL, index, (void *)&Mib_Entry))
		{
  		boaError(wp, 400, "读取chain record错误!\n"); //Get chain record error!
			return -1;
		}
		if (Mib_Entry.dir == DIR_OUT) //outgoing rules, which belong to black list...
		{
			continue;
		}
		memcpy(entry.filterName, Mib_Entry.name, sizeof(entry.filterName));
#if defined(CONFIG_CMCC) || defined(CONFIG_CU)
		memcpy(entry.WanPath, Mib_Entry.WanPath, sizeof(entry.WanPath));
#endif
		switch(Mib_Entry.protoType)
		{
			case PROTO_NONE:
				entry.protoType=0;
				break;
			case PROTO_UDPTCP:
				entry.protoType=1;
				break;
			case PROTO_TCP:
				entry.protoType=2;
				break;
			case PROTO_UDP:
				entry.protoType=3;
				break;
			case PROTO_ICMP:
				entry.protoType=4;
				break;
		}
		memcpy(&entry.sipStart, Mib_Entry.srcIp, 4);
		memcpy(&entry.sipEnd, Mib_Entry.srcIp2, 4);
		entry.smask=0xFFFFFFFF;
		if(Mib_Entry.smaskbit !=0)
			entry.smask =entry.smask<<(32-Mib_Entry.smaskbit);
		else
			entry.smask=0;
		memcpy(&entry.dipStart, Mib_Entry.dstIp, 4);
		memcpy(&entry.dipEnd, Mib_Entry.dstIp2, 4);
		entry.dmask=0xFFFFFFFF;
		if(Mib_Entry.dmaskbit !=0)
			entry.dmask =(entry.dmask<<(32-Mib_Entry.dmaskbit));
		else
			entry.dmask=0;
		entry.sportStart=Mib_Entry.srcPortFrom;
		entry.sportEnd=Mib_Entry.srcPortTo;
		entry.dportStart=Mib_Entry.dstPortFrom;
		entry.dportEnd=Mib_Entry.dstPortTo;
		entry.enable = Mib_Entry.enable;

#ifdef CONFIG_IPV6
		inet_ntop(PF_INET6, (struct in6_addr *)Mib_Entry.sip6Start, sip6StartStr, sizeof(sip6StartStr));
		inet_ntop(PF_INET6, (struct in6_addr *)Mib_Entry.sip6End, sip6EndStr, sizeof(sip6EndStr));
		inet_ntop(PF_INET6, (struct in6_addr *)Mib_Entry.dip6Start, dip6StartStr, sizeof(dip6StartStr));
		inet_ntop(PF_INET6, (struct in6_addr *)Mib_Entry.dip6End, dip6EndStr, sizeof(dip6EndStr));
#endif
		/************Place your code here, do what you want to do! ************/

		boaWrite (wp, "push(new it_nr(\"%d\"" _PTS_XSS _PTI _PTS _PTS _PTS _PTS _PTS _PTS _PTI _PTI _PTI _PTI _PTI _PTI _PTS _PTI
#ifdef CONFIG_IPV6
		", \nnew it(\"IpProtocolType\",%d),\n"  //ipv4 or ipv6
		"new it(\"sip6Start\",  \"%s\"),\n" 	//source ip6Start
		"new it(\"sip6End\",  \"%s\"),\n" 		//source ip6End
		"new it(\"dip6Start\",  \"%s\"),\n" 	//dst ip6Start
		"new it(\"dip6End\",  \"%s\"),\n" 		//dst ip6End
		"new it(\"sip6PrefixLen\",%d),\n"  	 	//source ip6 Prefix Len
		"new it(\"dip6PrefixLen\",%d)\n"  		//dst ip6 Prefix Len
#endif
#if defined(CONFIG_CMCC) || defined(CONFIG_CU)
		", \nnew it(\"WanPath\",  \"%s\")\n"		//WanPath
#endif
		"));\n",
		index, _PME_XSS(filterName), _PME(protoType),
		_PMEIP(sipStart), _PMEIP(sipEnd), _PMEIP(smask), _PMEIP(dipStart), _PMEIP(dipEnd), _PMEIP(dmask),
		_PME(sportStart), _PME(sportEnd), _PME(dportStart), _PME(dportEnd), _PME(allport), _PME(portnum), _PMEX(ifname), _PME(enable)
#ifdef CONFIG_IPV6
		, Mib_Entry.IpProtocol, sip6StartStr, sip6EndStr, dip6StartStr, dip6EndStr, Mib_Entry.sip6PrefixLen, Mib_Entry.dip6PrefixLen
#endif
#if defined(CONFIG_CMCC) || defined(CONFIG_CU)
		,entry.WanPath
#endif
		);
	}
	_TRACE_LEAVEL;
	return 0;
}
int ipPortFilterWhitelistOut (int eid, request * wp, int argc, char ** argv)
{
	struct ipfilter_whitelist_entry	entry;
	char sipStart[16];
	char sipEnd[16];
	char smask[16];
	char dipStart[16];
	char dipEnd[16];
	char dmask[16];
	char ifname[1024] = "INTERNET_R_0_0_32;INTERNET_R_0_8_35";
	int cnt = 2;
	int index = 0;
	int lineno = __LINE__;
#ifdef CONFIG_IPV6
	unsigned char 	sip6StartStr[48], dip6StartStr[48], sip6EndStr[48], dip6EndStr[48];
#endif

	_TRACE_CALL;

	/************Place your code here, do what you want to do! ************/
	MIB_CE_IP_PORT_FILTER_T Mib_Entry;
	cnt = mib_chain_total(MIB_IP_PORT_FILTER_TBL);
	/************Place your code here, do what you want to do! ************/

	for(index = 0; index < cnt; index++)
	{
		/************Place your code here, do what you want to do! ************/
		memset(&entry, 0, sizeof(entry));
		if (!mib_chain_get(MIB_IP_PORT_FILTER_TBL, index, (void *)&Mib_Entry))
		{
  		boaError(wp, 400, "读取chain record错误!\n"); //Get chain record error!
			return -1;
		}
		if (Mib_Entry.dir == DIR_IN) //outgoing rules, which belong to black list...
		{
			continue;
		}
		memcpy(entry.filterName, Mib_Entry.name, sizeof(entry.filterName));
		switch(Mib_Entry.protoType)
		{
			case PROTO_NONE:
				entry.protoType=0;
				break;
			case PROTO_UDPTCP:
				entry.protoType=1;
				break;
			case PROTO_TCP:
				entry.protoType=2;
				break;
			case PROTO_UDP:
				entry.protoType=3;
				break;
			case PROTO_ICMP:
				entry.protoType=4;
				break;
		}
		memcpy(&entry.sipStart, Mib_Entry.srcIp, 4);
		memcpy(&entry.sipEnd, Mib_Entry.srcIp2, 4);
		entry.smask=0xFFFFFFFF;
		if(Mib_Entry.smaskbit !=0)
			entry.smask =entry.smask<<(32-Mib_Entry.smaskbit);
		else
			entry.smask=0;
		memcpy(&entry.dipStart, Mib_Entry.dstIp, 4);
		memcpy(&entry.dipEnd, Mib_Entry.dstIp2, 4);
		entry.dmask=0xFFFFFFFF;
		if(Mib_Entry.dmaskbit !=0)
			entry.dmask =(entry.dmask<<(32-Mib_Entry.dmaskbit));
		else
			entry.dmask=0;
		entry.sportStart=Mib_Entry.srcPortFrom;
		entry.sportEnd=Mib_Entry.srcPortTo;
		entry.dportStart=Mib_Entry.dstPortFrom;
		entry.dportEnd=Mib_Entry.dstPortTo;
		entry.enable = Mib_Entry.enable;

#ifdef CONFIG_IPV6
		inet_ntop(PF_INET6, (struct in6_addr *)Mib_Entry.sip6Start, sip6StartStr, sizeof(sip6StartStr));
		inet_ntop(PF_INET6, (struct in6_addr *)Mib_Entry.sip6End, sip6EndStr, sizeof(sip6EndStr));
		inet_ntop(PF_INET6, (struct in6_addr *)Mib_Entry.dip6Start, dip6StartStr, sizeof(dip6StartStr));
		inet_ntop(PF_INET6, (struct in6_addr *)Mib_Entry.dip6End, dip6EndStr, sizeof(dip6EndStr));
#endif
		/************Place your code here, do what you want to do! ************/

		boaWrite (wp, "push(new it_nr(\"%d\"" _PTS_XSS _PTI _PTS _PTS _PTS _PTS _PTS _PTS _PTI _PTI _PTI _PTI _PTI _PTI _PTS _PTI
#ifdef CONFIG_IPV6
		", \nnew it(\"IpProtocolType\",%d),\n"  //ipv4 or ipv6
		"new it(\"sip6Start\",  \"%s\"),\n" 	//source ip6Start
		"new it(\"sip6End\",  \"%s\"),\n" 		//source ip6End
		"new it(\"dip6Start\",  \"%s\"),\n" 	//dst ip6Start
		"new it(\"dip6End\",  \"%s\"),\n" 		//dst ip6End
		"new it(\"sip6PrefixLen\",%d),\n"  	 	//source ip6 Prefix Len
		"new it(\"dip6PrefixLen\",%d)\n"  		//dst ip6 Prefix Len
#endif
		"));\n",
		index, _PME_XSS(filterName), _PME(protoType),
		_PMEIP(sipStart), _PMEIP(sipEnd), _PMEIP(smask), _PMEIP(dipStart), _PMEIP(dipEnd), _PMEIP(dmask),
		_PME(sportStart), _PME(sportEnd), _PME(dportStart), _PME(dportEnd), _PME(allport), _PME(portnum), _PMEX(ifname), _PME(enable)
#ifdef CONFIG_IPV6
		, Mib_Entry.IpProtocol, sip6StartStr, sip6EndStr, dip6StartStr, dip6EndStr, Mib_Entry.sip6PrefixLen, Mib_Entry.dip6PrefixLen
#endif
		);
	}
	_TRACE_LEAVEL;
	return 0;
}

#define LOG_ADD_FIELD_STR(str, name, content) { if(content[0]) snprintf(str+strlen(str), sizeof(str)-strlen(str), " %s %s", name, content); }
#define LOG_ADD_FIELD_INT(str, name, content) { if(content) snprintf(str+strlen(str), sizeof(str)-strlen(str), " %s %d", name, content); }

static void getIPPortFilterMibEntry(MIB_CE_IP_PORT_FILTER_T Mib_Entry, char *str, int add)
{
	char protoType[32]={0};
	char sipStart[32]={0};
	char sipEnd[32]={0};
	char smask[32]={0};
	unsigned int smask_value;
	char dipStart[32]={0};
	char dipEnd[32]={0};
	char dmask[32]={0};
	unsigned int dmask_value;
#ifdef CONFIG_IPV6
	unsigned char 	sip6StartStr[48], dip6StartStr[48], sip6EndStr[48], dip6EndStr[48];
#endif

	switch(Mib_Entry.protoType)
	{
		case PROTO_NONE:
			strcpy(protoType, "");
			break;
		case PROTO_UDPTCP:
			strcpy(protoType, "TCP/UDP");
			break;
		case PROTO_TCP:
			strcpy(protoType, "TCP");
			break;
		case PROTO_UDP:
			strcpy(protoType, "UDP");
			break;
		case PROTO_ICMP:
			strcpy(protoType, "ICMP");
			break;
	}
	if(memcmp(Mib_Entry.srcIp, "\x00\x00\x00\x00", IP_ADDR_LEN) != 0){
		//strcpy(sipStart, inet_ntoa(*(struct in_addr*)Mib_Entry.srcIp));
		sipStart[sizeof(sipStart)-1]='\0';
		strncpy(sipStart, inet_ntoa(*(struct in_addr*)Mib_Entry.srcIp), sizeof(sipStart)-1);
	}
	if(memcmp(Mib_Entry.srcIp2, "\x00\x00\x00\x00", IP_ADDR_LEN) != 0){
		//strcpy(sipEnd, inet_ntoa(*(struct in_addr*)Mib_Entry.srcIp2));
		sipEnd[sizeof(sipEnd)-1]='\0';
		strncpy(sipEnd, inet_ntoa(*(struct in_addr*)Mib_Entry.srcIp2), sizeof(sipEnd)-1);
	}
	if(Mib_Entry.smaskbit !=0){
		smask_value = 0xFFFFFFFF<<(32-Mib_Entry.smaskbit);
		//strcpy(smask, inet_ntoa(*(struct in_addr*)&smask_value));
		smask[sizeof(smask)-1]='\0';
		strncpy(smask, inet_ntoa(*(struct in_addr*)&smask_value), sizeof(smask)-1);
	}

	if(memcmp(Mib_Entry.dstIp, "\x00\x00\x00\x00", IP_ADDR_LEN) != 0){
		//strcpy(dipStart, inet_ntoa(*(struct in_addr*)Mib_Entry.dstIp));
		dipStart[sizeof(dipStart)-1]='\0';
		strncpy(dipStart, inet_ntoa(*(struct in_addr*)Mib_Entry.dstIp), sizeof(dipStart)-1);
	}
	if(memcmp(Mib_Entry.dstIp2, "\x00\x00\x00\x00", IP_ADDR_LEN) != 0){
		//strcpy(dipEnd, inet_ntoa(*(struct in_addr*)Mib_Entry.dstIp2));
		dipEnd[sizeof(dipEnd)-1]='\0';
		strncpy(dipEnd, inet_ntoa(*(struct in_addr*)Mib_Entry.dstIp2), sizeof(dipEnd)-1);
	}
	if(Mib_Entry.dmaskbit !=0){
		dmask_value = 0xFFFFFFFF<<(32-Mib_Entry.dmaskbit);
		//strcpy(dmask, inet_ntoa(*(struct in_addr*)&dmask_value));
		dmask[sizeof(dmask)-1]='\0';
		strncpy(dmask, inet_ntoa(*(struct in_addr*)&dmask_value), sizeof(dmask)-1);
	}

#ifdef CONFIG_IPV6
		inet_ntop(PF_INET6, (struct in6_addr *)Mib_Entry.sip6Start, sip6StartStr, sizeof(sip6StartStr));
		inet_ntop(PF_INET6, (struct in6_addr *)Mib_Entry.sip6End, sip6EndStr, sizeof(sip6EndStr));
		inet_ntop(PF_INET6, (struct in6_addr *)Mib_Entry.dip6Start, dip6StartStr, sizeof(dip6StartStr));
		inet_ntop(PF_INET6, (struct in6_addr *)Mib_Entry.dip6End, dip6EndStr, sizeof(dip6EndStr));
#endif

	snprintf(str, 1024, "%s", add? "add":"delete");
	LOG_ADD_FIELD_STR(str, "filterName", Mib_Entry.name);
	snprintf(str+strlen(str), sizeof(str)-strlen(str), " %s", Mib_Entry.enable? "Enable":"Disable");
	LOG_ADD_FIELD_STR(str, "WanPath", Mib_Entry.WanPath);
	LOG_ADD_FIELD_STR(str, "protocolType", protoType);
	LOG_ADD_FIELD_STR(str, "sipStart", sipStart);
	LOG_ADD_FIELD_STR(str, "sipEnd", sipEnd);
	LOG_ADD_FIELD_STR(str, "smask", smask);
	LOG_ADD_FIELD_STR(str, "dipStart", dipStart);
	LOG_ADD_FIELD_STR(str, "dipEnd", dipEnd);
	LOG_ADD_FIELD_STR(str, "dmask", dmask);
	LOG_ADD_FIELD_STR(str, "dmask", dmask);
	LOG_ADD_FIELD_INT(str, "sportStart", Mib_Entry.srcPortFrom);
	LOG_ADD_FIELD_INT(str, "sportEnd", Mib_Entry.srcPortTo);
	LOG_ADD_FIELD_INT(str, "dportStart", Mib_Entry.dstPortFrom);
	LOG_ADD_FIELD_INT(str, "dportEnd", Mib_Entry.dstPortTo);

}

void formPortFilterBlackOut(request * wp, char *path, char *query)
{
	struct ipfilter_blacklist_entry entry;
	char* stemp = "";
	int lineno = __LINE__;
	int index = -1;
	MIB_CE_IP_PORT_FILTER_T filterEntry;
	char ret;
	_BC_USE;
#ifdef CONFIG_IPV6
	char *str, ipv6_protoType=0;
#endif
	char output_str[1024]={0};

	_TRACE_CALL;
	FETCH_INVALID_OPT(stemp, "action", _NEED);
	//AUG_PRT("stemp=%s\n",stemp);
	if(strcmp(stemp, "rm") == 0)	//remove
	{
		int i;
		const char *name = NULL;
		_BC_INIT("bcdata");

		//reverse delete to avoid index panic
		for(i = _BC_ITCNT()-1 ; i >=0 ; i--)
		{
			if(bc_seek(bc, i, 0) < 0)
				continue;

			name = bc_gets(bc, "name");
			index = strtol(name, NULL, 10);

			if(mib_chain_get(MIB_IP_PORT_FILTER_TBL, index, &filterEntry) == 1)
			{
				mib_chain_delete(MIB_IP_PORT_FILTER_TBL, index);
				getIPPortFilterMibEntry(filterEntry, output_str, 0);
				//printf("%s\n", output_str);
				syslog(LOG_CRIT, "Port Filter DIR OUT BlackList, %s", output_str);
			}
		}

		restart_IPFilter_DMZ_MACFilter();
		_BC_FREE();
		boaRefreshParent(wp, "/secu_portfilter_cfg.asp");
		return;
	}
	else if(strcmp(stemp, "ad") == 0)	//add
	{
		memset(&entry, 0, sizeof(entry));

		_ENTRY_STR(filterName, _NEED);
		_ENTRY_INT(protoType, _NEED);
		//if(entry.protoType > 4){lineno = __LINE__; goto check_err;}
		_ENTRY_IP(sipStart, _OPT);
		_ENTRY_IP(sipEnd, _OPT);
		_ENTRY_IP(smask, _OPT);
		_ENTRY_IP(dipStart, _OPT);
		_ENTRY_IP(dipEnd, _OPT);
		_ENTRY_IP(dmask, _OPT);
		_ENTRY_INT(sportStart, _OPT);
		_ENTRY_INT(sportEnd, _OPT);
		entry.enable = 1;

		if(entry.sportEnd == 0)
			entry.sportEnd = entry.sportStart;
		
		if(entry.sportEnd < entry.sportStart){lineno = __LINE__; goto check_err;}

		_ENTRY_INT(dportStart, _OPT);
		_ENTRY_INT(dportEnd, _OPT);
		
		if(entry.dportEnd == 0)
			entry.dportEnd = entry.dportStart;
		
		if(entry.dportEnd < entry.dportStart){lineno = __LINE__; goto check_err;}

		/************Place your code here, do what you want to do! ************/
		/*add new*/
		//jim double check the parameters validity.
		if(!entry.sipStart)
		{
			entry.smask=0;
			entry.sipEnd=0;
		}
		if(!entry.dipStart)
		{
			entry.dmask=0;
			entry.dipEnd=0;
		}
#ifdef CONFIG_IPV6
		str = boaGetVar(wp, "protoTypeV6", "");
		if (str[0]) {
			ipv6_protoType = (char)atoi(str);
		}

		if(entry.protoType == 0 && ipv6_protoType == 0) //None proto... don't care ,, all.
#else
		if(entry.protoType == 0) //None proto... don't care ,, all.
#endif
		{    //mask off port info...
			entry.sportStart=0;
			entry.sportEnd=0;
			entry.dportStart=0;
			entry.dportEnd=0;
		}
		{		// IP/Port FILTER
			MIB_CE_IP_PORT_FILTER_T filterEntry;
			// if the exist entry with the same name, abandon the add action...
			if(findIPFilterEntrybyNameDirection(entry.filterName, DIR_OUT, NULL, NULL) \
				|| getTotalIPFilterNumOneDirection(DIR_OUT) > MAX_OUTGOING_IPFILTER_RULE_NUM)
				goto check_err;
#ifdef CONFIG_IPV6
			str = boaGetVar(wp, "IpProtocolType", "");
			filterEntry.IpProtocol = (char)atoi(str);
			// If it is a IPv6 rule. Save the protoType into  ipfilter_whitelist data base.
			// Because the parseIpFilterInfo2Entry() will clean the MIB's ipportfilter_entry.
			if ( filterEntry.IpProtocol == IPVER_IPV6 )
				entry.protoType = ipv6_protoType;
#endif
			parseIpFilterInfo2Entry(&entry, &filterEntry, DIR_OUT);

#ifdef CONFIG_IPV6
			// If it is a IPv6 rule.
			if ( filterEntry.IpProtocol == IPVER_IPV6 )
			{
				str = boaGetVar(wp, "sip6Start", "");
				if (str[0]) {
					if (!inet_pton(PF_INET6, str, &filterEntry.sip6Start)) {
						printf("Invalid sip6Start for ipport filter!");
						goto check_err;
					}
				}

				str = boaGetVar(wp, "sip6End", "");
				if (str[0]) {
					if (!inet_pton(PF_INET6, str, &filterEntry.sip6End)) {
						printf("Invalid sip6End for ipport filter!");
						goto check_err;
					}
				}

				str = boaGetVar(wp, "dip6Start", "");
				if (str[0]) {
					if (!inet_pton(PF_INET6, str, &filterEntry.dip6Start)) {
						printf("Invalid dip6Start for ipport filter!");
						goto check_err;
					}
				}

				str = boaGetVar(wp, "dip6End", "");
				if (str[0]) {
					if (!inet_pton(PF_INET6, str, &filterEntry.dip6End)) {
						printf("Invalid dip6End for ipport filter!");
						goto check_err;
					}
				}

				str = boaGetVar(wp, "sip6PrefixLen", "");
				filterEntry.sip6PrefixLen = (char)atoi(str);

				str = boaGetVar(wp, "dip6PrefixLen", "");
				filterEntry.dip6PrefixLen = (char)atoi(str);
			}
#endif
			ret = mib_chain_add(MIB_IP_PORT_FILTER_TBL, (unsigned char*)&filterEntry);
			if(ret == -1)
				goto Max_Size_Reached;
			else if( ret == 0 )
				goto check_err;

#if defined(CONFIG_CMCC) || defined(CONFIG_CU_BASEON_CMCC)
			getIPPortFilterMibEntry(filterEntry, output_str, 1);
			//printf("%s\n", output_str);
			syslog(LOG_CRIT, "Port Filter DIR OUT BlackList, %s", output_str);
#endif
			
			//take effect immediate
			restart_IPFilter_DMZ_MACFilter();
		}
		/************Place your code here, do what you want to do! ************/
	}
	else {lineno = __LINE__; goto check_err;}
	//Write to flash, take effect forever
	mib_update(CURRENT_SETTING, CONFIG_MIB_ALL);
	_COND_REDIRECT;
Max_Size_Reached:
	_BC_FREE();
	_TRACE_LEAVEL;
	ERR_MSG("规则数已达最大限制!"); //Max number of rules reached!
	return;
check_err:
	_BC_FREE();
	_TRACE_LEAVEL;
	ERR_MSG("设定错误!");
	return;
}

void formPortFilterBlackIn(request * wp, char *path, char *query)
{
	struct ipfilter_blacklist_entry entry;
	char* stemp = "";
	int lineno = __LINE__;
	int index = -1;
	MIB_CE_IP_PORT_FILTER_T filterEntry;
	char ret;
	_BC_USE;
#ifdef CONFIG_IPV6
	char *str, ipv6_protoType=0;
#endif
	char output_str[1024]={0};

	_TRACE_CALL;

	FETCH_INVALID_OPT(stemp, "action", _NEED);
	//AUG_PRT("stemp=%s\n",stemp);

	if(strcmp(stemp, "rm") == 0)	//remove
	{
		int i;
		const char *name = NULL;
		_BC_INIT("bcdata");

		//reverse delete to avoid index panic
		for(i = _BC_ITCNT()-1 ; i >=0 ; i--)
		{
			if(bc_seek(bc, i, 0) < 0)
				continue;

			name = bc_gets(bc, "name");
			index = strtol(name, NULL, 10);

			if(mib_chain_get(MIB_IP_PORT_FILTER_TBL, index, &filterEntry) == 1)
			{
				mib_chain_delete(MIB_IP_PORT_FILTER_TBL, index);
				getIPPortFilterMibEntry(filterEntry, output_str, 0);
				//printf("%s\n", output_str);
				syslog(LOG_CRIT, "Port Filter DIR IN BlackList, %s", output_str);
			}
		}

		restart_IPFilter_DMZ_MACFilter();
		_BC_FREE();
		boaRefreshParent(wp, "/secu_portfilter_cfg.asp");
		return;
	}
	else if(strcmp(stemp, "ad") == 0)	//add
	{
		memset(&entry, 0, sizeof(entry));

		_ENTRY_STR(filterName, _NEED);
		_ENTRY_INT(protoType, _NEED);
		//if(entry.protoType > 4){lineno = __LINE__; goto check_err;}
		_ENTRY_IP(sipStart, _OPT);
		_ENTRY_IP(sipEnd, _OPT);
		_ENTRY_IP(smask, _OPT);
		_ENTRY_IP(dipStart, _OPT);
		_ENTRY_IP(dipEnd, _OPT);
		_ENTRY_IP(dmask, _OPT);
		_ENTRY_INT(sportStart, _OPT);
		_ENTRY_INT(sportEnd, _OPT);
#if defined(CONFIG_CMCC) || defined(CONFIG_CU)
		_ENTRY_STR(WanPath, _NEED);
#endif		
		entry.enable = 1;
		if(entry.sportEnd == 0)
			entry.sportEnd = entry.sportStart;
		
		if(entry.sportEnd < entry.sportStart){lineno = __LINE__; goto check_err;}

		_ENTRY_INT(dportStart, _OPT);
		_ENTRY_INT(dportEnd, _OPT);
		
		if(entry.dportEnd == 0)
			entry.dportEnd = entry.dportStart;
		
		if(entry.dportEnd < entry.dportStart){lineno = __LINE__; goto check_err;}

		/************Place your code here, do what you want to do! ************/
		/*add new*/
		//jim double check the parameters validity.
		if(!entry.sipStart)
		{
			entry.smask=0;
			entry.sipEnd=0;
		}
		if(!entry.dipStart)
		{
			entry.dmask=0;
			entry.dipEnd=0;
		}
#ifdef CONFIG_IPV6
		str = boaGetVar(wp, "protoTypeV6", "");
		if (str[0]) {
			ipv6_protoType = (char)atoi(str);
		}

		if(entry.protoType == 0 && ipv6_protoType == 0) //None proto... don't care ,, all.
#else
		if(entry.protoType == 0) //None proto... don't care ,, all.
#endif
		{    //mask off port info...
			entry.sportStart=0;
			entry.sportEnd=0;
			entry.dportStart=0;
			entry.dportEnd=0;
		}
		{		// IP/Port FILTER
			MIB_CE_IP_PORT_FILTER_T filterEntry;
			// if the exist entry with the same name, abandon the add action...
			if(findIPFilterEntrybyNameDirection(entry.filterName, DIR_IN, NULL, NULL) \
				|| getTotalIPFilterNumOneDirection(DIR_IN) > MAX_OUTGOING_IPFILTER_RULE_NUM)
				goto check_err;
#ifdef CONFIG_IPV6
			str = boaGetVar(wp, "IpProtocolType", "");
			filterEntry.IpProtocol = (char)atoi(str);
			// If it is a IPv6 rule. Save the protoType into  ipfilter_whitelist data base.
			// Because the parseIpFilterInfo2Entry() will clean the MIB's ipportfilter_entry.
			if ( filterEntry.IpProtocol == IPVER_IPV6 )
				entry.protoType = ipv6_protoType;
#endif
			parseIpFilterInfo2Entry(&entry, &filterEntry, DIR_IN);

#ifdef CONFIG_IPV6
			// If it is a IPv6 rule.
			if ( filterEntry.IpProtocol == IPVER_IPV6 )
			{
				str = boaGetVar(wp, "sip6Start", "");
				if (str[0]) {
					if (!inet_pton(PF_INET6, str, &filterEntry.sip6Start)) {
						printf("Invalid sip6Start for ipport filter!");
						goto check_err;
					}
				}

				str = boaGetVar(wp, "sip6End", "");
				if (str[0]) {
					if (!inet_pton(PF_INET6, str, &filterEntry.sip6End)) {
						printf("Invalid sip6End for ipport filter!");
						goto check_err;
					}
				}

				str = boaGetVar(wp, "dip6Start", "");
				if (str[0]) {
					if (!inet_pton(PF_INET6, str, &filterEntry.dip6Start)) {
						printf("Invalid dip6Start for ipport filter!");
						goto check_err;
					}
				}

				str = boaGetVar(wp, "dip6End", "");
				if (str[0]) {
					if (!inet_pton(PF_INET6, str, &filterEntry.dip6End)) {
						printf("Invalid dip6End for ipport filter!");
						goto check_err;
					}
				}

				str = boaGetVar(wp, "sip6PrefixLen", "");
				filterEntry.sip6PrefixLen = (char)atoi(str);

				str = boaGetVar(wp, "dip6PrefixLen", "");
				filterEntry.dip6PrefixLen = (char)atoi(str);
			}
#endif
			ret = mib_chain_add(MIB_IP_PORT_FILTER_TBL, (unsigned char*)&filterEntry);
			if(ret == -1)
				goto Max_Size_Reached;
			else if( ret == 0 )
				goto check_err;

#if defined(CONFIG_CMCC) || defined(CONFIG_CU_BASEON_CMCC)
			getIPPortFilterMibEntry(filterEntry, output_str, 1);
			//printf("%s\n", output_str);
			syslog(LOG_CRIT, "Port Filter DIR IN BlackList, %s", output_str);
#endif

			//take effect immediate
			restart_IPFilter_DMZ_MACFilter();
		}
		/************Place your code here, do what you want to do! ************/
	}
	else {lineno = __LINE__; goto check_err;}
	//Write to flash, take effect forever
	mib_update(CURRENT_SETTING, CONFIG_MIB_ALL);
	_COND_REDIRECT;
Max_Size_Reached:
	_BC_FREE();
	_TRACE_LEAVEL;
	ERR_MSG("规则数已达最大限制!"); //Max number of rules reached!
	return;
check_err:
	_BC_FREE();
	_TRACE_LEAVEL;
	ERR_MSG("设定错误!");
	return;
}


void formPortFilterWhiteIn(request * wp, char *path, char *query)
{
	struct ipfilter_whitelist_entry	entry;
	char				isblack = 0;
	char*				slist = NULL;
	char*				stemp = "";
	char*				send = NULL;
	char*				stoken = NULL;
	int					lineno = __LINE__;
	int					index = -1;
	char				iffs[20][20];	//接口列表
	MIB_CE_IP_PORT_FILTER_T filterEntry;
	int j, ret;
#ifdef CONFIG_IPV6
	char *str, ipv6_protoType=0;
	MIB_CE_IP_PORT_FILTER_T IpEntry;
#endif
	char output_str[1024]={0};

	_BC_USE;

	_TRACE_CALL;

	FETCH_INVALID_OPT(stemp, "action", _NEED);

	if(strcmp(stemp, "rm") == 0)	//remove
	{
		int i;
		const char *name = NULL;
		_BC_INIT("bcdata");

		//reverse delete to avoid index panic
		for(i = _BC_ITCNT()-1 ; i >=0 ; i--)
		{
			if(bc_seek(bc, i, 0) < 0)
				continue;

			name = bc_gets(bc, "name");
			index = strtol(name, NULL, 10);

			if(mib_chain_get(MIB_IP_PORT_FILTER_TBL, index, &filterEntry) == 1)
			{
				mib_chain_delete(MIB_IP_PORT_FILTER_TBL, index);
				getIPPortFilterMibEntry(filterEntry, output_str, 0);
				//printf("%s\n", output_str);
				syslog(LOG_CRIT, "Port Filter DIR IN WhiteList, %s", output_str);
			}
		}

		restart_IPFilter_DMZ_MACFilter();
		_BC_FREE();
		boaRefreshParent(wp, "/secu_portfilter_cfg.asp");
		return;
	}
	else if(strcmp(stemp, "ad") == 0)	//add
	{
		memset(&entry, 0, sizeof(entry));

		_ENTRY_STR(filterName, _NEED);
		_ENTRY_INT(protoType, _NEED);
		//if(entry.protoType > 4){lineno = __LINE__; goto check_err;}
		_ENTRY_IP(sipStart, _OPT);
		_ENTRY_IP(sipEnd, _OPT);
		_ENTRY_IP(smask, _OPT);
		_ENTRY_IP(dipStart, _OPT);
		_ENTRY_IP(dipEnd, _OPT);
		_ENTRY_IP(dmask, _OPT);
		_ENTRY_INT(sportStart, _OPT);
		_ENTRY_INT(sportEnd, _OPT);
#if defined(CONFIG_CMCC) || defined(CONFIG_CU)
		_ENTRY_STR(WanPath, _NEED);
#endif		
		entry.enable = 1;

		if(entry.sportEnd == 0)
			entry.sportEnd = entry.sportStart;
		
		if(entry.sportEnd < entry.sportStart){lineno = __LINE__; goto check_err;}

		_ENTRY_INT(dportStart, _OPT);
		_ENTRY_INT(dportEnd, _OPT);

		if(entry.dportEnd == 0)
			entry.dportEnd = entry.dportStart;
		
		if(entry.dportEnd < entry.dportStart){lineno = __LINE__; goto check_err;}

/*
	//closed by jim ,we current do not support ip filter bound with interface...
		_ENTRY_BOOL(allport, _NEED);
		if(entry.allport < 0 || entry.allport > 1){lineno = __LINE__; goto check_err;}
		if(entry.allport == 0)
		{
			_ENTRY_INT(portnum, _NEED);
			if(entry.portnum < 0 || entry.portnum >= 20){lineno = __LINE__; goto check_err;}
			if(entry.portnum){FETCH_INVALID_OPT(stemp, "ifname", _NEED); stoken = stemp;}
			for(index = 0; stemp && index < entry.portnum; index++)
			{
				stemp = strchr(stoken, ';');
				if(stemp)*stemp = 0;
				strncpy(iffs[index], stoken, 20);
				stoken = stemp ? stemp + 1: NULL;
			}
		}
*/
		//jim double check the parameters validity.
		if(!entry.sipStart)
		{
			entry.smask=0;
			entry.sipEnd=0;
		}
		if(!entry.dipStart)
		{
			entry.dmask=0;
			entry.dipEnd=0;
		}
#ifdef CONFIG_IPV6
		str = boaGetVar(wp, "protoTypeV6", "");
		if (str[0]) {
			ipv6_protoType = (char)atoi(str);
		}

		if(entry.protoType == 0 && ipv6_protoType == 0) //None proto... don't care ,, all.
#else
		if(entry.protoType == 0) //None proto... don't care ,, all.
#endif
		{    //mask off port info...
			entry.sportStart=0;
			entry.sportEnd=0;
			entry.dportStart=0;
			entry.dportEnd=0;
		}
		/************Place your code here, do what you want to do! ************/
		{		// IP/Port FILTER
			MIB_CE_IP_PORT_FILTER_T filterEntry;
			// if the exist entry with the same name, abandon the add action...
			if(findIPFilterEntrybyNameDirection(entry.filterName, DIR_IN, NULL, NULL) \
				|| getTotalIPFilterNumOneDirection(DIR_IN) > MAX_INCOMING_IPFILTER_RULE_NUM)
				goto check_err;
#ifdef CONFIG_IPV6
			str = boaGetVar(wp, "IpProtocolType", "");
			filterEntry.IpProtocol = (char)atoi(str);
			// If it is a IPv6 rule. Save the protoType into  ipfilter_whitelist data base.
			// Because the parseIpFilterInfo2Entry() will clean the MIB's ipportfilter_entry.
			if ( filterEntry.IpProtocol == IPVER_IPV6 )
				entry.protoType = ipv6_protoType;
#endif
			parseIpFilterInfo2Entry((struct ipfilter_blacklist_entry *)&entry, &filterEntry, DIR_IN);

#ifdef CONFIG_IPV6
			// If it is a IPv6 rule.
			if ( filterEntry.IpProtocol == IPVER_IPV6 )
			{
				str = boaGetVar(wp, "sip6Start", "");
				if (str[0]) {
					if (!inet_pton(PF_INET6, str, &filterEntry.sip6Start)) {
						printf("Invalid sip6Start for ipport filter!");
						goto check_err;
					}
				}

				str = boaGetVar(wp, "sip6End", "");
				if (str[0]) {
					if (!inet_pton(PF_INET6, str, &filterEntry.sip6End)) {
						printf("Invalid sip6End for ipport filter!");
						goto check_err;
					}
				}

				str = boaGetVar(wp, "dip6Start", "");
				if (str[0]) {
					if (!inet_pton(PF_INET6, str, &filterEntry.dip6Start)) {
						printf("Invalid dip6Start for ipport filter!");
						goto check_err;
					}
				}

				str = boaGetVar(wp, "dip6End", "");
				if (str[0]) {
					if (!inet_pton(PF_INET6, str, &filterEntry.dip6End)) {
						printf("Invalid dip6End for ipport filter!");
						goto check_err;
					}
				}

				str = boaGetVar(wp, "sip6PrefixLen", "");
				filterEntry.sip6PrefixLen = (char)atoi(str);

				str = boaGetVar(wp, "dip6PrefixLen", "");
				filterEntry.dip6PrefixLen = (char)atoi(str);
			}
#endif

			ret = mib_chain_add(MIB_IP_PORT_FILTER_TBL, (unsigned char*)&filterEntry);
			if( ret == -1 )
				goto Max_Size_Reached;
			else if( ret == 0 )
				goto check_err;

#if defined(CONFIG_CMCC) || defined(CONFIG_CU_BASEON_CMCC)
			getIPPortFilterMibEntry(filterEntry, output_str, 1);
			//printf("%s\n", output_str);
			syslog(LOG_CRIT, "Port Filter DIR IN WhiteList, %s", output_str);
#endif
			//take effect immediate
			restart_IPFilter_DMZ_MACFilter();
		}
		/************Place your code here, do what you want to do! ************/
	}
	else {lineno = __LINE__; goto check_err;}
		//Write to flash, take effect forever
	mib_update(CURRENT_SETTING, CONFIG_MIB_ALL);
	_COND_REDIRECT;
Max_Size_Reached:
	_BC_FREE();
	_TRACE_LEAVEL;
	ERR_MSG("规则数已达最大限制!"); //Max number of rules reached!
	return;
check_err:
	_BC_FREE();
	_TRACE_LEAVEL;
	ERR_MSG("设定错误!");
	return;
}


void formPortFilterWhiteOut(request * wp, char *path, char *query)
{
	struct ipfilter_whitelist_entry	entry;
	char				isblack = 0;
	char*				slist = NULL;
	char*				stemp = "";
	char*				send = NULL;
	char*				stoken = NULL;
	int					lineno = __LINE__;
	int					index = -1;
	char				iffs[20][20];	//接口列表
	MIB_CE_IP_PORT_FILTER_T filterEntry;
	int j, ret;
#ifdef CONFIG_IPV6
	char *str, ipv6_protoType=0;
	MIB_CE_IP_PORT_FILTER_T IpEntry;
#endif
	char output_str[1024]={0};

	_BC_USE;

	_TRACE_CALL;

	FETCH_INVALID_OPT(stemp, "action", _NEED);
	//AUG_PRT("stemp=%s\n",stemp);

	if(strcmp(stemp, "rm") == 0)	//remove
	{
		int i;
		const char *name = NULL;
		_BC_INIT("bcdata");

		//reverse delete to avoid index panic
		for(i = _BC_ITCNT()-1 ; i >=0 ; i--)
		{
			if(bc_seek(bc, i, 0) < 0)
				continue;

			name = bc_gets(bc, "name");
			index = strtol(name, NULL, 10);

			if(mib_chain_get(MIB_IP_PORT_FILTER_TBL, index, &filterEntry) == 1)
			{
				mib_chain_delete(MIB_IP_PORT_FILTER_TBL, index);
				getIPPortFilterMibEntry(filterEntry, output_str, 0);
				//printf("%s\n", output_str);
				syslog(LOG_CRIT, "Port Filter DIR OUT WhiteList, %s", output_str);
			}
		}

		restart_IPFilter_DMZ_MACFilter();
		_BC_FREE();
		boaRefreshParent(wp, "/secu_portfilter_cfg.asp");
		return;
	}
	else if(strcmp(stemp, "ad") == 0)	//add
	{
		memset(&entry, 0, sizeof(entry));

		_ENTRY_STR(filterName, _NEED);
		_ENTRY_INT(protoType, _NEED);
		//if(entry.protoType > 4){lineno = __LINE__; goto check_err;}
		_ENTRY_IP(sipStart, _OPT);
		_ENTRY_IP(sipEnd, _OPT);
		_ENTRY_IP(smask, _OPT);
		_ENTRY_IP(dipStart, _OPT);
		_ENTRY_IP(dipEnd, _OPT);
		_ENTRY_IP(dmask, _OPT);
		_ENTRY_INT(sportStart, _OPT);
		_ENTRY_INT(sportEnd, _OPT);
		
		entry.enable = 1;
		
		if(entry.sportEnd == 0)
			entry.sportEnd = entry.sportStart;
		
		if(entry.sportEnd < entry.sportStart){lineno = __LINE__; goto check_err;}

		_ENTRY_INT(dportStart, _OPT);
		_ENTRY_INT(dportEnd, _OPT);

		if(entry.dportEnd == 0)
			entry.dportEnd = entry.dportStart;
		
		if(entry.dportEnd < entry.dportStart){lineno = __LINE__; goto check_err;}

/*
	//closed by jim ,we current do not support ip filter bound with interface...
		_ENTRY_BOOL(allport, _NEED);
		if(entry.allport < 0 || entry.allport > 1){lineno = __LINE__; goto check_err;}
		if(entry.allport == 0)
		{
			_ENTRY_INT(portnum, _NEED);
			if(entry.portnum < 0 || entry.portnum >= 20){lineno = __LINE__; goto check_err;}
			if(entry.portnum){FETCH_INVALID_OPT(stemp, "ifname", _NEED); stoken = stemp;}
			for(index = 0; stemp && index < entry.portnum; index++)
			{
				stemp = strchr(stoken, ';');
				if(stemp)*stemp = 0;
				strncpy(iffs[index], stoken, 20);
				stoken = stemp ? stemp + 1: NULL;
			}
		}
*/
		//jim double check the parameters validity.
		if(!entry.sipStart)
		{
			entry.smask=0;
			entry.sipEnd=0;
		}
		if(!entry.dipStart)
		{
			entry.dmask=0;
			entry.dipEnd=0;
		}
#ifdef CONFIG_IPV6
		str = boaGetVar(wp, "protoTypeV6", "");
		if (str[0]) {
			ipv6_protoType = (char)atoi(str);
		}

		if(entry.protoType == 0 && ipv6_protoType == 0) //None proto... don't care ,, all.
#else
		if(entry.protoType == 0) //None proto... don't care ,, all.
#endif
		{    //mask off port info...
			entry.sportStart=0;
			entry.sportEnd=0;
			entry.dportStart=0;
			entry.dportEnd=0;
		}
		/************Place your code here, do what you want to do! ************/
		{		// IP/Port FILTER
			MIB_CE_IP_PORT_FILTER_T filterEntry;
			// if the exist entry with the same name, abandon the add action...
			if(findIPFilterEntrybyNameDirection(entry.filterName, DIR_OUT, NULL, NULL) \
				|| getTotalIPFilterNumOneDirection(DIR_OUT) > MAX_INCOMING_IPFILTER_RULE_NUM)
				goto check_err;
#ifdef CONFIG_IPV6
			str = boaGetVar(wp, "IpProtocolType", "");
			filterEntry.IpProtocol = (char)atoi(str);
			// If it is a IPv6 rule. Save the protoType into  ipfilter_whitelist data base.
			// Because the parseIpFilterInfo2Entry() will clean the MIB's ipportfilter_entry.
			if ( filterEntry.IpProtocol == IPVER_IPV6 )
				entry.protoType = ipv6_protoType;
#endif
			parseIpFilterInfo2Entry((struct ipfilter_blacklist_entry *)&entry, &filterEntry, DIR_OUT);

#ifdef CONFIG_IPV6
			// If it is a IPv6 rule.
			if ( filterEntry.IpProtocol == IPVER_IPV6 )
			{
				str = boaGetVar(wp, "sip6Start", "");
				if (str[0]) {
					if (!inet_pton(PF_INET6, str, &filterEntry.sip6Start)) {
						printf("Invalid sip6Start for ipport filter!");
						goto check_err;
					}
				}

				str = boaGetVar(wp, "sip6End", "");
				if (str[0]) {
					if (!inet_pton(PF_INET6, str, &filterEntry.sip6End)) {
						printf("Invalid sip6End for ipport filter!");
						goto check_err;
					}
				}

				str = boaGetVar(wp, "dip6Start", "");
				if (str[0]) {
					if (!inet_pton(PF_INET6, str, &filterEntry.dip6Start)) {
						printf("Invalid dip6Start for ipport filter!");
						goto check_err;
					}
				}

				str = boaGetVar(wp, "dip6End", "");
				if (str[0]) {
					if (!inet_pton(PF_INET6, str, &filterEntry.dip6End)) {
						printf("Invalid dip6End for ipport filter!");
						goto check_err;
					}
				}

				str = boaGetVar(wp, "sip6PrefixLen", "");
				filterEntry.sip6PrefixLen = (char)atoi(str);

				str = boaGetVar(wp, "dip6PrefixLen", "");
				filterEntry.dip6PrefixLen = (char)atoi(str);
			}
#endif

			ret = mib_chain_add(MIB_IP_PORT_FILTER_TBL, (unsigned char*)&filterEntry);
			if( ret == -1 )
				goto Max_Size_Reached;
			else if( ret == 0 )
				goto check_err;

#if defined(CONFIG_CMCC) || defined(CONFIG_CU_BASEON_CMCC)
			getIPPortFilterMibEntry(filterEntry, output_str, 1);
			//printf("%s\n", output_str);
			syslog(LOG_CRIT, "Port Filter DIR OUT WhiteList, %s", output_str);
#endif

			//take effect immediate
			restart_IPFilter_DMZ_MACFilter();
		}
		/************Place your code here, do what you want to do! ************/
	}
	else {lineno = __LINE__; goto check_err;}
		//Write to flash, take effect forever
	mib_update(CURRENT_SETTING, CONFIG_MIB_ALL);
	_COND_REDIRECT;
Max_Size_Reached:
	_BC_FREE();
	_TRACE_LEAVEL;
	ERR_MSG("规则数已达最大限制!"); //Max number of rules reached!
	return;
check_err:
	_BC_FREE();
	_TRACE_LEAVEL;
	ERR_MSG("设定错误!");
	return;
}
void formPortFilterPort(request * wp, char *path, char *query)
{
	int filtered_port=0, pmap_idx=0;
	unsigned char filtered_protocal=0;
	MIB_CE_L2FILTER_T Entry;
	char *stemp = "";
	int lineno = __LINE__;
	char prot_String[16]={0};

	_TRACE_CALL;
	FETCH_INVALID_OPT(stemp,"action", _NEED);
	if(strcmp(stemp, "apply") == 0){
		int total = mib_chain_total(MIB_L2FILTER_TBL);
		_GET_INT(filtered_port, _NEED);
		mib_chain_get(MIB_L2FILTER_TBL,filtered_port,&Entry);
		FETCH_INVALID_OPT(stemp,"cbIPv4oE", _OPT);
		if(strcmp(stemp, "on") == 0)
			filtered_protocal |=  L2FILTER_ETH_IPV4OE;
		FETCH_INVALID_OPT(stemp,"cbPPPoE", _OPT);
		if(strcmp(stemp, "on") == 0)
			filtered_protocal |=  L2FILTER_ETH_PPPOE;
		FETCH_INVALID_OPT(stemp,"cbARP", _OPT);
		if(strcmp(stemp, "on") == 0)
			filtered_protocal |=  L2FILTER_ETH_ARP;
		FETCH_INVALID_OPT(stemp,"cbIPv6oE", _OPT);
		if(strcmp(stemp, "on") == 0)
			filtered_protocal |=  L2FILTER_ETH_IPV6OE;

		memset(Entry.dst_mac, 0, MAC_ADDR_LEN);
		memset(Entry.src_mac, 0, MAC_ADDR_LEN);
		Entry.eth_type = filtered_protocal;
		mib_chain_update(MIB_L2FILTER_TBL,&Entry,filtered_port);
#ifdef COMMIT_IMMEDIATELY
		Commit();
#endif
#ifdef _PRMT_X_CMCC_LANINTERFACES_
		setupL2Filter();
#endif
	}
	else if(strcmp(stemp, "apply_multi") == 0){
	//lan port
		for(filtered_port=0;filtered_port<PMAP_WLAN0;filtered_port++){
			mib_chain_get(MIB_L2FILTER_TBL,filtered_port,&Entry);
			filtered_protocal = 0;
			snprintf(prot_String, 15, "cbIPv4oE_%d", filtered_port);
			FETCH_INVALID_OPT(stemp,prot_String, _OPT);
			if(strcmp(stemp, "on") == 0)
				filtered_protocal |=  L2FILTER_ETH_IPV4OE;
			snprintf(prot_String, 15, "cbPPPoE_%d", filtered_port);
			FETCH_INVALID_OPT(stemp,prot_String, _OPT);
			if(strcmp(stemp, "on") == 0)
				filtered_protocal |=  L2FILTER_ETH_PPPOE;
			snprintf(prot_String, 15, "cbARP_%d", filtered_port);
			FETCH_INVALID_OPT(stemp,prot_String, _OPT);
			if(strcmp(stemp, "on") == 0)
				filtered_protocal |=  L2FILTER_ETH_ARP;
			snprintf(prot_String, 15, "cbIPv6oE_%d", filtered_port);
			FETCH_INVALID_OPT(stemp,prot_String, _OPT);
			if(strcmp(stemp, "on") == 0)
				filtered_protocal |=  L2FILTER_ETH_IPV6OE;
			//donot modify mac
			Entry.eth_type = filtered_protocal;
			pmap_idx++;
			mib_chain_update(MIB_L2FILTER_TBL,&Entry,filtered_port);
		}
#ifdef WLAN_SUPPORT
		int orig_wlan_idx = wlan_idx;
		int i=0, j=0, idx=0;
#if defined(CONFIG_CMCC) || defined(CONFIG_CU_BASEON_CMCC)
		unsigned char ssid2_enable = 0;
		mib_get_s(MIB_WEB_WLAN_SSID2_ENABLE, &ssid2_enable, sizeof(ssid2_enable));
		unsigned char ssid3_enable = 0;
		unsigned char ssid4_enable = 0;
#ifdef WLAN_DUALBAND_CONCURRENT
		unsigned char ssid6_enable = 0;
		unsigned char ssid7_enable = 0;
		unsigned char ssid8_enable = 0;
#endif
#if defined(CONFIG_CU_BASEON_CMCC)
		mib_get_s(MIB_WEB_WLAN_SSID3_ENABLE, &ssid3_enable, sizeof(ssid3_enable));
		mib_get_s(MIB_WEB_WLAN_SSID4_ENABLE, &ssid4_enable, sizeof(ssid4_enable));
#ifdef WLAN_DUALBAND_CONCURRENT
		mib_get_s(MIB_WEB_WLAN_SSID6_ENABLE, &ssid6_enable, sizeof(ssid6_enable));
		mib_get_s(MIB_WEB_WLAN_SSID7_ENABLE, &ssid7_enable, sizeof(ssid7_enable));
		mib_get_s(MIB_WEB_WLAN_SSID8_ENABLE, &ssid8_enable, sizeof(ssid8_enable));
#endif
#endif //defined(CONFIG_CU_BASEON_CMCC)
#endif	//defined(CONFIG_CMCC) || defined(CONFIG_CU_BASEON_CMCC)
		for(j=0; j<NUM_WLAN_INTERFACE; j++)
		{
			wlan_idx = j;
			idx = j*(PMAP_WLAN0_VAP_END-PMAP_WLAN0+1) + PMAP_WLAN0;
			if(mib_chain_get(MIB_L2FILTER_TBL,idx,&Entry)==0){
				continue;
			}
			filtered_protocal = 0;
			snprintf(prot_String, 15, "cbIPv4oE_%d", idx);
			FETCH_INVALID_OPT(stemp,prot_String, _OPT);
			if(strcmp(stemp, "on") == 0)
				filtered_protocal |=  L2FILTER_ETH_IPV4OE;
			snprintf(prot_String, 15, "cbPPPoE_%d", idx);
			FETCH_INVALID_OPT(stemp,prot_String, _OPT);
			if(strcmp(stemp, "on") == 0)
				filtered_protocal |=  L2FILTER_ETH_PPPOE;
			snprintf(prot_String, 15, "cbARP_%d", idx);
			FETCH_INVALID_OPT(stemp,prot_String, _OPT);
			if(strcmp(stemp, "on") == 0)
				filtered_protocal |=  L2FILTER_ETH_ARP;
			snprintf(prot_String, 15, "cbIPv6oE_%d", idx);
			FETCH_INVALID_OPT(stemp,prot_String, _OPT);
			if(strcmp(stemp, "on") == 0)
				filtered_protocal |=  L2FILTER_ETH_IPV6OE;
			//donot modify mac
			Entry.eth_type = filtered_protocal;
			pmap_idx++;
			mib_chain_update(MIB_L2FILTER_TBL,&Entry,idx);
#ifdef WLAN_MBSSID
			MIB_CE_MBSSIB_T entry;
			for (i = 0; i < WLAN_MBSSID_NUM; i++)
			{
				mib_chain_get(MIB_MBSSIB_TBL, i + 1, &entry);
#if defined(CONFIG_CMCC) || defined(CONFIG_CU_BASEON_CMCC)
				int wlan_mbssid_index = j*(WLAN_MBSSID_NUM+1) + (i + 2);
				if((wlan_mbssid_index == 2 && ssid2_enable == 0)
					|| (wlan_mbssid_index == 3 && ssid3_enable == 0)
					|| (wlan_mbssid_index == 4 && ssid4_enable == 0)
#ifdef WLAN_DUALBAND_CONCURRENT
					|| (wlan_mbssid_index == 6 && ssid6_enable == 0)|| (wlan_mbssid_index == 7 && ssid7_enable == 0)
					|| (wlan_mbssid_index == 8 && ssid8_enable == 0)
#endif
					)
					continue;
#endif //defined(CONFIG_CMCC) || defined(CONFIG_CU_BASEON_CMCC)
				idx = j*(PMAP_WLAN0_VAP_END-PMAP_WLAN0+1) + PMAP_WLAN0+ i + 1;
				if(mib_chain_get(MIB_L2FILTER_TBL,idx,&Entry)==0){
					continue;
				}
				filtered_protocal = 0;
				snprintf(prot_String, 15, "cbIPv4oE_%d", idx);
				FETCH_INVALID_OPT(stemp,prot_String, _OPT);
				if(strcmp(stemp, "on") == 0)
					filtered_protocal |=  L2FILTER_ETH_IPV4OE;
				snprintf(prot_String, 15, "cbPPPoE_%d", idx);
				FETCH_INVALID_OPT(stemp,prot_String, _OPT);
				if(strcmp(stemp, "on") == 0)
					filtered_protocal |=  L2FILTER_ETH_PPPOE;
				snprintf(prot_String, 15, "cbARP_%d", idx);
				FETCH_INVALID_OPT(stemp,prot_String, _OPT);
				if(strcmp(stemp, "on") == 0)
					filtered_protocal |=  L2FILTER_ETH_ARP;
				snprintf(prot_String, 15, "cbIPv6oE_%d", idx);
				FETCH_INVALID_OPT(stemp,prot_String, _OPT);
				if(strcmp(stemp, "on") == 0)
					filtered_protocal |=  L2FILTER_ETH_IPV6OE;
				//donot modify mac
				Entry.eth_type = filtered_protocal;
				pmap_idx++;
				mib_chain_update(MIB_L2FILTER_TBL,&Entry,idx);
			}
#endif //WLAN_MBSSID
		}
		wlan_idx = orig_wlan_idx;
#endif

#ifdef COMMIT_IMMEDIATELY
		Commit();
#endif
#ifdef _PRMT_X_CMCC_LANINTERFACES_
		setupL2Filter();
#endif
	}

	_COND_REDIRECT;
	return;
#if !defined(CONFIG_CMCC) && !defined(CONFIG_CU_BASEON_CMCC)
check_err:
	_TRACE_LEAVEL;
	ERR_MSG("设定错误!");
	return;
#endif
}
int initPagePortFilter(int eid, request *wp, int argc, char **argv)
{
	int pmap_idx=0;
	int idx, type, i;
	char port_name[8];
	char port_prot[8];
	int phyPortId;
	int ethPhyPortId = rtk_port_get_wan_phyID();
	MIB_CE_L2FILTER_T Entry, *pEntry;
	pEntry = &Entry;
	int total = mib_chain_total(MIB_L2FILTER_TBL);
	int ret = 0;

	for(i = 0; i < ELANVIF_NUM; i++){
		phyPortId = rtk_port_get_lan_phyID(i);
		if (phyPortId != -1 && phyPortId == ethPhyPortId)
			continue;
		idx = i;
		if(mib_chain_get(MIB_L2FILTER_TBL,idx,pEntry)){
			sprintf(port_name, "LAN%d",idx+1);
#ifdef CONFIG_CMCC_ENTERPRISE
			ret += boaWrite(wp, "port_filter_status[%d]={name:\"%s\", prot:\"%d\", idx:\"%d\", smac:\"%02x:%02x:%02x:%02x:%02x:%02x\", dmac:\"%02x:%02x:%02x:%02x:%02x:%02x\"};\n"
					, pmap_idx, port_name, pEntry->eth_type, idx
					, pEntry->src_mac[0], pEntry->src_mac[1], pEntry->src_mac[2], pEntry->src_mac[3], pEntry->src_mac[4], pEntry->src_mac[5]
					, pEntry->dst_mac[0], pEntry->dst_mac[1], pEntry->dst_mac[2], pEntry->dst_mac[3], pEntry->dst_mac[4], pEntry->dst_mac[5]);
#else

			ret += boaWrite(wp, "port_filter_status[%d]={name:\"%s\", prot:\"%d\", idx:\"%d\"};\n", pmap_idx, port_name, pEntry->eth_type,idx);
#endif
		}
		pmap_idx++;
	}
#ifdef WLAN_SUPPORT
		int orig_wlan_idx = wlan_idx;
		int j;
#if defined(CONFIG_CMCC) || defined(CONFIG_CU_BASEON_CMCC)
		unsigned char ssid2_enable = 0;

		mib_get_s(MIB_WEB_WLAN_SSID2_ENABLE, &ssid2_enable, sizeof(ssid2_enable));
		unsigned char ssid3_enable = 0;
		unsigned char ssid4_enable = 0;
#ifdef WLAN_DUALBAND_CONCURRENT
		unsigned char ssid6_enable = 0;
		unsigned char ssid7_enable = 0;
		unsigned char ssid8_enable = 0;
#endif
#if defined(CONFIG_CU_BASEON_CMCC)
		mib_get_s(MIB_WEB_WLAN_SSID3_ENABLE, &ssid3_enable, sizeof(ssid3_enable));
		mib_get_s(MIB_WEB_WLAN_SSID4_ENABLE, &ssid4_enable, sizeof(ssid4_enable));
#ifdef WLAN_DUALBAND_CONCURRENT
		mib_get_s(MIB_WEB_WLAN_SSID6_ENABLE, &ssid6_enable, sizeof(ssid6_enable));
		mib_get_s(MIB_WEB_WLAN_SSID7_ENABLE, &ssid7_enable, sizeof(ssid7_enable));
		mib_get_s(MIB_WEB_WLAN_SSID8_ENABLE, &ssid8_enable, sizeof(ssid8_enable));
#endif
#endif //defined(CONFIG_CU_BASEON_CMCC)
#endif	//defined(CONFIG_CMCC) || defined(CONFIG_CU_BASEON_CMCC)
		for(j=0; j<NUM_WLAN_INTERFACE; j++)
		{
			wlan_idx = j;
			idx = j*(PMAP_WLAN0_VAP_END-PMAP_WLAN0+1) + PMAP_WLAN0;
			if(mib_chain_get(MIB_L2FILTER_TBL,idx,pEntry)==0){
				continue;
			}
			sprintf(port_name, "SSID%d",j*(WLAN_MBSSID_NUM+1) + 1);
#ifdef CONFIG_CMCC_ENTERPRISE
			ret += boaWrite(wp, "port_filter_status[%d]={name:\"%s\", prot:\"%d\", idx:\"%d\", smac:\"%02x:%02x:%02x:%02x:%02x:%02x\", dmac:\"%02x:%02x:%02x:%02x:%02x:%02x\"};\n"
					, pmap_idx, port_name, pEntry->eth_type, idx
					, pEntry->src_mac[0], pEntry->src_mac[1], pEntry->src_mac[2], pEntry->src_mac[3], pEntry->src_mac[4], pEntry->src_mac[5]
					, pEntry->dst_mac[0], pEntry->dst_mac[1], pEntry->dst_mac[2], pEntry->dst_mac[3], pEntry->dst_mac[4], pEntry->dst_mac[5]);
#else
			ret += boaWrite(wp, "port_filter_status[%d]={name:\"%s\", prot:\"%d\", idx:\"%d\"};\n", pmap_idx, port_name, pEntry->eth_type, idx);
#endif
			pmap_idx++;
#ifdef WLAN_MBSSID
			MIB_CE_MBSSIB_T entry;
			for (i = 0; i < WLAN_MBSSID_NUM; i++)
			{
				mib_chain_get(MIB_MBSSIB_TBL, i + 1, &entry);
#if defined(CONFIG_CMCC) || defined(CONFIG_CU_BASEON_CMCC)
				int wlan_mbssid_index = j*(WLAN_MBSSID_NUM+1) + (i + 2);
				if((wlan_mbssid_index == 2 && ssid2_enable == 0) 
					|| (wlan_mbssid_index == 3 && ssid3_enable == 0)
					|| (wlan_mbssid_index == 4 && ssid4_enable == 0)
#ifdef WLAN_DUALBAND_CONCURRENT
                    || (wlan_mbssid_index == 6 && ssid6_enable == 0)|| (wlan_mbssid_index == 7 && ssid7_enable == 0)
                    || (wlan_mbssid_index == 8 && ssid8_enable == 0)
#endif
                    )
					continue;
#endif //defined(CONFIG_CMCC) || defined(CONFIG_CU_BASEON_CMCC)
				idx = j*(PMAP_WLAN0_VAP_END-PMAP_WLAN0+1) + PMAP_WLAN0+ i + 1;
				if(mib_chain_get(MIB_L2FILTER_TBL,idx,pEntry)==0){
					continue;
				}
				sprintf(port_name, "SSID%d",j*(WLAN_MBSSID_NUM+1) + (i + 2));
#ifdef CONFIG_CMCC_ENTERPRISE
				ret += boaWrite(wp, "port_filter_status[%d]={name:\"%s\", prot:\"%d\", idx:\"%d\", smac:\"%02x:%02x:%02x:%02x:%02x:%02x\", dmac:\"%02x:%02x:%02x:%02x:%02x:%02x\"};\n"
						, pmap_idx, port_name, pEntry->eth_type, idx
						, pEntry->src_mac[0], pEntry->src_mac[1], pEntry->src_mac[2], pEntry->src_mac[3], pEntry->src_mac[4], pEntry->src_mac[5]
						, pEntry->dst_mac[0], pEntry->dst_mac[1], pEntry->dst_mac[2], pEntry->dst_mac[3], pEntry->dst_mac[4], pEntry->dst_mac[5]);
#else
				ret += boaWrite(wp, "port_filter_status[%d]={name:\"%s\", prot:\"%d\", idx:\"%d\"};\n", pmap_idx, port_name, pEntry->eth_type, idx);
#endif
				pmap_idx++;
			}
#endif //WLAN_MBSSID
		}
		wlan_idx = orig_wlan_idx;
#endif
	return ret;
}

#endif /*end CONFIG_CMCC*/
void formPortFilter(request * wp, char *path, char *query)
{
	//IP地址过滤启用:
	unsigned char ipfilterEnable = 0;		//1- 启用;  0- 禁用
	char *stemp = "";
	int lineno = __LINE__;
	unsigned char original_state = 0;
	_TRACE_CALL;

	_GET_BOOL(ipfilterEnable, _NEED);

	/************Place your code here, do what you want to do! ************/
	mib_get_s(MIB_IPFILTER_ON_OFF, (void*)&original_state, sizeof(original_state));
	if(ipfilterEnable)
		ipfilterEnable=1;
	//printf("new=%d, old=%d, new^old=%d\n",ipfilterEnable, original_state, (ipfilterEnable^original_state));
	if(ipfilterEnable^original_state)
	{//mib set only if ipfitler switch changed...
		//printf("###%d###\n", ipfilterEnable);
		mib_set(MIB_IPFILTER_ON_OFF, (void*)&ipfilterEnable);
		//take effect immediate...
		//setupFirewall();
		restart_IPFilter_DMZ_MACFilter();
		//Write to flash, take effect forever
		mib_update(CURRENT_SETTING, CONFIG_MIB_ALL);
	}
	/************Place your code here, do what you want to do! ************/

	_COND_REDIRECT;
check_err:
	_TRACE_LEAVEL;
	return;
}

//DIR_OUT 0
//DIR_IN    1
int parseIpFilterInfo2Entry(struct ipfilter_blacklist_entry *entry, MIB_CE_IP_PORT_FILTER_T *filterEntry, int direction)
{
	unsigned long mask, mbit;
#ifdef CONFIG_IPV6
	unsigned char o_ipProtocol;
	o_ipProtocol = filterEntry->IpProtocol;
#endif
#if defined(CONFIG_CMCC) || defined(CONFIG_CU)
	unsigned char out_action = 0;
	unsigned char in_action = 0;
#endif
	memset(filterEntry, 0x00, sizeof(MIB_CE_IP_PORT_FILTER_T));
	filterEntry->ifIndex = DUMMY_IFINDEX;
#ifdef CONFIG_IPV6
	filterEntry->IpProtocol = o_ipProtocol;
#endif
#if defined(CONFIG_CMCC) || defined(CONFIG_CU)
	strncpy(filterEntry->WanPath, entry->WanPath, 16);
	filterEntry->WanPath[sizeof(filterEntry->WanPath)-1] = '\0';
#endif

	strncpy(filterEntry->name, entry->filterName, 32);
	switch(entry->protoType)
	{
		case 0:
			filterEntry->protoType=PROTO_NONE;
			break;
		case 1:
			filterEntry->protoType=PROTO_UDPTCP;
			break;
		case 2:
			filterEntry->protoType=PROTO_TCP;
			break;
		case 3:
			filterEntry->protoType=PROTO_UDP;
			break;
		case 4:
			filterEntry->protoType=PROTO_ICMP;
			break;
	}

#ifdef CONFIG_IPV6
	// If it is a IPv4 rule.
	if ( filterEntry->IpProtocol == IPVER_IPV4 ) {
#endif
	memcpy(filterEntry->srcIp, &entry->sipStart, 4);
	memcpy(filterEntry->srcIp2, &entry->sipEnd, 4);
	memcpy(filterEntry->dstIp, &entry->dipStart, 4);
	memcpy(filterEntry->dstIp2, &entry->dipEnd, 4);
#ifdef CONFIG_IPV6
	}
#endif

	filterEntry->srcPortFrom=entry->sportStart;
	filterEntry->srcPortTo=entry->sportEnd;
	filterEntry->dstPortFrom=entry->dportStart;
	filterEntry->dstPortTo=entry->dportEnd;
	filterEntry->dir=direction;

#ifdef CONFIG_IPV6
	// If it is a IPv4 rule.
	if ( filterEntry->IpProtocol == IPVER_IPV4 ) {
#endif
	mask=ntohl(entry->smask);
	mbit=0;
	while (1) {
		if (mask&0x80000000) {
			mbit++;
			mask <<= 1;
		}
		else
			break;
	}
	filterEntry->smaskbit = mbit;
	mask=ntohl(entry->dmask);
	mbit=0;
	while (1) {
		if (mask&0x80000000) {
			mbit++;
			mask <<= 1;
		}
		else
			break;
	}
	filterEntry->dmaskbit = mbit;
#ifdef CONFIG_IPV6
	}
#endif
#if defined(CONFIG_CMCC) || defined(CONFIG_CU)
	if(direction == DIR_OUT)
	{
		mib_get_s(MIB_IPF_OUT_ACTION, (void*)&out_action, sizeof(out_action));
		filterEntry->action=out_action; 
	}else if(direction == DIR_IN){
		mib_get_s(MIB_IPF_IN_ACTION, (void*)&in_action, sizeof(in_action));
		filterEntry->action=in_action;	
	}
	filterEntry->enable = 1;
#else
	if(direction == DIR_OUT)
		filterEntry->action=0; //deny
	else
		filterEntry->action=1; //allow
#endif
	return 0;
}

// caculate the total entry numbers at one direction (incoming or outgoing)
int getTotalIPFilterNumOneDirection(int dir)
{
	int entrynum=0;
	int totalentrynum=0;
	int index;
	MIB_CE_IP_PORT_FILTER_T Entry;
	totalentrynum = mib_chain_total(MIB_IP_PORT_FILTER_TBL);
	for(index = 0; index < totalentrynum; index++)
	{
		if (!mib_chain_get(MIB_IP_PORT_FILTER_TBL, index, (void *)&Entry))
		{
			return 0;
		}
		if (Entry.dir == dir)
		{
			entrynum++;
		}
	}
	return entrynum;
}

//dir DIR_IN    1
//     DIR_OUT 0
// pIndex tell caller the found entry's index in table, if can.
// ret   1: the entry found , otherwise not found...
int findIPFilterEntrybyNameDirection(char *name, int dir, MIB_CE_IP_PORT_FILTER_T *pEntry, int *pIndex)
{
	int entrynum=0;
	int index;
	MIB_CE_IP_PORT_FILTER_T Entry;
	entrynum = mib_chain_total(MIB_IP_PORT_FILTER_TBL);
	for(index = 0; index < entrynum; index++)
	{
		if (!mib_chain_get(MIB_IP_PORT_FILTER_TBL, index, (void *)&Entry))
		{
			return 0;
		}
		if (Entry.dir != dir) //bypass the reversed direction rules...
			continue;
		if(!strncmp(Entry.name, name , sizeof(Entry.name)))
		{
			if(pEntry)
				memcpy(pEntry, &Entry, sizeof(MIB_CE_IP_PORT_FILTER_T));
			if(pIndex)
				*pIndex=index;
			//found the entry by name and direction
			return 1;
		}
	}
	//not found the wanted entry....
	return 0;
}

int ipPortFilterBlacklist (int eid, request * wp, int argc, char ** argv)
{
	//IP地址过滤启用:
	struct ipfilter_blacklist_entry	entry;
	char sipStart[16];
	char sipEnd[16];
	char smask[16];
	char dipStart[16];
	char dipEnd[16];
	char dmask[16];
	int cnt = 2;
	int index = 0;
	int lineno = __LINE__;
#ifdef CONFIG_IPV6
	unsigned char 	sip6StartStr[48], dip6StartStr[48], sip6EndStr[48], dip6EndStr[48];
#endif

	_TRACE_CALL;

	/************Place your code here, do what you want to do! ************/
	MIB_CE_IP_PORT_FILTER_T Mib_Entry;
	cnt = mib_chain_total(MIB_IP_PORT_FILTER_TBL);
	/************Place your code here, do what you want to do! ************/

	for(index = 0; index < cnt; index++)
	{
		/************Place your code here, do what you want to do! ************/
		memset(&entry, 0, sizeof(entry));
		if (!mib_chain_get(MIB_IP_PORT_FILTER_TBL, index, (void *)&Mib_Entry))
		{
 			boaError(wp, 400, "Get chain record error!\n");
			return -1;
		}
		if (Mib_Entry.dir == DIR_IN) //incoming rules, which belong to white list...
		{
			continue;
		}
		memcpy(entry.filterName, Mib_Entry.name, sizeof(entry.filterName));
		switch(Mib_Entry.protoType)
		{
			case PROTO_NONE:
				entry.protoType=0;
				break;
			case PROTO_UDPTCP:
				entry.protoType=1;
				break;
			case PROTO_TCP:
				entry.protoType=2;
				break;
			case PROTO_UDP:
				entry.protoType=3;
				break;
			case PROTO_ICMP:
				entry.protoType=4;
				break;
		}
		memcpy(&entry.sipStart, Mib_Entry.srcIp, 4);
		memcpy(&entry.sipEnd, Mib_Entry.srcIp2, 4);
		entry.smask=0xFFFFFFFF;
		if(Mib_Entry.smaskbit !=0)
			entry.smask =entry.smask<<(32-Mib_Entry.smaskbit);
		else
			entry.smask=0;
		entry.smask = htonl(entry.smask);
		memcpy(&entry.dipStart, Mib_Entry.dstIp, 4);
		memcpy(&entry.dipEnd, Mib_Entry.dstIp2, 4);
		entry.dmask=0xFFFFFFFF;
		if(Mib_Entry.dmaskbit !=0)
			entry.dmask =(entry.dmask<<(32-Mib_Entry.dmaskbit));
		else
			entry.dmask=0;
		entry.dmask = htonl(entry.dmask);
		entry.sportStart=Mib_Entry.srcPortFrom;
		entry.sportEnd=Mib_Entry.srcPortTo;
		entry.dportStart=Mib_Entry.dstPortFrom;
		entry.dportEnd=Mib_Entry.dstPortTo;

#ifdef CONFIG_IPV6
		inet_ntop(PF_INET6, (struct in6_addr *)Mib_Entry.sip6Start, sip6StartStr, sizeof(sip6StartStr));
		inet_ntop(PF_INET6, (struct in6_addr *)Mib_Entry.sip6End, sip6EndStr, sizeof(sip6EndStr));
		inet_ntop(PF_INET6, (struct in6_addr *)Mib_Entry.dip6Start, dip6StartStr, sizeof(dip6StartStr));
		inet_ntop(PF_INET6, (struct in6_addr *)Mib_Entry.dip6End, dip6EndStr, sizeof(dip6EndStr));
#endif
		/************Place your code here, do what you want to do! ************/

		boaWrite (wp, "push(new it_nr(\"%d\"" _PTS_XSS _PTI _PTS _PTS _PTS _PTS _PTS _PTS _PTI _PTI _PTI _PTI
#ifdef CONFIG_IPV6
		", \nnew it(\"IpProtocolType\",%d),\n"  	//ipv4 or ipv6
		"new it(\"sip6Start\",  \"%s\"),\n" 	//source ip6Start
		"new it(\"sip6End\",  \"%s\"),\n" 		//source ip6End
		"new it(\"dip6Start\",  \"%s\"),\n" 	//dst ip6Start
		"new it(\"dip6End\",  \"%s\"),\n" 		//dst ip6End
		"new it(\"sip6PrefixLen\",%d),\n"  	 	//source ip6 Prefix Len
		"new it(\"dip6PrefixLen\",%d)\n"  		//dst ip6 Prefix Len
#endif
		"));\n",
		index, _PME_XSS(filterName), _PME(protoType),
		_PMEIP(sipStart), _PMEIP(sipEnd), _PMEIP(smask), _PMEIP(dipStart), _PMEIP(dipEnd), _PMEIP(dmask),
		_PME(sportStart), _PME(sportEnd), _PME(dportStart), _PME(dportEnd)
#ifdef CONFIG_IPV6
		, Mib_Entry.IpProtocol, sip6StartStr, sip6EndStr, dip6StartStr, dip6EndStr, Mib_Entry.sip6PrefixLen, Mib_Entry.dip6PrefixLen
#endif
		);
	}

check_err:
	_TRACE_LEAVEL;
	return 0;
}

int ipPortFilterWhitelist (int eid, request * wp, int argc, char ** argv)
{
	//IP地址过滤启用:
	struct ipfilter_whitelist_entry	entry;
	char sipStart[16];
	char sipEnd[16];
	char smask[16];
	char dipStart[16];
	char dipEnd[16];
	char dmask[16];
	char ifname[1024] = "INTERNET_R_0_0_32;INTERNET_R_0_8_35";
	int cnt = 2;
	int index = 0;
	int lineno = __LINE__;
#ifdef CONFIG_IPV6
	unsigned char 	sip6StartStr[48], dip6StartStr[48], sip6EndStr[48], dip6EndStr[48];
#endif

	_TRACE_CALL;

	/************Place your code here, do what you want to do! ************/
	MIB_CE_IP_PORT_FILTER_T Mib_Entry;
	cnt = mib_chain_total(MIB_IP_PORT_FILTER_TBL);
	/************Place your code here, do what you want to do! ************/

	for(index = 0; index < cnt; index++)
	{
		/************Place your code here, do what you want to do! ************/
		memset(&entry, 0, sizeof(entry));
		if (!mib_chain_get(MIB_IP_PORT_FILTER_TBL, index, (void *)&Mib_Entry))
		{
  		boaError(wp, 400, "读取chain record错误!\n"); //Get chain record error!
			return -1;
		}
		if (Mib_Entry.dir == DIR_OUT) //outgoing rules, which belong to black list...
		{
			continue;
		}
		memcpy(entry.filterName, Mib_Entry.name, sizeof(entry.filterName));
		switch(Mib_Entry.protoType)
		{
			case PROTO_NONE:
				entry.protoType=0;
				break;
			case PROTO_UDPTCP:
				entry.protoType=1;
				break;
			case PROTO_TCP:
				entry.protoType=2;
				break;
			case PROTO_UDP:
				entry.protoType=3;
				break;
			case PROTO_ICMP:
				entry.protoType=4;
				break;
		}
		memcpy(&entry.sipStart, Mib_Entry.srcIp, 4);
		memcpy(&entry.sipEnd, Mib_Entry.srcIp2, 4);
		entry.smask=0xFFFFFFFF;
		if(Mib_Entry.smaskbit !=0)
			entry.smask =entry.smask<<(32-Mib_Entry.smaskbit);
		else
			entry.smask=0;
		entry.smask = htonl(entry.smask);
		memcpy(&entry.dipStart, Mib_Entry.dstIp, 4);
		memcpy(&entry.dipEnd, Mib_Entry.dstIp2, 4);
		entry.dmask=0xFFFFFFFF;
		if(Mib_Entry.dmaskbit !=0)
			entry.dmask =(entry.dmask<<(32-Mib_Entry.dmaskbit));
		else
			entry.dmask=0;
		entry.dmask = htonl(entry.dmask);
		entry.sportStart=Mib_Entry.srcPortFrom;
		entry.sportEnd=Mib_Entry.srcPortTo;
		entry.dportStart=Mib_Entry.dstPortFrom;
		entry.dportEnd=Mib_Entry.dstPortTo;

#ifdef CONFIG_IPV6
		inet_ntop(PF_INET6, (struct in6_addr *)Mib_Entry.sip6Start, sip6StartStr, sizeof(sip6StartStr));
		inet_ntop(PF_INET6, (struct in6_addr *)Mib_Entry.sip6End, sip6EndStr, sizeof(sip6EndStr));
		inet_ntop(PF_INET6, (struct in6_addr *)Mib_Entry.dip6Start, dip6StartStr, sizeof(dip6StartStr));
		inet_ntop(PF_INET6, (struct in6_addr *)Mib_Entry.dip6End, dip6EndStr, sizeof(dip6EndStr));
#endif
		/************Place your code here, do what you want to do! ************/

		boaWrite (wp, "push(new it_nr(\"%d\"" _PTS_XSS _PTI _PTS _PTS _PTS _PTS _PTS _PTS _PTI _PTI _PTI _PTI _PTI _PTI _PTS
#ifdef CONFIG_IPV6
		", \nnew it(\"IpProtocolType\",%d),\n"  //ipv4 or ipv6
		"new it(\"sip6Start\",  \"%s\"),\n" 	//source ip6Start
		"new it(\"sip6End\",  \"%s\"),\n" 		//source ip6End
		"new it(\"dip6Start\",  \"%s\"),\n" 	//dst ip6Start
		"new it(\"dip6End\",  \"%s\"),\n" 		//dst ip6End
		"new it(\"sip6PrefixLen\",%d),\n"  	 	//source ip6 Prefix Len
		"new it(\"dip6PrefixLen\",%d)\n"  		//dst ip6 Prefix Len
#endif
		"));\n",
		index, _PME_XSS(filterName), _PME(protoType),
		_PMEIP(sipStart), _PMEIP(sipEnd), _PMEIP(smask), _PMEIP(dipStart), _PMEIP(dipEnd), _PMEIP(dmask),
		_PME(sportStart), _PME(sportEnd), _PME(dportStart), _PME(dportEnd), _PME(allport), _PME(portnum), _PMEX(ifname)
#ifdef CONFIG_IPV6
		, Mib_Entry.IpProtocol, sip6StartStr, sip6EndStr, dip6StartStr, dip6EndStr, Mib_Entry.sip6PrefixLen, Mib_Entry.dip6PrefixLen
#endif
		);
	}
	_TRACE_LEAVEL;
	return 0;
}

void formPortFilterBlack(request * wp, char *path, char *query)
{
	struct ipfilter_blacklist_entry entry;
	char* stemp = "";
	int lineno = __LINE__;
	int index = 0;
	MIB_CE_IP_PORT_FILTER_T filterEntry;
	char ret;
	_BC_USE;
#ifdef CONFIG_IPV6
	char *str, ipv6_protoType=0;
#endif
	struct in_addr tmpaddr;

	_TRACE_CALL;

	FETCH_INVALID_OPT(stemp, "action", _NEED);

	if(strcmp(stemp, "rm") == 0)	//remove
	{
		_BC_INIT("bcdata");
		while(_BC_NEXT())
		{
			memset(&entry, 0, sizeof(entry));
			_BC_ENTRY_STR(filterName, _OPT);
#if 0
			_BC_ENTRY_INT(protoType, _OPT);
			_BC_ENTRY_IP(sipStart, _OPT);
			_BC_ENTRY_IP(sipEnd, _OPT);
			_BC_ENTRY_IP(smask, _OPT);
			_BC_ENTRY_INT(sportStart, _OPT);
			_BC_ENTRY_INT(sportEnd, _OPT);
			_BC_ENTRY_IP(dipStart, _OPT);
			_BC_ENTRY_IP(dipEnd, _OPT);
			_BC_ENTRY_IP(dmask, _OPT);
			_BC_ENTRY_INT(dportStart, _OPT);
			_BC_ENTRY_INT(dportEnd, _OPT);
#endif
			/************Place your code here, do what you want to do! ************/
			/*remove*/
			if(findIPFilterEntrybyNameDirection(entry.filterName, DIR_OUT, NULL, &index))
				mib_chain_delete(MIB_IP_PORT_FILTER_TBL, index);

			/************Place your code here, do what you want to do! ************/
		}
		//take effect immediately...
		//setupFirewall();
		// Mason Yu. Take effect in real time; // Magician: Merge restart MAC filter into restart IPFilter and DMZ
		restart_IPFilter_DMZ_MACFilter();
	}
	else if(strcmp(stemp, "ad") == 0)	//add
	{
		memset(&entry, 0, sizeof(entry));

		_ENTRY_STR(filterName, _NEED);
		_ENTRY_INT(protoType, _NEED);
		//if(entry.protoType > 4){lineno = __LINE__; goto check_err;}
		_ENTRY_IP_STR(sipStart,tmpaddr, _OPT);
		_ENTRY_IP_STR(sipEnd,tmpaddr, _OPT);
		_ENTRY_IP_STR(smask,tmpaddr, _OPT);
		_ENTRY_IP_STR(dipStart,tmpaddr, _OPT);
		_ENTRY_IP_STR(dipEnd,tmpaddr, _OPT);
		_ENTRY_IP_STR(dmask,tmpaddr, _OPT);
		_ENTRY_INT(sportStart, _OPT);
		_ENTRY_INT(sportEnd, _OPT);
		
		if(entry.sportEnd == 0)
			entry.sportEnd = entry.sportStart;
		
		if(entry.sportEnd < entry.sportStart){lineno = __LINE__; goto check_err;}

		_ENTRY_INT(dportStart, _OPT);
		_ENTRY_INT(dportEnd, _OPT);
		
		if(entry.dportEnd == 0)
			entry.dportEnd = entry.dportStart;
		
		if(entry.dportEnd < entry.dportStart){lineno = __LINE__; goto check_err;}

		/************Place your code here, do what you want to do! ************/
		/*add new*/
		//jim double check the parameters validity.
		if(!entry.sipStart)
		{
			entry.smask=0;
			entry.sipEnd=0;
		}
		if(!entry.dipStart)
		{
			entry.dmask=0;
			entry.dipEnd=0;
		}
#ifdef CONFIG_IPV6
		str = boaGetVar(wp, "protoTypeV6", "");
		if (str[0]) {
			ipv6_protoType = (char)atoi(str);
		}

		if(entry.protoType == 0 && ipv6_protoType == 0) //None proto... don't care ,, all.
#else
		if(entry.protoType == 0) //None proto... don't care ,, all.
#endif
		{    //mask off port info...
			entry.sportStart=0;
			entry.sportEnd=0;
			entry.dportStart=0;
			entry.dportEnd=0;
		}
		{		// IP/Port FILTER
			MIB_CE_IP_PORT_FILTER_T filterEntry;
			// if the exist entry with the same name, abandon the add action...
			if(findIPFilterEntrybyNameDirection(entry.filterName, DIR_OUT, NULL, NULL) \
				|| getTotalIPFilterNumOneDirection(DIR_OUT) > MAX_OUTGOING_IPFILTER_RULE_NUM)
				goto check_err;
#ifdef CONFIG_IPV6
			str = boaGetVar(wp, "IpProtocolType", "");
			filterEntry.IpProtocol = (char)atoi(str);
			// If it is a IPv6 rule. Save the protoType into  ipfilter_whitelist data base.
			// Because the parseIpFilterInfo2Entry() will clean the MIB's ipportfilter_entry.
			if ( filterEntry.IpProtocol == IPVER_IPV6 )
				entry.protoType = ipv6_protoType;
#endif
			parseIpFilterInfo2Entry(&entry, &filterEntry, DIR_OUT);

#ifdef CONFIG_IPV6
			// If it is a IPv6 rule.
			if ( filterEntry.IpProtocol == IPVER_IPV6 )
			{
				str = boaGetVar(wp, "sip6Start", "");
				if (str[0]) {
					if (!inet_pton(PF_INET6, str, &filterEntry.sip6Start)) {
						printf("Invalid sip6Start for ipport filter!");
						goto check_err;
					}
				}

				str = boaGetVar(wp, "sip6End", "");
				if (str[0]) {
					if (!inet_pton(PF_INET6, str, &filterEntry.sip6End)) {
						printf("Invalid sip6End for ipport filter!");
						goto check_err;
					}
				}

				str = boaGetVar(wp, "dip6Start", "");
				if (str[0]) {
					if (!inet_pton(PF_INET6, str, &filterEntry.dip6Start)) {
						printf("Invalid dip6Start for ipport filter!");
						goto check_err;
					}
				}

				str = boaGetVar(wp, "dip6End", "");
				if (str[0]) {
					if (!inet_pton(PF_INET6, str, &filterEntry.dip6End)) {
						printf("Invalid dip6End for ipport filter!");
						goto check_err;
					}
				}

				str = boaGetVar(wp, "sip6PrefixLen", "");
				filterEntry.sip6PrefixLen = (char)atoi(str);

				str = boaGetVar(wp, "dip6PrefixLen", "");
				filterEntry.dip6PrefixLen = (char)atoi(str);
			}
#endif
			ret = mib_chain_add(MIB_IP_PORT_FILTER_TBL, (unsigned char*)&filterEntry);
			if(ret == -1)
				goto Max_Size_Reached;
			else if( ret == 0 )
				goto check_err;

			//take effect immediate
			restart_IPFilter_DMZ_MACFilter();
		}
		/************Place your code here, do what you want to do! ************/
	}
	else {lineno = __LINE__; goto check_err;}
	//Write to flash, take effect forever
	mib_update(CURRENT_SETTING, CONFIG_MIB_ALL);
	_COND_REDIRECT;
Max_Size_Reached:
	_BC_FREE();
	_TRACE_LEAVEL;
	ERR_MSG("规则数已达最大限制!"); //Max number of rules reached!
	return;
check_err:
	_BC_FREE();
	_TRACE_LEAVEL;
	ERR_MSG("设定错误!");
	return;
}

void formPortFilterWhite(request * wp, char *path, char *query)
{
	struct ipfilter_whitelist_entry	entry;
	char				isblack = 0;
	char*				slist = NULL;
	char*				stemp = "";
	char*				send = NULL;
	char*				stoken = NULL;
	int					lineno = __LINE__;
	int					index = 0;
	char				iffs[20][20];	//接口列表
	MIB_CE_IP_PORT_FILTER_T filterEntry;
	int j, ret;
#ifdef CONFIG_IPV6
	char *str, ipv6_protoType=0;
	MIB_CE_IP_PORT_FILTER_T IpEntry;
#endif
	struct in_addr tmpaddr;
	_BC_USE;

	_TRACE_CALL;

	FETCH_INVALID_OPT(stemp, "action", _NEED);

	if(strcmp(stemp, "rm") == 0)	//remove
	{
		_BC_INIT("bcdata");
		while(_BC_NEXT())
		{
			memset(&entry, 0, sizeof(entry));
			_BC_ENTRY_STR(filterName, _OPT);
#if 0
			_BC_ENTRY_INT(protoType, _OPT);
			_BC_ENTRY_IP(sipStart, _OPT);
			_BC_ENTRY_IP(sipEnd, _OPT);
			_BC_ENTRY_IP(smask, _OPT);
			_BC_ENTRY_INT(sportStart, _OPT);
			_BC_ENTRY_INT(sportEnd, _OPT);
			_BC_ENTRY_IP(dipStart, _OPT);
			_BC_ENTRY_IP(dipEnd, _OPT);
			_BC_ENTRY_IP(dmask, _OPT);
			_BC_ENTRY_INT(dportStart, _OPT);
			_BC_ENTRY_INT(dportEnd, _OPT);
#endif
			/************Place your code here, do what you want to do! ************/
			/*remove*/
			if(findIPFilterEntrybyNameDirection(entry.filterName, DIR_IN, NULL, &index))
			{
				mib_chain_delete(MIB_IP_PORT_FILTER_TBL, index);
			}
			/************Place your code here, do what you want to do! ************/
		}
		//take effect immediately
		//setupFirewall();
		restart_IPFilter_DMZ_MACFilter();
	}
	else if(strcmp(stemp, "ad") == 0)	//add
	{
		memset(&entry, 0, sizeof(entry));

		_ENTRY_STR(filterName, _NEED);
		_ENTRY_INT(protoType, _NEED);
		//if(entry.protoType > 4){lineno = __LINE__; goto check_err;}
		_ENTRY_IP_STR(sipStart,tmpaddr, _OPT);
		_ENTRY_IP_STR(sipEnd,tmpaddr, _OPT);
		_ENTRY_IP_STR(smask,tmpaddr, _OPT);
		_ENTRY_IP_STR(dipStart,tmpaddr, _OPT);
		_ENTRY_IP_STR(dipEnd,tmpaddr, _OPT);
		_ENTRY_IP_STR(dmask,tmpaddr, _OPT);
		_ENTRY_INT(sportStart, _OPT);
		_ENTRY_INT(sportEnd, _OPT);
		
		if(entry.sportEnd == 0)
			entry.sportEnd = entry.sportStart;
		
		if(entry.sportEnd < entry.sportStart){lineno = __LINE__; goto check_err;}

		_ENTRY_INT(dportStart, _OPT);
		_ENTRY_INT(dportEnd, _OPT);

		if(entry.dportEnd == 0)
			entry.dportEnd = entry.dportStart;
		
		if(entry.dportEnd < entry.dportStart){lineno = __LINE__; goto check_err;}

/*
	//closed by jim ,we current do not support ip filter bound with interface...
		_ENTRY_BOOL(allport, _NEED);
		if(entry.allport < 0 || entry.allport > 1){lineno = __LINE__; goto check_err;}
		if(entry.allport == 0)
		{
			_ENTRY_INT(portnum, _NEED);
			if(entry.portnum < 0 || entry.portnum >= 20){lineno = __LINE__; goto check_err;}
			if(entry.portnum){FETCH_INVALID_OPT(stemp, "ifname", _NEED); stoken = stemp;}
			for(index = 0; stemp && index < entry.portnum; index++)
			{
				stemp = strchr(stoken, ';');
				if(stemp)*stemp = 0;
				strncpy(iffs[index], stoken, 20);
				stoken = stemp ? stemp + 1: NULL;
			}
		}
*/
		//jim double check the parameters validity.
		if(!entry.sipStart)
		{
			entry.smask=0;
			entry.sipEnd=0;
		}
		if(!entry.dipStart)
		{
			entry.dmask=0;
			entry.dipEnd=0;
		}
#ifdef CONFIG_IPV6
		str = boaGetVar(wp, "protoTypeV6", "");
		if (str[0]) {
			ipv6_protoType = (char)atoi(str);
		}

		if(entry.protoType == 0 && ipv6_protoType == 0) //None proto... don't care ,, all.
#else
		if(entry.protoType == 0) //None proto... don't care ,, all.
#endif
		{    //mask off port info...
			entry.sportStart=0;
			entry.sportEnd=0;
			entry.dportStart=0;
			entry.dportEnd=0;
		}
		/************Place your code here, do what you want to do! ************/
		{		// IP/Port FILTER
			MIB_CE_IP_PORT_FILTER_T filterEntry;
			// if the exist entry with the same name, abandon the add action...
			if(findIPFilterEntrybyNameDirection(entry.filterName, DIR_IN, NULL, NULL) \
				|| getTotalIPFilterNumOneDirection(DIR_IN) > MAX_INCOMING_IPFILTER_RULE_NUM)
				goto check_err;
#ifdef CONFIG_IPV6
			str = boaGetVar(wp, "IpProtocolType", "");
			filterEntry.IpProtocol = (char)atoi(str);
			// If it is a IPv6 rule. Save the protoType into  ipfilter_whitelist data base.
			// Because the parseIpFilterInfo2Entry() will clean the MIB's ipportfilter_entry.
			if ( filterEntry.IpProtocol == IPVER_IPV6 )
				entry.protoType = ipv6_protoType;
#endif
			parseIpFilterInfo2Entry((struct ipfilter_blacklist_entry*)&entry, &filterEntry, DIR_IN);

#ifdef CONFIG_IPV6
			// If it is a IPv6 rule.
			if ( filterEntry.IpProtocol == IPVER_IPV6 )
			{
				str = boaGetVar(wp, "sip6Start", "");
				if (str[0]) {
					if (!inet_pton(PF_INET6, str, &filterEntry.sip6Start)) {
						printf("Invalid sip6Start for ipport filter!");
						goto check_err;
					}
				}

				str = boaGetVar(wp, "sip6End", "");
				if (str[0]) {
					if (!inet_pton(PF_INET6, str, &filterEntry.sip6End)) {
						printf("Invalid sip6End for ipport filter!");
						goto check_err;
					}
				}

				str = boaGetVar(wp, "dip6Start", "");
				if (str[0]) {
					if (!inet_pton(PF_INET6, str, &filterEntry.dip6Start)) {
						printf("Invalid dip6Start for ipport filter!");
						goto check_err;
					}
				}

				str = boaGetVar(wp, "dip6End", "");
				if (str[0]) {
					if (!inet_pton(PF_INET6, str, &filterEntry.dip6End)) {
						printf("Invalid dip6End for ipport filter!");
						goto check_err;
					}
				}

				str = boaGetVar(wp, "sip6PrefixLen", "");
				filterEntry.sip6PrefixLen = (char)atoi(str);

				str = boaGetVar(wp, "dip6PrefixLen", "");
				filterEntry.dip6PrefixLen = (char)atoi(str);
			}
#endif

			ret = mib_chain_add(MIB_IP_PORT_FILTER_TBL, (unsigned char*)&filterEntry);
			if( ret == -1 )
				goto Max_Size_Reached;
			else if( ret == 0 )
				goto check_err;

			//take effect immediate
			restart_IPFilter_DMZ_MACFilter();
		}
		/************Place your code here, do what you want to do! ************/
	}
	else {lineno = __LINE__; goto check_err;}
		//Write to flash, take effect forever
	mib_update(CURRENT_SETTING, CONFIG_MIB_ALL);
	_COND_REDIRECT;
Max_Size_Reached:
	_BC_FREE();
	_TRACE_LEAVEL;
	ERR_MSG("规则数已达最大限制!"); //Max number of rules reached!
	return;
check_err:
	_BC_FREE();
	_TRACE_LEAVEL;
	ERR_MSG("设定错误!");
	return;
}

#ifdef WLAN_SEC_WEB_ENABLE
#ifdef WLAN_VAP_ACL
int WlanDelAllEntry(int wlanIdx, int vwlanIdx)
{
	int j = 0, e_num = 0;

	mib_save_wlanIdx();

	wlan_idx = wlanIdx;
	e_num = mib_chain_total(MIB_WLAN_AC_TBL+vwlanIdx*WLAN_MIB_MAPPING_STEP);
	for(j = e_num; j > 0; j--)
	{
		if(!mib_chain_delete(MIB_WLAN_AC_TBL+vwlanIdx*WLAN_MIB_MAPPING_STEP, j-1))
			return 1;
	}
	mib_recov_wlanIdx();
	return 0;
}
#else
int WlanDelAllEntry()
{
	int i = 0, j = 0, e_num = 0;
	
	mib_save_wlanIdx();
	for(i = 0; i < NUM_WLAN_INTERFACE; i++)
	{
		wlan_idx = i;
		e_num = mib_chain_total(MIB_WLAN_AC_TBL);
		for(j = e_num; j > 0; j--)
		{
			if(!mib_chain_delete(MIB_WLAN_AC_TBL, j-1))
				return 1;
		}
	}
	mib_recov_wlanIdx();
	return 0;
}
#endif

int get_ifname_idx_by_ssididx(int ssid_idx, int *wlanIdx, int *vwlanIdx)
{
	int i=0, j=0;
	int flag=0;

	for(i=0; i<NUM_WLAN_INTERFACE; i++)
	{
		for(j=0; j<=WLAN_MBSSID_NUM; j++)
		{
			if(i*(WLAN_MBSSID_NUM+1)+j == ssid_idx)
			{
				flag=1;
				break;
			}
			else
				continue;
		}
		if(flag == 1)
			break;
	}

	if(flag == 1)
	{
		*wlanIdx = i;
		*vwlanIdx = j;
	}

	return 0;
}

void formWlanMacFilter(request *wp, char *path, char *query)
{
	struct routemac_entry	entry, Entry;
	char *stemp = "";
	char *str;
	int lineno = __LINE__;
	struct wlac_entry wl_entry, wl_Entry;
	int j = 0, index = 0, wl_Num = 0;
	unsigned char WlanMacFilterMode = 0; // 0-disable, 1-whitelist, 2-blacklist
#ifdef WLAN_VAP_ACL
	int vwlan_idx = 0;
	struct mbssid_entry wl_mode_entry, wl_mode_pre_entry, wl_idx_entry;
#endif


	mib_save_wlanIdx();

#ifdef WLAN_VAP_ACL
	int WlanSSIDIdx=0, ssid_idx_pre=0;
	WlanSSIDIdx = atoi(boaGetVar(wp, "WlanSSIDIdx", ""));
	get_ifname_idx_by_ssididx(WlanSSIDIdx, &wlan_idx, &vwlan_idx);
	mib_get_s(MIB_WLAN_AC_SSID_IDX, (void *)&ssid_idx_pre, sizeof(ssid_idx_pre));
	if(ssid_idx_pre != WlanSSIDIdx)
		mib_set(MIB_WLAN_AC_SSID_IDX,&WlanSSIDIdx);
#endif

	_BC_USE;

	_TRACE_CALL;
	FETCH_INVALID_OPT(stemp, "action", _NEED);

	if(strcmp(stemp, "sw") == 0)	//change mode
	{
		int mode_pre = 0;
		str = boaGetVar(wp, "WlanMacFilterMode", "");
		if(!strcmp(str, "off"))
			WlanMacFilterMode = 0;
		else if(!strcmp(str, "white"))
			WlanMacFilterMode = 1;
		else if(!strcmp(str, "black"))
			WlanMacFilterMode = 2;
		
#ifdef WLAN_VAP_ACL
		memset(&wl_mode_pre_entry, 0, sizeof(struct mbssid_entry));
		mib_chain_get(MIB_MBSSIB_TBL, vwlan_idx, (void *)&wl_mode_pre_entry);
		mode_pre = wl_mode_pre_entry.acl_enable;
#else
		mib_get_s(MIB_WLAN_MACAC_ENABLED, (void *)&mode_pre, sizeof(mode_pre));
#endif
		if(WlanMacFilterMode != mode_pre)
		{
#ifdef WLAN_VAP_ACL
			if(WlanDelAllEntry(wlan_idx, vwlan_idx))
#else
			if(WlanDelAllEntry())
#endif
			{
				printf("%s(%d) Delete all entries fail!\n", __FUNCTION__, __LINE__);
				mib_recov_wlanIdx();
				goto check_err;
			}
		}
		else
		{
			mib_recov_wlanIdx();
			return;
		}
		
#ifdef WLAN_VAP_ACL
		memset(&wl_mode_entry,0,sizeof(MIB_CE_MBSSIB_T));
		mib_chain_get(MIB_MBSSIB_TBL, vwlan_idx, (void *)&wl_mode_entry);
		wl_mode_entry.acl_enable = WlanMacFilterMode;
		mib_chain_update(MIB_MBSSIB_TBL, (void*)&wl_mode_entry, vwlan_idx);
		mib_recov_wlanIdx();
#else
		mib_set(MIB_WLAN_AC_ENABLED,&WlanMacFilterMode);
#endif
		
		if(WlanMacFilterMode==0)
			syslog(LOG_CRIT, "Wlan MAC Filter, close mac filter.");
		else if(WlanMacFilterMode==1)
				syslog(LOG_CRIT, "Wlan MAC Filter, open mac filter. (whitelist)");
		else if(WlanMacFilterMode==2)
				syslog(LOG_CRIT, "Wlan MAC Filter, open mac filter. (blacklist)");
	}
	else if(strcmp(stemp, "rm") == 0)	//remove
	{
		int k = 0;
		char mac[20] = {0};
		char comment[60] = {0};
		unsigned char mac_now[MAC_ADDR_LEN] = {0};
		_BC_INIT("bcdata");
		while(_BC_NEXT())
		{
			memset(&wl_entry, 0, sizeof(struct wlac_entry));

			if((sbc = bc_gets(bc, "comment")) == NULL)
			{
				lineno = __LINE__;
				continue;
			}
			snprintf(comment, sizeof(comment), "%s", sbc);

			
			if((sbc = bc_gets(bc, "macAddr")) == NULL)
			{
				lineno = __LINE__;
				continue;
			}
			snprintf(mac, sizeof(mac), "%s", sbc);

			changeMacFormatWlan(mac, '-');
			rtk_string_to_hex(mac, mac_now, 12);
			
			wl_Num = mib_chain_total(MIB_WLAN_AC_TBL+vwlan_idx*WLAN_MIB_MAPPING_STEP);
			for(k = wl_Num; k > 0; k--)
			{
				memset(&wl_Entry, 0, sizeof(struct wlac_entry));
				mib_chain_get(MIB_WLAN_AC_TBL+vwlan_idx*WLAN_MIB_MAPPING_STEP, k-1, (void*)&wl_Entry);
				if(!memcmp(wl_Entry.macAddr,mac_now,sizeof(wl_Entry.macAddr)))
				{
					mib_chain_delete(MIB_WLAN_AC_TBL+vwlan_idx*WLAN_MIB_MAPPING_STEP, k-1);
					continue;
				}
			}
			mib_recov_wlanIdx();
		}
	}

	else if(strcmp(stemp, "rmall") == 0) //remove all

	{
#ifdef WLAN_VAP_ACL
				if(WlanDelAllEntry(wlan_idx, vwlan_idx)){
#else
				if(WlanDelAllEntry()){
#endif
			printf("%s(%d) Delete all entries fail!\n", __FUNCTION__, __LINE__);
			goto check_err;
		}
		mib_recov_wlanIdx();
	}

#if 0
	else if(strcmp(stemp, "up") == 0)	//update
	{
		char *mac;
		char *comment;
		unsigned char mac_now[MAC_ADDR_LEN] = {0};
		wl_Num = mib_chain_total(MIB_WLAN_AC_TBL);
		memset(&entry, 0, sizeof(struct wlac_entry));
		
		comment = boaGetVar(wp, "comment", " ");
		mac = boaGetVar(wp, "macAddr", " ");
		changeMacFormatWlan(mac, '-');
		rtk_string_to_hex(mac, mac_now, MAC_ADDR_LEN*2);
		
		mib_save_wlanIdx();
		index = atoi(boaGetVar(wp,"index",""));
		for(i = 0;i < wl_Num;i++)//find index
		{
			mib_chain_get(MIB_WLAN_AC_TBL, i, (void *)&Entry);
		}
		mib_chain_update(MIB_WLAN_AC_TBL, (void *)&entry, index);
		mib_recov_wlanIdx();
	}
#endif
	else if(strcmp(stemp, "ad") == 0)	//add
	{
		char *mac;
		char *comment;
		char *sw;
		wl_Num = mib_chain_total(MIB_WLAN_AC_TBL);
		if(wl_Num >= MAX_WLAN_AC_NUM)
		{
			ERR_MSG("对不起,规则数已达最大限制!");
			goto check_err;
		}
		memset(&wl_entry, 0, sizeof(struct wlac_entry));

		comment = boaGetVar(wp, "comment", " ");
		snprintf(wl_entry.comment, sizeof(wl_entry.comment), "%s", comment);
		mac = boaGetVar(wp, "macAddr", " ");
		changeMacFormatWlan(mac, '-');
		rtk_string_to_hex(mac, wl_entry.macAddr, MAC_ADDR_LEN*2);
		

#ifdef WLAN_VAP_ACL
		mib_chain_get(MIB_MBSSIB_TBL, vwlan_idx, (void *)&wl_idx_entry);
		wl_entry.index = wl_idx_entry.wlan_ac_idx+1;
		wl_idx_entry.wlan_ac_idx = wl_idx_entry.wlan_ac_idx+1;
		mib_chain_update(MIB_MBSSIB_TBL, (void*)&wl_idx_entry, vwlan_idx);
#endif
		wl_entry.wlanIdx = wlan_idx;
		mib_chain_add(MIB_WLAN_AC_TBL+vwlan_idx*WLAN_MIB_MAPPING_STEP,&wl_entry);

		mib_recov_wlanIdx();
	}
	else
		{lineno = __LINE__; goto check_err;}


	config_WLAN_by_fork(ACT_RESTART, CONFIG_SSID_ALL);
	_COND_REDIRECT;
check_err:
	_BC_FREE();
	_TRACE_LEAVEL;
	return;
}


int WlanMacFilterList(int eid, request * wp, int argc, char ** argv)
{
	int cnt = 0, j = 0;
	int index = 0;
	int lineno = __LINE__;
	char tmp[32] = {0};
	struct wlac_entry wl_entry;
	unsigned int WlanMacFilterMode = 0;
#ifdef WLAN_VAP_ACL
	int vwlan_idx = 0;
	struct mbssid_entry wl_mode_entry;
#endif
	_TRACE_CALL;

#ifdef WLAN_VAP_ACL
	int ssid_idx=0;
	mib_save_wlanIdx();

	mib_get_s(MIB_WLAN_AC_SSID_IDX, (void*)&ssid_idx, sizeof(ssid_idx));
	get_ifname_idx_by_ssididx(ssid_idx, &wlan_idx, &vwlan_idx);
	_PUT_INT(ssid_idx);

	memset(&wl_mode_entry, 0, sizeof(struct mbssid_entry));
	mib_chain_get(MIB_MBSSIB_TBL, vwlan_idx, (void *)&wl_mode_entry);
	WlanMacFilterMode = wl_mode_entry.acl_enable;
#else
	mib_get_s(MIB_WLAN_MACAC_ENABLED, (void *)&WlanMacFilterMode, sizeof(WlanMacFilterMode));
#endif
	_PUT_INT(WlanMacFilterMode);

	if(WlanMacFilterMode != 0){
#ifdef WLAN_VAP_ACL
		cnt=mib_chain_total(MIB_WLAN_AC_TBL+vwlan_idx*WLAN_MIB_MAPPING_STEP);
#else
		cnt=mib_chain_total(MIB_WLAN_AC_TBL);
#endif
		for(j = 0; j < cnt; j++)
		{
			memset(&wl_entry,0,sizeof(struct wlac_entry));
#ifdef WLAN_VAP_ACL
			mib_chain_get(MIB_WLAN_AC_TBL+vwlan_idx*WLAN_MIB_MAPPING_STEP,j,&wl_entry);
#else
			mib_chain_get(MIB_WLAN_AC_TBL,j,&wl_entry);
#endif
			snprintf(tmp, sizeof(tmp), "%02x-%02x-%02x-%02x-%02x-%02x", wl_entry.macAddr[0], wl_entry.macAddr[1], wl_entry.macAddr[2],
			wl_entry.macAddr[3], wl_entry.macAddr[4], wl_entry.macAddr[5]);
			boaWrite(wp, "push(new it_nr(\"%d\"" _PTS _PTS"));\n",index, "comment",wl_entry.comment, "macAddr", tmp);
			index++;
		}
	}
	_TRACE_LEAVEL;
	return 0;
}



#endif

#ifdef DHCP_ARP_IGMP_RATE_LIMIT
int initPageL2Limit (int eid, request * wp, int argc, char ** argv)
{
	int total,idx=0, i;
	MIB_L2_BC_LIMIT_T entry;
	char port_name[8];
	int ret = 0, phyPortId=-1;
	int ethPhyPortId = rtk_port_get_wan_phyID();

	total = mib_chain_total(MIB_L2_BROADCAST_LIMIT_TBL);
	for(i=0; i<total && i<ELANVIF_NUM; i++)
	{
		phyPortId = rtk_port_get_lan_phyID(i);
		if (phyPortId != -1 && phyPortId == ethPhyPortId)
			continue;
		
		sprintf(port_name, "LAN%d",i+1);
		mib_chain_get(MIB_L2_BROADCAST_LIMIT_TBL, i,&entry);
		printf("port_name %s\n",port_name);
		ret += boaWrite(wp, "l2_limit_status[%d]={name:\"%s\", dhcpLimit:\"%d\", arpLimit:\"%d\", igmpLimit:\"%d\", idx:\"%d\"};\n"
					, idx, port_name, entry.dhcpLimit, entry.arpLimit, entry.igmpLimit, i);
		idx++;
	}

	return ret;
}
void formL2Limit(request * wp, char *path, char *query)
{
	int limited_port;
	MIB_L2_BC_LIMIT_T Entry;
	char *stemp = "";
	int lineno = __LINE__;
	char prot_String[16];
	int ethPhyPortId = rtk_port_get_wan_phyID();
	int phyPortId=-1;

	_TRACE_CALL;
	FETCH_INVALID_OPT(stemp,"action", _NEED);
	if(strcmp(stemp, "apply_multi") == 0){
	//lan port
		for(limited_port=0;limited_port<ELANVIF_NUM;limited_port++){
			phyPortId = rtk_port_get_lan_phyID(limited_port);
			if (phyPortId != -1 && phyPortId == ethPhyPortId)
				continue;
			
			mib_chain_get(MIB_L2_BROADCAST_LIMIT_TBL,limited_port,&Entry);

			snprintf(prot_String, 15, "DHCP_%d", limited_port);
			FETCH_INVALID_OPT(stemp,prot_String, _OPT);
			if(stemp)
				Entry.dhcpLimit = atoi(stemp);
			else
				Entry.dhcpLimit = 0;
			snprintf(prot_String, 15, "ARP_%d", limited_port);
			FETCH_INVALID_OPT(stemp,prot_String, _OPT);
			if(stemp)
				Entry.arpLimit= atoi(stemp);
			else
				Entry.arpLimit= 0;
			snprintf(prot_String, 15, "IGMP_%d", limited_port);
			FETCH_INVALID_OPT(stemp,prot_String, _OPT);
			if(stemp)
				Entry.igmpLimit= atoi(stemp);
			else
				Entry.igmpLimit= 0;

			mib_chain_update(MIB_L2_BROADCAST_LIMIT_TBL,&Entry,limited_port);
		}
#ifdef COMMIT_IMMEDIATELY
		Commit();
#endif
		initDhcpIgmpArpLimit();

	}
	_COND_REDIRECT;
	return;
check_err:
	_TRACE_LEAVEL;
	ERR_MSG("设定错误!");
	return;
}
#endif

