/*
 *      Web server handler routines for Speedtest
 */
#include "options.h"

/*-- Local inlcude files --*/
#include "mib.h"
#include "fmdefs.h"
#include "utility.h"
#include "subr_cu.h"

#ifdef CONFIG_USER_CUSPEEDTEST
struct CU_SpeedTest_Diagnostics gWeb_SpeedTestDiagnostics;
#define SPEED_TEST_RESULT_FILE "/tmp/speed_test_result"

void initWeb_SpeedTestDiag()
{
	clearSpeedTestDiagnostics(&gWeb_SpeedTestDiagnostics);
}

void setWebSpeedTestDiagnostics(char *testURL, char *reportURL, char *downloadURL, char *testMode, char *wanName, char *Eupppoename, char *Eupassword)	
{
	int ifindex;
	char IfName[32]={0};

	FreeSpeedTestDiagnosticsSouce(&gWeb_SpeedTestDiagnostics);
	if(testURL)
		gWeb_SpeedTestDiagnostics.ptestURL = strdup(testURL);
	if(reportURL)
		gWeb_SpeedTestDiagnostics.preportURL= strdup(reportURL);
	if(downloadURL)
		gWeb_SpeedTestDiagnostics.pdownloadURL = strdup(downloadURL);

	if(Eupppoename)
		gWeb_SpeedTestDiagnostics.Eupppoename = strdup(Eupppoename);
	if(Eupassword)
		gWeb_SpeedTestDiagnostics.Eupassword = strdup(Eupassword);


	if((wanName == NULL) || (strlen(wanName) == 0))
	{
		strcpy( gWeb_SpeedTestDiagnostics.IfName, "" );
	}
	else
	{
		ifindex = getWANIfindexFromIfName(wanName);
		ifGetName(ifindex, IfName, sizeof(IfName));
		strcpy(gWeb_SpeedTestDiagnostics.IfName, IfName);
	}
	
	if( strcmp( testMode, "downloadMode" )==0 )
		gWeb_SpeedTestDiagnostics.testMode = edownloadMode;
	else if(strcmp( testMode, "serverMode" )==0 )
		gWeb_SpeedTestDiagnostics.testMode = eserverMode;
	
}

void StartWeb_SpeedTestDiag()
{
	gWeb_SpeedTestDiagnostics.DiagnosticsState=eSpeedTest_Requested;
	gWeb_SpeedTestDiagnostics.source = esource_WEB;
	setSpeedtestDoneFlag(0);
	StartCU_SpeedTestDiag_General(&gWeb_SpeedTestDiagnostics);
	return;
}

int dumpSpeedtestInfo(int eid, request * wp, int argc, char **argv)
{
	int nBytesSent = 0;
	FILE *fp;

	if(access(SPEED_TEST_RESULT_FILE, F_OK) != 0){
		nBytesSent += boaWrite(wp, "%s", "<div align=\"left\"id=\"result\" ><b><font color=\"#FF0000\" size=\"-1\">No Test Result</font></b></div>\n");
		return nBytesSent;
	}else{
		fp = fopen(SPEED_TEST_RESULT_FILE,"r");
		if(fp){
			printf("%s:%d\n",__func__,__LINE__);
			char buff[256];
			char part1[32];
			char part2[256];
			
			nBytesSent += boaWrite(wp, "%s", "<b>Test Result<br>\n");
			nBytesSent += boaWrite(wp, "%s", "<table class=\"flat\" border=\"1\" cellpadding=\"1\" cellspacing=\"1\">\n");
			while (fgets(buff, sizeof(buff), fp) != NULL) {
				part1[0]=0;
				part2[0]=0;
				sscanf(buff,"%s\t%s",part1,part2);
				nBytesSent += boaWrite(wp, "<tr><td width=\"200px\">%s</td><td>%s</td></tr>\n", part1,part2);
			}
			nBytesSent += boaWrite(wp, "%s", "</table>\n");
			
			fclose(fp);			
		}
		return nBytesSent;
	}

}

void formSpeedtest(request * wp, char *path, char *query)
{
	char *submitUrl;
	char *testURL, *reportURL, *downloadURL, *testMode, *wanName, *Eupppoename, *Eupassword;

	testMode = boaGetVar(wp, "testMode", "");
	if (testMode[0]) {
		printf("<%s, %d, testMode=%s>\n", __FUNCTION__, __LINE__, testMode);
	}

	downloadURL = boaGetVar(wp, "downloadURL", "");
	if (downloadURL[0]) {
		printf("<%s, %d, downloadURL=%s>\n", __FUNCTION__, __LINE__, downloadURL);
	}

	testURL = boaGetVar(wp, "testURL", "");
	if (testURL[0]) {
		printf("<%s, %d, testURL=%s>\n", __FUNCTION__, __LINE__, testURL);
	}

	reportURL = boaGetVar(wp, "reportURL", "");
	if (reportURL[0]) {
		printf("<%s, %d, reportURL=%s>\n", __FUNCTION__, __LINE__, reportURL);
	}

	Eupppoename = boaGetVar(wp, "Eupppoename", "");
	if (Eupppoename[0]) {
		printf("<%s, %d, Eupppoename=%s>\n", __FUNCTION__, __LINE__, Eupppoename);
	}

	Eupassword = boaGetVar(wp, "Eupassword", "");
	if (Eupassword[0]) {
		printf("<%s, %d, Eupassword=%s>\n", __FUNCTION__, __LINE__, Eupassword);
	}

	wanName = boaGetVar(wp, "waninf", "");
	if (wanName[0]) {
		printf("<%s, %d, wanName=%s>\n", __FUNCTION__, __LINE__, wanName);
	}

	setWebSpeedTestDiagnostics(testURL, reportURL, downloadURL, testMode, wanName, Eupppoename, Eupassword);
	StartWeb_SpeedTestDiag();

	boaRedirect(wp, "/bd/speedtest.asp");	
	return;
	
}

#endif

