/*
 *      Web server handler routines for System Pon status
 *
 */

#include "../webs.h"
#include "webform.h"
#include "mib.h"
#include "utility.h"
#include "debug.h"
#include "multilang.h"

#include "rtk/ponmac.h"
#include "rtk/gpon.h"
#include "rtk/epon.h"
#include "rtk/stat.h"
#include "rtk/switch.h"
#if defined(CONFIG_COMMON_RT_API)
#include <rtk/rt/rt_stat.h>
#include <rtk/rt/rt_epon.h>
#include <rtk/rt/rt_gpon.h>
#include <rtk/rt/rt_switch.h>
#endif
extern int rtk_gpon_usFecSts_get(int* en);

#ifdef CONFIG_RTK_OMCI_V1
#include <omci_api.h>
#include <gos_type.h>
#endif
#include <common/util/rt_util.h>

#ifdef CONFIG_GPON_FEATURE
#define LOID_INIT 0
#define LOID_SUCCESS 1
#define LOID_NOT_EXIST 2
#define LOID_PWD_ERR 3
#define LOID_DUPLICATE 4

#if defined(CONFIG_CMCC) || defined(CONFIG_CU_BASEON_CMCC)
int showgpon_status(int eid, request * wp, int argc, char **argv)
{
	unsigned int pon_mode;
	int onu;
	int nBytesSent = 0;

	if (mib_get_s(MIB_PON_MODE, &pon_mode, sizeof(pon_mode)) != 0) {
		if (pon_mode != GPON_MODE) {
			fprintf(stderr, "not GPON_MODE Error!");
			return 0;
		}
	} else {
		fprintf(stderr, "mib_get_s Error!");
		return 0;
	}

	onu = getGponONUState();
	if(onu == 5)
		nBytesSent += boaWrite(wp, "在线");
	else
		if(onu == 2 || onu ==3 || onu == 4)
			nBytesSent += boaWrite(wp, "连线中");
		else
			nBytesSent += boaWrite(wp, "离线");
		
	return nBytesSent;
}

#else
int showgpon_status(int eid, request * wp, int argc, char **argv)
{
	unsigned int pon_mode;
	int onu;

#ifdef CONFIG_RTK_OMCI_V1
	PON_OMCI_CMD_T msg;
	int loid_st = 0;
	int st;
	char *status_map[] = {
		"失败-未注册未认证",
		"失败-已注册未认证",
		"成功-已注册已认证"
	};
#else
	char *status_map[] = {
		"Unknown State",
		"Initial State",
		"Standby State",
		"Serial Number State",
		"Ranging State",
		"Operation State",
		"POPUP State",
		"Emergency Stop State",
	};
#endif
	int nBytesSent = 0;

	if (mib_get_s(MIB_PON_MODE, &pon_mode, sizeof(pon_mode)) != 0) {
		if (pon_mode != GPON_MODE) {
			fprintf(stderr, "not GPON_MODE Error!");
			return 0;
		}
	} else {
		fprintf(stderr, "mib_get_s Error!");
		return 0;
	}

	onu = getGponONUState();

#ifdef CONFIG_RTK_OMCI_V1
	memset(&msg, 0, sizeof(msg));
	msg.cmd = PON_OMCI_CMD_LOIDAUTH_GET_RSP;
	if(omci_SendCmdAndGet(&msg) == GOS_OK)
		loid_st = msg.state;
	else
		loid_st = -1; // wrong status
	AUG_PRT("%s-%d onu=%d loid_st=%d\n",__func__,__LINE__,onu,loid_st);
	if(onu==5 && loid_st == LOID_SUCCESS){
		st=2;
	}else if(onu==1 && loid_st == LOID_INIT){
		st=0;
	}else if(loid_st == LOID_NOT_EXIST || loid_st == LOID_PWD_ERR){
		st=0;
	}else if(onu == 2 || onu == 3 || onu == 4 ){ // for SN number error case.
		st=0;
	}else 
		st=1;
	nBytesSent += boaWrite(wp, "%s (O%d)", status_map[st], onu);
#else
	nBytesSent += boaWrite(wp, "%s (O%d)", status_map[onu], onu);
#endif

	return nBytesSent;
}
#endif
#endif

#ifdef TERMINAL_INSPECTION_SC
//20180103
int showOLT_status(int eid, request * wp, int argc, char **argv)
{
	unsigned int pon_mode;
	int nBytesSent = 0;
	int onu = 0;

	if (mib_get_s(MIB_PON_MODE, &pon_mode, sizeof(pon_mode)) != 0) {
		if (pon_mode != EPON_MODE) {
			fprintf(stderr, "not EPON_MODE Error!");
			return 0;
		}
	} else {
		fprintf(stderr, "mib_get_s Error!");
		return 0;
	}

	onu = getEponONUState(0);
    if (onu == 5)
    {
        int ret;

        ret = epon_getAuthState(0);
        if (1 == ret)
            nBytesSent += boaWrite(wp, "已注册");
        else
            nBytesSent += boaWrite(wp, "注册失败");
        }
    else
    {
        nBytesSent += boaWrite(wp, "未注册");
    }

	return nBytesSent;
}
#endif


#ifdef CONFIG_EPON_FEATURE
int showepon_status(int eid, request * wp, int argc, char **argv)
{
	unsigned int pon_mode;
	int nBytesSent = 0;
	int onu = 0;

	if (mib_get_s(MIB_PON_MODE, &pon_mode, sizeof(pon_mode)) != 0) {
		if (pon_mode != EPON_MODE) {
			fprintf(stderr, "not EPON_MODE Error!");
			return 0;
		}
	} else {
		fprintf(stderr, "mib_get_s Error!");
		return 0;
	}

	onu = getEponONUState(0);
    if (onu== 5)
    {
        int ret;

        ret = epon_getAuthState(0);
        if (1 == ret)
            nBytesSent += boaWrite(wp, "已注册已认证");
        else
            nBytesSent += boaWrite(wp, "已注册未认证");
    }
    else
    {
        nBytesSent += boaWrite(wp, "未注册未认证");
    }

	return nBytesSent;
}
#endif

int ponGetStatus(int eid, request * wp, int argc, char **argv)
{
	int nBytesSent = 0;
	char *name;
	uint64 value = 0;
	rtk_enable_t state = DISABLED;
	rtk_transceiver_data_t transceiver, readableCfg;
#if defined(CONFIG_COMMON_RT_API)
	rt_stat_port_cntr_t counters;
#else
	rtk_stat_port_cntr_t counters;
#endif
	unsigned int pon_mode;
	char buf[512] = {0};
#ifdef CONFIG_EPON_FEATURE
#ifdef CONFIG_COMMON_RT_API
	rt_epon_llid_entry_t llid_entry;
#else
	rtk_epon_llid_entry_t llid_entry;
#endif	
#endif
#ifdef CONFIG_GPON_FEATURE
	uint32 i;
	int ret = RT_ERR_OK;
#ifdef CONFIG_COMMON_RT_API
	rt_gpon_dsFlow_t attr;
#else
	rtk_gpon_dsFlow_attr_t attr;
#endif
#endif
	unsigned int pon_port_idx = 1;

	if (boaArgs(argc, argv, "%s", &name) < 1) {
		boaError(wp, 400, "Insufficient args\n");
		return -1;
	}
#if defined(CONFIG_COMMON_RT_API)
	rt_switch_phyPortId_get(LOG_PORT_PON, &pon_port_idx);
#else
	rtk_switch_phyPortId_get(RTK_PORT_PON, &pon_port_idx);
#endif

	memset(&transceiver, 0, sizeof(transceiver));
	memset(&readableCfg, 0, sizeof(readableCfg));
	memset(&counters, 0, sizeof(counters));
	buf[0] = '\0';

	if (!strcmp(name, "vendor-name")) {
		rtk_ponmac_transceiver_get
		    (RTK_TRANSCEIVER_PARA_TYPE_VENDOR_NAME, &transceiver);
		_get_data_by_type(RTK_TRANSCEIVER_PARA_TYPE_VENDOR_NAME, &transceiver, &readableCfg);

		return boaWrite(wp, "%s", readableCfg.buf);
	} else if (!strcmp(name, "part-number")) {
		rtk_ponmac_transceiver_get
		    (RTK_TRANSCEIVER_PARA_TYPE_VENDOR_PART_NUM, &transceiver);
		_get_data_by_type(RTK_TRANSCEIVER_PARA_TYPE_VENDOR_PART_NUM, &transceiver, &readableCfg);

		return boaWrite(wp, "%s", readableCfg.buf);
	}
#ifdef CONFIG_EPON_FEATURE
	else if (!strcmp(name, "epon-mac-address")) {
		llid_entry.llidIdx = 0;
#ifdef CONFIG_COMMON_RT_API
		rt_epon_llid_entry_get(&llid_entry);
#else
		rtk_epon_llid_entry_get(&llid_entry);
#endif

		return boaWrite(wp, "%02X:%02X:%02X:%02X:%02X:%02X",
				llid_entry.mac.octet[0], llid_entry.mac.octet[1],
				llid_entry.mac.octet[2], llid_entry.mac.octet[3],
				llid_entry.mac.octet[4], llid_entry.mac.octet[5]);
	} else if (!strcmp(name, "epon-fec-us-state")) {
#ifdef CONFIG_COMMON_RT_API
		rt_epon_usFecState_get(&state);
#else
		rtk_epon_usFecState_get(&state);
#endif
		return boaWrite(wp, "%s",
				state == ENABLED ? "启用" : "禁用");
	} else if (!strcmp(name, "epon-fec-ds-state")) {
#ifdef CONFIG_COMMON_RT_API
		rt_epon_dsFecState_get(&state);
#else
		rtk_epon_dsFecState_get(&state);
#endif
		return boaWrite(wp, "%s",
				state == ENABLED ? "启用" : "禁用");
	} else if (!strcmp(name, "epon-triple-churning")) {
		rtk_epon_churningStatus_get(&state);

		return boaWrite(wp, "%s", state == ENABLED ? "启用" : "禁用");
	} else if (!strcmp(name, "epon-los")) {
#ifdef CONFIG_COMMON_RT_API
		rt_epon_losState_get(&state);
#else
		rtk_epon_losState_get(&state);
#endif
		if (state == ENABLED)
			return boaWrite(wp, "Loss of Signal");
	}

#endif
#ifdef CONFIG_GPON_FEATURE
	else if (!strcmp(name, "gpon-fec-us-state")) {
		rtk_gpon_usFecSts_get((int32_t*)&state);
		
		return boaWrite(wp, "%s",
				state == ENABLED ? "启用" : "禁用");
	} else if (!strcmp(name, "gpon-fec-ds-state")) {
		rtk_gpon_dsFecSts_get((int32_t*)&state);

		return boaWrite(wp, "%s",
				state == ENABLED ? "启用" : "禁用");
	} else if (!strcmp(name, "gpon-encryption")) {
		char buftmp[512]={0};
#ifdef CONFIG_USER_BOA_WITH_MULTILANG
		char enable_str[8]= {0}, disable_str[8]={0};
		snprintf(enable_str, sizeof(enable_str), "%s", multilang(LANG_ENABLE));
		snprintf(disable_str, sizeof(disable_str), "%s", multilang(LANG_ELINK_DISABLE));
#else
		char enable_str[8]="启用",disable_str[8]="禁用";
#endif
		strncpy(buftmp,buf,sizeof(buf));		
		for (i = 0; i < 128; i++) {
#ifdef CONFIG_COMMON_RT_API
			ret = rt_gpon_dsFlow_get(i, &attr);
#else
			ret = rtk_gpon_dsFlow_get(i, &attr);
#endif
			if (ret != RT_ERR_OK)
				continue;
#ifdef CONFIG_COMMON_RT_API
			sprintf(buf, "%sFlow %u: %s<br>", buftmp, i, attr.aesEn ? enable_str : disable_str);
#else
			sprintf(buf, "%sFlow %u: %s<br>", buftmp, i, attr.aes_en ? enable_str : disable_str);
#endif
			strncpy(buftmp,buf,sizeof(buf));
		}

		return boaWrite(wp, buf);
	} else if (!strcmp(name, "gpon-alarm")) {

		rtk_gpon_alarmStatus_get(RTK_GPON_ALARM_LOS, (int32 *)&state);

		if (state == ENABLED)
			strcat(buf, "[信号丢失]");

		rtk_gpon_alarmStatus_get(RTK_GPON_ALARM_LOF, (int32 *)&state);

		if (state == ENABLED) {
			if (strlen(buf) != 0)
				strcat(buf, ", ");
			strcat(buf, "[帧丢失]");
		}

		rtk_gpon_alarmStatus_get(RTK_GPON_ALARM_LOM, (int32 *)&state);

		if (state == ENABLED) {
			if (strlen(buf) != 0)
				strcat(buf, ", ");
			strcat(buf, "[复帧丢失]");
		}

		return boaWrite(wp, buf);
	}
#endif
	else if (!strcmp(name, "bytes-sent")) {
#ifdef CONFIG_COMMON_RT_API
		rt_stat_port_get(pon_port_idx, RT_IF_OUT_OCTETS_INDEX, &value);
#else
		rtk_stat_port_get(pon_port_idx, IF_OUT_OCTETS_INDEX, &value);
#endif
		return boaWrite(wp, "%llu", value);
	} else if (!strcmp(name, "bytes-received")) {
#ifdef CONFIG_COMMON_RT_API
		rt_stat_port_get(pon_port_idx, RT_IF_IN_OCTETS_INDEX, &value);
#else
		rtk_stat_port_get(pon_port_idx, IF_IN_OCTETS_INDEX, &value);
#endif
		return boaWrite(wp, "%llu", value);
	} else if (!strcmp(name, "packets-sent")) {
#ifdef CONFIG_COMMON_RT_API
		rt_stat_port_getAll(pon_port_idx, &counters);
#else
		rtk_stat_port_getAll(pon_port_idx, &counters);
#endif
		return boaWrite(wp, "%u", counters.ifOutUcastPkts + counters.ifOutMulticastPkts
						+ counters.ifOutBrocastPkts);
	} else if (!strcmp(name, "packets-received")) {
#ifdef CONFIG_COMMON_RT_API
		rt_stat_port_getAll(pon_port_idx, &counters);
#else
		rtk_stat_port_getAll(pon_port_idx, &counters);
#endif
		return boaWrite(wp, "%u", counters.ifInUcastPkts + counters.ifInMulticastPkts
						+ counters.ifInBroadcastPkts);
	} else if (!strcmp(name, "unicast-packets-sent")) {
#ifdef CONFIG_COMMON_RT_API
		rt_stat_port_getAll(pon_port_idx, &counters);
#else
		rtk_stat_port_getAll(pon_port_idx, &counters);
#endif
		return boaWrite(wp, "%u", counters.ifOutUcastPkts);
	} else if (!strcmp(name, "unicast-packets-received")) {
#ifdef CONFIG_COMMON_RT_API
		rt_stat_port_getAll(pon_port_idx, &counters);
#else
		rtk_stat_port_getAll(pon_port_idx, &counters);
#endif
		return boaWrite(wp, "%u", counters.ifInUcastPkts);
	} else if (!strcmp(name, "multicast-packets-sent")) {
#ifdef CONFIG_COMMON_RT_API
		rt_stat_port_getAll(pon_port_idx, &counters);
#else
		rtk_stat_port_getAll(pon_port_idx, &counters);
#endif
		return boaWrite(wp, "%u", counters.ifOutMulticastPkts);
	} else if (!strcmp(name, "multicast-packets-received")) {
#ifdef CONFIG_COMMON_RT_API
		rt_stat_port_getAll(pon_port_idx, &counters);
#else
		rtk_stat_port_getAll(pon_port_idx, &counters);
#endif
		return boaWrite(wp, "%u", counters.ifInMulticastPkts);
	} else if (!strcmp(name, "broadcast-packets-sent")) {
#ifdef CONFIG_COMMON_RT_API
		rt_stat_port_getAll(pon_port_idx, &counters);
#else
		rtk_stat_port_getAll(pon_port_idx, &counters);
#endif
		return boaWrite(wp, "%u", counters.ifOutBrocastPkts);
	} else if (!strcmp(name, "broadcast-packets-received")) {
#ifdef CONFIG_COMMON_RT_API
		rt_stat_port_getAll(pon_port_idx, &counters);
#else
		rtk_stat_port_getAll(pon_port_idx, &counters);
#endif
		return boaWrite(wp, "%u", counters.ifInBroadcastPkts);
	} else if (!strcmp(name, "fec-errors")) {
		mib_get_s(MIB_PON_MODE, &pon_mode, sizeof(pon_mode));

		if (pon_mode == GPON_MODE) {
			rtk_gpon_global_counter_t counter;

			memset(&counter, 0, sizeof(counter));
			rtk_gpon_globalCounter_get(RTK_GPON_PMTYPE_DS_PHY, &counter);

			nBytesSent += boaWrite(wp, "%u", counter.dsphy.rx_fec_uncor_cw);
		} else {
#ifdef CONFIG_COMMON_RT_API
			rt_epon_counter_t counter;
#else
			rtk_epon_counter_t counter;
#endif

			memset(&counter, 0, sizeof(counter));
#ifdef CONFIG_COMMON_RT_API
			rt_epon_mibCounter_get(&counter);
#else
			rtk_epon_mibCounter_get(&counter);
#endif

			nBytesSent += boaWrite(wp, "%u", counter.fecUncorrectedBlocks);
		}

		return nBytesSent;
	} else if (!strcmp(name, "hec-errors")) {
		mib_get_s(MIB_PON_MODE, &pon_mode, sizeof(pon_mode));

		if (pon_mode == GPON_MODE) {
			rtk_gpon_global_counter_t counter;

			memset(&counter, 0, sizeof(counter));
			rtk_gpon_globalCounter_get(RTK_GPON_PMTYPE_DS_GEM,
						   &counter);

			nBytesSent += boaWrite(wp, "%u", counter.dsgem.rx_hec_correct);
		} else {
			// EPON has no HEC error
			nBytesSent += boaWrite(wp, "0");
		}

		return nBytesSent;
	} else if (!strcmp(name, "packets-dropped")) {
#ifdef CONFIG_COMMON_RT_API
		rt_stat_port_get(pon_port_idx, RT_IF_OUT_DISCARDS_INDEX, &value);
#else
		rtk_stat_port_get(pon_port_idx, IF_OUT_DISCARDS_INDEX, &value);
#endif
		return boaWrite(wp, "%llu", value);
	} else if (!strcmp(name, "pause-packets-sent")) {
#ifdef CONFIG_COMMON_RT_API
		rt_stat_port_get(pon_port_idx, RT_DOT3_OUT_PAUSE_FRAMES_INDEX, &value);
#else
		rtk_stat_port_get(pon_port_idx, DOT3_OUT_PAUSE_FRAMES_INDEX, &value);
#endif
		return boaWrite(wp, "%llu", value);
	} else if (!strcmp(name, "pause-packets-received")) {
#ifdef CONFIG_COMMON_RT_API
		rt_stat_port_get(pon_port_idx, RT_DOT3_IN_PAUSE_FRAMES_INDEX, &value);
#else
		rtk_stat_port_get(pon_port_idx, DOT3_IN_PAUSE_FRAMES_INDEX, &value);
#endif
		return boaWrite(wp, "%llu", value);
	} else if (!strcmp(name, "temperature")) {
		rtk_ponmac_transceiver_get
		    (RTK_TRANSCEIVER_PARA_TYPE_TEMPERATURE, &transceiver);
		_get_data_by_type(RTK_TRANSCEIVER_PARA_TYPE_TEMPERATURE, &transceiver, &readableCfg);

		char* c_str=NULL;
		if(c_str=strstr(readableCfg.buf,"C")){
			printf("c_str=%s\n",c_str);
			printf("readableCfg.buf=%s len=%d\n",readableCfg.buf,strlen(readableCfg.buf));
			(*c_str)='\0';
			printf("readableCfg.buf=%s len=%d\n",readableCfg.buf,strlen(readableCfg.buf));
#if defined(CONFIG_CU_BASEON_CMCC)
			//to correspond to smart app display.
			char xString[1024]={0};
			char *tmp = NULL;
			strcpy(xString, readableCfg.buf);
			tmp = xString;
			while(1)
			{
				if(*tmp == '.') {*(tmp+3) = '\0'; break;}
				tmp++;
				//avoid loop all the time.
				if(tmp-xString>strlen(xString)) break;
			}
			return boaWrite(wp, "%s°C", xString);
#else
		    return boaWrite(wp, "%s°C", readableCfg.buf);
#endif
		}
		return boaWrite(wp, "%s", readableCfg.buf);
	} else if (!strcmp(name, "voltage")) {
		rtk_ponmac_transceiver_get(RTK_TRANSCEIVER_PARA_TYPE_VOLTAGE,
					   &transceiver);
		_get_data_by_type(RTK_TRANSCEIVER_PARA_TYPE_VOLTAGE, &transceiver, &readableCfg);

#if defined(CONFIG_CMCC) || defined(CONFIG_CU_BASEON_CMCC)
		double volt;
		int output = 0;

		rtk_ponmac_transceiver_get(RTK_TRANSCEIVER_PARA_TYPE_VOLTAGE, &transceiver);

		_get_data_by_type(RTK_TRANSCEIVER_PARA_TYPE_VOLTAGE, &transceiver, &readableCfg);
		sscanf(readableCfg.buf, "%lf", &volt);

		output = (volt * 1000.0);
		return boaWrite(wp, "%d mV", output);
#else
		return boaWrite(wp, "%s", readableCfg.buf);
#endif
	} else if (!strcmp(name, "tx-power")) {
		rtk_ponmac_transceiver_get(RTK_TRANSCEIVER_PARA_TYPE_TX_POWER,
					   &transceiver);
		_get_data_by_type(RTK_TRANSCEIVER_PARA_TYPE_TX_POWER, &transceiver, &readableCfg);

#if defined(CONFIG_CU_BASEON_CMCC)
		char xString[1024]={0};
		char *tmp = NULL;
		strcpy(xString, readableCfg.buf);
		tmp = xString;
		while(1)
		{
			if(*tmp == '.') {*(tmp+3) = '\0'; break;}
			tmp++;
			//avoid loop all the time.
			if(tmp-xString>strlen(xString)) break;
		}
		if(strncmp(xString, "-inf", 4) == 0)
			return boaWrite(wp, "无光", xString);
		else
			return boaWrite(wp, "%s  dBm", xString);
#else
		return boaWrite(wp, "%s", readableCfg.buf);
#endif
	} else if (!strcmp(name, "rx-power")) {
		rtk_ponmac_transceiver_get(RTK_TRANSCEIVER_PARA_TYPE_RX_POWER,
					   &transceiver);
		_get_data_by_type(RTK_TRANSCEIVER_PARA_TYPE_RX_POWER, &transceiver, &readableCfg);

#if defined(CONFIG_CU_BASEON_CMCC)
		char xString[1024]={0};
		char *tmp = NULL;
		strcpy(xString, readableCfg.buf);
		tmp = xString;
		while(1)
		{
			if(*tmp == '.') {*(tmp+3) = '\0'; break;}
			tmp++;
			//avoid loop all the time.
			if(tmp-xString>strlen(xString)) break;
		}
		if(strncmp(xString, "-inf", 4) == 0)
			return boaWrite(wp, "无光", xString);
		else
			return boaWrite(wp, "%s  dBm", xString);
#else
		return boaWrite(wp, "%s", readableCfg.buf);
#endif
	} else if (!strcmp(name, "bias-current")) {
		rtk_ponmac_transceiver_get
		    (RTK_TRANSCEIVER_PARA_TYPE_BIAS_CURRENT, &transceiver);
		_get_data_by_type(RTK_TRANSCEIVER_PARA_TYPE_BIAS_CURRENT, &transceiver, &readableCfg);

#if defined(CONFIG_CU_BASEON_CMCC)
		char xString[1024]={0};
		char *tmp = NULL;
		strcpy(xString, readableCfg.buf);
		tmp = xString;
		while(1)
		{
			if(*tmp == '.') {*(tmp+3) = '\0'; break;}
			tmp++;
			//avoid loop all the time.
			if(tmp-xString>strlen(xString)) break;
		}
		return boaWrite(wp, "%s mA", xString);
#else
		return boaWrite(wp, "%s", readableCfg.buf);
#endif
	}

	return -1;
}
