#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <linux/config.h>

#include "fmdefs.h"
#include "mib.h"
#include "utility.h"


int initPageStorage(int eid, request * wp, int argc, char ** argv)
{
	//FTP服务器:
	unsigned char	ftpEnable = 0;
	int				errcode = 1, lineno = __LINE__;
#if defined(CONFIG_USER_FTPD_FTPD) && defined( REMOTE_ACCESS_CTL)
	int cnt;
	MIB_CE_ACC_T accEntry={0};
	int acc_nums=mib_chain_total(MIB_ACC_TBL);
#elif defined(IP_ACL)
	MIB_CE_ACL_IP_T aclEntry={0};
#else
	unsigned char ftp_enable = 0;
#endif

	_TRACE_CALL;

	/************Place your code here, do what you want to do! ************/
	//mib_get_s(MIB_BFTPD_ENABLE, (void *) &ftpEnable, sizeof(ftpEnable));
#if defined(CONFIG_USER_FTPD_FTPD) && defined( REMOTE_ACCESS_CTL)
	for(cnt=0; cnt < acc_nums; cnt++)
	{
		memset(&accEntry, 0, sizeof(accEntry));
		mib_chain_get(MIB_ACC_TBL, cnt, (void*)&accEntry);
		if(accEntry.ftp & 0x2){//lan ftp enabled
			ftpEnable = 1;
			break;
		}
	}
#elif defined(IP_ACL)
	mib_chain_get(MIB_ACL_IP_TBL, 0, (void *)&aclEntry);
	if(aclEntry.ftp == 0)
		ftpEnable = 1;
#else
#ifdef FTP_SERVER_INTERGRATION
	mib_get_s(MIB_FTP_ENABLE, (void *)&ftp_enable, sizeof(ftp_enable));
#else
	mib_get_s(MIB_VSFTP_ENABLE, (void *)&ftp_enable, sizeof(ftp_enable));
#endif
	if (ftp_enable & 1)
		ftpEnable = 1;
#endif
	/************Place your code here, do what you want to do! ************/

	_PUT_BOOL(ftpEnable);

check_err:
	_TRACE_LEAVEL;
	return 0;
}

//网页提交action函数:

#ifdef CONFIG_USB_SUPPORT
int isUsbStoragePlugedIn(char *path)
{
	if(!path)
		return 0;
	
	if (!access(path, F_OK))
	{
		return 1;
	}

	return 0;
}

void formStorage(request * wp, char *path, char *query)
{
	char *strData;
	char tmpBuf[256] = {0};

	//存放目录:
	char *			psaveDir = NULL;
	char				argPath[64];
	//用户名:
	char			user[32];
	char				arguser[64];
	//密码:
	char			passwd[32];
	char				argpasswd[64];
	//端口:
	unsigned short	port = 0;
	char portstr[32]={0};
	//远程URL:
	char *			prmtURL = NULL;
	char*			stemp = "";
	int				errcode = 1, lineno = __LINE__;
	char ftpurl[136];
#if !defined(CONFIG_CMCC)
	char			storage_encode[32];
#endif
	char			devName[64] = {0};
	char			storagePath[128] = {0};

	_TRACE_CALL;

	user[0] = passwd[0] = 0;
	strcpy(argPath, "path=/mnt/");
	strcpy(arguser, "user=");
	strcpy(argpasswd, "passwd=");

	_GET_PSTR(saveDir, _NEED);
	//strcat(argPath, psaveDir);
	strncat(argPath, psaveDir, sizeof(argPath)-strlen(argPath)-1);

	_GET_STR(user, _OPT);
	user[sizeof(user)-1] = '\0';
	if(user[0])
	{
		strcat(arguser, user);
#if defined(CONFIG_CMCC)
		_GET_STR(passwd, _OPT);
		passwd[sizeof(passwd)-1] = '\0';
#else
		_GET_STR(storage_encode, _OPT);
		memset(passwd, 0, sizeof(passwd)); // rtk_util_data_base64decode does not pad NULL for us.
		rtk_util_data_base64decode(storage_encode, passwd, sizeof(passwd));
		passwd[sizeof(passwd)-1] = '\0';
#endif
		if(passwd[0])strcat(argpasswd, passwd);
	}

	_GET_INT(port, _OPT);
	snprintf(portstr,sizeof(portstr),"port=%d",port);
	//if(port == 0){lineno = __LINE__; goto check_err;}

	_GET_PSTR(rmtURL, _NEED);
	if(strContainXSSChar(prmtURL)){
	    strcpy(tmpBuf, "Invalid URL!");
	    goto setErr_storage;
	}
	if( strstr(prmtURL, "ftp://") != prmtURL )
		sprintf(ftpurl, "ftp://%s", prmtURL);
	else
		sprintf(ftpurl, "%s", prmtURL);

	/************Place your code here, do what you want to do! ************/
	//call_cmd("/bin/wget_manage", 4, 0, arguser, argpasswd, argPath, prmtURL);
	errcode = call_cmd("/bin/wget_manage", 5, 1, arguser, argpasswd, argPath, ftpurl, portstr);
	/************Place your code here, do what you want to do! ************/

	sscanf(psaveDir, "%[^/]", devName);
	sprintf(storagePath, "/mnt/%s", devName);
	
	strData = boaGetVar(wp,"submit-url","");   // hidden page
	if(errcode == 0 && isUsbStoragePlugedIn(storagePath))
	{
		strcpy(tmpBuf,"下载成功！");
		OK_MSG1(tmpBuf, strData);
	}
	else
	{
		strcpy(tmpBuf,"下载失败！");
		ERR_MSG_URL(tmpBuf, strData);
	}
check_err:
	_TRACE_LEAVEL;
	return;
setErr_storage:
	ERR_MSG(tmpBuf);
}
#endif
