/*
 *      Web server handler routines for Status
 *      Authors:
 *
 */

/*-- System inlcude files --*/
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <ctype.h>
#include <sys/wait.h>
#include <semaphore.h>
#ifdef EMBED
#include <linux/config.h>
#else
#include "autoconf.h"
#endif

/* for ioctl */

#include "../webs.h"
#include "webform.h"
#include "mib.h"
#include "utility.h"
#include "subr_net.h"
#include "debug.h"
#include <sys/ioctl.h>
#include <linux/if.h>
#include <linux/if_bridge.h>
#include <stdio.h>
#include <fcntl.h>
#include "signal.h"
#include "../defs.h"
#include "../boa.h"
#include "fmdefs.h"
#ifdef CONFIG_GPON_FEATURE	
#include "rtk/ponmac.h"
#include "rtk/gpon.h"
#include "rtk/epon.h"
#include "hal/chipdef/chip.h"
#if defined(CONFIG_COMMON_RT_API)
#include <rtk/rt/rt_gpon.h>
#include <rtk/rt/rt_epon.h>
#endif
#endif
#ifdef CONFIG_COMMON_RT_API
#include <common/error.h>
#include <rtk/rt/rt_switch.h>
#include <rtk/rt/rt_port.h>
#include <rtk/rt/rt_stat.h>
#endif

#include "../ipv6_info.h"

static const char IF_UP[] = "up";
static const char IF_DOWN[] = "down";
#if defined(CONFIG_CMCC) || defined(CONFIG_CU_BASEON_CMCC)
static const char IF_CONNET[] = "connecting";
#endif
static const char IF_NA[] = "n/a";

#define __PME(entry,name)               #name, entry.name
#define __PME_XSS(entry,name)			#name, strValToASP(entry.name)

struct wan_status_info {
	char protocol[10];
	char ipAddr[INET_ADDRSTRLEN];
	char *strStatus;
	char servName[MAX_WAN_NAME_LEN];
	unsigned short vlanId;
	unsigned char igmpEnbl;
	char qosEnbl;
	char servType[20];
	char encaps[8];
	char netmask[INET_ADDRSTRLEN];
	char gateway[INET_ADDRSTRLEN];
	char dns1[INET_ADDRSTRLEN];
	char dns2[INET_ADDRSTRLEN];
	char ipv6Addr[512];	/* With Prefix Length */
	char ipv6Prefix[64];	/* With Prefix Length */
	char ipv6Gateway[INET6_ADDRSTRLEN];
	char ipv6Dns1[INET6_ADDRSTRLEN];
	char ipv6Dns2[INET6_ADDRSTRLEN];
#if defined(CONFIG_CMCC) || defined(CONFIG_CU_BASEON_CMCC)
	unsigned char ipv6PrefixOrigin;
	unsigned char addrMode;
#endif
};
#ifdef CONFIG_MCAST_VLAN
struct iptv_mcast_info {
	unsigned int ifIndex;
	char servName[MAX_WAN_NAME_LEN];
	unsigned short vlanId;
	unsigned char enable;
};

int listWanName(int eid, request * wp, int argc, char **argv)
{
	char ifname[IFNAMSIZ];
	int i, entryNum;
	MIB_CE_ATM_VC_T entry;
	struct iptv_mcast_info mEntry[MAX_VC_NUM + MAX_PPP_NUM] = { 0 };
	int ret = 0;

	entryNum = mib_chain_total(MIB_ATM_VC_TBL);
	for (i = 0; i < entryNum; i++) {
		if (!mib_chain_get(MIB_ATM_VC_TBL, i, &entry)) {
			printf("get MIB chain error\n");
			return -1;
		}
		ifGetName(entry.ifIndex, ifname, sizeof(ifname));
		getWanName(&entry, mEntry[i].servName);
		mEntry[i].vlanId = entry.mVid;
		ret += boaWrite(wp,
			 "links.push(new it_nr(\"%d\"" _PTS _PTI "));\n", i,
			 __PME(mEntry[i], servName), __PME(mEntry[i], vlanId));
	}

	return ret;
}
#endif

#ifdef TERMINAL_INSPECTION_SC
//get IP of tro69-wan, voip-wan, internet-wan for terminal self-inspection. If there have more than one IP of tro69/voip/internet , only select one IP.
int terminalInspectionShow(int eid, request * wp, int argc, char **argv)
{
	char ifname[IFNAMSIZ], *str_ipv4;
	int flags, flags_found,i, entryNum, ipfound=0,wanfound=0,var1,var2;
	MIB_CE_ATM_VC_T entry;
	struct in_addr inAddr;
	unsigned int CPURate, MemRate;
	
	entryNum = mib_chain_total(MIB_ATM_VC_TBL);
	for (i = 0; i < entryNum; i++) {
		if (!mib_chain_get(MIB_ATM_VC_TBL, i, &entry)) {
			continue;
		}

		if((strcmp(argv[0], "VoiceIPAdd")==0) && (entry.applicationtype & X_CT_SRV_VOICE))
		{	
			ifGetName(entry.ifIndex,ifname,sizeof(ifname));
			flags_found = getInFlags(ifname, &flags);
			if (flags_found && getInAddr(ifname, IP_ADDR, &inAddr) == 1)
			{
				str_ipv4 = inet_ntoa(inAddr);
				if (strcmp(str_ipv4, "0.0.0.0"))
				{
					boaWrite(wp, "<td>%s</td>",str_ipv4);
					ipfound = 1;
					break;
				}
			}
		}
		else if((strcmp(argv[0], "tr069IPAdd")==0) && (entry.applicationtype & X_CT_SRV_TR069))
		{
			ifGetName(entry.ifIndex,ifname,sizeof(ifname));
			flags_found = getInFlags(ifname, &flags);
			if (flags_found && getInAddr(ifname, IP_ADDR, &inAddr) == 1)
			{
				str_ipv4 = inet_ntoa(inAddr);
				if (strcmp(str_ipv4, "0.0.0.0"))
				{
					boaWrite(wp, "<td>%s</td>",str_ipv4);
					ipfound = 1;
					break;
				}
			}
		}
		else if((strcmp(argv[0], "InterIPAdd")==0) && (entry.applicationtype & X_CT_SRV_INTERNET))
		{
			ifGetName(entry.ifIndex,ifname,sizeof(ifname));
			flags_found = getInFlags(ifname, &flags);
			if (flags_found && getInAddr(ifname, IP_ADDR, &inAddr) == 1)
			{
				str_ipv4 = inet_ntoa(inAddr);
				if (strcmp(str_ipv4, "0.0.0.0"))
				{
					boaWrite(wp, "<td>%s</td>",str_ipv4);
					ipfound = 1;
					break;
				}
			}
		}	
		else if((strcmp(argv[0], "SCWANState")==0) && (entry.applicationtype & X_CT_SRV_INTERNET))
		{
			if(entry.cmode == CHANNEL_MODE_BRIDGE)
			{
				boaWrite(wp, "<td>%s</td>","桥接模式");
				wanfound = 1;
				break;
			}
			else
			{
				ifGetName(entry.ifIndex,ifname,sizeof(ifname));
				flags_found = getInFlags(ifname, &flags);
				if (flags_found && getInAddr(ifname, IP_ADDR, &inAddr) == 1)
				{
					boaWrite(wp, "<td>%s</td>","路由模式-拨号成功");
					wanfound = 1;
					break;
				}
				else
				{
					boaWrite(wp, "<td>%s</td>","路由模式-拨号失败");
					wanfound = 1;
					break;
				}
			}						
		}
	}
	if(((strcmp(argv[0], "VoiceIPAdd")==0)||(strcmp(argv[0], "tr069IPAdd")==0)||(strcmp(argv[0], "InterIPAdd")==0) )&& !ipfound)
	{
		boaWrite(wp, "<td>%s</td>", "未获取宽带地址");
	}
	if((strcmp(argv[0], "SCWANState")==0) && !wanfound)
	{
		boaWrite(wp, "<td>%s</td>", "未配置");
	}	
	if(strcmp(argv[0], "SCCPURate")==0)
	{
#ifdef  _PRMT_X_CT_COM_PERFORMANCE_REPORT_SUBITEM_CPURateEnable_
		var1 = getCPURate(&CPURate);
		if(var1 < 0)
		{
			boaWrite(wp, "<td>%s</td>", "异常");
		}
		else
		{
			boaWrite(wp, "<td>%s</td>", "正常");
		}
#endif
	}
	if(strcmp(argv[0], "SCMemRate")==0)
	{
#ifdef  _PRMT_X_CT_COM_PERFORMANCE_REPORT_SUBITEM_MemRateEnable_
		var2 = getMemRate(&MemRate);
		if(var2 < 0)
		{
			boaWrite(wp, "<td>%s</td>", "异常");
		}
		else
		{
			boaWrite(wp, "<td>%s</td>", "正常");
		}
#endif
	}
	if(strcmp(argv[0], "LANPorts")==0)
	{
#ifdef TERMINAL_INSPECTION_SC
//		char status[128] = {0};
//		getLANxStateTerminal(status, sizeof(status));
//		boaWrite(wp, "<td>%s</td>", status);
#endif
	}
#ifdef STB_L2_FRAME_LOSS_RATE
			char rate[256] = {};
			char delay[256] = {};
			char term[256] = {};
			char line[256] = {};
			char *tmp;
			int res = 0;
			FILE *fp;
			if(strcmp(argv[0], "stbRate")==0)
			{
				if((access(STB_L2_DIAG_RESULT,F_OK))!=-1)	
				{	
					res = 1;
					//printf("%s %d: file exist!\n", __FUNCTION__, __LINE__);	
				}
				if(res)
				{
					
					if ((fp = fopen(STB_L2_DIAG_RESULT, "r")) == 0) {
						printf("%s can not open %s\n", __func__,STB_L2_DIAG_RESULT);
						return -1;
					}
					while(fgets(line, sizeof(line), fp))
					{
						if(tmp = strstr(line, "rate:"))
						{
							sscanf(tmp, "rate:%s", rate);
						}
					}
					fclose(fp);
					boaWrite(wp, "%s", strlen(rate)?rate:"未检测到机顶盒");
					//printf("rate:%s\n", rate);
				}
				else
				{
					boaWrite(wp, "%s", "未检测到机顶盒");
				}
			}
			if(strcmp(argv[0], "stbDelay")==0)
			{
				if((access(STB_L2_DIAG_RESULT,F_OK))!=-1)	
				{	
					res = 1;
					//printf("%s %d: file exist!\n", __FUNCTION__, __LINE__);	
				}
				if(res)
				{
					
					if ((fp = fopen(STB_L2_DIAG_RESULT, "r")) == 0) {
						printf("%s can not open %s\n", __func__,STB_L2_DIAG_RESULT);
						return -1;
					}
					while(fgets(line, sizeof(line), fp))
					{
						if(tmp = strstr(line, "delay:"))
						{
							sscanf(tmp, "delay:%s", delay);
						}
					}
					fclose(fp);
					boaWrite(wp, "%s", strlen(delay)?delay:"未检测到机顶盒");
					//printf("delay:%s\n", delay);
				}
				else
				{
					boaWrite(wp, "%s", "未检测到机顶盒");
				}
			}
			if(strcmp(argv[0], "stbTerm")==0)
			{
				if((access(STB_L2_DIAG_RESULT,F_OK))!=-1)	
				{	
					res = 1;
					//printf("%s %d: file exist!\n", __FUNCTION__, __LINE__);	
				}
				if(res)
				{
					
					if ((fp = fopen(STB_L2_DIAG_RESULT, "r")) == 0) {
						printf("%s can not open %s\n", __func__,STB_L2_DIAG_RESULT);
						return -1;
					}
					while(fgets(line, sizeof(line), fp))
					{
						if(tmp = strstr(line, "term:"))
						{
							sscanf(tmp, "term:%s", term);
						}
					}
					fclose(fp);
					boaWrite(wp, "%s", strlen(term)?term:"未检测到机顶盒");
					//printf("term:%s\n", term);
				}
				else
				{
					boaWrite(wp, "%s", "未检测到机顶盒");
				}
			}
#endif
	return 0;
}
#endif


int listWanConfig(int eid, request * wp, int argc, char **argv)
{
	char ifname[IFNAMSIZ], *str_ipv4;
	char vprio_str[20];
	char MacAddr[20];
	char cmode_str[20];
	int flags, i, k, entryNum, flags_found, isPPP;
#ifdef EMBED
	int spid;
#endif
	MIB_CE_ATM_VC_T entry;
	struct in_addr inAddr;
	int pon_mode = 0;
	FILE * pFile;
	char tmpFile[32], dhcpState[1024];

	struct wan_status_info sEntry[MAX_VC_NUM + MAX_PPP_NUM] = { 0 };

#if defined(CONFIG_GPON_FEATURE) || defined(CONFIG_EPON_FEATURE)
	mib_get_s(MIB_PON_MODE, &pon_mode, sizeof(pon_mode));
#endif

#ifdef CONFIG_GPON_FEATURE
	int onu;
	onu = getGponONUState();
#endif

		int ret;
#ifdef CONFIG_EPON_FEATURE
		if(pon_mode == EPON_MODE){
			int eonu = 0;
			
			eonu = getEponONUState(0);
			if (eonu == 5)	
				ret = epon_getAuthState(0);
		}
#endif

#ifdef EMBED
	if ((spid = read_pid(PPP_PID)) > 0)
		kill(spid, SIGUSR2);
	else
		fprintf(stderr, "spppd pidfile not exists\n");
#endif

	entryNum = mib_chain_total(MIB_ATM_VC_TBL);
	for (i = 0; i < entryNum; i++) {
		if (!mib_chain_get(MIB_ATM_VC_TBL, i, &entry)) {
			printf("get MIB chain error\n");
			return -1;
		}
#ifdef CONFIG_IPV6
		if ((entry.IpProtocol & IPVER_IPV4) == 0)
			continue;	// not IPv4 capable
#endif
#if defined(CONFIG_TR142_MODULE) && (defined(CONFIG_CMCC) || defined(CONFIG_CU_BASEON_CMCC))
		if (entry.omci_configured==1 && entry.applicationtype&X_CT_SRV_VOICE)
			continue;   
#endif
		ifGetName(entry.ifIndex, ifname, sizeof(ifname));
		flags_found = getInFlags(ifname, &flags);

		switch (entry.cmode) {
		case CHANNEL_MODE_BRIDGE:
			strcpy(sEntry[i].protocol, "br1483");
			isPPP = 0;
			break;
		case CHANNEL_MODE_IPOE:
			#if defined(CONFIG_CMCC) || defined(CONFIG_CU_BASEON_CMCC)
				if(entry.ipDhcp == 0){
					strcpy(sEntry[i].protocol, "Static");
					}
				else{
					strcpy(sEntry[i].protocol, "DHCP");
					}
			#else
				strcpy(sEntry[i].protocol, "IPoE");
				
			#endif			
			isPPP = 0;			
			break;
		case CHANNEL_MODE_PPPOE:	//patch for pppoe proxy
			strcpy(sEntry[i].protocol, "PPPoE");
			isPPP = 1;
			break;
		case CHANNEL_MODE_PPPOA:
			strcpy(sEntry[i].protocol, "PPPoA");
			isPPP = 1;
			break;
		default:
			isPPP = 0;
			break;
		}

		strcpy(sEntry[i].ipAddr, "");
#ifdef EMBED
		if (flags_found && getInAddr(ifname, IP_ADDR, &inAddr) == 1) {
			str_ipv4 = inet_ntoa(inAddr);
			// IP Passthrough or IP unnumbered
			if (flags & IFF_POINTOPOINT && (strcmp(str_ipv4, "10.0.0.1") == 0))
				strcpy(sEntry[i].ipAddr, STR_UNNUMBERED);
			else
				strcpy(sEntry[i].ipAddr, str_ipv4);
		}
#endif

		strcpy(sEntry[i].netmask, "");
		if (flags_found && getInAddr(ifname, SUBNET_MASK, &inAddr) == 1) {
			strcpy(sEntry[i].netmask, inet_ntoa(inAddr));
		}

		k = getInAddr(ifname, IP_ADDR, &inAddr);
		// set status flag
		if (flags_found) {
			if ((flags & IFF_UP)&& (flags&IFF_RUNNING)) {
#if defined(CONFIG_GPON_FEATURE) || defined(CONFIG_EPON_FEATURE)
					if ( getInAddr(ifname, IP_ADDR, &inAddr) == 1
#if defined(CONFIG_CMCC) || defined(CONFIG_CU_BASEON_CMCC)
					&&((pon_mode == GPON_MODE && onu == 5)|| (pon_mode == EPON_MODE && ret==1))
#endif
#ifdef CONFIG_GPON_FEATURE
						|| (pon_mode == GPON_MODE && onu == 5 && strcmp(sEntry[i].protocol, "br1483") == 0)
#endif
#ifdef CONFIG_EPON_FEATURE
					    || (pon_mode == EPON_MODE && ret==1 && strcmp(sEntry[i].protocol, "br1483") == 0)
#endif
#ifdef CONFIG_USER_LAN_PORT_AS_ETH_WAN 
						|| (pon_mode == ETH_MODE && strcmp(sEntry[i].protocol, "br1483") == 0)
						|| (pon_mode == ETH_MODE && getInAddr(ifname, IP_ADDR, &inAddr) == 1)
#endif

						)
#else
					if (strcmp(sEntry[i].protocol, "br1483") == 0
						|| getInAddr(ifname, IP_ADDR, &inAddr) == 1)
#endif
						sEntry[i].strStatus =
						    (char *)IF_UP;
					
#if defined(CONFIG_CMCC) || defined(CONFIG_CU_BASEON_CMCC)
#if defined(CONFIG_GPON_FEATURE) || defined(CONFIG_EPON_FEATURE)
					else if ((pon_mode == GPON_MODE && onu == 5)|| (pon_mode == EPON_MODE && ret==1))
						sEntry[i].strStatus =
							(char *)IF_CONNET;
#endif
#endif
					else
						sEntry[i].strStatus =
						    (char *)IF_DOWN;

			}
#if defined(CONFIG_CMCC) || defined(CONFIG_CU_BASEON_CMCC)
#if defined(CONFIG_GPON_FEATURE) || defined(CONFIG_EPON_FEATURE)
			else if ((pon_mode == GPON_MODE && onu == 5)|| (pon_mode == EPON_MODE && ret==1))
				sEntry[i].strStatus =
					(char *)IF_CONNET;
#endif
#endif
			else
				sEntry[i].strStatus = (char *)IF_DOWN;
		} else
			sEntry[i].strStatus = (char *)IF_NA;

		sEntry[i].gateway[0]='\0';
		sEntry[i].dns1[0]='\0';
		sEntry[i].dns2[0]='\0';
		if(sEntry[i].strStatus == IF_UP)
		{
			if (flags_found)
			{
				if(isPPP)
				{
					if(getInAddr(ifname, DST_IP_ADDR, &inAddr) == 1)
						strcpy(sEntry[i].gateway, inet_ntoa(inAddr));
				}
				else
				{
					if(entry.ipDhcp == (char)DHCP_CLIENT)
					{
						FILE *fp = NULL;
						char fname[128] = {0};

						sprintf(fname, "%s.%s", MER_GWINFO, ifname);

						if(fp = fopen(fname, "r"))
						{
						fscanf(fp, "%15s", sEntry[i].gateway);
						fclose(fp);
					}
					}
					else
					{
						unsigned char zero[IP_ADDR_LEN] = {0};
						if(memcmp(entry.remoteIpAddr, zero, IP_ADDR_LEN))
							strcpy(sEntry[i].gateway, inet_ntoa(*((struct in_addr *)entry.remoteIpAddr)));
					}
				}
			}

			get_dns_by_wan(&entry, sEntry[i].dns1, sEntry[i].dns2);
		}

		if (isPPP && strcmp(sEntry[i].strStatus, (char *)IF_UP)) {
			sEntry[i].ipAddr[0] = '\0';
		}

		getWanName(&entry, sEntry[i].servName);

#if defined(CONFIG_EXT_SWITCH) || defined(CONFIG_RTL_MULTI_ETH_WAN) || (defined(ITF_GROUP_1P) && defined(ITF_GROUP))
		sEntry[i].vlanId = entry.vid;
#endif

#ifdef CONFIG_IGMPPROXY_MULTIWAN
		sEntry[i].igmpEnbl = entry.enableIGMP;
#endif

		if (entry.qos == 0) {
			if (entry.svtype == 0) {
				strcpy(sEntry[i].servType, "UBR Without PCR");
			} else {
				strcpy(sEntry[i].servType, "UBR With PCR");
			}
		} else if (entry.qos == 1) {
			strcpy(sEntry[i].servType, "CBR");
		} else if (entry.qos == 2) {
			strcpy(sEntry[i].servType, "Non Realtime VBR");
		} else if (entry.qos == 3) {
			strcpy(sEntry[i].servType, "Realtime VBR");
		}

		if (entry.encap == 1) {
			strcpy(sEntry[i].encaps, "LLC");
		} else {
			strcpy(sEntry[i].encaps, "VCMUX");
		}

		if (entry.cmode == CHANNEL_MODE_IPOE && entry.ipDhcp == DHCP_CLIENT) {
			if(strlen(sEntry[i].ipAddr) < 2) {
				ifGetName(entry.ifIndex, ifname, sizeof(ifname));
				sprintf(tmpFile, "%s.%s", DEFAULT_STATE_FILE, ifname);
				pFile = fopen (tmpFile,"r");
				if (pFile!=NULL)
				{
					memset(dhcpState,0,sizeof(dhcpState));
					fgets(dhcpState, sizeof(dhcpState), pFile);
					sprintf(sEntry[i].ipAddr, "%s", dhcpState);
					fclose (pFile);
				}
			}
		}
	
		#if defined(CONFIG_CMCC) || defined(CONFIG_CU_BASEON_CMCC)
		if(strcmp(sEntry[i].strStatus, "down") == 0 || entry.enable == 0){
			sEntry[i].strStatus = "未连接";
		}
		else if(strcmp(sEntry[i].strStatus, "up") == 0){
			sEntry[i].strStatus = "已连接";	
		}
		else
			sEntry[i].strStatus = "连接中";	
		
		if(entry.cmode == CHANNEL_MODE_IPOE && entry.ipDhcp == 0){
				snprintf(cmode_str,20,"%s", "手动");	
			}
		else{
			snprintf(cmode_str,20,"%s", "自动");
		}
		
		//transfer format
		if(entry.vprio>0)
		snprintf(vprio_str,20,"%d",(entry.vprio-1));
		else
		snprintf(vprio_str,20,"%d",0);
		
		snprintf(MacAddr, 20, "%02x:%02x:%02x:%02x:%02x:%02x",
				entry.MacAddr[0],entry.MacAddr[1],entry.MacAddr[2],entry.MacAddr[3],entry.MacAddr[4],entry.MacAddr[5]);

#if defined(CONFIG_GPON_FEATURE) || defined(CONFIG_EPON_FEATURE)
		if(pon_mode == GPON_MODE && onu == 1 || isValidIpAddr(sEntry[i].ipAddr)==0)
		{
			strcpy(sEntry[i].gateway, "");
			strcpy(sEntry[i].dns1, "");
			strcpy(sEntry[i].dns2, "");
		}
#endif

		boaWrite(wp,
			 "links.push(new it_nr(\"%d\"" _PTS_XSS _PTS _PTS _PTS
			 _PTS _PTI _PTI _PTI _PTS _PTS _PTS _PTS _PTS _PTS _PTS _PTS "));\n", i,
			 __PME_XSS(sEntry[i], servName), __PME(sEntry[i], encaps),
			 __PME(sEntry[i], servType), __PME(sEntry[i], protocol),
			 __PME(sEntry[i], ipAddr), __PME(sEntry[i], vlanId),
			 __PME(sEntry[i], igmpEnbl), __PME(sEntry[i], qosEnbl),
			 __PME(sEntry[i], strStatus), __PME(sEntry[i], netmask),
			 __PME(sEntry[i], dns1), __PME(sEntry[i], dns2),
			 __PME(sEntry[i], gateway), "vprio",vprio_str, "MacAddr", MacAddr, "cmode",cmode_str
		    );
		#else
			boaWrite(wp,
			 "links.push(new it_nr(\"%d\"" _PTS_XSS _PTS _PTS _PTS
			 _PTS _PTI _PTI _PTI _PTS _PTS _PTS _PTS _PTS "));\n", i,
			 __PME_XSS(sEntry[i], servName), __PME(sEntry[i], encaps),
			 __PME(sEntry[i], servType), __PME(sEntry[i], protocol),
			 __PME(sEntry[i], ipAddr), __PME(sEntry[i], vlanId),
			 __PME(sEntry[i], igmpEnbl), __PME(sEntry[i], qosEnbl),
			 __PME(sEntry[i], strStatus), __PME(sEntry[i], netmask),
			 __PME(sEntry[i], dns1), __PME(sEntry[i], dns2),
			 __PME(sEntry[i], gateway)
		    );
		#endif
	}

	return 0;
}

#ifdef CONFIG_CMCC_ENTERPRISE

int getIpv6Info(struct wan_status_info *psEntry, MIB_CE_ATM_VC_T *pEntry, int isPPP);

int listWanStatus(int eid, request * wp, int argc, char **argv)
{	
	int entryNum = 0;
	int i = 0, flags_found = 0, flags = 0, isPPP = 0;
	int ret = -1;
	MIB_CE_ATM_VC_T entry;
	char *header = "WanStatus.WanList";
	struct wan_status_info sEntry;
	char ifname[IFNAMSIZ], *str_ipv4;
	struct in_addr inAddr;
	int pon_mode = 0;
	char vprio_str[20],MacAddr[20], aftr_str[INET6_ADDRSTRLEN]={0};
	char wanname[MAX_WAN_NAME_LEN];
	unsigned char mld_enabled;
	unsigned int ext_if;
	int idx=0; /*skip omci configured wan index */
	
#ifdef CONFIG_GPON_FEATURE
	int onu;
	onu = getGponONUState();
#endif


#if defined(CONFIG_GPON_FEATURE) || defined(CONFIG_EPON_FEATURE)
	mib_get(MIB_PON_MODE, &pon_mode);
#endif

	entryNum = mib_chain_total(MIB_ATM_VC_TBL);

	memset(&sEntry, 0, sizeof(struct wan_status_info));

	
	mib_get(MIB_MLD_PROXY_DAEMON, (void *)&mld_enabled);
	mib_get(MIB_MLD_PROXY_EXT_ITF, (void *)&ext_if);
	if(!mld_enabled)
		ext_if = DUMMY_IFINDEX;
	
	for (i = 0; i < entryNum; i++) {
		if (!mib_chain_get(MIB_ATM_VC_TBL, i, &entry)) {
			printf("get MIB chain error\n");
			return -1;
		}

#ifdef CONFIG_TR142_MODULE
		if (entry.omci_configured==1 && entry.applicationtype&X_CT_SRV_VOICE)
			continue;  
#endif

		memset(&sEntry, 0, sizeof(struct wan_status_info));

		isPPP = 0; //init isPPP for every interface.

		if((entry.cmode == CHANNEL_MODE_PPPOE) || 
			(entry.cmode == CHANNEL_MODE_PPPOA))
		{
			isPPP = 1;
		}

		ifGetName(entry.ifIndex, ifname, sizeof(ifname));
		flags_found = getInFlags(ifname, &flags);

		strcpy(sEntry.ipAddr, "");
#ifdef EMBED
		if (flags_found && getInAddr(ifname, IP_ADDR, &inAddr) == 1) {
			str_ipv4 = inet_ntoa(inAddr);
			// IP Passthrough or IP unnumbered
			if (flags & IFF_POINTOPOINT && (strcmp(str_ipv4, "10.0.0.1") == 0))
				strcpy(sEntry.ipAddr, STR_UNNUMBERED);
			else
				strcpy(sEntry.ipAddr, str_ipv4);
		}
#endif
		strcpy(sEntry.netmask, "");
		if (flags_found && getInAddr(ifname, SUBNET_MASK, &inAddr) == 1) {
			strcpy(sEntry.netmask, inet_ntoa(inAddr));
		}

		strcpy(sEntry.gateway, "");
		if (flags_found)
		{
			if(isPPP)
			{
				if(getInAddr(ifname, DST_IP_ADDR, &inAddr) == 1)
					strcpy(sEntry.gateway, inet_ntoa(inAddr));
			}
			else
			{
				if(entry.ipDhcp == (char)DHCP_CLIENT)
				{
					FILE *fp = NULL;
					char fname[128] = {0};

					sprintf(fname, "%s.%s", MER_GWINFO, ifname);

					if(fp = fopen(fname, "r"))
					{
					fscanf(fp, "%s", sEntry.gateway);
					fclose(fp);
				}
				}
				else
				{
					unsigned char zero[IP_ADDR_LEN] = {0};
					if(memcmp(entry.remoteIpAddr, zero, IP_ADDR_LEN))
						strcpy(sEntry.gateway, inet_ntoa(*((struct in_addr *)entry.remoteIpAddr)));
				}
			}
		}

		// set status flag
		if (flags_found) {
			if ((flags & IFF_UP)&& (flags&IFF_RUNNING)) {
#if defined(CONFIG_GPON_FEATURE) || defined(CONFIG_EPON_FEATURE)
					if ( getInAddr(ifname, IP_ADDR, &inAddr) == 1
#if defined(CONFIG_CMCC) || defined(CONFIG_CU)
					|| ((pon_mode == GPON_MODE && onu == 5)|| (pon_mode == EPON_MODE && ret==1))
#endif
#ifdef CONFIG_GPON_FEATURE
						|| (pon_mode == GPON_MODE && onu == 5 && strcmp(sEntry.protocol, "br1483") == 0)
#endif
						|| (pon_mode == EPON_MODE && ret==1 && strcmp(sEntry.protocol, "br1483") == 0)
#ifdef CONFIG_USER_LAN_PORT_AS_ETH_WAN 
						|| (pon_mode == ETH_MODE && strcmp(sEntry.protocol, "br1483") == 0)
						|| (pon_mode == ETH_MODE && getInAddr(ifname, IP_ADDR, &inAddr) == 1)
#endif
						)
#else
					if (strcmp(sEntry.protocol, "br1483") == 0
						|| getInAddr(ifname, IP_ADDR, &inAddr) == 1)
#endif
						sEntry.strStatus =
							(char *)IF_UP;
					
#if defined(CONFIG_CMCC) || defined(CONFIG_CU)
#if defined(CONFIG_GPON_FEATURE) || defined(CONFIG_EPON_FEATURE)
					else if ((pon_mode == GPON_MODE && onu == 5)|| (pon_mode == EPON_MODE && ret==1))
						sEntry.strStatus =
							(char *)IF_CONNET;
#endif
#endif
					else
						sEntry.strStatus =
							(char *)IF_DOWN;

			}
#if defined(CONFIG_CMCC) || defined(CONFIG_CU)
#if defined(CONFIG_GPON_FEATURE) || defined(CONFIG_EPON_FEATURE)
			else if ((pon_mode == GPON_MODE && onu == 5)|| (pon_mode == EPON_MODE && ret==1))
				sEntry.strStatus =
					(char *)IF_CONNET;
#endif
#endif
			else
				sEntry.strStatus = (char *)IF_DOWN;
		} 
		else{
			sEntry.strStatus = (char *)IF_NA;
		}

		if(entry.IpProtocol & IPVER_IPV6)
		{
			getIpv6Info(&sEntry, &entry, isPPP);
			if(entry.dslite_enable==1 && entry.dslite_aftr_hostname[0]!=0){
				snprintf(aftr_str,INET6_ADDRSTRLEN,"%s",entry.dslite_aftr_hostname);
			}
			else{
				snprintf(aftr_str,INET6_ADDRSTRLEN,"");
			}
		}
		else{
				snprintf(aftr_str,INET6_ADDRSTRLEN,"");
			}

		strcpy(sEntry.dns1, "");
		strcpy(sEntry.dns2, "");
		get_dns_by_wan(&entry, sEntry.dns1, sEntry.dns2);
		
		getWanName(&entry, wanname);

		boaWrite(wp,"%s[%d]				= {};\n"\
					"%s[%d].index		= %d;\n"\
					"%s[%d].valid		= %d;\n"\
					"%s[%d].enable		= %d;\n"\
					"%s[%d].cmode		= %d;\n"\
					"%s[%d].bridge		= %d;\n"\
					"%s[%d].service		= %d;\n"\
					"%s[%d].vlan_enable	= %d;\n"\
					"%s[%d].vlan_pbit	= %d;\n"\
					"%s[%d].vlan_vid	= %d;\n"\
					"%s[%d].ip_mode		= %d;\n"\
					"%s[%d].ip_ver		= %d;\n"\
					"%s[%d].mac			= \"%02x:%02x:%02x:%02x:%02x:%02x;\"\n"\
					"%s[%d].ip_state	= \"%s\";\n"\
					"%s[%d].ipv4_ip		= \"%s\";\n"\
					"%s[%d].ipv4_mask	= \"%s\";\n"\
					"%s[%d].ipv4_gw	= \"%s\";\n"\
					"%s[%d].ipv4_dns1	= \"%s\";\n"\
					"%s[%d].ipv4_dns2	= \"%s\";\n"\
					"%s[%d].intf_name   = \"%s\";\n"\
					"%s[%d].mvid   		= %d;\n"\
					"%s[%d].itfGroup	= %d;\n"\
					"%s[%d].nat   		= %d;\n"\
					"%s[%d].ipv6_addr   = \"%s\";\n"\
					"%s[%d].ipv6_prefix = \"%s\";\n"\
					"%s[%d].ipv6_dhcp_mode = %d;\n"\
					"%s[%d].ipv6_gw 	= \"%s\";\n"\
					"%s[%d].ipv6_dns1 	= \"%s\";\n"\
					"%s[%d].ipv6_dns2 	= \"%s\";\n"\
					"%s[%d].ipv6_dhcp 	= \"%d\";\n"\
					"%s[%d].ipv6_addrmode 	= \"%d\";\n"\
					"%s[%d].dslite_AFTR = \"%s\";\n"\
					"%s[%d].name = \"%s\";\n"\
					"%s[%d].ipv4_state	= %d;\n"\
					"%s[%d].ipv6_state	= %d;\n"\
					"%s[%d].mld	= %d;\n",\
					

					header,idx,
					header,idx,idx,
					
					header,idx,entry.enable,
					header,idx,entry.enable,
					header,idx,(entry.cmode),   //0:bridge. 1:IPoE, 2: PPPoE
					header,idx,(entry.cmode?0:1), 
					header,idx,entry.applicationtype,
					header,idx,entry.vlan,
					header,idx,((entry.vprio-1)>0)?(entry.vprio-1):0,
					header,idx,entry.vid,
					header,idx,entry.ipDhcp,   //when cmode is 1, ipdhcp 0: static, 1: dhcp.
					header,idx,entry.IpProtocol,
					header,idx,entry.MacAddr[0],entry.MacAddr[1],entry.MacAddr[2],
							 entry.MacAddr[3],entry.MacAddr[4],entry.MacAddr[5],
					header,idx, sEntry.strStatus,
					header,idx,sEntry.ipAddr,
					header,idx,sEntry.netmask,
					header,idx,sEntry.gateway,
					header,idx,sEntry.dns1,
					header,idx,sEntry.dns2,
					header,idx,ifname,
					header,idx,entry.mVid,
					header,idx,entry.itfGroup,
					header,idx,entry.napt,

					header,idx,sEntry.ipv6Addr,
					header,idx,sEntry.ipv6Prefix,
					header,idx,sEntry.ipv6PrefixOrigin,
					header,idx,sEntry.ipv6Gateway,
					header,idx,sEntry.ipv6Dns1,
					header,idx,sEntry.ipv6Dns2,
					header,idx,entry.Ipv6Dhcp,
					header,idx,entry.AddrMode,
					header,idx,aftr_str,
					header,idx, wanname,
					header,idx, (entry.IpProtocol & IPVER_IPV4)?1:0,
					header,idx, (entry.IpProtocol & IPVER_IPV6)?1:0,
					header,idx, (entry.ifIndex == ext_if)?1:0
				);
		idx++;
	}
	return 0;
}

int show_wan_staticis(int eid, request * wp, int argc, char ** argv)
{
	unsigned int nBytesSent=0;
	int entryNum = 0, i=0;
	char ifname[IFNAMSIZ]={0};
	MIB_CE_ATM_VC_T entry;
	char wanname[MAX_WAN_NAME_LEN]={0};
	unsigned int rx_packets=0, tx_packets=0;
	unsigned long long int rx_bytes =0, tx_bytes =0;
	entryNum = mib_chain_total(MIB_ATM_VC_TBL);

	for (i = 0; i < entryNum; i++) {
			if (!mib_chain_get(MIB_ATM_VC_TBL, i, &entry)) {
				printf("get MIB chain error\n");
				return -1;
			}
#ifdef CONFIG_TR142_MODULE
			if (entry.omci_configured==1 && entry.applicationtype&X_CT_SRV_VOICE)
				continue;
#endif
			ifGetName(entry.ifIndex, ifname, sizeof(ifname));
			getWanName(&entry, wanname);
			if (rtk_get_interface_packet_statistics(ifname, &rx_packets, &tx_packets, &rx_bytes, &tx_bytes) != 1)
				rx_packets = tx_packets =rx_bytes = tx_bytes = 0;
			nBytesSent += boaWrite(wp, "<tr>");
			nBytesSent += boaWrite(wp, "<td> %s </td>", wanname);
			nBytesSent += boaWrite(wp, "<td> %d </td>", entry.vid);
			nBytesSent += boaWrite(wp, "<td> %u </td>", rx_packets);
			nBytesSent += boaWrite(wp, "<td> %lu </td>", rx_bytes);
			nBytesSent += boaWrite(wp, "<td> %u </td>", tx_packets);
			nBytesSent += boaWrite(wp, "<td> %lu </td>", tx_bytes);
			nBytesSent += boaWrite(wp, "</tr>");
		}
	return nBytesSent;
}
#endif


#ifdef CONFIG_IPV6
#ifdef CONFIG_CMCC_ENTERPRISE
int getIpv6Info(struct wan_status_info *psEntry, MIB_CE_ATM_VC_T *pEntry, int isPPP)
{
	char ifname[IFNAMSIZ], str_ipv6[INET6_ADDRSTRLEN];
	char vprio_str[20],MacAddr[20];
	int flags,flags_found, j, k;
#ifdef EMBED
	int spid;
#endif
	struct ipv6_ifaddr ipv6_addr[6];
	struct in_addr inAddr;
#ifdef CONFIG_DEV_xDSL
	Modem_LinkSpeed vLs;
	int adslflag;
	MEDIA_TYPE_T mType;
#endif
	int pon_mode = 0;

#if defined(CONFIG_GPON_FEATURE) || defined(CONFIG_EPON_FEATURE)
	mib_get(MIB_PON_MODE, &pon_mode);
#endif

#ifdef CONFIG_GPON_FEATURE
	int onu;
	onu = getGponONUState();
#endif

#ifdef CONFIG_DEV_xDSL
	// check for xDSL link
	if (!adsl_drv_get
	    (RLCM_GET_LINK_SPEED, (void *)&vLs, RLCM_GET_LINK_SPEED_SIZE)
	    || vLs.upstreamRate == 0)
		adslflag = 0;
	else
		adslflag = 1;
#endif

	{
#if defined(CONFIG_CMCC) || defined(CONFIG_CU)
	
			//debug
			psEntry->addrMode = pEntry->AddrMode;
			printf("entry.Ipv6Dhcp=%d\n",pEntry->Ipv6Dhcp);
			printf("entry.AddrMode=%d\n",pEntry->AddrMode);
			#endif

		ifGetName(pEntry->ifIndex, ifname, sizeof(ifname));


		k = getifip6(ifname, IPV6_ADDR_UNICAST, ipv6_addr, 6);
		psEntry->ipv6Addr[0] = 0;
		if (k) {
			int len = 0;
			for (j = 0; j < k; j++) {
				inet_ntop(AF_INET6, &ipv6_addr[j].addr, str_ipv6,
					  INET6_ADDRSTRLEN);
				if (j == 0)
					len = sprintf(psEntry->ipv6Addr, "%s/%d",
						str_ipv6,
						ipv6_addr[j].prefix_len);
				else
					len += sprintf(psEntry->ipv6Addr+len, ", %s/%d",
						str_ipv6,
						ipv6_addr[j].prefix_len);
			}
		}

		if(k)
		{
			psEntry->strStatus = (char *)IF_UP;
		}
		psEntry->ipv6Prefix[0] = 0;
		if(pEntry->cmode != CHANNEL_MODE_BRIDGE && pEntry->IpProtocol & IPVER_IPV6)
		{
			const char *dst = NULL;
			if(pEntry->AddrMode & IPV6_WAN_STATIC)
			{
				char buf[256] = {};
				dst = inet_ntop(AF_INET6, pEntry->Ipv6Prefix, buf, sizeof(buf));
				if(dst)
				{
#ifdef CONFIG_USER_MULTI_DHCPD6_INTERFACE
					sprintf(psEntry->ipv6Prefix, "%s/%d", dst, pEntry->Ipv6PrefixLen);
#else
					sprintf(psEntry->ipv6Prefix, "%s/%d", dst, pEntry->Ipv6AddrPrefixLen);
#endif
				}
			}
			else
			{
				DLG_INFO_T dlg_info;
				char fname[256] = {0};
				int ret;
				const char *dst;

				memset(&dlg_info, 0, sizeof(dlg_info));
				snprintf(fname, 256, "%s.%s", PATH_DHCLIENT6_LEASE, ifname);
				ret = getLeasesInfo(fname, &dlg_info);
				dst = inet_ntop(AF_INET6, dlg_info.prefixIP, psEntry->ipv6Prefix, sizeof(psEntry->ipv6Prefix));

				if(ret && dst)
					sprintf(psEntry->ipv6Prefix, "%s/%d", dst, dlg_info.prefixLen);
			}
			
			#if defined(CONFIG_CMCC) || defined(CONFIG_CU)
			if(strcmp(psEntry->ipv6Prefix, "::") == 0)
				strcpy(psEntry->ipv6Prefix, "-");
			#endif

			unsigned char zero[IP6_ADDR_LEN] = {0};
			psEntry->ipv6Gateway[0] = 0;
			if(memcmp(pEntry->RemoteIpv6Addr, zero, IP6_ADDR_LEN))
				inet_ntop(AF_INET6, &(pEntry->RemoteIpv6Addr), psEntry->ipv6Gateway, INET6_ADDRSTRLEN);

			get_dns6_by_wan(pEntry, psEntry->ipv6Dns1, psEntry->ipv6Dns2);
		}

		if (isPPP && strcmp(psEntry->strStatus, (char *)IF_UP)) {
			psEntry->ipv6Addr[0] = '\0';
		}
		getWanName(pEntry, psEntry->servName);

#ifdef CONFIG_IGMPPROXY_MULTIWAN
		psEntry->igmpEnbl = pEntry->enableIGMP;
#endif

#if defined(CONFIG_CMCC) || defined(CONFIG_CU)
		psEntry->ipv6PrefixOrigin = pEntry->IPv6PrefixOrigin;
		psEntry->addrMode = pEntry->AddrMode;
#endif

#if defined(IP_QOS) || defined(NEW_IP_QOS_SUPPORT)
		psEntry->qosEnbl = pEntry->enableIpQos;
#endif


		//found in mit
#ifdef BR_ROUTE_ONEPVC
		if (pEntry->cmode == CHANNEL_MODE_BRIDGE && pEntry->br_route_flag == 1) {
			strcpy(psEntry->protocol, "br1483");
			psEntry->igmpEnbl = 0;
			strcpy(psEntry->ipv6Addr, "");
		}
#endif
	}

	return 0;
}
#endif	// CONFIG_CMCC_ENTERPRISE

int listWanConfigIpv6(int eid, request * wp, int argc, char ** argv)
{
	char ifname[IFNAMSIZ], str_ipv6[INET6_ADDRSTRLEN];
	char vprio_str[20],MacAddr[20], aftr_str[INET6_ADDRSTRLEN];
	int flags, i, j, k, entryNum, flags_found, isPPP;
#ifdef EMBED
	int spid;
#endif
	struct ipv6_ifaddr ipv6_addr[6];
	MIB_CE_ATM_VC_T entry;
	struct in_addr inAddr;
	int pon_mode = 0;
	char ipv6Addr[64]={0};

	struct wan_status_info sEntry[MAX_VC_NUM + MAX_PPP_NUM] = { 0 };

#if defined(CONFIG_GPON_FEATURE) || defined(CONFIG_EPON_FEATURE)
	mib_get_s(MIB_PON_MODE, &pon_mode, sizeof(pon_mode));
#endif

#ifdef CONFIG_GPON_FEATURE
	int onu;
	onu = getGponONUState();
#endif

			int ret;
#ifdef CONFIG_EPON_FEATURE
			if(pon_mode == EPON_MODE){
				int eonu = 0;
				
				eonu = getEponONUState(0);
				if (eonu == 5)	
					ret = epon_getAuthState(0);
			}
#endif

#ifdef EMBED
	if ((spid = read_pid(PPP_PID)) > 0)
		kill(spid, SIGUSR2);
	else
		fprintf(stderr, "spppd pidfile not exists\n");
#endif


	entryNum = mib_chain_total(MIB_ATM_VC_TBL);

	for (i = 0; i < entryNum; i++) {
		if (!mib_chain_get(MIB_ATM_VC_TBL, i, (void *)&entry)) {
			printf("get MIB chain error\n");
			return -1;
		}

		if ((entry.IpProtocol & IPVER_IPV6) == 0)
			continue;	// not IPv6 capable

#if defined(CONFIG_TR142_MODULE) && (defined(CONFIG_CMCC) || defined(CONFIG_CU_BASEON_CMCC))
		if (entry.omci_configured==1 && entry.applicationtype&X_CT_SRV_VOICE)
			continue;  

			//debug
			sEntry[i].addrMode = entry.AddrMode;
			printf("entry.Ipv6Dhcp=%d",entry.Ipv6Dhcp);
			printf("entry.AddrMode=%d",entry.AddrMode);
#endif

		ifGetName(entry.ifIndex, ifname, sizeof(ifname));

		switch (entry.cmode) {
		case CHANNEL_MODE_BRIDGE:
			strcpy(sEntry[i].protocol, "br1483");
			isPPP = 0;
			break;
		case CHANNEL_MODE_IPOE:
		#if defined(CONFIG_CMCC) || defined(CONFIG_CU_BASEON_CMCC)
			if((entry.Ipv6Dhcp == 0) &&(entry.AddrMode ==IPV6_WAN_STATIC))
				strcpy(sEntry[i].protocol, "Static");
			else
				strcpy(sEntry[i].protocol, "DHCP");
		#else
			strcpy(sEntry[i].protocol, "IPoE");
		#endif
			isPPP = 0;
			break;
		case CHANNEL_MODE_PPPOE:	//patch for pppoe proxy
			strcpy(sEntry[i].protocol, "PPPoE");
			isPPP = 1;
			break;
		case CHANNEL_MODE_PPPOA:
			strcpy(sEntry[i].protocol, "PPPoA");
			isPPP = 1;
			break;
		default:
			isPPP = 0;
			break;
		}

		k = getifip6(ifname, IPV6_ADDR_UNICAST, ipv6_addr, 6);
		sEntry[i].ipv6Addr[0] = 0;
		if (k) {
			for (j = 0; j < k; j++) {
				inet_ntop(AF_INET6, &ipv6_addr[j].addr, str_ipv6,
					  INET6_ADDRSTRLEN);
				if (j == 0)
					sprintf(sEntry[i].ipv6Addr, "%s/%d",
						str_ipv6,
						ipv6_addr[j].prefix_len);
				else
					sprintf(sEntry[i].ipv6Addr, "%s, %s/%d",
						ipv6Addr, str_ipv6,
						ipv6_addr[j].prefix_len);
				strncpy(ipv6Addr,sEntry[i].ipv6Addr,sizeof(ipv6Addr));				
			}
		}

		sEntry[i].ipv6Prefix[0] = 0;
		if(entry.cmode != CHANNEL_MODE_BRIDGE && entry.IpProtocol & IPVER_IPV6)
		{
#if defined(CONFIG_YUEME) || defined(CONFIG_CU_BASEON_YUEME)
			if((entry.AddrMode & IPV6_WAN_STATIC) && !(entry.Ipv6DhcpRequest & M_DHCPv6_REQ_IAPD))
#else
			if(entry.AddrMode & IPV6_WAN_STATIC)
#endif
			{
				struct in6_addr prefix = {0};
				char *dst;

#if defined(CONFIG_CMCC) || defined(CONFIG_CU) || defined(CONFIG_YUEME)
				ip6toPrefix(entry.Ipv6Prefix, entry.Ipv6AddrPrefixLen, &prefix);
#else
				ip6toPrefix(entry.Ipv6Addr, entry.Ipv6AddrPrefixLen, &prefix);
#endif
				dst = (char *)inet_ntop(AF_INET6, &prefix, sEntry[i].ipv6Prefix, sizeof(sEntry[i].ipv6Prefix));

				if (dst && strcmp(dst, "::"))
#ifdef CONFIG_USER_RTK_IPV6_MULTI_LAN_SERVICE_WITH_SINGLE_BR
					sprintf(sEntry[i].ipv6Prefix, "%s/%d", dst, entry.Ipv6PrefixLen);
#else
					sprintf(sEntry[i].ipv6Prefix, "%s/%d", dst, entry.Ipv6AddrPrefixLen);
#endif
			}
			else
			{
				DLG_INFO_T dlg_info;
				char fname[256] = {0};
				int ret;
				char *dst;

				memset(&dlg_info, 0, sizeof(dlg_info));
				snprintf(fname, 256, "%s.%s", PATH_DHCLIENT6_LEASE, ifname);
				ret = getLeasesInfo(fname, &dlg_info);
				dst = (char *)inet_ntop(AF_INET6, dlg_info.prefixIP, sEntry[i].ipv6Prefix, sizeof(sEntry[i].ipv6Prefix));

				if(ret && dst)
					sprintf(sEntry[i].ipv6Prefix, "%s/%d", dst, dlg_info.prefixLen);
			}

			#if defined(CONFIG_CMCC) || defined(CONFIG_CU_BASEON_CMCC)
			if(strcmp(sEntry[i].ipv6Prefix, "::") == 0)
				strcpy(sEntry[i].ipv6Prefix, "-");
			#endif

			unsigned char zero[IP6_ADDR_LEN] = {0};
			sEntry[i].ipv6Gateway[0] = 0;
			if(memcmp(entry.RemoteIpv6Addr, zero, IP6_ADDR_LEN))
				inet_ntop(AF_INET6, &entry.RemoteIpv6Addr, sEntry[i].ipv6Gateway, INET6_ADDRSTRLEN);

			get_dns6_by_wan(&entry, sEntry[i].ipv6Dns1, sEntry[i].ipv6Dns2);
		}

		// set status flag
		if (getInFlags(ifname, &flags) == 1) {
			if ((flags & IFF_UP) && (flags&IFF_RUNNING)) {
#if defined(CONFIG_GPON_FEATURE) || defined(CONFIG_EPON_FEATURE)
					if ( k!=0
#if defined(CONFIG_CMCC) || defined(CONFIG_CU_BASEON_CMCC)
					&&((pon_mode == GPON_MODE && onu == 5)|| (pon_mode == EPON_MODE && ret==1)) 			
#endif
#ifdef CONFIG_GPON_FEATURE
						|| (pon_mode == GPON_MODE && onu == 5 && strcmp(sEntry[i].protocol, "br1483") == 0)
#endif
#ifdef CONFIG_EPON_FEATURE
					    || (pon_mode == EPON_MODE && ret==1 && strcmp(sEntry[i].protocol, "br1483") == 0)
#endif
#ifdef CONFIG_USER_LAN_PORT_AS_ETH_WAN 
						|| (pon_mode == ETH_MODE && strcmp(sEntry[i].protocol, "br1483") == 0)
						|| (pon_mode == ETH_MODE && k!=0)
#endif

						)
#else
					if (strcmp(sEntry[i].protocol, "br1483") == 0
						|| k!=0)
#endif
						sEntry[i].strStatus =
						    (char *)IF_UP;
#if defined(CONFIG_CMCC) || defined(CONFIG_CU_BASEON_CMCC)
#if defined(CONFIG_GPON_FEATURE) || defined(CONFIG_EPON_FEATURE)
					else if ((pon_mode == GPON_MODE && onu == 5)|| (pon_mode == EPON_MODE && ret==1))			
						sEntry[i].strStatus =
							(char *)IF_CONNET;
#endif
#endif
					else
#ifdef CONFIG_CU_BASEON_YUEME
						// for C-cu always true to display other info, ignore the global address
						sEntry[i].strStatus =
						    (char *)IF_UP; 
#else
						sEntry[i].strStatus =
						    (char *)IF_DOWN;
#endif
			}
#if defined(CONFIG_CMCC) || defined(CONFIG_CU_BASEON_CMCC)
#if defined(CONFIG_GPON_FEATURE) || defined(CONFIG_EPON_FEATURE)
			else if ((pon_mode == GPON_MODE && onu == 5)|| (pon_mode == EPON_MODE && ret==1))			
				sEntry[i].strStatus =
					(char *)IF_CONNET;
#endif
#endif
			else
				sEntry[i].strStatus = (char *)IF_DOWN;
		} else
			sEntry[i].strStatus = (char *)IF_NA;
		
		sEntry[i].ipv6Gateway[0]='\0';
		sEntry[i].ipv6Dns1[0]='\0';
		sEntry[i].ipv6Dns2[0]='\0';
		if(sEntry[i].strStatus == IF_UP)
		{
			get_dns6_by_wan(&entry, sEntry[i].ipv6Dns1, sEntry[i].ipv6Dns2);
			
			unsigned char zero[IP6_ADDR_LEN] = {0};
			if(memcmp(entry.RemoteIpv6Addr, zero, IP6_ADDR_LEN))
				inet_ntop(AF_INET6, &entry.RemoteIpv6Addr, sEntry[i].ipv6Gateway, INET6_ADDRSTRLEN);
		}
		
		if (isPPP && strcmp(sEntry[i].strStatus, (char *)IF_UP)) {
			sEntry[i].ipv6Addr[0] = '\0';
		}
		getWanName(&entry, sEntry[i].servName);

#if defined(CONFIG_EXT_SWITCH) || defined(CONFIG_RTL_MULTI_ETH_WAN) || (defined(ITF_GROUP_1P) && defined(ITF_GROUP))
		sEntry[i].vlanId = entry.vid;
#endif

#ifdef CONFIG_IGMPPROXY_MULTIWAN
		sEntry[i].igmpEnbl = entry.enableIGMP;
#endif

#if defined(CONFIG_CMCC) || defined(CONFIG_CU_BASEON_CMCC)
		sEntry[i].ipv6PrefixOrigin = entry.IPv6PrefixOrigin;
		sEntry[i].addrMode = entry.AddrMode;
#endif

		if (entry.qos == 0) {
			if (entry.svtype == 0) {
				strcpy(sEntry[i].servType, "UBR Without PCR");
			} else {
				strcpy(sEntry[i].servType, "UBR With PCR");
			}
		} else if (entry.qos == 1) {
			strcpy(sEntry[i].servType, "CBR");
		} else if (entry.qos == 2) {
			strcpy(sEntry[i].servType, "Non Realtime VBR");
		} else if (entry.qos == 3) {
			strcpy(sEntry[i].servType, "Realtime VBR");
		}

		if (entry.encap == 1) {
			strcpy(sEntry[i].encaps, "LLC");
		} else {
			strcpy(sEntry[i].encaps, "VCMUX");
		}

#if defined(CONFIG_CMCC) || defined(CONFIG_CU_BASEON_CMCC)
		if(entry.vprio>0)
		snprintf(vprio_str,20,"%d",(entry.vprio-1));
		else
		snprintf(vprio_str,20,"%d",0);
#endif

		if(entry.dslite_enable==1 && entry.dslite_aftr_hostname[0]!=0){
			snprintf(aftr_str,INET6_ADDRSTRLEN,"%s",entry.dslite_aftr_hostname);
		}
		else{
			snprintf(aftr_str,INET6_ADDRSTRLEN,"");
		}
		
		snprintf(MacAddr,20,"%02x:%02x:%02x:%02x:%02x:%02x",entry.MacAddr[0],entry.MacAddr[1],entry.MacAddr[2],entry.MacAddr[3],entry.MacAddr[4],entry.MacAddr[5]);
/* Avoid when wan down, still show last pd information, because now /var/config/dhcpcV6.lease.xxx
 * will exist forever. */
#if defined(CONFIG_CMCC) || defined(CONFIG_CU_BASEON_CMCC)
		if(strcmp(sEntry[i].strStatus, "down") == 0 || (entry.enable == 0))
			snprintf(sEntry[i].ipv6Prefix, sizeof(sEntry[i].ipv6Prefix), "-");
#else
		if(strcmp(sEntry[i].strStatus, "down") == 0)
			snprintf(sEntry[i].ipv6Prefix, sizeof(sEntry[i].ipv6Prefix), "::");
#endif
#if defined(CONFIG_CMCC) || defined(CONFIG_CU_BASEON_CMCC)
		if(strcmp(sEntry[i].strStatus, "down") == 0 || (entry.enable == 0)){
			sEntry[i].strStatus = "未连接";
			}
		else if(strcmp(sEntry[i].strStatus, "up")==0){
			sEntry[i].strStatus = "已连接";	
			}
		else
			sEntry[i].strStatus = "连接中";	
			
		boaWrite(wp,
			  "links.push(new it_nr(\"%d\"" _PTS_XSS _PTS _PTS _PTS
			    _PTS _PTI _PTI _PTI _PTS _PTS _PTS _PTS _PTS _PTI _PTI _PTS _PTS _PTS_XSS"));\n", i,
			  __PME_XSS(sEntry[i], servName), __PME(sEntry[i], encaps),
			  __PME(sEntry[i], servType), __PME(sEntry[i], protocol),
			  __PME(sEntry[i], ipv6Addr), __PME(sEntry[i], vlanId),
			  __PME(sEntry[i], igmpEnbl), __PME(sEntry[i], qosEnbl),
			  __PME(sEntry[i], strStatus), __PME(sEntry[i], ipv6Prefix),
			  __PME(sEntry[i], ipv6Gateway), __PME(sEntry[i], ipv6Dns1),
			  __PME(sEntry[i], ipv6Dns2), __PME(sEntry[i], addrMode),
			  __PME(sEntry[i], ipv6PrefixOrigin),"vprio",vprio_str,"MacAddr",MacAddr,
			  "aftr", strValToASP(aftr_str)
		    );
#else
		boaWrite(wp,
			  "links.push(new it_nr(\"%d\"" _PTS_XSS _PTS _PTS _PTS
			    _PTS _PTI _PTI _PTI _PTS _PTS _PTS _PTS _PTS "));\n", i,
			  __PME_XSS(sEntry[i], servName), __PME(sEntry[i], encaps),
			  __PME(sEntry[i], servType), __PME(sEntry[i], protocol),
			  __PME(sEntry[i], ipv6Addr), __PME(sEntry[i], vlanId),
			  __PME(sEntry[i], igmpEnbl), __PME(sEntry[i], qosEnbl),
			  __PME(sEntry[i], strStatus), __PME(sEntry[i], ipv6Prefix),
			  __PME(sEntry[i], ipv6Gateway), __PME(sEntry[i], ipv6Dns1),
			  __PME(sEntry[i], ipv6Dns2)
		    );
#endif
	}

	return 0;
}
#endif

#ifdef SUPPORT_WAN_BANDWIDTH_INFO
int listWanBandwidth(int eid, request * wp, int argc, char **argv)
{
	char ifname[IFNAMSIZ];
	int i, entryNum;
	MIB_CE_ATM_VC_T entry;
	char servName[MAX_WAN_NAME_LEN];
	int uploadRate, downloadRate;
	unsigned int chipId;
	unsigned int rev;
	unsigned int subType;

	#ifdef CONFIG_COMMON_RT_API
	rt_switch_version_get(&chipId, &rev, &subType);
	#else
	rtk_switch_version_get(&chipId, &rev, &subType);
	#endif

	entryNum = mib_chain_total(MIB_ATM_VC_TBL);

	for (i = 0; i < entryNum; i++) {
		if (!mib_chain_get(MIB_ATM_VC_TBL, i, &entry)) {
			printf("get MIB chain error\n");
			return -1;
		}

		if((chipId != RTL9602C_CHIP_ID) && (entry.applicationtype != X_CT_SRV_INTERNET))
			continue;

		ifGetName(entry.ifIndex, ifname, sizeof(ifname));

		getWanName(&entry, servName);
		
		if(wan_bandwidth_get(entry.ifIndex, &uploadRate, &downloadRate) < 0)
		{
			uploadRate = -1;
			downloadRate = -1;
		}

		boaWrite(wp,
			 "links.push(new it_nr('%d',new it('servName', '%s'), new it('upload', '%d'), new it('download', '%d')));\n",
			 i,servName, uploadRate, downloadRate);
	}
}
#endif

/*****************************
** ethers stats list
*/
#if defined(CONFIG_CMCC) || defined(CONFIG_CU_BASEON_CMCC)
int show_LAN_status_cmcc(int eid, request * wp, int argc, char **argv)
{	
	int i = 0 , nBytesSent = 0;
#ifdef CONFIG_COMMON_RT_API
	rt_port_t port[ELANVIF_NUM];
	rt_port_linkStatus_t link_status[ELANVIF_NUM];
	rt_port_speed_t link_speed[ELANVIF_NUM];
	rt_port_duplex_t duplex[ELANVIF_NUM];

	memset(link_status, 0, sizeof(link_status));
	memset(link_speed, 0, sizeof(link_speed));
	memset(duplex, 0, sizeof(duplex));

	for (i = 0; i < ELANVIF_NUM; i++)
	{
		port[i] = rtk_port_get_lan_phyID(i);
		if(port[i] == -1) // get fail
		{
			printf("%s get port %d phy id failed!\n", __FUNCTION__, i);
			continue;
		}

		if(rt_port_link_get(port[i], &link_status[i]) != RT_ERR_OK)
		{
			printf("%s get port %d status failed!\n", __FUNCTION__, i);
			continue;
		}

		if(rt_port_speedDuplex_get(port[i], &link_speed[i], &duplex[i]) != RT_ERR_OK)
		{
			printf("%s get port %d speed/duplex failed!\n", __FUNCTION__, i);
			continue;
		}
	}
	nBytesSent += boaWrite(wp, "<table class=\"flat\" border=\"1\" cellpadding=\"1\" cellspacing=\"1\" width=\"100%%\">");
	nBytesSent += boaWrite(wp, "<tr class=\"hdb\" align=\"center\" nowrap> <td></td>");
	for(i = 0 ; i < ELANVIF_NUM ; i++)
	{
		nBytesSent += boaWrite(wp, "<td>LAN-%d</td>", (i+1));
	}
	nBytesSent += boaWrite(wp, "</tr>");
	
	nBytesSent += boaWrite(wp, "<tr align=\"center\">");
	nBytesSent += boaWrite(wp, "<td>连接状态</td>");
	for(i = 0 ; i < ELANVIF_NUM ; i++)
	{
		nBytesSent += boaWrite(wp, "<td>%s</td>",(link_status[i] == RT_PORT_LINKUP)?"连接上":"未连接");
	}
	nBytesSent += boaWrite(wp, "</tr>");
	
	nBytesSent += boaWrite(wp, "<tr align=\"center\">");
	nBytesSent += boaWrite(wp, "<td>工作模式</td>");
	for(i = 0 ; i < ELANVIF_NUM ; i++)
	{
		nBytesSent += boaWrite(wp, "<td>%s</td>",(duplex[i] == RT_PORT_HALF_DUPLEX)?"半双工":"全双工");
	}
	nBytesSent += boaWrite(wp, "</tr>");
	
	nBytesSent += boaWrite(wp, "<tr align=\"center\">");
	nBytesSent += boaWrite(wp, "<td>速率</td>");
	for(i = 0 ; i < ELANVIF_NUM ; i++)
	{
		int speed = 0;
		switch(link_speed[i])
		{
			case RT_PORT_SPEED_1000M:
				speed = 1000;
				break;
			case RT_PORT_SPEED_100M:
				speed = 100;
				break;
			case RT_PORT_SPEED_10M:
				speed = 10;
				break;
			default:
				speed = 0;
				break;
		}
		nBytesSent += boaWrite(wp, "<td>%dM</td>",speed);
	}
	nBytesSent += boaWrite(wp, "</tr>");
	
	nBytesSent += boaWrite(wp, "</tr></table>");
#endif
	return nBytesSent;
}
#else
int show_LAN_status(int eid, request * wp, int argc, char **argv)
{	
	int i = 0 , nBytesSent = 0;;
#ifdef CONFIG_COMMON_RT_API
	rt_port_t port[ELANVIF_NUM];
	rt_port_linkStatus_t link_status[ELANVIF_NUM] = {0};
	rt_port_speed_t link_speed[ELANVIF_NUM];
	rt_port_duplex_t duplex[ELANVIF_NUM];

	memset(link_status, 0, sizeof(link_status));
	memset(link_speed, 0, sizeof(link_speed));
	memset(duplex, 0, sizeof(duplex));

	for (i = 0; i < ELANVIF_NUM; i++)
	{
		port[i] = rtk_port_get_lan_phyID(i);
		if(port[i] == -1) // get fail
		{
			printf("%s get port %d phy id failed!\n", __FUNCTION__, i);
			continue;
		}

		if(rt_port_link_get(port[i], &link_status[i]) != RT_ERR_OK)
		{
			printf("%s get port %d status failed!\n", __FUNCTION__, i);
			continue;
		}

		if(rt_port_speedDuplex_get(port[i], &link_speed[i], &duplex[i]) != RT_ERR_OK)
		{
			printf("%s get port %d speed/duplex failed!\n", __FUNCTION__, i);
			continue;
		}
	}
	nBytesSent += boaWrite(wp, "<div align=\"left\"><b>LAN接口连接状态信息：</b></div>");
	nBytesSent += boaWrite(wp, "<table class=\"flat\" border=\"1\" cellpadding=\"1\" cellspacing=\"1\" width=\"100%%\">");
	nBytesSent += boaWrite(wp, "<tr class=\"hdb\" align=\"center\" nowrap> <td>接口</td> <td>连接状态</td> <td>工作模式</td><td>速率</td> </tr>");
	
	for(i = 0 ; i < ELANVIF_NUM ; i++)
	{
		nBytesSent += boaWrite(wp, "<tr align=\"center\">");
		nBytesSent += boaWrite(wp, "<td>端口_%d</td>",(i+1));
		nBytesSent += boaWrite(wp, "<td>%s</td>",(link_status[i] == RT_PORT_LINKUP)?"连接上":"未连接");
		nBytesSent += boaWrite(wp, "<td>%s</td>",(duplex[i] == RT_PORT_HALF_DUPLEX)?"半双工":"全双工");
		int speed = 0;
		switch(link_speed[i])
		{
			case RT_PORT_SPEED_1000M:
				speed = 1000;
				break;
			case RT_PORT_SPEED_100M:
				speed = 100;
				break;
			case RT_PORT_SPEED_10M:
				speed = 10;
				break;
			default:
				speed = 0;
				break;
		}
		nBytesSent += boaWrite(wp, "<td>%dM</td>",speed);
		nBytesSent += boaWrite(wp, "</tr>");
	}
	
	nBytesSent += boaWrite(wp, "</tr></table>");
#endif
	return nBytesSent;
}
#endif
#ifdef CONFIG_CU_BASEON_CMCC
int show_LAN_linkstatus(int eid, request * wp, int argc, char **argv)
{
    int i = 0,nBytesSent = 0;
    
#ifdef CONFIG_COMMON_RT_API
	rt_port_t port[ELANVIF_NUM];
	rt_port_linkStatus_t link_status[ELANVIF_NUM];

	for (i = 0; i < ELANVIF_NUM; i++)
	{
		port[i] = rtk_port_get_lan_phyID(i);
		if(port[i] == -1) // get fail
		{
			printf("%s get port %d phy id failed!\n", __FUNCTION__, i);
			continue;
		}

		if(rt_port_link_get(port[i], &link_status[i]) != RT_ERR_OK)
		{
			printf("%s get port %d status failed!\n", __FUNCTION__, i);
			continue;
		}
	}

    nBytesSent += boaWrite(wp, "<tr style=\"font-size: 10px;\"><td style=\"font-size: 16px;\"><p>灯名称：</p></td>");
    for(i = 0 ; i < ELANVIF_NUM ; i++)
    {
        nBytesSent += boaWrite(wp, "<td align=\"center\" >LAN%d </td>", (i+1));
    }
    nBytesSent += boaWrite(wp, "</tr>");

    nBytesSent += boaWrite(wp, "<tr style=\"font-size: 16px; \">");
    nBytesSent += boaWrite(wp, "<td><p>状态：</p></td>");
    for(i = 0 ; i < ELANVIF_NUM ; i++)
    {
		if(link_status[i] == RT_PORT_LINKUP)
        		nBytesSent += boaWrite(wp, "<td width=\"40\" style=\"text-align:center;\"><img src=\"../image/lanup.jpg\"></td>");
		else
			nBytesSent += boaWrite(wp, "<td width=\"40\" style=\"text-align:center;\"><img src=\"../image/landown.jpg\"></td>");
    }
    nBytesSent += boaWrite(wp, "</tr>");

#endif
    return nBytesSent;
}
#endif
int E8BPktStatsList(int eid, request * wp, int argc, char ** argv)
{
	int i, nBytesSent = 0;
	struct net_device_stats nds;
	char ifname[IFNAMSIZ]={0};
#if defined(CONFIG_CMCC) || defined(CONFIG_CU_BASEON_CMCC)
	unsigned long long total_tx_pkts=0,total_tx_drops=0,total_tx_errs=0,total_rx_pkts=0,total_rx_drops=0,total_rx_errs=0;
	unsigned long long int total_tx_bytes=0,total_rx_bytes=0;
	unsigned long tx_pkts,tx_drops,tx_errs,rx_pkts,rx_drops,rx_errs;
	unsigned long long int tx_bytes,rx_bytes;
	rt_stat_port_cntr_t counters;

#endif

#if defined(CONFIG_CMCC)
	memset(&counters, 0, sizeof(counters));
	for (i = 0; i < ELANVIF_NUM; i++) {
		rt_stat_port_getAll(rtk_port_get_lan_phyID(i), &counters);
		rx_pkts=counters.ifInUcastPkts + counters.ifInMulticastPkts + counters.ifInBroadcastPkts;
		rx_bytes=counters.ifInOctets;
		rx_errs=counters.dot3StatsSymbolErrors + counters.dot3ControlInUnknownOpcodes;
		rx_drops=counters.dot1dTpPortInDiscards;
		tx_pkts=counters.ifOutUcastPkts + counters.ifOutMulticastPkts + counters.ifOutBrocastPkts;
		tx_bytes=counters.ifOutOctets;
		tx_errs=0;
		tx_drops=counters.ifOutDiscards;
		nBytesSent += boaWrite(wp, "ethers.push(new it_nr(\"%d\""
				", new it(\"%s\", \"端口_%d\")" _PTUL _PTULL
				_PTUL _PTUL _PTUL
				_PTULL _PTUL _PTUL "));\n",
			  i, "ifname", i+1,
			  "rx_packets", rx_pkts,
			  "rx_bytes", rx_bytes,
			  "rx_errors", rx_errs,
			  "rx_dropped", rx_drops,
			  "tx_packets", tx_pkts,
			  "tx_bytes", tx_bytes,
			  "tx_errors", tx_errs,
			  "tx_dropped", tx_drops);
				total_tx_pkts += tx_pkts;
				total_tx_drops += tx_drops;
				total_tx_errs += tx_errs;
				total_rx_pkts += rx_pkts;
				total_rx_drops += rx_drops;
				total_rx_errs += rx_errs;
				total_tx_bytes += tx_bytes;
				total_rx_bytes += rx_bytes;
	}
#else
	for (i = 0; i < ELANVIF_NUM; i++) {
#ifdef CONFIG_USER_SUPPORT_EXTERNAL_SWITCH
		if (rtk_port_check_external_port(i)){
			snprintf(ifname, sizeof(ifname), "%s", ELANVIF[i]);
		}
		else
#endif
		{
			snprintf(ifname, sizeof(ifname), "%s", ELANRIF[i]);
		}

		get_net_device_stats(ifname, &nds);
		nBytesSent += boaWrite(wp, "ethers.push(new it_nr(\"%d\""
				", new it(\"%s\", \"端口_%d\")" _PTULL _PTULL
				_PTULL _PTULL _PTULL
				_PTULL _PTULL _PTULL "));\n",
			  i, "ifname", i+1,
			  "rx_packets", nds.rx_packets,
			  "rx_bytes", nds.rx_bytes,
			  "rx_errors", nds.rx_errors,
			  "rx_dropped", nds.rx_dropped,
			  "tx_packets", nds.tx_packets,
			  "tx_bytes", nds.tx_bytes,
			  "tx_errors", nds.tx_errors,
			  "tx_dropped", nds.tx_dropped);
#if defined(CONFIG_CMCC) || defined(CONFIG_CU_BASEON_CMCC)
		total_tx_pkts += nds.tx_packets;
		total_tx_drops += nds.tx_dropped;
		total_tx_errs += nds.tx_errors;
		total_rx_pkts += nds.rx_packets;
		total_rx_drops += nds.rx_dropped;
		total_rx_errs += nds.rx_errors;
		total_tx_bytes += nds.tx_bytes;
		total_rx_bytes += nds.rx_bytes;
#endif
	}
#endif

#if defined(CONFIG_CMCC) || defined(CONFIG_CU_BASEON_CMCC)
	i=0;
	nBytesSent += boaWrite(wp, "ethers.push(new it_nr(\"%d\""
				", new it(\"%s\", \"%s\")" _PTULL _PTULL
				_PTULL _PTULL _PTULL
				_PTULL _PTULL _PTULL "));\n",
			  i, "ifname", "Ethernet",
			  "rx_packets", total_rx_pkts,
			  "rx_bytes", total_rx_bytes,
			  "rx_errors", total_rx_errs,
			  "rx_dropped", total_rx_drops,
			  "tx_packets", total_tx_pkts,
			  "tx_bytes", total_tx_bytes,
			  "tx_errors", total_tx_errs,
			  "tx_dropped", total_tx_drops);
#endif

	return nBytesSent;
}

#ifdef CONFIG_CMCC_ENTERPRISE
int listWanStatistics(int eid, request * wp, int argc, char ** argv)
{
	int i = 0;
	int ret;
	int nBytesSent = 0;
	struct net_device_stats nds;
	char ifname[IFNAMSIZ]={0};
	unsigned long total_tx_pkts=0,total_tx_drops=0,total_tx_errs=0,total_rx_pkts=0,total_rx_drops=0,total_rx_errs=0;
	unsigned long long int total_tx_bytes=0,total_rx_bytes=0;
#if defined(CONFIG_GPON_FEATURE) || defined(CONFIG_EPON_FEATURE)|| defined(CONFIG_FIBER_FEATURE)
	int pon_mode = 0;
	mib_get(MIB_PON_MODE, &pon_mode);
	if(pon_mode == GPON_MODE || pon_mode == EPON_MODE){
		boaWrite(wp, "var wanPhyType = 1;\n"
					); // 0 ETH WAN, 1 XPON WAN
	}
	else if(pon_mode == ETH_MODE){
		boaWrite(wp, "var wanPhyType = 0;\n"
					); // 0 ETH WAN, 1 XPON WAN
	}
#endif

	snprintf(ifname, sizeof(ifname), "%s", ALIASNAME_NAS0);
	get_net_device_stats(ifname, &nds);

	i=0;
	nBytesSent += boaWrite(wp, "ethers.push(new it_nr(\"%d\""
				", new it(\"%s\", \"%s\")" _PTULL _PTULL
				_PTULL _PTULL _PTULL
				_PTULL _PTULL _PTULL "));\n",
				i, "ifname", "Ethernet",
				"rx_packets", nds.rx_packets,
				"rx_bytes", nds.rx_bytes,
				"rx_errors", nds.rx_errors,
				"rx_dropped", nds.rx_dropped,
				"tx_packets", nds.tx_packets,
				"tx_bytes", nds.tx_bytes,
				"tx_errors", nds.tx_errors,
				"tx_dropped", nds.tx_dropped);

	boaWrite(wp, "var wanLinkStatus	= %d;\n", is_interface_run(ifname));

	return 0;
}
#endif

#if  defined(CONFIG_USER_LAN_BANDWIDTH_MONITOR) && defined(CONFIG_USER_LANNETINFO)
int initPageLanBandwidthMonitor(int eid, request * wp, int argc, char ** argv)
{
	lanHostInfo_t *pLanNetInfo=NULL;
	unsigned char macString[32]={0};
	unsigned int count=0;
	int ret=-1, idx;

	ret = get_lan_net_info(&pLanNetInfo, &count);
	if(ret<0)
		goto end;

	for(idx=0; idx<count; idx++)
	{
#if defined(CONFIG_CMCC) || defined(CONFIG_CU_BASEON_CMCC)
		get_attach_device_name(pLanNetInfo[idx].mac, pLanNetInfo[idx].devName);
#endif

		memset(macString, 0, 32);
		changeMacToString(pLanNetInfo[idx].mac, macString);
		fillcharZeroToMacString(macString);

#ifdef CONFIG_USER_REFINE_CHECKALIVE_BY_ARP
		boaWrite (wp, "push(new it_nr(\"%d\"" _PTS _PTI _PTI"));\n", idx,
			"mac", macString, "cur_usBand", (pLanNetInfo[idx].upRate >> 7), "cur_dsBand", (pLanNetInfo[idx].downRate >> 7));
#else
		boaWrite (wp, "push(new it_nr(\"%d\"" _PTS _PTI _PTI"));\n", idx,
			"mac", macString, "cur_usBand", pLanNetInfo[idx].upRate, "cur_dsBand", pLanNetInfo[idx].downRate);
#endif
	}

end:
	if(pLanNetInfo)
		free(pLanNetInfo);

	return ret;
}

#endif

unsigned char *ipAssignChineseString[2] = {
	"静态分配",
	"动态分配"
};

#ifdef CONFIG_USER_LANNETINFO


unsigned char *devTypeString[10] = {
	"OTHER",
	"phone",
	"PC",
	"Pad",
	"STB",
	"PLC",
	"AP",
	"ROUTER",
	"SMTDEV",
	"CloudVR"
};

unsigned char *connectionTypeString[2] = {
	"Ethernet",
	"Wifi"
};

unsigned char *connectionTypeChineseString[2] = {
	"有线",
	"无线"
};

int initPageLanNetInfo(int eid, request * wp, int argc, char ** argv)
{
	lanHostInfo_t *pLanNetInfo=NULL;
	unsigned char macString[32]={0};
	struct in_addr lanIP;
	unsigned int count=0;
	int ret=-1, idx;

	ret = get_lan_net_info(&pLanNetInfo, &count);
	if(ret<0)
		goto end;

	for(idx=0; idx<count; idx++)
	{
		memset(macString, 0, 32);
		changeMacToString(pLanNetInfo[idx].mac, macString);
		fillcharZeroToMacString(macString);
		lanIP.s_addr = pLanNetInfo[idx].ip;

		boaWrite (wp, "push(new it_nr(\"%d\""_PTS _PTS _PTS _PTS _PTS _PTI _PTS _PTS _PTS _PTI _PTS _PTS"));\n", idx,
			"devName", pLanNetInfo[idx].devName, "devType", devTypeString[pLanNetInfo[idx].devType],"brand", pLanNetInfo[idx].brand, "model", pLanNetInfo[idx].model,
			"OS", pLanNetInfo[idx].os, "port", pLanNetInfo[idx].port, "mac", macString, "ip", inet_ntoa(lanIP), "connectionType", connectionTypeString[pLanNetInfo[idx].connectionType],
			"onlineTime", pLanNetInfo[idx].onLineTime, "latestActiveTime", pLanNetInfo[idx].latestActiveTime,
			"latestInactiveTime", pLanNetInfo[idx].latestInactiveTime);
	}

end:
	if(pLanNetInfo)
		free(pLanNetInfo);

	return ret;
}

#endif

#if defined(CONFIG_CMCC) || defined(CONFIG_CU_BASEON_CMCC)
/*****************************
** devices list
*/

static int convert_time_to_str(char *dst, int size, unsigned int time)
{
	char tmp_str[80] = {0};

	//accurate the time
	if(time > 86400)
	{
		sprintf(tmp_str, "%dD ", time/86400);
		time %= 86400;
	}
	else
		sprintf(tmp_str, "0D ");
	strcat(dst, tmp_str);
	if(time > 3600)
	{
		sprintf(tmp_str, "%dH ", time/3600);
		time %= 3600;
	}
	else
		sprintf(tmp_str, "0H ");
	strcat(dst, tmp_str);
	if(time > 60)
	{
		sprintf(tmp_str, "%dM ", time/60);
		time %= 60;
	}
	else
		sprintf(tmp_str, "0M ");
	strcat(dst, tmp_str);
	sprintf(tmp_str, "%dS", time);
	strcat(dst, tmp_str);

	return 0;
}

int E8BLanDevList(int eid, request * wp, int argc, char ** argv)
{
#ifdef EMBED
	char ipAddr[INET_ADDRSTRLEN]={0}, tmpipAddr[INET_ADDRSTRLEN]={0}, macAddr[20]={0}, liveTime[80]={0};
	char devname[MAX_NAME_LEN]={0}, conType[10]={0}, ipAssign[20]={0}, *buf = NULL, *ptr = NULL;
#if (defined (CONFIG_YUEME) || defined (CONFIG_CMCC) || defined(CONFIG_CU)) && defined (CONFIG_USER_LANNETINFO)
	lanHostInfo_t *pLanNetInfo=NULL;
#else
#ifdef _PRMT_X_TELEFONICA_ES_DHCPOPTION_
	DHCPS_SERVING_POOL_T dhcppoolentry;
#endif
#endif
	char lanHostMac[20];
	int i, entryNum, ret, pid, cnt;
	struct stat status;
	unsigned int ipVal = 0;
	unsigned long leaseFileSize;
	unsigned long FileSize;
	int isDhcpArp;
	time_t now = 0;
	char leaseTime[80]={0};
	char onlineTime[80]={0};
	unsigned int leaseTimeNum = 0;
	unsigned int onlineTimeNum = 0;

	if(getDhcpClientLeasesDB(&buf, &leaseFileSize) < 0)
		goto err;
#if (defined(_SUPPORT_INTFGRPING_PROFILE_) || defined(_SUPPORT_L2BRIDGING_PROFILE_) ) && defined(_SUPPORT_L2BRIDGING_DHCP_SERVER_)
	//parse the /var/dhcpd_ipv4_interface_group.leases to C code easy to read format
	if(access(DHCPD_IPV4_INTERFACE_GROUP_LEASES,0) == 0)
		va_cmd(DHCPD_IPV4_PARSE_LEASES_SCRIPT, 1, 1,  DHCPD_IPV4_INTERFACE_GROUP_LEASES);
#endif
#if (defined (CONFIG_YUEME) || defined (CONFIG_CMCC) || defined(CONFIG_CU)) && defined (CONFIG_USER_LANNETINFO)
	ret = get_lan_net_info(&pLanNetInfo, &entryNum);
	if(ret<0)
			goto err;
#else
	entryNum = mib_chain_total(MIB_DHCPS_SERVING_POOL_TBL);
#endif

	cnt = 0;
	isDhcpArp = 0;
	for(i=0; i < entryNum; i++){
		isDhcpArp = 0;
		now = getSYSInfoTimer();
		//strcpy(ipAssign, ipAssignChineseString[0]);
		ipAssign[sizeof(ipAssign)-1]='\0';
		strncpy(ipAssign, ipAssignChineseString[0], sizeof(ipAssign)-1);
		ptr = buf;
		FileSize = leaseFileSize;
#if (defined (CONFIG_YUEME) || defined (CONFIG_CMCC) || defined(CONFIG_CU)) && defined (CONFIG_USER_LANNETINFO)
		snprintf(macAddr, 20, "%02x:%02x:%02x:%02x:%02x:%02x",
				pLanNetInfo[i].mac[0], pLanNetInfo[i].mac[1],pLanNetInfo[i].mac[2],pLanNetInfo[i].mac[3],
				pLanNetInfo[i].mac[4], pLanNetInfo[i].mac[5]);
#endif
		while (1) {
			uint32_t active_time = 0;
			ret = getOneDhcpClient(&ptr, &FileSize, ipAddr, lanHostMac, liveTime, &active_time);
			/* lijian: 20080904 END */
			//printf("%s:%d macAddr %s, lanHostMac %s\n", __FUNCTION__, __LINE__, macAddr, lanHostMac);
			if (ret < 0)
				break;
			if (ret == 0)
				continue;

			//printf("%s:%d macAddr %s, lanHostMac %s\n", __FUNCTION__, __LINE__, macAddr, lanHostMac);
			if( 0 == strcmp(macAddr, lanHostMac) ){
				//printf("%s:%d macAddr %s is dynamic\n", __FUNCTION__, __LINE__, macAddr);
				//strcpy(ipAssign, ipAssignChineseString[1]);
				ipAssign[sizeof(ipAssign)-1]='\0';
				strncpy(ipAssign, ipAssignChineseString[1], sizeof(ipAssign)-1);
				isDhcpArp = 1;
				leaseTimeNum =atoi(liveTime);
				onlineTimeNum = now - active_time;
				//fprintf(stderr, "now =%u, active=%u, online=%u\n", now, active_time, onlineTimeNum);
				memset(liveTime, 0, sizeof(liveTime));
				memset(onlineTime, 0, sizeof(onlineTime));
				convert_time_to_str(liveTime, sizeof(liveTime), leaseTimeNum);
				convert_time_to_str(onlineTime, sizeof(onlineTime), onlineTimeNum);
#ifdef CONFIG_CMCC_ENTERPRISE
				strcpy(devname, pLanNetInfo[i].devName);
				boaWrite(wp, "with(dhcp){push(new it_nr(\"%d\"" _PTS _PTS _PTS _PTS _PTS "))};\n",
							  i, _PMEX(devname), _PMEX(macAddr), _PMEX(ipAddr), _PMEX(onlineTime), _PMEX(liveTime));
#endif
				break;
			}
			else
				snprintf(liveTime, 10, "%lu", 0);
		}
#if (defined(_SUPPORT_INTFGRPING_PROFILE_) || defined(_SUPPORT_L2BRIDGING_PROFILE_) ) && defined(_SUPPORT_L2BRIDGING_DHCP_SERVER_)
		FILE *fp = NULL;
		char buf[256]={0};
		int start_year=0,start_mon=0,start_day=0,start_hour=0,start_min=0,start_sec=0;
		int end_year=0,end_mon=0,end_day=0,end_hour=0,end_min=0,end_sec=0;
		time_t start_of_lease, end_of_lease;
		uint32_t active_time = 0;
		if(!isDhcpArp){
			if(access(DHCPD_IPV4_INTERFACE_GROUP_LEASES,0) == 0) {
				time(&now);
				fp=fopen(DHCPD_IPV4_INTERFACE_GROUP_LEASES_PARSED,"r");
				if(fp)
				{
					while(fgets(buf,sizeof(buf),fp)!=NULL)
					{
						memset(ipAddr, 0, sizeof(ipAddr));
						if(sscanf(buf,"%s %s %d/%d/%d %d:%d:%d %d/%d/%d %d:%d:%d", ipAddr, lanHostMac, 
							&start_year, &start_mon, &start_day, &start_hour, &start_min, &start_sec,
							&end_year, &end_mon, &end_day, &end_hour, &end_min, &end_sec) == 14)
						{
							if( 0 == strcmp(macAddr, lanHostMac) )
							{
								isDhcpArp = 1;
								start_of_lease = convert_timeStr_to_epoch(start_year, start_mon, start_day, start_hour, start_min, start_sec);
								end_of_lease = convert_timeStr_to_epoch(end_year, end_mon, end_day, end_hour, end_min, end_sec);
								leaseTimeNum =end_of_lease - now;
								onlineTimeNum = now - start_of_lease;
								fprintf(stderr, "now =%u, start_of_lease=%u, end_of_lease=%u\n", now, start_of_lease, end_of_lease);
								memset(liveTime, 0, sizeof(liveTime));
								memset(onlineTime, 0, sizeof(onlineTime));
								convert_time_to_str(liveTime, sizeof(liveTime), leaseTimeNum);
								convert_time_to_str(onlineTime, sizeof(onlineTime), onlineTimeNum);
								strcpy(devname, pLanNetInfo[i].devName);
								boaWrite(wp, "with(dhcp){push(new it_nr(\"%d\"" _PTS _PTS _PTS _PTS _PTS "))};\n",
										  i, _PMEX(devname), _PMEX(macAddr), _PMEX(ipAddr), _PMEX(onlineTime), _PMEX(liveTime));
								break;
							}
						}
					}
					fclose(fp);
				}
			}
		}
#endif
#if (defined (CONFIG_YUEME) || defined (CONFIG_CMCC) || defined (CONFIG_CU)) && defined (CONFIG_USER_LANNETINFO)				
		if(!isDhcpArp){
			strncpy(pLanNetInfo[i].devName, "Anonymous", sizeof(pLanNetInfo[i].devName));
		}
		get_attach_device_name(pLanNetInfo[i].mac, pLanNetInfo[i].devName);
		int result = rtk_iconv_scan_multi_bytes(pLanNetInfo[i].devName);
		//strcpy(devname, pLanNetInfo[i].devName);
		devname[sizeof(devname)-1]='\0';
		strncpy(devname, pLanNetInfo[i].devName, sizeof(devname)-1);
		if(result){
			rtk_iconv_gbk_to_utf8(pLanNetInfo[i].devName, devname, MAX_NAME_LEN);
			devname[sizeof(devname)-1]='\0';
		}

		inet_ntop(AF_INET, &(pLanNetInfo[i].ip), ipAddr, INET_ADDRSTRLEN);
		sprintf(conType, connectionTypeChineseString[pLanNetInfo[i].connectionType]);
#endif

#ifdef CONFIG_CMCC_ENTERPRISE
		char devType[5];
		sprintf(devType, "%s", devTypeString[pLanNetInfo[i].devType]);
		boaWrite(wp, "with(clts){push(new it_nr(\"%d\"" _PTS _PTS _PTS"));}\n",
				  i, _PMEX(devType), _PMEX(macAddr), _PMEX(ipAddr));
#else
		boaWrite(wp, "clts.push(new it_nr(\"%d\"" _PTS_XSS _PTS _PTS _PTS _PTS _PTS "));\n",
			  i, _PMEX_XSS(devname), _PMEX(macAddr), _PMEX(ipAddr), _PMEX(liveTime), _PMEX(conType), _PMEX(ipAssign));
#endif
	}

err:
#if (defined (CONFIG_YUEME) || defined (CONFIG_CMCC) || defined(CONFIG_CU)) && defined (CONFIG_USER_LANNETINFO)
	if(pLanNetInfo)
		free(pLanNetInfo);
#endif
	if (buf)
		free(buf);

	return 0;
#else
	return 0;
#endif
}
#else
/*****************************
** devices list
*/
int E8BDhcpClientList(int eid, request * wp, int argc, char ** argv)
{
#ifdef EMBED
	char ipAddr[INET_ADDRSTRLEN], macAddr[20], liveTime[10], devname[MAX_NAME_LEN], *buf = NULL, *ptr;
#if (defined (CONFIG_YUEME) || defined(CONFIG_CU_BASEON_YUEME) || defined(CONFIG_E8B)) && defined (CONFIG_USER_LANNETINFO)
	lanHostInfo_t *pLanNetInfo=NULL;
	char lanHostMac[20];
#else
#ifdef _PRMT_X_TELEFONICA_ES_DHCPOPTION_
	DHCPS_SERVING_POOL_T dhcppoolentry;
#endif
#endif
	int i, entryNum, ret, pid, cnt;
	struct stat status;
	unsigned int ipVal = 0;
	unsigned long leaseFileSize;
#ifdef CONFIG_RTK_DEV_AP
	int mibtotal=0;
	char macAddr_Dhcp[20]={0};
	MIB_CE_MAC_BASE_DHCP_T entry;
#endif

	if(getDhcpClientLeasesDB(&buf, &leaseFileSize) <= 0)
		goto err;
	
	ptr = buf;

#if (defined (CONFIG_YUEME) || defined(CONFIG_CU_BASEON_YUEME) || defined(CONFIG_E8B)) && defined (CONFIG_USER_LANNETINFO)
	ret = get_lan_net_info(&pLanNetInfo, &entryNum);
	if(ret<0)
			goto err;
#else
	entryNum = mib_chain_total(MIB_DHCPS_SERVING_POOL_TBL);
#endif

	cnt = 0;

	while (1) {
		uint32_t active_time = 0;
		ret = getOneDhcpClient(&ptr, &leaseFileSize, ipAddr, macAddr, liveTime, &active_time);
		/* lijian: 20080904 END */

		if (ret < 0)
			break;
		if (ret == 0)
			continue;

		inet_aton(ipAddr, (struct in_addr *)&ipVal);
		for (i = 0; i < entryNum; i++) {
			memset(&devname, 0, sizeof(devname));
#if (defined (CONFIG_YUEME) || defined(CONFIG_CU_BASEON_YUEME) || defined(CONFIG_E8B)) && defined (CONFIG_USER_LANNETINFO)
			memset(lanHostMac, 0, 20);
			snprintf(lanHostMac, 20, "%02x:%02x:%02x:%02x:%02x:%02x",
				pLanNetInfo[i].mac[0], pLanNetInfo[i].mac[1],pLanNetInfo[i].mac[2],pLanNetInfo[i].mac[3],
				pLanNetInfo[i].mac[4], pLanNetInfo[i].mac[5]);
			if( 0 == strcmp(macAddr, lanHostMac) )
			{
				strcpy(devname, devTypeString[pLanNetInfo[i].devType]);
				break;
			}
#else
#ifdef _PRMT_X_TELEFONICA_ES_DHCPOPTION_
			if (!mib_chain_get
				(MIB_DHCPS_SERVING_POOL_TBL, i,
				(void *)&dhcppoolentry))
				continue;
			if (ipVal >= *(unsigned int *)dhcppoolentry.startaddr
			&& ipVal <=
			*(unsigned int *)dhcppoolentry.endaddr) {
			strcpy(devname, dhcppoolentry.poolname);
				break;
			}
#endif
#endif
		}//end of for
		/*if can't find MAC in lanNetinfo, set type is OTHER  */
#if (defined (CONFIG_YUEME) || defined(CONFIG_CU_BASEON_YUEME) || defined(CONFIG_E8B)) && defined (CONFIG_USER_LANNETINFO)
		if(i>=entryNum)
			strncpy(devname, devTypeString[0], MAX_NAME_LEN-1);
#endif

#ifdef CONFIG_RTK_DEV_AP
		mibtotal = mib_chain_total(MIB_MAC_BASE_DHCP_TBL);

		for (i = 0; i < mibtotal; i++) {
			mib_chain_get(MIB_MAC_BASE_DHCP_TBL, i, (void *)&entry);
			snprintf(macAddr_Dhcp, 18,
				 "%02x:%02x:%02x:%02x:%02x:%02x",
				 entry.macAddr_Dhcp[0], entry.macAddr_Dhcp[1],
				 entry.macAddr_Dhcp[2], entry.macAddr_Dhcp[3],
				 entry.macAddr_Dhcp[4],
				 entry.macAddr_Dhcp[5]);
			if(0 == strncmp(macAddr, macAddr_Dhcp, 17))
			{
				memset(liveTime, 0, sizeof(liveTime));
				snprintf(liveTime, sizeof(liveTime), "--");
			}
			
		}
#endif
		
		boaWrite(wp, "clts.push(new it_nr(\"%d\"" _PTS_XSS _PTS _PTS _PTS "));\n",
			  cnt, _PMEX_XSS(devname), _PMEX(macAddr), _PMEX(ipAddr), _PMEX(liveTime));
		cnt++;
	}

err:
#if (defined (CONFIG_YUEME) || defined(CONFIG_CU_BASEON_YUEME)|| defined(CONFIG_E8B)) && defined (CONFIG_USER_LANNETINFO)
	if(pLanNetInfo)
		free(pLanNetInfo);
#endif
	if (buf)
		free(buf);

	return 0;
#else
	return 0;
#endif
}
#endif
#if defined(CONFIG_CMCC) || defined(CONFIG_CU_BASEON_CMCC) || defined(CONFIG_RTK_DEV_AP)
int getWANItfArray(int eid, request * wp, int argc, char **argv){

	MIB_CE_ATM_VC_T entry;
	int entryNum = 0;
	int i=0;
	struct wan_status_info sEntry[MAX_VC_NUM + MAX_PPP_NUM] = { 0 };

	entryNum = mib_chain_total(MIB_ATM_VC_TBL);
	for (i = 0; i < entryNum; i++) {
		if (!mib_chain_get(MIB_ATM_VC_TBL, i, &entry)) {
			printf("get MIB chain error\n");
			return -1;
		}

		getWanName(&entry, sEntry[i].servName);
		boaWrite(wp,"[%u,\"%s\",0,0]",entry.ifIndex, sEntry[i].servName);
		if(i!=(entryNum-1)){
			//boaWrite(wp,",",entry.ifIndex, sEntry[i].servName);
			boaWrite(wp,"%s",",");
		}

	}
	return 0;
}
#endif


#ifdef CONFIG_CMCC_ENTERPRISE
#ifdef CONFIG_LIB_LIBNETFILTER_CONNTRACK
#include <libnetfilter_conntrack/libnetfilter_conntrack.h>
#include <libnetfilter_conntrack/libnetfilter_conntrack_tcp.h>
#include <assert.h>
#include <libmnl/libmnl.h>
static int session_counter=0;
static int dump_cb(enum nf_conntrack_msg_type type, struct nf_conntrack *ct, void *data)
{
	char buf[1024];
	unsigned int op_type = NFCT_O_DEFAULT;
	unsigned int op_flags = 0;
	struct nf_conntrack *obj = data;

	if (!nfct_cmp(obj, ct, NFCT_CMP_ALL | NFCT_CMP_MASK)) {
		return NFCT_CB_CONTINUE;
	}

	session_counter++;
	return NFCT_CB_CONTINUE;
}

int get_conntrack_num(char* ipaddr, int protocol)
{
	struct nfct_handle *cth = nfct_open(CONNTRACK, 0);
	struct nfct_filter_dump_mark filter_dump_mark = {
		.val = 1,
		.mask = 0xffffffff,
	};
	struct nf_conntrack *ct_mask;
	ct_mask = nfct_new();
	if (!ct_mask) {
		perror("nfct_new");
		return -1;
	}
	/* IPPROTO_TCP, IPPROTO_UDP*/
	memset(ct_mask, 0, sizeof(ct_mask));
	nfct_set_attr_u8(ct_mask, ATTR_ORIG_L3PROTO, AF_INET);
	nfct_set_attr_u32(ct_mask, ATTR_ORIG_IPV4_SRC, inet_addr(ipaddr));
	nfct_set_attr_u8(ct_mask, ATTR_L4PROTO, protocol);

	assert(cth != NULL);

	nfct_callback_register(cth, NFCT_T_ALL, dump_cb, ct_mask);
	struct nfct_filter_dump *filter_dump = nfct_filter_dump_create();
	assert(filter_dump != NULL);
	nfct_filter_dump_set_attr_u8(filter_dump, NFCT_FILTER_DUMP_L3NUM, AF_INET);
	nfct_query(cth, NFCT_Q_DUMP_FILTER, filter_dump);

	nfct_filter_dump_destroy(filter_dump);
	nfct_close(cth);
	nfct_destroy(ct_mask);

	return 0;
}
#endif

int show_lan_staticis(int eid, request * wp, int argc, char ** argv)
{
	char ipAddr[INET_ADDRSTRLEN], tmpipAddr[INET_ADDRSTRLEN], macAddr[20], liveTime[80], devname[MAX_NAME_LEN], conType[10], ipAssign[20], *buf = NULL, *ptr;
	lanHostInfo_t *pLanNetInfo=NULL;
	char lanHostMac[20];
	int i, entryNum, ret, pid, cnt;
	struct stat status;
	unsigned int ipVal = 0, nBytesSent=0;
	unsigned long leaseFileSize;
	unsigned long FileSize;
	time_t now = 0;

	if(getDhcpClientLeasesDB(&buf, &leaseFileSize) < 0)
		goto err;

	ret = get_lan_net_info(&pLanNetInfo, &entryNum);
	if(ret<0)
			goto err;

	cnt = 0;
	int isDhcpArp = 0;
	time(&now);
	for(i=0; i < entryNum; i++){
		isDhcpArp = 0;

		strcpy(ipAssign, ipAssignChineseString[0]);
		ptr = buf;
		FileSize = leaseFileSize;
		snprintf(macAddr, 20, "%02x:%02x:%02x:%02x:%02x:%02x",
				pLanNetInfo[i].mac[0], pLanNetInfo[i].mac[1],pLanNetInfo[i].mac[2],pLanNetInfo[i].mac[3],
				pLanNetInfo[i].mac[4], pLanNetInfo[i].mac[5]);
		if(!isDhcpArp){
			strncpy(pLanNetInfo[i].devName, "Anonymous", sizeof(pLanNetInfo[i].devName));
		}
		get_attach_device_name(pLanNetInfo[i].mac, pLanNetInfo[i].devName);
		int result = rtk_iconv_scan_multi_bytes(pLanNetInfo[i].devName);
		strcpy(devname, pLanNetInfo[i].devName);
		if(result)
			rtk_iconv_gbk_to_utf8(pLanNetInfo[i].devName, devname, MAX_NAME_LEN);

		inet_ntop(AF_INET, &(pLanNetInfo[i].ip), ipAddr, INET_ADDRSTRLEN);
		sprintf(conType, connectionTypeChineseString[pLanNetInfo[i].connectionType]);

		char devType[5];
		int udp_session = 0, tcp_session = 0;
		unsigned int rx_packets=0, tx_packets=0;
		unsigned long long rxBytes=0, txBytes=0;
		rx_packets = pLanNetInfo[i].rx_packets;
		tx_packets= pLanNetInfo[i].tx_packets;
		rxBytes = pLanNetInfo[i].rxBytes;
		txBytes = pLanNetInfo[i].txBytes;
#ifdef CONFIG_LIB_LIBNETFILTER_CONNTRACK
		session_counter=0;
		get_conntrack_num(ipAddr, IPPROTO_TCP);
		tcp_session = session_counter;
		session_counter=0;
		get_conntrack_num(ipAddr, IPPROTO_UDP);
		udp_session = session_counter;
#endif
		sprintf(devType, "%s", devTypeString[pLanNetInfo[i].devType]);
		nBytesSent += boaWrite(wp, "<tr>");
		nBytesSent += boaWrite(wp, "<td> %s </td>", ipAddr);
		nBytesSent += boaWrite(wp, "<td> %s </td>", macAddr);
		nBytesSent += boaWrite(wp, "<td> %u </td>", rx_packets);
		nBytesSent += boaWrite(wp, "<td> %llu </td>", rxBytes);
		nBytesSent += boaWrite(wp, "<td> %u </td>", tx_packets);
		nBytesSent += boaWrite(wp, "<td> %llu </td>", txBytes);
		nBytesSent += boaWrite(wp, "<td> %i </td>", udp_session);
		nBytesSent += boaWrite(wp, "<td> %i </td>", tcp_session);
		nBytesSent += boaWrite(wp, "</tr>");
	}

err:
	if(pLanNetInfo)
		free(pLanNetInfo);
	if (buf)
		free(buf);
	return nBytesSent;
}
#endif
