/*
 *      Web server handler routines for TCP/IP stuffs
 *      Authors: David Hsu	<davidhsu@realtek.com.tw>
 *      Authors: Dick Tam	<dicktam@realtek.com.tw>
 *
 */


/*-- System inlcude files --*/
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <dirent.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <signal.h>
#include <netinet/in.h>
#include <sys/socket.h>
#include <arpa/inet.h>
#include <sys/wait.h>
#include <time.h>
#include <net/route.h>
#include <sys/ioctl.h>
#include <signal.h>
#include <sys/ioctl.h>
#include <linux/if.h>

/*-- Local inlcude files --*/
#include "../webs.h"
#include "webform.h"
#include "mib.h"
#include "fmdefs.h"
#include "utility.h"
#ifdef _TR111_STUN_
#include "cwmp_stun_api.h"
#endif

#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/msg.h>

#define	CONFIG_DIR	"/var/config"
#define CA_FNAME	CONFIG_DIR"/cacert.pem"
#define CERT_FNAME	CONFIG_DIR"/client.pem"
#define CWMP_PRMT_FILE	"/tmp/cwmp_prmt"
#if defined(CONFIG_CMCC) || defined(CONFIG_CU_BASEON_CMCC)
#define CA_STATUS_FILE	"/tmp/ca_status"
#define CERT_STATUS_FILE    "/tmp/cert_status"
#endif

#if defined(CONFIG_CU)
#define RECONNECT_MSG(url) { \
		boaHeader(wp); \
		boaWrite(wp, "<head><META http-equiv=content-type content=\"text/html; charset=utf-8\"></head>");\
		boaWrite(wp, "<body><blockquote><h4 style=\"color:#fff;\">设定成功! " \
					"<form><input class=\"btnsaveup\" type=button value=\"	OK	\" OnClick=window.location.replace(\"%s\")></form></blockquote></body>", url);\
		boaFooter(wp); \
		boaDone(wp, 200); \
	}
#else
#define RECONNECT_MSG(url) { \
	boaHeader(wp); \
	boaWrite(wp, "<head><META http-equiv=content-type content=\"text/html; charset=utf-8\"></head>");\
	boaWrite(wp, "<body><blockquote><h4>设定成功! " \
                "<form><input type=button value=\"  OK  \" OnClick=window.location.replace(\"%s\")></form></blockquote></body>", url);\
	boaFooter(wp); \
	boaDone(wp, 200); \
}
#endif

#define UPLOAD_MSG(url) { \
	boaHeader(wp); \
	boaWrite(wp, "<head><META http-equiv=content-type content=\"text/html; charset=utf-8\"></head>");\
	boaWrite(wp, "<body><blockquote><h4>上传成功! " \
                "<form><input type=button value=\"  OK  \" OnClick=window.location.replace(\"%s\")></form></blockquote></body>", url);\
	boaFooter(wp); \
	boaDone(wp, 200); \
}

#define DEL_MSG(url) { \
	boaHeader(wp); \
	boaWrite(wp, "<head><META http-equiv=content-type content=\"text/html; charset=utf-8\"></head>");\
	boaWrite(wp, "<body><blockquote><h4>删除成功! " \
                "<form><input type=button value=\"  OK  \" OnClick=window.location.replace(\"%s\")></form></blockquote></body>", url);\
	boaFooter(wp); \
	boaDone(wp, 200); \
}

//copy from fmmgmt.c
//find the start and end of the upload file.
FILE * uploadGetCert(request *wp, unsigned int *startPos, unsigned int *endPos)
{
	FILE *fp=NULL;
	struct stat statbuf;
	unsigned char *buf;
	int c = 0;
	char boundary[80];
#if defined(CONFIG_CMCC) || defined(CONFIG_CU_BASEON_CMCC)
	char cmd[32] = {0};
#endif


	if (wp->method == M_POST)
	{
		int i;

		if(fstat(wp->post_data_fd, &statbuf) == -1)
			printf("[%s:%d]Cannot fstat the file\n",__FUNCTION__,__LINE__);
		lseek(wp->post_data_fd, 0, SEEK_SET);

		printf("file size=%lld\n",statbuf.st_size);
		fp=fopen(wp->post_file_name,"rb");
		if(fp==NULL) goto error;

		memset( boundary, 0, sizeof( boundary ) );
		if( fgets( boundary,80,fp )==NULL ) goto error;
		if( boundary[0]!='-' || boundary[1]!='-') 
		{
#if defined(CONFIG_CMCC) || defined(CONFIG_CU_BASEON_CMCC)
			snprintf(cmd, 32, "%s%s", "echo 1 > ", CA_STATUS_FILE);
			system(cmd);
#endif
			goto error;
		}

		i= strlen( boundary ) - 1;
		while( boundary[i]=='\r' || boundary[i]=='\n' )
		{
			boundary[i]='\0';
			i--;
		}
		printf( "boundary=%s\n", boundary );
	}
	else goto error;


   	//printf("_uploadGet\n");
   	do
   	{
		if(feof(fp))
		{
			printf("Cannot find start of file\n");
#if defined(CONFIG_CMCC) || defined(CONFIG_CU_BASEON_CMCC)
			snprintf(cmd, 32, "%s%s", "echo 1 > ", CA_STATUS_FILE);
			system(cmd);
#endif
			goto error;
		}
		c= fgetc(fp);
		if (c!=0xd)
			continue;
		c= fgetc(fp);
		if (c!=0xa)
			continue;
		c= fgetc(fp);
		if (c!=0xd)
			continue;
		c= fgetc(fp);
		if (c!=0xa)
			continue;
		break;
	}while(1);
	(*startPos)=ftell(fp);

   	if(fseek(fp,statbuf.st_size-0x200,SEEK_SET)<0)
	{
#if defined(CONFIG_CMCC) || defined(CONFIG_CU_BASEON_CMCC)
			snprintf(cmd, 32, "%s%s", "echo 1 > ", CA_STATUS_FILE);
			system(cmd);
#endif
      		goto error;
	}

	do
	{
		if(feof(fp))
		{
			printf("Cannot find end of file\n");
#if defined(CONFIG_CMCC) || defined(CONFIG_CU_BASEON_CMCC)
			snprintf(cmd, 32, "%s%s", "echo 1 > ", CA_STATUS_FILE);
			system(cmd);
#endif
			goto error;
		}
		c= fgetc(fp);
		if (c!=0xd)
			continue;
		c= fgetc(fp);
		if (c!=0xa)
			continue;

		{
			int i, blen;

			blen= strlen( boundary );
			for( i=0; i<blen; i++)
			{
				c= fgetc(fp);
				//printf("%c(%u)", c, c);
				if (c!=boundary[i])
				{
					ungetc( c, fp );
					break;
				}
			}
			//printf("\r\n");
			if( i!=blen ) continue;
		}

		break;
	}while(1);
	(*endPos)=ftell(fp)-strlen(boundary)-2;

   	return fp;
error:
	if(fp)
		fclose(fp);
   	return NULL;
}

///////////////////////////////////////////////////////////////////
#ifdef CONFIG_CMCC_ENTERPRISE
void formTR069ConfigStun(request *wp, char *path, char *query)
{
	char *strData=NULL;
	char tmpStr[256 + 1]={0};
	char tmpBuf[100]={0};
	unsigned char vChar=0;
#ifdef _TR111_STUN_
	unsigned char stunEnable;
	int cur_port, srvPort;
#endif
	char changeflag = 0;

#ifdef CONFIG_USER_TR111_STUN
	strData = boaGetVar(wp, "stun_enable", "");
	if ( strData[0] ) {
		stunEnable = (strData[0]=='0')? 0:1;

		mib_get_s( TR111_STUNENABLE, (void*)&vChar, sizeof(vChar));
		if(vChar != stunEnable){

			if (stunEnable == 0)
			{
				if ( !mib_set( TR111_NATDETECTED, (void *)&stunEnable) ) {
					strcpy(tmpBuf, strSetStunNatdetectederror);
					goto setErr_tr069;
				}
			}

			if ( !mib_set( TR111_STUNENABLE, (void *)&stunEnable)) {
				strcpy(tmpBuf, strSetStunEnableerror);
				goto setErr_tr069;
			}
			changeflag = 1;
		}
	}

	strData = boaGetVar(wp, "stunsvraddr", "");
	if(strContainXSSChar(strData))
		goto setErr_tr069;
	if ( strData[0]) {
		mib_get_s( TR111_STUNSERVERADDR, (void *)tmpStr, sizeof(tmpStr));
		if (strcmp(tmpStr,strData)!=0){
			if ( !mib_set( TR111_STUNSERVERADDR, (void *)strData)) {
				strcpy(tmpBuf, "Set STUN Server Address error!");
				goto setErr_tr069;
			}
		}
	}

	strData = boaGetVar(wp, "stunsvrport", "");
	if ( strData[0] ) {
		cur_port = atoi(strData);
		mib_get_s( TR111_STUNSERVERPORT, (void *)&srvPort, sizeof(srvPort));
		if ( srvPort != cur_port ) {
			if ( !mib_set( TR111_STUNSERVERPORT, (void *)&cur_port)) {
				strcpy(tmpBuf, "Set STUN server Port error!");
				goto setErr_tr069;
			}
		}
	}

	strData = boaGetVar(wp, "stunsvruname", "");
	if ( strData[0]) {
		mib_get_s( TR111_STUNUSERNAME, (void *)tmpStr, sizeof(tmpStr));
		if (strcmp(tmpStr,strData)!=0){
			if ( !mib_set( TR111_STUNUSERNAME, (void *)strData)) {
				strcpy(tmpBuf, "Set STUN Server User Name error!");
				goto setErr_tr069;
			}
		}
	}

	strData = boaGetVar(wp, "stunsvrupasswd", "");
	if ( strData[0]) {
		mib_get_s( TR111_STUNPASSWORD, (void *)tmpStr, sizeof(tmpStr));
		if (strcmp(tmpStr,strData)!=0){
			if ( !mib_set( TR111_STUNPASSWORD, (void *)strData)) {
				strcpy(tmpBuf, "Set STUN Server Password error!");
				goto setErr_tr069;
			}
		}
	}
#endif
	syslog(LOG_INFO, "Tr069ConfigStun: Apply formTR069ConfigStun.\n");

#ifdef _CWMP_WITH_SSL_
end_tr069:
#endif
#ifdef APPLY_CHANGE
	if(changeflag == 1){
		off_tr069();
		sleep(3);

		if (-1 == startCWMP()) {
			strcpy(tmpBuf,"Start tr069 Fail *****");
			printf("Start tr069 Fail *****\n");
			goto setErr_tr069;
		}
	}
#endif	//end of APPLY_CHANGE

	// Magician: Commit immediately
#ifdef COMMIT_IMMEDIATELY
	Commit();
#endif

	strData = boaGetVar(wp,"submit-url","");
#if defined(CONFIG_CMCC) || defined(CONFIG_CU_BASEON_CMCC)
	boaRedirect(wp, strData);
#else
	RECONNECT_MSG(strData);// display reconnect msg to remote
#endif

	return;

setErr_tr069:
	ERR_MSG(tmpBuf);
}
#endif

void formTR069Config(request *wp, char *path, char *query)
{
	char *strData=NULL;
	char tmpStr[256 + 1]={0};
	char tmpBuf[100]={0};
	unsigned char vChar=0;
	unsigned char cwmp_flag = 0;
	int len=0;
	char tmplogBuf[200]={0};
#if defined(CONFIG_CMCC) || defined(CONFIG_CU_BASEON_CMCC)
	unsigned char gui_passauth_enable = 0;
#endif
	unsigned char informEnble=0;
#ifdef _TR111_STUN_
	unsigned char stunEnable;
	int cur_port, srvPort;
#endif
	unsigned char old_informEnable = 0;
	unsigned int informInterval=0;
	// Mason Yu
	char changeflag = 0;
	char waitMwExit = 0;
	char hotSetMidware=0;
#ifdef CONFIG_CU
	char acspwd[256+1]={0};
	char creqpwd[256+1]={0};
#endif

	strData = boaGetVar(wp,"applyTr069Config","");
	if (strData[0]){

		unsigned char configurable = 0;

		mib_get_s(CWMP_CONFIGURABLE, &configurable, sizeof(configurable));
		if(configurable == 0)
			return;

		strData = boaGetVar(wp,"inform","");
		if (strData[0]) {
			//informEnble = (strData[0] == '0') ? 0 : 1;
			mib_get_s(CWMP_INFORM_ENABLE,&old_informEnable, sizeof(old_informEnable));
			informEnble = (strData[0] == '0') ? 0 :((strData[0] == '1') ? 1 : 2);
			if (!mib_set(CWMP_INFORM_ENABLE, &informEnble)) {
				//strcpy(tmpBuf,strSetInformEnableerror);
				snprintf(tmpBuf, sizeof(tmpBuf), "%s", strSetInformEnableerror);
				goto setErr_tr069;
			}
			if(old_informEnable != informEnble)//change infrom type, should restart cwmp to read gRandomInform
				changeflag = 1;

			len += snprintf(tmplogBuf+len, sizeof(tmplogBuf)-len, ", inform: %d", informEnble);
		}

		if (informEnble) {
			strData = boaGetVar(wp,"informInterval","");
			if (strData[0]) {
				informInterval = strtoul(strData, NULL, 0);

				if (!mib_set(CWMP_INFORM_INTERVAL, &informInterval)) {
					strcpy(tmpBuf,strSetInformIntererror);
					goto setErr_tr069;
				}
			}

			len += snprintf(tmplogBuf+len, sizeof(tmplogBuf)-len, ", informInterval: %d", informInterval);
		}

		strData = boaGetVar(wp,"acsURL","");
#if defined(CONFIG_CMCC) || defined(CONFIG_CU_BASEON_CMCC)
		if (strData[0] || strlen(strData)==0) {
#else
		if (strData[0]){
			if (strlen(strData) == 0) {
				strcpy(tmpBuf,strACSURLWrong);
				goto setErr_tr069;
			}
#endif

			if(strData[0] && !strstr(strData, "http://") && !strstr(strData, "https://"))
			{
				strcpy(tmpBuf,strACSURLWrong);
				goto setErr_tr069;
			}

			if(strContainXSSChar(strData) && !strstr(strData,"&"))
			{
				strcpy(tmpBuf,strACSURLWrong);
				goto setErr_tr069;
			}

	#ifndef _CWMP_WITH_SSL_
			if (strstr(strData, "https://")) {
				strcpy(tmpBuf,strSSLWrong);
				goto setErr_tr069;
			}
	#endif
			mib_get_s(CWMP_ACS_URL, tmpStr, sizeof(tmpStr));
			printf("acs=%s | %s\n", tmpStr, strData);
			if (strcmp(tmpStr, strData))
			{
				mib_set(CWMP_ACS_URL_OLD, (void *)tmpStr);
			}

/*star:20100305 START add qos rule to set tr069 packets to the first priority queue*/
			storeOldACS();
/*star:20100305 END*/

			if (!mib_set(CWMP_ACS_URL, strData)) {
				//strcpy(tmpBuf,strSetACSURLerror);
				snprintf(tmpBuf, sizeof(tmpBuf), "%s", strSetACSURLerror);
				goto setErr_tr069;
			}
#ifdef CONFIG_TR142_MODULE
			else
			{
				unsigned char dynamic_acs_url_selection = 0;
				mib_get_s(CWMP_DYNAMIC_ACS_URL_SELECTION, &dynamic_acs_url_selection, sizeof(dynamic_acs_url_selection));
				if (dynamic_acs_url_selection)
				{
					unsigned char from = CWMP_ACS_FROM_MIB;
		
					mib_set(RS_CWMP_USED_ACS_URL, (void *)strData);
					mib_set(RS_CWMP_USED_ACS_FROM, (void *)&from);
				}
			}
#endif
			if(strData[0])
				len += snprintf(tmplogBuf+len, sizeof(tmplogBuf)-len, ", acs: %s", strData);

			restart_dnsrelay_ex("all", 0);
		}

		strData = boaGetVar(wp,"acsUser","");
		if (!mib_set(CWMP_ACS_USERNAME, strData)) {
			//strcpy(tmpBuf,strSetUserNameerror);
			snprintf(tmpBuf, sizeof(tmpBuf), "%s", strSetUserNameerror);
			goto setErr_tr069;
		}

		len += snprintf(tmplogBuf+len, sizeof(tmplogBuf)-len, ", acsUser: %s", strData);

		strData = boaGetVar(wp,"acsPwd","");
#ifdef CONFIG_CU
		if(strData[0]){
			memset(acspwd, 0, sizeof(acspwd));
			rtk_util_data_base64decode(strData, acspwd, sizeof(acspwd)-1);
			acspwd[sizeof(acspwd)-1] = '\0';
			strData = acspwd;
		}
#endif
		if (!mib_set(CWMP_ACS_PASSWORD, strData)) {
			strcpy(tmpBuf,strSetPasserror);
			goto setErr_tr069;
		}

		//len += snprintf(tmplogBuf+len, sizeof(tmplogBuf)-len, ", acsPwd: %s", strData);

		strData = boaGetVar(wp,"connReqUser","");
		//if (strData[0])
		{
			if (!mib_set( CWMP_CONREQ_USERNAME, strData)) {
				strcpy(tmpBuf,strSetConReqUsererror);
				goto setErr_tr069;
			}
		}

#ifdef CONFIG_CMCC_ENTERPRISE
		strData = boaGetVar(wp,"ShowSoap","");
		if (strData[0])
		{
			unsigned int enable=0, flag2=0;

			enable = (strData[0] == '0') ? 0 : 1;
			mib_get_s(CWMP_FLAG2, (void *)&flag2, sizeof(flag2));
			if(enable)
				flag2 |= CWMP_FLAG2_CWMP_PRINT_PACKET;
			else
				flag2 &= ~CWMP_FLAG2_CWMP_PRINT_PACKET;
			if (!mib_set( CWMP_FLAG2, (void *)&flag2)){
				strcpy(tmpBuf,strSetShowSoaperror);
				goto setErr_tr069;
			}
		}

		strData = boaGetVar(wp,"DisConReq","");
		if (strData[0])
		{
			unsigned int enable=0, flag2=0;

			enable = (strData[0] == '0') ? 0 : 1;
			mib_get_s(CWMP_FLAG2, (void *)&flag2, sizeof(flag2));
			if(enable!=(flag2&1))
			{
				if(enable)
					flag2 |= CWMP_FLAG2_DIS_CONREQ_AUTH;
				else
					flag2 &= ~CWMP_FLAG2_DIS_CONREQ_AUTH;
				if (!mib_set( CWMP_FLAG2, (void *)&flag2)){
					strcpy(tmpBuf,strSetConReqAutherror);
					goto setErr_tr069;
				}
				changeflag = 1;
			}
		}
#endif

		len += snprintf(tmplogBuf+len, sizeof(tmplogBuf)-len, ", connReqUser: %s", strData);

		strData = boaGetVar(wp,"connReqPwd","");
#ifdef CONFIG_CU
		if(strData[0]){
			memset(creqpwd, 0, sizeof(creqpwd));
			rtk_util_data_base64decode(strData, creqpwd, sizeof(creqpwd)-1);
			creqpwd[sizeof(creqpwd)-1] = '\0';
			strData = creqpwd;
		}
#endif
		//if (strData[0])
		{
			if (!mib_set(CWMP_CONREQ_PASSWORD, (void *)strData)) {
				strcpy(tmpBuf,strSetConReqPasserror);
				goto setErr_tr069;
			}
		}

		strData = boaGetVar(wp, "conreqpath", "");
		if ( strData[0] )
		{
			if(!strstr(strData,"/") || strContainXSSChar(strData))
			{
				strcpy(tmpBuf, multilang(LANG_SET_CONNECTION_REQUEST_PATH_ERROR));
				goto setErr_tr069;
			}
			mib_get_s( CWMP_CONREQ_PATH, (void *)tmpStr, sizeof(tmpStr));
			if (strcmp(tmpStr,strData)!=0){
				changeflag = 1;
				if ( !mib_set( CWMP_CONREQ_PATH, (void *)strData)) {
				    strcpy(tmpBuf, multilang(LANG_SET_CONNECTION_REQUEST_PATH_ERROR));
				    goto setErr_tr069;
				}
			}
    	}

		strData = boaGetVar(wp, "conreqport", "");
		if ( strData[0] ) {
			int cur_conreq_port = atoi(strData);
			int vInt = 0;
			mib_get_s( CWMP_CONREQ_PORT, (void *)&vInt, sizeof(vInt));
			if ( vInt != cur_conreq_port ) {
				changeflag = 1;
				if ( !mib_set( CWMP_CONREQ_PORT, (void *)&cur_conreq_port)) {
				    strcpy(tmpBuf, multilang(LANG_SET_CONNECTION_REQUEST_PORT_ERROR));
				    goto setErr_tr069;
				}
			}
		}

		//len += snprintf(tmplogBuf+len, sizeof(tmplogBuf)-len, ", connReqPwd: %s", strData);

		strData = boaGetVar(wp,"certauth","");
		if (strData[0]) {
			if (mib_get_s(CWMP_FLAG, &cwmp_flag, sizeof(cwmp_flag))) {
				vChar = cwmp_flag;
				if (strData[0] == '0')
					cwmp_flag &= ~CWMP_FLAG_CERT_AUTH;
				else
					cwmp_flag |= CWMP_FLAG_CERT_AUTH;

				if(vChar != cwmp_flag)
				{
					changeflag = 1;
					if (!mib_set(CWMP_FLAG, &cwmp_flag)) {
						strcpy(tmpBuf,strSetCWMPFlagerror);
						goto setErr_tr069;
					}
				}
			} else {
				strcpy(tmpBuf,strGetCWMPFlagerror);
				goto setErr_tr069;
			}
			len += snprintf(tmplogBuf+len, sizeof(tmplogBuf)-len, ", certauth: %s", strData);
		}

#if defined(CONFIG_CMCC) || defined(CONFIG_CU_BASEON_CMCC)
		strData = boaGetVar(wp,"passauth","");
		if (strData[0]) {
			gui_passauth_enable = (strData[0] == '0') ? 0 : 1;

			if (!mib_set(CWMP_GUI_PASSWORD_ENABLE, &gui_passauth_enable)) {
				strcpy(tmpBuf, "设定CPE password auth启用失败!");
				goto setErr_tr069;
			}
		}

		unlink(CA_STATUS_FILE);

		mib_get_s( CWMP_FLAG, (void *)&vChar, sizeof(vChar));
		if( !access("/var/config/cacert.pem", F_OK ) && (vChar & CWMP_FLAG_CERT_AUTH) )
		{
		snprintf(tmpBuf, 32, "%s%s", "echo 3 > ", CA_STATUS_FILE);
		system(tmpBuf);
		}
#endif
#ifdef CONFIG_USER_TR111_STUN
		strData = boaGetVar(wp, "stun_enable", "");
		if ( strData[0] ) {
			stunEnable = (strData[0]=='0')? 0:1;

			mib_get_s( TR111_STUNENABLE, (void*)&vChar, sizeof(vChar));
			if(vChar != stunEnable){

				if (stunEnable == 0)
				{
					if ( !mib_set( TR111_NATDETECTED, (void *)&stunEnable) ) {
						strcpy(tmpBuf, strSetStunNatdetectederror);
						goto setErr_tr069;
					}
				}

				if ( !mib_set( TR111_STUNENABLE, (void *)&stunEnable)) {
					strcpy(tmpBuf, strSetStunEnableerror);
					goto setErr_tr069;
				}
			}
		}

		strData = boaGetVar(wp, "stunsvraddr", "");
		if(strContainXSSChar(strData))
			goto setErr_tr069;
		if ( strData[0]) {
			mib_get_s( TR111_STUNSERVERADDR, (void *)tmpStr, sizeof(tmpStr));
			if (strcmp(tmpStr,strData)!=0){
				if ( !mib_set( TR111_STUNSERVERADDR, (void *)strData)) {
					strcpy(tmpBuf, "Set STUN Server Address error!");
					goto setErr_tr069;
				}
			}
		}

		strData = boaGetVar(wp, "stunsvrport", "");
		if ( strData[0] ) {
			cur_port = atoi(strData);
			mib_get_s( TR111_STUNSERVERPORT, (void *)&srvPort, sizeof(srvPort));
			if ( srvPort != cur_port ) {
				if ( !mib_set( TR111_STUNSERVERPORT, (void *)&cur_port)) {
					strcpy(tmpBuf, "Set STUN server Port error!");
					goto setErr_tr069;
				}
			}
		}

		strData = boaGetVar(wp, "stunsvruname", "");
		if ( strData[0]) {
			mib_get_s( TR111_STUNUSERNAME, (void *)tmpStr, sizeof(tmpStr));
			if (strcmp(tmpStr,strData)!=0){
				if ( !mib_set( TR111_STUNUSERNAME, (void *)strData)) {
					strcpy(tmpBuf, "Set STUN Server User Name error!");
					goto setErr_tr069;
				}
			}
		}

		strData = boaGetVar(wp, "stunsvrupasswd", "");
		if ( strData[0]) {
			mib_get_s( TR111_STUNPASSWORD, (void *)tmpStr, sizeof(tmpStr));
			if (strcmp(tmpStr,strData)!=0){
				if ( !mib_set( TR111_STUNPASSWORD, (void *)strData)) {
					strcpy(tmpBuf, "Set STUN Server Password error!");
					goto setErr_tr069;
				}
			}
		}
#endif
		syslog(LOG_INFO, "Tr069Config: Apply %s", tmplogBuf);
	}	//end if applyTr069Config

#ifdef _CWMP_WITH_SSL_
end_tr069:
#endif
	// Mason Yu
	//reset tr069 conreq-port/acl in mangle table
	restart_cwmp_acl();
#ifdef APPLY_CHANGE
	
	if(changeflag == 1){
		if(cwmp_flag || (old_informEnable != informEnble)) 
		{
			off_tr069();
			sleep(3);

			if (-1 == startCWMP()) {
				strcpy(tmpBuf,"Start tr069 Fail *****");
				printf("Start tr069 Fail *****\n");
				goto setErr_tr069;
			}
		}
		else// disable TR069
		{  
			off_tr069();
		} 
	}
#endif	//end of APPLY_CHANGE

// Magician: Commit immediately
#ifdef COMMIT_IMMEDIATELY
	Commit();
#endif

#if 0
	SetTR069WANInterface();
#endif

	strData = boaGetVar(wp,"submit-url","");
#if defined(CONFIG_CMCC) || defined(CONFIG_CU_BASEON_CMCC)
	boaRedirect(wp, strData);
#else
	RECONNECT_MSG(strData);// display reconnect msg to remote
#endif

	return;

setErr_tr069:
	ERR_MSG(tmpBuf);
}

void formTR069CPECert(request *wp, char *path, char *query)
{
	char	*strData;
	char tmpBuf[100];
	FILE	*fp=NULL,*fp_input;
	unsigned char *buf;
	unsigned int startPos,endPos,nLen,nRead;
	char cmd[64] = {0};

	if ((fp = uploadGetCert(wp, &startPos, &endPos)) == NULL)
	{
		//strcpy(tmpBuf,strUploaderror);
		snprintf(tmpBuf, sizeof(tmpBuf), "%s", strUploaderror);
 		goto setErr_tr069cpe;
 	}

	nLen = endPos - startPos;
	//printf("filesize is %d\n", nLen);
	buf = malloc(nLen+1);
	if (!buf)
	{
		//strcpy(tmpBuf,strMallocFail);
		snprintf(tmpBuf, sizeof(tmpBuf), "%s", strMallocFail);
 		goto setErr_tr069cpe;
 	}

	if(fseek(fp, startPos, SEEK_SET))
		printf("%s %d fseek fail\n", __func__, __LINE__);
	nRead = fread((void *)buf, 1, nLen, fp);
	buf[nRead]=0;
	if (nRead != nLen)
 		printf("Read %d bytes, expect %d bytes\n", nRead, nLen);

	//printf("write to %d bytes from %08x\n", nLen, buf);

	fp_input=fopen(CERT_FNAME,"w");
	if (!fp_input)
		printf("create %s file fail!\n", CERT_FNAME);
	else{
		fprintf(fp_input,buf);
		printf("create file %s\n", CERT_FNAME);
		fclose(fp_input);
	}
	free(buf);

#ifdef CONFIG_USER_FLATFSD_XXX
	if( va_niced_cmd( "/bin/flatfsd",1,1,"-s" ) )
		printf( "[%d]:exec 'flatfsd -s' error!",__FILE__ );
#endif

	off_tr069();

	if (startCWMP() == -1)
	{
		strcpy(tmpBuf,"Start tr069 Fail *****");
		printf("Start tr069 Fail *****\n");
		goto setErr_tr069cpe;
	}

#if defined(CONFIG_CMCC) || defined(CONFIG_CU_BASEON_CMCC)
	snprintf(cmd, 32, "%s%s", "echo 0 > ", CERT_STATUS_FILE);
	system(cmd);
#endif

#ifdef CONFIG_CMCC_ENTERPRISE
	boaRedirect(wp, "/tr069.asp");
#else
	strData = boaGetVar(wp,"submit-url","/net_tr069.asp");
	UPLOAD_MSG(strData);// display reconnect msg to remote
#endif
	if(fp)
		fclose(fp);
	return;

setErr_tr069cpe:
#if defined(CONFIG_CMCC) || defined(CONFIG_CU_BASEON_CMCC)
	snprintf(cmd, 32, "%s%s", "echo 1 > ", CERT_STATUS_FILE);
	system(cmd);
#endif

	if(fp)
		fclose(fp);
	ERR_MSG(tmpBuf);
}

void formTR069CACert(request *wp, char *path, char *query)
{
	char	*strData;
	char	tmpBuf[128];
	FILE	*fp=NULL,*fp1=NULL,*fp_input;
	unsigned char *buf;
	unsigned int startPos,endPos,nLen,nRead;
#if defined(CONFIG_CMCC) || defined(CONFIG_CU_BASEON_CMCC)
	char cmd[32] = {0};
	unsigned char vChar;

	if (!mib_get_s( CWMP_FLAG, (void *)&vChar, sizeof(vChar)))
		printf("Get MIB failed...\n");

	if ((vChar & CWMP_FLAG_CERT_AUTH)==0)
	{
		snprintf(cmd, 32, "%s%s", "echo 2 > ", CA_STATUS_FILE);
		system(cmd);
		goto tr069ca_disabled;
	}else
	{
		snprintf(cmd, 32, "%s%s", "echo 3 > ", CA_STATUS_FILE);
		system(cmd);
	}
	
	fp1 = fopen(CA_FNAME, "r");
	if (!fp1) 
	{
		snprintf(cmd, 32, "%s%s", "echo 4 > ", CA_STATUS_FILE);
		system(cmd);
	}
#endif

	if ((fp = uploadGetCert(wp, &startPos, &endPos)) == NULL)
	{
		//strcpy(tmpBuf,strUploaderror);
		snprintf(tmpBuf, sizeof(tmpBuf), "%s", strUploaderror);
 		goto setErr_tr069ca;
 	}

	nLen = endPos - startPos;
#if defined(CONFIG_CMCC) || defined(CONFIG_CU_BASEON_CMCC)
	if(nLen > 2000)
	{
		snprintf(cmd, 32, "%s%s", "echo 5 > ", CA_STATUS_FILE);
		system(cmd);
		goto tr069ca_disabled;
	}
#endif
	//printf("filesize is %d\n", nLen);
	buf = malloc(nLen+1);
	if (!buf)
	{
		//strcpy(tmpBuf,strMallocFail);
		snprintf(tmpBuf, sizeof(tmpBuf), "%s", strMallocFail);
 		goto setErr_tr069ca;
 	}

	if(fseek(fp, startPos, SEEK_SET))
		printf("%s %d fseek fail\n", __func__, __LINE__);
	nRead = fread((void *)buf, 1, nLen, fp);
	buf[nRead]=0;
	if (nRead != nLen)
 		printf("Read %d bytes, expect %d bytes\n", nRead, nLen);

	//printf("write to %d bytes from %08x\n", nLen, buf);

	fp_input=fopen(CA_FNAME,"w");
	if (!fp_input)
		printf("create %s file fail!\n", CA_FNAME );
	else{
		fprintf(fp_input,buf);
		printf("create file %s\n",CA_FNAME);
		fclose(fp_input);
	}
	free(buf);

#ifdef CONFIG_USER_FLATFSD_XXX
	if( va_niced_cmd( "/bin/flatfsd",1,1,"-s" ) )
		printf( "[%d]:exec 'flatfsd -s' error!",__FILE__ );
#endif

	off_tr069();

	if (startCWMP() == -1)
	{
		strcpy(tmpBuf,"Start tr069 Fail *****");
		printf("Start tr069 Fail *****\n");
		goto setErr_tr069ca;
	}

#if defined(CONFIG_CMCC) || defined(CONFIG_CU_BASEON_CMCC)
	snprintf(cmd, 32, "%s%s", "echo 0 > ", CA_STATUS_FILE);
	system(cmd);
tr069ca_disabled:
#if defined(CONFIG_CMCC_ENTERPRISE)
		boaRedirect(wp, "/tr069.asp");
#elif defined(CONFIG_USER_TR111_STUN)
	boaRedirect(wp, "/net_tr069_stun_cmcc.asp");
#else 
	boaRedirect(wp, "/net_tr069_cmcc.asp");
#endif
	if(fp1)
	{
		fclose(fp1);
		fp1 = NULL;
	}
#else // not CMCC/CU
	strData = boaGetVar(wp,"submit-url","/net_certca.asp");
	UPLOAD_MSG(strData);// display reconnect msg to remote
#endif
	if(fp)
	{
		fclose(fp);
		fp  = NULL;
	}
	return;

setErr_tr069ca:
#if defined(CONFIG_CMCC) || defined(CONFIG_CU_BASEON_CMCC)
#if defined(CONFIG_CMCC_ENTERPRISE)
			boaRedirect(wp, "/tr069.asp");
#elif defined(CONFIG_USER_TR111_STUN)
		boaRedirect(wp, "/net_tr069_stun_cmcc.asp");
#else 
		boaRedirect(wp, "/net_tr069_cmcc.asp");
#endif
	if(fp1)
	{
		fclose(fp1);
		fp1 = NULL;
	}
#else
	ERR_MSG(tmpBuf);
#endif
	if(fp)
	{
		fclose(fp);
		fp = NULL;
	}
	return;
}


void formTR069CACertDel(request *wp, char *path, char *query)
{
	char	*strData;
	char tmpBuf[100];
	FILE	*fp=NULL,*fp_input;
	unsigned char *buf;
	unsigned int startPos,endPos,nLen,nRead;

	unlink(CA_FNAME);

#ifdef CONFIG_USER_FLATFSD_XXX
	if( va_niced_cmd( "/bin/flatfsd",1,1,"-s" ) )
		printf( "[%d]:exec 'flatfsd -s' error!",__FILE__ );
#endif

	off_tr069();

	if (startCWMP() == -1)
	{
		strcpy(tmpBuf,"Start tr069 Fail *****");
		printf("Start tr069 Fail *****\n");
		goto setErr_tr069ca;
	}

	strData = boaGetVar(wp,"submit-url","/net_certca.asp");
	DEL_MSG(strData);// display reconnect msg to remote
	return;

setErr_tr069ca:
	ERR_MSG(tmpBuf);
}

void formMidwareConfig(request *wp, char *path, char *query)
{
	//We have no midleware currently.
	_COND_REDIRECT;
}

/*******************************************************/
/*show extra fileds at net_tr069.asp*/
/*******************************************************/
#ifdef _CWMP_WITH_SSL_
int ShowACSCertCPE(request *wp)
{
	int nBytesSent=0;
	unsigned char vChar=0;
	int isEnable=0;

	if ( mib_get_s( CWMP_FLAG, (void *)&vChar, sizeof(vChar)) )
		if ( (vChar & CWMP_FLAG_CERT_AUTH)!=0 )
			isEnable=1;

	nBytesSent += boaWrite(wp,"  <tr>\n");
	nBytesSent += boaWrite(wp,"      <td width=\"30%%\"><font size=2><b>ACS Certificates CPE:</b></td>\n");
	nBytesSent += boaWrite(wp,"      <td width=\"70%%\"><font size=2>\n");
	nBytesSent += boaWrite(wp,"      <input type=\"radio\" name=certauth value=0 %s >No&nbsp;&nbsp;\n", isEnable==0?"checked":"" );
	nBytesSent += boaWrite(wp,"      <input type=\"radio\" name=certauth value=1 %s >Yes\n", isEnable==1?"checked":"" );
	nBytesSent += boaWrite(wp,"      </td>\n");
	nBytesSent += boaWrite(wp,"  </tr>\n");

//		"\n"), isEnable==0?"checked":"", isEnable==1?"checked":"" );

	return nBytesSent;
}

int ShowMNGCertTable(request *wp)
{
	int nBytesSent=0;
	char buffer[256]="";

	getMIB2Str(CWMP_CERT_PASSWORD,buffer);

	nBytesSent += boaWrite(wp, "\n"
		"<table border=0 width=\"500\" cellspacing=4 cellpadding=0>\n"
		"  <tr><hr size=1 noshade align=top></tr>\n"
		"  <tr>\n"
		"      <td width=\"30%%\"><font size=2><b>Certificat Management:</b></td>\n"
		"      <td width=\"70%%\"><b></b></td>\n"
		"  </tr>\n"
		"\n");


	nBytesSent += boaWrite(wp, "\n"
		"  <tr>\n"
		"      <td width=\"30%%\"><font size=2><b>CPE Certificat Password:</b></td>\n"
		"      <td width=\"70%%\">\n"
		"		<form action=/boaform/admin/formTR069Config method=POST name=\"cpe_passwd\">\n"
		"		<input type=\"text\" name=\"certpw\" size=\"24\" maxlength=\"64\" value=\"%s\">\n"
		"		<input type=\"submit\" value=\"Apply\" name=\"CPE_Cert\">\n"
		"		<input type=\"reset\" value=\"Undo\" name=\"reset\">\n"
		"		<input type=\"hidden\" value=\"/net_tr069_sc.asp\" name=\"submit-url\">\n"
		"		</form>\n"
		"      </td>\n"
		"  </tr>\n"
		"\n", buffer);

	nBytesSent += boaWrite(wp, "\n"
		"  <tr>\n"
		"      <td width=\"30%%\"><font size=2><b>CPE Certificat:</b></td>\n"
		"      <td width=\"70%%\"><font size=2>\n"
		"           <form action=/boaform/admin/formTR069CPECert method=POST enctype=\"multipart/form-data\" name=\"cpe_cert\">\n"
		"           <input type=\"file\" name=\"binary\" size=24>&nbsp;&nbsp;\n"
		"           <input type=\"submit\" value=\"Upload\" name=\"load\">\n"
		"           </form>\n"
		"      </td>\n"
		"  </tr>\n"
		"\n");

	nBytesSent += boaWrite(wp, "\n"
		"  <tr>\n"
		"      <td width=\"30%%\"><font size=2><b>CA Certificat:</b></td>\n"
		"      <td width=\"70%%\"><font size=2>\n"
		"           <form action=/boaform/admin/formTR069CACert method=POST enctype=\"multipart/form-data\" name=\"ca_cert\">\n"
		"           <input type=\"file\" name=\"binary\" size=24>&nbsp;&nbsp;\n"
		"           <input type=\"submit\" value=\"Upload\" name=\"load\">\n"
		"           </form>\n"
		"      </td>\n"
		"  </tr>\n"
		"\n");

	nBytesSent += boaWrite(wp, "\n"
		"</table>\n"
		"\n");


	return nBytesSent;
}
#endif

#ifdef _INFORM_EXT_FOR_X_CT_
int ShowCTInformExt(request *wp)
{
	int nBytesSent=0;
	unsigned char vChar=0;
	int isEnable=0;

	if ( mib_get_s( CWMP_FLAG, (void *)&vChar, sizeof(vChar)) )
		if ( (vChar & CWMP_FLAG_CTINFORMEXT)!=0 )
			isEnable=1;

	nBytesSent += boaWrite(wp,"  <tr>\n");
	nBytesSent += boaWrite(wp,"      <td width=\"30%%\"><font size=2><b>CT Inform Extension:</b></td>\n");
	nBytesSent += boaWrite(wp,"      <td width=\"70%%\"><font size=2>\n");
	nBytesSent += boaWrite(wp,"      <input type=\"radio\" name=ctinformext value=0 %s >Disabled&nbsp;&nbsp;\n", isEnable==0?"checked":"" );
	nBytesSent += boaWrite(wp,"      <input type=\"radio\" name=ctinformext value=1 %s >Enabled\n", isEnable==1?"checked":"" );
	nBytesSent += boaWrite(wp,"      </td>\n");
	nBytesSent += boaWrite(wp,"  </tr>\n");

	return nBytesSent;
}
#endif

int TR069ConPageShow(int eid, request *wp, int argc, char **argv)
{
	int nBytesSent=0;
	char *name;

	if (boaArgs(argc, argv,"%s", &name) < 1) {
		boaError(wp, 400,strArgerror);
		return -1;
	}

#ifdef _CWMP_WITH_SSL_
	if ( !strcmp(name,"ShowACSCertCPE") )
		return ShowACSCertCPE( wp );
	else if ( !strcmp(name,"ShowMNGCertTable") )
		return ShowMNGCertTable( wp );
#endif
#ifdef _INFORM_EXT_FOR_X_CT_
	if ( !strcmp(name,"ShowCTInformExt") )
		return ShowCTInformExt( wp );
#endif

	if(!strcmp(name, "cwmp-configurable"))
	{
		unsigned char configurable = 0;
		unsigned int is_backdoor_login = is_backdoor_userlogin(wp);

		mib_get_s(CWMP_CONFIGURABLE, &configurable, sizeof(configurable));
		if(configurable || is_backdoor_login)
			nBytesSent += boaWrite(wp,"1");
		else
			nBytesSent += boaWrite(wp,"0");
	}

	return nBytesSent;
}

int TR069DumpCWMP(int eid, request * wp, int argc, char **argv)
{
	int cwmp_msgid = 0;
	struct stat st;
	struct cwmp_message cwmpmsg = {0};
	FILE *fp = NULL;
	int fd = -1;
	char content;
	unsigned int retrycnt = 0;

	if((cwmp_msgid = msgget((key_t)1234, 0)) > 0 )
	{
		cwmpmsg.msg_type = MSG_PRINT_PRMT; 
		msgsnd(cwmp_msgid, (void *)&cwmpmsg, MSG_SIZE, 0);
	}
	else
	{
		fprintf(stderr, "Can't get cwmp msgQueue!\n");
		return -1;
	}

	do
	{
		sleep(1);
		fp = fopen(CWMP_PRMT_FILE, "r");
		retrycnt++;
	}while (NULL == fp && retrycnt <= 3);
	if (NULL == fp)
	{
		fprintf(stderr, "Open %s failed\n", CWMP_PRMT_FILE);
		return -1;
	}

	fd = fileno(fp);
	if(flock_set(fd, F_RDLCK))
	{
		fprintf(stderr, "flock_set %s failed\n", CWMP_PRMT_FILE);
		fclose(fp);
		return -1;
	}

	while (!feof(fp))
	{
 		if(fscanf(fp, "%c", &content) == -1)
			printf("[%s:%d]fscanf fail\n",__FUNCTION__,__LINE__);
		boaWrite(wp, "%c", content);
	}
	fflush(fp);
	flock_set(fd, F_UNLCK);
	fclose(fp);
	return 0;
}
