/*
 *      Web server handler routines for URL stuffs
 */
#include "options.h"
#ifdef URL_BLOCKING_SUPPORT

/*-- System inlcude files --*/
#include <string.h>
#include <sys/ioctl.h>
#include <sys/time.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <sys/socket.h>
#include <linux/if.h>
#include <net/route.h>

/*-- Local inlcude files --*/
#include "../webs.h"
#include "webform.h"
#include "mib.h"
#include "utility.h"
#include "fmdefs.h"

#define  URL_MAX_ENTRY  500
#define  KEY_MAX_ENTRY  500

void formURL(request * wp, char *path, char *query)
{
#ifndef SUPPORT_URL_FILTER
	unsigned char urlfilterEnble = 0;	// 0-off, 1-on
	unsigned char urlFilterMode = 0;	// 0-black list, 1-white list
	unsigned char urlfilter_mode = 0;
#endif	
	unsigned char urlcap; // 0-off, 1-black list, 2-white list
#ifdef SUPPORT_URL_FILTER
	MIB_CE_URL_FILTER_T entry;
	int act_idx = -1;
#if defined(CONFIG_USER_CTCAPD) && defined(CONFIG_RTK_CTCAPD_FILTER_SUPPORT)
	int add_filter_flag = 0;
#endif
#ifdef SUPPORT_URLFILTER_DNSFILTER_NEW_SPEC	
	int time_set = 0;
	char *tok = NULL, *pSave = NULL;
	char urllist[MAX_URLLIST_LEN+256+1]={0};
	char	*str, *submitUrl, *strVal;
	unsigned char urlfilter_mode=0;
	unsigned char FilterMode = 0;
	mib_get(MIB_URLFILTER_MODE, (void *)&urlfilter_mode);
#endif
#else
	MIB_CE_URL_FQDN_T entry;
#endif
	char*			stemp = "";
	int				lineno = __LINE__;
	_BC_USE;
	int idx;
	int total;
	int ret;

	_TRACE_CALL;

	FETCH_INVALID_OPT(stemp, "action", _NEED);

#ifndef SUPPORT_URL_FILTER
	if(strcmp(stemp, "sw") == 0)	// switch
	{
		_GET_BOOL(urlfilterEnble, _NEED);
		_GET_BOOL(urlFilterMode, _NEED);

		//printf("%s(%d): urlfilterEnble: %d\n", __FUNCTION__, __LINE__, urlfilterEnble);
		//printf("%s(%d): urlFilterMode: %d\n", __FUNCTION__, __LINE__, urlFilterMode);

		if (!urlfilterEnble) {
			urlfilter_mode = 0;			/* Disable */
		}
		else {
			if(urlFilterMode == 1)
				urlfilter_mode = 1;		/* White List */
			else {
				urlfilter_mode = 2;	    /* Black List */
			}
		}
		if(!mib_set(MIB_URLFILTER_MODE, (void *)&urlfilter_mode)) {
			printf("Set URL Mode error!");
			goto check_err;
		}

#if defined(CONFIG_CMCC) || defined(CONFIG_CU_BASEON_CMCC)
		syslog(LOG_CRIT, "URL Filter, %s url filter.", urlfilterEnble? "open": "close");
		if(urlfilterEnble)
			syslog(LOG_CRIT, "URL Filter, mode (%s)", urlFilterMode==1? "whitelist":"blacklist");
#endif
	}
	else if(strcmp(stemp, "md") == 0)	//mode
	{
		_GET_BOOL(urlfilterEnble, _NEED);
		_GET_BOOL(urlFilterMode, _NEED);

		//printf("%s(%d): urlfilterEnble: %d\n", __FUNCTION__, __LINE__, urlfilterEnble);
		//printf("%s(%d): urlFilterMode: %d\n", __FUNCTION__, __LINE__, urlFilterMode);

		if (!urlfilterEnble) {
			urlfilter_mode = 0;			/* Disable */
		}
		else {
			if(urlFilterMode == 0)
				urlfilter_mode = 2;		/* Black List */
			else {
				urlfilter_mode = 1;		/* White List */
			}
		}
		if(!mib_set(MIB_URLFILTER_MODE, (void *)&urlfilter_mode)) {
			printf("Set URL Mode error!");
			goto check_err;
		}

#if defined(CONFIG_CMCC) || defined(CONFIG_CU_BASEON_CMCC)
		syslog(LOG_CRIT, "URL Filter, mode (%s)", urlFilterMode==1? "whitelist":"blacklist");
#endif
	}
#endif	
#ifdef SUPPORT_URL_FILTER
	if(strcmp(stemp, "rm") == 0)	//remove
	{
		MIB_CE_URL_FILTER_T rm_entry;
		FETCH_INVALID_OPT(stemp, "idx", _NEED);
		act_idx = atoi(stemp);

		total = mib_chain_total(MIB_URL_FILTER_TBL);
		if(total > act_idx){
#if defined(CONFIG_USER_CTCAPD) && defined(CONFIG_RTK_CTCAPD_FILTER_SUPPORT)
			add_filter_flag = 1;
			rtk_ctcapd_del_filter_rule_by_ubus(act_idx);
#else
			mib_chain_delete(MIB_URL_FILTER_TBL, act_idx);
#endif
		}
	}
#ifdef SUPPORT_URLFILTER_DNSFILTER_NEW_SPEC		
	else if(strcmp(stemp, "md") == 0)	//mode
	{
		_GET_BOOL(FilterMode, _NEED);

		if(FilterMode == 0)
			urlfilter_mode = 2;		/* Black List */
		else if(FilterMode == 1)
			urlfilter_mode = 1;		/* White List */

		if(!mib_set(MIB_URLFILTER_MODE, (void *)&urlfilter_mode))
		{
			printf("Set URL Mode error!");
			goto check_err;
		}
	}
#endif	
	else if(strcmp(stemp, "ad") == 0)	//add
	{
		MIB_CE_URL_FILTER_T	add_entry;
		/*ql:20080715 START: if url start with http, try to search key after www.*/
		char *pTmp;//point to the string after "http://"
		char urlTmp[MAX_URL_LENGTH];
		/*ql:20080715 END*/

		memset(&entry, 0, sizeof(MIB_CE_URL_FILTER_T));

		_ENTRY_STR(name, _NEED);

		printf("<%s, %d, name=%s>\n", __FUNCTION__, __LINE__, entry.name);
#ifdef SUPPORT_URLFILTER_DNSFILTER_NEW_SPEC	
		FETCH_INVALID_OPT(stemp, "url", _NEED);
		tok = strtok_r(stemp, "; \t\r\n", &pSave);
		if(tok)
			strncpy(entry.url, tok, sizeof(entry.url)-1);
		if(pSave)
			strncpy(entry.urllist, pSave, sizeof(entry.urllist)-1);
#else	
		_ENTRY_STR(url, _NEED);
#endif
		// Check XSS attack
		if(strContainXSSChar(entry.url)){
			printf("%s:%d String %s contains invalid words causing XSS attack!\n",__FUNCTION__,__LINE__,entry.url);
			ERR_MSG("invalid string (XSS attack)!");
			goto check_err;
		}

		if (!strncmp(entry.url, "http://", 7))
			strlcpy(urlTmp, entry.url+7,sizeof(urlTmp));
		else
			strlcpy(urlTmp, entry.url,sizeof(urlTmp));

		pTmp = strtok(urlTmp, ":");

		if (!strncmp(pTmp, "www.", 4)) {
			if (!pTmp[4]) {
				ERR_MSG("请输入正确的URL!");
				goto check_err;
			}
		} else {
			if (!pTmp[0]) {
				ERR_MSG("请输入正确的URL!");
				goto check_err;
			}
		}
		/*ql:20080715 END*/

		_ENTRY_STR(mac, _OPT);
		changeMacFormat(entry.mac,'-',':');
		
		// Check XSS attack
		if(entry.mac[0] !='\0' && !isValidMacString(entry.mac)){
			printf("%s:%d String %s contains invalid words causing XSS attack!\n",__FUNCTION__,__LINE__,entry.mac);
			ERR_MSG("invalid string (XSS attack)!");
			goto check_err;
		}

		FETCH_INVALID_OPT(stemp, "Enable", _NEED);
		entry.Enable = atoi(stemp);
		
		printf("%s %d entry.Enable=%d\n", __FUNCTION__, __LINE__, entry.Enable);

		total = mib_chain_total(MIB_URL_FILTER_TBL);
		for (idx=0; idx<total; idx++)
		{
			if (!mib_chain_get(MIB_URL_FILTER_TBL, idx, (void *)&add_entry)) {
				printf("get URL chain error!\n");
				goto check_err;
			}
			if (!gstrcmp(add_entry.url, entry.url))
			{
				ERR_MSG("规则已存在!");
				goto check_ok;
			}
		}
#ifdef SUPPORT_URLFILTER_DNSFILTER_NEW_SPEC
		FETCH_INVALID_OPT(stemp, "urlFilterMode", _NEED);
		entry.mode = atoi(stemp);
		if (urlfilter_mode == 2)		/* Black List */
			FilterMode = 0;
		else if(urlfilter_mode == 1)
			FilterMode = 1;			/* White List */

		if(FilterMode != entry.mode)
		{
			printf("only add the same mode as the global urlfilter mode !\n");
			goto Mode_Invalid;
		}
		
		FETCH_INVALID_OPT(stemp, "day", _OPT);
		entry.WeekDays = atoi(stemp);

		FETCH_INVALID_OPT(stemp, "startHour", _OPT);
		entry.start_hr1 = atoi(stemp);

		FETCH_INVALID_OPT(stemp, "startMin", _OPT);
		entry.start_min1 = atoi(stemp);

		FETCH_INVALID_OPT(stemp, "endHour", _OPT);
		entry.end_hr1 = atoi(stemp);
		if(strlen(stemp))
			time_set = 1;

		FETCH_INVALID_OPT(stemp, "endMin", _OPT);
		entry.end_min1 = atoi(stemp);

		if(time_set && (entry.end_hr1 == 0) && (entry.end_min1 == 0))
		{
			entry.end_hr1 = 23;
			entry.end_min1 = 59;
		}

		FETCH_INVALID_OPT(stemp, "SecondstartHour", _OPT);
		entry.start_hr2 = atoi(stemp);

		FETCH_INVALID_OPT(stemp, "SecondstartMin", _OPT);
		entry.start_min2 = atoi(stemp);

		FETCH_INVALID_OPT(stemp, "SecondendHour", _OPT);
		entry.end_hr2 = atoi(stemp);

		FETCH_INVALID_OPT(stemp, "SecondendMin", _OPT);
		entry.end_min2 = atoi(stemp);

		FETCH_INVALID_OPT(stemp, "ThirdstartHour", _OPT);
		entry.start_hr3 = atoi(stemp);

		FETCH_INVALID_OPT(stemp, "ThirdstartMin", _OPT);
		entry.start_min3 = atoi(stemp);

		FETCH_INVALID_OPT(stemp, "ThirdendHour", _OPT);
		entry.end_hr3 = atoi(stemp);

		FETCH_INVALID_OPT(stemp, "ThirdendMin", _OPT);
		entry.end_min3 = atoi(stemp);

		if(!IsVaildFilterTime(entry.start_hr1, entry.start_min1, entry.end_hr1, entry.end_min1, entry.start_hr2, entry.start_min2, entry.end_hr2, entry.end_min2) || 
			!IsVaildFilterTime(entry.start_hr1, entry.start_min1, entry.end_hr1, entry.end_min1, entry.start_hr3, entry.start_min3, entry.end_hr3, entry.end_min3) ||
			!IsVaildFilterTime(entry.start_hr2, entry.start_min2, entry.end_hr2, entry.end_min2, entry.start_hr3, entry.start_min3, entry.end_hr3, entry.end_min3))
		{
			goto Time_Invalid;
		}
#endif	
#if defined(CONFIG_USER_CTCAPD) && defined(CONFIG_RTK_CTCAPD_FILTER_SUPPORT)
		add_filter_flag = 1;
		ret = rtk_ctcapd_set_filter_rule_by_ubus(&entry,ADD_UBUS_FILTER);
		if( ret == -1 ){
			printf("add URL filter rule by ubus error!\n");
			goto check_err;
		}
#else
		ret = mib_chain_add(MIB_URL_FILTER_TBL, (void *)&entry);
		
		if( ret == -1 ){
			printf("Max number of rules reached!");
			goto Max_Size_Reached;
		}
		else if( ret == 0 ){
			printf("add URL chain error!\n");
			goto check_err;
		}
#endif
	}
	else if(strcmp(stemp, "modify") == 0)	//modify
	{
		/*ql:20080715 START: if url start with http, try to search key after www.*/
		char *pTmp;//point to the string after "http://"
		char urlTmp[MAX_URL_LENGTH];
		/*ql:20080715 END*/

		FETCH_INVALID_OPT(stemp, "idx", _NEED);
		act_idx = atoi(stemp);
		
		if (!mib_chain_get(MIB_URL_FILTER_TBL, act_idx, (void *)&entry)) {
			ERR_MSG("Error modify !");
			goto check_err;
		}

		_ENTRY_STR(name, _NEED);

		printf("<%s, %d, name=%s>\n", __FUNCTION__, __LINE__, entry.name);
#ifdef SUPPORT_URLFILTER_DNSFILTER_NEW_SPEC	
		FETCH_INVALID_OPT(stemp, "url", _NEED);
		strncpy(urllist, stemp, sizeof(urllist)-1);
		tok = strtok_r(stemp, "; \t\r\n", &pSave);
		if(tok)
			strncpy(entry.url, tok, sizeof(entry.url)-1);
		if(pSave)
			strncpy(entry.urllist, pSave, sizeof(entry.urllist)-1);
#else	
		_ENTRY_STR(url, _NEED);
#endif
		// Check XSS attack
		if(strContainXSSChar(entry.url)){
			printf("%s:%d String %s contains invalid words causing XSS attack!\n",__FUNCTION__,__LINE__,entry.url);
			ERR_MSG("invalid string (XSS attack)!");
			goto check_err;
		}

		if (!strncmp(entry.url, "http://", 7))
			strcpy(urlTmp, entry.url+7);
		else
			strcpy(urlTmp, entry.url);

		pTmp = strtok(urlTmp, ":");

		if (!strncmp(pTmp, "www.", 4)) {
			if (!pTmp[4]) {
				ERR_MSG("请输入正确的URL!");
				goto check_err;
			}
		} else {
			if (!pTmp[0]) {
				ERR_MSG("请输入正确的URL!");
				goto check_err;
			}
		}
		/*ql:20080715 END*/

		_ENTRY_STR(mac, _OPT);
		changeMacFormat(entry.mac,'-',':');
		// Check XSS attack
		if(entry.mac[0] !='\0' && !isValidMacString(entry.mac)){
			printf("%s:%d String %s contains invalid words causing XSS attack!\n",__FUNCTION__,__LINE__,entry.mac);
			ERR_MSG("invalid string (XSS attack)!");
			goto check_err;
		}

		FETCH_INVALID_OPT(stemp, "Enable", _NEED);
		entry.Enable = atoi(stemp);

#ifdef SUPPORT_URLFILTER_DNSFILTER_NEW_SPEC
		FETCH_INVALID_OPT(stemp, "urlFilterMode", _NEED);
		entry.mode = atoi(stemp);
		if (urlfilter_mode == 2)		/* Black List */
			FilterMode = 0;
		else if(urlfilter_mode == 1)
			FilterMode = 1;			/* White List */
		if(FilterMode != entry.mode)
		{
			printf("only add the same mode as the global urlfilter mode !\n");
			goto Mode_Invalid;
		}

		FETCH_INVALID_OPT(stemp, "day", _OPT);
		entry.WeekDays = atoi(stemp);

		FETCH_INVALID_OPT(stemp, "startHour", _OPT);
		entry.start_hr1 = atoi(stemp);

		FETCH_INVALID_OPT(stemp, "startMin", _OPT);
		entry.start_min1 = atoi(stemp);

		FETCH_INVALID_OPT(stemp, "endHour", _OPT);
		entry.end_hr1 = atoi(stemp);
		if(strlen(stemp))
			time_set = 1;

		FETCH_INVALID_OPT(stemp, "endMin", _OPT);
		entry.end_min1 = atoi(stemp);

		if(time_set && (entry.end_hr1 == 0) && (entry.end_min1 == 0))
		{
			entry.end_hr1 = 23;
			entry.end_min1 = 59;
		}

		FETCH_INVALID_OPT(stemp, "SecondstartHour", _OPT);
		entry.start_hr2 = atoi(stemp);

		FETCH_INVALID_OPT(stemp, "SecondstartMin", _OPT);
		entry.start_min2 = atoi(stemp);

		FETCH_INVALID_OPT(stemp, "SecondendHour", _OPT);
		entry.end_hr2 = atoi(stemp);

		FETCH_INVALID_OPT(stemp, "SecondendMin", _OPT);
		entry.end_min2 = atoi(stemp);

		FETCH_INVALID_OPT(stemp, "ThirdstartHour", _OPT);
		entry.start_hr3 = atoi(stemp);

		FETCH_INVALID_OPT(stemp, "ThirdstartMin", _OPT);
		entry.start_min3 = atoi(stemp);

		FETCH_INVALID_OPT(stemp, "ThirdendHour", _OPT);
		entry.end_hr3 = atoi(stemp);

		FETCH_INVALID_OPT(stemp, "ThirdendMin", _OPT);
		entry.end_min3 = atoi(stemp);

		if(!IsVaildFilterTime(entry.start_hr1, entry.start_min1, entry.end_hr1, entry.end_min1, entry.start_hr2, entry.start_min2, entry.end_hr2, entry.end_min2) || 
			!IsVaildFilterTime(entry.start_hr1, entry.start_min1, entry.end_hr1, entry.end_min1, entry.start_hr3, entry.start_min3, entry.end_hr3, entry.end_min3) ||
			!IsVaildFilterTime(entry.start_hr2, entry.start_min2, entry.end_hr2, entry.end_min2, entry.start_hr3, entry.start_min3, entry.end_hr3, entry.end_min3))
		{
			goto Time_Invalid;
		}
#endif		

		{
#if defined(CONFIG_USER_CTCAPD) && defined(CONFIG_RTK_CTCAPD_FILTER_SUPPORT)
			add_filter_flag = 1;
			entry.index = act_idx;
			ret = rtk_ctcapd_set_filter_rule_by_ubus(&entry, MODIFY_UBUS_FILTER);
			if( ret == -1 ){
				printf("modify URL filter rule by ubus error!\n");
				goto check_err;
			}
#else
			mib_chain_update(MIB_URL_FILTER_TBL, (void*)&entry, act_idx);
#endif
		}

	}
#else
	else if(strcmp(stemp, "rm") == 0)	//remove
	{
		MIB_CE_URL_FQDN_T	rm_entry;
		int del_rule_num = 0;

		_BC_INIT("bcdata");
		while(_BC_NEXT())
		{
			_BC_ENTRY_INTX(idx, _NEED);
			fprintf(stderr, "[Koala] idx=%d, del_rule_num=%d\n", idx, del_rule_num);
			/************Place your code here, do what you want to do! ************/
#if defined(CONFIG_CMCC) || defined(CONFIG_CU_BASEON_CMCC)
			if(mib_chain_get(MIB_URL_FQDN_TBL, idx - del_rule_num, (void *)&rm_entry)==1)
				syslog(LOG_CRIT, "URL Filter, delete url %s", rm_entry.fqdn);		
#endif
			//delete from chain record
			if (mib_chain_delete(MIB_URL_FQDN_TBL, idx - del_rule_num) != 1)
			{
				printf("Delete URL chain record error!");
				goto check_err;
			}
			del_rule_num++;
			/*
			total = mib_chain_total(MIB_URL_FQDN_TBL);
			for(idx = 0; idx < total; idx++)
			{
				if (!mib_chain_get(MIB_URL_FQDN_TBL, idx, (void *)&rm_entry)) {
					printf("get URL chain error!\n");
					goto check_err;
				}

				if (!gstrcmp(entry.url, rm_entry.url))
				{
					//delete from chain record
					if (mib_chain_delete(MIB_URL_FQDN_TBL, idx) != 1)
					{
						printf("Delete URL chain record error!");
						goto check_err;
					}
					printf("delete %s\n", entry.url);
					break;
				}
			}
			*/
		}
	}
	else if(strcmp(stemp, "ad") == 0)	//add
	{
		MIB_CE_URL_FQDN_T	add_entry;
		/*ql:20080715 START: if url start with http, try to search key after www.*/
		char *pTmp;//point to the string after "http://"
		char urlTmp[MAX_URL_LENGTH];
		/*ql:20080715 END*/
		char url[MAX_URL_LENGTH]={0};

		memset(&entry, 0, sizeof(MIB_CE_URL_FQDN_T));
#if defined(CONFIG_CMCC)||defined(CONFIG_CU_BASEON_CMCC)
		_ENTRY_STR(fqdn, _NEED);
#else
		_GET_STR(url, _NEED);
		if(url[0])
			strncpy(entry.fqdn, url, sizeof(entry.fqdn));
		else{
			lineno = __LINE__; 
			goto check_err;
		}
			
#endif
		// Check XSS attack
		if(strContainXSSChar(entry.fqdn)){
			printf("%s:%d String %s contains invalid words causing XSS attack!\n",__FUNCTION__,__LINE__,entry.fqdn);
			ERR_MSG("invalid string (XSS attack)!");
			goto check_err;
		}

		//_ENTRY_INT(port, _NEED);
		//if(entry.port == 0){lineno = __LINE__; goto check_err;}

		/*ql:20080715 START: if url start with http, try to search key after www.*/
		/*below is original code*/
		//ql_xu: get keyword from url
		/*if (!strncmp(entry.url, "www.", 4)) {
			if (!entry.url[4])
				goto check_err;

			strcpy(entry.key, entry.url + 3);
		} else
			strcpy(entry.key, entry.url);*/
		/*new code*/
		if (!strncmp(entry.fqdn, "http://", 7)){
			//strcpy(urlTmp, entry.fqdn+7);
			urlTmp[sizeof(urlTmp)-1]='\0';
			strncpy(urlTmp, entry.fqdn+7, sizeof(urlTmp)-1);
		}
		else{
			//strcpy(urlTmp, entry.fqdn);
			urlTmp[sizeof(urlTmp)-1]='\0';
			strncpy(urlTmp, entry.fqdn, sizeof(urlTmp)-1);
		}

		pTmp = strtok(urlTmp, ":");

		if (!strncmp(pTmp, "www.", 4)) {
			if (!pTmp[4]) {
				ERR_MSG("请输入正确的URL!");
				goto check_err;
			}

			//strcpy(entry.key, pTmp + 3);
			entry.key[sizeof(entry.key)-1]='\0';
			strncpy(entry.key, pTmp + 3, sizeof(entry.key)-1);
		} else {
			if (!pTmp[0]) {
				ERR_MSG("请输入正确的URL!");
				goto check_err;
			}
			//strcpy(entry.key, pTmp);
			entry.key[sizeof(entry.key)-1]='\0';
			strncpy(entry.key, pTmp, sizeof(entry.key)-1);
		}

		/*ql:20080715 END*/

		printf("url key:%s\n", entry.key);

		pTmp = strtok(NULL, ":");
		if(pTmp == NULL)
			entry.port = 80;
		else
			entry.port = atoi(pTmp);

		printf("url port:%d\n", entry.port);

		total = mib_chain_total(MIB_URL_FQDN_TBL);
		for (idx=0; idx<total; idx++)
		{
			if (!mib_chain_get(MIB_URL_FQDN_TBL, idx, (void *)&add_entry)) {
				printf("get URL chain error!\n");
				goto check_err;
			}
			if (!gstrcmp(add_entry.fqdn, entry.fqdn) && add_entry.port==entry.port)
			{
				ERR_MSG("规则已存在!");
				goto check_ok;
			}
		}
		
		ret = mib_chain_add(MIB_URL_FQDN_TBL, (void *)&entry);
		
		if( ret == -1 ){
			printf("Max number of rules reached!");
			goto Max_Size_Reached;
		}
		else if( ret == 0 ){
			printf("add URL chain error!\n");
			goto check_err;
		}
#if defined(CONFIG_CMCC) || defined(CONFIG_CU_BASEON_CMCC)
		syslog(LOG_CRIT, "URL Filter, add url %s", entry.fqdn);
#endif
	}
#endif
	else {lineno = __LINE__; goto check_err;}

#if defined(CONFIG_USER_CTCAPD) && defined(CONFIG_RTK_CTCAPD_FILTER_SUPPORT)
	if(add_filter_flag == 0)
#endif
	{
		//write to flash
		mib_update(CURRENT_SETTING, CONFIG_MIB_ALL);

		//take effect
		if(!mib_get_s(MIB_URLFILTER_MODE, (void *)&urlfilter_mode, sizeof(urlfilter_mode)))
			goto check_err;

		set_url_filter();
	}

check_ok:
	_COND_REDIRECT;
	_BC_FREE();
	return;

#ifndef CONFIG_RTK_CTCAPD_FILTER_SUPPORT
Max_Size_Reached:
	_BC_FREE();
	_TRACE_LEAVEL;
	ERR_MSG("已达最大规则数上限!"); //Max number of rules reached!
	return;
#endif

#ifdef SUPPORT_URLFILTER_DNSFILTER_NEW_SPEC
Mode_Invalid:
	_BC_FREE();
	_TRACE_LEAVEL;
	ERR_MSG("只能设置跟全局黑白名单一样的模式!"); 
	return;
Time_Invalid:
	_BC_FREE();
	_TRACE_LEAVEL;
	ERR_MSG("时间段设置不正确!"); 
	return; 
#endif	

check_err:
	_BC_FREE();
	_TRACE_LEAVEL;
	return;
}

int initPageURL(int eid, request * wp, int argc, char ** argv)
{
	//unsigned char urlcap; 	//0-disable, 1-black list, 2-white list
	unsigned char urlfilter_mode = 0;
#ifndef SUPPORT_URL_FILTER	
	unsigned char urlfilterEnble = 0, urlFilterMode = 0; // urlFilterMode = 0 for black list, urlFilterMode = 1 for white list.
#endif	
#ifdef SUPPORT_URL_FILTER
	MIB_CE_URL_FILTER_T entry;
	unsigned long long blocktimes = 0;
#if defined(CONFIG_USER_CTCAPD) && defined(CONFIG_RTK_CTCAPD_FILTER_SUPPORT)
	char url_filter_mac[512];
#endif
#else
	MIB_CE_URL_FQDN_T entry;
#endif
#ifdef SUPPORT_URLFILTER_DNSFILTER_NEW_SPEC
	unsigned char FilterMode = 0;
	char timestr[MAX_TIME_LEN+1]={0};
	char urllist[MAX_URLLIST_LEN+256+1]={0};
	char fixurl[(MAX_URLLIST_LEN+256+1)*2]={0};
#else
	char fixurl[100*2]={0};
#endif
	int total = 0;
	int idx = 0;
	int lineno = __LINE__;

	_TRACE_CALL;
	if (!mib_get_s(MIB_URLFILTER_MODE, (void *)&urlfilter_mode, sizeof(urlfilter_mode)))
		return -1;

#ifndef SUPPORT_URL_FILTER
#if 0
	switch(urlcap)
	{
		case 2:
			urlFilterMode = 1;
		case 1:
			urlfilterEnble = 1;
			break;
	}
#endif

	switch(urlfilter_mode){
	case 0:	/* Disable */
		urlfilterEnble = 0;
		urlFilterMode = 0;
		break;
	case 1:	/* White List */
		urlfilterEnble = 1;
		urlFilterMode = 1;
		break;
	case 2: /* Black List */
		urlfilterEnble = 1;
		urlFilterMode = 0;
		break;
	}

	_PUT_BOOL(urlfilterEnble);
	_PUT_BOOL(urlFilterMode);
#endif

#ifdef SUPPORT_URL_FILTER
	switch(urlfilter_mode){
	case 1:	/* White List */
		FilterMode = 1;
		break;
	case 2: /* Black List */
		FilterMode = 0;
		break;
	}

	_PUT_BOOL(FilterMode);

	unsigned char macString[32]={0};
	total = mib_chain_total(MIB_URL_FILTER_TBL);
	for(idx = 0; idx < total; idx++)
	{
		if (!mib_chain_get(MIB_URL_FILTER_TBL, idx, (void *)&entry)) {
			printf("get URL chain error!\n");
			goto check_err;
		}

		memset(macString, 0, 32);
		changeMacToString(entry.mac, macString);
#if defined(CONFIG_USER_CTCAPD) && defined(CONFIG_RTK_CTCAPD_FILTER_SUPPORT)
		memset(url_filter_mac, 0, sizeof(url_filter_mac));
		if(strncmp(entry.mac,"all",3))
			snprintf(url_filter_mac, sizeof(entry.mac), "%s", entry.mac);
#endif

		if(entry.Enable == 0) blocktimes = 0;
		else
			blocktimes = rtk_url_get_iptables_drop_pkt_count(&entry);
#ifdef SUPPORT_URLFILTER_DNSFILTER_NEW_SPEC
		getUrlFilterTime(&entry, timestr);
		if(strlen(entry.urllist))
			sprintf(urllist, "%s;%s", entry.url, entry.urllist);
		else
			strncpy(urllist, entry.url, sizeof(urllist)-1);

		boaWrite (wp, "push(new it_nr(\"%d\""_PTS_XSS _PTS_XSS _PTS_XSS _PTI _PTI _PTI _PTS  _PTI _PTI _PTI _PTI _PTI _PTI _PTI _PTI _PTI _PTI _PTI _PTI"));\n", idx, "name", strValToASP(entry.name),
			"url", fixSpecialChar(fixurl, strValToASP(urllist),sizeof(fixurl)),
#if defined(CONFIG_USER_CTCAPD) && defined(CONFIG_RTK_CTCAPD_FILTER_SUPPORT)
			"mac", strValToASP(url_filter_mac),
#else
			_PME(mac),
#endif
			"Enable", entry.Enable, "urlFilterMode", entry.mode,
			"weekday", entry.WeekDays, "time", timestr,
			"startHour", entry.start_hr1, "startMin", entry.start_min1,
			"endHour", entry.end_hr1, "endMin", entry.end_min1,
			"SecondstartHour", entry.start_hr2, "SecondstartMin", entry.start_min2,
			"SecondendHour", entry.end_hr2, "SecondendMin", entry.end_min2,
			"ThirdstartHour", entry.start_hr3, "ThirdstartMin", entry.start_min3,
			"ThirdendHour", entry.end_hr3, "ThirdendMin", entry.end_min3
			);
#else
		boaWrite (wp, "push(new it_nr(\"%d\""_PTS _PTS _PTS _PTI _PTU"));\n", idx, "name", entry.name,
			"url", fixSpecialChar(fixurl, entry.url,sizeof(fixurl)),
			 _PME(mac),
			"Enable", entry.Enable, "blocktimes", blocktimes);
#endif
	}
#else
	total = mib_chain_total(MIB_URL_FQDN_TBL);
	for(idx = 0; idx < total; idx++)
	{
		if (!mib_chain_get(MIB_URL_FQDN_TBL, idx, (void *)&entry)) {
			printf("get URL chain error!\n");
			goto check_err;
		}

		//boaWrite (wp, "push(new it_nr(\"%d\""_PTS _PTI "));\n", index,  _PME(url), _PME(port));
		//boaWrite (wp, "push(new it_nr(\"%d\""_PTS _PTI "));\n", idx, "url", fixSpecialChar(fixurl, entry.url,sizeof(fixurl)), _PME(port));		
#if defined(CONFIG_CMCC)||defined(CONFIG_CU_BASEON_CMCC)
		boaWrite (wp, "push(new it_nr(\"%d\""_PTS_XSS "));\n", idx, "fqdn", fixSpecialChar(fixurl, strValToASP(entry.fqdn),sizeof(fixurl)));
#else
		boaWrite (wp, "push(new it_nr(\"%d\""_PTS "));\n", idx, "url", fixSpecialChar(fixurl, entry.fqdn,sizeof(fixurl)));
#endif
	}
#endif	

check_err:
	_TRACE_LEAVEL;
	return 0;
}

#ifdef CONFIG_CMCC_ENTERPRISE
#include "cJSON.h"

void url_filter_Form(request * wp, char *path, char *query)
{
	unsigned char urlfltenable = 0;	// 0-off, 1-on
	int urlfltmode = 0;	// 0-black list, 1-white list
	unsigned char urlfilter_mode=0;
	unsigned char urlcap; // 0-off, 1-black list, 2-white list
	MIB_CE_URL_FQDN_T entry;
	char*			stemp = "";
	int				lineno = __LINE__;
	_BC_USE;
	int i;
	int total;
	int ret;
	char *strVal;
	char *submitUrlList = NULL;
	cJSON *	arrayItem = NULL,*object,*item;
	char *pTmp;//point to the string after "http://"
	char urlTmp[MAX_URL_LENGTH];
#ifdef SUPPORT_TIME_SCHEDULE
	int schedIndex = -1;
	char	*str;
	int fd = -1;

	fd = creat(SCHEDULE_NOW_FILE, 0777);
	if(fd >= 0) close(fd);
#endif

	_TRACE_CALL;
	submitUrlList = boaGetVar(wp, "urlfltlist", "");

	_GET_BOOL(urlfltenable, _NEED);

	strVal = boaGetVar(wp, "urlfltmode", "");
	printf("%s:%d urlfltmode %s\n", __FUNCTION__, __LINE__, strVal);
	if (strVal[0])
		urlfltmode = atoi(strVal);

	if(urlfltenable == 1)
	{
		if(urlfltmode == 1)
			urlfltenable = 2;
	}
	if(urlfltenable == 0)
	{
		urlfilter_mode = 0;
	}
	else {
		if (urlfltmode==0)
			urlfilter_mode = 2;		/* Black List */
		else if(urlfltmode == 1)
			urlfilter_mode = 1;		/* White List */
		else
			printf("Set URL Mode error!");
	}
	if(!mib_set(MIB_URLFILTER_MODE, (void *)&urlfilter_mode))
	{
		printf("Set URL FILTER MODE Enable error!");
		goto check_err;
	}

	submitUrlList = boaGetVar(wp, "urlfltlist", "");
	mib_chain_clear(MIB_URL_FQDN_TBL);
	printf("submitUrlList = %s\n",submitUrlList);
	arrayItem = cJSON_Parse(submitUrlList);
	if(arrayItem){
		total = cJSON_GetArraySize(arrayItem);
		printf("cJSON_GetArraySize: total=%d\n",total);

		for(i = 0;i<total;i++)
		{
			memset(&entry, 0, sizeof(MIB_CE_URL_FQDN_T));
			printf("i=%d\n",i);
			object=cJSON_GetArrayItem(arrayItem,i);

			item=cJSON_GetObjectItem(object,"URL");
			if(item!=NULL)
			{
				printf("cJSON_GetObjectItem: type=%d, string is %s\n",item->type,item->string);
				memcpy(entry.fqdn,item->valuestring,strlen(item->valuestring));
				if (!strncmp(entry.fqdn, "http://", 7))
					strcpy(urlTmp, entry.fqdn+7);
				else
					strcpy(urlTmp, entry.fqdn);

				pTmp = strtok(urlTmp, ":");

				if (!strncmp(pTmp, "www.", 4)) {
					if (!pTmp[4]) {
						ERR_MSG("请输入正确的URL!");
						goto check_err;
					}

					strcpy(entry.key, pTmp + 3);
				} else {
					if (!pTmp[0]) {
						ERR_MSG("请输入正确的URL!");
						goto check_err;
					}
					strcpy(entry.key, pTmp);
				}
				printf("url key:%s\n", entry.key);
				pTmp = strtok(NULL, ":");
				if(pTmp == NULL)
					entry.port = 80;
				else
					entry.port = atoi(pTmp);

				printf("url port:%d\n", entry.port);
			}
#ifdef SUPPORT_TIME_SCHEDULE
			item=cJSON_GetObjectItem(object,"ScheduleIdex");
			if(item!=NULL)
			{
				printf("cJSON_GetObjectItem: type=%d\n",item->type);
				schedIndex = atoi(item->valuestring);
				if(schedIndex >=32 || schedIndex < 0)
				{
					printf("url_filter_Form: schedList error!\n" );
					goto check_err;
				}
				printf("[%s %d]schedIndex=%d\n", __func__, __LINE__, schedIndex);
				entry.schedIndex = schedIndex;
			}
#endif
			ret = mib_chain_add(MIB_URL_FQDN_TBL, (void *)&entry);
			if( ret == -1 ){
				printf("Max number of rules reached!");
				goto Max_Size_Reached;
			}
			else if( ret == 0 ){
				printf("add URL chain error!\n");
				goto check_err;
			}

		}
	}

	cJSON_Delete(arrayItem);
	//write to flash
	mib_update(CURRENT_SETTING, CONFIG_MIB_ALL);
	//take effect
	if (urlfilter_mode == 1) /* White List */
		urlcap = 2;
	else if (urlfilter_mode == 2) /* Black List */
		urlcap = 1;
	else
		urlcap = 0;
	filter_set_url(urlcap);
check_ok:
	_COND_REDIRECT;
	_BC_FREE();
	return;

Max_Size_Reached:
	_BC_FREE();
	_TRACE_LEAVEL;
	ERR_MSG("已达最大规则数上限!"); //Max number of rules reached!
	return;

check_err:
	_BC_FREE();
	_TRACE_LEAVEL;
	return;
}

#ifdef SUPPORT_TIME_SCHEDULE
int getScheduleName(unsigned int idx, unsigned char *name)
{
	char vChar;
	MIB_CE_TIME_SCHEDULE_T pEntry;
	if(idx -1 < 0)
		return 0;
	if (mib_chain_get(MIB_TIME_SCHEDULE_TBL, idx-1, (void *)&pEntry))
	{
		 strcpy(name,pEntry.name);
		 return 1;
	}
	return 0;
}
#endif

int initEnterprisePageURL(int eid, request * wp, int argc, char ** argv)
{
	unsigned char urlcap; 	//0-disable, 1-black list, 2-white list
	unsigned char urlfilterEnble = 0, urlFilterMode = 0; // urlFilterMode = 0 for black list, urlFilterMode = 1 for white list.
	MIB_CE_URL_FQDN_T entry;
	char fixurl[100*2]={0};
	int total = 0;
	int idx = 0;
	int lineno = __LINE__;
#ifdef SUPPORT_TIME_SCHEDULE
	unsigned char name[32];
	char scheduleName[256+1]={0};
#endif

	_TRACE_CALL;
	if (!mib_get(MIB_URLFILTER_MODE, (void *)&urlFilterMode))
		return -1;
	printf("urlFilterMode=%d;\n", urlFilterMode);

	switch(urlFilterMode)
	{
		case 2:
			urlfilterEnble = 1;
			urlFilterMode = 0;
			break;
		case 1:
			urlfilterEnble = 1;
			urlFilterMode = 1;
			break;
		case 0:
			urlfilterEnble = 0;
			urlFilterMode = 0;
			break;
		default:
			break;
	}
	printf("urlfilterEnble=%d;\n urlFilterMode=%d;\n",urlfilterEnble, urlFilterMode);

	boaWrite (wp, "UrlFltCfg.UrlFltEnable=%d;\n",urlfilterEnble);
	boaWrite (wp, "UrlFltCfg.UrlFltMode=%d;\n", urlFilterMode);
	boaWrite (wp, "UrlFltCfg.UrlFltList = []\n");

	total = mib_chain_total(MIB_URL_FQDN_TBL);
	for(idx = 0; idx < total; idx++)
	{
		if (!mib_chain_get(MIB_URL_FQDN_TBL, idx, (void *)&entry)) {
			printf("get URL chain error!\n");
			goto check_err;
		}
#ifdef SUPPORT_TIME_SCHEDULE
		getScheduleName(entry.schedIndex, scheduleName);
		boaWrite (wp, "UrlFltCfg.UrlFltList[%d] = {\n URL:\"%s\",\n Urlentrymode:\"%d\",\n Schedule:\"%s\",\n ScheduleIdex:\"%d\"\n };\n", 
		idx,fixSpecialChar(fixurl, entry.fqdn,sizeof(fixurl)),urlFilterMode, entry.schedIndex == 0?multilang(LANG_SCHEDULE_EFFECTIVE):scheduleName,entry.schedIndex);
#else
		boaWrite (wp, "UrlFltCfg.UrlFltList[%d] = {\n URL:\"%s\",\n Urlentrymode:\"%d\"};\n", 
		idx,fixSpecialChar(fixurl, entry.fqdn,sizeof(fixurl)),urlFilterMode);
#endif
	}

check_err:
	_TRACE_LEAVEL;
	return 0;
}

#endif


#endif

