/*
 *      Web server handler routines for vlan passthorugh
 *      Authors:gloria_zhu
 */

/*-- System inlcude files --*/
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <ctype.h>
#include <sys/wait.h>
#include "../webs.h"
#include "webform.h"
#include "mib.h"
#include "utility.h"


/*****************************
** VLAN透传设置
*/

void formVlanPassthrough(request * wp, char *path, char *query)
{
	//使能:
	unsigned char *strVal = NULL;
	unsigned char vlanpass_enable = 0;	//1- 使能;  0- 禁用
	char *submitUrl = NULL;
	unsigned int lastStatus = 0;
	char tmpBuf[100] = {0};

	strVal = boaGetVar(wp, "vlanpass", "");
	if (strVal[0]) {
		if (strVal[0] == '0')
			vlanpass_enable = 0;
		else if(strVal[0] == '1')
			vlanpass_enable = 1;
	}

#if defined(CONFIG_USER_RTK_VLAN_PASSTHROUGH)
#if defined(CONFIG_CMCC)
	if (!mib_get_s(MIB_VLANPASS_ENABLED, (void *)&lastStatus, sizeof(lastStatus)))
		printf("get Vlan Pass enable failed!\n");

	lastStatus = lastStatus & (0xFFFFFE);
	vlanpass_enable |= lastStatus; 
#endif

	if (!mib_set(MIB_VLANPASS_ENABLED, (void *)&vlanpass_enable)) {
		strcpy(tmpBuf, "set Vlan Pass enable MIB failed!");
		goto check_err;
	}
#if defined(CONFIG_CMCC) || defined(CONFIG_CU)
	syslog(LOG_CRIT, "vlan_passthrough is %s.", vlanpass_enable & 0x1 ? "enabled": "disabled");
#endif

	//write to flash
	mib_update(CURRENT_SETTING, CONFIG_MIB_ALL);

	//take effect
	setup_vlan_passthrough();
#endif 

	submitUrl = boaGetVar(wp, "submit-url", "");   // hidden page
	//OK_MSG(submitUrl);
	if (submitUrl[0])
		boaRedirect(wp, submitUrl);
	else
		boaDone(wp, 200);
	return;

check_err:
	ERR_MSG(tmpBuf);
}

