/*
 *      Web server handler routines for NET
 *
 */

/*-- System inlcude files --*/
#include <config/autoconf.h>
#include "../webs.h"
#include "webform.h"
#include "mib.h"
#include "utility.h"
#include <stdlib.h>
#include "subr_net.h"
#if defined(WLAN_SUPPORT)
#include "subr_wlan.h"
#endif

#define LANIF_NUM	PMAP_ITF_END

int initPageLanVlan(int eid, request * wp, int argc, char ** argv)
{
	int total, i, j, idx=0;
	MIB_VLAN_GROUP_T group_Entry;
	MIB_CE_SW_PORT_T port_Entry;
	char vlan_str[40]={0};
	char vlan_str_tmp[40]={0};
	int mode=0;
#if defined(WLAN_SUPPORT)
	MIB_CE_MBSSIB_T mbssEntry;
	int wlanIndex;
	int ssidIdx = -1;
#endif

	total = mib_chain_total(MIB_VLAN_GROUP_TBL);

	for (i = 0; i < LANIF_NUM; i++)
	{
		if(i < PMAP_WLAN0)
		{
			if (!mib_chain_get(MIB_SW_PORT_TBL, i, (void*)&port_Entry))
				continue;

			mode = port_Entry.pb_mode;
		}
#ifdef WLAN_SUPPORT
		else if((ssidIdx = (i-PMAP_WLAN0)) < (WLAN_SSID_NUM*NUM_WLAN_INTERFACE) && ssidIdx >= 0){
			if(i >=PMAP_WLAN0 && i <=PMAP_WLAN0_VAP_END){
				wlanIndex = 0;
				idx = i-PMAP_WLAN0;
			}
			else{
				wlanIndex = 1;
				idx = i-PMAP_WLAN1;
			}
					
			if (!mib_chain_local_mapping_get(MIB_MBSSIB_TBL, wlanIndex, idx, (void *)&mbssEntry))
				continue;

			mode = mbssEntry.pb_mode;
		}
#endif

		boaWrite(wp, "setValue('VLAN_Mode%d', %d);\n\t", i, mode);
		for (j=0; j<total; j++)
		{
			mib_chain_get(MIB_VLAN_GROUP_TBL, j, (void*)&group_Entry);
			if(group_Entry.portMask & 1<<i)
			{
				if (strlen(vlan_str) == 0)
				{
					sprintf(vlan_str, "%d/%d", group_Entry.vid, group_Entry.vprio);
				}
				else
				{
					sprintf(vlan_str, "%s,%d/%d", vlan_str_tmp, group_Entry.vid, group_Entry.vprio);
				}
				strncpy(vlan_str_tmp,vlan_str,sizeof(vlan_str));
			}

		}
		boaWrite(wp, "setValue('VLAN_VLAN%d', '%s');\n\t", i, vlan_str);
		memset(vlan_str, 0, sizeof(vlan_str));
		memset(vlan_str_tmp, 0, sizeof(vlan_str_tmp));
	}
	return 0;
}

void formLanVlanSetup(request * wp, char *path, char *query)
{
	char *strData, *token;
	char *submitUrl;
	int total, i, ifidx, nVal, vid, priority, hit = 0, idx = 0;
	char tmpBuf[100] = {0};
	MIB_VLAN_GROUP_T group_Entry;
	MIB_CE_SW_PORT_T port_Entry;
#if defined(WLAN_SUPPORT)
	MIB_CE_MBSSIB_T mbssEntry;
	int wlanIndex;
#endif
	int mode=0;

	strData = boaGetVar(wp, "VLAN_if_index", "");
	printf("VLAN_if_index %s\n", strData);
	ifidx = atoi(strData);
	if (ifidx < 0 || ifidx >= LANIF_NUM) {
		strcpy(tmpBuf, strModChainerror);
		goto setErr_vmap;
	}
	idx = ifidx;

	strData = boaGetVar(wp, "VLAN_Frm_Mode", "");
	printf("VLAN_Frm_Mode %s\n", strData);
	nVal = atoi(strData);
	mode = nVal;
	if(mode == LAN_VLAN_BASED_MODE){
		if(rtk_util_check_binding_port(ifidx, (BINDCHECK_DOMAIN_PORT_BINDING|BINDCHECK_DOMAIN_VLAN_BINDING))){
			strcpy(tmpBuf, multilang(LANG_ERROR_VLAN_TRANSLATE_PORT_VLAN_BINDING));
			goto setErr_vmap;
		}
	}

	if(ifidx <PMAP_WLAN0 )
	{
		mib_chain_get(MIB_SW_PORT_TBL, idx, (void*)&port_Entry);
		port_Entry.pb_mode = mode;
		mib_chain_update(MIB_SW_PORT_TBL, (void *)&port_Entry,idx);
	}
#if defined(WLAN_SUPPORT)
	else if(ifidx >=PMAP_WLAN0 && ifidx <=PMAP_WLAN1_VAP_END){
		if(ifidx >=PMAP_WLAN0 && ifidx <=PMAP_WLAN0_VAP_END){
			wlanIndex = 0;
			idx = ifidx-PMAP_WLAN0;
		}
		else{
			wlanIndex = 1;
			idx = ifidx-PMAP_WLAN1;
		}
		mib_chain_local_mapping_get(MIB_MBSSIB_TBL, wlanIndex, idx, (void *)&mbssEntry);	
		mbssEntry.pb_mode = mode;
		mib_chain_local_mapping_update(MIB_MBSSIB_TBL, wlanIndex, (void *)&mbssEntry, idx);
	}
#endif
	config_vlan_group(CONFIGALL,NULL,0,ifidx);
	clear_VLAN_grouping_by_port(ifidx);
	Set_LanPort_Def(ifidx);
	if(mode == LAN_VLAN_BASED_MODE)
	{
		total = mib_chain_total(MIB_VLAN_GROUP_TBL);
		strData = boaGetVar(wp, "VLAN_Frm_VLANPRI", "");
		printf("VLAN_Frm_VLANPRI %s\n", strData);
		token=strtok(strData,",");

		while (token!=NULL) {
			hit = 0;
			sscanf(token,"%d/%d", &vid, &priority);
			for (i=0;i<total;i++) {
				mib_chain_get(MIB_VLAN_GROUP_TBL, i, (void*)&group_Entry);
				if(group_Entry.vid == vid && group_Entry.vprio == priority){
					group_Entry.portMask |= 1<<ifidx;
					mib_chain_update(MIB_VLAN_GROUP_TBL, (void *)&group_Entry,i);
					setup_vlan_group(&group_Entry, 1, ifidx);
					hit = 1;
					break;
				}
			}
			if(hit == 0)
			{
				printf("%s:%d vid %d, priority %d, ifidx %d\n", __FUNCTION__, __LINE__, vid, priority, ifidx);
				group_Entry.enable = 1;
				group_Entry.itfGroup = 0;
				group_Entry.vid = vid;
				group_Entry.vprio = priority;
				group_Entry.portMask = 1<<ifidx;
				group_Entry.txTagging = 1;
				group_Entry.instnum = 0;
				mib_chain_add(MIB_VLAN_GROUP_TBL, (void *)&group_Entry);
				setup_vlan_group(&group_Entry, 1, ifidx);
			}
			token = strtok(NULL, ",");
		}
	}

	// sync with port-based mapping
	//if (pbEntry.pb_mode!=0 && org_mode != pbEntry.pb_mode)
	//	sync_itfGroup(ifidx);
#ifdef COMMIT_IMMEDIATELY
	Commit();
#endif

	//setupnewEth2pvc();
	submitUrl = boaGetVar(wp, "submit-url", "");   // hidden page

	if (submitUrl[0])
		boaRedirect(wp, submitUrl);
	else
		boaDone(wp, 200);
	return;
setErr_vmap:
	ERR_MSG(tmpBuf);

}
