/*
 *      Web server handler routines for wlan stuffs
 *
 *      Authors: David Hsu	<davidhsu@realtek.com.tw>
 *
 *      $Id: fmwlan.c,v 1.97 2012/11/21 13:00:11 kaohj Exp $
 *
 */

#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <signal.h>

#include "../webs.h"
#include "mib.h"
#include "webform.h"
#include "utility.h"
//xl_yue add
#include "../defs.h"
#include "multilang.h"
#include "fmdefs.h"

#if defined(CONFIG_ELINKSDK_SUPPORT)
#include "../../../../lib_elinksdk/libelinksdk.h"
#endif

WLAN_RATE_T rate_11n_table_20M_LONG[]={
	{MCS0, 	"6.5"},
	{MCS1, 	"13"},
	{MCS2, 	"19.5"},
	{MCS3, 	"26"},
	{MCS4, 	"39"},
	{MCS5, 	"52"},
	{MCS6, 	"58.5"},
	{MCS7, 	"65"},
	{MCS8, 	"13"},
	{MCS9, 	"26"},
	{MCS10, 	"39"},
	{MCS11, 	"52"},
	{MCS12, 	"78"},
	{MCS13, 	"104"},
	{MCS14, 	"117"},
	{MCS15, 	"130"},
	{0}
};
WLAN_RATE_T rate_11n_table_20M_SHORT[]={
	{MCS0, 	"7.2"},
	{MCS1, 	"14.4"},
	{MCS2, 	"21.7"},
	{MCS3, 	"28.9"},
	{MCS4, 	"43.3"},
	{MCS5, 	"57.8"},
	{MCS6, 	"65"},
	{MCS7, 	"72.2"},
	{MCS8, 	"14.444"},
	{MCS9, 	"28.889"},
	{MCS10, 	"43.333"},
	{MCS11, 	"57.778"},
	{MCS12, 	"86.667"},
	{MCS13, 	"115.556"},
	{MCS14, 	"130"},
	{MCS15, 	"144.444"},
	{0}
};
WLAN_RATE_T rate_11n_table_40M_LONG[]={
	{MCS0, 	"13.5"},
	{MCS1, 	"27"},
	{MCS2, 	"40.5"},
	{MCS3, 	"54"},
	{MCS4, 	"81"},
	{MCS5, 	"108"},
	{MCS6, 	"121.5"},
	{MCS7, 	"135"},
	{MCS8, 	"27"},
	{MCS9, 	"54"},
	{MCS10, 	"81"},
	{MCS11, 	"108"},
	{MCS12, 	"162"},
	{MCS13, 	"216"},
	{MCS14, 	"243"},
	{MCS15, 	"270"},
	{0}
};
WLAN_RATE_T rate_11n_table_40M_SHORT[]={
	{MCS0, 	"15"},
	{MCS1, 	"30"},
	{MCS2, 	"45"},
	{MCS3, 	"60"},
	{MCS4, 	"90"},
	{MCS5, 	"120"},
	{MCS6, 	"135"},
	{MCS7, 	"150"},
	{MCS8, 	"30"},
	{MCS9, 	"60"},
	{MCS10, 	"90"},
	{MCS11, 	"120"},
	{MCS12, 	"180"},
	{MCS13, 	"240"},
	{MCS14, 	"270"},
	{MCS15, 	"300"},
	{0}
};
WLAN_RATE_T tx_fixed_rate[]={
	{1, "1"},
	{(1<<1), 	"2"},
	{(1<<2), 	"5.5"},
	{(1<<3), 	"11"},
	{(1<<4), 	"6"},
	{(1<<5), 	"9"},
	{(1<<6), 	"12"},
	{(1<<7), 	"18"},
	{(1<<8), 	"24"},
	{(1<<9), 	"36"},
	{(1<<10), 	"48"},
	{(1<<11), 	"54"},
	{(1<<12), 	"MCS0"},
	{(1<<13), 	"MCS1"},
	{(1<<14), 	"MCS2"},
	{(1<<15), 	"MCS3"},
	{(1<<16), 	"MCS4"},
	{(1<<17), 	"MCS5"},
	{(1<<18), 	"MCS6"},
	{(1<<19), 	"MCS7"},
	{(1<<20), 	"MCS8"},
	{(1<<21), 	"MCS9"},
	{(1<<22), 	"MCS10"},
	{(1<<23), 	"MCS11"},
	{(1<<24), 	"MCS12"},
	{(1<<25), 	"MCS13"},
	{(1<<26), 	"MCS14"},
	{(1<<27), 	"MCS15"},
	{0}
};


/////////////////////////////////////////////////////////////////////////////
#ifndef NO_ACTION
static void run_script(int mode)
{
	int pid;
	char tmpBuf[100];
	pid = fork();
	if (pid)
		waitpid(pid, NULL, 0);
	else if (pid == 0) {
		snprintf(tmpBuf, 100, "%s/%s", _CONFIG_SCRIPT_PATH, _CONFIG_SCRIPT_PROG);
#ifdef HOME_GATEWAY
		execl( tmpBuf, _CONFIG_SCRIPT_PROG, "gw", "bridge", NULL);
#else
		execl( tmpBuf, _CONFIG_SCRIPT_PROG, "ap", "bridge", NULL);
#endif
		exit(1);
	}
}
#endif

static inline int isAllStar(char *data)
{
	int i;
	for (i=0; i<strlen(data); i++) {
		if (data[i] != '*')
			return 0;
	}
	return 1;
}

#if defined (CONFIG_YUEME)
char *wlanRedirecAllowList[]={"net_wlan_basic_11n_e8.asp", "net_wlan_basic_user_11n_e8.asp", "net_wlan_ft.asp", NULL};
#elif defined(CONFIG_CU)
char *wlanRedirecAllowList[]={"/net_wlan_basic_11n_e8.asp", "/net_wlan_basic_user_11n_e8.asp", "/net_wlan_ft.asp","/net_wlan_basic_11n_cmcc.asp", NULL};
#endif
void formWlanRedirect(request * wp, char *path, char *query)
{
	char *redirectUrl;
	char *strWlanId;
	char tmpBuf[32];

	redirectUrl= boaGetVar(wp, "redirect-url", "");   // hidden page
	strWlanId= boaGetVar(wp, "wlan_idx", "");   // hidden page
	if(strWlanId[0]){
		wlan_idx = atoi(strWlanId);
		if (!isValid_wlan_idx(wlan_idx)) {
			snprintf(tmpBuf, 32, "Invalid wlan_idx: %d", wlan_idx);
			ERR_MSG(tmpBuf);
			return;
		}
	}

	if(redirectUrl[0])
	{
#if defined (CONFIG_YUEME) || defined(CONFIG_CU)
		if(!checkValidRedirect(redirectUrl, wlanRedirecAllowList))
		{
			wp->buffer_end=0; // clear header
			send_r_bad_request(wp);
		}
		else
#endif
			boaRedirectTemp(wp,redirectUrl); //avoid caching
	}
}

/*
 *	Whenever band changed, it must be called to check some dependency items.
 */
static void update_on_band_changed(MIB_CE_MBSSIB_T *pEntry, int idx, int cur_band)
{
	if(wl_isNband(cur_band)) {	//n mode is enabled
		/*
		 * andrew: new test plan require N mode to
		 * avoid using TKIP.
		 */
		if (pEntry->encrypt != WIFI_SEC_WPA2_MIXED) {
			pEntry->unicastCipher = WPA_CIPHER_AES;
			pEntry->wpa2UnicastCipher= WPA_CIPHER_AES;
		}
	}
}

static void update_vap_band(unsigned char root_band)
{
	MIB_CE_MBSSIB_T Entry;
	int i;
#if defined(WLAN_BAND_CONFIG_MBSSID)
	for(i=1; i<=NUM_VWLAN_INTERFACE; i++) {
		wlan_getEntry(&Entry, i);
//#ifndef CONFIG_YUEME
		if (!Entry.wlanDisabled)
//#endif
		{
			Entry.wlanBand &= root_band;
			if (Entry.wlanBand == 0) {
				Entry.wlanBand = root_band;
				update_on_band_changed(&Entry, i, Entry.wlanBand);
			}
			mib_chain_update(MIB_MBSSIB_TBL, (void *)&Entry, i);
		}
	}
#else
	for(i=1; i<=NUM_VWLAN_INTERFACE; i++) {
		wlan_getEntry(&Entry, i);
//#ifndef CONFIG_YUEME
		if (!Entry.wlanDisabled)
//#endif
		{
			update_on_band_changed(&Entry, i, root_band);
			mib_chain_update(MIB_MBSSIB_TBL, (void *)&Entry, i);
		}
	}
#endif
}

/////////////////////////////////////////////////////////////////////////////
//#if defined(CONFIG_CMCC) || defined(CONFIG_CU_BASEON_CMCC)
#define SET_WEP_KEY(mibKey, key, len, erase) (erase)?(memset(mibKey, atoi(key), len)):(memcpy(mibKey, key, len)) 

#ifdef CONFIG_WIFI_SIMPLE_CONFIG // WPS
#define WSC_PBC_WAITTIME	120
#define WSCD_PBC_CANCEL		"echo 1 > /tmp/wscd_cancel"

static void *start_PBC(char* ptr)
{
	system(ptr);
	sleep(WSC_PBC_WAITTIME);
	unlink(ptr+strlen("echo 1 >"));
	system(WSCD_PBC_CANCEL);

	return NULL;
}

static void stop_PBC(char* ptr)
{
	system(WSCD_PBC_CANCEL);
	unlink(ptr+strlen("echo 1 >"));
}
#endif
//#endif

#if 0 // defined(CONFIG_CMCC) || defined(CONFIG_CU_BASEON_CMCC) 
void formWlanSetup(request * wp, char *path, char *query)
{
	char *submitUrl, *strSSID, *strChan, *strDisabled, *strVal;
	char vChar, chan, disabled, mode=-1;
#ifdef CONFIG_CU_BASEON_CMCC
	unsigned char fakeTxPower;
#endif
	NETWORK_TYPE_T net;
	char tmpBuf[100];
	int flags;
	MIB_CE_MBSSIB_T Entry;
	int warn = 0;

	unsigned short uShort=0;
	int vInt=0, ssidIdx, wlmib_idx=0;
#ifndef WLAN_DUALBAND_CONCURRENT
	int all_ssid_modify=0;
#endif

#ifdef WLAN_UNIVERSAL_REPEATER
	MIB_CE_MBSSIB_T repeaterEntry;
#endif
#if defined(WLAN_DUALBAND_CONCURRENT)
	char phyBandSelect, wlanBand2G5GSelect, phyBandOrig, wlanBand2G5GSelect_single;
	int phyBandSelectChange = 0;
	char lan_ip[30];
	int orig_idx;
	int both_band_modify=0;
#ifdef WLAN_BAND_STEERING
	unsigned char sta_control=0, sta_control_change=0;
#endif
#endif //WLAN_DUALBAND_CONCURRENT

#if defined(WLAN_DUALBAND_CONCURRENT)
	strVal = boaGetVar(wp, "wlan_idx", "");
	if ( strVal[0] ) {
		printf("wlan_idx=%d\n", strVal[0]-'0');
		wlan_idx = strVal[0]-'0';
	}
#endif
	memset( &Entry, 0, sizeof( MIB_CE_MBSSIB_T ));
	strVal = boaGetVar(wp, "ssid_idx", "");
	ssidIdx = strVal[0] - '0'; 

	if(ssidIdx >= 0){
		wlmib_idx = ssidIdx;
		memset( &Entry, 0, sizeof( MIB_CE_MBSSIB_T ));
		if(mib_chain_get(MIB_MBSSIB_TBL, wlmib_idx, (void *)&Entry)!=1)
			goto setErr_wlan;
	}
	else
		goto setErr_wlan;

	strDisabled = boaGetVar(wp, "wlanDisabled", "");

	if ( !gstrcmp(strDisabled, "ON") )
		disabled = 1;
	else
		disabled = 0;

	strDisabled = boaGetVar(wp, "wlanEnabled", "");

	if ( !gstrcmp(strDisabled, "ON") )
		disabled = 0;
	else
		disabled = 1;

#if 0	
	if (getInFlags(getWlanIfName(), &flags) == 1) {
		if (disabled)
			flags &= ~IFF_UP;
		else
			flags |= IFF_UP;

		setInFlags(getWlanIfName(), flags);
	}
#endif
#ifdef WLAN_DUALBAND_CONCURRENT
	mib_get_s(MIB_WIFI_MODULE_DISABLED, (void *)&vChar, sizeof(vChar));
	if(disabled!=vChar)
		both_band_modify = 1;
#endif
#ifndef WLAN_DUALBAND_CONCURRENT
	mib_get_s(MIB_WIFI_MODULE_DISABLED, (void *)&vChar, sizeof(vChar));
	if(disabled!=vChar)
		all_ssid_modify=1;
#endif
	mib_set(MIB_WIFI_MODULE_DISABLED, (void *)&disabled);

	if ( disabled ){
		syslog(LOG_INFO, "WlanSetup: Disable Wlan");
		goto setwlan_module_disable;
	}

	strVal = boaGetVar(wp, "enableSSID", "");

	if ( !gstrcmp(strVal, "ON") )
		Entry.wlanDisabled = 0;
	else
	{
		Entry.wlanDisabled = 1;
#ifdef WLAN_BAND_STEERING
		mib_get_s(MIB_WIFI_STA_CONTROL, (void *)&sta_control, sizeof(sta_control));
		if(sta_control==1)
		{
			sta_control = 0;
			if ( mib_set( MIB_WIFI_STA_CONTROL, (void *)&sta_control) == 0)
			{
				goto setErr_wlan;
			}
			both_band_modify = 1;
			sta_control_change = 1;
		}
#endif
	}

	{
		
#ifdef WLAN_BAND_STEERING
		if(Entry.wlanDisabled == 0)
		{
			strDisabled = boaGetVar(wp, "wlanStaControl", "");

			if ( !gstrcmp(strDisabled, "ON") )
				vChar = 1;
			else
				vChar = 0;

			if ( mib_set( MIB_WIFI_STA_CONTROL, (void *)&vChar) == 0) {
				goto setErr_wlan;
			}
		}
#endif

#ifdef WLAN_RATE_PRIOR
		strVal = boaGetVar(wp, "wlanRatePrior", "");

		if ( !gstrcmp(strVal, "ON") )
			vChar = 1;
		else
			vChar = 0;
		if ( mib_set( MIB_WLAN_RATE_PRIOR, (void *)&vChar) == 0) {
			goto setErr_wlan;
		}
#endif

		// Added by Mason Yu for TxPower
		strVal = boaGetVar(wp, "txpower", "");
#ifdef CONFIG_CU_BASEON_CMCC
		printf("strVal is %s.\n", strVal);
#endif
		if ( strVal[0] ) {

			if (strVal[0] < '0' || strVal[0] > '5') {
				strlcpy(tmpBuf, strInvdTxPower,sizeof(tmpBuf));
				goto setErr_wlan;
			}

#ifdef CONFIG_CU_BASEON_CMCC
			if(strVal[0]=='5') {
				fakeTxPower = 1;
				mib_set( MIB_FAKE_TX_POWER, (void *)&fakeTxPower);
				mode = 4;
			}else{
				fakeTxPower = 0;
				mib_set( MIB_FAKE_TX_POWER, (void *)&fakeTxPower);
				mode = strVal[0] - '0';
			}
#else 
			if(strVal[0]=='5')
				mode = 0;
			else
				mode = strVal[0] - '0';
#endif
			if ( mib_set( MIB_TX_POWER, (void *)&mode) == 0) {
	   			strcpy(tmpBuf, strSetMIBTXPOWErr);
				goto setErr_wlan;
			}

			if(strVal[0]=='5')
				mode = 1;
			else
				mode = 0;

			if ( mib_set( MIB_WLAN_TX_POWER_HIGH, (void *)&mode) == 0) {
	   			strcpy(tmpBuf, strSetMIBTXPOWErr);
				goto setErr_wlan;
			}
			

		}
	}

	strVal = boaGetVar(wp, "mode", "");
	if ( strVal[0] ) {
		if (strVal[0]!= '0' && strVal[0]!= '1' && strVal[0]!= '2' && strVal[0]!= '3') {
			strcpy(tmpBuf, strInvdMode);
			goto setErr_wlan;
		}
		mode = strVal[0] - '0';

#ifdef WLAN_CLIENT
		if (mode == CLIENT_MODE) {
			WIFI_SECURITY_T encrypt;

			vChar = Entry.encrypt;
			encrypt = (WIFI_SECURITY_T)vChar;
			if (encrypt == WIFI_SEC_WPA || encrypt == WIFI_SEC_WPA2) {
				vChar = Entry.wpaAuth;
				if (vChar & 1) { // radius
					strcpy(tmpBuf, strSetWPAWarn);
					goto setErr_wlan;
				}
			}
			else if (encrypt == WIFI_SEC_WEP) {
				vChar = Entry.enable1X;
				if (vChar & 1) {
					strcpy(tmpBuf, strSetWEPWarn);
					goto setErr_wlan;
				}
			}
			else if (encrypt == WIFI_SEC_WPA2_MIXED) {
				vChar = WIFI_SEC_WPA2;
				Entry.encrypt = vChar;
				strcpy(tmpBuf, "警告! WPA2混合模式不支援client mode <BR> 请改为WPA2加密!"); //Warning! WPA2 Mixed encryption is not supported in client Mode. <BR> Change to WPA2 Encryption.
				warn = 1;
			}
		}
#endif
		Entry.wlanMode = mode;
	}

	strSSID = boaGetVar(wp, "ssid", "");
	
	if ( strSSID[0] ) {
		char real_ssid[64] = "";
#if defined(CONFIG_CU_BASEON_CMCC)
		unsigned char ssidprefix_enable = 0;

		mib_get_s(MIB_WEB_WLAN_SSIDPREFIX_ENABLE, &ssidprefix_enable, sizeof(ssidprefix_enable));
		if (ssidprefix_enable==1)
			sprintf(real_ssid, "CU_%s", strSSID);
		else
			sprintf(real_ssid, "%s", strSSID);
#elif defined(CONFIG_CMCC)
		unsigned char ssidprefix_enable = 0;

		mib_get_s(MIB_WEB_WLAN_SSIDPREFIX_ENABLE, &ssidprefix_enable, sizeof(ssidprefix_enable));
		if (ssidprefix_enable==1)
			sprintf(real_ssid, "CMCC-%s", strSSID);
		else
			sprintf(real_ssid, "%s", strSSID);
#endif
		strcpy(Entry.ssid, real_ssid);
	}
	//else if ( mode == 1 && !strSSID[0] ) { // client and NULL SSID
	//	if ( mib_set(MIB_WLAN_SSID, (void *)strSSID) == 0) {
   	// 			strcpy(tmpBuf, strSetSSIDErr);
	//			goto setErr_wlan;
	//	}
	//}

	{
		strChan = boaGetVar(wp, "chan", "");
		if ( strChan[0] ) {
			errno=0;
			chan = strtol( strChan, (char **)NULL, 10);
			if (errno) {
	   			strcpy(tmpBuf, strInvdChanNum);
				goto setErr_wlan;
			}
			if(chan != 0)
			{
				vChar = 0;	//disable auto channel
				if ( mib_set( MIB_WLAN_CHAN_NUM, (void *)&chan) == 0) {
					strcpy(tmpBuf, strSetChanErr);
					goto setErr_wlan;
				}
			}
			else
				vChar = 1;	//enable auto channel

			if ( mib_set( MIB_WLAN_AUTO_CHAN_ENABLED, (void *)&vChar) == 0) {
				strcpy(tmpBuf, strSetChanErr);
				goto setErr_wlan;
			}
		}
	}
#if 0// defined(WLAN0_5G_SUPPORT) || defined(WLAN1_5G_SUPPORT)
	{
		char band2G5GSelect = 0;
		char band_no, band_val;
		strVal = boaGetVar(wp, "Band2G5GSupport", "");
		if(strVal[0])
		{
			band2G5GSelect = atoi(strVal);
			printf("band2G5GSelect = %d\n", band2G5GSelect);
		}
		strVal = boaGetVar(wp, "band", "");
		if(strVal[0])
		{
			band_no = atoi(strVal);
			//printf("band_no = %d\n", band_no);
		}
		if(band_no==3 || band_no==11 || band_no==63 || band_no==71 || band_no==75)
			band_val = 2;
		else if(band_no==7)
		{
			band_val = band2G5GSelect;
		}
		else
			band_val = 1;

		if ( mib_set( MIB_WLAN_PHY_BAND_SELECT, (void *)&band_val) == 0) {
			strcpy(tmpBuf, ("Set band error!"));
			goto setErr_wlan;
		}
	}
#endif

	char *strRate;
	unsigned short val;

	strVal = boaGetVar(wp, "band", "");
	if ( strVal[0] ) {
		mode = atoi(strVal);
		mode++;

		update_on_band_changed(&Entry, 0, mode);

		if(ssidIdx==WLAN_ROOT_ITF_INDEX)
			update_vap_band(mode); // Update vap band based on root band

#ifdef WLAN_BAND_CONFIG_MBSSID
		Entry.wlanBand = mode;
#else
		if ( mib_set( MIB_WLAN_BAND, (void *)&mode) == 0) {
			strcpy(tmpBuf, strSetBandErr);
			goto setErr_wlan;
		}
#endif
	}
/*
	strRate = boaGetVar(wp, "basicrates", "");
	if ( strRate[0] ) {
		val = atoi(strRate);
		if ( mib_set(MIB_WLAN_BASIC_RATE, (void *)&val) == 0) {
			strcpy(tmpBuf, strSetBaseRateErr);
			goto setErr_wlan;
		}
	}

	strRate = boaGetVar(wp, "operrates", "");
	if ( strRate[0] ) {
		val = atoi(strRate);
		if ( mib_set(MIB_WLAN_SUPPORTED_RATE, (void *)&val) == 0) {
			strcpy(tmpBuf, strSetOperRateErr);
			goto setErr_wlan;
		}
	}
*/
	{
		strVal = boaGetVar(wp, "chanwid", "");            //add by yq_zhou 2.10
		if ( strVal[0] ) {
			int band = mode;
			mode = strVal[0] - '0';
			if(mode == 2 && band < 64) //20/40MHz
			{
				mode--;
				vChar = 1;
			}
			else
				vChar = 0;
			if ( mib_set( MIB_WLAN_CHANNEL_WIDTH, (void *)&mode) == 0) {
				strcpy(tmpBuf, strSetChanWidthErr);
				goto setErr_wlan;
			}
			if ( mib_set( MIB_WLAN_11N_COEXIST, (void *)&vChar) == 0) {
				strcpy(tmpBuf, strSet11NCoexistErr);
				goto setErr_wlan;
			}
		}

		strVal = boaGetVar(wp, "ctlband", "");            //add by yq_zhou 2.10
		if ( strVal[0] ) {
			mode = strVal[0] - '0';
			if ( mib_set( MIB_WLAN_CONTROL_BAND, (void *)&mode) == 0) {
				strcpy(tmpBuf, strSetCtlBandErr);
				goto setErr_wlan;
			}
		}
	}

	// set tx rate
	strRate = boaGetVar(wp, "txRate", "");
	if ( strRate[0] ) {
		if ( strRate[0] == '0' ) { // auto
			Entry.rateAdaptiveEnabled = 1;
		}
		else  {
			Entry.rateAdaptiveEnabled = 0;
			{
				unsigned int uInt;
				uInt = atoi(strRate);
				if(uInt<29)
					uInt = 1 << (uInt-1);
				else if(uInt>=29 && uInt<45)
					uInt = ((1 << 28) + (uInt-29));
				else
					uInt = ((1 << 31) + (uInt-45));
				
				Entry.fixedTxRate = uInt;
			}
			strRate = boaGetVar(wp, "basicrates", "");
			if ( strRate[0] ) {
				val = atoi(strRate);
				if ( mib_set(MIB_WLAN_BASIC_RATE, (void *)&val) == 0) {
					strcpy(tmpBuf, strSetBaseRateErr);
					goto setErr_wlan;
				}
			}

			strRate = boaGetVar(wp, "operrates", "");
			if ( strRate[0] ) {
				val = atoi(strRate);
				if ( mib_set(MIB_WLAN_SUPPORTED_RATE, (void *)&val) == 0) {
					strcpy(tmpBuf, strSetOperRateErr);
					goto setErr_wlan;
				}
			}
		}
	}
	else { // set rate in operate, basic sperately
#ifdef WIFI_TEST
		// disable rate adaptive
		Entry.rateAdaptiveEnabled = 0;

#endif // of WIFI_TEST
	}

	strVal = boaGetVar(wp, "beaconInterval", "");
	if (strVal[0]) {
		if ( !string_to_dec(strVal, &vInt) || vInt<MIN_WLAN_BEACON_INTERVAL || vInt>1024) {
			strcpy(tmpBuf, strInvdBeaconIntv);
			goto setErr_wlan;
		}
		uShort = (unsigned short)vInt;
		if ( mib_set(MIB_WLAN_BEACON_INTERVAL, (void *)&uShort) == 0) {
			strcpy(tmpBuf, strSetBeaconIntvErr);
			goto setErr_wlan;
		}
	}

	strVal = boaGetVar(wp, "dtimPeriod", "");
	if (strVal[0]) {
		if ( !string_to_dec(strVal, &vInt) || vInt<1 || vInt>255) {
			strcpy(tmpBuf, strInvdDTIMPerd);
			goto setErr_wlan;
		}
		vChar = (char)vInt;
		if ( mib_set(MIB_WLAN_DTIM_PERIOD, (void *)&vChar) == 0) {
			strcpy(tmpBuf, strSetDTIMErr);
			goto setErr_wlan;
		}
	}

	// set hidden SSID
	strVal = boaGetVar(wp, "hiddenSSID", "");
	if (!gstrcmp(strVal, "ON"))
		vChar = 1;
	else
		vChar = 0;
	
	Entry.hidessid = vChar;

	{
		strVal = boaGetVar(wp, "shortGI0", "");
		if (strVal[0]) {
		
			if (strVal[0] == '0')
			{
				vChar = 0;
			}
			else 
			{
				vChar = 1;
			}

			if (mib_set(MIB_WLAN_SHORTGI_ENABLED,(void *)&vChar) ==0){
				strcpy(tmpBuf, strSetShortGI0Err);
				goto setErr_wlan;
			}
		}
	}
#ifdef WLAN_11K
	strVal = boaGetVar(wp, "dot11kEnabled", "");
	if (strVal[0]) {
		if (strVal[0] == '0')
			Entry.rm_activated = 0;
		else // '1'
			Entry.rm_activated = 1;
	}
#endif
#ifdef WLAN_11V
	strVal = boaGetVar(wp, "dot11vEnabled", "");
	if (strVal[0]) {
		if (strVal[0] == '0')
			Entry.BssTransEnable = 0;
		else // '1'
			Entry.BssTransEnable = 1;
	}
#endif

	mib_chain_update(MIB_MBSSIB_TBL, (void *)&Entry, wlmib_idx);

#ifdef WLAN_UNIVERSAL_REPEATER
	strVal = boaGetVar(wp, "repeaterEnabled", "");
	mib_chain_get(MIB_MBSSIB_TBL, WLAN_REPEATER_ITF_INDEX, (void *)&repeaterEntry);
	if ( strVal[0] ) {
		vChar=1;
		repeaterEntry.wlanDisabled = 0;
		repeaterEntry.wlanMode = vChar;
	}
	else {
		vChar=0;
		repeaterEntry.wlanDisabled = 1;
	}
	mib_set( MIB_REPEATER_ENABLED1, (void *)&vChar);

	strVal = boaGetVar(wp, "repeaterSSID", "");
	if ( strVal[0] ) {
		mib_set( MIB_REPEATER_SSID1, (void *)strVal);
		strncpy(repeaterEntry.ssid, strVal, MAX_SSID_LEN);
	}
	mib_chain_update(MIB_MBSSIB_TBL, (void *)&repeaterEntry, WLAN_REPEATER_ITF_INDEX);
#endif

//--------------------------------
// Encrypt
	char *strEncrypt;
	char *strKeyLen, *strFormat, *wepKey, *strAuth;
	int key_index=0, key_i;
	char *strKeySelcted;
	char strbuf_idx[16], strbuf_errmsg1[16], strbuf_errmsg2[16];
	WIFI_SECURITY_T encrypt;
	int enableRS=0, intVal, getPSK=0, len, keyLen;
	SUPP_NONWAP_T suppNonWPA;
	struct in_addr inIp;
	WEP_T wep;
	char key[30];
	AUTH_TYPE_T authType;
	int i, eraseKey=0;

#if 0
	strVal = boaGetVar(wp, "wpaSSID", "");

	if (strVal[0]) {
		i = strVal[0]-'0';
		if (i<0 || i > NUM_VWLAN_INTERFACE) {
			strcpy(tmpBuf, strNotSuptSSIDType);
			goto setErr_encrypt;
		}

	} else {
		strcpy(tmpBuf, strNoSSIDTypeErr);
		goto setErr_encrypt;
	}
#endif
	i = wlmib_idx;

	if (!wlan_getEntry(&Entry, wlmib_idx)){
		strcpy(tmpBuf, strGetMBSSIBTBLErr);
		goto setErr_encrypt;
	}

	strEncrypt = boaGetVar(wp, "security_method", "");
	if (!strEncrypt[0]) {
 		strcpy(tmpBuf, strNoEncryptionErr);
		goto setErr_encrypt;
	}

	encrypt = (WIFI_SECURITY_T) strEncrypt[0] - '0';
	vChar = (char)encrypt;
	Entry.encrypt = vChar;

	if (encrypt == WIFI_SEC_NONE || encrypt == WIFI_SEC_WEP) {

#ifdef WLAN_1x
		strVal = boaGetVar(wp, "use1x", "");
		if ( !gstrcmp(strVal, "ON")) {
			vChar = Entry.wlanMode;
			if (vChar) { // not AP mode
				strcpy(tmpBuf, strSet8021xWarning);
				goto setErr_encrypt;
			}
			vChar = 1;
			enableRS = 1;
		}
		else
			vChar = 0;
		Entry.enable1X = vChar;
#endif

		if (encrypt == WIFI_SEC_WEP) {
	 		WEP_T wep;
			// Mason Yu. 201009_new_security. If wireless do not use 802.1x for wep mode. We should set wep key and Authentication type.
			if ( enableRS != 1 ) {
				// (1) Authentication Type
				strAuth = boaGetVar(wp, "auth_type", "");
				if (strAuth[0]) {
					if ( !gstrcmp(strAuth, "open"))
						authType = AUTH_OPEN;
					else if ( !gstrcmp(strAuth, "shared"))
						authType = AUTH_SHARED;
					else if ( !gstrcmp(strAuth, "both"))
						authType = AUTH_BOTH;
					else {
						strcpy(tmpBuf, strInvdAuthType);
						goto setErr_encrypt;
					}
					vChar = (char)authType;
					Entry.authType = vChar;
				}

				// (2) Key Length
				strKeyLen = boaGetVar(wp, "length0", "");
				if (!strKeyLen[0]) {
 					strcpy(tmpBuf, strKeyLenMustExist);
					goto setErr_encrypt;
				}
				if (strKeyLen[0]!='1' && strKeyLen[0]!='2') {
 					strcpy(tmpBuf, strInvdKeyLen);
					goto setErr_encrypt;
				}
				if (strKeyLen[0] == '1')
					wep = WEP64;
				else
					wep = WEP128;

				vChar = (char)wep;
				Entry.wep = vChar;

				// (3) Key Format
				strFormat = boaGetVar(wp, "format0", "");
				if (!strFormat[0]) {
 					strcpy(tmpBuf, strKeyTypeMustExist);
					goto setErr_encrypt;
				}

				if (strFormat[0]!='1' && strFormat[0]!='2') {
					strcpy(tmpBuf, strInvdKeyType);
					goto setErr_encrypt;
				}

				vChar = (char)(strFormat[0] - '0' - 1);
				Entry.wepKeyType = vChar;

				if (wep == WEP64) {
					if (strFormat[0]=='1')
						keyLen = WEP64_KEY_LEN;
					else
						keyLen = WEP64_KEY_LEN*2;
				}
				else {
					if (strFormat[0]=='1')
						keyLen = WEP128_KEY_LEN;
					else
						keyLen = WEP128_KEY_LEN*2;
				}

				// Key selected
				strKeySelcted = boaGetVar(wp, "defaultKeyidx", "");
				if (!strKeySelcted[0]) {
					strcpy(tmpBuf, strKeySelectedMustExist);
					goto setErr_encrypt;
				}
				if (strKeySelcted[0]!='1' && strKeySelcted[0]!='2' && strKeySelcted[0]!='3' && strKeySelcted[0]!='4') {
					strcpy(tmpBuf, strInvdKeySel);
					goto setErr_encrypt;
				}
				if (strKeySelcted[0] == '1')
					key_index = 0;
				else if (strKeySelcted[0] == '2')
					key_index = 1;
				else if (strKeySelcted[0] == '3')
					key_index = 2;
				else
					key_index = 3;

				Entry.wepDefaultKey = key_index;

				// (4) Encryption Key
				//
				for (key_i=0; key_i<4; key_i++)
				{

					if(key_index!=key_i) continue;

					sprintf(strbuf_idx, "key%d", key_i);
					sprintf(strbuf_errmsg1, "strInvdKey%dLen", key_i+1);
					sprintf(strbuf_errmsg2, "strInvdWEPKey%d", key_i+1);

					wepKey = boaGetVar(wp, strbuf_idx, "");
					if  (wepKey[0]) {
						if (strlen(wepKey) != keyLen && strcmp(wepKey, "0")) {
							strcpy(tmpBuf, strbuf_errmsg1);
							goto setErr_encrypt;
						}
						if ( !isAllStar(wepKey) ) {
							if(!strcmp(wepKey, "0"))     //special case for erase key
							{
								strcpy(key, "\0");
								eraseKey=1;
							}
							else     //general case
							{
								if (strFormat[0] == '1') // ascii
									strcpy(key, wepKey);
								else { // hex
									if ( !rtk_string_to_hex(wepKey, key, keyLen)) {
										strcpy(tmpBuf, strbuf_errmsg2);
										goto setErr_encrypt;
									}
								}
							}
							if (wep == WEP64)
							{
								switch(key_i)
								{	
									case 0:
										SET_WEP_KEY(Entry.wep64Key1, key, WEP64_KEY_LEN, eraseKey);
										break;
									case 1:
										SET_WEP_KEY(Entry.wep64Key2, key, WEP64_KEY_LEN, eraseKey);
										break;
									case 2:
										SET_WEP_KEY(Entry.wep64Key3, key, WEP64_KEY_LEN, eraseKey);
										break;
									case 3:
										SET_WEP_KEY(Entry.wep64Key4, key, WEP64_KEY_LEN, eraseKey);
										break;
								}
							}
							else
							{
								switch(key_i)
								{
									case 0:
										SET_WEP_KEY(Entry.wep128Key1, key, WEP128_KEY_LEN, eraseKey);
										break;
									case 1:
										SET_WEP_KEY(Entry.wep128Key2, key, WEP128_KEY_LEN, eraseKey);
										break;
									case 2:
										SET_WEP_KEY(Entry.wep128Key3, key, WEP128_KEY_LEN, eraseKey);
										break;
									case 3:
										SET_WEP_KEY(Entry.wep128Key4, key, WEP128_KEY_LEN, eraseKey);
										break;
								}
							}
						}
					}
				}// (4) Encryption Key
			}
		}
	}
#ifdef CONFIG_RTL_WAPI_SUPPORT
	/* assume MBSSID for now. */
	else if (encrypt == WIFI_SEC_WAPI) {
		char *wapiAuth=0, *pskFormat=0, *pskValue=0;
		unsigned char asIP[IP_ADDR_LEN]={0}, wapiType=0;
		int len;
		//fprintf(stderr, "%s(%d):\n", __FUNCTION__,__LINE__);
		wapiAuth = boaGetVar(wp, "wapiAuth", "");

		if (wapiAuth[0] == '1') {
			wapiType = 1;
			//asIP = boaGetVar(wp, "radiusIP", "");
			//fprintf(stderr, "%s(%d): %p\n", __FUNCTION__,__LINE__, asIP);
		}
		else if (wapiAuth[0] == '2') {
			wapiType = 2;
			pskFormat = boaGetVar(wp, "wapipskFormat", "");
			pskValue = boaGetVar(wp, "wapipskValue", "");
			len = strlen(pskValue);
		}
		else {
			strcpy(tmpBuf, strInvdWPAAuthValue);
			goto setErr_encrypt;
		}


		//fprintf(stderr, "%s(%d):\n", __FUNCTION__,__LINE__);
		if (0 == i) {

			Entry.wapiAuth = wapiType;
			if (wapiType == 2) { // PSK
				vChar = pskFormat[0] - '0';
				if (vChar != 0 && vChar != 1) {
					strcpy(tmpBuf, strInvdPSKFormat);
					goto setErr_encrypt;
				}
				Entry.wapiPskFormat = vChar;//mib_set(MIB_WLAN_WAPI_PSK_FORMAT, (void *)&vChar);
				if (vChar == 1) {// hex
					printf("(%s,%d) pskstring:%s\n",__func__,__LINE__,pskValue);
					memset(tmpBuf, 0, sizeof(tmpBuf));
					if (!rtk_string_to_hex(pskValue, tmpBuf, len)) {
						strcpy(tmpBuf, strInvdPSKValue);
						printf("(%s,%d) invalid pskvalue\n",__func__,__LINE__);
						goto setErr_encrypt;
					}


					if ((len & 1) || (len/2 >= MAX_PSK_LEN)) {
						strcpy(tmpBuf, strInvdPSKValue);
						goto setErr_encrypt;
					}
					len = len / 2;
					vChar = len;
					Entry.wapiPskLen = vChar;//mib_set(MIB_WLAN_WAPI_PSKLEN, &vChar);
					strcpy(Entry.wapiPsk, tmpBuf);//mib_set(MIB_WLAN_WAPI_PSK, (void *)tmpBuf);

				} else { // passphrase

					if (len==0 || len > (MAX_PSK_LEN - 1)) {
						strcpy(tmpBuf, strInvdPSKValue);
						goto setErr_encrypt;
					}
					vChar = len;
					Entry.wapiPskLen = vChar;//mib_set(MIB_WLAN_WAPI_PSKLEN, &vChar);
					strcpy(Entry.wapiPsk, pskValue);//mib_set(MIB_WLAN_WAPI_PSK, (void *)pskValue);

				}

			} else { // AS
				if ( !mib_get_s(MIB_ADSL_LAN_IP, (void *)&inIp, sizeof(inIp)) ) {
					strcpy(tmpBuf, strInvdRSIPValue);
					goto setErr_encrypt;
				}
				*((unsigned long *)Entry.wapiAsIpAddr) = inIp.s_addr;
			}

		} else {
			//fprintf(stderr, "%s(%d):\n", __FUNCTION__,__LINE__);
			mib_set(MIB_WLAN_WAPI_AUTH, (void *)&wapiType);
			if (wapiType == 2) { // PSK
				vChar = pskFormat[0] - '0';
				if (vChar != 0 && vChar != 1) {
					strcpy(tmpBuf, strInvdPSKFormat);
					goto setErr_encrypt;
				}
				mib_set(MIB_WLAN_WAPI_PSK_FORMAT, (void *)&vChar);
				if (vChar == 1) {// hex
					if (!rtk_string_to_hex(pskValue, tmpBuf, MAX_PSK_LEN)) {
						strcpy(tmpBuf, strInvdPSKValue);
						goto setErr_encrypt;
					}
					//fprintf(stderr, "%s(%d): %08x%08x%08x%08x\n",
					//	__FUNCTION__,__LINE__, (long *)&pskValue[0],
					//	(long *)&pskValue[4],(long *)&pskValue[8],(long *)&pskValue[12]);
					if ((len & 1) || (len/2 >= MAX_PSK_LEN)) {
						strcpy(tmpBuf, strInvdPSKValue);
						goto setErr_encrypt;
					}
					len = len / 2;
					vChar = len;
					mib_set(MIB_WLAN_WAPI_PSKLEN, &vChar);
					mib_set(MIB_WLAN_WAPI_PSK, (void *)pskValue);

				} else { // passphrase

					if (len==0 || len > (MAX_PSK_LEN - 1)) {
						strcpy(tmpBuf, strInvdPSKValue);
						goto setErr_encrypt;
					}
					vChar = len;
					mib_set(MIB_WLAN_WAPI_PSKLEN, &vChar);
					mib_set(MIB_WLAN_WAPI_PSK, (void *)pskValue);

				}

			} else { // AS
				//fprintf(stderr, "%s(%d):\n", __FUNCTION__,__LINE__);
				if ( !inet_aton(asIP, &inIp) ) {
					strcpy(tmpBuf, strInvdRSIPValue);
					goto setErr_encrypt;
				}
				//fprintf(stderr, "%s(%d):\n", __FUNCTION__,__LINE__);
				mib_set(MIB_WLAN_WAPI_ASIPADDR, (void *)&inIp);
			}


		}
	}
#endif 	// CONFIG_RTL_WAPI_SUPPORT
	else {	// WPA
#ifdef WLAN_1x
		// WPA authentication
		vChar = 0;
		Entry.enable1X = vChar;

		strVal = boaGetVar(wp, "wpaAuth", "");
		if (strVal[0]) {
			if ( !gstrcmp(strVal, "eap")) {
				vChar = Entry.wlanMode;
				if (vChar) { // not AP mode
					strcpy(tmpBuf, strSetWPARADIUSWarn);
					goto setErr_encrypt;
				}
				vChar = WPA_AUTH_AUTO;
				enableRS = 1;
			}
			else if ( !gstrcmp(strVal, "psk")) {
				vChar = WPA_AUTH_PSK;
				getPSK = 1;
			}
			else {
				strcpy(tmpBuf, strInvdWPAAuthValue);
				goto setErr_encrypt;
			}
			Entry.wpaAuth = vChar;
		}
#endif

		// Mason Yu. 201009_new_security. Set ciphersuite(wpa_cipher) for wpa/wpa mixed
		if ((encrypt == WIFI_SEC_WPA) || (encrypt == WIFI_SEC_WPA2_MIXED)) {
			unsigned char intVal = 0;
			unsigned char val2;

			strVal = boaGetVar(wp, "ciphersuite", ""); 
			if (strVal[0]) {
				if (strVal[0] == '1') 
				{    
					intVal |= WPA_CIPHER_TKIP;
				}    
				else if (strVal[0] == '2') 
				{    
					intVal |= WPA_CIPHER_AES;
				}    
				else if (strVal[0] == '3') 
				{    
					intVal |= WPA_CIPHER_MIXED;
				}    
			}

			if ( intVal == 0 )
				intVal = WPA_CIPHER_TKIP;

				Entry.unicastCipher = intVal;
		}

		// Mason Yu. 201009_new_security. Set wpa2ciphersuite(wpa2_cipher) for wpa2/wpa mixed
		if ((encrypt == WIFI_SEC_WPA2) || (encrypt == WIFI_SEC_WPA2_MIXED)) {
			unsigned char intVal = 0;

			strVal = boaGetVar(wp, "wpa2ciphersuite", ""); 
			if (strVal[0]) 
			{
				if (strVal[0] == '1') 
				{    
					intVal |= WPA_CIPHER_TKIP;
				}    
				else if (strVal[0] == '2') 
				{    
					intVal |= WPA_CIPHER_AES;
				}    
				else if (strVal[0] == '3') 
				{    
					intVal |= WPA_CIPHER_MIXED;
				}    
			}

			if ( intVal == 0 )
				intVal = WPA_CIPHER_AES;

			Entry.wpa2UnicastCipher = intVal;
		}
#ifdef WLAN_WPA3
		else if(((encrypt == WIFI_SEC_WPA3) || (encrypt == WIFI_SEC_WPA2_WPA3_MIXED))){
			Entry.wpa2UnicastCipher = WPA_CIPHER_AES;
		}
#endif

		// pre-shared key
		if ( getPSK ) {
			
			strVal = boaGetVar(wp, "pskFormat", "");
			if (!strVal[0]) {
	 			strcpy(tmpBuf, strNoPSKFormat);
				goto setErr_encrypt;
			}
			vChar = strVal[0] - '0';
			
			//vChar = 0;
			if (vChar != 0 && vChar != 1) {
	 			strcpy(tmpBuf, strInvdPSKFormat);
				goto setErr_encrypt;
			}

			strVal = boaGetVar(wp, "pskValue", "");
			len = strlen(strVal);
			Entry.wpaPSKFormat = vChar;

			if (vChar==1) { // hex
				if (len!=MAX_PSK_LEN || !rtk_string_to_hex(strVal, tmpBuf, MAX_PSK_LEN)) {
	 				strcpy(tmpBuf, strInvdPSKValue);
					goto setErr_encrypt;
				}
			}
			else { // passphras
				if (len==0 || len > (MAX_PSK_LEN - 1) ) {
	 				strcpy(tmpBuf, strInvdPSKValue);
					goto setErr_encrypt;
				}
			}
			strcpy(Entry.wpaPSK, strVal);
			
		}
	}
#ifdef WLAN_1x
	if (enableRS == 1) { // if 1x enabled, get RADIUS server info
		unsigned short uShort;

		strVal = boaGetVar(wp, "radiusPort", "");
		if (!strVal[0]) {
			strcpy(tmpBuf, "没有RS端口数值!"); //No RS port number!
			goto setErr_encrypt;
		}
		if (!string_to_dec(strVal, &intVal) || intVal<=0 || intVal>65535) {
			strcpy(tmpBuf, strInvdRSPortNum);
			goto setErr_encrypt;
		}
		uShort = (unsigned short)intVal;
		Entry.rsPort = uShort;

		strVal = boaGetVar(wp, "radiusIP", "");
		if (!strVal[0]) {
			strcpy(tmpBuf, strNoIPAddr);
			goto setErr_encrypt;
		}
		if ( !inet_aton(strVal, &inIp) ) {
			strcpy(tmpBuf, strInvdRSIPValue);
			goto setErr_encrypt;
		}
		*((unsigned long *)Entry.rsIpAddr) = inIp.s_addr;

		strVal = boaGetVar(wp, "radiusPass", "");
		if (strlen(strVal) > (MAX_PSK_LEN) ) {
			strcpy(tmpBuf, strRSPwdTooLong);
			goto setErr_encrypt;
		}
		strcpy(Entry.rsPassword, strVal);

		strVal = boaGetVar(wp, "radiusRetry", "");
		if (strVal[0]) {
			if ( !string_to_dec(strVal, &intVal) ) {
				strcpy(tmpBuf, strInvdRSRetry);
				goto setErr_encrypt;
			}
			vChar = (char)intVal;
			if ( !mib_set(MIB_WLAN_RS_RETRY, (void *)&vChar)) {
				strcpy(tmpBuf, strSetRSRETRYErr);
				goto setErr_encrypt;
			}
		}
		strVal = boaGetVar(wp, "radiusTime", "");
		if (strVal[0]) {
			if ( !string_to_dec(strVal, &intVal) ) {
				strcpy(tmpBuf, strInvdRSTime);
				goto setErr_encrypt;
			}
			uShort = (unsigned short)intVal;
			if ( !mib_set(MIB_WLAN_RS_INTERVAL_TIME, (void *)&uShort)) {
				strcpy(tmpBuf, strSetRSINTVLTIMEErr);
				goto setErr_encrypt;
			}
		}

get_wepkey:
		// get 802.1x WEP key length
		strVal = boaGetVar(wp, "wepKeyLen", "");
		if (strVal[0]) {
			if ( !gstrcmp(strVal, "wep64"))
				vChar = WEP64;
			else if ( !gstrcmp(strVal, "wep128"))
				vChar = WEP128;
			else {
				strcpy(tmpBuf, strInvdWepKeyLen);
				goto setErr_encrypt;
			}
			Entry.wep = vChar;
		}
	}
#endif

	wlan_setEntry(&Entry, wlmib_idx);

	//sleep(5);

//---------------------------------
//WPS
#if  defined(CONFIG_WIFI_SIMPLE_CONFIG)
	char tmpbuf_wps[200];
	int action, ssididx;
	pid_t pid;
	char *msg = "echo 1> /var/cmcc_wsc_running";
	char wps_ifname[IFNAMSIZ]={0};

	wlan_getEntry((void *)&Entry, wlmib_idx);

	strVal  = boaGetVar(wp, "action", "");
	action = strVal[0] - '0';
	if(strVal[0] && action!=0)
	{
#ifndef WLAN_WPS_MULTI_DAEMON
		if(wlan_idx==0) 
			ssididx = 1;
		else
			ssididx = 5;
#ifdef WLAN_WPS_VAP
		set_wps_ssid(ssididx);
#endif
#endif

		if (Entry.wsc_disabled) {
			Entry.wsc_disabled = 0;
			wlan_setEntry((void *)&Entry, wlmib_idx);
			mib_update(CURRENT_SETTING, CONFIG_MIB_ALL);	// update to flash
			system("echo 1 > /var/wps_start_pbc");
#ifndef NO_ACTION
			run_init_script("bridge");
#endif
		}
		else {
#ifndef WLAN_WPS_MULTI_DAEMON
			if(wlan_idx == 0 )
			{
				system("echo 1 > /var/wps_start_interface0");
			}
			else
			{
				system("echo 1 > /var/wps_start_interface1");

			}
#endif
			rtk_wlan_get_ifname(wlan_idx, 0, wps_ifname);
			va_niced_cmd(WSC_DAEMON_PROG, 2 , 1 , "-sig_pbc" , wps_ifname);
		}

		if (action == 1)
		{
			pid = fork();
			if (pid==0)
			{
				start_PBC(msg);
				exit(0);
			}
		}
		else if(action == 2)
		{
			stop_PBC(msg);
		}

		submitUrl = boaGetVar(wp, "submit-url", "");
		boaRedirect(wp, submitUrl);
		return;
	}

	if(wlmib_idx == 0){ //update for root ssid only
		strVal = boaGetVar(wp, "disableWPS", "");
		if ( !strcmp(strVal, "ON") )
		{
			intVal = 0;
		}
		else
		{
			intVal = 1;
		}

		Entry.wsc_disabled = intVal;
		wlan_setEntry((void *)&Entry, wlmib_idx);
#ifndef WLAN_WPS_VAP
		update_wps_mib();
#endif

		if(Entry.wsc_disabled == 0){
			strVal = boaGetVar(wp, "localPin", "");
			if (strVal[0]){
				int local_pin_changed = 0;
				char wpin[PIN_LEN+1]={0};
				mib_get_s(MIB_WSC_PIN, (void *)wpin, sizeof(wpin));
				if (strcmp(wpin, strVal)) {
					mib_set(MIB_WSC_PIN, (void *)strVal);
					local_pin_changed = 1;
#ifdef WLAN_DUALBAND_CONCURRENT
					both_band_modify = 1;
#endif
				}
				#if 0
				if(local_pin_changed){
					if(wlan_idx==0) 
						ssididx = 1;
					else
						ssididx = 5;
					mib_get_s(MIB_WPS_SSID, &vChar, sizeof(vChar));
					if(vChar != ssididx){
						vChar = ssididx;
						mib_set(MIB_WPS_SSID, &vChar);
					}
				}
				#endif
			}
		}
	}

#endif

setwlan_ret:
#ifdef CONFIG_WIFI_SIMPLE_CONFIG//WPS def WIFI_SIMPLE_CONFIG
	{
		int ret;
		char *wepKey;
		wepKey = boaGetVar(wp, "wps_clear_configure_by_reg0", "");
		ret = 0;
		if (wepKey && wepKey[0])
			ret = atoi(wepKey);
		update_wps_configured(ret);
	}
#endif
setwlan_module_disable:

submitUrl = boaGetVar(wp, "submit-url", "");   // hidden page

// Magician: Commit immediately
#ifdef COMMIT_IMMEDIATELY
	Commit();
#endif // of #if COMMIT_IMMEDIATELY

#ifndef NO_ACTION
	run_script(mode);
#endif

	if(wlan_idx == 0)
	{
#ifdef WLAN_DUALBAND_CONCURRENT
		if(both_band_modify==1)
			config_WLAN(ACT_RESTART, CONFIG_SSID_ALL);
		else
#endif
#ifndef WLAN_DUALBAND_CONCURRENT
		if(all_ssid_modify==1)
			config_WLAN(ACT_RESTART_2G, CONFIG_SSID_ALL);
		else
#endif
		{
			config_WLAN(get_wlan_phyband()==PHYBAND_2G? ACT_RESTART_2G: ACT_RESTART_5G, wlmib_idx);
		}
		
	}
	else
	{
#ifdef WLAN_DUALBAND_CONCURRENT
		if(both_band_modify==1)
			config_WLAN(ACT_RESTART, CONFIG_SSID_ALL);
		else
#endif	
			config_WLAN(get_wlan_phyband()==PHYBAND_2G? ACT_RESTART_2G: ACT_RESTART_5G, wlmib_idx);
		
	}
	if(get_wlan_phyband()==PHYBAND_2G)
		syslog(LOG_INFO, "WlanSetup: Update 2G ssid-%d configuration", wlmib_idx+1);
	else
		syslog(LOG_INFO, "WlanSetup: Update 5G ssid-%d configuration", wlmib_idx+1);
//	submitUrl = boaGetVar(wp, "submit-url", "");   // hidden page
	if (warn) {
		OK_MSG1(tmpBuf, submitUrl);
	}
	else {
		//OK_MSG(submitUrl);
		if (submitUrl[0])
			boaRedirect(wp, submitUrl);
		else
			boaDone(wp, 200);
	}
	return;

setErr_wlan:
	ERR_MSG(tmpBuf);

setErr_encrypt:
	ERR_MSG(tmpBuf);
}
#else
#ifdef BAND_STEERING_SUPPORT
int wlan_band_steering_update(char vChar){
	int 	ret = 0,val = 0;
	char 	if_name0[16], 	if_name1[16];
	MIB_CE_MBSSIB_T 		bsEntry0,  bsEntry1;
	RTK_WLAN_ENCRYPT_INFO 	pEncInfo0, pEncInfo1;

	wlan_idx = 0;
	memset(&bsEntry0,0,sizeof(bsEntry0));
	if(!mib_chain_get(MIB_MBSSIB_TBL, 0, (void *)&bsEntry0)){//get wlan0 ssid name
		printf("[%s:%d]mib get chain error!",__FUNCTION__,__LINE__);
		return -1;
	}
	memset(if_name0,0,sizeof(if_name0));
	snprintf(if_name0,sizeof(if_name0),WLAN_IF,wlan_idx);
	memset(&pEncInfo0,0,sizeof(pEncInfo0));
	ret = rtk_wlan_get_encryption(if_name0,&pEncInfo0);//get wlan0 encryption
	if(ret){
		printf("get (%s) encryption info failed!\n",if_name0);
		return ret;
	}
	wlan_idx = 1;
	memset(&bsEntry1,0,sizeof(bsEntry1));
	if(!mib_chain_get(MIB_MBSSIB_TBL, 0, (void *)&bsEntry1)){//get wlan1 ssid name
		printf("[%s:%d]mib get chain error!",__FUNCTION__,__LINE__);
		return -1;
	}
	memset(if_name1,0,sizeof(if_name1));
	snprintf(if_name1,sizeof(if_name1),WLAN_IF,wlan_idx);
	memset(&pEncInfo1,0,sizeof(pEncInfo1));
	ret = rtk_wlan_get_encryption(if_name1,&pEncInfo1);//get wlan1 encryption
	if(ret){
		printf("get (%s) encryption info failed!\n",if_name1);
		return ret;
	}
#ifdef CONFIG_BAND_5G_ON_WLAN0
	if(vChar == 0)
#else
	if(vChar == 1)
#endif
	{
		wlan_idx = 1;
		if(strcmp(bsEntry0.ssid, bsEntry1.ssid)){
			printf("[%s:%d]===ssid is not same===\n", __FUNCTION__,__LINE__);
			strncpy(bsEntry1.ssid, bsEntry0.ssid, sizeof(bsEntry1.ssid));
			val = wlan_setEntry((void *)&bsEntry1, 0);
		}
		if(memcmp(&pEncInfo0, &pEncInfo1, sizeof(RTK_WLAN_ENCRYPT_INFO))){
			printf("[%s:%d]Encryption is not same！\n", __FUNCTION__,__LINE__);
			ret = rtk_wlan_set_encryption(if_name1,pEncInfo0);//set wlan1 encryption same as wlan0
			if(ret){
				printf("Set (%s) encryption info failed!\n",if_name1);
				return ret;
			}
		}
	}
#ifdef CONFIG_BAND_5G_ON_WLAN0
	if(vChar == 1)
#else
	if(vChar == 0)
#endif
	{
		wlan_idx = 0;
		if(strcmp(bsEntry0.ssid, bsEntry1.ssid)){
			printf("[%s:%d]===ssid is not same===\n", __FUNCTION__,__LINE__);
			strncpy(bsEntry0.ssid, bsEntry1.ssid, sizeof(bsEntry0.ssid));
			val = wlan_setEntry((void *)&bsEntry0, 0);//set wlan0 ssid name
		}
		if(memcmp(&pEncInfo0, &pEncInfo1, sizeof(RTK_WLAN_ENCRYPT_INFO))){
			printf("[%s:%d]Encryption is not same！\n", __FUNCTION__,__LINE__);
			ret = rtk_wlan_set_encryption(if_name0,pEncInfo1);//set wlan0 encryption same as wlan1
			if(ret){
				printf("Set (%s) encryption info failed!\n",if_name0);
				return ret;
			}
		}
	}
	return ret;
}
#endif

void formWlanSetup(request * wp, char *path, char *query)
{
	char *submitUrl, *strSSID, *strChan, *strDisabled, *strVal;
	char vChar, chan, disabled, mode=-1;
#ifdef CONFIG_CU_BASEON_CMCC
	unsigned char fakeTxPower;
#endif
	NETWORK_TYPE_T net;
	char tmpBuf[100];
	int flags;
	MIB_CE_MBSSIB_T Entry;
	int warn = 0;
	unsigned short uShort=0;
	int vInt=0, ssidIdx=0;
	unsigned char update_all_ssid=0;
	int intVal;

#ifdef WLAN_UNIVERSAL_REPEATER
	MIB_CE_MBSSIB_T repeaterEntry;
#endif
#if defined(WLAN_DUALBAND_CONCURRENT)
	char phyBandSelect, wlanBand2G5GSelect, phyBandOrig, wlanBand2G5GSelect_single;
	int phyBandSelectChange = 0;
	char lan_ip[30];
	int orig_idx;
	int both_band_modify=0;
#ifdef WLAN_BAND_STEERING
	unsigned char sta_control=0, sta_control_change=0;
#endif
#endif // WLAN_DUALBAND_CONCURRENT
#ifdef BAND_STEERING_SUPPORT
	unsigned char band_steering_enable;
	unsigned char band_steering_prefer;
	int 	wlan_idx_orig;
	unsigned char tmp_band_steering_enable;
#endif
#ifdef CONFIG_CU
	char psk[MAX_PSK_LEN+1] = {0};
#endif
	int i;

#if defined(WLAN_DUALBAND_CONCURRENT)
	strVal = boaGetVar(wp, "wlan_idx", "");
	if ( strVal[0] ) {
		printf("wlan_idx=%d\n", strVal[0]-'0');
		wlan_idx = strVal[0]-'0';
	}
#endif

	strVal = boaGetVar(wp, "ssid_idx", "");
	ssidIdx = strVal[0] - '0'; 

	mib_chain_get(MIB_MBSSIB_TBL, ssidIdx, (void *)&Entry);

	strDisabled = boaGetVar(wp, "wlanDisabled", "");

	if ( !gstrcmp(strDisabled, "ON") )
		disabled = 1;
	else
		disabled = 0;

	strDisabled = boaGetVar(wp, "wlanEnabled", "");

	if ( !gstrcmp(strDisabled, "ON") )
		disabled = 0;
	else
		disabled = 1;

#if 0	
	if (getInFlags(getWlanIfName(), &flags) == 1) {
		if (disabled)
			flags &= ~IFF_UP;
		else
			flags |= IFF_UP;

		setInFlags(getWlanIfName(), flags);
	}
#endif

#ifdef YUEME_3_0_SPEC
	mib_get_s(MIB_WLAN_MODULE_DISABLED, (void *)&vChar, sizeof(vChar));
	if(vChar!=disabled)
		update_all_ssid = 1;
	mib_set(MIB_WLAN_MODULE_DISABLED, (void *)&disabled);
#else
	mib_get_s(MIB_WIFI_MODULE_DISABLED, (void *)&vChar, sizeof(vChar));
	if(vChar!=disabled){
		update_all_ssid = 1;
#ifdef WLAN_DUALBAND_CONCURRENT
		both_band_modify = 1;
#endif
	}
	mib_set(MIB_WIFI_MODULE_DISABLED, (void *)&disabled);
#endif

	if ( disabled ){
#ifdef YUEME_3_0_SPEC
#ifdef WLAN_BAND_STEERING
		mib_get_s(MIB_WIFI_STA_CONTROL, (void *)&sta_control, sizeof(sta_control));
		if(sta_control==1)
		{
			sta_control = 0;
			if ( mib_set( MIB_WIFI_STA_CONTROL, (void *)&sta_control) == 0)
			{
				goto setErr_wlan;
			}
			both_band_modify = 1;
			SetOrCancelSameSSID(sta_control);
		}
#endif
#endif
		syslog(LOG_INFO, "WlanSetup: Disable Wlan");
		goto setwlan_module_disable;
	}

	strVal = boaGetVar(wp, "enableSSID", "");
	if( !gstrcmp(strVal, "ON") )
	{
#ifdef CONFIG_USER_CTCAPD
		Entry.wlanDisabled = 0;
		Entry.func_off = 0;
#else
		Entry.wlanDisabled = 0;
#endif
	}
	else
	{
#ifdef CONFIG_USER_CTCAPD
		Entry.func_off = 1;
#else
		Entry.wlanDisabled = 1;
#endif
#ifdef WLAN_BAND_STEERING
		mib_get_s(MIB_WIFI_STA_CONTROL, (void *)&sta_control, sizeof(sta_control));
		if(sta_control==1)
		{
			sta_control = 0;
			if ( mib_set( MIB_WIFI_STA_CONTROL, (void *)&sta_control) == 0)
			{
				goto setErr_wlan;
			}
			both_band_modify = 1;
			sta_control_change = 1;
		}
#endif
	}


	if(ssidIdx==0)
	{
		
#ifdef WLAN_BAND_STEERING
		if(Entry.wlanDisabled == 0)
		{
			strDisabled = boaGetVar(wp, "wlanStaControl", "");

			if ( !gstrcmp(strDisabled, "ON") )
				vChar = 1;
			else
				vChar = 0;

			mib_get_s(MIB_WIFI_STA_CONTROL, (void *)&sta_control, sizeof(sta_control));
			
			if(sta_control!=vChar || vChar&&wlan_idx==0)
			{
				both_band_modify = 1;
				sta_control_change = 1;
			}
			sta_control = vChar;

			if ( mib_set( MIB_WIFI_STA_CONTROL, (void *)&vChar) == 0) {
				goto setErr_wlan;
			}
		}
#endif

#ifdef WLAN_RATE_PRIOR
		strVal = boaGetVar(wp, "wlanRatePrior", "");

		if ( !gstrcmp(strVal, "ON") )
			vChar = 1;
		else
			vChar = 0;
		if ( mib_set( MIB_WLAN_RATE_PRIOR, (void *)&vChar) == 0) {
			goto setErr_wlan;
		}
#endif

		// Added by Mason Yu for TxPower
		strVal = boaGetVar(wp, "txpower", "");
#ifdef CONFIG_CU_BASEON_CMCC
		printf("strVal is %s.\n", strVal);
#endif
#if defined(CONFIG_USER_AP_CMCC) && defined(CONFIG_USER_ANDLINK_PLUGIN)
		if ( strVal[0] ) {
			if (strVal[0] < '0' || strVal[0] > '9') {
				//strcpy(tmpBuf, strInvdTxPower);
				snprintf(tmpBuf, sizeof(tmpBuf), "%s", strInvdTxPower);
				goto setErr_wlan;
			}
			mode = strVal[0] - '0';
			vChar = mode * 10;

			if ( mib_set( MIB_TX_POWER, (void *)&vChar) == 0) {
				//strcpy(tmpBuf, strSetMIBTXPOWErr);
				snprintf(tmpBuf, sizeof(tmpBuf), "%s", strSetMIBTXPOWErr);
				goto setErr_wlan;
			}
		}
#else
		if ( strVal[0] ) {

			if (strVal[0] < '0' || strVal[0] > '5') {
				//strcpy(tmpBuf, strInvdTxPower);
				snprintf(tmpBuf, sizeof(tmpBuf), "%s", strInvdTxPower);
				goto setErr_wlan;
			}

#ifdef CONFIG_CU_BASEON_CMCC
			if(strVal[0]=='5') {
				fakeTxPower = 1;
				mib_set( MIB_FAKE_TX_POWER, (void *)&fakeTxPower);
				mode = 4;
			}else{
				fakeTxPower = 0;
				mib_set( MIB_FAKE_TX_POWER, (void *)&fakeTxPower);
				mode = strVal[0] - '0';
			}
#else 
			if(strVal[0]=='5')
				mode = 0;
			else
				mode = strVal[0] - '0';
#endif
			if ( mib_set( MIB_TX_POWER, (void *)&mode) == 0) {
				strlcpy(tmpBuf, strSetMIBTXPOWErr, sizeof(tmpBuf));
				goto setErr_wlan;
			}

			if(strVal[0]=='5')
				mode = 1;
			else
				mode = 0;

			if ( mib_set( MIB_WLAN_TX_POWER_HIGH, (void *)&mode) == 0) {
				strlcpy(tmpBuf, strSetMIBTXPOWErr, sizeof(tmpBuf));
				goto setErr_wlan;
			}
			

		}
#endif
	}

	strVal = boaGetVar(wp, "mode", "");
	if ( strVal[0] ) {
		if (strVal[0]!= '0' && strVal[0]!= '1' && strVal[0]!= '2' && strVal[0]!= '3') {
			//strcpy(tmpBuf, strInvdMode);
			snprintf(tmpBuf, sizeof(tmpBuf), "%s", strInvdMode);
			goto setErr_wlan;
		}
		mode = strVal[0] - '0';

#ifdef WLAN_CLIENT
		if (mode == CLIENT_MODE) {
			WIFI_SECURITY_T encrypt;

			vChar = Entry.encrypt;
			encrypt = (WIFI_SECURITY_T)vChar;
			if (encrypt == WIFI_SEC_WPA || encrypt == WIFI_SEC_WPA2) {
				vChar = Entry.wpaAuth;
				if (vChar & 1) { // radius
					//strcpy(tmpBuf, strSetWPAWarn);
					snprintf(tmpBuf, sizeof(tmpBuf), "%s", strSetWPAWarn);
					goto setErr_wlan;
				}
			}
			else if (encrypt == WIFI_SEC_WEP) {
				vChar = Entry.enable1X;
				if (vChar & 1) {
					//strcpy(tmpBuf, strSetWEPWarn);
					snprintf(tmpBuf, sizeof(tmpBuf), "%s", strSetWEPWarn);
					goto setErr_wlan;
				}
			}
			else if (encrypt == WIFI_SEC_WPA2_MIXED) {
				vChar = WIFI_SEC_WPA2;
				Entry.encrypt = vChar;
				strlcpy(tmpBuf, "警告! WPA2混合模式不支援client mode <BR> 请改为WPA2加密!", sizeof(tmpBuf));
				warn = 1;
			}
		}
#endif
		Entry.wlanMode = mode;
	}

#ifdef CONFIG_RTK_SSID_PRIORITY
		 strVal = boaGetVar(wp, "ssidpri", "");
		 if ( strVal[0] ) {
		   if ( strVal[0] == '0')
			   vChar = 0;
		   else if (strVal[0] == '1')
			   vChar = 1;
		   else if (strVal[0] == '2')	   
			   vChar = 3;
		   else if (strVal[0] == '3')	   
			   vChar = 5;
		   else if (strVal[0] == '4')	   
			   vChar = 7;	   
		   else {
				strlcpy(tmpBuf, "Error! Invalid SSID Priority.", sizeof(tmpBuf));
				goto setErr_wlan;
			}
	   
		 Entry.manual_priority=vChar;
	}
#endif
	strSSID = boaGetVar(wp, "ssid", "");
	
	if ( strSSID[0] ) {
		char real_ssid[64] = "";
#if defined(CONFIG_CU_BASEON_CMCC)
		unsigned char ssidprefix_enable = 0;

		mib_get_s(MIB_WEB_WLAN_SSIDPREFIX_ENABLE, &ssidprefix_enable, sizeof(ssidprefix_enable));
		if (ssidprefix_enable==1)
			sprintf(real_ssid, "CU_%s", strSSID);
		else
			sprintf(real_ssid, "%s", strSSID);
#elif defined(CONFIG_CMCC)
		unsigned char ssidprefix_enable = 0;

		mib_get_s(MIB_WEB_WLAN_SSIDPREFIX_ENABLE, &ssidprefix_enable, sizeof(ssidprefix_enable));
		if (ssidprefix_enable==1)
			sprintf(real_ssid, "CMCC-%s", strSSID);
		else
			sprintf(real_ssid, "%s", strSSID);
#else
		sprintf(real_ssid, "%s", strSSID);
#endif
		//strcpy(Entry.ssid, real_ssid);
		Entry.ssid[sizeof(Entry.ssid)-1]='\0';
		strncpy(Entry.ssid, real_ssid, sizeof(Entry.ssid)-1);
	}
	//else if ( mode == 1 && !strSSID[0] ) { // client and NULL SSID
	//	if ( mib_set(MIB_WLAN_SSID, (void *)strSSID) == 0) {
   	// 			strcpy(tmpBuf, strSetSSIDErr);
	//			goto setErr_wlan;
	//	}
	//}

	if(ssidIdx==0)
	{
		strChan = boaGetVar(wp, "chan", "");
		if ( strChan[0] ) {
			errno=0;
			chan = strtol( strChan, (char **)NULL, 10);
			if (errno) {
	   			//strcpy(tmpBuf, strInvdChanNum);
	   			snprintf(tmpBuf, sizeof(tmpBuf), "%s", strInvdChanNum);
				goto setErr_wlan;
			}
			if(chan != 0)
			{
				vChar = 0;	//disable auto channel
				if ( mib_set( MIB_WLAN_CHAN_NUM, (void *)&chan) == 0) {
					//strcpy(tmpBuf, strSetChanErr);
					snprintf(tmpBuf, sizeof(tmpBuf), "%s", strSetChanErr);
					goto setErr_wlan;
				}
			}
			else
				vChar = 1;	//enable auto channel

			if ( mib_set( MIB_WLAN_AUTO_CHAN_ENABLED, (void *)&vChar) == 0) {
				//strcpy(tmpBuf, strSetChanErr);
				snprintf(tmpBuf, sizeof(tmpBuf), "%s", strSetChanErr);
				goto setErr_wlan;
			}
		}
	}
#if 0// defined(WLAN0_5G_SUPPORT) || defined(WLAN1_5G_SUPPORT)
	{
		char band2G5GSelect = 0;
		char band_no, band_val;
		strVal = boaGetVar(wp, "Band2G5GSupport", "");
		if(strVal[0])
		{
			band2G5GSelect = atoi(strVal);
			printf("band2G5GSelect = %d\n", band2G5GSelect);
		}
		strVal = boaGetVar(wp, "band", "");
		if(strVal[0])
		{
			band_no = atoi(strVal);
			//printf("band_no = %d\n", band_no);
		}
		if(band_no==3 || band_no==11 || band_no==63 || band_no==71 || band_no==75)
			band_val = 2;
		else if(band_no==7)
		{
			band_val = band2G5GSelect;
		}
		else
			band_val = 1;

		if ( mib_set( MIB_WLAN_PHY_BAND_SELECT, (void *)&band_val) == 0) {
			strcpy(tmpBuf, ("Set band error!"));
			goto setErr_wlan;
		}
	}
#endif

	char *strRate;
	unsigned short val;

	strVal = boaGetVar(wp, "band", "");
	if ( strVal[0] ) {
		mode = atoi(strVal);
		mode++;

		update_on_band_changed(&Entry, 0, mode);

		if(ssidIdx==WLAN_ROOT_ITF_INDEX)
			update_vap_band(mode); // Update vap band based on root band

#if	defined(WLAN_BAND_CONFIG_MBSSID) || defined(WLAN_BAND_SETTING)
		Entry.wlanBand = mode;
#else
		if ( mib_set( MIB_WLAN_BAND, (void *)&mode) == 0) {
			strcpy(tmpBuf, strSetBandErr);
			goto setErr_wlan;
		}
#endif
	}
/*
	strRate = boaGetVar(wp, "basicrates", "");
	if ( strRate[0] ) {
		val = atoi(strRate);
		if ( mib_set(MIB_WLAN_BASIC_RATE, (void *)&val) == 0) {
			strcpy(tmpBuf, strSetBaseRateErr);
			goto setErr_wlan;
		}
	}

	strRate = boaGetVar(wp, "operrates", "");
	if ( strRate[0] ) {
		val = atoi(strRate);
		if ( mib_set(MIB_WLAN_SUPPORTED_RATE, (void *)&val) == 0) {
			strcpy(tmpBuf, strSetOperRateErr);
			goto setErr_wlan;
		}
	}
*/
	if(ssidIdx==0)
	{
		strVal = boaGetVar(wp, "chanwid", "");            //add by yq_zhou 2.10
		if ( strVal[0] ) {
			unsigned char band = 0;
			mib_get_s(MIB_WLAN_PHY_BAND_SELECT, (void *)&band, sizeof(band));
			mode = strVal[0] - '0';

			if(mode == 2 && band == PHYBAND_2G) //20/40MHz
			{
				mode--;
				vChar = 1;
			}
			else
				vChar = 0;
			if ( mib_set( MIB_WLAN_CHANNEL_WIDTH, (void *)&mode) == 0) {
				//strcpy(tmpBuf, strSetChanWidthErr);
				snprintf(tmpBuf, sizeof(tmpBuf), "%s", strSetChanWidthErr);
				goto setErr_wlan;
			}
			if ( mib_set( MIB_WLAN_11N_COEXIST, (void *)&vChar) == 0) {
				//strcpy(tmpBuf, strSet11NCoexistErr);
				snprintf(tmpBuf, sizeof(tmpBuf), "%s", strSet11NCoexistErr);
				goto setErr_wlan;
			}
		}

		strVal = boaGetVar(wp, "ctlband", "");            //add by yq_zhou 2.10
		if ( strVal[0] ) {
			mode = strVal[0] - '0';
			if ( mib_set( MIB_WLAN_CONTROL_BAND, (void *)&mode) == 0) {
				//strcpy(tmpBuf, strSetCtlBandErr);
				snprintf(tmpBuf, sizeof(tmpBuf), "%s", strSetCtlBandErr);
				goto setErr_wlan;
			}
		}
	}

	// set tx rate
	strRate = boaGetVar(wp, "txRate", "");
	if ( strRate[0] ) {
		if ( strRate[0] == '0' ) { // auto
			Entry.rateAdaptiveEnabled = 1;
		}
		else  {
			Entry.rateAdaptiveEnabled = 0;
			{
				unsigned int uInt;
				uInt = atoi(strRate);
#if defined(WLAN_11AX) && !defined(WIFI5_WIFI6_COMP)
				if(uInt<13)
					uInt = uInt-1;
				else if(uInt>=13 && uInt<45){//MCS
					uInt = 0x80 + uInt-13;
				}
				else if(uInt>=45 && uInt<85){//VHT
					uInt = uInt-45;
					uInt = 0x100 + (uInt/10)*(0x10) + (uInt%10);
				}
				else if(uInt>=85){//HE
					uInt = uInt-85;
					uInt = 0x180 + (uInt/12)*(0x10) + (uInt%12);
				}
#else

				if((uInt<29) && (uInt>0))
					uInt = 1 << (uInt-1);
				else if(uInt>=29 && uInt<45)
					uInt = ((1 << 28) + (uInt-29));
				else
					uInt = ((1 << 31) + (uInt-45));
#endif
				Entry.fixedTxRate = uInt;
			}
		}

		strRate = boaGetVar(wp, "basicrates", "");
		if ( strRate[0] ) {
			val = atoi(strRate);
			if(val != 0)
			{
				if ( mib_set(MIB_WLAN_BASIC_RATE, (void *)&val) == 0) {
					//strcpy(tmpBuf, strSetBaseRateErr);
					snprintf(tmpBuf, sizeof(tmpBuf), "%s", strSetBaseRateErr);
					goto setErr_wlan;
				}
			}
		}

		strRate = boaGetVar(wp, "operrates", "");
		if ( strRate[0] ) {
			val = atoi(strRate);
			if(val != 0)
			{
				if ( mib_set(MIB_WLAN_SUPPORTED_RATE, (void *)&val) == 0) {
					//strcpy(tmpBuf, strSetOperRateErr);
					snprintf(tmpBuf, sizeof(tmpBuf), "%s", strSetOperRateErr);
					goto setErr_wlan;
				}
			}
		}
	}
	else { // set rate in operate, basic sperately
#ifdef WIFI_TEST
		// disable rate adaptive
		Entry.rateAdaptiveEnabled = 0;
#endif // of WIFI_TEST
	}

	if(ssidIdx==0)
	{
		strVal = boaGetVar(wp, "beaconInterval", "");
		if (strVal[0]) {
			if ( !string_to_dec(strVal, &vInt) || vInt<MIN_WLAN_BEACON_INTERVAL || vInt>1024) {
				//strcpy(tmpBuf, strInvdBeaconIntv);
				snprintf(tmpBuf, sizeof(tmpBuf), "%s", strInvdBeaconIntv);
				goto setErr_wlan;
			}
			uShort = (unsigned short)vInt;
			if ( mib_set(MIB_WLAN_BEACON_INTERVAL, (void *)&uShort) == 0) {
				//strcpy(tmpBuf, strSetBeaconIntvErr);
				snprintf(tmpBuf, sizeof(tmpBuf), "%s", strSetBeaconIntvErr);
				goto setErr_wlan;
			}
		}

		strVal = boaGetVar(wp, "dtimPeriod", "");
		if (strVal[0]) {
			if ( !string_to_dec(strVal, &vInt) || vInt<1 || vInt>255) {
				//strcpy(tmpBuf, strInvdDTIMPerd);
				snprintf(tmpBuf, sizeof(tmpBuf), "%s", strInvdDTIMPerd);
				goto setErr_wlan;
			}
			vChar = (char)vInt;
			if ( mib_set(MIB_WLAN_DTIM_PERIOD, (void *)&vChar) == 0) {
				//strcpy(tmpBuf, strSetDTIMErr);
				snprintf(tmpBuf, sizeof(tmpBuf), "%s", strSetDTIMErr);
				goto setErr_wlan;
			}
		}
	}

	// set hidden SSID
	strVal = boaGetVar(wp, "hiddenSSID", "");
	if (!gstrcmp(strVal, "ON"))
		vChar = 1;
	else
		vChar = 0;
	
	Entry.hidessid = vChar;

#ifdef CONFIG_CU_BASEON_YUEME
	// set portIsolation
	strVal = boaGetVar(wp, "portIsolation", "");
	if (!gstrcmp(strVal, "ON"))
		vChar = 1;
	else
		vChar = 0;
	
	Entry.userisolation = vChar;
	Entry.accessRuleEnable = vChar;
#ifdef CONFIG_E8B
	Entry.ssidisolation = vChar;
#endif	
#endif

	if(ssidIdx==0)
	{
		strVal = boaGetVar(wp, "shortGI0", "");
		if (strVal[0]) {
		
			if (strVal[0] == '0')
			{
				vChar = 0;
			}
			else 
			{
				vChar = 1;
			}

			if (mib_set(MIB_WLAN_SHORTGI_ENABLED,(void *)&vChar) ==0){
				//strcpy(tmpBuf, strSetShortGI0Err);
				snprintf(tmpBuf, sizeof(tmpBuf), "%s", strSetShortGI0Err);
				goto setErr_wlan;
			}
		}
	}
#ifdef WLAN_11K
	strVal = boaGetVar(wp, "dot11kEnabled", "");
	if (strVal[0]) {
		if (strVal[0] == '0')
			Entry.rm_activated = 0;
		else // '1'
			Entry.rm_activated = 1;
	}
#endif
#ifdef WLAN_11V
	strVal = boaGetVar(wp, "dot11vEnabled", "");
	if (strVal[0]) {
		if (strVal[0] == '0')
			Entry.BssTransEnable = 0;
		else // '1'
			Entry.BssTransEnable = 1;
	}
#endif

	mib_chain_update(MIB_MBSSIB_TBL, (void *)&Entry, ssidIdx);

//--------------------------------
// Encrypt
{
	char *strEncrypt;
	char *strKeyLen, *strFormat, *wepKey, *strAuth;
	int key_index=0, key_i;
	char *strKeySelcted;
	char strbuf_idx[16], strbuf_errmsg1[16], strbuf_errmsg2[16];
	WIFI_SECURITY_T encrypt;
	int enableRS=0, getPSK=0, len, keyLen;
	SUPP_NONWAP_T suppNonWPA;
	struct in_addr inIp;
	WEP_T wep;
	char key[30];
	AUTH_TYPE_T authType;
	int i, eraseKey=0;

	i = ssidIdx;

	strEncrypt = boaGetVar(wp, "security_method", "");
	if (!strEncrypt[0]) {
 		//strcpy(tmpBuf, strNoEncryptionErr);
 		snprintf(tmpBuf, sizeof(tmpBuf), "%s", strNoEncryptionErr);
		goto setErr_encrypt;
	}

	encrypt = atoi(strEncrypt);
	vChar = (char)encrypt;
	Entry.encrypt = vChar;

	if (encrypt == WIFI_SEC_NONE || encrypt == WIFI_SEC_WEP) {

#ifdef WLAN_1x
		strVal = boaGetVar(wp, "use1x", "");
		if ( !gstrcmp(strVal, "ON")) {
			vChar = Entry.wlanMode;
			if (vChar) { // not AP mode
				//strcpy(tmpBuf, strSet8021xWarning);
				snprintf(tmpBuf, sizeof(tmpBuf), "%s", strSet8021xWarning);
				goto setErr_encrypt;
			}
			vChar = 1;
			enableRS = 1;
		}
		else
			vChar = 0;
		Entry.enable1X = vChar;
#endif

		if (encrypt == WIFI_SEC_WEP) {
	 		WEP_T wep;
			// Mason Yu. 201009_new_security. If wireless do not use 802.1x for wep mode. We should set wep key and Authentication type.
			if ( enableRS != 1 ) {
				// (1) Authentication Type
				strAuth = boaGetVar(wp, "auth_type", "");
				if (strAuth[0]) {
					if ( !gstrcmp(strAuth, "open"))
						authType = AUTH_OPEN;
					else if ( !gstrcmp(strAuth, "shared"))
						authType = AUTH_SHARED;
					else if ( !gstrcmp(strAuth, "both"))
						authType = AUTH_BOTH;
					else {
						//strcpy(tmpBuf, strInvdAuthType);
						snprintf(tmpBuf, sizeof(tmpBuf), "%s", strInvdAuthType);
						goto setErr_encrypt;
					}
					vChar = (char)authType;
					Entry.authType = vChar;
				}

				// (2) Key Length
				strKeyLen = boaGetVar(wp, "length0", "");
				if (!strKeyLen[0]) {
 					//strcpy(tmpBuf, strKeyLenMustExist);
 					snprintf(tmpBuf, sizeof(tmpBuf), "%s", strKeyLenMustExist);
					goto setErr_encrypt;
				}
				if (strKeyLen[0]!='1' && strKeyLen[0]!='2') {
 					//strcpy(tmpBuf, strInvdKeyLen);
 					snprintf(tmpBuf, sizeof(tmpBuf), "%s", strInvdKeyLen);
					goto setErr_encrypt;
				}
				if (strKeyLen[0] == '1')
					wep = WEP64;
				else
					wep = WEP128;

				vChar = (char)wep;
				Entry.wep = vChar;

				// (3) Key Format
				strFormat = boaGetVar(wp, "format0", "");
				if (!strFormat[0]) {
 					//strcpy(tmpBuf, strKeyTypeMustExist);
 					snprintf(tmpBuf, sizeof(tmpBuf), "%s", strKeyTypeMustExist);
					goto setErr_encrypt;
				}

				if (strFormat[0]!='1' && strFormat[0]!='2') {
					//strcpy(tmpBuf, strInvdKeyType);
					snprintf(tmpBuf, sizeof(tmpBuf), "%s", strInvdKeyType);
					goto setErr_encrypt;
				}

				vChar = (char)(strFormat[0] - '0' - 1);
				Entry.wepKeyType = vChar;

				if (wep == WEP64) {
					if (strFormat[0]=='1')
						keyLen = WEP64_KEY_LEN;
					else
						keyLen = WEP64_KEY_LEN*2;
				}
				else {
					if (strFormat[0]=='1')
						keyLen = WEP128_KEY_LEN;
					else
						keyLen = WEP128_KEY_LEN*2;
				}

#if defined(CONFIG_CMCC) || defined(CONFIG_CU_BASEON_CMCC)
				// Key selected
				strKeySelcted = boaGetVar(wp, "defaultKeyidx", "");
				if (!strKeySelcted[0]) {
					//strcpy(tmpBuf, strKeySelectedMustExist);
					snprintf(tmpBuf, sizeof(tmpBuf), "%s", strKeySelectedMustExist);
					goto setErr_encrypt;
				}
				if (strKeySelcted[0]!='1' && strKeySelcted[0]!='2' && strKeySelcted[0]!='3' && strKeySelcted[0]!='4') {
					//strcpy(tmpBuf, strInvdKeySel);
					snprintf(tmpBuf, sizeof(tmpBuf), "%s", strInvdKeySel);
					goto setErr_encrypt;
				}
				if (strKeySelcted[0] == '1')
					key_index = 0;
				else if (strKeySelcted[0] == '2')
					key_index = 1;
				else if (strKeySelcted[0] == '3')
					key_index = 2;
				else
					key_index = 3;
#else
				key_index = 0;
#endif
				Entry.wepDefaultKey = key_index;

				// (4) Encryption Key
				//
				for (key_i=0; key_i<4; key_i++)
				{
#if 0 // defined(CONFIG_CMCC) || defined(CONFIG_CU_BASEON_CMCC)
					if(key_index!=key_i) continue;
#endif
					sprintf(strbuf_idx, "key%d", key_i);
					sprintf(strbuf_errmsg1, "strInvdKey%dLen", key_i+1);
					sprintf(strbuf_errmsg2, "strInvdWEPKey%d", key_i+1);

					wepKey = boaGetVar(wp, strbuf_idx, "");
				
					if  (wepKey[0]) {
						if (strlen(wepKey) != keyLen
#if defined(CONFIG_CMCC) || defined(CONFIG_CU_BASEON_CMCC)
						&& strcmp(wepKey, "0")
#endif
						) {
							strcpy(tmpBuf, strbuf_errmsg1);
							goto setErr_encrypt;
						}
						if ( !isAllStar(wepKey) ) {
#if defined(CONFIG_CMCC) || defined(CONFIG_CU_BASEON_CMCC)
							if(!strcmp(wepKey, "0"))	 //special case for erase key
							{
								strcpy(key, "\0");
								eraseKey=1;
							}
							else	 //general case
#endif
							{
								if (strFormat[0] == '1') // ascii
									strcpy(key, wepKey);
								else { // hex
									if ( !rtk_string_to_hex(wepKey, key, keyLen)) {
										strcpy(tmpBuf, strbuf_errmsg2);
										goto setErr_encrypt;
									}
								}
								eraseKey=0;
							}
							if (wep == WEP64)
							{
								switch(key_i)
								{
									case 0:
										SET_WEP_KEY(Entry.wep64Key1, key, WEP64_KEY_LEN, eraseKey);
										break;
									case 1:
										SET_WEP_KEY(Entry.wep64Key2, key, WEP64_KEY_LEN, eraseKey);
										break;
									case 2:
										SET_WEP_KEY(Entry.wep64Key3, key, WEP64_KEY_LEN, eraseKey);
										break;
									case 3:
										SET_WEP_KEY(Entry.wep64Key4, key, WEP64_KEY_LEN, eraseKey);
										break;
								}
							}
							else
							{
								switch(key_i)
								{
									case 0:
										SET_WEP_KEY(Entry.wep128Key1, key, WEP128_KEY_LEN, eraseKey);
										break;
									case 1:
										SET_WEP_KEY(Entry.wep128Key2, key, WEP128_KEY_LEN, eraseKey);
										break;
									case 2:
										SET_WEP_KEY(Entry.wep128Key3, key, WEP128_KEY_LEN, eraseKey);
										break;
									case 3:
										SET_WEP_KEY(Entry.wep128Key4, key, WEP128_KEY_LEN, eraseKey);
										break;
								}
							}
						}
					}
				}// (4) Encryption Key
			}
		}
	}
#ifdef CONFIG_RTL_WAPI_SUPPORT
	/* assume MBSSID for now. */
	else if (encrypt == WIFI_SEC_WAPI) {
		char *wapiAuth=0, *pskFormat=0, *pskValue=0;
		unsigned char asIP[IP_ADDR_LEN]={0}, wapiType=0;
		int len;
		//fprintf(stderr, "%s(%d):\n", __FUNCTION__,__LINE__);
		wapiAuth = boaGetVar(wp, "wapiAuth", "");

		if (wapiAuth[0] == '1') {
			wapiType = 1;
			//asIP = boaGetVar(wp, "radiusIP", "");
			//fprintf(stderr, "%s(%d): %p\n", __FUNCTION__,__LINE__, asIP);
		}
		else if (wapiAuth[0] == '2') {
			wapiType = 2;
			pskFormat = boaGetVar(wp, "wapipskFormat", "");
			pskValue = boaGetVar(wp, "wapipskValue", "");
			len = strlen(pskValue);
		}
		else {
			strcpy(tmpBuf, strInvdWPAAuthValue);
			goto setErr_encrypt;
		}


		//fprintf(stderr, "%s(%d):\n", __FUNCTION__,__LINE__);
		if (0 == i) {

			Entry.wapiAuth = wapiType;
			if (wapiType == 2) { // PSK
				vChar = pskFormat[0] - '0';
				if (vChar != 0 && vChar != 1) {
					strcpy(tmpBuf, strInvdPSKFormat);
					goto setErr_encrypt;
				}
				Entry.wapiPskFormat = vChar;//mib_set(MIB_WLAN_WAPI_PSK_FORMAT, (void *)&vChar);
				if (vChar == 1) {// hex
					printf("(%s,%d) pskstring:%s\n",__func__,__LINE__,pskValue);
					memset(tmpBuf, 0, sizeof(tmpBuf));
					if (!rtk_string_to_hex(pskValue, tmpBuf, len)) {
						strcpy(tmpBuf, strInvdPSKValue);
						printf("(%s,%d) invalid pskvalue\n",__func__,__LINE__);
						goto setErr_encrypt;
					}


					if ((len & 1) || (len/2 >= MAX_PSK_LEN)) {
						strcpy(tmpBuf, strInvdPSKValue);
						goto setErr_encrypt;
					}
					len = len / 2;
					vChar = len;
					Entry.wapiPskLen = vChar;//mib_set(MIB_WLAN_WAPI_PSKLEN, &vChar);
					strcpy(Entry.wapiPsk, tmpBuf);//mib_set(MIB_WLAN_WAPI_PSK, (void *)tmpBuf);

				} else { // passphrase

					if (len==0 || len > (MAX_PSK_LEN - 1)) {
						strcpy(tmpBuf, strInvdPSKValue);
						goto setErr_encrypt;
					}
					vChar = len;
					Entry.wapiPskLen = vChar;//mib_set(MIB_WLAN_WAPI_PSKLEN, &vChar);
					strcpy(Entry.wapiPsk, pskValue);//mib_set(MIB_WLAN_WAPI_PSK, (void *)pskValue);

				}

			} else { // AS
				if ( !mib_get_s(MIB_ADSL_LAN_IP, (void *)&inIp, sizeof(inIp)) ) {
					strcpy(tmpBuf, strInvdRSIPValue);
					goto setErr_encrypt;
				}
				*((unsigned long *)Entry.wapiAsIpAddr) = inIp.s_addr;
			}

		} else {
			//fprintf(stderr, "%s(%d):\n", __FUNCTION__,__LINE__);
			mib_set(MIB_WLAN_WAPI_AUTH, (void *)&wapiType);
			if (wapiType == 2) { // PSK
				vChar = pskFormat[0] - '0';
				if (vChar != 0 && vChar != 1) {
					strcpy(tmpBuf, strInvdPSKFormat);
					goto setErr_encrypt;
				}
				mib_set(MIB_WLAN_WAPI_PSK_FORMAT, (void *)&vChar);
				if (vChar == 1) {// hex
					if (!rtk_string_to_hex(pskValue, tmpBuf, MAX_PSK_LEN)) {
						strcpy(tmpBuf, strInvdPSKValue);
						goto setErr_encrypt;
					}
					//fprintf(stderr, "%s(%d): %08x%08x%08x%08x\n",
					//	__FUNCTION__,__LINE__, (long *)&pskValue[0],
					//	(long *)&pskValue[4],(long *)&pskValue[8],(long *)&pskValue[12]);
					if ((len & 1) || (len/2 >= MAX_PSK_LEN)) {
						strcpy(tmpBuf, strInvdPSKValue);
						goto setErr_encrypt;
					}
					len = len / 2;
					vChar = len;
					mib_set(MIB_WLAN_WAPI_PSKLEN, &vChar);
					mib_set(MIB_WLAN_WAPI_PSK, (void *)pskValue);

				} else { // passphrase

					if (len==0 || len > (MAX_PSK_LEN - 1)) {
						strcpy(tmpBuf, strInvdPSKValue);
						goto setErr_encrypt;
					}
					vChar = len;
					mib_set(MIB_WLAN_WAPI_PSKLEN, &vChar);
					mib_set(MIB_WLAN_WAPI_PSK, (void *)pskValue);

				}

			} else { // AS
				//fprintf(stderr, "%s(%d):\n", __FUNCTION__,__LINE__);
				if ( !inet_aton(asIP, &inIp) ) {
					//strcpy(tmpBuf, strInvdRSIPValue);
					snprintf(tmpBuf, sizeof(tmpBuf), "%s", strInvdRSIPValue);
					goto setErr_encrypt;
				}
				//fprintf(stderr, "%s(%d):\n", __FUNCTION__,__LINE__);
				mib_set(MIB_WLAN_WAPI_ASIPADDR, (void *)&inIp);
			}


		}
	}
#endif 	// CONFIG_RTL_WAPI_SUPPORT
#if defined(CONFIG_RTL_CFG80211_WAPI_SUPPORT)
	else if (encrypt == WIFI_SEC_WAPI) {
		char *wapi_identify, *local_as;
		int len;
		struct in_addr AsuIpAddr;
		unsigned int wapiKeyUpdateTime;

		wapi_identify = boaGetVar(wp, "wapi_identify_way", "");

		if (wapi_identify[0] == '2') {//psk
			Entry.wapiAuthType = 2;

			strVal = boaGetVar(wp, "wapi_security_value", "");
			len = strlen(strVal);

			if (len<0 || len > MAX_PSK_LEN) {
				strcpy(tmpBuf, strInvdPSKValue);
				goto setErr_encrypt;
			}
			snprintf(Entry.wapiPsk,sizeof(Entry.wapiPsk),"%s",strVal);
			//printf("%s(%d):wapiPsk=%s\n", __FUNCTION__,__LINE__,Entry.wapiPsk);
		}
		else if (wapi_identify[0] == '1') {//Cert
			Entry.wapiAuthType = 1;
			local_as = boaGetVar(wp, "local_as", "");

			if(local_as[0] == '4'){
				Entry.wapiRole = 4;
			}else if(local_as[0] == '1'){
				Entry.wapiRole = 1;
				strVal = boaGetVar(wp, "as_ip", "");
				if (!strVal[0]) {
					strcpy(tmpBuf, "No Asu Ip Address");
					goto setErr_encrypt;
				}
				//printf("%s(%d):wapiAsuIpAddr=%s\n", __FUNCTION__,__LINE__,strVal);
				if ( !inet_aton(strVal, &AsuIpAddr) ) {
					strcpy(tmpBuf, "Invalid Asu IP-address value!");
					goto setErr_encrypt;
				}
				*((unsigned long*)Entry.wapiAsuIpAddr) = AsuIpAddr.s_addr;
				//printf("%s(%d):wapiAsuIpAddr=%x%x%x%x\n", __FUNCTION__,__LINE__,Entry.wapiAsuIpAddr[0],Entry.wapiAsuIpAddr[1],Entry.wapiAsuIpAddr[2],Entry.wapiAsuIpAddr[3]);
			}else{
				strcpy(tmpBuf, "Invalid wapiRole!");
				goto setErr_encrypt;
			}
			//printf("%s(%d):wapiRole=%d\n", __FUNCTION__,__LINE__,Entry.wapiRole);
		}else{
			strcpy(tmpBuf, "Invalid wapiAuthType!");
			goto setErr_encrypt;
		}
		//printf("%s(%d):wapiAuthType=%d\n", __FUNCTION__,__LINE__,Entry.wapiAuthType);
		strVal = boaGetVar(wp, "wapi_encrypt_algorithm", "");
		if (strVal[0] == '4') {//SMS4
			Entry.wapiCryptoAlg = 4;
		}else if(strVal[0] == '5'){
			Entry.wapiCryptoAlg = 5;
		}else{
			strcpy(tmpBuf, "Invalid wapiCryptoAlg!");
			goto setErr_encrypt;
		}
		//printf("%s(%d):wapiCryptoAlg=%d\n", __FUNCTION__,__LINE__,Entry.wapiCryptoAlg);

		strVal = boaGetVar(wp, "key_update_time", "");
		if (strVal[0]) {
			if ( !string_to_dec(strVal, &intVal) ) {
				strcpy(tmpBuf, "Invalid wapiKeyUpdateTime!");
				goto setErr_encrypt;
			}
		}else{
			strcpy(tmpBuf, "Invalid wapiKeyUpdateTime!");
			goto setErr_encrypt;
		}
		Entry.wapiKeyUpdateTime = intVal;
		//printf("%s(%d):wapiKeyUpdateTime=%d\n", __FUNCTION__,__LINE__,Entry.wapiKeyUpdateTime);
	}
#endif  //CONFIG_RTL_CFG80211_WAPI_SUPPORT
	else {	// WPA
#ifdef WLAN_1x
		// WPA authentication
		vChar = 0;
		Entry.enable1X = vChar;

		strVal = boaGetVar(wp, "wpaAuth", "");
		if (strVal[0]) {
			if ( !gstrcmp(strVal, "eap")) {
				vChar = Entry.wlanMode;
				if (vChar) { // not AP mode
					//strcpy(tmpBuf, strSetWPARADIUSWarn);
					snprintf(tmpBuf, sizeof(tmpBuf), "%s", strSetWPARADIUSWarn);
					goto setErr_encrypt;
				}
				vChar = WPA_AUTH_AUTO;
				enableRS = 1;
			}
			else if ( !gstrcmp(strVal, "psk")) {
				vChar = WPA_AUTH_PSK;
				getPSK = 1;
			}
			else {
				//strcpy(tmpBuf, strInvdWPAAuthValue);
				snprintf(tmpBuf, sizeof(tmpBuf), "%s", strInvdWPAAuthValue);
				goto setErr_encrypt;
			}
			Entry.wpaAuth = vChar;
		}
#endif

		// Mason Yu. 201009_new_security. Set ciphersuite(wpa_cipher) for wpa/wpa mixed
		Entry.unicastCipher = 0;
		Entry.wpa2UnicastCipher = 0;
		if ((encrypt == WIFI_SEC_WPA) || (encrypt == WIFI_SEC_WPA2_MIXED)) {
			unsigned char intVal = 0;
			unsigned char val2;

			strVal = boaGetVar(wp, "ciphersuite", ""); 
			if (strVal[0]) {
				if (strVal[0] == '1') 
				{    
					intVal |= WPA_CIPHER_TKIP;
				}    
				else if (strVal[0] == '2') 
				{    
					intVal |= WPA_CIPHER_AES;
				}    
				else if (strVal[0] == '3') 
				{    
					intVal |= WPA_CIPHER_MIXED;
				}    
			}

			if ( intVal == 0 )
				intVal = WPA_CIPHER_TKIP;

				Entry.unicastCipher = intVal;

		}

		// Mason Yu. 201009_new_security. Set wpa2ciphersuite(wpa2_cipher) for wpa2/wpa mixed
		if ((encrypt == WIFI_SEC_WPA2) || (encrypt == WIFI_SEC_WPA2_MIXED)) {
			unsigned char intVal = 0;

			strVal = boaGetVar(wp, "wpa2ciphersuite", ""); 
			if (strVal[0]) 
			{
				if (strVal[0] == '1') 
				{    
					intVal |= WPA_CIPHER_TKIP;
				}    
				else if (strVal[0] == '2') 
				{    
					intVal |= WPA_CIPHER_AES;
				}    
				else if (strVal[0] == '3') 
				{    
					intVal |= WPA_CIPHER_MIXED;
				}    
			}

			if ( intVal == 0 )
				intVal = WPA_CIPHER_AES;

			Entry.wpa2UnicastCipher = intVal;

		}
#ifdef WLAN_WPA3
		if(((encrypt == WIFI_SEC_WPA3) || (encrypt == WIFI_SEC_WPA2_WPA3_MIXED))){
			Entry.unicastCipher = 0;
			Entry.wpa2UnicastCipher = WPA_CIPHER_AES;
		}
#endif

#ifdef WLAN_11W
#ifdef WLAN_WPA3
		if(encrypt == WIFI_SEC_WPA3){
			Entry.dotIEEE80211W = 2;
			Entry.sha256 = 1;
		}
		else if(encrypt == WIFI_SEC_WPA2_WPA3_MIXED){
			Entry.dotIEEE80211W = 1;
			Entry.sha256 = 0;
		}else{
			Entry.dotIEEE80211W = 0;
			Entry.sha256 = 0;
		}
#endif
#endif

		// pre-shared key
		if ( getPSK ) {
			
			strVal = boaGetVar(wp, "pskFormat", "");
			if (!strVal[0]) {
	 			//strcpy(tmpBuf, strNoPSKFormat);
	 			snprintf(tmpBuf, sizeof(tmpBuf), "%s", strNoPSKFormat);
				goto setErr_encrypt;
			}
			vChar = strVal[0] - '0';
			
			//vChar = 0;
			if (vChar != 0 && vChar != 1) {
	 			//strcpy(tmpBuf, strInvdPSKFormat);
	 			snprintf(tmpBuf, sizeof(tmpBuf), "%s", strInvdPSKFormat);
				goto setErr_encrypt;
			}

#ifdef CONFIG_CU
			strVal = boaGetVar(wp, "pskValue", "");
			if(strVal[0]){
				rtk_util_data_base64decode(strVal, psk, sizeof(psk)-1);
				psk[sizeof(psk)-1] = '\0';
				len = strlen(psk);
				strVal = psk;
			}
#else
			strVal = boaGetVar(wp, "pskValue", "");
			len = strlen(strVal);
#endif
			Entry.wpaPSKFormat = vChar;

			if (vChar==1) { // hex
				if (len!=MAX_PSK_LEN || !rtk_string_to_hex(strVal, tmpBuf, MAX_PSK_LEN)) {
	 				//strcpy(tmpBuf, strInvdPSKValue);
	 				snprintf(tmpBuf, sizeof(tmpBuf), "%s", strInvdPSKValue);
					goto setErr_encrypt;
				}
			}
			else { // passphras
				if (len==0 || len > (MAX_PSK_LEN - 1) ) {
	 				//strcpy(tmpBuf, strInvdPSKValue);
	 				snprintf(tmpBuf, sizeof(tmpBuf), "%s", strInvdPSKValue);
					goto setErr_encrypt;
				}
			}
			strcpy(Entry.wpaPSK, strVal);
			
		}
	}

#ifdef WLAN_1x
	if (enableRS == 1) { // if 1x enabled, get RADIUS server info
		unsigned short uShort;

		strVal = boaGetVar(wp, "radiusPort", "");
		if (!strVal[0]) {
			strcpy(tmpBuf, "没有RS端口数值!"); //No RS port number!
			goto setErr_encrypt;
		}
		if (!string_to_dec(strVal, &intVal) || intVal<=0 || intVal>65535) {
			strcpy(tmpBuf, strInvdRSPortNum);
			goto setErr_encrypt;
		}
		uShort = (unsigned short)intVal;
		Entry.rsPort = uShort;

		strVal = boaGetVar(wp, "radiusIP", "");
		if (!strVal[0]) {
			strcpy(tmpBuf, strNoIPAddr);
			goto setErr_encrypt;
		}
		if ( !inet_aton(strVal, &inIp) ) {
			strcpy(tmpBuf, strInvdRSIPValue);
			goto setErr_encrypt;
		}
		*((in_addr_t *)Entry.rsIpAddr) = inIp.s_addr;

		strVal = boaGetVar(wp, "radiusPass", "");
		if (strlen(strVal) > (MAX_PSK_LEN) ) {
			strcpy(tmpBuf, strRSPwdTooLong);
			goto setErr_encrypt;
		}
		strcpy(Entry.rsPassword, strVal);

		strVal = boaGetVar(wp, "radiusRetry", "");
		if (strVal[0]) {
			if ( !string_to_dec(strVal, &intVal) ) {
				strcpy(tmpBuf, strInvdRSRetry);
				goto setErr_encrypt;
			}
			vChar = (char)intVal;
			if ( !mib_set(MIB_WLAN_RS_RETRY, (void *)&vChar)) {
				strcpy(tmpBuf, strSetRSRETRYErr);
				goto setErr_encrypt;
			}
		}
		strVal = boaGetVar(wp, "radiusTime", "");
		if (strVal[0]) {
			if ( !string_to_dec(strVal, &intVal) ) {
				strcpy(tmpBuf, strInvdRSTime);
				goto setErr_encrypt;
			}
			uShort = (unsigned short)intVal;
			if ( !mib_set(MIB_WLAN_RS_INTERVAL_TIME, (void *)&uShort)) {
				strcpy(tmpBuf, strSetRSINTVLTIMEErr);
				goto setErr_encrypt;
			}
		}

get_wepkey:
		// get 802.1x WEP key length
		strVal = boaGetVar(wp, "wepKeyLen", "");
		if (strVal[0]) {
			if ( !gstrcmp(strVal, "wep64"))
				vChar = WEP64;
			else if ( !gstrcmp(strVal, "wep128"))
				vChar = WEP128;
			else {
				strcpy(tmpBuf, strInvdWepKeyLen);
				goto setErr_encrypt;
			}
			Entry.wep = vChar;
		}
	}
#endif


	wlan_setEntry(&Entry,i);
}
#ifdef YUEME_3_0_SPEC
#if defined(WLAN_BAND_STEERING)
	if(sta_control_change)
		SetOrCancelSameSSID(sta_control);
#endif
#endif
	//sleep(5);
//---------------------------------
//WPS
#if defined(CONFIG_CMCC) || defined(CONFIG_CU_BASEON_CMCC)
#ifdef WLAN_WPS_HAPD
{
	char wps_ifname[IFNAMSIZ]={0};
	int action=0;
	strVal  = boaGetVar(wp, "action", "");
	action = strVal[0] - '0';
	if(strVal[0] && action!=0){
		if (Entry.wsc_disabled == 0){
			rtk_wlan_get_ifname(wlan_idx, 0, wps_ifname);
			if (action == 1)
			{
				va_niced_cmd(HOSTAPD_CLI, 3 , 1 , "wps_pbc" , "-i", wps_ifname);
			}
			else if(action == 2)
			{
				va_niced_cmd(HOSTAPD_CLI, 3 , 1 , "wps_cancel" , "-i", wps_ifname);
			}
		}

		submitUrl = boaGetVar(wp, "submit-url", "");
		boaRedirect(wp, submitUrl);
		return;
	}

	if(ssidIdx == 0){ //update for root ssid only
		strVal = boaGetVar(wp, "disableWPS", "");
		if ( !strcmp(strVal, "ON") )
		{
			intVal = 0;
		}
		else
		{
			intVal = 1;
		}

		Entry.wsc_disabled = intVal;
		wlan_setEntry((void *)&Entry, ssidIdx);
#if 0 //ndef WLAN_WPS_VAP //todo
		update_wps_mib();
#endif

		if(Entry.wsc_disabled == 0){
			strVal = boaGetVar(wp, "localPin", "");
			if (strVal[0]){
				int local_pin_changed = 0;
				char wpin[PIN_LEN+1]={0};
				mib_get_s(MIB_WSC_PIN, (void *)wpin, sizeof(wpin));
				if (strcmp(wpin, strVal)) {
					mib_set(MIB_WSC_PIN, (void *)strVal);
					local_pin_changed = 1;
#ifdef WLAN_DUALBAND_CONCURRENT
					both_band_modify = 1;
#endif
				}
			}
		}
	}
}
#elif defined(CONFIG_WIFI_SIMPLE_CONFIG)
{
	char tmpbuf_wps[200];
	int action, idx;
	pid_t pid;
	char *msg = "echo 1> /var/cmcc_wsc_running";
	char wps_ifname[IFNAMSIZ]={0};

	//wlan_getEntry((void *)&Entry, ssidIdx);

	strVal	= boaGetVar(wp, "action", "");
	if(strVal[0] && (strVal[0] - '0'))
	{
		action = strVal[0] - '0';
#ifndef WLAN_WPS_MULTI_DAEMON 
		idx = wlan_idx*WLAN_SSID_NUM+1;
#ifdef WLAN_WPS_VAP
		set_wps_ssid(idx);
#endif
#endif

		if (Entry.wsc_disabled) {
			Entry.wsc_disabled = 0;
			wlan_setEntry((void *)&Entry, ssidIdx);
			mib_update(CURRENT_SETTING, CONFIG_MIB_ALL);	// update to flash
			system("echo 1 > /var/wps_start_pbc");
#ifndef NO_ACTION
			run_init_script("bridge");
#endif
		}
		else {
#ifndef WLAN_WPS_MULTI_DAEMON
			if(wlan_idx == 0 )
			{
				system("echo 1 > /var/wps_start_interface0");
			}
			else
			{
				system("echo 1 > /var/wps_start_interface1");

			}
#endif
			rtk_wlan_get_ifname(wlan_idx, 0, wps_ifname);
			va_niced_cmd(WSC_DAEMON_PROG, 2 , 1 , "-sig_pbc" , wps_ifname);
		}

		if (action == 1)
		{
			pid = fork();
			if (pid==0)
			{
				start_PBC(msg);
				exit(0);
			}
		}
		else if(action == 2)
		{
			stop_PBC(msg);
		}

		submitUrl = boaGetVar(wp, "submit-url", "");
		boaRedirect(wp, submitUrl);
		return;
	}

	if(ssidIdx == 0){ //update for root ssid only
		strVal = boaGetVar(wp, "disableWPS", "");
		if ( !strcmp(strVal, "ON") )
		{
			intVal = 0;
		}
		else
		{
			intVal = 1;
		}

		Entry.wsc_disabled = intVal;
		wlan_setEntry((void *)&Entry, ssidIdx);
#ifndef WLAN_WPS_VAP
		update_wps_mib();
#endif

		if(Entry.wsc_disabled == 0){
			strVal = boaGetVar(wp, "localPin", "");
			if (strVal[0]){
				int local_pin_changed = 0;
				char wpin[PIN_LEN+1]={0};
				mib_get_s(MIB_WSC_PIN, (void *)wpin, sizeof(wpin));
				if (strcmp(wpin, strVal)) {
					mib_set(MIB_WSC_PIN, (void *)strVal);
					local_pin_changed = 1;
#ifdef WLAN_DUALBAND_CONCURRENT
					both_band_modify = 1;
#endif
				}
			#if 0
				if(local_pin_changed){
					mib_get_s(MIB_WPS_SSID, &vChar, sizeof(vChar));
					if(vChar != idx){
						vChar = idx;
						mib_set(MIB_WPS_SSID, &vChar);
					}
				}
			#endif
			}
		}
	}
}
#endif
#endif

#ifdef BAND_STEERING_SUPPORT
	strVal = boaGetVar(wp, "band_steering_enable", "");
	if(!gstrcmp(strVal, "ON"))
		tmp_band_steering_enable = 1;
	else
		tmp_band_steering_enable = 0;

	if(mib_get_s(MIB_WIFI_STA_CONTROL_ENABLE, &band_steering_enable, sizeof(band_steering_enable))==0){
		strncpy(tmpBuf, "Get mib WIFI_STA_CONTROL_ENABLE error!", sizeof(tmpBuf));
		goto setErr_wlan;
	}
	if(tmp_band_steering_enable != band_steering_enable){
		if(mib_set(MIB_WIFI_STA_CONTROL_ENABLE, &tmp_band_steering_enable)==0){
			strncpy(tmpBuf, "Set mib WIFI_STA_CONTROL_ENABLE error!", sizeof(tmpBuf));
			goto setErr_wlan;
		}
	}
	if(tmp_band_steering_enable == 1){
		if(mib_get_s(MIB_PREFER_BAND, &band_steering_prefer, sizeof(band_steering_prefer))==0){
			strncpy(tmpBuf, "Get mib PREFER_BAND error!", sizeof(tmpBuf));
			goto setErr_wlan;
		}

		wlan_idx_orig = wlan_idx;
		if(wlan_band_steering_update(band_steering_prefer) != 0){
			strncpy(tmpBuf, "Update wlan band steering error!", sizeof(tmpBuf));
			goto setErr_wlan;
		}
		wlan_idx = wlan_idx_orig;

		update_all_ssid = 1;
		both_band_modify = 1;
	}
#endif

setwlan_ret:
#if defined(CONFIG_WIFI_SIMPLE_CONFIG) || defined(WLAN_WPS)//WPS def WIFI_SIMPLE_CONFIG
	{
		int ret;
		char *wepKey;
		wepKey = boaGetVar(wp, "wps_clear_configure_by_reg0", "");
		ret = 0;
		if (wepKey && wepKey[0])
			ret = atoi(wepKey);
		update_wps_configured(ret);
	}
#endif
setwlan_module_disable:

submitUrl = boaGetVar(wp, "submit-url", "");   // hidden page

// Magician: Commit immediately
#ifdef COMMIT_IMMEDIATELY
	Commit();
#endif // of #if COMMIT_IMMEDIATELY

#ifndef NO_ACTION
	run_script(mode);
#endif


	if(ssidIdx != WLAN_ROOT_ITF_INDEX && update_all_ssid == 0){
#ifdef WLAN_DUALBAND_CONCURRENT
		config_WLAN(get_wlan_phyband()==PHYBAND_2G? ACT_RESTART_2G: ACT_RESTART_5G, ssidIdx);
#else
		config_WLAN(ACT_RESTART_2G, ssidIdx);
#endif
	}
	else{
#ifdef WLAN_DUALBAND_CONCURRENT
		if(both_band_modify == 0)
			config_WLAN(get_wlan_phyband()==PHYBAND_2G? ACT_RESTART_2G: ACT_RESTART_5G, CONFIG_SSID_ALL);
		else
#endif
		config_WLAN(ACT_RESTART, CONFIG_SSID_ALL);
	}
	if(get_wlan_phyband()==PHYBAND_2G)
		syslog(LOG_INFO, "WlanSetup: Update 2G ssid-%d configuration", ssidIdx+1);
	else
		syslog(LOG_INFO, "WlanSetup: Update 5G ssid-%d configuration", ssidIdx+1);
//	submitUrl = boaGetVar(wp, "submit-url", "");   // hidden page
	if (warn) {
		OK_MSG1(tmpBuf, submitUrl);
	}
	else {
		//OK_MSG(submitUrl);
		if (submitUrl[0])
			boaRedirect(wp, submitUrl);
		else
			boaDone(wp, 200);
	}
	return;

setErr_wlan:
	ERR_MSG(tmpBuf);

setErr_encrypt:
	ERR_MSG(tmpBuf);
}

#endif

#ifdef CONFIG_RTL_WAPI_SUPPORT

#define CERT_START "-----BEGIN CERTIFICATE-----"
#define CERT_END "-----END CERTIFICATE-----"
extern FILE * _uploadGet(request *wp, unsigned int *startPos, unsigned *endPos);
static void formUploadWapiCert(request * wp, char * path, char * query,
	const char *name, const char *submitUrl)
{
	/*save asu and user cert*/
	char *strVal;
	char tmpBuf[128];
	char cmd[128];
	FILE *fp, *fp_input;
	int startPos,endPos,nLen,nRead,nToRead;

	if ((fp_input = _uploadGet(wp, &startPos, &endPos)) == NULL) {
		strcpy(tmpBuf,"Upload failed");
		goto upload_ERR;
	}

	//fprintf(stderr, "%s(%d): %s,%s (%d,%d)\n", __FUNCTION__,__LINE__,
	//	 submitUrl, strVal, startPos, endPos);

	nLen = endPos - startPos;
	fseek(fp_input, startPos, SEEK_SET); // seek to the data star

	fp=fopen(WAPI_TMP_CERT,"w");
	if(NULL == fp)
	{
		strcpy(tmpBuf,"Can not open tmp cert!");
		goto upload_ERR;
	}

	/* copy startPos - endPost to another file */
	nToRead = nLen;
	do {
		nRead = nToRead > sizeof(tmpBuf) ? sizeof(tmpBuf) : nToRead;

		nRead = fread(tmpBuf, 1, nRead, fp_input);
		fwrite(tmpBuf, 1, nRead, fp);
		nToRead -= nRead;
	} while (nRead > 0);

	fclose(fp);
	fclose(fp_input);

	strcpy(cmd,"mv ");
	strcat(cmd,WAPI_TMP_CERT);
	strcat(cmd," ");
	strcat(cmd,name);
	system(cmd);
//ccwei_flatfsd
#ifdef CONFIG_USER_FLATFSD_XXX
	strcpy(cmd, "flatfsd -s");
	system(cmd);
#endif
	/*strcpy(cmd, "ln -s ");
	strcat(cmd, name);
	strcat(cmd," ");
	strcat(cmd, lnname);
	system(cmd); */


	config_WLAN(ACT_RESTART, CONFIG_SSID_ALL);

	//fprintf(stderr, "%s(%d):cmd \"%s\"\n", __FUNCTION__,__LINE__,cmd);
	/*check if user or asu cerification*/
	strcpy(tmpBuf,"Cerification Install Success!");
	//OK_MSG1(tmpBuf, submitUrl);
	OK_MSG(submitUrl);
	return;
upload_ERR:
	ERR_MSG(tmpBuf);
}



void formUploadWapiCert1(request * wp, char * path, char * query)
{
	formUploadWapiCert(wp, path, query, WAPI_CA4AP_CERT_SAVE, "/wlwapiinstallcert.asp");
	wapi_cert_link_one(WAPI_CA4AP_CERT_SAVE, WAPI_CA4AP_CERT);
}

void formUploadWapiCert2(request * wp, char * path, char * query)
{
	formUploadWapiCert(wp, path, query, WAPI_AP_CERT_SAVE, "/wlwapiinstallcert.asp");
	wapi_cert_link_one(WAPI_AP_CERT_SAVE, WAPI_AP_CERT);
}

void formWapiReKey(request * wp, char * path, char * query)
{
	char *submitUrl, *strVal;
	char vChar;
	int vLong, ret;
	char tmpBuf[128];

	submitUrl = boaGetVar(wp, "submit-url", "");

	strVal = boaGetVar(wp, "REKEY_POLICY", "");
	//fprintf(stderr, "%s(%d): %s\n",__FUNCTION__,__LINE__, strVal);
	if (strVal[0]) {
		vChar=strVal[0]-'0';
		ret = mib_set(MIB_WLAN_WAPI_UCAST_REKETTYPE,(void *)&vChar);
		//fprintf(stderr, "%s(%d): %d, %d\n",__FUNCTION__,__LINE__, vChar, ret);
		if (vChar!=1) {
			strVal = boaGetVar(wp, "REKEY_TIME", "");
			if (strVal[0]) {
				vLong = atoi(strVal);
				ret = mib_set(MIB_WLAN_WAPI_UCAST_TIME,(void *)&vLong);
				//fprintf(stderr, "%s(%d): %s,%d\n",__FUNCTION__,__LINE__, strVal,ret);
			}
			strVal = boaGetVar(wp, "REKEY_PACKET", "");
			if (strVal[0]) {
				vLong = atoi(strVal);
				ret = mib_set(MIB_WLAN_WAPI_UCAST_PACKETS,(void *)&vLong);
				//fprintf(stderr, "%s(%d): %s,%d\n",__FUNCTION__,__LINE__, strVal,ret);
			}
		}
	}

	strVal = boaGetVar(wp, "REKEY_M_POLICY", "");
	if (strVal[0]) {
		vChar=strVal[0]-'0';
		mib_set(MIB_WLAN_WAPI_MCAST_REKEYTYPE,(void *)&vChar);

		if (vChar!=1) {
			strVal = boaGetVar(wp, "REKEY_M_TIME", "");
			if (strVal[0]) {
				vLong = atoi(strVal);
				mib_set(MIB_WLAN_WAPI_MCAST_TIME,(void *)&vLong);
			}

			strVal = boaGetVar(wp, "REKEY_M_PACKET", "");
			if (strVal[0]) {
				vLong = atoi(strVal);
				mib_set(MIB_WLAN_WAPI_MCAST_PACKETS,(void *)&vLong);
			}
		}
	}
#ifdef COMMIT_IMMEDIATELY
	Commit();
#endif

	config_WLAN(ACT_RESTART, CONFIG_SSID_ALL);

	OK_MSG(submitUrl);
	return;

upload_ERR:
	ERR_MSG(tmpBuf);
}



#endif //CONFIG_RTL_WAPI_SUPPORT

//#define testWEP 1
#ifdef WLAN_WPA
/////////////////////////////////////////////////////////////////////////////
void formWlEncrypt(request * wp, char *path, char *query)
{
	char *submitUrl, *strEncrypt, *strVal;
	char vChar, *strKeyLen, *strFormat, *wepKey, *strAuth;
	char tmpBuf[100];
	WIFI_SECURITY_T encrypt;
	int enableRS=0, intVal, getPSK=0, len, keyLen;
	SUPP_NONWAP_T suppNonWPA;
	struct in_addr inIp;
	WEP_T wep;
	char key[30];
	AUTH_TYPE_T authType;
	MIB_CE_MBSSIB_T Entry;
	int i;
#if defined (CONFIG_YUEME) || defined(CONFIG_CU_BASEON_YUEME)
#if defined(WLAN_BAND_STEERING)
	unsigned char sta_control;
#endif
#endif
#if defined(WLAN_DUALBAND_CONCURRENT)
	strVal = boaGetVar(wp, "wlan_idx", "");
	if ( strVal[0] ) {
		printf("wlan_idx=%d\n", strVal[0]-'0');
		wlan_idx = strVal[0]-'0';
	}
#endif //WLAN_DUALBAND_CONCURRENT

	strVal = boaGetVar(wp, "wpaSSID", "");

	if (strVal[0]) {
		i = strVal[0]-'0';
		if (i<0 || i > NUM_VWLAN_INTERFACE) {
			//strcpy(tmpBuf, strNotSuptSSIDType);
			snprintf(tmpBuf, sizeof(tmpBuf), "%s", strNotSuptSSIDType);
			goto setErr_encrypt;
		}

	} else {
		//strcpy(tmpBuf, strNoSSIDTypeErr);
		snprintf(tmpBuf, sizeof(tmpBuf), "%s", strNoSSIDTypeErr);
		goto setErr_encrypt;
	}

	if (!wlan_getEntry(&Entry, i)){
		//strcpy(tmpBuf, strGetMBSSIBTBLErr);
		snprintf(tmpBuf, sizeof(tmpBuf), "%s", strGetMBSSIBTBLErr);
		goto setErr_encrypt;
	}
	// Added by Mason Yu. End
	/*
	printf("Entry.idx=%d\n", Entry.idx);
	printf("Entry.encrypt=%d\n", Entry.encrypt);
	printf("Entry.enable1X=%d\n", Entry.enable1X);
	printf("Entry.wep=%d\n", Entry.wep);
	printf("Entry.wpaAuth=%d\n", Entry.wpaAuth);
	printf("Entry.wpaPSKFormat=%d\n", Entry.wpaPSKFormat);
	printf("Entry.wpaPSK=%s\n", Entry.wpaPSK);
	printf("Entry.rsPort=%d\n", Entry.rsPort);
	printf("Entry.rsIpAddr=0x%x\n", *((unsigned long *)Entry.rsIpAddr));
	printf("Entry.rsPassword=%s\n", Entry.rsPassword);
	*/

	strEncrypt = boaGetVar(wp, "security_method", "");
	if (!strEncrypt[0]) {
 		//strcpy(tmpBuf, strNoEncryptionErr);
 		snprintf(tmpBuf, sizeof(tmpBuf), "%s", strNoEncryptionErr);
		goto setErr_encrypt;
	}

	encrypt = atoi(strEncrypt);
	//encrypt = (WIFI_SECURITY_T) strEncrypt[0] - '0';
	vChar = (char)encrypt;
	Entry.encrypt = vChar;

	if (encrypt == WIFI_SEC_NONE || encrypt == WIFI_SEC_WEP) {

#ifdef WLAN_1x
		strVal = boaGetVar(wp, "use1x", "");
		if ( !gstrcmp(strVal, "ON")) {
			vChar = Entry.wlanMode;
			if (vChar) { // not AP mode
				//strcpy(tmpBuf, strSet8021xWarning);
				snprintf(tmpBuf, sizeof(tmpBuf), "%s", strSet8021xWarning);
				goto setErr_encrypt;
			}
			vChar = 1;
			enableRS = 1;
		}
		else
			vChar = 0;
		Entry.enable1X = vChar;
#endif

		if (encrypt == WIFI_SEC_WEP) {
	 		WEP_T wep;
			// Mason Yu. 201009_new_security. If wireless do not use 802.1x for wep mode. We should set wep key and Authentication type.
			if ( enableRS != 1 ) {
				// (1) Authentication Type
				strAuth = boaGetVar(wp, "auth_type", "");
				if (strAuth[0]) {
					if ( !gstrcmp(strAuth, "open"))
						authType = AUTH_OPEN;
					else if ( !gstrcmp(strAuth, "shared"))
						authType = AUTH_SHARED;
					else if ( !gstrcmp(strAuth, "both"))
						authType = AUTH_BOTH;
					else {
						strcpy(tmpBuf, strInvdAuthType);
						goto setErr_encrypt;
					}
					vChar = (char)authType;
					Entry.authType = vChar;
				}

				// (2) Key Length
				strKeyLen = boaGetVar(wp, "length0", "");
				if (!strKeyLen[0]) {
 					strcpy(tmpBuf, strKeyLenMustExist);
					goto setErr_encrypt;
				}
				if (strKeyLen[0]!='1' && strKeyLen[0]!='2') {
 					strcpy(tmpBuf, strInvdKeyLen);
					goto setErr_encrypt;
				}
				if (strKeyLen[0] == '1')
					wep = WEP64;
				else
					wep = WEP128;

				vChar = (char)wep;
				Entry.wep = vChar;

				// (3) Key Format
				strFormat = boaGetVar(wp, "format0", "");
				if (!strFormat[0]) {
 					strcpy(tmpBuf, strKeyTypeMustExist);
					goto setErr_encrypt;
				}

				if (strFormat[0]!='1' && strFormat[0]!='2') {
					strcpy(tmpBuf, strInvdKeyType);
					goto setErr_encrypt;
				}

				vChar = (char)(strFormat[0] - '0' - 1);
				Entry.wepKeyType = vChar;

				if (wep == WEP64) {
					if (strFormat[0]=='1')
						keyLen = WEP64_KEY_LEN;
					else
						keyLen = WEP64_KEY_LEN*2;
				}
				else {
					if (strFormat[0]=='1')
						keyLen = WEP128_KEY_LEN;
					else
						keyLen = WEP128_KEY_LEN*2;
				}

				// (4) Encryption Key
				wepKey = boaGetVar(wp, "key0", "");
				if  (wepKey[0]) {
					if (strlen(wepKey) != keyLen) {
						strcpy(tmpBuf, strInvdKey1Len);
						goto setErr_encrypt;
					}
					if ( !isAllStar(wepKey) ) {
						if (strFormat[0] == '1') // ascii
							strcpy(key, wepKey);
						else { // hex
							if ( !rtk_string_to_hex(wepKey, key, keyLen)) {
				   				strcpy(tmpBuf, strInvdWEPKey1);
								goto setErr_encrypt;
							}
						}
						if (wep == WEP64)
							memcpy(Entry.wep64Key1,key,WEP64_KEY_LEN);
						else
							memcpy(Entry.wep128Key1,key,WEP128_KEY_LEN);
					}
				}// (4) Encryption Key


			}
		}
	}
#ifdef CONFIG_RTL_WAPI_SUPPORT
	/* assume MBSSID for now. */
	else if (encrypt == WIFI_SEC_WAPI) {
		char *wpaAuth=0, *pskFormat=0, *pskValue=0;
		char *asIP=0, wapiType=0;
		int len;
		//fprintf(stderr, "%s(%d):\n", __FUNCTION__,__LINE__);
		wpaAuth = boaGetVar(wp, "wpaAuth", "");

		if (wpaAuth && !gstrcmp(wpaAuth, "eap")) {
			wapiType = 1;
			asIP = boaGetVar(wp, "radiusIP", "");
			//fprintf(stderr, "%s(%d): %p\n", __FUNCTION__,__LINE__, asIP);
		}
		else if (wpaAuth && !gstrcmp(wpaAuth, "psk")) {
			wapiType = 2;
			pskFormat = boaGetVar(wp, "pskFormat", "");
			pskValue = boaGetVar(wp, "pskValue", "");
			len = strlen(pskValue);
		}
		else {
			strcpy(tmpBuf, strInvdWPAAuthValue);
			goto setErr_encrypt;
		}


		//fprintf(stderr, "%s(%d):\n", __FUNCTION__,__LINE__);
		if (0 != i) {

			Entry.wapiAuth = wapiType;
			if (wapiType == 2) { // PSK
				vChar = pskFormat[0] - '0';
				if (vChar != 0 && vChar != 1) {
					strcpy(tmpBuf, strInvdPSKFormat);
					goto setErr_encrypt;
				}
				Entry.wapiPskFormat = vChar;//mib_set(MIB_WLAN_WAPI_PSK_FORMAT, (void *)&vChar);
				if (vChar == 1) {// hex
					if (!rtk_string_to_hex(pskValue, tmpBuf, MAX_PSK_LEN)) {
						strcpy(tmpBuf, strInvdPSKValue);
						goto setErr_encrypt;
					}


					if ((len & 1) || (len/2 >= MAX_PSK_LEN)) {
						strcpy(tmpBuf, strInvdPSKValue);
						goto setErr_encrypt;
					}
					len = len / 2;
					vChar = len;
					Entry.wapiPskLen = vChar;//mib_set(MIB_WLAN_WAPI_PSKLEN, &vChar);
					strcpy(Entry.wapiPsk, tmpBuf);//mib_set(MIB_WLAN_WAPI_PSK, (void *)tmpBuf);

				} else { // passphrase

					if (len==0 || len > (MAX_PSK_LEN - 1)) {
						strcpy(tmpBuf, strInvdPSKValue);
						goto setErr_encrypt;
					}
					vChar = len;
					Entry.wapiPskLen = vChar;//mib_set(MIB_WLAN_WAPI_PSKLEN, &vChar);
					strcpy(Entry.wapiPsk, pskValue);//mib_set(MIB_WLAN_WAPI_PSK, (void *)pskValue);

				}

			} else { // AS

				if ( !inet_aton(asIP, &inIp) ) {
					strcpy(tmpBuf, strInvdRSIPValue);
					goto setErr_encrypt;
				}
				*((unsigned long *)Entry.wapiAsIpAddr) = inIp.s_addr;
			}

		} else {
			//fprintf(stderr, "%s(%d):\n", __FUNCTION__,__LINE__);
			mib_set(MIB_WLAN_WAPI_AUTH, (void *)&wapiType);
			if (wapiType == 2) { // PSK
				vChar = pskFormat[0] - '0';
				if (vChar != 0 && vChar != 1) {
					strcpy(tmpBuf, strInvdPSKFormat);
					goto setErr_encrypt;
				}
				mib_set(MIB_WLAN_WAPI_PSK_FORMAT, (void *)&vChar);
				if (vChar == 1) {// hex
					if (!rtk_string_to_hex(pskValue, tmpBuf, MAX_PSK_LEN)) {
						strcpy(tmpBuf, strInvdPSKValue);
						goto setErr_encrypt;
					}
					//fprintf(stderr, "%s(%d): %08x%08x%08x%08x\n",
					//	__FUNCTION__,__LINE__, (long *)&pskValue[0],
					//	(long *)&pskValue[4],(long *)&pskValue[8],(long *)&pskValue[12]);
					if ((len & 1) || (len/2 >= MAX_PSK_LEN)) {
						strcpy(tmpBuf, strInvdPSKValue);
						goto setErr_encrypt;
					}
					len = len / 2;
					vChar = len;
					mib_set(MIB_WLAN_WAPI_PSKLEN, &vChar);
					mib_set(MIB_WLAN_WAPI_PSK, (void *)pskValue);

				} else { // passphrase

					if (len==0 || len > (MAX_PSK_LEN - 1)) {
						strcpy(tmpBuf, strInvdPSKValue);
						goto setErr_encrypt;
					}
					vChar = len;
					mib_set(MIB_WLAN_WAPI_PSKLEN, &vChar);
					mib_set(MIB_WLAN_WAPI_PSK, (void *)pskValue);

				}

			} else { // AS
				//fprintf(stderr, "%s(%d):\n", __FUNCTION__,__LINE__);
				if ( !inet_aton(asIP, &inIp) ) {
					strcpy(tmpBuf, strInvdRSIPValue);
					goto setErr_encrypt;
				}
				//fprintf(stderr, "%s(%d):\n", __FUNCTION__,__LINE__);
				mib_set(MIB_WLAN_WAPI_ASIPADDR, (void *)&inIp);
			}


		}
	}
#endif 	// CONFIG_RTL_WAPI_SUPPORT
	else {	// WPA
#ifdef WLAN_1x
		// WPA authentication
		vChar = 0;
		Entry.enable1X = vChar;

		strVal = boaGetVar(wp, "wpaAuth", "");
		if (strVal[0]) {
			if ( !gstrcmp(strVal, "eap")) {
				vChar = Entry.wlanMode;
				if (vChar) { // not AP mode
					strcpy(tmpBuf, strSetWPARADIUSWarn);
					goto setErr_encrypt;
				}
				vChar = WPA_AUTH_AUTO;
				enableRS = 1;
			}
			else if ( !gstrcmp(strVal, "psk")) {
				vChar = WPA_AUTH_PSK;
				getPSK = 1;
			}
			else {
				strcpy(tmpBuf, strInvdWPAAuthValue);
				goto setErr_encrypt;
			}
			Entry.wpaAuth = vChar;
		}
#endif

		// Mason Yu. 201009_new_security. Set ciphersuite(wpa_cipher) for wpa/wpa mixed
		if ((encrypt == WIFI_SEC_WPA) || (encrypt == WIFI_SEC_WPA2_MIXED)) {
			unsigned char intVal = 0;
			unsigned char val2;
			strVal = boaGetVar(wp, "ciphersuite_t", "");
			if (strVal[0]=='1')
				intVal |= WPA_CIPHER_TKIP;
			strVal = boaGetVar(wp, "ciphersuite_a", "");
			if (strVal[0]=='1')
				intVal |= WPA_CIPHER_AES;

			if ( intVal == 0 )
				intVal = WPA_CIPHER_TKIP;

				Entry.unicastCipher = intVal;

		}

		// Mason Yu. 201009_new_security. Set wpa2ciphersuite(wpa2_cipher) for wpa2/wpa mixed
		if ((encrypt == WIFI_SEC_WPA2) || (encrypt == WIFI_SEC_WPA2_MIXED)) {
			unsigned char intVal = 0;
			strVal = boaGetVar(wp, "wpa2ciphersuite_t", "");
			if (strVal[0]=='1')
				intVal |= WPA_CIPHER_TKIP;
			strVal = boaGetVar(wp, "wpa2ciphersuite_a", "");
			if (strVal[0]=='1')
				intVal |= WPA_CIPHER_AES;

			if ( intVal == 0 )
				intVal = WPA_CIPHER_AES;

			Entry.wpa2UnicastCipher = intVal;
		}
#ifdef WLAN_WPA3
		else if(((encrypt == WIFI_SEC_WPA3) || (encrypt == WIFI_SEC_WPA2_WPA3_MIXED))){
			Entry.wpa2UnicastCipher = WPA_CIPHER_AES;
		}
#endif

		// pre-shared key
		if ( getPSK ) {
			
			strVal = boaGetVar(wp, "pskFormat", "");
			if (!strVal[0]) {
	 			strcpy(tmpBuf, strNoPSKFormat);
				goto setErr_encrypt;
			}
			vChar = strVal[0] - '0';
			
			//vChar = 0;
			if (vChar != 0 && vChar != 1) {
	 			strcpy(tmpBuf, strInvdPSKFormat);
				goto setErr_encrypt;
			}

			strVal = boaGetVar(wp, "pskValue", "");
			len = strlen(strVal);
			Entry.wpaPSKFormat = vChar;

			if (vChar==1) { // hex
				if (len!=MAX_PSK_LEN || !rtk_string_to_hex(strVal, tmpBuf, MAX_PSK_LEN)) {
	 				strcpy(tmpBuf, strInvdPSKValue);
					goto setErr_encrypt;
				}
			}
			else { // passphras
				if (len==0 || len > (MAX_PSK_LEN - 1) ) {
	 				strcpy(tmpBuf, strInvdPSKValue);
					goto setErr_encrypt;
				}
			}
			strcpy(Entry.wpaPSK, strVal);
			
		}
	}
#ifdef WLAN_1x
	if (enableRS == 1) { // if 1x enabled, get RADIUS server info
		unsigned short uShort;

		strVal = boaGetVar(wp, "radiusPort", "");
		if (!strVal[0]) {
			strcpy(tmpBuf, "没有RS端口数值!"); //No RS port number!
			goto setErr_encrypt;
		}
		if (!string_to_dec(strVal, &intVal) || intVal<=0 || intVal>65535) {
			strcpy(tmpBuf, strInvdRSPortNum);
			goto setErr_encrypt;
		}
		uShort = (unsigned short)intVal;
		Entry.rsPort = uShort;

		strVal = boaGetVar(wp, "radiusIP", "");
		if (!strVal[0]) {
			strcpy(tmpBuf, strNoIPAddr);
			goto setErr_encrypt;
		}
		if ( !inet_aton(strVal, &inIp) ) {
			strcpy(tmpBuf, strInvdRSIPValue);
			goto setErr_encrypt;
		}
		*((in_addr_t *)Entry.rsIpAddr) = inIp.s_addr;

		strVal = boaGetVar(wp, "radiusPass", "");
		if (strlen(strVal) > (MAX_PSK_LEN) ) {
			strcpy(tmpBuf, strRSPwdTooLong);
			goto setErr_encrypt;
		}
		strcpy(Entry.rsPassword, strVal);

		strVal = boaGetVar(wp, "radiusRetry", "");
		if (strVal[0]) {
			if ( !string_to_dec(strVal, &intVal) ) {
				strcpy(tmpBuf, strInvdRSRetry);
				goto setErr_encrypt;
			}
			vChar = (char)intVal;
			if ( !mib_set(MIB_WLAN_RS_RETRY, (void *)&vChar)) {
				strcpy(tmpBuf, strSetRSRETRYErr);
				goto setErr_encrypt;
			}
		}
		strVal = boaGetVar(wp, "radiusTime", "");
		if (strVal[0]) {
			if ( !string_to_dec(strVal, &intVal) ) {
				strcpy(tmpBuf, strInvdRSTime);
				goto setErr_encrypt;
			}
			uShort = (unsigned short)intVal;
			if ( !mib_set(MIB_WLAN_RS_INTERVAL_TIME, (void *)&uShort)) {
				strcpy(tmpBuf, strSetRSINTVLTIMEErr);
				goto setErr_encrypt;
			}
		}

get_wepkey:
		// get 802.1x WEP key length
		strVal = boaGetVar(wp, "wepKeyLen", "");
		if (strVal[0]) {
			if ( !gstrcmp(strVal, "wep64"))
				vChar = WEP64;
			else if ( !gstrcmp(strVal, "wep128"))
				vChar = WEP128;
			else {
				strcpy(tmpBuf, strInvdWepKeyLen);
				goto setErr_encrypt;
			}
			Entry.wep = vChar;
		}
	}
#endif

	wlan_setEntry(&Entry,i);

	//sleep(5);
	/*
	if (!wlan_getEntry(&Entry,i)) {
 		strcpy(tmpBuf, strGetMBSSIBTBLUpdtErr);
		goto setErr_encrypt;
	}
	
	printf("MIB_MBSSIB_TBL updated\n");
	printf("Entry.idx=%d\n", Entry.idx);
	printf("Entry.encrypt=%d\n", Entry.encrypt);
	printf("Entry.enable1X=%d\n", Entry.enable1X);
	printf("Entry.wep=%d\n", Entry.wep);
	printf("Entry.wpaAuth=%d\n", Entry.wpaAuth);
	printf("Entry.wpaPSKFormat=%d\n", Entry.wpaPSKFormat);
	printf("Entry.wpaPSK=%s\n", Entry.wpaPSK);
	printf("Entry.rsPort=%d\n", Entry.rsPort);
	printf("Entry.rsIpAddr=0x%x\n", *((unsigned long *)Entry.rsIpAddr));
	printf("Entry.rsPassword=%s\n", Entry.rsPassword);
	*/

set_OK:
#ifndef NO_ACTION
	run_script(-1);
#endif
#if defined(CONFIG_WIFI_SIMPLE_CONFIG) || defined(WLAN_WPS) //WPS
	//fprintf(stderr, "WPA WPS Configure\n");
	strVal = boaGetVar(wp, "wps_clear_configure_by_reg0", "");
	intVal = 0;
	if (strVal && strVal[0])
		intVal = atoi(strVal);
	update_wps_configured(intVal);
#endif

// Magician: Commit immediately
#ifdef COMMIT_IMMEDIATELY
	Commit();
#endif // of #if COMMIT_IMMEDIATELY
#if defined(WLAN_DUALBAND_CONCURRENT) && (defined (CONFIG_YUEME) || defined(CONFIG_CU_BASEON_YUEME))
#if defined(WLAN_BAND_STEERING)
	mib_get_s(MIB_WIFI_STA_CONTROL, (void *)&sta_control, sizeof(sta_control));
	if(sta_control==1 && wlan_idx==0)
		config_WLAN(ACT_RESTART, CONFIG_SSID_ALL);
	else
#endif
		config_WLAN(get_wlan_phyband()==PHYBAND_2G? ACT_RESTART_2G: ACT_RESTART_5G, CONFIG_SSID_ALL);
#else
	config_WLAN(ACT_RESTART, CONFIG_SSID_ALL);
#endif

	submitUrl = boaGetVar(wp, "submit-url", "");   // hidden page
	//OK_MSG(submitUrl);
	if (submitUrl[0])
		boaRedirect(wp, submitUrl);
	else
		boaDone(wp, 200);

	return;

setErr_encrypt:
	ERR_MSG(tmpBuf);
}
#endif // WLAN_WPA

#ifdef WLAN_ACL
/////////////////////////////////////////////////////////////////////////////
int wlAcList(int eid, request * wp, int argc, char **argv)
{
	int nBytesSent=0, entryNum, i;
	MIB_CE_WLAN_AC_T Entry;
	char tmpBuf[100];
#if defined(WLAN_DUALBAND_CONCURRENT)
	char *strVal;
	strVal = boaGetVar(wp, "wlan_idx", "");
	if ( strVal[0] ) {
		printf("wlan_idx=%d\n", strVal[0]-'0');
		wlan_idx = strVal[0]-'0';
	}
#endif //WLAN_DUALBAND_CONCURRENT

	entryNum = mib_chain_total(MIB_WLAN_AC_TBL);

	nBytesSent += boaWrite(wp, "<tr>"
      	"<td align=center width=\"45%%\" bgcolor=\"#808080\"><font size=\"2\"><b>%s</b></font></td>\n"
      	"<td align=center width=\"20%%\" bgcolor=\"#808080\"><font size=\"2\"><b>%s</b></font></td></tr>\n", multilang_bpas(strMACAddr), multilang_bpas(strSelect));
	for (i=0; i<entryNum; i++) {
		if (!mib_chain_get(MIB_WLAN_AC_TBL, i, (void *)&Entry))
		{
  			boaError(wp, 400, "Get chain record error!\n");
			return -1;
		}
		if(Entry.wlanIdx != wlan_idx)
			continue;
		snprintf(tmpBuf, 100, "%02x:%02x:%02x:%02x:%02x:%02x",
			Entry.macAddr[0], Entry.macAddr[1], Entry.macAddr[2],
			Entry.macAddr[3], Entry.macAddr[4], Entry.macAddr[5]);

		nBytesSent += boaWrite(wp, "<tr>"
			"<td align=center width=\"45%%\" bgcolor=\"#C0C0C0\"><font size=\"2\">%s</td>\n"
       			"<td align=center width=\"20%%\" bgcolor=\"#C0C0C0\"><input type=\"checkbox\" name=\"select%d\" value=\"ON\"></td></tr>\n",
				tmpBuf, i);
	}
	return nBytesSent;
}

/////////////////////////////////////////////////////////////////////////////
void formWlAc(request * wp, char *path, char *query)
{
	char *strAddMac, *strDelMac, *strDelAllMac, *strVal, *submitUrl, *strEnabled;
	char tmpBuf[100];
	char vChar;
	int entryNum, i, enabled;
	MIB_CE_WLAN_AC_T macEntry;
	MIB_CE_WLAN_AC_T Entry;
#ifdef WLAN_VAP_ACL
	MIB_CE_MBSSIB_T wlanEntry;
#endif
//xl_yue
	char * strSetMode;
	strSetMode = boaGetVar(wp, "setFilterMode", "");
	strAddMac = boaGetVar(wp, "addFilterMac", "");
	strDelMac = boaGetVar(wp, "deleteSelFilterMac", "");
	strDelAllMac = boaGetVar(wp, "deleteAllFilterMac", "");
	strEnabled = boaGetVar(wp, "wlanAcEnabled", "");
#if defined(WLAN_DUALBAND_CONCURRENT)
	strVal = boaGetVar(wp, "wlan_idx", "");
	if ( strVal[0] ) {
		printf("wlan_idx=%d\n", strVal[0]-'0');
		wlan_idx = strVal[0]-'0';
	}
#endif // WLAN_DUALBAND_CONCURRENT


//xl_yue: access control mode is set independently from adding MAC for 531b
	if (strSetMode[0]) {
		vChar = strEnabled[0] - '0';
#ifdef WLAN_VAP_ACL
		if ( !wlan_getEntry(&wlanEntry, 0) ) {
			//strcpy(tmpBuf, strGetMBSSIBTBLErr);
			snprintf(tmpBuf, sizeof(tmpBuf), "%s", strGetMBSSIBTBLErr);
			goto setErr_ac;
		}
		wlanEntry.acl_enable = vChar;
		if ( !wlan_setEntry(&wlanEntry,0) ) {
			strcpy(tmpBuf, strEnabAccCtlErr);
			goto setErr_ac;
		}
		goto setac_ret;
#else
		if ( mib_set( MIB_WLAN_AC_ENABLED, (void *)&vChar) == 0) {
  			strcpy(tmpBuf, strEnabAccCtlErr);
			goto setErr_ac;
		}
		goto setac_ret;
#endif
	}

	if (strAddMac[0]) {
		int intVal;
		/*
		if ( !gstrcmp(strEnabled, "ON"))
			vChar = 1;
		else
			vChar = 0;
		*/
		strVal = boaGetVar(wp, "mac", "");
		if ( !strVal[0] ) {
//			strcpy(tmpBuf, "Error! No mac address to set.");
			goto setac_ret;
		}

		if (strlen(strVal)!=12 || !rtk_string_to_hex(strVal, macEntry.macAddr, 12)) {
			//strcpy(tmpBuf, strInvdMACAddr);
			snprintf(tmpBuf, sizeof(tmpBuf), "%s", strInvdMACAddr);
			goto setErr_ac;
		}
		if (!isValidMacAddr(macEntry.macAddr)) {
			//strcpy(tmpBuf, strInvdMACAddr);
			snprintf(tmpBuf, sizeof(tmpBuf), "%s", strInvdMACAddr);
			goto setErr_ac;
		}
		macEntry.wlanIdx = wlan_idx;
/*
		strVal = boaGetVar(wp, "comment", "");
		if ( strVal[0] ) {
			if (strlen(strVal) > COMMENT_LEN-1) {
				strcpy(tmpBuf, "Error! Comment length too long.");
				goto setErr_ac;
			}
			strcpy(macEntry.comment, strVal);
		}
		else
			macEntry.comment[0] = '\0';
*/

		entryNum = mib_chain_total(MIB_WLAN_AC_TBL);
		if ( entryNum >= MAX_WLAN_AC_NUM ) {
			strcpy(tmpBuf, strAddAcErrForFull);
			goto setErr_ac;
		}

		// set to MIB. Check if entry exists
		for (i=0; i<entryNum; i++) {
			if (!mib_chain_get(MIB_WLAN_AC_TBL, i, (void *)&Entry))
			{
	  			strcpy(tmpBuf, "Get chain record error!\n");
				goto setErr_ac;
			}
			if(Entry.wlanIdx != macEntry.wlanIdx)
				continue;
			if (!memcmp(macEntry.macAddr, Entry.macAddr, 6))
			{
				//strcpy(tmpBuf, strMACInList);
				snprintf(tmpBuf, sizeof(tmpBuf), "%s", strMACInList);
				goto setErr_ac;
			}
		}

		intVal = mib_chain_add(MIB_WLAN_AC_TBL, (unsigned char*)&macEntry);
		if (intVal == 0) {
			//strcpy(tmpBuf, strAddListErr);
			snprintf(tmpBuf, sizeof(tmpBuf), "%s", strAddListErr);
			goto setErr_ac;
		}
		else if (intVal == -1) {
			//strcpy(tmpBuf, strTableFull);
			snprintf(tmpBuf, sizeof(tmpBuf), "%s", strTableFull);
			goto setErr_ac;
		}
	}

	/* Delete entry */
	if (strDelMac[0]) {
		unsigned int deleted = 0;
		entryNum = mib_chain_total(MIB_WLAN_AC_TBL);
		for (i=entryNum; i>0; i--) {
			if (!mib_chain_get(MIB_WLAN_AC_TBL, i-1, (void *)&Entry))
				break;
			if(Entry.wlanIdx != wlan_idx)
				continue;
			snprintf(tmpBuf, 20, "select%d", i-1);
			strVal = boaGetVar(wp, tmpBuf, "");

			if ( !gstrcmp(strVal, "ON") ) {

				deleted ++;
				if(mib_chain_delete(MIB_WLAN_AC_TBL, i-1) != 1) {
					strcpy(tmpBuf, strDelListErr);
					goto setErr_ac;
				}
			}
		}
		if (deleted <= 0) {
			strcpy(tmpBuf, "没有选择删除的项目!"); //There is no item selected to delete!
			goto setErr_ac;
		}
	}

	/* Delete all entry */
	if ( strDelAllMac[0]) {
		//mib_chain_clear(MIB_WLAN_AC_TBL); /* clear chain record */
		entryNum = mib_chain_total(MIB_WLAN_AC_TBL);
		for (i=entryNum; i>0; i--) {
			if (!mib_chain_get(MIB_WLAN_AC_TBL, i-1, (void *)&Entry)) {
	  			strcpy(tmpBuf, "chain record读取错误!");//Get chain record error!
				goto setErr_ac;
			}
			if(Entry.wlanIdx == wlan_idx) {
				if(mib_chain_delete(MIB_WLAN_AC_TBL, i-1) != 1) {
					strcpy(tmpBuf, strDelListErr);
					goto setErr_ac;
				}
			}
		}
	}

setac_ret:
	config_WLAN(ACT_RESTART, CONFIG_SSID_ALL);
// Magician: Commit immediately
#ifdef COMMIT_IMMEDIATELY
	Commit();
#endif // of #if COMMIT_IMMEDIATELY

#ifndef NO_ACTION
	run_script(-1);
#endif

	submitUrl = boaGetVar(wp, "submit-url", "");   // hidden page
	//OK_MSG( submitUrl );
	if (submitUrl[0])
		boaRedirect(wp, submitUrl);
	else
		boaDone(wp, 200);
  	return;

setErr_ac:
	ERR_MSG(tmpBuf);
}
#endif

// Added by Mason Yu
#ifdef WLAN_MBSSID
int wlmbssid_asp(int eid, request * wp, int argc, char **argv)
{
	char	*string_0[] = {	"Vap0", "Vap1", "Vap2", "Vap3" };
    	char	*string_1[] = { "En_vap0", "En_vap1", "En_vap2", "En_vap3"}; //En_vap(WlanCardIdx)(VAPIdx)
    	char	*string_2[] = { "ssid_v0", "ssid_v1", "ssid_v2", "ssid_v3"};     //ssid_v(WlanCardIdx)(VAPIdx)
    	volatile int	cntLoop, cntwlancard;
    	//uint8	totalWlanCards;

    	//totalWlanCards = pRomeCfgParam->wlaninterCfgParam.totalWlanCards;

	boaWrite(wp,
			"<form method=\"get\" action=\"/boaform/asp_setWlanMBS\" name=userform>\n"\
			"<BR>\n"
	);

	//for (cntwlancard=0; cntwlancard<totalWlanCards; cntwlancard++)
	{

			boaWrite(wp,
				"<table cellSpacing=1 cellPadding=2 border=1>\n"\
				"<tr><td bgColor=bbccff>Wireless Card </td></tr></table>\n"\
				"<table cellSpacing=1 cellPadding=2 border=0>\n"\
				"<tr>\n"
				);


			for(cntLoop=0; cntLoop<MAX_WLAN_VAP; cntLoop++)
			{
				boaWrite(wp,
					"<tr>\n"\
					"<td bgColor=#ddeeff>%s</td>\n",
					string_0[cntLoop]
				);
				/*
				if (pRomeCfgParam->wlanCfgParam[cntwlancard].enable)
				{
					boaWrite(wp,
						"<td bgColor=#ddeeff><input type=checkbox name=%s value=1 %s onClick=\"onload_func();\">Enable</td>\n",
						string_1[cntwlancard*4+cntLoop], pRomeCfgParam->wlanCfgParam[cntwlancard].enable_vap[cntLoop]?"checked":""
					);
				}
				else
				{
					boaWrite(wp,
						"<td bgColor=#ddeeff><input type=checkbox name=%s disabled value=1 %s onClick=\"onload_func();\">Enable</td>\n",
						string_1[cntwlancard*4+cntLoop], pRomeCfgParam->wlanCfgParam[cntwlancard].enable_vap[cntLoop]?"checked":""
					);
				}
				*/
				boaWrite(wp,
						"<td bgColor=#ddeeff><input type=checkbox name=%s value=1 %s onClick=\"onload_func();\">Enable</td>\n",
						string_1[cntLoop], "checked"
					);

				boaWrite(wp,
					"<td bgColor=#aaddff>SSID</td>\n"\
					"<td bgColor=#ddeeff><input type=text name=%s size=16 maxlength=16 value=%s></td>\n"\
					"</tr>\n",
					string_2[cntLoop], "CTC-1q2w"
		            );
			}
	}

	boaWrite(wp,
			"<tr>\n"\
			"<td colspan=2 align=center>\n"\
			"<input type=submit value=Apply>\n"\
	        	"<input type=reset value=Reset>\n"\
			"</td>\n"\
			"</tr>\n"\
			"</table> </form>\n"
	);
	return 0;
}

void formWlanMBSSID(request * wp, char *path, char *query)
{
	char	*str, *submitUrl;
	MIB_CE_MBSSIB_T Entry;
	char tmpBuf[100], en_vap[256];
	int i;
	AUTH_TYPE_T authType;
#ifndef NO_ACTION
	int pid;
#endif
	unsigned char vChar;

#if defined(WLAN_DUALBAND_CONCURRENT)
	str = boaGetVar(wp, "wlan_idx", "");
	if ( str[0] ) {
		printf("wlan_idx=%d\n", str[0]-'0');
		wlan_idx = str[0]-'0';
	}
#endif //WLAN_DUALBAND_CONCURRENT

	//for blocking between MBSSID
	sprintf(en_vap, "mbssid_block");
	str = boaGetVar(wp, en_vap, "");
	if (str[0]) {
		if ( !gstrcmp(str, "disable"))
			vChar = 0;
		else
			vChar = 1;

		if ( mib_set(MIB_WLAN_BLOCK_MBSSID, (void *)&vChar) == 0) {
			strcpy(tmpBuf, "set MBSSID error!");
			goto setErr_mbssid;
		}
	}

	for (i=0; i<4; i++) {
		sprintf(en_vap, "En_vap%d", i);
		str = boaGetVar(wp, en_vap, "");
		if ( str && str[0] ) {	// enable
			if (!mib_chain_get(MIB_MBSSIB_TBL, i+1, (void *)&Entry)) {
  				//strcpy(tmpBuf, strGetMBSSIBTBLErr);
  				snprintf(tmpBuf, sizeof(tmpBuf), "%s", strGetMBSSIBTBLErr);
				goto setErr_mbssid;
			}

			Entry.wlanDisabled = 0;
			mib_chain_update(MIB_MBSSIB_TBL, (void *)&Entry, i+1);
		} else {		// disable
			if (!mib_chain_get(MIB_MBSSIB_TBL, i+1, (void *)&Entry)) {
  				//strcpy(tmpBuf, strGetMBSSIBTBLErr);
  				snprintf(tmpBuf, sizeof(tmpBuf), "%s", strGetMBSSIBTBLErr);
				goto setErr_mbssid;
			}

			Entry.wlanDisabled = 1;
			mib_chain_update(MIB_MBSSIB_TBL, (void *)&Entry, i+1);
		}
	}

	for (i=0; i<4; i++) {
		sprintf(en_vap, "ssid_v%d", i);
		str = boaGetVar(wp, en_vap, "");
		if ( str ) {
			if (!mib_chain_get(MIB_MBSSIB_TBL, i+1, (void *)&Entry)) {
  				//strcpy(tmpBuf, strGetMULTIAPTBLErr);
  				snprintf(tmpBuf, sizeof(tmpBuf), "%s", strGetMBSSIBTBLErr);
				goto setErr_mbssid;
			}

			strcpy(Entry.ssid, str);
			mib_chain_update(MIB_MBSSIB_TBL, (void *)&Entry, i+1);
		}
	}

	for (i=0; i<4; i++) {
		sprintf(en_vap, "wlAPIsolation_wl%d", i);
		str = boaGetVar(wp, en_vap, "");
		if ( str ) {
			if (!mib_chain_get(MIB_MBSSIB_TBL, i+1, (void *)&Entry)) {
  				strcpy(tmpBuf, "strGetVAPMBSSIBTBLErr");
				goto setErr_mbssid;
			}
			if (str[0] == '0')
				vChar = 0;
			else // '1'
				vChar = 1;

			Entry.userisolation = vChar;
			mib_chain_update(MIB_MBSSIB_TBL, (void *)&Entry, i+1);
		}
	}

	config_WLAN(ACT_RESTART, CONFIG_SSID_ALL);

#ifdef COMMIT_IMMEDIATELY
	Commit();
#endif // of #if COMMIT_IMMEDIATELY

#ifndef NO_ACTION
	pid = fork();
	if (pid)
		waitpid(pid, NULL, 0);
	else if (pid == 0) {
		snprintf(tmpBuf, 100, "%s/%s", _CONFIG_SCRIPT_PATH, _CONFIG_SCRIPT_PROG);
#ifdef HOME_GATEWAY
		execl( tmpBuf, _CONFIG_SCRIPT_PROG, "gw", "bridge", NULL);
#else
		execl( tmpBuf, _CONFIG_SCRIPT_PROG, "ap", "bridge", NULL);
#endif
		exit(1);
	}
#endif

	submitUrl = boaGetVar(wp, "submit-url", "");
	OK_MSG(submitUrl);
  	return;

setErr_mbssid:
	ERR_MSG(tmpBuf);
}


#ifdef CONFIG_RTL_WAPI_SUPPORT
void wapi_mod_entry(MIB_CE_MBSSIB_T *Entry, char *strbuf, char *strbuf2) {
	int len;

	Entry->wpaPSKFormat = Entry->wapiPskFormat;
	Entry->wep = 0;
	Entry->enable1X = 0;
	Entry->rsPort = 0;
	Entry->rsPassword[0] = 0;

	if (Entry->wapiAuth==1) {// AS
		Entry->wpaAuth = 1;

		if ( ((struct in_addr *)Entry->wapiAsIpAddr)->s_addr == INADDR_NONE ) {
			sprintf(strbuf2, "%s", "");
		} else {
			sprintf(strbuf2, "%s", inet_ntoa(*((struct in_addr *)Entry->wapiAsIpAddr)));
		}


	} else { //PSK
		Entry->wpaAuth = 2;

		for (len=0; len<Entry->wapiPskLen; len++)
			strbuf[len]='*';
		strbuf[len]='\0';
	}
}
#endif

void formWlanMultipleAP(request * wp, char *path, char *query)
{
	char *str, *submitUrl;
	MIB_CE_MBSSIB_T Entry;
	char tmpBuf[100], en_vap[256];
	int i, val;
#ifndef NO_ACTION
	int pid;
#endif
	unsigned char vChar;

#if defined(WLAN_DUALBAND_CONCURRENT)
	str = boaGetVar(wp, "wlan_idx", "");
	if ( str[0] ) {
		printf("wlan_idx=%d\n", str[0]-'0');
		wlan_idx = str[0]-'0';
	}
#endif //WLAN_DUALBAND_CONCURRENT

	//for blocking between MBSSID
	sprintf(en_vap, "mbssid_block");
	str = boaGetVar(wp, en_vap, "");
	if (str[0]) {
		if ( !gstrcmp(str, "disable"))
			vChar = 0;
		else
			vChar = 1;

		if ( mib_set(MIB_WLAN_BLOCK_MBSSID, (void *)&vChar) == 0) {
			strcpy(tmpBuf, "set MBSSID error!");
			goto setErr_mbssid;
		}
	}

	for (i = 1; i <= NUM_VWLAN_INTERFACE; i ++) {
#ifdef WLAN_UNIVERSAL_REPEATER
		if (i == WLAN_REPEATER_ITF_INDEX) {
			continue;
		}
#endif
		if (!mib_chain_get(MIB_MBSSIB_TBL, i, (void *)&Entry)) {
			snprintf(tmpBuf, sizeof(tmpBuf), "%s", strGetMULTIAPTBLErr);
			goto setErr_mbssid;
		}

		sprintf(en_vap, "wl_disable%d", i);
		str = boaGetVar(wp, en_vap, "");
		if (str && !strcmp(str, "ON")) {	// enable
			Entry.wlanDisabled = 0;
		}
		else {	// disable
			Entry.wlanDisabled = 1;
			mib_chain_update(MIB_MBSSIB_TBL, (void *)&Entry, i);
			continue;
		}

		sprintf(en_vap, "wl_band%d", i);
		str = boaGetVar(wp, en_vap, "");
		if (str) {
			vChar = atoi(str);
			vChar ++;

			Entry.wlanBand= vChar;
			update_on_band_changed(&Entry, i, Entry.wlanBand);
		}

		sprintf(en_vap, "wl_ssid%d", i);
		str = boaGetVar(wp, en_vap, "");
		if (str) {
			snprintf(Entry.ssid, sizeof(Entry.ssid), "%s", str);
		}

		sprintf(en_vap, "TxRate%d", i);
		str = boaGetVar(wp, en_vap, "");
		if (str) {
			if (str[0] == '0') { // auto
				vChar = 1;
				Entry.rateAdaptiveEnabled = vChar;
			}
			else {
				vChar = 0;
				Entry.rateAdaptiveEnabled = vChar;
				val = atoi(str);
				if (val < 30 && val > 0)
					val = 1 << (val - 1);
				else
					val = ((1 << 31) + (val - 30));
				Entry.fixedTxRate = val;
			}
		}

		sprintf(en_vap, "wl_hide_ssid%d", i);
		str = boaGetVar(wp, en_vap, "");
		if (str) {
			if (str[0] == '0')
				vChar = 0;
			else		// '1'
				vChar = 1;
			Entry.hidessid = vChar;
		}

		sprintf(en_vap, "wl_wmm_capable%d", i);
		str = boaGetVar(wp, en_vap, "");
		if (str) {
			if (str[0] == '0')
				vChar = 0;
			else		// '1'
				vChar = 1;
			Entry.wmmEnabled = vChar;
		}

		sprintf(en_vap, "wl_access%d", i);
		str = boaGetVar(wp, en_vap, "");
		if (str) {
			if (str[0] == '0')
				vChar = 0;
			else		// '1'
				vChar = 1;
			Entry.userisolation = vChar;
		}
		mib_chain_update(MIB_MBSSIB_TBL, (void *)&Entry, i);
	}

	config_WLAN(ACT_RESTART, CONFIG_SSID_ALL);

#ifdef COMMIT_IMMEDIATELY
	Commit();
#endif // of #if COMMIT_IMMEDIATELY

#ifndef NO_ACTION
	pid = fork();
	if (pid)
		waitpid(pid, NULL, 0);
	else if (pid == 0) {
		snprintf(tmpBuf, 100, "%s/%s", _CONFIG_SCRIPT_PATH, _CONFIG_SCRIPT_PROG);
#ifdef HOME_GATEWAY
		execl( tmpBuf, _CONFIG_SCRIPT_PROG, "gw", "bridge", NULL);
#else
		execl( tmpBuf, _CONFIG_SCRIPT_PROG, "ap", "bridge", NULL);
#endif
		exit(1);
	}
#endif

	submitUrl = boaGetVar(wp, "submit-url", "");
	OK_MSG(submitUrl);
  	return;

setErr_mbssid:
	ERR_MSG(tmpBuf);
}

int checkSSID(int eid, request * wp, int argc, char **argv)
{
	char *name;
	MIB_CE_MBSSIB_T Entry;
	//char strbuf[20], strbuf2[20];
	//int len;
	int i;

	if (boaArgs(argc, argv, "%s", &name) < 1) {
		boaError(wp, 400, "Insufficient args\n");
		return -1;
	}

	if ( !strcmp(name, "vap0") ){
		i = 1;

	}
	else if ( !strcmp(name, "vap1") ) {
		i = 2;
	}
	else if ( !strcmp(name, "vap2") ) {
		i = 3;
	}
	else if ( !strcmp(name, "vap3") ) {
		i = 4;
	}
	else {
		printf("Not support this VAP!\n");
		return 1;
	}

	if (!mib_chain_get(MIB_MBSSIB_TBL, i, (void *)&Entry)) {
  		printf("Error! Get MIB_MBSSIB_TBL(Root) error.\n");
			return 1;
	}

	if ( Entry.wlanDisabled == 0 ) {
		boaWrite(wp, "checked");
	} else {
		boaWrite(wp, "");
	}
	return 0;
}


int SSIDStr(int eid, request * wp, int argc, char **argv)
{
	char *name;
	MIB_CE_MBSSIB_T Entry;
	//char strbuf[20], strbuf2[20];
	//int len;
	int i;
	char ssid[200];

	if (boaArgs(argc, argv, "%s", &name) < 1) {
		boaError(wp, 400, "Insufficient args\n");
		return -1;
	}

	if ( !strcmp(name, "vap0") ){
		i = 1;

	}
	else if ( !strcmp(name, "vap1") ) {
		i = 2;

	}
	else if ( !strcmp(name, "vap2") ) {
		i = 3;
	}
	else if ( !strcmp(name, "vap3") ) {
		i = 4;
	}
	else {
		printf("SSIDStr: Not support this VAP!\n");
		return 1;
	}
	{
		if (!mib_chain_get(MIB_MBSSIB_TBL, i, (void *)&Entry)) {
	  		printf("Error! Get MIB_MBSSIB_TBL(SSIDStr) error.\n");
  			return 1;
		}
	}
	{
		strncpy(ssid, Entry.ssid, MAX_SSID_LEN);
		translate_control_code(ssid);
		boaWrite(wp, "%s", ssid);
	}

	return 0;
}
#endif

/////////////////////////////////////////////////////////////////////////////
//check wlan status and set checkbox
int wlanStatus(int eid, request * wp, int argc, char **argv)
{
#ifdef WLAN_SUPPORT
	if (wlan_is_up())
	    //boaWrite(wp, "\"OFF\" enabled");
	    boaWrite(wp, "\"OFF\"");
	else
	    //boaWrite(wp, "\"ON\" checked disabled");
	    boaWrite(wp, "\"ON\" checked");
	return 0;
#endif
}

#ifdef WLAN_SUPPORT
int wlan_interface_status(int eid, request * wp, int argc, char **argv)
{
	int status;
	MIB_CE_MBSSIB_T Entry;
#if defined(WLAN_DUALBAND_CONCURRENT)
	int orig_idx = wlan_idx;
#endif
	int i, j;
	for(i=0; i<NUM_WLAN_INTERFACE; i++){
		wlan_idx = i;
		status = 0;
		
		mib_chain_get(MIB_MBSSIB_TBL, 0, (void *)&Entry);
		if(Entry.wlanDisabled==0){
			status=1;
		}

		if(status==0){
			for(j=0; j<WLAN_MBSSID_NUM; j++){
				mib_chain_get(MIB_MBSSIB_TBL, j+1, (void *)&Entry);
				if(Entry.wlanDisabled==0){
					status=1;
					break;
				}
			}
		}
		
		boaWrite(wp, "wlan_root_interface_up[%d]=%d;\n", i, status);
	}
#if defined(WLAN_DUALBAND_CONCURRENT)
	wlan_idx = orig_idx;
#endif
	return 0;
}
#endif

#ifdef WLAN_SUPPORT
int wlan_ssid_select(int eid, request * wp, int argc, char **argv)
{
	MIB_CE_MBSSIB_T Entry;
	WLAN_MODE_T root_mode;
	int len, i, k;
	char repeater_AP[]="Repeater AP";
	char repeater_Client[]="Repeater Client";
	char *pstr;
	char ssid[200];

	wlan_getEntry(&Entry, 0);
	strncpy(ssid, Entry.ssid, MAX_SSID_LEN);
	translate_control_code(ssid);
	root_mode = (WLAN_MODE_T)Entry.wlanMode;
	k=0;
	if (root_mode!=CLIENT_MODE) {
		/*--------------------- Root AP ----------------------------*/
		boaWrite(wp, "<option value=0>Root AP - %s</option>\n", ssid);
		#ifdef WLAN_MBSSID
		/*----------------------- VAP ------------------------------*/
		for (i=0; i<WLAN_MBSSID_NUM; i++) {
#if defined(CONFIG_CT_AWIFI_JITUAN_FEATURE)
            unsigned char functype=0;
            mib_get_s(AWIFI_PROVINCE_CODE, &functype, sizeof(functype));
            if(functype == AWIFI_ZJ){
                if(i == 0)	continue;
            }
#endif
			wlan_getEntry(&Entry, WLAN_VAP_ITF_INDEX+i);
			strncpy(ssid, Entry.ssid, MAX_SSID_LEN);
			translate_control_code(ssid);
			if (!Entry.wlanDisabled) {
				boaWrite(wp, "\t\t<option value=%d>AP%d - %s\n", WLAN_VAP_ITF_INDEX + i, i + 1, ssid);
			}
		}
		#endif
	}
	else { // client mode
		/*--------------------- Root Client ----------------------------*/
		boaWrite(wp, "<option value=0>Root Client - %s</option>\n", Entry.ssid);
	}
	#ifdef WLAN_UNIVERSAL_REPEATER
	wlan_getEntry(&Entry, WLAN_REPEATER_ITF_INDEX);
	strncpy(ssid, Entry.ssid, MAX_SSID_LEN);
	translate_control_code(ssid);
	if (!Entry.wlanDisabled && (root_mode != WDS_MODE)) {
		if (root_mode == CLIENT_MODE)
			pstr = repeater_AP;
		else
			pstr = repeater_Client;

		boaWrite(wp, "\t\t<option value=%d>%s - %s</option>\n", WLAN_REPEATER_ITF_INDEX, pstr, ssid);
	}
	#endif
	return 0;
}
#endif

/////////////////////////////////////////////////////////////////////////////
void formAdvanceSetup(request * wp, char *path, char *query)
{
	char *submitUrl, *strAuth, *strFragTh, *strRtsTh, *strBeacon, *strPreamble;
	char *strRate, *strHiddenSSID, *strDtim, *strIapp, *strBlock;
	char *strProtection, *strAggregation, *strShortGIO, *strVal;
	char vChar;
	unsigned short uShort;
	AUTH_TYPE_T authType;
	PREAMBLE_T preamble;
	int val;
	char tmpBuf[100];
	MIB_CE_MBSSIB_T Entry;

#if defined(WLAN_DUALBAND_CONCURRENT)
	strVal = boaGetVar(wp, "wlan_idx", "");
	if ( strVal[0] ) {
		printf("wlan_idx=%d\n", strVal[0]-'0');
		wlan_idx = strVal[0]-'0';
	}
#endif //WLAN_DUALBAND_CONCURRENT
//xl_yue: translocate to basic_setting   for ZTE531B BRIDGE
	mib_chain_get(MIB_MBSSIB_TBL, 0, (void *)&Entry);

	strFragTh = boaGetVar(wp, "fragThreshold", "");
	if (strFragTh[0]) {
		if ( !string_to_dec(strFragTh, &val) || val<256 || val>2346) {
			//strcpy(tmpBuf, strFragThreshold);
			snprintf(tmpBuf, sizeof(tmpBuf), "%s", strFragThreshold);
			goto setErr_advance;
		}
		uShort = (unsigned short)val;
		if ( mib_set(MIB_WLAN_FRAG_THRESHOLD, (void *)&uShort) == 0) {
			//strcpy(tmpBuf, strSetFragThreErr);
			snprintf(tmpBuf, sizeof(tmpBuf), "%s", strSetFragThreErr);
			goto setErr_advance;
		}
	}
	strRtsTh = boaGetVar(wp, "rtsThreshold", "");
	if (strRtsTh[0]) {
		if ( !string_to_dec(strRtsTh, &val) || val<0 || val>2347) {
			//strcpy(tmpBuf, strRTSThreshold);
			snprintf(tmpBuf, sizeof(tmpBuf), "%s", strRTSThreshold);
			goto setErr_advance;
		}
		uShort = (unsigned short)val;
		if ( mib_set(MIB_WLAN_RTS_THRESHOLD, (void *)&uShort) == 0) {
			//strcpy(tmpBuf, strSetRTSThreErr);
			snprintf(tmpBuf, sizeof(tmpBuf), "%s", strSetRTSThreErr);
			goto setErr_advance;
		}
	}

	strBeacon = boaGetVar(wp, "beaconInterval", "");
	if (strBeacon[0]) {
		if ( !string_to_dec(strBeacon, &val) || val<MIN_WLAN_BEACON_INTERVAL || val>1024) {
			//strcpy(tmpBuf, strInvdBeaconIntv);
			snprintf(tmpBuf, sizeof(tmpBuf), "%s", strInvdBeaconIntv);
			goto setErr_advance;
		}
		uShort = (unsigned short)val;
		if ( mib_set(MIB_WLAN_BEACON_INTERVAL, (void *)&uShort) == 0) {
			//strcpy(tmpBuf, strSetBeaconIntvErr);
			snprintf(tmpBuf, sizeof(tmpBuf), "%s", strSetBeaconIntvErr);
			goto setErr_advance;
		}
	}

//xl_yue: translocate to basic_setting  for ZTE531B BRIDGE
	// set tx rate
	strRate = boaGetVar(wp, "txRate", "");
	if ( strRate[0] ) {
		if ( strRate[0] == '0' )  // auto
			Entry.rateAdaptiveEnabled = 1;
		else  {
			Entry.rateAdaptiveEnabled = 0;
			{
				unsigned int uInt;
				uInt = atoi(strRate);
				if((uInt<29) && (uInt>0))
					uInt = 1 << (uInt-1);
				else if(uInt>=29 && uInt<45)
					uInt = ((1 << 28) + (uInt-29));
				else
					uInt = ((1 << 31) + (uInt-45));
				Entry.fixedTxRate = uInt;
			}
		}

		strRate = boaGetVar(wp, "basicrates", "");
		if ( strRate[0] ) {
			uShort = atoi(strRate);
			if ( mib_set(MIB_WLAN_BASIC_RATE, (void *)&uShort) == 0) {
				//strcpy(tmpBuf, strSetBaseRateErr);
				snprintf(tmpBuf, sizeof(tmpBuf), "%s", strSetBaseRateErr);
				goto setErr_advance;
			}
		}

		strRate = boaGetVar(wp, "operrates", "");
		if ( strRate[0] ) {
			uShort = atoi(strRate);
			if ( mib_set(MIB_WLAN_SUPPORTED_RATE, (void *)&uShort) == 0) {
				//strcpy(tmpBuf, strSetOperRateErr);
				snprintf(tmpBuf, sizeof(tmpBuf), "%s", strSetOperRateErr);
				goto setErr_advance;
			}
		}
	}
	else { // set rate in operate, basic sperately
#ifdef WIFI_TEST
		// disable rate adaptive
		Entry.rateAdaptiveEnabled = 0;
#endif // of WIFI_TEST
	}

	// set preamble
	strPreamble = boaGetVar(wp, "preamble", "");
	if (strPreamble[0]) {
		if (!gstrcmp(strPreamble, "long"))
			preamble = LONG_PREAMBLE;
		else if (!gstrcmp(strPreamble, "short"))
			preamble = SHORT_PREAMBLE;
		else {
			//strcpy(tmpBuf, strInvdPreamble);
			snprintf(tmpBuf, sizeof(tmpBuf), "%s", strInvdPreamble);
			goto setErr_advance;
		}
		vChar = (char)preamble;
		if ( mib_set(MIB_WLAN_PREAMBLE_TYPE, (void *)&vChar) == 0) {
			//strcpy(tmpBuf, strSetPreambleErr);
			snprintf(tmpBuf, sizeof(tmpBuf), "%s", strSetPreambleErr);
			goto setErr_advance;
		}
	}

	// set hidden SSID
	strHiddenSSID = boaGetVar(wp, "hiddenSSID", "");
	if (strHiddenSSID[0]) {
		if (!gstrcmp(strHiddenSSID, "no"))
			vChar = 0;
		else if (!gstrcmp(strHiddenSSID, "yes"))
			vChar = 1;
		else {
			//strcpy(tmpBuf, strInvdBrodSSID);
			snprintf(tmpBuf, sizeof(tmpBuf), "%s", strInvdBrodSSID);
			goto setErr_advance;
		}
		Entry.hidessid = vChar;
	}

	strProtection = boaGetVar(wp, "protection", "");
	if (strProtection[0]){
		if (!gstrcmp(strProtection,"yes"))
			vChar = 0;
		else if (!gstrcmp(strProtection,"no"))
			vChar = 1;
		else{
			//strcpy(tmpBuf, strInvdProtection);
			snprintf(tmpBuf, sizeof(tmpBuf), "%s", strInvdProtection);
			goto setErr_advance;
		}
		if (mib_set(MIB_WLAN_PROTECTION_DISABLED,(void *)&vChar) ==0){
			//strcpy(tmpBuf, strSetProtectionErr);
			snprintf(tmpBuf, sizeof(tmpBuf), "%s", strSetProtectionErr);
			goto setErr_advance;
		}
	}

	strAggregation = boaGetVar(wp, "aggregation", "");
	if (strAggregation[0]){
		if (!gstrcmp(strAggregation,"enable"))
			vChar = 1;
		else if (!gstrcmp(strAggregation,"disable"))
			vChar = 0;
		else{
			//strcpy(tmpBuf, strInvdAggregation);
			snprintf(tmpBuf, sizeof(tmpBuf), "%s", strInvdAggregation);
			goto setErr_advance;
		}
		if (mib_set(MIB_WLAN_AGGREGATION,(void *)&vChar) ==0){
			//strcpy(tmpBuf, strSetAggregationErr);
			snprintf(tmpBuf, sizeof(tmpBuf), "%s", strSetAggregationErr);
			goto setErr_advance;
		}
	}

	strShortGIO = boaGetVar(wp, "shortGI0", "");
	if (strShortGIO[0]){
		if (!gstrcmp(strShortGIO,"on"))
			vChar = 1;
		else if (!gstrcmp(strShortGIO,"off"))
			vChar = 0;
		else{
			//strcpy(tmpBuf, strInvdShortGI0);
			snprintf(tmpBuf, sizeof(tmpBuf), "%s", strInvdShortGI0);
			goto setErr_advance;
		}
		if (mib_set(MIB_WLAN_SHORTGI_ENABLED,(void *)&vChar) ==0){
			//strcpy(tmpBuf, strSetShortGI0Err);
			snprintf(tmpBuf, sizeof(tmpBuf), "%s", strSetShortGI0Err);
			goto setErr_advance;
		}
	}

	strDtim = boaGetVar(wp, "dtimPeriod", "");
	if (strDtim[0]) {
		if ( !string_to_dec(strDtim, &val) || val<1 || val>255) {
			//strcpy(tmpBuf, strInvdDTIMPerd);
			snprintf(tmpBuf, sizeof(tmpBuf), "%s", strInvdDTIMPerd);
			goto setErr_advance;
		}
		vChar = (char)val;
		if ( mib_set(MIB_WLAN_DTIM_PERIOD, (void *)&vChar) == 0) {
			//strcpy(tmpBuf, strSetDTIMErr);
			snprintf(tmpBuf, sizeof(tmpBuf), "%s", strSetDTIMErr);
			goto setErr_advance;
		}
	}

	// set block-relay
	strBlock = boaGetVar(wp, "block", "");
	if (strBlock[0]) {
		if (strBlock[0] == '0')
			vChar = 0;
		else // '1'
			vChar = 1;
		Entry.userisolation = vChar;
	}

#ifdef WLAN_QoS
	strBlock = boaGetVar(wp, "WmmEnabled", "");
	if (strBlock[0]) {
		if (strBlock[0] == '0')
			vChar = 0;
		else // '1'
			vChar = 1;
		Entry.wmmEnabled = vChar;
	}
#endif
	mib_chain_update(MIB_MBSSIB_TBL, (void *)&Entry, 0);
	config_WLAN(ACT_RESTART, CONFIG_SSID_ALL);

// Magician: Commit immediately
#ifdef COMMIT_IMMEDIATELY
	Commit();
#endif // of #if COMMIT_IMMEDIATELY

#ifndef NO_ACTION
	run_script(-1);
#endif

	submitUrl = boaGetVar(wp, "submit-url", "");   // hidden page

//	boaRedirect(wp, submitUrl);
	//OK_MSG(submitUrl);
	if (submitUrl[0])
		boaRedirect(wp, submitUrl);
	else
		boaDone(wp, 200);
  	return;

setErr_advance:
	ERR_MSG(tmpBuf);
}


/////////////////////////////////////////////////////////////////////////////
void formWirelessVAPTbl(request * wp, char *path, char *query)
{
	char *submitUrl;

	submitUrl = boaGetVar(wp, "submit-url", "");
	if (submitUrl[0])
		boaRedirect(wp, submitUrl);
}

/////////////////////////////////////////////////////////////////////////////
int wirelessClientList(int eid, request * wp, int argc, char **argv)
{
	int nBytesSent = 0, i, found = 0;
	int x,y;
	WLAN_STA_INFO_Tp pInfo;
	char *buff=NULL;
	char ifname[16];
#ifdef WIFI5_WIFI6_COMP
	char *buff_extra=NULL;
#endif

	buff = calloc(1, sizeof(WLAN_STA_INFO_T) * (MAX_STA_NUM + 1));
	if (buff == NULL) {
		printf("Allocate buffer failed!\n");
		goto end;
	}

#ifdef WIFI5_WIFI6_COMP
	buff_extra = calloc(1, sizeof(WLAN_STA_EXTRA_INFO_T) * (MAX_STA_NUM + 1));
	if (buff_extra == NULL) {
		printf("Allocate buffer extra failed!\n");
		goto end;
	}
#endif

	for (x=0; x<NUM_WLAN_INTERFACE; x++)
	{
	for(y=0; y<WLAN_SSID_NUM; y++)
	{
		memset(buff, 0, sizeof(WLAN_STA_INFO_T) * (MAX_STA_NUM + 1));
#ifdef WIFI5_WIFI6_COMP
		memset(buff_extra, 0, sizeof(WLAN_STA_EXTRA_INFO_T) * (MAX_STA_NUM + 1));
#endif
		rtk_wlan_get_ifname(x, y, ifname);

	if (getInFlags(ifname, 0)==0){
		continue;
	}
	if (getWlStaInfo(ifname, (WLAN_STA_INFO_Tp) buff) < 0) {
		printf("Read wlan sta info failed!\n");
		//free(buff);
		//return 0;
		continue;
	}

#ifdef WIFI5_WIFI6_COMP
	if (getWlStaExtraInfo(ifname, (WLAN_STA_EXTRA_INFO_Tp) buff_extra) < 0) {
		printf("Read wlan sta extra info failed!\n");
		continue;
	}
#endif

	for (i = 1; i <= MAX_STA_NUM; i++) {
		pInfo = (WLAN_STA_INFO_Tp) & buff[i * sizeof(WLAN_STA_INFO_T)];
		if (pInfo->aid && (pInfo->flags & STA_INFO_FLAG_ASOC)) {

			char txrate[20]={0};
#ifdef WIFI5_WIFI6_COMP
			rtk_wlan_get_sta_extra_rate(pInfo->addr, (WLAN_STA_EXTRA_INFO_Tp) buff_extra, WLAN_STA_TX_RATE, txrate, 20);
#else
			rtk_wlan_get_sta_rate(pInfo, WLAN_STA_TX_RATE, txrate, 20);
#endif
#if 0
			int rateid = 0;

			if(pInfo->TxOperaRate >= VHT_RATE_ID) {
				//sprintf(txrate, "%d", pInfo->acTxOperaRate);
				set_11ac_txrate(pInfo, txrate, sizeof(txrate));
			}else if ((pInfo->TxOperaRate & 0x80) != 0x80) {
				if (pInfo->TxOperaRate % 2) {
					sprintf(txrate, "%d%s",
						pInfo->TxOperaRate / 2, ".5");
				} else {
					sprintf(txrate, "%d",
						pInfo->TxOperaRate / 2);
				}
			} else {
				sprintf(txrate, "%s", MCS_DATA_RATEStr[(pInfo->ht_info & 0x1)?1:0][(pInfo->ht_info & 0x2)?1:0][pInfo->TxOperaRate-HT_RATE_ID]);
			
#if 0
				if ((pInfo->ht_info & 0x1) == 0) {	//20M
					if ((pInfo->ht_info & 0x2) == 0) {	//long
						for (rateid = 0;
						     rateid < 16; rateid++) {
							if (rate_11n_table_20M_LONG[rateid].id == pInfo->TxOperaRate) {
								sprintf
								    (txrate,
								     "%s",
								     rate_11n_table_20M_LONG
								     [rateid].rate);
								break;
							}
						}
					} else if ((pInfo->ht_info & 0x2) == 0x2) {	//short
						for (rateid = 0;
						     rateid < 16; rateid++) {
							if (rate_11n_table_20M_SHORT[rateid].id == pInfo->TxOperaRate) {
								sprintf
								    (txrate,
								     "%s",
								     rate_11n_table_20M_SHORT
								     [rateid].rate);
								break;
							}
						}
					}
				} else if ((pInfo->ht_info & 0x1) == 0x1) {	//40M
					if ((pInfo->ht_info & 0x2) == 0) {	//long

						for (rateid = 0;
						     rateid < 16; rateid++) {
							if (rate_11n_table_40M_LONG[rateid].id == pInfo->TxOperaRate) {
								sprintf
								    (txrate,
								     "%s",
								     rate_11n_table_40M_LONG
								     [rateid].rate);
								break;
							}
						}
					} else if ((pInfo->ht_info & 0x2) == 0x2) {	//short
						for (rateid = 0;
						     rateid < 16; rateid++) {
							if (rate_11n_table_40M_SHORT[rateid].id == pInfo->TxOperaRate) {
								sprintf
								    (txrate,
								     "%s",
								     rate_11n_table_40M_SHORT
								     [rateid].rate);
								break;
							}
						}
					}
				}
#endif
			}
#endif

			nBytesSent += boaWrite(wp,
					       "<tr align=\"center\" nowrap><font size=2>"
					       "<td>%02x:%02x:%02x:%02x:%02x:%02x</td>"
#ifdef WIFI5_WIFI6_COMP
					       "<td>%lu</td>"
					       "<td>%lu</td>"
#elif defined(WLAN_11AX)
					       "<td>%llu</td>"
					       "<td>%llu</td>"
#else
					       "<td>%lu</td>"
					       "<td>%lu</td>"
#endif
					       "<td>%s</td>"
					       "<td>%s</td>"
#ifdef WIFI5_WIFI6_COMP
					       "<td>%lu</td>"
#elif defined(WLAN_11AX)
					       "<td>%u</td>"
#else
					       "<td>%lu</td>"
#endif
					       "</font></tr>",
					       pInfo->addr[0], pInfo->addr[1],
					       pInfo->addr[2], pInfo->addr[3],
					       pInfo->addr[4], pInfo->addr[5],
					       pInfo->tx_packets, pInfo->rx_packets,
					       txrate, ((pInfo->flags &
						 STA_INFO_FLAG_ASLEEP) ?
						"yes" : "no"), pInfo->expired_time / 100);
			found++;
		}
	}
	}
	}

	if (found == 0) {
		nBytesSent += boaWrite(wp,
				       "<tr align=\"center\" nowrap><font size=2>"
				       "<td>None</td>"
				       "<td>---</td>"
				       "<td>---</td>"
				       "<td>---</td>"
				       "<td>---</td>"
				       "<td>---</td>"
				       "</font></tr>");
	}
end:
#ifdef WIFI5_WIFI6_COMP
	if(buff_extra)
		free(buff_extra);
#endif
	if(buff)
		free(buff);

	return nBytesSent;
}

/////////////////////////////////////////////////////////////////////////////
void formWirelessTbl(request * wp, char *path, char *query)
{
	char *submitUrl;
	char *strWlanId;

	strWlanId= boaGetVar(wp, "wlan_idx", "");
	if(strWlanId[0]){
		wlan_idx = atoi(strWlanId);
		//printf("%s: wlan_idx=%d\n", __func__, wlan_idx);
	}
	submitUrl = boaGetVar(wp, "submit-url", "");
	if (submitUrl[0])
		boaRedirect(wp, submitUrl);
}

#ifdef CONFIG_RTK_DEV_AP
#ifdef WLAN_SITE_SURVEY_SUPPORT
#ifdef WLAN_SITE_SURVEY_SIMUL
#if (NUM_WLAN_INTERFACE==3)
static SS_STATUS_Tp pStatus[NUM_WLAN_INTERFACE]={NULL, NULL, NULL}; // [wlan0, wlan1, wlan2]
#elif (NUM_WLAN_INTERFACE==2)
static SS_STATUS_Tp pStatus[NUM_WLAN_INTERFACE]={NULL, NULL}; // [wlan0, wlan1]
#else
static SS_STATUS_Tp pStatus[NUM_WLAN_INTERFACE]={NULL}; // [wlan0]
#endif //of (NUM_WLAN_INTERFACE==3)
static int getWlanIdx(SS_STATUS_Total_Tp pResult, int selID)
{
	int ret = -1;

	if(!pResult)
		return ret;
	if( selID>=pResult->number ){
		printf("Please re-select ssid to connect\n");
		return ret;
	}
	
#ifdef BAND_5G_ON_WLAN0 
	if(pResult->bssdb[selID].channel > 20)  //5g
		ret = 0;
	else
		ret = 1;
#else
	if(pResult->bssdb[selID].channel > 20)	//2g
		ret = 1;
	else
		ret = 0;
#endif

	return ret;
}

int wlGetSiteSurveyTotal(SS_STATUS_Total_Tp pResult)
{
	int i, j, k=0, ori_wlan_idx=wlan_idx;
	MIB_CE_MBSSIB_T Entry;
	int wlan_disable[NUM_WLAN_INTERFACE] = {0};	

	if(!pResult)
	{
		printf("pResult NULL\n");
		return -1;
	}

	for(i=0; i<NUM_WLAN_INTERFACE; ++i)
	{
		wlan_idx = i;
		memset(&Entry, 0, sizeof(MIB_CE_MBSSIB_T));
		wlan_getEntry((void *)&Entry, 0);	
		wlan_disable[i] = Entry.wlanDisabled;
	}

	//draw 2g first
#ifdef BAND_5G_ON_WLAN0 
	//wlan0(5g) wlan1(2g) or
	//wlan0(5g) wlan1(5g) wlan2(2g)
	for(j=NUM_WLAN_INTERFACE-1; j>=0; --j)
#else
	//wlan0(2g) wlan1(5g)
	for(j=0; j<NUM_WLAN_INTERFACE; ++j)
#endif
	{
		if(!wlan_disable[j] && pStatus[j] && (pStatus[j]->number != 0xff))
		{
			pResult->number += pStatus[j]->number;			
			for(i=0; i<pStatus[j]->number; ++k,++i)
			{
				memcpy(&pResult->bssdb[k], &pStatus[j]->bssdb[i], sizeof(BssDscr));				
			}	
		}
	}

	wlan_idx = ori_wlan_idx;
	return 0;	
}

#if defined(SYNC_VXD_TO_ROOT)
// not concern with wapi and 1x
int sync_vxd_to_root()
{
	MIB_CE_MBSSIB_T Entry, Entry2;
	int encrypt=0;	

	memset(&Entry, 0, sizeof(MIB_CE_MBSSIB_T));
	memset(&Entry2, 0, sizeof(MIB_CE_MBSSIB_T));
	mib_chain_get(MIB_MBSSIB_TBL, WLAN_REPEATER_ITF_INDEX, (void *)&Entry);
	mib_chain_get(MIB_MBSSIB_TBL, 0, (void *)&Entry2);

	/*ssid*/
	memcpy(Entry2.ssid, Entry.ssid, sizeof(Entry2.ssid));
	mib_set(MIB_WLAN_SSID, (void *)Entry.ssid);

	/*encrypt*/ /*no care about wpa3 yet*/
	Entry2.encrypt = Entry.encrypt;
	encrypt = Entry.encrypt;
	if(encrypt==WIFI_SEC_NONE)
	{
		Entry2.enable1X = Entry.enable1X;
	}else if(encrypt==WIFI_SEC_WEP)
	{
		Entry2.wep = Entry.wep; 	//64/128 bit
		if(Entry2.wep != WEP_DISABLED)
		{
			Entry2.authType = Entry.authType;
			Entry2.wepKeyType = Entry.wepKeyType;
			if(Entry2.wep==WEP64)
			{
				strcpy(Entry2.wep64Key1, Entry.wep64Key1);
				strcpy(Entry2.wep64Key2, Entry.wep64Key2);
				strcpy(Entry2.wep64Key3, Entry.wep64Key3);
				strcpy(Entry2.wep64Key4, Entry.wep64Key4);
			}else if(Entry2.wep==WEP128)
			{
				strcpy(Entry2.wep128Key1, Entry.wep128Key1);
				strcpy(Entry2.wep128Key2, Entry.wep128Key2);
				strcpy(Entry2.wep128Key3, Entry.wep128Key3);
				strcpy(Entry2.wep128Key4, Entry.wep128Key4);
			}
		}		
	}else if( encrypt==WIFI_SEC_WPA || encrypt==WIFI_SEC_WPA2 || encrypt==WIFI_SEC_WPA2_MIXED )
	{
#ifdef WLAN_11W
		Entry2.dotIEEE80211W = Entry.dotIEEE80211W;
		Entry2.sha256 = Entry.sha256;
#endif
		Entry2.wpaAuth = Entry.wpaAuth;
		Entry2.unicastCipher = Entry.unicastCipher;
		Entry2.wpa2UnicastCipher = Entry.wpa2UnicastCipher;
		if(Entry2.wpaAuth==WPA_AUTH_PSK)
		{
			Entry2.wpaPSKFormat = Entry.wpaPSKFormat;
			strcpy(Entry2.wpaPSK, Entry.wpaPSK);
		}
		/* no change group key rekey ...*/
	}	
#ifdef WLAN_WPA3
	else if(((encrypt == WIFI_SEC_WPA3) || (encrypt == WIFI_SEC_WPA2_WPA3_MIXED))){
#ifdef WLAN_11W
		Entry2.dotIEEE80211W = Entry.dotIEEE80211W;
		Entry2.sha256 = Entry.sha256;
#endif
		Entry2.wpaAuth = Entry.wpaAuth;
		Entry2.wpa2UnicastCipher = Entry.wpa2UnicastCipher;
		if(Entry2.wpaAuth==WPA_AUTH_PSK)
		{
			Entry2.wpaPSKFormat = Entry.wpaPSKFormat;
			strcpy(Entry2.wpaPSK, Entry.wpaPSK);
		}
	}
#endif

	mib_chain_update(MIB_MBSSIB_TBL,(void *)&Entry2,0);

	return 0;
}
#endif
void formWlSiteSurvey(request * wp, char *path, char *query)
{
 	char *submitUrl, *refresh, *connect, *strSel, *strEncrypt;
	int status, idx, tmpValue;
	unsigned char res, *pMsg=NULL;
	int wait_time;
	char tmpBuf[100]={0};
	char *strVal;
	int max_wait_time=0, i=0, ori_wlan_idx=wlan_idx, j;
	SS_STATUS_Total_Tp pStatusTotal = NULL;
	int wlan_disable[NUM_WLAN_INTERFACE] = {0};
	MIB_CE_MBSSIB_T Entry;
	int flags;

#ifdef SYNC_VXD_TO_ROOT
	char *sync_vxd;
	int is_sync_vxd = 0;
#endif

	submitUrl = boaGetVar(wp, "submit-url", "");
	refresh = boaGetVar(wp, "refresh", "");
	if ( refresh[0] ) 
	{		
		for(i=0; i<NUM_WLAN_INTERFACE; ++i)
		{
			wlan_idx = i;
			memset(&Entry, 0, sizeof(MIB_CE_MBSSIB_T));
			wlan_getEntry((void *)&Entry, 0);	
			wlan_disable[i] = Entry.wlanDisabled;

			if(wlan_disable[i]){
				continue;
			}

			if (!getInFlags(getWlanIfName(), &flags))
				continue;
			if(!(flags & IFF_UP))
				continue;

			// issue scan request
			wait_time = 0;
			while (1) {			
				switch(getWlSiteSurveyRequest(getWlanIfName(), &status)) 
				{					
					case -2: 
						//printf("Auto scan running!!\n"); 
						//goto ss_err; 
						break; 
					case -1: 
						//printf("Site-survey request failed!\n"); 
						//goto ss_err; 
						break; 
					default: 
						break; 
				} 		
			
				if (status != 0) {	// not ready				
					if (wait_time++ > 30) 			
					{
						if(i != (NUM_WLAN_INTERFACE-1))
							continue;
						else
						{
							strcpy(tmpBuf, "scan request timeout!");
							goto ss_err;
						}
					}					
					sleep(1);
				}
				else{				
					break;
				}
			}

			// wait until scan completely
			wait_time = 0;
			while (1) {
				res = 1;	// only request request status
				if ( getWlSiteSurveyResult(getWlanIfName(), (SS_STATUS_Tp)&res) < 0 ) {
					if(i != (NUM_WLAN_INTERFACE-1))
							continue;
					else
					{
						strcpy(tmpBuf, "Read site-survey status failed!");
						goto ss_err;
					}
				}
				if (res == 0xff) {   // in progress
#if defined(CONFIG_RTL_DFS_SUPPORT)
					if (wait_time++ > 20)
#else
					if (wait_time++ > 10)
#endif
					{
						if(i != (NUM_WLAN_INTERFACE-1))
							continue;
						else
						{
							strcpy(tmpBuf, "scan timeout!");
							goto ss_err;
						}
					}				
					sleep(1);
				}
				else{				
					break;
				}
			}
		}
		
		if (submitUrl[0])
			boaRedirect(wp, submitUrl);

		wlan_idx = ori_wlan_idx;
		return;
	}

	connect = boaGetVar(wp, "connect", "");
	if ( connect[0] ) {			
		/* malloc for sort array */
		if (pStatusTotal==NULL) {			
			pStatusTotal = malloc(sizeof(SS_STATUS_Total_T));		
			if ( pStatusTotal==NULL ) {
				strcpy(tmpBuf, "Alloc memory fail!");
				goto ss_err;
			}
			memset(pStatusTotal, 0, sizeof(SS_STATUS_Total_T));
		}

		if(wlGetSiteSurveyTotal(pStatusTotal))
		{
			strcpy(tmpBuf, "wlGetSiteSurveyTotal fail!");
			goto ss_err;
		}
		
#ifdef SYNC_VXD_TO_ROOT
		sync_vxd = boaGetVar(wp, ("sync_vxd"), "");
		if(sync_vxd[0]){
			is_sync_vxd = 1;
		}		
#endif

		strSel = boaGetVar(wp, "select", "");
		if (strSel[0]) {	
			unsigned char res;
			NETWORK_TYPE_T net;
			int keyLen, len;
			unsigned char chan, encrypt, vChar;
			char *strAuth, *strKeyLen, *strFormat, *wepKey;
			char key[30];

			MIB_CE_MBSSIB_T pEntry;
			int vxd_wisp_wan = 0, interface_idx = 0;
			char opmode, wlanmode, rptEnabled;
			sscanf(strSel, "sel%d", &idx);
			if (idx >= pStatusTotal->number || idx >= MAX_BSS_DESC * NUM_WLAN_INTERFACE || idx < 0) { // invalid index
				strcpy(tmpBuf, "Connect failed 1!");
				goto ss_err;
			}

			tmpValue = getWlanIdx(pStatusTotal, idx);
			if(tmpValue<0){
				strcpy(tmpBuf, "Connect failed 1!");
				goto ss_err;
			}

			wlan_idx = tmpValue;
			wlan_getEntry(&pEntry, 0);
			wlanmode = pEntry.wlanMode;
#ifdef WLAN_UNIVERSAL_REPEATER
			mib_get_s(MIB_REPEATER_ENABLED1, (void *)&rptEnabled, sizeof(rptEnabled));
#else
			rptEnabled = 0;
#endif		

			if( (wlanmode == AP_MODE || wlanmode == AP_WDS_MODE 
#ifdef WLAN_MESH
				|| wlanmode == AP_MESH_MODE || wlanmode == MESH_MODE
#endif
				) && (rptEnabled == 1))
				vxd_wisp_wan = 1;
			
			if(vxd_wisp_wan)
				interface_idx = WLAN_REPEATER_ITF_INDEX;

			wlan_getEntry(&pEntry, interface_idx);
			
			// Set SSID, network type to MIB
			if(pStatusTotal->bssdb[idx].ssidlen > sizeof(tmpBuf)) {
				snprintf(tmpBuf, sizeof(tmpBuf), "%s", "The ssid len is over range\n");
				goto ss_err;
			}
			memset(tmpBuf, 0, sizeof(tmpBuf));
			strlcpy(tmpBuf, pStatusTotal->bssdb[idx].ssid, sizeof(tmpBuf));
			//if ( mib_set(MIB_WLAN_SSID, (void *)tmpBuf) == 0) {
			//	strcpy(tmpBuf, "Set SSID error!");
			//	goto ss_err;
			//}
			strlcpy(pEntry.ssid, tmpBuf, sizeof(pEntry.ssid));
			if ( pStatusTotal->bssdb[idx].capability & cESS )
				net = INFRASTRUCTURE;
			else
				net = ADHOC;
			
			if(interface_idx == 0){
				if ( mib_set(MIB_WLAN_NETWORK_TYPE, (void *)&net) == 0) {
					//sprintf(tmpBuf, "%s:%s", Tset_mib_error, MIB_WLAN_NETWORK_TYPE);
					strcpy(tmpBuf, "Set MIB_WLAN_NETWORK_TYPE failed!");
					goto ss_err;
				}
			}
			
			if (net == ADHOC) {
				chan = pStatusTotal->bssdb[idx].channel;
				if ( mib_set( MIB_WLAN_CHAN_NUM, (void *)&chan) == 0) {
					//sprintf(tmpBuf, "%s:%s", Tset_mib_error, MIB_WLAN_CHAN_NUM);
					strcpy(tmpBuf, "Set channel number error!");
					goto ss_err;
				}
			}
			else if(vxd_wisp_wan){ //set to root (repeater enabled)
#ifdef WLAN_MESH /*in mesh mode, keep the original channel*/
                if(wlanmode != AP_MESH_MODE && wlanmode != MESH_MODE) 
#endif
				{
					chan = pStatusTotal->bssdb[idx].channel;					
					if ( mib_set( MIB_WLAN_CHAN_NUM, (void *)&chan) == 0) {
						//sprintf(tmpBuf, "%s:%s", Tset_mib_error, MIB_WLAN_CHAN_NUM);
						strcpy(tmpBuf, "Set channel number error!");
						goto ss_err;
					}
					int sideband;
					mib_get_s( MIB_WLAN_CONTROL_BAND, (void *)&sideband, sizeof(sideband));
					if ((chan<=4 && sideband==0) || (chan>=10 && sideband==1)){
					   sideband = ((sideband + 1) & 0x1);										
					   mib_set( MIB_WLAN_CONTROL_BAND, (void *)&sideband);
					}
				}
			}


			//strEncrypt = boaGetVar(wp, "security_method", "");
			strEncrypt = boaGetVar(wp, "wlan_encrypt", "");
			if (!strEncrypt[0]) {
		 		strcpy(tmpBuf, "Error! no encryption method.");
				goto ss_err;
			}

			encrypt = (WIFI_SECURITY_T) strEncrypt[0] - '0';
#ifdef WLAN_WPA3		
			encrypt = atoi(strEncrypt);
#endif
			vChar = (char)encrypt;
			pEntry.encrypt = vChar;			
			if (encrypt == WIFI_SEC_WEP) {
				AUTH_TYPE_T authType;
				WEP_T wep;
				// (1) Authentication Type
				strAuth = boaGetVar(wp, "auth_type", "");
				if (strAuth[0]) {
					if ( !gstrcmp(strAuth, "open"))
						authType = AUTH_OPEN;
					else if ( !gstrcmp(strAuth, "shared"))
						authType = AUTH_SHARED;
					else if ( !gstrcmp(strAuth, "both"))
						authType = AUTH_BOTH;
					else {
						strcpy(tmpBuf, "Error! Invalid authentication value.");
						goto ss_err;
					}
					vChar = (char)authType;
					pEntry.authType = vChar;
				}
				// (2) Key Length
				strKeyLen = boaGetVar(wp, "length0", "");
				if (!strKeyLen[0]) {
					strcpy(tmpBuf, "Key length must exist!");
					goto ss_err;
				}
				if (strKeyLen[0]!='1' && strKeyLen[0]!='2') {
					strcpy(tmpBuf, "Invalid key length value!");
					goto ss_err;
				}
				if (strKeyLen[0] == '1')
					wep = WEP64;
				else
					wep = WEP128;

				vChar = (char)wep;

				//if ( mib_set( MIB_WLAN_WEP, (void *)&vChar) == 0) {
				//	strcpy(tmpBuf, strSetWLANWEPErr);
				//	goto ss_err;
				//}
				pEntry.wep = vChar;

				// (3) Key Format
				strFormat = boaGetVar(wp, "format0", "");
				if (!strFormat[0]) {
					strcpy(tmpBuf, "Key type must exist!");
					goto ss_err;
				}

				if (strFormat[0]!='1' && strFormat[0]!='2') {
					strcpy(tmpBuf, "Invalid key type value!");
					goto ss_err;
				}

				vChar = (char)(strFormat[0] - '0' - 1);

				//if ( mib_set( MIB_WLAN_WEP_KEY_TYPE, (void *)&vChar) == 0) {
				//	strcpy(tmpBuf, strSetWepKeyTypeErr);
				//	goto ss_err;
				//}
				pEntry.wepKeyType = vChar;

				if (wep == WEP64) {
					if (strFormat[0]=='1')
						keyLen = WEP64_KEY_LEN;
					else
						keyLen = WEP64_KEY_LEN*2;
				}
				else {
					if (strFormat[0]=='1')
						keyLen = WEP128_KEY_LEN;
					else
						keyLen = WEP128_KEY_LEN*2;
				}

				// (4) Encryption Key
				wepKey = boaGetVar(wp, "key0", "");
				if	(wepKey[0]) {
					if (strlen(wepKey) != keyLen) {
						strcpy(tmpBuf, "Invalid key 1 length!");
						goto ss_err;
					}
					if ( !isAllStar(wepKey) ) {
						if (strFormat[0] == '1') // ascii
							strcpy(key, wepKey);
						else { // hex
							if ( !rtk_string_to_hex(wepKey, key, keyLen)) {
								strcpy(tmpBuf, "Invalid wep-key1 value!");
								goto ss_err;
							}
						}
						if (wep == WEP64) {
							//if (mib_set(MIB_WLAN_WEP64_KEY1, (void *)key) == 0 ) {
							//	strcpy(tmpBuf, strSetWEPKey1Err);
							//	goto ss_err;
							//}
							strcpy(pEntry.wep64Key1, key);
						}
						else {
							//if (mib_set(MIB_WLAN_WEP128_KEY1, (void *)key) == 0 ) {
							//	strcpy(tmpBuf, strSetWEPKey1Err);
							//	goto ss_err;
							//}
							strcpy(pEntry.wep128Key1, key);
						}

					}
				}// (4) Encryption Key	
			}
#ifdef CONFIG_RTL_CFG80211_WAPI_SUPPORT
			else if(encrypt == WIFI_SEC_WAPI) {
				unsigned char wapi_cipher=0, wapi_auth=0, wapiPskFmt=0;

				/* wapi auth */
				strVal = boaGetVar(wp, "wapi_auth_type", "");
				if (strVal){
					if (strVal[0]=='1')
						wapi_auth = WAPI_AUTH_CERT;
					else if (strVal[0]=='2')
						wapi_auth = WAPI_AUTH_PSK;
				}
				if(wapi_auth==0){
					strncpy(tmpBuf, "Error! invalid wapi auth.", sizeof(tmpBuf));
					goto ss_err;
				}
				pEntry.wapiAuthType = wapi_auth;

				/* wapi cipher */
				strVal = boaGetVar(wp, "wapi_sm4_gcm", "");
				if(strVal){
					if(strVal[0]=='4')
						wapi_cipher |= WAPI_CIPHER_SMS4;
					if(strVal[0]=='5')
						wapi_cipher |= WAPI_CIPHER_GCM;
				}
				if(wapi_cipher==0){
					strncpy(tmpBuf, "Error! invalid wapi cipher.", sizeof(tmpBuf));
					goto ss_err;
				}
				pEntry.wapiCryptoAlg = wapi_cipher;

				if(wapi_auth==WAPI_AUTH_PSK){
					/* wapi psk format */
					strVal = boaGetVar(wp, "wapiPskFormat", "");
					if (strVal && !strVal[0]) {
						strncpy(tmpBuf, "Error! no wapi psk format.", sizeof(tmpBuf));
						goto ss_err;
					}
					wapiPskFmt = strVal[0] - '0';
					if (wapiPskFmt != 0 && wapiPskFmt != 1) {
						strncpy(tmpBuf, "Error! invalid wapi psk format.", sizeof(tmpBuf));
						goto ss_err;
					}

					/* wapi psk pwd */
					strVal = boaGetVar(wp, "wapiPskValue", "");
					if(strVal){
						len = strlen(strVal);
						pEntry.wapiPskFormat = wapiPskFmt;
						if (wapiPskFmt==1)
						{ // hex
							if (len!=MAX_PSK_LEN || !rtk_string_to_hex(strVal, tmpBuf, MAX_PSK_LEN))
							{
								strncpy(tmpBuf, "Error! invalid psk value.", sizeof(tmpBuf));
								goto ss_err;
							}
						}
						else
						{ // passphras
							if (len < 8 || len > MAX_PSK_LEN ||
								((len==MAX_PSK_LEN) && (!rtk_string_to_hex(strVal, tmpBuf, MAX_PSK_LEN))))
							{
								strncpy(tmpBuf, "Error! invalid psk value.", sizeof(tmpBuf));
								goto ss_err;
							}
						}
						strncpy(pEntry.wapiPsk, strVal, MAX_PSK_LEN);
					}
				}
			}
#endif
			else if(encrypt >= WIFI_SEC_WPA) {	// WPA
				pEntry.unicastCipher = 0;
				pEntry.wpa2UnicastCipher = 0;
#ifdef WLAN_11W
					pEntry.sha256 = 0;
					pEntry.dotIEEE80211W = 0;
#endif
				if ((encrypt == WIFI_SEC_WPA) || (encrypt == WIFI_SEC_WPA2_MIXED)) {					
					unsigned char intVal = 0;
					unsigned char val2;
					//strVal = boaGetVar(wp, "ciphersuite_t", "");
					strVal = boaGetVar(wp, "wpa_tkip_aes", "");
					if (strVal[0]=='1')
						intVal |= WPA_CIPHER_TKIP;
					//strVal = boaGetVar(wp, "ciphersuite_a", "");
					if (strVal[0]=='2')
						intVal |= WPA_CIPHER_AES;
					if(strVal[0]=='3')
						intVal |= WPA_CIPHER_MIXED;

					if ( intVal == 0 )
						intVal = WPA_CIPHER_TKIP;
					
					pEntry.unicastCipher = intVal;
				}
		
				// Mason Yu. 201009_new_security. Set wpa2ciphersuite(wpa2_cipher) for wpa2/wpa mixed
				if ((encrypt == WIFI_SEC_WPA2) || (encrypt == WIFI_SEC_WPA2_MIXED)) {
					unsigned char intVal = 0;
					//strVal = boaGetVar(wp, "wpa2ciphersuite_t", "");
					strVal = boaGetVar(wp, "wpa2_tkip_aes", "");
					if (strVal[0]=='1')
						intVal |= WPA_CIPHER_TKIP;
					//strVal = boaGetVar(wp, "wpa2ciphersuite_a", "");
					if (strVal[0]=='2')
						intVal |= WPA_CIPHER_AES;
					if (strVal[0]=='3')
						intVal |= WPA_CIPHER_MIXED;

					if ( intVal == 0 )
						intVal = WPA_CIPHER_AES;

					pEntry.wpa2UnicastCipher = intVal;
				}
#ifdef WLAN_WPA3
				else if(((encrypt == WIFI_SEC_WPA3) || (encrypt == WIFI_SEC_WPA2_WPA3_MIXED))) {
					pEntry.wpa2UnicastCipher = WPA_CIPHER_AES;
#ifdef WLAN_11W
					if(encrypt == WIFI_SEC_WPA3)
					{
						pEntry.sha256 = 1;
						pEntry.dotIEEE80211W = 2;
					}
					else if(encrypt == WIFI_SEC_WPA2_WPA3_MIXED)
					{
						pEntry.sha256 = 0;
						pEntry.dotIEEE80211W = 1;
					}
#endif
				}
#endif
				// pre-shared key
					strVal = boaGetVar(wp, "pskFormat", "");
					if (!strVal[0]) {
						strcpy(tmpBuf, "Error! no psk format.");
						goto ss_err;
					}
					vChar = strVal[0] - '0';
					if (vChar != 0 && vChar != 1) {
						strcpy(tmpBuf, "Error! invalid psk format.");
						goto ss_err;
					}
		
					strVal = boaGetVar(wp, "pskValue", "");
					len = strlen(strVal);
		
					//if ( mib_set(MIB_WLAN_WPA_PSK_FORMAT, (void *)&vChar) == 0) {
					//	strcpy(tmpBuf, strSetWPAPSKFMATErr);
					//	goto ss_err;
					//}
					pEntry.wpaPSKFormat = vChar;					
		
					if (vChar==1) { // hex
						if (len!=MAX_PSK_LEN || !rtk_string_to_hex(strVal, tmpBuf, MAX_PSK_LEN)) {
							strcpy(tmpBuf, "Error! invalid psk value.");
							goto ss_err;
						}
					}
					else { // passphras
						if (len < 8 || len > MAX_PSK_LEN || 
							((len==MAX_PSK_LEN) && (!rtk_string_to_hex(strVal, tmpBuf, MAX_PSK_LEN)))) {
							strcpy(tmpBuf, "Error! invalid psk value.");
							goto ss_err;
						}
					}

					//if ( !mib_set(MIB_WLAN_WPA_PSK, (void *)strVal)) {
					//	strcpy(tmpBuf, strSetWPAPSKErr);
					//	goto ss_err;
					//}
					strcpy(pEntry.wpaPSK, strVal);
			}

			wlan_setEntry(&pEntry, interface_idx);

#ifdef SYNC_VXD_TO_ROOT
			if(is_sync_vxd){				
				sync_vxd_to_root();
				printf("sync vxd to root \n");
			}else
				printf("not sync vxd to root \n");
#endif

			mib_update(CURRENT_SETTING, CONFIG_MIB_ALL);	// update to flash
			config_WLAN(ACT_RESTART, CONFIG_SSID_ALL);	

			res = idx;
			wait_time = 0;
			char interface_name[20];

			if(vxd_wisp_wan)
				snprintf(interface_name, sizeof(interface_name), "%s-vxd", getWlanIfName());
			else
				snprintf(interface_name, sizeof(interface_name), "%s", getWlanIfName());

// CONFIG_SUPPORT_CLIENT_MIXED_SECURITY definition is removed in wifi driver V3.3 and after, do not use old method to get connection result
#if 0 //#ifndef CONFIG_SUPPORT_CLIENT_MIXED_SECURITY
// old method
			while (1) {
				if ( getWlJoinRequest(interface_name, &pStatus->bssdb[idx], &res) < 0 ) {
					strcpy(tmpBuf, multilang(LANG_JOIN_REQUEST_FAILED));
					goto ss_err;
				}
				if ( res == 1 ) { // wait
					if (wait_time++ > 5) {
						strcpy(tmpBuf, multilang(LANG_CONNECT_REQUEST_TIMEOUT));
						goto ss_err;
					}
					sleep(1);
					continue;
				}
				break;
			}

			if ( res == 2 ) // invalid index
				pMsg = "Connect failed 2!";
			else {
				wait_time = 0;
				while (1) {
					if ( getWlJoinResult(interface_name, &res) < 0 ) {
						strcpy(tmpBuf, multilang(LANG_GET_JOIN_RESULT_FAILED));
						goto ss_err;
					}
					if ( res != 0xff ) { // completed
						break;
					}
					if (wait_time++ > 10) {
						strcpy(tmpBuf, multilang(LANG_CONNECT_REQUEST_TIMEOUT));
						goto ss_err;
					}
					sleep(1);
				}

				if ( res!=STATE_Bss && res!=STATE_Ibss_Idle && res!=STATE_Ibss_Active )
					pMsg = "Connect failed 3!";
				else {
					status = 0;
					if (encrypt == WIFI_SEC_WPA
						|| encrypt == WIFI_SEC_WPA2) {
						bss_info bss;
						wait_time = 0;
						while (wait_time++ < 5) {
							getWlBssInfo(interface_name, &bss);
							if (bss.state == STATE_CONNECTED)
								break;
							sleep(1);
						}
						if (wait_time >= 5)
							status = 1;
					}
					if (status)
						pMsg = "Connect failed 4!";
					else
						pMsg = "Connect successfully!";
				}
			}
#else
// for wifi driver V3.3 and after
			status = 0;
			bss_info bss;
			if(pStatusTotal->bssdb[idx].channel > 14)
				max_wait_time = 95;
			else
				max_wait_time = 30;
			while (wait_time++ < max_wait_time) {
				getWlBssInfo(interface_name, &bss);
				if (bss.state == STATE_CONNECTED)
					break;
				sleep(1);
			}
			if (wait_time >= max_wait_time)
				status = 1;
			
			if (status)
				pMsg = "Connect failed 4!";
			else
				pMsg = "Connect successfully!";
#endif	
			OK_MSG1(pMsg, submitUrl);

		}
	}

	wlan_idx = ori_wlan_idx;
	if(pStatusTotal){
		free(pStatusTotal);
		pStatusTotal = NULL;
	}
	
	return;
ss_err:
	wlan_idx = ori_wlan_idx;
	for(j=0; j<NUM_WLAN_INTERFACE; ++j)
	{
		if (pStatus[j]) {		
			free(pStatus[j]); 
			pStatus[j] = NULL;
		}
	}

	if(pStatusTotal){
		free(pStatusTotal);
		pStatusTotal = NULL;
	}
	
	ERR_MSG(tmpBuf);
}

int wlSiteSurveyTbl(int eid, request * wp, int argc, char **argv)
{
	int nBytesSent=0, i;
	BssDscr *pBss;
	char tmpBuf[100], ssidbuf[40],tmp1Buf[10], tmp2Buf[20], chwidBuf[10], wpa_tkip_aes[20],wpa2_tkip_aes[20];
	WLAN_MODE_T mode;
	bss_info bss;
	MIB_CE_MBSSIB_T Entry;
	int j, ori_wlan_idx = wlan_idx, cnt=0;
	unsigned char ifname[10] = {0};	 
	SS_STATUS_Tp ptmpSS = NULL;
	int wlan_disable[NUM_WLAN_INTERFACE] = {0};
	SS_STATUS_Total_Tp pStatusTotal = NULL;
#if defined(CONFIG_RTL_CFG80211_WAPI_SUPPORT)
	char wapi_sm4_gcm[20]={0};
#endif

	for(j=0; j<NUM_WLAN_INTERFACE; ++j)
	{
		if (pStatus[j]==NULL) {		
			ptmpSS = calloc(1, sizeof(SS_STATUS_T));
			pStatus[j] = ptmpSS;		
			if ( pStatus[j]==NULL ) {
				printf("Allocate buffer failed!\n");
				goto draw_err;
			}
			memset(pStatus[j],0,sizeof(SS_STATUS_T));
		}
	}

	for(j=0; j<NUM_WLAN_INTERFACE; ++j)
	{
 		wlan_idx = j;
		wlan_getEntry((void *)&Entry, 0);	
		wlan_disable[j] = Entry.wlanDisabled;
		if(!Entry.wlanDisabled){
			snprintf(ifname, sizeof(ifname), WLAN_IF, j);		
			pStatus[j]->number = 0; // request BSS DB
			if ( getWlSiteSurveyResult(ifname, pStatus[j]) < 0 ) {	
				printf("Read site-survey status failed!\n");
				goto draw_err;
			}

			if ( getWlBssInfo(ifname, &bss) < 0) {
				printf("Get bssinfo failed!\n");
				goto draw_err;
			}	
		}
	}
	
	nBytesSent += boaWrite(wp, "<tr>"
		"<td align=center width=\"30%%\" bgcolor=\"#808080\"><font size=\"2\"><b>SSID</b></font></td>\n"
		"<td align=center width=\"20%%\" bgcolor=\"#808080\"><font size=\"2\"><b>BSSID</b></font></td>\n"
		"<td align=center width=\"10%%\" bgcolor=\"#808080\"><font size=\"2\"><b>%s</b></font></td>\n"
	  	"<td align=center width=\"10%%\" bgcolor=\"#808080\"><font size=\"2\"><b>%s</b></font></td>\n"
	  	"<td align=center width=\"10%%\" bgcolor=\"#808080\"><font size=\"2\"><b>%s</b></font></td>\n"
		"<td align=center width=\"10%%\" bgcolor=\"#808080\"><font size=\"2\"><b>%s(%%)</b></font></td>\n"
		"<td align=center width=\"10%%\" bgcolor=\"#808080\"><font size=\"2\"><b>Select</b></font></td></tr>\n",
		multilang_bpas("Channel"), multilang_bpas("Type"), multilang_bpas("Encryption"), multilang_bpas("Signal"));

	/* malloc for sort array */
	if (pStatusTotal==NULL) {			
		pStatusTotal = malloc(sizeof(SS_STATUS_Total_T));		
		if ( pStatusTotal==NULL ) {
			strcpy(tmpBuf, "Alloc memory fail!");
			goto draw_err;
		}
		memset(pStatusTotal, 0, sizeof(SS_STATUS_Total_T));
	}

	if(wlGetSiteSurveyTotal(pStatusTotal))
	{
		strcpy(tmpBuf, "wlGetSiteSurveyTotal fail!");
		goto draw_err;
	}

	for(i=0; i<pStatusTotal->number; ++i){
		pBss = &pStatusTotal->bssdb[i];
		snprintf(tmpBuf, sizeof(tmpBuf), "%02x:%02x:%02x:%02x:%02x:%02x",
		pBss->bssid[0], pBss->bssid[1], pBss->bssid[2],
		pBss->bssid[3], pBss->bssid[4], pBss->bssid[5]);

		//memcpy(ssidbuf, pBss->bdSsIdBuf, pBss->bdSsId.Length);
		//ssidbuf[pBss->bdSsId.Length] = '\0';
		if(pBss->ssidlen>SSID_LEN)
			printf("the length of SSID %s is greater than %d\n",pBss->ssid,SSID_LEN);

		memcpy(ssidbuf, pBss->ssid, pBss->ssidlen>=SSID_LEN?SSID_LEN:pBss->ssidlen);
		ssidbuf[pBss->ssidlen>=SSID_LEN?SSID_LEN:pBss->ssidlen] = '\0';

		if (pBss->network==BAND_11B)
			strcpy(tmp1Buf, (" (B)"));
		else if (pBss->network==BAND_11G)
			strcpy(tmp1Buf, (" (G)"));	   
		else if (pBss->network==(BAND_11G|BAND_11B))
			strcpy(tmp1Buf, (" (B+G)"));
		else if (pBss->network==(BAND_11N))
			strcpy(tmp1Buf, (" (N)"));				
		else if (pBss->network==(BAND_11G|BAND_11N))
			strcpy(tmp1Buf, (" (G+N)"));
		else if (pBss->network==(BAND_11G|BAND_11B | BAND_11N))
			strcpy(tmp1Buf, (" (B+G+N)"));
		else if(pBss->network== BAND_11A)
			strcpy(tmp1Buf, (" (A)"));
		else if(pBss->network== (BAND_11A | BAND_11N))
			strcpy(tmp1Buf, (" (A+N)"));
		else if(pBss->network== (BAND_5G_11AC | BAND_11N))
			strcpy(tmp1Buf, (" (AC+N)"));
		else if(pBss->network== (BAND_11A | BAND_5G_11AC))
			strcpy(tmp1Buf, (" (A+AC)"));				 
		else if(pBss->network== (BAND_11A |BAND_11N | BAND_5G_11AC))
			strcpy(tmp1Buf, (" (A+N+AC)")); 		  
		else
			sprintf(tmp1Buf, (" -%d-"),pBss->network);
				
		memset(wpa_tkip_aes,0x00,sizeof(wpa_tkip_aes));
		memset(wpa2_tkip_aes,0x00,sizeof(wpa2_tkip_aes));
		if ((pBss->capability & cPrivacy) == 0)
			sprintf(tmp2Buf, "no");
		else {
#if defined(CONFIG_RTL_CFG80211_WAPI_SUPPORT)
			if(pBss->bss_akm_suite & 0x00001000 || pBss->bss_akm_suite & 0x00002000)
			{
				int wapi_cipher=0, idx = 0;
				if(pBss->bss_akm_suite & 0x00001000)
					idx = snprintf(tmp2Buf, sizeof(tmp2Buf), "WAPI-PSK");
				else if(pBss->bss_akm_suite & 0x00002000)
					idx = snprintf(tmp2Buf, sizeof(tmp2Buf), "WAPI-CERT");
				wapi_cipher = (pBss->t_stamp[1] >> BSS_WAPI_SHIFT) & BSS_WAPI_MASK;
				if(wapi_cipher==1)
					idx = snprintf(wapi_sm4_gcm, sizeof(wapi_sm4_gcm), "SMS4");
				if(wapi_cipher==2)
					idx = snprintf(wapi_sm4_gcm, sizeof(tmp2Buf), "GCM-SM4");
			}else
#endif
			if (pBss->t_stamp[0] == 0)
				sprintf(tmp2Buf, "WEP");
#if defined(CONFIG_RTL_WAPI_SUPPORT)
			else if (pBss->t_stamp[0] == SECURITY_INFO_WAPI)
				sprintf(tmp2Buf, "WAPI");
#endif
			else 
			{
				int wpa_exist = 0, idx = 0, wpa3_exist = 0;
				if (pBss->t_stamp[0] & 0x0000ffff) 
				{
					idx = sprintf(tmp2Buf, "WPA");
					if (((pBss->t_stamp[0] & 0x0000f000) >> 12) == 0x4)
						idx += sprintf(tmp2Buf+idx, "-PSK");
					else if(((pBss->t_stamp[0] & 0x0000f000) >> 12) == 0x2)
						idx += sprintf(tmp2Buf+idx, "-1X");
					wpa_exist = 1;
				
					if (((pBss->t_stamp[0] & 0x00000f00) >> 8) == 0x5)
						sprintf(wpa_tkip_aes,"%s","aes/tkip");
					else if (((pBss->t_stamp[0] & 0x00000f00) >> 8) == 0x4)
						sprintf(wpa_tkip_aes,"%s","aes");
					else if (((pBss->t_stamp[0] & 0x00000f00) >> 8) == 0x1)
						sprintf(wpa_tkip_aes,"%s","tkip");
				}
				if(pBss->t_stamp[1] & 0x00000800)
				{
					idx += sprintf(tmp2Buf+idx, "WPA3");
					wpa3_exist = 1;
				}
				//if (pBss->t_stamp[0] & 0xffff0000) 
				if ((pBss->t_stamp[0] & 0xf0000000) || (!(pBss->t_stamp[1] & 0x00000800) && (pBss->t_stamp[0] & 0xffff0000)))
				{
					if (wpa_exist || wpa3_exist)
						idx += sprintf(tmp2Buf+idx, "/");
					idx += sprintf(tmp2Buf+idx, "WPA2");
					if (((pBss->t_stamp[0] & 0xf0000000) >> 28) == 0x4)
						idx += sprintf(tmp2Buf+idx, "-PSK");
					else if (((pBss->t_stamp[0] & 0xf0000000) >> 28) == 0x2)
						idx += sprintf(tmp2Buf+idx, "-1X");

					if (((pBss->t_stamp[0] & 0x0f000000) >> 24) == 0x5)
						sprintf(wpa2_tkip_aes,"%s","aes/tkip");
					else if (((pBss->t_stamp[0] & 0x0f000000) >> 24) == 0x4)
						sprintf(wpa2_tkip_aes,"%s","aes");
					else if (((pBss->t_stamp[0] & 0x0f000000) >> 24) == 0x1)
						sprintf(wpa2_tkip_aes,"%s","tkip");
				}
			}
		}
		memset(chwidBuf, '\0', sizeof(chwidBuf));
		if (pBss->t_stamp[1] & (BSS_BW_MASK << BSS_BW_SHIFT)){
			int tmp = (pBss->t_stamp[1] >> BSS_BW_SHIFT) & BSS_BW_MASK;
			switch (tmp) {
				case 0:
					sprintf(chwidBuf, "20MHz");
					break;
				case 1:
					sprintf(chwidBuf, "40MHz");
					break;
				case 2:
					sprintf(chwidBuf, "80MHz");
					break;
			}
		}
		else if (pBss->t_stamp[1] & (1<<1))
			sprintf(chwidBuf, "40MHz");
		else
			sprintf(chwidBuf, "20MHz");

		nBytesSent += boaWrite(wp, "<tr>"
			"<td align=left width=\"20%%\" bgcolor=\"#C0C0C0\"><font size=\"2\">%s</td>\n"
			"<td align=center width=\"20%%\" bgcolor=\"#C0C0C0\"><font size=\"2\">%s</td>\n"
  			"<td align=center width=\"10%%\" bgcolor=\"#C0C0C0\"><font size=\"2\">%d</td>\n"
  			"<td align=center width=\"10%%\" bgcolor=\"#C0C0C0\"><font size=\"2\">%s</td>\n"
			"<td align=center width=\"10%%\" bgcolor=\"#C0C0C0\"><font size=\"2\">%s</td>\n"
			"<td align=center width=\"10%%\" bgcolor=\"#C0C0C0\"><font size=\"2\">%d</td>\n",
			ssidbuf, tmpBuf, pBss->channel,
			((pBss->capability & cIBSS) ? "Ad hoc" : "AP"),	
			tmp2Buf, pBss->rssi);
				
#if defined(CONFIG_RTL_CFG80211_WAPI_SUPPORT)
		nBytesSent += boaWrite(wp,
			"<td align=center width=\"10%%\" bgcolor=\"#C0C0C0\"><input type=\"hidden\" id=\"selSSID_%d\" value=\"%s\" > <input type=\"hidden\" id=\"selChannel_%d\" value=\"%d\" > <input type=\"hidden\" id=\"selEncrypt_%d\" value=\"%s\" > <input type=\"hidden\" id=\"wpa_tkip_aes_%d\" value=\"%s\" > <input type=\"hidden\" id=\"wpa2_tkip_aes_%d\" value=\"%s\" > <input type=\"hidden\" id=\"wapi_sm4_gcm_%d\" value=\"%s\" > <input type=\"radio\" name="
			"\"select\" value=\"sel%d\" onClick=\"enableConnect(%d)\"></td></tr>\n",
			i,tmpBuf,i,pBss->channel,i,tmp2Buf,i,wpa_tkip_aes,i,wpa2_tkip_aes,i,wapi_sm4_gcm,i,i);
#else
		nBytesSent += boaWrite(wp,			
			"<td align=center width=\"10%%\" bgcolor=\"#C0C0C0\"><input type=\"hidden\" id=\"selSSID_%d\" value=\"%s\" > <input type=\"hidden\" id=\"selChannel_%d\" value=\"%d\" > <input type=\"hidden\" id=\"selEncrypt_%d\" value=\"%s\" > <input type=\"hidden\" id=\"wpa_tkip_aes_%d\" value=\"%s\" > <input type=\"hidden\" id=\"wpa2_tkip_aes_%d\" value=\"%s\" > <input type=\"radio\" name="	
			"\"select\" value=\"sel%d\" onClick=\"enableConnect(%d)\"></td></tr>\n",
			i,tmpBuf,i,pBss->channel,i,tmp2Buf,i,wpa_tkip_aes,i,wpa2_tkip_aes ,i,i);
#endif
	}

	if(pStatusTotal){
		free(pStatusTotal);
		pStatusTotal = NULL;
	}

	wlan_idx = ori_wlan_idx;
	return nBytesSent;

draw_err:
	for(j=0; j<NUM_WLAN_INTERFACE; ++j)
	{
		if (pStatus[j]) {		
			free(pStatus[j]); 
			pStatus[j] = NULL;
		}
	}

	if(pStatusTotal){
		free(pStatusTotal);
		pStatusTotal = NULL;
	}
	
	wlan_idx = ori_wlan_idx;
	return nBytesSent;
}
#else
static SS_STATUS_Tp pStatus=NULL;
void formWlSiteSurvey(request * wp, char *path, char *query)
{
 	char *submitUrl, *refresh, *connect, *strSel, *strEncrypt;
	int status, idx;
	unsigned char res, *pMsg=NULL;
	int wait_time;
	char tmpBuf[100];
	char *strVal;
	int max_wait_time=0;

#if defined(WLAN_DUALBAND_CONCURRENT)
	strVal = boaGetVar(wp, "wlan_idx", "");
	if ( strVal[0] ) {
		printf("wlan_idx=%d\n", strVal[0]-'0');
		wlan_idx = strVal[0]-'0';
	}
#endif //WLAN_DUALBAND_CONCURRENT

	submitUrl = boaGetVar(wp, "submit-url", "");
	wlan_idx = 1; //tesia

	refresh = boaGetVar(wp, "refresh", "");
	if ( refresh[0] ) 
	{		
		// issue scan request
		wait_time = 0;
		while (1) {			
			switch(getWlSiteSurveyRequest(getWlanIfName(), &status)) 
			{					
				case -2: 
					//printf("Auto scan running!!\n"); 
					//goto ss_err; 
					break; 
				case -1: 
					//printf("Site-survey request failed!\n"); 
					//goto ss_err; 
					break; 
				default: 
					break; 
			} 		
		
			if (status != 0) {	// not ready				
				if (wait_time++ > 30) 			
				{
					strcpy(tmpBuf, "scan request timeout!");
					goto ss_err;
				}
				sleep(1);
			}
			else
				break;
		}

		// wait until scan completely
		wait_time = 0;
		while (1) {
			res = 1;	// only request request status
			if ( getWlSiteSurveyResult(getWlanIfName(), (SS_STATUS_Tp)&res) < 0 ) {
				strcpy(tmpBuf, "Read site-survey status failed!");
				free(pStatus);
				pStatus = NULL;
				goto ss_err;
			}
			if (res == 0xff) {   // in progress
#if defined(CONFIG_RTL_DFS_SUPPORT)
				if (wait_time++ > 20)
#else
				if (wait_time++ > 10)
#endif
				{
					strcpy(tmpBuf, "scan timeout!");
					free(pStatus);
					pStatus = NULL;
					goto ss_err;
				}
				sleep(1);
			}
			else
				break;		
		}
		
		if (submitUrl[0])
			boaRedirect(wp, submitUrl);

		return;
	}

	connect = boaGetVar(wp, "connect", "");
	if ( connect[0] ) {			
		strSel = boaGetVar(wp, "select", "");
		if (strSel[0]) {	
			unsigned char res;
			NETWORK_TYPE_T net;
			int keyLen, len;
			unsigned char chan, encrypt, vChar;
			char *strAuth, *strKeyLen, *strFormat, *wepKey;
			char key[30];

			MIB_CE_MBSSIB_T pEntry;
			int vxd_wisp_wan = 0, interface_idx = 0;
			char opmode, wlanmode, rptEnabled;

			if (pStatus == NULL) {
				strcpy(tmpBuf, "Please refresh again!");
				goto ss_err;

			}
			sscanf(strSel, "sel%d", &idx);
			if ( idx >= pStatus->number ) { // invalid index
				strcpy(tmpBuf, "Connect failed 1!");
				goto ss_err;
			}

			wlan_getEntry(&pEntry, 0);
			wlanmode = pEntry.wlanMode;
#ifdef WLAN_UNIVERSAL_REPEATER
			mib_get_s(MIB_REPEATER_ENABLED1, (void *)&rptEnabled, sizeof(rptEnabled));
#else
			rptEnabled = 0;
#endif		

			if( (wlanmode == AP_MODE || wlanmode == AP_WDS_MODE 
#ifdef WLAN_MESH
				|| wlanmode == AP_MESH_MODE || wlanmode == MESH_MODE
#endif
				) && (rptEnabled == 1))
				vxd_wisp_wan = 1;
			
			if(vxd_wisp_wan)
				interface_idx = WLAN_REPEATER_ITF_INDEX;

			wlan_getEntry(&pEntry, interface_idx);
			
			// Set SSID, network type to MIB
			memcpy(tmpBuf, pStatus->bssdb[idx].ssid, pStatus->bssdb[idx].ssidlen);
			tmpBuf[pStatus->bssdb[idx].ssidlen] = '\0';
			//if ( mib_set(MIB_WLAN_SSID, (void *)tmpBuf) == 0) {
			//	strcpy(tmpBuf, "Set SSID error!");
			//	goto ss_err;
			//}
			strcpy(pEntry.ssid, tmpBuf);			
			if ( pStatus->bssdb[idx].capability & cESS )
				net = INFRASTRUCTURE;
			else
				net = ADHOC;
			
			if(interface_idx == 0){
				if ( mib_set(MIB_WLAN_NETWORK_TYPE, (void *)&net) == 0) {
					//sprintf(tmpBuf, "%s:%s", Tset_mib_error, MIB_WLAN_NETWORK_TYPE);
					strcpy(tmpBuf, "Set MIB_WLAN_NETWORK_TYPE failed!");
					goto ss_err;
				}
			}
			
			if (net == ADHOC) {
				chan = pStatus->bssdb[idx].channel;
				if ( mib_set( MIB_WLAN_CHAN_NUM, (void *)&chan) == 0) {
					//sprintf(tmpBuf, "%s:%s", Tset_mib_error, MIB_WLAN_CHAN_NUM);
					strcpy(tmpBuf, "Set channel number error!");
					goto ss_err;
				}
			}
			else if(vxd_wisp_wan){ //set to root (repeater enabled)
#ifdef WLAN_MESH /*in mesh mode, keep the original channel*/
                if(wlanmode != AP_MESH_MODE && wlanmode != MESH_MODE) 
#endif
				{
					chan = pStatus->bssdb[idx].channel;					
					if ( mib_set( MIB_WLAN_CHAN_NUM, (void *)&chan) == 0) {
						//sprintf(tmpBuf, "%s:%s", Tset_mib_error, MIB_WLAN_CHAN_NUM);
						strcpy(tmpBuf, "Set channel number error!");
						goto ss_err;
					}
					int sideband;
					mib_get_s( MIB_WLAN_CONTROL_BAND, (void *)&sideband, sizeof(sideband));
					if ((chan<=4 && sideband==0) || (chan>=10 && sideband==1)){
					   sideband = ((sideband + 1) & 0x1);										
					   mib_set( MIB_WLAN_CONTROL_BAND, (void *)&sideband);
					}
				}
			}


			//strEncrypt = boaGetVar(wp, "security_method", "");
			strEncrypt = boaGetVar(wp, "wlan_encrypt", "");
			if (!strEncrypt[0]) {
		 		strcpy(tmpBuf, "Error! no encryption method.");
				goto ss_err;
			}

			encrypt = (WIFI_SECURITY_T) strEncrypt[0] - '0';
			vChar = (char)encrypt;
			pEntry.encrypt = vChar;			
			if (encrypt == WIFI_SEC_WEP) {
				AUTH_TYPE_T authType;
				WEP_T wep;
				// (1) Authentication Type
				strAuth = boaGetVar(wp, "auth_type", "");
				if (strAuth[0]) {
					if ( !gstrcmp(strAuth, "open"))
						authType = AUTH_OPEN;
					else if ( !gstrcmp(strAuth, "shared"))
						authType = AUTH_SHARED;
					else if ( !gstrcmp(strAuth, "both"))
						authType = AUTH_BOTH;
					else {
						strcpy(tmpBuf, "Error! Invalid authentication value.");
						goto ss_err;
					}
					vChar = (char)authType;
					pEntry.authType = vChar;
				}
				// (2) Key Length
				strKeyLen = boaGetVar(wp, "length0", "");
				if (!strKeyLen[0]) {
					strcpy(tmpBuf, "Key length must exist!");
					goto ss_err;
				}
				if (strKeyLen[0]!='1' && strKeyLen[0]!='2') {
					strcpy(tmpBuf, "Invalid key length value!");
					goto ss_err;
				}
				if (strKeyLen[0] == '1')
					wep = WEP64;
				else
					wep = WEP128;

				vChar = (char)wep;

				//if ( mib_set( MIB_WLAN_WEP, (void *)&vChar) == 0) {
				//	strcpy(tmpBuf, strSetWLANWEPErr);
				//	goto ss_err;
				//}
				pEntry.wep = vChar;

				// (3) Key Format
				strFormat = boaGetVar(wp, "format0", "");
				if (!strFormat[0]) {
					strcpy(tmpBuf, "Key type must exist!");
					goto ss_err;
				}

				if (strFormat[0]!='1' && strFormat[0]!='2') {
					strcpy(tmpBuf, "Invalid key type value!");
					goto ss_err;
				}

				vChar = (char)(strFormat[0] - '0' - 1);

				//if ( mib_set( MIB_WLAN_WEP_KEY_TYPE, (void *)&vChar) == 0) {
				//	strcpy(tmpBuf, strSetWepKeyTypeErr);
				//	goto ss_err;
				//}
				pEntry.wepKeyType = vChar;

				if (wep == WEP64) {
					if (strFormat[0]=='1')
						keyLen = WEP64_KEY_LEN;
					else
						keyLen = WEP64_KEY_LEN*2;
				}
				else {
					if (strFormat[0]=='1')
						keyLen = WEP128_KEY_LEN;
					else
						keyLen = WEP128_KEY_LEN*2;
				}

				// (4) Encryption Key
				wepKey = boaGetVar(wp, "key0", "");
				if	(wepKey[0]) {
					if (strlen(wepKey) != keyLen) {
						strcpy(tmpBuf, "Invalid key 1 length!");
						goto ss_err;
					}
					if ( !isAllStar(wepKey) ) {
						if (strFormat[0] == '1') // ascii
							strcpy(key, wepKey);
						else { // hex
							if ( !rtk_string_to_hex(wepKey, key, keyLen)) {
								strcpy(tmpBuf, "Invalid wep-key1 value!");
								goto ss_err;
							}
						}
						if (wep == WEP64) {
							//if (mib_set(MIB_WLAN_WEP64_KEY1, (void *)key) == 0 ) {
							//	strcpy(tmpBuf, strSetWEPKey1Err);
							//	goto ss_err;
							//}
							strcpy(pEntry.wep64Key1, key);
						}
						else {
							//if (mib_set(MIB_WLAN_WEP128_KEY1, (void *)key) == 0 ) {
							//	strcpy(tmpBuf, strSetWEPKey1Err);
							//	goto ss_err;
							//}
							strcpy(pEntry.wep128Key1, key);
						}

					}
				}// (4) Encryption Key	
			}else if(encrypt >= WIFI_SEC_WPA) {	// WPA
				if ((encrypt == WIFI_SEC_WPA) || (encrypt == WIFI_SEC_WPA2_MIXED)) {					
					unsigned char intVal = 0;
					unsigned char val2;
					//strVal = boaGetVar(wp, "ciphersuite_t", "");
					strVal = boaGetVar(wp, "wpa_tkip_aes", "");
					if (strVal[0]=='1')
						intVal |= WPA_CIPHER_TKIP;
					//strVal = boaGetVar(wp, "ciphersuite_a", "");
					if (strVal[0]=='2')
						intVal |= WPA_CIPHER_AES;

					if ( intVal == 0 )
						intVal = WPA_CIPHER_TKIP;
					
					pEntry.unicastCipher = intVal;
				}
		
				// Mason Yu. 201009_new_security. Set wpa2ciphersuite(wpa2_cipher) for wpa2/wpa mixed
				if ((encrypt == WIFI_SEC_WPA2) || (encrypt == WIFI_SEC_WPA2_MIXED)) {
					unsigned char intVal = 0;
					//strVal = boaGetVar(wp, "wpa2ciphersuite_t", "");
					strVal = boaGetVar(wp, "wpa2_tkip_aes", "");
					if (strVal[0]=='1')
						intVal |= WPA_CIPHER_TKIP;
					//strVal = boaGetVar(wp, "wpa2ciphersuite_a", "");
					if (strVal[0]=='2')
						intVal |= WPA_CIPHER_AES;

					if ( intVal == 0 )
						intVal = WPA_CIPHER_AES;

					pEntry.wpa2UnicastCipher = intVal;
				}
				// pre-shared key
					strVal = boaGetVar(wp, "pskFormat", "");
					if (!strVal[0]) {
						strcpy(tmpBuf, "Error! no psk format.");
						goto ss_err;
					}
					vChar = strVal[0] - '0';
					if (vChar != 0 && vChar != 1) {
						strcpy(tmpBuf, "Error! invalid psk format.");
						goto ss_err;
					}
		
					strVal = boaGetVar(wp, "pskValue", "");
					len = strlen(strVal);
		
					//if ( mib_set(MIB_WLAN_WPA_PSK_FORMAT, (void *)&vChar) == 0) {
					//	strcpy(tmpBuf, strSetWPAPSKFMATErr);
					//	goto ss_err;
					//}
					pEntry.wpaPSKFormat = vChar;					
		
					if (vChar==1) { // hex
						if (len!=MAX_PSK_LEN || !rtk_string_to_hex(strVal, tmpBuf, MAX_PSK_LEN)) {
							strcpy(tmpBuf, "Error! invalid psk value.");
							goto ss_err;
						}
					}
					else { // passphras
						if (len==0 || len > (MAX_PSK_LEN - 1) ) {
							strcpy(tmpBuf, "Error! invalid psk value.");
							goto ss_err;
						}
					}

					//if ( !mib_set(MIB_WLAN_WPA_PSK, (void *)strVal)) {
					//	strcpy(tmpBuf, strSetWPAPSKErr);
					//	goto ss_err;
					//}
					strcpy(pEntry.wpaPSK, strVal);
			}

			wlan_setEntry(&pEntry, interface_idx);
			mib_update(CURRENT_SETTING, CONFIG_MIB_ALL);	// update to flash
			config_WLAN(ACT_RESTART, CONFIG_SSID_ALL);	

			res = idx;
			wait_time = 0;
			char interface_name[20];

			if(vxd_wisp_wan)
				sprintf(interface_name, "%s-vxd", getWlanIfName());
			else
				sprintf(interface_name, "%s", getWlanIfName());		

// CONFIG_SUPPORT_CLIENT_MIXED_SECURITY definition is removed in wifi driver V3.3 and after, do not use old method to get connection result
#if 0 //#ifndef CONFIG_SUPPORT_CLIENT_MIXED_SECURITY
// old method
			while (1) {
				if ( getWlJoinRequest(interface_name, &pStatus->bssdb[idx], &res) < 0 ) {
					strcpy(tmpBuf, multilang(LANG_JOIN_REQUEST_FAILED));
					goto ss_err;
				}
				if ( res == 1 ) { // wait
					if (wait_time++ > 5) {
						strcpy(tmpBuf, multilang(LANG_CONNECT_REQUEST_TIMEOUT));
						goto ss_err;
					}
					sleep(1);
					continue;
				}
				break;
			}

			if ( res == 2 ) // invalid index
				pMsg = "Connect failed 2!";
			else {
				wait_time = 0;
				while (1) {
					if ( getWlJoinResult(interface_name, &res) < 0 ) {
						strcpy(tmpBuf, multilang(LANG_GET_JOIN_RESULT_FAILED));
						goto ss_err;
					}
					if ( res != 0xff ) { // completed
						break;
					}
					if (wait_time++ > 10) {
						strcpy(tmpBuf, multilang(LANG_CONNECT_REQUEST_TIMEOUT));
						goto ss_err;
					}
					sleep(1);
				}

				if ( res!=STATE_Bss && res!=STATE_Ibss_Idle && res!=STATE_Ibss_Active )
					pMsg = "Connect failed 3!";
				else {
					status = 0;
					if (encrypt == WIFI_SEC_WPA
						|| encrypt == WIFI_SEC_WPA2) {
						bss_info bss;
						wait_time = 0;
						while (wait_time++ < 5) {
							getWlBssInfo(interface_name, &bss);
							if (bss.state == STATE_CONNECTED)
								break;
							sleep(1);
						}
						if (wait_time >= 5)
							status = 1;
					}
					if (status)
						pMsg = "Connect failed 4!";
					else
						pMsg = "Connect successfully!";
				}
			}
#else
// for wifi driver V3.3 and after
			status = 0;
			bss_info bss;
			max_wait_time = 30;
			while (wait_time++ < max_wait_time) {
				getWlBssInfo(interface_name, &bss);
				if (bss.state == STATE_CONNECTED)
					break;			
				sleep(1);
			}
			if (wait_time >= max_wait_time)
				status = 1;
			
			if (status)
				pMsg = "Connect failed 4!";
			else
				pMsg = "Connect successfully!";
#endif	
			OK_MSG1(pMsg, submitUrl);
		}
	}
	return;

ss_err:
	ERR_MSG(tmpBuf);
}

int wlSiteSurveyTbl(int eid, request * wp, int argc, char **argv)
{
	int nBytesSent=0, i;
	BssDscr *pBss;
	char tmpBuf[100], ssidbuf[40],tmp1Buf[10], tmp2Buf[20], chwidBuf[10], wpa_tkip_aes[20],wpa2_tkip_aes[20];
	WLAN_MODE_T mode;
	bss_info bss;
#ifdef WLAN_UNIVERSAL_REPEATER
	char rpt_enabled=0;
#endif
	MIB_CE_MBSSIB_T Entry;

	if (pStatus==NULL) {
		pStatus = calloc(1, sizeof(SS_STATUS_T));
		if ( pStatus == NULL ) {
			printf("Allocate buffer failed!\n");
			return 0;
		}
	}

	pStatus->number = 0; // request BSS DB	

	//just for test(tesia)
	wlan_idx = 1;
	
	if ( getWlSiteSurveyResult(getWlanIfName(), pStatus) < 0 ) {
		ERR_MSG("Read site-survey status failed");
		free(pStatus);
		pStatus = NULL;
		return 0;
	}
	
	wlan_getEntry((void *)&Entry, 0);
	mode=Entry.wlanMode;
	
	if ( getWlBssInfo(getWlanIfName(), &bss) < 0) {
		printf("Get bssinfo failed!");
		return 0;
	}
	
#ifdef WLAN_UNIVERSAL_REPEATER
	mib_get_s( MIB_REPEATER_ENABLED1, (void *)&rpt_enabled, sizeof(rpt_enabled));
#endif	

	nBytesSent += boaWrite(wp, "<tr>"
		"<td align=center width=\"30%%\" bgcolor=\"#808080\"><font size=\"2\"><b>SSID</b></font></td>\n"
		"<td align=center width=\"20%%\" bgcolor=\"#808080\"><font size=\"2\"><b>BSSID</b></font></td>\n"
		"<td align=center width=\"10%%\" bgcolor=\"#808080\"><font size=\"2\"><b>%s</b></font></td>\n"
	  	"<td align=center width=\"10%%\" bgcolor=\"#808080\"><font size=\"2\"><b>%s</b></font></td>\n"
	  	"<td align=center width=\"10%%\" bgcolor=\"#808080\"><font size=\"2\"><b>%s</b></font></td>\n"
		"<td align=center width=\"10%%\" bgcolor=\"#808080\"><font size=\"2\"><b>%s(%%)</b></font></td>\n",
		multilang_bpas("Channel"), multilang_bpas("Type"), multilang_bpas("Encryption"), multilang_bpas("Signal"));
	
	if( mode == CLIENT_MODE 
#ifdef WLAN_UNIVERSAL_REPEATER
		|| rpt_enabled
#endif
	)
		nBytesSent += boaWrite(wp, "<td align=center width=\"10%%\" bgcolor=\"#808080\"><font size=\"2\"><b>Select</b></font></td></tr>\n");
	else
		nBytesSent += boaWrite(wp, "</tr>\n");

	for (i=0; i<pStatus->number && pStatus->number!=0xff; i++) {
		pBss = &pStatus->bssdb[i];
		snprintf(tmpBuf, 200, "%02x:%02x:%02x:%02x:%02x:%02x",
			pBss->bssid[0], pBss->bssid[1], pBss->bssid[2],
			pBss->bssid[3], pBss->bssid[4], pBss->bssid[5]);

		//memcpy(ssidbuf, pBss->bdSsIdBuf, pBss->bdSsId.Length);
		//ssidbuf[pBss->bdSsId.Length] = '\0';
		if(pBss->ssidlen>SSID_LEN)
			printf("the length of SSID %s is greater than %d\n",pBss->ssid,SSID_LEN);

		memcpy(ssidbuf, pBss->ssid, pBss->ssidlen>=SSID_LEN?SSID_LEN:pBss->ssidlen);
		ssidbuf[pBss->ssidlen>=SSID_LEN?SSID_LEN:pBss->ssidlen] = '\0';

		if (pBss->network==BAND_11B)
				strcpy(tmp1Buf, (" (B)"));
		else if (pBss->network==BAND_11G)
				strcpy(tmp1Buf, (" (G)"));	   
		else if (pBss->network==(BAND_11G|BAND_11B))
				strcpy(tmp1Buf, (" (B+G)"));
		else if (pBss->network==(BAND_11N))
				strcpy(tmp1Buf, (" (N)"));				
		else if (pBss->network==(BAND_11G|BAND_11N))
				strcpy(tmp1Buf, (" (G+N)"));
		else if (pBss->network==(BAND_11G|BAND_11B | BAND_11N))
				strcpy(tmp1Buf, (" (B+G+N)"));
		else if(pBss->network== BAND_11A)
				strcpy(tmp1Buf, (" (A)"));
		else if(pBss->network== (BAND_11A | BAND_11N))
				strcpy(tmp1Buf, (" (A+N)"));
		else if(pBss->network== (BAND_5G_11AC | BAND_11N))
				strcpy(tmp1Buf, (" (AC+N)"));
		else if(pBss->network== (BAND_11A | BAND_5G_11AC))
				strcpy(tmp1Buf, (" (A+AC)"));				 
		else if(pBss->network== (BAND_11A |BAND_11N | BAND_5G_11AC))
				strcpy(tmp1Buf, (" (A+N+AC)")); 		  
		else
				sprintf(tmp1Buf, (" -%d-"),pBss->network);

		
		memset(wpa_tkip_aes,0x00,sizeof(wpa_tkip_aes));
		memset(wpa2_tkip_aes,0x00,sizeof(wpa2_tkip_aes));
		if ((pBss->capability & cPrivacy) == 0)
			sprintf(tmp2Buf, "no");
		else {
			if (pBss->t_stamp[0] == 0)
				sprintf(tmp2Buf, "WEP");
#if defined(CONFIG_RTL_WAPI_SUPPORT)
			else if (pBss->t_stamp[0] == SECURITY_INFO_WAPI)
				sprintf(tmp2Buf, "WAPI");
#endif
			else 
			{
				int wpa_exist = 0, idx = 0, wpa3_exist = 0;
				if (pBss->t_stamp[0] & 0x0000ffff) 
				{
					idx = sprintf(tmp2Buf, "WPA");
					if (((pBss->t_stamp[0] & 0x0000f000) >> 12) == 0x4)
						idx += sprintf(tmp2Buf+idx, "-PSK");
					else if(((pBss->t_stamp[0] & 0x0000f000) >> 12) == 0x2)
						idx += sprintf(tmp2Buf+idx, "-1X");
					wpa_exist = 1;
				
					if (((pBss->t_stamp[0] & 0x00000f00) >> 8) == 0x5)
						sprintf(wpa_tkip_aes,"%s","aes/tkip");
					else if (((pBss->t_stamp[0] & 0x00000f00) >> 8) == 0x4)
						sprintf(wpa_tkip_aes,"%s","aes");
					else if (((pBss->t_stamp[0] & 0x00000f00) >> 8) == 0x1)
						sprintf(wpa_tkip_aes,"%s","tkip");
				}
				if(pBss->t_stamp[1] & 0x00000800)
				{
					idx += sprintf(tmp2Buf+idx, "WPA3");
					wpa3_exist = 1;
				}
				//if (pBss->t_stamp[0] & 0xffff0000) 
				if ((pBss->t_stamp[0] & 0xf0000000) || (!(pBss->t_stamp[1] & 0x00000800) && (pBss->t_stamp[0] & 0xffff0000)))
				{
					if (wpa_exist || wpa3_exist)
						idx += sprintf(tmp2Buf+idx, "/");
					idx += sprintf(tmp2Buf+idx, "WPA2");
					if (((pBss->t_stamp[0] & 0xf0000000) >> 28) == 0x4)
						idx += sprintf(tmp2Buf+idx, "-PSK");
					else if (((pBss->t_stamp[0] & 0xf0000000) >> 28) == 0x2)
						idx += sprintf(tmp2Buf+idx, "-1X");

					if (((pBss->t_stamp[0] & 0x0f000000) >> 24) == 0x5)
						sprintf(wpa2_tkip_aes,"%s","aes/tkip");
					else if (((pBss->t_stamp[0] & 0x0f000000) >> 24) == 0x4)
						sprintf(wpa2_tkip_aes,"%s","aes");
					else if (((pBss->t_stamp[0] & 0x0f000000) >> 24) == 0x1)
						sprintf(wpa2_tkip_aes,"%s","tkip");
				}
			}
		}
		memset(chwidBuf, '\0', sizeof(chwidBuf));
		if (pBss->t_stamp[1] & (BSS_BW_MASK << BSS_BW_SHIFT)){
			int tmp = (pBss->t_stamp[1] >> BSS_BW_SHIFT) & BSS_BW_MASK;
			switch (tmp) {
				case 0:
					sprintf(chwidBuf, "20MHz");
					break;
				case 1:
					sprintf(chwidBuf, "40MHz");
					break;
				case 2:
					sprintf(chwidBuf, "80MHz");
					break;
			}
		}
		else if (pBss->t_stamp[1] & (1<<1))
			sprintf(chwidBuf, "40MHz");
		else
			sprintf(chwidBuf, "20MHz");

		nBytesSent += boaWrite(wp, "<tr>"
			"<td align=left width=\"20%%\" bgcolor=\"#C0C0C0\"><font size=\"2\">%s</td>\n"
			"<td align=center width=\"20%%\" bgcolor=\"#C0C0C0\"><font size=\"2\">%s</td>\n"
  			"<td align=center width=\"10%%\" bgcolor=\"#C0C0C0\"><font size=\"2\">%d</td>\n"
  			"<td align=center width=\"10%%\" bgcolor=\"#C0C0C0\"><font size=\"2\">%s</td>\n"
			"<td align=center width=\"10%%\" bgcolor=\"#C0C0C0\"><font size=\"2\">%s</td>\n"
			"<td align=center width=\"10%%\" bgcolor=\"#C0C0C0\"><font size=\"2\">%d</td>\n",
			ssidbuf, tmpBuf, pBss->channel,
			((pBss->capability & cIBSS) ? "Ad hoc" : "AP"),	
			tmp2Buf, pBss->rssi);

		if ( mode == CLIENT_MODE 
#ifdef WLAN_UNIVERSAL_REPEATER
		|| rpt_enabled
#endif
		)
		{
			nBytesSent += boaWrite(wp,			
				"<td align=center width=\"10%%\" bgcolor=\"#C0C0C0\"><input type=\"hidden\" id=\"selSSID_%d\" value=\"%s\" > <input type=\"hidden\" id=\"selChannel_%d\" value=\"%d\" > <input type=\"hidden\" id=\"selEncrypt_%d\" value=\"%s\" > <input type=\"hidden\" id=\"wpa_tkip_aes_%d\" value=\"%s\" > <input type=\"hidden\" id=\"wpa2_tkip_aes_%d\" value=\"%s\" > <input type=\"radio\" name="	
				"\"select\" value=\"sel%d\" onClick=\"enableConnect(%d)\"></td></tr>\n",i,tmpBuf,i,pBss->channel,i,tmp2Buf,i,wpa_tkip_aes,i,wpa2_tkip_aes ,i,i);
		}
		else
		{
			nBytesSent += boaWrite(wp, "</tr>\n");
		}
	}

	return nBytesSent;
}
#endif //of WLAN_SITE_SURVEY_SIMUL
#endif //of WLAN_SITE_SURVEY_SUPPORT
#else
#ifdef WLAN_CLIENT
static SS_STATUS_Tp pStatus=NULL;
/////////////////////////////////////////////////////////////////////////////
void formWlSiteSurvey(request * wp, char *path, char *query)
{
 	char *submitUrl, *refresh, *connect, *strSel;
	int status, idx;
	unsigned char res, *pMsg=NULL;
	int wait_time;
	char tmpBuf[100];
	BssDscr *pBss = NULL;

#if defined(WLAN_DUALBAND_CONCURRENT)
	char *strVal;
	strVal = boaGetVar(wp, "wlan_idx", "");
	if ( strVal[0] ) {
		printf("wlan_idx=%d\n", strVal[0]-'0');
		wlan_idx = strVal[0]-'0';
	}
#endif //WLAN_DUALBAND_CONCURRENT

	submitUrl = boaGetVar(wp, "submit-url", "");

	refresh = boaGetVar(wp, "refresh", "");
	if ( refresh[0] ) {
		// issue scan request
		wait_time = 0;
		while (1) {
			if ( getWlSiteSurveyRequest(getWlanIfName(),  &status) < 0 ) {
				strcpy(tmpBuf, "Site-survey request failed!");
				goto ss_err;
			}
			if (status != 0) {	// not ready
				if (wait_time++ > 5) {
					strcpy(tmpBuf, "scan request timeout!");
					goto ss_err;
				}
				sleep(1);
			}
			else
				break;
		}

		// wait until scan completely
		wait_time = 0;
		while (1) {
			res = 1;	// only request request status
			if ( getWlSiteSurveyResult(getWlanIfName(), (SS_STATUS_Tp)&res) < 0 ) {
				strcpy(tmpBuf, "Read site-survey status failed!");
				free(pStatus);
				pStatus = NULL;
				goto ss_err;
			}
			if (res == 0xff) {   // in progress
				if (wait_time++ > 10) {
					strcpy(tmpBuf, "scan timeout!");
					free(pStatus);
					pStatus = NULL;
					goto ss_err;
				}
				sleep(1);
			}
			else
				break;
		}

		if (submitUrl[0])
			boaRedirect(wp, submitUrl);

		return;
	}

	connect = boaGetVar(wp, "connect", "");
	if ( connect[0] ) {
		strSel = boaGetVar(wp, "select", "");
		if (strSel[0]) {
			unsigned char res;
			NETWORK_TYPE_T net;
			int chan;
			unsigned char encrypt;
			MIB_CE_MBSSIB_T pEntry;

			if (pStatus == NULL) {
				strcpy(tmpBuf, "Please refresh again!");
				goto ss_err;

			}
			sscanf(strSel, "sel%d", &idx);
			if ( idx >= pStatus->number ) { // invalid index
				strcpy(tmpBuf, "Connect failed 1!");
				goto ss_err;
			}
			wlan_getEntry(&pEntry, 0);
			// check encryption type match or not
			encrypt = pEntry.encrypt;
			// no encryption
			if (encrypt == WIFI_SEC_NONE)
			{
				if (pStatus->bssdb[idx].capability & 0x00000010) {
					strcpy(tmpBuf, "Encryption type mismatch!");
					goto ss_err;
				}
				else
					; // success
			}
			// legacy encryption
			else if (encrypt == WIFI_SEC_WEP)
			{
				if ((pStatus->bssdb[idx].capability & 0x00000010) == 0) {
					strcpy(tmpBuf, "Encryption type mismatch!");
					goto ss_err;
				}
#if defined(WLAN_11AX) && !defined(WIFI5_WIFI6_COMP)
				else if (pStatus->bssdb[idx].encrypt != ENCRYP_PROTOCOL_WEP)
#else
				else if (pStatus->bssdb[idx].t_stamp[0] != 0)
#endif
				{
					strcpy(tmpBuf, "Encryption type mismatch!");
					goto ss_err;
				}
				else
					; // success
			}
			// WPA/WPA2
			else
			{
				int isPSK;
				unsigned char auth;
				auth = pEntry.wpaAuth;
				if (auth == WPA_AUTH_PSK)
					isPSK = 1;
				else
					isPSK = 0;

				if ((pStatus->bssdb[idx].capability & 0x00000010) == 0) {
					strcpy(tmpBuf, "Encryption type mismatch!");
					goto ss_err;
				}
#if defined(WLAN_11AX) && !defined(WIFI5_WIFI6_COMP)
				else if (pStatus->bssdb[idx].encrypt == ENCRYP_PROTOCOL_OPENSYS)
#else
				else if (pStatus->bssdb[idx].t_stamp[0] == 0)
#endif
				{
					strcpy(tmpBuf, "Encryption type mismatch!");
					goto ss_err;
				}
				else if (encrypt == WIFI_SEC_WPA) {
#if defined(WLAN_11AX) && !defined(WIFI5_WIFI6_COMP)
					if(pStatus->bssdb[idx].encrypt!=ENCRYP_PROTOCOL_WPA)
#else
					if (((pStatus->bssdb[idx].t_stamp[0] & 0x0000ffff) == 0) ||
							(isPSK && !(pStatus->bssdb[idx].t_stamp[0] & 0x4000)) ||
							(!isPSK && (pStatus->bssdb[idx].t_stamp[0] & 0x4000)) )
#endif
					{
						strcpy(tmpBuf, "Encryption type mismatch!");
						goto ss_err;
					}
				}
				else if (encrypt == WIFI_SEC_WPA2) {
#if defined(WLAN_11AX) && !defined(WIFI5_WIFI6_COMP)
					if(pStatus->bssdb[idx].encrypt!=ENCRYP_PROTOCOL_WPA2)
#else
					if (((pStatus->bssdb[idx].t_stamp[0] & 0xffff0000) == 0) ||
							(isPSK && !(pStatus->bssdb[idx].t_stamp[0] & 0x40000000)) ||
							(!isPSK && (pStatus->bssdb[idx].t_stamp[0] & 0x40000000)) )
#endif
					{
						strcpy(tmpBuf, "Encryption type mismatch!");
						goto ss_err;
					}
				}
				else
					; // success
			}

			// Set SSID, network type to MIB
			memcpy(tmpBuf, pStatus->bssdb[idx].ssid, pStatus->bssdb[idx].ssidlen);
			tmpBuf[pStatus->bssdb[idx].ssidlen] = '\0';
			strcpy(pEntry.ssid,tmpBuf);

			if ( pStatus->bssdb[idx].capability & cESS )
				net = INFRASTRUCTURE;
			else
				net = ADHOC;

			if ( mib_set(MIB_WLAN_NETWORK_TYPE, (void *)&net) == 0) {
				strcpy(tmpBuf, "Set MIB_WLAN_NETWORK_TYPE failed!");
				goto ss_err;
			}

			if (net == ADHOC) {
				chan = pStatus->bssdb[idx].channel;
				if ( mib_set( MIB_WLAN_CHAN_NUM, (void *)&chan) == 0) {
   					strcpy(tmpBuf, "Set channel number error!");
					goto ss_err;
				}
			}
			
			wlan_setEntry(&pEntry, 0);
			mib_update(CURRENT_SETTING, CONFIG_MIB_ALL);	// update to flash

			res = idx;
			wait_time = 0;
			while (1) {
				pBss = &pStatus->bssdb[idx];
				if ( getWlJoinRequest(getWlanIfName(), pBss, &res) < 0 ) {
					strcpy(tmpBuf, "Join request failed!");
					goto ss_err;
				}
				if ( res == 1 ) { // wait
					if (wait_time++ > 5) {
						strcpy(tmpBuf, "connect-request timeout!");
						goto ss_err;
					}
					sleep(1);
					continue;
				}
				break;
			}

			if ( res == 2 ) // invalid index
				pMsg = "Connect failed 2!";
			else {
				wait_time = 0;
				while (1) {
					if ( getWlJoinResult(getWlanIfName(), &res) < 0 ) {
						strcpy(tmpBuf, "Get Join result failed!");
						goto ss_err;
					}
					if ( res != 0xff ) { // completed
						break;
					}
					if (wait_time++ > 10) {
						strcpy(tmpBuf, "connect timeout!");
						goto ss_err;
					}
					sleep(1);
				}

				if ( res!=STATE_Bss && res!=STATE_Ibss_Idle && res!=STATE_Ibss_Active )
					pMsg = "Connect failed 3!";
				else {
					status = 0;
					if (encrypt == WIFI_SEC_WPA
						|| encrypt == WIFI_SEC_WPA2) {
						bss_info bss;
						wait_time = 0;
						while (wait_time++ < 5) {
							getWlBssInfo(getWlanIfName(), &bss);
							if (bss.state == STATE_CONNECTED)
								break;
							sleep(1);
						}
						if (wait_time >= 5)
							status = 1;
					}
					if (status)
						pMsg = "Connect failed 4!";
					else
						pMsg = "Connect successfully!";
				}
			}
			OK_MSG1(pMsg, submitUrl);
		}
	}
	return;

ss_err:
	ERR_MSG(tmpBuf);
}

/////////////////////////////////////////////////////////////////////////////
int wlSiteSurveyTbl(int eid, request * wp, int argc, char **argv)
{
	int nBytesSent=0, i;
	BssDscr *pBss;
	char tmpBuf[100], ssidbuf[40];
	WLAN_MODE_T mode;
	unsigned char mib_mode;
	bss_info bss;
	MIB_CE_MBSSIB_T Entry;
	if (pStatus==NULL) {
		pStatus = calloc(1, sizeof(SS_STATUS_T));
		if ( pStatus == NULL ) {
			printf("Allocate buffer failed!\n");
			return 0;
		}
	}

	pStatus->number = 0; // request BSS DB

	if ( getWlSiteSurveyResult(getWlanIfName(), pStatus) < 0 ) {
		ERR_MSG("Read site-survey status failed!");
		free(pStatus);
		pStatus = NULL;
		return 0;
	}
	wlan_getEntry((void *)&Entry, 0);
	mode=Entry.wlanMode;
	if ( getWlBssInfo(getWlanIfName(), &bss) < 0) {
		printf("Get bssinfo failed!");
		return 0;
	}

	nBytesSent += boaWrite(wp, "<tr>"
	"<td align=center width=\"30%%\" bgcolor=\"#808080\"><font size=\"2\"><b>SSID</b></font></td>\n"
	"<td align=center width=\"20%%\" bgcolor=\"#808080\"><font size=\"2\"><b>BSSID</b></font></td>\n"
	"<td align=center width=\"10%%\" bgcolor=\"#808080\"><font size=\"2\"><b>%s</b></font></td>\n"
      	"<td align=center width=\"10%%\" bgcolor=\"#808080\"><font size=\"2\"><b>%s</b></font></td>\n"
      	"<td align=center width=\"10%%\" bgcolor=\"#808080\"><font size=\"2\"><b>%s</b></font></td>\n"
	"<td align=center width=\"10%%\" bgcolor=\"#808080\"><font size=\"2\"><b>%s</b></font></td>\n",
	multilang_bpas("Channel"), multilang_bpas("Type"), multilang_bpas("Encryption"), multilang_bpas("Signal"));
	if ( mode == CLIENT_MODE )
		nBytesSent += boaWrite(wp, "<td align=center width=\"10%%\" bgcolor=\"#808080\"><font size=\"2\"><b>Select</b></font></td></tr>\n");
	else
		nBytesSent += boaWrite(wp, "</tr>\n");

	for (i=0; i<pStatus->number && pStatus->number!=0xff; i++) {
		pBss = &pStatus->bssdb[i];
		snprintf(tmpBuf, 200, "%02x:%02x:%02x:%02x:%02x:%02x",
			pBss->bssid[0], pBss->bssid[1], pBss->bssid[2],
			pBss->bssid[3], pBss->bssid[4], pBss->bssid[5]);

		//memcpy(ssidbuf, pBss->bdSsIdBuf, pBss->bdSsId.Length);
		//ssidbuf[pBss->bdSsId.Length] = '\0';
		memcpy(ssidbuf, pBss->ssid, pBss->ssidlen>=SSID_LEN?SSID_LEN-1:pBss->ssidlen);
		ssidbuf[pBss->ssidlen>=SSID_LEN?SSID_LEN-1:pBss->ssidlen] = '\0';

		nBytesSent += boaWrite(wp, "<tr>"
			"<td align=left width=\"20%%\" bgcolor=\"#C0C0C0\"><font size=\"2\">%s</td>\n"
			"<td align=center width=\"20%%\" bgcolor=\"#C0C0C0\"><font size=\"2\">%s</td>\n"
      			"<td align=center width=\"10%%\" bgcolor=\"#C0C0C0\"><font size=\"2\">%d</td>\n"
      			"<td align=center width=\"10%%\" bgcolor=\"#C0C0C0\"><font size=\"2\">%s</td>\n"
			"<td align=center width=\"10%%\" bgcolor=\"#C0C0C0\"><font size=\"2\">%s</td>\n"
			"<td align=center width=\"10%%\" bgcolor=\"#C0C0C0\"><font size=\"2\">%d</td>\n",
			ssidbuf, tmpBuf, pBss->channel,
			((pBss->capability & cIBSS) ? "Ad hoc" : "AP"),
			multilang_bpas((pBss->capability & cPrivacy) ? "Yes" : "No"), pBss->rssi);

		if ( mode == CLIENT_MODE )
			nBytesSent += boaWrite(wp,
			"<td align=center width=\"10%%\" bgcolor=\"#C0C0C0\"><input type=\"radio\" name="
			"\"select\" value=\"sel%d\" onClick=\"enableConnect()\"></td></tr>\n", i);
		else
			nBytesSent += boaWrite(wp, "</tr>\n");
	}

	return nBytesSent;
}
#endif // of WLAN_CLIENT
#endif // of CONFIG_RTK_DEV_AP

#ifdef WLAN_WDS
/////////////////////////////////////////////////////////////////////////////
void formWlWds(request * wp, char *path, char *query)
{
	char *strAddMac, *strDelMac, *strDelAllMac, *strVal, *submitUrl, *strEnabled, *strSet, *strRate;
	char tmpBuf[100];
	int  i,idx;
	WDS_T macEntry;
	WDS_T Entry;
	unsigned char entryNum,enabled,delNum=0;

	strSet = boaGetVar(wp, "wdsSet", "");
	strAddMac = boaGetVar(wp, "addWdsMac", "");
	strDelMac = boaGetVar(wp, "deleteSelWdsMac", "");
	strDelAllMac = boaGetVar(wp, "deleteAllWdsMac", "");
	strEnabled = boaGetVar(wp, "wlanWdsEnabled", "");

#if defined(WLAN_DUALBAND_CONCURRENT)
	strVal = boaGetVar(wp, "wlan_idx", "");
	if ( strVal[0] ) {
		printf("wlan_idx=%d\n", strVal[0]-'0');
		wlan_idx = strVal[0]-'0';
	}
#endif //WLAN_DUALBAND_CONCURRENT

	if (strSet[0]) {
		if (!gstrcmp(strEnabled, "ON")){
			enabled = 1;
		}
		else
			enabled = 0;
		if (mib_set( MIB_WLAN_WDS_ENABLED, (void *)&enabled) == 0) {
  			strcpy(tmpBuf, strSetEnableErr);
			goto setErr_wds;
		}
	}

	if (strAddMac[0]) {
		int intVal;
		/*if ( !gstrcmp(strEnabled, "ON")){
			enabled = 1;
		}
		else
			enabled = 0;
		if ( mib_set( MIB_WLAN_WDS_ENABLED, (void *)&enabled) == 0) {
  			strcpy(tmpBuf, strSetEnableErr);
			goto setErr_wds;
		}*/
		strVal = boaGetVar(wp, "mac", "");
		if ( !strVal[0] )
			goto setWds_ret;

		if (strlen(strVal)!=12 || !rtk_string_to_hex(strVal, macEntry.macAddr, 12)) {
			strcpy(tmpBuf, strInvdMACAddr);
			goto setErr_wds;
		}
		if (!isValidMacAddr(macEntry.macAddr)) {
			strcpy(tmpBuf, strInvdMACAddr);
			goto setErr_wds;
		}

		strVal = boaGetVar(wp, "comment", "");
		if ( strVal[0] ) {
			if (strlen(strVal) > COMMENT_LEN-1) {
				strcpy(tmpBuf, strCommentTooLong);
				goto setErr_wds;
			}
			strcpy(macEntry.comment, strVal);
		}
		else
			macEntry.comment[0] = '\0';
		strRate = boaGetVar(wp, "txRate", "");
		if ( strRate[0] ) {
			if ( strRate[0] == '0' ) { // auto
				macEntry.fixedTxRate =0;
			}else  {
				intVal = atoi(strRate);
				intVal = 1 << (intVal-1);
				macEntry.fixedTxRate = intVal;
			}
		}

		if ( !mib_get_s(MIB_WLAN_WDS_NUM, (void *)&entryNum, sizeof(entryNum))) {
			strcpy(tmpBuf, strGetEntryNumErr);
			goto setErr_wds;
		}
		if ( (entryNum + 1) > MAX_WDS_NUM) {
			strcpy(tmpBuf, strErrForTablFull);
			goto setErr_wds;
		}

		// Jenny added, set to MIB. Check if entry exists
		for (i=0; i<entryNum; i++) {
			if (!mib_chain_get(MIB_WDS_TBL, i, (void *)&Entry)) {
	  			boaError(wp, 400, "Get chain record error!\n");
				return;
			}
			if (!memcmp(macEntry.macAddr, Entry.macAddr, 6)) {
				strcpy(tmpBuf, strMACInList);
				goto setErr_wds;
			}
		}

		// set to MIB. try to delete it first to avoid duplicate case
		//mib_set(MIB_WLAN_WDS_DEL, (void *)&macEntry);
		intVal = mib_chain_add(MIB_WDS_TBL, (void *)&macEntry);
		if (intVal == 0) {
			strcpy(tmpBuf, strAddEntryErr);
			goto setErr_wds;
		}
		else if (intVal == -1) {
			strcpy(tmpBuf, strTableFull);
			goto setErr_wds;
		}
		entryNum++;
		if ( !mib_set(MIB_WLAN_WDS_NUM, (void *)&entryNum)) {
			strcpy(tmpBuf, strGetEntryNumErr);
			goto setErr_wds;
		}
	}

	/* Delete entry */
	delNum=0;
	if (strDelMac[0]) {
		if ( !mib_get_s(MIB_WLAN_WDS_NUM, (void *)&entryNum, sizeof(entryNum))) {
			strcpy(tmpBuf, strGetEntryNumErr);
			goto setErr_wds;
		}
		for (i=0; i<entryNum; i++) {

			idx = entryNum-i-1;
			snprintf(tmpBuf, 20, "select%d", idx);
			strVal = boaGetVar(wp, tmpBuf, "");

			if ( !gstrcmp(strVal, "ON") ) {
				if(mib_chain_delete(MIB_WDS_TBL, idx) != 1) {
					strcpy(tmpBuf, strDelRecordErr);
				}
				delNum++;
			}
		}
		entryNum-=delNum;
		if ( !mib_set(MIB_WLAN_WDS_NUM, (void *)&entryNum)) {
			strcpy(tmpBuf, strGetEntryNumErr);
			goto setErr_wds;
		}
		if (delNum <= 0) {
			strcpy(tmpBuf, "There is no item selected to delete!");
			goto setErr_wds;
		}
	}

	/* Delete all entry */
	if ( strDelAllMac[0]) {
		mib_chain_clear(MIB_WDS_TBL); /* clear chain record */

		entryNum=0;
		if ( !mib_set(MIB_WLAN_WDS_NUM, (void *)&entryNum)) {
			strcpy(tmpBuf, strGetEntryNumErr);
			goto setErr_wds;
		}

	}

setWds_ret:
	config_WLAN(ACT_RESTART, CONFIG_SSID_ALL);
// Magician: Commit immediately
#ifdef COMMIT_IMMEDIATELY
	Commit();
#endif // of #if COMMIT_IMMEDIATELY

#ifndef NO_ACTION
	run_script(-1);
#endif

	submitUrl = boaGetVar(wp, "submit-url", "");   // hidden page
	OK_MSG( submitUrl );
	return;

setErr_wds:
	ERR_MSG(tmpBuf);
}

void formWdsEncrypt(request * wp, char *path, char *query)
{
	char *strVal, *submitUrl;
	unsigned char tmpBuf[100];
	unsigned char encrypt;
	unsigned char intVal, keyLen=0, oldFormat, oldPskLen, len, i;
	char charArray[16]={'0' ,'1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
	char key[100];
	char varName[20];
	sprintf(varName, "encrypt%d", wlan_idx);
	strVal = boaGetVar(wp, varName, "");
	if (strVal[0]) {
		encrypt = strVal[0] - '0';
		if (encrypt != WDS_ENCRYPT_DISABLED && encrypt != WDS_ENCRYPT_WEP64 &&
			encrypt != WDS_ENCRYPT_WEP128 && encrypt != WDS_ENCRYPT_TKIP &&
				encrypt != WDS_ENCRYPT_AES) {
			strcpy(tmpBuf, "encrypt value not validt!");
			goto setErr_wdsEncrypt;
		}
		if ( !mib_set(MIB_WLAN_WDS_ENCRYPT, (void *)&encrypt)) {
			strcpy(tmpBuf, strGetEntryNumErr);
			goto setErr_wdsEncrypt;
		}
	}
	else{
		if ( !mib_get_s(MIB_WLAN_WDS_ENCRYPT, (void *)&encrypt, sizeof(encrypt))) {
			strcpy(tmpBuf, strGetEntryNumErr);
			goto setErr_wdsEncrypt;
		}
	}
	if (encrypt == WDS_ENCRYPT_WEP64 || encrypt == WDS_ENCRYPT_WEP128) {
		sprintf(varName, "format%d", wlan_idx);
		strVal = boaGetVar(wp, varName, "");
		if (strVal[0]) {
			if (strVal[0]!='0' && strVal[0]!='1') {
				strcpy(tmpBuf, "Invalid wep key format value!");
				goto setErr_wdsEncrypt;
			}
			intVal = strVal[0] - '0';
			if ( !mib_set(MIB_WLAN_WDS_WEP_FORMAT, (void *)&intVal)) {
				strcpy(tmpBuf, strGetEntryNumErr);
				goto setErr_wdsEncrypt;
			}
		}
		else{
			if ( !mib_get_s(MIB_WLAN_WDS_WEP_FORMAT, (void *)&intVal, sizeof(intVal))) {
				strcpy(tmpBuf, strGetEntryNumErr);
				goto setErr_wdsEncrypt;
			}
		}
		if (encrypt == WDS_ENCRYPT_WEP64)
			keyLen = WEP64_KEY_LEN;
		else if (encrypt == WDS_ENCRYPT_WEP128)
			keyLen = WEP128_KEY_LEN;
		if (intVal == 1) // hex
			keyLen <<= 1;
		sprintf(varName, "wepKey%d", wlan_idx);
		strVal = boaGetVar(wp, varName, "");
		if(strVal[0]) {
			if (strlen(strVal) != keyLen) {
				strcpy(tmpBuf, "Invalid wep key length!");
				goto setErr_wdsEncrypt;
			}
			if ( !isAllStar(strVal) ) {
				if (intVal == 0) { // ascii
					for (i=0; i<keyLen; i++) {
						key[i*2] = charArray[(strVal[i]>>4)&0xf];
						key[i*2+1] = charArray[strVal[i]&0xf];
					}
					key[i*2] = '\0';
				}
				else  // hex
					strcpy(key, strVal);
				if ( !mib_set(MIB_WLAN_WDS_WEP_KEY, (void *)key)) {
					strcpy(tmpBuf, strGetEntryNumErr);
					goto setErr_wdsEncrypt;
				}
			}
		}
	}
	if (encrypt == WDS_ENCRYPT_TKIP || encrypt == WDS_ENCRYPT_AES) {
		sprintf(varName, "pskFormat%d", wlan_idx);
		strVal = boaGetVar(wp, varName, "");
		if (strVal[0]) {
			if (strVal[0]!='0' && strVal[0]!='1') {
				strcpy(tmpBuf, "Invalid wep key format value!");
				goto setErr_wdsEncrypt;
			}
			intVal = strVal[0] - '0';
		}
		else{
			if ( !mib_get_s(MIB_WLAN_WDS_PSK_FORMAT, (void *)&intVal, sizeof(intVal))) {
				strcpy(tmpBuf, strGetEntryNumErr);
				goto setErr_wdsEncrypt;
			}
		}
		if ( !mib_get_s(MIB_WLAN_WDS_PSK_FORMAT, (void *)&oldFormat, sizeof(oldFormat))) {
			strcpy(tmpBuf, strGetEntryNumErr);
			goto setErr_wdsEncrypt;
		}
		if ( !mib_get_s(MIB_WLAN_WDS_PSK, (void *)tmpBuf, sizeof(tmpBuf))) {
			strcpy(tmpBuf, strGetEntryNumErr);
			goto setErr_wdsEncrypt;
		}
		oldPskLen = strlen(tmpBuf);
		sprintf(varName, "pskValue%d", wlan_idx);
		strVal = boaGetVar(wp, varName, "");
		len = strlen(strVal);
		if (len > 0 && oldFormat == intVal && len == oldPskLen ) {
			for (i=0; i<len; i++) {
				if ( strVal[i] != '*' )
				break;
			}
			if (i == len)
				goto save_wdsEcrypt;
		}
		if (intVal==1) { // hex
			if (len!=MAX_PSK_LEN || !rtk_string_to_hex(strVal, tmpBuf, MAX_PSK_LEN)) {
				strcpy(tmpBuf, "Error! invalid psk value.");
				goto setErr_wdsEncrypt;
			}
		}
		else { // passphras
			if (len==0 || len > (MAX_PSK_LEN-1) ) {
				strcpy(tmpBuf, "Error! invalid psk value.");
				goto setErr_wdsEncrypt;
			}
		}
		if ( !mib_set(MIB_WLAN_WDS_PSK_FORMAT, (void *)&intVal)) {
			strcpy(tmpBuf, strGetEntryNumErr);
			goto setErr_wdsEncrypt;
		}
		if ( !mib_set(MIB_WLAN_WDS_PSK, (void *)strVal)) {
			strcpy(tmpBuf, strGetEntryNumErr);
			goto setErr_wdsEncrypt;
		}
	}
save_wdsEcrypt:
	{
		unsigned char enable = 1;
		if ( !mib_set(MIB_WLAN_WDS_ENABLED, (void *)&enable)) {
			strcpy(tmpBuf, strGetEntryNumErr);
			goto setErr_wdsEncrypt;
		}
	}
	config_WLAN(ACT_RESTART, CONFIG_SSID_ALL);
#ifdef COMMIT_IMMEDIATELY
	Commit();
#endif // of #if COMMIT_IMMEDIATELY
	submitUrl = boaGetVar(wp, "submit-url", "");   // hidden page
	OK_MSG(submitUrl);
	return;
setErr_wdsEncrypt:
	ERR_MSG(tmpBuf);
}

/////////////////////////////////////////////////////////////////////////////
int wlWdsList(int eid, request * wp, int argc, char **argv)
{
	int nBytesSent=0, i;
	WDS_T entry;
	char tmpBuf[100];
	char txrate[20];
	unsigned char entryNum;
	WDS_T Entry;
	int rateid = 0;

	if ( !mib_get_s(MIB_WLAN_WDS_NUM, (void *)&entryNum, sizeof(entryNum))) {
  		boaError(wp, 400, "Get table entry error!\n");
		return -1;
	}
//modified by xl_yue
	nBytesSent += boaWrite(wp, "<tr>"
      	"<td align=center width=\"20%%\" bgcolor=\"#808080\"><font size=\"2\"><b>%s</b></font></td>\n"
      	"<td align=center width=\"45%%\" bgcolor=\"#808080\"><font size=\"2\"><b>%s</b></font></td>\n"
      	"<td align=center width=\"25%%\" bgcolor=\"#808080\"><font size=\"2\"><b>Tx Rate (Mbps)</b></font></td>\n"
      	"<td align=center width=\"35%%\" bgcolor=\"#808080\"><font size=\"2\"><b>%s</b></font></td></tr>\n",
	multilang_bpas(strSelect), multilang_bpas(strMACAddr), multilang_bpas(strWdsComment));

	for (i=0; i<entryNum; i++) {
		*((char *)&entry) = (char)i;
		if (!mib_chain_get(MIB_WDS_TBL, i, (void *)&Entry)) {
  			boaError(wp, 400, errGetEntry);
			return -1;
		}
		snprintf(tmpBuf, 100, "%02x:%02x:%02x:%02x:%02x:%02x",
			Entry.macAddr[0], Entry.macAddr[1], Entry.macAddr[2],
			Entry.macAddr[3], Entry.macAddr[4], Entry.macAddr[5]);

		//strcpy(txrate, "N/A");
		if(Entry.fixedTxRate == 0){
			sprintf(txrate, "%s","Auto");
		}
		else{
			for(rateid=0; rateid<28;rateid++){
				if(tx_fixed_rate[rateid].id == Entry.fixedTxRate){
					sprintf(txrate, "%s", tx_fixed_rate[rateid].rate);
					break;
				}
			}
		}

		nBytesSent += boaWrite(wp, "<tr>"
			"<td align=center width=\"20%%\" bgcolor=\"#C0C0C0\"><input type=\"checkbox\" name=\"select%d\" value=\"ON\"></td>\n"
			"<td align=center width=\"45%%\" bgcolor=\"#C0C0C0\"><font size=\"2\">%s</td>\n"
			"<td align=center width=\"25%%\" bgcolor=\"#C0C0C0\"><font size=\"2\">%s</td>\n"
			"<td align=center width=\"35%%\" bgcolor=\"#C0C0C0\"><font size=\"2\">%s</td></tr>\n",
			i, tmpBuf, txrate, Entry.comment);
	}
	return nBytesSent;
}

int wdsList(int eid, request * wp, int argc, char **argv)
{
	int nBytesSent=0, i;
	WDS_INFO_Tp pInfo;
	char *buff;

	buff = calloc(1, sizeof(WDS_INFO_T)*MAX_WDS_NUM);
	if ( buff == 0 ) {
		printf("Allocate buffer failed!\n");
		return 0;
	}

	if ( getWdsInfo(getWlanIfName(), buff) < 0 ) {
		printf("Read wlan sta info failed!\n");
		return 0;
	}

	for (i=0; i<MAX_WDS_NUM; i++) {
		pInfo = (WDS_INFO_Tp)&buff[i*sizeof(WDS_INFO_T)];

		if (pInfo->state == STATE_WDS_EMPTY)
			break;

		nBytesSent += boaWrite(wp,
	   		"<tr bgcolor=#b7b7b7><td><font size=2>%02x:%02x:%02x:%02x:%02x:%02x</td>"
			"<td><font size=2>%d</td>"
	     		"<td><font size=2>%d</td>"
			"<td><font size=2>%d</td>"
			"<td><font size=2>%d%s</td></tr>",
			pInfo->addr[0],pInfo->addr[1],pInfo->addr[2],pInfo->addr[3],pInfo->addr[4],pInfo->addr[5],
			pInfo->tx_packets, pInfo->tx_errors, pInfo->rx_packets,
			pInfo->txOperaRate/2, ((pInfo->txOperaRate%2) ? ".5" : "" ));
	}

	free(buff);

	return nBytesSent;
}
#endif // WLAN_WDS

#ifdef CONFIG_WIFI_SIMPLE_CONFIG // WPS
//#define WLAN_IF  "wlan0"

#define OK_MSG2(msg, msg1, url) { \
        char tmp[200]; \
        snprintf(tmp, sizeof(tmp), msg, msg1); \
        OK_MSG1(tmp, url); \
}
#define START_PBC_MSG \
        "Start PBC successfully!<br><br>" \
        "You have to run Wi-Fi Protected Setup in %s within 2 minutes."
#define START_PIN_MSG \
        "Start PIN successfully!<br><br>" \
        "You have to run Wi-Fi Protected Setup in %s within 2 minutes."
#define SET_PIN_MSG \
        "Applied client's PIN successfully!<br><br>" \
        "You have to run Wi-Fi Protected Setup in client within 2 minutes."
/*for WPS2DOTX brute force attack , unlock*/
#define UNLOCK_MSG \
	"Applied %s WPS unlock successfully!<br>"

void formWsc(request * wp, char *path, char *query)
{
	char *strVal, *submitUrl;
	char intVal;
	char tmpbuf[200];
//	int mode;
	unsigned char mode;
	MIB_CE_MBSSIB_T Entry;


#if defined(WLAN_DUALBAND_CONCURRENT)
	strVal = boaGetVar(wp, "wlan_idx", "");
	if ( strVal[0] ) {
		printf("wlan_idx=%d\n", strVal[0]-'0');
		wlan_idx = strVal[0]-'0';
	}
#endif //WLAN_DUALBAND_CONCURRENT
	wlan_getEntry((void *)&Entry, 0);
	mode = Entry.wlanMode;
	submitUrl = boaGetVar(wp, "submit-url", "");
#ifdef CONFIG_WIFI_SIMPLE_CONFIG
	// for PIN brute force attack
	strVal = boaGetVar(wp, "unlockautolockdown", "");
	if (strVal[0]) {
		va_niced_cmd(WSC_DAEMON_PROG, 1, 1, "-sig_unlock");
		OK_MSG2(UNLOCK_MSG, ((mode==AP_MODE) ? "client" : "AP"), submitUrl);
		return;
	}

	strVal = boaGetVar(wp, "triggerPBC", "");
	if (strVal[0]) {
		if (Entry.wsc_disabled) {
			Entry.wsc_disabled = 0;
			wlan_setEntry((void *)&Entry, 0);
			mib_update(CURRENT_SETTING, CONFIG_MIB_ALL);	// update to flash
			system("echo 1 > /var/wps_start_pbc");
#ifndef NO_ACTION
			run_init_script("bridge");
#endif
		}
		else {
			//sprintf(tmpbuf, "%s -sig_pbc", WSC_DAEMON_PROG);
			//system(tmpbuf);
			//va_niced_cmd(WSC_DAEMON_PROG, 1, 1, "-sig_pbc");
			if(wlan_idx == 0 )
			{
				system("echo 1 > /var/wps_start_interface0");
			}
			else
			{
				system("echo 1 > /var/wps_start_interface1");

			}
			va_niced_cmd(WSC_DAEMON_PROG, 2 , 1 , "-sig_pbc" , getWlanIfName());
		}
		OK_MSG2(START_PBC_MSG, ((mode==AP_MODE) ? "client" : "AP"), submitUrl);
		return;
	}

	strVal = boaGetVar(wp, "triggerPIN", "");
	if (strVal[0]) {
		int local_pin_changed = 0;
		strVal = boaGetVar(wp, "localPin", "");
		if (strVal[0]) {
			if(CheckPINCode_s(strVal)) {
				return;
			}
			mib_get_s(MIB_WSC_PIN, (void *)tmpbuf, sizeof(tmpbuf));
			if (strcmp(tmpbuf, strVal)) {
				mib_set(MIB_WSC_PIN, (void *)strVal);
				local_pin_changed = 1;
			}
		}
		if (Entry.wsc_disabled) {
			char localpin[100];
			Entry.wsc_disabled = 0;
			wlan_setEntry((void *)&Entry, 0);
			mib_update(CURRENT_SETTING, CONFIG_MIB_ALL);	// update to flash
			system("echo 1 > /var/wps_start_pin");

#ifndef NO_ACTION
			if (local_pin_changed) {
				mib_get_s(MIB_WSC_PIN, (void *)localpin, sizeof(localpin));
				snprintf(tmpbuf, sizeof(tmpbuf), "echo %s > /var/wps_local_pin", localpin);
				system(tmpbuf);
			}
			run_init_script("bridge");
#endif
		}
		else {
			if (local_pin_changed) {
				system("echo 1 > /var/wps_start_pin");

				mib_update(CURRENT_SETTING,CONFIG_MIB_ALL);
				//run_init_script("bridge");
			}
			else {
				va_niced_cmd(WSC_DAEMON_PROG, 1, 0, "-sig_start");
			}
		}
		OK_MSG2(START_PIN_MSG, ((mode==AP_MODE) ? "client" : "AP"), submitUrl);
		return;
	}

	strVal = boaGetVar(wp, "setPIN", "");
	if (strVal[0]) {
		strVal = boaGetVar(wp, "peerPin", "");
		if (strVal[0]) {
			if(CheckPINCode_s(strVal)) {
				return;
			}
			if (Entry.wsc_disabled) {
				Entry.wsc_disabled = 0;
				wlan_setEntry((void *)&Entry, 0);
				mib_update(CURRENT_SETTING, CONFIG_MIB_ALL);

				snprintf(tmpbuf, sizeof(tmpbuf), "echo %s > /var/wps_peer_pin", strVal);
				system(tmpbuf);

#ifndef NO_ACTION
				run_init_script("bridge");
#endif
			}
			else {
				//sprintf(tmpbuf, "iwpriv %s set_mib pin=%s", WLAN_IF, strVal);
				//system(tmpbuf);
				if(wlan_idx == 0 )
				{
					system("echo 1 > /var/wps_start_interface0");
				}
				else
				{
					system("echo 1 > /var/wps_start_interface1");
				}
				snprintf(tmpbuf, sizeof(tmpbuf), "pin=%s", strVal);
				va_cmd("/bin/iwpriv", 3, 1, getWlanIfName(), "set_mib", tmpbuf);
			}
			OK_MSG1(SET_PIN_MSG, submitUrl);
			return;
		}
	}

	strVal = boaGetVar(wp, "disableWPS", "");
	if ( !gstrcmp(strVal, "ON"))
		intVal = 1;
	else
		intVal = 0;
	Entry.wsc_disabled = intVal;
	wlan_setEntry((void *)&Entry, 0);
	update_wps_mib();

	strVal = boaGetVar(wp, "localPin", "");
	if (strVal[0]){
		if(CheckPINCode_s(strVal)) {
			return;
		}
		mib_set(MIB_WSC_PIN, (void *)strVal);
	}
#endif
//	update_wps_configured(0);
	config_WLAN(ACT_RESTART, CONFIG_SSID_ALL);

#ifdef COMMIT_IMMEDIATELY
	Commit();
#endif // of #if COMMIT_IMMEDIATELY

#ifndef NO_ACTION
	run_init_script("bridge");
#endif

	OK_MSG(submitUrl);
}
#endif

#ifdef CONFIG_RTL_CFG80211_WAPI_SUPPORT
void formWapiMode(request * wp, char *path, char *query){
	char *str_mode, *submitUrl;
	char tmpBuf[100];
	unsigned char tmp_mode, pre_mode;

	str_mode = boaGetVar(wp, "wapimode", "");
	if(str_mode[0]){
		tmp_mode = str_mode[0] - '0';
		mib_get_s(MIB_WAPI_CERT_COUNT, (void *)&pre_mode, sizeof(pre_mode));
		if (tmp_mode != pre_mode){
			if ( mib_set(MIB_WAPI_CERT_COUNT, (void *)&tmp_mode) == 0) {
  				memset(tmpBuf, 0, sizeof(tmpBuf));
				snprintf(tmpBuf,sizeof(tmpBuf),"%s", "Set wapi mode to mib error!");
				goto setErr_wapimode;
			}
#ifdef COMMIT_IMMEDIATELY
			Commit();
#endif
		}
	}else{
		memset(tmpBuf, 0, sizeof(tmpBuf));
		snprintf(tmpBuf,sizeof(tmpBuf),"%s", "Wapi mode is error!");
		goto setErr_wapimode;
	}
	submitUrl = boaGetVar(wp, "submit-url", "");   // hidden page
	OK_MSG3( submitUrl );
  	return;

setErr_wapimode:
	ERR_MSG(tmpBuf);
}

FILE *GetWapiInstallCert(request *wp, unsigned int *startPos, unsigned *endPos)
{
	FILE *fp=NULL;
	struct stat statbuf;
	unsigned char *buf;
	int c;
	char boundary[80];

	printf("%s(%d): ==GetWapiInstallCert===\n", __FUNCTION__,__LINE__);
	if (wp->method == M_POST)
	{
		int i;

		fstat(wp->post_data_fd, &statbuf);
		lseek(wp->post_data_fd, SEEK_SET, 0);

		fp=fopen(wp->post_file_name, "rb");
		if(fp==NULL) goto error;

		memset(boundary, 0, sizeof(boundary));
		if( fgets(boundary, 80, fp)==NULL ) goto error;
		if( boundary[0]!='-' || boundary[1]!='-') goto error;

		i= strlen( boundary ) - 1;
		while( boundary[i]=='\r' || boundary[i]=='\n' )
		{
			boundary[i]='\0';
			i--;
		}
	}
	else {
		printf("No M_POST.\n");
		goto error;
	}

	printf("_uploadGet\n");

	do
	{
		if(feof(fp))
		{
			printf("Cannot find start of file.\n");
			goto error;
		}
		c= fgetc(fp);
		if (c!=0xd)
			continue;
		c= fgetc(fp);
		if (c!=0xa)
			continue;
		c= fgetc(fp);
		if (c!=0xd)
			continue;
		c= fgetc(fp);
		if (c!=0xa)
			continue;
		break;
	}while(1);
	(*startPos)=ftell(fp);

	do
	{
		if(feof(fp))
		{
			printf("Cannot find end of file.\n");
			goto error;
		}
		c= fgetc(fp);
		if (c!=0xd)
			continue;
		c= fgetc(fp);
		if (c!=0xa)
			continue;

		{
			int i, blen;

			blen= strlen( boundary );
			for( i=0; i<blen; i++)
			{
				c= fgetc(fp);
				//printf("%c(%u)", c, c);
				if (c!=boundary[i])
				{
					ungetc( c, fp );
					break;
				}
			}
			//printf("\r\n");
			if( i!=blen ) continue;
		}

		break;
	}while(1);
	(*endPos)=ftell(fp)-strlen(boundary)-2;

	return fp;
error:
	return NULL;
}

static void formWapiInstallCert(request * wp, char * path, char * query,
	const char *name, const char *submitUrl){
	FILE *fp, *fp_input;
	int startPos, endPos;
	int nLen, nRead, nToRead;
	char tmpBuf[100], urlBuf[128], cmd[128];
	printf("%s(%d): ==formWapiInstallCert===\n", __FUNCTION__,__LINE__);
	if ((fp_input = GetWapiInstallCert(wp, &startPos, &endPos)) == NULL) {
		strcpy(tmpBuf, "Upload cert fail.");
		goto upload_ERR;
	}
 	printf("%s(%d): %s (%d,%d)\n", __FUNCTION__,__LINE__,submitUrl, startPos, endPos);
 	nLen = endPos - startPos;
	fseek(fp_input, startPos, SEEK_SET); // seek to the data star
	fp=fopen(CFG80211_WAPI_TEMP_CERT,"w");
	if(NULL == fp)
	{
		strcpy(tmpBuf, "Can't open file.");
		goto upload_ERR;
	}
	printf("%s(%d): == copy startPos - endPost to tmp file ===\n", __FUNCTION__,__LINE__);
	/* copy startPos - endPost to tmp file */
	memset(tmpBuf, 0, sizeof(tmpBuf));
	nToRead = nLen;
	do {
		nRead = nToRead > sizeof(tmpBuf) ? sizeof(tmpBuf) : nToRead;

		nRead = fread(tmpBuf, 1, nRead, fp_input);
		fwrite(tmpBuf, 1, nRead, fp);
		nToRead -= nRead;
	} while (nRead > 0);

	fclose(fp);
	fclose(fp_input);
	printf("%s(%d): == copy tmp to %s file ===\n", __FUNCTION__,__LINE__,name);
	strcpy(cmd, "cp ");
	strcat(cmd, CFG80211_WAPI_TEMP_CERT);
	strcat(cmd, " ");
	strcat(cmd, name);
	system(cmd);

	strcpy(cmd, "rm -rf ");
	strcat(cmd, CFG80211_WAPI_TEMP_CERT);
	system(cmd);

	//config_WLAN(ACT_RESTART, CONFIG_SSID_ALL);
	printf("Certification install success.\n");
	snprintf(urlBuf, sizeof(urlBuf),"%s", submitUrl);
	OK_MSG(urlBuf);
	return;
upload_ERR:
	ERR_MSG(tmpBuf);
}

// for ap and client
void formWapiInstallCert0(request * wp, char *path, char *query){
	printf("%s(%d): ==formWapiInstallCert0===\n", __FUNCTION__,__LINE__);
	formWapiInstallCert(wp, path, query, CFG80211_WAPI_CA_CERT, "/net_wlan_wapiinstallcert.asp");
}

// for ap and client
void formWapiInstallCert1(request * wp, char *path, char *query){
	printf("%s(%d): ==formWapiInstallCert1===\n", __FUNCTION__,__LINE__);
	formWapiInstallCert(wp, path, query, CFG80211_WAPI_ASU_CERT, "/net_wlan_wapiinstallcert.asp");
}

// for ap
void formWapiInstallCert2(request * wp, char *path, char *query){
	printf("%s(%d): ==formWapiInstallCert2===\n", __FUNCTION__,__LINE__);
	formWapiInstallCert(wp, path, query, CFG80211_WAPI_USER_CERT, "/net_wlan_wapiinstallcert.asp");
}

// for client
void formWapiInstallCert3(request * wp, char *path, char *query){
	printf("%s(%d): ==formWapiInstallCert3===\n", __FUNCTION__,__LINE__);
	formWapiInstallCert(wp, path, query, CFG80211_WAPI_ASUE_CERT, "/net_wlan_wapiinstallcert.asp");
}
#endif

int wlStatsList(int eid, request * wp, int argc, char **argv)
{
	int i, intf_num = 0, orig_wlan_idx;
	char ssid[MAX_SSID_LEN];
	struct net_device_stats nds;
	MIB_CE_MBSSIB_T entry;
#ifdef WLAN_MBSSID
	int j;
	char vapname[16];
#endif
	char translate_web_str[200]={0};
	unsigned char wlan_module_disabled;
#if defined(CONFIG_USER_RTK_REPEATER_MODE) && defined(WLAN_UNIVERSAL_REPEATER)
	unsigned char phyBandSelect;
#endif
	int ret = 0;
	//_TRACE_CALL;

//	if (!wlan_is_up()) {
//		return -1;
//	}
#ifndef YUEME_3_0_SPEC
	mib_get_s(MIB_WIFI_MODULE_DISABLED, (void *)&wlan_module_disabled, sizeof(wlan_module_disabled));
	if(wlan_module_disabled==1)
		return -1;
#endif

	orig_wlan_idx = wlan_idx;

	//process each wlan interface
	for (i = 0; i < NUM_WLAN_INTERFACE; i++) {
		wlan_idx = i;
#ifdef YUEME_3_0_SPEC
		mib_get_s(MIB_WLAN_MODULE_DISABLED, (void *)&wlan_module_disabled, sizeof(wlan_module_disabled));
		if(wlan_module_disabled==1)
			continue;
#endif
#if 0
		if (!entry.wlanDisabled && getInFlags(getWlanIfName(), 0)) {
		get_wlan_net_device_stats(getWlanIfName(), &nds);
		boaWrite(wp, "rcs.push(new it_nr(\"%d\""
			 _PTS _PTULL _PTULL
			 _PTULL _PTULL _PTULL
			 _PTULL _PTULL _PTULL "));\n",
			 intf_num, "ifname", entry.ssid,
			 "rx_packets", nds.rx_packets,
			 "rx_bytes", nds.rx_bytes,
			 "rx_errors", nds.rx_errors,
			 "rx_dropped", nds.rx_dropped,
			 "tx_packets", nds.tx_packets,
			 "tx_bytes", nds.tx_bytes,
			 "tx_errors", nds.tx_errors,
			 "tx_dropped", nds.tx_dropped);
		intf_num++;
		}
#endif

//#ifdef WLAN_MBSSID
		/* append wlan0-vapX to names if not disabled */
#if defined(CONFIG_USER_RTK_REPEATER_MODE) && defined(WLAN_UNIVERSAL_REPEATER)
		for (j = 0; j <= WLAN_REPEATER_ITF_INDEX; j++)
#else
		for (j = 0; j < WLAN_SSID_NUM; j++) 
#endif
		{
#if defined(CONFIG_USER_RTK_REPEATER_MODE) && defined(WLAN_UNIVERSAL_REPEATER)
			if(j>=WLAN_SSID_NUM && j<WLAN_REPEATER_ITF_INDEX)
				continue; 
#endif
			mib_chain_get(MIB_MBSSIB_TBL, j, &entry);
			if (entry.wlanDisabled) {
				continue;
			}
			rtk_wlan_get_ifname(i, j, vapname);
			//sprintf(vapname, "%s-vap%d", getWlanIfName(), j);
			if(getInFlags(vapname, 0)==0)
				continue;
			ret = get_wlan_net_device_stats(vapname, &nds);
			if (ret < 0) {
				memset(&nds, 0, sizeof(nds));
				printf("%s(%d): get_net_device_stats nds faild!\n", __FUNCTION__,__LINE__);
				continue;
			}
			strcpy(translate_web_str, entry.ssid);
			translate_javascript_code(translate_web_str);
#if defined(CONFIG_USER_RTK_REPEATER_MODE) && defined(WLAN_UNIVERSAL_REPEATER)
			if(strstr(vapname, "-vxd")){
				memset(translate_web_str, 0, sizeof(translate_web_str));
				mib_get_s(MIB_WLAN_PHY_BAND_SELECT, &phyBandSelect, sizeof(phyBandSelect));
				if(phyBandSelect==PHYBAND_2G)
					strcpy(translate_web_str, "2.4G中继");
				else if(phyBandSelect==PHYBAND_5G)
					strcpy(translate_web_str, "5G中继");
			}
#endif
			boaWrite(wp, "rcs.push(new it_nr(\"%d\""
				 _PTS_XSS _PTULL _PTULL
				 _PTULL _PTULL _PTULL
				 _PTULL _PTULL _PTULL "));\n",
				 intf_num, "ifname", strValToASP(translate_web_str),
				 "rx_packets", nds.rx_packets,
				 "rx_bytes", nds.rx_bytes,
				 "rx_errors", nds.rx_errors,
				 "rx_dropped", nds.rx_dropped,
				 "tx_packets", nds.tx_packets,
				 "tx_bytes", nds.tx_bytes,
				 "tx_errors", nds.tx_errors,
				 "tx_dropped", nds.tx_dropped);
			intf_num++;
		}
//#endif
	}
	wlan_idx = orig_wlan_idx;
check_err:
	//_TRACE_LEAVEL;
	return 0;
}
#ifdef WIFI_TIMER_SCHEDULE
/////////////////////////////////////////////////////////////////////////////
void formWifiTimerEx(request * wp, char *path, char *query)
{
	char *strVal, *strVal2, *submitUrl;
	char tmpBuf[100];
	unsigned char vChar;
	int i, val, action;
	MIB_CE_WIFI_TIMER_EX_T Entry;

	strVal  = boaGetVar(wp, "action", "");
	if(strVal[0]){
		action = strVal[0] - '0';
	}
	else
		goto setErr_wlsched;

	if(!action){
		strVal  = boaGetVar(wp, "if_index", "");
		if (!strVal[0]) 
			goto setErr_wlsched;
		vChar = strVal[0] - '0';
		if(mib_chain_delete(MIB_WIFI_TIMER_EX_TBL, vChar) == 0){
			goto setErr_wlsched;
		}
		goto setwlsched_ret;
	}
	else{
		if(action == 2){
			
			strVal  = boaGetVar(wp, "if_index", "");
			if (!strVal[0]) {
				goto setErr_wlsched;
			}
			i = strVal[0] - '0';
		}

		strVal = boaGetVar(wp, "Fnt_Active", "");

		if ( !gstrcmp(strVal, "ON") )
			Entry.enable = 1;
		else
			Entry.enable = 0;

		strVal = boaGetVar(wp, "Fnt_Enable", "");
		if (!strVal[0]) {
			goto setErr_wlsched;
		}

		Entry.onoff = strVal[0] - '0';

		strVal = boaGetVar(wp, "Frm_Start1", "");
		if (!strVal[0]) {
			goto setErr_wlsched;
		}

		strVal2 = boaGetVar(wp, "Frm_Start2", "");
		if (!strVal2[0]) {
			goto setErr_wlsched;
		}

		snprintf(Entry.Time, 6,"%s:%s", strVal, strVal2);

		vChar = 0;
		strVal  = boaGetVar(wp, "Frm_Monday_S", "");
		if ( !gstrcmp(strVal, "ON") )
			vChar |=(1<<1);
		strVal  = boaGetVar(wp, "Frm_Tuesday_S", "");
		if ( !gstrcmp(strVal, "ON") )
			vChar |=(1<<2);
		strVal  = boaGetVar(wp, "Frm_Wednesday_S", "");
		if ( !gstrcmp(strVal, "ON") )
			vChar |=(1<<3);
		strVal  = boaGetVar(wp, "Frm_Thursday_S", "");
		if ( !gstrcmp(strVal, "ON") )
			vChar |=(1<<4);
		strVal  = boaGetVar(wp, "Frm_Friday_S", "");
		if ( !gstrcmp(strVal, "ON") )
			vChar |=(1<<5);
		strVal  = boaGetVar(wp, "Frm_Saturday_S", "");
		if ( !gstrcmp(strVal, "ON") )
			vChar |=(1<<6);
		strVal  = boaGetVar(wp, "Frm_Sunday_S", "");
		if ( !gstrcmp(strVal, "ON") )
			vChar |=(1<<7);

		Entry.day = vChar;

		strVal = boaGetVar(wp, "ssid_mask", "");
		if (!strVal[0]) {
			goto setwlsched_ret;
		}
		Entry.SSIDMask = atoi(strVal);

		if(action == 2){
			if(mib_chain_update(MIB_WIFI_TIMER_EX_TBL, &Entry, i) == 0){
				goto setErr_wlsched;
			}
		}
		else{
			if(mib_chain_add(MIB_WIFI_TIMER_EX_TBL, &Entry) == 0){
				goto setErr_wlsched;
			}
		}
		goto setwlsched_ret;
	}

setwlsched_ret:
	
// Magician: Commit immediately
#ifdef COMMIT_IMMEDIATELY
	Commit();
#endif // of #if COMMIT_IMMEDIATELY

#ifndef NO_ACTION
	run_script(-1);
#endif

	updateScheduleCrondFile("/var/spool/cron/crontabs", 0);

	submitUrl = boaGetVar(wp, "submit-url", "");   // hidden page
	//OK_MSG( submitUrl );
	if (submitUrl[0])
		boaRedirect(wp, submitUrl);
	else
		boaDone(wp, 200);
  	return;

setErr_wlsched:
	ERR_MSG(tmpBuf);
}

/////////////////////////////////////////////////////////////////////////////
void formWifiTimer(request * wp, char *path, char *query)
{
	char *strVal, *strVal2, *submitUrl;
	char tmpBuf[100];
	char vChar;
	int i, val, action;
	MIB_CE_WIFI_TIMER_T Entry;

	strVal  = boaGetVar(wp, "action", "");
	if(strVal[0]){
		action = strVal[0] - '0';
	}
	else
		goto setErr_wltimer;

	if(!action){
		strVal  = boaGetVar(wp, "if_index", "");
		if (!strVal[0]) 
			goto setErr_wltimer;
		vChar = strVal[0] - '0';
		if(mib_chain_delete(MIB_WIFI_TIMER_TBL, vChar) == 0){
			goto setErr_wltimer;
		}
		goto setwlsched_ret;
	}
	else{
		if(action == 2){
			
			strVal  = boaGetVar(wp, "if_index", "");
			if (!strVal[0]) {
				goto setErr_wltimer;
			}
			i = strVal[0] - '0';
		}

		strVal = boaGetVar(wp, "Fnt_Active", "");

		if ( !gstrcmp(strVal, "ON") )
			Entry.enable = 1;
		else
			Entry.enable = 0;

		strVal = boaGetVar(wp, "Frm_Start1", "");
		if (!strVal[0]) {
			goto setErr_wltimer;
		}
		
		strVal2 = boaGetVar(wp, "Frm_Start2", "");
		if (!strVal2[0]) {
			goto setErr_wltimer;
		}

		snprintf(Entry.startTime, 6,"%02d:%02d", atoi(strVal), atoi(strVal2));

		strVal = boaGetVar(wp, "Frm_End1", "");
		if (!strVal[0]) {
			goto setErr_wltimer;
		}
		
		strVal2 = boaGetVar(wp, "Frm_End2", "");
		if (!strVal2[0]) {
			goto setErr_wltimer;
		}

		snprintf(Entry.endTime, 6,"%02d:%02d", atoi(strVal), atoi(strVal2));
#if 0
		strVal = boaGetVar(wp, "Frm_Day", "");
		if (!strVal[0]) {
			goto setErr_wltimer;
		}

		string_to_dec(strVal, &val);
		Entry.controlCycle = (unsigned char) val;	
#endif
		Entry.controlCycle = 1;

		strVal = boaGetVar(wp, "ssid_mask", "");
		if (!strVal[0]) {
			goto setErr_wltimer;
		}
		Entry.SSIDMask = atoi(strVal);

		if(action == 2){
			if(mib_chain_update(MIB_WIFI_TIMER_TBL, &Entry, i) == 0){
				goto setErr_wltimer;
			}
		}
		else{
			if(mib_chain_add(MIB_WIFI_TIMER_TBL, &Entry) == 0){
				goto setErr_wltimer;
			}
		}
		goto setwlsched_ret;
	}

setwlsched_ret:
	
// Magician: Commit immediately
#ifdef COMMIT_IMMEDIATELY
	Commit();
#endif // of #if COMMIT_IMMEDIATELY

#ifndef NO_ACTION
	run_script(-1);
#endif

	updateScheduleCrondFile("/var/spool/cron/crontabs", 0);

	submitUrl = boaGetVar(wp, "submit-url", "");   // hidden page
	//OK_MSG( submitUrl );
	if (submitUrl[0])
		boaRedirect(wp, submitUrl);
	else
		boaDone(wp, 200);
  	return;

setErr_wltimer:
	ERR_MSG(tmpBuf);
}

int ShowWifiTimerMask(int eid, request * wp, int argc, char **argv)
{
#ifdef WLAN_SUPPORT
	int i;

	int orig_wlan_idx = wlan_idx;
	int j;
#ifdef YUEME_3_0_SPEC_SSID_ALIAS
	unsigned char phyband = PHYBAND_2G;
#endif
	for(j=0; j<NUM_WLAN_INTERFACE;j++){
		wlan_idx = j;
#ifdef YUEME_3_0_SPEC_SSID_ALIAS
#ifdef WLAN_DUALBAND_CONCURRENT
		mib_get_s(MIB_WLAN_PHY_BAND_SELECT, &phyband, sizeof(phyband));
#endif
		boaWrite(wp, "<tr nowrap><td><input type=\"checkbox\" name=\"chkpt\">无线(%s-%d)</td>", phyband==PHYBAND_2G? "2.4G":"5G", 1);
#else
		boaWrite(wp, "<tr nowrap><td><input type=\"checkbox\" name=\"chkpt\">无线(SSID%d)</td>", (j*(WLAN_MBSSID_NUM+1)) + 1);
#endif
#ifdef WLAN_MBSSID
		int showNum = 0;
		MIB_CE_MBSSIB_T entry;
		for (i = 0; i < WLAN_MBSSID_NUM; i++)
		{
			mib_chain_get(MIB_MBSSIB_TBL, i + 1, &entry);

#ifdef CTCOM_WLAN_REQ
			if(entry.instnum==0){
				boaWrite(wp, "<input type=hidden name=chkpt>\n");
				continue;
			}
#endif
			showNum++;

			if (!(showNum & 0x1))
				boaWrite(wp, "<tr nowrap>");

#ifdef YUEME_3_0_SPEC_SSID_ALIAS
			boaWrite(wp, "<td><input type=\"checkbox\" name=\"chkpt\">无线(%s-%d)</td>",  phyband==PHYBAND_2G? "2.4G":"5G", (i+2));
#else
			boaWrite(wp, "<td><input type=\"checkbox\" name=\"chkpt\">无线(SSID%d)</td>", (j*(WLAN_MBSSID_NUM+1)) + (i+2));
#endif

			if ((showNum & 0x1))
				boaWrite(wp,  "</tr>\n");
		}

		if (!(showNum & 0x1))
			boaWrite(wp,  "</tr>\n");
#else
		boaWrite(wp, "</tr>\n");
		for (i = 0; i <WLAN_MBSSID_NUM; i++)
			boaWrite(wp, "<input type=hidden name=chkpt>\n");
#endif
	}
	wlan_idx = orig_wlan_idx;
#ifndef WLAN_DUALBAND_CONCURRENT
	for(i=0; i<(1+WLAN_MBSSID_NUM); i++)
		boaWrite(wp, "<input type=hidden name=chkpt>\n");
#endif
#endif
}

#endif

#ifdef WLAN_11R
#ifndef WLAN_11R_HAPD
extern char FT_DAEMON_PROG[];
#endif
void formFt(request * wp, char *path, char *query)
{
	char *strVal, *submitUrl;
	char tmpbuf[200];
	MIB_CE_MBSSIB_T Entry;
	MIB_CE_WLAN_FTKH_T khEntry, getEntry;
	int idx, i, entryNum, intVal, deleted=0;

	submitUrl = boaGetVar(wp, "submit-url", "");
#if defined(WLAN_DUALBAND_CONCURRENT)
	strVal = boaGetVar(wp, "wlan_idx", "");
	if ( strVal[0] ) {
		printf("wlan_idx=%d\n", strVal[0]-'0');
		wlan_idx = strVal[0]-'0';
	}
#endif //WLAN_DUALBAND_CONCURRENT

	// check which interface is selected
	strVal = boaGetVar(wp, "ftSSID", "");
	if (strVal[0]) {
		idx = strVal[0]-'0';
		if (idx<0 || idx > NUM_VWLAN_INTERFACE) {
			strcpy(tmpbuf, strNotSuptSSIDType);
			goto setErr_ft;
		}
	} else {
		strcpy(tmpbuf, strNoSSIDTypeErr);
		goto setErr_ft;
	}

	if (!wlan_getEntry((void *)&Entry, idx)) {
		strcpy(tmpbuf, strGetMBSSIBTBLErr);
		goto setErr_ft;
	}

	// for driver configurateion
	strVal = boaGetVar(wp, "ftSaveConfig", "");
	if (strVal[0]) {
		// 802.11r related settings
		strVal = boaGetVar(wp, "ft_enable", "");
		if (strVal[0])
			Entry.ft_enable = atoi(strVal);

		strVal = boaGetVar(wp, "ft_mdid", "");
		if (strVal[0])
			strncpy(Entry.ft_mdid, strVal, 4);

		strVal = boaGetVar(wp, "ft_over_ds", "");
		if (strVal[0])
			Entry.ft_over_ds = atoi(strVal);

		strVal = boaGetVar(wp, "ft_res_request", "");
		if (strVal[0])
			Entry.ft_res_request = atoi(strVal);

		strVal = boaGetVar(wp, "ft_r0key_timeout", "");
		if (strVal[0])
			Entry.ft_r0key_timeout = atoi(strVal);

		strVal = boaGetVar(wp, "ft_reasoc_timeout", "");
		if (strVal[0])
			Entry.ft_reasoc_timeout = atoi(strVal);

		strVal = boaGetVar(wp, "ft_r0kh_id", "");
		if (strVal[0])
			strncpy(Entry.ft_r0kh_id, strVal, 48);

		strVal = boaGetVar(wp, "ft_push", "");
		if (strVal[0])
			Entry.ft_push = atoi(strVal);

		// save changes
		wlan_setEntry(&Entry, idx);
		mib_chain_update(MIB_MBSSIB_TBL, (void *)&Entry, idx);
#ifndef WLAN_11R_HAPD
		config_WLAN(ACT_RESTART, CONFIG_SSID_ALL);
#endif
		goto setOk_ft;
	}

	// for R0KH/R1KH configuration
	/* Add entry */
	strVal = boaGetVar(wp, "ftAddKH", "");
	if (strVal[0]) {
		if ( Entry.ft_kh_num >= MAX_VWLAN_FTKH_NUM ) {
			strcpy(tmpbuf, strAddAcErrForFull);
			goto setErr_ft;
		}

		memset(&khEntry, 0, sizeof(khEntry));
		strVal = boaGetVar(wp, "kh_mac", "");
		if (!strVal[0]) {
			strcpy(tmpbuf, "错误 ! 设置没有 mac 地址。");
			goto setErr_ft;
		}
		if (strlen(strVal)!=12 || !rtk_string_to_hex(strVal, khEntry.addr, 12)) {
			strcpy(tmpbuf, strInvdMACAddr);
			goto setErr_ft;
		}
		if (!isValidMacAddr(khEntry.addr)) {
			strcpy(tmpbuf, strInvdMACAddr);
			goto setErr_ft;
		}
		khEntry.wlanIdx = wlan_idx;
		khEntry.intfIdx = idx;

		strVal = boaGetVar(wp, "kh_nas_id", "");
		if (!strVal[0]) {
			strcpy(tmpbuf, "无效的 NAS 标识符 (1 ~ 48 个字符)");
			goto setErr_ft;
		}
		strncpy(khEntry.r0kh_id, strVal, 48);

		strVal = boaGetVar(wp, "kh_kek", "");
		if (!strVal[0]) {
			strcpy(tmpbuf, "错误! 没有设定 R0KH/R1KH 的值");
			goto setErr_ft;
		}
		strncpy(khEntry.key, strVal, 32);

		entryNum = mib_chain_total(MIB_WLAN_FTKH_TBL);

		// set to MIB. Check if entry exists
		for (i=0; i<entryNum; i++) {
			if (!mib_chain_get(MIB_WLAN_FTKH_TBL, i, (void *)&getEntry))
			{
	  			strcpy(tmpbuf, strGetChainerror);
				goto setErr_ft;
			}
			if (!memcmp(khEntry.addr, getEntry.addr, 6) && khEntry.intfIdx==getEntry.intfIdx)
			{
				strcpy(tmpbuf, strMACInList);
				goto setErr_ft;
			}
		}

		// add new KH entry
		intVal = mib_chain_add(MIB_WLAN_FTKH_TBL, (unsigned char *)&khEntry);
		if (intVal == 0) {
			strcpy(tmpbuf, strAddListErr);
			goto setErr_ft;
		}
		else if (intVal == -1) {
			strcpy(tmpbuf, strTableFull);
			goto setErr_ft;
		}

		// save entry count
		Entry.ft_kh_num++;
		wlan_setEntry(&Entry, idx);
		mib_chain_update(MIB_MBSSIB_TBL, (void *)&Entry, idx);
#ifndef WLAN_11R_HAPD
		// generate new ft.conf and update to FT daemon
		genFtKhConfig();
		va_niced_cmd(FT_DAEMON_PROG, 1 , 1 , "-update");
#endif
		goto setOk_ft;
	}

	/* Delete selected entry */
	strVal = boaGetVar(wp, "ftDelSelKh", "");
	if (strVal[0]) {
		entryNum = mib_chain_total(MIB_WLAN_FTKH_TBL);
		for (i=entryNum-1; i>=0; i--) {
			if (!mib_chain_get(MIB_WLAN_FTKH_TBL, i, (void *)&khEntry))
				break;
			if(khEntry.wlanIdx != wlan_idx)
				continue;

			snprintf(tmpbuf, 20, "kh_entry_%d", i);
			strVal = boaGetVar(wp, tmpbuf, "");

			if (!strcmp(strVal, "ON")) {
				deleted++;
				if(mib_chain_delete(MIB_WLAN_FTKH_TBL, i) != 1) {
					strcpy(tmpbuf, strDelListErr);
					goto setErr_ft;
				}
			}
		}
		if (deleted <= 0) {
			strcpy(tmpbuf, "没有选择要删除的项目!");
			goto setErr_ft;
		}

		// save entry count
		Entry.ft_kh_num--;
		wlan_setEntry(&Entry, idx);
		mib_chain_update(MIB_MBSSIB_TBL, (void *)&Entry, idx);

#ifndef WLAN_11R_HAPD
		// generate new ft.conf and update to FT daemon
		genFtKhConfig();
		va_niced_cmd(FT_DAEMON_PROG, 1 , 1 , "-clear");
		va_niced_cmd(FT_DAEMON_PROG, 1 , 1 , "-update");
#endif
		goto setOk_ft;
	}

	/* Delete all entry */
	strVal = boaGetVar(wp, "ftDelAllKh", "");
	if (strVal[0]) {
		entryNum = mib_chain_total(MIB_WLAN_FTKH_TBL);
		for (i=entryNum-1; i>=0; i--) {
			if (!mib_chain_get(MIB_WLAN_FTKH_TBL, i, (void *)&khEntry)) {
	  			strcpy(tmpbuf, strGetChainerror);
				goto setErr_ft;
			}
			if(khEntry.wlanIdx == wlan_idx) {
				if(mib_chain_delete(MIB_WLAN_FTKH_TBL, i) != 1) {
					strcpy(tmpbuf, strDelListErr);
					goto setErr_ft;
				}
			}
		}

		// reset entry count
		for (i=0; i<=NUM_VWLAN_INTERFACE; i++) {
			if (!wlan_getEntry((void *)&Entry, i)) {
				strcpy(tmpbuf, strGetMBSSIBTBLErr);
				goto setErr_ft;
			}
			Entry.ft_kh_num = 0;
			wlan_setEntry(&Entry, i);
			mib_chain_update(MIB_MBSSIB_TBL, (void *)&Entry, i);
		}

#ifndef WLAN_11R_HAPD
		// generate new ft.conf and update to FT daemon
		genFtKhConfig();
		va_niced_cmd(FT_DAEMON_PROG, 1 , 1 , "-clear");
#endif
		goto setOk_ft;
	}

setOk_ft:
#ifdef COMMIT_IMMEDIATELY
	Commit();
#endif // of #if COMMIT_IMMEDIATELY
#ifdef WLAN_11R_HAPD
	config_WLAN(ACT_RESTART, CONFIG_SSID_ALL);
#endif
	if (submitUrl[0])
		boaRedirect(wp, submitUrl);
	else
		boaDone(wp, 200);
	return;

setErr_ft:
	ERR_MSG(tmpbuf);
	return;
}

int wlFtKhList(int eid, request * wp, int argc, char **argv)
{
	int nBytesSent=0, entryNum, i, j, intfIndex=-1;
	MIB_CE_MBSSIB_T Entry;
	MIB_CE_WLAN_FTKH_T khEntry;
	char strAddr[18], strId[49], strKey[33];

	// show title
	nBytesSent += boaWrite(wp, "<tr class=\"hd\">"
      	"<td align=center width=\"14%%\">%s</td>\n"
      	"<td align=center width=\"44%%\">%s</td>\n"
      	"<td align=center width=\"30%%\">%s</td>\n"
      	"<td align=center width=\"7%%\">%s</td></tr>\n",
      	"MAC地址", "NAS identifier", "128-bit key / passphrase", "选择");

	// get total count of KH entry
	entryNum = mib_chain_total(MIB_WLAN_FTKH_TBL);

	// list KH entries, in order of interface index
	//for (j=0; j<=NUM_VWLAN_INTERFACE; j++) 
	j=0;
	{
		for (i=0; i<entryNum; i++) {
			// get KH entries
			if (!mib_chain_get(MIB_WLAN_FTKH_TBL, i, (void *)&khEntry)) {
	  			boaError(wp, 400, "Get chain record error!\n");
				return -1;
			}
			if (khEntry.intfIdx != j)
				continue;

			// show SSID if
			if (intfIndex != j) {
				if (!wlan_getEntry((void *)&Entry, j)) {
					boaError(wp, 400, "Get chain record error!\n");
					return -1;
				}
				nBytesSent += boaWrite(wp, "<tr>"
					"<td align=left width=\"100%%\" colspan=\"4\" bgcolor=\"#A0A0A0\">%s</td></tr>\n",
					Entry.ssid);
				intfIndex = j;
			}

			// show content of KH entry
			snprintf(strAddr, sizeof(strAddr), "%02x:%02x:%02x:%02x:%02x:%02x",
				khEntry.addr[0], khEntry.addr[1], khEntry.addr[2],
				khEntry.addr[3], khEntry.addr[4], khEntry.addr[5]);
			snprintf(strId, sizeof(strId), "%s", khEntry.r0kh_id);
			snprintf(strKey, sizeof(strKey), "%s", khEntry.key);

			nBytesSent += boaWrite(wp, "<tr>"
				"<td align=center width=\"14%%\" bgcolor=\"#C0C0C0\"><font size=\"2\">%s</td>\n"
				"<td align=center width=\"44%%\" bgcolor=\"#C0C0C0\"><font size=\"2\">%s</td>\n"
				"<td align=center width=\"30%%\" bgcolor=\"#C0C0C0\"><font size=\"2\">%s</td>\n"
				"<td align=center width=\"7%%\" bgcolor=\"#C0C0C0\"><input type=\"checkbox\" name=\"kh_entry_%d\" value=\"ON\"></td></tr>\n",
					strAddr, strId, strKey, i);
		}
	}

	return nBytesSent;
}
#endif

#ifdef CONFIG_CMCC_ENTERPRISE
static void hex_to_string_ent(unsigned char* hex_str, int length, char * acsii_str)
{
	if(hex_str == NULL || acsii_str == NULL)
	{
		return;
	}
	
	if(hex_str[0] == '\0')
	{
		return;
	}

	int i = 0, j = 0;
	for (i = 0; i < length/2; i++, j+=2) 
		sprintf(acsii_str+j, "%x", hex_str[i]);
}

int listWlanStatus(int eid, request * wp, int argc, char **argv)
{
	//int entryNum = 0;
	int i = 0;
	MIB_CE_MBSSIB_T entry;
	unsigned char newEncType, disabled;
	const char *header = "WifiSsidCfg";
	int orig_wlan_idx = wlan_idx;
	char wep_str1[32] = {'\0'};
	char wep_str2[32] = {'\0'};
	char wep_str3[32] = {'\0'};
	char wep_str4[32] = {'\0'};

	//entryNum = mib_chain_total(MIB_MBSSIB_TBL);	
	wlan_idx = 0;	//2.4G
	for (i = 0; i < WLAN_SSID_NUM; i++) 
	{
		if (!mib_chain_get(MIB_MBSSIB_TBL, i, &entry)) 
		{
			printf("get MIB chain error\n");
			wlan_idx = orig_wlan_idx;
			return -1;
		}

		if(i == 0)
		{
			mib_get(MIB_WIFI_MODULE_DISABLED, (void *)&disabled);
			boaWrite(wp, "WifiConfig.enable = %d;\n",(disabled?0:1));
		}

		if(entry.encrypt == WIFI_SEC_WPA2)
		{
			newEncType = 3;
		}
		else if(entry.encrypt == WIFI_SEC_WPA2_MIXED)
		{
			newEncType = 4;
		}
		else
		{
			newEncType = entry.encrypt;
		}

		if(entry.wep == WEP64)
		{
			if(entry.wepKeyType == 0) 
			{
				strncpy(wep_str1, entry.wep64Key1, 5);
				strncpy(wep_str2, entry.wep64Key2, 5);
				strncpy(wep_str3, entry.wep64Key3, 5);
				strncpy(wep_str4, entry.wep64Key4, 5);
			}
			else
			{
				hex_to_string_ent(entry.wep64Key1, 10, wep_str1);
				hex_to_string_ent(entry.wep64Key2, 10, wep_str2);
				hex_to_string_ent(entry.wep64Key3, 10, wep_str3);
				hex_to_string_ent(entry.wep64Key4, 10, wep_str4);
			}
		}
		else if (entry.wep == WEP128)
		{
			if(entry.wepKeyType == 0) 
			{
				strncpy(wep_str1, entry.wep128Key1, 13);
				strncpy(wep_str2, entry.wep128Key2, 13);
				strncpy(wep_str3, entry.wep128Key3, 13);
				strncpy(wep_str4, entry.wep128Key4, 13);
			}
			else
			{
				hex_to_string_ent(entry.wep128Key1, 26, wep_str1);
				hex_to_string_ent(entry.wep128Key2, 26, wep_str2);
				hex_to_string_ent(entry.wep128Key3, 26, wep_str3);
				hex_to_string_ent(entry.wep128Key4, 26, wep_str4);
			}
		}

		boaWrite(wp, "%s[%d].prefix		= \"CMCC-\";\n"\
				"%s[%d].ssid_name	= \"%s\";\n"\
				"%s[%d].broadcast	= %d;\n"\
				"%s[%d].ssid_enable	= %d;\n"\
				"%s[%d].ap_isolate	= %d;\n"\
				"%s[%d].security_mode = %d;\n"\
				"%s[%d].wep_mode	= %d;\n"\
				"%s[%d].wepKeyIndex	=\"%d\";\n"\
				"%s[%d].wepKeyLen	= \"%d\";\n"\
				"%s[%d].wepKey	       = [];\n"\
				"%s[%d].wepKey[0]	= \"%s\";\n"\
				"%s[%d].wepKey[1]	= \"%s\";\n"\
				"%s[%d].wepKey[2]	= \"%s\";\n"\
				"%s[%d].wepKey[3]	= \"%s\";\n"\
				"%s[%d].perKey		= \"%s\";\n"\
				"%s[%d].entKey	= \"%s\";\n",
				header,i,
				header,i,&entry.ssid[5],
				header,i,entry.hidessid,
				header,i,(entry.wlanDisabled?0:1),
				header,i,entry.userisolation,
				header,i,newEncType,
				header,i,entry.wepKeyType,
				header,i,entry.wepDefaultKey,
				header,i,entry.wepKeyType,
				header,i,
				header,i,wep_str1,
				header,i,wep_str2,
				header,i,wep_str3,
				header,i,wep_str4,
				header,i,entry.wpaPSK,
				header,i,entry.wpaPSK
					);
	}
	wlan_idx = orig_wlan_idx;
}

int listWlanMainStatus(int eid, request * wp, int argc, char **argv)
{
	
	int /*entryNum = 0, */channelNum = 0, txPower = 0, channelWidth = 0, dtimPeriod = 0, bconInterval = 0;
	int i = 0;
	MIB_CE_MBSSIB_T entry;
#ifdef WLAN_MESH
	MIB_CE_WLAN_SSID_SPEED_T speed_entry;
#endif
	unsigned char newEncType, disabled, vChar, vChar2, newSecurityEncType;
	unsigned short beaconInt, uShort;
	const char *header = "WifiSsidCfg";
	char wep_str1[32] = {'\0'};
	char wep_str2[32] = {'\0'};
	char wep_str3[32] = {'\0'};
	char wep_str4[32] = {'\0'};

	int	orig_wlan_idx = wlan_idx;
	wlan_idx = 0;	//2.4G
#ifdef WLAN_USE_VAP_AS_SSID1
#ifdef WLAN_MESH
	if (!mib_chain_get(MIB_MBSSIB_TBL, WLAN_ROOT_ITF_INDEX, &entry))
	{
		printf("get MIB chain error\n");
		wlan_idx = orig_wlan_idx;
		return -1;
	}

	boaWrite(wp, "WifiConfig.mesh_enable = %d;\n", (entry.wlanMode == AP_MESH_MODE)? 1:0);
#endif
#endif
	//entryNum = mib_chain_total(MIB_MBSSIB_TBL); 
	for (i = 0; i < WLAN_SSID_NUM; i++) 
	{
		if (!mib_chain_get(MIB_MBSSIB_TBL, i, &entry)) 
		{
			printf("get MIB chain error\n");
			wlan_idx = orig_wlan_idx;
			return -1;
		}
#ifdef WLAN_MESH
		if (!mib_chain_get(MIB_WLAN_SSID_SPEED_TBL, i, &speed_entry)) 
		{
			printf("get MIB chain error\n");
			wlan_idx = orig_wlan_idx;
			return -1;
		}
#endif
	
		if(i == 0)
		{
			boaWrite(wp, "WifiConfig.mode = %d;\n", entry.wlanBand-1);

			mib_get(MIB_WIFI_MODULE_DISABLED, (void *)&disabled);
			boaWrite(wp, "WifiConfig.enable = %d;\n",(disabled?0:1));
	
			mib_get(MIB_WLAN_AUTO_CHAN_ENABLED, &vChar);
			if(vChar)
			{
				channelNum = 0; 
			}
			else
			{
				mib_get(MIB_WLAN_CHAN_NUM, &vChar);
				channelNum = vChar;
			}
			boaWrite(wp, "WifiConfig.channel = %d;\n", channelNum);
	
			mib_get(MIB_TX_POWER, &vChar);
			txPower = vChar;
			boaWrite(wp, "WifiConfig.txpower = %d;\n", txPower);
	
			mib_get(MIB_WLAN_CHANNEL_WIDTH, &vChar);
			if(vChar==1)
			{
				mib_get( MIB_WLAN_11N_COEXIST,(void *)&vChar2);
				if(vChar2)
					vChar=2;
			}
			channelWidth = vChar;
			boaWrite(wp, "WifiConfig.chanwid = %d;\n", channelWidth);
			
			mib_get(MIB_WLAN_DTIM_PERIOD, &vChar);
			dtimPeriod = vChar;
			boaWrite(wp, "WifiConfig.dtimPeriod = %d;\n", dtimPeriod);
	
			mib_get(MIB_WLAN_BEACON_INTERVAL, &beaconInt);
			bconInterval = beaconInt;
			boaWrite(wp, "WifiConfig.beaconInterval = %d;\n", bconInterval);

			mib_get(MIB_WLAN_FRAG_THRESHOLD, &uShort);
			boaWrite(wp, "WifiConfig.fragThreshold = %d;\n", uShort);

			mib_get(MIB_WLAN_RTS_THRESHOLD, &uShort);
			boaWrite(wp, "WifiConfig.rtsThreshold = %d;\n", uShort);

			mib_get(MIB_WLAN_PROTECTION_DISABLED, &vChar);	
			boaWrite(wp, "WifiConfig.protection = %d;\n",(vChar?0:1));
#ifdef WLAN_MESH
#ifndef WLAN_USE_VAP_AS_SSID1
			boaWrite(wp, "WifiConfig.mesh_enable = %d;\n", (entry.wlanMode == AP_MESH_MODE)? 1:0);
#endif
			mib_get(MIB_SWQ_ATM_ENABLE, &vChar);
			boaWrite(wp, "WifiConfig.swq_atm_enable = %d;\n", vChar);
#endif
#ifdef RTK_SMART_ROAMING
			mib_get( MIB_CAPWAP_MODE, (void *)&vChar);
			boaWrite(wp, "WifiConfig.sr_enable = %d;\n", (vChar & CAPWAP_ROAMING_ENABLE)? 1:0);
			boaWrite(wp, "WifiConfig.sr_autoconfig = %d;\n", (vChar & CAPWAP_AUTO_CONFIG_ENABLE)? 1:0);
			boaWrite(wp, "WifiConfig.sr_opmode_select_ac = %d;\n", (vChar & CAPWAP_OPMODE_SELECT_AC_ENABLE)? 1:0);
			boaWrite(wp, "WifiConfig.sr_mesh_psk_gen_enable = %d;\n", (vChar & CAPWAP_AC_MESH_PSK_GENERATOR_ENABLE)? 1:0);
#endif
#ifdef WLAN_BAND_STEERING
			mib_get(MIB_WIFI_STA_CONTROL, (void *)&vChar);
			boaWrite(wp, "WifiConfig.sta_control_enable = %d;\n", (vChar & STA_CONTROL_ENABLE)? 1:0);
			boaWrite(wp, "WifiConfig.stactrl_prefer_band_value = %d;\n", (vChar & STA_CONTROL_PREFER_BAND)? 1:0);
			boaWrite(wp, "WifiConfig.bandsteering_status = %d;\n", rtk_wlan_get_band_steering_status());
#endif

		}
	
	
		if(entry.encrypt == WIFI_SEC_WPA2)
		{
			newEncType = 3;
			newSecurityEncType = entry.wpa2UnicastCipher - 1;
		}
		else if(entry.encrypt == WIFI_SEC_WPA2_MIXED)
		{
			newEncType =4;
			newSecurityEncType = entry.wpa2UnicastCipher - 1;
		}
		else if(entry.encrypt == WIFI_SEC_WPA)
		{
			newEncType = entry.encrypt;
			newSecurityEncType = entry.unicastCipher- 1;
		}
		else
		{
			newEncType = entry.encrypt;
			newSecurityEncType = 0;
		}

		if(entry.wep == WEP64)
		{
			if(entry.wepKeyType == 0) 
			{
				strncpy(wep_str1, entry.wep64Key1, 5);
				strncpy(wep_str2, entry.wep64Key2, 5);
				strncpy(wep_str3, entry.wep64Key3, 5);
				strncpy(wep_str4, entry.wep64Key4, 5);
			}
			else
			{
				hex_to_string_ent(entry.wep64Key1, 10, wep_str1);
				hex_to_string_ent(entry.wep64Key2, 10, wep_str2);
				hex_to_string_ent(entry.wep64Key3, 10, wep_str3);
				hex_to_string_ent(entry.wep64Key4, 10, wep_str4);
			}
		}
		else if (entry.wep == WEP128)
		{
			if(entry.wepKeyType == 0) 
			{
				strncpy(wep_str1, entry.wep128Key1, 13);
				strncpy(wep_str2, entry.wep128Key2, 13);
				strncpy(wep_str3, entry.wep128Key3, 13);
				strncpy(wep_str4, entry.wep128Key4, 13);
			}
			else
			{
				hex_to_string_ent(entry.wep128Key1, 26, wep_str1);
				hex_to_string_ent(entry.wep128Key2, 26, wep_str2);
				hex_to_string_ent(entry.wep128Key3, 26, wep_str3);
				hex_to_string_ent(entry.wep128Key4, 26, wep_str4);
			}
		}
	
		boaWrite(wp, "%s[%d].prefix 	= \"CMCC-\";\n"
					"%s[%d].ssid_name	= \"%s\";\n"
					"%s[%d].broadcast	= %d;\n"
					"%s[%d].ssid_enable = %d;\n"
					"%s[%d].wps_enable = %d;\n" 
					"%s[%d].wmm_enable = %d;\n"
					"%s[%d].wmf_enable = %d;\n"
					"%s[%d].ssid_isolation	= %d;\n"
					"%s[%d].user_isolation	= %d;\n"
					"%s[%d].sta_num	= %d;\n"
					"%s[%d].security_mode = %d;\n"
					"%s[%d].auth_type	= %d;\n"
					"%s[%d].wepKeyIndex =\"%d\";\n"
					"%s[%d].wepKeyLen	= \"%d\";\n"
					"%s[%d].wepKey		   = [];\n"
					"%s[%d].wepKey[0]	= \"%s\";\n"
					"%s[%d].wepKey[1]	= \"%s\";\n"
					"%s[%d].wepKey[2]	= \"%s\";\n"
					"%s[%d].wepKey[3]	= \"%s\";\n"
					"%s[%d].perKey		= \"%s\";\n"
					"%s[%d].perEntype	= %d;\n"
					"%s[%d].entEntype	= 0\n"
					"%s[%d].entServer		= \"0.0.0.0\";\n"
					"%s[%d].entPort	= 0;\n"
					"%s[%d].entKey		= \"\";\n",
					header,i,
					header,i,&entry.ssid[5],
					header,i,entry.hidessid,
					header,i,(entry.wlanDisabled?0:1),
					header,i,(entry.wsc_disabled?0:1),
					header,i,entry.wmmEnabled,
					header,i,(entry.mc2u_disable?0:1),
					header,i,entry.ssidisolation,
					header,i,entry.userisolation,
#ifdef WLAN_LIMITED_STA_NUM
					header,i,entry.stanum,
#else
					header,i,0,
#endif
					header,i,newEncType,
					header,i,entry.authType,
					header,i,entry.wepDefaultKey,
					header,i,((entry.wep-1<0)?0:entry.wep-1),
					header,i,
					header,i,wep_str1,
					header,i,wep_str2,
					header,i,wep_str3,
					header,i,wep_str4,
					header,i,entry.wpaPSK,
					header,i,newSecurityEncType,
					header,i,
					header,i,
					header,i,
					header,i
					);
#ifdef WLAN_MESH
		boaWrite(wp, "%s[%d].tx_restrict = \"%d\";\n"\
					 "%s[%d].rx_restrict = \"%d\";\n",
						header,i,speed_entry.thrd_tx,
						header,i,speed_entry.thrd_rx);
#endif
#ifdef WLAN_11K	
		boaWrite(wp, "%s[%d].dot11k_enable = %d;\n", header,i, entry.rm_activated);
#endif
#ifdef WLAN_11K
		boaWrite(wp, "%s[%d].dot11v_enable = %d;\n", header,i, entry.BssTransEnable);
#endif

	}

	wlan_idx = orig_wlan_idx;
}

int listWlan5GMainStatus(int eid, request * wp, int argc, char **argv)
{
	
	int /*entryNum = 0,*/ channelNum = 0, txPower = 0, channelWidth = 0, dtimPeriod = 0, bconInterval = 0;
	int i = 0;
	MIB_CE_MBSSIB_T entry;
#ifdef WLAN_MESH
	MIB_CE_WLAN_SSID_SPEED_T speed_entry;
#endif
	unsigned char newEncType, disabled, vChar, vChar2, newSecurityEncType;
	unsigned short beaconInt, uShort;
	const char *header = "WifiSsidCfg";
	char wep_str1[32] = {'\0'};
	char wep_str2[32] = {'\0'};
	char wep_str3[32] = {'\0'};
	char wep_str4[32] = {'\0'};

	int	orig_wlan_idx = wlan_idx;
	wlan_idx = 1;	//5G

#ifdef WLAN_USE_VAP_AS_SSID1
#ifdef WLAN_MESH
	if (!mib_chain_get(MIB_MBSSIB_TBL, WLAN_ROOT_ITF_INDEX, &entry))
	{
		printf("get MIB chain error\n");
		wlan_idx = orig_wlan_idx;
		return -1;
	}

	boaWrite(wp, "WifiConfig.mesh_enable = %d;\n", (entry.wlanMode == AP_MESH_MODE)? 1:0);
#endif
#endif
	
	//entryNum = mib_chain_total(MIB_MBSSIB_TBL); 
	for (i = 0; i < WLAN_SSID_NUM; i++) 
	{
		if (!mib_chain_get(MIB_MBSSIB_TBL, i, &entry)) 
		{
			printf("get MIB chain error\n");
			wlan_idx = orig_wlan_idx;
			return -1;
		}
#ifdef WLAN_MESH
		if (!mib_chain_get(MIB_WLAN_SSID_SPEED_TBL, i, &speed_entry)) 
		{
			printf("get MIB chain error\n");
			wlan_idx = orig_wlan_idx;
			return -1;
		}
#endif
	
		if(i == 0)
		{
			boaWrite(wp, "WifiConfig.mode = %d;\n", entry.wlanBand-1);

			mib_get(MIB_WIFI_MODULE_DISABLED, (void *)&disabled);
			boaWrite(wp, "WifiConfig.enable = %d;\n",(disabled?0:1));
	
			mib_get(MIB_WLAN_AUTO_CHAN_ENABLED, &vChar);
			if(vChar)
			{
				channelNum = 0; 
			}
			else
			{
				mib_get(MIB_WLAN_CHAN_NUM, &vChar);
				channelNum = vChar;
			}
			boaWrite(wp, "WifiConfig.channel = %d;\n", channelNum);
	
			mib_get(MIB_TX_POWER, &vChar);
			txPower = vChar;
			boaWrite(wp, "WifiConfig.txpower = %d;\n", txPower);
	
			mib_get(MIB_WLAN_CHANNEL_WIDTH, &vChar);
			if(vChar==1)
			{
				mib_get( MIB_WLAN_11N_COEXIST,(void *)&vChar2);
				if(vChar2)
					vChar=2;
			}
			channelWidth = vChar;
			boaWrite(wp, "WifiConfig.chanwid = %d;\n", channelWidth);
			
			mib_get(MIB_WLAN_DTIM_PERIOD, &vChar);
			dtimPeriod = vChar;
			boaWrite(wp, "WifiConfig.dtimPeriod = %d;\n", dtimPeriod);
	
			mib_get(MIB_WLAN_BEACON_INTERVAL, &beaconInt);
			bconInterval = beaconInt;
			boaWrite(wp, "WifiConfig.beaconInterval = %d;\n", bconInterval);

			mib_get(MIB_WLAN_FRAG_THRESHOLD, &uShort);
			boaWrite(wp, "WifiConfig.fragThreshold = %d;\n", uShort);

			mib_get(MIB_WLAN_RTS_THRESHOLD, &uShort);
			boaWrite(wp, "WifiConfig.rtsThreshold = %d;\n", uShort);

			mib_get(MIB_WLAN_PROTECTION_DISABLED, &vChar);	
			boaWrite(wp, "WifiConfig.protection = %d;\n",(vChar?0:1));
#ifdef WLAN_MESH
#ifndef WLAN_USE_VAP_AS_SSID1
			boaWrite(wp, "WifiConfig.mesh_enable = %d;\n", (entry.wlanMode == AP_MESH_MODE)? 1:0);
#endif
			mib_get(MIB_SWQ_ATM_ENABLE, &vChar);
			boaWrite(wp, "WifiConfig.swq_atm_enable = %d;\n", vChar);
#endif
#ifdef RTK_SMART_ROAMING
			mib_get( MIB_CAPWAP_MODE, (void *)&vChar);
			boaWrite(wp, "WifiConfig.sr_enable = %d;\n", (vChar & CAPWAP_ROAMING_ENABLE)? 1:0);
			boaWrite(wp, "WifiConfig.sr_autoconfig = %d;\n", (vChar & CAPWAP_AUTO_CONFIG_ENABLE)? 1:0);
			boaWrite(wp, "WifiConfig.sr_opmode_select_ac = %d;\n", (vChar & CAPWAP_OPMODE_SELECT_AC_ENABLE)? 1:0);
			boaWrite(wp, "WifiConfig.sr_mesh_psk_gen_enable = %d;\n", (vChar & CAPWAP_AC_MESH_PSK_GENERATOR_ENABLE)? 1:0);
#endif
#ifdef WLAN_BAND_STEERING
			mib_get(MIB_WIFI_STA_CONTROL, (void *)&vChar);
			boaWrite(wp, "WifiConfig.sta_control_enable = %d;\n", (vChar & STA_CONTROL_ENABLE)? 1:0);
			boaWrite(wp, "WifiConfig.stactrl_prefer_band_value = %d;\n", (vChar & STA_CONTROL_PREFER_BAND)? 1:0);
			boaWrite(wp, "WifiConfig.bandsteering_status = %d;\n", rtk_wlan_get_band_steering_status());
#endif
		}
	
	
		if(entry.encrypt == WIFI_SEC_WPA2)
		{
			newEncType = 3;
			newSecurityEncType = entry.wpa2UnicastCipher - 1;
		}
		else if(entry.encrypt == WIFI_SEC_WPA2_MIXED)
		{
			newEncType =4;
			newSecurityEncType = entry.wpa2UnicastCipher - 1;
		}
		else if(entry.encrypt == WIFI_SEC_WPA)
		{
			newEncType = entry.encrypt;
			newSecurityEncType = entry.unicastCipher- 1;
		}
		else
		{
			newEncType = entry.encrypt;
			newSecurityEncType = 0;
		}

		if(entry.wep == WEP64)
		{
			if(entry.wepKeyType == 0) 
			{
				strncpy(wep_str1, entry.wep64Key1, 5);
				strncpy(wep_str2, entry.wep64Key2, 5);
				strncpy(wep_str3, entry.wep64Key3, 5);
				strncpy(wep_str4, entry.wep64Key4, 5);
			}
			else
			{
				hex_to_string_ent(entry.wep64Key1, 10, wep_str1);
				hex_to_string_ent(entry.wep64Key2, 10, wep_str2);
				hex_to_string_ent(entry.wep64Key3, 10, wep_str3);
				hex_to_string_ent(entry.wep64Key4, 10, wep_str4);
			}
		}
		else if (entry.wep == WEP128)
		{
			if(entry.wepKeyType == 0) 
			{
				strncpy(wep_str1, entry.wep128Key1, 13);
				strncpy(wep_str2, entry.wep128Key2, 13);
				strncpy(wep_str3, entry.wep128Key3, 13);
				strncpy(wep_str4, entry.wep128Key4, 13);
			}
			else
			{
				hex_to_string_ent(entry.wep128Key1, 26, wep_str1);
				hex_to_string_ent(entry.wep128Key2, 26, wep_str2);
				hex_to_string_ent(entry.wep128Key3, 26, wep_str3);
				hex_to_string_ent(entry.wep128Key4, 26, wep_str4);
			}
		}
	
		boaWrite(wp, "%s[%d].prefix 	= \"CMCC-\";\n"
					"%s[%d].ssid_name	= \"%s\";\n"
					"%s[%d].broadcast	= %d;\n"
					"%s[%d].ssid_enable = %d;\n"
					"%s[%d].wps_enable = %d;\n" 
					"%s[%d].wmm_enable = %d;\n"
					"%s[%d].wmf_enable = %d;\n"
					"%s[%d].ssid_isolation	= %d;\n"
					"%s[%d].user_isolation	= %d;\n"
					"%s[%d].sta_num	= %d;\n"
					"%s[%d].security_mode = %d;\n"
					"%s[%d].auth_type	= %d;\n"
					"%s[%d].wepKeyIndex =\"%d\";\n"
					"%s[%d].wepKeyLen	= \"%d\";\n"
					"%s[%d].wepKey		   = [];\n"
					"%s[%d].wepKey[0]	= \"%s\";\n"
					"%s[%d].wepKey[1]	= \"%s\";\n"
					"%s[%d].wepKey[2]	= \"%s\";\n"
					"%s[%d].wepKey[3]	= \"%s\";\n"
					"%s[%d].perKey		= \"%s\";\n"
					"%s[%d].perEntype	= %d;\n"
					"%s[%d].entEntype	= 0\n"
					"%s[%d].entServer		= \"0.0.0.0\";\n"
					"%s[%d].entPort	= 0;\n"
					"%s[%d].entKey		= \"\";\n",
					header,i,
					header,i,&entry.ssid[5],
					header,i,entry.hidessid,
					header,i,(entry.wlanDisabled?0:1),
					header,i,(entry.wsc_disabled?0:1),
					header,i,entry.wmmEnabled,
					header,i,(entry.mc2u_disable?0:1),
					header,i,entry.ssidisolation,
					header,i,entry.userisolation,
#ifdef WLAN_LIMITED_STA_NUM
					header,i,entry.stanum,
#else
					header,i,0,
#endif
					header,i,newEncType,
					header,i,entry.authType,
					header,i,entry.wepDefaultKey,
					header,i,((entry.wep-1<0)?0:entry.wep-1),
					header,i,
					header,i,wep_str1,
					header,i,wep_str2,
					header,i,wep_str3,
					header,i,wep_str4,
					header,i,entry.wpaPSK,
					header,i,newSecurityEncType,
					header,i,
					header,i,
					header,i,
					header,i
					);
#ifdef WLAN_MESH
		boaWrite(wp, "%s[%d].tx_restrict = \"%d\";\n"\
					 "%s[%d].rx_restrict = \"%d\";\n",
						header,i,speed_entry.thrd_tx,
						header,i,speed_entry.thrd_rx);
#endif

#ifdef WLAN_11K	
		boaWrite(wp, "%s[%d].dot11k_enable = %d;\n", header,i, entry.rm_activated);
#endif
#ifdef WLAN_11K
		boaWrite(wp, "%s[%d].dot11v_enable = %d;\n", header,i, entry.BssTransEnable);
#endif

	}

	wlan_idx = orig_wlan_idx;
}
#endif

#if 0
void formEntQuickWlanSetup(request * wp, char *path, char *query)
{

	char *submitUrl, *strSSID, *strChan, *strDisabled, *strVal;
	char vChar, chan, disabled, mode=-1;
	NETWORK_TYPE_T net;
	char tmpBuf[100];
	int flags;
	MIB_CE_MBSSIB_T Entry;
	MIB_CE_MBSSIB_T RootEntry;
	int warn = 0;
	unsigned short uShort=0;
	int vInt=0, ssidIdx, wlmib_idx=0;
	
	mib_chain_get(MIB_MBSSIB_TBL, 0, (void *)&Entry);
	
	strDisabled = boaGetVar(wp, "wlanEnabled", "");

	if ( !gstrcmp(strDisabled, "ON") )
		disabled = 0;
	else
		disabled = 1;
	
	mib_set(MIB_WIFI_MODULE_DISABLED, (void *)&disabled);
	
	if ( disabled )
	{
		goto setwlan_module_disable;
	}

	strSSID = boaGetVar(wp, "ssid", "");
	
	if ( strSSID[0] ) {
		char real_ssid[64] = "";
#ifdef CONFIG_CU
		unsigned char ssidprefix_enable = 0;

		mib_get(MIB_WEB_WLAN_SSIDPREFIX_ENABLE, &ssidprefix_enable);
		if (ssidprefix_enable==1)
			sprintf(real_ssid, "CU_%s", strSSID);
		else
			sprintf(real_ssid, "%s", strSSID);
#elif defined(CONFIG_CMCC)
		unsigned char ssidprefix_enable = 0;

		mib_get(MIB_WEB_WLAN_SSIDPREFIX_ENABLE, &ssidprefix_enable);
		if (ssidprefix_enable==1)
			sprintf(real_ssid, "CMCC-%s", strSSID);
		else
			sprintf(real_ssid, "%s", strSSID);
#else
		sprintf(real_ssid, "ChinaNet-%s", strSSID);
#endif
		strcpy(Entry.ssid, real_ssid);
	}

	char *strEncrypt;
	char *strKeyLen, *strFormat, *wepKey, *strAuth;
	int key_index=0, key_i;
	char *strKeySelcted;
	char strbuf_idx[16], strbuf_errmsg1[16], strbuf_errmsg2[16];
	WIFI_SECURITY_T encrypt;
	int enableRS=0, intVal, getPSK=0, len, keyLen;
	SUPP_NONWAP_T suppNonWPA;
	struct in_addr inIp;
	WEP_T wep;
	char key[30];
	AUTH_TYPE_T authType;

	strEncrypt = boaGetVar(wp, "security_method", "");
	if (!strEncrypt[0]) {
 		strcpy(tmpBuf, strNoEncryptionErr);
		goto setErr_encrypt;
	}

	encrypt = (WIFI_SECURITY_T) strEncrypt[0] - '0';
	if(encrypt == 2)
	{
		encrypt = WIFI_SEC_WPA2_MIXED;
	}
	vChar = (char)encrypt;
	Entry.encrypt = vChar;
	

	if (encrypt == WIFI_SEC_NONE || encrypt == WIFI_SEC_WEP) 
	{

#ifdef WLAN_1x
		Entry.enable1X = 0;
#endif

		if (encrypt == WIFI_SEC_WEP) {
	 		WEP_T wep;
			// Mason Yu. 201009_new_security. If wireless do not use 802.1x for wep mode. We should set wep key and Authentication type.
			if (1) 
			{
				// (1) Authentication Type		
				authType = AUTH_BOTH;
				vChar = (char)authType;
				Entry.authType = vChar;
				// (2) Key Length
				wep = WEP64;
				vChar = (char)wep;
				Entry.wep = vChar;

				// (3) Key Format
				Entry.wepKeyType = 0;			
				keyLen = WEP64_KEY_LEN;
								
				// Key selected
				strKeySelcted = boaGetVar(wp, "wep_key_index", "");
				if (!strKeySelcted[0]) {
					strcpy(tmpBuf, strKeySelectedMustExist);
					goto setErr_encrypt;
				}
				if (strKeySelcted[0]!='0' && strKeySelcted[0]!='1' && strKeySelcted[0]!='2' && strKeySelcted[0]!='3') {
					strcpy(tmpBuf, strInvdKeySel);
					goto setErr_encrypt;
				}
				if (strKeySelcted[0] == '0')
					key_index = 0;
				else if (strKeySelcted[0] == '1')
					key_index = 1;
				else if (strKeySelcted[0] == '2')
					key_index = 2;
				else
					key_index = 3;

				Entry.wepDefaultKey = key_index;

				// (4) Encryption Key
				//
				for (key_i=0; key_i<4; key_i++)
				{
					sprintf(strbuf_idx, "wep_key%d", key_i);
					sprintf(strbuf_errmsg1, "strInvdKey%dLen", key_i+1);
					sprintf(strbuf_errmsg2, "strInvdWEPKey%d", key_i+1);

					wepKey = boaGetVar(wp, strbuf_idx, "");
				
					if  (wepKey[0]) {
						if (strlen(wepKey) != keyLen) {
							strcpy(tmpBuf, strbuf_errmsg1);
							goto setErr_encrypt;
						}
						if ( !isAllStar(wepKey) ) {
								strcpy(key, wepKey);

							if (wep == WEP64)
							{
								switch(key_i)
								{
									case 0:
										memcpy(Entry.wep64Key1, key, WEP64_KEY_LEN);
										break;
									case 1:
										memcpy(Entry.wep64Key2, key, WEP64_KEY_LEN);
										break;
									case 2:
										memcpy(Entry.wep64Key3, key, WEP64_KEY_LEN);
										break;
									case 3:
										memcpy(Entry.wep64Key4, key, WEP64_KEY_LEN);
										break;
								}
							}							
						}
					}
				}// (4) Encryption Key
			}
		}
	}	
	else {	// WPA
#ifdef WPS20
			unsigned char disableWps = 0;
#endif //WPS20
#ifdef WLAN_1x
			// WPA authentication
			Entry.enable1X = 0;
			Entry.wpaAuth = WPA_AUTH_PSK;
			getPSK = 1;
#endif
	
			// Mason Yu. 201009_new_security. Set ciphersuite(wpa_cipher) for wpa/wpa mixed
			if ((encrypt == WIFI_SEC_WPA) || (encrypt == WIFI_SEC_WPA2_MIXED)) {
				unsigned char intVal = 0;
				unsigned char val2;

				intVal |= WPA_CIPHER_MIXED;
				Entry.unicastCipher = intVal;
			}
	
			// Mason Yu. 201009_new_security. Set wpa2ciphersuite(wpa2_cipher) for wpa2/wpa mixed
			if ((encrypt == WIFI_SEC_WPA2) || (encrypt == WIFI_SEC_WPA2_MIXED)) {
				unsigned char intVal = 0;		
				intVal |= WPA_CIPHER_MIXED;
				Entry.wpa2UnicastCipher = intVal;
			}
		#ifdef WPS20
			if (disableWps) {
				Entry.wsc_disabled = 1;
			}
		#endif //WPS20
			// pre-shared key
			if ( getPSK ) {
				
		
				strVal = boaGetVar(wp, "pskValue", "");
				len = strlen(strVal);
				Entry.wpaPSKFormat = 0;
				vChar = 0;
				if (vChar==1) { // hex
					if (len!=MAX_PSK_LEN || !string_to_hex(strVal, tmpBuf, MAX_PSK_LEN)) {
						strcpy(tmpBuf, strInvdPSKValue);
						goto setErr_encrypt;
					}
				}
				else { // passphras
					if (len==0 || len > (MAX_PSK_LEN - 1) ) {
						strcpy(tmpBuf, strInvdPSKValue);
						goto setErr_encrypt;
					}
				}
				strcpy(Entry.wpaPSK, strVal);
				
			}
		}

	wlan_setEntry(&Entry, 0);

	sleep(5);

setwlan_module_disable:

	submitUrl = boaGetVar(wp, "submit-url", "");   // hidden page

#ifdef COMMIT_IMMEDIATELY
	Commit();
#endif // of #if COMMIT_IMMEDIATELY
	
#ifndef NO_ACTION
	run_script(-1);
#endif


	config_WLAN(CONFIG_WLAN_2G, CONFIG_SSID1);
	//va_cmd("/bin/ifconfig", 2, 1, "wlan0", "down");
	//va_cmd("/bin/ifconfig", 2, 1, "wlan0", "up");
	if (submitUrl[0])
		boaRedirect(wp, submitUrl);
	else
		boaDone(wp, 200);
	return;
setErr_wlan:
	ERR_MSG(tmpBuf);
setErr_encrypt:
	ERR_MSG(tmpBuf);

}
#endif
#ifdef CONFIG_CMCC_ENTERPRISE
void formEntWlanSetup(request * wp, char *path, char *query)
{
	char *submitUrl, *strSSID, *strChan, *strDisabled, *strVal;
	char vChar, chan, disabled, mode=-1;
	NETWORK_TYPE_T net;
	char tmpBuf[100];
	int flags;
	MIB_CE_MBSSIB_T Entry;
#ifdef WLAN_MESH
#ifdef WLAN_USE_VAP_AS_SSID1
	MIB_CE_MBSSIB_T root_entry;
#endif
#endif
	int warn = 0;
	unsigned char vmChar = 0;
	unsigned short uShort=0;
	int vInt=0, ssidIdx = 0, wlmib_idx=0;
#ifndef WLAN_DUALBAND_CONCURRENT
	int all_ssid_modify=0;
#endif
#ifdef WLAN_BAND_STEERING
	unsigned char band_steering=0;
#endif
#ifdef WLAN_MESH
	MIB_CE_WLAN_SSID_SPEED_T speed_entry;
	unsigned char swqatm_enable=0;
#endif

#ifdef WLAN_DUALBAND_CONCURRENT
	char phyBandSelect, wlanBand2G5GSelect, phyBandOrig, wlanBand2G5GSelect_single;
	int i;
	int phyBandSelectChange = 0;
	char lan_ip[30];
	int orig_idx;
	int both_band_modify=0;
#ifdef CONFIG_RTL_STA_CONTROL_SUPPORT
	unsigned char sta_control;
#endif
#endif //WLAN_DUALBAND_CONCURRENT


#ifdef WLAN_DUALBAND_CONCURRENT
	strVal = boaGetVar(wp, "wlan_idx", "");
	if ( strVal[0] ) {
		printf("wlan_idx=%d\n", strVal[0]-'0');
		wlan_idx = strVal[0]-'0';
	}
#endif

	memset( &Entry, 0, sizeof( MIB_CE_MBSSIB_T ));
	strVal = boaGetVar(wp, "ssid_idx", "");
	ssidIdx = strVal[0] - '0'; 
	
	if(ssidIdx >= 0){
		wlmib_idx = ssidIdx;
		if(mib_chain_get(MIB_MBSSIB_TBL, wlmib_idx, (void *)&Entry) != 1)
			goto setErr_wlan; 	
	}
	else goto setErr_wlan;

	strDisabled = boaGetVar(wp, "wlanDisabled", "");

	if ( !gstrcmp(strDisabled, "ON") )
		disabled = 1;
	else
		disabled = 0;

	strDisabled = boaGetVar(wp, "wlanEnabled", "");

	if ( !gstrcmp(strDisabled, "ON") )
		disabled = 0;
	else
		disabled = 1;

	mib_get(MIB_WIFI_MODULE_DISABLED, (void *)&vChar);

	if(disabled!=vChar)
	{
#ifdef WLAN_DUALBAND_CONCURRENT
		both_band_modify = 1;
#else
		all_ssid_modify=1;
#endif
	}
	
	mib_set(MIB_WIFI_MODULE_DISABLED, (void *)&disabled);

	if ( disabled ){
		goto setwlan_module_all_disable;
	}

	strVal = boaGetVar(wp, "enableSSID", "");
	if(strVal[0]=='1')
		Entry.wlanDisabled = 0;
	else
		Entry.wlanDisabled = 1;
	
#ifdef WLAN_RATE_PRIOR
	strVal = boaGetVar(wp, "wlanRatePrior", "");

	if ( !gstrcmp(strVal, "ON") )
		vChar = 1;
	else
		vChar = 0;
	if ( mib_set( MIB_WLAN_RATE_PRIOR, (void *)&vChar) == 0) {
		goto setErr_wlan;
	}
#endif

	// Added by Mason Yu for TxPower
	strVal = boaGetVar(wp, "txpower", "");
	if ( strVal[0] ) {

		if (strVal[0] < '0' || strVal[0] > '5') {
			strcpy(tmpBuf, strInvdTxPower);
			goto setErr_wlan;
		}

		if(strVal[0]=='5')
			mode = 0;
		else
			mode = strVal[0] - '0';

		if ( mib_set( MIB_TX_POWER, (void *)&mode) == 0) {
   			strcpy(tmpBuf, strSetMIBTXPOWErr);
			goto setErr_wlan;
		}

		if(strVal[0]=='5')
			mode = 1;
		else
			mode = 0;

		if ( mib_set( MIB_WLAN_TX_POWER_HIGH, (void *)&mode) == 0) {
   			strcpy(tmpBuf, strSetMIBTXPOWErr);
			goto setErr_wlan;
		}
		

	}

	Entry.wlanMode = 0;
	strSSID = boaGetVar(wp, "ssid_name", "");
	
	if ( strSSID[0] ) {
		char real_ssid[64] = "";
		unsigned char ssidprefix_enable = 0;

		mib_get(MIB_WEB_WLAN_SSIDPREFIX_ENABLE, &ssidprefix_enable);
		if (ssidprefix_enable==1)
			sprintf(real_ssid, "CMCC-%s", strSSID);
		else
			sprintf(real_ssid, "%s", strSSID);

		strcpy(Entry.ssid, real_ssid);
	}

	strChan = boaGetVar(wp, "chan", "");
	if ( strChan[0] ) {
		errno=0;
		chan = strtol( strChan, (char **)NULL, 10);
		if (errno) {
   			strcpy(tmpBuf, strInvdChanNum);
			goto setErr_wlan;
		}
		if(chan != 0)
		{
			vChar = 0;	//disable auto channel
			if ( mib_set( MIB_WLAN_CHAN_NUM, (void *)&chan) == 0) {
				strcpy(tmpBuf, strSetChanErr);
				goto setErr_wlan;
			}
		}
		else
			vChar = 1;	//enable auto channel

		if ( mib_set( MIB_WLAN_AUTO_CHAN_ENABLED, (void *)&vChar) == 0) {
			strcpy(tmpBuf, strSetChanErr);
			goto setErr_wlan;
		}
	}

	char *strRate;
	unsigned short val;

	strVal = boaGetVar(wp, "band", "");
	if ( strVal[0] ) {
		mode = atoi(strVal);
		mode++;

		update_on_band_changed(&Entry, 0, mode);
#ifndef WLAN_USE_VAP_AS_SSID1
		if(wlmib_idx == WLAN_ROOT_ITF_INDEX)
			update_vap_band(mode); // Update vap band based on root band
#endif
		Entry.wlanBand = mode;
	}

	strVal = boaGetVar(wp, "chanwid", "");            //add by yq_zhou 2.10
	if ( strVal[0] ) {
		int band = mode;
		mode = strVal[0] - '0';
		if(mode == 2 && band < BAND_5G_11AC) //20/40MHz
		{  
			mode--;
			vChar = 1;
		}
		else
			vChar = 0;
		if ( mib_set( MIB_WLAN_CHANNEL_WIDTH, (void *)&mode) == 0) {
			strcpy(tmpBuf, strSetChanWidthErr);
			goto setErr_wlan;
		}
		if ( mib_set( MIB_WLAN_11N_COEXIST, (void *)&vChar) == 0) {
			strcpy(tmpBuf, strSet11NCoexistErr);
			goto setErr_wlan;
		}
	}

	strVal = boaGetVar(wp, "ctlband", "");            //add by yq_zhou 2.10
	if ( strVal[0] ) {
		mode = strVal[0] - '0';
		if ( mib_set( MIB_WLAN_CONTROL_BAND, (void *)&mode) == 0) {
			strcpy(tmpBuf, strSetCtlBandErr);
			goto setErr_wlan;
		}
	}

	// set tx rate
	strRate = boaGetVar(wp, "txRate", "");
	if ( strRate[0] ) {
		if ( strRate[0] == '0' ) { // auto
			Entry.rateAdaptiveEnabled = 1;
		}
		else  {
			Entry.rateAdaptiveEnabled = 0;
			{
				unsigned int uInt;
				uInt = atoi(strRate);
				if(uInt<30)
					uInt = 1 << (uInt-1);
				else
					uInt = ((1 << 31) + (uInt-30));
				
				Entry.fixedTxRate = uInt;
			}
			strRate = boaGetVar(wp, "basicrates", "");
			if ( strRate[0] ) {
				val = atoi(strRate);
				if ( mib_set(MIB_WLAN_BASIC_RATE, (void *)&val) == 0) {
					strcpy(tmpBuf, strSetBaseRateErr);
					goto setErr_wlan;
				}
			}

			strRate = boaGetVar(wp, "operrates", "");
			if ( strRate[0] ) {
				val = atoi(strRate);
				if ( mib_set(MIB_WLAN_SUPPORTED_RATE, (void *)&val) == 0) {
					strcpy(tmpBuf, strSetOperRateErr);
					goto setErr_wlan;
				}
			}
		}
	}
	else { // set rate in operate, basic sperately
#ifdef WIFI_TEST
		// disable rate adaptive
		Entry.rateAdaptiveEnabled = 0;

#endif // of WIFI_TEST
	}

	strVal = boaGetVar(wp, "beaconInterval", "");
	if (strVal[0]) {
		if ( !string_to_dec(strVal, &vInt) || vInt<20 || vInt>1024) {
			strcpy(tmpBuf, strInvdBeaconIntv);
			goto setErr_wlan;
		}
		uShort = (unsigned short)vInt;
		if ( mib_set(MIB_WLAN_BEACON_INTERVAL, (void *)&uShort) == 0) {
			strcpy(tmpBuf, strSetBeaconIntvErr);
			goto setErr_wlan;
		}
	}

	strVal = boaGetVar(wp, "dtimPeriod", "");
	if (strVal[0]) {
		if ( !string_to_dec(strVal, &vInt) || vInt<1 || vInt>255) {
			strcpy(tmpBuf, strInvdDTIMPerd);
			goto setErr_wlan;
		}
		vChar = (char)vInt;
		if ( mib_set(MIB_WLAN_DTIM_PERIOD, (void *)&vChar) == 0) {
			strcpy(tmpBuf, strSetDTIMErr);
			goto setErr_wlan;
		}
	}

	strVal = boaGetVar(wp, "fragThreshold", "");
	if (strVal[0]) {
		if ( !string_to_dec(strVal, &vInt) || vInt<256 || vInt>2346) {
			strcpy(tmpBuf, strFragThreshold);
			goto setErr_wlan;
		}
		uShort = (unsigned short)vInt;
		if ( mib_set(MIB_WLAN_FRAG_THRESHOLD, (void *)&uShort) == 0) {
			strcpy(tmpBuf, strSetFragThreErr);
			goto setErr_wlan;
		}
	}
	
	strVal = boaGetVar(wp, "rtsThreshold", "");
	if (strVal[0]) {
		if ( !string_to_dec(strVal, &vInt) || vInt<0 || vInt>2347) {
			strcpy(tmpBuf, strRTSThreshold);
			goto setErr_wlan;
		}
		uShort = (unsigned short)vInt;
		if ( mib_set(MIB_WLAN_RTS_THRESHOLD, (void *)&uShort) == 0) {
			strcpy(tmpBuf, strSetRTSThreErr);
			goto setErr_wlan;
		}
	}

	
	strVal = boaGetVar(wp, "protection", "");
	if(strVal[0])
	{
		if(strVal[0] == '0')
		{
			vChar = 1;
		}
		else if(strVal[0] == '1')
		{
			vChar = 0;
		}
		
		if (mib_set(MIB_WLAN_PROTECTION_DISABLED,(void *)&vChar) ==0){
			strcpy(tmpBuf, strSetProtectionErr);
			goto setErr_wlan;
		}
	}	

	strVal = boaGetVar(wp, "ssid_isolation", "");
	if (strVal[0]) {
		if (strVal[0] == '0')
			vChar = 0;
		else // '1'
			vChar = 1;
		Entry.ssidisolation= vChar;
	}

#ifdef WLAN_QoS
	strVal = boaGetVar(wp, "WmmEnabled", "");
	if (strVal[0]) {
		if (strVal[0] == '0')
			vChar = 0;
		else // '1'
			vChar = 1;
		Entry.wmmEnabled = vChar;
	}
#endif	

	// set hidden SSID
	strVal = boaGetVar(wp, "hiddenSSID", "");
	if (strVal[0] == '1')
		vChar = 1;
	else
		vChar = 0;
	
	Entry.hidessid = vChar;
	
	#ifdef WPS20
	if(vChar){//if hidden, wsc should disable
		Entry.wsc_disabled = vChar;
	}
	#endif

	strVal = boaGetVar(wp, "shortGI0", "");
	if (strVal[0]) {
		if (strVal[0] == '0')
		{
			vChar = 0;
		}
		else 
		{
			vChar = 1;
		}

		if (mib_set(MIB_WLAN_SHORTGI_ENABLED,(void *)&vChar) ==0){
			strcpy(tmpBuf, strSetShortGI0Err);
			goto setErr_wlan;
		}
	}
#ifdef WLAN_11K
	strVal = boaGetVar(wp, "dot11kEnabled", "");
	if (strVal[0]) {
		if (strVal[0] == '0')
			Entry.rm_activated = 0;
		else // '1'
			Entry.rm_activated = 1;
	}
#endif
#ifdef WLAN_11V
	strVal = boaGetVar(wp, "dot11vEnabled", "");
	if (strVal[0]) {
		if (strVal[0] == '0')
			Entry.BssTransEnable = 0;
		else // '1'
			Entry.BssTransEnable = 1;
	}
#endif
#ifdef WLAN_MESH
	strVal = boaGetVar(wp, "mesh_enable", "");
	if (strVal[0]) {
#ifdef WLAN_USE_VAP_AS_SSID1
		wlan_getEntry(&root_entry, WLAN_ROOT_ITF_INDEX);
		if (strVal[0] == '0')
			root_entry.wlanMode = AP_MODE;
		else // '1'
			root_entry.wlanMode = AP_MESH_MODE;
		wlan_setEntry(&root_entry, WLAN_ROOT_ITF_INDEX);
#else
		if (strVal[0] == '0')
			Entry.wlanMode = AP_MODE;
		else // '1'
			Entry.wlanMode = AP_MESH_MODE;
#endif
	}
	strVal = boaGetVar(wp, "swq_atm_enable", "");
	if (strVal[0]) {
		mib_get(MIB_SWQ_ATM_ENABLE, (void *)&swqatm_enable);
		if (strVal[0] == '0')
			vChar = 0;
		else
			vChar = 1;
		if(vChar != swqatm_enable)
			both_band_modify = 1;
		mib_set(MIB_SWQ_ATM_ENABLE, (void *)&vChar);
	}
#endif
#ifdef RTK_SMART_ROAMING
	strVal = boaGetVar(wp, "smart_roaming_enable", "");
	if (strVal[0]) {
		unsigned char capwap_mode, wtp_id;
		char *str_SR_Auto;
		char *str_SR_opmode_select_ac;
		char *SR_mesh_psk_gen_enable;
		
		if ( strVal[0] == '1' ) {
			capwap_mode = ROAMING_ENABLE;
			wtp_id = 1;

			str_SR_Auto = boaGetVar(wp, "SR_AutoConfig_enable", "");
			if (str_SR_Auto[0]) {
				if ( str_SR_Auto[0] == '1' ) {
					capwap_mode |= CAPWAP_AUTO_CONFIG_ENABLE;
				}
			}

			str_SR_opmode_select_ac = boaGetVar(wp, "SR_opmode_select_ac", "");
			if (str_SR_opmode_select_ac[0]) {
				if ( str_SR_opmode_select_ac[0] == '1' ) {
					capwap_mode |= CAPWAP_OPMODE_SELECT_AC_ENABLE;
				}
			}
			
			SR_mesh_psk_gen_enable = boaGetVar(wp, "SR_mesh_psk_gen_enable", "");
			if (SR_mesh_psk_gen_enable[0]) {
				if ( SR_mesh_psk_gen_enable[0] == '1' ) {
					capwap_mode |= CAPWAP_AC_MESH_PSK_GENERATOR_ENABLE;
				}
			}

#if defined(WLAN_11V) && defined(WLAN_11K)
			strDisabled = boaGetVar(wp, "dot11kEnabled", "");
			if (strDisabled[0]) {
				if (strDisabled[0] == '1'){
					strDisabled = boaGetVar(wp, "dot11vEnabled", "");
					if (strDisabled[0]) {
						if (strDisabled[0] == '1'){
							capwap_mode |= CAPWAP_11V_ENABLE;
						}
					}
				}
			}
#endif
		}		
		else if ( strVal[0] == '0' ) {
			capwap_mode = 0;
			wtp_id = 0;
		}	
		else{
			strcpy(tmpBuf, strVal);
			goto setErr_wlan;
		}
	
		mib_set(MIB_CAPWAP_MODE,(void *)&capwap_mode);
		mib_set(MIB_CAPWAP_WTP_ID,(void *)&wtp_id);
	}
#endif
#ifdef WLAN_BAND_STEERING
	strVal = boaGetVar(wp, "sta_control", "");
	if (strVal[0]) {
		mib_get(MIB_WIFI_STA_CONTROL, &band_steering);
		vChar = 0;
		if (strVal[0] == '0')
			vChar &= ~STA_CONTROL_ENABLE;
		else // '1'
			vChar |= STA_CONTROL_ENABLE;
		strVal = boaGetVar(wp, "stactrl_prefer_band", "");
		if(strVal[0]){
			if (strVal[0] == '0')
				vChar &= ~STA_CONTROL_PREFER_BAND;
			else
				vChar |= STA_CONTROL_PREFER_BAND;
		}
		else{
			vChar |= (band_steering & STA_CONTROL_PREFER_BAND);
		}
		if(vChar != band_steering)
			both_band_modify = 1;
		mib_set(MIB_WIFI_STA_CONTROL, &vChar);
	}
#endif
#ifdef WLAN_MESH
	mib_chain_get(MIB_WLAN_SSID_SPEED_TBL, wlmib_idx, (void *)&speed_entry);
	strVal = boaGetVar(wp, "tx_restrict", "");
	if (strVal[0]) {
		speed_entry.thrd_tx = atoi(strVal);
	}
	strVal = boaGetVar(wp, "rx_restrict", "");
	if (strVal[0]) {
		speed_entry.thrd_rx = atoi(strVal);
	}
	mib_chain_update(MIB_WLAN_SSID_SPEED_TBL, (void *)&speed_entry, wlmib_idx);
#endif

	mib_chain_update(MIB_MBSSIB_TBL, (void *)&Entry, wlmib_idx);

#if defined(CONFIG_CMCC) || defined(CONFIG_CU)
//--------------------------------
// Encrypt
	char *strEncrypt;
	char *strKeyLen, *strFormat, *wepKey, *strAuth;
	int key_index=0, key_i;
	char *strKeySelcted;
	char strbuf_idx[16], strbuf_errmsg1[16], strbuf_errmsg2[16];
	WIFI_SECURITY_T encrypt;
	int enableRS=0, intVal, getPSK=0, len, keyLen;
	SUPP_NONWAP_T suppNonWPA;
	struct in_addr inIp;
	WEP_T wep;
	char key[30];
	AUTH_TYPE_T authType;
#ifndef WLAN_DUALBAND_CONCURRENT
	int i;
#endif

	strVal = boaGetVar(wp, "wpaSSID", "");

	if (strVal[0]) {
		i = strVal[0]-'0';
		if (i<0 || i > NUM_VWLAN_INTERFACE) {
			strcpy(tmpBuf, strNotSuptSSIDType);
			goto setErr_encrypt;
		}

	} else {
		strcpy(tmpBuf, strNoSSIDTypeErr);
		goto setErr_encrypt;
	}

	if (!wlan_getEntry(&Entry, wlmib_idx)){
		strcpy(tmpBuf, strGetMBSSIBTBLErr);
		goto setErr_encrypt;
	}

	strEncrypt = boaGetVar(wp, "security_method", "");
	if (!strEncrypt[0]) {
 		strcpy(tmpBuf, strNoEncryptionErr);
		goto setErr_encrypt;
	}

	encrypt = (WIFI_SECURITY_T) strEncrypt[0] - '0';
	if(encrypt == 3)
	{
		encrypt = WIFI_SEC_WPA2;
	}
	else if(encrypt == 4)
	{
		encrypt = WIFI_SEC_WPA2_MIXED;
	}
	
	vChar = (char)encrypt;
	Entry.encrypt = vChar;

	if (encrypt == WIFI_SEC_NONE || encrypt == WIFI_SEC_WEP) {

#ifdef WLAN_1x
		strVal = boaGetVar(wp, "use1x", "");
		if ( !gstrcmp(strVal, "ON")) {
			vChar = Entry.wlanMode;
			if (vChar) { // not AP mode
				strcpy(tmpBuf, strSet8021xWarning);
				goto setErr_encrypt;
			}
			vChar = 1;
			enableRS = 1;
		}
		else
			vChar = 0;
		Entry.enable1X = vChar;
#endif

		if (encrypt == WIFI_SEC_WEP) {
	 		WEP_T wep;
			// Mason Yu. 201009_new_security. If wireless do not use 802.1x for wep mode. We should set wep key and Authentication type.
			if ( enableRS != 1 ) {
				// (1) Authentication Type
				strAuth = boaGetVar(wp, "auth_type", "");
				if(strAuth[0] == '0')
				{
					authType = AUTH_OPEN;
				}
				else if(strAuth[0] == '1')
				{
					authType = AUTH_SHARED;
				}
				else if(strAuth[0] == '2')
				{
					authType = AUTH_BOTH;
				}
				else 
				{
					strcpy(tmpBuf, strInvdAuthType);
					goto setErr_encrypt;
				}

				vChar = (char)authType;
				Entry.authType = vChar;
				
				// (2) Key Length
				strKeyLen = boaGetVar(wp, "length0", "");
				if (!strKeyLen[0]) {
 					strcpy(tmpBuf, strKeyLenMustExist);
					goto setErr_encrypt;
				}
				if (strKeyLen[0]!='0' && strKeyLen[0]!='1') {
 					strcpy(tmpBuf, strInvdKeyLen);
					goto setErr_encrypt;
				}
				if (strKeyLen[0] == '0')
					wep = WEP64;
				else
					wep = WEP128;

				vChar = (char)wep;
				Entry.wep = vChar;

				// (3) Key Format
				Entry.wepKeyType = 0;

				if (wep == WEP64) {
						keyLen = WEP64_KEY_LEN;
				}
				else {
						keyLen = WEP128_KEY_LEN;
				}

				// Key selected
				strKeySelcted = boaGetVar(wp, "defaultKeyidx", "");
				if (!strKeySelcted[0]) {
					strcpy(tmpBuf, strKeySelectedMustExist);
					goto setErr_encrypt;
				}
				if (strKeySelcted[0]!='0' && strKeySelcted[0]!='1' && strKeySelcted[0]!='2' && strKeySelcted[0]!='3') {
					strcpy(tmpBuf, strInvdKeySel);
					goto setErr_encrypt;
				}
				if (strKeySelcted[0] == '0')
					key_index = 0;
				else if (strKeySelcted[0] == '1')
					key_index = 1;
				else if (strKeySelcted[0] == '2')
					key_index = 2;
				else
					key_index = 3;

				Entry.wepDefaultKey = key_index;

				// (4) Encryption Key
				//
				for (key_i=0; key_i<4; key_i++)
				{
					sprintf(strbuf_idx, "wep_key%d", key_i);
					sprintf(strbuf_errmsg1, "strInvdKey%dLen", key_i+1);
					sprintf(strbuf_errmsg2, "strInvdWEPKey%d", key_i+1);

					wepKey = boaGetVar(wp, strbuf_idx, "");
				
					if  (wepKey[0]) 
					{
						if (strlen(wepKey) == WEP64_KEY_LEN || strlen(wepKey) == WEP128_KEY_LEN) 
						{
							Entry.wepKeyType = 0;
						}
						else
						{
							Entry.wepKeyType = 1;
							
						}

						keyLen = strlen(wepKey);
						if ( !isAllStar(wepKey) ) 
						{
							if(!Entry.wepKeyType)
							{
								strcpy(key, wepKey);	
							}
							else 
							{ // hex
								if ( !rtk_string_to_hex(wepKey, key, keyLen)) 
								{
									strcpy(tmpBuf, strbuf_errmsg2);
									goto setErr_encrypt;
								}
							}
							if (wep == WEP64)
							{
								switch(key_i)
								{
									case 0:
										memcpy(Entry.wep64Key1, key, WEP64_KEY_LEN);
										break;
									case 1:
										memcpy(Entry.wep64Key2, key, WEP64_KEY_LEN);
										break;
									case 2:
										memcpy(Entry.wep64Key3, key, WEP64_KEY_LEN);
										break;
									case 3:
										memcpy(Entry.wep64Key4, key, WEP64_KEY_LEN);
										break;
								}
							}
							else
							{
								switch(key_i)
								{
									case 0:
										memcpy(Entry.wep128Key1, key, WEP128_KEY_LEN);
										break;
									case 1:
										memcpy(Entry.wep128Key2, key, WEP128_KEY_LEN);
										break;
									case 2:
										memcpy(Entry.wep128Key3, key, WEP128_KEY_LEN);
										break;
									case 3:
										memcpy(Entry.wep128Key4, key, WEP128_KEY_LEN);
										break;
								}
							}
						}
					}
				}// (4) Encryption Key
			}
			#ifdef WPS20
			if (0 == i) {
				Entry.wsc_disabled = 1;
			}
			#endif
		}
	}
#ifdef CONFIG_RTL_WAPI_SUPPORT
	/* assume MBSSID for now. */
	else if (encrypt == WIFI_SEC_WAPI) {
		char *wapiAuth=0, *pskFormat=0, *pskValue=0;
		unsigned char asIP[IP_ADDR_LEN]={0}, wapiType=0;
		int len;
		//fprintf(stderr, "%s(%d):\n", __FUNCTION__,__LINE__);
		wapiAuth = boaGetVar(wp, "wapiAuth", "");

		if (wapiAuth[0] == '1') {
			wapiType = 1;
			//asIP = boaGetVar(wp, "radiusIP", "");
			//fprintf(stderr, "%s(%d): %p\n", __FUNCTION__,__LINE__, asIP);
		}
		else if (wapiAuth[0] == '2') {
			wapiType = 2;
			pskFormat = boaGetVar(wp, "wapipskFormat", "");
			pskValue = boaGetVar(wp, "wapipskValue", "");
			len = strlen(pskValue);
		}
		else {
			strcpy(tmpBuf, strInvdWPAAuthValue);
			goto setErr_encrypt;
		}


		//fprintf(stderr, "%s(%d):\n", __FUNCTION__,__LINE__);
		if (0 == i) {

			Entry.wapiAuth = wapiType;
			if (wapiType == 2) { // PSK
				vChar = pskFormat[0] - '0';
				if (vChar != 0 && vChar != 1) {
					strcpy(tmpBuf, strInvdPSKFormat);
					goto setErr_encrypt;
				}
				Entry.wapiPskFormat = vChar;//mib_set(MIB_WLAN_WAPI_PSK_FORMAT, (void *)&vChar);
				if (vChar == 1) {// hex
					printf("(%s,%d) pskstring:%s\n",__func__,__LINE__,pskValue);
					memset(tmpBuf, 0, sizeof(tmpBuf));
					if (!rtk_string_to_hex(pskValue, tmpBuf, len)) {
						strcpy(tmpBuf, strInvdPSKValue);
						printf("(%s,%d) invalid pskvalue\n",__func__,__LINE__);
						goto setErr_encrypt;
					}


					if ((len & 1) || (len/2 >= MAX_PSK_LEN)) {
						strcpy(tmpBuf, strInvdPSKValue);
						goto setErr_encrypt;
					}
					len = len / 2;
					vChar = len;
					Entry.wapiPskLen = vChar;//mib_set(MIB_WLAN_WAPI_PSKLEN, &vChar);
					strcpy(Entry.wapiPsk, tmpBuf);//mib_set(MIB_WLAN_WAPI_PSK, (void *)tmpBuf);

				} else { // passphrase

					if (len==0 || len > (MAX_PSK_LEN - 1)) {
						strcpy(tmpBuf, strInvdPSKValue);
						goto setErr_encrypt;
					}
					vChar = len;
					Entry.wapiPskLen = vChar;//mib_set(MIB_WLAN_WAPI_PSKLEN, &vChar);
					strcpy(Entry.wapiPsk, pskValue);//mib_set(MIB_WLAN_WAPI_PSK, (void *)pskValue);

				}

			} else { // AS
				if ( !mib_get(MIB_ADSL_LAN_IP, (void *)&inIp) ) {
					strcpy(tmpBuf, strInvdRSIPValue);
					goto setErr_encrypt;
				}
				*((unsigned long *)Entry.wapiAsIpAddr) = inIp.s_addr;
			}

		} else {
			//fprintf(stderr, "%s(%d):\n", __FUNCTION__,__LINE__);
			mib_set(MIB_WLAN_WAPI_AUTH, (void *)&wapiType);
			if (wapiType == 2) { // PSK
				vChar = pskFormat[0] - '0';
				if (vChar != 0 && vChar != 1) {
					strcpy(tmpBuf, strInvdPSKFormat);
					goto setErr_encrypt;
				}
				mib_set(MIB_WLAN_WAPI_PSK_FORMAT, (void *)&vChar);
				if (vChar == 1) {// hex
					if (!rtk_string_to_hex(pskValue, tmpBuf, MAX_PSK_LEN)) {
						strcpy(tmpBuf, strInvdPSKValue);
						goto setErr_encrypt;
					}
					//fprintf(stderr, "%s(%d): %08x%08x%08x%08x\n",
					//	__FUNCTION__,__LINE__, (long *)&pskValue[0],
					//	(long *)&pskValue[4],(long *)&pskValue[8],(long *)&pskValue[12]);
					if ((len & 1) || (len/2 >= MAX_PSK_LEN)) {
						strcpy(tmpBuf, strInvdPSKValue);
						goto setErr_encrypt;
					}
					len = len / 2;
					vChar = len;
					mib_set(MIB_WLAN_WAPI_PSKLEN, &vChar);
					mib_set(MIB_WLAN_WAPI_PSK, (void *)pskValue);

				} else { // passphrase

					if (len==0 || len > (MAX_PSK_LEN - 1)) {
						strcpy(tmpBuf, strInvdPSKValue);
						goto setErr_encrypt;
					}
					vChar = len;
					mib_set(MIB_WLAN_WAPI_PSKLEN, &vChar);
					mib_set(MIB_WLAN_WAPI_PSK, (void *)pskValue);

				}

			} else { // AS
				//fprintf(stderr, "%s(%d):\n", __FUNCTION__,__LINE__);
				if ( !inet_aton(asIP, &inIp) ) {
					strcpy(tmpBuf, strInvdRSIPValue);
					goto setErr_encrypt;
				}
				//fprintf(stderr, "%s(%d):\n", __FUNCTION__,__LINE__);
				mib_set(MIB_WLAN_WAPI_ASIPADDR, (void *)&inIp);
			}


		}
	}
#endif 	// CONFIG_RTL_WAPI_SUPPORT
	else {	// WPA
#ifdef WPS20
		unsigned char disableWps = 0;
#endif //WPS20
#ifdef WLAN_1x
		// WPA authentication
		vChar = 0;
		Entry.enable1X = vChar;

		strVal = boaGetVar(wp, "wpaAuth", "");
		if (strVal[0]) {
			if ( !gstrcmp(strVal, "eap")) {
				vChar = Entry.wlanMode;
				if (vChar) { // not AP mode
					strcpy(tmpBuf, strSetWPARADIUSWarn);
					goto setErr_encrypt;
				}
				vChar = WPA_AUTH_AUTO;
				enableRS = 1;
			}
			else if ( !gstrcmp(strVal, "psk")) {
				vChar = WPA_AUTH_PSK;
				getPSK = 1;
			}
			else {
				strcpy(tmpBuf, strInvdWPAAuthValue);
				goto setErr_encrypt;
			}
			Entry.wpaAuth = vChar;
		}
#endif

		// Mason Yu. 201009_new_security. Set ciphersuite(wpa_cipher) for wpa/wpa mixed
		if ((encrypt == WIFI_SEC_WPA) || (encrypt == WIFI_SEC_WPA2_MIXED)) {
			unsigned char intVal = 0;
			unsigned char val2;

			strVal = boaGetVar(wp, "ciphersuite", ""); 
			if (strVal[0]) {
				if (strVal[0] == '0') 
				{    
					intVal |= WPA_CIPHER_TKIP;
				}    
				else if (strVal[0] == '1') 
				{    
					intVal |= WPA_CIPHER_AES;
				}    
				else if (strVal[0] == '2') 
				{    
					intVal |= WPA_CIPHER_MIXED;
				}    
			}

			if ( intVal == 0 )
				intVal = WPA_CIPHER_TKIP;

				Entry.unicastCipher = intVal;

			if(i==0){
				#ifdef WPS20
				if ((encrypt == WIFI_SEC_WPA) ||
					(encrypt == WIFI_SEC_WPA2_MIXED && intVal == WPA_CIPHER_TKIP)) {	//disable wps if wpa only or tkip only
					disableWps = 1;
				}
				#endif
			}
		}

		// Mason Yu. 201009_new_security. Set wpa2ciphersuite(wpa2_cipher) for wpa2/wpa mixed
		if ((encrypt == WIFI_SEC_WPA2) || (encrypt == WIFI_SEC_WPA2_MIXED)) {
			unsigned char intVal = 0;

			strVal = boaGetVar(wp, "ciphersuite", ""); 
			if (strVal[0]) 
			{
				if (strVal[0] == '0') 
				{    
					intVal |= WPA_CIPHER_TKIP;
				}    
				else if (strVal[0] == '1') 
				{    
					intVal |= WPA_CIPHER_AES;
				}    
				else if (strVal[0] == '2') 
				{    
					intVal |= WPA_CIPHER_MIXED;
				}    
			}

			if ( intVal == 0 )
				intVal = WPA_CIPHER_AES;

			Entry.wpa2UnicastCipher = intVal;

			if(i == 0){
				#ifdef WPS20
				if (encrypt == WIFI_SEC_WPA2) {
					if (intVal == WPA_CIPHER_TKIP)
						disableWps = 1;
				}
				else { // mixed
					if (intVal == WPA_CIPHER_TKIP && disableWps)	//disable wps if wpa2 mixed + tkip only
						disableWps = 1;
					else
						disableWps = 0;
				}
				#endif //WPS20
			}
		}
		#ifdef WPS20
		if (disableWps) {
			Entry.wsc_disabled = 1;
		}
		#endif //WPS20
		// pre-shared key
		if ( getPSK ) {
#if 0			
			strVal = boaGetVar(wp, "pskFormat", "");
			if (!strVal[0]) {
	 			strcpy(tmpBuf, strNoPSKFormat);
				goto setErr_encrypt;
			}
			vChar = strVal[0] - '0';
			
			//vChar = 0;
			if (vChar != 0 && vChar != 1) {
	 			strcpy(tmpBuf, strInvdPSKFormat);
				goto setErr_encrypt;
			}

#endif
			strVal = boaGetVar(wp, "pskValue", "");
			len = strlen(strVal);

			vChar = 0;
			Entry.wpaPSKFormat = 0;

			if (vChar==1) { // hex
				if (len!=MAX_PSK_LEN || !rtk_string_to_hex(strVal, tmpBuf, MAX_PSK_LEN)) {
	 				strcpy(tmpBuf, strInvdPSKValue);
					goto setErr_encrypt;
				}
			}
			else { // passphras
				if (len > (MAX_PSK_LEN - 1) ) {
	 				strcpy(tmpBuf, strInvdPSKValue);
					goto setErr_encrypt;
				}
			}
			strcpy(Entry.wpaPSK, strVal);
			
		}
	}
#ifdef WLAN_1x
	if (enableRS == 1) { // if 1x enabled, get RADIUS server info
		unsigned short uShort;

		strVal = boaGetVar(wp, "radiusPort", "");
		if (!strVal[0]) {
			strcpy(tmpBuf, "û��RS�˿���ֵ!"); //No RS port number!
			goto setErr_encrypt;
		}
		if (!string_to_dec(strVal, &intVal) || intVal<=0 || intVal>65535) {
			strcpy(tmpBuf, strInvdRSPortNum);
			goto setErr_encrypt;
		}
		uShort = (unsigned short)intVal;
		Entry.rsPort = uShort;

		strVal = boaGetVar(wp, "radiusIP", "");
		if (!strVal[0]) {
			strcpy(tmpBuf, strNoIPAddr);
			goto setErr_encrypt;
		}
		if ( !inet_aton(strVal, &inIp) ) {
			strcpy(tmpBuf, strInvdRSIPValue);
			goto setErr_encrypt;
		}
		*((unsigned long *)Entry.rsIpAddr) = inIp.s_addr;

		strVal = boaGetVar(wp, "radiusPass", "");
		if (strlen(strVal) > (MAX_PSK_LEN) ) {
			strcpy(tmpBuf, strRSPwdTooLong);
			goto setErr_encrypt;
		}
		strcpy(Entry.rsPassword, strVal);

		strVal = boaGetVar(wp, "radiusRetry", "");
		if (strVal[0]) {
			if ( !string_to_dec(strVal, &intVal) ) {
				strcpy(tmpBuf, strInvdRSRetry);
				goto setErr_encrypt;
			}
			vChar = (char)intVal;
			if ( !mib_set(MIB_WLAN_RS_RETRY, (void *)&vChar)) {
				strcpy(tmpBuf, strSetRSRETRYErr);
				goto setErr_encrypt;
			}
		}
		strVal = boaGetVar(wp, "radiusTime", "");
		if (strVal[0]) {
			if ( !string_to_dec(strVal, &intVal) ) {
				strcpy(tmpBuf, strInvdRSTime);
				goto setErr_encrypt;
			}
			uShort = (unsigned short)intVal;
			if ( !mib_set(MIB_WLAN_RS_INTERVAL_TIME, (void *)&uShort)) {
				strcpy(tmpBuf, strSetRSINTVLTIMEErr);
				goto setErr_encrypt;
			}
		}
	}
#endif

	wlan_setEntry(&Entry, wlmib_idx);

	sleep(5);

#ifdef COMMIT_IMMEDIATELY
	Commit();
#endif // of #if COMMIT_IMMEDIATELY

	//set SSID1-SSID3 or SSID5-SSID7
	int mbssid_setting = 0;
	strVal = boaGetVar(wp, "mbssid_setting", "");
	if(strVal[0])
		mbssid_setting = strVal[0]-'0';
	if(mbssid_setting)
	{
		MIB_CE_MBSSIB_T mbentry;
		int ssid_idx;
		for(ssid_idx = 0; ssid_idx < 3; ssid_idx++){
			char enablessid_str[32]={0};
			char hidenssid_str[32]={0};
			char userisolation_str[32]={0};
			char wmmenable_str[32]={0};
			char wmfenable_str[32]={0};
			char stanum_str[32]={0};
			int web_ssid_idx = ssid_idx+1;
#ifdef WLAN_DUALBAND_CONCURRENT
			if(wlan_idx==1)
				web_ssid_idx = (ssid_idx + 1 + 4);
#endif
			sprintf(enablessid_str,"enable_ssid%d",web_ssid_idx);
			sprintf(hidenssid_str,"hidenssid_ssid%d",web_ssid_idx);
			sprintf(userisolation_str,"userisolation_ssid%d",web_ssid_idx);
			sprintf(wmmenable_str,"wmmenable_ssid%d",web_ssid_idx);
			sprintf(wmfenable_str,"wmfenable_ssid%d",web_ssid_idx);
			sprintf(stanum_str,"stanum_ssid%d",web_ssid_idx);

			memset(&mbentry, 0, sizeof(MIB_CE_MBSSIB_T));
			wlan_getEntry((void *)&mbentry, ssid_idx);

			// set enable SSID
			strVal = boaGetVar(wp, enablessid_str, "");
			if (!gstrcmp(strVal, "ON"))
				mbentry.wlanDisabled = 0;
			else
				mbentry.wlanDisabled = 1;
		
			// set hide SSID
			strVal = boaGetVar(wp, hidenssid_str, "");
			if (!gstrcmp(strVal, "ON"))
				mbentry.hidessid = 1;
			else
				mbentry.hidessid = 0;

			//set user isolation
			strVal = boaGetVar(wp, userisolation_str, "");
			if (!gstrcmp(strVal, "ON"))
				mbentry.userisolation = 1;
			else
				mbentry.userisolation = 0;

			//set wmm enable
			strVal = boaGetVar(wp, wmmenable_str, "");
			if (!gstrcmp(strVal, "ON"))
				mbentry.wmmEnabled = 1;
			else
				mbentry.wmmEnabled = 0;

			//set wmf enable
			strVal = boaGetVar(wp, wmfenable_str, "");
			if (!gstrcmp(strVal, "ON"))
				mbentry.mc2u_disable = 0;
			else
				mbentry.mc2u_disable = 1;

			//set sta num
			strVal = boaGetVar(wp, stanum_str, "");
			if (strVal[0]) {
				if ( !string_to_dec(strVal, &vInt)) {
					strcpy(tmpBuf, strStanumErr);
					goto setErr_wlan;
				}

				mbentry.stanum = vInt;
			}

			wlan_setEntry((void *)&mbentry, ssid_idx);
		}
	}

//---------------------------------
//WPS
	char tmpbuf_wps[200];
	int action = 0, ssididx;
	pid_t pid;
	char *msg = "echo 1> /var/cmcc_wsc_running";
	int needRestartWlan = 0;
	char wps_ifname[IFNAMSIZ]={0};

	wlan_getEntry((void *)&Entry, wlmib_idx);

	strVal = boaGetVar(wp, "ssid_wps", "");
	if (strVal[0]== '1' )
	{
		intVal = 0;
	}
	else
	{
		intVal = 1;
	}

	if(Entry.wsc_disabled == 1 && intVal == 0)
	{
		needRestartWlan = 1;
	}
	
	Entry.wsc_disabled = intVal;
	wlan_setEntry((void *)&Entry, wlmib_idx);
	update_wps_mib();
	
	strVal  = boaGetVar(wp, "action", "");
	if(strVal[0] == '1')
	{
		action = 1;
	}
	

	strVal  = boaGetVar(wp, "wpsmode", "");
	if(strVal[0] =='0' && action)		//PBC mode
	{
#ifndef WLAN_WPS_MULTI_DAEMON
		if(wlan_idx==0) 
			ssididx = 1;
		else
			ssididx = 5;
		set_wps_ssid(ssididx);
#endif
		if(needRestartWlan)
		{
#ifdef COMMIT_IMMEDIATELY
			Commit();
#endif // of #if COMMIT_IMMEDIATELY
			
#ifndef NO_ACTION
			run_script(mode);
#endif
			config_WLAN(ACT_RESTART_2G, wlmib_idx);
		}

		if(wlan_idx == 0 )
		{
			system("echo 1 > /var/wps_start_interface0");
		}
		else
		{
			system("echo 1 > /var/wps_start_interface1");
		}
			
		rtk_wlan_get_ifname(wlan_idx, 0, wps_ifname);
		va_cmd(WSC_DAEMON_PROG, 2 , 1 , "-sig_pbc" , wps_ifname);
		
		submitUrl = boaGetVar(wp, "submit-url", "");
		boaRedirect(wp, submitUrl);
		return;
	}

	if(strVal[0] =='1' && action)		//PIN mode
	{

		char tmpbuf[200];
		strVal = boaGetVar(wp, "generate_pin_type", "");
		if (strVal[0] == '2'){	//peerPin
			if(needRestartWlan)
			{
#ifdef COMMIT_IMMEDIATELY
				Commit();
#endif // of #if COMMIT_IMMEDIATELY
			
#ifndef NO_ACTION
				run_script(mode);
#endif
				config_WLAN(ACT_RESTART_2G, wlmib_idx);
			}
			strVal = boaGetVar(wp, "wpspin", "");
			if (strVal[0]) {
				if(wlan_idx == 0)
				{
					system("echo 1 > /var/wps_start_interface0");
				}
				else
				{
					system("echo 1 > /var/wps_start_interface1");
				}
				sprintf(tmpbuf, "pin=%s", strVal);
				rtk_wlan_get_ifname(wlan_idx, 0, wps_ifname);
				va_cmd("/bin/iwpriv", 3, 1, wps_ifname, "set_mib", tmpbuf);

				submitUrl = boaGetVar(wp, "submit-url", "");
				boaRedirect(wp, submitUrl);
				return;
			}
		}
	}

	if(wlmib_idx == 0){ //update for root ssid only

		if(Entry.wsc_disabled == 0){
			strVal = boaGetVar(wp, "wpspin", "");		//localPin
			if (strVal[0]){
				int local_pin_changed = 0;
				char wpin[PIN_LEN+1]={0};
				mib_get(MIB_WSC_PIN, (void *)wpin);
				if (strcmp(wpin, strVal)) {
					mib_set(MIB_WSC_PIN, (void *)strVal);
					local_pin_changed = 1;
#ifdef WLAN_DUALBAND_CONCURRENT
					both_band_modify = 1;
#endif
				}
				#if 0
				if(local_pin_changed){
					if(wlan_idx==0) 
						ssididx = 1;
					else
						ssididx = 5;
					mib_get(MIB_WPS_SSID, &vChar);
					if(vChar != ssididx){
						vChar = ssididx;
						mib_set(MIB_WPS_SSID, &vChar);
					}
				}
				#endif
			}
		}
	}

#endif

setwlan_ret:
#ifdef CONFIG_WIFI_SIMPLE_CONFIG//WPS def WIFI_SIMPLE_CONFIG
	{
		int ret;
		char *wepKey;
		wepKey = boaGetVar(wp, "wps_clear_configure_by_reg0", "");
		ret = 0;
		if (wepKey && wepKey[0])
			ret = atoi(wepKey);
		update_wps_configured(ret);
	}
#endif
#ifdef WLAN_DUALBAND_CONCURRENT
	{
		int orig_wlan_idx = wlan_idx;
		wlan_idx = 1 - wlan_idx;
#if 0
		mib_chain_get(MIB_MBSSIB_TBL, 0, (void *)&Entry);
		if(Entry.wlanDisabled != disabled){
			Entry.wlanDisabled = disabled;
			mib_chain_update(MIB_MBSSIB_TBL, (void *)&Entry, 0);
		}
#endif
	
#ifdef CONFIG_WIFI_SIMPLE_CONFIG//WPS def WIFI_SIMPLE_CONFIG
	{
		int ret;
		char *wepKey;
		wepKey = boaGetVar(wp, "wps_clear_configure_by_reg0", "");
		ret = 0;
		if (wepKey && wepKey[0])
			ret = atoi(wepKey);
		update_wps_configured(ret);
	}
#endif
		wlan_idx = orig_wlan_idx;
	}
#endif

setwlan_module_disable:
//cmcc enterprise need when root ssid is disabled, the other vap ssid should work normally.
vmChar = 0;
mib_local_mapping_set(MIB_WLAN_DISABLED, wlan_idx, (void *)&vmChar);

setwlan_module_all_disable:
submitUrl = boaGetVar(wp, "submit-url", "");   // hidden page

#ifdef WLAN_BAND_STEERING
	if(rtk_wlan_update_band_steering_status()==1)
		both_band_modify = 1;
#endif

// Magician: Commit immediately
#ifdef COMMIT_IMMEDIATELY
	Commit();
#endif // of #if COMMIT_IMMEDIATELY

#ifndef NO_ACTION
	run_script(mode);
#endif

#ifdef RTK_SMART_ROAMING
	update_RemoteAC_Config();
#endif

#ifdef CONFIG_YUEME
#ifdef WLAN_DUALBAND_CONCURRENT
	if(both_band_modify == 0)
		config_WLAN_seperate(ACT_RESTART, wlan_idx);
	else
#endif
#endif

#if defined(CONFIG_CMCC) || defined(CONFIG_CU)
	if(wlan_idx == 0)
	{
#ifdef WLAN_DUALBAND_CONCURRENT
		if(both_band_modify==1)
			config_WLAN(ACT_RESTART, CONFIG_SSID_ALL);
		else
#endif
#ifndef WLAN_DUALBAND_CONCURRENT
		if(all_ssid_modify==1)
			config_WLAN(ACT_RESTART_2G, CONFIG_SSID_ALL);
		else
#endif
		{
			if(mbssid_setting)
				config_WLAN(ACT_RESTART_2G, CONFIG_SSID_ALL);
			else
				config_WLAN(ACT_RESTART_2G, wlmib_idx);
		}
	}
	else
	{
#ifdef WLAN_DUALBAND_CONCURRENT
		if(both_band_modify==1)
			config_WLAN(ACT_RESTART, CONFIG_SSID_ALL);
		else	
#endif
			config_WLAN(ACT_RESTART_5G, wlmib_idx);
	}
#else
	config_WLAN(ACT_RESTART, CONFIG_SSID_ALL);
#endif

//	submitUrl = boaGetVar(wp, "submit-url", "");   // hidden page
	if (warn) {
		OK_MSG1(tmpBuf, submitUrl);
	}
	else {
		//OK_MSG(submitUrl);
		if (submitUrl[0])
			boaRedirect(wp, submitUrl);
		else
			boaDone(wp, 200);
	}
	return;

setErr_wlan:
	ERR_MSG(tmpBuf);

#if defined(CONFIG_CMCC) || defined(CONFIG_CU)
setErr_encrypt:
	ERR_MSG(tmpBuf);
#endif
}
#endif


#if defined(WLAN_SUPPORT) && (defined(CONFIG_CMCC) || defined(CONFIG_CU_BASEON_CMCC) || defined(CONFIG_USER_AP_CMCC))
int wlan_interface_status_get(int eid, request * wp, int argc, char **argv, int band)
{
	int status;
	MIB_CE_MBSSIB_T Entry;
#if defined(WLAN_DUALBAND_CONCURRENT)
	int orig_idx = wlan_idx;
#endif
	int i, j;
	unsigned char phyband=PHYBAND_2G;

	//process wlan interface
	for(i=0; i<NUM_WLAN_INTERFACE; i++){
		wlan_idx = i;
		if(mib_get_s(MIB_WLAN_PHY_BAND_SELECT, &phyband, sizeof(phyband))){
			if(band == phyband)
				break;
		}
	}
	if(i>=NUM_WLAN_INTERFACE){
#if defined(WLAN_DUALBAND_CONCURRENT)
		wlan_idx = orig_idx;
#endif
		return -1;
	}

		status = 0;
		
		mib_chain_get(MIB_MBSSIB_TBL, 0, (void *)&Entry);
		if(Entry.wlanDisabled==0){
			status=1;
		}

		if(status==0){
			for(j=0; j<WLAN_MBSSID_NUM; j++){
				mib_chain_get(MIB_MBSSIB_TBL, j+1, (void *)&Entry);
				if(Entry.wlanDisabled==0){
					status=1;
					break;
				}
			}
		}
		
		boaWrite(wp, "wlan_root_interface_up[%d]=%d;\n", wlan_idx, status);
#if defined(WLAN_DUALBAND_CONCURRENT)
	wlan_idx = orig_idx;
#endif
	return 0;
}

int wlan_interface_status_24G(int eid, request * wp, int argc, char **argv)
{
	return wlan_interface_status_get(eid, wp, argc, argv, PHYBAND_2G);
}

int wlStatsList_get(int eid, request * wp, int argc, char **argv, int band)
{
	int i, intf_num = 0, orig_wlan_idx;
	char ssid[MAX_SSID_LEN];
	struct net_device_stats nds;
	MIB_CE_MBSSIB_T entry;
#ifdef WLAN_MBSSID
	int j;
	char vapname[15];
#endif
	unsigned char wlan_module_disabled;
	char ifname[IFNAMSIZ]={0};
	unsigned char phyband=PHYBAND_2G;
	int ret = 0;
	//_TRACE_CALL;

//	if (!wlan_is_up()) {
//		return -1;
//	}
	mib_get_s(MIB_WIFI_MODULE_DISABLED, (void *)&wlan_module_disabled, sizeof(wlan_module_disabled));
	if(wlan_module_disabled==1)
		return -1;

	orig_wlan_idx = wlan_idx;

	//process wlan interface
	for(i=0; i<NUM_WLAN_INTERFACE; i++){
		wlan_idx = i;
		if(mib_get_s(MIB_WLAN_PHY_BAND_SELECT, &phyband, sizeof(phyband))){
			if(band == phyband)
				break;
		}
	}
	if(i>=NUM_WLAN_INTERFACE){
		wlan_idx = orig_wlan_idx;
		return -1;
	}

		wlan_getEntry(&entry, 0);
		rtk_wlan_get_ifname(wlan_idx, 0, ifname);
#ifdef CONFIG_CMCC_ENTERPRISE
		if (getInFlags(ifname, 0)) {
#else
		if (!entry.wlanDisabled && getInFlags(ifname, 0)) {
#endif
		ret = get_wlan_net_device_stats(ifname, &nds);
		if (ret < 0) {
			memset(&nds, 0, sizeof(nds));
			printf("%s(%d): get_net_device_stats nds faild!\n", __FUNCTION__,__LINE__);
			return -1;
		}

		boaWrite(wp, "rcs.push(new it_nr(\"%d\""
			 _PTS _PTULL _PTULL
			 _PTULL _PTULL _PTULL
			 _PTULL _PTULL _PTULL "));\n",
			 intf_num, "ifname", "无线",
			 "rx_packets", nds.rx_packets,
			 "rx_bytes", nds.rx_bytes,
			 "rx_errors", nds.rx_errors,
			 "rx_dropped", nds.rx_dropped,
			 "tx_packets", nds.tx_packets,
			 "tx_bytes", nds.tx_bytes,
			 "tx_errors", nds.tx_errors,
			 "tx_dropped", nds.tx_dropped);
		intf_num++;
		}
		
#ifdef CONFIG_CMCC_ENTERPRISE
//#ifdef WLAN_MBSSID
		/* append wlan0-vapX to names if not disabled */
		for (j = 0; j < WLAN_MBSSID_NUM; j++) {
			mib_chain_get(MIB_MBSSIB_TBL, j + 1, &entry);
			//if (entry.wlanDisabled) {
			//	continue;
			//}
			sprintf(vapname, "%s-vap%d", getWlanIfName(), j);
			if(getInFlags(vapname, 0)==0)
				continue;
			ret = get_wlan_net_device_stats(vapname, &nds);
			if (ret < 0) {
				memset(&nds, 0, sizeof(nds));
				printf("%s(%d): get_net_device_stats nds faild!\n", __FUNCTION__,__LINE__);
				continue;
			}
			boaWrite(wp, "rcs.push(new it_nr(\"%d\""
				 _PTS _PTULL _PTULL
				 _PTULL _PTULL _PTULL
				 _PTULL _PTULL _PTULL "));\n",
				 intf_num, "ifname", entry.ssid,
				 "rx_packets", nds.rx_packets,
				 "rx_bytes", nds.rx_bytes,
				 "rx_errors", nds.rx_errors,
				 "rx_dropped", nds.rx_dropped,
				 "tx_packets", nds.tx_packets,
				 "tx_bytes", nds.tx_bytes,
				 "tx_errors", nds.tx_errors,
				 "tx_dropped", nds.tx_dropped);
			intf_num++;
		}
#endif
	wlan_idx = orig_wlan_idx;
check_err:
	//_TRACE_LEAVEL;
	return 0;
}

int wlStatsList_24G(int eid, request * wp, int argc, char **argv)
{
	return wlStatsList_get(eid, wp, argc, argv, PHYBAND_2G);
}

#if defined(WLAN_DUALBAND_CONCURRENT)
int wlan_interface_status_5G(int eid, request * wp, int argc, char **argv)
{
	return wlan_interface_status_get(eid, wp, argc, argv, PHYBAND_5G);
}

int wlStatsList_5G(int eid, request * wp, int argc, char **argv)
{
	return wlStatsList_get(eid, wp, argc, argv, PHYBAND_5G);
}
#endif //#if defined(WLAN_DUALBAND_CONCURRENT)

#endif //defined(WLAN_SUPPORT) && (defined(CONFIG_CMCC) || defined(CONFIG_CU_BASEON_CMCC) || defined(CONFIG_USER_AP_CMCC))

#ifdef _PRMT_X_CMCC_WLANSHARE_
void formWlanShare(request * wp, char *path, char *query)
{
	char *strVal, *submitUrl;
	char tmpBuf[100];
	unsigned char enable=0, wlan_restart=0;
	MIB_CE_WLAN_SHARE_T Entry;
	MIB_CE_MBSSIB_T wlanEntry;
	int total = mib_chain_total(MIB_WLAN_SHARE_TBL);

	strVal  = boaGetVar(wp, "EnableUserId", "");
	if(strVal[0]){
		enable = strVal[0] - '0';
	}
	else{
		strcpy(tmpBuf, "错误! 没有EnableUserId");
		goto setErr_wlshare;
	}
	
	if(enable==0 && total==0)
		goto setNo_wlshare;
	
	if(total == 0){
		memset(&Entry, 0, sizeof(MIB_CE_WLAN_SHARE_T));
	}
	else{
		if( !mib_chain_get(MIB_WLAN_SHARE_TBL, 0, &Entry)){
			strcpy(tmpBuf, "错误! MIB_WLAN_SHARE_TBL读取错误");
			goto setErr_wlshare;
		}
	}
	
	Entry.userid_enable = enable;

	strVal  = boaGetVar(wp, "ShareIndex", "");	
	if (!strVal[0]) {
		strcpy(tmpBuf, "错误! 没有ShareIndex");
		goto setErr_wlshare;
	}
	Entry.ssid_idx = strVal[0] - '0';

	if(enable){
		strVal  = boaGetVar(wp, "UserId", "");
		if (strVal[0]) {
			strcpy( Entry.userid, strVal);
		}
	}
	else{
		memset(Entry.userid, 0, sizeof(Entry.userid));
	}

	if(total==0){
		if(!mib_chain_add(MIB_WLAN_SHARE_TBL, &Entry)){
			strcpy(tmpBuf, strAddEntryErr);
			goto setErr_wlshare;
		}
	}
	else{
		mib_chain_update(MIB_WLAN_SHARE_TBL, &Entry, 0);
	}
	if(Entry.userid_enable)
		syslog(LOG_INFO, "WlanShare: Modify userid %s", Entry.userid);
	else
		syslog(LOG_INFO, "WlanShare: Disable");

// Magician: Commit immediately
#ifdef COMMIT_IMMEDIATELY
	Commit();
#endif // of #if COMMIT_IMMEDIATELY

#ifndef NO_ACTION
	run_script(-1);
#endif

#ifdef _PRMT_X_CMCC_WLANSHARE_
	setup_wlan_share();
#endif

setNo_wlshare:
	submitUrl = boaGetVar(wp, "submit-url", "");   // hidden page
	//OK_MSG( submitUrl );
	if (submitUrl[0])
		boaRedirect(wp, submitUrl);
	else
		boaDone(wp, 200);
  	return;

setErr_wlshare:
	ERR_MSG(tmpBuf);
}
#endif

#ifdef CONFIG_USER_CLUSTER_MANAGE
void formCLU(request * wp, char *path, char *query)
{
    char *strVal, *submitUrl;
    unsigned char vChar;
    unsigned char clu_Enble = 0;    // 0-off, 1-on

    mib_get( MIB_CLUSTER_MANAGE_ENABLE, (void *)&vChar);
    strVal = boaGetVar(wp, "cluEnble", "");
    if(strVal[0])
    {
        if(strcmp(strVal, "on") == 0 )
        {
            clu_Enble = 1;
        }
        if(vChar == clu_Enble)
        {
            printf("no change happen.\n");
        }
        else
        {
            mib_set( MIB_CLUSTER_MANAGE_ENABLE, (void *)&clu_Enble);
            if(1==clu_Enble)
            {
                va_cmd("/bin/killall", 1, 1, "cluster_client");
                va_cmd( "/bin/cluster_client", 0, 0 );
            }
            else
            {
                va_cmd("/bin/killall", 1, 1, "cluster_client");
                unlink(CLU_CLIENT_RUNFILE);
            }
#ifdef COMMIT_IMMEDIATELY
            Commit();
#endif // of #if COMMIT_IMMEDIATELY
        }
    }

    submitUrl = boaGetVar(wp, "submit-url", "");

    if (submitUrl[0])
        boaRedirect(wp, submitUrl);
    else
        boaDone(wp, 200);
    return;
}
#endif
#ifdef CONFIG_ELINK_SUPPORT
void formElinkSetup(request *wp, char *path, char *query)
{
	char *str_enable_elink,*str_config_yes,*submitUrl;
	unsigned char enabled=0,sync_config=0;
	int pid=-1;

	str_enable_elink = boaGetVar(wp, "elink_enable", "");
	str_config_yes = boaGetVar(wp, "elink_sync", "");

	if (str_enable_elink[0]) {
		enabled=str_enable_elink[0]-'0';
	}
	if (str_config_yes[0]) {
		sync_config=str_config_yes[0]-'0';
	}
	
	mib_set(MIB_RTL_LINK_ENABLE,(void *)&enabled);
	mib_set(MIB_RTL_LINK_SYNC,(void *)&sync_config);
	
	if(enabled){
        if(!isFileExist(RTL_LINK_PID_FILE)){
            system("elink -m1 -d2");
        }
    }else{
        if(isFileExist(RTL_LINK_PID_FILE)){
            //pid=getPid_fromFile(RTL_LINK_PID_FILE);
			pid=read_pid((char *)RTL_LINK_PID_FILE);
		
		    if(pid != -1){
			    if (kill(pid, SIGKILL) != 0) {
			        printf("Could not kill pid '%d'", pid);
			    }
		    }
		    unlink(RTL_LINK_PID_FILE);
        }
        //recover mode through file
    }

#ifdef COMMIT_IMMEDIATELY
	Commit();
#endif 

	submitUrl = boaGetVar(wp, "submit-url", "");   // hidden page
	OK_MSG(submitUrl);
		
	return;
}

#ifdef CONFIG_ELINKSDK_SUPPORT

#define MACIE5_CFGSTR	"/plain\x0d\x0a\0x0d\0x0a"
#define WINIE6_STR	"/octet-stream\x0d\x0a\0x0d\0x0a"
#define MACIE5_FWSTR	"/macbinary\x0d\x0a\0x0d\0x0a"
#define OPERA_FWSTR	"/x-macbinary\x0d\x0a\0x0d\0x0a"
#define LINE_FWSTR	"\x0d\x0a\0x0d\0x0a"
#define LINUXFX36_FWSTR "/x-ns-proxy-autoconfig\x0d\x0a\0x0d\0x0a"

static pid_t elink_find_pid_by_name( char* pidName)
{
	DIR *dir;
	struct dirent *next;
	pid_t pid;
	
	if ( strcmp(pidName, "init")==0)
		return 1;
	
	dir = opendir("/proc");
	if (!dir) {
		printf("Cannot open /proc");
		return 0;
	}

	while ((next = readdir(dir)) != NULL) {
		FILE *status;
		char filename[64];
		char buffer[64];
		char name[64];

		/* Must skip ".." since that is outside /proc */
		if (strcmp(next->d_name, "..") == 0)
			continue;

		/* If it isn't a number, we don't want it */
		if (!isdigit(*next->d_name))
			continue;

		sprintf(filename, "/proc/%s/status", next->d_name);
		if (! (status = fopen(filename, "r")) ) {
			continue;
		}
		if (fgets(buffer, 63, status) == NULL) {
			fclose(status);
			continue;
		}
		fclose(status);

		/* Buffer should contain a string like "Name:   binary_name" */
		sscanf(buffer, "%*s %s", name);
		if (strcmp(name, pidName) == 0) {
		//	pidList=xrealloc( pidList, sizeof(pid_t) * (i+2));
			pid=(pid_t)strtol(next->d_name, NULL, 0);
			closedir(dir);
			return pid;
		}
	}	
	closedir(dir);
	return 0;
}

static FILE * _rtl_link_uploadGet(request *wp,  unsigned *file_len)
{
	FILE *fp=NULL;
	struct stat statbuf;
	unsigned char  *buf;
	int c;

	if (wp->method == M_POST)
	{
		fstat(wp->post_data_fd, &statbuf);
		lseek(wp->post_data_fd, 0, SEEK_SET);

		//printf("file size=%d\n",statbuf.st_size);
		fp=fopen(wp->post_file_name,"rb");
		if(fp==NULL) goto error;

	}
	else goto error;

	fseek(fp,0L,SEEK_END); /* set to end */
	(*file_len)=ftell(fp);

	return fp;
error:
	return NULL;
}
static int rtl_link_find_head_offset(char *upload_data)
{
	int head_offset=0 ;
	char *pStart=NULL;
	int iestr_offset=0;
	char *dquote;
	char *dquote1;
	
	if (upload_data==NULL) {
		//fprintf(stderr, "upload data is NULL\n");
		return -1;
	}

	pStart = strstr(upload_data, WINIE6_STR);
	if (pStart == NULL) {
		pStart = strstr(upload_data, LINUXFX36_FWSTR);
		if (pStart == NULL) {
			pStart = strstr(upload_data, MACIE5_FWSTR);
			if (pStart == NULL) {
				pStart = strstr(upload_data, OPERA_FWSTR);
				if (pStart == NULL) {
					pStart = strstr(upload_data, "filename=");
					if (pStart == NULL) {
						return -1;
					}
					else {
						dquote =  strstr(pStart, "\"");
						if (dquote !=NULL) {
							dquote1 = strstr(dquote, LINE_FWSTR);
							if (dquote1!=NULL) {
								iestr_offset = 4;
								pStart = dquote1;
							}
							else {
								return -1;
							}
						}
						else {
							return -1;
						}
					}
				}
				else {
					iestr_offset = 16;
				}
			} 
			else {
				iestr_offset = 14;
			}
		}
		else {
			iestr_offset = 26;
		}
	}
	else {
		iestr_offset = 17;
	}
	//fprintf(stderr,"####%s:%d %d###\n",  __FILE__, __LINE__ , iestr_offset);
	head_offset = (int)(((unsigned long)pStart)-((unsigned long)upload_data)) + iestr_offset;
	return head_offset;
}

void formElinkSDKUpload(request *wp, char * path, char * query)
{
	FILE *fp = NULL;
	unsigned char *buf= NULL;
	unsigned int nRead=0,date_len=0,head_offset=0,file_len=0,offset=0;
	int ret = 0;
	char tmpBuf[200]={0},Cmdbuff[200]={0},submitUrl[64]={0},file[100];
	pid_t pid;

	strcpy(submitUrl, "/elink.asp");

	if ((fp = _rtl_link_uploadGet(wp, &file_len)) == NULL) {
		strcpy(tmpBuf, multilang(LANG_ERROR_FIND_THE_START_AND_END_OF_THE_UPLOAD_FILE_FAILED));
		goto ret_upload;
	}

	buf = malloc(file_len);
	if (!buf) {
		fclose(fp);
		goto ret_upload;
	}
	
	fseek(fp, 0, SEEK_SET);
	nRead = fread((void *)buf, 1, file_len, fp);
	fclose(fp);
	
	if (nRead != file_len)
		printf("Read %d bytes, expect %d bytes\n", nRead, file_len);

	head_offset = rtl_link_find_head_offset((char *)buf);
	if (head_offset == -1) {
		strcpy(tmpBuf, "<b>Invalid file format!");
		goto ret_upload;
	}

	date_len=file_len-head_offset;
	
	if(date_len > 512*1024){
        strcpy(tmpBuf, "<b>File too long!");
		goto ret_upload;
	}
		
	if(isFileExist(RTL_ELINKSDK_TMP_DIR)){
		snprintf(Cmdbuff,sizeof(Cmdbuff),"rm -rf %s",RTL_ELINKSDK_TMP_DIR);
		system(Cmdbuff);
	}

	snprintf(Cmdbuff,sizeof(Cmdbuff),"mkdir -p %s",RTL_ELINKSDK_TMP_DIR);
	system(Cmdbuff);

	snprintf(file, sizeof(file), "%s/%s", RTL_ELINKSDK_TMP_DIR, RTL_ELINKSDK_FILE);

	
	fp = fopen(file, "wb+");
	if (!fp) {
		printf("Get config file fail!\n");
		goto ret_upload;
	}
		
	while(date_len){
		ret = fwrite(buf+head_offset+offset, 1, date_len, fp);
		date_len -= ret;
		offset += ret;
	}
	fclose(fp);

	if(rtl_elinksdk_can_download()){
        /*store elink cloud param*/
        rtl_elinksdk_store_param();
        
        /*stop elink cloud thread*/
		pid = elink_find_pid_by_name("elink");
        if(pid){
            kill(pid, SIGUSR1);
        }
        
        /*stop elink cloud sdk*/
        rtl_elinksdk_stop();
        rtl_elinksdk_timelycheck_ops(ELINKSDK_TIMELYCHECK_STOP);
        
        ret = rtl_elinksdk_download(ELINKSDK_DOWNLOAD_FROM_WEB, NULL);
        SDK_DEBUG("rtl_elinksdk_download result : %d\n", ret);
        if(ret){
            /*restart elink cloud sdk*/
            rtl_elinksdk_restore_param();
            rtl_elinksdk_start();
            rtl_elinksdk_timelycheck_ops(ELINKSDK_TIMELYCHECK_START);
            if(ret == ELINKSDK_MD5_ERROR)
                sprintf(tmpBuf, "<b>Install Elink cloud SDK failed: MD5 error!");
            else if(ret == ELINKSDK_ARCH_ERROR)
                sprintf(tmpBuf, "<b>Install Elink cloud SDK failed: Arch error!");
            else if(ret == ELINKSDK_VERSION_ERROR)
                sprintf(tmpBuf, "<b>Install Elink cloud SDK failed: Already the newest!");
            else
                sprintf(tmpBuf, "<b>Install Elink cloud SDK failed: (%d)!", ret);
	        goto ret_upload;
        }

        /*restart elink cloud sdk*/
        rtl_elinksdk_restore_param();
        rtl_elinksdk_start();
        rtl_elinksdk_timelycheck_ops(ELINKSDK_TIMELYCHECK_START);
        strcpy(tmpBuf, "<b>Elink cloud SDK Upgrade successfully!");
		
        goto ret_upload;
        /*restart elink cloud thred*/
        //will start automatically
    }else{
	    strcpy(tmpBuf, "<b>Install Elink cloud SDK failed!");
	    goto ret_upload;
	}

ret_upload:

	if(buf){
		free(buf);
		buf=NULL;
	}
	
	OK_MSG1(tmpBuf, submitUrl);
	return;

}
#endif
#endif
#ifdef CONFIG_USER_CTCAPD
void formElinkSync(request *wp, char *path, char *query)
{
	char *str_config_yes,*submitUrl;
	unsigned char sync_config=0;

	str_config_yes = boaGetVar(wp, "elink_config_sync", "");

	if (str_config_yes[0]) {
		sync_config=str_config_yes[0]-'0';
	}
	
	mib_set(MIB_CTCAPD_ELINK_SYNC,(void *)&sync_config);

#ifdef COMMIT_IMMEDIATELY
	Commit();
#endif 

	submitUrl = boaGetVar(wp, "submit-url", "");   // hidden page
	OK_MSG(submitUrl);
		
	return;
}
#endif

