/*
 *      Web server handler routines for wireless status
 *
 */

#include <string.h>
#include "../webs.h"
#include "webform.h"
#include "mib.h"
#include "utility.h"
#include "debug.h"
#include <linux/wireless.h>
#include "fmdefs.h"
#include <sys/ioctl.h>

#include <rtk/subr_wlan.h>

static void getEncryption(MIB_CE_MBSSIB_T *Entry, char *buffer)
{
	switch (Entry->encrypt) {
		case WIFI_SEC_WEP:
			if (Entry->wep == WEP_DISABLED)
				strcpy(buffer, "Disabled");
			else if (Entry->wep == WEP64 )
				strcpy(buffer, "WEP 64bits");
			else if (Entry->wep == WEP128)
				strcpy(buffer, "WEP 128bits");
			else
				buffer[0] = '\0';
			break;
		case WIFI_SEC_NONE:
		case WIFI_SEC_WPA:
			strcpy(buffer, wlan_encrypt[Entry->encrypt]);
			break;
		case WIFI_SEC_WPA2:
			strcpy(buffer, wlan_encrypt[3]);
			break;
		case WIFI_SEC_WPA2_MIXED:
			strcpy(buffer, wlan_encrypt[4]);
			break;
#ifdef CONFIG_RTL_WAPI_SUPPORT
		case WIFI_SEC_WAPI:
			strcpy(buffer, wlan_encrypt[5]);
			break;
#endif
		default:
			strcpy(buffer, wlan_encrypt[0]);
	}
}

static void getTranSSID(char *buff, char *ssid)
{
	memset(buff, '\0', 200);
	memcpy(buff, ssid, MAX_SSID_LEN);
	translate_control_code(buff);
}

#if defined(CONFIG_CMCC) || defined(CONFIG_CU_BASEON_CMCC) || defined(CONFIG_USER_AP_CMCC)
const char *wl_auth_type[] = {"OPENSYSTEM", "SHAREDKEY", "BOTH"};
const char *wl_wep_keylen[] = {"", "WEP-64bits", "WEP-128bits"};

int wlStatus_parm(int eid, request * wp, int argc, char **argv)
{
	int i,j, intf_num = 0;
#ifdef WLAN_DUALBAND_CONCURRENT
	int orig_wlan_idx;
#endif
	unsigned char translate_ssid[200];
	unsigned char buffer[64];
	bss_info bss;
	MIB_CE_MBSSIB_T Entry;
	unsigned int channel;
	int nBytesSent = 0;
	unsigned char wlan_module_disabled=0, phyBandSelect=0;
	unsigned char cipher=0;
	unsigned char auto_channel=0;
	unsigned char wlanBand=0;
	//_TRACE_CALL;

//	if (!wlan_is_up()) {
//		return -1;
//	}
	mib_get_s(MIB_WIFI_MODULE_DISABLED, (void *)&wlan_module_disabled, sizeof(wlan_module_disabled));
	if(wlan_module_disabled==1)
		return -1;
	
#ifdef WLAN_DUALBAND_CONCURRENT
	orig_wlan_idx = wlan_idx;
#endif

	//process each wlan interface
	for (i = 0; i < NUM_WLAN_INTERFACE; i++) {
		wlan_idx = i;
#if !defined(WLAN_BAND_CONFIG_MBSSID)
		mib_get_s(MIB_WLAN_BAND, (void *)&wlanBand, sizeof(wlanBand));
#endif
		for (j = 0; j < WLAN_SSID_NUM; j++) {
			if(j==0){
				sprintf(buffer,"%s", getWlanIfName());
				mib_get_s(MIB_WLAN_AUTO_CHAN_ENABLED, (void *)&auto_channel, sizeof(auto_channel));
				if(auto_channel)
					waitWlChannelSelect(buffer);
				if(getWlChannel(buffer, &channel)==0)
					nBytesSent += boaWrite(wp, "wlDefChannel[%d]=%d;\n", i, channel);
				else
					nBytesSent += boaWrite(wp, "wlDefChannel[%d]='N/A';\n", i);

#ifdef WLAN_DUALBAND_CONCURRENT
				mib_get_s(MIB_WLAN_PHY_BAND_SELECT, &phyBandSelect, sizeof(phyBandSelect));
				boaWrite(wp, "Band2G5GSupport[%d]=%d;\n", i, phyBandSelect);
#endif
			}
#ifdef CONFIG_CMCC_ENTERPRISE
			else
				sprintf(buffer, "%s-vap%d", getWlanIfName(), j-1);
#endif
			rtk_wlan_get_ifname(i, j, buffer);

			mib_chain_get(MIB_MBSSIB_TBL, j, (void *)&Entry);
			
			if (!Entry.wlanDisabled && getInFlags(buffer, 0)) {

				if (getWlBssInfo(buffer, &bss) < 0) {
					continue;
				}
				getTranSSID(translate_ssid, Entry.ssid);
#ifdef WLAN_BAND_CONFIG_MBSSID
				wlanBand = Entry.wlanBand;
#endif
				if(Entry.encrypt == WIFI_SEC_NONE){
					nBytesSent += boaWrite(wp, "wlan_parm.push(new it_nr(\"%d\""
						_PTS _PTI _PTI _PTI _PTI
						", new it(\"%s\", \"%02x:%02x:%02x:%02x:%02x:%02x\")"
						_PTI _PTS _PTS "));\n",
						intf_num, "ssid", translate_ssid,
						"ssid_idx", i*WLAN_SSID_NUM+j+1,
						"hiddenssid", Entry.hidessid,
						"band", wlanBand,
						"disabled", Entry.wlanDisabled,
						"bssid", 
						bss.bssid[0], bss.bssid[1],
						bss.bssid[2], bss.bssid[3],
						bss.bssid[4], bss.bssid[5],
						"encrypt_state", Entry.encrypt,
						"auth_mode", "OPENSYSTEM",
						"encrypt_mode", "NONE");
				}
				else if(Entry.encrypt == WIFI_SEC_WEP){			
					nBytesSent += boaWrite(wp, "wlan_parm.push(new it_nr(\"%d\""
						_PTS _PTI _PTI _PTI _PTI 
						", new it(\"%s\", \"%02x:%02x:%02x:%02x:%02x:%02x\")" 
						_PTI _PTS _PTS "));\n",
						intf_num, "ssid", translate_ssid,
						"ssid_idx", i*WLAN_SSID_NUM+j+1,
						"hiddenssid", Entry.hidessid,
						"band", wlanBand,
						"disabled", Entry.wlanDisabled,
						"bssid", 
						bss.bssid[0], bss.bssid[1],
						bss.bssid[2], bss.bssid[3],
						bss.bssid[4], bss.bssid[5],
						"encrypt_state", Entry.encrypt,
						"auth_mode", wl_auth_type[Entry.authType],
						"encrypt_mode", wl_wep_keylen[Entry.wep]);
				}
				else{
					if(Entry.encrypt == WIFI_SEC_WPA)
						cipher = Entry.unicastCipher;
					else if(Entry.encrypt == WIFI_SEC_WPA2)
						cipher = Entry.wpa2UnicastCipher;
					else
						cipher = (Entry.unicastCipher | Entry.wpa2UnicastCipher);
					nBytesSent += boaWrite(wp, "wlan_parm.push(new it_nr(\"%d\""
						_PTS _PTI _PTI _PTI _PTI 
						", new it(\"%s\", \"%02x:%02x:%02x:%02x:%02x:%02x\")" 
						_PTI _PTS _PTS "));\n",
						intf_num, "ssid", translate_ssid,
						"ssid_idx", i*WLAN_SSID_NUM+j+1,
						"hiddenssid", Entry.hidessid,
						"band", wlanBand,
						"disabled", Entry.wlanDisabled,
						"bssid", 
						bss.bssid[0], bss.bssid[1],
						bss.bssid[2], bss.bssid[3],
						bss.bssid[4], bss.bssid[5],
						"encrypt_state", Entry.encrypt == 0 ? 0:1,
						"auth_mode", Entry.encrypt == WIFI_SEC_WPA2_MIXED ? "WPA-PSK/WPA2-PSK": 
						(Entry.encrypt == WIFI_SEC_WPA ? "WPA-PSK": "WPA2-PSK"),
						"encrypt_mode", cipher == WPA_CIPHER_MIXED? "TKIP+AES":
						(cipher == WPA_CIPHER_AES? "AES":"TKIP"));
				}

				intf_num++;
			}
		}
	}
#ifdef WLAN_DUALBAND_CONCURRENT
	wlan_idx = orig_wlan_idx;
#endif
check_err:
	//_TRACE_LEAVEL;
	return 0;
}

int wlStatus_parm_get(int eid, request * wp, int argc, char **argv, int band)
{
	int i,j, intf_num = 0;
#ifdef WLAN_DUALBAND_CONCURRENT
	int orig_wlan_idx;
#endif
	unsigned char translate_ssid[200];
	unsigned char buffer[64], auth_mode[20]={0};
	bss_info bss;
	MIB_CE_MBSSIB_T Entry;
	unsigned int channel;
	int nBytesSent = 0;
	unsigned char wlan_module_disabled=0, phyBandSelect=0;
	unsigned char cipher=0;
	unsigned char wlanBand = 0;
	//_TRACE_CALL;

//	if (!wlan_is_up()) {
//		return -1;
//	}
	mib_get_s(MIB_WIFI_MODULE_DISABLED, (void *)&wlan_module_disabled, sizeof(wlan_module_disabled));
	if(wlan_module_disabled==1)
		return -1;
	
#ifdef WLAN_DUALBAND_CONCURRENT
	orig_wlan_idx = wlan_idx;
#endif

	//process 2.4 wlan interface
	for(i=0; i<NUM_WLAN_INTERFACE; i++){
		wlan_idx = i;
		if(mib_get_s(MIB_WLAN_PHY_BAND_SELECT, &phyBandSelect, sizeof(phyBandSelect))){
			if(band == phyBandSelect)
				break;
		}
	}
	if(i>=NUM_WLAN_INTERFACE){
#ifdef WLAN_DUALBAND_CONCURRENT
		wlan_idx = orig_wlan_idx;
#endif
		return -1;
	}
#if !defined(WLAN_BAND_CONFIG_MBSSID)
	mib_get_s(MIB_WLAN_BAND, (void *)&wlanBand, sizeof(wlanBand));
#endif
		
		for (j = 0; j < WLAN_SSID_NUM; j++) {
			if(j==0){
				sprintf(buffer,"%s", getWlanIfName());
				
				if(getWlChannel(buffer, &channel)==0)
#ifdef CONFIG_CMCC_ENTERPRISE
					if(band==PHYBAND_2G)
						nBytesSent += boaWrite(wp, "wlDefChannel[%d]=%d;\n", 0, channel);
					else
						nBytesSent += boaWrite(wp, "wlDefChannel[%d]=%d;\n", 1, channel);
#else
					nBytesSent += boaWrite(wp, "wlDefChannel[%d]=%d;\n", 0, channel);
#endif
				else
					nBytesSent += boaWrite(wp, "wlDefChannel[%d]='N/A';\n", 0);

#ifdef WLAN_DUALBAND_CONCURRENT
				mib_get_s(MIB_WLAN_PHY_BAND_SELECT, &phyBandSelect, sizeof(phyBandSelect));
				boaWrite(wp, "Band2G5GSupport[%d]=%d;\n", 0, phyBandSelect);
#endif
			}
#ifdef CONFIG_CMCC_ENTERPRISE
			else
				sprintf(buffer, "%s-vap%d", getWlanIfName(), j-1);
#endif
			rtk_wlan_get_ifname(i, j, buffer);

			mib_chain_get(MIB_MBSSIB_TBL, j, (void *)&Entry);
#if defined(WLAN_BAND_CONFIG_MBSSID)
			wlanBand = Entry.wlanBand;
#endif
#ifdef CONFIG_CMCC_ENTERPRISE
			if (getInFlags(buffer, 0)) {
#else
			if (!Entry.wlanDisabled && getInFlags(buffer, 0)) {
#endif

				if (getWlBssInfo(buffer, &bss) < 0) {
					continue;
				}
				getTranSSID(translate_ssid, Entry.ssid);
				
				if(Entry.encrypt == WIFI_SEC_NONE){
					nBytesSent += boaWrite(wp, "wlan_parm.push(new it_nr(\"%d\""
						_PTS _PTI _PTI _PTI _PTI
						", new it(\"%s\", \"%02x:%02x:%02x:%02x:%02x:%02x\")"
						_PTI _PTS _PTS "));\n",
						intf_num, "ssid", translate_ssid,
						"ssid_idx", i*WLAN_SSID_NUM+j+1,
						"hiddenssid", Entry.hidessid,
						"band", wlanBand,
						"disabled", Entry.wlanDisabled,
						"bssid", 
						bss.bssid[0], bss.bssid[1],
						bss.bssid[2], bss.bssid[3],
						bss.bssid[4], bss.bssid[5],
						"encrypt_state", Entry.encrypt,
						"auth_mode", "OPENSYSTEM",
						"encrypt_mode", "NONE");
				}
				else if(Entry.encrypt == WIFI_SEC_WEP){			
					nBytesSent += boaWrite(wp, "wlan_parm.push(new it_nr(\"%d\""
						_PTS _PTI _PTI _PTI _PTI 
						", new it(\"%s\", \"%02x:%02x:%02x:%02x:%02x:%02x\")" 
						_PTI _PTS _PTS "));\n",
						intf_num, "ssid", translate_ssid,
						"ssid_idx", i*WLAN_SSID_NUM+j+1,
						"hiddenssid", Entry.hidessid,
						"band", wlanBand,
						"disabled", Entry.wlanDisabled,
						"bssid", 
						bss.bssid[0], bss.bssid[1],
						bss.bssid[2], bss.bssid[3],
						bss.bssid[4], bss.bssid[5],
						"encrypt_state", Entry.encrypt,
						"auth_mode", wl_auth_type[Entry.authType],
						"encrypt_mode", wl_wep_keylen[Entry.wep]);
				}
				else{
					if(Entry.encrypt == WIFI_SEC_WPA)
						cipher = Entry.unicastCipher;
					else if(Entry.encrypt == WIFI_SEC_WPA2)
						cipher = Entry.wpa2UnicastCipher;
					else
						cipher = (Entry.unicastCipher | Entry.wpa2UnicastCipher);
					switch(Entry.encrypt)
					{
#ifdef WLAN_WPA3

						case WIFI_SEC_WPA2_WPA3_MIXED:
							snprintf(auth_mode,sizeof(auth_mode),"%s", "WPA2-PSK/WPA3-PSK");
							break;
						case WIFI_SEC_WPA3:
							snprintf(auth_mode,sizeof(auth_mode),"%s", "WPA3-PSK");
							break;
#endif
						case WIFI_SEC_WPA2_MIXED:
							snprintf(auth_mode,sizeof(auth_mode),"%s", "WPA-PSK/WPA2-PSK");
							break;
						case WIFI_SEC_WPA2:
							snprintf(auth_mode,sizeof(auth_mode),"%s", "WPA2-PSK");
							break;
						case WIFI_SEC_WPA:
							snprintf(auth_mode,sizeof(auth_mode),"%s", "WPA-PSK");
							break;
						default:
							printf("[%s](%d)encrypt error\n",__FUNCTION__,__LINE__);
							break;
					}
					nBytesSent += boaWrite(wp, "wlan_parm.push(new it_nr(\"%d\""
						_PTS _PTI _PTI _PTI _PTI 
						", new it(\"%s\", \"%02x:%02x:%02x:%02x:%02x:%02x\")" 
						_PTI _PTS _PTS "));\n",
						intf_num, "ssid", translate_ssid,
						"ssid_idx", i*WLAN_SSID_NUM+j+1,
						"hiddenssid", Entry.hidessid,
						"band", wlanBand,
						"disabled", Entry.wlanDisabled,
						"bssid", 
						bss.bssid[0], bss.bssid[1],
						bss.bssid[2], bss.bssid[3],
						bss.bssid[4], bss.bssid[5],
						"encrypt_state", Entry.encrypt == 0 ? 0:1,
						"auth_mode", auth_mode,
						"encrypt_mode", cipher == WPA_CIPHER_MIXED? "TKIP+AES":
						(cipher == WPA_CIPHER_AES? "AES":"TKIP"));
				}

				intf_num++;
			}
		}
#ifdef WLAN_DUALBAND_CONCURRENT
	wlan_idx = orig_wlan_idx;
#endif
check_err:
	//_TRACE_LEAVEL;
	return 0;
}

int wlStatus_parm_24G(int eid, request * wp, int argc, char **argv)
{
	return wlStatus_parm_get(eid, wp, argc, argv, PHYBAND_2G);
}

#ifdef WLAN_DUALBAND_CONCURRENT
int wlStatus_parm_5G(int eid, request * wp, int argc, char **argv)
{
	return wlStatus_parm_get(eid, wp, argc, argv, PHYBAND_5G);
}
#endif //WLAN_DUALBAND_CONCURRENT
#else
int wlStatus_parm(int eid, request * wp, int argc, char **argv)
{
	bss_info bss;
	int nBytesSent = 0, i, k, mbssid_idx=0;
	int orig_wlan_idx;
	MIB_CE_MBSSIB_T Entry, Entry2,WlanEnable_Entry;
	struct _misc_data_ misc_data;
	unsigned char buffer[64], buffer2[64], translate_ssid[200];
	unsigned char band, autort, hiddenSSID, wlan_disabled, phyBandSelect;
	unsigned int fixedTxRate;
#if defined(CONFIG_USER_RTK_REPEATER_MODE) && defined(WLAN_UNIVERSAL_REPEATER)
	unsigned char repeaterMode;
	MIB_CE_MBSSIB_T Entry3;
#endif
#ifdef CONFIG_USER_CTCAPD
	int flag=0;
	unsigned char tmp_value=0;
#endif
	unsigned int channel=0;

	orig_wlan_idx = wlan_idx;

	for (i = 0; i < NUM_WLAN_INTERFACE; i++) {
		wlan_idx = i;

		wlan_getEntry(&Entry, 0);
#ifdef WLAN_BAND_CONFIG_MBSSID
		band = Entry.wlanBand;
#else
		mib_get_s(MIB_WLAN_BAND, (void *)&band, sizeof(band));
#endif
		autort = Entry.rateAdaptiveEnabled;
		hiddenSSID = Entry.hidessid;
		wlan_disabled = Entry.wlanDisabled;
		fixedTxRate = Entry.fixedTxRate;
#if defined(WLAN0_5G_SUPPORT) || defined(WLAN1_5G_SUPPORT)
		mib_get_s(MIB_WLAN_PHY_BAND_SELECT, &phyBandSelect, sizeof(phyBandSelect));
#else
		phyBandSelect = PHYBAND_2G;
#endif
		rtk_wlan_get_ifname(i, 0, buffer);
		if (getWlBssInfo(buffer, &bss) < 0) {
			wlan_idx = orig_wlan_idx;
			return -1;
		}
		getTranSSID(translate_ssid, bss.ssid);
		nBytesSent += boaWrite(wp,
				       "\tband[%d]=%d;\n\tssid_drv[%d]='%s';\n\twlanSsidAttr[%d]='%s';\n",
				       i, band, i, translate_ssid, i,
				       (hiddenSSID == 0) ? "Visual" : "Hidden");
		/* Encryption */
		getEncryption(&Entry, buffer);
		nBytesSent += boaWrite(wp, "\tencryptState[%d]='%s';\n",
				       i,
				       (Entry.encrypt ==
					0) ? INFO_DISABLED : INFO_ENABLED);

		nBytesSent += boaWrite(wp,
				       "\tchannel_drv[%d]='%d';\n",
				       i, bss.channel);
		nBytesSent += boaWrite(wp,
				       "\tbssid_drv[%d]='%02x:%02x:%02x:%02x:%02x:%02x';\n",
				       i, bss.bssid[0], bss.bssid[1],
				       bss.bssid[2], bss.bssid[3], bss.bssid[4],
				       bss.bssid[5]);

		nBytesSent += boaWrite(wp,
				       "\twlanDisabled[%d]=%d;\n",
				       i, wlan_disabled);

		nBytesSent += boaWrite(wp, "\tssid_alias[%d]='%s-%d';\n",
#ifdef YUEME_3_0_SPEC_SSID_ALIAS
								i, phyBandSelect==PHYBAND_2G? "2.4G":"5G", 1);
#else
#ifdef RTK_RSV_VAP_FOR_EASYMESH
								i, "SSID", 1 + i*WLAN_MBSSID_NUM);
#else
								i, "SSID", 1 + i*WLAN_SSID_NUM);
#endif
#endif
#ifdef WLAN_RATE_PRIOR
		unsigned char vChar = 0;
		mib_get_s(MIB_WLAN_RATE_PRIOR, (void *)&vChar, sizeof(vChar));
		nBytesSent += boaWrite(wp, "\twlan_rate_prior[%d]=%d;\n", i, vChar);
#else
		nBytesSent += boaWrite(wp, "\twlan_rate_prior[%d]=0;\n", i);
#endif
#if 0
		struct iwreq wrq;
		int ret, idx,cmd_id,vwlanidx=0;
#define RTL8185_IOCTL_GET_MIB	0x89f2
#define SIOCDEVPRIVATEAXEXT 0x89f2 //SIOCDEVPRIVATE+2
		idx = socket(AF_INET, SOCK_DGRAM, 0);

		memset(&WlanEnable_Entry,0,sizeof(MIB_CE_MBSSIB_T));
		mib_chain_get_wlan(getWlanIfName(),&WlanEnable_Entry,&vwlanidx);
		if(WlanEnable_Entry.is_ax_support)
		{
			wrq.u.data.flags = RTL8185_IOCTL_GET_MIB;
			cmd_id = SIOCDEVPRIVATEAXEXT;
		}
		else
		{
			cmd_id = RTL8185_IOCTL_GET_MIB;
		}
		strcpy(wrq.ifr_name, getWlanIfName());
		strcpy(buffer, "channel");
		wrq.u.data.pointer = (caddr_t) & buffer;
		wrq.u.data.length = 10;
		ret = ioctl(idx, cmd_id, &wrq);
		close(idx);
#endif
		sprintf(buffer,"%s", getWlanIfName());
		if (getWlChannel(buffer, &channel)==0)
			nBytesSent += boaWrite(wp, "\twlDefChannel[%d]=%d;\n", i, channel);
		else
			nBytesSent += boaWrite(wp, "\twlDefChannel[%d]='N/A';\n", i);

		nBytesSent += boaWrite(wp, "\ttxrate[%d]=%u;\n", i, fixedTxRate);

		nBytesSent += boaWrite(wp, "\tauto[%d]=%d;\n", i, autort);

		memset(&misc_data, 0, sizeof(struct _misc_data_));
		getMiscData(getWlanIfName(), &misc_data);
		nBytesSent += boaWrite(wp, "\trf_used[%d]=%u;\n", i, misc_data.mimo_tr_used);

		nBytesSent += boaWrite(wp,
				       "\tmssid_num=%d;\n", WLAN_MBSSID_NUM);
#ifdef WLAN_MBSSID
		/*-------------- VAP Interface ------------*/
		for (mbssid_idx = 1; mbssid_idx < WLAN_SSID_NUM; mbssid_idx++) {
			//wlan_idx = orig_wlan_idx;
#ifdef RTK_RSV_VAP_FOR_EASYMESH
			if(mbssid_idx == MULTI_AP_BSS_IDX)
				continue;
#endif
			mib_chain_get(MIB_MBSSIB_TBL, mbssid_idx,
				      (void *)&Entry2);
#ifdef WLAN_BAND_CONFIG_MBSSID
			band = Entry2.wlanBand;
#endif
			rtk_wlan_get_ifname(i, mbssid_idx, buffer);

			k = mbssid_idx-1;
#ifdef CONFIG_USER_CTCAPD
			if (getInFlags((char *)buffer, &flag) == 1)
			{
				if(flag & IFF_UP)
					tmp_value = 1;
				else
					tmp_value = 0;
			}
			else
				tmp_value = 0;

			nBytesSent += boaWrite(wp,
		       "\tmssid_is_up[%d][%d]=%d;\n",
		       i, k, tmp_value);
#endif
			if ((Entry2.wlanDisabled == 0) && (getWlBssInfo(buffer, &bss) < 0))
				printf("getWlBssInfo failed\n");
			getTranSSID(translate_ssid, bss.ssid);
			nBytesSent += boaWrite(wp,
					       "\tmssid_ssid_drv[%d][%d]='%s';\n\tmssid_wlanSsidAttr[%d][%d]='%s';\n\tmssid_band[%d][%d]=%d;\n"
					       "\tmssid_disable[%d][%d]=%d;\n",
					       i, k, translate_ssid, i, k,
					       (Entry2.hidessid ==
						0) ? "Visual" : "Hidden", i, k,
					       band, i, k,
					       Entry2.wlanDisabled 
	#ifdef CONFIG_USER_CTCAPD
					       | Entry2.func_off
	#endif
					       );
			nBytesSent +=
			    boaWrite(wp,
				     "\tmssid_bssid_drv[%d][%d]='%02x:%02x:%02x:%02x:%02x:%02x';\n",
				     i, k, bss.bssid[0], bss.bssid[1],
				     bss.bssid[2], bss.bssid[3], bss.bssid[4],
				     bss.bssid[5]);
			/* VAP encryption */
			getEncryption(&Entry2, buffer2);
			nBytesSent +=
			    boaWrite(wp, "\tmssid_encryptState[%d][%d]='%s';\n",
				     i, k,
				     (Entry2.encrypt ==
				      0) ? INFO_DISABLED : INFO_ENABLED);
			nBytesSent += boaWrite(wp, "\tmssid_alias[%d][%d]='%s-%d';\n",
#ifdef YUEME_3_0_SPEC_SSID_ALIAS
						i, k, phyBandSelect==PHYBAND_2G? "2.4G":"5G", WLAN_VAP_ITF_INDEX + (k+1));
#else
#ifdef RTK_RSV_VAP_FOR_EASYMESH

						i, k, "SSID", (k>MULTI_AP_BSS_IDX-1) ? (WLAN_VAP_ITF_INDEX + (k+1) + i*WLAN_MBSSID_NUM - 1) : (WLAN_VAP_ITF_INDEX + (k+1) + i*WLAN_SSID_NUM));
#else
						i, k, "SSID", WLAN_VAP_ITF_INDEX + (k+1) + i*WLAN_SSID_NUM);
#endif
#endif
		}
#endif
		nBytesSent +=
		    boaWrite(wp, "\tBand2G5GSupport[%d]=%d;\n", i, phyBandSelect);

#if defined(CONFIG_USER_RTK_REPEATER_MODE) && defined(WLAN_UNIVERSAL_REPEATER)
		memset(&Entry3, 0, sizeof(MIB_CE_MBSSIB_T));	
		memset(&bss, 0, sizeof(bss_info));
		memset(translate_ssid, 0, sizeof(translate_ssid));

		mib_chain_get(MIB_MBSSIB_TBL, WLAN_REPEATER_ITF_INDEX,(void *)&Entry3);
		rtk_wlan_get_ifname(i, WLAN_REPEATER_ITF_INDEX, buffer);

		/* disabled */
		nBytesSent += boaWrite(wp, "\trpt_wlanDisabled[%d]=%d;\n", i, Entry3.wlanDisabled);

		/* SSID */
		if (getWlBssInfo(buffer, &bss) < 0)
			printf("getWlBssInfo failed(%s)\n", buffer);
		getTranSSID(translate_ssid, bss.ssid);
		nBytesSent += boaWrite(wp, "\trpt_ssid_drv[%d]='%s';\n", i, translate_ssid);

		/* Encryption */
		getEncryption(&Entry3, buffer);
		nBytesSent += boaWrite(wp, "\trpt_encryptState[%d]='%s';\n", i,
					(Entry3.encrypt == 0) ? INFO_DISABLED : INFO_ENABLED);

		/* BSSID */
		nBytesSent += boaWrite(wp,
				       "\trpt_bssid_drv[%d]='%02x:%02x:%02x:%02x:%02x:%02x';\n",
				       i, bss.bssid[0], bss.bssid[1], bss.bssid[2],
				       bss.bssid[3], bss.bssid[4], bss.bssid[5]);
		
		/* alias */
		nBytesSent += boaWrite(wp, "\trpt_ssid_alias[%d]='%s-%s';\n",i,phyBandSelect==PHYBAND_2G? "2.4G":"5G","中继");	

		/* 中继状态 */
		memset(buffer, 0, sizeof(buffer));
		switch (bss.state) {
			case STATE_DISABLED:
				strcpy( buffer, "Disabled");
				break;
			case STATE_IDLE:
				strcpy( buffer, "Idle");
				break;
			case STATE_STARTED:
				strcpy( buffer, "Started");
				break;
			case STATE_CONNECTED:
				strcpy( buffer, "Connected");
				break;
			case STATE_WAITFORKEY:
				strcpy( buffer, "Waiting for keys");
				break;
			case STATE_SCANNING:
				strcpy( buffer, "Scanning");
				break;
			default:
				buffer[0]='\0';
				break;
		}
		nBytesSent += boaWrite(wp, "\trpt_conn_status[%d]='%s';\n",i,buffer);			
#endif
	}
	wlan_idx = orig_wlan_idx;

	return nBytesSent;
}
#endif
