#include "webform.h"
#include "multilang.h"
#include "fmdefs.h"

void rtk_formAWiFi(request * wp, char *path, char *query)
{
	char *enable_str, *extif_str, *wlan0_str, *wlan1_str;
	unsigned char enable, pre_enable;
	unsigned char wlan0_enable, wlan0_pre_enable;
	unsigned char wlan1_enable, wlan1_pre_enable;
	unsigned int extif, pre_extif;
	char *submitUrl, tmpBuf[64];;

	enable_str = boaGetVar(wp, "aWiFi_enable", "");
	extif_str = boaGetVar(wp, "ext_if", "");

	if (enable_str[0]){
		enable = enable_str[0]-'0';
		if(extif_str[0])
			extif = (unsigned int)atoi(extif_str);
		else
			extif = getInternetIPv4WANIfindex();

		wlan0_str = boaGetVar(wp, "wlan0_enable", "");
		wlan1_str=  boaGetVar(wp, "wlan1_enable", "");		
		wlan0_enable = (unsigned char)atoi(wlan0_str);
		wlan1_enable = (unsigned char)atoi(wlan1_str);
		if (mib_get_s(MIB_RTK_AWIFI_ENABLE, (void *)&pre_enable, sizeof(pre_enable)) && 
			mib_get_s(MIB_RTK_AWIFI_EXT_ITF, (void *)&pre_extif, sizeof(pre_extif)) &&
			mib_get_s(MIB_RTK_AWIFI_WLAN0_ENABLE, (void *)&wlan0_pre_enable, sizeof(wlan0_pre_enable)) && 
			mib_get_s(MIB_RTK_AWIFI_WLAN1_ENABLE, (void *)&wlan1_pre_enable, sizeof(wlan1_pre_enable)) ){
			if (enable == pre_enable){
				if( (enable == 0) || 
					(enable == 1 && extif == pre_extif && wlan0_enable == wlan0_pre_enable && wlan1_enable == wlan1_pre_enable)){
					goto formAWiFi_redirect;
				}
			}

			if (enable == 1 && extif == 65535){
				strcpy(tmpBuf, "Please select the internet wan interface first!");
				goto formAWiFi_err;
			}

			if (enable == 1 && wlan0_enable == 0 && wlan1_enable == 0){
				strcpy(tmpBuf, "Please select the connected wlan interface first!");
				goto formAWiFi_err;
			}
			
			if(!mib_set(MIB_RTK_AWIFI_ENABLE, (void *)&enable) ||
				!mib_set(MIB_RTK_AWIFI_EXT_ITF, (void *)&extif) ||
				!mib_set(MIB_RTK_AWIFI_WLAN0_ENABLE, (void *)&wlan0_enable) ||
				!mib_set(MIB_RTK_AWIFI_WLAN1_ENABLE, (void *)&wlan1_enable)){
				strcpy(tmpBuf, "Set aWiFi mib error!");
				goto formAWiFi_err;
			}
			
		}else{
			strcpy(tmpBuf, "Get aWiFi mib error!");
			goto formAWiFi_err;
		}
	}else
		return;

formAWiFi_end:	
#ifdef COMMIT_IMMEDIATELY
	Commit();
#endif

#ifdef APPLY_CHANGE
	rtk_wan_aWiFi_wifidog_stop();
	
	if(enable){
		char ext_ifname[32]={0};
		char wlan_iface[32*2]={0};
		char *wlan0 = "wlan0:";
		char *wlan1 = "wlan1:";
		
		ifGetName(extif, ext_ifname, sizeof(ext_ifname));
		if(wlan0_enable)
			strncpy(wlan_iface+strlen(wlan_iface),wlan0, strlen(wlan0));
		if(wlan1_enable)
			strncpy(wlan_iface+strlen(wlan_iface), wlan1, strlen(wlan1));
		printf("[%s:%d] extif=%d, ext_ifname=%s, wlan_iface=%s\n",__FUNCTION__,__LINE__,extif,ext_ifname,wlan_iface);

		rtk_wan_aWiFi_wifidog_start(ext_ifname, wlan_iface);
	}
#endif

formAWiFi_redirect:
	submitUrl = boaGetVar(wp, "submit-url", "");
	boaRedirect(wp,submitUrl);
	return;

formAWiFi_err:
	ERR_MSG(tmpBuf);
}

#define _BC_STR(name, opt)	{if((sbc = bc_gets(bc, #name)) == NULL){lineno = __LINE__; continue;} strncpy(name, sbc, sizeof(name));}

void rtk_formAWiFiMAC(request * wp, char *path, char *query)
{
	char *stemp = "";
	MIB_CE_RTK_AWIFI_MAC_T entry;
	char mac[20]={0};
	int index, cnt;
	int lineno = __LINE__;

	_BC_USE;

	_TRACE_CALL;
	FETCH_INVALID_OPT(stemp, "action", _NEED);
	if (strcmp(stemp, "rm") == 0){/*delete*/
		_BC_INIT("bcdata");
		while(_BC_NEXT())
		{
			memset(&entry, 0, sizeof(MIB_CE_RTK_AWIFI_MAC_T));

			_BC_ENTRY_STR(name, _OPT);	
			_BC_STR(mac, _OPT);
			changeStringToMac(entry.macAddr, mac);

			/*
			printf("[%s:%d] mac=%s, entry.name=%s, entry.macAddr=%02x-%02x-%02x-%02x-%02x-%02x \n",__FUNCTION__,__LINE__,mac,entry.name,
				entry.macAddr[0],entry.macAddr[1],
				entry.macAddr[2],entry.macAddr[3],
				entry.macAddr[4],entry.macAddr[5]);
			
			MIB_CE_RTK_AWIFI_MAC_T tmpEntry;
			cnt=mib_chain_total(MIB_RTK_AWIFI_MAC_TBL);
			for(index=0; index<cnt; index++){
				mib_chain_get(MIB_RTK_AWIFI_MAC_TBL,index,&tmpEntry);
				if(!memcmp(&tmpEntry, &entry, sizeof(MIB_CE_RTK_AWIFI_MAC_T))){
					printf("[%s:%d] rm find! index=%d\n",__FUNCTION__,__LINE__,index);
					mib_chain_delete(MIB_RTK_AWIFI_MAC_TBL, index);
					break;
				}
			}
			*/
			MIB_CHAIN_DELETE(MIB_RTK_AWIFI_MAC_TBL,MIB_CE_RTK_AWIFI_MAC_T,entry);
		}
	}else if(strcmp(stemp, "up") == 0){/*update*/
		memset(&entry, 0, sizeof(MIB_CE_RTK_AWIFI_MAC_T));
		_ENTRY_STR(name, _OPT);
		_GET_STR(mac, _OPT);	
		changeStringToMac(entry.macAddr, mac);

		index = atoi(boaGetVar(wp,"index",""));
		/*
		printf("[%s:%d] index=%d, entry.name=%s,mac=%s \n",__FUNCTION__,__LINE__,index,entry.name,mac);
		*/
		mib_chain_update(MIB_RTK_AWIFI_MAC_TBL, (void *)&entry, index);
	}else if(strcmp(stemp, "ad") == 0){/*add*/
		cnt = mib_chain_total(MIB_RTK_AWIFI_MAC_TBL);
		if(cnt >= MAX_RTK_AWIFI_MAC_LIST_NUM)
		{
			ERR_MSG("对不起,规则数已达最大限制!");
			goto check_err;
		}
		
		memset(&entry, 0, sizeof(MIB_CE_RTK_AWIFI_MAC_T));
		_ENTRY_STR(name, _OPT);
		_GET_STR(mac, _OPT);	
		/*
		printf("[%s:%d] entry.name=%s,macStr=%s\n",__FUNCTION__,__LINE__,entry.name,mac);
		*/
		changeStringToMac(entry.macAddr, mac);

		mib_chain_add(MIB_RTK_AWIFI_MAC_TBL,&entry);
	}else{lineno = __LINE__; goto check_err;}
	
#ifdef COMMIT_IMMEDIATELY
	Commit();
#endif
	
#ifdef APPLY_CHANGE
	rtk_wan_aWiFi_stop(-1);
	rtk_wan_aWiFi_start(-1);
#endif

	_COND_REDIRECT;
check_err:
	_BC_FREE();
	_TRACE_LEAVEL;
	return;
}

void rtk_formAWiFiURL(request * wp, char *path, char *query)
{
	char *stemp = "";
	MIB_CE_RTK_AWIFI_URL_T entry;
	int index, cnt;
	int lineno = __LINE__;

	_BC_USE;

	_TRACE_CALL;
	FETCH_INVALID_OPT(stemp, "action", _NEED);
	if (strcmp(stemp, "rm") == 0){/*delete*/
		_BC_INIT("bcdata");
		while(_BC_NEXT())
		{
			memset(&entry, 0, sizeof(MIB_CE_RTK_AWIFI_URL_T));

			_BC_ENTRY_STR(name, _OPT);
			_BC_ENTRY_STR(url, _OPT);		
			MIB_CHAIN_DELETE(MIB_RTK_AWIFI_URL_TBL,MIB_CE_RTK_AWIFI_URL_T,entry);
		}
	}else if(strcmp(stemp, "up") == 0){/*update*/
		memset(&entry, 0, sizeof(MIB_CE_RTK_AWIFI_URL_T));

		_ENTRY_STR(name, _OPT);
		_ENTRY_STR(url, _OPT);	
		index = atoi(boaGetVar(wp,"index",""));
		/*
		printf("[%s:%d] index=%d, entry.name=%s,entry.url=%s \n",__FUNCTION__,__LINE__,index,entry.name,entry.url);
		*/
		mib_chain_update(MIB_RTK_AWIFI_URL_TBL, (void *)&entry, index);
	}else if(strcmp(stemp, "ad") == 0){/*add*/
		cnt = mib_chain_total(MIB_RTK_AWIFI_URL_TBL);
		if(cnt >= MAX_RTK_AWIFI_URL_LIST_NUM)
		{
			ERR_MSG("对不起,规则数已达最大限制!");
			goto check_err;
		}
		
		memset(&entry, 0, sizeof(MIB_CE_RTK_AWIFI_URL_T));

		_ENTRY_STR(name, _OPT);
		_ENTRY_STR(url, _OPT);	
		/*
		printf("[%s:%d] entry.name=%s,entry.url=%s\n",__FUNCTION__,__LINE__,entry.name,entry.url);
		*/
		mib_chain_add(MIB_RTK_AWIFI_URL_TBL,&entry);
	}else{lineno = __LINE__; goto check_err;}
	
#ifdef COMMIT_IMMEDIATELY
	Commit();
#endif

#ifdef APPLY_CHANGE
	rtk_wan_aWiFi_stop(-1);
	rtk_wan_aWiFi_start(-1);
#endif

	_COND_REDIRECT;
check_err:
	_BC_FREE();
	_TRACE_LEAVEL;
	return;
}


#ifdef CONFIG_USER_AWIFI_AUDIT_SUPPORT
void rtk_formAWiFiAudit(request * wp, char *path, char *query)
{
	char *str, *submitUrl;
	unsigned char awifi_audit_type;
	char tmpBuf[64];

	str = boaGetVar(wp, "AWiFiAuditCap", "");
	if (str[0]) {
		awifi_audit_type = str[0] - '0';
		if (!mib_set(MIB_RTK_AWIFI_AUDIT_TYPE, &awifi_audit_type)) {
			strcpy(tmpBuf, Tset_mib_error);
			goto formAWiFiAudit_err;
		}
	}

formAWiFiAudit_end:
#ifdef COMMIT_IMMEDIATELY
	Commit();
#endif

#ifdef APPLY_CHANGE
	rtk_wan_aWiFi_stop(-1);
	rtk_wan_aWiFi_start(-1);
#endif

	submitUrl = boaGetVar(wp, "submit-url", "");
	OK_MSG(submitUrl);
	return;

formAWiFiAudit_err:
	ERR_MSG(tmpBuf);
}
#endif

int rtk_showAWiFiMACTable(int eid, request * wp, int argc, char **argv)
{
	int index, cnt;
	MIB_CE_RTK_AWIFI_MAC_T entry;
	char mac[20]={0};

	_TRACE_CALL;
	
	cnt=mib_chain_total(MIB_RTK_AWIFI_MAC_TBL);
	for(index=0; index<cnt; index++){
		mib_chain_get(MIB_RTK_AWIFI_MAC_TBL, index, (void *)&entry);
		changeMacToString(entry.macAddr, mac);
		/*
		printf("[%s:%d] index=%d, mac=%s, entry.name=%s, entry.macAddr=%02x-%02x-%02x-%02x-%02x-%02x \n",__FUNCTION__,__LINE__,
			index,mac,entry.name,
			entry.macAddr[0],entry.macAddr[1],
			entry.macAddr[2],entry.macAddr[3],
			entry.macAddr[4],entry.macAddr[5]);
		*/
		boaWrite(wp, "push(new it_nr(\"%d\"" _PTS _PTS"));\n",
						index, _PME(name), "mac", mac);
	}
	_TRACE_LEAVEL;
	return 0;
}

int rtk_showAWiFiURLTable(int eid, request * wp, int argc, char **argv)
{
	int index, cnt;
	MIB_CE_RTK_AWIFI_URL_T entry;

	_TRACE_CALL;
	
	cnt=mib_chain_total(MIB_RTK_AWIFI_URL_TBL);
	for(index=0; index<cnt; index++){
		mib_chain_get(MIB_RTK_AWIFI_URL_TBL, index, (void *)&entry);

	/*
		printf("[%s:%d] index=%d,url=%s\n",__FUNCTION__,__LINE__,index,entry.url);
	*/
		boaWrite(wp, "push(new it_nr(\"%d\"" _PTS _PTS"));\n",
						index, _PME(name), _PME(url));
	}
	_TRACE_LEAVEL;
	return 0;
}


