#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include "sysconfig.h"
#include "../webs.h"
#include "ark.h"

#include "../cJSON.h"
#include "../../../port.h"
// #include "multilang_final.h"

#define MAX_LINE_LENGTH 128


static int _isArkOn(void)
{
	FILE *fp = NULL;

	fp = fopen("/proc/ark/info", "r");
	if (!fp) return 0;

	fclose(fp);
	return 1;
}

static void showArkStatus(request *wp)
{
	FILE *fp = NULL;
	char buf[128];

	fp = popen("[ -f /var/app/ark/arktool -a -f /var/app/ark/ark.ini ] && /var/app/ark/arktool ark status -n /var/app/ark/ark.ini", "r");
	if (!fp) {
		boaWrite(wp, "{\"return\": 1}");
		return;
	}

	while (fgets(buf, 128, fp)) {
		boaWrite(wp, "%s", buf);
	}

	pclose(fp);
}

int isArkOn(int eid, request *wp, int argc, char **argv)
{
	boaWrite(wp, "%s", (_isArkOn()) ? "true" : "false");
	return 0;
}

int arkStatusGet(int eid, request *wp, int argc, char **argv)
{
	showArkStatus(wp);
	return 0;
}

int arkVersionGet(int eid, request *wp, int argc, char **argv)
{
	FILE *fp = NULL;
	char buf[MAX_LINE_LENGTH];
	int done = 0;

	fp = popen("[ -f /proc/ark/info ] && cat /proc/ark/info | grep \"ARK version:\"", "r");
	if (!fp) {
		boaWrite(wp, "\"-\"");
		return 0;
	}

	while (fgets(buf, MAX_LINE_LENGTH, fp)) {
		char version[32];
		int n;

		n = sscanf(buf, "ARK version: %s", version);
		if (n != 1) continue;

		boaWrite(wp, "%s", version);
		done = 1;
		break;
	}

	if (!done) {
		boaWrite(wp, "-");
		pclose(fp);
		return 0;
	}

	pclose(fp);
	return 0;
}

int arkSetMode(int eid, request *wp, int argc, char **argv)
{
	char buf[128];
	int n, mode;
	char *str = NULL;
	FILE *fp = NULL;

	str = boaGetVar(wp, "mode", "");
	if (!str) {
		boaWrite(wp, "{\"return\": 1}");
		return 0;
	}

	n = sscanf(str, "%d", &mode);
	if (n != 1) {
		boaWrite(wp, "{\"return\": 1}");
		return 0;
	}

	switch (mode) {
		case 0:
			fp = popen("[ -f /var/app/ark/gtb_agent ] && /var/app/ark/gtb_agent stop", "r");
			break;
		case 1:
			fp = popen("[ -f /var/app/ark/gtb_agent ] && /var/app/ark/gtb_agent start", "r");
			break;
		default:
			boaWrite(wp, "{\"return\": 1}");
			return 0;
	}

	sleep(5);

	if (!fp) {
		boaWrite(wp, "{\"return\": 2}");
		return 0;
	}

	{
		int ret;
		unsigned char val = (unsigned char) mode;
		ret = mib_set(MIB_GTB_ARK_MODE, (void *)&val);
#ifdef COMMIT_IMMEDIATELY
		mib_update(CURRENT_SETTING, CONFIG_MIB_ALL);
#endif
	}
	
	showArkStatus(wp);
	pclose(fp);
	return 0;
}

int arkStatsGet(int eid, request *wp, int argc, char **argv)
{
	FILE *fp;
	char buf[1024];

	fp = popen("[ -f /var/app/ark/arktool -a -f /var/app/ark/ark.ini ] && /var/app/ark/arktool ark stats -n /var/app/ark/ark.ini", "r");
	if (!fp) return 0;

	while (fgets(buf, 1024, fp)) {
		boaWrite(wp, "%s", buf);
	}

	pclose(fp);
	return 0;
}

