/*
 *      laod balance
 *
 */

/*-- System inlcude files --*/
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <ctype.h>
#include <sys/wait.h>

#include "../webs.h"
#include "webform.h"
#include "mib.h"
#include "utility.h"
#include "multilang.h"
#include "subr_net.h"

#define MAX_PORT_NUM	11
#define MAX_TOTAL_LOGIC_PORT_NUM 6

#if defined(CONFIG_RTL_MULTI_PHY_ETH_WAN)
void formLdStats(request * wp, char *path, char *query)
{
	char *strValue, *submitUrl, ret=0;
	
	submitUrl = boaGetVar(wp, "submit-url", "");   // hidden page

	if (submitUrl[0])
		boaRedirect(wp, submitUrl);
}

int rtk_set_default_route_by_wan_info(MIB_CE_ATM_VC_T *wan_entry)
{
	char wan_gw_ip[16] = {0};
	char wan_name[IFNAMSIZ] = {0};
	int balance_type;
	
	if(wan_entry ==NULL)
		return -1;

	ifGetName(wan_entry->ifIndex, wan_name, sizeof(wan_name));

	if(wan_entry->balance_type == 1)
	{
		//shared network need check default route rule which is necessary or not.
		if(isDefaultRouteWan(wan_entry))
		{
			rtk_get_default_gw_ip_by_wan_info(wan_name, wan_entry->cmode, wan_gw_ip);
			if((wan_entry->cmode==CHANNEL_MODE_IPOE) && (strlen(wan_gw_ip) > 0))
			{
				va_cmd(ROUTE, 6, 1, ARG_ADD, "default", "gw", wan_gw_ip, "dev", wan_name);
			}
			else if(wan_entry->cmode==CHANNEL_MODE_PPPOE)
			{
				va_cmd(ROUTE, 3, 1, ARG_ADD, "default", wan_name);
			}
			else{
				//do nothing
			}
		}
	}
	else
	{
		//proprietary network should delete default route rule.
		va_cmd(ROUTE, 3, 1, ARG_DEL, "default", wan_name);
	}

	return 0;
}

void formDynmaicBalance(request * wp, char *path, char *query)
{
	char *addDynbalance, *strWanDevName, *dynSelectValue, *globalEnableFlag, *dynTypeValue, *submitUrl, *strVal;
	int i =0, total_wan_num = 0,j = 0 , dyn_select_value = 0, dyn_type_value = 0 , dy_enable_flag = 0, dyn_type_old = 0;
	int dy_weight_flag = 0, dy_weight_old = 0;
	MIB_CE_ATM_VC_T wan_entry;
	char wanif[IFNAMSIZ] = {0};
	char tmpBuf[100];
	char vChar = 0,globalFlag = 0;
	char tmpbuf1[32]={0},tmpbuf2[32]={0},tmpbuf3[32]={0};
	char global_balance_enable = 0;
	int global_balance_flag = 0;
	char dy_enable = 0;
	char cmd[128] = {0};

	globalEnableFlag = boaGetVar(wp, "total_balance_enable", "");
	if (globalEnableFlag[0]) {
		if (globalEnableFlag[0] == '0')
			globalFlag = 0;
		else if(globalEnableFlag[0] == '1')
			globalFlag = 1;
	}
	if(!mib_get_s(MIB_GLOBAL_LOAD_BALANCE, (void *)&global_balance_enable,sizeof(global_balance_enable)))
	{
		snprintf(tmpBuf, sizeof(tmpBuf), "%s:%s", Tget_mib_error, MIB_GLOBAL_LOAD_BALANCE);
		goto setErr_dyn_balance;
	}
		
	if(!mib_set(MIB_GLOBAL_LOAD_BALANCE, (void *)&globalFlag))
	{
		snprintf(tmpBuf, sizeof(tmpBuf), "%s:%s", Tset_mib_error, MIB_GLOBAL_LOAD_BALANCE);
		goto setErr_dyn_balance;
	}

	if(globalFlag != global_balance_enable)
		global_balance_flag =1;

	if(!globalFlag)
	{
		printf("[%s %d] total load balance is disabled!\n",__FUNCTION__,__LINE__);
		goto setOk_dyn_Balance;
	}
	
	strVal = boaGetVar(wp, "dynamic_balance_enable", "");
	if (strVal[0]) {
		if (strVal[0] == '0')
			vChar = 0;
		else if(strVal[0] == '1')
			vChar = 1;
	}

	if(vChar)
	{
		strVal = boaGetVar(wp, "dynamic_balance_type", "");
		if (strVal[0]) {
			if (strVal[0] == '1'){
				//connect load balance
				vChar = 1;
			}
			else if(strVal[0] == '2'){
				//boardband load balance
				vChar = 2;
			}
		}
	}

	if(!mib_get_s(MIB_DYNAMIC_LOAD_BALANCE, (void *)&dy_enable,sizeof(dy_enable)))
	{
		snprintf(tmpBuf, sizeof(tmpBuf), "%s:%s", Tget_mib_error, MIB_DYNAMIC_LOAD_BALANCE);
		goto setErr_dyn_balance;
	}

	if(vChar != dy_enable)
		dy_enable_flag = 1;

	if(!mib_set(MIB_DYNAMIC_LOAD_BALANCE, (void *)&vChar))
	{
		snprintf(tmpBuf, sizeof(tmpBuf), "%s:%s", Tset_mib_error, MIB_DYNAMIC_LOAD_BALANCE);
		goto setErr_dyn_balance;
	}

	if(!vChar){
		printf("[%s %d] dynamic load balance is disabled!\n",__FUNCTION__,__LINE__ );
		goto setOk_dyn_Balance;
	}

	addDynbalance = boaGetVar(wp, "addDynBalance", "");
	//add dynmaic load balance
	if(addDynbalance[0]){
		total_wan_num = mib_chain_total(MIB_ATM_VC_TBL);
		for(i = 0; i < total_wan_num; i++)
		{
			if(!mib_chain_get(MIB_ATM_VC_TBL, i, &wan_entry))
				continue;

			ifGetName(wan_entry.ifIndex, wanif, sizeof(wanif));

			dyn_type_old = wan_entry.balance_type;
			dy_weight_old = wan_entry.weight;
			
			if(vChar==RTK_CONNECT_TYPE){
				for(j =0; j< total_wan_num; j++){
					snprintf(tmpbuf1, 32, "wan_name_ct_%d", j);
					strWanDevName = boaGetVar(wp, tmpbuf1, "");
					if(!strncmp(strWanDevName, wanif, sizeof(wanif)))
					{
						snprintf(tmpbuf2, 32, "dyn_select_%d", j);
						dynSelectValue = boaGetVar(wp, tmpbuf2, "");
						dyn_select_value = atoi(dynSelectValue);

						snprintf(tmpbuf3, 32, "dyn_ct_type_%d", j);
						dynTypeValue = boaGetVar(wp, tmpbuf3, "");
						dyn_type_value = atoi(dynTypeValue);

						break;
					}
				}

				wan_entry.balance_type = (unsigned int)dyn_type_value;
				wan_entry.weight = (unsigned int)dyn_select_value;

				if(dy_weight_old != wan_entry.weight)
					dy_weight_flag = 1;
				
				if(!mib_chain_update(MIB_ATM_VC_TBL, (void*)&wan_entry, (unsigned int)i))
				{
					snprintf(tmpBuf, sizeof(tmpBuf), "%s", Tadd_chain_error);
					goto setErr_dyn_balance;
				}
			}
			else if(vChar == RTK_BANDWIDTH_TYPE){
				for(j =0; j< total_wan_num; j++){
					snprintf(tmpbuf1, 32, "wan_name_bd_%d", j);
					strWanDevName = boaGetVar(wp, tmpbuf1, "");
					if(!strncmp(strWanDevName, wanif, sizeof(wanif)))
					{
						snprintf(tmpbuf2, 32, "dyn_wan_bd_%d", j);
						dynSelectValue = boaGetVar(wp, tmpbuf2, "");
						dyn_select_value = atoi(dynSelectValue);

						snprintf(tmpbuf3, 32, "dyn_bd_type_%d", j);
						dynTypeValue = boaGetVar(wp, tmpbuf3, "");
						dyn_type_value = atoi(dynTypeValue);
						break;
					}
				}

				wan_entry.balance_type = (unsigned int)dyn_type_value;
				wan_entry.weight = (unsigned int)dyn_select_value;
				if(!mib_chain_update(MIB_ATM_VC_TBL, (void*)&wan_entry, (unsigned int)i))
				{
					snprintf(tmpBuf, sizeof(tmpBuf), "%s", Tadd_chain_error);
					goto setErr_dyn_balance;
				}
			}

			if(dyn_type_old != dyn_type_value)   //wan 's balance type be changed
			{		

				rtk_set_default_route_by_wan_info(&wan_entry);
				
				if(dyn_type_value == 0)   //share -> private
				{
					memset(cmd, 0, sizeof(cmd));
					snprintf(cmd, sizeof(cmd), "sysconf send_unix_sock_message /var/run/systemd.usock do_web_change_process type_to_private %s",wanif);
					system(cmd);
				}
				else   // private -> share
				{
					memset(cmd, 0, sizeof(cmd));
					snprintf(cmd, sizeof(cmd), "sysconf send_unix_sock_message /var/run/systemd.usock do_web_change_process type_to_share");
					system(cmd);
				}
			}
		}

		goto setOk_dyn_Balance;
	}

setOk_dyn_Balance:
	//	Magician: Commit immediately
	
#ifdef COMMIT_IMMEDIATELY
	Commit();
#endif
	if(global_balance_flag)
	{
		//process manual load balance when change global balance states
		set_manual_load_balance_rules();
		
		if(globalFlag)  
		{
			if(vChar)	//global switch to enable	
			{
				memset(cmd, 0, sizeof(cmd));
				snprintf(cmd, sizeof(cmd), "sysconf send_unix_sock_message /var/run/systemd.usock do_web_change_process dy_to_enable");
				system(cmd);
			} 
		}
		else   //global switch to disable         
		{
			memset(cmd, 0, sizeof(cmd));
			snprintf(cmd, sizeof(cmd), "sysconf send_unix_sock_message /var/run/systemd.usock do_web_change_process dy_to_disable");
			system(cmd);
		}  
	}
	
	if(dy_enable_flag)
	{
		if(vChar)   //dynamic switch to enable
		{
			memset(cmd, 0, sizeof(cmd));
			snprintf(cmd, sizeof(cmd), "sysconf send_unix_sock_message /var/run/systemd.usock do_web_change_process dy_to_enable");
			system(cmd);
		} 
		else       //dynamic switch to disable
		{
			memset(cmd, 0, sizeof(cmd));
			snprintf(cmd, sizeof(cmd), "sysconf send_unix_sock_message /var/run/systemd.usock do_web_change_process dy_to_disable");
			system(cmd);
		}   
	}

	if(dy_weight_flag)
	{
		memset(cmd, 0, sizeof(cmd));
		snprintf(cmd, sizeof(cmd), "sysconf send_unix_sock_message /var/run/systemd.usock do_web_change_process dy_mod_weight");
		system(cmd);
	}	


	submitUrl = boaGetVar(wp, "submit-url", "");   // hidden page
	if (submitUrl[0])
		boaRedirect(wp, submitUrl);
	else
		boaDone(wp, 200);

	return;

setErr_dyn_balance:
	ERR_MSG(tmpBuf);	
}

int rtk_get_all_static_entry(char (*mac_str)[MAC_ADDR_STRING_LEN])
{
	int i , con_cnt = 0 , totalEntry = 0;
	MIB_STATIC_LOAD_BALANCE_T sta_balance_entry;

	totalEntry = mib_chain_total(MIB_STATIC_LOAD_BALANCE_TBL);

	for (i=0; i<totalEntry; i++) {
		if(!mib_chain_get(MIB_STATIC_LOAD_BALANCE_TBL, i, &sta_balance_entry))
			continue;

		if(mac_str[con_cnt])
			memcpy(mac_str[con_cnt], sta_balance_entry.mac, MAC_ADDR_STRING_LEN);
		con_cnt++;
	}

	return con_cnt;
}

int rtk_delete_dynamic_entry_when_manual_enable(void)
{
	MIB_STATIC_LOAD_BALANCE_T sta_balance_entry;
	int i = 0, totalEntry = 0;
	char cmd[128] = {0};
	
	totalEntry = mib_chain_total(MIB_STATIC_LOAD_BALANCE_TBL);
	for (i=0; i<totalEntry; i++) {
		if(!mib_chain_get(MIB_STATIC_LOAD_BALANCE_TBL, i, &sta_balance_entry))
			continue;

		memset(cmd, 0, sizeof(cmd));
		snprintf(cmd, sizeof(cmd), "sysconf send_unix_sock_message /var/run/systemd.usock do_web_change_process add_static %s",sta_balance_entry.mac);
		system(cmd);
	}

	return 1;
}

int rtk_check_manual_balance_is_exist(char *mac)
{
	MIB_STATIC_LOAD_BALANCE_T sta_balance_entry;
	int i = 0, totalEntry = 0;
	
	totalEntry = mib_chain_total(MIB_STATIC_LOAD_BALANCE_TBL);
	for (i=0; i<totalEntry; i++) {
		if(!mib_chain_get(MIB_STATIC_LOAD_BALANCE_TBL, i, &sta_balance_entry))
			continue;

		if(!strncmp(mac,sta_balance_entry.mac,MAC_ADDR_STRING_LEN-1))
		{
			return 1;
		}
	}

	return 0;
}

void formStaticBalance(request * wp, char *path, char *query)
{
	char *submitUrl, *strVal;
	char *totalNum;
	char *strDevName, *strMac, *strWanDevName,*delDevMac;
	char *addStaBalance, *delStabalance, *delAllStabalance;
	char vChar = 0, sta_enable = 0,sta_enable_flag = 0;
	char tmpBuf[100];
	MIB_CE_ATM_VC_T wan_entry;
	MIB_STATIC_LOAD_BALANCE_T sta_balance_entry;
	int intVal = 0, mibTblId = 0;
	int i =0, deleted = 0, totalEntry = 0,j = 0, con_cnt;
	int total_lan_num = 0, get_del_dev_flag = 0, total_wan_num = 0;
	char tmpbuf1[32]={0},tmpbuf2[32]={0},tmpbuf3[32]={0};
	char wanif[IFNAMSIZ] = {0};
	char save_mac_str[16][MAC_ADDR_STRING_LEN] = {0};    //16 is static ld table max num
	char cmd[128] = {0};
	
	strVal = boaGetVar(wp, "balance_enable", "");
	addStaBalance = boaGetVar(wp, "addStaBalance", "");
	delStabalance = boaGetVar(wp, "deleteSelStaBalance", "");
	delAllStabalance = boaGetVar(wp, "deleteAllStaBalance", "");

	//enable or disable manual load balance
	if (strVal[0]) {
		if (strVal[0] == '0')
			vChar = 0;
		else if(strVal[0] == '1')
			vChar = 1;

		if(!mib_get_s(MIB_STATIC_LOAD_BALANCE_ENABLE, (void *)&sta_enable,sizeof(sta_enable)))
		{
			snprintf(tmpBuf, sizeof(tmpBuf), "%s:%s", Tget_mib_error, MIB_STATIC_LOAD_BALANCE_ENABLE);
			goto setErr_sta_balance;
		}

		if(vChar != sta_enable)
			sta_enable_flag = 1;
		
		if(!mib_set(MIB_STATIC_LOAD_BALANCE_ENABLE, (void *)&vChar))
		{
			snprintf(tmpBuf, sizeof(tmpBuf), "%s:%s", Tset_mib_error, MIB_STATIC_LOAD_BALANCE_ENABLE);
			goto setErr_sta_balance;
		}

		if(!vChar){
			printf("[%s %d] static load balance is disable!\n",__FUNCTION__,__LINE__ );			
			goto setOk_StaBalance;
		}
	}

	//delete all entries
	if(delAllStabalance[0]){
		
		con_cnt = rtk_get_all_static_entry(save_mac_str);
			
		mibTblId = MIB_STATIC_LOAD_BALANCE_TBL;
		printf("%s %d delete all static entry!\n",__FUNCTION__,__LINE__);	
		mib_chain_clear(mibTblId); /* clear chain record */
	
		for(i = 0; i < con_cnt; i++)
		{	
			memset(cmd, 0, sizeof(cmd));
			snprintf(cmd, sizeof(cmd), "sysconf send_unix_sock_message /var/run/systemd.usock do_web_change_process del_static %s",save_mac_str[i]);
			system(cmd);
		}
	
		goto setOk_StaBalance;
	}

	//delete selected entries
	if(delStabalance[0])
	{
		totalEntry = mib_chain_total(MIB_STATIC_LOAD_BALANCE_TBL);
		for (i=0; i<totalEntry; i++) {
			get_del_dev_flag = 0;
			snprintf(tmpbuf1, 32, "delete%d", i);
			strVal = boaGetVar(wp, tmpbuf1, "");

			snprintf(tmpbuf2, 32, "del_dev_%d", i);
			delDevMac = boaGetVar(wp, tmpbuf2, "");

			if ( !strncmp(strVal, "ON",2)) {
				for(j= 0; j<totalEntry; j++)
				{
					if(!mib_chain_get(MIB_STATIC_LOAD_BALANCE_TBL, j, &sta_balance_entry))
						continue;

					if(!strncmp(delDevMac, sta_balance_entry.mac, MAC_ADDR_STRING_LEN))
					{
						get_del_dev_flag = 1;
						strWanDevName = sta_balance_entry.wan_itfname;
						break;
					}
				}

				if(get_del_dev_flag)
				{
					if(mib_chain_delete(MIB_STATIC_LOAD_BALANCE_TBL, j) != 1) {
						snprintf(tmpBuf, sizeof(tmpBuf), "%s", Tdelete_chain_error);
						goto setErr_sta_balance;
					}
					 //when delete static entry ,the mac need add dynamic load balance ,signal example is "00:11:22:33:44:55"
					memset(cmd, 0, sizeof(cmd));
					snprintf(cmd, sizeof(cmd), "sysconf send_unix_sock_message /var/run/systemd.usock do_web_change_process del_static %s",sta_balance_entry.mac);
					system(cmd);
				}
			}
		}
		goto setOk_StaBalance;
	}

	//add static load balance
	if(addStaBalance[0]){
		//validity check.
		totalEntry = mib_chain_total(MIB_STATIC_LOAD_BALANCE_TBL);
		if(totalEntry == RTK_MANUAL_BALANCE_TOTAL_NUM)
		{
			snprintf(tmpBuf, sizeof(tmpBuf), "%s", "MIB_STATIC_LOAD_BALANCE_TBL is full!");
				goto setErr_sta_balance;
		}

		totalNum = boaGetVar(wp, "total_lan_num", "");
		total_lan_num = atoi(totalNum);
		for(i = 0; i < total_lan_num;i++)
		{
			memset(tmpbuf1,0,sizeof(tmpbuf1));
			snprintf(tmpbuf1,sizeof(tmpbuf1),"select%d",i);
			strVal = boaGetVar(wp, tmpbuf1, "");
			
			if(strVal[0] == '1')
			{
				memset(&sta_balance_entry,0,sizeof(sta_balance_entry));
				memset(tmpbuf1,0,sizeof(tmpbuf1));
				memset(tmpbuf2,0,sizeof(tmpbuf2));
				memset(tmpbuf3,0,sizeof(tmpbuf3));
				snprintf(tmpbuf1,sizeof(tmpbuf1),"dev_name_%d",i);
				snprintf(tmpbuf2,sizeof(tmpbuf2),"mac_%d",i);
				snprintf(tmpbuf3,sizeof(tmpbuf3),"interface_%d",i);

				sta_balance_entry.enable  = 1;

				strDevName = boaGetVar(wp, tmpbuf1, "");
				strMac = boaGetVar(wp, tmpbuf2, "");
				strWanDevName = boaGetVar(wp, tmpbuf3, "");

				if(strDevName[0] && strMac[0] && strWanDevName[0])
				{
					snprintf(sta_balance_entry.dev_name, RTK_LAN_NAME_LENTH, "%s", strDevName);
					snprintf(sta_balance_entry.mac, MAC_ADDR_STRING_LEN, "%s", strMac);
					snprintf(sta_balance_entry.wan_itfname, IFNAMSIZ, "%s", strWanDevName);
				}
				else{
					snprintf(tmpBuf, sizeof(tmpBuf), "%s", "get manual load balance information fail!");
					goto setErr_sta_balance;
				}
				if(rtk_check_manual_balance_is_exist(sta_balance_entry.mac)==1){
					snprintf(tmpBuf, sizeof(tmpBuf), "%s", "manual load balance rule already exists!");
					goto setErr_sta_balance;
				}
				//printf("=====%s %s %s\n",sta_balance_entry.dev_name,sta_balance_entry.mac,sta_balance_entry.wan_itfname);
				intVal = mib_chain_add(MIB_STATIC_LOAD_BALANCE_TBL, (unsigned char*)&sta_balance_entry);
				if (intVal == 0) {
					snprintf(tmpBuf, sizeof(tmpBuf), "%s", Tadd_chain_error);
					goto setErr_sta_balance;
				}
				else if (intVal == -1) {
					snprintf(tmpBuf, sizeof(tmpBuf), "%s", strTableFull);
					goto setErr_sta_balance;
				}
				 //when add static entry ,the mac need delete dynamic load balance ,signal example is "00:11:22:33:44:55"
				memset(cmd, 0, sizeof(cmd));
				snprintf(cmd, sizeof(cmd), "sysconf send_unix_sock_message /var/run/systemd.usock do_web_change_process add_static %s",sta_balance_entry.mac);
				system(cmd);
			}
		}
		goto setOk_StaBalance;
	}

setOk_StaBalance:
	//	Magician: Commit immediately
#ifdef COMMIT_IMMEDIATELY
	Commit();
#endif
	if(sta_enable_flag)
	{
		if(vChar)  //switch to enable
		{	
			rtk_delete_dynamic_entry_when_manual_enable();
		}
		else   //switch to disable
		{
			memset(cmd, 0, sizeof(cmd));
			snprintf(cmd, sizeof(cmd), "sysconf send_unix_sock_message /var/run/systemd.usock do_web_change_process dy_to_enable");
			system(cmd);
		}
	}

	//set rules to manual load balance
	set_manual_load_balance_rules();

	submitUrl = boaGetVar(wp, "submit-url", "");   // hidden page
	if (submitUrl[0])
		boaRedirect(wp, submitUrl);
	else
		boaDone(wp, 200);

	return;

setErr_sta_balance:
	ERR_MSG(tmpBuf);	
}


int sta_balance_list(int eid, request * wp, int argc, char **argv)
{
	int nBytesSent=0;
	unsigned int wan_entry_num,sta_load_entry_num;
	int i = 0, j = 0;
	MIB_STATIC_LOAD_BALANCE_T Entry;
	MIB_CE_ATM_VC_T wan_entry;
	char *start_ip, *end_ip;

	char wanif[IFNAMSIZ] = {0};
	char tmpBuf[12] = {0};
	char global_balance_enable = 0, manual_enable = 0;
	
	sta_load_entry_num = mib_chain_total(MIB_STATIC_LOAD_BALANCE_TBL);
	wan_entry_num = mib_chain_total(MIB_ATM_VC_TBL);
	if(!mib_get_s(MIB_GLOBAL_LOAD_BALANCE, (void *)&global_balance_enable,sizeof(global_balance_enable)))
	{
		return nBytesSent;
	}

	if(!mib_get_s(MIB_STATIC_LOAD_BALANCE_ENABLE, (void *)&manual_enable,sizeof(manual_enable)))
	{
		return nBytesSent;
	}

	if(manual_enable == 0 || global_balance_enable == 0)
	{
		snprintf(tmpBuf,12,"%s","disabled");
	}
	nBytesSent += boaWrite(wp, "<tr>"
		"<th align=\"left\" width=\"20%%\" bgcolor=\"#C0C0C0\">%s</th>\n"
		"<th align=\"left\" width=\"20%%\" bgcolor=\"#C0C0C0\">%s</th>\n"
		"<th align=\"left\" width=\"20%%\" bgcolor=\"#C0C0C0\">%s</th>\n"
		"<th align=\"left\" width=\"40%%\" bgcolor=\"#C0C0C0\">%s</th></tr>\n",
		multilang(LANG_ENABLE_STATIC_LOAD_BALANCE), multilang(LANG_LOAD_BALANCE_DEV_NAME), multilang(LANG_MAC_ADDRESS),multilang(LANG_WAN_INTERFACE));
	
	for(i = 0;i<wan_entry_num; i++)
	{
		if(!mib_chain_get(MIB_ATM_VC_TBL, i, &wan_entry))
			continue;
		
		ifGetName(wan_entry.ifIndex, wanif, sizeof(wanif));


		for(j=0; j<sta_load_entry_num; j++)
		{
			if(!mib_chain_get(MIB_STATIC_LOAD_BALANCE_TBL, j, &Entry))
				continue;

			if(strncmp(Entry.wan_itfname, wanif, sizeof(wanif)))
				continue;

			nBytesSent += boaWrite(wp, "<tr>"
			"<td align=\"left\" width=\"20%%\" bgcolor=\"#808080\"><input type=\"checkbox\" name=\"delete%d\" value=\"ON\" %s></td>\n"
			"<td align=\"left\" width=\"20%%\" bgcolor=\"#808080\"><font size=\"2\">%s<input type=\"hidden\" name=\"del_dev_%d\" value=\"%s\"></font></td>\n"
			"<td align=\"left\" width=\"20%%\" bgcolor=\"#808080\"><font size=\"2\">%s</font></td>"
			"<td align=\"left\" width=\"40%%\" bgcolor=\"#808080\"><font size=\"2\">%s</font></td></tr>\n",
			j, tmpBuf, Entry.dev_name, j, Entry.mac, Entry.mac,wanif);
		}


	}
	
	return nBytesSent;
}

int rtk_set_connect_load_balance(int eid, request * wp, int argc, char **argv)
{
	int nBytesSent=0, entry_num = 0,i = 0;
	MIB_CE_ATM_VC_T entry;
	char wanif[IFNAMSIZ] = {0};
	char tmpBuf[12] = {0};
	char global_balance_enable = 0, dyn_enable = 0;

	if(!mib_get_s(MIB_GLOBAL_LOAD_BALANCE, (void *)&global_balance_enable,sizeof(global_balance_enable)))
	{
		return nBytesSent;
	}

	if(!mib_get_s(MIB_DYNAMIC_LOAD_BALANCE, (void *)&dyn_enable,sizeof(dyn_enable)))
	{
		return nBytesSent;
	}

	if(dyn_enable == 0 || global_balance_enable == 0)
	{
		snprintf(tmpBuf,12,"%s","disabled");
	}
	
	entry_num = mib_chain_total(MIB_ATM_VC_TBL);

	for(i=0;i<entry_num;i++)
	{
		if(!mib_chain_get(MIB_ATM_VC_TBL, i, &entry))
			continue;

		ifGetName(entry.ifIndex, wanif, sizeof(wanif));
		
		nBytesSent += boaWrite(wp, "<tr>"
			"<td align=\"left\" width=\"20%%\" bgcolor=\"#808080\"><font size=\"2\">%s<input type=\"hidden\" name=\"wan_name_ct_%d\" value=\"%s\"></td>\n"
			"<td align=\"left\" width=\"40%%\" bgcolor=\"#808080\"><font size=\"2\"><select id=\"ct_type_%d\" name=\"dyn_ct_type_%d\" style=\"width:170px\" %s>\n"
					"<option value=\"0\">%s</option>\n"
					"<option value=\"1\">%s</option>\n"
					"</select><input type=\"hidden\" id=\"ct_type_value_%d\" value=\"%d\"></td>\n"
			"<td align=\"left\" width=\"15%%\" bgcolor=\"#808080\"><font size=\"2\">%d</td>\n"
			"<td align=\"left\" width=\"25%%\" bgcolor=\"#808080\"><font size=\"2\"><select id=\"ct_name_%d\" name=\"dyn_select_%d\" %s>\n"
					"<option value=\"1\">1</option>\n"
					"<option value=\"2\">2</option>\n"
					"<option value=\"3\">3</option>\n"
					"<option value=\"4\">4</option>\n"
					"<option value=\"5\">5</option>\n"
					"<option value=\"6\">6</option>\n"
					"<option value=\"7\">7</option>\n"
					"<option value=\"8\">8</option>\n"
					"<option value=\"9\">9</option>\n"
					"<option value=\"10\">10</option>\n"
					"</select><input type=\"hidden\" id=\"ct_selected_value_%d\" value=\"%d\"></td></tr>\n",
			wanif, i, wanif,
			i, i, tmpBuf, multilang(LANG_DYN_PROPRIETARY_NETWORK), multilang(LANG_DYN_SHARED_NETWORK), i, entry.balance_type,
			entry.logic_port,
			i, i, tmpBuf, i, entry.weight-1);
	}

	return nBytesSent;
}

int rtk_set_bandwidth_load_balance(int eid, request * wp, int argc, char **argv)
{
	int nBytesSent=0, entry_num = 0,i = 0;
	MIB_CE_ATM_VC_T entry;
	char wanif[IFNAMSIZ] = {0};
	char tmpBuf[12] = {0};
	char global_balance_enable = 0, dyn_enable = 0;

	entry_num = mib_chain_total(MIB_ATM_VC_TBL);

	if(!mib_get_s(MIB_GLOBAL_LOAD_BALANCE, (void *)&global_balance_enable,sizeof(global_balance_enable)))
	{
		return nBytesSent;
	}

	if(!mib_get_s(MIB_DYNAMIC_LOAD_BALANCE, (void *)&dyn_enable,sizeof(dyn_enable)))
	{
		return nBytesSent;
	}

	if(dyn_enable == 0 || global_balance_enable == 0)
	{
		snprintf(tmpBuf,12,"%s","disabled");
	}

	for(i=0;i<entry_num;i++)
	{
		if(!mib_chain_get(MIB_ATM_VC_TBL, i, &entry))
			continue;

		ifGetName(entry.ifIndex, wanif, sizeof(wanif));
		
		nBytesSent += boaWrite(wp, "<tr>"
			"<td align=\"left\" width=\"20%%\" bgcolor=\"#808080\"><font size=\"2\">%s<input type=\"hidden\" name=\"wan_name_bd_%d\" value=\"%s\"></td>\n"
			"<td align=\"left\" width=\"40%%\" bgcolor=\"#808080\"><font size=\"2\"><select id=\"bd_type_%d\" name=\"dyn_bd_type_%d\" style=\"width:170px\" %s>\n"
					"<option value=\"0\">%s</option>\n"
					"<option value=\"1\">%s</option>\n"
					"</select><input type=\"hidden\" id=\"bd_type_value_%d\" value=\"%d\"></td>\n"
			"<td align=\"left\" width=\"15%%\" bgcolor=\"#808080\"><font size=\"2\">%d</td>\n"
			"<td align=\"left\" width=\"25%%\" bgcolor=\"#808080\"><font size=\"2\"><input type=\"text\" id =\"bd_name_%d\" name = \"dyn_wan_bd_%d\" size=\"12\" maxlength=\"12\" value = %d></td></tr>\n",
			wanif, i, wanif,
			i, i, tmpBuf, multilang(LANG_DYN_PROPRIETARY_NETWORK), multilang(LANG_DYN_SHARED_NETWORK), i, entry.balance_type,
			entry.logic_port,
			i, i, entry.weight ,tmpBuf);
	}

	return nBytesSent;
}

#if defined(CONFIG_USER_LANNETINFO) && defined(CONFIG_USER_REFINE_CHECKALIVE_BY_ARP)
int rtk_set_lan_sta_load_balance(int eid, request * wp, int argc, char **argv)
{
	int i = 0,idx = 0,entry_num = 0;
	int nBytesSent=0;
	unsigned int count = 0;
	unsigned char mac[18] = {0};
	MIB_CE_ATM_VC_T entry;
	char wanif[IFNAMSIZ] = {0};
	char *buf = NULL;
	char option_buf[RTK_SELECT_OPTION_LEN_OF_WAN_NAME] = {0};
	char dev_name[RTK_LAN_NAME_LENTH] = {0};
	char tmpBuf[12] = {0};
	char global_balance_enable = 0, manual_enable = 0;
	lanHostInfo_t *pLanNetInfo=NULL;

	if(!mib_get_s(MIB_GLOBAL_LOAD_BALANCE, (void *)&global_balance_enable,sizeof(global_balance_enable)))
	{
		return nBytesSent;
	}

	if(!mib_get_s(MIB_STATIC_LOAD_BALANCE_ENABLE, (void *)&manual_enable,sizeof(manual_enable)))
	{
		return nBytesSent;
	}

	if(manual_enable == 0 || global_balance_enable == 0)
	{
		snprintf(tmpBuf,12,"%s","disabled");
	}

	if(get_lan_net_info(&pLanNetInfo, &count) != 0)
	{
		goto get_info_end;
	}

	entry_num = mib_chain_total(MIB_ATM_VC_TBL);

	buf = (char *)malloc(sizeof(char)*RTK_SELECT_OPTION_LEN_OF_WAN_NAME*entry_num);

	if(buf == NULL){
		printf("%s %d buf is NULL\n",__FUNCTION__,__LINE__);
		goto get_info_end;
	}
	memset(buf,0,sizeof(buf));
	
	for(i=0;i<entry_num;i++)
	{
		memset(wanif,0,sizeof(wanif));
		memset(option_buf,0,sizeof(option_buf));
		if(!mib_chain_get(MIB_ATM_VC_TBL, i, &entry))
		    continue;

		ifGetName(entry.ifIndex, wanif, sizeof(wanif));
		snprintf(option_buf,sizeof(option_buf),"<option value=\"%s\">%s</option>",wanif,wanif);
		strncat(buf,option_buf,sizeof(option_buf));
	}

	if(count > 0)
	{
		for(i=0; (i<count) && (idx<MAX_STA_NUM*2); i++){
			memset(mac,0,sizeof(mac));
			snprintf(mac,sizeof(mac),"%02x:%02x:%02x:%02x:%02x:%02x", pLanNetInfo[idx].mac[0],pLanNetInfo[idx].mac[1],pLanNetInfo[idx].mac[2],pLanNetInfo[idx].mac[3],pLanNetInfo[idx].mac[4],pLanNetInfo[idx].mac[5]);
			if(strlen(pLanNetInfo[idx].devName)==0)
				snprintf(dev_name, RTK_LAN_NAME_LENTH, "unknown");
			else
				snprintf(dev_name, RTK_LAN_NAME_LENTH, "%s", pLanNetInfo[idx].devName);
			
			nBytesSent += boaWrite(wp, "<tr>"
			"<td align=\"left\" width=\"20%%\" bgcolor=\"#C0C0C0\"><input type=\"checkbox\" id=\"set%d\" name=\"select%d\" value=\"0\" %s></td>\n"
			"<td align=\"left\" width=\"20%%\" bgcolor=\"#C0C0C0\"><font size=\"2\">%s<input type=\"hidden\" name=\"dev_name_%d\" value=\"%s\"></td>\n"
			"<td align=\"left\" width=\"20%%\" bgcolor=\"#C0C0C0\"><font size=\"2\">%s<input type=\"hidden\" name=\"mac_%d\" value=\"%s\"></td>\n"
			"<td align=\"left\" width=\"15%%\" bgcolor=\"#C0C0C0\"><font size=\"2\">%d</td>\n"
			"<td align=\"left\" width=\"25%%\" bgcolor=\"#C0C0C0\"><select name =\"interface_%d\" %s>%s</select></td></tr>\n",
			idx,idx, tmpBuf,
			dev_name,idx,dev_name,
			mac,idx,mac,
			pLanNetInfo[idx].phy_port,
			idx,tmpBuf, buf);

			idx++;
		}
		nBytesSent += boaWrite(wp, "<tr><input type=\"hidden\" name=\"total_lan_num\" value=\"%d\"></tr>\n", idx);
	}

	if(buf)
		free(buf);
	
get_info_end:
	if(pLanNetInfo)
		free(pLanNetInfo);


	return nBytesSent;
}

int LoadBalanceStatsList(int eid, request * wp, int argc, char **argv)
{
	int nBytesSent = 0,i = 0, j = 0,k=0;
	int sta_entry_num = 0, wan_entry_idx = 0;
	MIB_CE_ATM_VC_T entry;
	unsigned int count = 0, wanCount = 0, mappingCount = 0;
	char wanif[IFNAMSIZ] = {0};
	MIB_STATIC_LOAD_BALANCE_T sta_entry;
	unsigned int wan_mark = 0, wan_mask = 0;
	con_wan_info_T *pConWandata = NULL;
	lanHostInfo_t  LanNetInfo = {0};
	lanHostInfo_t *pLanNetInfo = NULL;
	unsigned char lan_mac[18] = {0};
	char LanDevName[64] = {0};
	int find_wan_flag = 0;
	char default_wan_itf[IFNAMSIZ] = {0};
	char global_balance_enable = 0, sta_enable = 0, dyn_enable = 0;
	int ret_1 = 0, ret_2 = 0;

	ret_1 = get_lan_net_info(&pLanNetInfo, &count);
	ret_2 = get_con_wan_info(&pConWandata,&wanCount);

	if(ret_1 != 0)
		goto get_info_end;
	
	if((!mib_get_s(MIB_STATIC_LOAD_BALANCE_ENABLE, (void *)&sta_enable,sizeof(sta_enable))) ||
		(!mib_get_s(MIB_GLOBAL_LOAD_BALANCE, (void *)&global_balance_enable,sizeof(global_balance_enable))) ||
		(!mib_get_s(MIB_DYNAMIC_LOAD_BALANCE, (void *)&dyn_enable,sizeof(dyn_enable))))
	{
		goto get_info_end;
	}

	rtk_get_default_gw_wan_from_route_table(default_wan_itf);
	
	nBytesSent +=boaWrite(wp, "&nbsp;&nbsp;\n"
	"<div class=\"column\">\n"
	"<div class=\"column_title\">\n"
	"<div class=\"column_title_left\"></div>\n"
	"<p>%s</p>\n"
	"<div class=\"column_title_right\"></div>\n"
	"</div>\n"
	"<div class=\"data_common data_vertical\">\n",multilang(LANG_ASSIGNMENT_TABLE));
	
	nBytesSent +=boaWrite(wp, "<table>\n");
	nBytesSent += boaWrite(wp, "<tr>"
	"<td align=center width=\"14%%\" bgcolor=\"#808080\" class=\"table_item\"><b>%s</b></td>\n"
	"<td align=center width=\"16%%\" bgcolor=\"#808080\" class=\"table_item\"><b>%s</b></td>\n"
	"<td align=center width=\"16%%\" bgcolor=\"#808080\" class=\"table_item\"><b>%s</b></td>\n"
	"<td align=center width=\"16%%\" bgcolor=\"#808080\" class=\"table_item\"><b>%s</b></td>\n"
	"<td align=center width=\"10%%\" bgcolor=\"#808080\" class=\"table_item\"><b>%s</b></td>\n"
	"<td align=center width=\"10%%\" bgcolor=\"#808080\" class=\"table_item\"><b>%s</b></td>\n"
	"<td align=center width=\"10%%\" bgcolor=\"#808080\" class=\"table_item\"><b>%s</b></td>\n"
	"<td align=center width=\"8%%\" bgcolor=\"#808080\" class=\"table_item\"><b>%s</b></td></tr>\n",
	multilang(LANG_WAN_INTERFACE),multilang(LANG_LOAD_BALANCE_DEV_NAME),multilang(LANG_MAC_ADDRESS),multilang(LANG_IP_ADDRESS), multilang(LANG_LAN_PORT), multilang(LANG_RX_PKT), multilang(LANG_TX_PKT),multilang(LANG_TYPE));

	sta_entry_num = mib_chain_total(MIB_STATIC_LOAD_BALANCE_TBL);
	if(count>0){
		for(i=0; i<count; i++)
		{
			find_wan_flag  = 0;
			memset(wanif,0,IFNAMSIZ);
			
			snprintf(lan_mac,sizeof(lan_mac),"%02x:%02x:%02x:%02x:%02x:%02x", pLanNetInfo[i].mac[0],pLanNetInfo[i].mac[1],pLanNetInfo[i].mac[2],pLanNetInfo[i].mac[3],pLanNetInfo[i].mac[4],pLanNetInfo[i].mac[5]);
			if(strlen(pLanNetInfo[i].devName)==0)
					snprintf(LanDevName, MAX_LANNET_DEV_NAME_LENGTH, "unknown");
				else
					snprintf(LanDevName, MAX_LANNET_DEV_NAME_LENGTH, "%s", pLanNetInfo[i].devName);

			if(sta_enable != 0 && global_balance_enable != 0)
			{
				//check munual load balance entry which could has the same mac. 
				for(j=0;j<sta_entry_num;j++)
				{
					if(!mib_chain_get(MIB_STATIC_LOAD_BALANCE_TBL, j, &sta_entry))
						continue;

					if(!strncasecmp(lan_mac,sta_entry.mac,MAC_ADDR_STRING_LEN-1))
					{
						nBytesSent += boaWrite(wp, "<tr>"
								"<td align=center width=\"14%%\" bgcolor=\"#C0C0C0\">%s</td>\n"
								"<td align=center width=\"16%%\" bgcolor=\"#C0C0C0\">%s</td>\n"
								"<td align=center width=\"16%%\" bgcolor=\"#C0C0C0\">%s</td>\n"
								"<td align=center width=\"16%%\" bgcolor=\"#C0C0C0\">%d.%d.%d.%d</td>\n"
								"<td align=center width=\"10%%\" bgcolor=\"#C0C0C0\">%d</td>\n"
								"<td align=center width=\"10%%\" bgcolor=\"#C0C0C0\">%d</td>\n"
								"<td align=center width=\"10%%\" bgcolor=\"#C0C0C0\">%d</td>\n"
								"<td align=center width=\"8%%\" bgcolor=\"#C0C0C0\">manual</td></tr>\n",
								sta_entry.wan_itfname, LanDevName, lan_mac,  pLanNetInfo[i].ip>>24, ( pLanNetInfo[i].ip>>16) & 0xff, ( pLanNetInfo[i].ip>>8) & 0xff, pLanNetInfo[i].ip & 0xff, pLanNetInfo[i].phy_port, pLanNetInfo[i].rx_packets, pLanNetInfo[i].tx_packets);
						find_wan_flag  = 1;
						break;
					}
				}
			}

			//find port mapping Lan pc info from port mapping when disable auto load balance or global load balance.
			if(find_wan_flag == 0)
			{
				if(rtk_check_port_mapping_rules_exist(pLanNetInfo[i].ifName, &wan_entry_idx, &wan_mark))
				{
					if(mib_chain_get(MIB_ATM_VC_TBL, wan_entry_idx, &entry)){
						ifGetName(entry.ifIndex, wanif, sizeof(wanif));
						nBytesSent += boaWrite(wp, "<tr>"
							"<td align=center width=\"14%%\" bgcolor=\"#C0C0C0\">%s</td>\n"
							"<td align=center width=\"16%%\" bgcolor=\"#C0C0C0\">%s</td>\n"
							"<td align=center width=\"16%%\" bgcolor=\"#C0C0C0\">%s</td>\n"
							"<td align=center width=\"16%%\" bgcolor=\"#C0C0C0\">%d.%d.%d.%d</td>\n"
							"<td align=center width=\"10%%\" bgcolor=\"#C0C0C0\">%d</td>\n"
							"<td align=center width=\"10%%\" bgcolor=\"#C0C0C0\">%d</td>\n"
							"<td align=center width=\"10%%\" bgcolor=\"#C0C0C0\">%d</td>\n"
							"<td align=center width=\"8%%\" bgcolor=\"#C0C0C0\">manual</td></tr>\n",
							wanif, LanDevName, lan_mac, pLanNetInfo[i].ip>>24, ( pLanNetInfo[i].ip>>16) & 0xff, ( pLanNetInfo[i].ip>>8) & 0xff, pLanNetInfo[i].ip & 0xff, pLanNetInfo[i].phy_port, pLanNetInfo[i].rx_packets, pLanNetInfo[i].tx_packets);
						find_wan_flag  = 1;
					}
				}
			}

			if(dyn_enable != 0 && global_balance_enable != 0)
			{
				//check auto load balance entry which could has the same mac. 
				if(wanCount > 0 && find_wan_flag == 0 && ret_2 == 0)
				{
					for(k=0;k<wanCount;k++)
					{
						if(pConWandata[k].wan_mark)
						{
							if(find_wan_flag == 1)
								break;
							
							if(rtk_get_wan_itf_by_mark(wanif,pConWandata[k].wan_mark)!=1)
							{
								//printf("this mark cant find wanitf name.\n");
								continue;
							}
							for(j=0; j<MAX_MAC_NUM; j++)
							{
								if(strlen(pConWandata[k].mac_info[j].mac_str))
								{
									if(!strncasecmp(lan_mac, pConWandata[k].mac_info[j].mac_str, MAC_ADDR_STRING_LEN-1))
									{
										nBytesSent += boaWrite(wp, "<tr>"
												"<td align=center width=\"14%%\" bgcolor=\"#C0C0C0\">%s</td>\n"
												"<td align=center width=\"16%%\" bgcolor=\"#C0C0C0\">%s</td>\n"
												"<td align=center width=\"16%%\" bgcolor=\"#C0C0C0\">%s</td>\n"
												"<td align=center width=\"16%%\" bgcolor=\"#C0C0C0\">%d.%d.%d.%d</td>\n"
												"<td align=center width=\"10%%\" bgcolor=\"#C0C0C0\">%d</td>\n"
												"<td align=center width=\"10%%\" bgcolor=\"#C0C0C0\">%d</td>\n"
												"<td align=center width=\"10%%\" bgcolor=\"#C0C0C0\">%d</td>\n"
												"<td align=center width=\"8%%\" bgcolor=\"#C0C0C0\">auto</td></tr>\n",
												wanif, LanDevName, lan_mac,  pLanNetInfo[i].ip>>24, ( pLanNetInfo[i].ip>>16) & 0xff, ( pLanNetInfo[i].ip>>8) & 0xff, pLanNetInfo[i].ip & 0xff, pLanNetInfo[i].phy_port, pLanNetInfo[i].rx_packets, pLanNetInfo[i].tx_packets);
										find_wan_flag  = 1;
										break;
									}
								}
							}
						}
					}
				}
			}

			if(find_wan_flag == 0){
				//lan dev<-->default wan
				nBytesSent += boaWrite(wp, "<tr>"
						"<td align=center width=\"14%%\" bgcolor=\"#C0C0C0\">%s</td>\n"
						"<td align=center width=\"16%%\" bgcolor=\"#C0C0C0\">%s</td>\n"
						"<td align=center width=\"16%%\" bgcolor=\"#C0C0C0\">%s</td>\n"
						"<td align=center width=\"16%%\" bgcolor=\"#C0C0C0\">%d.%d.%d.%d</td>\n"
						"<td align=center width=\"10%%\" bgcolor=\"#C0C0C0\">%d</td>\n"
						"<td align=center width=\"10%%\" bgcolor=\"#C0C0C0\">%d</td>\n"
						"<td align=center width=\"10%%\" bgcolor=\"#C0C0C0\">%d</td>\n"
						"<td align=center width=\"8%%\" bgcolor=\"#C0C0C0\">default</td></tr>\n",
						default_wan_itf, LanDevName, lan_mac,  pLanNetInfo[i].ip>>24, ( pLanNetInfo[i].ip>>16) & 0xff, ( pLanNetInfo[i].ip>>8) & 0xff, pLanNetInfo[i].ip & 0xff, pLanNetInfo[i].phy_port, pLanNetInfo[i].rx_packets, pLanNetInfo[i].tx_packets);
			}
		}	
	}
	nBytesSent +=boaWrite(wp, "</table>\n"
	"</div>\n"
	"</div>\n");
	
get_info_end:
	if(pLanNetInfo)
		free(pLanNetInfo);
		
	if(pConWandata)
		free(pConWandata);
	
	return nBytesSent;
}

int wan_stats_show(int eid, request * wp, int argc, char **argv)
{
	int nBytesSent = 0,i = 0,j = 0;
	int entry_num = 0;
	MIB_CE_ATM_VC_T entry;
	char wanif[IFNAMSIZ] = {0};
	int wan_phy_port = 0;
	lan_net_port_speed_T ps[MAX_PORT_NUM] = {0};
	unsigned int up_speed = 0;
	unsigned int down_speed = 0;
	struct net_device_stats nds;
	char tmpBuf[32] = {0};
	char default_wan_itf[IFNAMSIZ]= {0};
	float total_rx_rate = 0;
	float total_tx_rate = 0;
	unsigned long long total_rx_pkt = 0;
	unsigned long long total_tx_pkt = 0;
	char total_port[12] = {0};
	int logic_port_array[MAX_TOTAL_LOGIC_PORT_NUM] = {-1,-1,-1,-1,-1,-1};
	int find_same_logic_port = 0, total_num = 0;
	char tmpbuf[6] = {0};
	char connect_status[16] = {0};

	entry_num = mib_chain_total(MIB_ATM_VC_TBL);

	if(get_lanNetInfo_portSpeed(ps, MAX_PORT_NUM)==RTK_FAILED)
		return nBytesSent;

	nBytesSent +=boaWrite(wp, "<div class=\"column\">\n"
	"<div class=\"column_title\">\n"
	"<div class=\"column_title_left\"></div>\n"
	"<p>%s</p>\n"
	"<div class=\"column_title_right\"></div>\n"
	"</div>\n"
	"<div class=\"data_common data_vertical\">\n",multilang(LANG_WAN_STATS_TABLE));

	nBytesSent +=boaWrite(wp, "<table>\n");
	nBytesSent += boaWrite(wp, "<tr>"
	"<td align=center width=\"14%%\"><b>%s</b></td>\n"
	"<td align=center width=\"16%%\"><b>%s</b></td>\n"
	"<td align=center width=\"16%%\"><b>Rx Rate(Mbps)</b></td>\n"
	"<td align=center width=\"16%%\"><b>Tx Rate(Mbps)</b></td>\n"
	"<td align=center width=\"14%%\"><b>%s</b></td>\n"
	"<td align=center width=\"14%%\"><b>%s</b></td>\n"
	"<td align=center width=\"10%%\"><b>%s</b></td></tr>\n",
	multilang(LANG_WAN_INTERFACE),multilang(LANG_WAN_PORT), multilang(LANG_RX_PKT), multilang(LANG_TX_PKT), multilang(LANG_STATUS));

	rtk_get_default_gw_wan_from_route_table(default_wan_itf);
	
	for(i=0; i<entry_num; i++)
	{
		
		if(!mib_chain_get(MIB_ATM_VC_TBL, i, &entry))
			continue;

		ifGetName(entry.ifIndex, wanif, sizeof(wanif));
		
		if(!strncmp(wanif,default_wan_itf,IFNAMSIZ))
		{
			snprintf(tmpBuf, sizeof(tmpBuf), "%s(default)", wanif);
		}
		else
		{
			snprintf(tmpBuf, sizeof(tmpBuf), "%s", wanif);
		}
		wan_phy_port = rtk_port_get_phyport_by_ifname(wanif);
		if(wan_phy_port==-1){
			printf("%s %d find %s phy port fail\n",__FUNCTION__,__LINE__,wanif);
			continue;
		}

		for(j=0; j< MAX_PORT_NUM; j++)
		{
			if(wan_phy_port == ps[j].portNum)
			{
				up_speed = ps[j].txRate;
				down_speed = ps[j].rxRate;
				break;
			}
		}

		get_net_device_stats(wanif, &nds);

		if(rtk_check_wan_is_connected(&entry))
			snprintf(connect_status, sizeof(connect_status), "connected");
		else
			snprintf(connect_status, sizeof(connect_status), "disconnected");

		nBytesSent += boaWrite(wp, "<tr>"
		"<td align=center width=\"14%%\">%s</td>\n"
		"<td align=center width=\"16%%\">%d</td>\n"
		"<td align=center width=\"16%%\">%.3f</td>\n"
		"<td align=center width=\"16%%\">%.3f</td>\n"
		"<td align=center width=\"14%%\">%lld</td>\n"
		"<td align=center width=\"14%%\">%lld</td>\n"
		"<td align=center width=\"10%%\">%s</td></tr>\n",
		tmpBuf,entry.logic_port,(float)down_speed*8/1000000, (float)up_speed*8/1000000, nds.rx_packets, nds.tx_packets, connect_status);

		total_rx_rate += (float)down_speed*8/1000000;
		total_tx_rate += (float)up_speed*8/1000000;
		total_rx_pkt += nds.rx_packets;
		total_tx_pkt += nds.tx_packets;

		if(i < MAX_TOTAL_LOGIC_PORT_NUM){
			logic_port_array[i] = entry.logic_port;
			total_num++;
		}
	}

	for(j=0; j<6; j++)
	{
		if(logic_port_array[j] >= 0){
			if(total_num==1)
			{
				snprintf(total_port,12,"%d",logic_port_array[j]);
				break;
			}
			else{
				if(j==total_num-1){
					snprintf(tmpbuf,6,"%d",logic_port_array[j]);
				}
				else{
					snprintf(tmpbuf,6,"%d/",logic_port_array[j]);
				}
				strncat(total_port,tmpbuf,sizeof(total_port));
			}
		}
	}
	nBytesSent += boaWrite(wp, "<tr>"
		"<td align=center width=\"14%%\">Total</td>\n"
		"<td align=center width=\"16%%\">%s</td>\n"
		"<td align=center width=\"16%%\">%.3f</td>\n"
		"<td align=center width=\"16%%\">%.3f</td>\n"
		"<td align=center width=\"14%%\">%lld</td>\n"
		"<td align=center width=\"14%%\">%lld</td>\n"
		"<td align=center width=\"10%%\">N/A</td></tr>\n",
		total_port,total_rx_rate, total_tx_rate, total_rx_pkt, total_tx_pkt);

	nBytesSent +=boaWrite(wp, "</table>\n"
	"</div>\n"
	"</div>\n");
	
	return nBytesSent;
}
#endif
#endif
