/*
 *      Web server handler routines for DNS stuffs
 *
 */


/*-- System inlcude files --*/
#include <string.h>
#include <net/if.h>
#include <sys/ioctl.h>
#include <sys/time.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <sys/socket.h>
#include <net/route.h>

/*-- Local inlcude files --*/
#include "../webs.h"
#include "webform.h"
#include "mib.h"

void formSchedule(request * wp, char *path, char *query)
{
	char *str, *submitUrl;
	char *name, *starttime, *endtime, *weekday, *mod;
	char weekdays[32];
	char tmpBuf[100];
	char vChar;
	unsigned int totalEntry;
	MIB_CE_TIME_SCHEDULE_T Entry;
	MIB_CE_TIME_SCHEDULE_T pEntry;
	int i, selected=-1;
	int intVal, modIndex;

#ifdef CONFIG_TM_FEATURE
	extern unsigned char schedule_now;
	schedule_now = 1;
#endif
	str = boaGetVar(wp, "addschedule", "");
	if(str[0]){
		//submit to add schedule
		mod = boaGetVar(wp, "sched_mod", "");
		if(!mod[0]){
			strcpy(tmpBuf, "Get ERROR!");
			goto setErr_Schedule;
		}

		modIndex = mod[0]-'0';
		
		name = boaGetVar(wp, "name_sched", "");
		if(!name[0]){
			strcpy(tmpBuf, "Get Name ERROR!");
			goto setErr_Schedule;
		}

		starttime = boaGetVar(wp, "time_schedstart", "");
		if(!starttime[0]){
			strcpy(tmpBuf, "Get starttime ERROR!");
			goto setErr_Schedule;
		}

		endtime = boaGetVar(wp, "time_schedend", "");
		if(!endtime[0]){
			strcpy(tmpBuf, "Get endtime ERROR!");
			goto setErr_Schedule;
		}

		weekday = boaGetVar(wp, "weekdays_sched", "");
		if(!weekday[0]){
			strcpy(tmpBuf, "Get weekdays ERROR!");
			goto setErr_Schedule;
		}

		memset(&Entry, 0x00, sizeof(Entry));
		strcpy(Entry.name, name);
		strcpy(Entry.weekdays, weekday);
		strcpy(Entry.timestart, starttime);
		strcpy(Entry.timestop, endtime);

		totalEntry = mib_chain_total(MIB_TIME_SCHEDULE_TBL); /* get chain record size */
		
		if(modIndex != 0)
		{
			//modify, not add
			for (i=0; i<totalEntry; i++)
			{
				if (!mib_chain_get(MIB_TIME_SCHEDULE_TBL, i, (void *)&pEntry))
				{
					strcpy(tmpBuf, strGetChainerror);
					goto setErr_Schedule;
				}
				if((strcmp(Entry.name, pEntry.name)==0) && (i != modIndex-1))
				{
					strcpy(tmpBuf, "Schedule Name aleady exist!!");
					goto setErr_Schedule;
				}
			}
			if(!mib_chain_update( MIB_TIME_SCHEDULE_TBL, (void*)&Entry, modIndex-1))
			{
				strcpy(tmpBuf, "update error!!");
				goto setErr_Schedule;
			}
			else
			{
				//update ok!
				goto setOk;
			}
		}
		

		//duplicate check
		for (i=0; i<totalEntry; i++) {
			if (!mib_chain_get(MIB_TIME_SCHEDULE_TBL, i, (void *)&pEntry))
			{
				strcpy(tmpBuf, strGetChainerror);
				goto setErr_Schedule;
			}
			if((strcmp(Entry.name, pEntry.name)==0))
			{
				strcpy(tmpBuf, "Schedule Name aleady exist!!");
				goto setErr_Schedule;
			}
			if((strcmp(Entry.weekdays, pEntry.weekdays)==0) 
				&&(strcmp(Entry.timestart, pEntry.timestart)==0) 
				&&(strcmp(Entry.timestop, pEntry.timestop)==0) )
			{
				strcpy(tmpBuf, "Schedule Rule aleady exist!!");
				goto setErr_Schedule;
			}
		}

		intVal = mib_chain_add(MIB_TIME_SCHEDULE_TBL, (void *)&Entry);
		if (intVal == 0) {
			strcpy(tmpBuf, strAddChainerror);
			goto setErr_Schedule;
		}
		else if (intVal == -1) {
			strcpy(tmpBuf, strTableFull);
			goto setErr_Schedule;
		}

	}

setOk:

// Magician: Commit immediately
#ifdef COMMIT_IMMEDIATELY
	Commit();
#endif

	if(modIndex != 0)
	{
		restart_urlblocking();
		setupMacFilter();
	}
	
	submitUrl = boaGetVar(wp, "submit-url", "");
	//printf("redirectUrl:%s\n", submitUrl);

	if (submitUrl[0])
		boaRedirect(wp, submitUrl);
	else
		boaDone(wp, 200);
 	return;

setErr_Schedule:
setErr_dns:
	ERR_MSG(tmpBuf);
}

void formSchedList(request * wp, char *path, char *query)
{
	char *strVal, *submitUrl;
	unsigned int totalEntry;
	MIB_CE_URL_FQDN_T urlEntry;
	MIB_CE_KEYWD_FILTER_T keyEntry;
	MIB_CE_MAC_FILTER_T macEntry;
	int i, selected=-1;
	int intVal;
	int action, index;
	int mac_index=-1, url_index=-1;

	//printf("Enter formSchedList\n");

	strVal = boaGetVar(wp, "action", "");
	if (strVal[0]) {
		action = strVal[0]-'0';
		strVal = boaGetVar(wp, "idx", "");
		index = strVal[0]-'0';

		//printf("action:%d index:%d\n", action, index);
		if (action == 0) 
		{ 	// delete schedule may effect mac-filter & url-filter
			mib_chain_delete(MIB_TIME_SCHEDULE_TBL, index);

			totalEntry = mib_chain_total(MIB_URL_FQDN_TBL);
			for (i=totalEntry-1 ; i>=0; i--)
			{
				if (mib_chain_get(MIB_URL_FQDN_TBL, i, (void *)&urlEntry))
				{
					if(urlEntry.schedIndex == index+1)
						mib_chain_delete(MIB_URL_FQDN_TBL, i);
					else if(urlEntry.schedIndex > index+1)
					{
						urlEntry.schedIndex--;
						mib_chain_update(MIB_URL_FQDN_TBL, (void *)&urlEntry, i);
					}
				}
			}

			totalEntry = mib_chain_total(MIB_KEYWD_FILTER_TBL);
			for (i=totalEntry-1 ; i>=0; i--)
			{
				if (mib_chain_get(MIB_KEYWD_FILTER_TBL, i, (void *)&keyEntry))
				{
					if(keyEntry.schedIndex == index+1)
						mib_chain_delete(MIB_KEYWD_FILTER_TBL, i);
					else if(keyEntry.schedIndex > index+1)
					{
						keyEntry.schedIndex--;
						mib_chain_update(MIB_KEYWD_FILTER_TBL, (void *)&keyEntry, i);
					}
				}
			}

			totalEntry = mib_chain_total(MIB_MAC_FILTER_TBL);
			for (i=totalEntry-1 ; i>=0; i--)
			{
				if (mib_chain_get(MIB_MAC_FILTER_TBL, i, (void *)&macEntry))
				{
					if(macEntry.schedIndex == index+1)
						mib_chain_delete(MIB_MAC_FILTER_TBL, i);
					else if(macEntry.schedIndex > index+1)
					{
						macEntry.schedIndex--;
						mib_chain_update(MIB_MAC_FILTER_TBL, (void *)&macEntry, i);
					}
				}
			}
			
		}
	}

#ifdef COMMIT_IMMEDIATELY
	Commit();
#endif

	if (action == 0) 
	{
		restart_urlblocking();
		setupMacFilter();
	}
	submitUrl = boaGetVar(wp, "redirect-url", "");   // hidden page
	//printf("redirectUrl:%s\n", submitUrl);
	if (submitUrl[0])
		boaRedirect(wp, submitUrl);
	else
		boaDone(wp, 200);
  	return;
	
}

void schedTableList(int eid, request * wp, int argc, char **argv)
{
	char *str, *submitUrl;
	char *name, *starttime, *endtime, *weekday;
	char weekdays[10];
	char vChar;
	unsigned int totalEntry;
	MIB_CE_TIME_SCHEDULE_T Entry;
	MIB_CE_TIME_SCHEDULE_T pEntry;
	int i, j;
	int intVal;

	//
	totalEntry = mib_chain_total(MIB_TIME_SCHEDULE_TBL); /* get chain record size */

	//printf("[%s %d]totalEntry:%d\n", __func__, __LINE__, totalEntry);
	//duplicate check
	for (i=0; i<totalEntry; i++) {
		if (mib_chain_get(MIB_TIME_SCHEDULE_TBL, i, (void *)&pEntry))
		{
			//printf("[%s %d]name:%s, week:%s, time%s - %s\n", __func__, __LINE__, pEntry.name, pEntry.weekdays, pEntry.timestart, pEntry.timestop);
			for (j=0; j<10; j++) 
			{
				weekdays[j] = ' ';
			}
			if(strstr(pEntry.weekdays, "Sun"))
				weekdays[0] = '*';
			if(strstr(pEntry.weekdays, "Mon"))
				weekdays[1] = '*';
			if(strstr(pEntry.weekdays, "Tue"))
				weekdays[2] = '*';
			if(strstr(pEntry.weekdays, "Wed"))
				weekdays[3] = '*';
			if(strstr(pEntry.weekdays, "Thu"))
				weekdays[4] = '*';
			if(strstr(pEntry.weekdays, "Fri"))
				weekdays[5] = '*';
			if(strstr(pEntry.weekdays, "Sat"))
				weekdays[6] = '*';
			if(strstr(pEntry.weekdays, "all"))
			{
				for (j=0; j<7; j++) 
				{
					weekdays[j] = '*';
				}
			}
			boaWrite(wp, "<tr><td>%s</td><td>%c</td><td>%c</td><td>%c</td><td>%c</td><td>%c</td>"
				"<td>%c</td><td>%c</td><td>%s</td><td>%s</td>",
				pEntry.name, weekdays[0], weekdays[1], weekdays[2], weekdays[3], weekdays[4],
				weekdays[5], weekdays[6], pEntry.timestart, pEntry.timestop);
			boaWrite(wp,
				"<td><a href=\"#\" onClick=\"editShedClick(%d)\">"
				"<image border=0 src=\"graphics/edit.gif\" alt=\"Post for editing\" /></a></td>", i);

				boaWrite(wp,
				"<td><a href=\"#\" onClick=\"delClick(%d)\">"
				"<image border=0 src=\"graphics/del.gif\" alt=Delete /></a></td></tr>\n", i);
		}
		
	}
}

void schedList_select(int eid, request * wp, int argc, char **argv)
{
	char *str, *submitUrl;
	char *name, *starttime, *endtime, *weekday;
	char weekdays[10];
	char vChar;
	unsigned int totalEntry;
	MIB_CE_TIME_SCHEDULE_T pEntry;
	int i, j;
	int intVal;

	boaWrite(wp,"\t<option value=0 selected=\"selected\">Always</option>\n");

	totalEntry = mib_chain_total(MIB_TIME_SCHEDULE_TBL); /* get chain record size */

	//printf("[%s %d]totalEntry:%d\n", __func__, __LINE__, totalEntry);
	for (i=0; i<totalEntry; i++) {
		if (mib_chain_get(MIB_TIME_SCHEDULE_TBL, i, (void *)&pEntry))
		{
			//printf("[%s %d]name:%s, week:%s, time%s - %s\n", __func__, __LINE__, pEntry.name, pEntry.weekdays, pEntry.timestart, pEntry.timestop);

			boaWrite(wp,"\t<option value=%d>%s</option>\n", i+1, pEntry.name);
		}
	}
	//boaWrite(wp,"\t<option value=%d>Never</option>\n", totalEntry+1);
}
