/*
 *      Web server handler routines for System IPv6 status
 *
 */

#include <string.h>
#include "../webs.h"
#include "webform.h"
#include "mib.h"
#include "utility.h"
#include "debug.h"
#include "multilang.h"

#ifdef CONFIG_IPV6
void formStatus_ipv6(request * wp, char *path, char *query)
{
	char *submitUrl;

	submitUrl = boaGetVar(wp, "submit-url", "");
	if (submitUrl[0])
		boaRedirect(wp, submitUrl);
	else
		boaDone(wp, 200);
  	return;
}

int wanip6ConfList(int eid, request * wp, int argc, char **argv)
{
	int nBytesSent=0;
	int in_turn=0, ifcount=0;
	int i, j, k;
	struct ipv6_ifaddr ip6_addr[6];
	char buf[256], str_ip6[INET6_ADDRSTRLEN];
	struct wstatus_info sEntry[MAX_VC_NUM+MAX_PPP_NUM];

	ifcount = getWanStatus(sEntry, MAX_VC_NUM+MAX_PPP_NUM);
#ifndef CONFIG_GENERAL_WEB
	nBytesSent += boaWrite(wp, "<tr bgcolor=\"#808080\">"
	"<td width=\"8%%\" align=center><font size=2><b>%s</b></font></td>\n"
	"<td width=\"12%%\" align=center><font size=2><b>%s</b></font></td>\n"
	"<td width=\"12%%\" align=center><font size=2><b>%s</b></font></td>\n"
	"<td width=\"12%%\" align=center><font size=2><b>%s</b></font></td>\n"
	"<td width=\"22%%\" align=center><font size=2><b>%s</b></font></td>\n"
	"<td width=\"12%%\" align=center><font size=2><b>%s</b></font></td></tr>\n",
#else
	nBytesSent += boaWrite(wp, "<tr>"
	"<th width=\"8%%\">%s</th>\n"
	"<th width=\"12%%\">%s</th>\n"
	"<th width=\"12%%\">%s</th>\n"
	"<th width=\"12%%\">%s</th>\n"
	"<th width=\"22%%\">%s</th>\n"
	"<th width=\"12%%\">%s</th></tr>\n",
#endif
	multilang(LANG_INTERFACE), 
#if defined(CONFIG_LUNA)
	multilang(LANG_VLAN_ID), multilang(LANG_CONNECTION_TYPE),
#else
	multilang(LANG_VPI_VCI), multilang(LANG_ENCAPSULATION),
#endif
	multilang(LANG_PROTOCOL), multilang(LANG_IP_ADDRESS), multilang(LANG_STATUS));
	in_turn = 0;
	for (i=0; i<ifcount; i++) {
		if (sEntry[i].cmode == CHANNEL_MODE_BRIDGE || (sEntry[i].ipver == IPVER_IPV4))
			continue; // not IPv6 capable
#ifndef CONFIG_GENERAL_WEB
		if (in_turn == 0)
			nBytesSent += boaWrite(wp, "<tr bgcolor=\"#EEEEEE\">\n");
		else
			nBytesSent += boaWrite(wp, "<tr bgcolor=\"#DDDDDD\">\n");
#else
		if (in_turn == 0)
			nBytesSent += boaWrite(wp, "<tr>\n");
#endif

		in_turn ^= 0x01;
		k=getifip6(sEntry[i].ifname, IPV6_ADDR_UNICAST, ip6_addr, 6);
		buf[0]=0;
		if (k) {
			for (j=0; j<k; j++) {
				inet_ntop(PF_INET6, &ip6_addr[j].addr, str_ip6, INET6_ADDRSTRLEN);
				if (j == 0)
#ifdef CONFIG_00R0 //for rostelecom is mask bit not prefix len
					sprintf(buf, "%s/%d", str_ip6, 128);
#else
					sprintf(buf, "%s/%d", str_ip6, ip6_addr[j].prefix_len);
#endif
				else
#ifdef CONFIG_00R0
					sprintf(buf + strlen(buf), ", %s/%d", str_ip6, 128);
#else
					sprintf(buf + strlen(buf), ", %s/%d", str_ip6, ip6_addr[j].prefix_len);
#endif
			}
		}
		nBytesSent += boaWrite(wp,
#ifndef CONFIG_GENERAL_WEB
		"<td align=center width=\"5%%\"><font size=2>%s</td>\n"
#if defined(CONFIG_LUNA)
		"<td align=center width=\"1%%\"><font size=2>%d</td>\n"
		"<td align=center width=\"9%%\"><font size=2>%s</td>\n"
#else
		"<td align=center width=\"5%%\"><font size=2>%s</td>\n"
		"<td align=center width=\"5%%\"><font size=2>%s</td>\n"
#endif
		"<td align=center width=\"5%%\"><font size=2>%s</td>\n"
		"<td align=center width=\"10%%\"><font size=2>%s</td>\n"
		"<td align=center width=\"23%%\"><font size=2>%s\n",
#else	//CONFIG_GENERAL_WEB
		"<td width=\"5%%\">%s</th>\n"
#if defined(CONFIG_LUNA)
		"<td width=\"1%%\">%d</th>\n"
		"<td width=\"9%%\">%s</th>\n"
#else
		"<td width=\"5%%\">%s</th>\n"
		"<td width=\"5%%\">%s</th>\n"
#endif
		"<td width=\"5%%\">%s</th>\n"
		"<td width=\"10%%\">%s</th>\n"
		"<td width=\"23%%\">%s\n",
#endif	//CONFIG_GENERAL_WEB
		sEntry[i].ifDisplayName, 
#if defined(CONFIG_LUNA)
		sEntry[i].vid, sEntry[i].serviceType,
#else
		sEntry[i].vpivci, sEntry[i].encaps,
#endif
		sEntry[i].protocol, buf, sEntry[i].strStatus_IPv6);
		nBytesSent += boaWrite(wp, "</td></tr>\n");
	}
	return nBytesSent;
}

int routeip6ConfList(int eid, request * wp, int argc, char **argv){
	FILE *fp = NULL;
	int nBytesSent = 0;
	char tmp_cmd[16] = {0};
	char route_line[256], tmp_line[256], dest_ip[64], gw_ip[64];
	char *ret=NULL,*via=NULL,*dev=NULL,*metric=NULL; 
	
#ifndef CONFIG_GENERAL_WEB
	nBytesSent += boaWrite(wp, "<tr bgcolor=\"#808080\">"
	"<td width=\"12%%\" align=center><font size=2><b>%s IP</b></font></td>\n"
	"<td width=\"12%%\" align=center><font size=2><b>%s</b></font></td>\n"
	"<td width=\"8%%\" align=center><font size=2><b>%s</b></font></td>\n"
	"<td width=\"8%%\" align=center><font size=2><b>%s</b></font></td></tr>\n",
#else
	nBytesSent += boaWrite(wp, "<tr>"
	"<th width=\"12%%\">%s IP</th>\n"
	"<th width=\"12%%\">%s</th>\n"
	"<th width=\"8%%\">%s</th>\n"
	"<th width=\"8%%\">%s</th></tr>\n",
#endif
	multilang(LANG_DESTINATION), multilang(LANG_GATEWAY), 
	multilang(LANG_METRIC), multilang(LANG_INTERFACE));

	snprintf(tmp_cmd,sizeof(tmp_cmd),"ip -6 route");
	if((fp = popen(tmp_cmd,"r")) != NULL){
		while(fgets(route_line,sizeof(route_line),fp)){
			route_line[strlen(route_line)-1] = '\0';
			
			memset(dest_ip,0,sizeof(dest_ip));
			snprintf(dest_ip,sizeof(dest_ip),route_line);
			ret=strstr(dest_ip," ");
			*ret='\0';//dest_ip is OK
			
			ret++;
			memset(gw_ip,0,sizeof(gw_ip));
			if(via=strstr(ret,"via")){
				via+=4;
				ret=strstr(via," ");
				*ret='\0';
				snprintf(gw_ip,sizeof(gw_ip),via);
			}
			else
				snprintf(gw_ip,sizeof(gw_ip),"::");//gateway is OK

			memset(tmp_line,0,sizeof(tmp_line));
			snprintf(tmp_line,sizeof(tmp_line),route_line);

			dev=strstr(tmp_line,"dev");
			metric=strstr(tmp_line,"metric");
			
			dev += 4;
			ret=strstr(dev," ");
			*ret='\0';//dev is OK

			metric += 7;
			ret=strstr(metric," ");//metric is OK
			*ret='\0';

			nBytesSent += boaWrite(wp,
#ifndef CONFIG_GENERAL_WEB
			"<td align=center width=\"12%%\"><font size=2>%s</td>\n"
			"<td align=center width=\"12%%\"><font size=2>%s</td>\n"
			"<td align=center width=\"8%%\"><font size=2>%s</td>\n"
			"<td align=center width=\"8%%\"><font size=2>%s</td>\n",
#else
			"<td width=\"12%%\">%s</td>\n"
			"<td width=\"12%%\">%s</td>\n"
			"<td width=\"8%%\">%s</td>\n"
			"<td width=\"8%%\">%s</td>\n",
#endif
			dest_ip, gw_ip, metric, dev);
			nBytesSent += boaWrite(wp, "</tr>\n");
		}
		fclose(fp);
	}
	else
		printf("ip -6 route fail!\n");
	return nBytesSent;
}

int dsliteConfList(int eid, request * wp, int argc, char **argv){
	MIB_CE_ATM_VC_T Entry;
	unsigned int entry_Num;
	char ifname[IFNAMSIZ];
	DLG_INFO_T tempInfo = {0};
	char inf[IFNAMSIZ];
	char leasefile[64] = {0};
	char dslite_dhcpv6_option[16];
	int in_turn, ifcount=0;
	int totalNum, nBytesSent=0;
	int i;

	entry_Num = mib_chain_total(MIB_ATM_VC_TBL);
#ifndef CONFIG_GENERAL_WEB
	nBytesSent += boaWrite(wp, "<tr bgcolor=\"#808080\">"
	"<td width=\"12%%\" align=center><font size=2><b>%s</b></font></td>\n"
	"<td width=\"12%%\" align=center><font size=2><b>%s</b></font></td>\n"
	"<td width=\"12%%\" align=center><font size=2><b>%s</b></font></td>\n"
	"<td width=\"22%%\" align=center><font size=2><b>%s</b></font></td></tr>\n",
#else
	nBytesSent += boaWrite(wp, "<tr>"
	"<th width=\"12%%\">%s</th>\n"
	"<th width=\"12%%\">%s</th>\n"
	"<th width=\"12%%\">%s</th>\n"
	"<th width=\"22%%\">%s</th></tr>\n",
#endif
	multilang(LANG_INTERFACE), multilang(LANG_AFTR_NAME), multilang(LANG_AFTR_ADDRESS), multilang(LANG_DS_LITE_DHCPV6_OPTION));
	in_turn = 0;
	for (i=0; i<entry_Num; i++) {		
		if(!mib_chain_get(MIB_ATM_VC_TBL, i, (void*)&Entry)){
			printf("get chain failed,id=%d,recordNum=%d,%s:%d\n",MIB_ATM_VC_TBL,i,__func__,__LINE__);
			continue;
		}
		if (Entry.cmode == CHANNEL_MODE_BRIDGE || (Entry.IpProtocol != IPVER_IPV6))
			continue;
		//ifGetName(Entry.ifIndex, ifname, sizeof(ifname));
		getDisplayWanName(&Entry, ifname);
		if(Entry.dslite_enable){
#ifndef CONFIG_GENERAL_WEB
			if (in_turn == 0)
				nBytesSent += boaWrite(wp, "<tr bgcolor=\"#EEEEEE\">\n");
			else
				nBytesSent += boaWrite(wp, "<tr bgcolor=\"#DDDDDD\">\n");
#else
			if (in_turn == 0)
				nBytesSent += boaWrite(wp, "<tr>\n");
#endif
			
			memset(dslite_dhcpv6_option, 0, sizeof(dslite_dhcpv6_option));
			if(0==Entry.dslite_aftr_mode){
				snprintf(dslite_dhcpv6_option, sizeof(dslite_dhcpv6_option), "%s", "enable");

				ifGetName(Entry.ifIndex, inf, sizeof(inf));
				snprintf(leasefile, sizeof(leasefile), "%s.%s", (char *)PATH_DHCLIENT6_LEASE, inf);
				if (getLeasesInfo(leasefile, &tempInfo) && LEASE_GET_AFTR==0)
					snprintf(tempInfo.dslite_aftr, sizeof(tempInfo.dslite_aftr),"%s","");
			}	
			else{
				snprintf(tempInfo.dslite_aftr, sizeof(tempInfo.dslite_aftr),"%s","");
				snprintf(dslite_dhcpv6_option, sizeof(dslite_dhcpv6_option), "%s", "disable");
			}
				
			//printf("[%s:%d]interfacenname=%s,ip=%s,option=%s\n",__func__,__LINE__,sEntry[i].ifDisplayName, Entry.dslite_aftr_hostname, dslite_dhcpv6_option);
			in_turn ^= 0x01;
			nBytesSent += boaWrite(wp,
#ifndef CONFIG_GENERAL_WEB
			"<td align=center width=\"2%%\"><font size=2>%s</td>\n"
			"<td align=center width=\"23%%\"><font size=2>%s</td>\n"
			"<td align=center width=\"23%%\"><font size=2>%s</td>\n"
			"<td align=center width=\"23%%\"><font size=2>%s</td>\n",
#else	//CONFIG_GENERAL_WEB
			"<td width=\"2%%\">%s</td>\n"
			"<td width=\"23%%\">%s</td>\n"
			"<td width=\"23%%\">%s</td>\n"
			"<td width=\"2%%\">%s</td>\n",
#endif	//CONFIG_GENERAL_WEB
			ifname, tempInfo.dslite_aftr, strValToASP(Entry.dslite_aftr_hostname), dslite_dhcpv6_option);
			nBytesSent += boaWrite(wp, "</tr>\n");

		}

	}
}

#endif //#ifdef CONFIG_IPV6
