/*-- System inlcude files --*/
#include <string.h>
#include <signal.h>
/*-- Local inlcude files --*/
#include "../webs.h"
#include "webform.h"
#include "mib.h"
#include "utility.h"

#ifdef CONFIG_USER_MINIUPNPD
void formUpnp(request * wp, char *path, char *query)
{
	char *str_enb, *str_extif, *submitUrl;
#ifdef CONFIG_TR_064
	char *tr064_en;
	unsigned char is_tr064_en, is_tr064_changed = 0;
#endif
	char tmpBuf[100]= {0};
	char ifname[IFNAMSIZ];
#ifndef NO_ACTION
	int pid;
#endif
	unsigned char is_enabled, pre_enabled;
	unsigned int ext_if, pre_ext_if;
#ifdef EMBED
	unsigned char if_num;
	int igmp_pid;
#endif

#ifdef CONFIG_TR_064
	tr064_en = boaGetVar(wp, "tr_064_sw", "");

	if(tr064_en[0])
	{
		is_tr064_en = tr064_en[0] - '0';

		if(is_tr064_en != TR064_STATUS)
		{
			if(!mib_set(MIB_TR064_ENABLED, (void *)&is_tr064_en))
			{
				sprintf(tmpBuf, "%s:%s", Tset_mib_error, MIB_TR064_ENABLED);
				goto setErr_igmp;
			}

			is_tr064_changed = 1;
		}
	}
#endif

	str_enb = boaGetVar(wp, "daemon", "");
	str_extif = boaGetVar(wp, "ext_if", "");

	if(str_enb[0])
	{
		is_enabled = str_enb[0] - '0';

		if(str_extif[0])
			ext_if = (unsigned int)atoi(str_extif);
		else
			ext_if = DUMMY_IFINDEX;  // No interface selected.

		mib_get_s(MIB_UPNP_DAEMON, (void *)&pre_enabled, sizeof(pre_enabled));
		mib_get_s(MIB_UPNP_EXT_ITF, (void *)&pre_ext_if, sizeof(pre_ext_if));

		if (is_enabled != pre_enabled || (ext_if != pre_ext_if)
#ifdef CONFIG_TR_064
			|| is_tr064_changed
#endif
				) {
			if (is_enabled != pre_enabled)
				mib_set(MIB_UPNP_DAEMON, (void *)&is_enabled);
			if (ext_if != pre_ext_if)
				mib_set(MIB_UPNP_EXT_ITF, (void *)&ext_if);
			restart_upnp(CONFIGALL, 0, 0, 0);
		}
// Magician: Commit immediately
#ifdef COMMIT_IMMEDIATELY
		Commit();
#endif
	}

#ifndef NO_ACTION
	pid = fork();
	if (pid)
		waitpid(pid, NULL, 0);
	else if (pid == 0)
	{
		snprintf(tmpBuf, 100, "%s/%s", _CONFIG_SCRIPT_PATH, _CONFIG_SCRIPT_PROG);
#ifdef HOME_GATEWAY
		execl( tmpBuf, _CONFIG_SCRIPT_PROG, "gw", "bridge", NULL);
#else
		execl( tmpBuf, _CONFIG_SCRIPT_PROG, "ap", "bridge", NULL);
#endif
		exit(1);
	}
#endif

	submitUrl = boaGetVar(wp, "submit-url", "");
	str_enb = boaGetVar(wp, "refresh", "");
	if (str_enb[0]) /* refresh */
		boaRedirect(wp, submitUrl);
	else
		OK_MSG(submitUrl);
	return;

#ifdef CONFIG_TR_064
setErr_igmp:
	ERR_MSG(tmpBuf);
#endif
}

int upnpPortFwList(int eid, request * wp, int argc, char **argv)
{
	int nBytesSent=0;
	unsigned int entryNum, i;
	MIB_CE_PORT_FW_T Entry;
	char	*type, portRange[20], *ip, localIP[20];
	char	remotePort[20];
	
	entryNum = mib_chain_total(MIB_PORT_FW_TBL);
	
	nBytesSent += boaWrite(wp, "<tr>"
#ifndef CONFIG_GENERAL_WEB
  	"<td align=center width=\"25%%\" bgcolor=\"#808080\"><font size=\"2\"><b>%s</b></font></td>\n"
  	"<td align=center width=\"20%%\" bgcolor=\"#808080\"><font size=\"2\"><b>%s</b></font></td>\n"
  	"<td align=center width=\"20%%\" bgcolor=\"#808080\"><font size=\"2\"><b>%s</b></font></td>\n"
	"<td align=center width=\"20%%\" bgcolor=\"#808080\"><font size=\"2\"><b>%s</b></font></td>\n"
	"<td align=center bgcolor=\"#808080\"><font size=\"2\"><b>%s</b></font></td></tr>\n",
#else
	"<th align=center width=\"25%%\">%s</th>\n"
	"<th align=center width=\"20%%\">%s</th>\n"
	"<th align=center width=\"20%%\">%s</th>\n"
	"<th align=center width=\"20%%\">%s</th>\n"
	"<th align=center>%s</th></tr>\n",
#endif
	multilang(LANG_COMMENT), multilang(LANG_LOCAL_IP), multilang(LANG_PROTOCOL),
	multilang(LANG_LOCAL_PORT), multilang(LANG_REMOTE_PORT));
	
	for (i=0; i<entryNum; i++) {

		if (!mib_chain_get(MIB_PORT_FW_TBL, i, (void *)&Entry))
		{
  			boaError(wp, 400, (char *)errGetEntry);
			return -1;
		}
		
		if (Entry.dynamic==0)
			continue;
		
		ip = inet_ntoa(*((struct in_addr *)Entry.ipAddr));
		strcpy( localIP, ip );
		if ( !strcmp(localIP, "0.0.0.0"))
			strcpy( localIP, "----" );

		if ( Entry.protoType == PROTO_UDPTCP )
			type = "TCP+UDP";
		else if ( Entry.protoType == PROTO_TCP )
			type = "TCP";
		else
			type = "UDP";

		if ( Entry.fromPort == 0)
			strcpy(portRange, "----");
		else if ( Entry.fromPort == Entry.toPort )
			snprintf(portRange, 20, "%d", Entry.fromPort);
		else
			snprintf(portRange, 20, "%d-%d", Entry.fromPort, Entry.toPort);

		if ( Entry.externalfromport == 0)
			strcpy(remotePort, "----");
		else if ( Entry.externalfromport == Entry.externaltoport )
			snprintf(remotePort, 20, "%d", Entry.externalfromport);
		else
			snprintf(remotePort, 20, "%d-%d", Entry.externalfromport, Entry.externaltoport);
		
		nBytesSent += boaWrite(wp, "<tr>"
#ifndef CONFIG_GENERAL_WEB
			"<td align=center width=\"25%%\" bgcolor=\"#C0C0C0\"><font size=\"2\">%s</td>\n"
      		"<td align=center width=\"20%%\" bgcolor=\"#C0C0C0\"><font size=\"2\">%s</td>\n"
      		"<td align=center width=\"20%%\" bgcolor=\"#C0C0C0\"><font size=\"2\">%s</td>\n"
     		"<td align=center width=\"20%%\" bgcolor=\"#C0C0C0\"><font size=\"2\">%s</td>\n"
			"<td align=center bgcolor=\"#C0C0C0\"><font size=\"2\">%s</td></tr>\n",
#else
			"<td align=center width=\"25%%\">%s</td>\n"
			"<td align=center width=\"20%%\">%s</td>\n"
			"<td align=center width=\"20%%\">%s</td>\n"
			"<td align=center width=\"20%%\">%s</td>\n"
			"<td align=center>%s</td></tr>\n",
#endif
				Entry.comment, localIP, type, portRange,
				remotePort);
	}
	
	return nBytesSent;
}

#endif
