<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN">
<!--系统默认模板-->
<HTML>
<HEAD>
<TITLE>VxLAN配置</TITLE>
<META http-equiv=pragma content=no-cache>
<META http-equiv=cache-control content="no-cache, must-revalidate">
<META http-equiv=content-type content="text/html; charset=utf-8">
<META http-equiv=content-script-type content=text/javascript>
<!--系统公共css-->
<STYLE type=text/css>
@import url(/style/default.css);
</STYLE>
<!--系统公共脚本-->
<SCRIPT language="javascript" src="common.js"></SCRIPT>
<SCRIPT language="javascript" type="text/javascript">

var work_mode_type = new Array("", "二层模式", "三层模式");
var addr_mode_type = new Array("", "DHCP", "Static");

var rcs = new Array();
with(rcs){<% vxlanConfList(); %>}
var ssid2_enable = "<% checkWrite("ssid2_enable"); %>";

function on_chkclick(index)
{
	if(index < 0 || index >= rcs.length)
		return; 
	rcs[index].select = !rcs[index].select;
}

/********************************************************************
**          on document load
********************************************************************/
function on_init()
{
	sji_docinit(document);
	
	if(ssid2_enable == 1)
		getElById('enableDisplay2').style.display = "inline";
	
	if(lstrc.rows){while(lstrc.rows.length > 1) lstrc.deleteRow(1);}
	for(var i = 0; i < rcs.length; i++)
	{
		var row = lstrc.insertRow(i + 1);
		
		row.nowrap = true;
		row.vAlign = "top";
		row.align = "center";
		var cell = row.insertCell(0);
		cell.innerHTML = rcs[i].tunnel_key;
		cell = row.insertCell(1);
		if(rcs[i].enable == "1")
			cell.innerHTML = "开启";
		else
			cell.innerHTML = "关闭";
		cell = row.insertCell(2);
		cell.innerHTML = rcs[i].tunnel_dst_ip;
		cell = row.insertCell(3);
		cell.innerHTML = work_mode_type[rcs[i].work_mode];	
		cell = row.insertCell(4);
		cell.innerHTML = addr_mode_type[rcs[i].addressing_type];	
		cell = row.insertCell(5);
		cell.innerHTML = rcs[i].ip_addr;
		cell = row.insertCell(6);
		if(rcs[i].vlan_enable == "1")
			cell.innerHTML = "开启";
		else
			cell.innerHTML = "关闭";		
		cell = row.insertCell(7);
		cell.innerHTML = rcs[i].wanname;
		cell = row.insertCell(8);
		cell.align = "center";
		cell.innerHTML = "<input type=\"checkbox\" name=\"rml"
				+ i + "\" value=\"ON\" onClick=\"on_chkclick(" + i + ");\">";
	}
	onSelectWorkMode();
}

/********************************************************************
**          on document submit
********************************************************************/
function on_submit_add() 
{
	with ( document.forms[0] ) 
	{
		if(!checkDigitRange(form.tunnel_key.value, 1, 0, 16777215))
		{
			form.tunnel_key.focus();
			alert("vni：" + form.tunnel_key.value + "为无效值，请重新输入！");
			return;
		}
		if (form.vlan_enable.checked)
		{
			if(!checkDigitRange(form.vlan.value, 1, 0, 4094))
			{
				form.vlan.focus();
				alert("VLAN ID：" + form.vlan.value + "为无效值，请重新输入！");
				return;
			}
		}
		if(form.work_mode.value == 2) //Routing
		{
			if(form.addressing_type.value == 2) //Static
			{
				if(sji_checkvip(ip_addr.value) == false)
				{
					form.ip_addr.focus();
					alert("IP地址：" + form.ip_addr.value + "为无效IP，请重新输入！");
					return;
				}
				if(sji_checkmask(subnet_mask.value) == false)
				{
					form.subnet_mask.focus();
					alert("地址掩码：" + form.subnet_mask.value + "为无效IP，请重新输入！");
					return;
				}
				if(sji_checkvip(default_gateway.value) == false)
				{
					form.default_gateway.focus();
					alert("閘道地址：" + form.default_gateway.value + "为无效IP，请重新输入！");
					return;
				}
				if((form.dns_server_master.value.length > 0 )&& sji_checkvip(dns_server_master.value) == false)
				{
					form.dns_server_master.focus();
					alert("主用DNS地址：" + form.dns_server_master.value + "为无效IP，请重新输入！");
					return;
				}
				if((form.dns_server_slave.value.length > 0 )&& sji_checkvip(dns_server_slave.value) == false)
				{
					form.dns_server_slave.focus();
					alert("备用DNS地址：" + form.dns_server_slave.value + "为无效IP，请重新输入！");
					return;
				}
			}
		}
		form.action.value = "add";
		form.submit();
		}
}

function on_submit_delete() 
{
	with ( document.forms[0] ) 
	{
		form.bcdata.value = sji_encode(rcs, "select");
		form.action.value = "delete";
		form.submit();
	}
}

function onSelectAddrMode()
{
	 with ( document.forms[0] )
	 {
		if(form.addressing_type.value == 1)//DHCP
		{
			document.form.ip_addr.disabled = true;
			document.form.ip_addr.value = '';
			document.form.subnet_mask.disabled = true;
			document.form.subnet_mask.value = '';
			document.form.default_gateway.disabled = true;
			document.form.default_gateway.value = '';
			document.form.dns_server_master.disabled = true;
			document.form.dns_server_master.value = '';
			document.form.dns_server_slave.disabled = true;
			document.form.dns_server_slave.value = '';
		}
		else //Static
		{
			document.form.ip_addr.disabled = false;
			document.form.subnet_mask.disabled = false;
			document.form.default_gateway.disabled = false;
			document.form.dns_server_master.disabled = false;
			document.form.dns_server_slave.disabled = false;
		}
	}
}

function onSelectWorkMode()
{
	 with ( document.forms[0] )
	 {
		if(form.work_mode.value == 1) //Bridge
		{
			document.form.addressing_type.disabled = true;
			document.form.nat_enable.disabled = true;
			document.form.ip_addr.disabled = true;
			document.form.ip_addr.value = '';
			document.form.subnet_mask.disabled = true;
			document.form.subnet_mask.value = '';	
			document.form.default_gateway.disabled = true;
			document.form.default_gateway.value = '';
			document.form.dns_server_master.disabled = true;
			document.form.dns_server_master.value = '';
			document.form.dns_server_slave.disabled = true;
			document.form.dns_server_slave.value = '';
		}
		else //Routing
		{
			document.form.addressing_type.disabled = false;
			document.form.nat_enable.disabled = false;
			onSelectAddrMode();
		}
	 }
}

</SCRIPT>
</HEAD>

<!-------------------------------------------------------------------------------------->
<!--主页代码-->
<body topmargin="0" leftmargin="0" marginwidth="0" marginheight="0" alink="#000000" link="#000000" vlink="#000000" onLoad="on_init();">
	<blockquote>
		<DIV align="left" style="padding-left:20px; padding-top:5px">
			<form id="form" name="form" action="/boaform/admin/formVxlan" method="post">
				<br>
				<table cellpadding="0" cellspacing="1">
					<tr>
						<td align="left">VxLAN vni :</td>
						<td>
							<input type="text" size="8" maxlength="8" name="tunnel_key">
						</td>
					</tr>				
					<tr>
						<td align="left">启用：</td>
						<td>
							<input type="checkbox" name="enable">
						</td>
					</tr>
					<tr>
						<td align="left">隧道对端地址：</td>
						<td>
							<input type="text" size="15" maxlength="15" name="tunnel_dst_ip">
						</td>
					</tr>				
					<tr>
						<td align="left">工作模式：</td>
						<td>
							<select name="work_mode" onchange=onSelectWorkMode()>
								<option value="1">
								二层模式
								<option value="2" selected>
								三层模式
							 </select>
						</td>
					</tr>
<!-- 三层模式 -->
					<tr>
						<td align="left">地址类型：</td>
						<td>
							<select name="addressing_type" onchange=onSelectAddrMode()>
								<option value="1" selected>
								DHCP
								<option value="2">
								Static
							 </select>
						</td>
					</tr>
					<tr>
						<td align="left">IP地址：</td>
						<td>
							<input type="text" size="15" maxlength="15" name="ip_addr">
						</td>
					</tr>						
					<tr>
						<td align="left">地址掩码：</td>
						<td>
							<input type="text" size="15" maxlength="15" name="subnet_mask">
						</td>
					</tr>
					<tr>
						<td align="left">閘道地址：</td>
						<td>
							<input type="text" size="15" maxlength="15" name="default_gateway">
						</td>
					</tr>
					<tr>
						<td align="left">启用NAT：</td>
						<td>
							<input type="checkbox" name="nat_enable">
						</td>
					</tr>
					<tr>
						<td align="left">主用DNS地址：</td>
						<td>
							<input type="text" size="15" maxlength="15" name="dns_server_master">
						</td>
					</tr>
					<tr>
						<td align="left">备用DNS地址：</td>
						<td>
							<input type="text" size="15" maxlength="15" name="dns_server_slave">
						</td>
					</tr>
<!-- end of 三层模式 -->
					<tr>
						<td align="left">MTU :</td>
						<td>
							<input type="text" size="4" maxlength="4" name="max_mtu_size">
						</td>
					</tr>				
					<tr>
						<td align="left">启用VLAN：</td>
						<td>
							<input type="checkbox" name="vlan_enable">
						</td>
					</tr>			
					<tr>
						<td align="left">VLAN ID:</td>
						<td>
							<input type="text" size="4" maxlength="4" name="vlan">
						</td>
					</tr>
					
					<tr>
						<td align="left">绑定LAN连接：</td>
						<td><% ShowPortMapping(); %> </td>						
					</tr>
					<TABLE cellSpacing=0 cellPadding=0 border=0 id="wlanBindTab">
						<TBODY>
							<TR id = 'wlan_table_1'>
								<TD width=85>&nbsp; </TD>
								<TD>
									<SPAN id=secWireless1>
										<INPUT id=cb_bindwireless1  type=checkbox name=cb_bindwireless1 >
											SSID1
										<INPUT id=bindwireless1 type=hidden value=0 name=bindwireless1>
									</SPAN>
									<DIV id=enableDisplay2 style="display:none;"> <!-- display:inline to show in the same line with SSID1 -->
										<SPAN id=secWireless2>
											<INPUT id=cb_bindwireless2 type=checkbox name=cb_bindwireless2 >
												SSID2
											<INPUT id=bindwireless2 type=hidden value=0 name=bindwireless2>
										</SPAN>
									</DIV>
								</TD>
							</TR>
						</TBODY>
					</TABLE>

					<TABLE cellSpacing=0 cellPadding=0 border=0 id="wlanacBindTab">
						<TBODY>
							<TR id = 'wlan_table_2'>
								<TD width=85>&nbsp;</TD>
								<TD>
								<SPAN id=secWirelessac1>
									<INPUT id=cb_bindwirelessac1 type=checkbox name=cb_bindwirelessac1 >
										SSID5
									<INPUT id=bindwirelessac1 type=hidden value=0 name=bindwirelessac1>
								</SPAN> &nbsp; </TD>
							</TR>
						</TBODY>
					</TABLE>					
					<tr>
						<td align="left">绑定WAN连接：</td>
						<td><select name="wan_interface"> <% if_wan_list("rt"); %> </select></td>
					</tr>
				</table>
				<p>
				<DIV id="div_Vrtsrv" name="div_Vrtsrv" style="display:block;">				
				<table class="flat" id="lstrc" border="1" cellpadding="0" cellspacing="1">
				   <tr class="hdb" align="center" nowrap>
					  <td width="60px">VNI</td>
					  <td width="60px">使能</td>
					  <td width="120px">隧道对端地址</td>
					  <td width="60px">工作模式</td>
					  <td width="60px">地址类型</td>
					  <td width="120px">VXLAN IP地址</td>
					  <td width="60px">启用vlan</td>
					  <td width="120px">绑定WAN连接</td>
					  <td width="40px">删除</td>
				   </tr>
				</table>
				   </tr>
				</table>
				</DIV>
				<br>
				<input type="button" class="btnaddup" onClick="on_submit_add();" value="添加">
				<input type="button" class="btndeleup" onClick="on_submit_delete();" value="删除">
				<input type="hidden" id="action" name="action" value="delete">
				<input type="hidden" name="bcdata" value="le">
				<input type="hidden" name="submit-url" value="/app_vxlan_cfg.asp">
			</form>
		</DIV>
	</blockquote>
</body>
<%addHttpNoCache();%>
</html>
