<html>
<head>
<title>IPsec VPN Configuration</title>
<meta http-equiv="Content-Type" content="text/html" charset="gbk">
<style type=text/css>
@import url(/style/default.css);
</style>
<script language="javascript" src="common.js"></script>
<script>
var conns = new Array();
with(conns){<% ipsecSwanConfDetail(); %>}

function checkParameters()
{
	with (getElById('ipsec'))
	{
		if(IKEAuthenticationMethod.value == 1){
			if(IKEPreshareKey.value == ""){
				alert("PSKģʽIKEPreshareKeyΪֵ");
				IKEPreshareKey.focus();
				return false;
			}
			else if((IKEPreshareKey.value.length < 8) || (IKEPreshareKey.value.length  >128)){
				alert("IKEPreshareKeyַΪ8~128");
				IKEPreshareKey.focus();
				return false;
			}
		}
		
		//check IKESAPeriod
		if((IKESAPeriod.value < 1200) || (IKESAPeriod.value > 86400)){
			alert("IKESAPeriodֵǷЧֵ1200~86400s");
			IKESAPeriod.focus();
			return false;
		}

		//check IPSecSATimePeriod
		if((IPSecSATimePeriod.value < 600) || (IPSecSATimePeriod.value > 86400)){
			alert("IPSecSATimePeriodֵǷЧֵ600~86400s");
			IPSecSATimePeriod.focus();
			return false;
		}

		//check IPSecSATrafficPeriod
		if((IPSecSATrafficPeriod.value < 2560) || (IPSecSATrafficPeriod.value > 536870912)){
			alert("IPSecSATrafficPeriodֵǷЧֵ2560~536870912KBytes");
			IPSecSATrafficPeriod.focus();
			return false;
		}

		if(DPDEnable.checked == true){
			//check DPDThreshold
			if((DPDThreshold.value < 10) || (DPDThreshold.value > 3600)){
				alert("DPDThresholdֵǷЧֵ10~3600s");
				DPDThreshold.focus();
				return false;
			}

			//check DPDRetry
			if((DPDRetry.value < 2) || (DPDRetry.value > 10)){
				alert("DPDRetryֵǷЧֵ2~10s");
				DPDRetry.focus();
				return false;
			}
		}
	}

	return true;
}

function btnSave()
{
	var	vForm = document.ipsec;
	
	if(checkParameters() == false){
		return;
	}
	
	vForm.submit();	
}

function btnDelete()
{
	var	vForm = document.ipsec;	
	vForm.OperatorStyle.value = "delete";
	vForm.submit();
}

function IPSecTypeChange()
{
	var type = getElById('IPSecType');
	var secRemoteIP = getElById('secRemoteIP');
	var secRemoteDomain = getElById('secRemoteDomain');

	if(type.value == 1){
		secRemoteIP.style.display="block";
		secRemoteDomain.style.display="none";
	}
	else if(type.value == 2){
		secRemoteIP.style.display="none";
		secRemoteDomain.style.display="block";
	}
	
	return;
}

function IKEAuthMethodChange()
{
	var method = getElById('IKEAuthenticationMethod');
	var secPsk = getElById('secPsk');

	if(method.value == 1){
		secPsk.style.display="block";
	}
	else if(method.value == 2){
		secPsk.style.display="none";
	}
	
	return;
}

function IKEIDTypeChange()
{
	var type = getElById('IKEIDType');
	var secTypeName = getElById('secTypeName');

	if(type.value == 1){
		secTypeName.style.display="none";
	}
	else if(type.value == 2){
		secTypeName.style.display="block";
	}

	return;
}

function IPSecTransformChange()
{
	var transform = getElById('IPSecTransform');
	var secEsp = getElById('secEsp');
	var secAh = getElById('secAh');

	if(transform.value == 1){
		secAh.style.display="block";
		secEsp.style.display="none";
	}
	else if(transform.value == 2){
		secAh.style.display="none";
		secEsp.style.display="block";	
	}

	return;
}

function DPDEnableChange()
{
	var DPDEnable = getElById('DPDEnable');
	var secDpd = getElById('secDpd');

	if(DPDEnable.checked == true){
		secDpd.style.display="block";
	}
	else if(DPDEnable.checked == false){
		secDpd.style.display="none";
	}

	return;
}

function secChange()
{
	IPSecTypeChange();
	IKEAuthMethodChange();
	IKEIDTypeChange();
	IPSecTransformChange();
	DPDEnableChange();

	return;
}

function entry_init()
{
	var vForm = document.ipsec;

	vForm.OperatorStyle.value = "add";

	vForm.Enable.checked = true;
	vForm.encapl2tp.checked = true;
	vForm.IPSecType.value = 1;
	vForm.RemoteSubnet.value = "";
	vForm.LocalSubnet.value = "192.168.1.0/24";
	vForm.RemoteIP.value = "";
	vForm.RemoteDomain.value = "";
	//vForm.IPSecOutInterface.value
	vForm.IPSecEncapsulationMode.value = 1;
	vForm.IKEVersion.value = 2;
	vForm.ExchangeMode.value = 1;
	vForm.IKEAuthenticationAlgorithm.value = 1;
	vForm.IKEAuthenticationMethod.value = 1;
	vForm.IKEEncryptionAlgorithm.value = 1;
	vForm.IKEDHGroup.value = 1;
	vForm.IKEIDType.value = 1;
	vForm.IKELocalName.value = "";
	vForm.IKERemoteName.value = "";
	vForm.IKEPreshareKey.value = "";
	vForm.IKESAPeriod.value = "10800";
	vForm.IPSecTransform.value = 2;
	vForm.ESPAuthenticationAlgorithm.value = 1;
	vForm.ESPEncryptionAlgorithm.value = 2;
	vForm.AHAuthenticationAlgorithm.value = 1;
	vForm.IPSecPFS.value = 1;
	vForm.IPSecSATimePeriod.value = 3600;
	vForm.IPSecSATrafficPeriod.value = 1843200;
	vForm.DPDEnable.checked = false;
	vForm.DPDThreshold.value = 10;
	vForm.DPDRetry.value = 5;
	vForm.ConnectionStatus.value = 0;

	secChange();

	return;
}

function entry_change()
{
	var vForm = document.ipsec;	
	var index = vForm.entrys.value;
	if(index == 999){
		entry_init();
		return;
	}

	vForm.OperatorStyle.value = "modify";

	var ipsecCfg = conns[index];

	if(ipsecCfg.Enable == 1){
		vForm.Enable.checked = true;
	}
	else{
		vForm.Enable.checked = false;
	}
	if(ipsecCfg.encapl2tp == 1){
		vForm.encapl2tp.checked = true;
	}
	else{
		vForm.encapl2tp.checked = false;
	}
	vForm.IPSecType.value = ipsecCfg.IPSecType;
	vForm.RemoteSubnet.value = ipsecCfg.RemoteSubnet;
	vForm.LocalSubnet.value = ipsecCfg.LocalSubnet;
	vForm.RemoteIP.value = ipsecCfg.RemoteIP;
	vForm.RemoteDomain.value = ipsecCfg.RemoteDomain;
	vForm.IPSecOutInterface.value = ipsecCfg.IPSecOutInterface;
	vForm.IPSecEncapsulationMode.value = ipsecCfg.IPSecEncapsulationMode;
	vForm.IKEVersion.value = ipsecCfg.IKEVersion;
	vForm.ExchangeMode.value = ipsecCfg.ExchangeMode;
	vForm.IKEAuthenticationAlgorithm.value = ipsecCfg.IKEAuthenticationAlgorithm;
	vForm.IKEAuthenticationMethod.value = ipsecCfg.IKEAuthenticationMethod;
	vForm.IKEEncryptionAlgorithm.value = ipsecCfg.IKEEncryptionAlgorithm;
	vForm.IKEDHGroup.value = ipsecCfg.IKEDHGroup;
	vForm.IKEIDType.value = ipsecCfg.IKEIDType;
	vForm.IKELocalName.value = ipsecCfg.IKELocalName;
	vForm.IKERemoteName.value = ipsecCfg.IKERemoteName;
	vForm.IKEPreshareKey.value = ipsecCfg.IKEPreshareKey;
	vForm.IKESAPeriod.value = ipsecCfg.IKESAPeriod;
	vForm.IPSecTransform.value = ipsecCfg.IPSecTransform;
	vForm.ESPAuthenticationAlgorithm.value = ipsecCfg.ESPAuthenticationAlgorithm;
	vForm.ESPEncryptionAlgorithm.value = ipsecCfg.ESPEncryptionAlgorithm;
	vForm.AHAuthenticationAlgorithm.value = ipsecCfg.AHAuthenticationAlgorithm;
	vForm.IPSecPFS.value = ipsecCfg.IPSecPFS;
	vForm.IPSecSATimePeriod.value = ipsecCfg.IPSecSATimePeriod;
	vForm.IPSecSATrafficPeriod.value = ipsecCfg.IPSecSATrafficPeriod;

	if(ipsecCfg.DPDEnable == 1){
		vForm.DPDEnable.checked = true;
	}
	else{
		vForm.DPDEnable.checked = false;
	}
	vForm.DPDThreshold.value = ipsecCfg.DPDThreshold;
	vForm.DPDRetry.value = ipsecCfg.DPDRetry;
	vForm.ConnectionStatus.value = ipsecCfg.ConnectionStatus;

	secChange();
	
	return;
}
function WebInit()
{
	var	vForm = document.ipsec;	
	if(conns.length > 0){
		vForm.entrys.value=0;
		entry_change();
	}
	secChange();
}
</script>
</head>
<body onload="WebInit();">
	<blockquote>
	<form action=/boaform/formIPsecStrongswan method=POST name="ipsec">
	<input type="hidden" name="OperatorStyle" value="add">
	<table>
		<tr>
			<td class="leftContent"  width=312>VPN Config</td>
			<td class="rightContent"  width=312>
			<select name="entrys" class="selectStyle" onchange="entry_change()">
				<% ipsecSwanConfList();%>
			</select>
			</td>
		</tr>
		<tr>
			<td>ܿ</td>
			<td valign="middle" width="30" height="30">
				<input type='checkbox' name='Enable' checked>
			</td>
		</tr>
		<tr>
			<td class="leftContent"  width=312>L2TP Encap</td>
			<td class="rightContent"  width=312>
			<input type='checkbox' name='encapl2tp' checked>
			</td>
		</tr>
		<tr>
			<td class="leftContent"  width=312>IPSecType</td>
			<td class="rightContent"  width=312>
			<select name="IPSecType" class="selectStyle" onchange="IPSecTypeChange();">
				<option value="1" selected>Site-to-Site</option>
				<option value="2">PC-to-Site</option>
			</select>
			</td>
		</tr>
		<tr>
			<td class="leftContent"  width=312>RemoteSubnet</td>
			<td class="rightContent"  width=312>
				<input  name="RemoteSubnet" class="inputStyle" placeholder="öŷָ" type="text" />
			</td>
		</tr>
		<tr>
			<td class="leftContent"  width=312>LocalSubnet</td>
			<td class="rightContent"  width=312>
				<input  name="LocalSubnet" class="inputStyle" value="192.168.1.0/24" type="text" />
			</td>
		</tr>
	</table>
	<table id="secRemoteIP" style="display: block">
		<tr>
			<td class="leftContent"  width=312>RemoteIP</td>
			<td class="rightContent"  width=312>
				<input  name="RemoteIP" class="inputStyle" type="text" />
			</td>
		</tr>
	</table>
	<table id="secRemoteDomain" style="display: none">
		<tr>
			<td class="leftContent"  width=312>RemoteDomain</td>
			<td class="rightContent"  width=312>
				<input  name="RemoteDomain"class="inputStyle" type="text" />
			</td>
		</tr>
	</table>
	<table>
		<tr>
			<td class="leftContent"  width=312>IPSecOutInterface</td>
			<td class="rightContent"  width=312>
			<select name="IPSecOutInterface" class="selectStyle">
          		<%  ipsecSwanWanList();%>
			</select>
			</td>
		</tr>
		<tr>
			<td class="leftContent"  width=312>IPSecEncapsulationMode</td>
			<td class="rightContent"  width=312>
			<select name="IPSecEncapsulationMode" class="selectStyle">
				<option value="1" selected>Tunnel</option>
				<option value="2">Transport</option>
			</select>
			</td>
		</tr>
		<tr>
			<td colspan="3"><hr size=1 noshade align=top /></td>
		</tr>
		<!-- -->
		<tr>
			<td class="leftContent"  width=312>IKEVersion</td>
			<td class="rightContent"  width=312>
			<select name="IKEVersion" class="selectStyle">
				<option value="0">ALL</option>
				<option value="1">1</option>
				<option value="2" selected>2</option>
			</select>
			</td>
		</tr>
		<tr>
			<td class="leftContent"  width=312>ExchangeMode</td>
			<td class="rightContent"  width=312>
			<select name="ExchangeMode" class="selectStyle">
				<option value="1" selected>main</option>
				<option value="2">aggressive</option>
			</select>
			</td>
		</tr>
		<tr>
			<td class="leftContent"  width=312>IKEAuthenticationAlgorithm</td>
			<td class="rightContent"  width=312>
			<select name="IKEAuthenticationAlgorithm" class="selectStyle">
				<option value="1" selected>MD5</option>
				<option value="2">SHA1</option>
			</select>
			</td>
		</tr>
		<tr>
			<td class="leftContent"  width=312>IKEAuthenticationMethod</td>
			<td class="rightContent"  width=312>
			<select name="IKEAuthenticationMethod" id="IKEAuthenticationMethod" class="selectStyle" onchange="IKEAuthMethodChange();">
				<option value="1" selected>PreShareKey</option>
				<option value="2">RsaSignature</option>
			</select>
			</td>
		</tr>
	</table>
	<table id = "secPsk" style="display: block">
		<tr>
			<td class="leftContent"  width=312>IKEPreshareKey</td>
			<td class="rightContent"  width=312>
				<input name="IKEPreshareKey" class="inputStyle" type="text" onblur="checkit(this)" onfocus="clearit(this)" />
			</td>
		</tr>
	</table>
	<table>
		<tr>
			<td class="leftContent"  width=312>IKEEncryptionAlgorithm</td>
			<td class="rightContent"  width=312>
			<select name="IKEEncryptionAlgorithm" class="selectStyle">
				<option value="1" selected>DES</option>
				<option value="2">3DES</option>
				<option value="3">AES128</option>
				<option value="4">AES192</option>
				<option value="5">AES256</option>
			</select>
			</td>
		</tr>
		<tr>
			<td class="leftContent"  width=312>IKEDHGroup</td>
			<td class="rightContent"  width=312>
			<select name="IKEDHGroup" class="selectStyle">
				<option value="1" selected>Group1</option>
				<option value="2">Group2</option>
				<option value="3">Group5</option>
				<option value="4">Group14</option>
			</select>
			</td>
		</tr>
		<tr>
			<td class="leftContent"  width=312>IKEIDType</td>
			<td class="rightContent"  width=312>
			<select name="IKEIDType" id="IKEIDType" class="selectStyle" onchange="IKEIDTypeChange();">
				<option value="1" selected>IP</option>
				<option value="2">Name</option>
			</select>
			</td>
		</tr>
	</table>
	<table id="secTypeName" style="display: none">
		<tr>
			<td class="leftContent"  width=312>IKELocalName</td>
			<td class="rightContent"  width=312>
				<input name="IKELocalName" class="inputStyle" type="text" onblur="checkit(this)" onfocus="clearit(this)" />
			</td>
		</tr>
		<tr>
			<td class="leftContent"  width=312>IKERemoteName</td>
			<td class="rightContent"  width=312>
				<input name="IKERemoteName" class="inputStyle" type="text" onblur="checkit(this)" onfocus="clearit(this)" />
			</td>
		</tr>
	</table>
	<table>
		<tr>
			<td class="leftContent"  width=312>IKESAPeriod</td>
			<td class="rightContent"  width=312>
				<input  name="IKESAPeriod"class="inputStyle" placeholder="1200-86400s" type="text" value="10800"/>
			</td>
		</tr>
		<tr>
			<td colspan="3"><hr size=1 noshade align=top /></td>
		</tr>
		<!-- -->
		<tr>
			<td class="leftContent"  width=312>IPSecTransform</td>
			<td class="rightContent"  width=312>
			<select name="IPSecTransform" id = "IPSecTransform" class="selectStyle" onchange="IPSecTransformChange();">
				<option value="1">AH</option>
				<option value="2" selected>ESP</option>
			</select>
			</td>
		</tr>
	</table>
	<table id="secEsp" style="display: block">
		<tr>
			<td class="leftContent"  width=312>ESPAuthenticationAlgorithm</td>
			<td class="rightContent"  width=312>
			<select name="ESPAuthenticationAlgorithm" class="selectStyle">
				<option value="0">NONE</option>
				<option value="1" selected>MD5</option>
				<option value="2">SHA1</option>
			</select>
			</td>
		</tr>
		<tr>
			<td class="leftContent"  width=312>ESPEncryptionAlgorithm</td>
			<td class="rightContent"  width=312>
			<select name="ESPEncryptionAlgorithm" class="selectStyle">
				<option value="1">DES</option>
				<option value="2" selected>3DES</option>
				<option value="3">AES128</option>
				<option value="4">AES192</option>
				<option value="5">AES256</option>
			</select>
			</td>
		</tr>
	</table>
	<table id="secAh" style="display: none">
		<tr>
			<td class="leftContent"  width=312>AHAuthenticationAlgorithm</td>
			<td class="rightContent"  width=312>
			<select name="AHAuthenticationAlgorithm" class="selectStyle">
				<option value="1">MD5</option>
				<option value="2">SHA1</option>
			</select>
			</td>
		</tr>
	</table>
	<table>
		<tr>
			<td class="leftContent"  width=312>IPSecPFS</td>
			<td class="rightContent"  width=312>
			<select name="IPSecPFS" class="selectStyle">
				<option value="0" selected>NONE</option>
				<option value="1">Group1</option>
				<option value="2">Group2</option>
				<option value="3">Group5</option>
				<option value="4">Group14</option>
			</select>
			</td>
		</tr>
		<tr>
			<td class="leftContent"  width=312>IPSecSATimePeriod</td>
			<td class="rightContent"  width=312>
				<input  name="IPSecSATimePeriod"class="inputStyle" placeholder="600-86400s" type="text" value="3600"/>
			</td>
		</tr>
		<tr>
			<td class="leftContent"  width=312>IPSecSATrafficPeriod</td>
			<td class="rightContent"  width=312>
				<input  name="IPSecSATrafficPeriod" class="inputStyle" placeholder="2560-536870912Kbytes" type="text" value="1843200"/>
			</td>
		</tr>
		<tr>
			<td colspan="3"><hr size=1 noshade align=top /></td>
		</tr>
		<!-- -->
		<tr>
			<td>IPSec DPD (IPSec Dead Peer Detection on-demand)</td>
			<td valign="middle" width="30" height="30">
				<input type='checkbox' name="DPDEnable" id="DPDEnable" value="ON" onchange="DPDEnableChange();">
			</td>
		</tr>
	</table>
	<table id="secDpd" style="display: none">
		<tr>
			<td class="leftContent"  width=312>DPDThreshold</td>
			<td class="rightContent"  width=312>
				<input  name="DPDThreshold" class="inputStyle" placeholder="10-3600S" type="text" value="10"/>
			</td>
		</tr>
		<tr>
			<td class="leftContent"  width=312>DPDRetry</td>
			<td class="rightContent"  width=312>
				<input  name="DPDRetry" class="inputStyle" placeholder="2-10S" type="text" value="5"/>
			</td>
		</tr>
	</table>
	<table>
		<tr>
			<td colspan="3"><hr size=1 noshade align=top /></td>
		</tr>
		<!-- -->
		<tr>
			<td class="leftContent"  width=312>ConnectionStatus</td>
			<td class="rightContent"  width=312>
			<select name="ConnectionStatus" class="selectStyle" disabled>
				<option value="0" selected>Unconfigured</option>
				<option value="1">PhaseI_Connecting</option>
				<option value="2">PhaseII_Connecting</option>
				<option value="3">Connected</option>
				<option value="4">Disconnecting</option>
				<option value="5">Disconnected</option>
			</select>
			</td>
		</tr>
	</table>
	<input id=btnDel class="btnDel" type="button" onclick="return btnDelete();" value="ɾ">
	<input id=btnOK class="btnsaveup" type="button" onclick="return btnSave();" value="ȷ">
	<input name="submit-url" type="hidden" value="/ipsec_swan.asp" />
	</form>
	
	<form action=/boaform/formIPSecSwanGenCert method=POST name="gen_local_cert">	
	<table id="autoHead" class="tableStyle">
		<tr>
			<td class="topFrame" colspan="3">Certificate Management: </td>
		</tr>
	</table>
	<table class="tableStyle">	
		<tr>
			<td class="leftBlank"></td>
			<td class="leftContent">ca.cert.pem</td>
			<td class="rightContent">
				<form action=/boaform/formIPSecSwanCert method=POST enctype="multipart/form-data" name="ipsec_cert">
					<input type="file" value="Choose File" name="binary" size=24>&nbsp;&nbsp;
					<input type="submit" value="Upload" name="load">
				</form>
			</td>
		</tr>
		<tr>
			<td class="leftBlank"></td>
			<td class="leftContent">ca.pem(private key)</td>
			<td class="rightContent">
				<form action=/boaform/formIPSecSwanKey method=POST enctype="multipart/form-data" name="ipsec_key">
					<input type="file" value="Choose File" name="binary" size=24>&nbsp;&nbsp;
					<input type="submit" value="Upload" name="load">
					<input type="hidden" name="postSecurityFlag" value="">
				</form>
			</td>
		</tr>
		<tr>
			<td class="leftContent"  width=312>Country(C)</td>
			<td class="rightContent"  width=312>
				<input name="Country" class="inputStyle" type="text"/>
			</td>
		</tr>
		<tr>
			<td class="leftContent"  width=312>Organization(O)</td>
			<td class="rightContent"  width=312>
				<input name="Organization" class="inputStyle" type="text"/>
			</td>
		</tr>
		<tr>
			<td class="leftBlank"></td>
			<td class="leftContent">generate a new local cert:</td>
			<td class="rightContent">
					<input type="submit" value="generate local cert" name="generate">
					<input name="submit-url" type="hidden" value="/ipsec_swan.asp" />	
			</td>
		</tr>
	</table>
	</form>

	</blockquote>
</body>
</html>
