<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN">
<HTML>
<HEAD>
<TITLE>绑定模式</TITLE>
<META http-equiv=pragma content=no-cache>
<META http-equiv=cache-control content="no-cache, must-revalidate">
<META http-equiv=content-type content="text/html; charset=utf-8">
<META http-equiv=content-script-type content=text/javascript>
<STYLE type=text/css>
@import url(/style/default.css);
</STYLE>
<SCRIPT language="javascript" src="common.js"></SCRIPT>
<SCRIPT language="javascript" type="text/javascript">
var vlan_mapping_interface = <% checkWrite("vlan_mapping_interface"); %>;
var vlan_mapping_interface_idx = <% checkWrite("vlan_mapping_interface_idx"); %>;
<% initVlanRange(); %>

function getObj(id)
{
	return(document.getElementById(id));
}

function setValue(id,value)
{
	var node = document.getElementById(id);
	if(node)node.value=value;
}

function getValue(id)
{
	var node = document.getElementById(id);
	if(node) return node.value;
	else return "";
}

function ModifyInstance(obj, index, port)
{
  var mode_id="Mode"+port;
  if(getValue(mode_id) == 1)
  {
	document.getElementById("Frm_Mode").options[0].selected=true;
	document.getElementById("BindVlanRow").style.display = '';   
  }
  else
  {
    document.getElementById("Frm_Mode").options[1].selected=true;	
	document.getElementById("BindVlanRow").style.display = 'none'; 
  }

  document.getElementById("if_index").value = port;
  document.getElementById("PortId").innerHTML=obj.cells[0].innerText;
  if(obj.cells[2].innerText != "--")
  {
  	document.getElementById("VlanPair").value=obj.cells[2].innerText;
  }
  else
  {
    document.getElementById("VlanPair").value='';
  }
  document.getElementById("TableUrlInfo").style.display = "block";
}

function addline(index, iface, port)
{
	if(port == -1 || iface == "SSID_DISABLE")
		return;
	
	var newline;
	var mode= getValue('Mode'+port);
	newline = document.getElementById('Special_Table').insertRow(-1);
	newline.nowrap = true;
	newline.vAlign = "top";
	newline.align = "center";
	newline.onclick = function() {ModifyInstance(this, index, port)};
	newline.setAttribute("class","white");
	newline.setAttribute("className","white");
	newline.insertCell(-1).innerHTML = iface;
	newline.insertCell(-1).innerHTML = (mode==1)?"VLAN绑定":"端口绑定";
	newline.insertCell(-1).innerHTML = (mode==1)?getValue('VLAN'+port):"--";
}

function addPort(index, iface, port)
{
	if(port == -1 || iface == "SSID_DISABLE")
		return;
	
	var form = document.getElementsByName("vmap");
	if(form.length > 0)
	{
		var modeInput = document.createElement("input"); 
		var vlanInput = document.createElement("input"); 
		if(modeInput && vlanInput)
		{
			modeInput.type="hidden";
			modeInput.name="Mode"+port;
			modeInput.id="Mode"+port;
			modeInput.value=0;
			modeInput.disabled=true;
			
			vlanInput.type="hidden";
			vlanInput.name="VLAN"+port;
			vlanInput.id="VLAN"+port;
			vlanInput.value="";
			vlanInput.disabled=true;
			
			form[0].appendChild(modeInput);
			form[0].appendChild(vlanInput);
		}
	}
}


function showTable()
{
	var num = vlan_mapping_interface.length;
	var iface = vlan_mapping_interface;
	var port = vlan_mapping_interface_idx;

	if (num!=0) {
		for (var i=0; i<num; i++) {
			if(i >= port.length) continue;
			addline(i, iface[i], port[i]);
		}
	}
	else {
	}
}

function initPagePBind()
{
	var num = vlan_mapping_interface.length;
	var iface = vlan_mapping_interface;
	var port = vlan_mapping_interface_idx;

	if (num!=0) {
		for (var i=0; i<num; i++) {
			if(i >= port.length) continue;
			addPort(i, iface[i], port[i]);
		}
	}
	
	<% initPagePBind(); %>
}

/********************************************************************
**          on document load
********************************************************************/
function on_init()
{
	initPagePBind();
	showTable();
}

function checkVLANRange(vlan)
{
	var num = reservedVlanA.length;
	for(var i = 0; i<num; i++){
		if(vlan == reservedVlanA[i])
			return false;
	}
	if(sji_checkdigitrange(vlan, otherVlanStart, otherVlanEnd) == true)
		return false;
	//return vlan==parseInt(vlan)&&0<vlan&&vlan<4095;
	return true;
}

function OnChooseDeviceType(Select)
{
   var Mode = document.getElementById("Frm_Mode").value;

   if (Mode == "0")
       document.getElementById("BindVlanRow").style.display = 'none';        
   else if (Mode == "1")
       document.getElementById("BindVlanRow").style.display = '';
}

//用户点击了取消按钮后的代码逻辑
function OnCancelButtonClick()
{
    document.getElementById("TableUrlInfo").style.display = "none";
    return false;
}

function OnApplyButtonClick(obj)
{
	if(1 == document.getElementById("Frm_Mode").value) //vlan bind
	{
		var BindVlan = document.getElementById("VlanPair").value;
		if(false == IsBindBindVlanValid(BindVlan))
		{
			return false;
		}
	}

	obj.isclick = 1;
	postTableEncrypt(document.forms[0].postSecurityFlag, document.forms[0]);
	document.forms[0].submit();
	return true;
}

function IsBindBindVlanValid(BindVlan)
{   
	var LanVlanWanVlanList = BindVlan.split(",");
	var LanVlan;
	var WanVlan;
	var TempList;
	
	if ( LanVlanWanVlanList.length > 4)
	{
			alert("最大支持4个VLAN对。");
			return false;
	}

	for (var i = 0; i < LanVlanWanVlanList.length; i++)
	{
		TempList = LanVlanWanVlanList[i].split("/");
		
		/* 检验是否满足a/b格式 */
		if (TempList.length != 2)
		{
			alert(BindVlan+"格式不合法。");
			return false;
		}
		
		/* 检验a，b是否为数字 */
		if ((isNaN(parseInt(TempList[0]))) || (isNaN(parseInt(TempList[1]))))
		{
			alert(BindVlan+"格式不合法。");
			return false;
		}
		
		/* 检验lan口的vlan是否合法, 如果需要更加精确的检查，调用checkVLANRange */
		if (!(parseInt(TempList[0]) >= 1 && parseInt(TempList[0]) <= 4095))
		{
			alert(BindVlan+"中用户Vlan\""+parseInt(TempList[0])+"\"不合法。");
			return false;
		}
		
		if (!(parseInt(TempList[1]) >= 0 && parseInt(TempList[1]) <= 4095))
		{
			alert(BindVlan+"中出接口Vlan\""+parseInt(TempList[1])+"\"不合法。");
			return false;
		}

		LanVlan = "Frm_VLAN"+i+"a";
		WanVlan = "Frm_VLAN"+i+"b";

		document.getElementById(LanVlan).value = TempList[0];
		document.getElementById(WanVlan).value = TempList[1];	
	}

	return true;
}
</script>

</head>

<!-------------------------------------------------------------------------------------->
<!--主页代码-->
<body topmargin="0" leftmargin="0" marginwidth="0" marginheight="0" alink="#000000" link="#000000" vlink="#000000" onLoad="on_init();">
	<blockquote>
	<table height="100%" cellspacing="0" cellpadding="0" border="0">
    	<tbody>
        <tr>
        <td valign="top">
        <!--解释头-->
        <div id="PromptPanel">
          <table width="100%" border="0" cellpadding="0" cellspacing="0">
            <tbody>
			<tr>
              <td height="5px"></td>
            </tr>
			<tr>
              <td class="prompt"><table width="100%" border="0" cellspacing="0" cellpadding="0">
                  <tbody><tr>
                    <td width="100%" class="title_01" style="padding-left: 10px;"> 您可以进行VLAN绑定的操作，VLAN的值以m1/n1 VLAN对方式设置, 其中m1代表用户侧的vlan,n1代表出接口的vlan, 多组VLAN对以逗号分开。 </td>
                  </tr>
                </tbody></table></td>
            </tr>
            <tr>
              <td height="5px"></td>
            </tr>
          </tbody></table>
        </div>
        
        <!--TODO:在这里加入你的具体页面展现-->
        <table border="1" id="Special_Table" width="100%" class="table1_bg">
          <tbody>
          <tr align="middle">
            <td class="table_title" width="10%">端口</td>
            <td class="table_title" width="15%">绑定模式</td>
            <td class="table_title" width="75%">VLAN绑定配置</td>
          </tr>
		</tbody>
		</table>
        
        <!--Apply和Cancel按钮-->
        <div id="TableUrlInfo" style="display:none">
        <form id="vmap" action=/boaform/admin/formVlanMapping method=POST name=vmap>
          <table class="table1_bg" border="1">
            <tbody>
            	<tr class="trTabConfigure">
              <td align="left" width="25%" class="table1_left">端口:
              </td><td class="table1_right"><div id="PortId"></div></td>
              </tr>
            
          </tbody></table>
          <table class="table1_bg" border="1">
            <tbody><tr class="trTabConfigure">
              <td align="left" width="25%" class="table1_left">端口模式:</td>
              <td class="table1_right"><select name="Frm_Mode" id="Frm_Mode" onchange="OnChooseDeviceType(this);">
                  <option value="1">VLAN绑定</option>
                  <option value="0">端口绑定</option>
                </select></td>
            </tr>
          </tbody></table>
          <div id="BindVlanRow">
            <table class="table1_bg" border="1">
              <tbody><tr class="trTabConfigure">
                <td width="25%" align="left" class="table1_left">绑定VLAN对:</td>
                <td class="table1_right"><input type="text" id="VlanPair" style="width:300px" maxlength="255"></td>
              </tr>
            </tbody></table>
          </div>
          <table id="ConfigPanelButtons" width="100%" cellspacing="1" class="table1_button">
            <tbody>
            <tr  align="center">
              <td class="table1_submit" style="padding-left: 5px"><input type="hidden" value="0" name="entryidx">
				<input type='hidden' id="Frm_Mode"   name="Frm_Mode"   type="text" value="">
				<input type='hidden' id="Frm_VLAN0a" name="Frm_VLAN0a" type="text" value="">
				<input type='hidden' id="Frm_VLAN0b" name="Frm_VLAN0b" type="text" value="">
				<input type='hidden' id="Frm_VLAN1a" name="Frm_VLAN1a" type="text" value="">
				<input type='hidden' id="Frm_VLAN1b" name="Frm_VLAN1b" type="text" value="">
				<input type='hidden' id="Frm_VLAN2a" name="Frm_VLAN2a" type="text" value="">
				<input type='hidden' id="Frm_VLAN2b" name="Frm_VLAN2b" type="text" value="">
				<input type='hidden' id="Frm_VLAN3a" name="Frm_VLAN3a" type="text" value="">
				<input type='hidden' id="Frm_VLAN3b" name="Frm_VLAN3b" type="text" value="">
				<input type='hidden' name=if_index ID=if_index value=''>
				<input type="hidden" name="submit-url" value="/net_vlan_mapping.asp">
				<button class="btnsaveup" name="save" onclick="javascript:return OnApplyButtonClick(this);">应用</button>
							 &nbsp;&nbsp;
				<button class="BtnCnl" name="save" onclick="javascript:OnCancelButtonClick();">取消</button>
				<input type="hidden" name="postSecurityFlag" value="">
            </tr>
          </tbody>
          </table>
          </form>
        </div>
      </td>
      </tr>
			</tbody>
			</table>
	<blockquote>
</body>
<%addHttpNoCache();%>
</html>

