<% cmccEnterpriseHtmlCommonHead(); %>

<style type="text/css">

</style>

<script type="text/javascript">

<% initProductInfo(); %>

var cgi = new Object();
<%init_dhcpmain_page();%>
var dmacips = new Array();
<% showMACBaseTable(); %>
cgi.ipv6linkaddr = "<% getInfo("ip6_ll"); %>";
cgi.PrefixMode =" <% getInfo("radvd-mode"); %>";
cgi.Prefix = "<% getInfo("V6prefix_ip"); %>";
cgi.Prefix_len = "<% getInfo("V6prefix_len"); %>";
cgi.PreferredLifetime = "<% getInfo("V6PreferredLifetime"); %>";
cgi.ValidLifetime = "<% getInfo("V6ValidLifetime"); %>";
cgi.RadvdEnable = "<% getInfo("V6RADVDEnable"); %>";
cgi.RaManageFlag = "<% getInfo("V6ManagedFlag"); %>";
cgi.RaOtherFlag = "<% getInfo("V6OtherConfigFlag"); %>";
cgi.RaMaxIntervalTime = "<% getInfo("V6MaxRtrAdvInterval"); %>";
cgi.RaMinIntervalTime = "<% getInfo("V6MinRtrAdvInterval"); %>";
cgi.Dhcp6sEnable = "<% getInfo("dhcpv6_mode"); %>";
cgi.Dhcp6sStart = "<% getInfo("dhcpv6s_min_address"); %>";
cgi.Dhcp6sEnd = "<% getInfo("dhcpv6s_max_address"); %>";
cgi.dns6type = <% getInfo("dns-mode"); %>;
cgi.ip6Dns1 = "<% getInfo("wan-dnsv61"); %>";
cgi.ip6Dns2 = "<% getInfo("wan-dnsv62"); %>";
</script>

<script type="text/javascript">
//<![CDATA[
Ont.CurMainMenu = "network";
Ont.CurSubMenu  = "dhcp";

function FreshTable()
{
	var table = "";

	table += '<table id = "MacIPTable" class="x_table">\n'
	table += '<tr>\n'
	table += '<th style="width: 45%;"><% multilang(LANG_MAC_ADDRESS);%></td>\n'
	table += '<th style="width: 45%;"><% multilang(LANG_IP_ADDRESS);%></td>\n'
	table += '<th style="width: 10%;"><% multilang(LANG_DELETE);%></td>\n'
	table += '</tr>\n'
	table += '</table>\n'

	
	$("#maciplist").val("");
	$("#MacIPTableContainer").html(table);
	
	$.each(dmacips, function(ii, iv) {
			var row = $("#MacIPTable").get(0).insertRow($("#MacIPTable").get(0).rows.length);
			iv.macAddr_Dhcp = RepalceAll(iv.macAddr_Dhcp);
			row.insertCell(row.cells.length).innerHTML = iv.macAddr_Dhcp;
			row.insertCell(row.cells.length).innerHTML = iv.ipAddr_Dhcp;
			row.insertCell(row.cells.length).innerHTML = '<input type="button" value="<% multilang(LANG_DELETE);%>" onclick="DeleteMacIPBind(this);" />';
	});
	
	$("#maciplist").val(JSON.stringify(dmacips));
	console.log(JSON.stringify(dmacips));
	RecalcHelpHeight();
}
function DeleteMacIPBind(r)
{
	var row = r.parentNode.parentNode.rowIndex;

	for (var i = row-1; i < dmacips.length; i++ )
	{
		dmacips[i] = dmacips[i+1];
	}
	dmacips.pop();
	FreshTable();
}
function RepalceAll(str)
{
	while(str.indexOf("-")>0)
	{
		str=str.replace("-",":");
	}
	return str;
}
function HaveSameBind(obj)
{
	var flag = 0;
	$.each(dmacips, function(mi, mv) {
		if(mv.macAddr_Dhcp == obj.macAddr_Dhcp)
		{
			flag = 1;			
			return false;
		}
		if(mv.ipAddr_Dhcp == obj.ipAddr_Dhcp)
		{
			flag = 2;			
			return false;
		}
	});
	
	return flag;
}

function AddMacIpBind()
{
	var obj = new Object();
	var macaddr;
	var ipaddr;
	var MACADDR;
	if(dmacips.length>=10)
	{	
		alert('<% multilang(LANG_RULE_EXCEED_10_CANNOT_ADD);%>！');
		return;
	}
	macaddr = $("#bindmacadd").val().toLowerCase();
	MACADDR = RepalceAll(macaddr);
	if (macaddr.length > 128)
	{
		alert( '<% multilang(LANG_MAC_ADDR_MUST_SMALL_128_CHAR);%>');
		return;
	}
	else if (macaddr == '')
	{
		alert( '<% multilang(LANG_PLEASE_INPUT);%><% multilang(LANG_MAC_ADDRESS);%>');
		return;
	}
	if(isValidMacAddress(MACADDR) == false)
	{
		alert('<% multilang(LANG_MAC_ADDRESS);%><% multilang(LANG_FORMAT);%>：XX:XX:XX:XX:XX:XX(0-9, a-f, A-F)');
		return;
	}
	
	ipaddr = $("#bindipadd").val();
	if (ipaddr == '')
	{
		alert( '<% multilang(LANG_PLEASE_INPUT);%><% multilang(LANG_IP_ADDRESS);%>');
		return;
	}	
	if(!isValidIpv4Address(ipaddr))
	{
		alert( '<% multilang(LANG_ERROR);%><% multilang(LANG_IP_ADDRESS);%>');
		return;
	}
	if(Ip2Num(ipaddr) < Ip2Num(cgi.dhcpRangeStart) || Ip2Num(ipaddr) > Ip2Num(cgi.dhcpRangeEnd))
	{
		alert( '<% multilang(LANG_IP_ADDR_MUST_BETWEEN);%>'+cgi.dhcpRangeStart+'～'+cgi.dhcpRangeEnd+'<% multilang(LANG_BETWEEN_STR);%>');
		return;
	}
	
	obj.macAddr_Dhcp = MACADDR;
	obj.ipAddr_Dhcp = ipaddr;
	var flag;
	if(flag = HaveSameBind(obj))
	{
		if(flag == 1)
			alert( '<% multilang(LANG_MAC_ADDR_BIND_BY_OTHER_IP_ADDR);%>');
		if(flag == 2)
			alert( '<% multilang(LANG_IP_ADDR_BIND_BY_OTHER_MAC_ADDR);%>');
		return;	
	}
	dmacips.push(obj);
	FreshTable();
}

function WebInit()
{
	dhcp_web_init();
	FreshTable();
	$("#macipbindadd").click(function(){	
		AddMacIpBind();	
	});

	$("#radvdenable").click(function() {
		ChangeRADVD();
	});
	
	$("#managed_flag_enable").click(function() {
		ChangeManagedFlag();
	});
	
	$("#other_flag_enable").click(function() {
		ChangeOtherFlag();
	});
	
	$("#dhcp6senable").click(function() {
		ChangeDHCP6S();
	});
	
	$("#dhcpenable").change(function() {
		ChangeDHCP();
	});
	
	$("#per_pd_prefix").change(function() {
		perPdPrefix();
	});
	
	$("#dnsv6type").change(function() {
		dnsv6TypeSel();
	});
	
	$("#btn_save_v4").click(function() {
		dhcp_web_v4_submit();
	});
	$("#btn_save_v6").click(function() {
		dhcp_web_v6_submit();
	});

	$("#v4DnsType").click(function() {
		ChangelanDnsType();
	});
}

function setSelectContent(sId, sValue)
{
		var item;
		if (null == (item = getElById(sId)))
		{
				//alert(sId + " is not existed" );
				//return false;
		}

		for (var i = 0; i < item.options.length; i++)
		{
		if (item.options[i].value == sValue)
				{

				item.selectedIndex = i;
				return true;
		}
	}
	//alert("the option which value is " + sValue + " is not existed in " + sId);
	//return false;
	return true;
}

function dhcp_web_init()
{
	var lease_time_minute; 

	lease_time_minute = parseInt(cgi.ulTime/60);
	$("#lanip").val(cgi.uIp);
	$("#lanmask").val(cgi.uMask);
	if (lease_time_minute == 1)
		$("#leasetimesel").get(0).selectedIndex = 0;
	else if (lease_time_minute == 60)
		$("#leasetimesel").get(0).selectedIndex = 1;
	else if (lease_time_minute == 10080)
		$("#leasetimesel").get(0).selectedIndex = 3;
	else
		$("#leasetimesel").get(0).selectedIndex = 2;
		
	$("#ipstart").val(cgi.dhcpRangeStart);
	$("#ipend").val(cgi.dhcpRangeEnd);
	
	$("#prefix").val(cgi.Prefix);
	$("#prefix_len").val(cgi.Prefix_len);
	//$("#parent_prefix").val(DhcpConfig.ParentPrefix);
	//$("#child_prefix_bits").val(DhcpConfig.ChildPrefix);
	$("#Dhcp6s_minaddr").val(cgi.Dhcp6sStart);
	$("#Dhcp6s_maxaddr").val(cgi.Dhcp6sEnd);
	var slash = cgi.ipv6linkaddr.indexOf('/');
	$("#ipv6linkaddr").val(cgi.ipv6linkaddr.substr(0,slash));
	
	//$("#dhcpenable").attr("checked", (cgi.uDhcpType == 1) ? true : false);
	if(cgi.dhcp_client_support == 1)
		$("<option></option>").val("3").text("启用DHCP Client").appendTo("#dhcpenable");
	$("#dhcpenable").val(cgi.uDhcpType);
	ChangeDHCP();
	
	$("#radvdenable").attr("checked", (cgi.RadvdEnable == "1") ? true : false);
	ChangeRADVD();
	
	$("#dhcp6senable").attr("checked", (cgi.Dhcp6sEnable=="DHCP Server") ? true : false);
	ChangeDHCP6S();
	
	$("#v4DnsType").attr("checked", (cgi.lanDnsType == 1) ? true : false);
	ChangelanDnsType();
	
	//if (DhcpConfig.wanIndex >= 0)
	//{
	//	var m = parseInt(DhcpConfig.wanIndex) + 1;
	//	var name = GetWanName(DhcpConfig.wan);
	//	if (Ont.CurLoginUser == 1)
	//	{
	//		name = "WAN" + m.toString();
	//	}
	//	$("#wan_conlist").empty();
	//	$("<option></option>").val(0).text(name).appendTo("#wan_conlist");
	//	$("#wan_dns_conlist").empty();
	//	$("<option></option>").val(0).text(name).appendTo("#wan_dns_conlist");
	//}

	var ifIdx = <% getInfo("prefix-delegation-wan-conn"); %>;
	setSelectContent('wan_conlist' , ifIdx);
	$("#managed_flag_enable").attr("checked", (cgi.RaManageFlag == "1") ? true : false);
	ChangeManagedFlag();
	
	$("#other_flag_enable").attr("checked", (cgi.RaOtherFlag=="1") ? true : false);
	ChangeOtherFlag();
	
	if (cgi.RaMaxIntervalTime == " " || parseInt(cgi.RaMaxIntervalTime) == 0)
	{
		cgi.RaMaxIntervalTime = 60;
	}
	if (cgi.RaMinIntervalTime == " " || parseInt(cgi.RaMinIntervalTime) == 0)
	{
		//RaMinIntervalTime = 0.33*parseInt(RaMaxIntervalTime);
		cgi.RaMinIntervalTime = 18;
	}
	$("#ra_max_interval_time").val(cgi.RaMaxIntervalTime);
	$("#ra_min_interval_time").val(cgi.RaMinIntervalTime);
	$("#per_pd_prefix").get(0).selectedIndex = cgi.PrefixMode;
	$("#dnsv6type").get(0).selectedIndex = cgi.dns6type;
	$("#primary_dns").val(cgi.ip6Dns1);
	$("#secondary_dns").val(cgi.ip6Dns2);
	$("#lanDns1").val(cgi.lan_dns1);
	$("#lanDns2").val(cgi.lan_dns2);
	
	perPdPrefix();
	dnsv6TypeSel();
	if (Ont.ProtocolVer == 1)
	{
		$("#lan_ipv6").hide();
	}
}

function ChangeRADVD()
{
	if ($("#radvdenable").prop("checked") == true)
	{
		//$("#range_start").attr("disabled", false);
		//$("#range_end").attr("disabled", false);
   		$("#radvdvalue").val("1");
		$("#managed_flag_enable").attr("disabled", false);
		$("#other_flag_enable").attr("disabled", false);
		$("#ra_max_interval_time").attr("disabled", false);
		$("#ra_min_interval_time").attr("disabled", false);
	}
	else
	{
		//$("#range_start").attr("disabled", true);
		//$("#range_end").attr("disabled", true);
		$("#radvdvalue").val("0");
		$("#managed_flag_enable").attr("disabled", true);
		$("#other_flag_enable").attr("disabled", true);
		$("#ra_max_interval_time").attr("disabled", true);
		$("#ra_min_interval_time").attr("disabled", true);
	}
	return true;
}

function ChangeDHCP6S()
{
	if ($("#dhcp6senable").prop("checked") == true)
	{
		$("#Dhcp6s_minaddr").attr("disabled", false);
		$("#Dhcp6s_maxaddr").attr("disabled", false);
   		$("#Dhcp6svalue").val("2");
	}
	else
	{
		$("#Dhcp6s_minaddr").attr("disabled", true);
		$("#Dhcp6s_maxaddr").attr("disabled", true);
		$("#Dhcp6svalue").val("0");
	}
	return true;
}

function ChangeOtherFlag()
{
	if ($("#other_flag_enable").prop("checked") == true)
	{
   		$("#other_flag_value").val("1");
	}
	else
	{
		$("#other_flag_value").val("0");
	}
	return true;
}

function ChangeManagedFlag()
{
	if ($("#managed_flag_enable").prop("checked") == true)
	{
   		$("#managed_flag_value").val("1");
	}
	else
	{
		$("#managed_flag_value").val("0");
	}
	return true;
}

function ChangeDHCP()
{
	if ($("#dhcpenable").val() == "1")
	{
   		$("#dhcpvalue").val("1");
		$("#leasetime").attr("disabled", false);

		$("#ipstart").attr("disabled", false);
		$("#ipend").attr("disabled", false);
	}
	else
	{
		$("#dhcpvalue").val($("#dhcpenable").val());
		$("#leasetime").attr("disabled", true);

		$("#ipstart").attr("disabled", true);
		$("#ipend").attr("disabled", true);
	}
	return true;
}

function ChangelanDnsType()
{
	if ($("#v4DnsType").prop("checked") == true)
	{
		$("#lanDnsType").val("1");
		$("#lanDns1").attr("disabled", false);
		$("#lanDns2").attr("disabled", false);
	}
	else
	{
		$("#lanDnsType").val("0");
		$("#lanDns1").attr("disabled", true);
		$("#lanDns2").attr("disabled", true);
	}
	return true;
}

function CheckIpRange()
{
	var startip = $("#ipstart").val();
	var endip = $("#ipend").val();
	var lanip = $("#lanip").val();
	var lanmask = $("#lanmask").val();

	if (!isValidIpv4Address(startip))
	{
		alert("<% multilang(LANG_PLEASE_INPUT_VALID_START_IPADDR);%>！");
		$("#ipstart").focus();
		return false;
	}

	if (!isValidIpv4Address(endip))
	{
		alert("<% multilang(LANG_PLEASE_INPUT_VALID_END_IPADDR);%>！");
		$("#ipend").focus();
		return false;
	}

	var nsip = Ip2Num(startip);
	var neip = Ip2Num(endip);
	var nlip = Ip2Num(lanip);
	var nmask = Ip2Num(lanmask);
	var nsubnet = (nlip&nmask);

	if ((nsip&nmask) != nsubnet)
	{
		alert("<% multilang(LANG_START_IP_DUPLICT_WITH_LAN_IP);%>!");
	   	$("#ipstart").focus();
		return false;
	}

	if ((neip&nmask) != nsubnet)
	{
		alert("<% multilang(LANG_END_IP_DUPLICT_WITH_LAN_IP);%>!");
	   	$("#ipend").focus();
		return false;
	}

	if (nsip > neip)
	{
		alert("<% multilang(LANG_PLEASE_INPUT_VALID_START_IPADDR);%>!");
		$("#ipend").focus();
		return false;
	}

	if (nsip == nlip)
	{
		alert("<% multilang(LANG_PLEASE_INPUT_VALID_START_IPADDR);%>！");
		$("#ipstart").focus();
		return false;
	}

	if (neip == nlip)
	{
		alert("<% multilang(LANG_PLEASE_INPUT_VALID_START_IPADDR);%>！");
		$("#ipend").focus();
		return false;
	}

	return true;
}

function IsValidLanIp()
{
	var lanip = $("#lanip").val();
	if (!isValidIpAddress(lanip))
	{
		return false;
	}

	var ip4 = lanip.split('.');
	var num = parseInt(ip4[0]);
	if (num == 0 || num == 127 || num > 223)
	{
		return false;
	}
	
	num = parseInt(ip4[3]);
	if (num == 0 || num == 255)
	{
		return false;
	}
	
	return true;
}

function IsValidMask()
{
	var mask = $("#lanmask").val();
	if (!isValidIpAddress(mask))
	{
		return false;
	}

	var ip4 = mask.split('.');
	var nip = 0;
	for (var i = 0; i < 4; i++)
	{
		nip = nip*256 + parseInt(ip4[i]);
	}

	var bits = 0;
	for (var i = 0; i < 32; i++)
	{
		if ((nip&(1<<i)) != 0)
		{
			bits++;
		}
	}

	var zbits = 32 - bits;
	for (var i = 0; i < zbits; i++)
	{
		if ((nip&(1<<i)) != 0)
		{
			return false;
		}
	}

	return true;
}

function perPdPrefix()
{
	$("#div_child_prefix").hide();
	var index = $("#per_pd_prefix").get(0).selectedIndex;
	$("#preferred_lifetime").val(cgi.PreferredLifetime);
	$("#valid_lifetime").val(cgi.ValidLifetime);
	if (index == 0)
	{
		$("#waninfo").show();
		$("#pd_set").hide();
		$("#preferred_lifetime").attr("disabled", true);
		$("#valid_lifetime").attr("disabled", true);
	}
	else if (index == 1)
	{
		$("#waninfo").hide();
		$("#pd_set").show();
		$("#preferred_lifetime").attr("disabled", false);
		$("#valid_lifetime").attr("disabled", false);
	}
	RecalcHelpHeight();
}

function dnsv6TypeSel()
{
	var index = $("#dnsv6type").get(0).selectedIndex;
	if (0 == index)
	{
		$("#waninfo_dns").hide();
		$("#dns_info").hide();
	}

	else if (1 == index)
	{
		$("#waninfo_dns").show();
		$("#dns_info").hide();
	}
	else if (2 == index)
	{
		$("#waninfo_dns").hide();
		$("#dns_info").show();
	}
	RecalcHelpHeight();
}

function isValidIpv6Prefix(prefix)
{
	var parts1 = prefix.split('/');
	if (parts1.length > 2)	return false;
	
	var part2 = prefix.split('::'); 
	if (part2.length != 2)	return false;
	
	var ipParts = part2[0].split(':');
	if (ipParts.length > 4|| part2[0] == '')	return false;

	return true;
}

function dhcp_web_v4_submit()
{
	if (!IsValidLanIp())
	{
		alert("<% multilang(LANG_PLEASE_INPUT_VALID);%> LAN <% multilang(LANG_IP_ADDRESS);%>!");
		$("#lanip").focus();
		return false;
	}

	if (!IsValidMask())
	{
		alert("<% multilang(LANG_PLEASE_INPUT_VALID);%> LAN <% multilang(LANG_SUBNET_MASK);%>!");
		$("#lanmask").focus();
		return false;
	}

	if ($("#dhcpvalue").val()=="1")
	{
		var selindex = $("#leasetimesel").get(0).selectedIndex;
		if (selindex == 0)
			$("#leasetime").val(1*60);
		else if (selindex == 1)
			$("#leasetime").val(60*60);
		else if (selindex == 2)
			$("#leasetime").val(1440*60);
		else if (selindex == 3)
			$("#leasetime").val(10080*60);

		if (!CheckIpRange())
		{
			return false;
		}
	}

	if ($("#lanDnsType").val()=="1")
	{
	var LanDns1 = $("#lanDns1").val();
	var LanDns2 = $("#lanDns2").val();
	if (LanDns1 == '')
	{
		alert( "<% multilang(LANG_PLEASE_INPUT);%><% multilang(LANG_IP_ADDRESS);%>");
		$("#lanDns1").focus();
		return;
	}	
	if (!isValidIpv4Address(LanDns1))
	{
		alert("<% multilang(LANG_PLEASE_INPUT_VALID);%><% multilang(LANG_PRIMARY_DNS);%>！");
		$("#lanDns1").focus();
		return false;
	}

	if (LanDns2!= '' && !isValidIpv4Address(LanDns2))
	{
		alert("<% multilang(LANG_PLEASE_INPUT_VALID);%><% multilang(LANG_SECONDARY_DNS);%>！");
		$("#lanDns2").focus();
		return false;
	}

	}
	$("#XForm_v4").submit();

}
function dhcp_web_v6_submit()
{
	$("#per_pd_prefix_sel").val($("#per_pd_prefix").get(0).selectedIndex);
	var prefix_sel = $("#per_pd_prefix_sel").val();
	
	$("#dnsv6_type_sel").val($("#dnsv6type").get(0).selectedIndex);

	var prefix_value = $("#prefix").val();

	if (prefix_sel == 1 && !isValidIpv6Prefix(prefix_value))
	{
		alert("<% multilang(LANG_INVALID_IPV6_PREFIX);%>！");
		$("#prefix").focus();
		return false;
	}
	if ($("#prefix_len").val()>64 || $("#prefix_len").val()<0)
	{
		alert("<% multilang(LANG_MAPE_IPV6_PREFIX_INVALID_LEN);%>！");
		$("#prefix_len").focus();
		return false;
	}
	
	var max_interval_time = $("#ra_max_interval_time").val();
	var min_interval_time = $("#ra_min_interval_time").val();
	if (max_interval_time == "" || parseInt(max_interval_time) < 4 || parseInt(max_interval_time) > 1800)
	{
		alert("<% multilang(LANG_MIN_INTERVAL_TIME_3_1350,);%>！");
		$("#ra_max_interval_time").focus();
		return false;
	}
	
	if (min_interval_time=="" || parseInt(min_interval_time) < 3 || parseInt(min_interval_time) > 1350)
	{
		alert("<% multilang(LANG_MIN_INTERVAL_TIME_3_1350);%>！");
		$("#ra_min_interval_time").focus();
		return false;
	}
	var suffix_minaddr = $("#Dhcp6s_minaddr").val();
	var suffix_maxaddr = $("#Dhcp6s_maxaddr").val();
	if (!("" == suffix_minaddr && "" == suffix_maxaddr))
	{
		if ((isValidSuffix(suffix_minaddr) == false) || (isValidSuffix(suffix_maxaddr) == false))
		{
			alert("<% multilang(LANG_IPV6_END_PREFIX_ILLEGAL);%>！");
			$("#Dhcp6s_minaddr").focus();
			return false;
		}
		if (compareIpv6Addr(suffix_minaddr, suffix_maxaddr) < 1)
		{
			alert("<% multilang(LANG_IPV6_START_PREFIX_CANNOT_BIG_THAN_END_PREFIX);%>！");
			$("#Dhcp6s_minaddr").focus();
			return false;
		}
	}
	if ($("#dnsv6type").get(0).selectedIndex == 2)
	{
		if ("" == $("#primary_dns").val())
		{
			alert("Primary DNS <% multilang(LANG_CAN_NOT_EMPTY);%>！");
			$("#primary_dns").focus();
			return false;
		}
		if ("" == $("#secondary_dns").val())
		{
			alert("Secondary DNS <% multilang(LANG_CAN_NOT_EMPTY);%>！");
			$("#secondary_dns").focus();
			return false;
		}
	}
	$("#preferred_lifetime").attr("disabled", false);
	$("#valid_lifetime").attr("disabled", false);
	//$("#ipv6_wanindex").val(DhcpConfig.wanIndex);

	$("#XForm_v6").submit();
}

//]]>
</script>

<script type="text/javascript">

$(function() {
	//if (window.top.location.href == window.location.href)
	//{
	//	window.location.href = "/index.html";
	//	return;
	//}
	$("#submit-url_v4").ready(function(){
		$("#submit-url_v4").val(window.location.href);
	});
	$("#submit-url_v6").ready(function(){
		$("#submit-url_v6").val(window.location.href);
	});
	$.each(Ont.MainMenu, function(mi, mv){
		if (mv.id == Ont.CurMainMenu)
		{
			/*
			if (mv.id == "help")
			{
				initHelpMenu(mv.submenu);
			}
			*/
			$.each(mv.submenu, function(smi, smv){
				if (smv.id == Ont.CurSubMenu)
				{
					if (!isSubMenuShow(smv))
					{
					//	window.top.location.href = "/admin/login.asp";
					}
					//return false;
				}
			});
			return false;
		}
	});

	window.Ont.InitProvince();

	WriteMainMenu();
	WriteSubMenu();
	WebInit();
	initMainContent();

	$S("XWebPageName", Ont.CurSubMenu);
	$("#XForm_v4").attr("action", "/boaform/admin/formdhcpv4_cmcc_ent");
	$("#XForm_v6").attr("action", "/boaform/admin/formdhcpv6_cmcc_ent");

	setTimeout(function(){window.top.location.href = "logout.html";}, Ont.LogoutTimeout);
	
	$("#logout").click(function() {
		window.top.location.href = "logout.html";
	});
	
	$("#btn_cancel_v4").click(function() {
		onCancel();
	});
	$("#btn_cancel_v6").click(function() {
		onCancel();
	});

	$("#login_username").html(Ont.CurUserName);
	$("#logout").html(Ont.StrLogout);
	//$("#ont_name").html(Ont.StrOntName);
	//$("#ont_model").html(Ont.StrOntModel.replace("/(^_*)|(_*$)/g", ""));

	$(".x_table tr:nth-child(even)").addClass("even");
	$(".x_table tr:nth-child(odd)").addClass("odd");
	var webdevicename=Ont.Webdevicename + "<% multilang(LANG_INTEGRATED_ENTERPRISE_GATEWAY);%>";
	$("#device_name").html(webdevicename);
});

function onCancel()
{
	window.location.reload();
}

</script>
</head>
<body id="x_root_body">

<div id="header">
	<div id="logo"></div>
	<div id="header_info">
		<div id="dev_info"><% multilang(LANG_TERM_MODEL);%>：<span id="device_name"></span></div>
		<div id="user_info"><% multilang(LANG_WELCOME);%>，<span id="login_username"></span>
		<a href="#" id="logout"></a>
		</div>
	</div>
</div>

<div id="menu">
	<div id="main_menu"></div>
</div>

<div id="container">

<div id="nav">
	<div id="nav_header"></div>
	<div id="sub_menu"></div>
</div>

<div id="maincontent">

<div id="content">
<div id="errmessage" class="x_message"></div>



<script type="text/javascript">WriteMainTitle("IPv4 <% multilang(LANG_CONFIGURATION);%>", "lan_ipv4");</script>
<div id="x_lan_ipv4" class="x_main_content">
<form id="XForm_v4" name="XForm_v4" method="post" action="">

<div class="x_sub_title"><% multilang(LANG_LAN);%>（LAN <% multilang(LANG_WLAN_SCHEDULE_APPLY);%>）</div>
<div class="x_form_area">
	<ul class="x_form_line" onmouseover="$H('<% multilang(LANG_IMPORT);%><% multilang(LANG_IP_ADDRESS);%>');" onmouseout="$H();">
		<li class="x_form_caption">LAN<% multilang(LANG_IP_ADDRESS);%>：</li>
		<li class="x_form_input">
		          <input name="uIp" id="lanip" type="text" style="width:120px" value="" maxlength="15" onkeypress="return OnKeyPress(event, X_INPUT_IP);" />
	    </li>
	</ul>
	<ul class="x_form_line" onmouseover="$H('<% multilang(LANG_IMPORT);%><% multilang(LANG_SUBNET_MASK);%>');" onmouseout="$H();">
		<li class="x_form_caption">IP<% multilang(LANG_SUBNET_MASK);%>：</li>
		<li class="x_form_input">
		          <input name="uMask" id="lanmask" type="text"  style="width:120px" value="" maxlength="15" onkeypress="return OnKeyPress(event, X_INPUT_IP);" />
	   </li>
	</ul>
	
<script type="text/javascript">WriteDivideLine();</script>

	<ul class="x_form_line" onmouseover="$H('<% multilang(LANG_WLAN_SCHEDULE_ENA);%><% multilang(LANG_DNS_TRANSPRENT);%>');" onmouseout="$H();">
		<li class="x_form_caption"><% multilang(LANG_DNS_TRANSPRENT);%>：</li>
		<li class="x_form_input"><input id="v4DnsType" name="v4DnsType" type="checkbox" /><input type="hidden" name="lanDnsType" id="lanDnsType" /></li>
	</ul>
	<ul class="x_form_line" onmouseover="$H('<% multilang(LANG_IMPORT);%> LAN <% multilang(LANG_PRIMARY_DNS_SERVER);%>');" onmouseout="$H();">
		<li class="x_form_caption">LAN <% multilang(LANG_PRIMARY_DNS_SERVER);%>：</li>
		<li class="x_form_input">
		          <input name="lanDns1" id="lanDns1" type="text" style="width:120px" value="" maxlength="15" onkeypress="return OnKeyPress(event, X_INPUT_IP);" />
	    </li>
	</ul>
	<ul class="x_form_line" onmouseover="$H('<% multilang(LANG_IMPORT);%> LAN <% multilang(LANG_SECONDARY_DNS);%>');" onmouseout="$H();">
		<li class="x_form_caption">LAN <% multilang(LANG_SECONDARY_DNS);%>：</li>
		<li class="x_form_input">
		          <input name="lanDns2" id="lanDns2" type="text"  style="width:120px" value="" maxlength="15" onkeypress="return OnKeyPress(event, X_INPUT_IP);" />
	   </li>
	</ul>

<script type="text/javascript">WriteDivideLine();</script>

	<ul class="x_form_line" onmouseover="$H('<% multilang(LANG_WLAN_SCHEDULE_ENA);%> DHCP <% multilang(LANG_SERVER1);%>');" onmouseout="$H();">
		<li class="x_form_caption"><% multilang(LANG_ELINK_ENABLE);%>DHCP：</li>
		<li class="x_form_input"><input type="hidden" name="uDhcpType" id="dhcpvalue" />
			<select id="dhcpenable" name="dhcpenable">
				<option value="0"><% multilang(LANG_ELINK_DISABLE);%></option>
				<option value="1"><% multilang(LANG_ELINK_ENABLE);%> DHCP Server</option>
			</select>
		</li>
	</ul>
	<ul class="x_form_line" onmouseover="$H('<% multilang(LANG_PLEASE_INPUT_DHCP_LEASE_TIME);%>');" onmouseout="$H();">
		<li class="x_form_caption"><% multilang(LANG_MAX_LEASE_TIME);%>：</li>
		<li class="x_form_input"><input name="ulTime" id="leasetime" type="hidden" />
		<select id="leasetimesel" name="leasetimesel">
			<option value="0" >1<% multilang(LANG_MINUTES);%></option>
			<option value="1" >1<% multilang(LANG_HOUR1);%></option>
			<option value="2" selected="selected">1<% multilang(LANG_WLAN_SCHEDULE_DAYS);%></option>
			<option value="3" >1<% multilang(LANG_WEEK);%></option>
		</select>
		</li>
	</ul>

<script type="text/javascript">WriteDivideLine();</script>

	 <ul class="x_form_line" onmouseover="$H('<% multilang(LANG_IP_ADDRESS_RANGE);%>');" onmouseout="$H();">
		<li class="x_form_caption"><% multilang(LANG_IP_ADDRESS_RANGE);%>：</li>
		<li class="x_form_input">
		<input id="ipstart" name="dhcpRangeStart" type="text" value="" disabled="disabled" style="width:120px" maxlength="15" onkeypress="return OnKeyPress(event, X_INPUT_IP);" />
		～
		<input id="ipend" name="dhcpRangeEnd" type="text" value="" disabled="disabled"  style="width:120px" maxlength="15" onkeypress="return OnKeyPress(event, X_INPUT_IP);" /></li>
	</ul>
	
<script type="text/javascript">WriteDivideLine();</script>

	<ul class="x_form_line" onmouseover="$H('<% multilang(LANG_RESVER_IP_ADDR_LIST);%>:');" onmouseout="$H();">
		<li class="x_form_caption"><% multilang(LANG_RESVER_IP_ADDR_LIST);%>:
		</li>
	</ul>
	 <ul class="x_form_line" onmouseover="$H('');" onmouseout="$H();">
		<li class="x_form_caption"><% multilang(LANG_MAC_ADDRESS);%>：</li>
		<li class="x_form_input"><input id="bindmacadd" style="width:160px" onkeypress="return OnKeyPress(event, X_INPUT_MAC);" type="text"></li>
	</ul>
   	<ul class="x_form_line" onmouseover="$H('');" onmouseout="$H();">
		<li class="x_form_caption"><% multilang(LANG_IP_ADDRESS);%></li>
		<li class="x_form_input"><input id="bindipadd" style="width:160px" onkeypress="return OnKeyPress(event, X_INPUT_IP);" type="text"></li>
	</ul>
  
	<ul class="x_form_line" onmouseover="$H('<% multilang(LANG_ADD_MAC_FILTER_LIST);%>');" onmouseout="$H();">
		<li class="x_form_caption"></li>
		<li class="x_form_input"><input id="macipbindadd" class="btn_save" style="width: 80px;" value="<% multilang(LANG_ADD);%>" type="button">
		<input id="maciplist" name="maciplist" value="[]" type="hidden">
	</ul>
<br>
<div class="x_sub_title"><% multilang(LANG_RESVER_IP_ADDR);%></div>
			<div id="MacIPTableContainer">
			</div>


</div>
<div id="div_save" class="x_form_save">
	<input type="button" id="btn_save_v4" class="btn_save" value="<% multilang(LANG_CONFIRM);%>" />
	<input type="button" id="btn_cancel_v4" class="btn_cancel" value="<% multilang(LANG_CANCEL);%>" />
	<input id="submit-url_v4" type="hidden" name="submit-url" value="">
</div>
</form>

</div>
<script type="text/javascript">WriteMainTitle("IPv6 <% multilang(LANG_CONFIGURATION);%>", "lan_ipv6");</script>
<div id="x_lan_ipv6" class="x_main_content">

<div class="x_sub_title"><% multilang(LANG_LAN);%>（IPv6）<% multilang(LANG_CONFIGURATION);%></div>
<div class="x_form_area">
<form id="XForm_v6" name="XForm_v6" method="post" action="">
	<input type="hidden" name="ipv6_wanindex" id="ipv6_wanindex"/>
	<ul class="x_form_line" onmouseover="$H('');" onmouseout="$H();">
		<li class="x_form_caption"><% multilang(LANG_IPV6_ADDRESS2);%>：</li>
		<li class="x_form_input">
			<input id="ipv6linkaddr" name="ipv6linkaddr" type="text" value=""  style="width:180px"/>
		</li>
	</ul>

	<ul class="x_form_line" onmouseover="$H('<% multilang(LANG_PREFIX_MODE1);%>.');" onmouseout="$H();">
		<li class="x_form_caption"><% multilang(LANG_PREFIX_MODE1);%>：</li>
		<li class="x_form_input"><select id="per_pd_prefix" name="per_pd_prefix">	
		<option value="0" selected="selected">AUTO</option>
		<option value="1" >Static</option></select>
		<input type="hidden" name="per_pd_prefix_sel" id="per_pd_prefix_sel" /></li>
	</ul>

	<ul id="waninfo" class="x_form_line" onmouseover="$H('');" onmouseout="$H();">
		<li class="x_form_caption"><% multilang(LANG_WAN_LIST);%>：</li>
			<li class="x_form_input" >
				<select id="wan_conlist" style="width:140px" name="wan_conlist">
					<% if_wan_list("rtv6"); %>
				</select>
				<!---
				<input id="parent_prefix" name="parent_prefix" type="text" value=""  style="width:170px" maxlength="48" readonly="true" />
				--->
			</li>
	</ul>
	<div id="prefix_info">
	<ul id="pd_set" class="x_form_line" onmouseover="$H('IPv6 <% multilang(LANG_IPV6_ADDR_PREFIX);%>，<% multilang(LANG_EXAMPLE);%>2000:0:0:1::/64 <% multilang(LANG_OR);%> 2001::，<% multilang(LANG_PREFIX_LENGTH_BEWTEEN_48_64);%>');" onmouseout="$H();">
		<li class="x_form_caption"><% multilang(LANG_PREFIX_CONFIGURATION);%>:</li>
		<li class="x_form_input"><input id="prefix" name="prefix" type="text" value=""  style="width:180px" maxlength="48"  /> / <input id="prefix_len" name="prefix_len" type="text" value=""  style="width:40px" maxlength="2"  />
		</li>
	</ul>
	
	<ul class="x_form_line" onmouseover="$H('<% multilang(LANG_PREFIX_PERFERR_TIME);%>');" onmouseout="$H();">
		<li class="x_form_caption"><% multilang(LANG_PREFIX_PERFERR_TIME);%>：</li>
		<li class="x_form_input">
		<input id="preferred_lifetime" name="preferred_lifetime" type="text" value=""  style="width:48px"/><% multilang(LANG_SECONDS);%>
		</li>
	</ul> 
	
	<ul class="x_form_line" onmouseover="$H('<% multilang(LANG_PREFIX_VALID_TIME);%>');" onmouseout="$H();">
		<li class="x_form_caption"><% multilang(LANG_PREFIX_VALID_TIME);%>：</li>
		<li class="x_form_input">
		<input id="valid_lifetime" name="valid_lifetime" type="text" value=""  style="width:48px"/><% multilang(LANG_SECONDS);%>
		</li>
	</ul>
	</div>

<script type="text/javascript">WriteDivideLine();</script>

	<ul class="x_form_line" onmouseover="$H('<% multilang(LANG_WLAN_SCHEDULE_ENA);%>RADVD<% multilang(LANG_SERVER1);%>');" onmouseout="$H();">
		<li class="x_form_caption"><% multilang(LANG_ENABLE);%>RADVD:</li>
		<li class="x_form_input"><input id="radvdenable" name="radvdenable" type="checkbox" />
								<input type="hidden" name="radvdvalue" id="radvdvalue" /></li>
	</ul>
	<div id="radvd_info">
	<ul class="x_form_line" onmouseover="$H('<% multilang(LANG_DEVICE_M_FLAG_TYPE);%>M');" onmouseout="$H();">
		<li class="x_form_caption">M<% multilang(LANG_FLAG_TYPE);%>:</li>
		<li class="x_form_input"><input id="managed_flag_enable" name="managed_flag_enable" type="checkbox" />
								<input type="hidden" name="managed_flag_value" id="managed_flag_value" /></li>
	</ul>
	<ul class="x_form_line" onmouseover="$H('<% multilang(LANG_DEVICE_O_FLAG_TYPE);%>O');" onmouseout="$H();">
		<li class="x_form_caption">O<% multilang(LANG_FLAG_TYPE);%>:</li>
		<li class="x_form_input"><input id="other_flag_enable" name="other_flag_enable" type="checkbox" />
								<input type="hidden" name="other_flag_value" id="other_flag_value" /></li>
	</ul>	
	<ul class="x_form_line" onmouseover="$H('<% multilang(LANG_RA_INTERVAL_MSG);%>');" onmouseout="$H();">
		<li class="x_form_caption">RA<% multilang(LANG_MAX_INTERVAL_VALUE);%>:</li>
		<li class="x_form_input">
		  <input id="ra_max_interval_time" name="ra_max_interval_time" type="text" value=""  style="width:60px" maxlength="48"  />  <% multilang(LANG_SECONDS);%>
		</li>
	</ul>
	<ul class="x_form_line" onmouseover="$H('<% multilang(LANG_RA_INTERVAL_MAX_MIN_MSG);%>');" onmouseout="$H();">
		<li class="x_form_caption">RA<% multilang(LANG_MIN_INTERVAL_VALUE);%>:</li>
		<li class="x_form_input">
		  <input id="ra_min_interval_time" name="ra_min_interval_time" type="text" value=""  style="width:60px" maxlength="48"  />  <% multilang(LANG_SECONDS);%>
		</li>
	</ul>
	</div>
	
<script type="text/javascript">WriteDivideLine();</script>

	<ul class="x_form_line" onmouseover="$H('<% multilang(LANG_WLAN_SCHEDULE_ENA);%>DHCPv6<% multilang(LANG_SERVER1);%>');" onmouseout="$H();">
		<li class="x_form_caption"><% multilang(LANG_ENABLE);%>DHCP6S:</li>
		<li class="x_form_input"><input id="dhcp6senable" name="dhcp6senable" type="checkbox" />
								<input type="hidden" name="Dhcp6svalue" id="Dhcp6svalue" /></li>
	</ul>

<div id="div_child_prefix">
	<ul class="x_form_line" onmouseover="$H('');">
		<li class="x_form_caption">CHILD_PREFIX_BITS：</li>
		<li class="x_form_input">
		<input id="child_prefix_bits" name="child_prefix_bits" type="text" value="ffff:ffff:ffff:ff01::/64"  style="width:170px" maxlength="48"  />
		</li>
	</ul>
</div>

<div id="div_prefix">
	<ul class="x_form_line" onmouseover="$H('IPv6<% multilang(LANG_ADDR_BACK_PREFIX);%>，<% multilang(LANG_EXAMPLE);%>0:1:2:3');" onmouseout="$H();">
		<li class="x_form_caption">IPv6<% multilang(LANG_ADDR_BACK_PREFIX_START);%>:</li>
		<li class="x_form_input">
		<input id="Dhcp6s_minaddr" name="Dhcp6s_minaddr" type="text" value=""  style="width:180px" maxlength="48"  />
		</li>
	</ul>
	<ul class="x_form_line" onmouseover="$H('IPv6<% multilang(LANG_ADDR_BACK_PREFIX);%>，<% multilang(LANG_EXAMPLE);%>0:1:2:3');" onmouseout="$H();">
		<li class="x_form_caption">IPv6<% multilang(LANG_ADDR_BACK_PREFIX_END);%>:</li>
		<li class="x_form_input">
		<input id="Dhcp6s_maxaddr" name="Dhcp6s_maxaddr" type="text" value=""  style="width:180px" maxlength="48"  />
		</li>
	</ul>
</div>

<script type="text/javascript">WriteDivideLine();</script> 

	<ul class="x_form_line" onmouseover="$H('DNSV6 <% multilang(LANG_WLAN_SCHEDULE_APPLY);%>');" onmouseout="$H();">
		<li class="x_form_caption">DNSv6 <% multilang(LANG_SOURCE1);%>：</li>
		<li class="x_form_input"><select id="dnsv6type" name="dnsv6type">	
		<option value="0" >HGWProxy</option>
		<option value="1">WANConnection</option>
		<option value="2" >Static</option></select>
		<input type="hidden" name="dnsv6_type_sel" id="dnsv6_type_sel" /></li>
	</ul>

<div id="dns_relay_info">
	<ul id="waninfo_dns" class="x_form_line" onmouseover="$H('');" onmouseout="$H();">
		<li class="x_form_caption">WAN <% multilang(LANG_CONNECT_STR);%>：</li>
		<li class="x_form_input" >
			<select id="wan_dns_conlist" style="width:140px" name="wan_dns_conlist">
					<% if_wan_list("rtv6"); %>
			</select>
		</li>
	</ul>
	<div id="dns_info">
		<ul class="x_form_line" onmouseover="$H('');" onmouseout="$H();">
			<li class="x_form_caption"><% multilang(LANG_PRIMARY_DNS);%>：</li>
			<li class="x_form_input">
				<input id="primary_dns" name="primary_dns" type="text" value=""  style="width:180px" onkeypress="return OnKeyPress(event, X_INPUT_IPV6);"/>
			</li>
		</ul> 
	
		<ul class="x_form_line" onmouseover="$H('');" onmouseout="$H();">
			<li class="x_form_caption"><% multilang(LANG_SECONDARY_DNS);%> ：</li>
			<li class="x_form_input">
				<input id="secondary_dns" name="secondary_dns" type="text" value=""  style="width:180px" onkeypress="return OnKeyPress(event, X_INPUT_IPV6);"/>
			</li>
		</ul>
	</div>

</div>

</div>
<div id="div_save" class="x_form_save">
	<input type="button" id="btn_save_v6" class="btn_save" value="确定<% multilang();%>" />
	<input type="button" id="btn_cancel_v6" class="btn_cancel" value="取消<% multilang();%>" />
	<input id="submit-url_v6" type="hidden" name="submit-url" value="">
</div>
</form>

</div>



<div style="clear:both;"></div>

</div> <!-- end of div[content] -->

</div>

</div>

</body>
</html>


