<% cmccEnterpriseHtmlCommonHead();%>
<link rel="stylesheet" type="text/css" href="/style/ip_qos.css">

<script type="text/javascript">

<% initProductInfo(); %>

var IpQosConfig = {
	qosServList: [{}, {}, {}, {}, {}],
	qosQueueList: [],
	qosPqList: [],
	usRateCtlLanList: [],
	usRateCtlVlanList: [],
	usRateCtlIpList: [],
	dsRateCtlLanList: [],
	dsRateCtlVlanList: [],
	dsRateCtlIpList: []
};
var WanList = new Array();
<% cmccEnterpriseHtmlIPQosInitPage();%>
</script>

<script type="text/javascript">
//<![CDATA[

Ont.CurMainMenu = "network";
Ont.CurSubMenu  = "ip_qos";
var strServiceList = new Array("", "TR069", "VOIP", "IPTV", "OTHER", "INTERNET");
var strEtherType = new Array("IPv4", "IPv6", "All");
//var strProtoType = new Array("All", "TCP", "UDP", "ICMP","TCP & UDP","RTP","ICMPv6");
var strLanPortList = new Array("LAN1", "LAN2", "LAN3", "LAN4", "SSID1", "SSID2", "SSID3", "SSID4");

/*
var aryProtocolType = {
	NET_PROTO_ALL: 0,
	NET_PROTO_TCP: 1,
	NET_PROTO_UDP: 2,
	NET_PROTO_ICMP: 3,
	NET_PROTO_TCP_UDP: 4,
	NET_PROTO_RTP: 5,
	NET_PROTO_ICMPV6: 6,
	NET_PROTO_NONE: 7
};
*/
function WebInit()
{
	ip_qos_web_init();
		
	$("#qos_mode").change(function() {
		onQosMode();
	});
		
	$("#serv_rule").change(function() {
		onServRule();
	});
	
	$("#pq_unitype").change(function() {
		onUniType();
	});
	
	$("#ether_type").change(function() {
		onEtherType();
	});

	$("#pq_wanport").change(function() {
		onWanType();
	});

	$("#proto_type").change(function() {
		onProtoType();
	});
	
	$("#tos_dscp").change(function() {
		onTosDscpType();
	});
	
	$("#add_pqrule").click(function() {
		addQosPqRule();
	});

	$("#hidebox").click(function() {
		hidePqDetail();
	});

	$("#ModeSwitch_up").change(function() {
		onUsCarMode();
	});

	$("#InterfaceName_up").change(function() {
		onUsCarLanPort();
	});
	
	$("#usipaddr_type").change(function() {
		onUsIpaddr();
	});
	
	$("#add_uscarrule").click(function() {
		addQosUsCarRule();
	});
	
	$("#ModeSwitch_down").change(function() {
		onDsCarMode();
	});

	$("#InterfaceName_down").change(function() {
		onDsCarLanPort();
	});
	
	$("#dsipaddr_type").change(function() {
		onDsIpaddr();
	});
	
	$("#add_dscarrule").click(function() {
		addQosDsCarRule();
	});
		
	$("#btn_save").click(function() {
		ip_qos_web_submit();
	});
	
	$("#qos_enable").click(function() {
	ChangeQOS();
	});
	onProtoType();
}

function showHideDiv()
{
	$("#hidebg").show();
	$("#hidebg").height($("#content").get(0).clientHeight + 100);
	$("#hidebox").show();
}

function hidePqDetail()
{
	$("#hidebg").hide();
	$("#hidebox").hide();
}

function freshServiceTable()
{
	var htmlstr = "";
	var row;

	htmlstr += '<table id="qos_service_table" class="x_table">';
	htmlstr += '<tr>';
	htmlstr += '<th><% multilang(LANG_TRAFFIC_CLASS_STR);%></th>';
	htmlstr += '<th><% multilang(LANG_QUEUE_STR);%></th>';
	htmlstr += '</tr>';
	htmlstr += '</table>';
	$("#QosServiceTableContainer").html(htmlstr);
	$.each(IpQosConfig.qosServList.reverse(), function(li, lv) {
		if (lv.serv_queue == "0") return true;
		row = $("#qos_service_table").get(0).insertRow($("#qos_service_table").get(0).rows.length);
		row.insertCell(row.cells.length).innerHTML = strServiceList[lv.serv_type]
			+ '<input type=hidden name=serv_type' + li + ' value=' + lv.serv_type + '>';
		row.insertCell(row.cells.length).innerHTML = lv.serv_queue
			+ '<input type=hidden name=serv_queue' + li  + ' value=' + lv.serv_queue + '>';
	});

	RecalcDynamicTableHeight("qos_service_table");
}

function getWanNameByIdx(wanidx)
{
	for (var j = 0; j < WanList.length; j++)
	{
		if (WanList[j].index == (wanidx - 1))
		{
			return GetWanName(WanList[j]);
		}
	}
	if(wanidx==0)
		return "ALL";
	return "WAN" + wanidx + "_<% multilang(LANG_UNCONFIGURED);%>";
}

function freshQosPqTable()
{
	var htmlstr = "";

	htmlstr += '<table id="QosPqTable" class="x_table">';
	htmlstr += '<tr>';
	htmlstr += '<th>LAN <% multilang(LANG_INTERFACES);%></th>';
	htmlstr += '<th>WAN <% multilang(LANG_INTERFACES);%></th>';
	htmlstr += '<th><% multilang(LANG_PROTOCOL_STR);%></th>';
	htmlstr += '<th>802.1p <% multilang(LANG_PRIORITY);%></th>';
	htmlstr += '<th>DSCP <% multilang(LANG_PRIORITY);%></th>';
	htmlstr += '<th><% multilang(LANG_QUEUE_STR);%></th>';
	htmlstr += '<th><% multilang(LANG_DELETE);%></th>';
	htmlstr += '<th><% multilang(LANG_DETAIL_STR);%></th>';
	htmlstr += '</tr>';
	htmlstr += '</table>';
	$("#QosPqTableContainer").html(htmlstr);
	
	$.each(IpQosConfig.qosPqList, function(li, lv) {

		row = $("#QosPqTable").get(0).insertRow($("#QosPqTable").get(0).rows.length);
		//alert('lv.pq_lanport'+lv.pq_lanport+' lv.pq_wanport'+lv.pq_wanport)
		if (0 == lv.pq_lanport) {
			htmlstr = "All";
		} else if (lv.pq_lanport > 0) {
			htmlstr = strLanPortList[lv.pq_lanport - 1];
			htmlstr += ' - ';
			htmlstr += strLanPortList[lv.pq_lanport_end - 1];
		}  
		row.insertCell(row.cells.length).innerHTML = htmlstr;
		if(lv.pq_wanport > 0) {
			htmlstr = getWanNameByIdx(lv.pq_wanport);
		}else
			htmlstr="ALL";
		row.insertCell(row.cells.length).innerHTML = htmlstr;
		htmlstr = strProtoType[lv.proto_type];		
		row.insertCell(row.cells.length).innerHTML = htmlstr;
		if(lv.act_priority>-1)
			row.insertCell(row.cells.length).innerHTML = lv.act_priority;
		else
			row.insertCell(row.cells.length).innerHTML = "";
		if(lv.act_DSCP_priority>-1)
			row.insertCell(row.cells.length).innerHTML = lv.act_DSCP_priority;
		else
			row.insertCell(row.cells.length).innerHTML = "";
		row.insertCell(row.cells.length).innerHTML = lv.act_queue;
		row.insertCell(row.cells.length).innerHTML = '<input type="button" value="<% multilang(LANG_DELETE);%>" onclick="delQosPqRule(this);" />';
		row.insertCell(row.cells.length).innerHTML = '<input type="button" value="<% multilang(LANG_DETAIL_STR);%>" onclick="showQosPqDetail(this);" />';
	});
	
	$("#qospqrule").val(JSON.stringify(IpQosConfig.qosPqList));
	RecalcDynamicTableHeight("QosPqTable");
}

function RepalceAll(str)
{
	while (str.indexOf("-") > 0)
	{
		str = str.replace("-", ":");
	}
	return str;
}

/*return 0 when ipBegin == ipEnd
* return 1 when ipBegin > ipEnd
* return 2 when ipBegin < ipEnd
*/
function compareIpv4(ipBegin, ipEnd)  
{  
    var temp1;
    var temp2;    
    temp1 = ipBegin.split(".");  
    temp2 = ipEnd.split(".");   
    for (var i = 0; i < 4; i++)  
    {
        if (parseInt(temp1[i], 10) > parseInt(temp2[i], 10))
        {
            return 1;
        }  
        else if (parseInt(temp1[i], 10) < parseInt(temp2[i], 10))  
        {
            return 2;  
        }
    }
    return 0;     
}

function clearQosPqRule()
{
	$("#dscp").val("");
	$("#dscp_end").val("");
	$("#ipv6_tc").val("");
	$("#ipv6_tc_end").val("");
	$("#pbit").val("");
	$("#vlanid").val("");
	$("#vlanid_end").val("");
	$("#vlan_8021p").val("");
	$("#vlan_8021p_end").val("");
	$("#pq_unitype").val("0");
	$("#pq_lanport").val("0");
	$('#pq_lanport_end_div').hide();
	$("#pq_wanport").val("0");
	$("#ether_type").val("0");
	$("#proto_type").val("6");
	$("#src_mac").val("");
	$("#src_mac_end").val("");
	$("#dst_mac").val("");
	$("#dst_mac_end").val("");
	$("#ipv4_srcip").val("");
	$("#ipv4_srcip_end").val("");
	$("#ipv4_dstip").val("");
	$("#ipv4_dstip_end").val("");
	$("#ipv6_srcip").val("");
	$("#ipv6_srcip_end").val("");
	$("#ipv6_dstip").val("");
	$("#ipv6_dstip_end").val("");
	$("#mark_ipv6_tc").val("");
	$("#srcport_start").val("");
	$("#srcport_end").val("");
	$("#dstport_start").val("");
	$("#dstport_end").val("");
	$("#act_priority").val("");
	$("#act_DSCP_priority").val("");
	$("#act_queue").val("");
	
	onEtherType();
	onUniType();
	onWanType();
}

function addQosPqRule()
{
	if (IpQosConfig.qosPqList.length >= 16)
	{
		alert("<% multilang(LANG_ERROR_URL_RULE_EXCEEDED_16);%>！");
		return;
	}
	
	var obj = new Object();
	obj.proto_type = $("#proto_type").val();
	obj.pq_unitype = $("#pq_unitype").val();
	obj.pq_lanport = $("#pq_lanport").val();
	obj.pq_lanport_end = $("#pq_lanport_end").val();
	if(obj.pq_lanport_end=='')
		obj.pq_lanport_end = obj.pq_lanport;
	obj.pq_wanport = $("#pq_wanport").val();
	obj.ether_type = $("#ether_type").val();	
	obj.ipv4_srcip = $("#ipv4_srcip").val();
	obj.ipv4_srcip_end = $("#ipv4_srcip_end").val();
	if(obj.ipv4_srcip_end=='')
		obj.ipv4_srcip_end = obj.ipv4_srcip_end;
	obj.ipv6_srcip = $("#ipv6_srcip").val();
	obj.ipv6_srcip_end = $("#ipv6_srcip_end").val();
	if(obj.ipv6_srcip_end=='')
		obj.ipv6_srcip_end = obj.ipv6_srcip;
	obj.srcport_start = $("#srcport_start").val();
	obj.srcport_end = $("#srcport_end").val();
	if(obj.srcport_end=='')
		obj.srcport_end = obj.srcport_start;
	obj.ipv4_dstip = $("#ipv4_dstip").val();
	obj.ipv4_dstip_end = $("#ipv4_dstip_end").val();
	if(obj.ipv4_dstip_end=='')
		obj.ipv4_dstip_end = obj.ipv4_dstip;
	obj.ipv6_dstip = $("#ipv6_dstip").val();
	obj.ipv6_dstip_end = $("#ipv6_dstip_end").val();
	if(obj.ipv6_dstip_end=='')
		obj.ipv6_dstip_end = obj.ipv6_dstip;
	obj.dstport_start = $("#dstport_start").val();
	obj.dstport_end = $("#dstport_end").val();
	if(obj.dstport_end=='')
		obj.dstport_end = obj.dstport_start;
	obj.src_mac = RepalceAll($("#src_mac").val().toLowerCase());
	obj.src_mac_end = RepalceAll($("#src_mac_end").val().toLowerCase());
	if(obj.src_mac_end=='')
		obj.src_mac_end = obj.src_mac;
	obj.dst_mac = RepalceAll($("#dst_mac").val().toLowerCase());
	obj.dst_mac_end = RepalceAll($("#dst_mac_end").val().toLowerCase());
	if(obj.dst_mac_end=='')
		obj.dst_mac_end = obj.dst_mac;
	obj.tos_dscp_type = $("#tos_dscp").val();
	obj.dscp = $("#dscp").val();
	obj.dscp_end = $("#dscp_end").val();
	if(obj.dscp_end=='')
		obj.dscp_end = obj.dscp;
	obj.ipv6_tc = $("#ipv6_tc").val();
	obj.ipv6_tc_end = $("#ipv6_tc_end").val();
	if(obj.ipv6_tc_end=='')
		obj.ipv6_tc_end = obj.ipv6_tc;
	obj.mark_ipv6_tc = $("#mark_ipv6_tc").val();
	obj.pbit = $("#pbit").val();
	obj.vlanid = $("#vlanid").val();
	obj.vlanid_end = $("#vlanid_end").val();
	if(obj.vlanid_end=='')
		obj.vlanid_end = obj.vlanid;
	obj.vlan_8021p = $("#vlan_8021p").val();
	obj.vlan_8021p_end = $("#vlan_8021p_end").val();
	if(obj.vlan_8021p_end=='')
		obj.vlan_8021p_end = obj.vlan_8021p;
	obj.act_priority_enable=$("#act_priority_enable").is(':checked');
	obj.act_DSCP_priority_enable=$("#act_DSCP_priority_enable").is(':checked');	
	obj.act_priority =  $("#act_priority").val();
	obj.act_DSCP_priority =  $("#act_DSCP_priority").val();
	obj.act_queue = $("#act_queue").val();

	if (obj.srcport_start < 0 || obj.srcport_start > 65535 || obj.srcport_end < 0 || obj.srcport_end > 65535
		|| obj.dstport_start < 0 || obj.dstport_start > 65535 || obj.dstport_end < 0 || obj.dstport_end > 65535 )
	{
		alert("<% multilang(LANG_THE_PORT_RANGE_IS_STR);%> 0-65535");
		return;
	}
	if (obj.pq_lanport>0&&(parseInt(obj.pq_lanport)>parseInt(obj.pq_lanport_end)))
	{
		alert("<% multilang(LANG_THE_END_LAN_INTERFACE_SHOULD_BE_THE_START_LAN_INTERFACE_STR);%>");
		return;
	}
/*	
	if (1 == obj.pq_unitype && 0 == obj.pq_lanport)
	{
		alert("请选择LAN接口");
		return;
	}
	else if (2 == obj.pq_unitype && 65535 == obj.pq_wanport)
	{
		alert("请选择WAN接口");
		return;
	}
	else 
*/
	if (1)
	{
		if (obj.src_mac != '')
		{
			if (obj.src_mac.length != 17)
			{
				alert("<% multilang(LANG_THE_SOURCE_MAC_ADDRESS_LENGTH_IS_WRONG_STR);%>。");
				return;
			}
			if (isValidMacAddress(obj.src_mac) == false)
			{
				alert('<% multilang(LANG_SOURCE_MAC_ADDRESS_FORMAT_STR);%>：XX:XX:XX:XX:XX:XX(0-9, a-f, A-F)');
				return;
			}
		}
		if (obj.src_mac_end != '')
		{
			if (obj.src_mac_end.length != 17)
			{
				alert("<% multilang(LANG_THE_SOURCE_MAC_ADDRESS_LENGTH_IS_WRONG_STR);%>。");
				return;
			}
			if (isValidMacAddress(obj.src_mac_end) == false)
			{
				alert('<% multilang(LANG_SOURCE_MAC_ADDRESS_FORMAT_STR);%>：XX:XX:XX:XX:XX:XX(0-9, a-f, A-F)');
				return;
			}
		}
		if (obj.dst_mac != '')
		{
			if (obj.dst_mac.length != 17)
			{
				alert("<% multilang(LANG_THE_DESTINATION_MAC_ADDRESS_LENGTH_IS_WRONG_STR);%>。");
				return;
			}
			if (isValidMacAddress(obj.dst_mac) == false)
			{
				alert('<% multilang(LANG_DESTINATION_MAC_ADDRESS_FORMAT_STR);%>：XX:XX:XX:XX:XX:XX(0-9, a-f, A-F)');
				return;
			}
		}
		if (obj.dst_mac_end != '')
		{
			if (obj.dst_mac_end.length != 17)
			{
				alert("<% multilang(LANG_THE_DESTINATION_MAC_ADDRESS_LENGTH_IS_WRONG_STR);%>。");
				return;
			}
			if (isValidMacAddress(obj.dst_mac_end) == false)
			{
				alert('<% multilang(LANG_DESTINATION_MAC_ADDRESS_FORMAT_STR);%>：XX:XX:XX:XX:XX:XX(0-9, a-f, A-F)');
				return;
			}
		}
		if (1 == obj.ether_type)
		{
			if ((obj.ipv4_srcip != '' && !isValidIpAddress(obj.ipv4_srcip)) 
				|| (obj.ipv4_srcip_end != '' && !isValidIpAddress(obj.ipv4_srcip_end)))
			{
				alert("<% multilang(LANG_WRONG_SOURCE_IP_ADDRESS_STR);%>");
				return;
			}
			if ((obj.ipv4_dstip != '' && !isValidIpAddress(obj.ipv4_dstip)) 
				|| (obj.ipv4_dstip_end != '' && !isValidIpAddress(obj.ipv4_dstip_end)))
			{
				alert("<% multilang(LANG_WRONG_DESTINATION_IP_ADDRESS_STR);%>");
				return;
			}
			if (obj.ipv4_srcip != '' && obj.ipv4_srcip_end != '')
			{
				if (compareIpv4(obj.ipv4_srcip, obj.ipv4_srcip_end) == 1)
				{
					alert("<% multilang(LANG_START_ADDR_SHOULD_SMALL_THAN_END_ADDR_STR);%>");
					$("#ipv4_srcip").focus();
					return;
				}
			}
			if (obj.ipv4_dstip != '' && obj.ipv4_dstip_end != '')
			{
				if (compareIpv4(obj.ipv4_dstip, obj.ipv4_dstip_end) == 1)
				{
					alert("<% multilang(LANG_START_ADDR_SHOULD_SMALL_THAN_END_ADDR_STR);%>");
					$("#ipv4_dstip").focus();
					return;
				}
			}
			if (obj.tos_dscp_type == 1)
			{
			  //  if ((obj.dscp != '') && (isValidBinKey(obj.dscp, 8) == false))
			    if((obj.dscp != '') &&obj.dscp < 0 || obj.dscp > 252)
			    {
				    alert("<% multilang(LANG_INPUT_CORRECT_VALUE_STR);%> tos (0~252)");
				    return;
			    } 
				 if((obj.dscp_end != '') &&obj.dscp_end < 0 || obj.dscp_end > 252)
			    {
				    alert("<% multilang(LANG_INPUT_CORRECT_VALUE_STR);%> tos (0~252)");
				    return;
			    } 
				 if((obj.dscp_end != '') &&(obj.dscp != ''))
			    {
					if(parseInt(obj.dscp_end)<parseInt(obj.dscp)){
						alert("<% multilang(LANG_THE_END_TOS_VALUE_SHOULD_BE_THE_START_TOS_VALUE_STR);%>");
						return;
					}
			    } 
/*				
				else
				{
				    if (obj.dscp != '')
				        obj.dscp = parseInt(obj.dscp, 2).toString();
				}
*/				
				
			}
			else if (obj.tos_dscp_type == 2)
			{
			    if (obj.dscp != '' && (obj.dscp < 0 || obj.dscp > 63))
			    {
				    alert("<% multilang(LANG_INPUT_CORRECT_VALUE_STR);%> dscp (0~63)");
				    return;
			    }   
				 if((obj.dscp_end != '') &&obj.dscp_end < 0 || obj.dscp_end > 63)
			    {
				     alert("<% multilang(LANG_INPUT_CORRECT_VALUE_STR);%> dscp(0~63)");
				    return;
			    } 
				 if((obj.dscp_end != '') &&(obj.dscp != ''))
			    {
					if(parseInt(obj.dscp_end)<parseInt(obj.dscp)){
						alert("<% multilang(LANG_THE_END_DSCP_VALUE_SHOULD_BE_THE_START_DSCP_VALUE_STR);%>");
						return;
					}
			    } 
			}
			if (obj.dscp == "")
				obj.tos_dscp_type = "0";
		}
		else if (2 == obj.ether_type)
		{
			if ((obj.ipv6_srcip != '' && !isValidIpAddress6(obj.ipv6_srcip)) 
				|| (obj.ipv6_srcip_end != '' && !isValidIpAddress6(obj.ipv6_srcip_end)))
			{
				alert("<% multilang(LANG_WRONG_SOURCE_IPV6_ADDRESS_STR);%>");
				return;
			}
			if ((obj.ipv6_dstip != '' && !isValidIpAddress6(obj.ipv6_dstip)) 
				|| (obj.ipv6_dstip_end != '' && !isValidIpAddress6(obj.ipv6_dstip_end)))
			{
				alert("<% multilang(LANG_WRONG_DESTINATION_IPV6_ADDRESS_STR);%>");
				return;
			}
		
			if (obj.ipv6_tc == '')
				obj.ipv6_tc = 255;
			else
            {
			    if ((obj.ipv6_tc < 0) || (obj.ipv6_tc > 63))
				{
				    alert("<% multilang(LANG_INPUT_CORRECT_VALUE_STR);%> traffic class(0~63)");
				    return;
				}
			}	
			if (obj.ipv6_tc_end == ''){
					obj.ipv6_tc_end = 255;
					if(obj.ipv6_tc!='')
						obj.ipv6_tc_end = obj.ipv6_tc;
			}else
            {
			    if ((obj.ipv6_tc_end < 0) || (obj.ipv6_tc_end > 63))
				{
				    alert("<% multilang(LANG_INPUT_CORRECT_VALUE_STR);%> traffic class(0~63)");
				    return;
				}
			}	
			if (obj.ipv6_tc != ''&&obj.ipv6_tc != ''){
				 if (parseInt(obj.ipv6_tc ) > parseInt(obj.ipv6_tc_end ))
				{
				    alert("<% multilang(LANG_END_TRAFFICCLASS_SHOULD_BE__START_TRAFFICCLASS_STR);%>");
				    return;
				}
			}
			if (obj.mark_ipv6_tc == '')
				obj.mark_ipv6_tc = -1;
			else	
			{
			    if ((obj.mark_ipv6_tc < 0) || (obj.mark_ipv6_tc > 63))
				{
				    alert("<% multilang(LANG_INPUT_CORRECT_VALUE_STR);%> traffic class(0~63)");
				    return;
				}
			}	
		}

		if ((obj.srcport_end != '' && parseInt(obj.srcport_start) > parseInt(obj.srcport_end)) 
			|| (obj.dstport_end != '' && parseInt(obj.dstport_start) > parseInt(obj.dstport_end)))
		{
			alert("<% multilang(LANG_THE_END_PORT_IS_LESS_THAN_THE_START_PORT_STR);%>");
			return;
		}
		if (obj.pbit != '' && (obj.pbit < 0 || obj.pbit > 7))
		{
			alert("<% multilang(LANG_INPUT_CORRECT_VALUE_STR);%>pbit(0~7)");
			return;
		}
		if (obj.pbit == '')
		{
			obj.pbit = -1;
		}
		if (obj.vlan_8021p != '' && (obj.vlan_8021p < 0 || obj.vlan_8021p > 7))
		{
			alert("<% multilang(LANG_INPUT_CORRECT_VALUE_STR);%> 802.1p(0~7)");
			return;
		}
		if (obj.vlan_8021p_end != '' && (obj.vlan_8021p_end < 0 || obj.vlan_8021p_end > 7))
		{
			alert("<% multilang(LANG_INPUT_CORRECT_VALUE_STR);%> 802.1p(0~7)");
			return;
		}
		if(obj.vlan_8021p != ''&&obj.vlan_8021p_end != ''){
			if(parseInt(obj.vlan_8021p)>parseInt(obj.vlan_8021p_end)){
				alert("<% multilang(LANG_END_8021P_SHOULD_BE__START_8021P_STR);%>");
				return;
			}
		}
		if (obj.vlanid != '' && (obj.vlanid < 0 || obj.vlanid > 4095))
		{
			alert("<% multilang(LANG_INPUT_CORRECT_VALUE_STR);%> VLAN ID(0~4095)");
			return;
		}
		if (obj.vlanid_end != '' && (obj.vlanid_end < 0 || obj.vlanid_end > 4095))
		{
			alert("<% multilang(LANG_INPUT_CORRECT_VALUE_STR);%> VLAN ID(0~4095)");
			return;
		}
		if(obj.vlanid != ''&&obj.vlanid_end != ''){
			if(parseInt(obj.vlanid)>parseInt(obj.vlanid_end)){
				alert("<% multilang(LANG_END_8021P_SHOULD_BE__START_8021P_STR);%>");
				return;
			}
		}
/*		
		if (obj.vlanid == '')
		{
			obj.vlanid = "65535";
		}
*/		
	}
	if (obj.act_priority_enable&&(obj.act_priority == '' || obj.act_priority < -1 || obj.act_priority > 7))
	{
		alert("<% multilang(LANG_INPUT_CORRECT_VALUE_STR);%> 802.1P(0~7)");
		return;
	}
	if ((obj.ether_type==1)&&obj.act_DSCP_priority_enable&&(obj.act_DSCP_priority == '' || obj.act_DSCP_priority < -1 || obj.act_DSCP_priority > 63))
	{
		alert("<% multilang(LANG_INPUT_CORRECT_VALUE_STR);%> DSCP(0~63)");
		return;
	}
	if (obj.act_queue == '' || obj.act_queue < 1 || obj.act_queue > 8)
	{
		alert("<% multilang(LANG_INPUT_CORRECT_VALUE_STR);%> <% multilang(LANG_QUEUE_STR);%>(1~8)");
		return;
	}
	if (HaveSameQosPqRule(obj))
	{
		alert("<% multilang(LANG_THIS_RULE_ALREADY_EXISTS_STR);%>");
		return;
	}
	IpQosConfig.qosPqList.push(obj);
	freshQosPqTable();
	clearQosPqRule();
	RecalcHelpHeight();
}

function delQosPqRule(r)
{
	var row = r.parentNode.parentNode.rowIndex;
	var len = IpQosConfig.qosPqList.length;
	for (var i = row - 1; i < IpQosConfig.qosPqList.length; i++ )
	{
		IpQosConfig.qosPqList[i] = IpQosConfig.qosPqList[i + 1];
	}
	IpQosConfig.qosPqList.pop();
	freshQosPqTable();
}

function showQosPqDetail(r)
{
	var row = r.parentNode.parentNode.rowIndex;
	var obj = IpQosConfig.qosPqList[row - 1];
	var htmlstr = "";

	showHideDiv();
	htmlstr += '<table id="qos_pq_detail">';
	htmlstr += '<tr><td width="220px"><b><% multilang(LANG_CLASSIFICATION_RULES);%></b></td><td></td></tr>';
	if (1)
	{
		if(obj.pq_lanport!=0)
			htmlstr += '<tr><td>LAN <% multilang(LANG_INTERFACES);%>：</td><td>' + strLanPortList[obj.pq_lanport - 1]+' - '+strLanPortList[obj.pq_lanport_end - 1] + '</td></tr>';
		else
			htmlstr += '<tr><td>LAN <% multilang(LANG_INTERFACES);%>：</td><td> ALL </td></tr>';
		htmlstr += '<tr><td>WAN <% multilang(LANG_INTERFACES);%>：</td><td>' + getWanNameByIdx(obj.pq_wanport) + '</td></tr>';
		if(obj.src_mac!="00:00:00:00:00:00"||obj.src_mac_end!="00:00:00:00:00:00")
			htmlstr += '<tr><td><% multilang(LANG_SRC_MAC);%>：</td><td>' + obj.src_mac +' - '+obj.src_mac_end + '</td></tr>';
		if(obj.dst_mac!="00:00:00:00:00:00"||obj.dst_mac_end!="00:00:00:00:00:00")
			htmlstr += '<tr><td><% multilang(LANG_DST_MAC);%>：</td><td>' + obj.dst_mac +' - '+ obj.dst_mac_end +'</td></tr>';
		if (1 == obj.ether_type)
		{
		    htmlstr += '<tr><td><% multilang(LANG_LOOP_DETECTION_ETHER_TYPE);%>：</td><td>IPv4</td></tr>';
			if(obj.ipv4_srcip=='0.0.0.0'&&obj.ipv4_srcip_end=='0.0.0.0'){
				//htmlstr += '<tr><td>源起始IP地址：</td><td>&nbsp;</td></tr>';
				//htmlstr += '<tr><td>源结束IP地址：</td><td>&nbsp;</td></tr>';
			}else{
				htmlstr += '<tr><td><% multilang(LANG_SRC_IP_START_ADDRESS);%>：</td><td>' + obj.ipv4_srcip + '</td></tr>';
				htmlstr += '<tr><td><% multilang(LANG_SRC_IP_END_ADDRESS);%>：</td><td>' + obj.ipv4_srcip_end + '</td></tr>';
			}
			if(obj.ipv4_dstip=='0.0.0.0'&&obj.ipv4_dstip_end=='0.0.0.0'){
				//htmlstr += '<tr><td>目的起始IP地址：</td><td>&nbsp;</td></tr>';
				//htmlstr += '<tr><td>目的结束IP地址：</td><td>&nbsp;</td></tr>';
			}else{
				htmlstr += '<tr><td><% multilang(LANG_DST_IP_START_ADDRESS);%>：</td><td>' + obj.ipv4_dstip + '</td></tr>';
				htmlstr += '<tr><td><% multilang(LANG_DST_IP_END_ADDRESS);%>：</td><td>' + obj.ipv4_dstip_end + '</td></tr>';
			}
		}
		else if (2 == obj.ether_type)
		{
			htmlstr += '<tr><td><% multilang(LANG_LOOP_DETECTION_ETHER_TYPE);%>：</td><td>IPv6</td></tr>';
			if(obj.ipv6_srcip!='::'||obj.ipv6_srcip_end!='::'){
				htmlstr += '<tr><td><% multilang(LANG_SOURCE_START_IPV6_ADDRESS_STR);%>：</td><td>' + obj.ipv6_srcip + '</td></tr>';
				htmlstr += '<tr><td><% multilang(LANG_SOURCE_END_IPV6_ADDRESS_STR);%>：</td><td>' + obj.ipv6_srcip_end + '</td></tr>';
			}
			if(obj.ipv6_dstip!='::'||obj.ipv6_dstip_end!='::'){
				htmlstr += '<tr><td><% multilang(LANG_DESTINATION_START_IPV6_ADDRESS_STR);%>：</td><td>' + obj.ipv6_dstip + '</td></tr>';
				htmlstr += '<tr><td><% multilang(LANG_DESTINATION_END_IPV6_ADDRESS_STR);%>：</td><td>' + obj.ipv6_dstip_end + '</td></tr>';
			}
		}
		else
		{
			htmlstr += '<tr><td><% multilang(LANG_LOOP_DETECTION_ETHER_TYPE);%>：</td><td>ALL</td></tr>';
		}
		htmlstr += '<tr><td><% multilang(LANG_PROTOCOL);%>：</td><td>' + strProtoType[obj.proto_type] + '</td></tr>';
		if (aryProtocolType.NET_PROTO_ICMP != obj.proto_type 
			&& aryProtocolType.NET_PROTO_ICMPV6 != obj.proto_type)
		{
			if(obj.srcport_start!='0'||obj.srcport_end!='0'){
				htmlstr += '<tr><td><% multilang(LANG_SRC_IP_START_PORT);%>：</td><td>' + obj.srcport_start + '</td></tr>';
				htmlstr += '<tr><td><% multilang(LANG_SRC_IP_END_PORT);%>：</td><td>' + obj.srcport_end + '</td></tr>';
			}
			if(obj.dstport_start!='0'||obj.dstport_end!='0'){
				htmlstr += '<tr><td><% multilang(LANG_DST_IP_START_PORT);%>：</td><td>' + obj.dstport_start + '</td></tr>';
				htmlstr += '<tr><td><% multilang(LANG_DST_IP_END_PORT);%>：</td><td>' + obj.dstport_end + '</td></tr>';
			}
		}
		if (65535 != obj.vlanid){
			htmlstr += '<tr><td>VLAN：</td><td>' + obj.vlanid + '</td></tr>';
		}
		/*else
			htmlstr += '<tr><td>VLAN：</td><td></td></tr>';
		*/	
		if (255 != obj.vlan_8021p)
			htmlstr += '<tr><td>802.1P：</td><td>' + obj.vlan_8021p + '</td></tr>';
		//else
		//	htmlstr += '<tr><td>802.1P：</td><td></td></tr>';
		if (1 == obj.ether_type||3 == obj.ether_type)
		{
			if (1 == obj.tos_dscp_type)
            {
			   // var dscp = parseInt(obj.dscp);
				//dscp = (dscp).toString(2);
			
			    if (255 != obj.dscp)
				    htmlstr += '<tr><td>tos：</td><td>' + obj.dscp +' - '+ obj.dscp_end + '</td></tr>';
			    //else
				 //   htmlstr += '<tr><td>tos：</td><td></td></tr>';
			}  	
            else
            {
			    if (255 != obj.dscp)
				    htmlstr += '<tr><td>dscp：</td><td>' + obj.dscp +' - '+ obj.dscp_end + '</td></tr>';
			   // else
				//    htmlstr += '<tr><td>dscp：</td><td></td></tr>';
			}			
		}
		else if (2 == obj.ether_type)
		{
			if (255 != obj.ipv6_tc)
				htmlstr += '<tr><td>traffic class</td><td>' + obj.ipv6_tc +' - '+ obj.ipv6_tc_end + '</td></tr>';
			//else
			//	htmlstr += '<tr><td>traffic class</td><td></td></tr>';
		}
		/*
		if (255 != obj.pbit)
			htmlstr += '<tr><td>pbit：</td><td>' + obj.pbit + '</td></tr>';
		else
			htmlstr += '<tr><td>pbit：</td><td></td></tr>';
		*/	
		
		
	}
	/*
	else if (1 == obj.pq_unitype)
	{
		htmlstr += '<tr><td>LAN接口：</td><td>' + strLanPortList[obj.pq_lanport - 1] + '</td></tr>';
	}
	else if (2 == obj.pq_unitype)
	{
		htmlstr += '<tr><td>WAN接口：</td><td>' + getWanNameByIdx(obj.pq_wanport) + '</td></tr>';
	}
	*/
	htmlstr += '<tr><td><b><% multilang(LANG_PERFORM_ACTIONS_STR);%></b></td></tr>'
	if(obj.act_priority>0)
		htmlstr += '<tr><td>802.1p<% multilang(LANG_PRIORITY);%>：</td><td>' + obj.act_priority + '</td></tr>';
	if(obj.ether_type==1&&obj.act_DSCP_priority>0)
		htmlstr += '<tr><td>DSCP：</td><td>' + obj.act_DSCP_priority + '</td></tr>';
	if (obj.ether_type==2 && obj.mark_ipv6_tc >0)
	{
	
		if (-1 != obj.mark_ipv6_tc)
			htmlstr += '<tr><td><% multilang(LANG_MARK);%> traffic class：</td><td>' + obj.mark_ipv6_tc + '</td></tr>';
		else
			htmlstr += '<tr><td><% multilang(LANG_MARK);%> traffic class：</td><td></td></tr>';
	}
	if(obj.ether_type==3&&obj.act_DSCP_priority>0)
		htmlstr += '<tr><td>DSCP/Traffic Class：</td><td>' + obj.act_DSCP_priority + '</td></tr>';
	htmlstr += '<tr><td><% multilang(LANG_QUEUE_STR);%>：</td><td>' + obj.act_queue + '</td></tr>';
	htmlstr += '</table>';
	htmlstr += '<p align="center"><font color="red"><% multilang(LANG_ANY_CLICK_TO_CLOSE_STR);%></font></p>';

	$("#hidebox").html(htmlstr);
	$("#hidebox").height($("#qos_pq_detail").height() + 100);
	scrollTo(0, 0);
}

function delQosUsCarRule(r)
{
	var row = r.parentNode.parentNode.rowIndex;
	$("#select_car_qos_mode").val("car_qos");
	if (1 == $("#ModeSwitch_up").val())// car qos lan mode
	{
		var len = IpQosConfig.usRateCtlLanList.length;
		for (var i = row - 1; i < IpQosConfig.usRateCtlLanList.length; i++ )
		{
			IpQosConfig.usRateCtlLanList[i] = IpQosConfig.usRateCtlLanList[i + 1];
		}
		IpQosConfig.usRateCtlLanList.pop();
	}
	else if (2 == $("#ModeSwitch_up").val())// car qos vlan mode
	{
		var len = IpQosConfig.usRateCtlVlanList.length;
		for (var i = row - 1; i < IpQosConfig.usRateCtlVlanList.length; i++ )
		{
			IpQosConfig.usRateCtlVlanList[i] = IpQosConfig.usRateCtlVlanList[i + 1];
		}
		IpQosConfig.usRateCtlVlanList.pop();
	}
	else if (3 == $("#ModeSwitch_up").val())// car qos ip mode
	{
		var len = IpQosConfig.usRateCtlIpList.length;
		for (var i = row - 1; i < IpQosConfig.usRateCtlIpList.length; i++ )
		{
			IpQosConfig.usRateCtlIpList[i] = IpQosConfig.usRateCtlIpList[i + 1];
		}
		IpQosConfig.usRateCtlIpList.pop();
	} 
	freshQosUsCarTable();
}

function delQosDsCarRule(r)
{
	var row = r.parentNode.parentNode.rowIndex;
	if (1 == $("#ModeSwitch_down").val())// car qos lan mode
	{
		var len = IpQosConfig.dsRateCtlLanList.length;
		for (var i = row - 1; i < IpQosConfig.dsRateCtlLanList.length; i++ )
		{
			IpQosConfig.dsRateCtlLanList[i] = IpQosConfig.dsRateCtlLanList[i + 1];
		}
		IpQosConfig.dsRateCtlLanList.pop();
	}
	else if (2 == $("#ModeSwitch_down").val())// car qos vlan mode
	{
		var len = IpQosConfig.dsRateCtlVlanList.length;
		for (var i = row - 1; i < IpQosConfig.dsRateCtlVlanList.length; i++ )
		{
			IpQosConfig.dsRateCtlVlanList[i] = IpQosConfig.dsRateCtlVlanList[i + 1];
		}
		IpQosConfig.dsRateCtlVlanList.pop();
	}
	else if (3 == $("#ModeSwitch_down").val())// car qos ip mode
	{
		var len = IpQosConfig.dsRateCtlIpList.length;
		for (var i = row - 1; i < IpQosConfig.dsRateCtlIpList.length; i++ )
		{
			IpQosConfig.dsRateCtlIpList[i] = IpQosConfig.dsRateCtlIpList[i + 1];
		}
		IpQosConfig.dsRateCtlIpList.pop();
	} 
	freshQosDsCarTable();
}

function HaveSameQosPqRule(obj)
{
	$.each(IpQosConfig.qosPqList, function(li, lv) {

		if (lv.pq_unitype > 0)
		{
			if (1 == lv.pq_unitype && lv.pq_unitype == obj.pq_unitype
			 	&& lv.pq_lanport == obj.pq_lanport&& lv.pq_lanport_end == obj.pq_lanport_end)
			{
				return true;
			}
			else if (2 == lv.pq_unitype && lv.pq_unitype == obj.pq_unitype
				&& lv.pq_wanport == obj.pq_wanport)
			{
				return true;
			}
		}
		else
		{
			if (1 == lv.ether_type)
			{
				if (lv.src_mac == obj.src_mac && lv.src_mac_end == obj.src_mac_end 
					&&lv.dst_mac == obj.dst_mac && lv.dst_mac_end == obj.dst_mac_end
					&& lv.ether_type == obj.ether_type && lv.proto_type == obj.proto_type 
					&& lv.ipv4_srcip == obj.ipv4_srcip && lv.ipv4_srcip_end == obj.ipv4_srcip_end 
					&& lv.srcport_start == obj.srcport_start && lv.srcport_end == obj.srcport_end 
					&& lv.ipv4_dstip == obj.ipv4_dstip && lv.ipv4_dstip_end == obj.ipv4_dstip_end 
					&& lv.dstport_start == obj.dstport_start && lv.dstport_end == obj.dstport_end 
					&& lv.dscp == obj.dscp && lv.dscp_end == obj.dscp_end&& lv.pbit == obj.pbit 
					&& lv.vlanid == obj.vlanid&&lv.vlanid_end == obj.vlanid_end
					&& lv.vlan_8021p == obj.vlan_8021p
					&& lv.vlan_8021p_end == obj.vlan_8021p_end)
				{
					return true;
				}
			}
			else if (2 == lv.ether_type)
			{
				if (lv.src_mac == obj.src_mac && lv.src_mac_end == obj.src_mac_end 
					&&lv.dst_mac == obj.dst_mac && lv.dst_mac_end == obj.dst_mac_end 
					&& lv.ether_type == obj.ether_type && lv.proto_type == obj.proto_type 
					&& lv.ipv6_srcip == obj.ipv6_srcip && lv.ipv6_srcip_end == obj.ipv6_srcip_end 
					&& lv.srcport_start == obj.srcport_start && lv.srcport_end == obj.srcport_end 
					&& lv.ipv6_dstip == obj.ipv6_dstip && lv.ipv6_dstip_end == obj.ipv6_dstip_end 
					&& lv.dstport_start == obj.dstport_start && lv.dstport_end == obj.dstport_end 
					&& lv.ipv6_tc == obj.ipv6_tc&& lv.ipv6_tc_end == obj.ipv6_tc_end 
					&& lv.pbit == obj.pbit && lv.vlanid == obj.vlanid
					&&lv.vlanid_end == obj.vlanid_end&& lv.vlan_8021p == obj.vlan_8021p
					&& lv.vlan_8021p_end == obj.vlan_8021p_end)
				{
					return true;
				}
			}
			else if (3 == lv.ether_type)
			{
				if (lv.src_mac == obj.src_mac&&lv.src_mac_end == obj.src_mac_end 
					&& lv.dst_mac == obj.dst_mac && lv.dst_mac_end == obj.dst_mac_end
					&& lv.ether_type == obj.ether_type && lv.proto_type == obj.proto_type 
					&& lv.srcport_start == obj.srcport_start && lv.srcport_end == obj.srcport_end 
					&& lv.dstport_start == obj.dstport_start && lv.dstport_end == obj.dstport_end)
				{
					return true;
				}
			}
		}
	});

	return false;
}

function HaveSameUsLANQosRule(tofind, flag)
{
	if (1 == flag)
	{	
		for (var i = 0; i < IpQosConfig.usRateCtlLanList.length; i++ )
		{
			if (IpQosConfig.usRateCtlLanList[i].InterfaceName_up == tofind)
			{
				if (!(IpQosConfig.usRateCtlLanList[i].rate == 0))
					return true;
			}
		}
	}
	else if (2 == flag)
	{	
		for (var i = 0; i < IpQosConfig.usRateCtlVlanList.length; i++ )
		{
			if (IpQosConfig.usRateCtlVlanList[i].vlan == tofind)
			{
				if (!(IpQosConfig.usRateCtlVlanList[i].rate == 0))
					return true;
			}
		}
	}
	return false;
}

function HaveSameDsLANQosRule(tofind, flag)
{
	if (1 == flag)
	{	
		for (var i = 0; i < IpQosConfig.dsRateCtlLanList.length; i++ )
		{
			if (IpQosConfig.dsRateCtlLanList[i].InterfaceName_up == tofind)
			{
				if (!(IpQosConfig.dsRateCtlLanList[i].rate == 0))
					return true;
			}
		}
	}
	else if (2 == flag)
	{	
		for (var i = 0; i < IpQosConfig.dsRateCtlVlanList.length; i++ )
		{
			if (IpQosConfig.dsRateCtlVlanList[i].vlan == tofind)
			{
				if (!(IpQosConfig.dsRateCtlVlanList[i].rate == 0))
					return true;
			}
		}
	}
	return false;
}

function ModifyUsLanQosRule(tofind, flag)
{
	if (1 == flag)
	{
		for (var i = 0; i < IpQosConfig.usRateCtlLanList.length; i++ )
		{
			if (IpQosConfig.usRateCtlLanList[i].InterfaceName_up == tofind)
			{
				IpQosConfig.usRateCtlLanList[i].rate = $("#InterfaceSpeed_up").val();
				return true;
			}
		}
	}
	else if (2 == flag)
	{
		for (var i = 0; i < IpQosConfig.usRateCtlVlanList.length; i++ )
		{
			if (IpQosConfig.usRateCtlVlanList[i].vlan == tofind)
			{
				IpQosConfig.usRateCtlVlanList[i].rate = $("#VlanTagSpeed_up").val();
				return true;
			}
		}
	}
}

function ModifyDsLanQosRule(tofind, flag)
{
	if (1 == flag)
	{
		for (var i = 0; i < IpQosConfig.dsRateCtlLanList.length; i++ )
		{
			if (IpQosConfig.dsRateCtlLanList[i].InterfaceName_up == tofind)
			{
				IpQosConfig.dsRateCtlLanList[i].rate = $("#InterfaceSpeed_down").val();
				return true;
			}
		}
	}
	else if (2 == flag)
	{
		for (var i = 0; i < IpQosConfig.dsRateCtlVlanList.length; i++ )
		{
			if (IpQosConfig.dsRateCtlVlanList[i].vlan == tofind)
			{
				IpQosConfig.dsRateCtlVlanList[i].rate = $("#VlanTagSpeed_down").val();
				return true;
			}
		}
	}
}

function addQosUsCarLanRule()
{
	if (IpQosConfig.usRateCtlLanList.length >= 16)
	{
		alert("<% multilang(LANG_ERROR_URL_RULE_EXCEEDED_16);%>！");
		return;
	}
	
	var InterfaceName_up = $("#InterfaceName_up").val();
	var InterfaceSpeed_up = $("#InterfaceSpeed_up").val();

	if (0 > InterfaceSpeed_up)
	{
		$("#InterfaceSpeed_up").focus();
		alert("<% multilang(LANG_UPLINK_RATE_CANNOT_BE_NEGATIVE_STR);%>");
		return false;
	}
	if (HaveSameUsLANQosRule(InterfaceName_up, 1))
	{
		if (true == confirm("<% multilang(LANG_THE_RATE_LIMIT_RULE_FOR_THIS_PORT_ALREADY_EXISTS_STR);%>"))
		{
			ModifyUsLanQosRule(InterfaceName_up, 1);
		}
		else
		{
			$("#InterfaceName_up").focus();
			return false;
		}
	}
	else
	{
		var obj = new Object();
		obj.rate =  InterfaceSpeed_up;
		obj.InterfaceName_up = InterfaceName_up;
		IpQosConfig.usRateCtlLanList.push(obj);
	}
	
	freshQosUsCarTable();
}

function addQosDsCarLanRule()
{
	if (IpQosConfig.dsRateCtlLanList.length >= 16)
	{
		alert("<% multilang(LANG_ERROR_URL_RULE_EXCEEDED_16);%>！");
		return;
	}
	
	var InterfaceName_down = $("#InterfaceName_down").val();
	var InterfaceSpeed_down = $("#InterfaceSpeed_down").val();

	if (0 > InterfaceSpeed_down)
	{
		$("#InterfaceSpeed_down").focus();
		alert("<% multilang(LANG_UPLINK_RATE_CANNOT_BE_NEGATIVE_STR);%>");
		return false;
	}
	if (HaveSameDsLANQosRule(InterfaceName_down, 1))
	{
		if (true == confirm("<% multilang(LANG_THE_RATE_LIMIT_RULE_FOR_THIS_PORT_ALREADY_EXISTS_STR);%>"))
		{
			ModifyDsLanQosRule(InterfaceName_down, 1);
		}
		else
		{
			$("#InterfaceName_down").focus();
			return false;
		}
	}
	else
	{
		var obj = new Object();
		obj.InterfaceName_down = InterfaceName_down;
		obj.rate =  InterfaceSpeed_down;
		IpQosConfig.dsRateCtlLanList.push(obj);
	}
	
	freshQosDsCarTable();
}

function addQosUsCarVlanRule()
{
	if (IpQosConfig.usRateCtlVlanList.length >= 16)
	{
		alert("<% multilang(LANG_ERROR_URL_RULE_EXCEEDED_16);%>！");
		return;
	}
	
	var VlanTagValue_up = $("#VlanTagValue_up").val();
	var VlanTagSpeed_up = $("#VlanTagSpeed_up").val();

	if (0 > VlanTagValue_up || VlanTagValue_up > 4095)
	{
		$("#VlanTagValue_up").focus();
		alert("vlan <% multilang(LANG_VALID_VALUE_RANGE_STR);%> 0~4095");
		return false;
	}
	if (0 > VlanTagSpeed_up)
	{
		$("#VlanTagSpeed_up").focus();
		alert("<% multilang(LANG_WRONG_RATE_VALUE_STR);%>");
		return false;
	}
	if (HaveSameUsLANQosRule(VlanTagValue_up, 2))
	{
		if (true == confirm("<% multilang(LANG_THE_RATE_LIMIT_RULES_FOR_THIS_VLAN_ALREADY_EXIST_STR);%>"))
		{
			ModifyUsLanQosRule(VlanTagValue_up, 2);
		}
		else
		{
			$("#VlanTagValue_up").focus();
			return false;
		}
	}
	else
	{
		var obj = new Object();
		obj.vlan = VlanTagValue_up;
		obj.rate =  VlanTagSpeed_up;
		IpQosConfig.usRateCtlVlanList.push(obj);
	}
	
	freshQosUsCarTable();
}

function addQosDsCarVlanRule()
{
	if (IpQosConfig.dsRateCtlVlanList.length >= 16)
	{
		alert("<% multilang(LANG_ERROR_URL_RULE_EXCEEDED_16);%>！");
		return;
	}
	
	var VlanTagValue_down = $("#VlanTagValue_down").val();
	var VlanTagSpeed_down = $("#VlanTagSpeed_down").val();

	if (0 > VlanTagValue_down || VlanTagValue_down > 4095)
	{
		$("#VlanTagValue_down").focus();
		alert("vlan <% multilang(LANG_VALID_VALUE_RANGE_STR);%> 0~4095");
		return false;
	}
	if (0 > VlanTagSpeed_down)
	{
		$("#VlanTagSpeed_down").focus();
		alert("<% multilang(LANG_WRONG_RATE_VALUE_STR);%>");
		return false;
	}
	if (HaveSameDsLANQosRule(VlanTagValue_down, 2))
	{
		if (true == confirm("<% multilang(LANG_THE_RATE_LIMIT_RULES_FOR_THIS_VLAN_ALREADY_EXIST_STR);%>"))
		{
			ModifyDsLanQosRule(VlanTagValue_down, 2);
		}
		else
		{
			$("#VlanTagValue_down").focus();
			return false;
		}
	}
	else
	{
		var obj = new Object();
		obj.vlan = VlanTagValue_down;
		obj.rate =  VlanTagSpeed_down;
		IpQosConfig.dsRateCtlVlanList.push(obj);
	}
	
	freshQosDsCarTable();
}

function addQosUsCarIpRule()
{
	if (IpQosConfig.usRateCtlIpList.length >= 16)
	{
		alert("<% multilang(LANG_ERROR_URL_RULE_EXCEEDED_16);%>！");
		return;
	}
	
	var usipaddr_type = $("#usipaddr_type").val();
	var ipaddrbegin = '';
	var ipaddrend = '';
	if (0 == usipaddr_type)
	{
		ipaddrbegin = $("#IP_Start_up").val();
		ipaddrend = $("#IP_End_up").val();
		if ((ipaddrbegin != '' && !isValidIpAddress(ipaddrbegin)) 
			|| (ipaddrend != '' && !isValidIpAddress(ipaddrend)))
		{
			alert("<% multilang(LANG_WRONG_IPV4_ADDRESS_STR);%>");
			return;
		}
	}
	else if (1 == usipaddr_type)
	{
		ipaddrbegin = $("#usipv6_src").val();
		ipaddrend = $("#usipv6_dst").val();
		if ((ipaddrbegin != '' && !isValidIpAddress6(ipaddrbegin)) 
			|| (ipaddrend != '' && !isValidIpAddress6(ipaddrend)))
		{
			alert("<% multilang(LANG_WRONG_IPV6_ADDRESS_STR);%>");
			return false;
		}
	}
	if (ipaddrbegin == '' && ipaddrend == '')
	{
		alert("<% multilang(LANG_THE_START_ADDRESS_AND_THE_END_ADDRESS_CANNOT_BE_EMPTY_AT_THE_SAME_TIME_STR);%>");
		return false;
	}
	var IPSpeed_up = $("#IPSpeed_up").val();
	if (0 > IPSpeed_up)
	{
		$("#IPSpeed_up").focus();
		alert("<% multilang(LANG_UPLINK_RATE_CANNOT_BE_NEGATIVE_STR);%>");
		return false;
	}
	var obj = new Object();
	obj.etherType = usipaddr_type;
	obj.addrBegin = ipaddrbegin;
	obj.addrEnd = ipaddrend;
	obj.rate =  IPSpeed_up;
	IpQosConfig.usRateCtlIpList.push(obj);
	
	freshQosUsCarTable();
}

function addQosDsCarIpRule()
{
	if (IpQosConfig.dsRateCtlIpList.length >= 16)
	{
		alert("<% multilang(LANG_ERROR_URL_RULE_EXCEEDED_16);%>！");
		return;
	}
	
	var dsipaddr_type = $("#dsipaddr_type").val();
	var ipaddrbegin = '';
	var ipaddrend = '';
	if (0 == dsipaddr_type)
	{
		ipaddrbegin = $("#IP_Start_down").val();
		ipaddrend = $("#IP_End_down").val();
		if ((ipaddrbegin != '' && !isValidIpAddress(ipaddrbegin)) 
			|| (ipaddrend != '' && !isValidIpAddress(ipaddrend)))
		{
			alert("<% multilang(LANG_WRONG_IPV4_ADDRESS_STR);%>");
			return;
		}
	}
	else if (1 == dsipaddr_type)
	{
		ipaddrbegin = $("#dsipv6_src").val();
		ipaddrend = $("#dsipv6_dst").val();
		if ((ipaddrbegin != '' && !isValidIpAddress6(ipaddrbegin)) 
			|| (ipaddrend != '' && !isValidIpAddress6(ipaddrend)))
		{
			alert("<% multilang(LANG_WRONG_IPV6_ADDRESS_STR);%>");
			return false;
		}
	}
	if (ipaddrbegin == '' && ipaddrend == '')
	{
		alert("<% multilang(LANG_THE_START_ADDRESS_AND_THE_END_ADDRESS_CANNOT_BE_EMPTY_AT_THE_SAME_TIME_STR);%>");
		return false;
	}
	var IPSpeed_down = $("#IPSpeed_down").val();
	if (0 > IPSpeed_down)
	{
		$("#IPSpeed_down").focus();
		alert("<% multilang(LANG_UPLINK_RATE_CANNOT_BE_NEGATIVE_STR);%>");
		return false;
	}
	var obj = new Object();
	obj.etherType = dsipaddr_type;
	obj.addrBegin = ipaddrbegin;
	obj.addrEnd = ipaddrend;
	obj.rate =  IPSpeed_down;
	IpQosConfig.dsRateCtlIpList.push(obj);
	
	freshQosDsCarTable();
}

function addQosUsCarRule()
{
	var ModeSwitch_up = $("#ModeSwitch_up").val();
	$("#select_car_qos_mode").val("car_qos");
	if (1 == ModeSwitch_up) // lan mode 
	{
		addQosUsCarLanRule();
	}
	else if (2 == ModeSwitch_up) // vlan mode
	{
		addQosUsCarVlanRule();
	}
	else if (3 == ModeSwitch_up) // ip mode
	{
		addQosUsCarIpRule();
	}
	else
	{
		return false;
	}
}

function addQosDsCarRule()
{
	var ModeSwitch_down = $("#ModeSwitch_down").val();
	if (1 == ModeSwitch_down) // lan mode 
	{
		addQosDsCarLanRule();
	}
	else if (2 == ModeSwitch_down) // vlan mode
	{
		addQosDsCarVlanRule();
	}
	else if (3 == ModeSwitch_down) // ip mode
	{
		addQosDsCarIpRule();
	}
	else
	{
		return false;
	}
}

function freshQosUsCarTable()
{
	var htmlstr = "";
	
	if (0 == $("#ModeSwitch_up").val())
	{
		return;
	}
	if (1 == $("#ModeSwitch_up").val())// car qos lan mode
	{
		htmlstr += '<input type=hidden name="uscarlan_count" value=' + IpQosConfig.usRateCtlLanList.length + '>';
		htmlstr += '<table id="us_car_lan_table" class="x_table">';
		htmlstr += '<tr>';	
		htmlstr += '<th>LAN <% multilang(LANG_INTERFACES);%></th>';
		htmlstr += '<th><% multilang(LANG_DATA_RATE);%></th>';
		htmlstr += '<th><% multilang(LANG_DELETE);%></th>';
		htmlstr += '</tr>';
		htmlstr += '</table>';
		$("#QosUsCarTableContainer").html(htmlstr);
		$.each(IpQosConfig.usRateCtlLanList, function(li, lv) {
			row = $("#us_car_lan_table").get(0).insertRow($("#us_car_lan_table").get(0).rows.length);
			row.insertCell(row.cells.length).innerHTML = strLanPortList[lv.InterfaceName_up - 1]
				+ '<input type=hidden name="InterfaceName_up' + li + '" value="' + lv.InterfaceName_up + '">';
			row.insertCell(row.cells.length).innerHTML = lv.rate
				+ '<input type=hidden name="usrate' + li + '" value="' + lv.rate + '">';
			row.insertCell(row.cells.length).innerHTML = '<input type="button" value="<% multilang(LANG_DELETE);%>" onclick="delQosUsCarRule(this);" />';
		});
	}
	else if (2 == $("#ModeSwitch_up").val()) //vlan mode
	{
		htmlstr += '<input type=hidden name="uscarvlan_count" value=' + IpQosConfig.usRateCtlVlanList.length + '>';
		htmlstr += '<table id="us_car_vlan_table" class="x_table">';
		htmlstr += '<tr>';	
		htmlstr += '<th>VLAN ID</th>';
		htmlstr += '<th><% multilang(LANG_DATA_RATE);%></th>';
		htmlstr += '<th><% multilang(LANG_DELETE);%></th>';
		htmlstr += '</tr>';
		htmlstr += '</table>';
		$("#QosUsCarTableContainer").html(htmlstr);
		$.each(IpQosConfig.usRateCtlVlanList, function(li, lv) {
			row = $("#us_car_vlan_table").get(0).insertRow($("#us_car_vlan_table").get(0).rows.length);
			row.insertCell(row.cells.length).innerHTML = lv.vlan
				+ '<input type=hidden name="usvlanId' + li + '" value="' + lv.vlan + '">';
			row.insertCell(row.cells.length).innerHTML = lv.rate
				+ '<input type=hidden name="usrate' + li + '" value="' + lv.rate + '">';
			row.insertCell(row.cells.length).innerHTML = '<input type="button" value="<% multilang(LANG_DELETE);%>" onclick="delQosUsCarRule(this);" />';
		});
	}
	else if (3 == $("#ModeSwitch_up").val()) // ip mode
	{
		htmlstr += '<input type=hidden name="uscarip_count" value=' + IpQosConfig.usRateCtlIpList.length + '>';
		htmlstr += '<table id="us_car_ip_table" class="x_table">';
		htmlstr += '<tr>';	
		htmlstr += '<th><% multilang(LANG_START_STR);%>/<% multilang(LANG_PURPOSE_STR);%> IP</th>';
		htmlstr += '<th><% multilang(LANG_DATA_RATE);%></th>';
		htmlstr += '<th><% multilang(LANG_DELETE);%></th>';
		htmlstr += '</tr>';
		htmlstr += '</table>';
		$("#QosUsCarTableContainer").html(htmlstr);
		$.each(IpQosConfig.usRateCtlIpList, function(li, lv) {
			row = $("#us_car_ip_table").get(0).insertRow($("#us_car_ip_table").get(0).rows.length);
			row.insertCell(row.cells.length).innerHTML = lv.addrBegin + '--'+ lv.addrEnd
				+ '<input type=hidden name="usetherType' + li + '" value="' + lv.etherType + '">'
				+ '<input type=hidden name="usaddrBegin' + li + '" value="' + lv.addrBegin + '">'
				+ '<input type=hidden name="usaddrEnd' + li + '" value="' + lv.addrEnd + '">';
			row.insertCell(row.cells.length).innerHTML = lv.rate
				+ '<input type=hidden name="usrate' + li + '" value="' + lv.rate + '">';
			row.insertCell(row.cells.length).innerHTML = '<input type="button" value="<% multilang(LANG_DELETE);%>" onclick="delQosUsCarRule(this);" />';
		});
	}
	else
	{
		return false;
	}
	RecalcDynamicTableHeight("QosUsCarTableContainer");
}

function freshQosDsCarTable()
{
	var htmlstr = "";
	
	if (0 == $("#ModeSwitch_down").val())
	{
		return;
	}
	if (1 == $("#ModeSwitch_down").val())// car qos lan mode
	{
		htmlstr += '<input type=hidden name="dscarlan_count" value=' + IpQosConfig.dsRateCtlLanList.length + '>';
		htmlstr += '<table id="ds_car_lan_table" class="x_table">';
		htmlstr += '<tr>';	
		htmlstr += '<th>LAN <% multilang(LANG_INTERFACES);%></th>';
		htmlstr += '<th><% multilang(LANG_DATA_RATE);%></th>';
		htmlstr += '<th><% multilang(LANG_DELETE);%></th>';
		htmlstr += '</tr>';
		htmlstr += '</table>';
		$("#QosDsCarTableContainer").html(htmlstr);
		$.each(IpQosConfig.dsRateCtlLanList, function(li, lv) {
			row = $("#ds_car_lan_table").get(0).insertRow($("#ds_car_lan_table").get(0).rows.length);
			row.insertCell(row.cells.length).innerHTML = strLanPortList[lv.InterfaceName_down - 1]
				+ '<input type=hidden name="InterfaceName_down' + li + '" value="' + lv.InterfaceName_down + '">';
			row.insertCell(row.cells.length).innerHTML = lv.rate
				+ '<input type=hidden name="dsrate' + li + '" value="' + lv.rate + '">';
			row.insertCell(row.cells.length).innerHTML = '<input type="button" value="<% multilang(LANG_DELETE);%>" onclick="delQosDsCarRule(this);" />';
		});
	}
	else if (2 == $("#ModeSwitch_down").val()) //vlan mode
	{
		htmlstr += '<input type=hidden name="dscarvlan_count" value=' + IpQosConfig.dsRateCtlVlanList.length + '>';
		htmlstr += '<table id="ds_car_vlan_table" class="x_table">';
		htmlstr += '<tr>';	
		htmlstr += '<th>VLAN ID</th>';
		htmlstr += '<th><% multilang(LANG_DATA_RATE);%></th>';
		htmlstr += '<th><% multilang(LANG_DELETE);%></th>';
		htmlstr += '</tr>';
		htmlstr += '</table>';
		$("#QosDsCarTableContainer").html(htmlstr);
		$.each(IpQosConfig.dsRateCtlVlanList, function(li, lv) {
			row = $("#ds_car_vlan_table").get(0).insertRow($("#ds_car_vlan_table").get(0).rows.length);
			row.insertCell(row.cells.length).innerHTML = lv.vlan
				+ '<input type=hidden name="dsvlanId' + li + '" value="' + lv.vlan + '">';
			row.insertCell(row.cells.length).innerHTML = lv.rate
				+ '<input type=hidden name="dsrate' + li + '" value="' + lv.rate + '">';
			row.insertCell(row.cells.length).innerHTML = '<input type="button" value="<% multilang(LANG_DELETE);%>" onclick="delQosDsCarRule(this);" />';
		});
	}
	else if (3 == $("#ModeSwitch_down").val()) // ip mode
	{
		htmlstr += '<input type=hidden name="dscarip_count" value=' + IpQosConfig.dsRateCtlIpList.length + '>';
		htmlstr += '<table id="ds_car_ip_table" class="x_table">';
		htmlstr += '<tr>';	
		htmlstr += '<th><% multilang(LANG_START_STR);%>/<% multilang(LANG_PURPOSE_STR);%> IP</th>';
		htmlstr += '<th><% multilang(LANG_DATA_RATE);%></th>';
		htmlstr += '<th><% multilang(LANG_DELETE);%></th>';
		htmlstr += '</tr>';
		htmlstr += '</table>';
		$("#QosDsCarTableContainer").html(htmlstr);
		$.each(IpQosConfig.dsRateCtlIpList, function(li, lv) {
			row = $("#ds_car_ip_table").get(0).insertRow($("#ds_car_ip_table").get(0).rows.length);
			row.insertCell(row.cells.length).innerHTML = lv.addrBegin + '--'+ lv.addrEnd
				+ '<input type=hidden name="dsetherType' + li + '" value="' + lv.etherType + '">'
				+ '<input type=hidden name="dsaddrBegin' + li + '" value="' + lv.addrBegin + '">'
				+ '<input type=hidden name="dsaddrEnd' + li + '" value="' + lv.addrEnd + '">';
			row.insertCell(row.cells.length).innerHTML = lv.rate
				+ '<input type=hidden name="dsrate' + li + '" value="' + lv.rate + '">';
			row.insertCell(row.cells.length).innerHTML = '<input type="button" value="<% multilang(LANG_DELETE);%>" onclick="delQosDsCarRule(this);" />';
		});
	}
	else
	{
		return false;
	}
	RecalcDynamicTableHeight("QosDsCarTableContainer");
}

function initEnable()
{
	var i = 0; found = 0;
	var serv_rule1 = IpQosConfig.serv_rule.replace("VOICE", "VOIP");

	for (i = 0; i < qosServRule.length; i++)
	{
		if (IpQosConfig.serv_rule == qosServRule[i])
		{
			found = 1;
			break;
		}
	}
	if (found == 0)
	{
		$("<option></option>").val(IpQosConfig.serv_rule).text(serv_rule1).appendTo("#serv_rule");
	}
	$("#serv_rule").val(IpQosConfig.serv_rule);
	
	$("#qos_enable").attr("checked", (IpQosConfig.qosType==1) ? true : false);
	ChangeQOS();
	if(IpQosConfig.qosdown_enable == 1)
		$("#qosdown_enable").attr("checked", true);
	else
		$("#qosdown_enable").attr("checked", false);
	$("#qos_bandwidth").val(IpQosConfig.qos_usrate);
	if (IpQosConfig.qos_mode == 2)
		IpQosConfig.qos_mode = 0;
	$("#qos_mode").val(IpQosConfig.qos_mode);
	$("#enableDSCP").val(IpQosConfig.enableDSCP);	
	$("#enable8021p").val(IpQosConfig.enable8021p);
	$("#enableTC").val(IpQosConfig.enableTC);
	$("#ModeSwitch_up").val(IpQosConfig.usRateCtlMode);
	$("#ModeSwitch_down").val(IpQosConfig.dsRateCtlMode);
	for (i = 0; i < IpQosConfig.qosQueueList.length; i++)
	{
		if (IpQosConfig.qosQueueList[i].qid > 0)
		{
			$("#q" + IpQosConfig.qosQueueList[i].qid + "_weight").val(IpQosConfig.qosQueueList[i].weight);
			$("#q" + IpQosConfig.qosQueueList[i].qid + "_enable").attr("checked", IpQosConfig.qosQueueList[i].enable?true:false);
		}
	}
}
function ChangeQOS()
{
	if ($("#qos_enable").prop("checked") == true)
	{
		$("#qosvalue").val("1");
	}
	else
	{
		$("#qosvalue").val("0");
	}
	return true;
}
function onUsCarLanPort()
{
	$("#usrate").val('');
}

function onDsCarLanPort()
{
	$("#dsrate").val('');
}

function initLanPort()
{
	var i = 0;
	
	strLanPortList = new Array("LAN1", "LAN2", "LAN3", "LAN4", "", "", "", "");
	for (i = 0; i < Ont.LanNum; i++)
	{
		strLanPortList[i] ="LAN" + (i + 1);
	}

	if (Ont.WifiNum == 1)
	{
		for (i = 0; i < 4; i++)
		{
			strLanPortList[Ont.LanNum + i] = "SSID" + (i + 1);
		}
	}
	else if (Ont.WifiNum == 2)
	{
		for (i = 0; i < 8; i++)
		{
			strLanPortList[Ont.LanNum + i] = "SSID" + (i + 1);
		}
	}

	$.each(strLanPortList, function(li, lv) {
		if (lv.length > 0)
		{
			if(li<Ont.LanNum||li>=Ont.LanNum){
				$("<option></option>").val(li + 1).text(lv).appendTo("#pq_lanport");
				$("<option></option>").val(li + 1).text(lv).appendTo("#pq_lanport_end");
			}
			
		}			
	});
	
	$.each(WanList, function(li, lv) {
		$("<option></option>").val(lv.index + 1).text(GetWanName(lv)).appendTo("#pq_wanport");
	});

	$.each(strLanPortList, function(li, lv) {
		if (lv.length > 0)
		{
			$("<option></option>").val(li + 1).text(lv).appendTo("#InterfaceName_up");
		}
	});
	
	$.each(strLanPortList, function(li, lv) {
		if (lv.length > 0)
		{
			$("<option></option>").val(li + 1).text(lv).appendTo("#InterfaceName_down");
		}
	});
}

function onQosMode()
{
	var qos_mode = $("#qos_mode").val();
	$("#select_car_qos_mode").val("");
	if (0 == qos_mode)
	{
		$("#div_qos_pq").show();
		$("#qos_queue_priority").show();
		$("#qos_queue_weight").hide();
		onEtherType();
		onWanType();
		freshQosPqTable();
	}
	else if (1 == qos_mode)
	{
		$("#div_qos_pq").show();
		$("#qos_queue_priority").hide();
		$("#qos_queue_weight").show();
		onEtherType();
		onWanType();
		freshQosPqTable();
	}
	else if (2 == qos_mode)
	{
		$("#div_qos_pq").hide();
	}
}

function onUsCarMode()
{
	var ModeSwitch_up = $("#ModeSwitch_up").val();
	$("#div_us_interface_qos").hide();
	$("#div_us_vlan_qos").hide();
	$("#div_us_ip_qos").hide();	
	$("#add_uscarrule").show();
	
	if (0 == ModeSwitch_up)//off
	{
		$("#add_uscarrule").hide();
	}
	else if (1 == ModeSwitch_up)//interface
	{
		$("#div_us_interface_qos").show();
	}
	else if (2 == ModeSwitch_up)//vlanid
	{
		$("#div_us_vlan_qos").show();
	}
	else if (3 == ModeSwitch_up)//ip
	{
		onUsIpaddr();
		$("#div_us_ip_qos").show();		
	}
	else//error occur
	{
		$("#add_uscarrule").hide();
		alert("<% multilang(LANG_AN_ILLEGAL_VALUE_IS_SELECTED_FOR_THE_UPLINK_SPEED_LIMIT_MODE_STR);%>！");
		return false;
	}
	freshQosUsCarTable();
}

function onDsCarMode()
{
	var ModeSwitch_down = $("#ModeSwitch_down").val();
	$("#div_ds_interface_qos").hide();
	$("#div_ds_vlan_qos").hide();
	$("#div_ds_ip_qos").hide();	
	$("#add_dscarrule").show();
	
	if (0 == ModeSwitch_down)//off
	{
		$("#add_dscarrule").hide();
	}
	else if (1 == ModeSwitch_down)//interface
	{
		$("#div_ds_interface_qos").show();
	}
	else if (2 == ModeSwitch_down)//vlanid
	{
		$("#div_ds_vlan_qos").show();
	}
	else if (3 == ModeSwitch_down)//ip
	{
		onDsIpaddr();
		$("#div_ds_ip_qos").show();		
	}
	else//error occur
	{
		$("#add_dscarrule").hide();
		alert("<% multilang(LANG_AN_ILLEGAL_VALUE_IS_SELECTED_FOR_THE_DOWNLINK_SPEED_LIMIT_MODE_STR);%>！");
		return false;
	}
	freshQosDsCarTable();
}

function ip_qos_web_init()
{
	initEnable();
	initLanPort();
	onServRule();
	onQosMode();
	onUsCarMode();
	onDsCarMode();
	RecalcHelpHeight();
}

function checkValue()
{
	if ($("#qos_bandwidth").val() != "" 
		&& (parseInt($("#qos_bandwidth").val()) < 0 || parseInt($("#qos_bandwidth").val()) > 1024000))
	{
		alert("<% multilang(LANG_PLEASE_ENTER_THE_CORRECT_BANDWIDTH_VALUE_STR);%>！");
		return false;
	}
	
	if ($("#qos_mode").val() == 1)
	{
	
	    if (($("#q1_weight").val() <0) || ($("#q2_weight").val() < 0)
		     ||($("#q3_weight").val() < 0) || ($("#q4_weight").val() < 0)
			 ||($("#q5_weight").val() < 0)||($("#q6_weight").val() < 0)
			 ||($("#q7_weight").val() < 0)||($("#q8_weight").val() < 0))
		{
		    alert("<% multilang(LANG_WEIGHT_NEED_STR);%>>=0！");
		    return false;
		}	 

		if ((parseInt($("#q1_weight").val() )+parseInt($("#q2_weight").val())
		     +parseInt($("#q3_weight").val() ) + parseInt($("#q4_weight").val())
			 +parseInt($("#q5_weight").val() ) + parseInt($("#q6_weight").val())
			 +parseInt($("#q7_weight").val() ) + parseInt($("#q8_weight").val()))!=100)
		{
		    alert("<% multilang(LANG_ALL_WEIGHTS_NEED_TO_BE_EQUAL_TO_STR);%> 100！");
		    return false;
		}	 
	}
	
	return true;
}

function onServRule()
{
	var i = 0;
	for (i = 0; i < 5; i++)
	{
		IpQosConfig.qosServList[i].serv_type = (i + 1).toString();
		IpQosConfig.qosServList[i].serv_queue = "0";
	}

	var serv_rule = $("#serv_rule").val();
    //serv_rule = serv_rule.replace(",INTERNET", "");
    //serv_rule = serv_rule.replace("INTERNET,", "");
	nameParts = serv_rule.split(",");
	for (i = 0; i < nameParts.length; i++)
	{
		if (nameParts[i] == "TR069")
		{
			IpQosConfig.qosServList[i].serv_type = "1";
			IpQosConfig.qosServList[i].serv_queue = nameParts.length-i;
			//$("#q1_enable").attr("checked", true);
		}
		else if ((nameParts[i] == "VOIP") || (nameParts[i] == "VOICE"))
		{
			IpQosConfig.qosServList[i].serv_type = "2";
			IpQosConfig.qosServList[i].serv_queue = nameParts.length-i;
			//$("#q2_enable").attr("checked", true);
		}
		else if (nameParts[i] == "IPTV")
		{
			IpQosConfig.qosServList[i].serv_type = "3";
			IpQosConfig.qosServList[i].serv_queue = nameParts.length-i;
			//$("#q3_enable").attr("checked", true);
		}
		else if (nameParts[i] == "OTHER")
		{
			IpQosConfig.qosServList[i].serv_type = "4";
			IpQosConfig.qosServList[i].serv_queue = nameParts.length-i ;
			//$("#q4_enable").attr("checked", true);
		}
		else if (nameParts[i] == "INTERNET")
		{
			IpQosConfig.qosServList[i].serv_type = "5";
			IpQosConfig.qosServList[i].serv_queue = nameParts.length-i;
		}
	}

	freshServiceTable();
}

function onUniType()
{
	var pq_unitype = $("#pq_unitype").val();
	if (0 == pq_unitype)
	{
		//$("#div_pq_lanport").hide();
		//$("#div_pq_wanport").hide();
		$("#div_pq_ether").show();
	} else if (1 == pq_unitype) {
		//$("#div_pq_lanport").show();
		//$("#div_pq_wanport").hide();
		$("#div_pq_ether").hide();
	} else {
		//$("#div_pq_lanport").hide();
		//$("#div_pq_wanport").show();
		$("#div_pq_ether").hide();
	}
}

function onProtoType()
{
	var protoType = $("#proto_type").val();
	$("#ul_src_port_start").hide();
	//$("#ul_src_port_end").hide();
	$("#ul_dst_port_start").hide();
	//$("#ul_dst_port_end").hide();
	if (aryProtocolType.NET_PROTO_TCP == protoType || 
		aryProtocolType.NET_PROTO_UDP == protoType || 
		aryProtocolType.NET_PROTO_TCP_UDP == protoType)
	{
		$("#ul_src_port_start").show();
		//$("#ul_src_port_end").show();
		$("#ul_dst_port_start").show();
		//$("#ul_dst_port_end").show();
	}
}

function onEtherType()
{
	var etherType = $("#ether_type").val();
	var wanType = $("#pq_wanport").val();
	$("#div_ipv4_srcip").hide();
	$("#div_ipv4_dstip").hide();
	$("#div_ipv6_srcip").hide();
	$("#div_ipv6_dstip").hide();
	$("#div_ipv4_dscp").hide();
	$("#div_ipv6_traffic").hide();
	$("#ul_mark_ipv6_tc").hide();
	$("#ul_mark_ipv4_dscp").hide();	
	if (1 == etherType)
	{
		$("#div_ipv4_srcip").show();
		$("#div_ipv4_dstip").show();
		$("#div_ipv4_dscp").show();
		$("#ul_mark_ipv4_dscp").show();
	}
	else if (2 == etherType)
	{
	
		$("#div_ipv6_srcip").show();
		$("#div_ipv6_dstip").show();
		$("#div_ipv6_traffic").show();
		$("#ul_mark_ipv6_tc").show();
	}
	else
	{
		$("#ul_mark_ipv4_dscp").show();
	}
}

function onWanType()
{
	return 0;
}

function onTosDscpType()
{
    if ($("#tos_dscp").val() == 1)
	{
        $("#dscp").attr("maxLength", "8");
	}
	else
	{
        $("#dscp").attr("maxLength", "2");
	}
}

function onUsIpaddr()
{
	var usipaddr_type = $("#usipaddr_type").val();
	$("#div_us_ipv4_qos").hide();
	$("#div_us_ipv6_qos").hide();
	if (0 == usipaddr_type)
	{
		$("#div_us_ipv4_qos").show();
	}
	else if (1 == usipaddr_type)
	{
		$("#div_us_ipv6_qos").show();
	}
	else
	{
		alert("qos: ip addr type invliad.");
		return false;
	}
}

function onDsIpaddr()
{
	var dsipaddr_type = $("#dsipaddr_type").val();
	$("#div_ds_ipv4_qos").hide();
	$("#div_ds_ipv6_qos").hide();
	if (0 == dsipaddr_type)
	{
		$("#div_ds_ipv4_qos").show();
	}
	else if (1 == dsipaddr_type)
	{
		$("#div_ds_ipv6_qos").show();
	}
	else
	{
		alert("qos: ip addr type invliad.");
		return false;
	}
}

function ip_qos_web_submit()
{
	if(top.window.XWebCurTrdMenuId==""||top.window.XWebCurTrdMenuId=="qos_cfg"){
		if (false == checkValue())
			return;

		$("#XForm").submit();
	}else if(top.window.XWebCurTrdMenuId=="qosdown_cfg"){
		$("#downQosform").submit();
	}else if(top.window.XWebCurTrdMenuId=="div_qos_car"){
		$("#carQosform").submit();
	}
}
//]]>
</script>
<script type="text/javascript">

$(function() {
	if (window.top.location.href == window.location.href)
	{
		window.location.href = "/index.html";
		return;
	}
	$.each(Ont.MainMenu, function(mi, mv){
		if (mv.id == Ont.CurMainMenu)
		{
			/*
			if (mv.id == "help")
			{
				initHelpMenu(mv.submenu);
			}
			*/
			$.each(mv.submenu, function(smi, smv){
				if (smv.id == Ont.CurSubMenu)
				{
					//alert("CurLoginUser:"+Ont.CurLoginUser);
					if (!isSubMenuShow(smv))
					{
						window.top.location.href = "/admin/login.asp";
					}
					return false;
				}
			});
			return false;
		}
	});

	window.Ont.InitProvince();

	WriteMainMenu();
	WriteSubMenu();
	WebInit();
	initMainContent();

	$S("XWebPageName", Ont.CurSubMenu);
	$("#XForm").attr("action", "/boaform/admin/" + Ont.CurSubMenu + "_Form");

	setTimeout(function(){window.top.location.href = "logout.html";}, Ont.LogoutTimeout);
	
	$("#logout").click(function() {
		window.top.location.href = "logout.html";
	});
	
	$("#btn_cancel").click(function() {
		onCancel();
	});

	$("#login_username").html(Ont.CurUserName);
	$("#logout").html(Ont.StrLogout);
	//$("#ont_name").html(Ont.StrOntName);
	//$("#ont_model").html(Ont.StrOntModel.replace("/(^_*)|(_*$)/g", ""));

	$(".x_table tr:nth-child(even)").addClass("even");
	$(".x_table tr:nth-child(odd)").addClass("odd");
	var webdevicename=Ont.Webdevicename + "<% multilang(LANG_INTEGRATED_ENTERPRISE_GATEWAY);%>";
	$("#device_name").html(webdevicename);
});

function onCancel()
{
	window.location.reload();
}

$(function() {  
	$("#act_priority_enable,#act_DSCP_priority_enable,#mark_ipv6_tc_enable").each(function(){    
             if($(this).is(':checked')){   
				   $("#"+$(this).attr("name").replace("_enable","")).prop('disabled', false);
            } else {   
                   $("#"+$(this).attr("name").replace("_enable","")).prop('disabled', true);
            }    
        }); 
	$("#act_priority_enable,#act_DSCP_priority_enable,#mark_ipv6_tc_enable").bind("click",function(){    
             if($(this).is(':checked')){   
				   $("#"+$(this).attr("name").replace("_enable","")).prop('disabled', false);
            } else {   
                   $("#"+$(this).attr("name").replace("_enable","")).prop('disabled', true);
            }    
       });
	   $('#pq_lanport_end_div').hide();
	  $('#pq_lanport').on('change',function(){
		if($(this).val()==0){
			$('#pq_lanport_end_div').hide(); 
		}else{
			$('#pq_lanport_end_div').show(); 
		}
	});

 });  


</script>
</head>
<body id="x_root_body">

<div id="header">
	<div id="logo"></div>
	<div id="header_info">
		<div id="dev_info"><% multilang(LANG_TERM_MODEL);%>：<span id="device_name"></span></div>
		<div id="user_info"><% multilang(LANG_WELCOME);%>，<span id="login_username">admin</span>
		<a href="#" id="logout"></a>
		</div>
	</div>
</div>

<div id="menu">
	<div id="main_menu"></div>
</div>

<div id="container">

<div id="nav">
	<div id="nav_header"></div>
	<div id="sub_menu"></div>
</div>

<div id="maincontent">

<div id="content">
<div id="errmessage" class="x_message"></div>
<form id="XForm" name="XForm" method="post" action="">
<input id="XWebPageName" name="XWebPageName" type="hidden" value="" />


<div id="hidebg"></div>
<div id="hidebox">
</div>
<script type="text/javascript">WriteMainTitle("<% multilang(LANG_UPSTREAM_QOS_CONFIGURATION_STR);%>", "qos_cfg");</script>
<div id="x_qos_cfg" class="x_main_content">

<div class="x_sub_title"><% multilang(LANG_UPSTREAM_QOS_CONFIGURATION_STR);%></div>
<div class="x_form_area">
	<ul class="x_form_line" >
		<li class="x_form_caption"><% multilang(LANG_ENABLE_QOS_CONFIGURATION_STR);%>：</li>
		<li class="x_form_input">
			<input type="checkbox" id="qos_enable" name="qos_enable"/>
			<input type="hidden" name="qosType" id="qosvalue" />
		</li>
	</ul>
	 <ul class="x_form_line" >
		<li class="x_form_caption"><% multilang(LANG_UPSTREAM_BANDWIDTH_STR);%>：</li>
		<li class="x_form_input">
			<input id="qos_bandwidth" name="qos_bandwidth" maxlength="7" style="width:90px"/>
			(0-1024000)Kbps</li>
	</ul>
	<ul class="x_form_line" onmouseover="$H('QoS <% multilang(LANG_SCHEDULING_STRATEGY_STR);%>');" onmouseout="$H();" >
		<li class="x_form_caption"><% multilang(LANG_SCHEDULING_STRATEGY_STR);%>：</li>
		<li class="x_form_input">
			<select id="qos_mode" name="qos_mode" style="width:160px">
				<option value="0" selected>SP (<% multilang(LANG_STRICT_PRIORITY_STR);%>)</option>
				<option value="1">WRR (<% multilang(LANG_WEIGHTED_ROUND_ROBIN_STR);%>)</option>
			</select>
		</li>
	</ul>
	<ul class="x_form_line" onmouseover="$H('DSCP <% multilang(LANG_PRIORITY_MARKING_MODE_STR);%>');" onmouseout="$H();" >
		<li class="x_form_caption">DSCP <% multilang(LANG_PRIORITY_MARKING_MODE_STR);%>：</li>
		<li class="x_form_input">
			<select id="enableDSCP" name="enableDSCP" style="width:160px">
				<option value="0" selected><% multilang(LANG_DISABLED);%></option>
				<option value="1"><% multilang(LANG_WLAN_SCHEDULE_ENA);%></option>
			</select>
		</li>
	</ul>
	<ul class="x_form_line" onmouseover="$H('TC <% multilang(LANG_PRIORITY_MARKING_MODE_STR);%>');" onmouseout="$H();" >
		<li class="x_form_caption">TC <% multilang(LANG_PRIORITY_MARKING_MODE_STR);%>：</li>
		<li class="x_form_input">
			<select id="enableTC" name="enableTC" style="width:160px">
				<option value="0" selected><% multilang(LANG_DISABLED);%></option>
				<option value="1"><% multilang(LANG_WLAN_SCHEDULE_ENA);%></option>
			</select>
		</li>
	</ul>
	<ul class="x_form_line" onmouseover="$H('QoS <% multilang(LANG_PRIORITY_MARKING_MODE_STR);%>');" onmouseout="$H();" >
		<li class="x_form_caption">802.1p <% multilang(LANG_PRIORITY_MARKING_MODE_STR);%>：</li>
		<li class="x_form_input">
			<select id="enable8021p" name="enable8021p" style="width:160px">
				<option value="0" selected>0 <% multilang(LANG_MARK);%></option>
				<option value="1"><% multilang(LANG_KEEP_THE_ORIGINAL_FLAG_BIT_VALUE_STR);%></option>
				<option value="2"><% multilang(LANG_REWRITE_FLAG_VALUE_STR);%></option>
			</select>
		</li>
	</ul>
	

<script type="text/javascript">WriteDivideLine();</script>

<div id="div_qos_pq">
	<ul class="x_form_line">
		<li class="x_form_caption"><% multilang(LANG_BASED_ON_TRAFFIC_CLASSIFICATION_STR);%> QoS</li>
		<li class="x_form_input"></li>
	</ul>
	<ul class="x_form_line">
		<li class="x_form_caption"><% multilang(LANG_RULE_TEMPLATE_STR);%>：</li>
		<li class="x_form_input">
			<select id="serv_rule" name="serv_rule">
				<option value="OTHER" >OTHER</option>
				<option value="TR069,INTERNET" >TR069,INTERNET</option>
				<option value="VOICE,TR069,INTERNET" >VOICE,TR069,INTERNET</option>
				<option value="IPTV,TR069,INTERNET" >IPTV,TR069,INTERNET</option>
				<option value="VOICE,IPTV,TR069,INTERNET" >VOICE,IPTV,TR069,INTERNET</option>
				<option value="TR069,VOICE,IPTV,INTERNET" >TR069,VOICE,IPTV,INTERNET</option>
				<option value="IPTV,VOICE,TR069,INTERNET" >IPTV,VOICE,TR069,INTERNET</option>
			</select>
		</li>
	</ul>
</div>

	<table class="x_table" id="qos_queue_priority" style="display:none">
		<tr>
			<th><% multilang(LANG_QUEUE_STR);%></th>
			<th><% multilang(LANG_PRIORITY);%></th>
			<th><% multilang(LANG_MAC_MAP_ENABLE);%></th>
		</tr>
		<tr>
			<td>Q1</td>
			<td><% multilang(LANG_HIGHEST_STR);%></td>
			<td><input type="checkbox" id="q1_enable" name="q1_enable" value="1"/></td>
		</tr>
		<tr>
			<td>Q2</td>
			<td><% multilang(LANG_HIGHER_STR);%></td>
			<td><input type="checkbox" id="q2_enable" name="q2_enable" value="1"/></td>
		</tr>
		<tr>
			<td>Q3</td>
			<td><% multilang(LANG_HIGH);%></td>
			<td><input type="checkbox" id="q3_enable" name="q3_enable" value="1"/></td>
		</tr>
		<tr>
			<td>Q4</td>
			<td><% multilang(LANG_SECOND_HIGHEST_STR);%></td>
			<td><input type="checkbox" id="q4_enable" name="q4_enable" value="1"/></td>
		</tr>
		<tr>
			<td>Q5</td>
			<td><% multilang(LANG_MEDIUM);%></td>
			<td><input type="checkbox" id="q5_enable" name="q5_enable" value="1"/></td>
		</tr>
		<tr>
			<td>Q6</td>
			<td><% multilang(LANG_SECONDARY_STR);%></td>
			<td><input type="checkbox" id="q6_enable" name="q6_enable" value="1"/></td>
		</tr>
		<tr>
			<td>Q7</td>
			<td><% multilang(LANG_LOW);%></td>
			<td><input type="checkbox" id="q7_enable" name="q7_enable" value="1"/></td>
		</tr>
		<tr>
			<td>Q8</td>
			<td><% multilang(LANG_LOWEST_STR);%></td>
			<td><input type="checkbox" id="q8_enable" name="q8_enable" value="1"/></td>
		</tr>
	</table>
	<table id="qos_queue_weight" class="x_table" style="display:none">
		<tr>
			<th><% multilang(LANG_QUEUE_STR);%></th>
			<th><% multilang(LANG_LOWEST_STR);%></th>
		</tr>
		<tr>
			<td>Q1</td>
			<td><input id="q1_weight" name="q1_weight" maxlength="2" size="5"/></td>
		</tr>
		<tr>
			<td>Q2</td>
			<td><input id="q2_weight" name="q2_weight" maxlength="2" size="5"/></td>
		</tr>
		<tr>
			<td>Q3</td>
			<td><input id="q3_weight" name="q3_weight" maxlength="2" size="5"/></td>
		</tr>
		<tr>
			<td>Q4</td>
			<td><input id="q4_weight" name="q4_weight" maxlength="2" size="5"/></td>
		</tr>
		<tr>
			<td>Q5</td>
			<td><input id="q5_weight" name="q5_weight" maxlength="2" size="5"/></td>
		</tr>
		<tr>
			<td>Q6</td>
			<td><input id="q6_weight" name="q6_weight" maxlength="2" size="5"/></td>
		</tr>
		<tr>
			<td>Q7</td>
			<td><input id="q7_weight" name="q7_weight" maxlength="2" size="5"/></td>
		</tr>
		<tr>
			<td>Q8</td>
			<td><input id="q8_weight" name="q8_weight" maxlength="2" size="5"/></td>
		</tr>
	</table>

<script type="text/javascript">WriteDynamicTable("", "QosServiceTableContainer");</script>
<script type="text/javascript">WriteDivideLine();</script>

	<ul class="x_form_line">
		<li class="x_form_caption"><b><% multilang(LANG_CLASSIFICATION_RULES);%></b></li>
		<li class="x_form_input">
		</li>
	</ul>
	<div id="div_pq_port"  style="display:none">
	<ul class="x_form_line" onmouseover="$H('');" onmouseout="$H();" >
		<li class="x_form_caption">LAN/WAN <% multilang(LANG_INTERFACES);%>：</li>
		<li class="x_form_input">
			<select id="pq_unitype" style="width:90px">
				<option value="0">All</>
				<option value="1">LAN <% multilang(LANG_INTERFACES);%></>
				<option value="2">WAN <% multilang(LANG_INTERFACES);%></>
			</select>
		</li>
	</ul>
	</div>
	<div id="div_pq_lanport">
	<ul class="x_form_line" onmouseover="$H('');" onmouseout="$H();" >
		<li class="x_form_caption">LAN <% multilang(LANG_INTERFACES);%>：</li>
		<li class="x_form_input">
			<select id="pq_lanport">
				<option value="0">ALL</>
			</select>
		</li>
	</ul>
	</div>
	<div id="pq_lanport_end_div">
	<ul class="x_form_line" onmouseover="$H('');" onmouseout="$H();" >
		<li class="x_form_caption"></li>
		<li class="x_form_input">			
				<select id="pq_lanport_end">
					<option value="0">ALL</>
				</select>				
		</li>
	</ul>
	</div>	
	<div id="div_pq_wanport">
	<ul class="x_form_line" onmouseover="$H('');" onmouseout="$H();" >
		<li class="x_form_caption">WAN <% multilang(LANG_INTERFACES);%>：</li>
		<li class="x_form_input">
			<select id="pq_wanport">
				<option value="0">ALL</>
			</select>
		</li>
	</ul>
	</div>
	<div id="div_pq_ether">
		<ul class="x_form_line" onmouseover="$H('');" onmouseout="$H();" >
			<li class="x_form_caption"><% multilang(LANG_LOOP_DETECTION_ETHER_TYPE);%>：</li>
			<li class="x_form_input">
				<select id="ether_type" style="width:90px">
					<option value="1" selected>IPv4</option>
					<option value="2">IPv6</option>
					<option value="3">All</option>
				</select>
			</li>
		</ul>
		<div id="div_proto_type" style="">
		<ul class="x_form_line" onmouseover="$H('');" onmouseout="$H();" >
			<li class="x_form_caption"><% multilang(LANG_PROTOCOL_STR);%>：</li>
			<li class="x_form_input">
				<select id="proto_type" style="width:90px">
					<script>
					for (i = 0; i < IpQosConfig.support_protocols.length; i++)
					{
						if(IpQosConfig.support_protocols[i][2])
							document.write('<option value="'+IpQosConfig.support_protocols[i][1]+'" selected >'+IpQosConfig.support_protocols[i][0]+'</option>');
						else
							document.write('<option value="'+IpQosConfig.support_protocols[i][1]+'">'+IpQosConfig.support_protocols[i][0]+'</option>');
				
					}
					</script>					
				</select>
			</li>
		</ul>
		</div>
		<div id="div_vlanid" style="">
		<ul class="x_form_line" onmouseover="$H('');" onmouseout="$H();">
			<li class="x_form_caption">VLAN：</li>
			<li class="x_form_input">
				<input id="vlanid" size="8" maxlength="4" onkeypress="return OnKeyPress(event, X_INPUT_NUM);" />
				<!--
				-
				<input id="vlanid_end" size="8" maxlength="4" onkeypress="return OnKeyPress(event, X_INPUT_NUM);" />
				-->
			</li>
		</ul>
		<ul class="x_form_line" onmouseover="$H('');" onmouseout="$H();">
			<li class="x_form_caption">802.1P：</li>
			<li class="x_form_input">
				<input id="vlan_8021p" size="8" maxlength="4" onkeypress="return OnKeyPress(event, X_INPUT_NUM);" />
				<!--
				-
				<input id="vlan_8021p_end" size="8" maxlength="4" onkeypress="return OnKeyPress(event, X_INPUT_NUM);" />
				-->
			</li>
		</ul>
		</div>
		<div id="div_ipv4_dscp" style="">
			<ul class="x_form_line" onmouseover="$H('');" onmouseout="$H();">
				<li class="x_form_caption">tos/dscp：</li>
				<li class="x_form_input">
				<select id="tos_dscp" style="width:90px">
					<option value="1">TOS</option>
					<option value="2" selected>DSCP</option>
				</select>
			</li>
			</ul>

			<ul class="x_form_line" onmouseover="$H('');" onmouseout="$H();">
				<li class="x_form_caption">tos/dscp：</li>
				<li class="x_form_input">
					<input id="dscp" size="8" maxlength="2" onkeypress="return OnKeyPress(event, X_INPUT_NUM);" />
					-
					<input id="dscp_end" size="8" maxlength="2" onkeypress="return OnKeyPress(event, X_INPUT_NUM);" />
				</li>
			</ul>
		</div>
		<div id="div_ipv6_traffic" style="display:none">
			<ul class="x_form_line" onmouseover="$H('');" onmouseout="$H();">
				<li class="x_form_caption">Traffic class</li>
				<li class="x_form_input">
					<input id="ipv6_tc" size="8" maxlength="2" onkeypress="return OnKeyPress(event, X_INPUT_NUM);" />
					-
					<input id="ipv6_tc_end" size="8" maxlength="2" onkeypress="return OnKeyPress(event, X_INPUT_NUM);" />
				</li>
			</ul>
		</div>
		<div id="div_pbit" style="display:none">
		<ul class="x_form_line" onmouseover="$H('');" onmouseout="$H();" >
			<li class="x_form_caption">pbit：</li>
			<li class="x_form_input"><input id="pbit" size="8" maxlength="1" onkeypress="return OnKeyPress(event, X_INPUT_NUM);" /></li>
		</ul>
		</div>
		<div id="div_src_mac" style="">
		<ul class="x_form_line" onmouseover="$H('');" onmouseout="$H();">
			<li class="x_form_caption"><% multilang(LANG_SRC_MAC);%>：</li>
			<li class="x_form_input">
				<input id='src_mac' size="20" onkeypress="return OnKeyPress(event, X_INPUT_MAC);" />
				-
				<input id='src_mac_end' size="20" onkeypress="return OnKeyPress(event, X_INPUT_MAC);" />
			</li>
		</ul>
		</div>
		<div id="div_dst_mac" style="">
		<ul class="x_form_line" onmouseover="$H('');" onmouseout="$H();">
			<li class="x_form_caption"><% multilang(LANG_DST_MAC);%>：</li>
			<li class="x_form_input">
				<input id='dst_mac' size="20" onkeypress="return OnKeyPress(event, X_INPUT_MAC);" />
				-
				<input id='dst_mac_end' size="20" onkeypress="return OnKeyPress(event, X_INPUT_MAC);" />
			</li>
		</ul>
		</div>
		<div id="div_ipv4_srcip" style="display:none">
			<ul class="x_form_line" onmouseover="$H('');" onmouseout="$H();" >
				<li class="x_form_caption"><% multilang(LANG_SRC_IP_START_ADDRESS);%>：</li>
				<li class="x_form_input">
					<input id="ipv4_srcip" size="26" maxlength="15" onkeypress="return OnKeyPress(event, X_INPUT_IP);" />
				</li>
			</ul>
			<ul class="x_form_line" onmouseover="$H('');" onmouseout="$H();" >
				<li class="x_form_caption"><% multilang(LANG_SRC_IP_END_ADDRESS);%>：</li>
				<li class="x_form_input">
					<input id="ipv4_srcip_end" size="26" maxlength="15" onkeypress="return OnKeyPress(event, X_INPUT_IP);" />
				</li>
			</ul>
		</div>
		<div id="div_ipv4_dstip" style="display:none">
			<ul class="x_form_line" onmouseover="$H('');" onmouseout="$H();" >
				<li class="x_form_caption"><% multilang(LANG_DST_IP_START_ADDRESS);%>：</li>
				<li class="x_form_input">
					<input id="ipv4_dstip" size="26" maxlength="15" onkeypress="return OnKeyPress(event, X_INPUT_IP);" />
				</li>
			</ul>
			<ul class="x_form_line" onmouseover="$H('');" onmouseout="$H();" >
				<li class="x_form_caption"><% multilang(LANG_DST_IP_END_ADDRESS);%>：</li>
				<li class="x_form_input">
					<input id="ipv4_dstip_end" size="26" maxlength="15" onkeypress="return OnKeyPress(event, X_INPUT_IP);" />
				</li>
			</ul>
		</div>
		<div id="div_ipv6_srcip" style="display:none">
			<ul class="x_form_line" onmouseover="$H('');" onmouseout="$H();" >
				<li class="x_form_caption"><% multilang(LANG_SOURCE_START_IPV6_ADDRESS_STR);%>：</li>
				<li class="x_form_input">
					<input id="ipv6_srcip" size="30" maxlength="64" onkeypress="return OnKeyPress(event, X_INPUT_IPV6);" />
				</li>
			</ul>
			<ul class="x_form_line" onmouseover="$H('');" onmouseout="$H();" >
				<li class="x_form_caption"><% multilang(LANG_SOURCE_END_IPV6_ADDRESS_STR);%>：</li>
				<li class="x_form_input">
					<input id="ipv6_srcip_end" size="30" maxlength="64" onkeypress="return OnKeyPress(event, X_INPUT_IPV6);" />
				</li>
			</ul>
		</div>
		<div id="div_ipv6_dstip" style="display:none">
			<ul class="x_form_line" onmouseover="$H('');" onmouseout="$H();" >
				<li class="x_form_caption"><% multilang(LANG_DESTINATION_START_IPV6_ADDRESS_STR);%>：</li>
				<li class="x_form_input">
					<input id="ipv6_dstip" size="30" maxlength="64" onkeypress="return OnKeyPress(event, X_INPUT_IPV6);" />
				</li>
			</ul>
			<ul class="x_form_line" onmouseover="$H('');" onmouseout="$H();" >
				<li class="x_form_caption"><% multilang(LANG_DESTINATION_END_IPV6_ADDRESS_STR);%>：</li>
				<li class="x_form_input">
					<input id="ipv6_dstip_end" size="30" maxlength="64" onkeypress="return OnKeyPress(event, X_INPUT_IPV6);" />
				</li>
			</ul>
		</div>
		<ul id="ul_src_port_start" class="x_form_line" onmouseover="$H('');" onmouseout="$H();" >
			<li class="x_form_caption"><% multilang(LANG_SRC_IP_START_PORT);%>：</li>
			<li class="x_form_input">
				<input id="srcport_start" size="8" maxlength="5" onkeypress="return OnKeyPress(event, X_INPUT_NUM);" />
				-
				<input id="srcport_end" size="8" maxlength="5" onkeypress="return OnKeyPress(event, X_INPUT_NUM);" />
			</li>
		</ul>
		<!--
		<ul id="ul_src_port_end" class="x_form_line" onmouseover="$H('');" onmouseout="$H();" >
			<li class="x_form_caption">源结束端口：</li>
			<li class="x_form_input">
				<input id="srcport_end" size="8" maxlength="5" onkeypress="return OnKeyPress(event, X_INPUT_NUM);" />
			</li>
		</ul>
		-->
		<ul id="ul_dst_port_start" class="x_form_line" onmouseover="$H('');" onmouseout="$H();" >
			<li class="x_form_caption"><% multilang(LANG_DST_IP_START_PORT);%>：</li>
			<li class="x_form_input">
				<input id="dstport_start" size="8" maxlength="5" onkeypress="return OnKeyPress(event, X_INPUT_NUM);" />
				-
				<input id="dstport_end" size="8" maxlength="5" onkeypress="return OnKeyPress(event, X_INPUT_NUM);" />
			</li>
		</ul>
		<!--
		<ul id="ul_dst_port_end" class="x_form_line" onmouseover="$H('');" onmouseout="$H();" >
			<li class="x_form_caption">目的结束端口：</li>
			<li class="x_form_input">
				<input id="dstport_end" size="8" maxlength="5" onkeypress="return OnKeyPress(event, X_INPUT_NUM);" />
			</li>
		</ul>
		-->
	</div>
	<ul class="x_form_line">
		<li class="x_form_caption"><b><% multilang(LANG_PERFORM_ACTIONS_STR);%></b></li>
		<li class="x_form_input">
		</li>
	</ul>
	<ul class="x_form_line" onmouseover="$H('');" onmouseout="$H();" >
		<li class="x_form_caption">
			<div style="display:none">
				<input type="checkbox" id="act_priority_enable" name="act_priority_enable" value="1" checked/>
			</div>
			<% multilang(LANG_MARK);%> 802.1p：			
		</li>
		<li class="x_form_input">
			<input id="act_priority" size="8" maxlength="1" onkeypress="return OnKeyPress(event, X_INPUT_URL);" />&nbsp;(0~7)			
		</li>
	</ul>	
	<ul class="x_form_line" id="ul_mark_ipv4_dscp" onmouseover="$H('');" onmouseout="$H();" >
		<li class="x_form_caption">
			<div style="display:none">
				<input type="checkbox" id="act_DSCP_priority_enable" name="act_DSCP_priority_enable" value="1" checked/>
			</div>
			<% multilang(LANG_MARK);%> DSCP：			
		</li>
		<li class="x_form_input">
			<input id="act_DSCP_priority" size="8" maxlength="2" onkeypress="return OnKeyPress(event, X_INPUT_URL);" />&nbsp;(0~63)
		</li>
	</ul>
	<ul class="x_form_line" id="ul_mark_ipv6_tc" onmouseover="$H('');" onmouseout="$H();" >
		<li class="x_form_caption">
			<div style="display:none">
				<input type="checkbox" id="mark_ipv6_tc_enable" name="mark_ipv6_tc_enable" value="1" checked/>
			</div>
			<% multilang(LANG_MARK);%> traffic class：			
		</li>
		<li class="x_form_input">
			<input id="mark_ipv6_tc" size="8" maxlength="2" onkeypress="return OnKeyPress(event, X_INPUT_URL);" />&nbsp;(0~63)
		</li>
	</ul>
	<ul class="x_form_line" onmouseover="$H('');" onmouseout="$H();" >
		<li class="x_form_caption"><% multilang(LANG_QUEUE_STR);%>：</li>
		<li class="x_form_input">
			<input id="act_queue" size="8" maxlength="1" onkeypress="return OnKeyPress(event, X_INPUT_NUM);" />&nbsp;(1~8)
		</li>
	</ul>
	<ul class="x_form_line" onmouseover="$H('');" onmouseout="$H();" >
		<li class="x_form_caption"></li>
		<li class="x_form_input">
			<input type="hidden" id="qospqrule" name="qospqrule">
			<input type="button" id="add_pqrule" style="width:80px" class="btn_save"  value="<% multilang(LANG_ADD);%>">
		</li>
	</ul>

<script type="text/javascript">WriteDynamicTable("", "QosPqTableContainer");</script>
</div>
</div>
	<input type="hidden" name="submit-url" value="/ip_qos.asp">
</form>
<form id="downQosform" action="/boaform/admin/ip_download_qos_Form" method="post">
<script type="text/javascript">WriteMainTitle("<% multilang(LANG_DOWNSTREAM_QOS_CONFIGURATION_STR);%>", "qosdown_cfg");</script>
<div id="x_qosdown_cfg" class="x_main_content">

<div class="x_sub_title"><% multilang(LANG_DOWNSTREAM_QOS_CONFIGURATION_STR);%></div>
<div class="x_form_area">
	<ul class="x_form_line" >
		<li class="x_form_caption"><% multilang(LANG_ENABLE_DOWNSTREAM_QOS_STR);%>：</li>
		<li class="x_form_input">
			<input type="checkbox" id="qosdown_enable" name="qosdown_enable" value="1"/>
		</li>
	</ul>
</div>
</div>
	<input type="hidden" name="submit-url" value="/ip_qos.asp">
</form>
<form id="carQosform" action="/boaform/admin/ip_qos_car_Form" method="post">
<script type="text/javascript">WriteMainTitle("<% multilang(LANG_SPEED_LIMIT);%>", "div_qos_car");</script>
<div id="x_div_qos_car" class="x_main_content">

<div class="x_sub_title"><% multilang(LANG_UPLINK_SPEED_LIMIT_MODE);%></div>
<div class="x_form_area">
	<ul class="x_form_line" onmouseover="$H('<% multilang(LANG_UPLINK_SPEED_LIMIT_MODE);%>');" onmouseout="$H();" >
		<input type="hidden" id="select_car_qos_mode" name="select_car_qos_mode" value="" />
		<li class="x_form_caption"><% multilang(LANG_UPLINK_SPEED_LIMIT_MODE);%>：</li>
		<li class="x_form_input">
			<select id="ModeSwitch_up" name="ModeSwitch_up">
				<option value="0" ><% multilang(LANG_DISABLED);%></option>
				<option value="1" selected><% multilang(LANG_SPEED_LIMIT_BASED_ON_LOCAL_INTERFACE);%></option>
				<option value="2"><% multilang(LANG_SPEED_LIMIT_BASED_ON_LOCAL_VLAN_ID);%></option>
				<option value="3"><% multilang(LANG_SPEED_LIMIT_BASED_ON_LOCAL_IP_ADDRESS);%></option>
			</select>
		</li>
	</ul>
	<div id="div_us_interface_qos">
		<ul class="x_form_line" onmouseover="$H('');" onmouseout="$H();" >
			<li class="x_form_caption"><% multilang(LANG_INTERFACES);%>：</li>
			<li class="x_form_input">
				<select id="InterfaceName_up" name="InterfaceName_up">
				</select>
			</li>
		</ul>
		<ul class="x_form_line" onmouseover="$H('');" onmouseout="$H();" >
			<li class="x_form_caption"><% multilang(LANG_DATA_RATE);%>：</li>
			<li class="x_form_input">
				<input id="InterfaceSpeed_up" maxlength="7" style="width:90px" onkeypress="return OnKeyPress(event, X_INPUT_NUM);" />&nbsp;512Kbps
			</li>
		</ul>
	</div>
	<div id="div_us_vlan_qos">
		<ul class="x_form_line" onmouseover="$H('');" onmouseout="$H();" >
			<li class="x_form_caption">VLAN-ID</li>
			<li class="x_form_input">
				<input id="VlanTagValue_up" maxlength="7" style="width:90px" onkeypress="return OnKeyPress(event, X_INPUT_NUM);" />
			</li>
		</ul>
		<ul class="x_form_line" onmouseover="$H('');" onmouseout="$H();" >
			<li class="x_form_caption"><% multilang(LANG_DATA_RATE);%>：</li>
			<li class="x_form_input">
				<input id="VlanTagSpeed_up" maxlength="7" style="width:90px" onkeypress="return OnKeyPress(event, X_INPUT_NUM);" />&nbsp;512Kbps
			</li>
		</ul>
	</div>
	<div id="div_us_ip_qos">
		<ul class="x_form_line" onmouseover="$H('');" onmouseout="$H();" >
			<li class="x_form_caption">IP <% multilang(LANG_ADDR_TYPE);%>：</li>
			<li class="x_form_input">
				<select id="usipaddr_type" style="width:90px">
					<option value="0" selected>IPv4</option>
					<option value="1">IPv6</option>
				</select>
			</li>
		</ul>
		<div id="div_us_ipv4_qos" style="display:none">
			<ul class="x_form_line" onmouseover="$H('');" onmouseout="$H();" >
			<li class="x_form_caption"><% multilang(LANG_SRC_IP_START_ADDRESS);%>：</li>
			<li class="x_form_input">
				<input id="IP_Start_up" size="26" maxlength="15" onkeypress="return OnKeyPress(event, X_INPUT_IP);" />
			</li>
			</ul>
			<ul class="x_form_line" onmouseover="$H('');" onmouseout="$H();" >
				<li class="x_form_caption"><% multilang(LANG_SRC_IP_END_ADDRESS);%>：</li>
				<li class="x_form_input">
					<input id="IP_End_up" size="26" maxlength="15" onkeypress="return OnKeyPress(event, X_INPUT_IP);" />
				</li>
			</ul>
		</div>
		<div id="div_us_ipv6_qos" style="display:none">
			<ul class="x_form_line" onmouseover="$H('');" onmouseout="$H();" >
				<li class="x_form_caption"><% multilang(LANG_SOURCE_START_IPV6_ADDRESS_STR);%>：</li>
				<li class="x_form_input">
					<input id="usipv6_src" size="30" maxlength="64" onkeypress="return OnKeyPress(event, X_INPUT_IPV6);" />
				</li>
			</ul>
			<ul class="x_form_line" onmouseover="$H('');" onmouseout="$H();" >
				<li class="x_form_caption"><% multilang(LANG_SOURCE_END_IPV6_ADDRESS_STR);%>：</li>
				<li class="x_form_input">
					<input id="usipv6_dst" size="30" maxlength="64" onkeypress="return OnKeyPress(event, X_INPUT_IPV6);" />
				</li>
			</ul>
		</div>
		<ul class="x_form_line" onmouseover="$H('');" onmouseout="$H();" >
			<li class="x_form_caption"><% multilang(LANG_DATA_RATE);%>：</li>
			<li class="x_form_input">
				<input id="IPSpeed_up" maxlength="7" style="width:90px" onkeypress="return OnKeyPress(event, X_INPUT_NUM);" />&nbsp;512Kbps
			</li>
		</ul>
	</div>
	<ul class="x_form_line" onmouseover="$H('');" onmouseout="$H();" >
		<li class="x_form_caption"></li>
		<li class="x_form_input">
			<input type="button" id="add_uscarrule" class="btn_save" style="width:80px" value="添加" />
		</li>
	</ul>

<script type="text/javascript">WriteDynamicTable("", "QosUsCarTableContainer");</script>
</div>

<div class="x_sub_title"><% multilang(LANG_DOWNLINK_SPEED_LIMIT_MODE);%></div>
<div class="x_form_area">
	<ul class="x_form_line" onmouseover="$H('<% multilang(LANG_DOWNLINK_SPEED_LIMIT_MODE);%>');" onmouseout="$H();" >
		<li class="x_form_caption"><% multilang(LANG_DOWNLINK_SPEED_LIMIT_MODE);%>：</li>
		<li class="x_form_input">
			<select id="ModeSwitch_down" name="ModeSwitch_down">
				<option value="0" ><% multilang(LANG_DISABLED);%></option>
				<option value="1" selected><% multilang(LANG_SPEED_LIMIT_BASED_ON_LOCAL_INTERFACE);%></option>
				<option value="2"><% multilang(LANG_SPEED_LIMIT_BASED_ON_LOCAL_VLAN_ID);%></option>
				<option value="3"><% multilang(LANG_SPEED_LIMIT_BASED_ON_LOCAL_IP_ADDRESS);%></option>
			</select>
		</li>
	</ul>
	<div id="div_ds_interface_qos">
		<ul class="x_form_line" onmouseover="$H('');" onmouseout="$H();" >
			<li class="x_form_caption"><% multilang(LANG_INTERFACES);%>：</li>
			<li class="x_form_input">
				<select id="InterfaceName_down" name="InterfaceName_down">
				</select>
			</li>
		</ul>
		<ul class="x_form_line" onmouseover="$H('');" onmouseout="$H();" >
			<li class="x_form_caption"><% multilang(LANG_DATA_RATE);%>：</li>
			<li class="x_form_input">
				<input id="InterfaceSpeed_down" maxlength="7" style="width:90px" onkeypress="return OnKeyPress(event, X_INPUT_NUM);" />&nbsp;512Kbps
			</li>
		</ul>
	</div>
	<div id="div_ds_vlan_qos">
		<ul class="x_form_line" onmouseover="$H('');" onmouseout="$H();" >
			<li class="x_form_caption">VLAN-ID</li>
			<li class="x_form_input">
				<input id="VlanTagValue_down" maxlength="7" style="width:90px" onkeypress="return OnKeyPress(event, X_INPUT_NUM);" />
			</li>
		</ul>
		<ul class="x_form_line" onmouseover="$H('');" onmouseout="$H();" >
			<li class="x_form_caption"><% multilang(LANG_DATA_RATE);%>：</li>
			<li class="x_form_input">
				<input id="VlanTagSpeed_down" maxlength="7" style="width:90px" onkeypress="return OnKeyPress(event, X_INPUT_NUM);" />&nbsp;512Kbps
			</li>
		</ul>
	</div>
	<div id="div_ds_ip_qos">
		<ul class="x_form_line" onmouseover="$H('');" onmouseout="$H();" >
			<li class="x_form_caption">IP <% multilang(LANG_ADDR_TYPE);%>：</li>
			<li class="x_form_input">
				<select id="dsipaddr_type" style="width:90px">
					<option value="0" selected>IPv4</option>
					<option value="1">IPv6</option>
				</select>
			</li>
		</ul>
		<div id="div_ds_ipv4_qos" style="display:none">
			<ul class="x_form_line" onmouseover="$H('');" onmouseout="$H();" >
			<li class="x_form_caption"><% multilang(LANG_SRC_IP_START_ADDRESS);%>：</li>
			<li class="x_form_input">
				<input id="IP_Start_down" size="26" maxlength="15" onkeypress="return OnKeyPress(event, X_INPUT_IP);" />
			</li>
			</ul>
			<ul class="x_form_line" onmouseover="$H('');" onmouseout="$H();" >
				<li class="x_form_caption"><% multilang(LANG_SRC_IP_END_ADDRESS);%>：</li>
				<li class="x_form_input">
					<input id="IP_End_down" size="26" maxlength="15" onkeypress="return OnKeyPress(event, X_INPUT_IP);" />
				</li>
			</ul>
		</div>
		<div id="div_ds_ipv6_qos" style="display:none">
			<ul class="x_form_line" onmouseover="$H('');" onmouseout="$H();" >
				<li class="x_form_caption"><% multilang(LANG_SOURCE_START_IPV6_ADDRESS_STR);%>：</li>
				<li class="x_form_input">
					<input id="dsipv6_src" size="30" maxlength="64" onkeypress="return OnKeyPress(event, X_INPUT_IPV6);" />
				</li>
			</ul>
			<ul class="x_form_line" onmouseover="$H('');" onmouseout="$H();" >
				<li class="x_form_caption"><% multilang(LANG_SOURCE_END_IPV6_ADDRESS_STR);%>：</li>
				<li class="x_form_input">
					<input id="dsipv6_dst" size="30" maxlength="64" onkeypress="return OnKeyPress(event, X_INPUT_IPV6);" />
				</li>
			</ul>
		</div>
		<ul class="x_form_line" onmouseover="$H('');" onmouseout="$H();" >
			<li class="x_form_caption"><% multilang(LANG_DATA_RATE);%>：</li>
			<li class="x_form_input">
				<input id="IPSpeed_down" maxlength="7" style="width:90px" onkeypress="return OnKeyPress(event, X_INPUT_NUM);" />&nbsp;512Kbps
			</li>
		</ul>
	</div>
	<ul class="x_form_line" onmouseover="$H('');" onmouseout="$H();" >
		<li class="x_form_caption"></li>
		<li class="x_form_input">
			<input type="button" id="add_dscarrule" class="btn_save" style="width:80px" value="<% multilang(LANG_ADD);%>" />
		</li>
	</ul>

<script type="text/javascript">WriteDynamicTable("", "QosDsCarTableContainer");</script>
</div>

</div>


<div id="div_save" class="x_form_save">
	<input type="button" id="btn_save" class="btn_save" value="<% multilang(LANG_CONFIRM);%>" />
	<input type="button" id="btn_cancel" class="btn_cancel" value="<% multilang(LANG_CANCEL);%>" />
	<input type="hidden" name="submitAction" value="rule">
	<input type="hidden" name="submit-url" value="/ip_qos.asp">	
</div>

</form>
<div style="clear:both;"></div>

</div> <!-- end of div[content] -->

</div>

</div>

</body>
</html>


