
function $G(id)
{
	return $("#" + id).val();
}

function $S(id, value)
{
	$("#" + id).val(value);
}

function $W(obj)
{
	document.write(obj);
}

function $W2(obj)
{
	var p=/(^_*)|(_*$)/g;
	var dev_name=obj.replace(p,"");

	document.write(dev_name);
}

function $H()
{
	var msg = "";
	for (var i = 0; i < arguments.length; i++)
	{
		msg += arguments[i];
	}
	$("#help_box").html(msg + "\n");
}

function reFresh()
{
	window.location.reload();
} 

//added for check wan
function isNameUnsafe(compareChar)
{
	var unsafeString = "\"<>%\\^[]`\+\$\,='#&@.: \t";

	if ( unsafeString.indexOf(compareChar) == -1
		&& compareChar.charCodeAt(0) > 32
		&& compareChar.charCodeAt(0) < 123 )
	{
		return false; // found no unsafe chars, return false
	}
	else
	{
		return true;
	}
}

function isPppoeNameUnsafe(compareChar)
{
	var unsafeString = "\"\\\': \t\n";

	if ( unsafeString.indexOf(compareChar) == -1
		&& compareChar.charCodeAt(0) > 32
		&& compareChar.charCodeAt(0) < 123 )
	{
		return false; // found no unsafe chars, return false
	}
	else
	{
		return true;
	}
}

function isValidIpAddress(address)
{
	var addrParts = address.split('.');

	if ( addrParts.length != 4 )
	{
		return false;
	}

	for (i = 0; i < 4; i++)
	{
		if (isNaN(addrParts[i]) || addrParts[i] == "")
		{
			return false;
		}
		num = parseInt(addrParts[i]);
		if ( num < 0 || num > 255 )
		{
			return false;
		}
	}
	return true;
}

function isValidIpv4Address(address)
{
/*
	if (!isValidIpAddress(address))
	{
		return false;
	}

	var ip4 = address.split('.');
	var num = parseInt(ip4[0]);
	var num1 = parseInt(ip4[3]);
	if (num == 0 || num == 255 || num1 == 0 || num1 == 255)
	{
		return false;
	}
	return true;
*/
	//need suport address field
	return isValidIpAddress(address);
}
function Ip2Num(ip)
{
	var num = 0;

	if (!isValidIpAddress(ip))
	{
		return num;
	}

	var ip4 = ip.split('.');
	for (var i = 0; i < 4; i++)
	{
		num = num*256 + parseInt(ip4[i]);
	}

	return num;
}

function isValidIpAddress6(address)
{
	ipParts = address.split('/');
	if (ipParts.length > 2) return false;
	if (ipParts.length == 2) {
		num = parseInt(ipParts[1]);
		if (num <= 0 || num > 128)
			return false;
	}

	addrParts = ipParts[0].split(':');
	if (addrParts.length < 3 || addrParts.length > 8)
		return false;
	for (i = 0; i < addrParts.length; i++) {
		if ( addrParts[i] != "" )
			num = parseInt(addrParts[i], 16);
		if ( i == 0 ) {
		} else if ( (i + 1) == addrParts.length) {
			if ( num == 0 || num == 1)
				return false;
		}
		if ( num != 0 )
			break;
	}
	return true;
}

function isValidName(name)
{
	var i = 0;

	for ( i = 0; i < name.length; i++ ) {
		if ( isNameUnsafe(name.charAt(i)) == true )
			return false;
	}
	return true;
}

function isValidPppoeName(name)
{
	var i = 0;

	for ( i = 0; i < name.length; i++ ) {
		if ( isPppoeNameUnsafe(name.charAt(i)) == true )
			return false;
	}
	return true;
}

function isSameSubNet(lan1Ip, lan1Mask, lan2Ip, lan2Mask)
{
	var count = 0;

	lan1a = lan1Ip.split('.');
	lan1m = lan1Mask.split('.');
	lan2a = lan2Ip.split('.');
	lan2m = lan2Mask.split('.');

	for (i = 0; i < 4; i++) {
		l1a_n = parseInt(lan1a[i]);
		l1m_n = parseInt(lan1m[i]);
		l2a_n = parseInt(lan2a[i]);
		l2m_n = parseInt(lan2m[i]);
		if ((l1a_n & l1m_n) == (l2a_n & l2m_n))
			count++;
	}
	if (count == 4)
		return true;
	else
		return false;
}


function isSameSubnet1(input,ip,mask)
{
	var temp1,temp2,temp3;
	temp1=input.split(".");
	temp2=ip.split(".");
	temp3=mask.split(".");
	for (var i=0;i<4;i++)
	{
		if((temp1[i]&temp3[i])!=(temp2[i]&temp3[i]))
			return false;
	}
	return true;
}

function isLansubIP(input,ip,mask)
{
	var temp1,temp2,temp3, mcastip;
	temp1=input.split(".");
	temp2=ip.split(".");
	temp3=mask.split(".");
	mcastip=mask.split(".");
	//must in one subnet
	for (var i=0;i<4;i++)
	{
		if((temp1[i]&temp3[i])!=(temp2[i]&temp3[i]))
			return false;
	}
	
	//can't be lan br0 ip addr
	if(temp1[0] == temp2[0] && temp1[1] == temp2[1] && temp1[2] == temp2[2] && temp1[3] == temp2[3])
		return false;
		
	//can't be multicast ip addr
	for (var i=0;i<4;i++)
	{
		mcastip[i] = (255 ^ temp3[i]) | temp2[i];
	}
	if(temp1[0] == mcastip[0] && temp1[1] == mcastip[1] && temp1[2] == mcastip[2] && temp1[3] == mcastip[3])
		return false;
	
	return true;
}

function getLeftMostZeroBitPos(num)
{
	var i = 0;
	var numArr = [128, 64, 32, 16, 8, 4, 2, 1];

	for ( i = 0; i < numArr.length; i++ )
		if ( (num & numArr[i]) == 0 )
			return i;

	return numArr.length;
}

function getRightMostOneBitPos(num)
{
	var i = 0;
	var numArr = [1, 2, 4, 8, 16, 32, 64, 128];

	for ( i = 0; i < numArr.length; i++ )
		if ( ((num & numArr[i]) >> i) == 1 )
			return (numArr.length - i - 1);

	return -1;
}

function isValidSubnetMask(mask)
{
	var i = 0, num = 0;
	var zeroBitPos = 0, oneBitPos = 0;
	var zeroBitExisted = false;

	if ( mask == '0.0.0.0' )
		return false;

	maskParts = mask.split('.');
	if ( maskParts.length != 4 ) return false;

	for (i = 0; i < 4; i++) {
		if ( isNaN(maskParts[i]) == true )
			return false;
		num = parseInt(maskParts[i]);
		if ( num < 0 || num > 255 )
			return false;
		if ( zeroBitExisted == true && num != 0 )
			return false;
		zeroBitPos = getLeftMostZeroBitPos(num);
		oneBitPos = getRightMostOneBitPos(num);
		if ( zeroBitPos < oneBitPos )
			return false;
		if ( zeroBitPos < 8 )
			zeroBitExisted = true;
	}

	return true;
}

function ipverify(ip_string)
{
	var c;
	var n = 0;
	var ch = ".0123456789";
	if (ip_string.length < 7 || ip_string.length > 15)
		return false;
	for (var i = 0; i < ip_string.length; i++){
		c = ip_string.charAt(i);
		if (ch.indexOf(c) == -1)
			return false;
		else{
			if (c == '.'){
				if(ip_string.charAt(i+1) != '.')
					n++;
				else
					return false;
			}
		}
	}
	if (n != 3)
		return false;
	if (ip_string.indexOf('.') == 0 || ip_string.lastIndexOf('.') == (ip_string.length - 1))
		return false;

	szarray = [0,0,0,0];
	var remain;
	var i;
	for(i = 0; i < 3; i++){
		var n = ip_string.indexOf('.');
		szarray[i] = ip_string.substring(0,n);
		remain = ip_string.substring(n+1);
		ip_string = remain;
	}
	szarray[3] = remain;

	for(i = 0; i < 4; i++){
		if (szarray[i] < 0 || szarray[i] > 255){
			return false;
		}
	}
	return true;
}

function is_ipaddr(ip_string)
{
	if(ip_string.length == 0){
		alert("input ip please");
		return false;
	}
	if(ip_string=="0.0.0.0")
	{
		alert("ip format error, please input again");
		return false;
	}
	if(ip_string=="255.255.255.255")
	{
		alert("IP format error, please input again");
		return false;
	}
	if (!ipverify(ip_string))
	{
		alert("IP format error, please input again");
		return false;
	}
	return true;
}

function check_ipaddr(var_name)
{
	var element = document.getElementById(var_name);
	if(element)
	{
		if(!is_ipaddr(element.value))
		{
			element.focus();
			element.select();
			return false;
		}
	}
	return true;
}

function IsIpaddr(ip)
{
	var c;
	var subip = ip.split(".");

	if (4 != subip.length)
	{
		return false;
	}

	if (ip == "0.0.0.0")
	{
		return true;
	}

	if (ip.length < 7 || ip.length > 15)
	{
		return false;
	}

	for (var i = 0; i < ip.length; i++)
	{
		c = ip.charCodeAt(i);
		if (c == '.'.charCodeAt(0))
		{
			continue;
		}
		else
		{
			if (c < 0x30 || c > 0x39)
			{
				return false;
			}
		}
	}

	for (var i = 0; i < 4; i++)
	{
		if (subip[i].length == 0)
		{
			return false;
		}
		var n = parseInt(subip[i]);
		if (n < 0 || n > 255)
		{
			return false;
		}
	}

	return true;
}

function CheckIpaddr(id)
{
	var ipaddr = $("#"+id).val();
	if (false == IsIpaddr(ipaddr))
	{
		$(id).focus();
		return false;
	}
	return true;
}

function IsPort(port)
{
	var c;

	if (port.length < 1 || port.length > 5)
	{
		return false;
	}

	for (var i = 0; i < port.length; i++)
	{
		c = port.charCodeAt(i);
		if (c < 0x30 || c > 0x39)
		{
			return false;
		}
	}

	var n = parseInt(port);
	if (n < 0 || n > 65535)
	{
		return false;
	}

	return true;
}

function CheckPort(id)
{
	var port = $("#"+id).val();	

	if (false == IsPort(port))
	{
		return false;
	}
	return true;
}

function ChangeEnable(var_name)
{
	var element = document.getElementById(var_name);
	var element_enable = document.getElementById(var_name+"enable");
	if (element.checked==true)
	{
		element_enable.value="1";
		return true;
	}
	else
	{
		element_enable.value="0";
		return false;
	}
}
function isHexaDigit(digit) {
   var hexVals = new Array("0", "1", "2", "3", "4", "5", "6", "7", "8", "9",
                           "A", "B", "C", "D", "E", "F", "a", "b", "c", "d", "e", "f");
   var len = hexVals.length;
   var i = 0;
   var ret = false;

   for ( i = 0; i < len; i++ )
      if ( digit == hexVals[i] ) break;

   if ( i < len )
      ret = true;

   return ret;
}

function isValidHexKey(val, size) {
   var ret = false;
   if (val.length == size) {
      for ( i = 0; i < val.length; i++ ) {
         if ( isHexaDigit(val.charAt(i)) == false ) {
            break;
         }
      }
      if ( i == val.length ) {
         ret = true;
      }
   }

   return ret;
}

function isBinaDigit(digit) {
   var hexVals = new Array("0", "1");
   var len = hexVals.length;
   var i = 0;
   var ret = false;

   for ( i = 0; i < len; i++ )
      if ( digit == hexVals[i] ) break;

   if ( i < len )
      ret = true;

   return ret;
}

function isValidBinKey(val, size) {
   var ret = false;
   if (val.length == size) {
      for ( i = 0; i < val.length; i++ ) {
         if ( isHexaDigit(val.charAt(i)) == false ) {
            break;
         }
      }
      if ( i == val.length ) {
         ret = true;
      }
   }

   return ret;
}

function KeyPressIP(c)
{
	var ValidString = ".0123456789";

	return (-1 != ValidString.indexOf(c))?true:false;
}

function KeyPressNUM(c)
{
	var ValidString = "0123456789";

	return (-1 != ValidString.indexOf(c))?true:false;
}

function KeyPressNegativeNUM(c)
{
	var ValidString = "-0123456789";

	return (-1 != ValidString.indexOf(c))?true:false;
}
function KeyPressHEX(c)
{
	var ValidString = "0123456789abcdefABCDEF";

	return (-1 != ValidString.indexOf(c))?true:false;
}

function KeyPressID(c)
{
	var InvalidString = "\"\\\': \t\n";

	return (-1 == InvalidString.indexOf(c))?true:false;
}

function KeyPressSSID(c)
{
	var InvalidString = "\"\\\'";

	return (-1 == InvalidString.indexOf(c))?true:false;
}

function KeyPressMAC(c)
{
	var ValidString = "-:0123456789abcdefABCDEF";

	return (-1 != ValidString.indexOf(c))?true:false;
}

function KeyPressPasswd(c)
{
	var InvalidString = "\"\\\' :\t\n";

	return (-1 == InvalidString.indexOf(c))?true:false;
}

function KeyPressLVM(c)
{
	var ValidString = "0123456789/,";

	return (-1 != ValidString.indexOf(c))?true:false;
}

function KeyPressURL(c)
{
	var InvalidString = "\"\' \t\n";

	return (-1 == InvalidString.indexOf(c))?true:false;
}

function KeyPressDigitmap(c)
{
	var ValidString = "0123456789-()[]{}*#Xx.T|EFtSL";

	return (-1 != ValidString.indexOf(c))?true:false;
}

function KeyPressPHONENUM(c)
{
	var ValidString = "+0123456789";

	return (-1 != ValidString.indexOf(c))?true:false;
}
function KeyPressICCODE(c)
{
	var ValidString = "*#0123456789";

	return (-1 != ValidString.indexOf(c))?true:false;
}

function KeyPressIPV6(c)
{
    var validString = "/:0123456789abcdefABCDEF";

    return (-1 != validString.indexOf(c))?true:false;
}

var X_INPUT_IP = 1;
var X_INPUT_NUM = 2;
var X_INPUT_HEX = 3;
var X_INPUT_ID = 4;
var X_INPUT_MAC = 5;
var X_INPUT_PASSWD = 6;
var X_INPUT_LVM = 7;
var X_INPUT_URL = 8;
var X_INPUT_DIGITMAP = 9;
var X_INPUT_PHONENUM = 10;
var X_INPUT_ICCODE = 11;
var X_INPUT_IPV6 = 12;
var X_INPUT_Negative_NUM = 13;
var X_INPUT_SSID = 14;

function OnKeyPress(e, type)
{
	var	k = 0;
	var	c;

	if (window.event)
	{
		k = e.keyCode;
	}
	else if (e.which)
	{
		k = e.which;
	}

	if (k == 8 || k == 0)
	{
		return true;
	}

	c = String.fromCharCode(k);

	switch (type)
	{
	case	X_INPUT_IP:
		return KeyPressIP(c);

	case	X_INPUT_NUM:
		return KeyPressNUM(c);

	case	X_INPUT_HEX:
		return KeyPressHEX(c);

	case	X_INPUT_ID:
		return KeyPressID(c);

	case	X_INPUT_MAC:
		return KeyPressMAC(c);

	case	X_INPUT_PASSWD:
		return KeyPressPasswd(c);

	case	X_INPUT_LVM:
		return KeyPressLVM(c);

	case	X_INPUT_URL:
		return KeyPressURL(c);

	case	X_INPUT_DIGITMAP:
		return KeyPressDigitmap(c);

	case	X_INPUT_PHONENUM:
		return KeyPressPHONENUM(c);

	case	X_INPUT_ICCODE:
		return KeyPressICCODE(c);
	case	X_INPUT_IPV6:
		return KeyPressIPV6(c);

	case	X_INPUT_Negative_NUM:
		return KeyPressNegativeNUM(c);
	case	X_INPUT_SSID:
		return KeyPressSSID(c);

	}

	return false;
}


function isValidMacAddress(address) {
   var c = '';
   var num = 0;
   var i = 0, j = 0;
   var zeros = 0;

   addrParts = address.split(':');
   if ( addrParts.length != 6 ) return false;

   for (i = 0; i < 6; i++) {
      if ( addrParts[i] == '' )
         return false;
      for ( j = 0; j < addrParts[i].length; j++ ) {
         c = addrParts[i].toLowerCase().charAt(j);
         if ( (c >= '0' && c <= '9') ||
              (c >= 'a' && c <= 'f'))
            continue;
         else
            return false;
      }

      num = parseInt(addrParts[i], 16);
      if ( num == NaN || num < 0 || num > 255 )
         return false;
      if ( num == 0 )
         zeros++;
   }
   if (zeros == 6)
      return false;

   if ( parseInt(addrParts[0], 16) & 1 )	  
          return false;

   return true;
}
function is_domain(domain)
{
	var InvalidString = "\"\\\': \t\n";
	var i;
	if(domain.length==0)
	   return false;
	for(i=0;i<domain.length;i++)
	{
	  if(-1 != InvalidString.indexOf(domain.charAt(i)))
	    return false;
	}
	return true;
}

function isValidSuffix(address)
{
    var j = 0;
    if (address == "0:0:0:0" || address == "FFFF:FFFF:FFFF:FFFF"
    		|| address == "ffff:ffff:ffff:ffff")
        return false;
        
    ipParts = address.split(':');
    if (ipParts.length != 4)
    {
        return false;
    }
    else
    {  
        for(j = 0; j < 4; j++)
        {          
            if(false == isValidIpChar(ipParts[j]))
            {
                return false;
            }
        }        
    }
    return true;
}

function isValidIpChar(ipchar)
{
    var str="0123456789abcdefABCDEF";
    var i = 0;
   
    if (ipchar.length == 0 || ipchar.length > 4)
    {
        return false;
    }
    
    for(i = 0; i < ipchar.length; i++)
    {        
        if (str.indexOf(ipchar.charAt(i)) < 0)
        {
            return false;
        }    
    }    

    return true;   
}

function compareIpv6Addr(ipv6addrmin, ipv6addrmax)
{
    var ip6addr1 = ipv6addrmin.split(':');
    var ip6addr2 = ipv6addrmax.split(':');
    
    for(i = 0; i < 4; i++)
    {       
        if (parseInt(ip6addr1[i], 16) < parseInt(ip6addr2[i], 16)) 
        {
            return 1;
        }
        
        if (parseInt(ip6addr1[i], 16) > parseInt(ip6addr2[i], 16)) 
        {
            return -1;
        }
    }
    
    return 0;
}

/********************************************************************
**          Debug functions
********************************************************************/
function sji_debug(msg)
{
    if(JS_ALERT)alert(msg);
    document.write(msg);
}

function sji_objdump(obj)
{
	if(typeof obj == "undefined")return;
	for(var key in obj) alert(key + "=" + obj[key]);
}

/********************************************************************
**          Utility functions
********************************************************************/
function sji_int(val){if(val == false) {return 0;} else if(val == true) {return 1;} else {return parseInt(val);}}

function sji_docinit(doc, cgi)
{
	var surl = doc.getElementsByName("submit-url");
	if(surl && surl.length > 0)
	{
		if(surl[0].value == "")surl[0].value = doc.location.href;
	}

	var stype = "";
	var stag = "";
	var svalue = null;

	if(typeof doc == "undefined" || typeof cgi == "undefined")return;
	for(var name in cgi)
	{
		if(typeof cgi[name] != "boolean" && typeof cgi[name] != "string" && typeof cgi[name] != "number")continue;
		svalue = cgi[name];
		var obj = doc.getElementsByName(name);
		if(typeof obj != "object")continue;
		if(obj.length == 0 || typeof obj[0].tagName == "undefined")continue;
		stag = obj[0].tagName;
		if(stag == "LABEL")
		{
			obj[0].innerHTML = svalue;
		}
		else if(stag == "TD")
		{
			obj[0].innerHTML = svalue;
		}
		else if(stag == "INPUT")
		{
			stype = obj[0].type;
			if(stype == "text" || stype == "hidden")obj[0].value = svalue;
			else if(stype == "radio")obj[sji_int(svalue)].checked = true;
			else if(stype == "checkbox")obj[0].checked = sji_int(svalue);
			else {/*warning*/}
		}
		else if(stag == "SELECT")
		{
			obj[0].value = svalue;
		}
		else {/*warning*/}
	}
}

function sji_onchanged(doc, rec)
{
	var stype = "";
	var stag = "";
	var svalue = null;

	if(typeof doc == "undefined" || typeof rec == "undefined")return;
	for(var name in rec)
	{
		if(typeof rec[name] != "boolean" && typeof rec[name] != "string" && typeof rec[name] != "number")continue;
		svalue = rec[name];
		var obj = doc.getElementsByName(name);
		if(typeof obj != "object")continue;
		if(obj.length == 0 || typeof obj[0].tagName == "undefined")continue;
		stag = obj[0].tagName;
		if(stag == "LABEL")
		{
			obj[0].innerHTML = svalue;
		}
		else if(stag == "TD")
		{
			obj[0].innerHTML = svalue;
		}
		else if(stag == "INPUT")
		{
			stype = obj[0].type;
			if(stype == "text" || stype == "hidden" || stype == "password")obj[0].value = svalue;
			else if(stype == "radio")obj[sji_int(svalue)].checked = true;
			else if(stype == "checkbox")obj[0].checked = sji_int(svalue);
			else {/*warning*/}
		}
		else if(stag == "SELECT")
		{
			obj[0].value = svalue;
		}
		else {/*warning*/}
	}
}

function sji_elshowbyid(id, show)
{
	if (document.getElementById)// standard
	{
		document.getElementById(id).style.display = show ? "block" : "none";
	}
	else if (document.all)// old IE
	{
		document.all[id].style.display = show ? "block" : "none";
	}
	else if (document.layers)// Netscape 4
	{
		document.layers[id].display = show ? "block" : "none";
	}
}

function sji_getchild(el, chid)
{
	if(el.childNodes)
	{
		return el.childNodes[chid];
	}
	return el.children[chid];
}

function sji_queryparam(param)
{
	var urlstr = window.location.href;
	var sar = urlstr.split("?");

	if(sar.length == 1)return null;

	var params = sar[1].split("&");
	for(var i=0; i<params.length; i++)
	{
		var pair = params[i].split("=");
		if(param == pair[0])
		{
			return pair[1];
		}
	}
	return null;
}

function sji_encode(ar, field)
{
	var senc = null;
	if(typeof ar == "undefined")return null;

	senc = "l";
	for(var i in ar)
	{
		if(!ar[i][field])continue;
		senc += ar[i].enc();
	}
	senc += "e";

	return senc;
}

function sji_varencode(ar, field, k)
{
	var senc = null;
	if(typeof ar == "undefined")return null;

	senc = "l";
	for(var i in ar)
	{
		if(!ar[i][field])continue;
		senc += ar[i].encvar(k);
	}
	senc += "e";

	return senc;
}

function sji_idxencode(ar, field, name)
{
	var senc = null;
	if(typeof ar == "undefined")return null;

	senc = "l";
	for(var i in ar)
	{
		if(!ar[i][field])continue;
		senc += "d";
		senc += sji_valenc(name);
		senc += ("i" + i + "e");
		senc += "e";
	}
	senc += "e";

	return senc;
}

/********************************************************************
**          string functions
********************************************************************/

function sji_valenc(val)
{
	var text = "";
	if(typeof val == "undefined")return null;
    else if(typeof val == "string")
    {
        text = val.length + ":" + val;
    }
    else if(typeof val == "number")
    {
        text = "i" + val + "e";
    }
	else return null;

    return text;
}

function sji_valdec(text)
{
    var type = text.charAt(0);
    var len = text.length;
    var val = '\0';
    var hlen = 1;
    var hdr = "";
    var vlen = 0;
	var cnt = 1;

	if(typeof text == "undefined")return null;

    if(text.length <= 2){return null;}

	if(type == 'i')
	{
		var subtext = "";
		while(cnt < len)
		{
			val = text.charAt(cnt);
			if(val == 'e')
			{
				subtext = text.substring(1, cnt);
				cnt++;
				break;
			}
			cnt++;
		}
		if(subtext == ""){return null;}

		if(isNaN(parseInt(subtext))){return null;}

		return new it(cnt, parseInt(subtext));
	}
	else
	{
		while(hlen < len)
		{
			val = text.charAt(hlen);
			if(val == ':')
			{
				hdr = text.substring(0, hlen);
				hlen++;
				break;
			}
			hlen++;
		}
		if(hdr == ""){return null;}
		if(isNaN(parseInt(hdr))){return null;}

		vlen = parseInt(hdr);
		if((vlen + hlen) > len){vlen = len - hlen;}

		return new it(hlen + vlen, text.substring(hlen, hlen + vlen));
	}
	return null;
}

//----------------------
//功能: 去除字符前尾的空格
//======================
function sji_killspace(str)
{
	while( str.charAt(0)==" " )
	{
		str=str.substr(1,str.length);
	}

	while( str.charAt(str.length-1)==" " )
	{
		str=str.substr(0,str.length-1);
	}
	return str;
}

//-------------------
//功能：计算字符串的长度，字符串内可以混合英文和中文
//====================
function sji_strlen(str)
{
	var len;
	var i;
	len = 0;
	for (i=0;i<str.length;i++)
	{
		if (str.charCodeAt(i)>255)
			len+=2;
		else
			len++;
	}
	return len;
}


//-----------------------
//功能：检查输入的是否为数字
//======================
function sji_checkdigit(str)
{
	if(typeof str == "undefined")return false;
	var pattern = /^-?[0-9]+((\.[0-9]+)|([0-9]*))$/;
	return pattern.test(str);
}


//-----------------------
//功能：检查输入的数值是否符合数值范围
//======================
function sji_checkdigitrange(num, dmin, dmax)
{
	if(typeof num == "undefined")return false;
	if(sji_checkdigit(num) == false)
	{
		return false;
	}
  	var val = parseInt(num, 10);
	if(typeof dmin != "undefined" && val < dmin)return false;
	if(typeof dmax != "undefined" && val > dmax)return false;
	return true;
}

//-----------------------
//功能：检查输入的 str 数字是否为非负整数
//======================
function sji_checknum(str)
{
	if(typeof str == "undefined")return false;
	var pattern = /^[0-9]{1,}$/;
	return pattern.test(str);
}

//-----------------------
//功能：检查输入的 str 数字是否为16进制数值
//======================
function sji_checkhex(str, smin, smax)
{
	if(typeof str == "undefined")return false;

	if(typeof smin != "undefined" && str.length < smin)return false;
	if(typeof smax != "undefined" && str.length > smax)return false;

	var pattern = /^[0-9a-fA-F]+$/;
	return pattern.test(str);
}

//-----------------------
//功能：检查输入的字符串长度符合要求
//======================
function sji_checklen(str, smin, smax)
{
	if(typeof str == "undefined")return false;
	if(typeof smin != "undefined" && str.length < smin)return false;
	if(typeof smax != "undefined" && str.length > smax)return false;
	return true;
}

//-----------------------
//功能：检查输入的字符串是否合乎常规应用，且长度符合要求
//======================
function sji_checkstrnor(str, smin, smax)
{
	if(typeof str == "undefined")return false;
	if(typeof smin != "undefined" && str.length < smin)return false;
	if(typeof smax != "undefined" && str.length > smax)return false;

	/*ql:20080717 START: Don't restrict the length of the string*/
	//var pattern = /^[a-zA-Z0-9%@.,~+=_*&\(\)\[\]:][a-zA-Z0-9%@.,~+=_*&\s\(\)\[\]:]+[a-zA-Z0-9%@.,~+=_*&\(\)\[\]:]$/;
	var pattern = /^[a-zA-Z0-9%@.,~+=_*&\(\)\[\]:]+$/;
	/*ql:20080717 END*/
	return pattern.test(str);
}

//-----------------------
//功能：检查输入的密码是否合乎常规应用，且长度符合要求
//======================
function sji_checkpswnor(str, smin, smax)
{
	if(typeof str == "undefined")return false;
	if(typeof smin != "undefined" && str.length < smin)return false;
	if(typeof smax != "undefined" && str.length > smax)return false;

	var pattern = /^[a-zA-Z0-9%@.,~+=_*&\s\(\)\[\]:]+$/;
	return pattern.test(str);
}

//-------------------
//功能：检查用户名是否符合指定规则
//====================
function sji_checkusername(username, smin, smax)
{
	if(typeof username == "undefined")return false;
	if(typeof smin != "undefined" && username.length < smin)return false;
	if(typeof smax != "undefined" && username.length > smax)return false;

	var pattern = /^([a-zA-Z0-9_-])+$/;
	return pattern.test(username);
}

//-------------------
//功能：检查域名是否符合指定规则
//====================
function sji_checkhostname(username, smin, smax)
{
	if(typeof username == "undefined")return false;
	if(typeof smin != "undefined" && username.length < smin)return false;
	if(typeof smax != "undefined" && username.length > smax)return false;

	var pattern = /^([a-zA-Z0-9@.\-])+$/;
	return pattern.test(username);
}


//-------------------
//功能：检查PPP帐号是否符合指定规则
//====================
function sji_checkpppacc(username, smin, smax)
{
	var str = username;
	if(typeof username == "undefined")return false;
	if(typeof smin != "undefined" && username.length < smin)return false;
	if(typeof smax != "undefined" && username.length > smax)return false;

	//var pattern = /^([a-zA-Z0-9%@.,~+=_*&])+$/;
	for (var i=0; i<str.length; i++) {
		if ((str.charAt(i) >= '0' && str.charAt(i) <= '9') || (str.charAt(i) >= 'A' && str.charAt(i) <= 'Z') || (str.charAt(i) >= 'a' && str.charAt(i) <= 'z') ||
		   (str.charAt(i) == '.') || (str.charAt(i) == ':') || (str.charAt(i) == '-') || (str.charAt(i) == '_') || (str.charAt(i) == ' ') || (str.charAt(i) == '/') || (str.charAt(i) == '@') ||
		   (str.charAt(i) == '!') ||(str.charAt(i) == '~') ||(str.charAt(i) == '#') ||(str.charAt(i) == '$') ||(str.charAt(i) == '%') ||(str.charAt(i) == '^') ||(str.charAt(i) == '&') ||
		   (str.charAt(i) == '*') ||(str.charAt(i) == '(') ||(str.charAt(i) == ')') ||(str.charAt(i) == '+') ||(str.charAt(i) == '=') ||(str.charAt(i) == '?') ||(str.charAt(i) == '>') ||
		   (str.charAt(i) == '<') )
			continue;
		return false;
	}
	return true;
}

//-------------------
//检查 email 是否是合法的书写形式
//===================
function sji_checkemail(email)//M12
{
	if(typeof email == "undefined")return false;
	var pattern = /^(([a-zA-Z0-9_.\-])+@([a-zA-Z0-9_\-])+(\.[a-zA-Z0-9_\-]+)+){0,1}$/;
	var email_array = email.split("\r\n");
	for (i = 0; i < email_array.length; i++)
	{
		if (!sji_killspace(email_array[i]))
			continue;
		if(!pattern.test(sji_killspace(email_array[i])))
			return false;
	}
	return true;
}

//-------------------
//检查 URL 是否是合法的书写形式
//===================
function sji_checkurl(url)
{
	if(typeof url == "undefined")return false;
	//var pattern = /^((http|ftp):\/\/)?((([\d]+.){3}[\d]+(\/[\w.\/]+)?)|([a-z]\w*((.\w+)+){2,})([\/][\w.~]*)*)$/;
	var pattern = /^((http|https|ftp):\/\/)?((((\d+.){3}\d+)|([a-zA-Z]\w*(.\w+){2,}))(\/\S*)*)$/;

	return pattern.test(url);
}

//-------------------
//检查 URL 是否是合法的书写形式
//===================
function sji_checkhttpurl(url)
{
	if(typeof url == "undefined")return false;
	var pattern = /^(https?:\/\/)?((((\d+.){3}\d+)|([a-zA-Z]\w*(.\w+){2,}))(:[0-9]+)?(\/\S*)*)$/;

	return pattern.test(url);
}

//-------------------
//检查 FTP URL 是否是合法的书写形式
//===================
function sji_checkftpurl(url)
{
	if(typeof url == "undefined")return false;
	var pattern = /^(ftp:\/\/)?((((\d+.){3}\d+)|([a-zA-Z]\w*(.\w+){2,}))(\/\S*)*)$/;

	return pattern.test(url);
}

//-----------------------
//功能：检查输入的IP地址是否符合指定规则
//======================
function sji_checkip(ip)
{
	if(typeof ip == "undefined")return false;
	var pattern = /^([0-9]|[1-9]\d|1\d\d|2[0-4]\d|25[0-5])(\.([0-9]|[1-9]\d|1\d\d|2[0-4]\d|25[0-5])){3}$/;
	return pattern.test(ip);
}

//-----------------------
//功能：检查输入的IP地址是否为合法IP地址
//======================
function sji_checkvip(ip)
{
	if(typeof ip == "undefined")return false;

	var pattern1 = /^([1-9]|[1-9]\d|1\d\d|2[0-4]\d|25[0-5])(\.([0-9]|[1-9]\d|1\d\d|2[0-4]\d|25[0-5])){2}(\.([1-9]|[1-9]\d|1\d\d|2[0-4]\d|25[0-4]))$/;
	if(pattern1.test(ip) == false) return false;

	var pattern2 = /^127\..+$/;
	if(pattern2.test(ip) == true) return false;

	return true;
}

//-----------------------
//功能：检查输入的IP掩码是否符合指定规则
//======================
function sji_checkmask(mask)
{
	if(typeof mask == "undefined")return false;
	var pattern = /^((128)|(192)|(224)|(240)|(248)|(252)|(254))(.0){3}$/;

	if(pattern.test(mask) == true)return true;

	pattern = /^255.((0)|(128)|(192)|(224)|(240)|(248)|(252)|(254))(.0){2}$/;
	if(pattern.test(mask) == true)return true;

	pattern = /^255.255.((0)|(128)|(192)|(224)|(240)|(248)|(252)|(254)).0$/;
	if(pattern.test(mask) == true)return true;

	pattern = /^255.255.255.((0)|(128)|(192)|(224)|(240)|(248)|(252)|(254)|(255))$/;
	return pattern.test(mask);
}

//-----------------------
//功能：检查输入的MAC地址是否符合指定规则
//======================
function sji_checkmac(mac)
{
	if(typeof mac == "undefined")return false;
	var pattern = /^([0-9a-fA-F]{2}(:|-)){5}[0-9a-fA-F]{2}$/;
	//var pattern = /^([0-9a-fA-F]{2}(-)){5}[0-9a-fA-F]{2}$/;
	return pattern.test(mac);
}

function sji_checkmac2(mac)
{
	if(typeof mac == "undefined")return false;
	//var pattern = /^([0-9a-fA-F]{2}(:)){5}[0-9a-fA-F]{2}$/;
	var pattern = /^([0-9a-fA-F]{2})(:[0-9a-fA-F]{2}){5}$/;
	return pattern.test(mac);
}

//-----------------------
//功能：IP地址比较，ip1 > ip2: 1; ip1 < ip2: -1; ip1 == ip2: 0;
//======================
function sji_ipcmp(ip1, ip2)
{
	if(typeof ip1 == "undefined" || typeof ip2 == "undefined")return -2;

	if(ip1 == ip2)return 0;

	var uip1 = sji_str2ip(ip1);
	var uip2 = sji_str2ip(ip2);

	if(uip1 > 0 && uip2 < 0) return -1;
	if(uip1 < 0 && uip2 > 0) return 1;

	return (uip1 > uip2) ? 1 : -1;
}

//-----------------------
//功能：获取地址的前缀
//======================
function sji_ipprefix(ip, mask)
{
	var ipcells = ip.split(".");
	var maskcells=mask.split(".");
	var s="";
	for(var i=0;i<4;i++)
	{
		if(maskcells[i]!=0xff) break;
		s+=ipcells[i]+".";
	}
	return s;
}


//-----------------------
//功能：点分IP地址转换成integer
//======================
function sji_str2ip(str)
{
	if(sji_checkip(str) == false)return 0;

	var cells = str.split(".");

	var addr = 0;
	for(var i = 0; i < 4; i++)
	{
		addr <<= 8;
		addr |= (parseInt(cells[i], 10) & 0xff);
	}

	return addr;
}

//-----------------------
//功能：integer转换成点分IP地址
//======================
function sji_ip2str(ip)
{
	var uTemp = ip;
	var addr1 = (uTemp & 0xff);
	uTemp >>= 8;
	var addr2 = (uTemp & 0xff);
	uTemp >>= 8;
	var addr3 = (uTemp & 0xff);
	uTemp >>= 8;
	var addr4 = (uTemp & 0xff);

	var addr = addr1 + "." + addr2 + "." + addr3 + "." + addr4;

	return addr;
}


//-----------------------
//说明：键值对
//键名称 数值
//======================
function it(key, value)
{
	this.key = key;
	this.value = value;
	return this;
}

//-----------------------
//说明：通用结构
//名称 选中
//======================
function it_nr(name)
{
	if(typeof name == "undefined")return null;
	this.name = name;
	this.select = false;

	this.add = function(kv)
	{
		this[kv.key] = kv.value;
	}
	this.enc = function()
	{
		var strenc = "d";
		for(var k in this)
		{
			var strk = sji_valenc(k);
			if(strk == null) continue;
			var strv = sji_valenc(this[k]);
			if(strv == null) continue;
			strenc += (strk + strv);
		}
		strenc += "e";
		return strenc;
	}
	this.encvar = function(k)
	{
		var strenc = "d";
		//for(var k in this)
		//{
			var strk = sji_valenc(k);
			if(strk == null) {
				strenc += "e";
				return strenc;
			}
			var strv = sji_valenc(this[k]);
			if(strv == null) {
				strenc += "e";
				return strenc;
			}
			strenc += (strk + strv);
		//}
		strenc += "e";
		return strenc;
	}
	this.dec = function(strenc)
	{
		if(typeof strenc == "undefined" || strenc == null)return;
		if(strenc.charAt(0) != 'd')return;
		var cnt = 1;
		while(cnt < strenc.length)
		{
			var kvk = sji_valdec(strenc.substring(cnt, strenc.length));
			if(kvk == null)break;
			cnt += kvk.key;
			var kvv = sji_valdec(strenc.substring(cnt, strenc.length));
			if(kvv == null)break;
			cnt += kvv.key;
			this[kvk.value] = kvv.value;
		}
		if(strenc.charAt(cnt) != 'e')return; // error, not terminator
	}
	this.displayname = function(ex)
	{
		var strpvc = "";
		var str1 = "";
		if(typeof this.vpi == "undefined" || typeof this.vci == "undefined" || typeof this.cmode == "undefined")return str;

		strpvc = "_0_" + this.vpi + "_" + this.vci;

		if(typeof this.applicationtype == "undefined") return strpvc;

		str1 = strpvc;

		if(this.cmode == 0) str1 = "_B" + str1;
		else str1 = "_R" + str1;

		if(this.applicationtype == 0)  str1 = "TR069_INTERNET" + str1;
		else if(this.applicationtype == 1)  str1 = "TR069" + str1;
		else if(this.applicationtype == 2)  str1 = "INTERNET" + str1;
		else if(this.applicationtype == 3)  str1 = "Other" + str1;

		if(typeof ex == "undefined" || !ex) return str1;

		var str2 = strpvc;
		if(this.cmode == 2) str2 = "ppp" + str2;
		else str2 = "nas" + str2;

		return str1 + "/" + str2;
	}

	for(var i = 1; i < arguments.length; i++)
	{
		if(typeof arguments[i].key == "undefined" || typeof arguments[i].value == "undefined")continue;
		this[arguments[i].key] = arguments[i].value;
	}
	return this;
}

//--------------------------
//功能：检查输入的IP，mask
//=========================
function validateKey(str)
{
   for (var i=0; i<str.length; i++) {
    if ( (str.charAt(i) >= '0' && str.charAt(i) <= '9') ||
    		(str.charAt(i) == '.' ) )
			continue;
	return 0;
  }
  return 1;
}
function validateKey2(str)
{
   for (var i=0; i<str.length; i++) {
    if ( (str.charAt(i) >= '0' && str.charAt(i) <= '9') ||
    		(str.charAt(i) == '-' ) || 
    		(str.charAt(i) >= 'A' && str.charAt(i) <= 'F')||
    		(str.charAt(i) >= 'a' && str.charAt(i) <= 'f') )
			continue;
	return 0;
  }
  return 1;
}
function IsInvalidIP(str)
{
//	if ((str == "127.100.100.100") || (str == "127.255.255.254"))
	d = getDigit(str, 1);
	if (d == 127)
		return 1;
	return 0;
}
function IsLoopBackIP(str)
{
	if(str=="127.0.0.1")
		return 1;
	return 0;
}
function getDigit(str, num)
{
  i=1;
  if ( num != 1 ) {
  	while (i!=num && str.length!=0) {
		if ( str.charAt(0) == '.' ) {
			i++;
		}
		str = str.substring(1);
  	}
  	if ( i!=num )
  		return -1;
  }
  for (i=0; i<str.length; i++) {
  	if ( str.charAt(i) == '.' ) {
		str = str.substring(0, i);
		break;
	}
  }
  if ( str.length == 0)
  	return -1;
  d = parseInt(str, 10);
  return d;
}
function checkDigitRange(str, num, min, max)
{
  d = getDigit(str,num);
  if ( d > max || d < min )
      	return false;
  return true;
}
function checkHostIP(ip, checkEmpty)
{
	if (checkEmpty == 1 && ip.value=="") {
		alert("IP地址不能是空的! 格式为 xxx.xxx.xxx.xxx.");
		ip.value = ip.defaultValue;
		ip.focus();
		return false;
	}
	if (validateKey(ip.value) == 0) {
		alert("IP地址无效. 必须是(0-9)的数字.");
		ip.value = ip.defaultValue;
		ip.focus();
		return false;
	}
	
	if (IsLoopBackIP(ip.value)==1 || IsInvalidIP(ip.value)==1) {
		alert("IP地址无效.");
		ip.value = ip.defaultValue;
		ip.focus();
		return false;
	}
	
	if (!checkDigitRange(ip.value, 1, 1, 223)) {
		alert('IP地址的第一个位元无效. 必须是 1-223的数值.');
		ip.value = ip.defaultValue;
		ip.focus();
		return false;
	}
	if (!checkDigitRange(ip.value, 2, 0, 255)) {
		alert('IP地址的第二个位元无效. I必须是 0-255的数值.');
		ip.value = ip.defaultValue;
		ip.focus();
		return false;
	}
	if (!checkDigitRange(ip.value, 3, 0, 255)) {
		alert('IP地址的第三个位元无效. 必须是 0-255的数值.');
		ip.value = ip.defaultValue;
		ip.focus();
		return false;
	}
	if (!checkDigitRange(ip.value, 4, 0, 254)) {
		alert('IP地址的第四个位元无效. 必须是 0-254的数值.');
		ip.value = ip.defaultValue;
		ip.focus();
		return false;
	}
	
	return true;
}
function checkNetmask(netmask, checkEmpty)
{
	var i, d;

	if (checkEmpty == 1 && netmask.value == "") {
		alert("子网掩码不能是空的! 格式为 xxx.xxx.xxx.xxx.");
		netmask.value = netmask.defaultValue;
		netmask.focus();
		return false;
	}

	if (validateKey(netmask.value) == 0) {
		alert("子网掩码无效. 必须是(0-9)的数字.");
		netmask.value = netmask.defaultValue;
		netmask.focus();
		return false;
	}

	for (i=1; i<=4; i++) {
		d = getDigit(netmask.value, i);
		if( !(d==0 || d==128 || d==192 || d==224 || d==240 || d==248 || d==252 || d==254 || d==255 )) {
			alert('子网掩码无效.\n必须是下列的数字 0, 128, 192, 224, 240, 248, 252 or 254');
			netmask.focus();
			return false;
		}
	}

	return true;
}
function checkMask(netmask)
{
	var i, d;

	if (netmask.value == "") {
		alert("子网掩码不能是空的! 格式为 xxx.xxx.xxx.xxx.");
		netmask.value = netmask.defaultValue;
		netmask.focus();
		return false;
	}

	if (validateKey(netmask.value) == 0) {
		alert("子网掩码无效. 必须是(0-9)的数字.");
		netmask.value = netmask.defaultValue;
		netmask.focus();
		return false;
	}

	for (i=1; i<=4; i++) {
		d = getDigit(netmask.value, i);
		if (!(d==0 || d==128 || d==192 || d==224 || d==240 || d==248 || d==252 || d==254 || d==255)) {
			alert('子网掩码无效. 必须是(0-9)的数字 0, 128, 192, 224, 240, 248, 252 or 254');
			netmask.focus();
			return false;
		}
	}

	return true;
}
function includeSpace(str)
{
  for (var i=0; i<str.length; i++) {
  	if ( str.charAt(i) == ' ' ) {
	  return true;
	}
  }
  return false;
}
function checkPrintableString(str)
{
	for (var i=0; i<str.length; i++) {
		//if ((str.charAt(i) >= '0' && str.charAt(i) <= '9') || (str.charAt(i) >= 'A' && str.charAt(i) <= 'Z') || (str.charAt(i) >= 'a' && str.charAt(i) <= 'z') ||
		//   (str.charAt(i) == '.') || (str.charAt(i) == ':') || (str.charAt(i) == '-') || (str.charAt(i) == '_') || (str.charAt(i) == ' ') || (str.charAt(i) == '/') || (str.charAt(i) == '@'))
		if((str.charAt(i) >= ' ') && (str.charAt(i) <= '~'))
			continue;
		return 0;
	}
	return 1;
}

function checkString(str)
{
	for (var i=0; i<str.length; i++) {
		if ((str.charAt(i) >= '0' && str.charAt(i) <= '9') || (str.charAt(i) >= 'A' && str.charAt(i) <= 'Z') || (str.charAt(i) >= 'a' && str.charAt(i) <= 'z') ||
		   (str.charAt(i) == '.') || (str.charAt(i) == ':') || (str.charAt(i) == '-') || (str.charAt(i) == '_') || (str.charAt(i) == ' ') || (str.charAt(i) == '/') || (str.charAt(i) == '@'))
			continue;
		return 0;
	}
	return 1;
}
function deleteClick()
{
	if ( !confirm('删除这项设定?') ) {
		return false;
	}
	else
		return true;
}
//------------------------------
//功能：IPV6 static route
//==============================
function validateKeyV6IP(str)
{   
   find_flag=0;  
   account=0;   
   
   for (var i=0; i<str.length; i++) {
    if ( (str.charAt(i) >= '0' && str.charAt(i) <= '9') ||
    		(str.charAt(i) == ':' ) || 
    		(str.charAt(i) >= 'A' && str.charAt(i) <= 'F')||
    		(str.charAt(i) >= 'a' && str.charAt(i) <= 'f') ) {    			
    			if ((str.charAt(i) == ':' && str.charAt(i-1) == ':') || str.charAt(i) == ':' ) {
    				//find_flag = find_flag + 1;
    				account = account + 1;				
    			}
    			
    			if ((str.charAt(i) == ':' && str.charAt(i-1) == ':')) {
    				find_flag = find_flag + 1;
    			}
    			
    			if (str.charAt(i) == ':' && str.charAt(i-1) == ':' && str.charAt(i-2) == ':') {
    				return 0;    				
    			}    			
    			 				
			continue;
    }
    return 0;
  }
  
  // alert("find_flag="+find_flag);
  
  if ( find_flag > 1 || account == 1)
  	return 0;
  	
  return 1;
}


function validateKeyV6Prefix(str)
{   
   find_flag=0;    
   var prefix_len=0;
   var prefix_len_tmp1=0;
   var prefix_len_tmp2=0;   
  
   for (var i=0; i<str.length; i++) {
    if ( (str.charAt(i) >= '0' && str.charAt(i) <= '9') ||
    		(str.charAt(i) == ':' ) || (str.charAt(i) == '/' ) ||
    		(str.charAt(i) >= 'A' && str.charAt(i) <= 'F')||
    		(str.charAt(i) >= 'a' && str.charAt(i) <= 'f') ) {    			
    			if ((str.charAt(i) == ':' && str.charAt(i-1) == ':')) {
    				if ( str.charAt(i+1) != '/' ) {    					
    					return 0;
    				}
    				find_flag = find_flag + 1;
    			}    			
    			
    			if ( str.charAt(i) == '/' ) {
    				
    				 if ( str.charAt(i+1) < '0' || str.charAt(i+1) > '9') {    				 	
    				 	return 0;
    				 }
    				 
    				if ( (i+2) < str.length ) {
    				 	if ( str.charAt(i+2) < '0' || str.charAt(i+2) > '9') {    				 		
    				 		return 0;
    					}
    					    					
    					prefix_len_tmp1 = parseInt(str.charAt(i+1), 10); 					
    					prefix_len_tmp1 = prefix_len_tmp1*10;
    					prefix_len_tmp2 = parseInt(str.charAt(i+2), 10);    					
    					prefix_len = prefix_len_tmp1 + prefix_len_tmp2;       					 
    				} else {
    					prefix_len = parseInt(str.charAt(i+1), 10);    										
    				}    				
    				
    				if ( prefix_len > 64 || prefix_len < 3 ) {    					
    					return 0;
    				}
    			}    			
    				
    			if (str.charAt(i) == ':' && str.charAt(i-1) == ':' && str.charAt(i-2) == ':') {    				
    				return 0;    				
    			}    			
    			 				
			continue;
    }
    
    return 0;
  }
  
  //alert("find_flag="+find_flag);
  
  if ( find_flag != 1 ) {
  	//alert("validateKeyV6Prefix(6)");
  	return 0;
  }
  	
  return 1;
}

 
function isNumber(value)
{
	return /^\d+$/.test(value);
}
function ParseIpv6Array(str)
{
    var Num;
    var i,j;
    var finalAddrArray = new Array();
    var falseAddrArray = new Array();
    
    var addrArray = str.split(':');
    Num = addrArray.length;
    if (Num > 8)
    {
        return falseAddrArray;
    }

    for (i = 0; i < Num; i++)
    {
        if ((addrArray[i].length > 4) 
            || (addrArray[i].length < 1))
        {
            return falseAddrArray;
        }
        for (j = 0; j < addrArray[i].length; j++)
        {
            if ((addrArray[i].charAt(j) < '0')
                || (addrArray[i].charAt(j) > 'f')
                || ((addrArray[i].charAt(j) > '9') && 
                (addrArray[i].charAt(j) < 'a')))
            {
                return falseAddrArray;
            }
        }

        finalAddrArray[i] = '';
        for (j = 0; j < (4 - addrArray[i].length); j++)
        {
            finalAddrArray[i] += '0';
        }
        finalAddrArray[i] += addrArray[i];
    }

    return finalAddrArray;
}

function getFullIpv6Address(address)
{
    var c = '';
    var i = 0, j = 0, k = 0, n = 0;
    var startAddress = new Array();
    var endAddress = new Array();
    var finalAddress = '';
    var startNum = 0;
    var endNum = 0;
    var lowerAddress;
    var totalNum = 0;

    lowerAddress = address.toLowerCase();
 
    var addrParts = lowerAddress.split('::');
    if (addrParts.length == 2)
    {
        if (addrParts[0] != '')
        {
            startAddress = ParseIpv6Array(addrParts[0]);
            if (startAddress.length == 0)
            {
                return '';
            }
        }
        if (addrParts[1] != '')
        {
            endAddress = ParseIpv6Array(addrParts[1]);
            if (endAddress.length == 0)
            {
               return '';
            }
        }

        if (startAddress.length +  endAddress.length >= 8)
        {
            return '';
        }
    }
    else if (addrParts.length == 1)
    {
        startAddress = ParseIpv6Array(addrParts[0]);
        if (startAddress.length != 8)
        {
            return '';
        }
    }
    else
    {
        return '';
    }

    for (i = 0; i < startAddress.length; i++)
    {
        finalAddress += startAddress[i];
        if (i != 7)
        {
            finalAddress += ':';
        }
    }
    for (; i < 8 - endAddress.length; i++)
    {
        finalAddress += '0000';
        if (i != 7)
        {
            finalAddress += ':';
        }
    }
    for (; i < 8; i++)
    {
        finalAddress += endAddress[i - (8 - endAddress.length)];
        if (i != 7)
        {
            finalAddress += ':';
        }
    }

    return finalAddress;
    
}
function isUnicastIpv6Address(address)
{
    var tempAddress = getFullIpv6Address(address);
    
    if ((tempAddress == '')
        || (tempAddress == '0000:0000:0000:0000:0000:0000:0000:0000')
        || (tempAddress == '0000:0000:0000:0000:0000:0000:0000:0001')
        || (tempAddress.substring(0, 2) == 'ff'))
    {
        return false;
    }
    
    return true;
}

function isGlobalIpv6Address(address)
{
    var tempAddress = getFullIpv6Address(address);
    
    if ((tempAddress == '')
        || (tempAddress == '0000:0000:0000:0000:0000:0000:0000:0000')
        || (tempAddress == '0000:0000:0000:0000:0000:0000:0000:0001')
        || (tempAddress.substring(0, 3) == 'fe8')
        || (tempAddress.substring(0, 3) == 'fe9')
        || (tempAddress.substring(0, 3) == 'fea')
        || (tempAddress.substring(0, 3) == 'feb')
        || (tempAddress.substring(0, 2) == 'ff'))
    {
        return false;
    }
    
    return true;
}

//start for wan.asp
function isInteger(value)
{   	
	if (/^(\+|-)?\d+$/.test(value)) 
	{
	   return true;
	} 
	else 
	{
	    return false;
	}
}

function isPlusInteger(value)
{
	if (isInteger(value) && parseInt(value) >= 0)
	{
		return true;
	}
	else
	{
		return false;
	}
}
//end for wan.asp



//-------------------
//功能：检查用户名是否符合指定规则
//====================
function sji_checkusername(username, smin, smax)
{
	if(typeof username == "undefined")return false;
	if(typeof smin != "undefined" && username.length < smin)return false;
	if(typeof smax != "undefined" && username.length > smax)return false;

	var pattern = /^([a-zA-Z0-9_-])+$/;
	return pattern.test(username);
}


function sji_checkhostname(username, smin, smax)
{
	if(typeof username == "undefined")return false;
	if(typeof smin != "undefined" && username.length < smin)return false;
	if(typeof smax != "undefined" && username.length > smax)return false;

	var pattern = /^([a-zA-Z0-9@.\-])+$/;
	return pattern.test(username);
}

//-----------------------
//功能：检查输入的密码是否合乎常规应用，且长度符合要求
//======================
function sji_checkpswnor(str, smin, smax)
{
	if(typeof str == "undefined")return false;
	if(typeof smin != "undefined" && str.length < smin)return false;
	if(typeof smax != "undefined" && str.length > smax)return false;

	var pattern = /^[a-zA-Z0-9%@.,~+=_*&\s\(\)\[\]:]+$/;
	return pattern.test(str);
}

/********************************************************************
**          Utility functions
********************************************************************/
function sji_int(val){if(val == false) {return 0;} else if(val == true) {return 1;} else {return parseInt(val);}}
function sji_docinit(doc, cgi)
{
	var surl = doc.getElementsByName("submit-url");
	if(surl && surl.length > 0)
	{
		if(surl[0].value == "")surl[0].value = doc.location.href;
	}

	var stype = "";
	var stag = "";
	var svalue = null;

	if(typeof doc == "undefined" || typeof cgi == "undefined")return;
	for(var name in cgi)
	{
		if(typeof cgi[name] != "boolean" && typeof cgi[name] != "string" && typeof cgi[name] != "number")continue;
		svalue = cgi[name];
		var obj = doc.getElementsByName(name);
		if(typeof obj != "object")continue;
		if(obj.length == 0 || typeof obj[0].tagName == "undefined")continue;
		stag = obj[0].tagName;
		if(stag == "LABEL")
		{
			obj[0].innerHTML = svalue;
		}
		else if(stag == "TD")
		{
			obj[0].innerHTML = svalue;
		}
		else if(stag == "INPUT")
		{
			stype = obj[0].type;
			if(stype == "text" || stype == "hidden")obj[0].value = svalue;
			else if(stype == "radio")obj[sji_int(svalue)].checked = true;
			else if(stype == "checkbox")obj[0].checked = sji_int(svalue);
			else {/*warning*/}
		}
		else if(stag == "SELECT")
		{
			obj[0].value = svalue;
		}
		else {/*warning*/}
	}
}

function sji_encode(ar, field)
{
	var senc = null;
	if(typeof ar == "undefined")return null;

	senc = "l";
	for(var i in ar)
	{
		if(!ar[i][field])continue;
		senc += ar[i].enc();
	}
	senc += "e";

	return senc;
}

/********************************************************************
**          string functions
********************************************************************/

function sji_valenc(val)
{
	var text = "";
	if(typeof val == "undefined")return null;
    else if(typeof val == "string")
    {
        text = val.length + ":" + val;
    }
    else if(typeof val == "number")
    {
        text = "i" + val + "e";
    }
	else return null;

    return text;
}

function enableTextField (field) {
	if (document.all || document.getElementById)
		field.disabled = false;
	else {
		field.onfocus = field.oldOnFocus;
	}
}

function disableTextField (field) {
	if (document.all || document.getElementById)
		field.disabled = true;
	else {
		field.oldOnFocus = field.onfocus;
		field.onfocus = skip;
	}
}

//-----------------------
//说明：多级对象结构
//名称 选中
//======================
function it_mlo(name)
{
	if(typeof name == "undefined")return null;

	this.name = name;
	this.childs = new Array();
	this.select = false;

	this.add = function(o)
	{
		if(typeof childs[o.name] != "undefined")return;
		childs[o.name] = o;
		childs.push(o);
	}
	this.destroy = function(){delete childs;childs = null;}

	for(var i = 1; i < arguments.length; i++)
	{
		if(typeof arguments[i].name != "undefined")this.childs[arguments[i].name] = arguments[i];
		this.childs.push(arguments[i]);
	}

	return this;
}


//-----------------------
//功能：检查输入的IP地址是否为合法IP地址
//======================
function sji_checkvip(ip)
{
	if(typeof ip == "undefined")return false;

	var pattern1 = /^([1-9]|[1-9]\d|1\d\d|2[0-4]\d|25[0-5])(\.([0-9]|[1-9]\d|1\d\d|2[0-4]\d|25[0-5])){2}(\.([1-9]|[1-9]\d|1\d\d|2[0-4]\d|25[0-4]))$/;
	if(pattern1.test(ip) == false) return false;

	var pattern2 = /^127\..+$/;
	if(pattern2.test(ip) == true) return false;

	return true;
}
function verifyBrowser() {
	var ms = navigator.appVersion.indexOf("MSIE");
	ie4 = (ms>0) && (parseInt(navigator.appVersion.substring(ms+5, ms+6)) >= 4);
	var ns = navigator.appName.indexOf("Netscape");
	ns= (ns>=0) && (parseInt(navigator.appVersion.substring(0,1))>=4);
	if (ie4)
		return "ie4";
	else
		if(ns)
			return "ns";
		else
			return false;
}
//-----------------------
//功能：检查输入的字符串是否合乎常规应用，且长度符合要求
//======================
function sji_checkstrnor(str, smin, smax)
{
	if(typeof str == "undefined")return false;
	if(typeof smin != "undefined" && str.length < smin)return false;
	if(typeof smax != "undefined" && str.length > smax)return false;

	/*ql:20080717 START: Don't restrict the length of the string*/
	//var pattern = /^[a-zA-Z0-9%@.,~+=_*&\(\)\[\]:][a-zA-Z0-9%@.,~+=_*&\s\(\)\[\]:]+[a-zA-Z0-9%@.,~+=_*&\(\)\[\]:]$/;
	var pattern = /^[a-zA-Z0-9%@.,~+=_*&\(\)\[\]:]+$/;
	/*ql:20080717 END*/
	return pattern.test(str);
}

//-----------------------
//功能：检查输入的是否为数字
//======================
function sji_checkdigit(str)
{
	if(typeof str == "undefined")return false;
	var pattern = /^-?[0-9]+((\.[0-9]+)|([0-9]*))$/;
	return pattern.test(str);
}

//-----------------------
//功能：检查输入的数值是否符合数值范围
//======================
function sji_checkdigitrange(num, dmin, dmax)
{
	if(typeof num == "undefined")return false;
	if(sji_checkdigit(num) == false)
	{
		return false;
	}
  	var val = parseInt(num, 10);
	if(typeof dmin != "undefined" && val < dmin)return false;
	if(typeof dmax != "undefined" && val > dmax)return false;
	return true;
}

// --------------------------------
// Mason Yu. For IPv6
// --------------------------------

//star:20100825 IPV6_RELATED
function isIPv6(str)
{
 if(str.indexOf(":")<0)
	return false;
return str.match(/:/g).length<=7
&&/::/.test(str)
?/^([\da-f]{1,4}(:|::)){1,6}[\da-f]{1,4}$/i.test(str)
:/^([\da-f]{1,4}:){7}[\da-f]{1,4}$/i.test(str);
}


function isIpv6Address(address)
{
    if (getFullIpv6Address(address) == '')
    {
        return false;
    }

    return true;
}

function isUnicastIpv6AddressForDHCPv6(address)
{
    var tempAddress = getFullIpv6Address(address);

    if ((tempAddress == '')
        || (tempAddress.substring(0, 2) == 'ff'))
    {
        return false;
    }

    return true;
}

function isLinkLocalIpv6Address(address)
{
    var tempAddress = getFullIpv6Address(address);

    if ( (tempAddress.substring(0, 3) == 'fe8')
        || (tempAddress.substring(0, 3) == 'fe9')
        || (tempAddress.substring(0, 3) == 'fea')
        || (tempAddress.substring(0, 3) == 'feb'))
    {
        return true;
    }

    return false;
}
//star:20100825 IPV6_RELATED END

var xssChars = [
	["<", "&lt;"],
	[">", "&gt;"],
	["&", "&amp;"],
	["\"", "&quot;"],
	["\'", "&#39;"]
];
				
function detectContainXSSChar(name, value) {
	// current only detect the following characters
	var expression = "[";
	for (var i = 0; i < xssChars.length; i++){
		expression += xssChars[i][0];
	}
	expression += "]";

	var reg = new RegExp(expression);
	// judge whether the value contains special characters
	if(reg.test(value)){
		alert("The value(" +value+ ") set for name(" +name+ ") may cause the risk of XSS attack!");
		name.focus();
		return false;
	}else{
		return true;
	} 
}

function unescapeHTML(str){
	var result = str+"";
	var regex;
	 
	for (var i=0; i < xssChars.length; i++){
		regex = new RegExp(xssChars[i][1], 'g');
		result = result.replace(regex, xssChars[i][0]);	
	}
	//console.log("result", result);
	return result;
}


function postTableEncrypt(postobj, formobj)
{
	var obj;
	var inputVal = "";
	var csum = 0;
	var i, name, value;
	//1. encodeURIComponent can not encode such characters: !,',(,),*,-,.,_,~
	//   while !,',(,),~ should be encoded to %21, %27, %28, %29, %7E
	//2. encodeURIComponent will encode space key as %20, while it will be posted as +, so we should translate %20 to +
	//var dic = {"!": "%21", "'": "%27", "(": "%28", ")": "%29", "~": "%7E", "%20": "+"};

	if (formobj.elements.length)
	{
		for(i=0; i<formobj.elements.length; i++)
		{
			obj=formobj[i];

			if (obj.name==undefined || obj.name=="" || obj.name=="postSecurityFlag" || obj.name=="csrftoken")
				continue;
			
			if (obj.disabled == true)
				continue;

			if ((obj.type != 'submit') && (obj.type != 'reset') && (obj.type != 'button'))
			{
				if (obj.type == 'radio' || obj.type == 'checkbox')
				{
					if (obj.checked)
					{
						name = obj.name;
						value = encodeURIComponent(obj.value);
						value = value.replace(/!/gm, "%21");
						value = value.replace(/\'/gm, "%27");
						value = value.replace(/\(/gm, "%28");
						value = value.replace(/\)/gm, "%29");
						value = value.replace(/~/gm, "%7E");
						value = value.replace(/%20/gm, "+");
						inputVal += name + "=" + value + "&";
					}
				}
				else if (obj.type == 'select-one' || obj.type == 'select-multiple')
				{
					if (obj.value != "")
					{
						name = obj.name;
						value = encodeURIComponent(obj.value);
						value = value.replace(/!/gm, "%21");
						value = value.replace(/\'/gm, "%27");
						value = value.replace(/\(/gm, "%28");
						value = value.replace(/\)/gm, "%29");
						value = value.replace(/~/gm, "%7E");
						value = value.replace(/%20/gm, "+");
						inputVal += name + "=" + value + "&";
					}
					else if((obj.selectedIndex>=0) && (obj.options[obj.selectedIndex].text != ""))//for ie8
					{
						name = obj.name;
						value = encodeURIComponent(obj.options[obj.selectedIndex].text);
						value = value.replace(/!/gm, "%21");
						value = value.replace(/\'/gm, "%27");
						value = value.replace(/\(/gm, "%28");
						value = value.replace(/\)/gm, "%29");
						value = value.replace(/~/gm, "%7E");
						value = value.replace(/%20/gm, "+");
						inputVal += name + "=" + value + "&";
					}
				}
				else
				{
					name = obj.name;
					value = encodeURIComponent(obj.value);
					value = value.replace(/!/gm, "%21");
					value = value.replace(/\'/gm, "%27");
					value = value.replace(/\(/gm, "%28");
					value = value.replace(/\)/gm, "%29");
					value = value.replace(/~/gm, "%7E");
					value = value.replace(/%20/gm, "+");
					inputVal += name + "=" + value + "&";
				}
			}
			else
			{
				if (obj.isclick == 1)
				{
					name = obj.name;
					value = encodeURIComponent(obj.value);
					value = value.replace(/!/gm, "%21");
					value = value.replace(/\'/gm, "%27");
					value = value.replace(/\(/gm, "%28");
					value = value.replace(/\)/gm, "%29");
					value = value.replace(/~/gm, "%7E");
					value = value.replace(/%20/gm, "+");
					inputVal += name + "=" + value + "&";
				}
			}
		}
	}
	
	//alert("post: " + inputVal + " length: " + inputVal.length);

	i = 0;
	while (i<inputVal.length)
	{
		if ((i+4) > inputVal.length)
		{
			if (i < inputVal.length)
				csum += (inputVal.charCodeAt(i)<<24);
			if ((i+1) < inputVal.length)
				csum += (inputVal.charCodeAt(i+1)<<16);
			if ((i+2) < inputVal.length)
				csum += (inputVal.charCodeAt(i+2)<<8);
			
			break;
		}
		else
		{
			csum += (inputVal.charCodeAt(i)<<24) + (inputVal.charCodeAt(i+1)<<16) + (inputVal.charCodeAt(i+2)<<8) + inputVal.charCodeAt(i+3);
			i += 4;
		}
	}
	csum = (csum & 0xffff) + (csum >> 16);
	csum = csum&0xffff;
	csum = (~csum)&0xffff;
	
	//doc.getElementsByName("postSecurityFlag")[0].value = csum;
	postobj.value = csum;
}

/*getElByName*/
function getElementByName(sId)
{    // standard
        if (document.getElementsByName)
        {
                var element = document.getElementsByName(sId);

                if (element.length == 0)
                {
                        return null;
                }
                else if (element.length == 1)
                {
                        return  element[0];
                }

                return element;
        }
}
function getElementById(sId)
{
        if (document.getElementById)
        {
                return document.getElementById(sId);
        }
        else if (document.all)
        {
                // old IE
                return document.all(sId);
        }
        else if (document.layers)
        {
                // Netscape 4
                return document.layers[sId];
        }
        else
        {
                return null;
        }
}
function getElement(sId)
{
         var ele = getElementByName(sId);
         if (ele == null)
         {
                 return getElementById(sId);
         }
         return ele;
}
function getElById(sId)
{
        return getElement(sId);
}
/*
 * getSelect - get the select element, and return the selected option
 * @element: select element to get
 */
function getSelect(element)
{
        if (element.options.length > 0) {
                return element.options[element.selectedIndex].value;
        } else {
                return "";
        }
}

/*
 * setSelect - set the select element to the option with specified value
 * @element: select element to set
 * @value: value to set to @element
 */
function setSelect(element, value)
{
        var i;

        for (i = 0; i < element.options.length; i++) {
                if (element.options[i].value == value) {
                        element.selectedIndex = i;
                        break;
                }
        }
}
