

function initHelpMenu(submenu)
{
	var help_menu = "";
	$.each(submenu, function(smi, smv) {
		if (-1 != smv.id.search("help_")) {
			help_menu = smv.id.substring(5);
			$.each(Ont.MainMenu, function(mi, mv) {
				if (mv.id == help_menu) {
					smv.show = mv.show;
				}
			});
		}
	});
}

function isSubMenuShow(smobj)
{
	if (0 == (Ont.CurLoginUser & smobj.show) ||
		(0 == Ont.WifiNum && smobj.id == "wifi") ||
		(2 != Ont.WifiNum && smobj.id == "wifi5g") || 
		(0 == Ont.CurUsbConfig && smobj.id == "usb") ||
		(0 == Ont.CurPotsConfig && (smobj.id == "voip" || smobj.id == "voipinfo")) ||
		(0 == Ont.mesh_support && smobj.id == "wifi_mesh") ||
		(0 == Ont.ft_support && smobj.id == "wifi_ft")) {
		return false;
	}
	if ((Ont.CurLoginUser==3) && (smobj.id == "quickwifi") )//this page(quickwifi.asp) don't  display in advanced webpages
	{
		return false;
	}
	
	return true;
}

function WriteMainMenu()
{
	var mainMenuText = "";
	var str = "<ul>\n";

	Ont.CurMainMenu = top.window.CurMainMenu;
	Ont.CurSubMenu = top.window.CurSubMenu;

	$.each(Ont.MainMenu, function(mi, mv) {
		if (!(Ont.CurLoginUser & mv.show))
		{
			return true;
		}

		if (mv.id == Ont.CurMainMenu)
		{
			str += '<li id="nav_' + mv.id + '_act" class="main_menu_current">';
			mainMenuText = mv.text;
		}
		else
		{
			str += '<li id="nav_' + mv.id + '">';
		}

		var fs = 0;
		$.each(mv.submenu, function(smi, smv) {
			if (!isSubMenuShow(smv))
			{
				fs++;
			}
			else
			{
				return false;
			}
		});

		str += '<a href="javascript: ShowPage(\'' + mv.submenu[fs].id + '\')">' + mv.text + '</a></li>\n';
	});

	str += "</ul>\n";
	$("#main_menu").html(str);
	$("#nav_header").html(mainMenuText);
	
	var menu_num = $("#main_menu li").length;
	var margin_value = Math.floor((960 - 90 * menu_num)/menu_num/2);
	$("#main_menu li").css("margin", "0px " + margin_value + "px");
}

function WriteSubMenu()
{
	$.each(Ont.MainMenu, function(mi, mv) {
		if (mv.id == Ont.CurMainMenu) {
			var str = "<ul>\n";
			$.each(mv.submenu, function(smi, smv) {
				if (!isSubMenuShow(smv)) {
					return true;
				}
				if (smv.id == Ont.CurSubMenu) {
					str += '<li id="submenu_' + smv.id + '_act" class="sub_menu_act">';
					
					if(smv.id != "quickwifi" && smv.id != "quick_register"
					&& smv.id != "quick_voip" && smv.id != "quick_wifi"
					&& smv.id != "vlan")
						str += '<a href="javascript: ShowPage(\'' + smv.id + '\')">' + smv.text  + '<span class="arrowup"></span>'+ '</a>\n';
					else
						str += '<a href="javascript: ShowPage(\'' + smv.id + '\')">' + smv.text  + '</a>\n';
				}
				else {
					str += '<li id="submenu_' + smv.id + '" class="sub_menu">';
					
					if(smv.id != "quickwifi" && smv.id != "quick_register"
					&& smv.id != "quick_voip" && smv.id != "quick_wifi"
					&& smv.id != "vlan")						
						str += '<a href="javascript: ShowPage(\'' + smv.id + '\')">' + smv.text  + '<span class="arrowdown"></span>' + '</a>\n';
					else
						str += '<a href="javascript: ShowPage(\'' + smv.id + '\')">' + smv.text  + '</a>\n';
				}
				if (smv.id == Ont.CurSubMenu) {
					str += '<ul id="ss_menu">' + webMainTitle + '</ul>';
				}
				str += '</li>';
			});

			str += "</ul>\n";
			$("#sub_menu").html(str);

			return false;
		}
	});

}

function getMainMenu(smid)
{
	var mmid = "";
	$.each(Ont.MainMenu, function(mi, mv) {
		$.each(mv.submenu, function(smi, smv) {
			if (smv.id == smid) {
				mmid = mv.id;
				return false;
			}
		});
		if (mmid.length > 0) {
			return false;
		}
	});
	return mmid;
}

function ShowPage(page)
{
	if (page == "pluginmanager") {
		window.open("https://oms.ep.chinamobile.com/pms-plugin/login.html");
		return;
	}
	top.window.CurMainMenu = getMainMenu(page);
	top.window.CurSubMenu = page;
	document.location = page + ".asp";
	top.window.XWebCurPageId = "";
	top.window.XWebCurTrdMenuId = "";
}

var webMainTitle = "";
function WriteMainTitle(title, id)
{
	var str = "";

	if (undefined == id)
	{
		str +='<li class="x_main_title">';
	}
	else
	{
		str +='<li class="x_main_title" id="' + id + '">';
	}
	str +='<a href="javascript: showMainContent(\'' + id + '\')">' + title + '</a></li>';

	webMainTitle += str;
}

function WriteWlanIdx(idx)
{
	$("#wlan_idx").val(idx);
	$("#wlan_idx").change();	
}

function WriteMainTitleWithWlanIdx(title, id, idx)
{
	var str = "";

	if (undefined == id)
	{
		str +='<li class="x_main_title">';
	}
	else
	{
		str +='<li class="x_main_title" id="' + id + idx + '">';
	}
	str +='<a href="javascript: showMainContentWithWlanIdx(\'' + id + '\',\'' + idx + '\')">' + title + '</a></li>';

	webMainTitle += str;
}

function initHelpContent()
{
	var help_menu;
	
	if (-1 == Ont.CurSubMenu.search("help_")) {
		return;
	}

	help_menu = Ont.CurSubMenu.substring(5);
	
	$.each(Ont.MainMenu, function(mi, mv) {
		if (mv.id == help_menu) {
			$.each(mv.submenu, function(smi, smv) {
				if (!isSubMenuShow(smv)) {
					if(smv.id != "dhcp")
						$("#help_" + smv.id).hide();
					return true;
				}
			});
			return false;
		}
	});
}

function showErrMessage()
{
	var paragraph = document.getElementById('errmessage');
	var errMsg = myUrl.searchParam('errMsg');
	if(errMsg !='' && paragraph != null) {
		var old_innerHTML = paragraph.innerHTML;
		var new_innerHTML = '<span style=color:red>'+errMsg+'</span>' + old_innerHTML;
		paragraph.innerHTML = new_innerHTML;
	}
}

function initMainContent()
{
	var divArray;
	var class_name = "";
	var menu_cnt = 0;
	var content_cnt = 0;
	var fstMenuId = "";
	var submit_flag = 0;
	var cur_find = 0;
	var i = 0;

	if (top.window.XWebCurPageId == Ont.CurSubMenu)
	{
		submit_flag = 1;
	}

	divArray = $(".x_main_title");
	for (i = 0; i < divArray.length; i++)
	{
		if (divArray[i].style.display != "none")
		{
			if (0 == submit_flag)
			{
				// after click mainmenu or submenu, show first page
				if (0 == menu_cnt)
					fstMenuId = divArray[i].id;
				menu_cnt++;
			}
			else if (0 == cur_find && divArray[i].id == top.window.XWebCurTrdMenuId)
			{
				// after submit, show current page
				cur_find = 1;
				$("#" + divArray[i].id).attr("class", "x_main_title_active");
			}
		}
	}
	divArray = $(".x_main_content");
	for (i = 0; i < divArray.length; i++)
	{
		if (divArray[i].style.display != "none")
		{
			if (cur_find)
			{
				if (divArray[i].id != "x_" + top.window.XWebCurTrdMenuId)
					$("#" + divArray[i].id).hide();
			} else {
				if (0 != content_cnt)
					$("#" + divArray[i].id).hide();
				content_cnt++;
			}
		}
	}
	if (cur_find == 0 && fstMenuId != "")
	{
		$("#" + fstMenuId).attr("class", "x_main_title_active");
	}
	showErrMessage();
	RecalcHelpHeight();
}

function showMainContent(id)
{
	$(".x_main_title_active").attr("class", "x_main_title");
	$(".x_main_content").hide();
	$(".x_message").hide();

	top.window.XWebCurPageId = Ont.CurSubMenu;
	top.window.XWebCurTrdMenuId = id;
	$("#" + id).attr("class", "x_main_title_active");
	$("#x_" + id).show();
	RecalcHelpHeight();
}

function showMainContentWithWlanIdx(id,idx)
{
	WriteWlanIdx(idx);	
	showMainContent(id+idx);
}

function WriteSubTitleBegin(title, hclass, id)
{
	$W('<div class="x_sub_title">' + title + '</div>\n');
	$W('<div class="x_form_area ' + hclass + '">\n');
}

function WriteSubTitleEnd()
{
	$W('</div>\n');
}

function WriteDivideLine(id)
{
	if (undefined == id)
	{
		$W('<div class="x_divide_line">\n');
	}
	else
	{
		$W('<div class="x_divide_line" id="' + id + '">\n');
	}
	$W('</div>\n');
}

function WriteDynamicTable(title, id)
{
	if (title != "") {
		$W('<div class="x_sub_title">' + title + '</div>\n');
	}
	$W('<div id="' + id + '">\n');
	$W('</div>\n');
}

function RecalcHelpHeight()
{
	var content_height = $("#content").outerHeight() + 350;
	if (content_height < 900)
		content_height = 900;
	$("#nav").height(content_height);
	$("#maincontent").height(content_height);
}


function RecalcDynamicTableHeight(id)
{
	$(".x_table tr:nth-child(even)").addClass("even");
	$(".x_table tr:nth-child(odd)").addClass("odd");
	RecalcHelpHeight();
}

function GetWanName(wan)
{
	var name = "";
	name += wan.index + 1;
	if (wan.service&Ont.TR069)
	{
		name += "_TR069";
	}

	if (wan.service&Ont.VOIP)
	{
		name += "_VOIP";
	}

	if (wan.service&Ont.INTERNET)
	{
		name += "_INTERNET";
	}

	if (wan.service&Ont.IPTV)
	{
		name += "_OTHER";
	}

	name += (0 == wan.bridge)?"_R":"_B";

	name += "_VID_";
	var vlan = 0;
	if (wan.vlan_enable)
	{
		vlan = wan.vlan_vid & 0xFFF; //vlan just low 12 bits.
		name += vlan.toString();
	}	

	return name;
}

