
function ipv6_mode_set(ori)
{
	switch(ori)
	{
	case 2://Addr auto, IA_PD
		$("#ipv6_addr_mode").val(0);
		$("#ipv6_pd_mode").val(2);
		break;

	case 3://IA_NA, IA_PD
		$("#ipv6_addr_mode").val(1);
		$("#ipv6_pd_mode").val(2);
		break;

	case 34://Addr none, IA_PD
		$("#ipv6_addr_mode").val(32);
		$("#ipv6_pd_mode").val(2);
		break;

	case 128://Addr auto, NO_PD
		$("#ipv6_addr_mode").val(0);
		$("#ipv6_pd_mode").val(128);
		break;

	case 129://IA_NA, NO_PD
		$("#ipv6_addr_mode").val(1);
		$("#ipv6_pd_mode").val(128);
		break;

	case 160://Addr none, NO_PD
		$("#ipv6_addr_mode").val(32);
		$("#ipv6_pd_mode").val(128);
		break;
	}
}

function dslite_mode_change()
{
	if(1 == parseInt($("#dslite_mode").val()))
	{
		$("#aftr_endpoint").attr("disabled", false);
		$("#aftr_endpoint").show();
	}
	else
	{
		$("#aftr_endpoint").val("");
		$("#aftr_endpoint").attr("disabled", true);
		$("#aftr_endpoint").hide();
	}
}

function wan_web_init()
{
	$("#aftr_endpoint").hide();
	if(Ont.ProvinceCode == "JS")
	{
		$("#router_bridge_mix_div").show();	
	}
	else
	{		
		$("#router_bridge_mix_div").hide();
	}

	if(1 == Ont.ProtocolVer)
	{
		$("#div_ip_ver").hide();
		$("#div_wan_static_ipv6").hide();
		$("#div_ipv6_dhcp").hide();
	}
	else if (2 == Ont.ProtocolVer)
	{
		$("#div_ip_ver").hide();
	}

	if(0 == Ont.WifiNum)
	{
		$("#div_wifi_portbind").hide();
	}
	else if(1 == Ont.WifiNum)
	{
		$("#div_ssid_2g").show();
		$("#div_ssid_5g").hide();
	}
	else if(2 == Ont.WifiNum)
	{
		$("#div_ssid_2g").show();
		$("#div_ssid_5g").show();
	}

	var wan_num = 0;
	var wan_empty = -1;
	$("#wan_conlist option:first").remove();
	$.each(WanConfig.WanList, function(wi, wv){
		if (0 == wv.valid)
		{
			if (-1 == wan_empty)
			{
				wan_empty = wi;
			}
			return true;
		}

		wan_num++;

		$("<option></option>").val(wi).text(GetWanName(wv)).appendTo("#wan_conlist");
	});

	if(wan_num < WanConfig.MaxWanNum)
	{
		$("<option></option>").val(wan_empty).text("建一条新的WAN连接").appendTo("#wan_conlist");
	}

	$("#wan_conlist").val(WanConfig.CurWanList);

	wan_lan_set();
	wan_ssid_set();
	wan_set_value();
	wan_con_set();
	con_mode_change();
}

function wan_ssid_set()
{
	var i;

	for(i = 0; i < 8; i++)
	{
		var name = "ssid" + (i+1).toString();
		if (i >= 4)
		{
			name = "ssid" + (i+1).toString() + "_5g";
		}

		if(WifiConfig.ssid_enable[i]==1)
		{
			$(name).attr("disabled", false);
		}
		else
		{
			$(name).attr("disabled", true);
		}
	}
}

function wan_lan_set()
{
	if(Ont.LanNum == 1)
	{
		$("#lan1").show();
		$("#label_lan1").show();
		$("#lan2").hide();
		$("#label_lan2").hide();
		$("#lan3").hide();
		$("#label_lan3").hide();
		$("#lan4").hide();
		$("#label_lan4").hide();
	}
	else if(Ont.LanNum == 2)
	{
		$("#lan1").show();
		$("#label_lan1").show();
		$("#lan2").show();
		$("#label_lan2").show();
		$("#lan3").hide();
		$("#label_lan3").hide();
		$("#lan4").hide();
		$("#label_lan4").hide();
	}
	else if (Ont.LanNum == 4)
	{
		$("#lan1").show();
		$("#label_lan1").show();
		$("#lan2").show();
		$("#label_lan2").show();
		$("#lan3").show();
		$("#label_lan3").show();
		$("#lan4").show();
		$("#label_lan4").show();
	}
}

function wan_set_nat()
{
	if (
		($("#con_mode")[0].selectedIndex == 0) &&
		((-1 != $("#wan_type").val().indexOf("INTERNET")) ||
		 (-1 != $("#wan_type").val().indexOf("IPTV")) ||
		 (-1 != $("#wan_type").val().indexOf("OTHER")))
	)
	{
		$("#nat").attr("checked", true);
	}
	else
	{
		$("#nat").attr("checked", false);
	}

	check_nat_disable();
}

function check_nat_disable()
{
	if (
		($("#con_mode")[0].selectedIndex == 0) &&
		((-1 != $("#wan_type").val().indexOf("INTERNET")) ||
		 (-1 != $("#wan_type").val().indexOf("IPTV")) ||
		 (-1 != $("#wan_type").val().indexOf("OTHER")))
	)
	{
		$("#nat").attr("disabled", false);
	}
	else
	{
		$("#nat").attr("disabled", true);
	}
}

function doClickTr069(check)
{
	var els = $("*");

	$.each(els, function(ei, ev){
		if(ev.type == "password"  || ev.type  == "checkbox" || ev.type  == "select-one")
		{
			if (ev.id != "wan_conlist")
			{
				$('#'+ev.id).attr("disabled", check);
			}	
		}
	});
	if (check)
	{
		$("#btn_save").hide();
		$("#btn_cancel").hide();
		$("#vlan_set").attr("disabled", true);
		$("#vlan_pbit").attr("disabled", true);
		$("#mtu").attr("disabled", true);
	}
	else
	{
		$("#btn_save").show();
		$("#btn_cancel").show();
		$("#vlan_set").attr("disabled", false);
		$("#vlan_pbit").attr("disabled", false);
		$("#mtu").attr("disabled", false);
	}
}

function wan_set_value()
{
	var wan = $("#wan_conlist")[0].selectedIndex;
	$("#dial_mode").val(0);
	$("#pppoe_demand").hide();
	$("#pppoe_manual").hide();

	if(wan == (WanConfig.WanNum))
	{
		// create new wan connection
		$("#en_con").attr("checked", false);
		$("#con_mode")[0].selectedIndex	= 0;
		$("#lan_dhcp").attr("checked", false);
		$("#wan_type")[0].selectedIndex	= 0;
		$("#nat").attr("checked", false);
		$("#nat").attr("disabled", true);
		$("#vlan_enable").attr("checked", true);
		$("#vlan_pbit").val(0);
		$("#vlan_set").val("");
		$("#lan1").attr("checked", false);
		$("#lan2").attr("checked", false);
		$("#lan3").attr("checked", false);
		$("#lan4").attr("checked", false);
		$("#ssid1").attr("checked", false);
		$("#ssid2").attr("checked", false);
		$("#ssid3").attr("checked", false);
		$("#ssid4").attr("checked", false);
		$("#ssid1_5g").attr("checked", false);
		$("#ssid2_5g").attr("checked", false);
		$("#ssid3_5g").attr("checked", false);
		$("#ssid4_5g").attr("checked", false);
		$("#router_bridge_mix").attr("checked", false);
		$("#pppoe_user").val("");
		$("#pppoe_psw").val("");
		$("#pppoe_alivetime").val("");
		$("#static_ip").val("");
		$("#static_mask").val("");
		$("#static_gw").val("");
		$("#static_pridns").val("");
		$("#static_secdns").val("");
		$("#static_ipv6addr").val("");
		$("#static_ipv6plen").val("");
		$("#static_ipv6gw").val("");
		$("#static_ipv6pridns").val("");
		$("#static_ipv6secdns").val("");
		$("#ip_mode")[0].selectedIndex	= 0;
		$("#dhcpv6_ver").val(0);
		$("#dslite_enable").attr("checked", false);
		$("#dslite_mode").val(0);
		$("#aftr_endpoint").val("");
		$("#aftr_endpoint").attr("disabled", true);
		$("#aftr_endpoint").hide();
		$("#opt60_mode")[0].selectedIndex	= 0;
		$("#ipv6_addr_mode")[0].selectedIndex	= 0;
		if(2 == Ont.ProtocolVer)
		{
			$("#ip_ver")[0].selectedIndex	= 1;
		}
		else
		{
			$("#ip_ver")[0].selectedIndex	= 0;
		}
		if (Ont.DisableTr069 == 1)
		{
			doClickTr069(false);
		}
	}
	else if (wan < WanConfig.WanNum)
	{
		var id = parseInt($("#wan_conlist").val());
		$("#del_con").attr("checked", false);
		$("#en_con").attr("checked", (0 != WanConfig.WanList[id].enable)?true:false);
		$("#con_mode")[0].selectedIndex	= (0 != WanConfig.WanList[id].bridge)?1:0;
		$("#nat").attr("checked", (0 != WanConfig.WanList[id].nat_enable)?true:false);
		$("#lan_dhcp").attr("checked", (0 != WanConfig.WanList[id].dhcp_enable)?true:false);
		$("#mtu").val(WanConfig.WanList[id].mtu);

		var wan_type_sel = "";
		if (WanConfig.WanList[id].service&Ont.TR069)
		{
			wan_type_sel = "TR069";
		}

		if (WanConfig.WanList[id].service&Ont.VOIP)
		{
			if("" != wan_type_sel)
			{
				wan_type_sel += "_";
			}
			wan_type_sel += "VOIP";
		}

		if (WanConfig.WanList[id].service&Ont.INTERNET)
		{
			if("" != wan_type_sel)
			{
				wan_type_sel += "_";
			}
			wan_type_sel += "INTERNET";
		}

		if (WanConfig.WanList[id].service&Ont.IPTV)
		{
			if("" != wan_type_sel)
			{
				wan_type_sel += "_";
			}
			wan_type_sel += "IPTV";
		}
		$("#wan_type").val(wan_type_sel);

		$("#vlan_enable").attr("checked", (0 != WanConfig.WanList[id].vlan_enable)?true:false);
		if (WanConfig.WanList[id].vlan_enable)
		{
			$("#vlan_pbit").val(WanConfig.WanList[id].vlan_pbit);
			$("#vlan_set").val(WanConfig.WanList[id].vlan_vid);
		}
		else
		{
			$("#vlan_pbit").val("");
			$("#vlan_set").val("");
		}

		if (WanConfig.WanList[id].service&Ont.IPTV || WanConfig.WanList[id].service&Ont.INTERNET)
		{
			$("#mvlan").attr("disabled", false);
			$("#mvlan").val(WanConfig.WanList[id].mc_vlan);
		}
		else
		{
			$("#mvlan").val(-1);
			$("#mvlan").attr("disabled", true);
		}

		$("#lan1").attr("checked", (WanConfig.WanList[id].port_map&Ont.LAN1)?true:false);
		$("#lan2").attr("checked", (WanConfig.WanList[id].port_map&Ont.LAN2)?true:false);
		$("#lan3").attr("checked", (WanConfig.WanList[id].port_map&Ont.LAN3)?true:false);
		$("#lan4").attr("checked", (WanConfig.WanList[id].port_map&Ont.LAN4)?true:false);
		$("#ssid1").attr("checked", (WanConfig.WanList[id].port_map&Ont.SSID1)?true:false);
		$("#ssid2").attr("checked", (WanConfig.WanList[id].port_map&Ont.SSID2)?true:false);
		$("#ssid3").attr("checked", (WanConfig.WanList[id].port_map&Ont.SSID3)?true:false);
		$("#ssid4").attr("checked", (WanConfig.WanList[id].port_map&Ont.SSID4)?true:false);
		$("#ssid1_5g").attr("checked", (WanConfig.WanList[id].port_map&Ont.SSID5)?true:false);
		$("#ssid2_5g").attr("checked", (WanConfig.WanList[id].port_map&Ont.SSID6)?true:false);
		$("#ssid3_5g").attr("checked", (WanConfig.WanList[id].port_map&Ont.SSID7)?true:false);
		$("#ssid4_5g").attr("checked", (WanConfig.WanList[id].port_map&Ont.SSID8)?true:false);

		if($("#con_mode")[0].selectedIndex==1) // bridge
		{
			$("#pppoe_user").val("");
			$("#pppoe_psw").val("");
			$("#pppoe_alivetime").val("");
			$("#static_ip").val("");
			$("#static_mask").val("");
			$("#static_gw").val("");
			$("#static_pridns").val("");
			$("#static_secdns").val("");
			$("#ip_ver").val(WanConfig.WanList[id].ip_ver);
			$("#opt60_mode")[0].selectedIndex	= 0;
		}
		else //route
		{
			var ipVer = WanConfig.WanList[id].ip_ver;
			var ipMode = WanConfig.WanList[id].ip_mode;
			//check the ipv4 or ipv6

			$("#ip_ver").val(ipVer);
			$("#ip_mode").val(ipMode);

			if(Ont.PPPOE == ipMode)
			{
				$("#pppoe_user").val(WanConfig.WanList[id].pppoe_user);
				$("#pppoe_psw").val(WanConfig.WanList[id].pppoe_pass);
				$("#pppoe_alivetime").val(WanConfig.WanList[id].pppoe_ktime);
				$("#static_ip").val("");
				$("#static_mask").val("");
				$("#static_gw").val("");
				$("#static_pridns").val("");
				$("#static_secdns").val("");
				$("#opt60_mode")[0].selectedIndex	= 0;
				$("#dial_mode").val(WanConfig.WanList[id].pppoe_dial_mode);
				$("#dial_time").val(WanConfig.WanList[id].pppoe_idle_time);
				pppoe_dial_mode_change();
			}
			else if((Ont.DHCP == ipMode)&&(1 != ipVer))
			{
				ipv6_mode_set(WanConfig.WanList[id].ipv6_mode);
			}
			else if (Ont.STATIC_IP == ipMode)
			{
				$("#static_ip").val(WanConfig.WanList[id].ipv4_ip);
				$("#static_mask").val(WanConfig.WanList[id].ipv4_mask);
				$("#static_gw").val(WanConfig.WanList[id].ipv4_gw);
				$("#static_pridns").val(WanConfig.WanList[id].ipv4_dns1);
				$("#static_secdns").val(WanConfig.WanList[id].ipv4_dns2);
				$("#static_ipv6addr").val(WanConfig.WanList[id].ipv6_addr);
				$("#static_ipv6addr_prefix").val(WanConfig.WanList[id].ipv6_prefix);
				$("#static_ipv6plen").val(WanConfig.WanList[id].ipv6_plen);
				$("#static_ipv6gw").val(WanConfig.WanList[id].ipv6_gw);
				$("#static_ipv6pridns").val(WanConfig.WanList[id].ipv6_dns1);
				$("#static_ipv6secdns").val(WanConfig.WanList[id].ipv6_dns2);
				$("#pppoe_user").val("");
				$("#pppoe_psw").val("");
				$("#pppoe_alivetime").val("");
				$("#opt60_mode")[0].selectedIndex	= 0;
			}
			else
			{
				$("#pppoe_user").val("");
				$("#pppoe_psw").val("");
				$("#pppoe_alivetime").val("");
				$("#static_ip").val("");
				$("#static_mask").val("");
				$("#static_gw").val("");
				$("#static_pridns").val("");
				$("#static_secdns").val("");
				$("#opt60_mode")[0].selectedIndex	= WanConfig.WanList[id].dhcp_mode;
			}
			
			if(WanConfig.WanList[id].service&Ont.INTERNET)
			{
				$("#router_bridge_mix").attr("disabled", false);	
				$("#router_bridge_mix").attr("checked", (0 != WanConfig.WanList[id].router_bridge_mix)?true:false);					
			}
			else
			{
				$("#router_bridge_mix").attr("disabled", true);
				$("#router_bridge_mix").attr("checked", false);				
			}
			
		}

		if(ipVer > 1) //dslite
		{
			$("#aftr_endpoint").val("");
			$("#aftr_endpoint").attr("disabled", true);
			$("#aftr_endpoint").hide();
			if(0 != WanConfig.WanList[id].dslite_enable)
			{
				$("#dslite_enable").attr("checked", true);
				$("#dslite_mode").val(WanConfig.WanList[id].dslite_aftr_mode);
				if(0 != WanConfig.WanList[id].dslite_aftr_mode)
				{
					$("#aftr_endpoint").show();
					$("#aftr_endpoint").attr("disabled", false);
					$("#aftr_endpoint").val(WanConfig.WanList[id].dslite_aftr_addr);
				}
			}
			else
			{
				$("#aftr_endpoint").attr("disabled", true);
				$("#aftr_endpoint").hide();
			}
		}

		if(ipVer > 1 &&(Ont.DHCP == ipMode || Ont.PPPOE == ipMode)) //(ipv6 || v6+v4) && (ppoe||dhcp)
		{
			ipv6_mode_set(WanConfig.WanList[id].ipv6_mode);
			$("#dhcpv6_ver").val(WanConfig.WanList[id].dhcpv6_ver);

		}
	}
	if (false == $("#vlan_enable").prop("checked"))
	{
		$("#vlan_pbit").val(0);
		$("#vlan_set").val("");
		$("#vlan_pbit").attr("disabled", true);
		$("#vlan_set").attr("disabled", true);
	}
	else
	{
		$("#vlan_pbit").attr("disabled", false);
		$("#vlan_set").attr("disabled", false);
	}
	if (Ont.DisableTr069 == 1 && wan != WanConfig.WanNum)
	{
		if ($("#wan_type").val().indexOf("TR069") != -1)
			doClickTr069(true);
		else
			doClickTr069(false);
	}
	else
	{
		doClickTr069(false);
	}
	check_nat_disable();
}

function vlan_enable_change()
{
	if (false == $("#vlan_enable").is(":checked"))
	{
		$("#vlan_pbit").val(0);
		$("#vlan_pbit").attr("disabled", true);
		$("#vlan_set").val("");
		$("#vlan_set").attr("disabled", true);
	}
	else
	{
		$("#vlan_pbit").attr("disabled", false);
		$("#vlan_set").attr("disabled", false);
	}
}

function wan_con_set()
{
	if (1 == Ont.DisableTr069 && -1 != $("#wan_type").val().indexOf("TR069"))
	{
		$("#del_con").attr("disabled", true);
	}
	else
	{
		$("#del_con").attr("disabled", false);
	}
}

function con_mode_change()
{
	var wan = $("#wan_conlist").val();

	if ($("#con_mode")[0].selectedIndex == 1)
	{
		$("#div_line_2").hide();
		$("#div_ip_mode").hide();
		$("#divMtu").hide();
		$("#div_wan_pppoe").hide();
		$("#div_wan_dhcp").hide();
		$("#div_wan_static").hide();

		if(3 == Ont.ProtocolVer)
		{
			$("#div_ip_ver").show();
		}

		$("#div_wan_static_ipv6").hide();
		$("#div_ipv6_dhcp").hide();
		$("#div_dslite").hide();

		if(1 == Ont.ProtocolVer)
		{
			$("#ip_ver").val(1);
		}
		else if(2 == Ont.ProtocolVer)
		{
			$("#ip_ver").val(2);
		}

		$("#ip_mode")[0].selectedIndex = 1;
		$("#router_bridge_mix").attr("disabled", true);
	}
	else
	{
		$("#div_ip_mode").show();
		$("#divMtu").show();
		if(1 == Ont.ProtocolVer)
		{
			$("#div_ip_ver").hide();
			$("#div_wan_static_ipv6").hide();
			$("#div_ipv6_dhcp").hide();
			$("#div_dslite").hide();
		}
		$("#div_line_2").show();
		$("#div_ip_mode").show();
	
		if (WanConfig.WanList[wan].valid && ($("#con_mode").val() == WanConfig.WanList[wan].bridge))
		{
			wan_ip_set();
		}
		else
		{
			ip_mode_set();
		}
		if(-1 != $("#wan_type").val().indexOf("INTERNET"))
		{
			$("#router_bridge_mix").attr("disabled", false);			
		}
		else
		{
			$("#router_bridge_mix").attr("disabled", true);					
		}
	}

	service_change();
	RecalcHelpHeight();
}

function wan_ip_set()
{
	var ip_mode = $("#ip_mode")[0].selectedIndex;
	var ipver = $("#ip_ver")[0].selectedIndex;

	$("#div_ip_ver").hide();
	$("#div_ipv6_dhcp").hide();
	$("#div_wan_static_ipv6").hide();
	$("#div_wan_pppoe").hide();
	$("#div_wan_static").hide();
	$("#div_dslite").hide();

	if(Ont.ProtocolVer > 1)
	{
		wan_ipv6_set();
		RecalcHelpHeight();
		return;
	}

	if(ip_mode == 1)
	{
		$("#div_wan_pppoe").show();
		$("#div_wan_dhcp").hide();
		$("#div_wan_static").hide();
	}
	else if(ip_mode == 2)
	{
		$("#div_wan_static").show();
		$("#div_wan_pppoe").hide();
		$("#div_wan_dhcp").hide();
	}
	else
	{
		if (-1 != $("#wan_type").val().indexOf("VOIP"))
		{
			$("#div_wan_dhcp").show();
		}
		else
		{
			$("#div_wan_dhcp").hide();
		}
		$("#div_wan_static").hide();
		$("#div_wan_pppoe").hide();
	}

	RecalcHelpHeight();
}

function pppoe_dial_mode_change()
{
	if(1 == parseInt($("#dial_mode").val()))
	{
		$("#pppoe_demand").show();
		$("#dial_time").val(600);
		$("#pppoe_manual").hide();
	}
	else if(2 == parseInt($("#dial_mode").val()))
	{
		$("#pppoe_demand").hide();
		$("#dial_time").val(0);
		$("#pppoe_manual").show();
	}
	else
	{
		$("#pppoe_demand").hide();
		$("#dial_time").val(0);
		$("#pppoe_manual").hide();
	}
	
	return;
}

function dial_pppoe()
{
	var wan_index = parseInt($("#wan_conlist").val());
	if ($("#en_con").prop("checked") == false
		|| WanConfig.WanList[wan_index].enable != 1
		|| WanConfig.WanList[wan_index].ip_mode != 2
		|| WanConfig.WanList[wan_index].pppoe_dial_mode != 2)
	{
		alert("请先启用并保存WAN配置后再尝试连接！");
		return false;
	}
	$("#dialAction").val("dial_pppoe");
	$("#XForm").submit();
}

function down_pppoe()
{
	var wan_index = parseInt($("#wan_conlist").val());
	if ($("#en_con").prop("checked") == false
		|| WanConfig.WanList[wan_index].enable != 1
		|| WanConfig.WanList[wan_index].ip_mode != 2
		|| WanConfig.WanList[wan_index].pppoe_dial_mode != 2)
	{
		alert("请先启用并保存WAN配置后再尝试断开！");
		return false;
	}
	$("#dialAction").val("down_pppoe");
	$("#XForm").submit();
}

function ip_mode_set()
{
	if(1 == $("#con_mode")[0].selectedIndex)
	{
		return;
	}

	var ip_mode = $("#ip_mode")[0].selectedIndex;
	var ipver   = $("#ip_ver")[0].selectedIndex;
	var wan     = parseInt($("#wan_conlist").val());

	$("#div_ip_ver").hide();
	$("#div_ipv6_dhcp").hide();
	$("#div_wan_static_ipv6").hide();
	$("#div_wan_pppoe").hide();
	$("#div_wan_static").hide();
	$("#div_dslite").hide();

	if(Ont.ProtocolVer > 1)
	{
		wan_ipv6_set();
		RecalcHelpHeight();
		return;
	}

	var mtu = 1500;
	if(ip_mode == 1)
	{
		$("#div_wan_pppoe").show();
		$("#div_wan_dhcp").hide();
		$("#div_wan_static").hide();
		mtu = 1492;
	}
	else if(ip_mode == 2)
	{
		$("#div_wan_static").show();
		$("#div_wan_pppoe").hide();
		$("#div_wan_dhcp").hide();
	}
	else
	{
		if (-1 != $("#wan_type").val().indexOf("VOIP"))
		{
			$("#div_wan_dhcp").show();
		}
		else
		{
			$("#div_wan_dhcp").hide();
		}
		$("#div_wan_static").hide();
		$("#div_wan_pppoe").hide();
	}

	if (WanConfig.WanList[wan].valid && $("#ip_mode").val() == WanConfig.WanList[wan].ip_mode)
	{
		mtu = WanConfig.WanList[wan].mtu;
	}
	$("#mtu").val(mtu);

	RecalcHelpHeight();
}

function wan_ipv6_set()
{
	var ip_mode	= $("#ip_mode")[0].selectedIndex;
	var ipver	= $("#ip_ver")[0].selectedIndex;
	var wan     	= parseInt($("#wan_conlist").val());

	if(3 == Ont.ProtocolVer)
	{
		$("#div_ip_ver").show();
	}

	$("#div_line_2").show();

	$("#div_wan_static").hide();
	$("#div_wan_pppoe").hide();
	$("#div_ipv6_dhcp").hide();
	$("#div_wan_static_ipv6").hide();
	$("#div_dslite").hide();
	$("#div_wan_dhcp").hide();

	var mtu = 1500;
	if (ipver == 0)
	{
		if(ip_mode == 0)
		{
			if (-1 != $("#wan_type").val().indexOf("VOIP"))
			{
				$("div_wan_dhcp").show();
			}
		}
		else if(ip_mode == 1)
		{
			$("#div_wan_pppoe").show();
			mtu = 1492;
		}
		else if(ip_mode == 2)
		{
			$("#div_wan_static").show();
		}

		$("#dslite_enable").attr("checked", false);
	}

	if(ipver == 1)
	{
		if(ip_mode == 0)
		{
			$("#div_ipv6_dhcp").show();
			$("#div_dslite").show();
		}

		if(ip_mode == 1)
		{
			$("#div_wan_pppoe").show();
			$("#div_ipv6_dhcp").show();
			$("#div_dslite").show();
			mtu = 1492;
		}

		if(ip_mode == 2)
		{
			$("#div_wan_static").hide();
			$("#div_wan_static_ipv6").show();
			$("#div_dslite").show();
		}
	}

	if(ipver==2)
	{
		if(ip_mode == 0)
		{
			$("#div_ipv6_dhcp").show();
			$("#div_dslite").hide();
		}

		if(ip_mode == 1)
		{
			$("#div_ipv6_dhcp").show();
			$("#div_dslite").hide();
			$("#div_wan_pppoe").show();
			mtu = 1492;
		}
		if(ip_mode == 2){
			$("#div_wan_static_ipv6").show();
			$("#div_wan_static").show();
			$("#div_dslite").hide();
		}
		$("#dslite_enable").attr("checked", false);
	}
	
	if (WanConfig.WanList[wan].valid && $("#ip_mode").val() == WanConfig.WanList[wan].ip_mode)
	{
		mtu = WanConfig.WanList[wan].mtu;	
	}
	$("#mtu").val(mtu);
	RecalcHelpHeight();
}

function wan_check_value()
{
	var ret = 0;
	if (
		($("#voip").prop("checked") == false) &&
		($("#tr069").prop("checked") == false) &&
		($("#internet").prop("checked") == false) &&
		($("#other").prop("checked") == false)
	)
	{
		alert("WAN连接必须至少绑定一种服务类型！");
		return false;
	}

	if (true == $("#vlan_enable").prop("checked"))
	{
		if(($("#vlan_pbit").val() == "") || ($("#vlan_set").val() == ""))
		{
			alert("VLAN ID和VLAN优先级不能为空！");
			return false;
		}

		if(parseInt($("#vlan_pbit").val()) < 0 || parseInt($("#vlan_pbit").val()) > 7)
		{
			alert("请设置正确的VLAN优先级，范围0到7！");
			return false;
		}

		if(parseInt($("#vlan_set").val()) < 0 || parseInt($("#vlan_set").val()) > 4095)
		{
			alert("请设置正确的VLAN ID，范围0到4095！");
			return false;
		}
	}

	if ($("#nat").prop("checked") == true)
	{
		if ($("#con_mode")[0].selectedIndex == 1)
		{
			alert("桥接类型的WAN连接不能启用NAT!");
			return false;
		}

		if (
			(-1 == $("#wan_type").val().indexOf("INTERNET")) &&
			(-1 == $("#wan_type").val().indexOf("IPTV")) &&
			(-1 == $("#wan_type").val().indexOf("OTHER"))
		)
		{
			alert("TR069或VOIP的WAN连接不能启用NAT!");
			return false;
		}
	}
	
	if ($("#router_bridge_mix").prop("checked") == true)
	{
		if ($("#con_mode")[0].selectedIndex == 1)
		{
			alert("桥接类型的WAN连接不能启用路由混合模式!");
			return false;
		}
		if (-1 == $("#wan_type").val().indexOf("INTERNET"))
		{
			alert("路由桥接混合模式不能在非INTERNET的WAN连接中启用!");
			return false;
		}
	}
	
	var ip_ver = $("#ip_ver")[0].selectedIndex + 1;
	$.each(WanConfig.WanList, function(wi, wv){
		if (0 == wv.valid || wi == $("#wan_conlist").val())
		{
			return true;
		}
		if (0 == (wv.ip_ver & ip_ver))
		{
			return true;
		}

		var port_map = parseInt(wv.port_map);

		if ($("#lan1").get(0).checked && (port_map&0x1) != 0)
		{
			alert("LAN1已经绑定在其它WAN连接上，不能再绑定到该WAN连接上！");
			ret++;
			return false;
		}
		if ($("#lan2").get(0).checked && (port_map&0x2) != 0)
		{
			alert("LAN2已经绑定在其它WAN连接上，不能再绑定到该WAN连接上！");
			ret++;
			return false;
		}
		if ($("#lan3").get(0).checked && (port_map&0x4) != 0)
		{
			alert("LAN3已经绑定在其它WAN连接上，不能再绑定到该WAN连接上！");
			ret++;
			return false;
		}
		if ($("#lan4").get(0).checked && (port_map&0x8) != 0)
		{
			alert("LAN4已经绑定在其它WAN连接上，不能再绑定到该WAN连接上！");
			ret++;
			return false;
		}
		if ($("#ssid1").get(0).checked && (port_map&0x100) != 0)
		{
			alert("SSID1已经绑定在其它WAN连接上，不能再绑定到该WAN连接上！");
			ret++;
			return false;
		}
		if ($("#ssid2").get(0).checked && (port_map&0x200) != 0)
		{
			alert("SSID2已经绑定在其它WAN连接上，不能再绑定到该WAN连接上！");
			ret++;
			return false;
		}
		if ($("#ssid3").get(0).checked && (port_map&0x400) != 0)
		{
			alert("SSID3已经绑定在其它WAN连接上，不能再绑定到该WAN连接上！");
			ret++;
			return false;
		}
		if ($("#ssid4").get(0).checked && (port_map&0x800) != 0)
		{
			alert("SSID4已经绑定在其它WAN连接上，不能再绑定到该WAN连接上！");
			ret++;
			return false;
		}
		if ($("#ssid1_5g").get(0).checked && (port_map&0x1000) != 0)
		{
			alert("SSID5已经绑定在其它WAN连接上，不能再绑定到该WAN连接上！");
			ret++;
			return false;
		}
		if ($("#ssid2_5g").get(0).checked && (port_map&0x2000) != 0)
		{
			alert("SSID6已经绑定在其它WAN连接上，不能再绑定到该WAN连接上！");
			ret++;
			return false;
		}
		if ($("#ssid3_5g").get(0).checked && (port_map&0x4000) != 0)
		{
			alert("SSID7已经绑定在其它WAN连接上，不能再绑定到该WAN连接上！");
			ret++;
			return false;
		}
		if ($("#ssid4_5g").get(0).checked && (port_map&0x8000) != 0)
		{
			alert("SSID8已经绑定在其它WAN连接上，不能再绑定到该WAN连接上！");
			ret++;
			return false;
		}
	});
	if(ret > 0)
		return false;
	
	if(1 == $("#con_mode")[0].selectedIndex)
	{
		return true;
	}

	var ipmod_index=$("#ip_mode")[0].selectedIndex;
	var ipver_index=$("#ip_ver")[0].selectedIndex;
	if (1 == ipmod_index)
	{
		if($("#pppoe_user").val() == "" || $("#pppoe_psw").val() == "")
		{
			alert("PPPoE用户名和密码不能为空！");
			return false;
		}

		if((false==isValidPppoeName($("#pppoe_user").val()))||(false==isValidPppoeName($("#pppoe_psw").val())))
		{
			alert("请设置正确的PPPoE用户名和密码！");
			return false;
		}

		if(parseInt($("#pppoe_alivetime").val()) < 5 || parseInt($("#pppoe_alivetime").val()) > 300)
		{
			alert("请设置正确的PPPoE keepalive time(5~300秒)！");
			return false;
		}

		if(parseInt($("#mtu").val()) < 512 || parseInt($("#mtu").val()) > 1492)
		{
			alert("请设置正确MTU值！(512-1492)");
			return false;
		}

		if(1 == parseInt($("#dial_mode").val()))
		{
			if(parseInt($("#dial_time").val()) < 180)
			{
				alert("请输入正确的按需拨号时间!（大于180秒）");
				return false;
			}
		}
	}
	else
	{
		if(parseInt($("#mtu").val()) < 512 || parseInt($("#mtu").val()) > 1500)
		{
			alert("请设置正确MTU值！(512-1500)");
			return false;
		}
	}

	if(2 == ipmod_index && $("#div_wan_static").css("display") !='none' && ipver_index != 1)
	{
		if(false==isValidIpv4Address($("#static_ip").val()))
		{
			alert("请设置正确的静态IP地址！");
			return false;
		}
		if(false==isValidSubnetMask($("#static_mask").val()))
		{
			alert("请设置正确的子网掩码！");
			return false;
		}
		if(false==isValidIpv4Address($("#static_gw").val()))
		{
			alert("请设置正确的网关地址！");
			return false;
		}
		if(false==isSameSubNet($("#static_ip").val(),$("#static_mask").val(),$("#static_gw").val(),$("#static_mask").val()))
		{
			alert("网关地址和IP地址不在同一子网！");
			return false;
		}
		if($("#static_pridns").val().length>0 && $("#static_pridns").val() != "0.0.0.0")
		{
			if(false==isValidIpv4Address($("#static_pridns").val()))
			{
				alert("请设置正确的首选DNS！");
				return false;
			}
		}
		if($("#static_secdns").val().length>0 && $("#static_secdns").val() != "0.0.0.0")
		{
			if(false==isValidIpv4Address($("#static_secdns").val()))
			{
				alert("备用DNS设置错误！");
				return false;
			}
			if($("#static_pridns").val() == $("#static_secdns").val())
			{
				alert("备用DNS和首选DNS设置不能相同！");
				return false;
			}
		}

	}

	if(ipmod_index==2 && $("#div_wan_static_ipv6").css("display") !='none' && ipver_index != 0) //check static ipv6
	{
		if(false==isValidIpAddress6($("#static_ipv6addr").val()))
		{
			alert("请设置正确IPV6地址前缀！");
			return false;
		}
		if(false==isValidIpAddress6($("#static_ipv6gw").val()))
		{
			alert("请设置正确的IPV6网关地址！");
			return false;
		}
		if($("#static_ipv6pridns").val().length>0)
		{
			if(false==isValidIpAddress6($("#static_ipv6pridns").val()))
			{
				alert("请设置正确的IPV6首选DNS！");
				return false;
			}
		}
		if($("#static_ipv6secdns").val().length>0)
		{
			if(false==isValidIpAddress6($("#static_ipv6secdns").val()))
			{
				alert("IPV6备用DNS设置错误！");
				return false;
			}
			if($("#static_ipv6pridns").val()==$("#static_ipv6secdns").val())
			{
				alert("IPV6备用DNS和IPV6首选DNS设置不能相同！");
				return false;
			}
		}
		var tmp=$("#static_ipv6addr_prefix").val().split("/");
		$("#static_ipv6addr_prefix").val(tmp[0]);
		if(undefined == tmp[1] || "" == tmp[1])
		{
			tmp[1] = 64;
		}
		$("#static_ipv6plen").val(tmp[1]);

	}

	if(ipver_index > 0 && 1 != Ont.ProtocolVer) //ipv6 or both
	{
		if(true==$("#dslite_enable").prop("checked") && parseInt($("#dslite_mode").val()))
		{
			if(false == isValidIpAddress6($("#aftr_endpoint").val()))
			{
				if(false == is_domain($("#aftr_endpoint").val()))
				{
					alert("AFTR终端设置错误！");
					return false;
				}
			}
		}
	}
	return true;
}

function ip_mode_change()
{
	ip_mode_set();
}

function check_lan_dhcp()
{
	var servidce_internet = (-1 != $("#wan_type").val().indexOf("INTERNET"))?true:false;
	var service_other = (-1 != $("#wan_type").val().indexOf("IPTV") || -1 != $("#wan_type").val().indexOf("OTHER"))?true:false;

	if ($("#con_mode")[0].selectedIndex == 1 && true == service_other)// other bridge
	{
		$("#lan_dhcp").attr("disabled", true);
		$("#lan_dhcp").attr("checked", false);
	}
	else
	{
		if ($("#wan_conlist")[0].selectedIndex >= WanConfig.WanNum)
		{
			$("#lan_dhcp").attr("checked", true);
		}
	}

}

function service_change()
{
	var wan = $("#wan_conlist").val();
	if (-1 != $("#wan_type").val().indexOf("IPTV") && $("#con_mode")[0].selectedIndex == 0 && $("#ip_mode")[0].selectedIndex == 0)
	{
		$("div_wan_dhcp").show();
	}
	else
	{
		$("div_wan_dhcp").hide();
	}
	check_lan_dhcp();

	$("#lan1").attr("disabled", false);
	$("#lan2").attr("disabled", false);
	$("#lan3").attr("disabled", false);
	$("#lan4").attr("disabled", false);
	$("#ssid1").attr("disabled", false);
	$("#ssid2").attr("disabled", false);
	$("#ssid3").attr("disabled", false);
	$("#ssid4").attr("disabled", false);
	$("#ssid1_5g").attr("disabled", false);
	$("#ssid2_5g").attr("disabled", false);
	$("#ssid3_5g").attr("disabled", false);
	$("#ssid4_5g").attr("disabled", false);

	if ((-1 != $("#wan_type").val().indexOf("IPTV")) || -1 != $("#wan_type").val().indexOf("OTHER") || (-1 != $("#wan_type").val().indexOf("INTERNET")))
	{
	}
	else
	{
		$("#lan1").attr("disabled", true);
		$("#lan1").attr("checked", false);
		$("#lan2").attr("disabled", true);
		$("#lan2").attr("checked", false);
		$("#lan3").attr("disabled", true);
		$("#lan3").attr("checked", false);
		$("#lan4").attr("disabled", true);
		$("#lan4").attr("checked", false);
		$("#ssid1").attr("disabled", true);
		$("#ssid1").attr("checked", false);
		$("#ssid2").attr("disabled", true);
		$("#ssid2").attr("checked", false);
		$("#ssid3").attr("disabled", true);
		$("#ssid3").attr("checked", false);
		$("#ssid4").attr("disabled", true);
		$("#ssid4").attr("checked", false);
		$("#ssid1_5g").attr("disabled", true);
		$("#ssid1_5g").attr("checked", false);
		$("#ssid2_5g").attr("disabled", true);
		$("#ssid2_5g").attr("checked", false);
		$("#ssid3_5g").attr("disabled", true);
		$("#ssid3_5g").attr("checked", false);
		$("#ssid4_5g").attr("disabled", true);
		$("#ssid4_5g").attr("checked", false);
	}

	if(-1 != $("#wan_type").val().indexOf("INTERNET") || -1 != $("#wan_type").val().indexOf("IPTV") || -1 != $("#wan_type").val().indexOf("OTHER"))
	{
		$("#mvlan").attr("disabled", false);
	}
	else
	{
		$("#mvlan").val(-1);
		$("#mvlan").attr("disabled", true);
	}
	
	if((-1 != $("#wan_type").val().indexOf("INTERNET")) && ($("#con_mode")[0].selectedIndex == 0))
	{
		$("#router_bridge_mix").attr("disabled", false);				
	}
	else
	{
		$("#router_bridge_mix").attr("disabled", true);		
	}
	
	RecalcHelpHeight();
}

function wan_check_service()
{
	var con_mode = $("#con_mode").val();
	var lan1 = ($("#lan1").prop("checked") == true) ? true:false;
	var lan2 = ($("#lan2").prop("checked") == true) ? true:false;
	var lan3 = ($("#lan3").prop("checked") == true) ? true:false;
	var lan4 = ($("#lan4").prop("checked") == true) ? true:false;
	var ssid1 = ($("#ssid1").prop("checked") == true) ? true:false;
	var ssid2 = ($("#ssid2").prop("checked") == true) ? true:false;
	var ssid3 = ($("#ssid3").prop("checked") == true) ? true:false;
	var ssid4 = ($("#ssid4").prop("checked") == true) ? true:false;
	var ssid1_5g = ($("#ssid1_5g").prop("checked") == true) ? true:false;
	var ssid2_5g = ($("#ssid2_5g").prop("checked") == true) ? true:false;
	var ssid3_5g = ($("#ssid3_5g").prop("checked") == true) ? true:false;
	var ssid4_5g = ($("#ssid4_5g").prop("checked") == true) ? true:false;
	var tr069 = (-1 != $("#wan_type").val().indexOf("TR069"))?true:false;
	var voip = (-1 != $("#wan_type").val().indexOf("VOIP"))?true:false;
	var internet = (-1 != $("#wan_type").val().indexOf("INTERNET"))?true:false;
	var other = (-1 != $("#wan_type").val().indexOf("IPTV") || -1 != $("#wan_type").val().indexOf("OTHER"))?true:false;
	var bridge_route_mix = ($("#router_bridge_mix").prop("checked") == true) ? true:false;
	
	if (true == con_mode)
	{
		// bridge mode
		if ((true == tr069) || (true == voip))
		{
			alert("TR069/VOIP类型的WAN连接不能是桥接模式！");
			return false;
		}
	}

	if ((false == internet) && (false == other))
	{
		if ((true == lan1) ||
		    (true == lan2) ||
		    (true == lan3) ||
		    (true == lan4) ||
		    (true == ssid1) ||
		    (true == ssid2) ||
		    (true == ssid3) ||
		    (true == ssid4) ||
		    (true == ssid1_5g) ||
		    (true == ssid2_5g) ||
		    (true == ssid3_5g) ||
		    (true == ssid4_5g))
		{
			alert("只有INTERNET或OTHER类型的WAN连接可以绑定LAN端口");
			return false;
		}
	}
	if((true == internet) && (true == bridge_route_mix))
	{
		if ((false == lan1) &&
		(false == lan2) &&
		(false == lan3) &&
		(false == lan4) &&
		(false == ssid1) &&
		(false == ssid2) &&
		(false == ssid3) &&
		(false == ssid4) &&
		(false == ssid1_5g) &&
		(false == ssid2_5g) &&
		(false == ssid3_5g) &&
		(false == ssid4_5g))	
		{
			alert("路由桥接混合模式需要至少绑定一个口！");
			return false;
		}
	}

	return true;
}

function CheckTr069Config()
{
	var wan_action = parseInt($("#hAction").val());
	var wan_index = parseInt($("#wan_conlist").val());

	if (1 == wan_action)
	{
		if (-1 != $("#wan_type").val().indexOf("TR069"))
		{
			alert("不允许创建TR069的WAN连接!");
			return false;
		}
	}
	else if (2 == wan_action)
	{
		if ((WanConfig.WanList[wan_index].service&0x2) != 0)
		{
			alert("不允许删除TR069的WAN连接!");
			return false;
		}
	}
	else if (3 == wan_action)
	{
		if ((WanConfig.WanList[wan_index].service&0x2) != 0)
		{
			alert("不允许修改TR069的WAN连接!");
			return false;
		}
	}

	return true;
}


function wan_web_submit()
{
	if($("#wantype").val() != WanConfig.WanType)
	{
		if(false == confirm("您真的要将WAN类型切换到" + $("#wantype").val() + "？ 确认，系统将会重启。"))
			return ;
	}
	
	if($("#del_con").prop("checked") == true)
	{
		// delete wan
		$("#hAction").val("2");
	}
	else if($("#wan_conlist")[0].selectedIndex == WanConfig.WanNum)
	{
		// create new wan
		$("#hAction").val("1");
	}
	else
	{
		// update wan
		$("#hAction").val("3");
	}

	if (0 != Ont.DisableTr069 && false == CheckTr069Config())
	{
		return;
	}

	var wan_action = parseInt($("#hAction").val());
	if((1 == wan_action)||(3 == wan_action))
	{
		if (false == wan_check_service())
		{
			return;
		}
			
		if(false == wan_check_value())
		{
			return;
		}
	}

	var service = $("wan_type").val();
	if (
		$("#nat").prop("checked") == false &&
		$("#con_mode")[0].selectedIndex == 0 &&
		((-1 != service.indexOf("INTERNET")) ||
		 (-1 != service.indexOf("IPTV")) ||
		 (-1 != service.indexOf("OTHER"))
		)
	)
	{
		if (!confirm("建议路由模式INTERNET、IPTV或OTHER类型WAN连接启用NAT功能, 确定要关闭NAT使用全路由模式?"))
		{
			return false;
		}
	}

	$("#XForm").submit();
}
