<% cmccEnterpriseHtmlCommonHead();%>
<link href="style/default.css" type="text/css" rel="stylesheet" />
<style type="text/css">

</style>

<script type="text/javascript">

<% initProductInfo(); %>
var vlan_mapping_interface = <% checkWrite("vlan_mapping_interface"); %>;
var vlan_mapping_index = <% checkWrite("vlan_mapping_interface_idx"); %>;
<% initVlanRange(); %>

<% checkWrite("interface_grouping_tabel"); %>

function getObj(id)
{
	return(document.getElementById(id));
}

function setValue(id,value)
{
	document.getElementById(id).value=value;
}

function getValue(id)
{
	return(document.getElementById(id).value);
}

function convertDisplay(name,col)
{
	//var port=["LAN1","LAN2","LAN3","LAN4","SSID1","SSID2","SSID3","SSID4","SSID5"];
	var port = vlan_mapping_interface;
	var port_index = vlan_mapping_index;
	var mode=["<% multilang(LANG_BINDING_PORT);%>","<% multilang(LANG_VLAN_BINDING);%>"];
	if(col==0){
		return port[name]||"";
	}
	else if(col==1){
		return mode[name]||mode[0];
	}
	else if(col==2){
		return getValue('VLAN'+port_index[name]);
	}
	return value;
}

function ModifyInstance(obj, index)
{
  var port_index = vlan_mapping_index;
  var mode_id="Mode"+port_index[index];
  
  if(getValue(mode_id) == 1)
  {
	document.getElementById("Frm_Mode").options[0].selected=true;
	document.getElementById("BindVlanRow").style.display = '';   
  }
  else
  {
    document.getElementById("Frm_Mode").options[1].selected=true;	
	document.getElementById("BindVlanRow").style.display = 'none'; 
  }

  document.getElementById("if_index").value = port_index[index];
  document.getElementById("PortId").innerHTML=obj.cells[0].innerText;
  if(obj.cells[2].innerText != "--")
  {
  	document.getElementById("VlanPair").value=obj.cells[2].innerText;
  }
  else
  {
    document.getElementById("VlanPair").value='';
  }
  document.getElementById("TableUrlInfo").style.display = "block";
}

function addline(index)
{
	var newline;
	var port_index = vlan_mapping_index;
	var mode= getValue('Mode'+port_index[index]);
	
	newline = document.getElementById('Special_Table').insertRow(-1);
	newline.nowrap = true;
	newline.vAlign = "top";
	newline.align = "center";
	newline.onclick = function() {ModifyInstance(this, index)};
	newline.setAttribute("class","white");
	newline.setAttribute("className","white");
	newline.insertCell(-1).innerHTML = convertDisplay(index, 0);
	newline.insertCell(-1).innerHTML = convertDisplay(mode,1);
	newline.insertCell(-1).innerHTML = (mode==0)?"--":convertDisplay(index, 2);
}

function showTable()
{
	//var num = getValue('if_instnum');
	var num = vlan_mapping_interface.length;
	var port = vlan_mapping_interface;

	if (num!=0) {
		for (var i=0; i<num; i++) {
			if (port[i] == "LAN_DISABLE") {
				continue;
			}
			if (port[i] == "SSID_DISABLE") {
				continue;
			}
			addline(i);
		}
	}
	else {
	}
}

function ModifyInstance_iso(obj, index)
{
	
}

function handleClick(obj)
{
	var index = obj.value;
	if(obj.checked){
		setValue("Isolation"+index, 1);
	}
	else{
		setValue("Isolation"+index, 0);
	}
}

function convertDisplay_iso(name,col)
{
	//var port=["LAN1","LAN2","LAN3","LAN4","SSID1","SSID2","SSID3","SSID4","SSID5"];
	var port = vlan_mapping_interface;
	var port_index = vlan_mapping_index;
	var mode= getValue('Isolation'+port_index[name]);
	
	if(col==0){
		return port[name]||"";
	}
	else if(col==1){
		if(mode == 1){
			return "<input type=checkbox name=ISO_"+port_index[name]+" value="+port_index[name]+" onclick='handleClick(this);' checked>";
		}
		else{
			return "<input type=checkbox name=ISO_"+port_index[name]+" value="+port_index[name]+" onclick='handleClick(this);'>";
		}
	}
	return value;
}

function addline_iso(index)
{
	var newline;
	
	newline = document.getElementById('x_iso_port').insertRow(-1);
	newline.nowrap = true;
	newline.vAlign = "top";
	newline.align = "center";
	newline.onclick = function() {ModifyInstance_iso(this, index)};
	//newline.setAttribute("class","white");
	//newline.setAttribute("className","white");
	newline.insertCell(-1).innerHTML = convertDisplay_iso(index, 0);
	newline.insertCell(-1).innerHTML = convertDisplay_iso(index, 1);
}

function showTable_iso()
{
	//var num = getValue('if_instnum');
	var num = vlan_mapping_interface.length;
	var port = vlan_mapping_interface;

	if (num!=0) {
		for (var i=0; i<num; i++) {
			if (port[i] == "LAN_DISABLE") {
				continue;
			}
			if (port[i] == "SSID_DISABLE") {
				continue;
			}
			addline_iso(i);
		}
	}
	else {
	}
}

function portIsolation_submit()
{
	document.forms[1].submit();
}

function convertDisplay_vlan(name,col)
{
	//var port=["LAN1","LAN2","LAN3","LAN4","SSID1","SSID2","SSID3","SSID4","SSID5"];
	var port = vlan_mapping_interface;
	var port_index = vlan_mapping_index;
	var mode=["TRUNK mode","Normal mode","VLAN mode"];
	if(col==0){
		return port[name]||"";
	}
	else if(col==1){
		return mode[name]||mode[0];
	}
	else if(col==2){
		return getValue('VLAN_VLAN'+port_index[name]);
	}
	return value;
}

function ModifyInstance_vlan(obj, index)
{
  var port_index = vlan_mapping_index;
  var mode_id="VLAN_Mode"+port_index[index];
  
  if(getValue(mode_id) == 1)
  {
	document.getElementById("VLAN_Mode").options[0].selected=true;
	document.getElementById("VLAN_BindVlanRow").style.display = '';   
  }
  else
  {
    document.getElementById("VLAN_Mode").options[1].selected=true;	
	document.getElementById("VLAN_BindVlanRow").style.display = 'none'; 
  }

  document.getElementById("VLAN_if_index").value = port_index[index];
  document.getElementById("VLAN_PortId").innerHTML=obj.cells[0].innerText;
  document.getElementById("VLAN_Mode").value = getValue(mode_id);
  
  if(obj.cells[2].innerText != "--")
  {
  	document.getElementById("VLAN_VlanPair").value=obj.cells[2].innerText;
  }
  else
  {
    document.getElementById("VLAN_VlanPair").value='';
  }
  document.getElementById("VLAN_TableUrlInfo").style.display = "block";
  OnChooseDeviceType_vlan();
}

function addline_vlan(index)
{
	var newline;
	var port_index = vlan_mapping_index;
	var mode= getValue('VLAN_Mode'+port_index[index]);
	
	newline = document.getElementById('VLAN_Special_Table').insertRow(-1);
	newline.nowrap = true;
	newline.vAlign = "top";
	newline.align = "center";
	newline.onclick = function() {ModifyInstance_vlan(this, index)};
	newline.setAttribute("class","white");
	newline.setAttribute("className","white");
	newline.insertCell(-1).innerHTML = convertDisplay_vlan(index, 0);
	newline.insertCell(-1).innerHTML = convertDisplay_vlan(mode,1);
	newline.insertCell(-1).innerHTML = (mode==0)?"--":convertDisplay_vlan(index, 2);
}

function showTable_vlan()
{
	//var num = getValue('if_instnum');
	document.getElementById('VLAN_PortId').disabled = false; 
	document.getElementById('VLAN_Mode').disabled = false; 
	document.getElementById('VLAN_VlanPair').disabled = false; 
	document.getElementById('VLAN_save').disabled = false; 
	document.getElementById('VLAN_cancel').disabled = false; 
	
	var num = vlan_mapping_interface.length;
	var port = vlan_mapping_interface;

	if (num!=0) {
		for (var i=0; i<num; i++) {
			if (port[i] == "LAN_DISABLE") {
				continue;
			}
			if (port[i] == "SSID_DISABLE") {
				continue;
			}
			addline_vlan(i);
		}
	}
	else {
	}
}


function viewGroup()
{
	with (document.forms[3])
	{
		var i = 0, j = 0, find = 0;
		var group_key = group_select.value;

		for (i = (group_member.options.length - 1); i >= 0; i--)
		{
			group_member.options.remove(i);
		}

		for (i = (group_available.options.length - 1); i >= 0; i--)
		{
			group_available.options.remove(i);
		}

		for (i = 0; i < InterfaceGroupingKey.length; i++)
		{
			if (InterfaceGroupingKey[i] == group_key)
			{
				group_enable.checked = (InterfaceGroupingEnable[i] == "1") ? true:false;
				group_name.value = InterfaceGroupingName[i];
				if (i == 0)
				{
					apply_div.style.display = "none";
				}
				else
				{
					apply_div.style.display = "";
				}

				for (j = 0; j < InterfaceList_Domain.length; j++)
				{
					if (InterfaceGroupingKey[i] == InterfaceList_Group[j])
					{
						group_member.options.add(new Option(InterfaceList_Name[j], InterfaceList_Name[j]));
					}
				}
				find = 1;
				break;
			}
		}

		if (find == 0)
		{
			group_enable.checked = true;
			group_name.value = "";
			apply_div.style.display = "";
		}

		for (j = 0; j < InterfaceList_Domain.length; j++)
		{
			if (InterfaceList_Group[j] == 0)
			{
				group_available.options.add(new Option(InterfaceList_Name[j], InterfaceList_Name[j]));
			}
		}
	}
	return true;
}

function btnRemove()
{
	with (document.forms[3])
	{
		var i = 0;
		for (i = 0; i < group_member.options.length; i++)
		{
			if (group_member.options[i].selected == true)
			{
				group_available.options.add(new Option(group_member.options[i].text, group_member.options[i].value));
			}
		}

		for (i = (group_member.options.length - 1); i >= 0; i--)
		{
			if (group_member.options[i].selected == true)
			{
				group_member.options.remove(i);
			}
		}
	}
	return true;
}

function btnAdd()
{
	with (document.forms[3])
	{
		var i = 0;
		for (i = 0; i < group_available.options.length; i++)
		{
			if (group_available.options[i].selected == true)
			{
				group_member.options.add(new Option(group_available.options[i].text, group_available.options[i].value));
			}
		}

		for (i = (group_available.options.length - 1); i >= 0; i--)
		{
			if (group_available.options[i].selected == true)
			{
				group_available.options.remove(i);
			}
		}
	}
	return true;
}

function build_group_list()
{
	with (document.forms[3])
	{
		var i = 0, j = 0, member_info = "";

		group_member_list.value = "";
		for (i = 0; i < group_member.options.length; i++)
		{
			for (j = 0; j < InterfaceList_Domain.length; j++)
			{
				if (group_member.options[i].value == InterfaceList_Name[j])
				{
					member_info = InterfaceList_Domain[j] + "|" + InterfaceList_ID[j] + "|" + InterfaceList_Name[j] + "|" + InterfaceList_Group[j];
					break;
				}
			}

			if (group_member_list.value != "") group_member_list.value += ",";
			group_member_list.value += member_info;
		}

		group_available_list.value = "";
		for (i = 0; i < group_available.options.length; i++)
		{
			for (j = 0; j < InterfaceList_Domain.length; j++)
			{
				if (group_available.options[i].value == InterfaceList_Name[j])
				{
					member_info = InterfaceList_Domain[j] + "|" + InterfaceList_ID[j] + "|" + InterfaceList_Name[j] + "|" + InterfaceList_Group[j];
					break;
				}
			}

			if (group_available_list.value != "") group_available_list.value += ",";
			group_available_list.value += member_info;
		}
	}
	return true;
}

function delClick(group_key)
{
	with (document.forms[3])
	{
		var i = 0;

		if (!confirm('<% multilang(LANG_CONFIRM_DELETE_ONE_ENTRY); %>'))
		{
			return false;
		}
		else
		{
			group_action.value = "0";
			group_number.value = group_key;

			group_select.value = group_key;
			viewGroup();

			for (i = 0; i < group_member.options.length; i++)
			{
				group_available.options.add(new Option(group_member.options[i].text, group_member.options[i].value));
			}

			for (i = (group_member.options.length - 1); i >= 0; i--)
			{
				group_member.options.remove(i);
			}

			build_group_list();
			postTableEncrypt(document.forms[3].postSecurityFlag, document.forms[3]);
			submit();
			return true;
		}
	}
	return true;
}

function saveClick()
{
	with (document.forms[3])
	{
		group_action.value = "1";
		group_number.value = group_select.value;

		if (group_enable.checked)
		{
			group_enable.disabled = true;
			group_enable_value.value = "1";
		}
		else
		{
			group_enable.disabled = true; 
			group_enable_value.value = "0";
		}

		build_group_list();
	}

	postTableEncrypt(document.forms[3].postSecurityFlag, document.forms[3]);
	document.forms[3].submit();
	return true;
}
/********************************************************************
**          on document load
********************************************************************/
function checkVLANRange(vlan)
{
	var num = reservedVlanA.length;
	for(var i = 0; i<num; i++){
		if(vlan == reservedVlanA[i])
			return false;
	}
	if(sji_checkdigitrange(vlan, otherVlanStart, otherVlanEnd) == true)
		return false;
	//return vlan==parseInt(vlan)&&0<vlan&&vlan<4095;
	return true;
}

function OnChooseDeviceType(Select)
{
   var Mode = document.getElementById("Frm_Mode").value;

   if (Mode == "0")
       document.getElementById("BindVlanRow").style.display = 'none';        
   else if (Mode == "1")
       document.getElementById("BindVlanRow").style.display = '';
}

//用户点击了取消按钮后的代码逻辑
function OnCancelButtonClick()
{
    document.getElementById("TableUrlInfo").style.display = "none";
    return false;
}

function OnApplyButtonClick()
{
	if(1 == document.getElementById("Frm_Mode").value) //vlan bind
	{
		var BindVlan = document.getElementById("VlanPair").value;
		if(false == IsBindBindVlanValid(BindVlan))
		{
			return false;
		}
	}
	
	document.forms[0].submit();
	return true;
}

function IsBindBindVlanValid(BindVlan)
{   
	var LanVlanWanVlanList = BindVlan.split(",");
	var LanVlan;
	var WanVlan;
	var TempList;
	
	if ( LanVlanWanVlanList.length > 4)
	{
			alert("<% multilang(LANG_MAX_SUPPORT_4_VLAN_PAIR);%>。");
			return false;
	}

	for (var i = 0; i < LanVlanWanVlanList.length; i++)
	{
		TempList = LanVlanWanVlanList[i].split("/");
		
		/* 检验是否满足a/b格式 */
		if (TempList.length != 2)
		{
			alert(BindVlan+"<% multilang(LANG_FORMAT_ILLEGAL);%>。");
			return false;
		}
		
		/* 检验a，b是否为数字 */
		if ((isNaN(parseInt(TempList[0]))) || (isNaN(parseInt(TempList[1]))))
		{
			alert(BindVlan+"<% multilang(LANG_FORMAT_ILLEGAL);%>。");
			return false;
		}
		
		/* 检验lan口的vlan是否合法, 如果需要更加精确的检查，调用checkVLANRange */
		if (!(parseInt(TempList[0]) >= 1 && parseInt(TempList[0]) <= 4095))
		{
			alert(BindVlan+"<% multilang(LANG_USER_VLAN);%>\""+parseInt(TempList[0])+"\"<% multilang(LANG_VALID_VALUE);%>。");
			return false;
		}
		
		if (!(parseInt(TempList[1]) >= 1 && parseInt(TempList[1]) <= 4095))
		{
			alert(BindVlan+"<% multilang(LANG_INTERFACE_VLAN);%>\""+parseInt(TempList[1])+"\"<% multilang(LANG_VALID_VALUE);%>。");
			return false;
		}

		LanVlan = "Frm_VLAN"+i+"a";
		WanVlan = "Frm_VLAN"+i+"b";

		document.getElementById(LanVlan).value = TempList[0];
		document.getElementById(WanVlan).value = TempList[1];	
	}

	return true;
}

function OnChooseDeviceType_vlan(Select)
{
   var Mode = document.getElementById("VLAN_Mode").value;

   if (Mode == "0")
       document.getElementById("VLAN_BindVlanRow").style.display = 'none';
   else if (Mode == "1")
       document.getElementById("VLAN_BindVlanRow").style.display = 'none';
   else if (Mode == "2")
       document.getElementById("VLAN_BindVlanRow").style.display = '';
}

//蚚誧萸僻賸秏偌聽綴腔測鎢軀憮
function OnCancelButtonClick_vlan()
{
    document.getElementById("VLAN_TableUrlInfo").style.display = "none";
    return false;
}

function OnApplyButtonClick_vlan(obj)
{
	var Mode = document.getElementById("VLAN_Mode").value;
	document.getElementById("VLAN_Frm_Mode").value = Mode;
	
	if(2 == document.getElementById("VLAN_Mode").value) //vlan bind
	{
		var BindVlan = document.getElementById("VLAN_VlanPair").value;
		if(false == IsBindBindVlanValid_vlan(BindVlan))
		{
			return false;
		}
	}
	obj.isclick = 1;
	document.getElementById('VLAN_PortId').disabled = true; 
	document.getElementById('VLAN_Mode').disabled = true; 
	document.getElementById('VLAN_VlanPair').disabled = true;
	document.getElementById('VLAN_save').disabled = true; 
	document.getElementById('VLAN_cancel').disabled = true; 
	postTableEncrypt(document.forms[2].postSecurityFlag, document.forms[2]);
	document.forms[2].submit();
	return true;
}

function IsBindBindVlanValid_vlan(BindVlan)
{
	var LanVlanWanVlanList = BindVlan.split(",");
	var LanVlan;
	var WanVlan;
	var TempList;
	var i;

	if ( LanVlanWanVlanList.length > 8)
	{
			alert("Max support four VLAN pairs");
			return false;
	}

	var SortLanVlanWanVlanList=LanVlanWanVlanList.sort();
	for (i = 0; i < LanVlanWanVlanList.length-1; i++)
	{
		if (SortLanVlanWanVlanList[i]==SortLanVlanWanVlanList[i+1])
		{
			alert(BindVlan+" has duplicated setting");
			return false;
		}
	}
	for (i = 0; i < LanVlanWanVlanList.length; i++)
	{
		TempList = LanVlanWanVlanList[i].split("/");

		/* 潰桄岆瘁雛逋a/b跡宒 */
		if (TempList.length != 2)
		{
			alert(BindVlan+"format invalid");
			return false;
		}

		/* 潰桄aㄛb岆瘁峈杅趼 */
		if ((isNaN(parseInt(TempList[0]))) || (isNaN(parseInt(TempList[1]))))
		{
			alert(BindVlan+"format invalid");
			return false;
		}

		/* 潰桄lan諳腔vlan岆瘁磁楊, 彆剒猁載樓儕腔潰脤ㄛ覃蚚checkVLANRange */
		if (!(parseInt(TempList[0]) >= 1 && parseInt(TempList[0]) <= 4095))
		{
			alert(BindVlan+"Vlan\""+parseInt(TempList[0])+"\"invalid");
			return false;
		}

		if (!(parseInt(TempList[1]) >= -1 && parseInt(TempList[1]) <= 7))
		{
			alert(BindVlan+" Vlan priority\""+parseInt(TempList[1])+"\"invalid (valid:0~7, '-1':not assigned)");
			return false;
		}

	}
	document.getElementById("VLAN_Frm_VLANPRI").value = BindVlan;
	return true;
}


Ont.CurMainMenu = "network";
Ont.CurSubMenu = "pvm";

function WebInit()
{
	showTable();
	showTable_iso();
	showTable_vlan();
	viewGroup();
}

$(function() {
	if (window.top.location.href == window.location.href)
	{
		window.location.href = "/index.html";
		return;
	}

	$.each(Ont.MainMenu, function(mi, mv){
		if (mv.id == Ont.CurMainMenu)
		{
			/*
			if (mv.id == "help")
			{
				initHelpMenu(mv.submenu);
			}
			*/
			$.each(mv.submenu, function(smi, smv){
				if (smv.id == Ont.CurSubMenu)
				{
					if (!isSubMenuShow(smv))
					{
						window.top.location.href = "/admin/login.asp";
					}
					return false;
				}
			});
			return false;
		}
	});

	window.Ont.InitProvince();

	WriteMainMenu();
	WriteSubMenu();
	WebInit();
	initMainContent();

	$S("XWebPageName", Ont.CurSubMenu);
	$("#XForm").attr("action", "/boaform/admin/formVlanMapping");

	setTimeout(function(){window.top.location.href = "logout.html";}, Ont.LogoutTimeout);
	
	$("#logout").click(function() {
		window.top.location.href = "logout.html";
	});
	
	$("#btn_cancel").click(function() {
		onCancel();
	});

	$("#login_username").html(Ont.CurUserName);
	$("#logout").html(Ont.StrLogout);
	//$("#ont_name").html(Ont.StrOntName);
	//$("#ont_model").html(Ont.StrOntModel.replace("/(^_*)|(_*$)/g", ""));

	$(".x_table tr:nth-child(even)").addClass("even");
	$(".x_table tr:nth-child(odd)").addClass("odd");
	var webdevicename=Ont.Webdevicename + "<% multilang(LANG_INTEGRATED_ENTERPRISE_GATEWAY);%>";
	$("#device_name").html(webdevicename);
});

function onCancel()
{
	window.location.reload();
}

</script>

</head>
<body id="x_root_body">

<div id="header">
	<div id="logo"></div>
	<div id="header_info">
		<div id="dev_info"><% multilang(LANG_TERM_MODEL);%>：<span id="device_name"></span></div>
		<div id="user_info"><% multilang(LANG_WELCOME);%>，<span id="login_username">admin</span>
		<a href="#" id="logout"></a>
		</div>
	</div>
</div>

<div id="menu">
	<div id="main_menu"></div>
</div>

<div id="container">

<div id="nav">
	<div id="nav_header"></div>
	<div id="sub_menu"></div>
</div>

<div id="maincontent">

<div id="content">
<div id="errmessage" class="x_message"></div>
<script type="text/javascript">WriteMainTitle("<% multilang(LANG_PVM_MODE); %>", "url_filter");</script>
<div id="x_url_filter" class="x_main_content">
<div class="x_sub_title"><% multilang(LANG_MENU_NETWORK_PVM);%></div>
        <br>
        <!--TODO:在这里加入你的具体页面展现-->
        <table border="1" id="Special_Table" width="100%" class="x_table">
          <tbody>
          <tr align="middle">
            <td class="table_title" width="10%"><% multilang(LANG_LAN); %></td>
            <td class="table_title" width="15%"><% multilang(LANG_PVM_MODE);%></td>
            <td class="table_title" width="75%"><% multilang(LANG_VLAN_BINDING_CONFIGUR);%></td>
          </tr>
		</tbody>
		</table>
        
        <!--Apply和Cancel按钮-->
        <div id="TableUrlInfo" style="display:none">
        <form id="vmap" action=/boaform/admin/formVlanMapping method=POST name=vmap>
          <table class="table1_bg" border="1">
            <tbody>
            	<tr class="trTabConfigure">
              <td align="left" width="25%" class="table1_left"><% multilang(LANG_LAN); %>
              </td><td class="table1_right"><div id="PortId"></div></td>
              </tr>
            
          </tbody></table>
          <table class="table1_bg" border="1">
            <tbody><tr class="trTabConfigure">
              <td align="left" width="25%" class="table1_left"><% multilang(LANG_INTERFACE_MODE);%>:</td>
              <td class="table1_right"><select name="Frm_Mode" id="Frm_Mode" onchange="OnChooseDeviceType(this);">
                  <option value="1"><% multilang(LANG_VLAN_BINDING);%></option>
                  <option value="0"><% multilang(LANG_BINDING_PORT);%></option>
                </select></td>
            </tr>
          </tbody></table>
          <div id="BindVlanRow">
            <table class="table1_bg" border="1">
              <tbody><tr class="trTabConfigure">
                <td width="25%" align="left" class="table1_left"><% multilang(LANG_BINDING_VLAN_PAIR);%>:</td>
                <td class="table1_right"><input type="text" id="VlanPair" style="width:300px" maxlength="255"></td>
              </tr>
            </tbody></table>
          </div>
          <table id="ConfigPanelButtons" width="100%" cellspacing="1" class="table1_button">
            <tbody>
            <tr  align="center">
              <td class="table1_submit" style="padding-left: 5px"><input type="hidden" value="0" name="entryidx">
				<input type='hidden' id="Frm_Mode"   name="Frm_Mode"   type="text" value="">
				<input type='hidden' id="Frm_VLAN0a" name="Frm_VLAN0a" type="text" value="">
				<input type='hidden' id="Frm_VLAN0b" name="Frm_VLAN0b" type="text" value="">
				<input type='hidden' id="Frm_VLAN1a" name="Frm_VLAN1a" type="text" value="">
				<input type='hidden' id="Frm_VLAN1b" name="Frm_VLAN1b" type="text" value="">
				<input type='hidden' id="Frm_VLAN2a" name="Frm_VLAN2a" type="text" value="">
				<input type='hidden' id="Frm_VLAN2b" name="Frm_VLAN2b" type="text" value="">
				<input type='hidden' id="Frm_VLAN3a" name="Frm_VLAN3a" type="text" value="">
				<input type='hidden' id="Frm_VLAN3b" name="Frm_VLAN3b" type="text" value="">
				<input type='hidden' name=if_index ID=if_index value=''>
				<input type="hidden" name="submit-url" value="/pvm.asp">
				<button class="btnsaveup" name="save" onclick="javascript:return OnApplyButtonClick();"><% multilang(LANG_APPLY_CHANGES); %></button>
							 &nbsp;&nbsp;
				<button class="BtnCnl" name="save" onclick="javascript:OnCancelButtonClick();"><% multilang(LANG_CANCEL); %></button>
            </tr>
          </tbody>
          </table>
			<input type='hidden' name=Mode0   ID=Mode0 value='0'>
	 		<input type='hidden' name=VLAN0   ID=VLAN0 value=''>
	 		<input type='hidden' name=Mode1   ID=Mode1 value='0'>
	 		<input type='hidden' name=VLAN1   ID=VLAN1 value=''>
	 		<input type='hidden' name=Mode2   ID=Mode2 value='0'>
	 		<input type='hidden' name=VLAN2   ID=VLAN2 value=''>
	 		<input type='hidden' name=Mode3   ID=Mode3 value='0'>
	 		<input type='hidden' name=VLAN3   ID=VLAN3 value=''>
	 		<input type='hidden' name=Mode4   ID=Mode4 value='0'>
	 		<input type='hidden' name=VLAN4   ID=VLAN4 value=''>
	 		<input type='hidden' name=Mode5   ID=Mode5 value='0'>
	 		<input type='hidden' name=VLAN5   ID=VLAN5 value=''>
	 		<input type='hidden' name=Mode6   ID=Mode6 value='0'>
	 		<input type='hidden' name=VLAN6   ID=VLAN6 value=''>
	 		<input type='hidden' name=Mode7   ID=Mode7 value='0'>
	 		<input type='hidden' name=VLAN7   ID=VLAN7 value=''>
	 		<input type='hidden' name=Mode8   ID=Mode8 value='0'>
	 		<input type='hidden' name=VLAN8   ID=VLAN8 value=''>
	 		<input type='hidden' name=Mode9   ID=Mode9 value='0'>
	 		<input type='hidden' name=VLAN9   ID=VLAN9 value=''>
	 		<input type='hidden' name=Mode10   ID=Mode10 value='0'>
	 		<input type='hidden' name=VLAN10   ID=VLAN10 value=''>
	 		<input type='hidden' name=Mode11   ID=Mode11 value='0'>
	 		<input type='hidden' name=VLAN11   ID=VLAN11 value=''>
	 		<input type='hidden' name=Mode12   ID=Mode12 value='0'>
	 		<input type='hidden' name=VLAN12   ID=VLAN12 value=''>
	 		<input type='hidden' name=Mode13   ID=Mode13 value='0'>
	 		<input type='hidden' name=VLAN13   ID=VLAN13 value=''>
			<input type='hidden' name=Mode14   ID=Mode14 value='0'>
	 		<input type='hidden' name=VLAN14   ID=VLAN14 value=''>
			<input type='hidden' name=Mode15   ID=Mode15 value='0'>
	 		<input type='hidden' name=VLAN15   ID=VLAN15 value=''>
			<input type='hidden' name=Mode16   ID=Mode16 value='0'>
	 		<input type='hidden' name=VLAN16   ID=VLAN16 value=''>
			<input type='hidden' name=Mode17   ID=Mode17 value='0'>
	 		<input type='hidden' name=VLAN17   ID=VLAN17 value=''>
	 		<script>
	 		<% initPagePBind(); %>
	 		</script>
          </form>
	 		
        </div>
</div> <!-- end of div[content] -->
<form id="portIsolation" action=/boaform/admin/formPortIsolation method=POST name=portIsolation>
<script type="text/javascript">WriteMainTitle("<% multilang(LANG_INTERFACE_BINDING_ISOLATION);%>", "url_port");</script>
<div id="x_url_port" class="x_main_content">
<div class="x_sub_title"><% multilang(LANG_MENU_NETWORK_PVM);%></div>
<div class="x_form_area">
<table border="1" id="x_iso_port" width="100%" class="x_table">
	<tbody>
          <tr align="middle">
            <td class="table_title" width="20%"><% multilang(LANG_LAN); %></td>
            <td class="table_title" width="80%"><% multilang(LANG_ISOLATION);%></td>
          </tr>
	</tbody>
</table>
<input type="button" id="btn_save_port" class="btn_save" onclick='portIsolation_submit();' value="<% multilang(LANG_APPLY_CHANGES); %>" />
</div>
</div>
<input type='hidden' name=Isolation0   ID=Isolation0 value='0'>
<input type='hidden' name=Isolation1   ID=Isolation1 value='0'>
<input type='hidden' name=Isolation2   ID=Isolation2 value='0'>
<input type='hidden' name=Isolation3   ID=Isolation3 value='0'>
<input type='hidden' name=Isolation4   ID=Isolation4 value='0'>
<input type='hidden' name=Isolation5   ID=Isolation5 value='0'>
<input type='hidden' name=Isolation6   ID=Isolation6 value='0'>
<input type='hidden' name=Isolation7   ID=Isolation7 value='0'>
<input type='hidden' name=Isolation8   ID=Isolation8 value='0'>
<input type='hidden' name=Isolation9   ID=Isolation9 value='0'>
<input type='hidden' name=Isolation10   ID=Isolation10 value='0'>
<input type='hidden' name=Isolation11   ID=Isolation11 value='0'>
<input type='hidden' name=Isolation12   ID=Isolation12 value='0'>
<input type='hidden' name=Isolation13   ID=Isolation13 value='0'>
<input type='hidden' name=Isolation14   ID=Isolation14 value='0'>
<input type='hidden' name=Isolation15   ID=Isolation15 value='0'>
<input type='hidden' name=Isolation16   ID=Isolation16 value='0'>
<input type='hidden' name=Isolation17   ID=Isolation17 value='0'>
<input type="hidden" name="submit-url" value="/pvm.asp">
<script>
<% initPagePIsolation(); %>
</script>
</form>




<script type="text/javascript">WriteMainTitle("<% multilang(LANG_VLAN_FUNCTION);%>", "vlan");</script>
<div id="x_vlan" class="x_main_content">
<div class="x_sub_title"><% multilang(LANG_VLAN_FUNCTION);%></div>
<div class="x_form_area">

<table border="1" id="VLAN_Special_Table" width="100%" class="x_table">
    <tbody>
        <tr align="middle">
			<td class="table_title" width="10%"><% multilang(LANG_LAN); %></td>
			<td class="table_title" width="15%"><% multilang(LANG_PVM_MODE);%></td>
			<td class="table_title" width="75%"><% multilang(LANG_VLAN_CONFIGURATION);%></td>
        </tr>
	</tbody>
</table>
<br>
<!--Apply睿Cancel偌聽-->
        <div id="VLAN_TableUrlInfo" style="display:none">
        <form id="vlanmap" action="/boaform/formLanVlanSetup" method="POST" name="vlanmap">
			<table width=600 class="table1_bg" border="1">
				<tbody>
					<tr>
						<th colspan="2" bgcolor="#C0C0C0"><strong>VLAN Setting</strong></th>
					</tr>
					<tr>
						<td bgcolor="#DDDDDD" align="left" width="25%" >Port</td>
						<td bgcolor="#DDDDDD" width="75%"><div id="VLAN_PortId"></div></td>
					</tr>
					<tr>
						<td bgcolor="#DDDDDD" align="left" width="25%" class="table1_left">Mode</td>
						<td bgcolor="#DDDDDD" class="table1_right">
							<select name="VLAN_Mode" id="VLAN_Mode" onchange="OnChooseDeviceType_vlan(this);">
							  <option value="0">Trunk </option>
							  <option value="1">Normal</option>
							  <option value="2">Enable VLAN</option>
							</select>
						</td>
					</tr>
				</tbody>
			</table>
			<div id="VLAN_BindVlanRow">
				<table width=600 class="table1_bg" border="1">
					<tbody>
						<tr>
							<td bgcolor="#DDDDDD" width="25%" align="left" class="table1_left">Setup VLAN/Priority</td>
							<td bgcolor="#DDDDDD" class="table1_right"><input type="text" id="VLAN_VlanPair" style="width:300px" maxlength="255"></td>
						</tr>
					</tbody>
				</table>
			</div>
		  </div>
			<table id="ConfigPanelButtons" width=600 cellspacing="1" class="table1_button">
				<tbody>
					<tr  align="center">
						<td class="table1_submit" style="padding-left: 5px">
						<input type="hidden" value="0" name="VLAN_entryidx">
						<input type='hidden' id="VLAN_Frm_Mode" name="VLAN_Frm_Mode" type="text" value="">
						<input type='hidden' id="VLAN_Frm_VLANPRI" name="VLAN_Frm_VLANPRI" type="text" value="">
						<input type='hidden' name=VLAN_if_index ID=VLAN_if_index value=''>
						<input type='hidden' name=VLAN_Mode0   ID=VLAN_Mode0 value='0'>
						<input type='hidden' name=VLAN_VLAN0   ID=VLAN_VLAN0 value=''>
						<input type='hidden' name=VLAN_Mode1   ID=VLAN_Mode1 value='0'>
						<input type='hidden' name=VLAN_VLAN1   ID=VLAN_VLAN1 value=''>
						<input type='hidden' name=VLAN_Mode2   ID=VLAN_Mode2 value='0'>
						<input type='hidden' name=VLAN_VLAN2   ID=VLAN_VLAN2 value=''>
						<input type='hidden' name=VLAN_Mode3   ID=VLAN_Mode3 value='0'>
						<input type='hidden' name=VLAN_VLAN3   ID=VLAN_VLAN3 value=''>
						<input type='hidden' name=VLAN_Mode4   ID=VLAN_Mode4 value='0'>
						<input type='hidden' name=VLAN_VLAN4   ID=VLAN_VLAN4 value=''>
						<input type='hidden' name=VLAN_Mode5   ID=VLAN_Mode5 value='0'>
						<input type='hidden' name=VLAN_VLAN5   ID=VLAN_VLAN5 value=''>
						<input type='hidden' name=VLAN_Mode6   ID=VLAN_Mode6 value='0'>
						<input type='hidden' name=VLAN_VLAN6   ID=VLAN_VLAN6 value=''>
						<input type='hidden' name=VLAN_Mode7   ID=VLAN_Mode7 value='0'>
						<input type='hidden' name=VLAN_VLAN7   ID=VLAN_VLAN7 value=''>
						<input type='hidden' name=VLAN_Mode8   ID=VLAN_Mode8 value='0'>
						<input type='hidden' name=VLAN_VLAN8   ID=VLAN_VLAN8 value=''>
						<input type='hidden' name=VLAN_Mode9   ID=VLAN_Mode9 value='0'>
						<input type='hidden' name=VLAN_VLAN9   ID=VLAN_VLAN9 value=''>
						<input type='hidden' name=VLAN_Mode10   ID=VLAN_Mode10 value='0'>
						<input type='hidden' name=VLAN_VLAN10   ID=VLAN_VLAN10 value=''>
						<input type='hidden' name=VLAN_Mode11   ID=VLAN_Mode11 value='0'>
						<input type='hidden' name=VLAN_VLAN11   ID=VLAN_VLAN11 value=''>
						<input type='hidden' name=VLAN_Mode12   ID=VLAN_Mode12 value='0'>
						<input type='hidden' name=VLAN_VLAN12   ID=VLAN_VLAN12 value=''>
						<input type='hidden' name=VLAN_Mode13   ID=VLAN_Mode13 value='0'>
						<input type='hidden' name=VLAN_VLAN13   ID=VLAN_VLAN13 value=''>
						<input type='hidden' name=VLAN_Mode14   ID=VLAN_Mode14 value='0'>
						<input type='hidden' name=VLAN_VLAN14   ID=VLAN_VLAN14 value=''>
						<input type='hidden' name=VLAN_Mode15   ID=VLAN_Mode15 value='0'>
						<input type='hidden' name=VLAN_VLAN15   ID=VLAN_VLAN15 value=''>
						<input type='hidden' name=VLAN_Mode16   ID=VLAN_Mode16 value='0'>
						<input type='hidden' name=VLAN_VLAN16   ID=VLAN_VLAN16 value=''>
						<input type='hidden' name=VLAN_Mode17   ID=VLAN_Mode17 value='0'>
						<input type='hidden' name=VLAN_VLAN17   ID=VLAN_VLAN17 value=''>
						<input type="hidden" name="submit-url" value="/pvm.asp">
						<input type="hidden" name="postSecurityFlag" value="">
						<div class="btn_ctl">
							<input class="btn_save" type="button" name="VLAN_save" id="VLAN_save" value="<% multilang(LANG_APPLY_CHANGES); %>" onClick="return OnApplyButtonClick_vlan(this)">&nbsp;&nbsp;
							<input class="btn_save" type="button" name="VLAN_cancel" id="VLAN_cancel" value="<% multilang(LANG_CANCEL); %>" onClick="return OnCancelButtonClick_vlan()">
						</div>
						</td>
					</tr>
				</tbody>
			</table>
	 		<script>
	 		<% initPageLanVlan(); %>
	 		</script>
          </form>
          	
        </div>
      </td>
      </tr>
	</tbody>
	</table>

<div class="x_sub_title"><% multilang(LANG_INTERFACE_GROUPING); %></div>
<form action="/boaform/formInterfaceGrouping" method="POST" name="InterfaceGroupingform">
		<div>
			<ul class="x_form_line" onmouseover="$H('');" onmouseout="$H();">
				<li class="x_form_caption"><% multilang(LANG_SELECT); %>:</li>
				<li class="x_form_input">
					<select name="group_select" id="group_select" onChange="viewGroup();">
						<script language="javascript">
						var i = 0;
						for (i = 1; i < InterfaceGroupingKey.length; i++)
						{
							document.write("<option value=\"" + InterfaceGroupingKey[i] + "\">" + InterfaceGroupingName[i] + "</option>");
						}
						document.write("<option value=\"-1\">New Group</option>");
						</script>
					</select>
				</li>
			</ul>
			<ul class="x_form_line" onmouseover="$H('');" onmouseout="$H();">
				<li class="x_form_caption"><% multilang(LANG_ENABLE); %>:</li>
				<li class="x_form_input">
					<input type="checkbox" name="group_enable" id="group_enable" value="1">
				</li>
			</ul>
			<ul class="x_form_line" onmouseover="$H('');" onmouseout="$H();">
				<li class="x_form_caption"><% multilang(LANG_NAME); %>:</li>
				<li class="x_form_input">
					<td width="70%"><input type="text" name="group_name" id="group_name" size="35" maxlength="64"></td>
				</li>
			</ul>
			<table>
				<tr align="center">
					<td><b><% multilang(LANG_GROUPED_INTERFACES); %></b></td>
					<td></td>
					<td><b><% multilang(LANG_AVAILABLE_INTERFACES); %></b></td>
				</tr>
				<tr align="center">
					<td>
						<select multiple name="group_member" id="group_member" size="8" style="width: 120px; height: 150px"></select>
					</td>
					<td>
						<input type="button" name="rmbtn" value="->" onClick="btnRemove();" style="width: 30px; height: 30px">
						<br><br>
						<input type="button" name="adbtn" value="<-" onClick="btnAdd();" style="width: 30px; height: 30px">
					</td>
					<td>
						<select multiple name="group_available" id="group_available" size="8" style="width: 120px; height: 150px"></select>
					</td>
				</tr>
			</table>
		</div>
		<br><br>
		<div id="apply_div" class="x_form_save">
			<input class="btn_save" type="button" value="<% multilang(LANG_APPLY_CHANGES); %>"  onClick="return saveClick()">
			<input type="hidden" name="group_action" value="1">
			<input type="hidden" name="group_number" value="0">
			<input type="hidden" name="group_enable_value" value="0">
			<input type="hidden" name="group_member_list" value="">
			<input type="hidden" name="group_available_list" value="">
			<input type="hidden" value="/pvm.asp" name="submit-url">
			<input type="hidden" name="postSecurityFlag" value="">
		</div>
			<table class="x_table">
			<tr>
				<th align=center width="25%"><% multilang(LANG_NAME); %></th>
				<th align=center width="15%"><% multilang(LANG_STATUS); %></th>
				<th align=center width="50%"><% multilang(LANG_INTERFACE); %></th>
				<th align=center width="10%"><% multilang(LANG_ACTION); %></th>
			</tr>
			<script language="javascript">
			var i = 0, j = 0, member_list = "";
			for (i = 0; i < InterfaceGroupingKey.length; i++)
			{
				document.write("<tr>");
				document.write("<td>" + InterfaceGroupingName[i] + "</td>");
				document.write("<td>" + ((InterfaceGroupingEnable[i] == "0") ? "<% multilang(LANG_DISABLE); %>":"<% multilang(LANG_ENABLE); %>") + "</td>");

				member_list = "";
				for (j = 0; j < InterfaceList_Domain.length; j++)
				{
					if (InterfaceGroupingKey[i] == InterfaceList_Group[j])
					{
						if (member_list != "") member_list += ",";
						member_list += InterfaceList_Name[j];
					}
				}
				document.write("<td>" + member_list + "</td>");

				if (i > 0)
					document.write("<td><image onClick=\"delClick(" + InterfaceGroupingKey[i] + ")\" title=\"Delete\" src=\"image/del.gif\"></td>");
				else
					document.write("<td></td>");
				document.write("</tr>");
			}
			</script>
			</table>
		</form>
	</div>
</div>






</div>

</div>

</body>
</html>

