<% cmccEnterpriseHtmlCommonHead(); %>

<style type="text/css">
</style>
<script type="text/javascript" src="/js/base64_code.js"></script>
<script type="text/javascript">
<% initProductInfo(); %>
var conns = new Array();
with(conns){<% ipsecSwanConfDetail(); %>}
var work_mode_type = new Array("", "<% multilang(LANG_LAYER2_MODE);%>", "<% multilang(LANG_LAYER3_MODE);%>");
var addr_mode_type = new Array("", "DHCP", "Static");
var L2TPOverIPSec=<% checkWrite("L2TPOverIPSec"); %>
var rcs = new Array();
with(rcs){<% vxlanConfList(); %>}

function checkParameters()
{
	with (getElById('ipsec'))
	{
		if(IKEAuthenticationMethod.value == 1){
			if(IKEPreshareKey.value == ""){
				alert("PSK<% multilang(LANG_MODE);%>IKEPreshareKey<% multilang(LANG_CAN_NOT_EMPTY);%>");
				IKEPreshareKey.focus();
				return false;
			}
			else if((IKEPreshareKey.value.length < 8) || (IKEPreshareKey.value.length  >128)){
				alert("IKEPreshareKey<% multilang(LANG_CHAR_LENGTH_IS);%>8~128");
				IKEPreshareKey.focus();
				return false;
			}
		}
		
		//check IKESAPeriod
		if((IKESAPeriod.value < 1200) || (IKESAPeriod.value > 86400)){
			alert("IKESAPeriod<% multilang(LANG_ILLEGAL_VALUE);%>，<% multilang(LANG_VALID_VALUE);%>1200~86400s");
			IKESAPeriod.focus();
			return false;
		}

		//check IPSecSATimePeriod
		if((IPSecSATimePeriod.value < 600) || (IPSecSATimePeriod.value > 86400)){
			alert("IPSecSATimePeriod<% multilang(LANG_ILLEGAL_VALUE);%>，<% multilang(LANG_VALID_VALUE);%>600~86400s");
			IPSecSATimePeriod.focus();
			return false;
		}

		//check IPSecSATrafficPeriod
		if((IPSecSATrafficPeriod.value < 2560) || (IPSecSATrafficPeriod.value > 536870912)){
			alert("IPSecSATrafficPeriod<% multilang(LANG_ILLEGAL_VALUE);%>，<% multilang(LANG_VALID_VALUE);%>2560~536870912KBytes");
			IPSecSATrafficPeriod.focus();
			return false;
		}

		if(DPDEnable.checked == true){
			//check DPDThreshold
			if((DPDThreshold.value < 10) || (DPDThreshold.value > 3600)){
				alert("DPDThreshold<% multilang(LANG_ILLEGAL_VALUE);%>，<% multilang(LANG_VALID_VALUE);%>10~3600s");
				DPDThreshold.focus();
				return false;
			}

			//check DPDRetry
			if((DPDRetry.value < 2) || (DPDRetry.value > 10)){
				alert("DPDRetry<% multilang(LANG_ILLEGAL_VALUE);%>，<% multilang(LANG_VALID_VALUE);%>2~10s");
				DPDRetry.focus();
				return false;
			}
		}
	}

	return true;
}

function btnSave()
{
	var	vForm = document.ipsec;
	
	if(checkParameters() == false){
		return;
	}
	
	vForm.submit();	
}

function btnDelete()
{
	var	vForm = document.ipsec;	
	vForm.OperatorStyle.value = "delete";
	vForm.submit();
}

function IPSecTypeChange()
{
	var type = getElById('IPSecType');
	var secRemoteIP = getElById('secRemoteIP');
	var secRemoteDomain = getElById('secRemoteDomain');

	if(type.value == 1){
		secRemoteIP.style.display="block";
		secRemoteDomain.style.display="none";
	}
	else if(type.value == 2){
		secRemoteIP.style.display="none";
		secRemoteDomain.style.display="block";
	}
	return;
}

function IKEAuthMethodChange()
{
	var method = getElById('IKEAuthenticationMethod');
	var secPsk = getElById('secPsk');

	if(method.value == 1){
		secPsk.style.display="block";
	}
	else if(method.value == 2){
		secPsk.style.display="none";
	}
	return;
}

function IKEIDTypeChange()
{
	var type = getElById('IKEIDType');
	var secTypeName = getElById('secTypeName');

	if(type.value == 1){
		secTypeName.style.display="none";
	}
	else if(type.value == 2){
		secTypeName.style.display="block";
	}
	return;
}

function IPSecTransformChange()
{
	var transform = getElById('IPSecTransform');
	var secEsp = getElById('secEsp');
	var secAh = getElById('secAh');

	if(transform.value == 1){
		secAh.style.display="block";
		secEsp.style.display="none";
	}
	else if(transform.value == 2){
		secAh.style.display="none";
		secEsp.style.display="block";	
	}
	return;
}

function DPDEnableChange()
{
	var DPDEnable = getElById('DPDEnable');
	var secDpd = getElById('secDpd');

	if(DPDEnable.checked == true){
		secDpd.style.display="block";
	}
	else if(DPDEnable.checked == false){
		secDpd.style.display="none";
	}
	return;
}

function secChange()
{
	IPSecTypeChange();
	IKEAuthMethodChange();
	IKEIDTypeChange();
	IPSecTransformChange();
	DPDEnableChange();
}

function entry_init()
{
	var vForm = document.ipsec;

	vForm.OperatorStyle.value = "add";

	vForm.Enable.checked = true;
	vForm.encapl2tp.checked = true;
	vForm.IPSecType.value = 1;
	vForm.RemoteSubnet.value = "";
	vForm.LocalSubnet.value = "192.168.1.0/24";
	vForm.RemoteIP.value = "";
	vForm.RemoteDomain.value = "";
	//vForm.IPSecOutInterface.value
	vForm.IPSecEncapsulationMode.value = 1;
	vForm.IKEVersion.value = 2;
	vForm.ExchangeMode.value = 1;
	vForm.IKEAuthenticationAlgorithm.value = 1;
	vForm.IKEAuthenticationMethod.value = 1;
	vForm.IKEEncryptionAlgorithm.value = 1;
	vForm.IKEDHGroup.value = 1;
	vForm.IKEIDType.value = 1;
	vForm.IKELocalName.value = "";
	vForm.IKERemoteName.value = "";
	vForm.IKEPreshareKey.value = "";
	vForm.IKESAPeriod.value = "10800";
	vForm.IPSecTransform.value = 2;
	vForm.ESPAuthenticationAlgorithm.value = 1;
	vForm.ESPEncryptionAlgorithm.value = 2;
	vForm.AHAuthenticationAlgorithm.value = 1;
	vForm.IPSecPFS.value = 1;
	vForm.IPSecSATimePeriod.value = 3600;
	vForm.IPSecSATrafficPeriod.value = 1843200;
	vForm.DPDEnable.checked = false;
	vForm.DPDThreshold.value = 10;
	vForm.DPDRetry.value = 5;
	vForm.ConnectionStatus.value = 0;

	secChange();

	return;
}

function entry_change()
{
	var vForm = document.ipsec;	
	var index = vForm.entrys.value;
	if(index == 999){
		entry_init();
		return;
	}

	vForm.OperatorStyle.value = "modify";

	var ipsecCfg = conns[index];

	if(ipsecCfg.Enable == 1){
		vForm.Enable.checked = true;
	}
	else{
		vForm.Enable.checked = false;
	}
	if(ipsecCfg.encapl2tp == 1){
		vForm.encapl2tp.checked = true;
	}
	else{
		vForm.encapl2tp.checked = false;
	}
	vForm.IPSecType.value = ipsecCfg.IPSecType;
	vForm.RemoteSubnet.value = ipsecCfg.RemoteSubnet;
	vForm.LocalSubnet.value = ipsecCfg.LocalSubnet;
	vForm.RemoteIP.value = ipsecCfg.RemoteIP;
	vForm.RemoteDomain.value = ipsecCfg.RemoteDomain;
	vForm.IPSecOutInterface.value = ipsecCfg.IPSecOutInterface;
	vForm.IPSecEncapsulationMode.value = ipsecCfg.IPSecEncapsulationMode;
	vForm.IKEVersion.value = ipsecCfg.IKEVersion;
	vForm.ExchangeMode.value = ipsecCfg.ExchangeMode;
	vForm.IKEAuthenticationAlgorithm.value = ipsecCfg.IKEAuthenticationAlgorithm;
	vForm.IKEAuthenticationMethod.value = ipsecCfg.IKEAuthenticationMethod;
	vForm.IKEEncryptionAlgorithm.value = ipsecCfg.IKEEncryptionAlgorithm;
	vForm.IKEDHGroup.value = ipsecCfg.IKEDHGroup;
	vForm.IKEIDType.value = ipsecCfg.IKEIDType;
	vForm.IKELocalName.value = ipsecCfg.IKELocalName;
	vForm.IKERemoteName.value = ipsecCfg.IKERemoteName;
	vForm.IKEPreshareKey.value = ipsecCfg.IKEPreshareKey;
	vForm.IKESAPeriod.value = ipsecCfg.IKESAPeriod;
	vForm.IPSecTransform.value = ipsecCfg.IPSecTransform;
	vForm.ESPAuthenticationAlgorithm.value = ipsecCfg.ESPAuthenticationAlgorithm;
	vForm.ESPEncryptionAlgorithm.value = ipsecCfg.ESPEncryptionAlgorithm;
	vForm.AHAuthenticationAlgorithm.value = ipsecCfg.AHAuthenticationAlgorithm;
	vForm.IPSecPFS.value = ipsecCfg.IPSecPFS;
	vForm.IPSecSATimePeriod.value = ipsecCfg.IPSecSATimePeriod;
	vForm.IPSecSATrafficPeriod.value = ipsecCfg.IPSecSATrafficPeriod;

	if(ipsecCfg.DPDEnable == 1){
		vForm.DPDEnable.checked = true;
	}
	else{
		vForm.DPDEnable.checked = false;
	}
	vForm.DPDThreshold.value = ipsecCfg.DPDThreshold;
	vForm.DPDRetry.value = ipsecCfg.DPDRetry;
	vForm.ConnectionStatus.value = ipsecCfg.ConnectionStatus;

	secChange();
	
	return;
}
function checkLacOverIPSec(){
	if(L2TPOverIPSec){
		if(document.l2tp.overipsecLAC.checked){
			if(document.l2tp.IKEPreshareKeyLAC.value == ""){
				alert("IKEPreshareKey cannot be empty in PSK mode");
				document.l2tp.IKEPreshareKeyLAC.focus();
				return false;
			}
			else if((document.l2tp.IKEPreshareKeyLAC.value.length < 8) || (document.l2tp.IKEPreshareKeyLAC.value.length  >128)){
				alert("IKEPreshareKey character length is8~128");
				document.l2tp.IKEPreshareKeyLAC.focus();
				return false;
			}

			if(!isAllStar(document.l2tp.IKEPreshareKeyLAC.value)){
				document.l2tp.encodepskValueLAC.value = encode64(document.l2tp.IKEPreshareKeyLAC.value);
				document.l2tp.IKEPreshareKeyLAC.disabled=true;
			}
		}
	}

	return true;
}

function checkLnsOverIPSec(){
	if(L2TPOverIPSec){
		if(document.l2tp.overipsecLNS.checked){
			if(document.l2tp.IKEPreshareKeyLNS.value == ""){
				alert("IKEPreshareKey cannot be empty in PSK mode");
				document.l2tp.IKEPreshareKeyLNS.focus();
				return false;
			}
			else if((document.l2tp.IKEPreshareKeyLNS.value.length < 8) || (document.l2tp.IKEPreshareKeyLNS.value.length  >128)){
				alert("IKEPreshareKey character length is8~128");
				document.l2tp.IKEPreshareKeyLNS.focus();
				return false;
			}

			if(!isAllStar(document.l2tp.IKEPreshareKeyLNS.value)){
				document.l2tp.encodepskValueLNS.value = encode64(document.l2tp.IKEPreshareKeyLNS.value);
				document.l2tp.IKEPreshareKeyLNS.disabled=true;
			}
		}
	}

	return true;
}

function onClickLacOverIPSec()
{
	if(L2TPOverIPSec){
		if (document.l2tp.overipsecLAC.checked)
			enableTextField(document.l2tp.IKEPreshareKeyLAC);
		else
			disableTextField(document.l2tp.IKEPreshareKeyLAC);
	}
}

function onClickLnsOverIPSec()
{
	if(L2TPOverIPSec){
		if (document.l2tp.overipsecLNS.checked)
			enableTextField(document.l2tp.IKEPreshareKeyLNS);
		else
			disableTextField(document.l2tp.IKEPreshareKeyLNS);
	}
}

function checkTextStr(str)
{
	for (var i=0; i<str.length; i++) 
	{
		if ( str.charAt(i) == '%' || str.charAt(i) =='&' ||str.charAt(i) =='\\' || str.charAt(i) =='?' || str.charAt(i)=='"') 
			return false;			
	}
	return true;
}

function pppAuthChange()
{
	if (document.l2tp.auth.value==3)
	{
		document.l2tp.enctype.disabled = false;
	}
	else
	{
		document.l2tp.enctype.disabled = true;
	}
}

function pppAuthChange_lns()
{
	if (document.l2tp.s_auth.value==3) {
		document.l2tp.s_enctype.disabled = false;
	}else
		document.l2tp.s_enctype.disabled = true;
}

function onClickTunnelAuth()
{
	if (document.l2tp.tunnel_auth.checked)
		document.l2tp.tunnel_secret.disabled = false;
	else
		document.l2tp.tunnel_secret.disabled = true;
}

function onClickTunnelAuth_lns()
{
	if(document.l2tp.s_tunnelAuth.checked)
		document.l2tp.s_authKey.disabled = false;
	else
		document.l2tp.s_authKey.disabled = true;
}

function isAllStar(str)
{
	for (var i=0; i<str.length; i++) {
		if ( str.charAt(i) != '*' ) {
			return false;
		}
	}
	return true;
}

function setL2tpServer(obj)
{
	var nsip = Ip2Num(document.l2tp.peeraddr.value);
	var neip = Ip2Num(document.l2tp.peerendaddr.value);
	var nlip = Ip2Num(document.l2tp.localaddr.value);
	
	if(document.l2tp.l2tpen[0].checked)
		return false;

	if (document.l2tp.s_name.value=="") {
		alert('<% multilang(LANG_PLEASE_ENTER_L2TP_SERVER_RULE_NAME); %>');
		document.l2tp.s_name.focus();
		return false;
	}

	if (document.l2tp.peeraddr.value=="") {
		alert('<% multilang(LANG_PLEASE_ENTER_PEER_START_ADDRESS); %>');
		document.l2tp.peeraddr.focus();
		return false;
	}
	if (!checkHostIP(document.l2tp.peeraddr, 0))
		return false;
		
	if (document.l2tp.peerendaddr.value=="") {
		alert('<% multilang(LANG_PLEASE_ENTER_PEER_END_ADDRESS); %>');
		document.l2tp.peerendaddr.focus();
		return false;
	}
	if (!checkHostIP(document.l2tp.peerendaddr, 0))
		return false;

	if(document.l2tp.peeraddr.value!='' && nsip > neip){
		alert( '<% multilang(LANG_START_IP_SHOULD_LESS_THAN_END_IP); %>');
		return;
	}
	
	if (document.l2tp.localaddr.value=="") {
		alert('<% multilang(LANG_PLEASE_ENTER_LOCAL_ADDRESS); %>');
		document.l2tp.localaddr.focus();
		return false;
	}
	if (!checkHostIP(document.l2tp.localaddr, 0)){
		alert( '<% multilang(LANG_INVALID_LOCAL_IP_ADDRESS); %>');
		return false;
	}
		
	if(nlip >= nsip && nlip <= neip){
		alert( '<% multilang(LANG_ERROR_LOCAL_ADDR_SHOULD_NOT_IN_PEER_START_END_ADDRESS); %>');
		return false;
	}

	if(false == checkLnsOverIPSec()){
		return false;
	}
	document.l2tp.lst.disabled = true;
	obj.isclick = 1;
	//postTableEncrypt(document.forms[0].postSecurityFlag, document.forms[0]);

	return true;
}

function addL2tpAccount(obj)
{
	if(document.l2tp.l2tpen[0].checked)
		return false;

	if (document.l2tp.s_accout_name.value=="") {
		alert('<% multilang(LANG_PLEASE_ENTER_L2TP_SERVER_RULE_NAME); %>');
		document.l2tp.s_accout_name.focus();
		return false;
	}

	if(document.l2tp.s_tunnelAuth.checked){
		if(document.l2tp.s_authKey.value ==""){
			alert('<% multilang(LANG_PLEASE_ENTER_L2TP_TUNNEL_AUTHKEY); %>');
			document.l2tp.s_authKey.focus();
			return false;
		}
		if(!checkTextStr(document.l2tp.s_authKey))
		{
			return false;
		}
	}

	if (document.l2tp.s_username.value=="")
	{
		alert('<% multilang(LANG_PLEASE_ENTER_L2TP_SERVER_USERNAME); %>');
		document.l2tp.s_username.focus();
		return false;
	}
	if(!checkTextStr(document.l2tp.s_username))
	{
		return false;
	}

	if (document.l2tp.s_password.value=="") {
		alert('<% multilang(LANG_PLEASE_ENTER_L2TP_SERVER_PASSWORD); %>');
		document.l2tp.s_password.focus();
		return false;
	}
	if(!isAllStar(document.l2tp.s_password.value)){
		if (includeSpace(document.l2tp.s_password.value)) {
			alert('<% multilang(LANG_CANNOT_ACCEPT_SPACE_CHARACTER_IN_PASSWORD_PLEASE_TRY_IT_AGAIN); %>');
			document.l2tp.s_password.focus();
			return false;
		}
		if(!checkString(document.l2tp.s_password.value))
		{
			alert("<% multilang(LANG_INVALID_VALUE_IN_PASSWORD); %>");
			document.l2tp.s_password.focus();
			return false;
		}
		document.l2tp.encodeSPassword.value=encode64(document.l2tp.s_password.value);
		document.l2tp.s_password.disabled=true;
	}
	document.l2tp.lst.disabled = true;
	obj.isclick = 1;
	//postTableEncrypt(document.forms[0].postSecurityFlag, document.forms[0]);

	return true;
}

function connTypeChange()
{
	if(document.l2tp.pppconntype.selectedIndex==1)
	{
		document.l2tp.idletime.disabled=false;
	}else{
		document.l2tp.idletime.disabled=true;
	}
}

function l2tpSelection()
{
	if (document.l2tp.l2tpen[0].checked) {
		/* LAC */
		document.l2tp.c_name.disabled = true;
		document.l2tp.IpProtocolType.disabled = true;
		document.l2tp.server.disabled = true;
		document.l2tp.tunnel_auth.disabled = true;
		document.l2tp.tunnel_secret.disabled = true;
		document.l2tp.auth.disabled = true;
		document.l2tp.username.disabled = true;
		document.l2tp.password.disabled = true;
		document.l2tp.pppconntype.disabled = true;
		document.l2tp.idletime.disabled = true;
		document.l2tp.mtu.disabled = true;
		document.l2tp.defaultgw.disabled = true;
		document.l2tp.addClient.disabled = true;
		document.l2tp.enctype.disabled = true;
		document.l2tp.delSelClient.disabled = true;
		document.l2tp.overipsecLAC.disabled = true;
		document.l2tp.IKEPreshareKeyLAC.disabled = true;
		/* LNS */
		document.l2tp.s_name.disabled = true;
		document.l2tp.s_auth.disabled = true;
		document.l2tp.s_enctype.disabled = true;
		document.l2tp.peeraddr.disabled = true;
		document.l2tp.peerendaddr.disabled = true;
		document.l2tp.localaddr.disabled = true;
		document.l2tp.addServer.disabled = true;
		document.l2tp.s_accout_name.disabled = true;
		document.l2tp.tunnelen.disabled = true;
		document.l2tp.s_tunnelAuth.disabled = true;
		document.l2tp.s_authKey.disabled = true;
		document.l2tp.s_username.disabled = true;
		document.l2tp.s_password.disabled = true;
		document.l2tp.addAccount.disabled = true;
		document.l2tp.delSelAccount.disabled = true;
		document.l2tp.overipsecLNS.disabled = true;
		document.l2tp.IKEPreshareKeyLNS.disabled = true;
	}
	else {
		/* LAC */
		document.l2tp.c_name.disabled = false;
		document.l2tp.IpProtocolType.disabled = false;
		document.l2tp.server.disabled = false;
		document.l2tp.tunnel_auth.disabled = false;
		document.l2tp.tunnel_secret.disabled = false;
		document.l2tp.auth.disabled = false;
		document.l2tp.username.disabled = false;
		document.l2tp.password.disabled = false;
		document.l2tp.pppconntype.disabled = false;
		document.l2tp.idletime.disabled = false;
		document.l2tp.mtu.disabled = false;
		document.l2tp.defaultgw.disabled = false;
		document.l2tp.addClient.disabled = false;
		document.l2tp.enctype.disabled = false;
		document.l2tp.delSelClient.disabled = false;
		document.l2tp.overipsecLAC.disabled = false;
		document.l2tp.IKEPreshareKeyLAC.disabled = false;
		/* LNS */
		document.l2tp.s_name.disabled = false;
		document.l2tp.s_auth.disabled = false;
		document.l2tp.s_enctype.disabled = false;
		document.l2tp.peeraddr.disabled = false;
		document.l2tp.peerendaddr.disabled = false;
		document.l2tp.localaddr.disabled = false;
		document.l2tp.addServer.disabled = false;
		document.l2tp.s_accout_name.disabled = false;
		document.l2tp.tunnelen.disabled = false;
		document.l2tp.s_tunnelAuth.disabled = false;
		document.l2tp.s_authKey.disabled = false;
		document.l2tp.s_username.disabled = false;
		document.l2tp.s_password.disabled = false;
		document.l2tp.addAccount.disabled = false;
		document.l2tp.delSelAccount.disabled = false;
		document.l2tp.overipsecLNS.disabled = false;
		document.l2tp.IKEPreshareKeyLNS.disabled = false;
	}
	onClickTunnelAuth();
	onClickTunnelAuth_lns();
	pppAuthChange();
	connTypeChange()
}

function onClickL2TPEnable()
{
	l2tpSelection();
	
	if (document.l2tp.l2tpen[0].checked)
		document.l2tp.lst.value = "disable";
	else
		document.l2tp.lst.value = "enable";
	//postTableEncrypt(document.forms[0].postSecurityFlag, document.forms[0]);
}

function addL2TPItf(obj)
{
	if(document.l2tp.l2tpen[0].checked)
		return false;
	
	if (document.l2tp.c_name.value=="") {
		alert('<% multilang(LANG_PLEASE_ENTER_L2TP_CLIENT_RULE_NAME); %>');
		document.l2tp.c_name.focus();
		return false;
	}

	if (document.l2tp.server.value=="") {		
		alert('<% multilang(LANG_PLEASE_ENTER_L2TP_SERVER_ADDRESS); %>');
		document.l2tp.server.focus();
		return false;
	}

	if (document.l2tp.IpProtocolType.value == 2)
	{
		if (! isGlobalIpv6Address( document.l2tp.server.value) )
		{			
			alert('<% multilang(LANG_PLEASE_INPUT_IPV6_ADDRESS); %>');
			document.l2tp.server.focus();
			return false;
		}
	}
	else if (document.l2tp.IpProtocolType.value == 1)
	{
		if (!checkTextStr(document.l2tp.server.value))
		{			
			alert('<% multilang(LANG_PLEASE_INPUT_IPV4_ADDRESS); %>');
			document.l2tp.server.focus();
			return false;
		}
	}

	if (document.l2tp.tunnel_auth.checked)
	{
		if (document.l2tp.tunnel_secret.value=="")
		{			
			alert('<% multilang(LANG_PLEASE_ENTER_L2TP_TUNNEL_AUTHENTICATION_SECRET); %>');
			document.l2tp.tunnel_secret.focus();
			return false;
		}
		if(!checkTextStr(document.l2tp.tunnel_secret.value))
		{			
			alert('<% multilang(LANG_INVALID_VALUE_IN_TUNNEL_AUTHENTICATION_SECRET); %>');
			document.l2tp.tunnel_secret.focus();
			return false;		
		}
	}
	
	if (document.l2tp.auth.selectedIndex!=3)
	{
		if (document.l2tp.username.value=="")
		{			
			alert('<% multilang(LANG_PLEASE_ENTER_L2TP_CLIENT_USERNAME); %>');
			document.l2tp.username.focus();
			return false;
		}
		if(!checkTextStr(document.l2tp.username.value))
		{			
			alert('<% multilang(LANG_INVALID_VALUE_IN_USERNAME); %>');
			document.l2tp.username.focus();
			return false;		
		}
		if (document.l2tp.password.value=="") {			
			alert('<% multilang(LANG_PLEASE_ENTER_L2TP_CLIENT_PASSWORD); %>');
			document.l2tp.password.focus();
			return false;
		}
		if(!isAllStar(document.l2tp.password.value)){
			if (includeSpace(document.l2tp.password.value)) {
				alert('<% multilang(LANG_CANNOT_ACCEPT_SPACE_CHARACTER_IN_PASSWORD_PLEASE_TRY_IT_AGAIN); %>');
				document.l2tp.password.focus();
				return false;
			}
			if(!checkString(document.l2tp.password.value))
			{
				alert("<% multilang(LANG_INVALID_VALUE_IN_PASSWORD); %>");
				document.l2tp.password.focus();
				return false;
			}
			document.l2tp.encodePassword.value=encode64(document.l2tp.password.value);
			document.l2tp.password.disabled=true;
		}
	}

	if (document.l2tp.pppconntype.selectedIndex==1)
	{
		if (document.l2tp.idletime.value=="")
		{			
			alert('<% multilang(LANG_PLEASE_ENTER_L2TP_TUNNEL_IDLE_TIME); %>');
			document.l2tp.idletime.focus();
			return false;
		}
	}

	if (document.l2tp.mtu.value=="")
	{		
		alert('<% multilang(LANG_PLEASE_ENTER_L2TP_TUNNEL_MTU); %>');
		document.l2tp.mtu.focus();
		return false;
	}

	if(false == checkLacOverIPSec()){
		return false;
	}
	document.l2tp.lst.disabled = true;
	obj.isclick = 1;
	//postTableEncrypt(document.forms[0].postSecurityFlag, document.forms[0]);
	return true;
}

function deleteClick(obj)
{
	if ( !confirm('<% multilang(LANG_CONFIRM_DELETE_ONE_ENTRY); %>') ) {
		return false;
	}
	else{
		document.l2tp.lst.disabled = true;
		obj.isclick = 1;
		//postTableEncrypt(document.forms[0].postSecurityFlag, document.forms[0]);
		return true;
	}
}

function on_submit(obj)
{
	obj.isclick = 1;
	//postTableEncrypt(document.forms[0].postSecurityFlag, document.forms[0]);
	return true;
}

function roleSelect()
{
	var myval = document.getElementById("sel_rol").value;
	if (myval == 0) {
		document.getElementById("l2tp_lac").style.display = "";
		document.getElementById("l2tp_lns").style.display = "none";
	}
	else {
		document.getElementById("l2tp_lac").style.display = "none";
		document.getElementById("l2tp_lns").style.display = "";
	}
	
	if (document.l2tp.l2tpen[0].checked)
		document.l2tp.lst.value = "disable";
	else
		document.l2tp.lst.value = "enable";
}

function show_password(id)
{
	var x= document.l2tp.password;
	if(id==1){
		x= document.l2tp.password;
	}
	else if(id==2){
		x= document.l2tp.s_password;
	}
	else if(id==3){
		x= document.l2tp.IKEPreshareKeyLAC;
	}
	else if(id==4){
		x= document.l2tp.IKEPreshareKeyLNS;
	}
	if (x.type == "password") {
		x.type = "text";
	} else {
		x.type = "password";
	}
}

function l2tp_submit(obj)
{
	obj.isclick = 1;
	//postTableEncrypt(document.forms[0].postSecurityFlag, document.forms[0]);
	document.l2tp.submit();
	return true;
}


</script>
<script type="text/javascript">

Ont.CurMainMenu = "network";
Ont.CurSubMenu  = "vpn";

<% initProductInfo(); %>

function WebInit()
{
	//ipsec init
	var	vForm = document.ipsec;	
	if(conns.length > 0){
		vForm.entrys.value=0;
		entry_change();
	}
	secChange();
	
	//l2tp init
	<% initPage("l2tp"); %>
	if (document.l2tp.lns_en.value != 0)
		document.getElementById("l2tp_type").style.display = "";
	if (document.l2tp.ipv6_en.value != 0)
		document.getElementById("l2tp_ipv6").style.display = "";
	roleSelect();
	l2tpSelection();
	on_init_vxlan();
}

$(function() {
	if (window.top.location.href == window.location.href)
	{
		window.location.href = "/index.html";
		return;
	}

	$.each(Ont.MainMenu, function(mi, mv){
		if (mv.id == Ont.CurMainMenu)
		{
			/*
			if (mv.id == "help")
			{
				initHelpMenu(mv.submenu);
			}
			*/
			$.each(mv.submenu, function(smi, smv){
				if (smv.id == Ont.CurSubMenu)
				{
					if (!isSubMenuShow(smv))
					{
						window.top.location.href = "/admin/login.asp";
					}
					return false;
				}
			});
			return false;
		}
	});

	window.Ont.InitProvince();

	WriteMainMenu();
	WriteSubMenu();
	WebInit();
	initMainContent();

	$S("XWebPageName", Ont.CurSubMenu);
	$("#ipsec").attr("action", "/boaform/admin/formIPsecStrongswan");
	$("#gen_local_cert").attr("action", "/boaform/admin/formIPSecSwanGenCert");
	$("#l2tp").attr("action", "/boaform/admin/formL2TP");
	$("#vxlan_connection").attr("action", "/boaform/admin/formVxlan");

	setTimeout(function(){window.top.location.href = "logout.html";}, Ont.LogoutTimeout);
	
	$("#logout").click(function() {
		window.top.location.href = "logout.html";
	});
	$("#btn_cancel").click(function() {
		onCancel();
	});

	$("#login_username").html(Ont.CurUserName);
	$("#logout").html(Ont.StrLogout);
	//$("#ont_name").html(Ont.StrOntName);
	//$("#ont_model").html(Ont.StrOntModel.replace("/(^_*)|(_*$)/g", ""));

	$(".x_table tr:nth-child(even)").addClass("even");
	$(".x_table tr:nth-child(odd)").addClass("odd");
	var webdevicename=Ont.Webdevicename + "<% multilang(LANG_INTEGRATED_ENTERPRISE_GATEWAY);%>";
	$("#device_name").html(webdevicename);
});


//VxLAN
function onSelectAddrMode()
{
	if(document.getElementById("addressing_type").value == 1)//DHCP
	{
		document.getElementById("ip_addr_div").style.display = "none";
		document.getElementById("subnet_mask_div").style.display = "none";
		document.getElementById("default_gateway_div").style.display = "none";
		document.getElementById("dns_server_master_div").style.display = "none";
		document.getElementById("dns_server_slave_div").style.display = "none";
		document.vxlan_connection.ip_addr.value = '';
		document.vxlan_connection.subnet_mask.value = '';
		document.vxlan_connection.default_gateway.value = '';
		document.vxlan_connection.dns_server_master.value = '';
		document.vxlan_connection.dns_server_slave.value = '';
	}
	else //Static
	{
		document.getElementById("ip_addr_div").style.display = "block";
		document.getElementById("subnet_mask_div").style.display = "block";
		document.getElementById("default_gateway_div").style.display = "block";
		document.getElementById("dns_server_master_div").style.display = "block";
		document.getElementById("dns_server_slave_div").style.display = "block";
	}
}

function onSelectWorkMode()
{
	if(document.getElementById("work_mode").value == 1)//DHCP
	{
		document.getElementById("addressing_type_div").style.display = "none";
		document.getElementById("nat_enable_div").style.display = "none";
		document.getElementById("ip_addr_div").style.display = "none";
		document.getElementById("subnet_mask_div").style.display = "none";
		document.getElementById("default_gateway_div").style.display = "none";
		document.getElementById("dns_server_master_div").style.display = "none";
		document.getElementById("dns_server_slave_div").style.display = "none";
		document.vxlan_connection.ip_addr.value = '';
		document.vxlan_connection.subnet_mask.value = '';
		document.vxlan_connection.default_gateway.value = '';
		document.vxlan_connection.dns_server_master.value = '';
		document.vxlan_connection.dns_server_slave.value = '';
	}
	else //Routing
	{
		document.getElementById("addressing_type_div").style.display = "block";
		document.getElementById("nat_enable_div").style.display = "block";
		onSelectAddrMode();
	}
}

function vxlanCheck(obj)
{
	//vxlan_connection
	{
		if(!checkDigitRange(document.vxlan_connection.tunnel_key.value, 1, 0, 16777215))
		{
			document.vxlan_connection.tunnel_key.focus();
			alert("vni：" + document.vxlan_connection.tunnel_key.value + "<% multilang(LANG_ILLEGAL_VALUE_INPUT_AGAIN);%>！");
			return false;
		}
		if(sji_checkvip(document.vxlan_connection.tunnel_dst_ip.value) == false)
		{
			document.vxlan_connection.tunnel_dst_ip.focus();
			alert("<% multilang(LANG_TUNNEL_DST_ADDR);%>：" + document.vxlan_connection.tunnel_dst_ip.value + "<% multilang(LANG_ILLEGAL_IP_INPUT_AGAIN);%>！");
			return false;
		}
		if (document.vxlan_connection.vlan_enable.checked)
		{
			if(!checkDigitRange(document.vxlan_connection.vlan.value, 1, 0, 4094))
			{
				document.vxlan_connection.vlan.focus();
				alert("VLAN ID：" + document.vxlan_connection.vlan.value + "<% multilang(LANG_ILLEGAL_VALUE_INPUT_AGAIN);%>！");
				return false;
			}
		}
		if(document.vxlan_connection.work_mode.value == 2) //Routing
		{
			if(document.vxlan_connection.addressing_type.value == 2) //Static
			{
				if(sji_checkvip(document.vxlan_connection.ip_addr.value) == false)
				{
					document.vxlan_connection.ip_addr.focus();
					alert("<% multilang(LANG_IP_ADDRESS);%>：" + document.vxlan_connection.ip_addr.value + "<% multilang(LANG_ILLEGAL_IP_INPUT_AGAIN);%>！");
					return false;
				}
				if(sji_checkmask(document.vxlan_connection.subnet_mask.value) == false)
				{
					document.vxlan_connection.subnet_mask.focus();
					alert("<% multilang(LANG_SUBNET_MASK);%>：" + document.vxlan_connection.subnet_mask.value + "<% multilang(LANG_ILLEGAL_IP_INPUT_AGAIN);%>！");
					return false;
				}
				if(sji_checkvip(document.vxlan_connection.default_gateway.value) == false)
				{
					document.vxlan_connection.default_gateway.focus();
					alert("<% multilang(LANG_GATEWAY);%>：" + document.vxlan_connection.default_gateway.value + "<% multilang(LANG_ILLEGAL_IP_INPUT_AGAIN);%>！");
					return false;
				}
				if((document.vxlan_connection.dns_server_master.value.length > 0 )&& sji_checkvip(document.vxlan_connection.dns_server_master.value) == false)
				{
					document.vxlan_connection.dns_server_master.focus();
					alert("<% multilang(LANG_PRIMARY_DNS);%>：" + document.vxlan_connection.dns_server_master.value + "<% multilang(LANG_ILLEGAL_IP_INPUT_AGAIN);%>！");
					return false;
				}
				if((document.vxlan_connection.dns_server_slave.value.length > 0 )&& sji_checkvip(document.vxlan_connection.dns_server_slave.value) == false)
				{
					document.vxlan_connection.dns_server_slave.focus();
					alert("<% multilang(LANG_SECONDARY_DNS);%>：" + document.vxlan_connection.dns_server_slave.value + "<% multilang(LANG_ILLEGAL_IP_INPUT_AGAIN);%>！");
					return false;
				}
			}
		}
	}
	obj.isclick = 1;
	document.vxlan_connection.action.value = "add";

	return true;
}

function deleteVxlanClick(obj)
{
	if ( !confirm('<% multilang(LANG_CONFIRM_DELETE_ONE_ENTRY); %>') ) {
		return false;
	}
	else{
		obj.isclick = 1;
		document.vxlan_connection.action.value = "delete";
		return true;
	}
}

function on_chkclick(index)
{
	if(index < 0 || index >= rcs.length)
		return;
	rcs[index].select = !rcs[index].select;
}


function on_init_vxlan()
{
	//sji_docinit(document);
	if(lstrc.rows){while(lstrc.rows.length > 1) lstrc.deleteRow(1);}
	for(var i = 0; i < rcs.length; i++)
	{
		var row = lstrc.insertRow(i + 1);
		row.nowrap = true;
		row.vAlign = "top";
		row.align = "center";
		var cell;
		cell = row.insertCell(0);
		cell.align = "center";
		cell.innerHTML = "<input type=\"checkbox\" name=\"rml"
				+ i + "\" value=\"ON\" onClick=\"on_chkclick(" + i + ");\">";
		cell = row.insertCell(1);
		cell.innerHTML = rcs[i].tunnel_key;
		cell = row.insertCell(2);
		if(rcs[i].enable == "1")
			cell.innerHTML = "<% multilang(LANG_WLAN_SCHEDULE_ENA);%>";
		else
			cell.innerHTML = "<% multilang(LANG_SPEED_LIMIT_DISABLED);%>";
		cell = row.insertCell(3);
		cell.innerHTML = rcs[i].tunnel_dst_ip;
		cell = row.insertCell(4);
		cell.innerHTML = work_mode_type[rcs[i].work_mode];
		cell = row.insertCell(5);
		cell.innerHTML = addr_mode_type[rcs[i].addressing_type];
		cell = row.insertCell(6);
		cell.innerHTML = rcs[i].ip_addr;
		cell = row.insertCell(7);
		if(rcs[i].vlan_enable == "1")
			cell.innerHTML = "<% multilang(LANG_WLAN_SCHEDULE_ENA);%>";
		else
			cell.innerHTML = "<% multilang(LANG_SPEED_LIMIT_DISABLED);%>";
		cell = row.insertCell(8);
		cell.innerHTML = rcs[i].wanname;
	}
	onSelectWorkMode();
}
</script>
</head>
<body id="x_root_body">
<div id="header">
	<div id="logo"></div>
	<div id="header_info">
		<div id="dev_info"><% multilang(LANG_TERM_MODEL);%>：<span id="device_name"></span></div>
		<div id="user_info"><% multilang(LANG_WELCOME);%>，<span id="login_username">admin</span>
		<a href="#" id="logout"></a>
		</div>
	</div>
</div>

<div id="menu">
	<div id="main_menu"></div>
</div>

<div id="container">

<div id="nav">
	<div id="nav_header"></div>
	<div id="sub_menu"></div>
</div>

<div id="maincontent">

<div id="content">
<div id="errmessage" class="x_message"></div>
<script type="text/javascript">WriteMainTitle("IPSec<% multilang(LANG_CONFIGURATION);%>", "ipsec_connection");</script>
<div id="x_ipsec_connection" class="x_main_content">
	<form id="ipsec" name="ipsec" action=/boaform/formIPsecStrongswan method=POST >
	<div class="x_sub_title">IPSec <% multilang(LANG_BASIC_CONFIGURATION);%></div>
	<div class="x_form_area">
	<input id="XWebPageName" name="XWebPageName" value="vpn" type="hidden">
	<input type="hidden" name="OperatorStyle" value="add">
	<ul class="x_form_line" onmouseover="$H('');" onmouseout="$H();">
		<li class="x_form_caption">IPSec<% multilang(LANG_RULE_LIST);%></li>
		<li class="x_form_input">
			<select name="entrys" class="selectStyle" onchange="entry_change()">
				<% ipsecSwanConfList();%>
			</select>
		</li>
	</ul>
	<ul class="x_form_line" onmouseover="$H('');" onmouseout="$H();">
		<li class="x_form_caption"><% multilang(LANG_ENABLE_RULE);%></li>
		<li class="x_form_input">
			<input type='checkbox' name='Enable' checked>
		</li>
	</ul>
	<ul class="x_form_line" onmouseover="$H('');" onmouseout="$H();">
		<li class="x_form_caption">L2TP<% multilang(LANG_ENCAP_RULE);%></li>
		<li class="x_form_input">
			<input type='checkbox' name='encapl2tp' checked>
		</li>
	</ul>
	<ul class="x_form_line" onmouseover="$H('');" onmouseout="$H();">
		<li class="x_form_caption">IPSec <% multilang(LANG_TYPE);%></li>
		<li class="x_form_input">
			<select name="IPSecType" class="selectStyle" onchange="IPSecTypeChange();">
				<option value="1" selected>Site-to-Site</option>
				<option value="2">PC-to-Site</option>
			</select>
		</li>
	</ul>
	<ul class="x_form_line" onmouseover="$H('');" onmouseout="$H();">
		<li class="x_form_caption"><% multilang(LANG_REMOTE);%> Subnet</li>
		<li class="x_form_input">
			<input  name="RemoteSubnet" class="inputStyle" placeholder="<% multilang(LANG_MULTIPLE_NETWORK_DIV_BY_DOT);%>" type="text" />
		</li>
	</ul>
	<ul class="x_form_line" onmouseover="$H('');" onmouseout="$H();">
		<li class="x_form_caption"><% multilang(LANG_LOCAL_STR);%> Subnet</li>
		<li class="x_form_input">
			<input  name="LocalSubnet" class="inputStyle" value="192.168.1.0/24" type="text" />
		</li>
	</ul>
	<div id="secRemoteIP" style="display: block">
	<ul class="x_form_line" onmouseover="$H('');" onmouseout="$H();">
		<li class="x_form_caption"><% multilang(LANG_REMOTE);%> IP</li>
		<li class="x_form_input">
			<input  name="RemoteIP" class="inputStyle" type="text" />
		</li>
	</ul>
	</div>
	<div id="secRemoteDomain" style="display: none">
	<ul class="x_form_line" onmouseover="$H('');" onmouseout="$H();">
		<li class="x_form_caption"><% multilang(LANG_REMOTE);%> Domain</li>
		<li class="x_form_input">
			<input  name="RemoteDomain"class="inputStyle" type="text" />
		</li>
	</ul>
	</div>
	<ul class="x_form_line" onmouseover="$H('');" onmouseout="$H();">
		<li class="x_form_caption">IPSec WAN<% multilang(LANG_CONNECT_STR);%></li>
		<li class="x_form_input">
			<select name="IPSecOutInterface" class="selectStyle">
          		<%  ipsecSwanWanList();%>
			</select>
		</li>
	</ul>
	<ul class="x_form_line" onmouseover="$H('');" onmouseout="$H();">
		<li class="x_form_caption">IPSec <% multilang(LANG_ENCAP_TYPE);%></li>
		<li class="x_form_input">
			<select name="IPSecEncapsulationMode" class="selectStyle">
				<option value="1" selected>Tunnel</option>
				<option value="2">Transport</option>
			</select>
		</li>
	</ul>
	<ul class="x_form_line" onmouseover="$H('');" onmouseout="$H();">
		<li class="x_form_caption">IKE <% multilang(LANG_VERSION);%></li>
		<li class="x_form_input">
			<select name="IKEVersion" class="selectStyle">
				<option value="0">ALL</option>
				<option value="1">1</option>
				<option value="2" selected>2</option>
			</select>
		</li>
	</ul>
	<ul class="x_form_line" onmouseover="$H('');" onmouseout="$H();">
		<li class="x_form_caption">IKE <% multilang(LANG_NEGO_TYPE);%></li>
		<li class="x_form_input">
			<select name="ExchangeMode" class="selectStyle">
				<option value="1" selected>main</option>
				<option value="2">aggressive</option>
			</select>
		</li>
	</ul>
	<ul class="x_form_line" onmouseover="$H('');" onmouseout="$H();">
		<li class="x_form_caption">IKE <% multilang(LANG_VERIFY_ALGO_VALUE);%></li>
		<li class="x_form_input">
			<select name="IKEAuthenticationAlgorithm" class="selectStyle">
				<option value="1" selected>MD5</option>
				<option value="2">SHA1</option>
			</select>
		</li>
	</ul>
	<ul class="x_form_line" onmouseover="$H('');" onmouseout="$H();">
		<li class="x_form_caption">IKE <% multilang(LANG_VERIFY_TYPE);%></li>
		<li class="x_form_input">
			<select name="IKEAuthenticationMethod" id="IKEAuthenticationMethod" class="selectStyle" onchange="IKEAuthMethodChange();">
				<option value="1" selected>PreShareKey</option>
				<option value="2">RsaSignature</option>
			</select>
		</li>
	</ul>
	<div id="secPsk" style="display: block">
	<ul class="x_form_line" onmouseover="$H('');" onmouseout="$H();">
		<li class="x_form_caption">IKE <% multilang(LANG_PRE_SHARE_KEY);%></li>
		<li class="x_form_input">
			<input name="IKEPreshareKey" class="inputStyle" type="text" onblur="checkit(this)" onfocus="clearit(this)" />
		</li>
	</ul>
	</div>
	<ul class="x_form_line" onmouseover="$H('');" onmouseout="$H();">
		<li class="x_form_caption">IKE <% multilang(LANG_ENCRYPT_ALGO);%></li>
		<li class="x_form_input">
			<select name="IKEEncryptionAlgorithm" class="selectStyle">
				<option value="1" selected>DES</option>
				<option value="2">3DES</option>
				<option value="3">AES128</option>
				<option value="4">AES192</option>
				<option value="5">AES256</option>
			</select>
		</li>
	</ul>
	<ul class="x_form_line" onmouseover="$H('');" onmouseout="$H();">
		<li class="x_form_caption">IKE DH<% multilang(LANG_GROUP);%></li>
		<li class="x_form_input">
			<select name="IKEDHGroup" class="selectStyle">
				<option value="1" selected>Group1</option>
				<option value="2">Group2</option>
				<option value="3">Group5</option>
				<option value="4">Group14</option>
			</select>
		</li>
	</ul>
	<ul class="x_form_line" onmouseover="$H('');" onmouseout="$H();">
		<li class="x_form_caption">IKE <% multilang(LANG_IDENTIFY_TYPE);%></li>
		<li class="x_form_input">
			<select name="IKEIDType" id="IKEIDType" class="selectStyle" onchange="IKEIDTypeChange();">
				<option value="1" selected>IP</option>
				<option value="2">Name</option>
			</select>
		</li>
	</ul>
	<div id="secTypeName" style="display: none">
	<ul class="x_form_line" onmouseover="$H('');" onmouseout="$H();">
		<li class="x_form_caption">IKE <% multilang(LANG_LOCAL_NAME);%></li>
		<li class="x_form_input">
			<input name="IKELocalName" class="inputStyle" type="text" onblur="checkit(this)" onfocus="clearit(this)" />
		</li>
	</ul>
	<ul class="x_form_line" onmouseover="$H('');" onmouseout="$H();">
		<li class="x_form_caption">IKE <% multilang(LANG_REMOTE_NAME);%></li>
		<li class="x_form_input">
			<input name="IKERemoteName" class="inputStyle" type="text" onblur="checkit(this)" onfocus="clearit(this)" />
		</li>
	</ul>
	</div>
	<ul class="x_form_line" onmouseover="$H('');" onmouseout="$H();">
		<li class="x_form_caption">IKE SA Period</li>
		<li class="x_form_input">
			<input  name="IKESAPeriod"class="inputStyle" placeholder="1200-86400s" type="text" value="10800"/>
		</li>
	</ul>
	<ul class="x_form_line" onmouseover="$H('');" onmouseout="$H();">
		<li class="x_form_caption">IPSec <% multilang(LANG_SECUR_PROTOCOL);%></li>
		<li class="x_form_input">
			<select name="IPSecTransform" id = "IPSecTransform" class="selectStyle" onchange="IPSecTransformChange();">
				<option value="1">AH</option>
				<option value="2" selected>ESP</option>
			</select>
		</li>
	</ul>
	<div id="secEsp" style="display: block">
	<ul class="x_form_line" onmouseover="$H('');" onmouseout="$H();">
		<li class="x_form_caption">ESP <% multilang(LANG_VERIFY_ALGO_VALUE);%></li>
		<li class="x_form_input">
			<select name="ESPAuthenticationAlgorithm" class="selectStyle">
				<option value="0">NONE</option>
				<option value="1" selected>MD5</option>
				<option value="2">SHA1</option>
			</select>
		</li>
	</ul>
	<ul class="x_form_line" onmouseover="$H('');" onmouseout="$H();">
		<li class="x_form_caption">ESP <% multilang(LANG_ENCRYPT_ALGO);%></li>
		<li class="x_form_input">
			<select name="ESPEncryptionAlgorithm" class="selectStyle">
				<option value="1">DES</option>
				<option value="2" selected>3DES</option>
				<option value="3">AES128</option>
				<option value="4">AES192</option>
				<option value="5">AES256</option>
			</select>
		</li>
	</ul>
	</div>
	<div id="secAh" style="display: none">
	<ul class="x_form_line" onmouseover="$H('');" onmouseout="$H();">
		<li class="x_form_caption">AH <% multilang(LANG_VERIFY_ALGO_VALUE);%></li>
		<li class="x_form_input">
			<select name="AHAuthenticationAlgorithm" class="selectStyle">
				<option value="1">MD5</option>
				<option value="2">SHA1</option>
			</select>
		</li>
	</ul>
	</div>
	<ul class="x_form_line" onmouseover="$H('');" onmouseout="$H();">
		<li class="x_form_caption">IPSec PFS<% multilang(LANG_GROUP);%></li>
		<li class="x_form_input">
			<select name="IPSecPFS" class="selectStyle">
				<option value="0" selected>NONE</option>
				<option value="1">Group1</option>
				<option value="2">Group2</option>
				<option value="3">Group5</option>
				<option value="4">Group14</option>
			</select>
		</li>
	</ul>
	<ul class="x_form_line" onmouseover="$H('');" onmouseout="$H();">
		<li class="x_form_caption">IPSec SA Time Period</li>
		<li class="x_form_input">
			<input  name="IPSecSATimePeriod"class="inputStyle" placeholder="600-86400s" type="text" value="3600"/>
		</li>
	</ul>
	<ul class="x_form_line" onmouseover="$H('');" onmouseout="$H();">
		<li class="x_form_caption">IPSec SA Traffic Period</li>
		<li class="x_form_input">
			<input  name="IPSecSATrafficPeriod" class="inputStyle" placeholder="2560-536870912Kbytes" type="text" value="1843200"/>
		</li>
	</ul>
	<ul class="x_form_line" onmouseover="$H('');" onmouseout="$H();">
		<li class="x_form_caption">IPSec DPD</li>
		<li class="x_form_input">
			<input type='checkbox' name="DPDEnable" id="DPDEnable" value="ON" onchange="DPDEnableChange();">
		</li>
	</ul>
	<div id="secDpd" style="display: none">
	<ul class="x_form_line" onmouseover="$H('');" onmouseout="$H();">
		<li class="x_form_caption">DPD Threshold</li>
		<li class="x_form_input">
			<input  name="DPDThreshold" class="inputStyle" placeholder="10-3600S" type="text" value="10"/>
		</li>
	</ul>
	<ul class="x_form_line" onmouseover="$H('');" onmouseout="$H();">
		<li class="x_form_caption">DPD Retry</li>
		<li class="x_form_input">
			<input  name="DPDRetry" class="inputStyle" placeholder="2-10S" type="text" value="5"/>
		</li>
	</ul>
	</div>
	
	<script type="text/javascript">WriteDivideLine();</script>
	
	<ul class="x_form_line" onmouseover="$H('');" onmouseout="$H();">
		<li class="x_form_caption"><% multilang(LANG_CONNECT_STATUS);%></li>
		<li class="x_form_input">
			<select name="ConnectionStatus" class="selectStyle" disabled>
				<option value="0" selected>Unconfigured</option>
				<option value="1">PhaseI_Connecting</option>
				<option value="2">PhaseII_Connecting</option>
				<option value="3">Connected</option>
				<option value="4">Disconnecting</option>
				<option value="5">Disconnected</option>
			</select>
		</li>
	</ul>
	
	<div id="div_save" class="x_form_save">
		<input id=btnOK class="btnsaveup" type="button" onclick="return btnSave();" value="<% multilang(LANG_ELINK_SAVE);%>">
		<input id=btnDel class="btnDel" type="button" onclick="return btnDelete();" value="<% multilang(LANG_DELETE);%>">
	</div>
	</div>
	<input name="submit-url" type="hidden" value="/vpn.asp" />
	</form>
	</div>
	
	<script type="text/javascript">WriteMainTitle("IPSec <% multilang(LANG_CREDENT_MANAGMENT);%>", "ipsec_csrt");</script>
	<div id="x_ipsec_csrt" class="x_main_content">
	<div class="x_sub_title">IPSec <% multilang(LANG_CREDENT_MANAGMENT);%></div>
	<div class="x_form_area">
	
	<form action=/boaform/formIPSecSwanGenCert method=POST name="gen_local_cert" id="gen_local_cert">
	
	<ul class="x_form_line" onmouseover="$H('');" onmouseout="$H();">
		<li class="x_form_caption"><% multilang(LANG_UPLOAD);%> ca.cert.pem</li>
		<li class="x_form_input">
			<form action=/boaform/formIPSecSwanCert method=POST enctype="multipart/form-data" name="ipsec_cert">
				<input type="file" value="Choose File" name="binary" size=24>&nbsp;&nbsp;
				<input type="submit" value="Upload" name="load">
			</form>
		</li>
	</ul>
	<ul class="x_form_line" onmouseover="$H('');" onmouseout="$H();">
		<li class="x_form_caption"><% multilang(LANG_UPLOAD);%> ca.pem(<% multilang(LANG_PRIVATE_KEY);%>)</li>
		<li class="x_form_input">
			<form action=/boaform/formIPSecSwanKey method=POST enctype="multipart/form-data" name="ipsec_key">
				<input type="file" value="Choose File" name="binary" size=24>&nbsp;&nbsp;
				<input type="submit" value="Upload" name="load">
				<input type="hidden" name="postSecurityFlag" value="">
			</form>
		</li>
	</ul>
	
	<script type="text/javascript">WriteDivideLine();</script>
	
	<ul class="x_form_line" onmouseover="$H('');" onmouseout="$H();">
		<li class="x_form_caption">Country(C)</li>
		<li class="x_form_input">
			<input name="Country" class="inputStyle" type="text"/>
		</li>
	</ul>
	<ul class="x_form_line" onmouseover="$H('');" onmouseout="$H();">
		<li class="x_form_caption">Organization(O)</li>
		<li class="x_form_input">
			<input name="Organization" class="inputStyle" type="text"/>
		</li>
	</ul>
	<script type="text/javascript">WriteDivideLine();</script>
	<div id="div_save" class="x_form_save">
		<input type="submit" value="<% multilang(LANG_GENERATE_LOCAL_CERDENT);%>" name="generate">
		<input name="submit-url" type="hidden" value="/vpn.asp" />	
	</div>
	
	</form>
	</div>
	</div>
	
	
	
	
	<script type="text/javascript">WriteMainTitle("L2TP <% multilang(LANG_CONFIGURATION);%>", "l2tp");</script>
	<div id="x_l2tp" class="x_main_content">
	<div class="x_sub_title">L2TP Configuration</div>
	<div class="x_form_area">
	
	<form action=/boaform/formL2TP method=POST name="l2tp" id="l2tp">
	<div id="l2tp_type" style=display:none>
	<ul class="x_form_line" onmouseover="$H('');" onmouseout="$H();">
		<li class="x_form_caption">L2TP Type</li>
		<li class="x_form_input">
			<select id="sel_rol" name="ltype" onChange="roleSelect()">
				<option value=0>LAC</option>
				<option value=1>LNS</option>
			</select>
		</li>
	</ul>
	</div>
	<ul class="x_form_line" onmouseover="$H('');" onmouseout="$H();">
		<li class="x_form_caption">L2TP VPN</li>
		<li class="x_form_input">
			<input type="radio" value="0" name="l2tpen" <% checkWrite("l2tpenable0"); %> onClick="onClickL2TPEnable()"><% multilang(LANG_DISABLE); %>&nbsp;&nbsp;
			<input type="radio" value="1" name="l2tpen" <% checkWrite("l2tpenable1"); %> onClick="onClickL2TPEnable()"><% multilang(LANG_ENABLE); %>
		</li>
	</ul>
	<div id="div_save" class="x_form_save">
		<input type="submit" value="<% multilang(LANG_APPLY_CHANGES); %>" onClick="return l2tp_submit(this)">&nbsp;&nbsp;
	</div>
	<input type="hidden" id="lst" name="lst" value="">
	<script type="text/javascript">WriteDivideLine();</script>
	
	<div id="l2tp_lac">
	<div class="x_sub_title">L2TP <% multilang(LANG_CLIENT); %></div>
	<ul class="x_form_line" onmouseover="$H('');" onmouseout="$H();">
		<li class="x_form_caption"><% multilang(LANG_NAME); %></li>
		<li class="x_form_input">
			<input type="text" name="c_name" size="16" maxlength="256">
		</li>
	</ul>
	<div id="l2tp_ipv6" style=display:none>
	<ul class="x_form_line" onmouseover="$H('');" onmouseout="$H();">
		<li class="x_form_caption">IP <% multilang(LANG_PROTOCOL); %></li>
		<li class="x_form_input">
			<select id="IpProtocolType" style="WIDTH: 130px" name="IpProtocolType">
				<option value="1" > IPv4</option>
				<option value="2" > IPv6</option>
			</select>
		</li>
	</ul>
	</div>
	<ul class="x_form_line" onmouseover="$H('');" onmouseout="$H();">
		<li class="x_form_caption"><% multilang(LANG_SERVER); %></li>
		<li class="x_form_input">
			<input type="text" name="server" size="32" maxlength="256">
		</li>
	</ul>
	<ul class="x_form_line" onmouseover="$H('');" onmouseout="$H();">
		<li class="x_form_caption"><% multilang(LANG_TUNNEL_AUTHENTICATION); %></li>
		<li class="x_form_input">
			<input type=checkbox name="tunnel_auth" value=1 onClick=onClickTunnelAuth()>
		</li>
	</ul>
	<ul class="x_form_line" onmouseover="$H('');" onmouseout="$H();">
		<li class="x_form_caption"><% multilang(LANG_TUNNEL_AUTHENTICATION_SECRET); %></li>
		<li class="x_form_input">
			<input type="text" name="tunnel_secret" size="15" maxlength="35">
		</li>
	</ul>
	<ul class="x_form_line" onmouseover="$H('');" onmouseout="$H();">
		<li class="x_form_caption">PPP <% multilang(LANG_AUTHENTICATION); %></li>
		<li class="x_form_input">
			<select name="auth" onChange="pppAuthChange()">
				<option value="0">Auto</option>
				<option value="1">PAP</option>
				<option value="2">CHAP</option>
				<option value="3">CHAPMSV2</option>
			</select>
		</li>
	</ul>
	<ul class="x_form_line" onmouseover="$H('');" onmouseout="$H();">
		<li class="x_form_caption">PPP <% multilang(LANG_ENCRYPTION); %></li>
		<li class="x_form_input">
			<select name="enctype" >
				<option value="0">None</option>
				<option value="1">MPPE</option>
				<option value="2">MPPC</option>
				<option value="3">MPPE&MPPC</option>
			</select>
		</li>
	</ul>
	<ul class="x_form_line" onmouseover="$H('');" onmouseout="$H();">
		<li class="x_form_caption"><% multilang(LANG_USER); %><% multilang(LANG_NAME); %></li>
		<li class="x_form_input">
			<input type="text" name="username" size="15" maxlength="35">
		</li>
	</ul>
	<ul class="x_form_line" onmouseover="$H('');" onmouseout="$H();">
		<li class="x_form_caption"><% multilang(LANG_PASSWORD); %></li>
		<li class="x_form_input">
			<input type="text" name="password" size="15" maxlength="35">
		</li>
	</ul>
	<ul class="x_form_line" onmouseover="$H('');" onmouseout="$H();">
		<li class="x_form_caption">PPP <% multilang(LANG_CONNECTION_TYPE); %></li>
		<li class="x_form_input">
			<select name="pppconntype" onChange="connTypeChange()">
				<option value="0">Persisent</option>
				<option value="1">Diag on demand</option>
				<option value="2">Manual</option>
				<option value="3">None</option>
			</select>
		</li>
	</ul>
	<ul class="x_form_line" onmouseover="$H('');" onmouseout="$H();">
		<li class="x_form_caption"><% multilang(LANG_IDLE_TIME_MIN); %></li>
		<li class="x_form_input">
			<input type="text" name="idletime" size="32" maxlength="256">
		</li>
	</ul>
	<ul class="x_form_line" onmouseover="$H('');" onmouseout="$H();">
		<li class="x_form_caption">MTU</li>
		<li class="x_form_input">
			<input type="text" name="mtu" size="32" maxlength="256" value="1458">
		</li>
	</ul>
	<ul class="x_form_line" onmouseover="$H('');" onmouseout="$H();">
		<li class="x_form_caption"><% multilang(LANG_DEFAULT_GATEWAY); %></li>
		<li class="x_form_input">
			<input type="checkbox" name="defaultgw">
		</li>
	</ul>
	<% l2tpWithIPSecLAC(); %>
	<div id="div_save" class="x_form_save">
		<input type="submit" value="<% multilang(LANG_APPLY_CHANGES); %>" name="addClient" onClick="return addL2TPItf(this)">&nbsp;&nbsp;
	</div>
	<div class="x_sub_title">L2TP <% multilang(LANG_TABLE); %></div>
	<div id="L2tpTableContainer">
	<table class="x_table">
		<tr>
			<th align=center width="3%"><% multilang(LANG_SELECT); %></th>
			<th align=center width="5%"><% multilang(LANG_NAME); %></th>
			<th align=center width="5%"><% multilang(LANG_SERVER); %></th>
			<th align=center width="5%"><% multilang(LANG_TUNNEL_AUTHENTICATION); %></th>
			<th align=center width="5%">PPP <% multilang(LANG_AUTHENTICATION); %></th>
			<th align=center width="5%">MTU</th>
			<th align=center width="5%"><% multilang(LANG_DEFAULT_GATEWAY); %></th>
			<% l2tpWithIPSecLACTable(); %>
			<th align=center width="8%"><% multilang(LANG_ACTION); %></th>
		</tr>
		<% l2tpWuiList(); %>
	</table>
	</div>
	
	<div id="div_save" class="x_form_save">
		<input type="submit" value="<% multilang(LANG_DELETE_SELECTED); %>" name="delSelClient" onClick="return deleteClick(this)">&nbsp;&nbsp;
	</div>
	</div> <!-- l2tp_lac-->
	<div id="l2tp_lns">
	<div class="x_sub_title">L2TP <% multilang(LANG_SERVER); %></div>
	<ul class="x_form_line" onmouseover="$H('');" onmouseout="$H();">
		<li class="x_form_caption"><% multilang(LANG_NAME); %></li>
		<li class="x_form_input">
			<input type="text" name="s_name" size="16" maxlength="256">
		</li>
	</ul>
	<ul class="x_form_line" onmouseover="$H('');" onmouseout="$H();">
		<li class="x_form_caption">PPP <% multilang(LANG_AUTHENTICATION); %></li>
		<li class="x_form_input">
			<select name="s_auth" onChange="pppAuthChange_lns()">
				<option value="0">Auto</option>
				<option value="1">PAP</option>
				<option value="2">CHAP</option>
				<option value="3">MS-CHAPV2</option>
			</select>
		</li>
	</ul>
	<ul class="x_form_line" onmouseover="$H('');" onmouseout="$H();">
		<li class="x_form_caption">PPP <% multilang(LANG_ENCRYPTION); %></li>
		<li class="x_form_input">
			<select name="s_enctype" >
				<option value="0">None</option>
				<option value="1">MPPE</option>
				<option value="2">MPPC</option>
				<option value="3">MPPE&MPPC</option>
			</select>
		</li>
	</ul>
	<ul class="x_form_line" onmouseover="$H('');" onmouseout="$H();">
		<li class="x_form_caption"><% multilang(LANG_TUNNEL_AUTHENTICATION); %></li>
		<li class="x_form_input">
			<input type="checkbox" name="s_tunnelAuth" value="1" onClick="onClickTunnelAuth_lns()">
		</li>
	</ul>
	<ul class="x_form_line" onmouseover="$H('');" onmouseout="$H();">
		<li class="x_form_caption"><% multilang(LANG_TUNNEL_AUTHENTICATION_SECRET); %></li>
		<li class="x_form_input">
			<input type="text" name="s_authKey" size="16" maxlength="256">
		</li>
	</ul>
	<ul class="x_form_line" onmouseover="$H('');" onmouseout="$H();">
		<li class="x_form_caption">Peer Address</li>
		<li class="x_form_input">
			<input type="text" name="peeraddr" size="16" maxlength="80">
		</li>
	</ul>
	<ul class="x_form_line" onmouseover="$H('');" onmouseout="$H();">
		<li class="x_form_caption">Peer End Address</li>
		<li class="x_form_input">
			<input type="text" name="peerendaddr" size="16" maxlength="80">
		</li>
	</ul>
	<ul class="x_form_line" onmouseover="$H('');" onmouseout="$H();">
		<li class="x_form_caption">Local Address</li>
		<li class="x_form_input">
			<input type="text" name="localaddr" size="16" maxlength="80">
		</li>
	</ul>
	<% l2tpWithIPSecLNS(); %>
	<div id="div_save" class="x_form_save">
		<input type="submit" value="<% multilang(LANG_APPLY_CHANGES); %>" name="addServer" onClick="return setL2tpServer(this)">
	</div>
	
	<div class="x_sub_title">Server Account</div>
	<ul class="x_form_line" onmouseover="$H('');" onmouseout="$H();">
		<li class="x_form_caption"><% multilang(LANG_NAME); %></li>
		<li class="x_form_input">
			<select id="s_accout_name" name="s_accout_name">
				<% lns_name_list(); %>
			</select>
		</li>
	</ul>
	<ul class="x_form_line" onmouseover="$H('');" onmouseout="$H();">
		<li class="x_form_caption">Tunnel</li>
		<li class="x_form_input">
			<input type="radio" value="0" name="tunnelen"><% multilang(LANG_DISABLE); %>&nbsp;&nbsp;
			<input type="radio" value="1" name="tunnelen" checked><% multilang(LANG_ENABLE); %>
		</li>
	</ul>
	<ul class="x_form_line" onmouseover="$H('');" onmouseout="$H();">
		<li class="x_form_caption"><% multilang(LANG_USER); %><% multilang(LANG_NAME); %></li>
		<li class="x_form_input">
			<input type="text" name="s_username" size="16" maxlength="256">
		</li>
	</ul>
	<ul class="x_form_line" onmouseover="$H('');" onmouseout="$H();">
		<li class="x_form_caption"><% multilang(LANG_PASSWORD); %></li>
		<li class="x_form_input">
			<input type="text" name="s_password" size="16" maxlength="256">
		</li>
	</ul>
	<div id="div_save" class="x_form_save">
		<input type="submit" value="<% multilang(LANG_ADD); %>" name="addAccount" onClick="return addL2tpAccount(this)">
	</div>
	<div class="x_sub_title">L2TP Server Table</div>
	<div id="L2tpLNSTableContainer">
	<table class="x_table">
		<tr>
			<th align=center><% multilang(LANG_SELECT); %></th>
			<th align=center><% multilang(LANG_NAME); %></th>
			<th align=center><% multilang(LANG_ENABLE); %></th>
			<th align=center><% multilang(LANG_USERNAME); %></th>
			<th align=center><% multilang(LANG_PASSWORD); %></th>
		</tr>
		<% l2tpServerList(); %>
	</table>
	</div>
	<div id="div_save" class="x_form_save">
		<input type="submit" value="<% multilang(LANG_DELETE_SELECTED); %>" name="delSelAccount" onClick="return deleteClick(this)">&nbsp;&nbsp;
	</div>
	</div> <!-- l2tp_lns-->
	<input type="hidden" name=lns_en value=0>
	<input type="hidden" name=ipv6_en value=0>
	<input type="hidden" name="encodePassword" value="">
	<input type="hidden" name="encodepskValueLAC" value="">
	<input type="hidden" name="encodeSPassword" value="">
	<input type="hidden" name="encodepskValueLNS" value="">
	<input type="hidden" value="/vpn.asp" name="submit-url">
	</form>
	</div>
	</div>
	
	<script type="text/javascript">WriteMainTitle("VxLAN<% multilang(LANG_CONFIGURATION);%>", "vxlan_connection");</script>
	<div id="x_vxlan_connection" class="x_main_content">
	<div class="x_sub_title">VxLAN <% multilang(LANG_PRIVILEGE);%></div>
	<div class="x_form_area">
	<form action="/boaform/admin/formVxlan" method=POST name="vxlan_connection" id="vxlan_connection">
	<script type="text/javascript">WriteDivideLine();</script>
	<ul class="x_form_line" onmouseover="$H('');" onmouseout="$H();">
		<li class="x_form_caption">VxLAN vni</li>
		<li class="x_form_input">
			<input name="tunnel_key" class="inputStyle" type="text"/>
		</li>
	</ul>
	<ul class="x_form_line" onmouseover="$H('');" onmouseout="$H();">
		<li class="x_form_caption"><% multilang(LANG_ENABLE_DNS);%></li>
		<li class="x_form_input">
			<input type='checkbox' name='enable' checked>
		</li>
	</ul>
	<ul class="x_form_line" onmouseover="$H('');" onmouseout="$H();">
		<li class="x_form_caption"><% multilang(LANG_TUNNEL_DST_ADDR);%></li>
		<li class="x_form_input">
			<input  name="tunnel_dst_ip" class="inputStyle" placeholder="" type="text" />
		</li>
	</ul>
	<ul class="x_form_line" onmouseover="$H('');" onmouseout="$H();">
		<li class="x_form_caption"><% multilang(LANG_OPERATION_MODE);%></li>
		<li class="x_form_input">
			<select id="work_mode" name="work_mode" onchange=onSelectWorkMode()>
				<option value="1"> <% multilang(LANG_LAYER2_MODE);%>
				<option value="2" selected> <% multilang(LANG_LAYER3_MODE);%>
			</select>
		</li>
	</ul>
	<div id="addressing_type_div" style=display:block>
	<ul class="x_form_line" onmouseover="$H('');" onmouseout="$H();">
		<li class="x_form_caption"><% multilang(LANG_ADDR_TYPE);%></li>
		<li class="x_form_input">
			<select id="addressing_type" name="addressing_type" onchange=onSelectAddrMode()>
				<option value="1" selected> DHCP
				<option value="2"> Static
			</select>
		</li>
	</ul>
	</div>
	<div id="ip_addr_div" style=display:none>
	<ul class="x_form_line" onmouseover="$H('');" onmouseout="$H();">
		<li class="x_form_caption"><% multilang(LANG_IP_ADDRESS);%></li>
		<li class="x_form_input">
			<input  name="ip_addr" class="inputStyle" placeholder="" type="text" />
		</li>
	</ul>
	</div>
	<div id="subnet_mask_div" style=display:none>
	<ul class="x_form_line" onmouseover="$H('');" onmouseout="$H();">
		<li class="x_form_caption"><% multilang(LANG_SUBNET_MASK);%></li>
		<li class="x_form_input">
			<input  name="subnet_mask" class="inputStyle" placeholder="" type="text" />
		</li>
	</ul>
	</div>
	<div id="default_gateway_div" style=display:none>
	<ul class="x_form_line" onmouseover="$H('');" onmouseout="$H();">
		<li class="x_form_caption"><% multilang(LANG_GATEWAY);%></li>
		<li class="x_form_input">
			<input  name="default_gateway" class="inputStyle" placeholder="" type="text" />
		</li>
	</ul>
	</div>
	<div id="nat_enable_div" style=display:none>
	<ul class="x_form_line" onmouseover="$H('');" onmouseout="$H();">
		<li class="x_form_caption"><% multilang(LANG_ENABLE);%>NAT</li>
		<li class="x_form_input">
			<input type='checkbox' name='nat_enable' checked>
		</li>
	</ul>
	</div>
	<div id="dns_server_master_div" style=display:none>
	<ul class="x_form_line" onmouseover="$H('');" onmouseout="$H();">
		<li class="x_form_caption"><% multilang(LANG_PRIMARY_DNS);%></li>
		<li class="x_form_input">
			<input  name="dns_server_master" class="inputStyle" placeholder="" type="text" />
		</li>
	</ul>
	</div>
	<div id="dns_server_slave_div" style=display:none>
	<ul class="x_form_line" onmouseover="$H('');" onmouseout="$H();">
		<li class="x_form_caption"><% multilang(LANG_SECONDARY_DNS);%></li>
		<li class="x_form_input">
			<input  name="dns_server_slave" class="inputStyle" placeholder="" type="text" />
		</li>
	</ul>
	</div>
	<ul class="x_form_line" onmouseover="$H('');" onmouseout="$H();">
		<li class="x_form_caption"><% multilang(LANG_ENABLE);%>VLAN</li>
		<li class="x_form_input">
			<input type='checkbox' name='vlan_enable'>
		</li>
	</ul>
	<ul class="x_form_line" onmouseover="$H('');" onmouseout="$H();">
		<li class="x_form_caption">VLAN ID</li>
		<li class="x_form_input">
			<input  name="vlan" class="inputStyle" placeholder="" type="text" />
		</li>
	</ul>

	 <ul class="x_form_line" onmouseover="$H('<% multilang(LANG_BINDING_PORT);%>.');" onmouseout="$H();">
	  <li class="x_form_caption"><% multilang(LANG_BINDING_PORT);%></li>
	  <li class="x_form_input">
	   <% ShowPortMapping(); %>
	  </li>
	 </ul>
	<div id="wlan_table_1" style="display: none;">
	<ul class="x_form_line" onmouseover="$H('SSID <% multilang(LANG_BINDING_PORT);%>.');" onmouseout="$H();">
	 <li class="x_form_caption">SSID <% multilang(LANG_BINDING_PORT);%>：</li>
	 <li class="x_form_input">
	  <SPAN id=secWireless1 style="float:left;">
		<input id=cb_bindwireless1 type=checkbox name=cb_bindwireless1 >
		<label>SSID1 &nbsp;</label>
		<input id=bindwireless1 type=hidden value=0 name=bindwireless1>
	  </SPAN>
	  <SPAN id=secWireless2 style="float:left;">
				 <input id=cb_bindwireless2 type=checkbox name=cb_bindwireless2 >
				 <label>SSID2 &nbsp;</label>
				 <input id=bindwireless2 type=hidden value=0 name=bindwireless2>
				</SPAN>
	  <SPAN id=secWireless3 style="float:left;">
				 <input id=cb_bindwireless3 type=checkbox name=cb_bindwireless3 >
				 <label>SSID3 &nbsp;</label>
				 <input id=bindwireless3 type=hidden value=0 name=bindwireless3>
	  </SPAN>
	 </li>
	</ul>
	</div>
	<div id="wlan_table_2" style="display: none;">
	<ul class="x_form_line" onmouseover="$H('SSID <% multilang(LANG_BINDING_PORT);%>.');" onmouseout="$H();" >
	<li class="x_form_caption"></li>
	<li class="x_form_input">
	<SPAN id=secWirelessac1 style="float:left;">
				<input id=cb_bindwirelessac1 type=checkbox name=cb_bindwirelessac1 >
				<label>SSID5 &nbsp;</label>
				<input id=bindwirelessac1 type=hidden value=0 name=bindwirelessac1>
			</SPAN>
	<SPAN id=secWirelessac2 style="float:left;">
				<input id=cb_bindwirelessac2 type=checkbox name=cb_bindwirelessac2 >
				<label>SSID6 &nbsp;</label>
				<input id=bindwirelessac2 type=hidden value=0 name=bindwirelessac2>
			</SPAN>
	<SPAN id=secWirelessac3 style="float:left;">
				<input id=cb_bindwirelessac3 type=checkbox name=cb_bindwirelessac3 >
				<label>SSID7 &nbsp;</label>
				<input id=bindwirelessac3 type=hidden value=0 name=bindwirelessac3>
			</SPAN>
	</li>
	</ul>
	</div>
	<ul class="x_form_line" onmouseover="$H('');" onmouseout="$H();">
		<li class="x_form_caption"><% multilang(LANG_BIND_WAN_PORT);%></li>
		<li class="x_form_input">
			<select name="wan_interface" class="selectStyle">
				<% if_wan_list("rt"); %>
			</select>
		</li>
	</ul>
	<div id="div_save" class="x_form_save">
		<input type="submit" value="<% multilang(LANG_ADD); %>" name="addVxLAN" onClick="return vxlanCheck(this)">
	</div>

	<div class="x_sub_title">VxLAN Table</div>
	<div id="vxlanTableContainer">
	<table class="x_table" id="lstrc">
		<tr>
			<th align=center>select</th>
			<th align=center>VNI</th>
			<th align=center><% multilang(LANG_MAC_MAP_ENABLE);%></th>
			<th align=center><% multilang(LANG_TUNNEL_DST_ADDR);%></th>
			<th align=center><% multilang(LANG_OPERATION_MODE);%></th>
			<th align=center><% multilang(LANG_ADDR_TYPE);%></th>
			<th align=center>VXLAN <% multilang(LANG_IP_ADDRESS);%></th>
			<th align=center><% multilang(LANG_ENABLE);%>vlan</th>
			<th align=center><% multilang(LANG_BIND_WAN_PORT);%></th>
		</tr>
	</table>
	<div id="div_save" class="x_form_save">
		<input type="submit" value="<% multilang(LANG_DELETE_SELECTED); %>" name="delVxLAN" onClick="return deleteVxlanClick(this)">&nbsp;&nbsp;
	</div>
	</div>
	<input type="hidden" id="action" name="action" value="add">
	<input type="hidden" value="/vpn.asp" name="submit-url">
	</form>
	</div>
	</div>
	<!-- insert form here-->
	
	
	</div>
	</div>
	</div>
</body>
</html>
