<% cmccEnterpriseHtmlCommonHead();%>
<style type="text/css">

</style>

<script type="text/javascript">

<% initProductInfo(); %>

var WifiShareCfg = {};
var WifiConfig = {};
var WifiSsidCfg = [{}, {}, {}, {}];
var WifiRadiusIf = [];
var WifiSsidConfig = [{}, {}, {}, {}];
WifiShareCfg.enable = 0;
WifiShareCfg.ssid_index = 1;
WifiShareCfg.sta_isolation = 0;
WifiShareCfg.port_isolation = 0;
WifiShareCfg.enable_userid = 0;
WifiShareCfg.userid = "";
WifiConfig.cur_ssid = 0;
WifiConfig.mode = 0;
WifiConfig.txrate = 0;
WifiConfig.txpower = 1;
WifiConfig.wpspin = <% getInfo("wscLoocalPin"); %>;
WifiConfig.mesh_enable = 0;
WifiConfig.swq_atm_enable = 0;
WifiConfig.sr_enable = 0;
WifiConfig.sr_autoconfig = 0;
WifiConfig.sr_opmode_select_ac = 0;
WifiConfig.sr_mesh_psk_gen_enable = 0;
WifiConfig.sta_control_enable = 0;
WifiConfig.stactrl_prefer_band_value = 0;
WifiConfig.bandsteering_status = 0;
WifiConfig.protection = 0;
<% listWlan5GMainStatus(); %>
</script>

<script type="text/javascript">
//<![CDATA[

Ont.CurMainMenu = "network";
Ont.CurSubMenu  = "wifi";

function WebInit()
{
	wifi_web_init();
	
	$("#band").change(function() {
		setWifiMode();
	});
		
	$("#ssid_idx").change(function() {
		doSsidSel();
	});
		
	$("#wpaSSID").change(function() {
		$("#ssid_idx").val($("#wpaSSID").val());
		doSsidSel();
	});
	
	$("#security_method").change(function() {
		doSecSel();
	});
	
	$("#ssid_wps").change(function() {
		doWpsSel();
	});
	
	$("#ssid_wps_mode").change(function() {
		doWpsModeSel();
	});
	
	$("#generate_pin_type").change(function() {
		selectPinType();
	});
	
	$("#btn_generate").click(function() {
		generatePin();
	});
	
	$("#wpsconnect").click(function() {
		wpscommit();
	});
	
	$("#share_enable").click(function() {
		enableWlanShare();
	});
	
	$("#pwstate").click(function() {
		pwstate_change();
	});
	
	$("#btn_save").click(function() {
		wifi_web_submit();
	});

	$("#smart_roaming_enable").change(function() {
		sr_enable_change();
	});

	$("#sta_control").change(function() {
		stactrlPreBandChange();
	});
	
	$("#dot11kEnabled").change(function() {
		wlDot11kChange();
	});
}

function sr_enable_change()
{
	if($("#smart_roaming_enable").val() == "1")
		$("#div_sr_autoconfig").show();
	else
		$("#div_sr_autoconfig").hide();
}

function stactrlPreBandChange()
{
	if(Ont.bandsteering_support == 1){
		if($("#sta_control").val() == "1")	
			$("#stactrl_prefer_band").attr("disabled", false);
		else
			$("#stactrl_prefer_band").attr("disabled", true);
	}	
}

function wlDot11kChange()
{
	if(Ont.dot11v_support == 1)
	{
		if($("#dot11kEnabled").val() == "1")
			$("#div_11v").show();
		else
			$("#div_11v").hide();
	}
}

function pwstate_change()
{
	if (true != $("#pwstate").is(":checked"))
	{
		$("#wep_key0")[0].type = "password";
		$("#wep_key1")[0].type = "password";
		$("#wep_key2")[0].type = "password";
		$("#wep_key3")[0].type = "password";	
		$("#pskValue")[0].type = "password";
		$("#ent_key")[0].type = "password";
	}
	else
	{
		$("#wep_key0")[0].type = "text";
		$("#wep_key1")[0].type = "text";
		$("#wep_key2")[0].type = "text";
		$("#wep_key3")[0].type = "text";	
		$("#pskValue")[0].type = "text";
		$("#ent_key")[0].type = "text";
	}
}

function ValidChecksum(PIN)
{
	var accum = 0;
	
	accum += 3 * (Math.floor(PIN / 10000000) % 10);
	accum += 1 * (Math.floor(PIN / 1000000) % 10);
	accum += 3 * (Math.floor(PIN / 100000) % 10);	
	accum += 1 * (Math.floor(PIN / 10000) % 10);	
	accum += 3 * (Math.floor(PIN / 1000) % 10);	
	accum += 1 * (Math.floor(PIN / 100) % 10);	
	accum += 3 * (Math.floor(PIN / 10) % 10);
	accum += 1 * (Math.floor(PIN / 1) % 10);

	return (0 == (accum % 10));
}

function AutoCompleteZeroPIN(PIN)
{
    var pin_val;
    if      ((PIN < 100000000) && (PIN >= 10000000))
    {                              
        pin_val = PIN;        
    }  
    else if ((PIN < 10000000) && (PIN >= 1000000))
    {                                            
        pin_val = "0" + PIN;         
    }                                       
    else if ((PIN < 1000000) && (PIN >= 100000))
    {                                      
        pin_val = "00" + PIN;      
    }                                              
    else if ((PIN < 100000) && (PIN >= 10000))
    {
        pin_val = "000" + PIN;      
    }
    else if ((PIN < 10000) && (PIN >= 1000))
    {
        pin_val = "0000" + PIN;      
    }
    else if ((PIN < 1000) && (PIN >= 100))
    {
        pin_val = "00000" + auto_pin;      
    }
    else if ((PIN < 100) && (PIN >= 10))
    {
        pin_val = "000000" + PIN;      
    }
    else if ((PIN < 10) && (PIN >= 1))
    {
        pin_val = "0000000" + PIN;      
    }
    else
    {
        pin_val = "00000000";
    }
    return pin_val;
}

function ComputeChecksum(PIN)
{
	var accum = 0;
	var digit = 0;
	
	PIN = PIN * 10;
	accum += 3 * (Math.floor(PIN / 10000000) % 10);
	accum += 1 * (Math.floor(PIN / 1000000) % 10);
	accum += 3 * (Math.floor(PIN / 100000) % 10);	
	accum += 1 * (Math.floor(PIN / 10000) % 10);	
	accum += 3 * (Math.floor(PIN / 1000) % 10);	
	accum += 1 * (Math.floor(PIN / 100) % 10);	
	accum += 3 * (Math.floor(PIN / 10) % 10);
	digit = accum % 10;
	return (10 - digit) % 10;
}

function selectPinType()
{
	if ($("#generate_pin_type").val() != 1)
	{
        $("#ssid_wps_pin").attr("disabled", false);			
	}
	else
	{
        $("#ssid_wps_pin").attr("disabled", true);			
	}
}

function generatePin()
{  
    var auto_pin = 0;
    var lowest_bit = 0;
    var high_seven_bit = 0;
    var temp_random = 0;

    temp_random = Math.random();
    high_seven_bit = Math.floor(temp_random * 10000000);
    lowest_bit = ComputeChecksum(high_seven_bit);
    auto_pin = high_seven_bit * 10 + lowest_bit;

	$("#ssid_wps_pin").val(AutoCompleteZeroPIN(auto_pin));
}

function doWpsSel()
{
	if ($("#ssid_wps").get(0).selectedIndex == 1)
	{
		$("#ssid_wps_mode").attr("disabled", false);
		$("#generate_pin_type").attr("disabled", false);
		$("#ssid_wps_pin").val(WifiConfig.wpspin);
		if ($("#ssid_wps_mode").val() == 0)
		{
			$("#ssid_wps_pin").attr("disabled", true);
		}
		else
		{
			$("#ssid_wps_pin").attr("disabled", false);
		}
	}
	else
	{
		$("#ssid_wps_mode").attr("disabled", true);
		$("#ssid_wps_pin").attr("disabled", true);
		$("#generate_pin_type").attr("disabled", true);
	}
	doWpsModeSel();
}

function doWpsModeSel()
{
	if ($("#ssid_wps_mode").get(0).selectedIndex == 1)
	{
		$("#generate_pin_type").attr("disabled", false);
		$("#ssid_wps_pin").attr("disabled", false);
		$("#btn_generate").attr("disabled", false);
	}
	else
	{
		$("#generate_pin_type").attr("disabled", true);
		$("#ssid_wps_pin").attr("disabled", true);
		$("#btn_generate").attr("disabled", false);
	}
}

function doSecSel()
{
	var index = $("#security_method").get(0).selectedIndex;
	if (index == 0)
	{
		$("#div_wep").hide();
		$("#div_per").hide();
		$("#div_ent").hide();
	}
	else if (index == 1)
	{
		$("#div_per").hide();
		$("#div_ent").hide();
		$("#div_wep").show();
		$("#ssid_wps").get(0).selectedIndex = 0;
	}
	else
	{
		$("#div_per").show();
		$("#div_ent").hide();
		$("#div_wep").hide();
	}
	
	RecalcHelpHeight();

}

function isSsidNameUnsafe(compareChar)
{
	var unsafeString = "\\\"\'";

	if (unsafeString.indexOf(compareChar) == -1 )
	{
		return false; // found no unsafe chars, return false
	}
	else
	{
		return true;
	}
}

function isValidSsidName(ssidname)
{
	var i = 0;
	
	for (i = 0; i < ssidname.length; i++)
	{
		if (isSsidNameUnsafe(ssidname.charAt(i)) == true)
			return false;
	}
	return true; 
}

function doCheckValue()
{
	if(top.window.XWebCurTrdMenuId == "wlan_cfg")
	{
		if ($("#ssid_name_sub").val().length == 0)
		{
			alert("ssid name should not be NULL");
			$("#ssid_name").focus();
			return false ;
		}
		if (false == isValidSsidName($("#ssid_name").val()))
		{
			alert("ssid name have invalid character");
			$("#ssid_name").focus();
			return false ;
		}
	}
	
	if(top.window.XWebCurTrdMenuId == "wifi_advance")
	{
		var dtimPeriod = $("#dtimPeriod").val();
		if (dtimPeriod > 255 || dtimPeriod < 1)
		{
			alert("<% multilang(LANG_INVALID_VALUE_OF_DTIM_PRERIOD_INPUT_VALUE_SHOULD_BE_BETWEEN_1_255_IN_DECIMAL);%>.");
			return false ;
		}
	
		var fragThreshold = $("#fragThreshold").val();
		if (fragThreshold > 2346 || fragThreshold < 256)
		{
			alert("<% multilang(LANG_INVALID_VALUE_OF_FRAGMENT_THRESHOLD_INPUT_VALUE_SHOULD_BE_BETWEEN_256_2346_IN_DECIMAL);%>.");
			return false ;
		}
	
		var rtsThreshold = $("#rtsThreshold").val();
		if (rtsThreshold > 2347 || rtsThreshold < 0)
		{
			alert("<% multilang(LANG_INVALID_VALUE_OF_RTS_THRESHOLD_INPUT_VALUE_SHOULD_BE_BETWEEN_0_2347_IN_DECIMAL);%>.");
			return false ;
		}
	}
	var ssid_index = $("#ssid_idx").get(0).selectedIndex;
	
	var index = $("#security_method").get(0).selectedIndex;
	if(top.window.XWebCurTrdMenuId != "div_security")
	{
		return true;
	}
	
	if (index == 0)
		return true;
	else if (index == 1)
	{
		var keyIndex = $("#defaultKeyidx").val();
		if ((keyIndex < 0) || (keyIndex > 3))
		{
		    alert("<% multilang(LANG_WEP_KEY_INDEX_ERROR);%>");
			return false;
		}
		//if ($("#wep_key" + keyIndex + "_len").val() == "0")
		//{
		//    alert("您所选择的wep key index为" + $("#defaultKeyidx").val() + ",　请启用 wep密码" + $("#defaultKeyidx").val());
		//	$("#wep_key" + j).focus();
		//	return false;
		//}
	    //for (j = 0; j < 4; j++)
		{
		    if ($("#length0").val() == "0")  //40 bit
			{
			    if ( ($("#wep_key" + keyIndex).val() == "") 
					|| (($("#wep_key" + keyIndex).val().length != 10) && ($("#wep_key" + keyIndex).val().length != 5)))
				{
					alert("<% multilang(LANG_PASSWORD);%> " + keyIndex + " <% multilang(LANG_10_HEX_OR_5_CHAR);%>");
					$("#wep_key" + keyIndex).focus();
					return false;
				}
			    else
				{
					if ($("#wep_key" + keyIndex).val().length == 10)
					{
						if (!isValidHexKey($("#wep_key" + keyIndex).val(), 10))
						{
							alert("<% multilang(LANG_PASSWORD);%> " + keyIndex + " <% multilang(LANG_INCLUDE_ILLEGAL_HEX);%>");
							$("#wep_key" + keyIndex).focus();
							return false;
						}
					}
				}
			}
			else if ($("#length0").val() == "1")  //104 bit
			{
				if (($("#wep_key" + keyIndex).val() == "") 
					|| ($("#wep_key" + keyIndex).val().length != 13) && ($("#wep_key" + keyIndex).val().length != 26))
				{
					alert("<% multilang(LANG_PASSWORD);%> " + keyIndex + " <% multilang(LANG_26HEX_OR_13_CHAR);%>");
					$("#wep_key" + keyIndex).focus();
					return false;
				}
				else
				{
					if ($("#wep_key" + keyIndex).val().length == 26)
					{
						if (!isValidHexKey($("#wep_key" + keyIndex).val(), 26))
						{
							alert("<% multilang(LANG_PASSWORD);%> " + keyIndex + " <% multilang(LANG_INCLUDE_ILLEGAL_HEX);%>");
							$("#wep_key" + keyIndex).focus();
							return false;
						}
					}
				}
			}
		}
	}
	else
	{
		if ($("#pskValue").val().length < 8 || $("#pskValue").val().length > 64)
		{
			alert("<% multilang(LANG_PASSWORD_LENGTH_SHOULD);%>8-64");
			$("#pskValue").focus();
			return false;
		}
		else if ($("#pskValue").val().length == 64)
		{
			if (!isValidHexKey($("#pskValue").val(), 64))
			{
				alert("<% multilang(LANG_INCLUDE_ILLEGAL_HEX);%>");
				$("#pskValue").focus();
				return false;
			}
		}
	}
}

function wifi_web_submit()
{
	if (false == doCheckValue())
		return;
	
	$("#ssid_name").val($("#ssid_name_sub").val());
	$("#share_enable").attr("disabled", false);
	$("#share_ssid").attr("disabled", false);
	$("#share_portisolation").attr("disabled", false);
	$("#share_staisolation").attr("disabled", false);
	$("#share_userid_enable").attr("disabled", false)
	$("#share_userid").attr("disabled", false);
	
	$("#XForm").submit();
}

function wpspincheck(pin)
{
	var i = 0;

	if (pin == '' || pin.length != 8)
	{
		alert("<% multilang(LANG_INPUT_NIC_8_PIN_CODE);%>");
		return false;
	}

	for (i = 0; i < 8; i++)
	{
		if (pin[i] < 0 || pin[i] > 9)
		{
			alert("<% multilang(LANG_INVALID_PIN_THE_DEVICE_PIN_MUST_BE_NUMERIC_DIGITS);%>");
			return false;
		}
	}

	return true;
}

function wpscommit()
{
	if ($("#ssid_wps").val() == 0)
	{
		alert("<% multilang(LANG_WPS_NOT_ENABLE_YET);%>");
		return;
	}
	if ($("#ssid_wps_mode").val() == 1)
	{
		wpspincheck($("#ssid_wps_pin").val());
	}

	$("#wpsmode").val($("#ssid_wps_mode").val());
	$("#wpspin").val($("#ssid_wps_pin").val());
	$("#action").val("1");
	$("#XForm").submit();
}

function enableWlanShare()
{
	if ($("#share_enable").prop("checked") == true)
	{
		$("#share_ssid").attr("disabled", false);
		$("#share_staisolation").attr("disabled", false);
		$("#share_portisolation").attr("disabled", false);
		$("#share_userid_enable").attr("disabled", false);
		$("#share_userid").attr("disabled", false);
	}
	else
	{
		$("#share_ssid").attr("disabled", true);
		$("#share_staisolation").attr("disabled", true);
		$("#share_portisolation").attr("disabled", true);
		$("#share_userid_enable").attr("disabled", true);
		$("#share_userid").attr("disabled", true);
	}
}

function InitWlanShare()
{
	$("#share_enable").attr("checked", (1 == WifiShareCfg.enable) ? true : false);
	$("#share_ssid").val(WifiShareCfg.ssid_index);
	$("#share_staisolation").attr("checked", (1 == WifiShareCfg.sta_isolation) ? true : false);
	$("#share_portisolation").attr("checked", (1 == WifiShareCfg.port_isolation) ? true : false);
	$("#share_userid_enable").attr("checked", (1 == WifiShareCfg.enable_userid) ? true : false);
	$("#share_userid").val(WifiShareCfg.userid);
	
	if (1 != WifiShareCfg.enable)
	{
		$("#share_ssid").attr("disabled", true);
		$("#share_staisolation").attr("disabled", true);
		$("#share_portisolation").attr("disabled", true);
		$("#share_userid_enable").attr("disabled", true);
		$("#share_userid").attr("disabled", true);
	}
}

function wifi_web_init()
{
	var i,ssid_num;
	$("#div_wlan_share").hide();
	$("#wlanEnabled").attr("checked", (WifiConfig.enable == 1) ? true : false);
	$("#band").val(WifiConfig.mode);
	//$("#country").get(0).selectedIndex = WifiConfig.country;
	$("#chan").val(WifiConfig.channel);
	$("#chanwid").val(WifiConfig.chanwid);
	$("#dtimPeriod").val(WifiConfig.dtimPeriod);
	$("#fragThreshold").val(WifiConfig.fragThreshold);
	$("#rtsThreshold").val(WifiConfig.rtsThreshold);
	$("#beaconInterval").val(WifiConfig.beaconInterval);
	$("#protection").get(0).selectedIndex = WifiConfig.protection;
	
	if(Ont.mesh_support == 0)
		$("#div_mesh").hide();
	else
	{
		$("#mesh_enable").get(0).selectedIndex = WifiConfig.mesh_enable;
		$("#swq_atm_enable").get(0).selectedIndex = WifiConfig.swq_atm_enable;
	}
	if(Ont.rtk_smart_support == 0)
	{
		$("#div_sr").hide();
		$("#div_sr_autoconfig").hide();
	}
	else
	{
		$("#smart_roaming_enable").get(0).selectedIndex = WifiConfig.sr_enable;
		$("#SR_AutoConfig_enable").get(0).selectedIndex = WifiConfig.sr_autoconfig;
		$("#SR_opmode_select_ac").get(0).selectedIndex = WifiConfig.sr_opmode_select_ac;
		$("#SR_mesh_psk_gen_enable").get(0).selectedIndex = WifiConfig.sr_mesh_psk_gen_enable;
		if(WifiConfig.sr_enable == 0)
			$("#div_sr_autoconfig").hide();
	}

	if(Ont.bandsteering_support == 0)
		$("#div_bandsteering").hide();
	else{
		$("#sta_control").get(0).selectedIndex = WifiConfig.sta_control_enable;
		$("#stactrl_prefer_band").get(0).selectedIndex = WifiConfig.stactrl_prefer_band_value;
		stactrlPreBandChange();
		if(WifiConfig.bandsteering_status == 0){
			$("#sta_control").attr("disabled", true);
			$("#stactrl_prefer_band").attr("disabled", true);
		}
			
	}

	setWifiMode();
	//doAddChanOptions();
	$("#txrate").get(0).selectedIndex = WifiConfig.txrate;
	if (WifiConfig.txpower >= 0 && WifiConfig.txpower <= 5)
		$("#txpower").get(0).selectedIndex = WifiConfig.txpower;
	else
		$("#txpower").get(0).selectedIndex = 0;
	
	switch(Ont.SsidWebControl)
	{
        case 1:
            ssid_num=1;
            break;
        case 3 :
            ssid_num=2;
            break;
        case 7:
            ssid_num=3;
            break;
        case 15:
            ssid_num=4;
            break;
        default: 
        	ssid_num=1;
    }
	if(Ont.CurLoginUser==1)
	{
		ssid_num=1;
		//$("#wifi_advance").hide();
	}
	else
	{
		ssid_num=3;
	}
	$("#ssid_idx").empty();
	$("#wpaSSID").empty();
	for(i=0;i<ssid_num;i++)
	{	
		var name="SSID"+((i+1).toString());
		$("#ssid_idx").append("<option value='"+(i)+"'>"+name+"</option>");
		$("#wpaSSID").append("<option value='"+(i)+"'>"+name+"</option>");
	}	
	$("#ssid_idx").val(WifiConfig.cur_ssid);
	$("#wpaSSID").val(WifiConfig.cur_ssid);
	$("#pwstate").attr("checked", false);
	InitWlanShare();
	doSsidSel();
	doWpsSel();
	pwstate_change();
	initMBSSID();
}

function initMBSSID()
{
	//SSID5 info
	$("#enable_ssid5").attr("checked", (WifiSsidCfg[0].ssid_enable == 1) ? true : false);
	$("#hidenssid_ssid5").attr("checked", (WifiSsidCfg[0].broadcast == 1) ? true : false);
	$("#userisolation_ssid5").attr("checked", (WifiSsidCfg[0].user_isolation == 1) ? true : false);	
	$("#wmmenable_ssid5").attr("checked", (WifiSsidCfg[0].wmm_enable == 1) ? true : false);
	$("#wmfenable_ssid5").attr("checked", (WifiSsidCfg[0].wmf_enable == 1) ? true : false);
	$("#stanum_ssid5").val(WifiSsidCfg[0].sta_num);	

	//SSID6 info
	$("#enable_ssid6").attr("checked", (WifiSsidCfg[1].ssid_enable == 1) ? true : false);
	$("#hidenssid_ssid6").attr("checked", (WifiSsidCfg[1].broadcast == 1) ? true : false);
	$("#userisolation_ssid6").attr("checked", (WifiSsidCfg[1].user_isolation == 1) ? true : false);	
	$("#wmmenable_ssid6").attr("checked", (WifiSsidCfg[1].wmm_enable == 1) ? true : false);
	$("#wmfenable_ssid6").attr("checked", (WifiSsidCfg[1].wmf_enable == 1) ? true : false);
	$("#stanum_ssid6").val(WifiSsidCfg[1].sta_num);		
	
	//SSID7 info
	$("#enable_ssid7").attr("checked", (WifiSsidCfg[2].ssid_enable == 1) ? true : false);
	$("#hidenssid_ssid7").attr("checked", (WifiSsidCfg[2].broadcast == 1) ? true : false);
	$("#userisolation_ssid7").attr("checked", (WifiSsidCfg[2].user_isolation == 1) ? true : false);	
	$("#wmmenable_ssid7").attr("checked", (WifiSsidCfg[2].wmm_enable == 1) ? true : false);
	$("#wmfenable_ssid7").attr("checked", (WifiSsidCfg[2].wmf_enable == 1) ? true : false);
	$("#stanum_ssid7").val(WifiSsidCfg[2].sta_num);
}

function doSsidSel()
{
	var ssid_index = $("#ssid_idx").get(0).selectedIndex;
	
	$("#wpaSSID").val($("#ssid_idx").val());
    $("#ssid_name").val(WifiSsidCfg[ssid_index].ssid_name);
	$("#ct_ssid").val(WifiSsidCfg[ssid_index].prefix);
	$("#ct_ssid").attr("disabled", true);
	$("#ssid_name_sub").val(WifiSsidCfg[ssid_index].ssid_name);
	$("#enableSSID").get(0).selectedIndex = WifiSsidCfg[ssid_index].ssid_enable;
	$("#hiddenSSID").get(0).selectedIndex = WifiSsidCfg[ssid_index].broadcast;
	$("#ssid_isolation").get(0).selectedIndex = WifiSsidCfg[ssid_index].ssid_isolation;
	$("#ssid_wps").get(0).selectedIndex = WifiSsidCfg[ssid_index].wps_enable;
	$("#security_method").get(0).selectedIndex = WifiSsidCfg[ssid_index].security_mode;
	$("#defaultKeyidx").get(0).selectedIndex = WifiSsidCfg[ssid_index].wepKeyIndex;
	$("#length0").get(0).selectedIndex = WifiSsidCfg[ssid_index].wepKeyLen;
	$("#wep_key0").val(WifiSsidCfg[ssid_index].wepKey[0]);
	$("#wep_key1").val(WifiSsidCfg[ssid_index].wepKey[1]);
	$("#wep_key2").val(WifiSsidCfg[ssid_index].wepKey[2]);
	$("#wep_key3").val(WifiSsidCfg[ssid_index].wepKey[3]);
	$("#pskValue").val(WifiSsidCfg[ssid_index].perKey);
	$("#ent_server").val(WifiSsidCfg[ssid_index].entServer);
	$("#ent_port").val(WifiSsidCfg[ssid_index].entPort.toString());
	$("#ent_key").val(WifiSsidCfg[ssid_index].entKey);
	$("#WmmEnabled").get(0).selectedIndex = WifiSsidCfg[ssid_index].wmm_enable;
	if (WifiSsidCfg[ssid_index].wps_enable == 1)
	{
		$("#ssid_wps_mode").attr("disabled", false);
		if ($("#ssid_wps_mode").val() == 1)
			$("#ssid_wps_pin").attr("disabled", false);
		else
			$("#ssid_wps_pin").attr("disabled", true);
	}
	else
	{
		$("#ssid_wps_mode").attr("disabled", true);
		$("#ssid_wps_pin").attr("disabled", true);
	}
	if (WifiSsidCfg[ssid_index].security_mode == 0)
	{
		$("#div_wep").hide();
		$("#div_per").hide();
		$("#div_ent").hide();
	}
	else if (WifiSsidCfg[ssid_index].security_mode == 1)
	{
		$("#div_wep").show();
		$("#div_per").hide();
		$("#div_ent").hide();
		$("#auth_type").get(0).selectedIndex = WifiSsidCfg[ssid_index].auth_type;
		var real_wep_key = WifiSsidCfg[ssid_index].wepKeyIndex - 1;

	}
	else if (WifiSsidCfg[ssid_index].security_mode == 2 || WifiSsidCfg[ssid_index].security_mode == 3 || WifiSsidCfg[ssid_index].security_mode == 4)
	{
		$("#div_wep").hide();
		$("#div_per").show();
		$("#div_ent").hide();
		$("#ciphersuite").get(0).selectedIndex = WifiSsidCfg[ssid_index].perEntype;
		$("#pskValue").val(WifiSsidCfg[ssid_index].perKey);
	}
	else
	{
        $("#div_wep").hide();
		$("#div_per").hide();
		$("#div_ent").show();
		$("#ent_version").get(0).selectedIndex = WifiSsidCfg[ssid_index].entVersion;
		$("#ent_entype").get(0).selectedIndex = WifiSsidCfg[ssid_index].entEntype;
		$("#ent_server").val(WifiSsidCfg[ssid_index].entServer);
		$("#ent_port").val(WifiSsidCfg[ssid_index].entPort.toString());
		$("#ent_key").val(WifiSsidCfg[ssid_index].entKey);
	}

	$("#div_wps").hide();
	
	if(Ont.mesh_support == 1){
		$("#tx_restrict").val(WifiSsidCfg[ssid_index].tx_restrict);
		$("#rx_restrict").val(WifiSsidCfg[ssid_index].rx_restrict);
	}
	else{
		$("#div_restrict").hide();
	}

	if(Ont.dot11k_support == 1){
		$("#dot11kEnabled").get(0).selectedIndex = WifiSsidCfg[ssid_index].dot11k_enable;
	}
	else{
		$("#div_11k").hide();
	}

	if(Ont.dot11v_support == 1){
		$("#dot11vEnabled").get(0).selectedIndex = WifiSsidCfg[ssid_index].dot11v_enable;
		if(WifiSsidCfg[ssid_index].dot11k_enable == 0)
			$("#div_11v").hide();
		else
			$("#div_11v").show();
	}
	else{
		$("#div_11v").hide();
	}
	
	RecalcHelpHeight();
}

function setWifiMode()
{
	var aryChannelWidth = ["20MHZ", "40MHZ", "80MHZ"];
	var wifi_mode = $("#band").val();
    var chanwid = $("#chanwid").val();
		
	if (3 == wifi_mode || 7 == wifi_mode || 11 == wifi_mode)
    {
		aryChannelWidth = ["20MHZ", "40MHZ"];
		$("#chanwid").empty();
		$.each(aryChannelWidth, function(li, lv) {
			$("<option></option>").val(li).text(lv).appendTo("#chanwid");
		});
		$("#chanwid").val(chanwid);
    }
	else if (63 == wifi_mode || 71 == wifi_mode || 75 == wifi_mode)
    {
		aryChannelWidth = ["20MHZ", "40MHZ", "80MHZ"];
		$("#chanwid").empty();
		$.each(aryChannelWidth, function(li, lv) {
			$("<option></option>").val(li).text(lv).appendTo("#chanwid");
		});
		$("#chanwid").val(chanwid);
    }
	else
	{
		aryChannelWidth = ["20MHZ"];
		$("#chanwid").empty();
		$.each(aryChannelWidth, function(li, lv) {
			$("<option></option>").val(li).text(lv).appendTo("#chanwid");
		});
		$("#chanwid").val(0);
	}
}
function SelectShareSsid()
{
}

//]]>
</script>

<script type="text/javascript">

$(function() {
	if (window.top.location.href == window.location.href)
	{
		window.location.href = "/index.html";
		return;
	}

	$.each(Ont.MainMenu, function(mi, mv){
		if (mv.id == Ont.CurMainMenu)
		{
			/*
			if (mv.id == "help")
			{
				initHelpMenu(mv.submenu);
			}
			*/
			$.each(mv.submenu, function(smi, smv){
				if (smv.id == Ont.CurSubMenu)
				{
					if (!isSubMenuShow(smv))
					{
						window.top.location.href = "/admin/login.asp";
					}
					return false;
				}
			});
			return false;
		}
	});

	window.Ont.InitProvince();

	WriteMainMenu();
	WriteSubMenu();
	WebInit();
	initMainContent();

	$S("XWebPageName", Ont.CurSubMenu);
	$("#XForm").attr("action", "/boaform/admin/formEntWlanSetup");

	setTimeout(function(){window.top.location.href = "logout.html";}, Ont.LogoutTimeout);
	
	$("#logout").click(function() {
		window.top.location.href = "logout.html";
	});
	
	$("#btn_cancel").click(function() {
		onCancel();
	});

	$("#login_username").html(Ont.CurUserName);
	$("#logout").html(Ont.StrLogout);
	//$("#ont_name").html(Ont.StrOntName);
	//$("#ont_model").html(Ont.StrOntModel.replace("/(^_*)|(_*$)/g", ""));

	$(".x_table tr:nth-child(even)").addClass("even");
	$(".x_table tr:nth-child(odd)").addClass("odd");
	var webdevicename=Ont.Webdevicename + "<% multilang(LANG_INTEGRATED_ENTERPRISE_GATEWAY);%>";
	$("#device_name").html(webdevicename);
});

function onCancel()
{
	window.location.reload();
}

function updateSsidTable()
{
	var ssid_index = $("#ssid_idx").get(0).selectedIndex;

	if(ssid_index==0)
	{
		$("#enable_ssid5").attr("checked", ($("#enableSSID").get(0).selectedIndex == 1) ? true : false);
		$("#hidenssid_ssid5").attr("checked", ($("#hiddenSSID").get(0).selectedIndex == 1) ? true : false);
	}
	else if(ssid_index==1)
	{
		$("#enable_ssid6").attr("checked", ($("#enableSSID").get(0).selectedIndex == 1) ? true : false);
		$("#hidenssid_ssid6").attr("checked", ($("#hiddenSSID").get(0).selectedIndex == 1) ? true : false);
	}
	else if(ssid_index==2)
	{
		$("#enable_ssid7").attr("checked", ($("#enableSSID").get(0).selectedIndex == 1) ? true : false);
		$("#hidenssid_ssid7").attr("checked", ($("#hiddenSSID").get(0).selectedIndex == 1) ? true : false);
	}
}

function updateRootSsid()
{
	var ssid_index = $("#ssid_idx").get(0).selectedIndex;
	var item_enable_ssid, item_hidden_ssid;

	if(ssid_index==0)
	{
		item_enable_ssid = document.getElementById("enable_ssid5");
		item_hidden_ssid = document.getElementById("hidenssid_ssid5");
	}
	else if(ssid_index==1)
	{
		item_enable_ssid = document.getElementById("enable_ssid6");
		item_hidden_ssid = document.getElementById("hidenssid_ssid6");
	}
	else if(ssid_index==2)
	{
		item_enable_ssid = document.getElementById("enable_ssid7");
		item_hidden_ssid = document.getElementById("hidenssid_ssid7");
	} 

	if(item_enable_ssid.checked == true)
		$("#enableSSID").get(0).selectedIndex = 1;
	else
		$("#enableSSID").get(0).selectedIndex = 0;
	if(item_hidden_ssid.checked == true)
		$("#hiddenSSID").get(0).selectedIndex = 1;
	else
		$("#hiddenSSID").get(0).selectedIndex = 0;
}

</script>
</head>
<body id="x_root_body">

<div id="header">
	<div id="logo"></div>
	<div id="header_info">
		<div id="dev_info"><% multilang(LANG_TERM_MODEL);%>：<span id="device_name"></span></div>
		<div id="user_info"><% multilang(LANG_WELCOME);%>，<span id="login_username">admin</span>
		<a href="#" id="logout"></a>
		</div>
	</div>
</div>

<div id="menu">
	<div id="main_menu"></div>
</div>

<div id="container">

<div id="nav">
	<div id="nav_header"></div>
	<div id="sub_menu"></div>
</div>

<div id="maincontent">

<div id="content" style="height: 1140px;">
<div id="errmessage" class="x_message"></div>
<form id="XForm" name="XForm" method="post" action="">
<input id="XWebPageName" name="XWebPageName" type="hidden" value="" />



<script type="text/javascript">WriteMainTitle("WLAN <% multilang(LANG_BASIC_CONFIGURATION);%>", "wlan_cfg");</script>
<div id="x_wlan_cfg" class="x_main_content">

<div class="x_sub_title">WLAN <% multilang(LANG_BASIC_CONFIGURATION);%></div>
<div class="x_form_area">

	<ul class="x_form_line" onmouseover="$H('<% multilang(LANG_ENABLE);%>/<% multilang(LANG_DISABLE);%>');" onmouseout="$H();">
		<li class="x_form_caption"><% multilang(LANG_ENABLE);%>：</li>
		<li class="x_form_input"><input type="checkbox" id="wlanEnabled" name="wlanEnabled" value="ON" /></li>
	</ul>
	
<div id="mode_chan_select">
	<ul class="x_form_line" onmouseover="$H('<% multilang(LANG_SELECT);%> WiFi <% multilang(LANG_OPERATION_MODE);%>');" onmouseout="$H();">
		<li class="x_form_caption"><% multilang(LANG_CHOICE_MODE);%>：</li>
		<li class="x_form_input">
		<select id="band" name="band">
		<option value="3" selected="selected">5 GHz (A)</option>
		<option value="7">5 GHz (N)</option>
		<option value="11">5 GHz (A+N)</option>
		<option value="63">5 GHz (AC)</option>
		<option value="71">5 GHz (N+AC)</option>
		<option value="75">5 GHz (A+N+AC)</option>
		</select></li>
	</ul>
<!--
	<ul class="x_form_line" onmouseover="$H('选择所属国家');" onmouseout="$H();">
		<li class="x_form_caption">国家选择:</li>
		<li class="x_form_input"><select id="country" name="country" onchange="doAddChanOptions();">
		<option value="0" selected="selected">中国</option>
		<option value="1" >美国</option>
		<option value="2" >日本</option>
		<option value="3" >欧洲</option>
		</select></li>
	</ul>
-->
	<ul class="x_form_line" onmouseover="$H('<% multilang(LANG_CHANNEL_NUMBER);%>');" onmouseout="$H();">
		<li class="x_form_caption"><% multilang(LANG_CHANNEL_NUMBER);%>：</li>
		<li class="x_form_input">
			<select id="chan" name="chan" style="width:60px">
				<option value="0" selected="selected"><% multilang(LANG_AUTO);%></option>
				<option value="36" selected="selected">36</option>
				<option value="40" selected="selected">40</option>
				<option value="44" selected="selected">44</option>
				<option value="48" selected="selected">48</option>
				<option value="52" selected="selected">52</option>
				<option value="56" selected="selected">56</option>
				<option value="60" selected="selected">60</option>
				<option value="64" selected="selected">64</option>
				<option value="149" selected="selected">149</option>
				<option value="153" selected="selected">153</option>
				<option value="157" selected="selected">157</option>
				<option value="161" selected="selected">161</option>
				<option value="165" selected="selected">165</option>
			</select>
		</li>
	</ul>
</div>

<div id="div_chanwid">
	<ul class="x_form_line" onmouseover="$H('<% multilang(LANG_FREQUENCY_BANDWIDTH);%>');" onmouseout="$H();">
		<li class="x_form_caption"><% multilang(LANG_FREQUENCY_BANDWIDTH);%>：</li>
		<li class="x_form_input">
			<select id="chanwid" name="chanwid">
				<option value="0" selected="selected">20MHZ</option>
				<option value="1">40MHZ</option>
				<option value="2">80MHZ</option>
			</select>
		</li>
	</ul>
</div>

	<ul class="x_form_line" onmouseover="$H('<% multilang(LANG_CHOICE_CONFIGURATION);%>SSID');" onmouseout="$H();">
		<li class="x_form_caption">SSID <% multilang(LANG_TABLE);%>：</li>
		<li class="x_form_input">
			<select id="ssid_idx" name="ssid_idx" style="width:60px">
				<option value="0" selected="selected">SSID5</option>
			</select>
		</li>
	</ul>
	<ul class="x_form_line" onmouseover="$H('SSID <% multilang(LANG_NAME);%> .');" onmouseout="$H();">
		<li class="x_form_caption">SSID <% multilang(LANG_NAME);%>：</li>
		<li class="x_form_input">
			<input type="text" id="ct_ssid" style="width:100px" />
			<input type="text" id="ssid_name_sub" style="width:120px" maxlength="32" onkeypress="return OnKeyPress(event, X_INPUT_SSID);" />
			<input type="hidden" id="ssid_name" name="ssid_name" />
		</li>
	</ul>
	<ul class="x_form_line" onmouseover="$H('SSID <% multilang(LANG_MAC_MAP_ENABLE);%>.');" onmouseout="$H();">
		<li class="x_form_caption">SSID <% multilang(LANG_MAC_MAP_ENABLE);%>：</li>
		<li class="x_form_input"><select id="enableSSID" name="enableSSID" style="width:60px" onChange="updateSsidTable()">
		<option value="0" selected="selected"><% multilang(LANG_DISABLED);%></option>
		<option value="1"><% multilang(LANG_WLAN_SCHEDULE_ENA);%></option>
		</select></li>
	</ul>
	<ul class="x_form_line" onmouseover="$H('SSID <% multilang(LANG_BROADCAST);%>.');" onmouseout="$H();">
		<li class="x_form_caption">SSID <% multilang(LANG_BROADCAST);%>：</li>
		<li class="x_form_input"><select id="hiddenSSID" name="hiddenSSID" style="width:60px" onChange="updateSsidTable()">
		<option value="0" selected="selected"><% multilang(LANG_WLAN_SCHEDULE_ENA);%></option>
		<option value="1"><% multilang(LANG_DISABLED);%></option>
		</select></li>
	</ul>
	<div>
	<ul class="x_form_line" onmouseover="$H('SSID <% multilang(LANG_ISOLATION);%>.');" onmouseout="$H();">
		<li class="x_form_caption">SSID <% multilang(LANG_ISOLATION);%>：</li>
		<li class="x_form_input"><select id="ssid_isolation" name="ssid_isolation" style="width:60px" >
		<option value="0" selected="selected"><% multilang(LANG_DISABLED);%></option>
		<option value="1"><% multilang(LANG_WLAN_SCHEDULE_ENA);%></option>
		</select>
		</li>
	</ul>
	</div>
	<div id="div_restrict">
	<ul class="x_form_line" onmouseover="$H('SSID <% multilang(LANG_RATE_LIMIT1);%>.');" onmouseout="$H();">
		<li class="x_form_caption">SSID <% multilang(LANG_RATE_LIMIT1);%>：</li>
		<li class="x_form_input">
		TX <input type="text" id="tx_restrict" name="tx_restrict" style="text-align:right;width:60px" >(Mbps)
		RX <input type="text" id="rx_restrict" name="rx_restrict" style="text-align:right;width:60px" >(Mbps)
		</li>
	</ul>
	</div>
	<br>
	<div style="width: 200px;text-align: left;font-size: 15px;line-height: 30px;margin-left: 1px;font-weight:bold;"><% multilang(LANG_WIFI_GUEST);%>/<% multilang(LANG_VIRTUAL_AP);%></div>
	<div>
		<ul class="x_form_line">
			<table class="x_table_2" id="x_AP">
				<tr>
					<th><% multilang(LANG_WLAN_SCHEDULE_ENA);%></th>
					<th>SSID</th>
					<th><% multilang(LANG_HIDE);%></th>
					<th><% multilang(LANG_CLIENT_ISOLATION);%></th>
					<th><% multilang(LANG_DISABLED);%> WMM</th>
					<th><% multilang(LANG_WLAN_SCHEDULE_ENA);%> WMF</th>
					<th><% multilang(LANG_MAX_CLIENT_NUMBERS);%></th>
					<th>BSSID</th>
				</tr>
				<tr>
					<td><input type="checkbox" id="enable_ssid5" name="enable_ssid5" value="ON" onChange="updateRootSsid()"/></td>
					<td><% getInfo("ssidName5"); %></td>
					<td><input type="checkbox" id="hidenssid_ssid5" name="hidenssid_ssid5" value="ON" onChange="updateRootSsid()"/></td>
					<td><input type="checkbox" id="userisolation_ssid5" name="userisolation_ssid5" value="ON"/></td>
					<td><input type="checkbox" id="wmmenable_ssid5" name="wmmenable_ssid5" value="ON"/></td>
					<td><input type="checkbox" id="wmfenable_ssid5" name="wmfenable_ssid5" value="ON"/></td>
					<td><input type="text" id="stanum_ssid5" name="stanum_ssid5"/></td>
					<td><% getInfo("bssid5"); %></td>
				</tr>
				<tr>
					<td><input type="checkbox" id="enable_ssid6" name="enable_ssid6" value="ON" onChange="updateRootSsid()"/></td>
					<td><% getInfo("ssidName6"); %></td>
					<td><input type="checkbox" id="hidenssid_ssid6" name="hidenssid_ssid6" value="ON" onChange="updateRootSsid()"/></td>
					<td><input type="checkbox" id="userisolation_ssid6" name="userisolation_ssid6" value="ON"/></td>
					<td><input type="checkbox" id="wmmenable_ssid6" name="wmmenable_ssid6" value="ON"/></td>
					<td><input type="checkbox" id="wmfenable_ssid6" name="wmfenable_ssid6" value="ON"/></td>
					<td><input type="text" id="stanum_ssid6" name="stanum_ssid6"/></td>
					<td><% getInfo("bssid6"); %></td>
				</tr>
				<tr>
					<td><input type="checkbox" id="enable_ssid7" name="enable_ssid7" value="ON" onChange="updateRootSsid()"/></td>
					<td><% getInfo("ssidName7"); %></td>
					<td><input type="checkbox" id="hidenssid_ssid7" name="hidenssid_ssid7" value="ON" onChange="updateRootSsid()"/></td>
					<td><input type="checkbox" id="userisolation_ssid7" name="userisolation_ssid7" value="ON"/></td>
					<td><input type="checkbox" id="wmmenable_ssid7" name="wmmenable_ssid7" value="ON"/></td>
					<td><input type="checkbox" id="wmfenable_ssid7" name="wmfenable_ssid7" value="ON"/></td>
					<td><input type="text" id="stanum_ssid7" name="stanum_ssid7"/></td>
					<td><% getInfo("bssid7"); %></td>
				</tr>
			</table>
		</ul>
		<br><br><br><br><br><br><br><br>
	</div>

</div>
</div>

<script type="text/javascript">WriteMainTitle("WLAN <% multilang(LANG_SECURITY);%>", "div_security");</script>
<div id="x_div_security" class="x_main_content">

<div class="x_sub_title">WLAN <% multilang(LANG_SECURITY);%></div>
<div class="x_form_area">
	<ul class="x_form_line" onmouseover="$H('<% multilang(LANG_CHOICE_CONFIGURATION);%>SSID');" onmouseout="$H();">
		<li class="x_form_caption">SSID <% multilang(LANG_TABLE);%>：</li>
		<li class="x_form_input">
			<select id="wpaSSID" name="wpaSSID" style="width:60px">
				<option value="0" selected="selected">SSID1</option>
			</select>
		</li>
	</ul>
	<ul class="x_form_line" onmouseover="$H('<% multilang(LANG_ENCRYPT_MODE);%>.');" onmouseout="$H();">
		<li class="x_form_caption"><% multilang(LANG_ENCRYPT_MODE);%>：</li>
		<li class="x_form_input"><select id="security_method" name="security_method">
		<option value="0" selected="selected">OPEN</option>
		<option value="1">WEP</option>
		<option value="2">WPA</option>
		<option value="3">WPA2</option>
		<option value="4">WPA-PSK/WPA2-PSK</option>
		</select>
		</li>
	</ul>

<div id="div_wep">

	<ul class="x_form_line" onmouseover="$H('WEP <% multilang(LANG_ENCRYPT_MODE);%>.');" onmouseout="$H();">
		<li class="x_form_caption">WEP <% multilang(LANG_ENCRPYT_MODE);%>：</li>
		<li class="x_form_input"><select id="auth_type" name="auth_type" >
		<option value="0" selected="selected"><% multilang(LANG_OPEN_MODE);%></option>
		<option value="1" ><% multilang(LANG_SHARE_MODE);%></option>
		<option value="2" ><% multilang(LANG_OPEN_MODE);%>/<% multilang(LANG_SHARE_MODE);%></option>
		</select></li>
	</ul>
	<ul class="x_form_line" onmouseover="$H('wep <% multilang(LANG_ENCRYPT_KEY_INDEX);%>.');" onmouseout="$H();">
		<li class="x_form_caption">WEP Key Index：</li>
		<li class="x_form_input"><select id="defaultKeyidx" name="defaultKeyidx" style="width:60px">
		<option value="0" selected="selected">1</option>
		<option value="1">2</option>
		<option value="2">3</option>
		<option value="3">4</option>
		</select></li>
	</ul>
	<ul class="x_form_line" onmouseover="$H('<% multilang(LANG_PASSWORD_FORMAT);%>.');" onmouseout="$H();">
		<li class="x_form_caption">WEP Key Type：</li>
		<li class="x_form_input"><select id="length0" name="length0" style="width:70px">
		<option value="0" selected="selected">64<% multilang(LANG_CHARACTER_NUM);%></option>
		<option value="1">128<% multilang(LANG_CHARACTER_NUM);%></option>
		</select></li>
	</ul>
	<ul class="x_form_line" onmouseover="$H('<% multilang(LANG_ENTER_PASSWORD);%>1.');" onmouseout="$H();">
		<li class="x_form_caption">WEP <% multilang(LANG_PASSWORD);%>1：</li>
		<li class="x_form_input"><input type="text" id="wep_key0" name="wep_key0" style="width:200px" maxlength="26" onkeypress="return OnKeyPress(event, X_INPUT_PASSWD);"/></li>
	</ul>

	<ul class="x_form_line" onmouseover="$H('<% multilang(LANG_ENTER_PASSWORD);%>2.');" onmouseout="$H();">
		<li class="x_form_caption">WEP <% multilang(LANG_PASSWORD);%>2：</li>
		<li class="x_form_input"><input type="text" id="wep_key1" name="wep_key1" style="width:200px" maxlength="26" onkeypress="return OnKeyPress(event, X_INPUT_PASSWD);"/></li>
	</ul>
	<ul class="x_form_line" onmouseover="$H('<% multilang(LANG_ENTER_PASSWORD);%>3.');" onmouseout="$H();">
		<li class="x_form_caption">WEP <% multilang(LANG_PASSWORD);%>3：</li>
		<li class="x_form_input"><input type="text" id="wep_key2" name="wep_key2" style="width:200px" maxlength="26" onkeypress="return OnKeyPress(event, X_INPUT_PASSWD);"/></li>
	</ul>
	<ul class="x_form_line" onmouseover="$H('<% multilang(LANG_ENTER_PASSWORD);%>4.');" onmouseout="$H();">
		<li class="x_form_caption">WEP <% multilang(LANG_PASSWORD);%>4：</li>
		<li class="x_form_input"><input type="text" id="wep_key3" name="wep_key3" style="width:200px" maxlength="26" onkeypress="return OnKeyPress(event, X_INPUT_PASSWD);"/></li>
	</ul>

</div>


<div id="div_per">
	<ul class="x_form_line" onmouseover="$H('WPA <% multilang(LANG_ENCRYPT_MODE);%>.');" onmouseout="$H();">
        <li class="x_form_caption">WPA <% multilang(LANG_ENCRYPT_MODE);%>：</li>
        <li class="x_form_input"><select id="ciphersuite" name="ciphersuite" style="width:110px">
        <option value="0" selected="selected">TKIP</option>
        <option value="1" >AES</option>
        <option value="2" >TKIP/AES</option>
        </select></li>
	</ul>
	<ul class="x_form_line" onmouseover="$H('<% multilang(LANG_ENTER_PASSWORD);%>.');" onmouseout="$H();">
        <li class="x_form_caption">WPA <% multilang(LANG_PASSWORD);%>：</li>
        <li class="x_form_input"><input type="text" id="pskValue" name="pskValue" style="width:200px" maxlength="64" onkeypress="return OnKeyPress(event, X_INPUT_PASSWD);" /></li>
	</ul>

	<ul class="x_form_line" onmouseover="$H('WPS <% multilang(LANG_MAC_MAP_ENABLE);%>.');" onmouseout="$H();">
        <li class="x_form_caption">WPS <% multilang(LANG_MAC_MAP_ENABLE);%>：</li>
        <li class="x_form_input"><select id="ssid_wps" name="ssid_wps" style="width:60px">
        <option value="0" selected="selected"><% multilang(LANG_DISABLED);%></option>
        <option value="1"><% multilang(LANG_WLAN_SCHEDULE_ENA);%></option>
        </select>
        </li>
	</ul>
	<ul class="x_form_line" onmouseover="$H('WPS <% multilang(LANG_MODE);%>.');" onmouseout="$H();">
        <li class="x_form_caption">WPS <% multilang(LANG_MODE);%>：</li>
        <li class="x_form_input"><select id="ssid_wps_mode" style="width:60px">
        <option value="0" selected="selected">PBC</option>
        <option value="1">PIN</option>
        </select>
        </li>
	</ul>

	<ul class="x_form_line" onmouseover="$H('<% multilang(LANG_GENERATE_PIN_CODE);%><% multilang(LANG_MANUAL_INPUT);%>/<% multilang(LANG_AUTO_GENERATE);%>');" onmouseout="$H();">
		<li class="x_form_caption"><% multilang(LANG_GENERATE_PIN_CODE);%>：</li>
		<li class="x_form_input"><select name="generate_pin_type" id="generate_pin_type">
		<option value="0" selected="selected"><% multilang(LANG_MANUAL);%></option>
		<option value="1"><% multilang(LANG_AUTO);%></option>
		<option value="2"><% multilang(LANG_REMOTE_PIN_CODE);%></option>
		</select>
		</li>
	</ul>
	<ul class="x_form_line" onmouseover="$H('<% multilang(LANG_SELF_PIN_NUMBER);%>');" onmouseout="$H();">
		<li class="x_form_caption"><% multilang(LANG_SELF_PIN_NUMBER);%>：</li>
		<li class="x_form_input"><input type="text" name="ssid_wps_pin" id="ssid_wps_pin" style="width:200px" maxlength="32" />
		<input type="button" id="btn_generate" name="btn_generate" value="<% multilang(LANG_REMOTE_PIN_CODE);%>">
		</li>
	</ul>

	<ul class="x_form_line" onmouseover="$H('WPS <% multilang(LANG_CONNECT_STR);%>');" onmouseout="$H();">
        <li class="x_form_caption"></li>
        <li class="x_form_input"><input type="button" id="wpsconnect" value="WPS <% multilang(LANG_CONNECT_STR);%>" /></li>
	</ul>

</div>

<div id="div_ent">

	<ul class="x_form_line" onmouseover="$H('WPA <% multilang(LANG_VERSION);%>.');" onmouseout="$H();">
		<li class="x_form_caption">WPA <% multilang(LANG_VERSION);%>：</li>
		<li class="x_form_input"><select id="ent_version" name="ent_version" style="width:110px">
		<option value="0" selected="selected">WPA1</option>
		<option value="1" >WPA2</option>
		<option value="2" >WPA1/WPA2</option>
		</select></li>
	</ul>
	<ul class="x_form_line" onmouseover="$H('WPA <% multilang(LANG_ENCRYPT_MODE);%>.');" onmouseout="$H();">
		<li class="x_form_caption">WPA <% multilang(LANG_ENCRYPT_MODE);%>：</li>
		<li class="x_form_input"><select id="ent_entype" name="ent_entype" style="width:110px">
		<option value="0" selected="selected">TKIP</option>
		<option value="1" >AES</option>
		<option value="2" >TKIP/AES</option>
		</select></li>
	</ul>
	<ul class="x_form_line" onmouseover="$H('<% multilang(LANG_PLEASE_INPUT);%> RADIUS <% multilang(LANG_SERVER1);%>.');" onmouseout="$H();">
		<li class="x_form_caption">RADIUS <% multilang(LANG_SERVER1);%>：</li>
		<li class="x_form_input"><input type="text" id="ent_server" name="ent_server" style="width:200px" maxlength="32" onkeypress="return OnKeyPress(event, X_INPUT_ID);" /></li>
	</ul>
	<ul class="x_form_line" onmouseover="$H('<% multilang(LANG_PLEASE_INPUT);%> RADIUS <% multilang(LANG_SERVER_PORT);%>.');" onmouseout="$H();">
		<li class="x_form_caption">RADIUS <% multilang(LANG_LOOP_DETECTION_LAN_PORT);%>：</li>
		<li class="x_form_input">
			<input type="text" id="ent_port" name="ent_port" style="width:60px" maxlength="5" onkeypress="return OnKeyPress(event, X_INPUT_NUM);" />
		</li>
	</ul>
	<ul class="x_form_line" onmouseover="$H('<% multilang(LANG_ENTER_PASSWORD);%>.');" onmouseout="$H();">
		<li class="x_form_caption">WPA <% multilang(LANG_PASSWORD);%>：</li>
		<li class="x_form_input"><input type="text" id="ent_key" name="ent_key" style="width:200px" maxlength="64" onkeypress="return OnKeyPress(event, X_INPUT_PASSWD);" /></li>
	</ul>

</div>

<div id="div_wps">

	<ul class="x_form_line" onmouseover="$H('WPS <% multilang(LANG_MODE);%>.');" onmouseout="$H();">
		<li class="x_form_caption">WPS <% multilang(LANG_MODE);%>：</li>
		<li class="x_form_input"><select id="wpsmode" name="wpsmode" style="width:60px" >
		<option value="0">PBC</option>
		<option value="1">PIN</option>
		<option value="2" selected="selected">NONE</option>
		</select>
		</li>
	</ul>
	<ul class="x_form_line" onmouseover="$H('WPS <% multilang(LANG_CONNECTION);%>');" onmouseout="$H();">
		<li class="x_form_caption"><% multilang(LANG_PIN_CODE);%>：</li>
		<li class="x_form_input"><input type="text" id="wpspin" name="wpspin" style="width:200px" maxlength="8" onkeypress="return OnKeyPress(event, X_INPUT_NUM);" /></li>
	</ul>

</div>

	<ul class="x_form_line" onmouseover="$H('<% multilang(LANG_DISPLAY);%>.');" onmouseout="$H();">
		<li class="x_form_caption"><% multilang(LANG_DISPLAY_PASSWORD);%>:</li>
		<li class="x_form_input"><input type="checkbox" id="pwstate" name="pwstate" onkeypress="return OnKeyPress(event, X_INPUT_PASSWD);" /></li>
	</ul>
	
</div>
</div>

<script type="text/javascript">WriteMainTitle("<% multilang(LANG_WLAN_ADVANCED);%>", "wifi_advance");</script>
<div id="x_wifi_advance" class="x_main_content">

<div class="x_sub_title">WLAN <% multilang(LANG_ADVANCED);%></div>
<div class="x_form_area">
	<ul class="x_form_line" onmouseover="$H('<% multilang(LANG_CHOICE_RATE);%>');" onmouseout="$H();">
		<li class="x_form_caption"><% multilang(LANG_DATA_RATE);%>：</li>
		<li class="x_form_input"><select id="txrate" name="txrate" style="width:60px">
		<option value="0"><% multilang(LANG_AUTO);%></option></select>
		</li>
	</ul>
	<ul class="x_form_line" onmouseover="$H('<% multilang(LANG_TX_POWER_STR);%>');" onmouseout="$H();">
		<li class="x_form_caption"><% multilang(LANG_TX_POWER_STR);%>：</li>
		<li class="x_form_input"><select id="txpower" name="txpower" style="width:60px">
		<option value="0" selected="selected">100%</option>
		<option value="1">80%</option>
		<option value="2">60%</option>
		<option value="3">40%</option>
		<option value="4">20%</option>
		</select></li>
	</ul>
	<ul class="x_form_line" onmouseover="$H('<% multilang(LANG_DTIM_PERIOD);%>');" onmouseout="$H();">
		<li class="x_form_caption"><% multilang(LANG_DTIM_PERIOD);%>：</li>
		<li class="x_form_input">
		 <input name="dtimPeriod" id="dtimPeriod" type="text" size="6" maxlength="3" onkeypress="return OnKeyPress(event, X_INPUT_NUM);" />
		</li>
	</ul>
	<ul class="x_form_line" onmouseover="$H('<% multilang(LANG_BEACON_INTERVAL);%>');" onmouseout="$H();">
	    <li class="x_form_caption"><% multilang(LANG_BEACON_INTERVAL);%>：</li>
	    <li class="x_form_input"><select name="beaconInterval" id="beaconInterval" style="width:60px">
	    <option value="100" selected="selected">100</option>
	    <option value="200">200</option>
		<option value="400">400</option>
		<option value="600">600</option>
		<option value="800">800</option>
		<option value="1000">1000</option>
	    </select></li>
	</ul>
	<ul class="x_form_line" onmouseover="$H('<% multilang(LANG_FRAGMENT_THRESHOLD);%>');" onmouseout="$H();">
		<li class="x_form_caption"><% multilang(LANG_FRAGMENT_THRESHOLD);%>：</li>
		<li class="x_form_input">
		 <input name="fragThreshold" id="fragThreshold" type="text" size="6" maxlength="4" onkeypress="return OnKeyPress(event, X_INPUT_NUM);" />
		</li>
	</ul>
	<ul class="x_form_line" onmouseover="$H('<% multilang(LANG_RTS_THRESHOLD);%>');" onmouseout="$H();">
		<li class="x_form_caption"><% multilang(LANG_RTS_THRESHOLD);%>：</li>
		<li class="x_form_input">
		 <input name="rtsThreshold" id="rtsThreshold" type="text" size="6" maxlength="4" onkeypress="return OnKeyPress(event, X_INPUT_NUM);" />
		</li>
	</ul>
	<ul class="x_form_line" onmouseover="$H('WMM <% multilang(LANG_MAC_MAP_ENABLE);%>');" onmouseout="$H();">
        <li class="x_form_caption">WMM <% multilang(LANG_MAC_MAP_ENABLE);%>：</li>
        <li class="x_form_input"><select id="WmmEnabled" name="WmmEnabled" style="width:60px">
        <option value="0" selected="selected"><% multilang(LANG_DISABLED);%></option>
        <option value="1"><% multilang(LANG_WLAN_SCHEDULE_ENA);%></option>
        </select>
        </li>
	</ul>
	<ul class="x_form_line" onmouseover="$H('802.11n <% multilang(LANG_PROTECTION);%>');" onmouseout="$H();">
        <li class="x_form_caption">802.11n <% multilang(LANG_PROTECTION);%>：</li>
        <li class="x_form_input"><select id="protection" name="protection" style="width:60px">
        <option value="0" selected="selected"><% multilang(LANG_DISABLED);%></option>
        <option value="1"><% multilang(LANG_WLAN_SCHEDULE_ENA);%></option>
        </select>
        </li>
	</ul>
	<div id="div_mesh">
	<ul class="x_form_line" onmouseover="$H('MESH <% multilang(LANG_WLAN_SCHEDULE_ENA);%>');" onmouseout="$H();">
        <li class="x_form_caption">MESH <% multilang(LANG_WLAN_SCHEDULE_ENA);%>：</li>
        <li class="x_form_input"><select id="mesh_enable" name="mesh_enable" style="width:60px">
        <option value="0" selected="selected"><% multilang(LANG_DISABLED);%></option>
        <option value="1"><% multilang(LANG_WLAN_SCHEDULE_ENA);%></option>
        </select>
        </li>
	</ul>
	<ul class="x_form_line" onmouseover="$H('<% multilang(LANG_EMPTY_INTERFACE_FAIR_ENABLE);%>');" onmouseout="$H();">
        <li class="x_form_caption"><% multilang(LANG_EMPTY_INTERFACE_FAIR_ENABLE);%>：</li>
        <li class="x_form_input"><select id="swq_atm_enable" name="swq_atm_enable" style="width:60px">
        <option value="0" selected="selected"><% multilang(LANG_DISABLED);%></option>
        <option value="1"><% multilang(LANG_WLAN_SCHEDULE_ENA);%></option>
        </select>
        </li>
	</ul>
	</div>
	<div id="div_sr">
	<ul class="x_form_line" onmouseover="$H('Smart Roaming <% multilang(LANG_MAC_MAP_ENABLE);%>');" onmouseout="$H();">
        <li class="x_form_caption">Smart Roaming <% multilang(LANG_MAC_MAP_ENABLE);%>：</li>
        <li class="x_form_input"><select id="smart_roaming_enable" name="smart_roaming_enable" style="width:60px">
        <option value="0" selected="selected"><% multilang(LANG_DISABLED);%></option>
        <option value="1"><% multilang(LANG_WLAN_SCHEDULE_ENA);%></option>
        </select>
        </li>
	</ul>
	</div>
	<div id="div_sr_autoconfig">
	<ul class="x_form_line" onmouseover="$H('Smart Roaming<% multilang(LANG_AUTO_CONFIGURATION);%>');" onmouseout="$H();">
        <li class="x_form_caption">Smart Roaming<% multilang(LANG_AUTO_CONFIGURATION);%>：</li>
        <li class="x_form_input"><select id="SR_AutoConfig_enable" name="SR_AutoConfig_enable" style="width:60px">
        <option value="0" selected="selected"><% multilang(LANG_DISABLED);%></option>
        <option value="1"><% multilang(LANG_WLAN_SCHEDULE_ENA);%></option>
        </select>
        </li>
	</ul>
	<ul class="x_form_line" onmouseover="$H('Smart Roaming Opmode AC');" onmouseout="$H();">
        <li class="x_form_caption">Smart Roaming <% multilang(LANG_STATIC_STR);%> AC：</li>
        <li class="x_form_input"><select id="SR_opmode_select_ac" name="SR_opmode_select_ac" style="width:60px">
        <option value="0" selected="selected"><% multilang(LANG_DISABLED);%></option>
        <option value="1"><% multilang(LANG_WLAN_SCHEDULE_ENA);%></option>
        </select>
        </li>
	</ul>
	<ul class="x_form_line" onmouseover="$H('Smart Roaming AC Mesh PSK Generator');" onmouseout="$H();">
        <li class="x_form_caption">SR AC Mesh PSK <% multilang(LANG_GENERATE_STR);%>：</li>
        <li class="x_form_input"><select id="SR_mesh_psk_gen_enable" name="SR_mesh_psk_gen_enable" style="width:60px">
        <option value="0" selected="selected"><% multilang(LANG_DISABLED);%></option>
        <option value="1"><% multilang(LANG_WLAN_SCHEDULE_ENA);%></option>
        </select>
        </li>
	</ul>
	</div>
	<div id="div_bandsteering">
	<ul class="x_form_line" onmouseover="$H('Band Steering');" onmouseout="$H();">
		<li class="x_form_caption">Band Steering：</li>
		<li class="x_form_input"><select id="sta_control" name="sta_control" style="width:60px">
		<option value="0" selected="selected"><% multilang(LANG_DISABLED);%></option>
		<option value="1"><% multilang(LANG_WLAN_SCHEDULE_ENA);%></option>
		</select>
		<select id="stactrl_prefer_band" name="stactrl_prefer_band" style="width:120px">
		<option value="0" selected="selected">Prefer 5GHz</option>
		<option value="1">Prefer 2.4GHz</option>
		</select>
		</li>
	</ul>
	</div>
	<div id="div_11k">
	<ul class="x_form_line" onmouseover="$H('802.11k Support');" onmouseout="$H();">
		<li class="x_form_caption">802.11k Support：</li>
		<li class="x_form_input"><select id="dot11kEnabled" name="dot11kEnabled" style="width:60px">
		<option value="0" selected="selected"><% multilang(LANG_DISABLED);%></option>
		<option value="1"><% multilang(LANG_WLAN_SCHEDULE_ENA);%></option>
		</select>
		</li>
	</ul>
	</div>
	<div id="div_11v">
	<ul class="x_form_line" onmouseover="$H('802.11v Support');" onmouseout="$H();">
		<li class="x_form_caption">802.11v Support：</li>
		<li class="x_form_input"><select id="dot11vEnabled" name="dot11vEnabled" style="width:60px">
		<option value="0" selected="selected"><% multilang(LANG_DISABLED);%></option>
		<option value="1"><% multilang(LANG_WLAN_SCHEDULE_ENA);%></option>
		</select>
		</li>
	</ul>
	</div>
</div>
</div>

<script type="text/javascript">WriteMainTitle("WLAN <% multilang(LANG_SHARE_CONFIGURATION);%>", "div_wlan_share");</script>
<div id="x_div_wlan_share" class="x_main_content">

<div class="x_sub_title">WLAN <% multilang(LANG_SHARE_CONFIGURATION);%></div>
<div class="x_form_area">
	<ul class="x_form_line" onmouseover="$H('<% multilang(LANG_ENABLE_DNS);%>/<% multilang(LANG_DISABLED);%> WLAN <% multilang(LANG_SHARE_CONFIGURATION);%>');" onmouseout="$H();">
		<li class="x_form_caption"><% multilang(LANG_ENABLE_DNS);%>：</li>
		<li class="x_form_input"><input type="checkbox" id="share_enable" name="share_enable" value="1" /></li>
	</ul>
	<div id="div_wlan_share_cfg">
		<ul class="x_form_line" onmouseover="$H(' <% multilang(LANG_CHOICE_TO_SHARE);%> ');" onmouseout="$H();">
			<li class="x_form_caption">SSID <% multilang(LANG_TABLE);%>：</li>
			<li class="x_form_input">
				<select id="share_ssid" name="share_ssid" style="width:70px">
					<option value="1" selected="selected">SSID2</option>
				</select>
			</li>
		</ul>
		<ul class="x_form_line" onmouseover="$H('STA <% multilang(LANG_ISOLATION);%>');" onmouseout="$H();">
			<li class="x_form_caption">STA <% multilang(LANG_ISOLATION);%>：</li>
			<li class="x_form_input"><input type="checkbox" id="share_staisolation" name="share_staisolation" value="1" /></li>
		</ul>
		<ul class="x_form_line" onmouseover="$H('<% multilang(LANG_ISOLATION_WITH_SSID_LAN);%>');" onmouseout="$H();">
			<li class="x_form_caption"><% multilang(LANG_ISOLATION_WITH_SSID_LAN);%>：</li>
			<li class="x_form_input"><input type="checkbox" id="share_portisolation" name="share_portisolation" value="1" /></li>
		</ul>
		<ul class="x_form_line" onmouseover="$H('<% multilang(LANG_ENABLE_SHARE_USER_FLAG);%>');" onmouseout="$H();">
			<li class="x_form_caption"><% multilang(LANG_ENABLE_SHARE_USER_FLAG);%>：</li>
			<li class="x_form_input"><input type="checkbox" id="share_userid_enable" name="share_userid_enable" value="1" /></li>
		</ul>
		<ul class="x_form_line" onmouseover="$H('<% multilang(LANG_USER_FLAG);%>');" onmouseout="$H();">
			<li class="x_form_caption"><% multilang(LANG_USER_FLAG);%>：</li>
			<li class="x_form_input"><input type="text" id="share_userid" name="share_userid" style="width:200px" maxlength="32" />
			</li>
		</ul>
	</div>
</div>

</div>


<div id="div_save" class="x_form_save">
	<input type="hidden" id="action" name="action" value="0">
	<input type="hidden" name="wpaAuth" value="psk">
	<input type="hidden" name="wlan_idx" value=1>
	<input type="hidden" name="mbssid_setting" value=1>
	<input type="hidden" value="/wifi5g.asp" name="submit-url">
	<input type="button" id="btn_save" class="btn_save" value="<% multilang(LANG_CONFIRM);%>" />
	<input type="button" id="btn_cancel" class="btn_cancel" value="<% multilang(LANG_CANCEL);%>" />
</div>

</form>
<div style="clear:both;"></div>

</div> <!-- end of div[content] -->

</div>

</div>

</body>
</html>


