<% SendWebHeadStr(); %>
<!-- <META HTTP-EQUIV=Refresh CONTENT="10; URL=GTARKtest.asp"> -->
<title>ARK Configuration</title>
<script src="jquery-3.2.1.min.js"></script>
<script language="javascript" type="text/javascript">
    var ark_enabled = <% isArkOn(); %>;
	var ark_version = "<% arkVersionGet(); %>";
	var updata_stats_worker = null;

	function ark_apply() {
		var enable = $("input:checked").val();
		$.ajax({
			type: "GET",
			async: false,
			dataType: "json",
			url: "/ark_mode.asp?mode=" + enable,
			contentType: 'application/json; charset=UTF-8',
			data: null,
			success: function (msg) {
			}
		});
	}
	
	function ark_enable() {
		$("#version").text(ark_version);
		$("input[name='arkmode'][value=1]").prop('checked', true);
		$('#stats_table').show();
		updata_stats_worker = setInterval(query_ark_stats, 1000);
		ark_enabled = 1;
	}
	
	function ark_disable() {
		$("#version").text("-");
		$("input[name='arkmode'][value=0]").prop('checked', true);
		$('#stats_table').hide();
		clearInterval(updata_stats_worker);
		ark_enabled = 0;
	}

	function query_ark_status() {
		$.ajax({
			type: "GET",
			async: false,
			dataType: "json",
			url: "/ark_status.asp",
			contentType: 'application/json; charset=UTF-8',
			data: null,
			success: function (msg) {
				// ark on
				if (msg.return == 0 && ark_enabled != 1) {
					ark_version = msg.status.version;
					ark_enable();
				}
				// ark off
				else if (msg.return != 0 && ark_enabled == 1) {
					ark_disable();
				}
				
			}
		});
	}
	
	function query_ark_stats(){
		$.ajax({
			type: "GET",
			async: false,
			dataType: "json",
			url: "/ark_data.asp",
			contentType: 'application/json; charset=UTF-8',
			data: null,
			success: function (msg) {
				if (msg.return == 0) {
					$("#highest_upstream").text(msg.statistics.highest_current[0]);
					$("#highest_downstream").text(msg.statistics.highest_current[1]);
					$("#high_upstream").text(msg.statistics.high_current[0]);
					$("#high_downstream").text(msg.statistics.high_current[1]);
					$("#medium_upstream").text(msg.statistics.medium_current[0]);
					$("#medium_downstream").text(msg.statistics.medium_current[1]);
					$("#low_upstream").text(msg.statistics.low_current[0]);
					$("#low_downstream").text(msg.statistics.low_current[1]);
				}
			},
			error: function (request, error) {
				//console.log(" Can't do because: " + error);
			}
		});
	}
	

	$(function(){
		if (ark_enabled)
			ark_enable();
		else
			ark_disable();
			
		setInterval(query_ark_status, 1000);
	});
	
</script>
</head>

<!-- web ui  -->

<body>
<div class="intro_main">
    <p class="intro_title">ARK QoS Configuration</p>
</div>

    <div class="column">
        <div class="column_title">
            <div class="disabled"></div>
                <p>Settings</p>
            <div class="column_title_right"></div>
        </div>
    </div>
    <div class="data_common">
        <table>
            <tbody>
                <tr>
                    <th>ARK Version:</th>
                    <td id="version"></td>
                </tr>
				<tr>
                    <th>ARK QoS:</th>
                    <td>
						<input id="arkmodedis" type="radio" name="arkmode" value=0>Disable
						<input id="arkmodeen" type="radio" name="arkmode" value=1>Enable
					</td>
                </tr>
            </tbody>
        </table>
    </div>
    <div class="btn_ctl">
        <input class="link_bg" type="button" value="Apply Changes" onClick="ark_apply();">
    </div>

<div id="stats_table">
    <div class="data_common data_vertical">
        <div class="column_title">
            <p>Statistics</p>
        </div>
        <table id="current traffic">
            <tr aligh="left">
                <th></th>
                <th>Upstream</th>
                <th>Downstream</th>
            </tr>
            <tr>
                <th aligh="left">Highest</th>
                <td id="highest_upstream">0</td>
                <td id="highest_downstream">0</td>
            </tr>
            <tr>
                <th aligh="left">High</th>
                <td id="high_upstream">0</td>
                <td id="high_downstream">0</td>
            </tr>
            <tr>
                <th aligh="left">Medium</th>
                <td id="medium_upstream">0</td>
                <td id="medium_downstream">0</td>
            </tr>
            <tr>
                <th aligh="left">Lowest</th>
                <td id="low_upstream">0</td>
                <td id="low_downstream">0</td>
            </tr>
        </table>
    </div>
</div>


</body>
</html>
