<% SendWebHeadStr();%>
<title>ACL <% multilang(LANG_CONFIGURATION); %></title>
<SCRIPT>
var _telnet = 0;
var _web = 0;
var _https = 0;
var _ssh = 0;
var _icmp = 0;

function addClick(obj)
{
	if (!checkNetIP(document.acl.aclIP, 0))
		return false;
	if (!checkNetmask(document.acl.aclMask, 0))
		return false;

	if (document.acl.aclProtocol.value == 0)
	{
		alert("<% multilang(LANG_PLEASE_SELECT_A_PROTOCOL); %>"); 
		document.acl.aclProtocol.focus();
		return false;
	}

	if (document.acl.aclPort.value != "" && !checkDigitRange(document.acl.aclPort.value, 1, 1, 65535))
	{
		alert("<% multilang(LANG_INVALID_PORT_NUMBER_YOU_SHOULD_SET_A_VALUE_BETWEEN_1_65535); %>");
		document.acl.aclPort.focus();
		return false;
	}

	document.forms[0].addIP.isclick = 1;
	postTableEncrypt(document.forms[0].postSecurityFlag, document.forms[0]);
	return true;
}

function deleteClick()
{
	if ( !confirm('<% multilang(LANG_CONFIRM_DELETE_ONE_ENTRY); %>') ) {
		return false;
	}
	else
	{
		document.forms[0].delIP.isclick = 1;
		postTableEncrypt(document.forms[0].postSecurityFlag, document.forms[0]);
		return true;
	}
}

function proto_changed(proto)
{
	with ( document.forms[0] ) 
	{
		if(proto.value == "0" || proto.value == "5")
			document.getElementById('raw_proto_id').style.display = "none";
		else
			document.getElementById('raw_proto_id').style.display = "";
	}
}
	
function disableDelButton()
{
  if (verifyBrowser() != "ns") {
	disableButton(document.acl.delIP);
	//disableButton(document.acl.delAllIP);
  }
}

function on_submit(obj)
{
	obj.isclick = 1;
	postTableEncrypt(document.forms[0].postSecurityFlag, document.forms[0]);
	return true;
}
</SCRIPT>
</head>

<body>
<div class="intro_main ">
	<p class="intro_title">ACL <% multilang(LANG_CONFIGURATION); %></p>
	<p class="intro_content"> <% multilang(LANG_THIS_PAGE_IS_USED_TO_CONFIGURE_THE_IP_ADDRESS_FOR_ACCESS_CONTROL_LIST_IF_ACL_IS_ENABLED_ONLY_THE_IP_ADDRESS_IN_THE_ACL_TABLE_CAN_ACCESS_CPE_HERE_YOU_CAN_ADD_DELETE_THE_IP_ADDRESS); %></p>
</div>
<form action=/boaform/admin/formACL method=POST name="acl">
	<div class="data_common data_common_notitle">
		<table>
			<tr>
				<th width="30%"><% multilang(LANG_ALLOW_TELNET_FROM_LAN); %>:</th>
				<td>
					<input type="checkbox" name="telnet_lan_enable" value="1" <% checkWrite("telnet_lan_enable"); %>>
				</td>
				<td>
					<input class="inner_btn" type="submit" value="<% multilang(LANG_APPLY_CHANGES); %>" name="apply_lan_telnet" onClick="return on_submit(this)">&nbsp;&nbsp;
				</td>
			</tr>
		</table>
	</div>
	<div class="data_common data_common_notitle">
		<table> 
			<tr>
				<th width="30%"><% multilang(LANG_ENABLE); %>:</th>
				<td width="70%"><input type="checkbox" name="enable" value="1" checked></td>
			</tr>	  
			<tr>
				<th><% multilang(LANG_INTERFACE); %>:</th>
				<td>
					<select name="interface" >
						<%  if_wan_list("rt-any");%>
					</select>
				</td>
			</tr>
			<tr>
				<th><% multilang(LANG_IP_ADDRESS); %>:</th>
				<td><input type="text" name="aclIP" size="15" maxlength="15"></td>
			</tr>  
			<tr>
				<th><% multilang(LANG_SUBNET_MASK); %>:</th>
				<td><input type="text" name="aclMask" size="15" maxlength="15"></td>      
			</tr>
			<tr>
				<th><% multilang(LANG_PROTOCOL); %>:</th>
				<td>
					<select name="aclProtocol" onChange="proto_changed(this)">
						<option value=0></option>
						<option value=1>HTTP</option>
						<option value=2>HTTPS</option>
						<option value=3>TELNET</option>
						<option value=4>SSH</option>
						<option value=5>ICMP</option>
					</select>
				</td>
			</tr>
			<tr id="raw_proto_id" style="display:none">
				<th><% multilang(LANG_PORT); %>:</th>
				<td><input type="text" name="aclPort" size="5" maxlength="5"></td>
			</tr> 
		</table>
	</div>
	<div class="btn_ctl">
	   <input class="link_bg" type="submit" value="<% multilang(LANG_ADD); %>" name="addIP" onClick="return addClick(this)">
	</div>

<!--input type="submit" value="Update" name="updateACL" onClick="return addClick()">&nbsp;&nbsp;
</tr-->

	<div class="column clearfix column_title">
		<div class="column_title_left"></div>
			<p>ACL <% multilang(LANG_TABLE); %></p>
		<div class="column_title_right"></div>
	</div>	
	<div class="data_common data_vertical">
		<table>
			<% showACLTable(); %>
		</table>
	</div> 	
	<div class="btn_ctl clearfix">
		<input class="link_bg" type="submit" value="<% multilang(LANG_DELETE_SELECTED); %>" name="delIP" onClick="return deleteClick(this)">    
		<input type="hidden" value="/admin/acl.asp" name="submit-url">
		<input type="hidden" name="postSecurityFlag" value="">
	</div>  
	<script>
		<% checkWrite("aclNum"); %>
	</script>
</form>
</body>
</html>

