#include <soc.h>
#include <cg/cg.h>
#include <mem_plat_setting.h>
#include <register_map.h>
#include <dram/memcntlr_reg.h>

mem_pll_info_t ddr3_pll[] = {
	{.mhz=500, .pll0=0x001ca07f, .pll1=0x4000018c, .pll2=0x26923740, .pll3=0x260f0000},
	{.mhz=450, .pll0=0x001ca07f, .pll1=0x4000018c, .pll2=0x26923720, .pll3=0x220f0000},
	{.mhz=400, .pll0=0x001ca07f, .pll1=0x4000018c, .pll2=0x26522520, .pll3=0x1e0f0000},
	{.mhz=350, .pll0=0x001ca07f, .pll1=0x4000018c, .pll2=0x26122520, .pll3=0x1a0f0000},
	{.mhz=300, .pll0=0x001ca07f, .pll1=0x4000018c, .pll2=0x26122520, .pll3=0x160f0000},
	{.mhz=250, .pll0=0x001ca07f, .pll1=0x4000018c, .pll2=0x26122400, .pll3=0x120F0000},
	{.mhz=  0, .pll0=0         , .pll1=0         , .pll2=0         , .pll3=0         },
};

void memcntlr_plat_preset(void) {
	/* triple SYNC, enable if mem > 500MHz */
	if (cg_query_freq(CG_DEV_MEM) > 500) {
		RMOD_MCR(
		  sync_ocp1_dram, 1,
			sync_lx0_dram, 1,
			sync_lx1_dram, 1,
			sync_lx2_dram, 1,
			sync_ocp0_dram, 1);
	}

	/* read after write */
	RMOD_MCERAWCR0(
		ocp0_raw_dis, 1,
		ocp1_raw_dis, 1,
		lx0_raw_dis, 1,
		lx1_raw_dis, 1,
		lx2_raw_dis, 1,
		lx3_raw_dis, 1);

	/* parallel bank & ECO */
	RMOD_DCR(
		prl_bank_act_en, 1,
		eco_rd_buf_mech_5281, 0,
		eco_rd_buf_mech_iA, 0);

	DMCRrv = DMCRrv;
	while (RFLD_DMCR(dtr_up_busy_mrs_busy)) {
		;
	}

	return;
}

void memcntlr_plat_postset(void) {
	return;
}
