//This is only for 9602C Test-chip demo board use.
//Goal: To support the SPI NAND type that will use on-die ECC only.

#include <util.h>
#include <spi_nand/spi_nand_struct.h>
#include <spi_nand/spi_nand_symb_func.h>

#ifndef __SECTION_RUNTIME
    #define __SECTION_RUNTIME           SECTION_UNS_TEXT
#endif


__SECTION_RUNTIME void
nsc_disable_on_die_ecc(void)
{
    u32_t feature_addr=0xB0;
    u32_t value = nsu_get_feature_reg(feature_addr);
    value &= ~(1<<4);
    nsu_set_feature_reg(feature_addr,value);
}

__SECTION_RUNTIME void
nsc_enable_on_die_ecc(void)
{
     u32_t feature_addr=0xB0;
    u32_t value = nsu_get_feature_reg(feature_addr) | (1<<4);
    nsu_set_feature_reg(feature_addr, value);
}

__SECTION_RUNTIME void
nsc_block_unprotect(void)
{
    u32_t feature_addr=0xA0;
    u32_t value = 0x00;
    nsu_set_feature_reg(feature_addr, value);
}

__SECTION_RUNTIME s32_t
snaf_page_write_with_ondie_ecc(spi_nand_flash_info_t *info, void *dma_addr, u32_t blk_pge_addr, void *p_eccbuf)
{
    return info->_model_info->_page_write(info, dma_addr, blk_pge_addr);
}

__SECTION_RUNTIME s32_t
snaf_page_read_with_ondie_ecc(spi_nand_flash_info_t *info, void *dma_addr, u32_t blk_pge_addr, void *p_eccbuf)
{
    info->_model_info->_page_read(info, dma_addr, blk_pge_addr);
    return info->_ecc_decode(ECC_USE_ODE, VZERO, VZERO);
}

SECTION_RECYCLE void
spi_nand_func_reassign_for_test_chip(void)
{
    _nsu_page_read_with_ode_ptr = snaf_page_read_with_ondie_ecc;
    _nsu_page_write_with_ode_ptr = snaf_page_write_with_ondie_ecc;
    _nsu_enable_on_die_ecc = nsc_enable_on_die_ecc;
    _nsu_disable_on_die_ecc= nsc_disable_on_die_ecc;
    _nsu_block_unprotect   = nsc_block_unprotect;
}

REG_INIT_FUNC(spi_nand_func_reassign_for_test_chip, 3);
