// arch.h for project/8685S_spi_nand_demo

// UBOOT relative definition
#define MAX_UBOOT_SIZE         (0x20000)
#define ECC_DECODED_UBOOT_ADDR (0x80700000)
#define NEW_STACK_AT_DRAM      (ECC_DECODED_UBOOT_ADDR-32)
#define UBOOT_DECOMP_ADDR      (0x80000000)

#define MT_DRAM_ADDR_V         (0xA0000000)
#define MT_DRAM_SIZE           (0x01000000)
#define BTG_LX1_ADDR_PHY       (0xA2000000)
#define BTG_LX2_ADDR_PHY       (0xA3000000)
#define BTG_SIZE_W             (0x01000000-1)
#define BTG_SIZE_R             (0x01000000-1)


#define SIZE_3KB            (3*1024)
#define SNAF_SRC_CHUNK_BUF    (0xA0000000)
#define SRC_OOB_BUFFER      (SNAF_SRC_CHUNK_BUF + 0x800)
#define SNAF_CHK_CHUNK_BUF    (SNAF_SRC_CHUNK_BUF + SIZE_3KB)
#define CHK_OOB_BUFFER      (SNAF_CHK_CHUNK_BUF + 0x800)
#define SNAF_ECC_TAG_BUF       (SNAF_CHK_CHUNK_BUF + SIZE_3KB)
#define src_page_buf ((void*)(SNAF_SRC_CHUNK_BUF))
#define src_oob_buf   ((oob_t*)(SRC_OOB_BUFFER))
#define chk_page_buf ((void*)(SNAF_CHK_CHUNK_BUF))
#define chk_oob_buf   ((oob_t*)(CHK_OOB_BUFFER))
#define mt_ecc_buf    ((void*)(SNAF_ECC_TAG_BUF))
