// This file is used to store parameters for DDR, and/or flash
#define DONT_DECLAIRE__SOC_SYMBOLS
#include <dram/memcntlr.h>
#include <cg/cg.h>
#include <uart/uart.h>
#include <plr_sections.h>
#include <symb_define.h>
#include <util.h>
#include <spi_nand/spi_nand_struct.h>

extern init_table_entry_t start_of_init_func_table, end_of_init_func_table;
extern symbol_table_entry_t start_of_symble_table, end_of_symble_table;
extern unsigned int lma_offset_before_mapped_area;
extern void plr_tlb_miss_isr(void);

#ifndef SECTION_SOC
    #define SECTION_SOC         SECTION_SOC_STRU
#endif

spi_nand_cmd_info_t   plr_cmd_info SECTION_SDATA;
spi_nand_model_info_t plr_model_info SECTION_SDATA;
spi_nand_flash_info_t   plr_spi_nand_flash_info SECTION_SDATA ={
    ._cmd_info   = &plr_cmd_info,
    ._model_info = &plr_model_info,
};

soc_t _soc SECTION_SOC = {
    .bios={
        .header= {
            .signature=SIGNATURE_PLR_FL,
            .export_symb_list=&start_of_symble_table,
            .end_of_export_symb_list=&end_of_symble_table,
            .init_func_list=&start_of_init_func_table,
            .end_of_init_func_list=&end_of_init_func_table,
        },
        .isr=plr_tlb_miss_isr,
        .size_of_plr_load_firstly=(u32_t)&lma_offset_before_mapped_area,
        .uart_putc=VZERO,
        .uart_getc=VZERO,
        .uart_tstc=VZERO,
        .dcache_writeback_invalidate_all=VZERO,
        .icache_invalidate_all=VZERO,
    },
    .flash_info.spi_nand_info=&plr_spi_nand_flash_info,
};

symb_idefine(boot_storage_type, SF_BOOT_STORAGE_TYPE, BOOT_FROM_SPI_NAND);

const mc_dram_param_t ddr2_param SECTION_PARAMETERS = {
    .dram_type    = 2,
};
const mc_dram_param_t ddr3_param SECTION_PARAMETERS = {
    .dram_type    = 3,
};


const mc_cntlr_opt_t cntlr_opt SECTION_PARAMETERS = {
	.dqs0_en_hclk = 1,
	.dqs1_en_hclk = 1,

	.fast_exit = 1,

	.normal_drv = 1,
	.rtt_nom_ohm = 120,
	.write_lvl_en = 0,
	.dll_dis = 0,

	.rtt_wr_ohm = 120,

	.cntlr_odt = 100,
	.cntlr_ocd = 60,

	.tx_delay       = 0xd,
	.clkm_delay     = 0,
	.clkm90_delay   = 0,
	.dqs0_en_tap    = 0,
	.dqs1_en_tap    = 0,
	.dqs0_group_tap = 0,
	.dqs1_group_tap = 0,
	.dqm0_tap       = 0,
	.dqm1_tap       = 0,
	.wr_dq_delay  = {0x2, 0x1, 0x2, 0x1,
	                 0x3, 0x3, 0x1, 0x2,
	                 0x1, 0x0, 0x0, 0x0,
	                 0x0, 0x1, 0x0, 0x1},
	.rdr_dq_delay = {0xc, 0xd, 0xd, 0xd,
	                 0xd, 0xd, 0xd, 0xc,
	                 0xf, 0xf, 0xf, 0xf,
	                 0xf, 0xf, 0xf, 0xf},
	.rdf_dq_delay = {0xc, 0xc, 0xd, 0xd,
	                 0xd, 0xd, 0xd, 0xc,
	                 0xf, 0xf, 0xf, 0xf,
	                 0xf, 0xf, 0xf, 0xf},
	.cal_method = 1,
	.clk_dll_type = 1,
	.dq_dll_type = 1,
};

const mc_cntlr_opt_t ddr2_cntlr_opt SECTION_PARAMETERS = {
	.dqs0_en_hclk = 0,
	.dqs1_en_hclk = 0,

	.fast_exit = 1,

	.normal_drv = 1,
	.rtt_nom_ohm = 150,
	.write_lvl_en = 0,
	.dll_dis = 0,

	.cntlr_odt = 150,
	.cntlr_ocd = 50,

	.tx_delay       = 0,
	.clkm_delay     = 0,
	.clkm90_delay   = 0,
	.dqs0_en_tap    = 0x1f,
	.dqs1_en_tap    = 0x1f,
	.dqs0_group_tap = 0,
	.dqs1_group_tap = 0,
	.dqm0_tap       = 0,
	.dqm1_tap       = 0,
	.wr_dq_delay    = {0},
	.rdr_dq_delay   = {0},
	.rdf_dq_delay   = {0},
	.cal_method     = 1,

	.clk_dll_type = 1,
	.dq_dll_type = 1,
};

const mc_register_set_t regset SECTION_PARAMETERS = {
	.mcr.v     = MCRdv,
	.dcr.v     = DCRdv,
	.dtr0.v    = DTR0dv,
	.dtr1.v    = DTR1dv,
	.dtr2.v    = DTR2dv,
	.dider.v  = DIDERdv,
	.drcko.v  = DRCKOdv,
	.daccr.v  = DACCRdv,
	.ddzqpr.v = DDZQPRdv,
	.dcdqmr.v = DCDQMRdv,
	.ddzqpcr.v  = DDZQPCRdv,
	.dcsdcr0.v  = DCSDCR0dv,
	.dcsdcr1.v  = DCSDCR1dv,
	.dcsdcr2.v  = DCSDCR2dv,
	.dcsdcr3.v  = DCSDCR3dv,
	.ana_dll0.v = ANA_DLL0dv,

	.mr[0].f.mr_mode_en = 1,
	.mr[1].f.mr_mode_en = 1,
	.mr[2].f.mr_mode_en = 1,
	.mr[3].f.mr_mode_en = 1,
	.mr[0].f.mr_mode    = 0,
	.mr[1].f.mr_mode    = 1,
	.mr[2].f.mr_mode    = 2,
	.mr[3].f.mr_mode    = 3,

	.dacdq_rr  = {
		{.v = DACDQ_IDX_RRdv}, {.v = DACDQ_IDX_RRdv},
		{.v = DACDQ_IDX_RRdv}, {.v = DACDQ_IDX_RRdv},
		{.v = DACDQ_IDX_RRdv}, {.v = DACDQ_IDX_RRdv},
		{.v = DACDQ_IDX_RRdv}, {.v = DACDQ_IDX_RRdv},
		{.v = DACDQ_IDX_RRdv}, {.v = DACDQ_IDX_RRdv},
		{.v = DACDQ_IDX_RRdv}, {.v = DACDQ_IDX_RRdv},
		{.v = DACDQ_IDX_RRdv}, {.v = DACDQ_IDX_RRdv},
		{.v = DACDQ_IDX_RRdv}, {.v = DACDQ_IDX_RRdv}
	},
	.dacdq_fr  = {
		{.v = DACDQ_IDX_FRdv}, {.v = DACDQ_IDX_FRdv},
		{.v = DACDQ_IDX_FRdv}, {.v = DACDQ_IDX_FRdv},
		{.v = DACDQ_IDX_FRdv}, {.v = DACDQ_IDX_FRdv},
		{.v = DACDQ_IDX_FRdv}, {.v = DACDQ_IDX_FRdv},
		{.v = DACDQ_IDX_FRdv}, {.v = DACDQ_IDX_FRdv},
		{.v = DACDQ_IDX_FRdv}, {.v = DACDQ_IDX_FRdv},
		{.v = DACDQ_IDX_FRdv}, {.v = DACDQ_IDX_FRdv},
		{.v = DACDQ_IDX_FRdv}, {.v = DACDQ_IDX_FRdv}
	},
};

const mc_info_t mi[] SECTION_PARAMETERS = {
	{(mc_dram_param_t *)&ddr3_param,
	 (mc_cntlr_opt_t *)&cntlr_opt,
	 (mc_register_set_t *)&regset},

	{(mc_dram_param_t *)&ddr2_param,
	 (mc_cntlr_opt_t *)&ddr2_cntlr_opt,
	 (mc_register_set_t *)&regset},
};

MEMCNTLR_SECTION
const mc_info_t *
proj_mc_info_select(void) {
	if (RFLD_MCR(dram_type) == 2) {
		return &mi[0];
	} else if (RFLD_MCR(dram_type) == 1) {
		return &mi[1];
	} else {
		return VZERO;
	}
}

const cg_info_t cg_info_proj SECTION_PARAMETERS = {
	.dev_freq ={
		.ocp_mhz  = 500,
		.mem_mhz  = 400,
		.lx_mhz   = 200,
	},

	.register_set = {
		.syspllctr.v  = SYSPLLCTRdv,
		.lx_clk_pll.v = LX_CLK_PLLdv,
	},
};
const u32_t uart_baud_rate SECTION_PARAMETERS=115200;

symb_pdefine(cg_info_dev_freq, SF_SYS_CG_DEV_FREQ, (void *)(&cg_info_proj.dev_freq));
