// This file is used to store parameters for DDR, and/or flash
#include <soc.h>
#include <util.h>
#define DONT_DECLAIRE__SOC_SYMBOLS
#include <dram/memcntlr.h>
#include <cg/cg.h>
#include <uart/uart.h>
#include <plr_sections.h>
#include <symb_define.h>
#include <spi_nand/spi_nand_struct.h>

extern init_table_entry_t start_of_init_func_table, end_of_init_func_table;
extern symbol_table_entry_t start_of_symble_table, end_of_symble_table;
extern unsigned int lma_offset_before_mapped_area;
extern void plr_tlb_miss_isr(void);

#ifndef SECTION_SOC
    #define SECTION_SOC         SECTION_SOC_STRU
#endif

spi_nand_cmd_info_t   plr_cmd_info SECTION_SDATA;
spi_nand_model_info_t plr_model_info SECTION_SDATA;
spi_nand_flash_info_t   plr_spi_nand_flash_info SECTION_SDATA ={
    ._cmd_info   = &plr_cmd_info,
    ._model_info = &plr_model_info,
};

soc_t _soc SECTION_SOC = {
    .bios={
        .header= {
            .signature=SIGNATURE_PLR_FL,
            .version=PLR_VERSION,
            .export_symb_list=&start_of_symble_table,
            .end_of_export_symb_list=&end_of_symble_table,
            .init_func_list=&start_of_init_func_table,
            .end_of_init_func_list=&end_of_init_func_table,
        },
        .isr=plr_tlb_miss_isr,
        .size_of_plr_load_firstly=(u32_t)&lma_offset_before_mapped_area,
        .uart_putc=VZERO,
        .uart_getc=VZERO,
        .uart_tstc=VZERO,
        .dcache_writeback_invalidate_all=VZERO,
        .icache_invalidate_all=VZERO,
    },
    .flash_info.spi_nand_info = &plr_spi_nand_flash_info,
};


//*************************************
//  MEM PLL Relative Setting
//*************************************
//   250,                275,               300,               325,                350,               375,                400,               425,
//   450,                475,               500,               525,                550,               575,                600,
SECTION_CG_MISC_DATA
u32_t mem_ctrl2[] = {
    0x26222400, 0x26222400, 0x26222520, 0x26222520, 0x26222520, 0x26622520, 0x26622520, 0x26a23720,
    0x26a23720, 0x26a23740, 0x26a23740, 0x26a33840, 0x26a33840, 0x26a33860, 0x26a33860};

SECTION_CG_MISC_DATA
u32_t ddr2_mem_ctrl0[] = {
    0x0008407f, 0x0008407f, 0x0008407f, 0x0008407f, 0x0008407f, 0x0008407f, 0x0008407f, 0x0008407f,
    0x0008407f, 0x000C607f, 0x000C607f, 0x000C607f, 0x000C607f, 0x000C807f, 0x000C807f};

SECTION_CG_MISC_DATA
u32_t ddr3_mem_ctrl0[] = {
    0x0008407f, 0x0008407f, 0x0008407f, 0x0008407f, 0x0008407f, 0x0008407f, 0x0008407f, 0x0008407f,
    0x0008407f, 0x000C607f, 0x000C607f, 0x000C607f, 0x000C607f, 0x000C807f, 0x000C807f};

SECTION_CG_MISC_DATA
u32_t ddr2_mem_ctrl1[] = {
    0x0000018F, 0x0000018F, 0x4000018F, 0x4000018f, 0x4000018f, 0x4000018f, 0x4000018F, 0x4000018F,
    0x4000018F, 0x4000018F, 0x4000018F, 0x4000018f, 0x4000018f, 0x4000018f, 0x4000018F};

SECTION_CG_MISC_DATA
u32_t ddr2_mem_ctrl3[] = {
    0x120F0000, 0x140F0000, 0x160F0000, 0x180F0000, 0x1A0F0000, 0x1C0F0000, 0x1E0F0000, 0x200F0000,
    0x220F0000, 0x240F0000, 0x260f0000, 0x280F0000, 0x2A0F0000, 0x2C0F0000, 0x2E0F0000};

SECTION_CG_MISC_DATA
u32_t ddr3_mem_ctrl1[] = {
    0x4000018f, 0x4000018f, 0x4000018f, 0x4000018f, 0x4000018f, 0x4000018f, 0x4000018f, 0x4000018f,
    0x4000018f, 0x4000018f, 0x4000018f, 0x4000018f, 0x4000018f, 0x4000018f, 0x4000018f};

SECTION_CG_MISC_DATA
u32_t ddr3_mem_ctrl3[] = {
    0x120F0000, 0x140F0000, 0x160f0000, 0x180f0000, 0x1a0f0000, 0x1c0f0000, 0x1e0f0000, 0x200f0000,
    0x220f0000, 0x240f0000, 0x260f0000, 0x280f0000, 0x2a0f0000, 0x2c0f0000, 0x2e0f0000};


//************************************
// DRAM: Controller Setting & Data Base
//************************************
const mc_dram_param_t ddr2_param SECTION_PARAMETERS = {
    .dram_type    = 2,
};
const mc_dram_param_t ddr3_param SECTION_PARAMETERS = {
    .dram_type    = 3,
};

const mc_cntlr_opt_t ddr2_cntlr_opt SECTION_PARAMETERS = {
    .fast_exit      = 1,
    .normal_drv     = 1,
    .ddr2_odt_val   = 150,
    .bus_sync       = 1,
    .dqs0_en_hclk   = 1,
    .dqs1_en_hclk   = 1,
    .cntlr_odt      = 120,
    .cntlr_ocd      = 40,
    .cntlr_odt_clk  = 120,
    .cntlr_ocd_clk  = 40,
    .cntlr_odt_adr  = 120,
    .cntlr_ocd_adr  = 40,
    .cntlr_odt_dq   = 120,
    .cntlr_ocd_dq   = 40,
    .dqs0_en_tap    = 0x1f,
    .dqs1_en_tap    = 0x1f,
    .dqs0_group_tap = 0,
    .dqs1_group_tap = 0,
    .cal_method     = 1,   // 1: autoK, 0: others
    .dq_dll_type    = 1,   // 1: digital delay line, 0:Analog dll
    .zq_cal_method  = 1,   // 1: autoK, 0: others
    .parallel_bank_en = 1,
    .dbg_en         = 0,
};

#define WR_DELAY_V  (0x8)
const mc_cntlr_opt_t ddr3_cntlr_opt SECTION_PARAMETERS = {
    .rtt_nom_ohm    = 120,
    .rtt_wr_ohm     = 0,
    .normal_drv     = 1,
    .bus_sync       = 1,
    .dqs0_en_hclk   = 1,
    .dqs1_en_hclk   = 1,
    .cntlr_odt      = 120,
    .cntlr_ocd      = 48,
    .cntlr_odt_clk  = 120,
    .cntlr_ocd_clk  = 34,
    .cntlr_odt_adr  = 120,
    .cntlr_ocd_adr  = 60,
    .cntlr_odt_dq   = 120,
    .cntlr_ocd_dq   = 40,
    .dqs0_en_tap    = 0x1f,
    .dqs1_en_tap    = 0x1f,
    .dqs0_group_tap = 0,
    .dqs1_group_tap = 0,
    .cal_method     = 1,   // 1: autoK, 0: others
    .dq_dll_type    = 1,   // 1: digital delay line, 0:Analog dll
    .zq_cal_method  = 1,   // 1: autoK, 0: others
    .parallel_bank_en = 1,
    .dbg_en         = 0,
};

const mc_register_set_t regset SECTION_PARAMETERS = {
    .mcr.v     = MCRdv,
    .dcr.v     = DCRdv,
    .dtr0.v    = DTR0dv,
    .dtr1.v    = DTR1dv,
    .dtr2.v    = DTR2dv,
    .dider.v  = DIDERdv,
    .drcko.v  = DRCKOdv,
    .daccr.v  = DACCRdv,
    .ddzqpr.v = DDZQPRdv,
    .dcdqmr.v = DCDQMRdv,
    .ddzqpcr.v  = DDZQPCRdv,
    .dcsdcr0.v  = DCSDCR0dv,
    .dcsdcr1.v  = DCSDCR1dv,
    .dcsdcr2.v  = DCSDCR2dv,
    .dcsdcr3.v  = DCSDCR3dv,
    .ana_dll0.v = ANA_DLL0dv,

    .mr[0].f.mr_mode_en = 1,
    .mr[1].f.mr_mode_en = 1,
    .mr[2].f.mr_mode_en = 1,
    .mr[3].f.mr_mode_en = 1,
    .mr[0].f.mr_mode    = 0,
    .mr[1].f.mr_mode    = 1,
    .mr[2].f.mr_mode    = 2,
    .mr[3].f.mr_mode    = 3,

    .dacdq_rr  = {
        {.v = DACDQ_IDX_RRdv}, {.v = DACDQ_IDX_RRdv},
        {.v = DACDQ_IDX_RRdv}, {.v = DACDQ_IDX_RRdv},
        {.v = DACDQ_IDX_RRdv}, {.v = DACDQ_IDX_RRdv},
        {.v = DACDQ_IDX_RRdv}, {.v = DACDQ_IDX_RRdv},
        {.v = DACDQ_IDX_RRdv}, {.v = DACDQ_IDX_RRdv},
        {.v = DACDQ_IDX_RRdv}, {.v = DACDQ_IDX_RRdv},
        {.v = DACDQ_IDX_RRdv}, {.v = DACDQ_IDX_RRdv},
        {.v = DACDQ_IDX_RRdv}, {.v = DACDQ_IDX_RRdv}
    },
    .dacdq_fr  = {
        {.v = DACDQ_IDX_FRdv}, {.v = DACDQ_IDX_FRdv},
        {.v = DACDQ_IDX_FRdv}, {.v = DACDQ_IDX_FRdv},
        {.v = DACDQ_IDX_FRdv}, {.v = DACDQ_IDX_FRdv},
        {.v = DACDQ_IDX_FRdv}, {.v = DACDQ_IDX_FRdv},
        {.v = DACDQ_IDX_FRdv}, {.v = DACDQ_IDX_FRdv},
        {.v = DACDQ_IDX_FRdv}, {.v = DACDQ_IDX_FRdv},
        {.v = DACDQ_IDX_FRdv}, {.v = DACDQ_IDX_FRdv},
        {.v = DACDQ_IDX_FRdv}, {.v = DACDQ_IDX_FRdv}
    },
};

const mc_info_t mi_ddr2[] SECTION_PARAMETERS = {
    {(mc_dram_param_t *)&ddr2_param,
     (mc_cntlr_opt_t *)&ddr2_cntlr_opt,
     (mc_register_set_t *)&regset},
};

const mc_info_t mi_ddr3[] SECTION_PARAMETERS = {
    {(mc_dram_param_t *)&ddr3_param,
     (mc_cntlr_opt_t *)&ddr3_cntlr_opt,
     (mc_register_set_t *)&regset},
};

MEMCNTLR_SECTION
const mc_info_t *
proj_mc_info_select(void) {
    if (RFLD_MCR(dram_type) == 1) {
		return &mi_ddr2[0];
	}else if (RFLD_MCR(dram_type) == 2) {
        return &mi_ddr3[0];
	}else{
        return VZERO;
    }
}

//*************************************
// CG: OCP, MEM, LX, UART Clock Setting
//*************************************
const cg_dev_freq_t cg_ddr2_proj_freq SECTION_PARAMETERS = {
    .lx_mhz   = 200,
    .spif_mhz = 25,
};

const cg_dev_freq_t cg_ddr3_proj_freq SECTION_PARAMETERS = {
    .lx_mhz   = 200,
    .spif_mhz = 25,
};

const u32_t uart_baud_rate SECTION_PARAMETERS=115200;
const u32_t core_power_step SECTION_PARAMETERS=0;
symb_idefine(boot_storage_type, SF_BOOT_STORAGE_TYPE, BOOT_FROM_SPI_NAND);

