#include <bamt.h>

static void parse_desc(bonding_desc_t *desc, u16_t *map) {
	u32_t i = 0;
	while (desc[i].a != -1) {
		map[(u8_t)desc[i].a] |= (1 << desc[i].a) | (1 << desc[i].b);
		i++;
	}
	return;
}

static void trans_map_2_bit_pos(s8_t *bit_pos, u16_t map) {
	u32_t n = 0;
	u32_t i;

	for (i=0; i<17; i++) {
		bit_pos[i] = -1;
		if (map & (1 << i)) {
			bit_pos[n++] = i;
		}
	}

	return;
}

static u32_t get_pat_lim(s8_t *bit_pos) {
	u32_t pat_lim = 1;

	while ((*bit_pos) != -1) {
		pat_lim *= 2;
		bit_pos++;
	}

	return pat_lim;
}

static u16_t pat_2_pat16(s8_t *bit_pos, u32_t pat) {
	u16_t pat16 = 0;

	while (*bit_pos != -1) {
		pat16 |= (pat & 1) << *bit_pos;
		bit_pos++;
		pat /= 2;
	}

	return pat16;
}

static u32_t imm_v(volatile u32_t *addr, u32_t val) {
	u32_t v = *addr;
	if (v != val) {
		printf("EE: %08x@%08x != %08x\n", v, (u32_t)addr, val);
	}
	return (v!=val);
}

static u32_t imm_wnv(volatile u32_t *addr, u32_t val) {
	*addr = val;
	asm volatile("" ::: "memory");
	return imm_v(addr, val);
}

static u32_t data_wr_test(const u32_t *baseaddr,
                          u16_t map,
                          u16_t pat,
                          __attribute__ ((unused)) mc_addr_info_t *mcai) {
	u32_t *addr;
	u32_t i, res = 0;
	u32_t pat_grp[] = {
		(pat << 16) | pat,
		(pat << 16) | (~pat & map),
		(pat << 16) | pat          | ~(map | (map << 16)),
		(pat << 16) | (~pat & map) | ~(map | (map << 16)),
	};

	for (i=0; i<sizeof(pat_grp)/sizeof(pat_grp[0]); i++) {
		if (pat_grp[i] == 0xffffffff) {
			pat_grp[i] = 0;
		}
	}

	_bios.dcache_writeback_invalidate_all();

	addr = (u32_t *)baseaddr;
	/* printf("DD: map: %04x, pat: %04x ", map, pat); */
	for (i=0; i<sizeof(pat_grp)/sizeof(pat_grp[0]); i++) {
		if (pat_grp[i] == 0) {
			continue;
		}
		/* printf("%08x@%08x... ", pat_grp[i], (u32_t)addr); */
		bamt_dram_fill_with_cache(addr, pat_grp[i], 16*1024, 16*1024);
		addr += 16*1024/4;
	}
	/* puts("\n"); */

	addr = (u32_t *)baseaddr;
	for (i=0; i<sizeof(pat_grp)/sizeof(pat_grp[0]); i++) {
		if (pat_grp[i] == 0) {
			continue;
		}
		res |= bamt_dram_verify(addr, pat_grp[i], 16*1024);
		addr += 16*1024/4;
	}

	return res;
}

static u32_t addr_wr_test(__attribute__ ((unused)) const u32_t *baseaddr,
                          __attribute__ ((unused)) u16_t map,
                          u16_t pat,
                          mc_addr_info_t *mcai) {
	volatile u32_t *addr;
	u32_t res = 0;
	u32_t i, b;
	u32_t addr_grp[3];

	addr_grp[0] = 0xa0000000 | (pat & mcai->col_mask);
	addr_grp[1] = 0xa0000000 | ((pat & mcai->row_mask) << mcai->col_bnum);
	addr_grp[2] = 0xa0000000 | (pat & mcai->col_mask) | ((pat & mcai->row_mask) << mcai->col_bnum);

	for (b=0; b<mcai->bank_num; b++) {
		for (i=0; i<3; i++) {
			addr = (u32_t *)(addr_grp[i] | (b << mcai->bank_offset));

			/* printf("DD: pat: %04x, %08x...\n", pat, (u32_t)addr); */

			res |= imm_wnv(addr, 0xa5a55a5a);
			res |= imm_wnv(addr, 0x00000000);
			res |= imm_wnv(addr, 0xffffffff);
			res |= imm_wnv(addr, 0x5a5aa5a5);
			if (res) {
				break;
			}
		}
	}

	return res;
}

static u32_t per_bit_test(u16_t map, bamt_target_t test_type, mc_addr_info_t *mcai) {
	u32_t pat_lim = 1, res = 0;
	u32_t pat = 0;
	u16_t pat16;
	s8_t bit_pos[17];
	map_wr_test *wr_func[] = {
		data_wr_test, //bamt_data
		addr_wr_test, //bamt_addr,
	};

	if (map == 0) {
		return 0;
	}

	trans_map_2_bit_pos(bit_pos, map);

	pat_lim = get_pat_lim(bit_pos);

	while (pat < pat_lim) {
		pat16 = pat_2_pat16(bit_pos, pat);

		res |= wr_func[test_type]((u32_t *)0x80ff0000, map, pat16, mcai);
		pat++;
	}

	return res;
}

void bamt_dram_fill_with_cache(u32_t *addr, u32_t pat, u32_t msize_b, u32_t csize_b) {
	const u32_t cache_entry_num = csize_b / 32;
	u32_t i, j;

	_soc.bios.dcache_writeback_invalidate_all();
	for (i=0; i<msize_b/csize_b; i++) {
		j = cache_entry_num;
		while (j--) {
			*addr++ = pat;
			*addr++ = pat;
			*addr++ = pat;
			*addr++ = pat;
			*addr++ = pat;
			*addr++ = pat;
			*addr++ = pat;
			*addr++ = pat;
		}
		_soc.bios.dcache_writeback_invalidate_all();
	}

	return;
}

u32_t bamt_dram_verify(u32_t *addr, u32_t pat, u32_t msize_b) {
	u32_t erraddr = 0, errcnt = 0;
	u32_t i;

	for (i=0; i<msize_b/sizeof(u32_t); i++) {
		if (*addr != pat) {
			erraddr = (u32_t)addr;
			if ((errcnt++) < 16) {
				FT_PRINTF("EE: %08x@%08x != %08x\n", *addr, addr, pat);
			};
		}
		addr++;
	}

	if (errcnt) {
		FT_PRINTF("EE: ... ~ %08x, total: %d W\n", erraddr, errcnt);
	}
	return (errcnt > 0);
}

mc_addr_info_t * bamt_get_addr_pin_info(mc_addr_info_t *mcai) {
	mcai->col_bnum = RFLD_DCR(colcnt) + 8;
	mcai->col_mask = ((1 << mcai->col_bnum) - 1) & (~3);

	mcai->row_bnum = RFLD_DCR(rowcnt) + 11;
	mcai->row_mask = (1 << mcai->row_bnum) - 1;

	mcai->bank_num = 1 << (RFLD_DCR(bankcnt) + 1);
	mcai->bank_offset = mcai->col_bnum + mcai->row_bnum;
	return mcai;
}

u32_t bonding_aware_memory_test(bonding_desc_t *desc,
                                mc_addr_info_t *mcai,
                                bamt_target_t tt) {
	u32_t res = 0;
	u16_t dq_map[16] = {0};
	u32_t i;

	parse_desc(desc, dq_map);

	for (i=0; i<16; i++) {
		res |= per_bit_test(dq_map[i], tt, mcai);
	}

	return res;
}
