#ifndef __BAMT_H__
#define __BAMT_H__

#include <soc.h>
#include <register_map.h>

#define FT_PRINTF(...) do { \
		printf(__VA_ARGS__); \
	} while (0)

typedef struct {
	u32_t col_bnum;
	u32_t col_mask;
	u32_t row_bnum;
	u32_t row_mask;
	u32_t bank_num;
	u32_t bank_offset;
} mc_addr_info_t;

typedef enum {
	bamt_data,
	bamt_addr,
} bamt_target_t;

typedef struct {
	s8_t a;
	s8_t b;
} bonding_desc_t;

u32_t bonding_aware_memory_test(bonding_desc_t *dq_desc,
                                mc_addr_info_t *mcai,
                                bamt_target_t tt);
mc_addr_info_t * bamt_get_addr_pin_info(mc_addr_info_t *mcai);
u32_t bamt_dram_verify(u32_t *addr, u32_t pat, u32_t msize_b);
void bamt_dram_fill_with_cache(u32_t *addr, u32_t pat, u32_t msize_b, u32_t csize_b);

typedef u32_t (map_wr_test)(const u32_t *addr, u16_t map, u16_t pat, mc_addr_info_t *mcai);

#endif
