#include <soc.h>
#include <dram/autok/dram_autok.h>
#include <dram_autok_scty.h>

extern void _memctl_update_phy_param(void);

SECTION_AUTOK
void _memctl_set_phy_delay_dqrf(u32_t bit_loc,u32_t max_w_seq_start,u32_t max_w_len,u32_t max_r_seq_start,u32_t max_r_len)
{
	volatile u32_t *ddcrdqr_base, *soc_id_reg __attribute__((unused));
	volatile u32_t *mcr __attribute__((unused));
	unsigned char r_delay_tap;
#if 1
	unsigned char w_delay_tap=0;			// __attribute__((unused));
#endif
	u32_t ps_mul, ps_div;

	ddcrdqr_base = (volatile u32_t *)0xB8001510;		//DQ delay line
	soc_id_reg   = (volatile u32_t *)0xB80010FC;
	mcr = (volatile u32_t *)MCR;

	ddcrdqr_base += bit_loc;

#if 1
	if(max_w_seq_start==0){
		if((max_w_len-15)>=0)
			w_delay_tap=max_w_len-15;
		else
			w_delay_tap=0;
	}else{
		w_delay_tap=max_w_len/2;
	}
#endif

	//for DDR2, DDR3 Read delay tap
	ps_mul = mc_akh_rx_win_sel_mul(1);
	ps_div = mc_akh_rx_win_sel_div(2);

	if(max_r_len>20){
		r_delay_tap = ((max_r_len*ps_mul) + (ps_div/2)) / ps_div;
	}else if(max_r_len>12 && max_r_seq_start==0){
		r_delay_tap = max_r_len-12;
	}else if(max_r_seq_start!=0){
		r_delay_tap = ((max_r_len*ps_mul) + (ps_div/2)) / ps_div;
	}else{
		r_delay_tap=0;
	}


#if 1 //we currently don't set write DQ delay taps in new mem-controller
	*ddcrdqr_base = (w_delay_tap << 24) | \
		(((max_r_seq_start + max_r_len - 1) & 0x1f) << 16) | \
		(((max_r_seq_start + (r_delay_tap)) & 0x1f) << 8) | \
		(((max_r_seq_start) & 0x1f) << 0);
#else
	*ddcrdqr_base = (((max_r_seq_start + max_r_len - 1) & 0x1f) << 16) | \
		(((max_r_seq_start + (r_delay_tap)) & 0x1f) << 8) | \
		(((max_r_seq_start) & 0x1f) << 0);
#endif

	_memctl_update_phy_param();
	// printf("(0x%x) = 0x%x\n",ddcrdqr_base,*ddcrdqr_base);
	puts("\n");
	if(max_r_len<10){
		REG32(0xb8003260) = 0x80000000;		//trigger watchdog.
		while(REG32(0xb8003260));
		//REG32(0xb8003268) = 0x80000002;		//trigger watchdog software reset.
		REG32(0xb8003268) = 0x80000000;		//trigger watchdog HW reset.
		printf("trigger watchdog.\n\r");
		while(1);
	}

	return;
}

#if 0
SECTION_AUTOK
void _DRAM_PLL_CLK_power_switch(unsigned char power_on)
{
#if 1
	volatile unsigned int *dpcpw;
	unsigned int	delay_tmp;
	dpcpw = (unsigned int *)0xB8000204;

	if(power_on)
		*dpcpw &=  ~(1<<4);
	else
		*dpcpw |=  (1<<4);
#else
	volatile unsigned int *dpcpw;
	unsigned int	delay_tmp;
	dpcpw = (unsigned int *)0xB8000220;

	if(power_on)
		*dpcpw &=  ~(1);
	else
		*dpcpw |=  (1);
#endif
	delay_tmp=0x1fff;
	while(delay_tmp--);
}


SECTION_AUTOK
void _periodic_DRAM_refresh(unsigned char enable)
{
	volatile unsigned int *dmcr;
	dmcr = (unsigned int *)DMCR;

	if(enable){
		/* Enable DRAM periodic DRAM refresh operation. */
		*dmcr &=  ~(1<<24);
	}else{
		/* Disable DRAM periodic DRAM refresh operation */
		*dmcr |=  (1<<24);
	}

	_memctl_delay_clkm_cycles(10);
	while((*dmcr & ((unsigned int)DMCR_MRS_BUSY)) != 0);
}

SECTION_AUTOK
void memctlc_change_pll_phase(unsigned short value)
{
	volatile unsigned int *ddrckodl;
	ddrckodl = (volatile unsigned int *)0xb800021c;
	unsigned char clk,clkm;
	unsigned short i=0,j=0;
	clk=value&0x1f;
	clkm=(value>>8)&0x1f;
	for(i=0;i<=clk;i++){
		*ddrckodl=(i)|(j<<8);
		udelay(100);
		for(;j<clkm;j++){
			*ddrckodl=(i)|(j<<8);
			udelay(100);
		}
	}
}


#endif
