#include <dram/autok/dram_autok.h>
#include <dram_autok_scty.h>

extern void memctlc_config_DTR(unsigned int default_instruction, unsigned int dram_size);
extern u32_t DDR_Calibration(unsigned char full_scan);
extern unsigned int memctlc_config_DRAM_size(void);
extern int memctlc_ZQ_calibration(unsigned int auto_cali_value);
extern void memctlc_dll_setup(void);
extern void memctrlc_config_DRAM_MCR_SETTING(unsigned int);
extern void _memctl_update_phy_param(void);
extern void memctlc_dram_phy_reset(void);

static unsigned int auto_cali_value[]= {
	CONFIG_DRAM_PREFERED_ZQ_PROGRAM
};

/* Function Name:
 * 	sys_watchdog_enable
 * Descripton:
 *	Implement system watchdog function
 * Input:
 *	ph1 -> phase 1 threshold, ph2 -> phase 2 thershold
 * Output:
 * 	None
 * Return:
 *	None
 */
void sys_watchdog_enable(unsigned int ph1, unsigned int ph2)
{
	REG32(SYSREG_WDCNTRR) |= SYSREG_WDT_KICK;
	REG32(SYSREG_WDTCTRLR) = ((SYSREG_WDT_E) |\
								((ph1 << SYSREG_PH1_TO_S) & SYSREG_PH1_TO_MASK) |\
								((ph2 << SYSREG_PH2_TO_S) & SYSREG_PH2_TO_MASK));
	return;
}

void sys_watchdog_disable(void)
{
	REG32(SYSREG_WDCNTRR) = 0x0;
	REG32(SYSREG_WDTCTRLR) = 0x0;

	return;
}

SECTION_AUTOK
void memctlc_config_delay_line(void)		//this for clock rate under 350MHz
{
	unsigned char analog_delay_disable=1, dynamic_FIFO_rst=0, buffer_poniter=0;
	unsigned char DQS0_EN,DQS1_EN,DQS0_GROUP,DQS1_GROUP,HCLK_EN,DQM0_DLY,DQM1_DLY,ADDR_CTL_DLY,TX_DQS_DLY;
	analog_delay_disable=1;

	/* common setting  */
	dynamic_FIFO_rst = 1;
	buffer_poniter = 1;
	DQS0_GROUP=0x0;
	DQS1_GROUP=0x0;
	HCLK_EN=1;
	DQS0_EN=DQS1_EN=0x0f;
	//DQS0_EN=DQS1_EN=0x0;
	DQM0_DLY=0x4;
	DQM1_DLY=0x4;
	ADDR_CTL_DLY=0x0f;
	TX_DQS_DLY=0x0;

	REG32(DDCR) = ((HCLK_EN&0x1)<<31) |((DQS0_EN&0x1F)<<24) |((HCLK_EN&0x1)<<23)  | ((DQS1_EN&0x1F)<<16);						//DQS0 HCLK, DQS0 EN, DQS1 HCLK, DQS1 EN for read
	REG32(DACCR) = ((analog_delay_disable&0x1)<<31) | ((DQS0_GROUP&0x1F)<< 16) |((DQS1_GROUP&0x1F)<< 8)|(dynamic_FIFO_rst<<5)|(buffer_poniter<<4);	/* Assign DQS0 and DQS1 group delay for read */
	REG32(DCDQMR) = (DQM1_DLY&0x1f)<<16 | (DQM0_DLY&0x1f)<<24;
	REG32(DWDMOR) = (DQM0_DLY&0x1f)<<16 | (DQM1_DLY&0x1f)<<24;			//DQM1_OUT_EN_DELAY[n28:24], DQM0_OUT_EN_DELAY[n20:16]
	REG32(DWDQSOR) = (TX_DQS_DLY&0x1f)<<16 | (TX_DQS_DLY&0x1f)<<24;		//DQS1_OUT_EN_DELAY[n28:24], DQS0_OUT_EN_DELAY[n20:16]

	REG32(DDR_DELAY_CTRL_REG0)= (ADDR_CTL_DLY<<24)|(ADDR_CTL_DLY<<20)|(ADDR_CTL_DLY<<16)|(ADDR_CTL_DLY<<12)|(ADDR_CTL_DLY<<8)|(ADDR_CTL_DLY<<4)|(ADDR_CTL_DLY);
	REG32(DDR_DELAY_CTRL_REG1)= (TX_DQS_DLY<<24)|(TX_DQS_DLY<<16)|(ADDR_CTL_DLY<<8)|(ADDR_CTL_DLY<<4)|(ADDR_CTL_DLY);
	REG32(DDR_DELAY_CTRL_REG2)= (ADDR_CTL_DLY<<28)|(ADDR_CTL_DLY<<24)|(ADDR_CTL_DLY<<20)|(ADDR_CTL_DLY<<16)|(ADDR_CTL_DLY<<12)|(ADDR_CTL_DLY<<8)|(ADDR_CTL_DLY<<4)|(ADDR_CTL_DLY);
	REG32(DDR_DELAY_CTRL_REG3)= (ADDR_CTL_DLY<<28)|(ADDR_CTL_DLY<<24)|(ADDR_CTL_DLY<<20)|(ADDR_CTL_DLY<<16)|(ADDR_CTL_DLY<<12)|(ADDR_CTL_DLY<<8)|(ADDR_CTL_DLY<<4)|(ADDR_CTL_DLY);
	_memctl_update_phy_param();
	return;
}

SECTION_AUTOK
static void memctlc_set_dqm_delay(void)
{
	volatile unsigned int *ddr_tx_dq_delay;
	unsigned char i;
	unsigned short tx_hdqm_average=0,tx_ldqm_average=0;
	ddr_tx_dq_delay = (volatile unsigned int *)0xb8001510;
	for(i=0;i<8;i++)
		tx_ldqm_average+= ((*(ddr_tx_dq_delay+i))>>24) &0x1f;
	for(i=8;i<16;i++)
		tx_hdqm_average+= ((*(ddr_tx_dq_delay+i))>>24) &0x1f;
	printf("tx_ldqm_average=0x%x, tx_hdqm_average=0x%x\n\r",tx_ldqm_average/8,tx_hdqm_average/8);
	REG32(0xb8001590)= ((tx_ldqm_average/8)<<24) | ((tx_hdqm_average/8)<<16);
}

SECTION_AUTOK
static void memctlc_set_ckodl_delay(unsigned int mem_clk_mhz)
{
	volatile unsigned int *ddrckodl;
	ddrckodl = (volatile unsigned int *)0xb800021c;
	REG32(0xb8000608) |=(1<<31);		// clk,clkm,clkm90 use delay line type, if 1 use digital line.
	RMOD_DRAM_CLK_CHG(dram_clk_dg_en, 1);	udelay(100);
	//if(memctlc_is_DDR2()){
	if(mem_clk_mhz==350){
		//Etron => CLK lead DQS0 377ps, CLK lead DQS1 ps @350MHz
		//clk_clkm_phase=7; 	//RTL9601 => CLK lead DQS1 644ps @350MHz (condition 714ps ~357ps)		//kevinchung
		*ddrckodl= 0x30a;
		//*ddrckodl= 0x7;
		//memctlc_change_pll_phase(0x30a);
	}else if(mem_clk_mhz==400){
		//clk_clkm_phase=10;		//RTL9601 => CLK lead DQS1 544ps @400MHz (condition 625ps ~312ps)		//kevinchung
		*ddrckodl= 0x30d;
		//memctlc_change_pll_phase(0x30d);
	}else{
		//Etron => CLK lead DQS0 330ps, CLK lead DQS1 355ps @300MHz
		//clk_clkm_phase=4; 	//RTL9601 => CLK lead DQS1 722ps @300MHz (condition 833ps ~416ps)		//kevinchung
		*ddrckodl= 0x307;
		//*ddrckodl= 0x004;
		//memctlc_change_pll_phase(0x307);
	}
	udelay(100);RMOD_DRAM_CLK_CHG(dram_clk_dg_en, 0);udelay(100);
	printf("0xb800021c=0x%x\n\r",*ddrckodl);
	return ;
}

SECTION_AUTOK
u32_t dram_autok(void) {
	unsigned int dram_size=0;
	u32_t ret = 0;
#ifdef AUTOK_DEBUG
	int j;
    unsigned int *ptr;
#endif
#ifdef CONFIG_FULL_AUTOK
	int i;
	int is_zq_fail;
#endif

	printf("\nDRAM AUTO CALIBRATION\n");
	// Enable watchdog for whole the initial procedure
	sys_watchdog_enable(20, 1);

	do {
#ifdef CONFIG_FULL_AUTOK
		/* gerneal DTR config */
		memctlc_config_DTR(1, dram_size);

		/*ZQ Configuration*/
		is_zq_fail = 1;

		auto_cali_value[0] = mc_akh_get_zq_setting(auto_cali_value[0]);

		if(is_zq_fail){//user-defined value fail, try other predefine value
			for(i=0; i< (sizeof(auto_cali_value)/sizeof(unsigned int));i++){
				printf("auto_cali_value[i]=0x%x\n\r",auto_cali_value[i]);
				if(0 == memctlc_ZQ_calibration(auto_cali_value[i])){
					/* We found one .*/
					break;
				}
			}
			if(i >= (sizeof(auto_cali_value)/sizeof(unsigned int)) ){
				printf("ZQ calibration failed\n");
				break;
			}
		}

		memctlc_config_delay_line();

		/* 150211,apply DQM calibration. */
		memctlc_set_ckodl_delay(GET_MEM_MHZ());

		/*DLL setup*/
		memctlc_dll_setup();
#endif

		ret = DDR_Calibration(1);
		if (ret != 0) break;
		memctlc_set_dqm_delay();

#ifdef CONFIG_FULL_AUTOK
		/* reset dram phy */
		memctlc_dram_phy_reset();

		/* dram size detection */
		if (efuse_6_rd()) {
			dram_size = 0x00800000 << efuse_6_rd();
			memctrlc_config_DRAM_MCR_SETTING(dram_size);
		} else {
			dram_size = memctlc_config_DRAM_size();
		}

		/* set DTR accroding to dram size */
		memctlc_config_DTR(0, dram_size);
#endif
		sys_watchdog_disable();
#ifdef AUTOK_DEBUG
		/* print regs settings after autok*/
		printf("II: Regs Settings:\n");
		printf("0xb8001000: 0x%08x\n", REG32(0xb8001000));
		printf("0xb8001004: 0x%08x\n", REG32(0xb8001004));
		printf("0xb8001008: 0x%08x\n", REG32(0xb8001008));
		printf("0xb800100c: 0x%08x\n", REG32(0xb800100c));
		printf("0xb8001010: 0x%08x\n", REG32(0xb8001010));
		printf("0xb800021c: 0x%08x\n", REG32(0xb800021c));
		printf("0xb8001090: 0x%08x\n", REG32(0xb8001090));
		printf("0xb8001094: 0x%08x\n", REG32(0xb8001094));
		printf("0xb8001590: 0x%08x\n", REG32(0xb8001590));
		printf("0xb8001050: 0x%08x\n", REG32(0xb8001050));
		printf("0xb8001500: 0x%08x\n", REG32(0xb8001500));
		printf("0xb8000208: 0x%08x\n", REG32(0xb8000208));
		printf("0xb800020c: 0x%08x\n", REG32(0xb800020c));
		printf("0xb8000210: 0x%08x\n", REG32(0xb8000210));
		printf("0xb80015b0: 0x%08x\n", REG32(0xb80015b0));
		printf("0xb80015b4: 0x%08x\n", REG32(0xb80015b4));
		printf("0xb80015b8: 0x%08x\n", REG32(0xb80015b8));
		printf("0xb80015bc: 0x%08x\n", REG32(0xb80015bc));

		ptr = (volatile unsigned int *) 0xb8001510;
		for(j=0;j < 32; j++) {
			printf("0x%08x: 0x%08x\n",(ptr+j), *(ptr+j));
		}
#endif
		printf("AutoK: dram auto calibrtaion is done\n\n");
		return ret;
	} while(0);

	printf("AutoK: dram auto calibrtaion failed!!!\n\n");
	return ret;
}
