#include <soc.h>
#include <cg/cg.h>
#include <misc/misc_setting.h>
#include <cli/cli_util.h>
#include <cli/cli_access.h>

#define PLL_INFO cg_info_query

extern cg_dev_freq_t cg_target_freq;

void _cg_xlat_n_assign(void);
void cg_result_decode(void);
void apro_cg_init(void);

cli_cmd_ret_t
cli_pll_setup(const void *user, u32_t argc, const char *argv[]) {
	if (otto_is_apro()) {
		cg_target_freq.cpu0_mhz = PLL_INFO.cpu0_mhz;
		cg_target_freq.mem_mhz = PLL_INFO.mem_mhz;
		cg_target_freq.lx_mhz = PLL_INFO.lx_mhz;
		cg_target_freq.spif_mhz = PLL_INFO.spif_mhz;
		cg_target_freq.sram_mhz = PLL_INFO.sram_mhz;
		apro_cg_init();
	} else {
		_cg_xlat_n_assign();
		cg_result_decode();
	}
	return CCR_OK;
}

cli_add_node(pll, get, VZERO);
cli_add_parent(pll, set);

#define DEFINE_PLL_INT_VAR(name, is_dec, get_func_body, set_func_body) \
	SECTION_CLI_VAR int _CLI_VAR_CLI_ ## name ## _get_int_(u32_t *result) { \
		get_func_body; return 0;}	\
	SECTION_CLI_VAR int _CLI_VAR_CLI_ ## name ## _set_int_(u32_t value) { \
		set_func_body; return 0;}	\
	CLI_DEFINE_VAR(name, pll, 1, 0, is_dec,	\
								 _CLI_VAR_CLI_ ## name ## _get_int_, \
								 _CLI_VAR_CLI_ ## name ## _set_int_)

DEFINE_PLL_INT_VAR(cpu0_mhz, 1, {*result=PLL_INFO.cpu0_mhz;}, {PLL_INFO.cpu0_mhz=value;});
DEFINE_PLL_INT_VAR(mem_mhz, 1, {*result=PLL_INFO.mem_mhz;}, {PLL_INFO.mem_mhz=value;});
DEFINE_PLL_INT_VAR(lx_mhz, 1, {*result=PLL_INFO.lx_mhz;}, {PLL_INFO.lx_mhz=value;});
DEFINE_PLL_INT_VAR(spif_mhz, 1, {*result=PLL_INFO.spif_mhz;}, {PLL_INFO.spif_mhz=value;});
DEFINE_PLL_INT_VAR(sram_mhz, 1, {*result=PLL_INFO.sram_mhz;}, {PLL_INFO.sram_mhz=value;});
