#include <soc.h>
#include <cg/cg.h>
#include <uart/uart.h>
#include <plr_sections.h>

#undef _soc

extern void writeback_invalidate_dcache_all(void);
extern void invalidate_icache_all(void);
extern init_table_entry_t start_of_init_func_table, end_of_init_func_table;
extern symbol_table_entry_t start_of_symble_table, end_of_symble_table;

soc_t _soc SECTION_SOC_STRU = {
    .bios={
        .header= {
            .signature=SIGNATURE_PLR,
            .version=PLR_VERSION,
            .export_symb_list=&start_of_symble_table,
            .end_of_export_symb_list=&end_of_symble_table,
            .init_func_list=&start_of_init_func_table,
            .end_of_init_func_list=&end_of_init_func_table,
        },
        .isr=VZERO,
        .size_of_plr_load_firstly=0,
        .uart_putc=VZERO,
        .uart_getc=VZERO,
        .uart_tstc=VZERO,
        .dcache_writeback_invalidate_all= &writeback_invalidate_dcache_all,
        .icache_invalidate_all=&invalidate_icache_all,
    },
    .cid = 0, //This filed will be updated to the SCT
    .sid = 0, //This filed will be updated to "1" (IS_PRODUZIONE) if it is MP Chip
};



//*************************************
// CG: OCP, MEM, LX, UART Clock Setting 
//*************************************
#ifdef OTTO_PROJECT_FPGA
const u32_t lx_clk_dft SECTION_PARAMETERS = 30;

const cg_dev_freq_t cg_ddr2_proj_freq SECTION_PARAMETERS = {
    .cpu0_mhz = 40, 
    .cpu1_mhz = 40,
    .mem_mhz  = 40,
    .lx_mhz   = 30,
    .spif_mhz = 3
};
const cg_dev_freq_t cg_ddr3_proj_freq SECTION_PARAMETERS= {0};
#else
const cg_dev_freq_t cg_ddr2_proj_freq SECTION_PARAMETERS = {
    .cpu1_mhz = 500,
    .mem_mhz  = 525,
    .lx_mhz   = 200,
    .spif_mhz = 50,
    .sram_mhz = 500
};

const cg_dev_freq_t cg_ddr3_proj_freq SECTION_PARAMETERS = {
    .cpu1_mhz = 500,
    .mem_mhz  = 600,
    .lx_mhz   = 200,
    .spif_mhz = 50,
    .sram_mhz = 500
};
const u32_t lx_clk_dft SECTION_PARAMETERS = LX_PLL_DEFAULT;
#endif

const uart_parameter_t uart_info SECTION_PARAMETERS = {
        .uid = 0,
        .baud = 115200,//1500000,
};

symb_fdefine(SF_SYS_UDELAY, otto_lx_timer_udelay);
symb_fdefine(SF_SYS_MDELAY, otto_lx_timer_mdelay);
symb_fdefine(SF_SYS_GET_TIMER, otto_lx_timer_get_timer);
symb_fdefine(SF_PROTO_PRINTF, proto_printf);

