#include <util.h>
#include <onfi/onfi_ctrl.h>
#include <onfi/onfi_common.h>
#include <onfi/onfi_symb_func.h>
#include <lib/misc/timer.h>

#ifndef __SECTION_RUNTIME
    #define __SECTION_RUNTIME           SECTION_UNS_TEXT
#endif

__SECTION_RUNTIME 
void onaf_pio_read_data(onfi_info_t *info, void *ram_addr, u32_t wr_bytes, u32_t blk_page_idx, u32_t col_addr)
{
    u32_t flash_addr1=0, flash_addr2=0;
    int page_size = ONFI_PAGE_SIZE(info);
    int spare_size = ONFI_SPARE_SIZE(info);
    int real_page = blk_page_idx;
    int pio_length = wr_bytes;
    u32_t rlen, i;

    DIS_ONFI_CE0_CE1();
    WAIT_ONFI_CTRL_READY();
    union {
        u8_t u8[4];
        u32_t u32;
    } tmp;

	while(pio_length >0){
		if(pio_length > (page_size+spare_size)){
			rlen = (page_size+spare_size);
			pio_length -= (page_size+spare_size);
		}else{
			rlen = pio_length;
			pio_length -= rlen;
		}

        /* Command write cycle 1*/
        NACMRrv = (CECS0|CMD_PG_READ_C1);
        
        WAIT_ONFI_CTRL_READY();
        
        if(512 == page_size){
            flash_addr1 = ((real_page & 0xffffff) << 8);
        }else{
            flash_addr1 = ((real_page&0xff)<<16) | (col_addr&0xffff);
            flash_addr2 = (real_page >> 8) & 0xffffff;
        }
        
        switch(ONFI_BS_ADDR_CYCLE(RFLD_NACFR(nafc_ac))){
            case 3:
                NAADRrv = (AD2EN|AD1EN|AD0EN|flash_addr1);
                WAIT_ONFI_CTRL_READY();
                break;
            case 4:
                /* set address 1 */
                NAADRrv = (EN_NEXT_AD|AD2EN|AD1EN|AD0EN|flash_addr1);
                WAIT_ONFI_CTRL_READY();              
                NAADRrv = (AD0EN|flash_addr2);
                WAIT_ONFI_CTRL_READY();
                break;
            case 5:
                NAADRrv = (EN_NEXT_AD|AD2EN|AD1EN|AD0EN|flash_addr1);
                WAIT_ONFI_CTRL_READY();
                NAADRrv = (AD1EN|AD0EN|flash_addr2);
                WAIT_ONFI_CTRL_READY();
                break;
        }
        
        if(1 != ONFI_BS_CMD_CYCLE(RFLD_NACFR(nafc_rc))){ //512 page size not need 'end' command
            /* Command cycle 2*/
            NACMRrv = (CECS0|CMD_PG_READ_C2);
            WAIT_ONFI_CTRL_READY();
        }

        _udelay(25);
        for(i=0; i<(rlen/4); i++){
            tmp.u32= NADRrv;
            *((u8_t *)ram_addr++) = tmp.u8[0];
            *((u8_t *)ram_addr++) = tmp.u8[1];
            *((u8_t *)ram_addr++) = tmp.u8[2];
            *((u8_t *)ram_addr++) = tmp.u8[3];
            WAIT_ONFI_CTRL_READY();
        }
        real_page++;
    }
    DIS_ONFI_CE0_CE1();
    WAIT_ONFI_CTRL_READY();
}

__SECTION_RUNTIME  
s32_t onaf_pio_write_data(onfi_info_t *info, void *ram_addr, u32_t wr_bytes, u32_t blk_page_idx, u32_t col_addr)
{
    int i, rlen;
    u32_t flash_addr1=0, flash_addr2=0;
    int page_size= ONFI_PAGE_SIZE(info);
    int spare_size = ONFI_SPARE_SIZE(info);
    int real_page = blk_page_idx;
    int pio_length = wr_bytes;

    //Disable Write Protection
    RMOD_NACFR(wp_b, 1);

	while(pio_length >0){
		if(pio_length > (page_size+spare_size)){
			rlen = (page_size+spare_size);
			pio_length -= (page_size+spare_size);
		}else{
			rlen = pio_length;
			pio_length -= rlen;
		}

		/* Command write cycle 1*/
        NACMRrv = (CECS0|CMD_PG_WRITE_C1);
		WAIT_ONFI_CTRL_READY();
		
		if(512 == page_size){
			flash_addr1 = ((real_page & 0xffffff) << 8);
		}else{
            flash_addr1 = ((real_page&0xff)<<16) | (col_addr&0xffff);
			flash_addr2 = (real_page >> 8) & 0xffffff;
		}

		switch(ONFI_BS_ADDR_CYCLE(RFLD_NACFR(nafc_ac))){
			case 3:
                NAADRrv = (AD2EN|AD1EN|AD0EN|flash_addr1);
				WAIT_ONFI_CTRL_READY();
				break;
			case 4:
                NAADRrv = (EN_NEXT_AD|AD2EN|AD1EN|AD0EN|flash_addr1);
                WAIT_ONFI_CTRL_READY();				
                NAADRrv = (AD0EN|flash_addr2);
                WAIT_ONFI_CTRL_READY();
				break;
			case 5:
                NAADRrv = (EN_NEXT_AD|AD2EN|AD1EN|AD0EN|flash_addr1);
				WAIT_ONFI_CTRL_READY();
                NAADRrv = (AD1EN|AD0EN|flash_addr2);
                WAIT_ONFI_CTRL_READY();
				break;
		}


		for(i=0; i<(rlen/4); i++){
            NADRrv = *(u32_t *)(ram_addr+i*4);
            WAIT_ONFI_CTRL_READY();
		}

        if(1 != ONFI_BS_CMD_CYCLE(RFLD_NACFR(nafc_rc))){
            /* Command cycle 2*/
            NACMRrv = (CECS0|CMD_PG_WRITE_C2);
    		WAIT_ONFI_CTRL_READY();
        }
		real_page++;
	}
    info->_model_info->_wait_onfi_rdy();
    return _ofu_chk_program_erase_sts_ptr();
}

 
SECTION_RECYCLE void
onfi_func_reassign_for_test_chip(void)
{
    if(!_soc.sid){
        onfi_plr_model_info._pio_read = onaf_pio_read_data;
        onfi_plr_model_info._pio_write = onaf_pio_write_data;
    }
}

REG_INIT_FUNC(onfi_func_reassign_for_test_chip, 4);




