/*
 * arch.h for project/APro_onfi_demo
 */

#ifdef OTTO_PROJECT_FPGA
    #define KEEP_TIMEOUT_MONITOR
#endif

//For PLR-CLI's high memory test
#define USING_MEM_ZONE

//For enable UART IO
#define UART_IO_EN() RMOD_IO_MODE_EN(uart0_en, 1)

// UBOOT relative definition
#define MAX_UBOOT_SIZE         (0x20000)
#define ECC_DECODED_UBOOT_ADDR (0x80700000)
#define NEW_STACK_AT_DRAM      (ECC_DECODED_UBOOT_ADDR-32)
#define UBOOT_DECOMP_ADDR      (0x80000000)


// BTG, SNAF, ECC & Concurrent test Address
#define MT_DRAM_ADDR_V         (0xA0000000)
#define MT_DRAM_SIZE           (0x01000000)
#define BTG_LX0_ADDR_PHY       (0xA1000000)
#define BTG_LX1_ADDR_PHY       (0xA1800000)
#define BTG_LX2_ADDR_PHY       (0xA2000000)
#define BTG_LXDS_ADDR_PHY      (0xA3000000)
#define BTG_LXUS_ADDR_PHY      (0xA3800000)
#define BTG_SIZE_W             (0x00800000-1)
#define BTG_SIZE_R             (0x00800000-0x40)

// SNAF & ECC Test relative definition
#define SIZE_5KB              (3*1024)
#define ONAF_SRC_CHUNK_BUF    (0xA0000000)
#define ONAF_CHK_CHUNK_BUF    (ONAF_SRC_CHUNK_BUF + SIZE_5KB)
#define ONAF_ECC_TAG_BUF      (ONAF_CHK_CHUNK_BUF + SIZE_5KB)
#define src_page_buf ((void*)(ONAF_SRC_CHUNK_BUF))
#define chk_page_buf ((void*)(ONAF_CHK_CHUNK_BUF))
#define mt_ecc_buf    ((void*)(ONAF_ECC_TAG_BUF))


// BTG Base Address
//#define PROJECT_WITH_PBO_LX_BUS

#define BTG_LX0_BASE   (0)
#define BTG_LX1_BASE   (0xB800A000)
#define BTG_LX2_BASE   (0xB8018000)



