#if defined(CONFIG_UNDER_UBOOT)
#include <common.h>
#include <command.h>
#else
#include <soc.h>
#include <util.h>
typedef unsigned int uint32_t;
#endif

#define REG8(x) (*((volatile char *)(x)))
#define UART_DLL (UART_BASE_ADDR + 0x0)
#define UART_THR (UART_BASE_ADDR + 0x0)
#define UART_RBR (UART_BASE_ADDR + 0x0)
#define UART_DLH (UART_BASE_ADDR + 0x4)
#define UART_IER (UART_BASE_ADDR + 0x4)
#define UART_FCR (UART_BASE_ADDR + 0x8)
#define UART_LCR (UART_BASE_ADDR + 0xc)
#define UART_MCR (UART_BASE_ADDR + 0x10)
#define UART_LSR (UART_BASE_ADDR + 0x14)

static char cas_getc(void) {
	volatile uint32_t timeout = 0x1000;
	while (timeout--) {
		if ((REG8(UART_LSR) & 0x8F) == 0x01) {
			return REG8(UART_RBR);
		}
	}
	return 0;
}

static void cas_uart_init(short baud_divisor) {
#define LCR_BKSE 0x80                /* Bank select enable */
#define LCRVAL   LCR_8N1             /* 8 data, 1 stop, no parity */
#define MCRVAL   (MCR_DTR | MCR_RTS) /* RTS/DTR */
#define FCRVAL   0xC1                /* Clear & enable FIFOs */
#define LCR_8N1  0x03
#define MCR_DTR  0x01
#define MCR_RTS  0x02

	volatile uint32_t timeout = 0x100;
	while (timeout--);

	REG8(UART_IER) = 0x7;
	REG8(UART_LCR) = LCR_BKSE;
	REG8(UART_DLL) = (baud_divisor >> 0) & 0xff;
	REG8(UART_DLH) = (baud_divisor >> 8) & 0xff;
	REG8(UART_FCR) = FCRVAL;
	REG8(UART_LCR) = LCRVAL;
	REG8(UART_MCR) = MCRVAL | 0x40;

	return;
}

short console_auto_set(void) {
	int j, n, m;
	const short lx_freq[] = {
		250, 225, 204, 200, 175, 150, 125, 100,
		80, 75, 66, 63, 60, 50, 40, 36,
		35, 34, 33, 32, 30, 27, 25, 16,
		8
	};
	short bdiv;
	char ans[4];

	j = -1;
	n = 0;

 uart_init_start:
	j = (j+1) % sizeof(lx_freq);
	m = (n / sizeof(lx_freq)) % 2;
	n++;

	bdiv = lx_freq[j] * 1000 * 1000 / 115200 / 16 - m;
	cas_uart_init(bdiv);

	/* query terminal status */
	REG8(0xb8002000) = '\x1b';
	REG8(0xb8002000) = '[';
	REG8(0xb8002000) = '5';
	REG8(0xb8002000) = 'n';

	ans[0] = cas_getc();
	ans[1] = cas_getc();
	ans[2] = cas_getc();
	ans[3] = cas_getc();
	if ((ans[0] == '\x1b') &&
			(ans[1] == '[') &&
			(ans[2] == '0') &&
			(ans[3] == 'n')) {
		;
	} else {
		goto uart_init_start;
 	}

	printf("\rII: bdiv found: %x(-%d), lx_freq: %d, %d rounds\n", bdiv, m, lx_freq[j], n);
	return lx_freq[j];
}

#if defined(CONFIG_UNDER_UBOOT)
int do_caset(cmd_tbl_t *cmdtp, int flag, int argc, char * const argv[]) {
	return console_auto_set();
}

U_BOOT_CMD(caset, 1 , 1, do_caset,
           "caset - Console Auto-set Test.",
           "");
#endif
