#include <util.h>

#define EFUSE_ADDR 0xb8000644
#define EFUSE_ADDR1 0xb8000648

#define EFUSE_REG_OFFSET (16)
#define EFUSE_DATA_OFFSET (0)
/*     
  * Function             : EFUSE_ReadPhyMdio
  * Input                   : regaddr
  * Output                : return value
  * Description         : Read Giga_EthPHY parameters through MDIO 
  *
  */
unsigned short EFUSE_ReadPhyMdio(unsigned char regaddr)
{
        REG32(EFUSE_ADDR)     = (05<<24) |  ( (regaddr&0x1f)<<EFUSE_REG_OFFSET); 
        mdelay(1);
        REG32(EFUSE_ADDR)     = (04<<24);
        mdelay(1);
        return (REG32(EFUSE_ADDR1)&0x0ffff);
}


/*     
  * Function             : EFUSE_SetPhyMdioWrite
  * Input                   : regaddr, val
  * Description         : Write Giga_Eth PHY parameters through MDIO 
  *
  */
void EFUSE_SetPhyMdioWrite(unsigned char regaddr, unsigned short val)
{
        EFUSE_ReadPhyMdio(regaddr);
        REG32(EFUSE_ADDR)     = (07<<24) | ( (regaddr&0x1f)<<EFUSE_REG_OFFSET) | ((val&0xffff)<<EFUSE_DATA_OFFSET) ; 
        mdelay(1);
        REG32(EFUSE_ADDR1)   = (01<<24);
        mdelay(1);
}


