#include <util.h>
#include <misc/misc_setting.h>

#ifndef SECTION_MISC_SETTING
#define SECTION_MISC_SETTING
#endif

SECTION_MISC_SETTING series_mode_t series_tbl[] = {
    {.idx=0x4,  .st=ST_RTL9601C,  .cclk=112,  .dclk=400,  .size= SIZE_256Mb}, //idx_4
    {.idx=0x8,  .st=ST_RTL9602CP, .cclk=725,  .dclk=525,  .size= 0         }, //idx_8
    {.idx=0xC,  .st=ST_RTL9601C,  .cclk=112,  .dclk=400,  .size= SIZE_256Mb}, //idx_12
    {.idx=0x18, .st=ST_RTL9601D,  .cclk=300,  .dclk=325,  .size= SIZE_256Mb}, //idx_24
    {.idx=0x1C, .st=ST_RTL9601D,  .cclk=300,  .dclk=325,  .size= SIZE_512Mb}, //idx_28
    {.idx=0x1D, .st=ST_RTL9601D,  .cclk=300,  .dclk=325,  .size= SIZE_512Mb}, //idx_29
    {.idx=0x1E, .st=ST_RTL9601D,  .cclk=300,  .dclk=325,  .size= SIZE_512Mb}, //idx_30
    {.idx=0x1F, .st=ST_RTL9601D,  .cclk=300,  .dclk=325,  .size= SIZE_512Mb},
    {.idx=0x24, .st=ST_RTL9601C,  .cclk=112,  .dclk=400,  .size= SIZE_512Mb}, //idx_36
    {.idx=0x118,.st=ST_RTL9601D,  .cclk=300,  .dclk=325,  .size= SIZE_128Mb},
};

const char _str_9601C[] SECTION_RECYCLE_DATA = {"9601C"};
const char _str_9601D[] SECTION_RECYCLE_DATA = {"9601D"};
const char _str_9602C[] SECTION_RECYCLE_DATA = {"9602C"};
const char _str_9602CP[] SECTION_RECYCLE_DATA = {"9602CP"};

SECTION_RECYCLE char *acquire_banner(void)
{
    ACQ_SOC_CID_FROM_REG();
    u32_t i;
    for(i=0 ; i<sizeof(series_tbl)/sizeof(series_mode_t) ; i++){
        if(_soc_cid_sct == series_tbl[i].idx){
            _soc.cid = ((_soc.cid&0xFFFF0000)|(series_tbl[i].st));
            break;
        }
    }

    switch(_soc_cid_series){
        case ST_RTL9601C:
            return (char *)_str_9601C;
        case ST_RTL9601D:
            return (char *)_str_9601D;
        case ST_RTL9602CP:
            return (char *)_str_9602CP;
        default:
            return (char *)_str_9602C;
    }
}

u32_t xlat_freq(void)
{
    u32_t i;
    for(i=0 ; i<sizeof(series_tbl)/sizeof(series_mode_t) ; i++){
        if(_soc_cid_sct == series_tbl[i].idx){
            return (series_tbl[i].cclk<<16)|(series_tbl[i].dclk);
        }
    }
    return (CPU_CLK_DEFAULT<<16)|(MEM_PLL_MIN);
}

