#ifndef _MISC_SETTING_H_
#define _MISC_SETTING_H_

#define NA (0x4E41)
typedef enum {
    SIZE_128Mb = 0,
    SIZE_256Mb = 1,
    SIZE_512Mb = 2,
    SIZE_1Gb   = 3,
    SIZE_2Gb   = 4,
    SIZE_4Gb   = 5,
    SIZE_8Gb   = 6,
    SIZE_NA    = 0x4E41,
} memory_size_mapping_t;

typedef enum {
    ST_RTL9601C  = 0x1C,
    ST_RTL9601D  = 0x1D,
    ST_RTL9602C  = 0x2C,
    ST_RTL9602CP = 0x50,
} sub_chip_type_t;

typedef struct{
    u16_t idx;
    sub_chip_type_t st;;
    u16_t cclk;
    u16_t dclk;
    memory_size_mapping_t size;
}series_mode_t;

#ifndef CONFIG_UNDER_UBOOT
#include <register_map.h>

#define _soc_cid_sct    ((_soc.cid>>16)&0xFFFF)
#define _soc_cid_series (_soc.cid&0xFFFF)
#define ACQ_SOC_CID_FROM_REG() {\
    u32_t __val = RFLD_EFUSE_BOND_RSLT(ef_bond_rslt); \
    __val = ((__val&0x3E)>>1) | ((__val&0x7800)>>6);\
    _soc.cid = ((__val<<16)|(_soc.cid&0xFFFF)); \
}
#endif
extern char *acquire_banner(void);
extern u32_t xlat_freq(void);

#endif


