#include <util.h>

#define BSP_USB2_EXT_REG	0xB8140200
#define BSP_USB2_AUX_REG	(BSP_USB2_EXT_REG + 0xc)
#define BSP_EHCI_BASE			0xB8021000
#define BSP_EHCI_UTMI_CTRL		(BSP_EHCI_BASE + 0xA4)
#define LOOP_LIMIT 100000
#define UTMI_NOP   (1<<12)
#define UTMI_LOAD  (0<<12)
#define BUILD_CMD(vp,vctrl) (((vp)&0xf)<<13)|(((vctrl)&0xf)<<8)
#define UTMI_BUSY(x) (x&(1<<17))
#define le32_to_cpu(x)  ((((x)&0xff)<<24) | (((x)&0xff00)<<8) | (((x)&0xff0000)>>8) | (((x)&0xff000000) >> 24))
#define cpu_to_le32 le32_to_cpu
static SECTION_RECYCLE u32_t utmi_wait(void) {
	u32_t __reg, __c = 0;
	do { 
		__c++; 
		__reg = le32_to_cpu(REG32(BSP_EHCI_UTMI_CTRL));	
		if (__c>LOOP_LIMIT) { 
			//printk("utmi_wait timeout\n"); 
			return 0;
		}
	} while (UTMI_BUSY(__reg));
	return __reg;
}

static SECTION_RECYCLE void utmi_set(u32_t v) {
	utmi_wait();
	REG32(BSP_EHCI_UTMI_CTRL) = cpu_to_le32(v);	
}

#if 0
static SECTION_RECYCLE u32_t utmi_get(void) {	
	u32_t reg;
	reg = utmi_wait();
	return reg;
}
#endif

static SECTION_RECYCLE int __ehci_phy_write(u8_t vport, u8_t reg, u16_t val) {		
	REG32(BSP_USB2_AUX_REG) = (val)&0xff;
	// send [3:0]
	#if 1
	utmi_set(BUILD_CMD(vport,reg&0xf)|UTMI_NOP);
	utmi_set(BUILD_CMD(vport,reg&0xf)|UTMI_LOAD);
	utmi_set(BUILD_CMD(vport,reg&0xf)|UTMI_NOP);	
	// send [7:4]
	utmi_set(BUILD_CMD(vport,reg>>4)|UTMI_NOP);
	utmi_set(BUILD_CMD(vport,reg>>4)|UTMI_LOAD);
	utmi_set(BUILD_CMD(vport,reg>>4)|UTMI_NOP);	
	#endif 
	return 0;
	
}

#if 0
static SECTION_RECYCLE int __ehci_phy_get(u8_t vport, u8_t reg, u8_t *data) {
		
	reg -= 0x20;
	// send [3:0]
	utmi_set(BUILD_CMD(vport,reg&0xf)|UTMI_NOP);
	utmi_set(BUILD_CMD(vport,reg&0xf)|UTMI_LOAD);
	utmi_set(BUILD_CMD(vport,reg&0xf)|UTMI_NOP);
	
	// send [7:4]
	utmi_set(BUILD_CMD(vport,reg>>4)|UTMI_NOP);
	utmi_set(BUILD_CMD(vport,reg>>4)|UTMI_LOAD);
	utmi_set(BUILD_CMD(vport,reg>>4)|UTMI_NOP);
	
	*data = utmi_get() & 0xff;
	
	return 0;
}
#endif

SECTION_RECYCLE void
chip_pre_init(void)
/*  For RTL9602/RTL9602CP only
  *  Change USB PHY REG_SRC[2] to 1 to prevent IC overvaltage.
  */
{
    __ehci_phy_write(1, 0xf4, 0xbb);    
    __ehci_phy_write(1, 0xe5, 0xfa);
    __ehci_phy_write(1, 0xf4, 0x9b);
}

REG_INIT_FUNC(chip_pre_init, 0);

